# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetInvitationResult',
    'AwaitableGetInvitationResult',
    'get_invitation',
    'get_invitation_output',
]

@pulumi.output_type
class GetInvitationResult:
    """
    A collection of values returned by getInvitation.
    """
    def __init__(__self__, accepted_at=None, auth_type=None, creators=None, email=None, expires_at=None, id=None, status=None, users=None):
        if accepted_at and not isinstance(accepted_at, str):
            raise TypeError("Expected argument 'accepted_at' to be a str")
        pulumi.set(__self__, "accepted_at", accepted_at)
        if auth_type and not isinstance(auth_type, str):
            raise TypeError("Expected argument 'auth_type' to be a str")
        pulumi.set(__self__, "auth_type", auth_type)
        if creators and not isinstance(creators, list):
            raise TypeError("Expected argument 'creators' to be a list")
        pulumi.set(__self__, "creators", creators)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="acceptedAt")
    def accepted_at(self) -> _builtins.str:
        """
        (Optional String) The timestamp that the invitation was accepted.
        """
        return pulumi.get(self, "accepted_at")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        (Optional String) Accepted values are: `AUTH_TYPE_LOCAL` and `AUTH_TYPE_SSO`. The user/invitee's authentication type. Note that only the [`OrganizationAdmin role`](https://docs.confluent.io/cloud/current/access-management/access-control/cloud-rbac.html#organizationadmin) can invite `AUTH_TYPE_LOCAL` users to SSO organizations. The user's auth_type is set as `AUTH_TYPE_SSO` by default if the organization has SSO enabled. Otherwise, the user's auth_type is `AUTH_TYPE_LOCAL` by default.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def creators(self) -> Sequence['outputs.GetInvitationCreatorResult']:
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "creators")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        (Required String) The user/invitee's email address.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> _builtins.str:
        """
        (Optional String) The timestamp that the invitation will expire.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Required String) The id of invitation creator.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        (Optional String) The status of invitations. Accepted values are: `INVITE_STATUS_SENT`,`INVITE_STATUS_STAGED`,`INVITE_STATUS_ACCEPTED`,`INVITE_STATUS_EXPIRED`, and `INVITE_STATUS_DEACTIVATED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetInvitationUserResult']:
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "users")


class AwaitableGetInvitationResult(GetInvitationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInvitationResult(
            accepted_at=self.accepted_at,
            auth_type=self.auth_type,
            creators=self.creators,
            email=self.email,
            expires_at=self.expires_at,
            id=self.id,
            status=self.status,
            users=self.users)


def get_invitation(id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInvitationResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `Invitation` describes an Invitation data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_invitation(id="i-gxxn1")
    pulumi.export("invitation", main)
    ```


    :param _builtins.str id: The ID of the Invitation, for example, `i-zyw30`.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getInvitation:getInvitation', __args__, opts=opts, typ=GetInvitationResult).value

    return AwaitableGetInvitationResult(
        accepted_at=pulumi.get(__ret__, 'accepted_at'),
        auth_type=pulumi.get(__ret__, 'auth_type'),
        creators=pulumi.get(__ret__, 'creators'),
        email=pulumi.get(__ret__, 'email'),
        expires_at=pulumi.get(__ret__, 'expires_at'),
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'),
        users=pulumi.get(__ret__, 'users'))
def get_invitation_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInvitationResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `Invitation` describes an Invitation data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_invitation(id="i-gxxn1")
    pulumi.export("invitation", main)
    ```


    :param _builtins.str id: The ID of the Invitation, for example, `i-zyw30`.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getInvitation:getInvitation', __args__, opts=opts, typ=GetInvitationResult)
    return __ret__.apply(lambda __response__: GetInvitationResult(
        accepted_at=pulumi.get(__response__, 'accepted_at'),
        auth_type=pulumi.get(__response__, 'auth_type'),
        creators=pulumi.get(__response__, 'creators'),
        email=pulumi.get(__response__, 'email'),
        expires_at=pulumi.get(__response__, 'expires_at'),
        id=pulumi.get(__response__, 'id'),
        status=pulumi.get(__response__, 'status'),
        users=pulumi.get(__response__, 'users')))
