# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetKafkaClientQuotaResult',
    'AwaitableGetKafkaClientQuotaResult',
    'get_kafka_client_quota',
    'get_kafka_client_quota_output',
]

@pulumi.output_type
class GetKafkaClientQuotaResult:
    """
    A collection of values returned by getKafkaClientQuota.
    """
    def __init__(__self__, description=None, display_name=None, environments=None, id=None, kafka_clusters=None, principals=None, throughputs=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_clusters and not isinstance(kafka_clusters, list):
            raise TypeError("Expected argument 'kafka_clusters' to be a list")
        pulumi.set(__self__, "kafka_clusters", kafka_clusters)
        if principals and not isinstance(principals, list):
            raise TypeError("Expected argument 'principals' to be a list")
        pulumi.set(__self__, "principals", principals)
        if throughputs and not isinstance(throughputs, list):
            raise TypeError("Expected argument 'throughputs' to be a list")
        pulumi.set(__self__, "throughputs", throughputs)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Required String) The description of the Kafka Client Quota.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        (Required String) The name of the Kafka Client Quota.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetKafkaClientQuotaEnvironmentResult']:
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "environments")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Required String) The ID of the Environment that the corresponding Kafka Cluster belongs to, for example, `env-abc123`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kafkaClusters")
    def kafka_clusters(self) -> Sequence['outputs.GetKafkaClientQuotaKafkaClusterResult']:
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "kafka_clusters")

    @_builtins.property
    @pulumi.getter
    def principals(self) -> Sequence[_builtins.str]:
        """
        (Required Set of Strings) The list of principals (i.e., service accounts or identity pools) to apply the Kafka Client Quota to. Use the special name, `"<default>"`, to represent the default quota for all users and service accounts.
        """
        return pulumi.get(self, "principals")

    @_builtins.property
    @pulumi.getter
    def throughputs(self) -> Sequence['outputs.GetKafkaClientQuotaThroughputResult']:
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "throughputs")


class AwaitableGetKafkaClientQuotaResult(GetKafkaClientQuotaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaClientQuotaResult(
            description=self.description,
            display_name=self.display_name,
            environments=self.environments,
            id=self.id,
            kafka_clusters=self.kafka_clusters,
            principals=self.principals,
            throughputs=self.throughputs)


def get_kafka_client_quota(id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaClientQuotaResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `KafkaClientQuota` describes a Kafka Client Quota.

    > **Note:** See [Control application usage with Client Quotas](https://docs.confluent.io/cloud/current/clusters/client-quotas.html#control-application-usage-with-client-quotas) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_kafka_client_quota(id="cq-abc123")
    pulumi.export("example", example)
    ```


    :param _builtins.str id: The ID of the Kafka Client Quota (for example, `cq-abc123`).
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getKafkaClientQuota:getKafkaClientQuota', __args__, opts=opts, typ=GetKafkaClientQuotaResult).value

    return AwaitableGetKafkaClientQuotaResult(
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environments=pulumi.get(__ret__, 'environments'),
        id=pulumi.get(__ret__, 'id'),
        kafka_clusters=pulumi.get(__ret__, 'kafka_clusters'),
        principals=pulumi.get(__ret__, 'principals'),
        throughputs=pulumi.get(__ret__, 'throughputs'))
def get_kafka_client_quota_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaClientQuotaResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `KafkaClientQuota` describes a Kafka Client Quota.

    > **Note:** See [Control application usage with Client Quotas](https://docs.confluent.io/cloud/current/clusters/client-quotas.html#control-application-usage-with-client-quotas) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_kafka_client_quota(id="cq-abc123")
    pulumi.export("example", example)
    ```


    :param _builtins.str id: The ID of the Kafka Client Quota (for example, `cq-abc123`).
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getKafkaClientQuota:getKafkaClientQuota', __args__, opts=opts, typ=GetKafkaClientQuotaResult)
    return __ret__.apply(lambda __response__: GetKafkaClientQuotaResult(
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        environments=pulumi.get(__response__, 'environments'),
        id=pulumi.get(__response__, 'id'),
        kafka_clusters=pulumi.get(__response__, 'kafka_clusters'),
        principals=pulumi.get(__response__, 'principals'),
        throughputs=pulumi.get(__response__, 'throughputs')))
