/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_order4.h"

GtinvDataOrder4::GtinvDataOrder4(){

    set_gtinv_info();
}

GtinvDataOrder4::~GtinvDataOrder4(){}

const vector2i& GtinvDataOrder4::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataOrder4::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataOrder4::get_coeffs() const{ return coeffs_all; }

void GtinvDataOrder4::set_gtinv_info(){

    l_array_all =
        {{0, 0, 0, 0},
        {0, 0, 1, 1},
        {0, 0, 2, 2},
        {0, 1, 1, 2},
        {0, 2, 2, 2},
        {1, 1, 1, 1},
        {1, 1, 1, 1},
        {1, 1, 2, 2},
        {1, 1, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {0, 0, 3, 3},
        {0, 0, 4, 4},
        {0, 1, 2, 3},
        {0, 1, 3, 4},
        {0, 2, 2, 4},
        {0, 2, 3, 3},
        {0, 2, 4, 4},
        {0, 3, 3, 4},
        {0, 4, 4, 4},
        {1, 1, 1, 3},
        {1, 1, 2, 4},
        {1, 1, 3, 3},
        {1, 1, 3, 3},
        {1, 1, 4, 4},
        {1, 1, 4, 4},
        {1, 2, 2, 3},
        {1, 2, 2, 3},
        {1, 2, 3, 4},
        {1, 2, 3, 4},
        {1, 3, 3, 3},
        {1, 3, 3, 3},
        {1, 3, 4, 4},
        {1, 3, 4, 4},
        {2, 2, 2, 4},
        {2, 2, 2, 4},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4}};

    coeffs_all =
        {{1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {-0.447213595499958,
         0.447213595499958,
         -0.447213595499958,
         0.447213595499958,
         -0.447213595499958},
        {0.447213595499958,
         -0.316227766016838,
         0.182574185835055,
         -0.316227766016838,
         0.365148371670111,
         -0.316227766016838,
         0.182574185835055,
         -0.316227766016838,
         0.447213595499958},
        {0.239045721866879,
         -0.29277002188456,
         0.239045721866879,
         -0.29277002188456,
         0.119522860933439,
         0.119522860933439,
         -0.29277002188456,
         0.239045721866879,
         0.119522860933439,
         -0.239045721866879,
         0.119522860933439,
         0.239045721866879,
         -0.29277002188456,
         0.119522860933439,
         0.119522860933439,
         -0.29277002188456,
         0.239045721866879,
         -0.29277002188456,
         0.239045721866879},
        {-0.330554641960247,
         0.140294070099267,
         0.190260571860981,
         -0.252764426053122,
         0.112470355953854,
         -0.302730927814835,
         0.190260571860979,
         0.140294070099266,
         0.112470355953855,
         -0.4430249979141,
         0.112470355953855,
         0.140294070099266,
         0.190260571860979,
         -0.302730927814835,
         0.112470355953856,
         -0.252764426053122,
         0.190260571860979,
         0.140294070099266,
         -0.330554641960247},
        {0.229574054183946,
         -0.32102255280716,
         0.0914484986232151,
         0.0860043829612314,
         0.235018169845929,
         -0.326466668469144,
         0.0914484986232149,
         -0.32102255280716,
         0.235018169845929,
         -0.00544411566198335,
         0.235018169845929,
         -0.321022552807161,
         0.0914484986232151,
         -0.326466668469144,
         0.235018169845929,
         0.0860043829612313,
         0.0914484986232149,
         -0.32102255280716,
         0.229574054183945},
        {0.139550865339032,
         -0.170914206622238,
         0.139550865339032,
         -0.195563787977642,
         0.140838383153849,
         -0.0421610199521685,
         -0.0461454010297642,
         0.343688452212849,
         -0.20540397157933,
         0.124090893153224,
         -0.0997492169345304,
         0.132378942923249,
         -0.0461454010297643,
         -0.0421610199521685,
         0.140838383153849,
         -0.195563787977642,
         -0.0671194909458113,
         0.238033697568049,
         -0.295005099775462,
         0.238033697568049,
         -0.0671194909458113,
         -0.195563787977642,
         0.140838383153849,
         -0.0421610199521685,
         -0.0461454010297643,
         0.132378942923249,
         -0.0997492169345304,
         0.124090893153224,
         -0.20540397157933,
         0.343688452212849,
         -0.0461454010297643,
         -0.0421610199521685,
         0.140838383153849,
         -0.195563787977642,
         0.139550865339032,
         -0.170914206622238,
         0.139550865339032},
        {0.0418771008407753,
         -0.0512887644834881,
         0.0418771008407753,
         -0.178651996724072,
         0.189191534770729,
         -0.159579952789784,
         0.106118730394164,
         0.0633031632216659,
         0.0630228751344417,
         -0.172252658662721,
         0.26438618736317,
         -0.33942346123579,
         0.106118730394163,
         -0.159579952789784,
         0.189191534770729,
         -0.178651996724072,
         0.18934891349055,
         -0.138060149007062,
         0.120963894179232,
         -0.138060149007062,
         0.18934891349055,
         -0.178651996724072,
         0.189191534770729,
         -0.159579952789784,
         0.106118730394163,
         -0.33942346123579,
         0.26438618736317,
         -0.172252658662721,
         0.0630228751344417,
         0.0633031632216663,
         0.106118730394163,
         -0.159579952789784,
         0.189191534770729,
         -0.178651996724072,
         0.0418771008407754,
         -0.0512887644834879,
         0.0418771008407751},
        {0.0314224920209405,
         -0.153438999343136,
         0.122016507322196,
         0.147843754324332,
         0.00685274764096061,
         -0.127611752341,
         -0.0437451845398178,
         -0.127494189462783,
         0.120641441821822,
         0.0291084275752915,
         0.0483431784978582,
         -0.00459799395804068,
         0.108696563742554,
         -0.207199888508264,
         0.178091460932972,
         0.122016507322196,
         -0.153438999343136,
         0.00685274764096045,
         0.0230296244927333,
         0.00685274764096054,
         -0.127494189462783,
         -8.8767175767699e-05,
         -0.0285361023357705,
         0.120641441821822,
         -0.00459799395804075,
         0.204491033174629,
         -0.100303696214347,
         0.0303364737844088,
         -0.207199888508263,
         -0.0437451845398175,
         -0.127494189462783,
         0.120641441821822,
         0.0291084275752916,
         -0.127611752341,
         0.00685274764096049,
         0.147843754324331,
         0.120641441821822,
         -0.0285361023357703,
         -8.87671757679324e-05,
         -0.127494189462783,
         0.108696563742554,
         -0.100303696214347,
         0.128928565725885,
         -0.100303696214347,
         0.108696563742554,
         -0.127494189462783,
         -8.87671757678279e-05,
         -0.0285361023357702,
         0.120641441821822,
         0.147843754324331,
         0.00685274764096057,
         -0.127611752341,
         0.0291084275752915,
         0.120641441821822,
         -0.127494189462783,
         -0.0437451845398174,
         -0.207199888508263,
         0.0303364737844085,
         -0.100303696214347,
         0.204491033174628,
         -0.00459799395804067,
         0.120641441821822,
         -0.0285361023357705,
         -8.87671757676123e-05,
         -0.127494189462783,
         0.00685274764096064,
         0.0230296244927332,
         0.00685274764096047,
         -0.153438999343136,
         0.122016507322196,
         0.178091460932972,
         -0.207199888508263,
         0.108696563742554,
         -0.00459799395804062,
         0.0483431784978581,
         0.0291084275752914,
         0.120641441821822,
         -0.127494189462783,
         -0.0437451845398174,
         -0.127611752341,
         0.00685274764096041,
         0.147843754324331,
         0.122016507322196,
         -0.153438999343136,
         0.0314224920209404},
        {0.279560907994314,
         -0.0988080568027534,
         -0.180752851191561,
         0.0299181452211407,
         0.0843725659002002,
         0.111862939609948,
         0.0404865442198233,
         -0.0862277823147385,
         0.00185521641453844,
         -0.1133777174693,
         -0.136221291039088,
         0.0957347468192648,
         -0.0253300573783005,
         0.023815279518949,
         0.089562437950351,
         -0.180752851191561,
         -0.0988080568027535,
         0.0843725659002,
         0.176226040621896,
         0.0843725659002002,
         -0.0862277823147382,
         -0.0276459784321134,
         -0.217469973771395,
         0.0018552164145382,
         0.0957347468192645,
         -0.0306142568776422,
         0.128664924750719,
         0.0872902711613236,
         0.0238152795189494,
         0.0404865442198233,
         -0.0862277823147384,
         0.00185521641453819,
         -0.1133777174693,
         0.111862939609949,
         0.0843725659002001,
         0.0299181452211408,
         0.00185521641453829,
         -0.217469973771395,
         -0.0276459784321133,
         -0.0862277823147383,
         -0.0253300573783006,
         0.12866492475072,
         0.116451027452789,
         0.12866492475072,
         -0.0253300573783007,
         -0.0862277823147384,
         -0.0276459784321131,
         -0.217469973771395,
         0.00185521641453839,
         0.0299181452211407,
         0.0843725659002001,
         0.111862939609949,
         -0.1133777174693,
         0.00185521641453813,
         -0.0862277823147384,
         0.0404865442198234,
         0.0238152795189492,
         0.0872902711613236,
         0.12866492475072,
         -0.0306142568776418,
         0.0957347468192648,
         0.00185521641453843,
         -0.217469973771395,
         -0.0276459784321132,
         -0.0862277823147384,
         0.0843725659002002,
         0.176226040621896,
         0.0843725659002,
         -0.0988080568027534,
         -0.180752851191561,
         0.0895624379503511,
         0.0238152795189492,
         -0.0253300573783008,
         0.0957347468192651,
         -0.136221291039088,
         -0.1133777174693,
         0.0018552164145385,
         -0.0862277823147388,
         0.0404865442198233,
         0.111862939609949,
         0.0843725659002002,
         0.029918145221141,
         -0.180752851191561,
         -0.0988080568027535,
         0.279560907994315},
        {-0.0323047669213212,
         0.0826418876615202,
         -0.0503371207401988,
         -0.179049122373357,
         0.118074266278367,
         -0.0460701139716375,
         0.235042168013193,
         -0.0685771954809846,
         -0.0494970707973819,
         0.0864843030436375,
         -0.126637778133198,
         -0.108404389879995,
         0.164397435519831,
         -0.123983246447831,
         0.0374989434041937,
         -0.0503371207401989,
         0.0826418876615203,
         0.118074266278367,
         -0.176915618989076,
         0.118074266278367,
         -0.0685771954809852,
         0.118427838765357,
         -0.0379194544881171,
         -0.049497070797382,
         -0.108404389879995,
         -0.0426482096734433,
         -0.0197865834520766,
         0.0981202270121937,
         -0.123983246447831,
         0.235042168013193,
         -0.0685771954809848,
         -0.0494970707973821,
         0.0864843030436376,
         -0.0460701139716377,
         0.118074266278367,
         -0.179049122373357,
         -0.049497070797382,
         -0.0379194544881169,
         0.118427838765357,
         -0.0685771954809851,
         0.164397435519831,
         -0.0197865834520767,
         -0.0607218008251629,
         -0.0197865834520766,
         0.164397435519831,
         -0.0685771954809849,
         0.118427838765357,
         -0.0379194544881169,
         -0.0494970707973819,
         -0.179049122373357,
         0.118074266278367,
         -0.0460701139716377,
         0.0864843030436377,
         -0.0494970707973822,
         -0.0685771954809848,
         0.235042168013193,
         -0.123983246447831,
         0.0981202270121934,
         -0.0197865834520765,
         -0.0426482096734434,
         -0.108404389879994,
         -0.049497070797382,
         -0.0379194544881172,
         0.118427838765356,
         -0.0685771954809848,
         0.118074266278367,
         -0.176915618989076,
         0.118074266278367,
         0.0826418876615201,
         -0.0503371207401988,
         0.0374989434041934,
         -0.123983246447831,
         0.164397435519831,
         -0.108404389879995,
         -0.126637778133199,
         0.0864843030436374,
         -0.0494970707973819,
         -0.0685771954809848,
         0.235042168013193,
         -0.0460701139716378,
         0.118074266278366,
         -0.179049122373357,
         -0.0503371207401987,
         0.08264188766152,
         -0.0323047669213212},
        {0.16449148857074,
         -0.0736354021527284,
         -0.0908560864180115,
         0.0128994469443231,
         0.0743860496505641,
         0.030120131209606,
         -0.0673333253841183,
         0.0666676134490924,
         -0.141053663099657,
         0.0850497024385948,
         0.248885408599695,
         -0.181552083215576,
         0.127118204775781,
         -0.0119483711275803,
         -0.0731013313110144,
         -0.0908560864180118,
         -0.0736354021527287,
         0.0743860496505641,
         0.0733875557581317,
         0.0743860496505642,
         0.0666676134490924,
         -0.185654197416624,
         0.0515306864500869,
         -0.141053663099656,
         -0.181552083215577,
         0.167234590940002,
         -0.036014271963173,
         0.0996534191612868,
         -0.0119483711275804,
         -0.0673333253841182,
         0.0666676134490926,
         -0.141053663099657,
         0.0850497024385948,
         0.030120131209606,
         0.0743860496505643,
         0.0128994469443231,
         -0.141053663099657,
         0.0515306864500868,
         -0.185654197416624,
         0.0666676134490926,
         0.127118204775781,
         -0.0360142719631727,
         0.17013778292971,
         -0.0360142719631728,
         0.127118204775781,
         0.0666676134490923,
         -0.185654197416624,
         0.0515306864500866,
         -0.141053663099656,
         0.0128994469443228,
         0.0743860496505643,
         0.0301201312096061,
         0.0850497024385949,
         -0.141053663099657,
         0.0666676134490926,
         -0.0673333253841182,
         -0.0119483711275803,
         0.0996534191612869,
         -0.0360142719631729,
         0.167234590940002,
         -0.181552083215577,
         -0.141053663099657,
         0.0515306864500871,
         -0.185654197416624,
         0.0666676134490924,
         0.0743860496505641,
         0.0733875557581316,
         0.0743860496505644,
         -0.0736354021527287,
         -0.0908560864180117,
         -0.0731013313110146,
         -0.0119483711275802,
         0.127118204775781,
         -0.181552083215576,
         0.248885408599695,
         0.0850497024385948,
         -0.141053663099657,
         0.0666676134490923,
         -0.0673333253841182,
         0.0301201312096061,
         0.0743860496505639,
         0.0128994469443229,
         -0.0908560864180119,
         -0.0736354021527286,
         0.16449148857074},
        {-0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009227},
        {0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333},
        {-0.377964473009227,
         0.308606699924184,
         -0.239045721866879,
         0.169030850945703,
         -0.0975900072948533,
         0.218217890235992,
         -0.276026223736942,
         0.29277002188456,
         -0.276026223736942,
         0.218217890235992,
         -0.0975900072948533,
         0.169030850945703,
         -0.239045721866879,
         0.308606699924184,
         -0.377964473009227},
        {0.333333333333333,
         -0.288675134594813,
         0.243975018237133,
         -0.199204768222399,
         0.154303349962091,
         -0.109108945117996,
         0.0629940788348712,
         -0.166666666666667,
         0.218217890235993,
         -0.243975018237133,
         0.251976315339485,
         -0.243975018237133,
         0.218217890235993,
         -0.166666666666667,
         0.0629940788348712,
         -0.109108945117996,
         0.154303349962092,
         -0.199204768222399,
         0.243975018237133,
         -0.288675134594813,
         0.333333333333333},
        {-0.333333333333334,
         0.235702260395516,
         -0.154303349962092,
         0.0890870806374748,
         -0.0398409536444798,
         0.235702260395516,
         -0.251976315339485,
         0.218217890235992,
         -0.159363814577919,
         0.0890870806374748,
         -0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092,
         0.0890870806374748,
         -0.159363814577919,
         0.218217890235992,
         -0.251976315339485,
         0.235702260395516,
         -0.0398409536444798,
         0.0890870806374748,
         -0.154303349962092,
         0.235702260395516,
         -0.333333333333334},
        {-0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092,
         0.243975018237133,
         -0.188982236504614,
         0.0690065559342354,
         0.0690065559342357,
         -0.188982236504614,
         0.243975018237133,
         -0.243975018237133,
         0.14638501094228,
         -0.195180014589706,
         0.14638501094228,
         -0.243975018237133,
         0.243975018237133,
         -0.188982236504614,
         0.0690065559342354,
         0.0690065559342354,
         -0.188982236504614,
         0.243975018237133,
         -0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092},
        {0.110096376512636,
         -0.165144564768954,
         0.197385508487931,
         -0.20806259464412,
         0.197385508487931,
         -0.165144564768954,
         0.110096376512636,
         -0.205971460217775,
         0.194624736040381,
         -0.132410224425712,
         0.0465242105199236,
         0.0465242105199236,
         -0.132410224425713,
         0.194624736040381,
         -0.205971460217775,
         0.237835356004225,
         -0.0594588390010564,
         -0.0679529588583502,
         0.144400037573994,
         -0.169882397145875,
         0.144400037573993,
         -0.0679529588583502,
         -0.0594588390010564,
         0.237835356004225,
         -0.205971460217775,
         0.194624736040381,
         -0.132410224425712,
         0.0465242105199236,
         0.0465242105199236,
         -0.132410224425712,
         0.194624736040381,
         -0.205971460217775,
         0.110096376512636,
         -0.165144564768954,
         0.197385508487931,
         -0.20806259464412,
         0.197385508487931,
         -0.165144564768954,
         0.110096376512636},
        {0.174077655955698,
         -0.21320071635561,
         0.197385508487931,
         -0.147122471584125,
         0.080582296402538,
         -0.224733287487747,
         0.100503781525921,
         0.0465242105199236,
         -0.151947435279517,
         0.188025358272589,
         -0.147122471584125,
         0.174077655955698,
         0.100503781525921,
         -0.169882397145875,
         0.10403129732206,
         0.0268607654675126,
         -0.151947435279517,
         0.197385508487931,
         -0.21320071635561,
         0.0465242105199236,
         0.10403129732206,
         -0.161164592805076,
         0.10403129732206,
         0.0465242105199236,
         -0.21320071635561,
         0.197385508487931,
         -0.151947435279517,
         0.0268607654675126,
         0.10403129732206,
         -0.169882397145875,
         0.100503781525921,
         0.174077655955698,
         -0.147122471584125,
         0.188025358272589,
         -0.151947435279517,
         0.0465242105199236,
         0.100503781525921,
         -0.224733287487747,
         0.080582296402538,
         -0.147122471584125,
         0.197385508487931,
         -0.21320071635561,
         0.174077655955698},
        {0.104297703129124,
         -0.164909148306052,
         0.186989398001692,
         -0.164909148306051,
         0.104297703129124,
         -0.164909148306051,
         0.156446554693686,
         -0.0623297993338971,
         -0.0623297993338969,
         0.156446554693686,
         -0.164909148306051,
         0.186989398001691,
         -0.0623297993338972,
         -0.0819481953157405,
         0.141350698548044,
         -0.0819481953157404,
         -0.0623297993338971,
         0.186989398001692,
         -0.164909148306051,
         -0.0623297993338969,
         0.141350698548044,
         -0.0670485234401512,
         -0.067048523440151,
         0.141350698548044,
         -0.062329799333897,
         -0.164909148306051,
         0.104297703129124,
         0.156446554693686,
         -0.0819481953157405,
         -0.067048523440151,
         0.134097046880302,
         -0.0670485234401512,
         -0.0819481953157405,
         0.156446554693686,
         0.104297703129124,
         -0.164909148306051,
         -0.0623297993338972,
         0.141350698548044,
         -0.0670485234401511,
         -0.0670485234401511,
         0.141350698548044,
         -0.0623297993338969,
         -0.164909148306051,
         0.186989398001691,
         -0.062329799333897,
         -0.0819481953157406,
         0.141350698548044,
         -0.0819481953157403,
         -0.0623297993338972,
         0.186989398001692,
         -0.164909148306051,
         0.156446554693686,
         -0.0623297993338972,
         -0.0623297993338971,
         0.156446554693686,
         -0.164909148306051,
         0.104297703129124,
         -0.164909148306051,
         0.186989398001692,
         -0.164909148306052,
         0.104297703129124},
        {-0.377964473009227,
         0.218217890235992,
         -0.0975900072948534,
         0.218217890235992,
         -0.195180014589707,
         0.119522860933439,
         -0.0975900072948533,
         0.119522860933439,
         -0.0975900072948533,
         0.218217890235992,
         -0.195180014589707,
         0.119522860933439,
         -0.195180014589706,
         0.239045721866879,
         -0.195180014589707,
         0.119522860933439,
         -0.195180014589707,
         0.218217890235992,
         -0.0975900072948534,
         0.119522860933439,
         -0.0975900072948533,
         0.119522860933439,
         -0.195180014589707,
         0.218217890235992,
         -0.0975900072948534,
         0.218217890235992,
         -0.377964473009227},
        {0.333333333333333,
         -0.235702260395516,
         0.154303349962092,
         -0.0890870806374748,
         0.0398409536444798,
         -0.166666666666667,
         0.17817416127495,
         -0.154303349962092,
         0.112687233963802,
         -0.0629940788348712,
         0.0629940788348712,
         -0.0890870806374748,
         0.0975900072948533,
         -0.0890870806374746,
         0.0629940788348712,
         -0.166666666666667,
         0.17817416127495,
         -0.154303349962092,
         0.112687233963802,
         -0.0629940788348712,
         0.125988157669742,
         -0.178174161274949,
         0.195180014589707,
         -0.178174161274949,
         0.125988157669742,
         -0.0629940788348712,
         0.112687233963802,
         -0.154303349962092,
         0.17817416127495,
         -0.166666666666667,
         0.0629940788348712,
         -0.0890870806374748,
         0.0975900072948533,
         -0.0890870806374748,
         0.0629940788348712,
         -0.0629940788348712,
         0.112687233963802,
         -0.154303349962092,
         0.17817416127495,
         -0.166666666666667,
         0.0398409536444798,
         -0.0890870806374748,
         0.154303349962092,
         -0.235702260395516,
         0.333333333333333},
        {0.00629761294187317,
         -0.0089061696329733,
         0.00975622001789405,
         -0.0089061696329733,
         0.00629761294187317,
         -0.106111607355935,
         0.133353567515703,
         -0.142098553960582,
         0.138115593816888,
         -0.122445781933975,
         0.0920297167219238,
         0.3218330294255,
         -0.260569464354407,
         0.200931935952964,
         -0.142920444221169,
         0.0865349891590232,
         -0.0317755707665266,
         -0.0213578109563213,
         0.0920297167219238,
         -0.122445781933975,
         0.138115593816888,
         -0.142098553960582,
         0.133353567515703,
         -0.106111607355935,
         -0.138042334212222,
         0.146172517560467,
         -0.151050627569414,
         0.152676664239063,
         -0.151050627569414,
         0.146172517560467,
         -0.138042334212222,
         -0.106111607355935,
         0.133353567515703,
         -0.142098553960582,
         0.138115593816888,
         -0.122445781933975,
         0.0920297167219238,
         -0.0213578109563213,
         -0.0317755707665265,
         0.0865349891590232,
         -0.142920444221169,
         0.200931935952964,
         -0.260569464354407,
         0.3218330294255,
         0.0920297167219239,
         -0.122445781933975,
         0.138115593816888,
         -0.142098553960582,
         0.133353567515703,
         -0.106111607355935,
         0.00629761294187297,
         -0.0089061696329733,
         0.00975622001789405,
         -0.00890616963297335,
         0.00629761294187315},
        {-0.131518899557005,
         0.185995811461902,
         -0.203748203078323,
         0.185995811461902,
         -0.131518899557005,
         0.190339347498884,
         -0.169794568934294,
         0.102820775502548,
         -0.0196409199107381,
         -0.0580028472539878,
         0.103745852236548,
         -0.0703012584195532,
         -0.0395912150963049,
         0.115525654765776,
         -0.15750206058886,
         0.165520432565556,
         -0.139580770695865,
         0.0796830749797875,
         0.103745852236548,
         -0.0580028472539878,
         -0.0196409199107381,
         0.102820775502548,
         -0.169794568934294,
         0.190339347498884,
         -0.259376162128021,
         0.0895859928960853,
         0.0122881086430765,
         -0.0462461424894635,
         0.0122881086430765,
         0.0895859928960853,
         -0.259376162128021,
         0.190339347498884,
         -0.169794568934294,
         0.102820775502548,
         -0.0196409199107381,
         -0.0580028472539878,
         0.103745852236548,
         0.0796830749797875,
         -0.139580770695865,
         0.165520432565556,
         -0.15750206058886,
         0.115525654765776,
         -0.039591215096305,
         -0.0703012584195531,
         0.103745852236547,
         -0.0580028472539878,
         -0.0196409199107381,
         0.102820775502548,
         -0.169794568934294,
         0.190339347498884,
         -0.131518899557005,
         0.185995811461902,
         -0.203748203078323,
         0.185995811461902,
         -0.131518899557005},
        {0.00461215195233148,
         -0.00691822792849727,
         0.00826886394603592,
         -0.00871614791050731,
         0.00826886394603601,
         -0.00691822792849718,
         0.00461215195233141,
         0.0588673996388299,
         -0.0801803258628643,
         0.0935307882045493,
         -0.101346395341074,
         0.104102683323086,
         -0.101375321324006,
         0.0917107057436931,
         -0.07107000671354,
         0.0254650717155998,
         -0.0548987715350147,
         0.0852040861454802,
         -0.116381015546997,
         0.148429559739564,
         -0.181349718723182,
         0.21514149249785,
         -0.249804881063569,
         0.28533988442034,
         -0.0710700067135399,
         0.0917107057436928,
         -0.101375321324005,
         0.104102683323086,
         -0.101346395341074,
         0.0935307882045493,
         -0.0801803258628645,
         0.0588673996388298,
         -0.143199870993259,
         0.149301174530614,
         -0.153659248485868,
         0.15627409285902,
         -0.157145707650071,
         0.15627409285902,
         -0.153659248485868,
         0.149301174530614,
         -0.143199870993259,
         0.0588673996388298,
         -0.0801803258628646,
         0.0935307882045492,
         -0.101346395341074,
         0.104102683323086,
         -0.101375321324006,
         0.0917107057436929,
         -0.0710700067135399,
         0.285339884420339,
         -0.249804881063569,
         0.21514149249785,
         -0.181349718723182,
         0.148429559739564,
         -0.116381015546997,
         0.0852040861454803,
         -0.0548987715350146,
         0.0254650717156,
         -0.07107000671354,
         0.0917107057436928,
         -0.101375321324005,
         0.104102683323086,
         -0.101346395341074,
         0.0935307882045491,
         -0.0801803258628643,
         0.05886739963883,
         0.00461215195233144,
         -0.00691822792849733,
         0.00826886394603591,
         -0.00871614791050725,
         0.00826886394603592,
         -0.0069182279284972,
         0.00461215195233134},
        {-0.0902367406649113,
         0.135355110997367,
         -0.161780301083685,
         0.170531410657417,
         -0.161780301083685,
         0.135355110997367,
         -0.0902367406649113,
         0.0741619485301488,
         -0.0529886659449172,
         0.00892407640077269,
         0.0445199645479619,
         -0.0984467315758572,
         0.144554193190903,
         -0.172603185717361,
         0.164582026390236,
         0.0839379983390505,
         -0.121018972604125,
         0.141046805803457,
         -0.144021497937048,
         0.129943049004898,
         -0.0988114590070049,
         0.0506267279433707,
         0.0146111441860054,
         -0.0969021573811231,
         0.164582026390236,
         -0.172603185717361,
         0.144554193190903,
         -0.0984467315758571,
         0.0445199645479619,
         0.00892407640077254,
         -0.0529886659449173,
         0.0741619485301487,
         -0.232261895399348,
         0.112889907939156,
         -0.0276242026104469,
         -0.0235352205867779,
         0.04058836165252,
         -0.0235352205867777,
         -0.0276242026104469,
         0.112889907939156,
         -0.232261895399348,
         0.0741619485301487,
         -0.0529886659449172,
         0.00892407640077262,
         0.0445199645479621,
         -0.0984467315758573,
         0.144554193190903,
         -0.172603185717361,
         0.164582026390236,
         -0.0969021573811231,
         0.0146111441860053,
         0.0506267279433706,
         -0.0988114590070047,
         0.129943049004898,
         -0.144021497937048,
         0.141046805803458,
         -0.121018972604124,
         0.0839379983390503,
         0.164582026390236,
         -0.172603185717361,
         0.144554193190903,
         -0.0984467315758571,
         0.044519964547962,
         0.00892407640077267,
         -0.0529886659449175,
         0.0741619485301488,
         -0.0902367406649111,
         0.135355110997367,
         -0.161780301083685,
         0.170531410657417,
         -0.161780301083685,
         0.135355110997367,
         -0.0902367406649111},
        {0.145701041627445,
         -0.145701041627445,
         0.0921494298003463,
         -0.108348503939194,
         -0.0106158983872236,
         0.100372469332096,
         -0.111152570289013,
         0.140794017205128,
         -0.00660932972387322,
         0.0133426043217803,
         -0.0804086997037832,
         0.125020720616843,
         -0.140794017205128,
         0.0941655198486589,
         -0.0760197236335629,
         0.110611598912157,
         -0.166797551415061,
         0.089045955058628,
         -0.10577719435635,
         0.118685779327821,
         -0.161890526992744,
         0.268372692211677,
         -0.0991336830807997,
         0.0150131474759861,
         0.0535303526645688,
         -0.0685256107039156,
         -0.0906344674673665,
         0.217500084007143,
         -0.173222414718888,
         0.0506040915660651,
         0.0557248406996792,
         0.00934700373369671,
         -0.171430622741334,
         0.238259404539961,
         -0.171430622741334,
         0.00934700373369696,
         0.0557248406996789,
         0.0506040915660651,
         -0.173222414718888,
         0.217500084007143,
         -0.0906344674673664,
         -0.0685256107039154,
         0.0535303526645686,
         0.015013147475986,
         -0.0991336830807999,
         0.268372692211677,
         -0.161890526992744,
         0.118685779327821,
         -0.10577719435635,
         0.0890459550586278,
         -0.166797551415061,
         0.110611598912157,
         -0.076019723633563,
         0.0941655198486589,
         -0.140794017205128,
         0.125020720616843,
         -0.0804086997037832,
         0.0133426043217801,
         -0.00660932972387323,
         0.140794017205128,
         -0.111152570289013,
         0.100372469332096,
         -0.0106158983872234,
         -0.108348503939193,
         0.0921494298003461,
         -0.145701041627445,
         0.145701041627445},
        {0.113561262045324,
         -0.113561262045324,
         0.0718224484052908,
         -0.222510158900342,
         0.129787776714498,
         -0.0287107311460163,
         -0.0248905615648688,
         0.171461582174879,
         0.0825123632940948,
         -0.164446981330156,
         0.136583128330383,
         -0.0612560210382478,
         -0.171461582174879,
         0.0445280243988999,
         0.0847955076389089,
         -0.156538334703715,
         0.146452245625916,
         0.108441826177749,
         -0.088317184408325,
         0.0134929708290343,
         0.0885519254963612,
         -0.191880102225093,
         0.117983008848512,
         -0.183547634059894,
         0.19296152629875,
         -0.140727780930213,
         0.0176967126096192,
         0.0176842714667482,
         0.0443446805003308,
         -0.131041706534831,
         0.167067715953013,
         -0.116690103233965,
         0.0232024728858455,
         0.0193721487907657,
         0.0232024728858451,
         -0.116690103233965,
         0.167067715953013,
         -0.131041706534831,
         0.0443446805003309,
         0.0176842714667482,
         0.0176967126096191,
         -0.140727780930214,
         0.19296152629875,
         -0.183547634059893,
         0.117983008848513,
         -0.191880102225093,
         0.0885519254963607,
         0.0134929708290341,
         -0.088317184408325,
         0.108441826177749,
         0.146452245625916,
         -0.156538334703714,
         0.0847955076389089,
         0.0445280243989001,
         -0.171461582174879,
         -0.061256021038248,
         0.136583128330383,
         -0.164446981330156,
         0.0825123632940949,
         0.171461582174879,
         -0.0248905615648689,
         -0.0287107311460164,
         0.129787776714498,
         -0.222510158900342,
         0.0718224484052913,
         -0.113561262045324,
         0.113561262045324},
        {0.00213215183529186,
         -0.0026113420253016,
         0.00241763293440539,
         -0.00180199719532426,
         0.000986994512439913,
         0.0876954631576592,
         -0.0995541674906814,
         0.0935650703044763,
         -0.077535243092759,
         0.0556315738166391,
         -0.030912065253534,
         -0.204573985520034,
         0.101219769522605,
         -0.0203728176926177,
         -0.0373854825371492,
         0.0714264718948124,
         -0.080976810521939,
         0.064599072548294,
         0.177166268413779,
         -0.182246441608904,
         0.147600729143969,
         -0.0938541610637202,
         0.0335772306946142,
         0.0217249932431757,
         -0.0565123665408225,
         -0.0946993538425133,
         0.140586493905574,
         -0.165418715962763,
         0.170105643236898,
         -0.154719134444523,
         0.119149037414282,
         -0.0632258156353152,
         -0.128787749798215,
         0.142923005691376,
         -0.131333996876542,
         0.106427881764468,
         -0.0746860353555293,
         0.0405951112251119,
         0.202439539045209,
         -0.128098823906318,
         0.0694956445037637,
         -0.0260198730336933,
         -0.00292229196855124,
         0.017874734564516,
         -0.0191526800148711,
         -0.0730307907835455,
         0.0934127636990735,
         -0.102958153029966,
         0.105825041436425,
         -0.102958153029966,
         0.0934127636990735,
         -0.0730307907835453,
         -0.0191526800148712,
         0.017874734564516,
         -0.00292229196855127,
         -0.0260198730336935,
         0.0694956445037637,
         -0.128098823906318,
         0.202439539045209,
         0.0405951112251121,
         -0.0746860353555297,
         0.106427881764468,
         -0.131333996876542,
         0.142923005691376,
         -0.128787749798215,
         -0.0632258156353154,
         0.119149037414282,
         -0.154719134444523,
         0.170105643236898,
         -0.165418715962762,
         0.140586493905574,
         -0.0946993538425133,
         -0.0565123665408227,
         0.0217249932431754,
         0.0335772306946141,
         -0.0938541610637202,
         0.147600729143969,
         -0.182246441608904,
         0.177166268413779,
         0.0645990725482938,
         -0.0809768105219391,
         0.0714264718948122,
         -0.0373854825371491,
         -0.0203728176926177,
         0.101219769522604,
         -0.204573985520034,
         -0.030912065253534,
         0.0556315738166392,
         -0.0775352430927587,
         0.0935650703044762,
         -0.0995541674906811,
         0.0876954631576591,
         0.000986994512440044,
         -0.00180199719532411,
         0.00241763293440538,
         -0.0026113420253016,
         0.00213215183529181},
        {-0.14199038197746,
         0.173901992113827,
         -0.161001959689469,
         0.120003775458778,
         -0.0657287748045574,
         0.19800030349185,
         -0.120968707127152,
         0.0190407357350443,
         0.060350356027819,
         -0.0963414658907828,
         0.0821631957996495,
         -0.117947311280878,
         -0.0693279249036595,
         0.137785398865415,
         -0.123494480977571,
         0.0626031622850277,
         0.00850127351603132,
         -0.052345155765343,
         0.102145367877311,
         -0.0214840595059508,
         -0.0635371646293621,
         0.11685638905376,
         -0.124805733895296,
         0.0881164891042747,
         -0.0234178346764504,
         -0.0545989957489833,
         0.0416504276692073,
         -0.0010366160024467,
         -0.0514568066030965,
         0.100848293835772,
         -0.132332609239357,
         0.131162311050786,
         0.0374854317005992,
         0.0290852042644969,
         -0.0926564415186193,
         0.129320987597372,
         -0.129392273106759,
         0.0916563303669101,
         -0.138655849807319,
         -0.00542686638066629,
         0.0347617172253728,
         0.00894893023891231,
         -0.08385037365836,
         0.147622998038268,
         -0.155825118083268,
         0.179053143956897,
         -0.0874615873456065,
         -0.000808134844430322,
         0.0347768314363475,
         -0.000808134844430577,
         -0.0874615873456065,
         0.179053143956897,
         -0.155825118083268,
         0.147622998038268,
         -0.0838503736583599,
         0.00894893023891193,
         0.0347617172253727,
         -0.00542686638066607,
         -0.138655849807319,
         0.0916563303669098,
         -0.129392273106759,
         0.129320987597372,
         -0.0926564415186192,
         0.029085204264497,
         0.0374854317005994,
         0.131162311050785,
         -0.132332609239357,
         0.100848293835772,
         -0.0514568066030963,
         -0.00103661600244668,
         0.0416504276692072,
         -0.0545989957489832,
         -0.0234178346764504,
         0.0881164891042749,
         -0.124805733895296,
         0.116856389053759,
         -0.0635371646293617,
         -0.0214840595059509,
         0.102145367877311,
         -0.0523451557653428,
         0.00850127351603135,
         0.0626031622850277,
         -0.123494480977571,
         0.137785398865415,
         -0.0693279249036592,
         -0.117947311280878,
         0.0821631957996497,
         -0.096341465890783,
         0.0603503560278191,
         0.0190407357350442,
         -0.120968707127152,
         0.198000303491849,
         -0.0657287748045574,
         0.120003775458778,
         -0.161001959689469,
         0.173901992113827,
         -0.14199038197746},
        {-0.124446632671581,
         0.160659911942875,
         -0.124446632671581,
         0.127264791889408,
         -0.0555329620310095,
         -0.0689136706405718,
         0.136726381684311,
         -0.118097938901699,
         0.00271756703434875,
         0.0525560164985192,
         0.0149324269357831,
         -0.135372359436795,
         0.117624265704226,
         0.0151634328223111,
         -0.0195876539444786,
         -0.0329683625540405,
         0.0151634328223109,
         0.136547445294031,
         -0.110812869792083,
         -0.0555329620310094,
         0.0389222536190216,
         -0.0193345996745429,
         0.0523029622285833,
         -0.0689136706405713,
         -0.124193578401645,
         0.143058799750063,
         -0.0552799077610741,
         0.0149324269357833,
         0.00271756703434872,
         -0.0552799077610737,
         0.160333220285159,
         -0.110812869792083,
         0.117445329313946,
         -0.117771247243983,
         0.126906919108849,
         -0.124193578401645,
         0.0844016646858089,
         -0.0475126820128577,
         -0.024336614859822,
         0.0680137104406626,
         -0.0476587829637249,
         -0.0904783293080254,
         0.160752304707313,
         -0.101403632138123,
         -0.0322080715283676,
         -0.0240444129580883,
         0.160752304707312,
         -0.0868323305346955,
         -0.0813696791196468,
         0.160752304707312,
         -0.0317697686757668,
         0.0677037835213752,
         -0.101610250084314,
         -0.0812663701465508,
         0.176095326918277,
         -0.081266370146551,
         -0.101610250084314,
         0.0677037835213753,
         -0.0317697686757666,
         0.160752304707312,
         -0.0813696791196467,
         -0.0868323305346957,
         0.160752304707312,
         -0.0240444129580883,
         -0.0322080715283674,
         -0.101403632138123,
         0.160752304707312,
         -0.0904783293080254,
         -0.0476587829637246,
         0.0680137104406627,
         -0.0243366148598222,
         -0.0475126820128576,
         0.084401664685809,
         -0.124193578401645,
         0.126906919108849,
         -0.117771247243984,
         0.117445329313946,
         -0.110812869792084,
         0.160333220285159,
         -0.0552799077610739,
         0.00271756703434887,
         0.0149324269357832,
         -0.0552799077610739,
         0.143058799750063,
         -0.124193578401645,
         -0.0689136706405715,
         0.0523029622285833,
         -0.0193345996745429,
         0.0389222536190216,
         -0.0555329620310095,
         -0.110812869792083,
         0.136547445294031,
         0.015163432822311,
         -0.0329683625540403,
         -0.0195876539444787,
         0.0151634328223111,
         0.117624265704226,
         -0.135372359436795,
         0.0149324269357833,
         0.0525560164985192,
         0.00271756703434878,
         -0.118097938901699,
         0.136726381684311,
         -0.0689136706405715,
         -0.0555329620310095,
         0.127264791889408,
         -0.124446632671581,
         0.160659911942875,
         -0.124446632671581},
        {-0.0829621066919146,
         0.107103619194689,
         -0.0829621066919144,
         0.147529334695133,
         -0.125675879281822,
         0.0427137725899079,
         0.0284598699749906,
         -0.163364657120396,
         0.0405729615949915,
         0.0812304267010869,
         -0.113145056372656,
         0.0540254486705623,
         0.12213067138104,
         0.0733624949387953,
         -0.124810039286409,
         0.0435796125853214,
         0.0733624949387952,
         -0.116008258059245,
         -0.0470429725669756,
         -0.125675879281822,
         0.0453112925761485,
         0.0794987467102597,
         -0.123078359295581,
         0.0427137725899079,
         0.121346679304754,
         0.0607322164359969,
         0.0786329067148464,
         -0.113145056372657,
         0.0405729615949913,
         0.0786329067148462,
         -0.156657889354962,
         -0.0470429725669759,
         -0.0223374566531958,
         0.100396851429255,
         -0.141406921373338,
         0.121346679304754,
         -0.0523134739172763,
         0.121880618939779,
         -0.169778813570894,
         0.15392088860804,
         0.00392288634679626,
         -0.0384104262576126,
         0.00387215417476586,
         0.0990791487592651,
         -0.190516735326985,
         0.0661366516150704,
         0.00387215417476574,
         0.0160239138473207,
         -0.052720873661118,
         0.00387215417476592,
         0.163356462451962,
         -0.096305249221621,
         -0.0677382764605093,
         0.0306878389487691,
         0.00424173237531417,
         0.030687838948769,
         -0.0677382764605092,
         -0.096305249221621,
         0.163356462451961,
         0.00387215417476602,
         -0.052720873661118,
         0.0160239138473208,
         0.00387215417476579,
         0.0661366516150705,
         -0.190516735326985,
         0.0990791487592649,
         0.00387215417476616,
         -0.0384104262576128,
         0.00392288634679637,
         0.15392088860804,
         -0.169778813570894,
         0.121880618939779,
         -0.0523134739172765,
         0.121346679304754,
         -0.141406921373338,
         0.100396851429255,
         -0.0223374566531953,
         -0.047042972566976,
         -0.156657889354962,
         0.0786329067148462,
         0.0405729615949913,
         -0.113145056372656,
         0.0786329067148462,
         0.0607322164359968,
         0.121346679304754,
         0.042713772589908,
         -0.123078359295581,
         0.0794987467102597,
         0.0453112925761487,
         -0.125675879281822,
         -0.047042972566976,
         -0.116008258059245,
         0.0733624949387952,
         0.0435796125853212,
         -0.124810039286409,
         0.0733624949387952,
         0.12213067138104,
         0.0540254486705623,
         -0.113145056372656,
         0.0812304267010873,
         0.0405729615949913,
         -0.163364657120396,
         0.0284598699749905,
         0.0427137725899079,
         -0.125675879281822,
         0.147529334695133,
         -0.0829621066919144,
         0.107103619194689,
         -0.0829621066919144},
        {-0.0738401778331153,
         0.116751572392261,
         -0.132383839596719,
         0.116751572392261,
         -0.0738401778331155,
         0.0656201959490605,
         -0.0398071700293545,
         -0.0288531769517985,
         0.105285022379321,
         -0.152035239440961,
         0.136599459297891,
         -0.0175841395517328,
         -0.0469894000918787,
         0.0898062744442841,
         -0.073158236795686,
         -0.0050437559189027,
         0.111725057748965,
         -0.176298597392576,
         -0.0329362227660769,
         0.0651066120162501,
         -0.0303202278190988,
         -0.0413661896684308,
         0.0980343162179488,
         -0.0890966418965213,
         -0.0126472752862578,
         0.172781226504902,
         0.0495573371810118,
         -0.00921886726524835,
         -0.0510581427674888,
         0.0758145051147329,
         -0.0437723923783553,
         -0.0321646624354342,
         0.104911765916086,
         -0.0932026642487118,
         -0.118410256785915,
         -0.0554067873603101,
         0.0496749592645501,
         -0.00575270352275622,
         -0.0481514569282547,
         0.0791032124077482,
         -0.0594079832552036,
         -0.0213043040842803,
         0.132386691703256,
         0.0362722567275634,
         -0.0528613555884137,
         0.0473778686552825,
         -0.0185729535541538,
         -0.0260926489414956,
         0.0700783348155716,
         -0.0866674336764221,
         0.119845631398123,
         -0.152572492502972,
         0.138231061504769,
         -0.0941031149725298,
         0.0418122257532983,
         -0.00309405900586235,
         -0.157541256483665,
         0.0997124254276062,
         -0.00425130526892785,
         -0.0657087456933843,
         0.0805851409550741,
         -0.0422461012700541,
         -0.0155827297860045,
         0.127200200104466,
         0.0166585010579333,
         -0.0854010214771506,
         0.0632538918342986,
         0.00634387361638662,
         -0.0614056509104468,
         0.0484013926261019,
         0.0432164031210024,
         -0.0555177435723824,
         -0.0838019377625083,
         0.0437711763508533,
         0.0360652082993421,
         -0.0719803244832741,
         0.0360652082993421,
         0.0437711763508531,
         -0.0838019377625083,
         -0.0555177435723823,
         0.0432164031210026,
         0.0484013926261019,
         -0.061405650910447,
         0.00634387361638653,
         0.0632538918342988,
         -0.0854010214771507,
         0.0166585010579332,
         0.127200200104466,
         -0.0155827297860043,
         -0.0422461012700541,
         0.0805851409550741,
         -0.0657087456933843,
         -0.00425130526892802,
         0.099712425427606,
         -0.157541256483665,
         -0.00309405900586229,
         0.0418122257532981,
         -0.09410311497253,
         0.138231061504769,
         -0.152572492502972,
         0.119845631398123,
         -0.0866674336764219,
         0.0700783348155715,
         -0.0260926489414959,
         -0.0185729535541538,
         0.0473778686552824,
         -0.0528613555884137,
         0.0362722567275634,
         0.132386691703256,
         -0.0213043040842802,
         -0.0594079832552034,
         0.079103212407748,
         -0.0481514569282548,
         -0.00575270352275615,
         0.0496749592645501,
         -0.0554067873603103,
         -0.118410256785915,
         -0.093202664248712,
         0.104911765916086,
         -0.0321646624354341,
         -0.0437723923783551,
         0.0758145051147332,
         -0.0510581427674888,
         -0.00921886726524851,
         0.049557337181012,
         0.172781226504902,
         -0.0126472752862579,
         -0.0890966418965214,
         0.0980343162179488,
         -0.0413661896684307,
         -0.030320227819099,
         0.06510661201625,
         -0.0329362227660769,
         -0.176298597392576,
         0.111725057748965,
         -0.0050437559189028,
         -0.0731582367956857,
         0.0898062744442839,
         -0.0469894000918788,
         -0.0175841395517324,
         0.136599459297891,
         -0.152035239440962,
         0.10528502237932,
         -0.0288531769517987,
         -0.0398071700293547,
         0.0656201959490604,
         -0.0738401778331155,
         0.116751572392261,
         -0.132383839596719,
         0.116751572392261,
         -0.0738401778331155},
        {0.0421153220157619,
         -0.0665901709806207,
         0.075506156646854,
         -0.0665901709806206,
         0.042115322015762,
         -0.0781228502687455,
         0.0870501333225552,
         -0.0604513099279556,
         0.0168578100624206,
         0.0223686829400808,
         -0.037214709154388,
         0.120685509746237,
         -0.0936842627208791,
         0.0384033204961525,
         0.00457709194884937,
         -0.0162624824966074,
         -0.00221087835602139,
         0.0292121253813794,
         -0.162860119080216,
         0.0676347276753249,
         0.010044200850582,
         -0.0419436972027265,
         0.0383982970243361,
         -0.0238309582851003,
         0.0228221043274486,
         -0.0442970621053283,
         0.17205654857244,
         0.027405547025278,
         -0.0900231373497369,
         0.081822081697085,
         -0.04933263354818,
         0.0195894405685842,
         -0.000131544608568836,
         -0.0209976182968893,
         0.0752502179281048,
         -0.192365069290985,
         0.122252409408325,
         -0.0407172059370229,
         -0.0192292156030719,
         0.0541126553187811,
         -0.0716408539331734,
         0.0813442682939671,
         -0.0841323013044575,
         0.125932498727338,
         -0.154537460632535,
         0.151597048083616,
         -0.133285312401754,
         0.109253099164013,
         -0.0836824817792702,
         0.0550775198740726,
         0.00213240393632215,
         -0.0244292876730242,
         0.0543673024147431,
         -0.0795360212970277,
         0.0876022706966669,
         -0.0687225749169429,
         -0.0354924528855624,
         0.0904533884827318,
         -0.125021612644515,
         0.120545810859711,
         -0.0761270320299465,
         0.00863710625401653,
         0.0463238293431525,
         0.0796203455578307,
         -0.125988803026479,
         0.101820131480662,
         -0.0269433410343577,
         -0.0597428228300133,
         0.115649607286995,
         -0.107694126153507,
         0.0312171802356633,
         -0.0957305127464347,
         0.0796459624061634,
         0.0114334795791087,
         -0.0979173357528743,
         0.13205131964123,
         -0.0979173357528744,
         0.0114334795791088,
         0.0796459624061634,
         -0.0957305127464348,
         0.0312171802356633,
         -0.107694126153507,
         0.115649607286995,
         -0.0597428228300136,
         -0.0269433410343579,
         0.101820131480662,
         -0.125988803026479,
         0.079620345557831,
         0.0463238293431528,
         0.00863710625401655,
         -0.0761270320299466,
         0.120545810859711,
         -0.125021612644515,
         0.0904533884827318,
         -0.0354924528855625,
         -0.0687225749169428,
         0.0876022706966668,
         -0.0795360212970278,
         0.0543673024147432,
         -0.0244292876730242,
         0.00213240393632212,
         0.0550775198740727,
         -0.0836824817792704,
         0.109253099164013,
         -0.133285312401754,
         0.151597048083616,
         -0.154537460632535,
         0.125932498727338,
         -0.0841323013044577,
         0.0813442682939672,
         -0.0716408539331733,
         0.0541126553187811,
         -0.019229215603072,
         -0.0407172059370229,
         0.122252409408325,
         -0.192365069290985,
         0.0752502179281047,
         -0.0209976182968893,
         -0.000131544608568717,
         0.0195894405685841,
         -0.0493326335481802,
         0.0818220816970852,
         -0.0900231373497369,
         0.0274055470252782,
         0.17205654857244,
         -0.0442970621053281,
         0.0228221043274485,
         -0.0238309582851002,
         0.0383982970243357,
         -0.0419436972027266,
         0.0100442008505819,
         0.0676347276753249,
         -0.162860119080216,
         0.0292121253813793,
         -0.00221087835602139,
         -0.0162624824966074,
         0.00457709194884921,
         0.0384033204961525,
         -0.093684262720879,
         0.120685509746237,
         -0.037214709154388,
         0.0223686829400806,
         0.0168578100624207,
         -0.0604513099279558,
         0.0870501333225549,
         -0.0781228502687455,
         0.042115322015762,
         -0.0665901709806208,
         0.0755061566468539,
         -0.0665901709806207,
         0.0421153220157621},
        {0.0047682083745901,
         -0.00412938958293287,
         0.00220725157654969,
         0.115491203700101,
         -0.103389948793713,
         0.069891861068664,
         -0.0339878476459756,
         -0.231232468438148,
         0.0634877301451885,
         0.0261221339076492,
         -0.0554337058455456,
         0.0434066177398231,
         0.20025319184722,
         -0.148602309084495,
         0.0707139621087443,
         -0.00836934103981342,
         -0.0200319005827246,
         -0.10703983350003,
         0.120510861719051,
         -0.0976307626346092,
         0.0572174540997882,
         -0.0175294380360605,
         -0.121331042452606,
         0.101704132555822,
         -0.0643737321272898,
         0.0293055599732864,
         0.167709576118739,
         -0.114459188960549,
         0.0758322348820316,
         -0.0463830321516636,
         0.0228371052840037,
         0.0182652930863707,
         0.0312322991613578,
         -0.0741278295673869,
         0.0907972242909834,
         -0.0725261804366747,
         -0.118997274665579,
         0.108115677213363,
         -0.050240156083449,
         -0.0184711380251619,
         0.0600235162623585,
         0.1065549146558,
         -0.149897703004087,
         0.148232238483333,
         -0.10384711135251,
         0.032794575656811,
         -0.0378679141668388,
         0.131852423928367,
         -0.152898657020289,
         0.125442272361828,
         -0.0721508059083078,
         -0.118464094479986,
         0.0677747650882673,
         -0.010834421948125,
         -0.0247601993571476,
         0.0308315213961102,
         0.0655955131328699,
         -0.0880837766306379,
         0.0947812131023201,
         -0.088083776630638,
         0.0655955131328698,
         0.0308315213961103,
         -0.0247601993571475,
         -0.0108344219481251,
         0.0677747650882674,
         -0.118464094479986,
         -0.0721508059083078,
         0.125442272361828,
         -0.152898657020289,
         0.131852423928367,
         -0.0378679141668391,
         0.0327945756568112,
         -0.10384711135251,
         0.148232238483333,
         -0.149897703004087,
         0.1065549146558,
         0.0600235162623589,
         -0.0184711380251615,
         -0.0502401560834491,
         0.108115677213363,
         -0.11899727466558,
         -0.0725261804366746,
         0.0907972242909833,
         -0.0741278295673873,
         0.0312322991613576,
         0.0182652930863709,
         0.0228371052840039,
         -0.0463830321516635,
         0.0758322348820315,
         -0.114459188960549,
         0.167709576118739,
         0.0293055599732866,
         -0.0643737321272902,
         0.101704132555822,
         -0.121331042452606,
         -0.0175294380360605,
         0.0572174540997882,
         -0.0976307626346092,
         0.12051086171905,
         -0.10703983350003,
         -0.0200319005827247,
         -0.00836934103981349,
         0.0707139621087442,
         -0.148602309084495,
         0.20025319184722,
         0.0434066177398232,
         -0.0554337058455458,
         0.0261221339076492,
         0.0634877301451884,
         -0.231232468438148,
         -0.0339878476459753,
         0.069891861068664,
         -0.103389948793713,
         0.1154912037001,
         0.00220725157654958,
         -0.0041293895829328,
         0.00476820837459011},
        {0.189185213705,
         -0.163839201088918,
         0.0875757367139272,
         -0.0335643236154645,
         -0.104706590599197,
         0.156122290597009,
         -0.114880351782232,
         0.0455355444790046,
         -0.00313093537429155,
         0.0705962322186114,
         -0.130896000177873,
         0.121461030961367,
         -0.0394349382939739,
         0.0231285395019044,
         -0.0541120221825761,
         0.101333067166238,
         -0.111844471825826,
         0.0210788611663747,
         -0.0208395685274472,
         0.0356139337712009,
         -0.0648240801984338,
         0.0832823541058416,
         -0.198139296612856,
         0.0378195168436817,
         0.0628170511878089,
         -0.0708958401112453,
         -0.0222051009512199,
         0.179540578548457,
         -0.0817842539882074,
         -0.0559908344408119,
         0.10812150112029,
         -0.0129683107687711,
         -0.108931489751684,
         0.0768304029682587,
         0.047124169104952,
         -0.134614178584641,
         0.0295686134140327,
         0.0380499488139728,
         -0.0387229280852138,
         -0.0499190745280001,
         0.153975599292967,
         -0.0238754484838528,
         0.00298070911277923,
         -0.000242217092871524,
         0.0542302859716377,
         -0.155807017714023,
         0.179910447237648,
         0.0443777671066683,
         -0.0538107536603226,
         -0.00519978830189629,
         0.041156666884538,
         -0.107985715730691,
         -0.0835370200982655,
         0.120814914639246,
         -0.0331801949718763,
         -0.0627877717983687,
         0.0791829974347827,
         0.0737945230118534,
         -0.148673723712829,
         0.0737945230118533,
         0.0791829974347826,
         -0.0627877717983689,
         -0.0331801949718764,
         0.120814914639245,
         -0.0835370200982656,
         -0.107985715730691,
         0.0411566668845381,
         -0.00519978830189617,
         -0.0538107536603224,
         0.044377767106668,
         0.179910447237648,
         -0.155807017714023,
         0.0542302859716375,
         -0.000242217092871617,
         0.00298070911277925,
         -0.0238754484838526,
         0.153975599292966,
         -0.0499190745280004,
         -0.038722928085214,
         0.038049948813973,
         0.0295686134140327,
         -0.134614178584641,
         0.0471241691049522,
         0.0768304029682587,
         -0.108931489751684,
         -0.0129683107687713,
         0.10812150112029,
         -0.0559908344408118,
         -0.0817842539882075,
         0.179540578548457,
         -0.0222051009512199,
         -0.0708958401112451,
         0.0628170511878088,
         0.0378195168436816,
         -0.198139296612856,
         0.0832823541058415,
         -0.0648240801984336,
         0.0356139337712006,
         -0.020839568527447,
         0.0210788611663747,
         -0.111844471825826,
         0.101333067166238,
         -0.0541120221825759,
         0.0231285395019042,
         -0.0394349382939739,
         0.121461030961367,
         -0.130896000177873,
         0.0705962322186113,
         -0.00313093537429159,
         0.0455355444790045,
         -0.114880351782232,
         0.156122290597009,
         -0.104706590599198,
         -0.0335643236154645,
         0.0875757367139273,
         -0.163839201088918,
         0.189185213705},
        {0.000346366691398352,
         -0.000447157475822257,
         0.000346366691398461,
         -0.0951488990381962,
         0.134278056245411,
         -0.133995249026137,
         0.0945489743306446,
         0.0974673529027823,
         -0.0426907533255232,
         -0.0572459579333606,
         0.147007120043317,
         -0.170805952368766,
         -0.0224768984952705,
         -0.0684498017205898,
         0.108051116251606,
         -0.0675721112014073,
         -0.0422651155265709,
         0.165044139503454,
         -0.0700841619862975,
         0.088436472757545,
         -0.0451450169927498,
         -0.0172383240613545,
         0.0562511006531983,
         -0.0295202945263761,
         -0.105237681080353,
         0.0945489743306446,
         -0.133995249026137,
         0.134278056245411,
         -0.0951488990381962,
         0.0454300868226005,
         -0.0637580084517789,
         0.0696645359109596,
         -0.0637580084517789,
         0.0454300868226004,
         -0.126580950183236,
         0.0384034567824636,
         0.0343178649597706,
         -0.0505271614877801,
         0.00633389665734029,
         0.0679309602896736,
         0.0976126281431692,
         0.0473206328113148,
         -0.0337763667575748,
         -0.0528733693254274,
         0.127614244439388,
         -0.105789653566662,
         -0.0968992823297404,
         -0.0224768984952703,
         -0.0684498017205901,
         0.108051116251606,
         -0.0675721112014072,
         -0.042265115526571,
         0.165044139503454,
         -0.170805952368767,
         0.147007120043317,
         -0.0572459579333607,
         -0.0426907533255233,
         0.0974673529027824,
         0.0679309602896736,
         0.00633389665734027,
         -0.0505271614877801,
         0.0343178649597705,
         0.0384034567824632,
         -0.126580950183236,
         0.0289683220400672,
         0.0296816678534956,
         -0.0643350728186468,
         0.0757967763118656,
         -0.0643350728186467,
         0.0296816678534958,
         0.0289683220400673,
         -0.126580950183236,
         0.0384034567824634,
         0.0343178649597705,
         -0.0505271614877802,
         0.00633389665734056,
         0.0679309602896733,
         0.0974673529027824,
         -0.0426907533255234,
         -0.0572459579333605,
         0.147007120043317,
         -0.170805952368766,
         0.165044139503454,
         -0.0422651155265711,
         -0.0675721112014072,
         0.108051116251606,
         -0.0684498017205901,
         -0.0224768984952704,
         -0.0968992823297405,
         -0.105789653566662,
         0.127614244439388,
         -0.0528733693254274,
         -0.0337763667575748,
         0.0473206328113147,
         0.0976126281431689,
         0.0679309602896735,
         0.00633389665734029,
         -0.0505271614877801,
         0.0343178649597705,
         0.0384034567824634,
         -0.126580950183236,
         0.0454300868226004,
         -0.0637580084517789,
         0.0696645359109598,
         -0.063758008451779,
         0.0454300868226004,
         -0.0951488990381961,
         0.134278056245411,
         -0.133995249026137,
         0.0945489743306446,
         -0.105237681080353,
         -0.0295202945263761,
         0.0562511006531983,
         -0.0172383240613546,
         -0.0451450169927499,
         0.0884364727575453,
         -0.0700841619862973,
         0.165044139503454,
         -0.042265115526571,
         -0.0675721112014071,
         0.108051116251606,
         -0.0684498017205899,
         -0.0224768984952702,
         -0.170805952368766,
         0.147007120043317,
         -0.0572459579333604,
         -0.0426907533255233,
         0.0974673529027823,
         0.0945489743306447,
         -0.133995249026137,
         0.134278056245411,
         -0.0951488990381961,
         0.000346366691398498,
         -0.000447157475822331,
         0.000346366691398438},
        {-0.0339251344681886,
         0.0437971602710472,
         -0.0339251344681887,
         0.0280643056790011,
         -0.0119891654090381,
         -0.0157105908917513,
         0.0306957508735081,
         -0.0423449621842431,
         0.0318205141401316,
         -0.0255708591790983,
         0.0344519593346386,
         -0.0460663876669563,
         -0.0176675358198801,
         0.0651536528505501,
         -0.0960203150067114,
         0.114101642933018,
         -0.128521286875376,
         0.135235031191107,
         0.185975612707773,
         -0.171550130117423,
         0.130343341939891,
         -0.0749059872230935,
         0.00902937296073716,
         0.0722546259076814,
         -0.182673566496875,
         0.0306957508735081,
         -0.0157105908917514,
         -0.0119891654090382,
         0.028064305679001,
         0.003252971949249,
         -0.0525777823188908,
         0.0751149389077245,
         -0.052577782318891,
         0.00325297194924902,
         0.0885914878534793,
         -0.0830495741303878,
         0.111577765145057,
         -0.14992870538466,
         0.154152815016015,
         -0.0927910565818534,
         -0.164337388822248,
         0.090171383559119,
         -0.0670482482333288,
         0.0435882085864164,
         -0.00344921857676002,
         -0.0346730396204248,
         0.0170451556130851,
         -0.0176675358198804,
         0.0651536528505497,
         -0.0960203150067112,
         0.114101642933018,
         -0.128521286875376,
         0.135235031191107,
         -0.0460663876669562,
         0.0344519593346386,
         -0.0255708591790984,
         0.0318205141401318,
         -0.0423449621842431,
         -0.0927910565818535,
         0.154152815016015,
         -0.14992870538466,
         0.111577765145056,
         -0.0830495741303879,
         0.0885914878534792,
         0.0757459009687683,
         -0.0715463322403945,
         0.0164699986781131,
         0.01064821123019,
         0.0164699986781132,
         -0.0715463322403943,
         0.0757459009687682,
         0.0885914878534793,
         -0.0830495741303882,
         0.111577765145057,
         -0.149928705384659,
         0.154152815016015,
         -0.0927910565818533,
         -0.0423449621842431,
         0.0318205141401316,
         -0.0255708591790982,
         0.0344519593346386,
         -0.0460663876669565,
         0.135235031191107,
         -0.128521286875376,
         0.114101642933018,
         -0.0960203150067113,
         0.0651536528505497,
         -0.0176675358198804,
         0.0170451556130848,
         -0.0346730396204247,
         -0.00344921857676003,
         0.0435882085864165,
         -0.0670482482333286,
         0.0901713835591189,
         -0.164337388822248,
         -0.0927910565818534,
         0.154152815016015,
         -0.14992870538466,
         0.111577765145057,
         -0.0830495741303878,
         0.0885914878534792,
         0.00325297194924909,
         -0.0525777823188909,
         0.0751149389077246,
         -0.0525777823188907,
         0.00325297194924919,
         0.028064305679001,
         -0.0119891654090382,
         -0.0157105908917513,
         0.030695750873508,
         -0.182673566496875,
         0.0722546259076816,
         0.00902937296073699,
         -0.0749059872230936,
         0.130343341939891,
         -0.171550130117423,
         0.185975612707774,
         0.135235031191107,
         -0.128521286875376,
         0.114101642933018,
         -0.0960203150067112,
         0.0651536528505499,
         -0.0176675358198804,
         -0.0460663876669566,
         0.0344519593346387,
         -0.0255708591790983,
         0.0318205141401317,
         -0.0423449621842431,
         0.030695750873508,
         -0.0157105908917515,
         -0.0119891654090382,
         0.028064305679001,
         -0.0339251344681887,
         0.0437971602710475,
         -0.0339251344681888},
        {0.13855880125565,
         -0.178878643244532,
         0.13855880125565,
         -0.131383542495843,
         0.0726716001875609,
         0.0404611872951215,
         -0.108607341114781,
         0.0870529707622184,
         0.00827205059904527,
         -0.0653527568735758,
         0.0310482519801077,
         0.054842557869779,
         -0.0391257784141794,
         -0.0365418080270454,
         0.0336220422550548,
         0.0125893352994862,
         -0.0334468677316637,
         -0.016573030317107,
         0.107703614984924,
         -0.0757575506836107,
         0.0988686193208284,
         -0.118280314467489,
         0.111011858343412,
         -0.089858201817323,
         0.103390024406852,
         -0.108607341114781,
         0.0404611872951217,
         0.0726716001875607,
         -0.131383542495843,
         0.120945291400756,
         0.0249092645177831,
         -0.0988381894323185,
         0.0249092645177832,
         0.120945291400756,
         -0.0897237358943569,
         -0.0761908994282558,
         0.058936611095568,
         0.0486839746654682,
         -0.0799814116822876,
         -0.0664159639047531,
         -0.0597845185329541,
         0.181454318728625,
         -0.0993260331677674,
         0.0382398606552761,
         -0.0799330854004193,
         0.16304007701684,
         -0.0830922905225586,
         -0.0391257784141795,
         -0.0365418080270454,
         0.033622042255055,
         0.0125893352994861,
         -0.0334468677316639,
         -0.0165730303171068,
         0.0548425578697793,
         0.0310482519801075,
         -0.0653527568735757,
         0.00827205059904524,
         0.0870529707622185,
         -0.0664159639047529,
         -0.0799814116822878,
         0.0486839746654679,
         0.0589366110955679,
         -0.0761908994282557,
         -0.0897237358943572,
         0.149508254427311,
         0.00663144537179875,
         0.114339106642173,
         -0.19043835262907,
         0.114339106642173,
         0.00663144537179864,
         0.149508254427311,
         -0.0897237358943572,
         -0.0761908994282558,
         0.0589366110955679,
         0.0486839746654678,
         -0.0799814116822876,
         -0.0664159639047529,
         0.0870529707622184,
         0.00827205059904516,
         -0.0653527568735759,
         0.0310482519801076,
         0.0548425578697793,
         -0.016573030317107,
         -0.0334468677316639,
         0.0125893352994862,
         0.033622042255055,
         -0.0365418080270455,
         -0.0391257784141795,
         -0.0830922905225582,
         0.163040077016841,
         -0.0799330854004194,
         0.038239860655276,
         -0.0993260331677674,
         0.181454318728625,
         -0.0597845185329543,
         -0.0664159639047528,
         -0.0799814116822879,
         0.0486839746654679,
         0.0589366110955676,
         -0.0761908994282558,
         -0.0897237358943573,
         0.120945291400756,
         0.0249092645177832,
         -0.0988381894323183,
         0.0249092645177831,
         0.120945291400756,
         -0.131383542495843,
         0.0726716001875608,
         0.0404611872951216,
         -0.108607341114781,
         0.103390024406853,
         -0.089858201817323,
         0.111011858343412,
         -0.118280314467489,
         0.0988686193208283,
         -0.075757550683611,
         0.107703614984924,
         -0.0165730303171069,
         -0.0334468677316639,
         0.0125893352994862,
         0.033622042255055,
         -0.0365418080270454,
         -0.0391257784141794,
         0.054842557869779,
         0.0310482519801077,
         -0.0653527568735755,
         0.0082720505990453,
         0.0870529707622184,
         -0.108607341114781,
         0.0404611872951215,
         0.0726716001875609,
         -0.131383542495843,
         0.13855880125565,
         -0.178878643244532,
         0.13855880125565},
        {0.0795069366532415,
         -0.102643013855324,
         0.0795069366532418,
         -0.0259568235208106,
         -0.0282086500781542,
         0.0931257920155632,
         -0.111753230316764,
         -0.0654470369831199,
         0.118512910839472,
         -0.107974062850418,
         0.0327165040435182,
         0.0558874051105971,
         0.113080823656842,
         -0.0805396786163355,
         -0.00357290849360112,
         0.0799221005273943,
         -0.0960926240359712,
         0.0311428286657194,
         -0.168247929373864,
         0.0759178234895612,
         -0.0249800582004453,
         0.0270428778810159,
         -0.073185924134707,
         0.133960235793889,
         -0.159388248919867,
         -0.111753230316764,
         0.093125792015563,
         -0.0282086500781539,
         -0.0259568235208104,
         0.125114460033994,
         -0.0644987781113086,
         0.0295976658640384,
         -0.0644987781113086,
         0.125114460033994,
         -0.035014307338487,
         -0.0264739017051103,
         0.0040070989154541,
         0.037403045096977,
         -0.00742551156737824,
         -0.126507766021977,
         0.0297527705474098,
         -0.0870685690932255,
         0.158512930464946,
         -0.159283557600378,
         0.0866925645215884,
         -0.020166476334901,
         0.1212462292309,
         0.113080823656842,
         -0.0805396786163355,
         -0.0035729084936011,
         0.0799221005273943,
         -0.0960926240359711,
         0.0311428286657192,
         0.0558874051105971,
         0.0327165040435181,
         -0.107974062850418,
         0.118512910839472,
         -0.06544703698312,
         -0.126507766021977,
         -0.0074255115673784,
         0.0374030450969771,
         0.00400709891545432,
         -0.0264739017051104,
         -0.0350143073384869,
         0.0052615367910772,
         0.156260536569387,
         -0.130002163959277,
         0.100720770318175,
         -0.130002163959277,
         0.156260536569387,
         0.00526153679107705,
         -0.0350143073384869,
         -0.0264739017051103,
         0.00400709891545407,
         0.037403045096977,
         -0.00742551156737839,
         -0.126507766021977,
         -0.0654470369831198,
         0.118512910839472,
         -0.107974062850418,
         0.0327165040435184,
         0.0558874051105972,
         0.0311428286657192,
         -0.096092624035971,
         0.0799221005273943,
         -0.0035729084936009,
         -0.0805396786163355,
         0.113080823656842,
         0.1212462292309,
         -0.0201664763349008,
         0.0866925645215886,
         -0.159283557600378,
         0.158512930464946,
         -0.0870685690932256,
         0.0297527705474099,
         -0.126507766021977,
         -0.00742551156737839,
         0.037403045096977,
         0.00400709891545399,
         -0.0264739017051102,
         -0.035014307338487,
         0.125114460033994,
         -0.0644987781113083,
         0.0295976658640386,
         -0.0644987781113085,
         0.125114460033994,
         -0.0259568235208104,
         -0.0282086500781541,
         0.0931257920155629,
         -0.111753230316764,
         -0.159388248919867,
         0.133960235793889,
         -0.073185924134707,
         0.027042877881016,
         -0.0249800582004452,
         0.075917823489561,
         -0.168247929373863,
         0.0311428286657194,
         -0.0960926240359711,
         0.0799221005273941,
         -0.00357290849360099,
         -0.0805396786163357,
         0.113080823656842,
         0.055887405110597,
         0.0327165040435181,
         -0.107974062850418,
         0.118512910839472,
         -0.0654470369831195,
         -0.111753230316764,
         0.0931257920155629,
         -0.0282086500781539,
         -0.0259568235208106,
         0.0795069366532417,
         -0.102643013855324,
         0.0795069366532417},
        {0.0674449076993872,
         -0.106639762454945,
         0.120918124854337,
         -0.106639762454945,
         0.0674449076993871,
         -0.0412476179637129,
         0.0175274588201674,
         0.0360520304711145,
         -0.0930533811730235,
         0.125544795952045,
         -0.109563780388315,
         -0.00398349138879312,
         0.0416967220853601,
         -0.0613115304066932,
         0.0438133781412762,
         0.00940241584679138,
         -0.076630342212179,
         0.114343572908746,
         0.00455597053004364,
         -0.00257717776306627,
         -0.0243746672644662,
         0.0610913838395516,
         -0.0850889593680325,
         0.0755725593466195,
         -0.0224061839529805,
         -0.057917956706704,
         -0.0259594877276126,
         0.0227379300709323,
         -0.0213603706117603,
         0.0328506989530068,
         -0.0601715963739605,
         0.0982245358302883,
         -0.133849781954033,
         0.145826391053617,
         -0.104872211113838,
         -0.109563780388315,
         0.125544795952045,
         -0.0930533811730235,
         0.0360520304711145,
         0.0175274588201675,
         -0.041247617963713,
         0.0923781717584571,
         -0.0319274951827409,
         -0.0383146813204666,
         0.0672579146774689,
         -0.0383146813204665,
         -0.0319274951827409,
         0.092378171758457,
         0.00187252844913154,
         -0.0796622120238198,
         0.0889420744204685,
         -0.042729654145009,
         -0.0137029612641579,
         0.0297806975307514,
         0.028293131174756,
         -0.142982516664052,
         0.0195163724142524,
         -0.0243595872771892,
         0.0778883062544726,
         -0.117748708522167,
         0.113831806550829,
         -0.0682734461055026,
         0.0154543062457232,
         -0.0219998993255159,
         0.186780570993396,
         0.00455597053004378,
         -0.0025771777630662,
         -0.0243746672644661,
         0.0610913838395517,
         -0.0850889593680326,
         0.0755725593466195,
         -0.0224061839529806,
         -0.057917956706704,
         0.114343572908746,
         -0.0766303422121789,
         0.00940241584679142,
         0.0438133781412761,
         -0.0613115304066932,
         0.0416967220853602,
         -0.00398349138879304,
         -0.142982516664052,
         0.028293131174756,
         0.0297806975307517,
         -0.0137029612641579,
         -0.0427296541450089,
         0.0889420744204686,
         -0.0796622120238198,
         0.0018725284491315,
         -0.0216785820225951,
         0.143883416544439,
         -0.110254459205704,
         0.0417098348607289,
         -0.0108004184221146,
         0.0417098348607288,
         -0.110254459205704,
         0.143883416544439,
         -0.021678582022595,
         0.00187252844913156,
         -0.07966221202382,
         0.0889420744204684,
         -0.0427296541450089,
         -0.0137029612641578,
         0.0297806975307515,
         0.0282931311747562,
         -0.142982516664052,
         -0.00398349138879295,
         0.0416967220853601,
         -0.0613115304066934,
         0.0438133781412761,
         0.00940241584679138,
         -0.076630342212179,
         0.114343572908746,
         -0.0579179567067038,
         -0.0224061839529805,
         0.0755725593466197,
         -0.0850889593680323,
         0.0610913838395518,
         -0.0243746672644661,
         -0.00257717776306619,
         0.00455597053004379,
         0.186780570993396,
         -0.0219998993255159,
         0.0154543062457233,
         -0.0682734461055026,
         0.113831806550829,
         -0.117748708522167,
         0.0778883062544728,
         -0.0243595872771892,
         0.0195163724142524,
         -0.142982516664052,
         0.0282931311747561,
         0.0297806975307515,
         -0.0137029612641577,
         -0.0427296541450092,
         0.0889420744204686,
         -0.0796622120238199,
         0.00187252844913148,
         0.092378171758457,
         -0.0319274951827408,
         -0.0383146813204667,
         0.0672579146774688,
         -0.0383146813204665,
         -0.0319274951827407,
         0.0923781717584568,
         -0.0412476179637129,
         0.0175274588201675,
         0.0360520304711145,
         -0.0930533811730237,
         0.125544795952045,
         -0.109563780388315,
         -0.104872211113838,
         0.145826391053617,
         -0.133849781954033,
         0.0982245358302883,
         -0.0601715963739607,
         0.0328506989530065,
         -0.0213603706117603,
         0.0227379300709324,
         -0.0259594877276126,
         -0.057917956706704,
         -0.0224061839529804,
         0.0755725593466195,
         -0.0850889593680326,
         0.0610913838395518,
         -0.0243746672644662,
         -0.00257717776306614,
         0.00455597053004365,
         0.114343572908746,
         -0.0766303422121789,
         0.00940241584679124,
         0.0438133781412761,
         -0.0613115304066932,
         0.04169672208536,
         -0.0039834913887928,
         -0.109563780388315,
         0.125544795952045,
         -0.0930533811730235,
         0.0360520304711146,
         0.0175274588201673,
         -0.0412476179637128,
         0.067444907699387,
         -0.106639762454945,
         0.120918124854337,
         -0.106639762454945,
         0.067444907699387},
        {-0.0234437901617499,
         0.0370678869490886,
         -0.0420310330688335,
         0.0370678869490886,
         -0.02344379016175,
         0.0416436670260186,
         -0.0492671559618469,
         0.0390718953039735,
         -0.0192582763018082,
         -0.000464633038416565,
         0.0107782414258949,
         -0.0982706512019462,
         0.111341503251647,
         -0.100825625596901,
         0.0837213718610289,
         -0.0688768748252667,
         0.057881017914995,
         -0.0448101658652944,
         0.170348918072436,
         -0.140245556276966,
         0.0861333895044937,
         -0.0325808623952976,
         -0.0132752215182665,
         0.0503193989645587,
         -0.0777951598683463,
         0.0881427527733645,
         -0.209414555747568,
         0.0889596806107569,
         -0.0139952775241955,
         -0.0266083916792775,
         0.0411789962955678,
         -0.0352421367493254,
         0.0115213445939452,
         0.0300619174884345,
         -0.0923882556869299,
         0.0107782414258949,
         -0.000464633038416463,
         -0.0192582763018082,
         0.0390718953039735,
         -0.049267155961847,
         0.0416436670260189,
         0.0320169180251779,
         -0.0850932639868551,
         0.128288662960208,
         -0.144568353881497,
         0.128288662960208,
         -0.0850932639868552,
         0.0320169180251777,
         -0.0247864097698985,
         0.0745497175684727,
         -0.0883393533906085,
         0.0665800162041906,
         -0.0248380034120648,
         -0.0159005207441273,
         0.0358661865577141,
         -0.0241202403532926,
         -0.0314951945260543,
         -0.0674940200814143,
         0.0936541769115321,
         -0.0832550966548996,
         0.0613583245170954,
         -0.0418171302186747,
         0.0272765079951715,
         -0.0091731765970964,
         -0.0322644207100609,
         0.170348918072436,
         -0.140245556276966,
         0.0861333895044936,
         -0.0325808623952975,
         -0.0132752215182664,
         0.0503193989645584,
         -0.0777951598683462,
         0.0881427527733643,
         -0.0448101658652945,
         0.0578810179149949,
         -0.0688768748252667,
         0.0837213718610288,
         -0.100825625596901,
         0.111341503251647,
         -0.0982706512019461,
         -0.0241202403532928,
         0.0358661865577142,
         -0.0159005207441272,
         -0.0248380034120647,
         0.0665800162041904,
         -0.0883393533906087,
         0.0745497175684728,
         -0.0247864097698985,
         0.0601160752318447,
         -0.0177616738111638,
         -0.0545225031295846,
         0.114705422521567,
         -0.137568464523483,
         0.114705422521567,
         -0.0545225031295845,
         -0.0177616738111639,
         0.0601160752318448,
         -0.0247864097698983,
         0.0745497175684729,
         -0.0883393533906087,
         0.0665800162041906,
         -0.0248380034120648,
         -0.0159005207441273,
         0.0358661865577142,
         -0.0241202403532927,
         -0.0982706512019462,
         0.111341503251647,
         -0.100825625596901,
         0.0837213718610289,
         -0.0688768748252669,
         0.0578810179149951,
         -0.0448101658652944,
         0.0881427527733644,
         -0.0777951598683463,
         0.0503193989645586,
         -0.0132752215182664,
         -0.0325808623952973,
         0.0861333895044935,
         -0.140245556276966,
         0.170348918072436,
         -0.0322644207100608,
         -0.00917317659709627,
         0.0272765079951716,
         -0.0418171302186747,
         0.0613583245170953,
         -0.0832550966548995,
         0.093654176911532,
         -0.0674940200814141,
         -0.0314951945260541,
         -0.0241202403532925,
         0.0358661865577143,
         -0.0159005207441272,
         -0.0248380034120648,
         0.0665800162041906,
         -0.0883393533906085,
         0.0745497175684728,
         -0.0247864097698985,
         0.0320169180251777,
         -0.0850932639868552,
         0.128288662960208,
         -0.144568353881497,
         0.128288662960207,
         -0.0850932639868553,
         0.0320169180251776,
         0.0416436670260188,
         -0.0492671559618469,
         0.0390718953039736,
         -0.0192582763018082,
         -0.000464633038416406,
         0.010778241425895,
         -0.0923882556869301,
         0.0300619174884345,
         0.0115213445939453,
         -0.0352421367493255,
         0.0411789962955679,
         -0.0266083916792775,
         -0.0139952775241955,
         0.0889596806107571,
         -0.209414555747568,
         0.0881427527733645,
         -0.0777951598683463,
         0.0503193989645584,
         -0.0132752215182663,
         -0.0325808623952973,
         0.0861333895044936,
         -0.140245556276966,
         0.170348918072436,
         -0.0448101658652945,
         0.057881017914995,
         -0.0688768748252666,
         0.083721371861029,
         -0.100825625596901,
         0.111341503251647,
         -0.0982706512019462,
         0.0107782414258948,
         -0.000464633038416467,
         -0.0192582763018081,
         0.0390718953039735,
         -0.0492671559618469,
         0.0416436670260188,
         -0.02344379016175,
         0.0370678869490885,
         -0.0420310330688334,
         0.0370678869490886,
         -0.0234437901617499},
        {-0.00566533951666284,
         0.00895768829540607,
         -0.0101570638078622,
         0.00895768829540596,
         -0.00566533951666273,
         0.0594407594958474,
         -0.0899780929386235,
         0.102756305096603,
         -0.0979682192996139,
         0.0779600929687544,
         -0.0467726752209737,
         -0.0953370033783966,
         0.0915282973239493,
         -0.0504927506996758,
         -0.00610234789577625,
         0.0594485991566281,
         -0.0924387680519845,
         0.0886300619975379,
         0.0846135386122072,
         -0.0293689235121565,
         -0.0266181067224128,
         0.0572099512900036,
         -0.0538675576937429,
         0.0185419135206586,
         0.0370171169493946,
         -0.0860043056219618,
         0.05829606944569,
         -0.118126876378572,
         0.133825226321552,
         -0.121277330477708,
         0.0956922624629281,
         -0.071601958305908,
         0.0628612164481532,
         -0.0826476977439788,
         0.143461925460508,
         -0.0467726752209738,
         0.0779600929687544,
         -0.0979682192996135,
         0.102756305096603,
         -0.0899780929386238,
         0.0594407594958477,
         -0.00932938641364387,
         0.00503639132505975,
         0.000404252194986617,
         -0.00268324451906275,
         0.000404252194986576,
         0.00503639132505962,
         -0.00932938641364389,
         0.0747292039962397,
         -0.0233645175011263,
         -0.0257281522606448,
         0.0506889695438213,
         -0.0464902430499669,
         0.0172968772814261,
         0.0254138793539062,
         -0.060478330853568,
         -0.177957683311453,
         0.0534094873132392,
         -0.0224154702238258,
         0.0498175217011044,
         -0.103166081751728,
         0.152720140731112,
         -0.171447239343439,
         0.135023468641649,
         -0.0218334700274494,
         0.084613538612207,
         -0.0293689235121568,
         -0.026618106722413,
         0.0572099512900039,
         -0.0538675576937428,
         0.0185419135206585,
         0.0370171169493947,
         -0.0860043056219619,
         0.088630061997538,
         -0.0924387680519846,
         0.0594485991566282,
         -0.00610234789577642,
         -0.0504927506996757,
         0.0915282973239494,
         -0.0953370033783967,
         -0.0604783308535681,
         0.0254138793539062,
         0.017296877281426,
         -0.0464902430499669,
         0.0506889695438214,
         -0.0257281522606448,
         -0.0233645175011263,
         0.0747292039962396,
         0.0916678312243427,
         -0.104009449392006,
         0.102667827132474,
         -0.0978000282536107,
         0.0955002910401321,
         -0.0978000282536107,
         0.102667827132474,
         -0.104009449392006,
         0.0916678312243429,
         0.0747292039962396,
         -0.0233645175011262,
         -0.0257281522606446,
         0.0506889695438214,
         -0.0464902430499668,
         0.0172968772814261,
         0.0254138793539062,
         -0.0604783308535681,
         -0.0953370033783966,
         0.0915282973239495,
         -0.0504927506996757,
         -0.00610234789577632,
         0.0594485991566283,
         -0.0924387680519849,
         0.0886300619975379,
         -0.0860043056219618,
         0.0370171169493946,
         0.0185419135206586,
         -0.053867557693743,
         0.0572099512900037,
         -0.0266181067224129,
         -0.0293689235121565,
         0.0846135386122074,
         -0.0218334700274494,
         0.135023468641648,
         -0.171447239343438,
         0.152720140731112,
         -0.103166081751728,
         0.0498175217011044,
         -0.0224154702238258,
         0.0534094873132389,
         -0.177957683311454,
         -0.0604783308535679,
         0.0254138793539061,
         0.0172968772814261,
         -0.046490243049967,
         0.0506889695438214,
         -0.0257281522606447,
         -0.0233645175011264,
         0.0747292039962398,
         -0.00932938641364368,
         0.00503639132505965,
         0.000404252194986568,
         -0.00268324451906289,
         0.000404252194986534,
         0.00503639132505966,
         -0.0093293864136438,
         0.0594407594958476,
         -0.0899780929386235,
         0.102756305096603,
         -0.0979682192996137,
         0.0779600929687544,
         -0.0467726752209736,
         0.143461925460508,
         -0.0826476977439786,
         0.0628612164481532,
         -0.0716019583059082,
         0.0956922624629283,
         -0.121277330477708,
         0.133825226321552,
         -0.118126876378572,
         0.0582960694456901,
         -0.0860043056219617,
         0.0370171169493948,
         0.0185419135206587,
         -0.0538675576937428,
         0.0572099512900041,
         -0.0266181067224128,
         -0.0293689235121566,
         0.0846135386122072,
         0.0886300619975381,
         -0.0924387680519845,
         0.059448599156628,
         -0.00610234789577627,
         -0.0504927506996757,
         0.0915282973239493,
         -0.0953370033783966,
         -0.0467726752209738,
         0.0779600929687545,
         -0.0979682192996136,
         0.102756305096603,
         -0.0899780929386237,
         0.0594407594958478,
         -0.00566533951666289,
         0.00895768829540614,
         -0.0101570638078621,
         0.00895768829540594,
         -0.0056653395166629},
        {-0.0622881531846615,
         0.0984862176545003,
         -0.111672874063366,
         0.0984862176545003,
         -0.0622881531846615,
         0.0766605539670172,
         -0.0771666031085551,
         0.0395886340372991,
         0.0130544636458991,
         -0.0549665234048265,
         0.0626199907468055,
         -0.0642078310252125,
         0.029921759334194,
         0.014754057183234,
         -0.0384086503274132,
         0.0292874208512894,
         0.00560279046990486,
         -0.0398888621609234,
         -0.0139290045354107,
         0.0740319537954265,
         -0.103532734788567,
         0.100614825886295,
         -0.0795775416986418,
         0.0594525036580216,
         -0.0556669524191069,
         0.068193650704248,
         0.112948735797675,
         -0.103099442235508,
         0.0635276984103702,
         -0.0147218991811812,
         -0.0302744188640311,
         0.0658625774081286,
         -0.0938887564048654,
         0.123643994078886,
         -0.171864186925727,
         0.0626199907468055,
         -0.0549665234048266,
         0.013054463645899,
         0.039588634037299,
         -0.077166603108555,
         0.0766605539670173,
         -0.0839833809274785,
         0.0274888537367174,
         0.0377726625555423,
         -0.0646320765577933,
         0.0377726625555423,
         0.0274888537367177,
         -0.0839833809274785,
         0.137181329490444,
         -0.0633403070743538,
         0.0378316252287827,
         -0.0686412205869174,
         0.121218537467245,
         -0.148784674029812,
         0.112703870932399,
         -0.00889459608428416,
         -0.0932501486733408,
         -0.0157030740281402,
         0.0175972947329985,
         0.00936640548647199,
         -0.0167663786415412,
         -0.0140395901729565,
         0.0719142827786227,
         -0.115941047913495,
         0.0754238012320459,
         -0.0139290045354107,
         0.0740319537954266,
         -0.103532734788566,
         0.100614825886295,
         -0.0795775416986421,
         0.0594525036580219,
         -0.055666952419107,
         0.0681936507042479,
         -0.0398888621609232,
         0.00560279046990492,
         0.0292874208512894,
         -0.0384086503274134,
         0.014754057183234,
         0.029921759334194,
         -0.0642078310252127,
         -0.00889459608428415,
         0.112703870932399,
         -0.148784674029812,
         0.121218537467245,
         -0.0686412205869174,
         0.0378316252287829,
         -0.0633403070743538,
         0.137181329490445,
         -0.0651532063448567,
         -0.0459463637533999,
         0.0136303254745033,
         0.0504284471181812,
         -0.0792262295866336,
         0.0504284471181813,
         0.0136303254745031,
         -0.0459463637533998,
         -0.065153206344857,
         0.137181329490444,
         -0.0633403070743537,
         0.0378316252287827,
         -0.0686412205869175,
         0.121218537467245,
         -0.148784674029812,
         0.112703870932398,
         -0.00889459608428414,
         -0.0642078310252127,
         0.0299217593341941,
         0.0147540571832339,
         -0.0384086503274134,
         0.0292874208512893,
         0.00560279046990469,
         -0.0398888621609232,
         0.0681936507042481,
         -0.055666952419107,
         0.0594525036580218,
         -0.0795775416986422,
         0.100614825886295,
         -0.103532734788567,
         0.0740319537954267,
         -0.0139290045354106,
         0.0754238012320457,
         -0.115941047913495,
         0.0719142827786226,
         -0.0140395901729564,
         -0.0167663786415413,
         0.00936640548647195,
         0.0175972947329987,
         -0.0157030740281401,
         -0.0932501486733409,
         -0.00889459608428409,
         0.112703870932399,
         -0.148784674029813,
         0.121218537467245,
         -0.0686412205869174,
         0.0378316252287828,
         -0.0633403070743538,
         0.137181329490445,
         -0.0839833809274785,
         0.0274888537367175,
         0.0377726625555422,
         -0.0646320765577934,
         0.0377726625555422,
         0.0274888537367175,
         -0.0839833809274785,
         0.0766605539670171,
         -0.077166603108555,
         0.0395886340372991,
         0.0130544636458991,
         -0.0549665234048264,
         0.0626199907468056,
         -0.171864186925727,
         0.123643994078886,
         -0.0938887564048654,
         0.0658625774081285,
         -0.0302744188640311,
         -0.0147218991811811,
         0.0635276984103702,
         -0.103099442235508,
         0.112948735797675,
         0.0681936507042479,
         -0.0556669524191071,
         0.0594525036580218,
         -0.0795775416986421,
         0.100614825886295,
         -0.103532734788566,
         0.0740319537954267,
         -0.0139290045354107,
         -0.0398888621609233,
         0.0056027904699047,
         0.0292874208512895,
         -0.0384086503274132,
         0.0147540571832338,
         0.0299217593341941,
         -0.0642078310252129,
         0.0626199907468056,
         -0.0549665234048265,
         0.0130544636458991,
         0.039588634037299,
         -0.0771666031085551,
         0.0766605539670171,
         -0.0622881531846614,
         0.0984862176545002,
         -0.111672874063366,
         0.0984862176545002,
         -0.0622881531846615},
        {-0.168817349124505,
         0.188743534211854,
         -0.123561647494187,
         0.168627176206953,
         -0.0603251562953437,
         -0.0725775849840141,
         0.113241038669936,
         -0.112902105874018,
         -0.0502546392877779,
         0.0975108176696168,
         -0.0185841343946091,
         -0.0698945567324847,
         0.0408663114956991,
         0.092586349891481,
         -0.0391915485346629,
         -0.0476174838508938,
         0.048065854336808,
         0.0278133381770654,
         0.000747520843860428,
         -0.05069817745769,
         -0.0428705233087591,
         0.0670034010839994,
         -0.0150162669189546,
         -0.0266135465070376,
         -0.00734415728583174,
         -0.000835753710734731,
         0.0433949096198886,
         -0.000390854479385245,
         -0.0470758046911682,
         0.0470828656821418,
         -0.0152569297095576,
         0.0161949508156115,
         0.000547129234540522,
         -0.0253699479613454,
         0.0181533420568786,
         0.0117229618492009,
         -0.0367550634440225,
         0.0410517032906277,
         -0.0495770567376638,
         0.085874956646024,
         0.0141969796146813,
         -0.112886300438442,
         0.123422455171103,
         -0.113556933131627,
         -0.0545290423287019,
         0.0734351309716522,
         0.0446530226857768,
         -0.142701662647405,
         0.107731375767198,
         0.0863470158106029,
         -0.00699411604663617,
         -0.0949916833665356,
         0.0439058858850803,
         0.108114865260279,
         -0.0513455494983316,
         -0.1163737457027,
         -0.0310775221857737,
         0.0495604356031209,
         0.0564860793586448,
         -0.0954467462625603,
         -0.0462805465394751,
         0.0623566213590927,
         0.0940184775317797,
         -0.0244931865292159,
         -0.0493818395491948,
         0.00121255822592034,
         0.0895739005818117,
         -0.0118668054067861,
         -0.0522542347028045,
         -0.0603647957362037,
         0.0601784501347292,
         0.00935714645521689,
         -0.0307389413622279,
         -0.0415694441473163,
         0.0378161268927405,
         0.0299110772773428,
         0.0280259742052697,
         -0.0608968723959939,
         0.0387934798629805,
         0.0038539852044293,
         0.00266337042602215,
         -0.00788859522538168,
         -0.0647083774595738,
         0.0506142116580252,
         0.0274493299809865,
         -0.0826358800188723,
         0.00752076221826969,
         0.0967664449518616,
         -0.0115291051698252,
         -0.0622064464077219,
         0.00449451508363857,
         0.120960707874747,
         -0.035117803299159,
         -0.0712936661981959,
         -0.0780558181985096,
         0.0763636510893588,
         0.0368646580587211,
         -0.0532935958997375,
         -0.121809863094102,
         0.0874768997220099,
         0.084922535445907,
         0.0183774037874078,
         -0.10053147408758,
         0.0183774037874079,
         0.084922535445907,
         0.0874768997220101,
         -0.121809863094102,
         -0.0532935958997373,
         0.0368646580587211,
         0.076363651089359,
         -0.0780558181985096,
         -0.0712936661981961,
         -0.0351178032991589,
         0.120960707874747,
         0.00449451508363851,
         -0.0622064464077219,
         -0.0115291051698252,
         0.0967664449518615,
         0.00752076221826966,
         -0.0826358800188723,
         0.0274493299809865,
         0.0506142116580252,
         -0.0647083774595737,
         -0.00788859522538167,
         0.00266337042602187,
         0.00385398520442928,
         0.0387934798629806,
         -0.0608968723959939,
         0.0280259742052697,
         0.0299110772773425,
         0.0378161268927405,
         -0.0415694441473162,
         -0.030738941362228,
         0.00935714645521685,
         0.0601784501347292,
         -0.0603647957362036,
         -0.0522542347028045,
         -0.0118668054067861,
         0.0895739005818116,
         0.00121255822592041,
         -0.0493818395491949,
         -0.0244931865292158,
         0.0940184775317797,
         0.0623566213590925,
         -0.046280546539475,
         -0.0954467462625602,
         0.0564860793586447,
         0.0495604356031212,
         -0.0310775221857738,
         -0.1163737457027,
         -0.0513455494983316,
         0.108114865260279,
         0.0439058858850803,
         -0.0949916833665355,
         -0.00699411604663614,
         0.086347015810603,
         0.107731375767198,
         -0.142701662647405,
         0.0446530226857768,
         0.0734351309716524,
         -0.054529042328702,
         -0.113556933131627,
         0.123422455171103,
         -0.112886300438442,
         0.0141969796146811,
         0.085874956646024,
         -0.0495770567376637,
         0.0410517032906276,
         -0.0367550634440224,
         0.011722961849201,
         0.0181533420568785,
         -0.0253699479613453,
         0.000547129234540393,
         0.0161949508156114,
         -0.0152569297095576,
         0.0470828656821416,
         -0.0470758046911682,
         -0.000390854479385195,
         0.0433949096198885,
         -0.000835753710735064,
         -0.00734415728583174,
         -0.0266135465070376,
         -0.0150162669189549,
         0.0670034010839993,
         -0.042870523308759,
         -0.0506981774576901,
         0.000747520843860421,
         0.0278133381770654,
         0.0480658543368079,
         -0.0476174838508936,
         -0.039191548534663,
         0.0925863498914809,
         0.0408663114956993,
         -0.0698945567324848,
         -0.018584134394609,
         0.0975108176696168,
         -0.050254639287778,
         -0.112902105874017,
         0.113241038669936,
         -0.0725775849840142,
         -0.0603251562953436,
         0.168627176206953,
         -0.123561647494187,
         0.188743534211854,
         -0.168817349124505},
        {0.049436169694151,
         -0.0552713179916682,
         0.0361835712081137,
         0.0588880971826752,
         -0.114935873831424,
         0.133322113997682,
         -0.0978641529827378,
         -0.116049909026904,
         0.0762926367231239,
         0.0265052862466541,
         -0.1191283105378,
         0.134449669128205,
         0.0965996017500775,
         0.0341298928498713,
         -0.102231397346408,
         0.061830110799902,
         0.0485559019268188,
         -0.130739428672654,
         -0.0458486810565953,
         -0.0786037442968551,
         0.0348341481265851,
         0.055029623551919,
         -0.0905191609973652,
         0.0263954726640237,
         0.0915088632557049,
         0.0512603837606269,
         0.0328744905392853,
         -0.0504670395736192,
         0.000179780780498786,
         0.0638674549747857,
         -0.0672780140161743,
         -0.0332953062922978,
         -0.0335577983907941,
         0.000394507972008005,
         0.0273629767227382,
         -0.0212937406188503,
         -0.0194876259116958,
         0.0605138487874587,
         -0.0235719492547956,
         -0.157748852652357,
         0.158245447427259,
         -0.104198051007386,
         0.0431016737522796,
         0.0814938411087293,
         -0.00483482298216981,
         -0.0376839779743938,
         0.025398104342674,
         0.00624730607926363,
         0.0161755991681227,
         -0.0271380762626927,
         -0.0115689819913896,
         0.0250393012837008,
         0.0176111685375789,
         -0.0741912667094567,
         -0.0388976217718333,
         -0.0544308869790374,
         0.0528842770933526,
         0.0144585456851082,
         -0.0582461668652342,
         0.00582984759443522,
         0.118842209246912,
         0.0800595760579603,
         0.0399973825114612,
         -0.089413095075563,
         0.0334495484946796,
         0.0596887774495548,
         -0.0616923837274433,
         -0.118552905439699,
         -0.0950625189866918,
         0.00957489872865971,
         0.0790236762565554,
         -0.0849442793970101,
         -0.00524008126652381,
         0.0925298687278473,
         0.0759562976804474,
         0.0707036687960248,
         -0.0441468116460865,
         -0.0243036353837454,
         0.0789244033632023,
         -0.059222786354102,
         -0.0567098817081052,
         0.141596725761029,
         -0.0368053498668719,
         -0.0695208303451698,
         0.111976540299492,
         -0.0849398360137697,
         -0.126090705208549,
         -0.05222840416528,
         0.0756139983598006,
         0.000156153810670514,
         -0.0753536091182037,
         0.0843745452557467,
         0.0388339450856627,
         0.0933340313142188,
         -0.0169745544368851,
         -0.0358203262668903,
         0.013921297861792,
         0.0337931696013141,
         -0.0395652206806926,
         -0.0138753464783618,
         -0.041693595718382,
         0.0144034854623077,
         0.00867014193245216,
         0.0144034854623077,
         -0.0416935957183821,
         -0.0138753464783618,
         -0.0395652206806925,
         0.0337931696013139,
         0.0139212978617919,
         -0.0358203262668902,
         -0.0169745544368852,
         0.0933340313142189,
         0.0388339450856628,
         0.0843745452557467,
         -0.0753536091182037,
         0.000156153810670539,
         0.0756139983598006,
         -0.05222840416528,
         -0.126090705208549,
         -0.0849398360137696,
         0.111976540299492,
         -0.0695208303451699,
         -0.0368053498668719,
         0.141596725761029,
         -0.0567098817081051,
         -0.0592227863541019,
         0.0789244033632023,
         -0.024303635383745,
         -0.0441468116460865,
         0.070703668796025,
         0.0759562976804474,
         0.0925298687278473,
         -0.00524008126652371,
         -0.0849442793970098,
         0.0790236762565553,
         0.00957489872865975,
         -0.0950625189866916,
         -0.118552905439699,
         -0.0616923837274435,
         0.0596887774495547,
         0.0334495484946797,
         -0.0894130950755631,
         0.0399973825114613,
         0.0800595760579603,
         0.118842209246912,
         0.00582984759443542,
         -0.0582461668652343,
         0.0144585456851083,
         0.0528842770933526,
         -0.0544308869790375,
         -0.0388976217718332,
         -0.0741912667094567,
         0.0176111685375789,
         0.0250393012837007,
         -0.0115689819913898,
         -0.0271380762626924,
         0.0161755991681227,
         0.00624730607926363,
         0.0253981043426741,
         -0.037683977974394,
         -0.00483482298216971,
         0.0814938411087293,
         0.0431016737522797,
         -0.104198051007386,
         0.158245447427259,
         -0.157748852652357,
         -0.0235719492547955,
         0.0605138487874585,
         -0.0194876259116959,
         -0.0212937406188502,
         0.0273629767227382,
         0.000394507972008012,
         -0.0335577983907942,
         -0.0332953062922977,
         -0.0672780140161744,
         0.0638674549747857,
         0.00017978078049873,
         -0.0504670395736191,
         0.0328744905392853,
         0.0512603837606271,
         0.091508863255705,
         0.0263954726640237,
         -0.0905191609973653,
         0.0550296235519189,
         0.034834148126585,
         -0.0786037442968551,
         -0.0458486810565954,
         -0.130739428672654,
         0.0485559019268189,
         0.0618301107999019,
         -0.102231397346408,
         0.0341298928498711,
         0.0965996017500772,
         0.134449669128205,
         -0.1191283105378,
         0.0265052862466541,
         0.076292636723124,
         -0.116049909026904,
         -0.0978641529827375,
         0.133322113997681,
         -0.114935873831424,
         0.0588880971826752,
         0.0361835712081135,
         -0.0552713179916681,
         0.0494361696941511},
        {-0.0248742849807494,
         0.0278102960543291,
         -0.0182061123954418,
         0.0216094848701587,
         -0.00492434307383811,
         -0.0140442828948449,
         0.0186197744023191,
         -0.0754588948310405,
         0.06825775588098,
         -0.0590325728593825,
         0.0544682723494662,
         -0.0429996701781809,
         0.140508257056759,
         -0.0646751126442702,
         -0.00331688311886027,
         0.050908117628939,
         -0.0781884175340996,
         0.0761329613175602,
         -0.158766788202878,
         -0.0345906953574811,
         0.0891119925965124,
         -0.0700514135488228,
         0.0148283332578463,
         0.0500792727948589,
         -0.0910755842406232,
         0.177506665495474,
         -0.0869709167863518,
         -0.00159586368549993,
         0.0507699802474272,
         -0.0498114725974302,
         -0.000199606481946204,
         0.0771035906389512,
         -0.116205390141745,
         0.11730389549789,
         -0.082072289426905,
         0.035765058601496,
         -0.000443380951943142,
         0.000505398414103497,
         -0.0672113560819739,
         0.0166174196204647,
         -0.00276332386887141,
         -0.0125297935978949,
         0.0158165233958759,
         0.0818822629720915,
         -0.129956202459312,
         0.124757256532088,
         -0.0791339506095096,
         0.0263533669102394,
         -0.124056451412658,
         0.100509672360368,
         -0.0197061426697458,
         -0.0490703489310824,
         0.0662951776643484,
         -0.0357159716042069,
         0.102905376503475,
         -0.0365355089848557,
         -0.0276054321732923,
         0.0401933327948128,
         -0.0158906951930153,
         -0.0051486821449504,
         -0.00375486042460099,
         -0.0137677595457879,
         0.0613279272973843,
         -0.0651791933008729,
         0.0506819088491498,
         -0.0335805904484236,
         0.00562578009663026,
         0.0484753351661783,
         -0.0832454231779054,
         0.0433491127122893,
         0.0161498899547564,
         -0.071052197808197,
         0.106524724269899,
         -0.0946777817828039,
         -0.0267241799285968,
         0.102841513733672,
         -0.132531800672027,
         0.121572319594128,
         -0.0751011880640824,
         3.03847497945056e-05,
         0.0816020223690442,
         -0.105382843170998,
         0.114675989169675,
         -0.104360315620473,
         0.0850196663335383,
         -0.0552302557276712,
         0.0544466431567094,
         -0.040521098166612,
         0.0475184948667677,
         -0.0505748679155134,
         0.03253809279156,
         -0.00200532400425748,
         -0.0214737276796658,
         0.0651596344887134,
         -0.0866223897552781,
         0.0466860369385175,
         0.0264759203622161,
         -0.0780405731466436,
         0.0671720519974625,
         -0.0628188323926812,
         0.00471658498009439,
         0.083149353884271,
         -0.122584856314029,
         0.0831493538842711,
         0.00471658498009451,
         -0.0628188323926812,
         0.0671720519974626,
         -0.0780405731466433,
         0.0264759203622163,
         0.0466860369385176,
         -0.0866223897552781,
         0.0651596344887134,
         -0.0214737276796657,
         -0.00200532400425759,
         0.0325380927915599,
         -0.0505748679155134,
         0.0475184948667677,
         -0.0405210981666119,
         0.0544466431567094,
         -0.0552302557276711,
         0.0850196663335382,
         -0.104360315620473,
         0.114675989169675,
         -0.105382843170998,
         0.0816020223690443,
         3.03847497944668e-05,
         -0.0751011880640823,
         0.121572319594128,
         -0.132531800672027,
         0.102841513733672,
         -0.0267241799285968,
         -0.094677781782804,
         0.106524724269899,
         -0.0710521978081971,
         0.0161498899547566,
         0.0433491127122894,
         -0.0832454231779055,
         0.0484753351661785,
         0.00562578009663012,
         -0.0335805904484236,
         0.0506819088491497,
         -0.0651791933008728,
         0.0613279272973844,
         -0.0137677595457879,
         -0.00375486042460111,
         -0.00514868214495045,
         -0.0158906951930153,
         0.0401933327948127,
         -0.0276054321732923,
         -0.0365355089848557,
         0.102905376503475,
         -0.0357159716042069,
         0.0662951776643483,
         -0.0490703489310825,
         -0.0197061426697456,
         0.100509672360368,
         -0.124056451412658,
         0.0263533669102392,
         -0.0791339506095095,
         0.124757256532088,
         -0.129956202459312,
         0.0818822629720915,
         0.015816523395876,
         -0.0125297935978948,
         -0.00276332386887141,
         0.0166174196204648,
         -0.0672113560819741,
         0.000505398414103551,
         -0.000443380951943173,
         0.0357650586014957,
         -0.0820722894269049,
         0.117303895497891,
         -0.116205390141745,
         0.0771035906389512,
         -0.00019960648194611,
         -0.0498114725974303,
         0.0507699802474273,
         -0.00159586368549982,
         -0.0869709167863519,
         0.177506665495474,
         -0.0910755842406233,
         0.0500792727948589,
         0.0148283332578462,
         -0.0700514135488228,
         0.0891119925965125,
         -0.0345906953574811,
         -0.158766788202878,
         0.07613296131756,
         -0.0781884175340995,
         0.0509081176289388,
         -0.0033168831188602,
         -0.0646751126442704,
         0.14050825705676,
         -0.0429996701781809,
         0.0544682723494662,
         -0.0590325728593824,
         0.0682577558809801,
         -0.0754588948310403,
         0.0186197744023187,
         -0.0140442828948449,
         -0.00492434307383802,
         0.0216094848701587,
         -0.018206112395442,
         0.0278102960543291,
         -0.0248742849807495},
        {-0.0298505352860599,
         0.0333739130321929,
         -0.021848354672414,
         0.0476504044183925,
         -0.0325082665568699,
         0.00562614512197341,
         0.0093658970507975,
         -0.0367317934554131,
         -0.0082876960659087,
         0.0351474153930112,
         -0.0303908176654026,
         0.0100230470598536,
         0.054675101043233,
         -0.0161415456531369,
         0.0226170830056945,
         -0.0471645154415485,
         0.0568909748392424,
         -0.0389242891061251,
         -0.0499312408232943,
         -0.0237213266000655,
         0.0349923475109205,
         -0.0470379030460097,
         0.0729688795949548,
         -0.0956643491975556,
         0.0870133867312525,
         0.0558248243408991,
         -0.0164977460675474,
         -0.0137850620147157,
         0.043938683338515,
         -0.0856315473420471,
         0.13512998290144,
         -0.16200307334339,
         -0.0365459261713976,
         0.0306247784459612,
         -0.0141045990894075,
         -0.0131408325359398,
         0.0601688417451935,
         -0.139315291932171,
         0.260949358955435,
         -0.00665694468257814,
         0.0292605747819464,
         -0.0425688061616861,
         0.0348765248609524,
         -0.0244548565228744,
         0.00202211922318102,
         -0.00365126192416566,
         0.0246464114067696,
         -0.0367906113779433,
         -0.0366219879848557,
         0.094259288322701,
         -0.0845461864981175,
         0.0551845116511687,
         -0.0428578002043216,
         0.0450066318127964,
         0.0195203963953858,
         -0.0107137019154597,
         -0.0695843938863817,
         0.115185296724359,
         -0.110875273576366,
         0.0861557496916908,
         -0.0681407204177488,
         0.0113992136064301,
         0.0151360059595579,
         0.0290381561399489,
         -0.0906790164692148,
         0.123490606737375,
         -0.117293732109426,
         0.0933622092506065,
         -0.0394737176458169,
         0.0192855608433607,
         -0.028005160823247,
         0.0661624751946163,
         -0.105698799991902,
         0.116233073178436,
         -0.0904894456052464,
         0.0400180763224198,
         -0.0461777570980078,
         0.0542994319652981,
         -0.0763395755454475,
         0.107711222113702,
         -0.122574813777148,
         0.0338691979769439,
         -0.0357160433137079,
         0.0139110880961514,
         0.0142083988218697,
         -0.026884919934501,
         0.0788498672057796,
         -0.0963098904036025,
         0.111223483428966,
         -0.0967371073408569,
         0.0471218085632827,
         0.00906684736040237,
         0.00901597865960221,
         -0.0642493261716975,
         0.0739901159257143,
         -0.0945010030226437,
         0.111377824918158,
         -0.088601981713353,
         0.0184117579873442,
         -0.0279474327942703,
         0.0847929713180604,
         -0.0834390574278832,
         0.0747421928407488,
         -0.0834390574278831,
         0.0847929713180603,
         -0.0279474327942702,
         0.0184117579873442,
         -0.088601981713353,
         0.111377824918159,
         -0.0945010030226436,
         0.0739901159257142,
         -0.0642493261716974,
         0.00901597865960209,
         0.00906684736040235,
         0.0471218085632827,
         -0.096737107340857,
         0.111223483428966,
         -0.0963098904036026,
         0.0788498672057795,
         -0.0268849199345011,
         0.0142083988218696,
         0.0139110880961514,
         -0.0357160433137078,
         0.0338691979769439,
         -0.122574813777148,
         0.107711222113702,
         -0.0763395755454476,
         0.0542994319652981,
         -0.0461777570980077,
         0.0400180763224199,
         -0.0904894456052465,
         0.116233073178436,
         -0.105698799991902,
         0.0661624751946166,
         -0.0280051608232469,
         0.0192855608433609,
         -0.039473717645817,
         0.0933622092506066,
         -0.117293732109426,
         0.123490606737375,
         -0.0906790164692148,
         0.0290381561399491,
         0.015136005959558,
         0.01139921360643,
         -0.0681407204177488,
         0.0861557496916908,
         -0.110875273576366,
         0.115185296724359,
         -0.0695843938863818,
         -0.0107137019154596,
         0.0195203963953861,
         0.0450066318127966,
         -0.0428578002043216,
         0.0551845116511689,
         -0.0845461864981175,
         0.0942592883227008,
         -0.0366219879848558,
         -0.036790611377943,
         0.0246464114067696,
         -0.00365126192416562,
         0.00202211922318115,
         -0.0244548565228742,
         0.0348765248609523,
         -0.0425688061616864,
         0.0292605747819467,
         -0.00665694468257822,
         0.260949358955435,
         -0.139315291932171,
         0.0601688417451937,
         -0.0131408325359398,
         -0.0141045990894073,
         0.0306247784459612,
         -0.0365459261713977,
         -0.16200307334339,
         0.13512998290144,
         -0.0856315473420473,
         0.043938683338515,
         -0.0137850620147159,
         -0.0164977460675477,
         0.0558248243408992,
         0.0870133867312526,
         -0.0956643491975555,
         0.0729688795949548,
         -0.0470379030460095,
         0.0349923475109205,
         -0.0237213266000654,
         -0.0499312408232942,
         -0.0389242891061251,
         0.0568909748392423,
         -0.0471645154415484,
         0.0226170830056946,
         -0.0161415456531369,
         0.0546751010432332,
         0.0100230470598536,
         -0.0303908176654024,
         0.0351474153930115,
         -0.00828769606590859,
         -0.0367317934554132,
         0.00936589705079738,
         0.0056261451219732,
         -0.0325082665568699,
         0.0476504044183927,
         -0.021848354672414,
         0.033373913032193,
         -0.02985053528606},
        {0.0543059120057697,
         -0.0718399689439118,
         0.0543059120057697,
         -0.00653649724683124,
         -0.044501166135523,
         0.0988070781412927,
         -0.102075326764708,
         -0.0391248919466793,
         0.0705088589600296,
         -0.0354483650224058,
         -0.0558771327672202,
         0.120742147332244,
         0.0539728508210126,
         -0.0266512322834256,
         -0.0480952158587619,
         0.0835435808811676,
         -0.0168878719975765,
         -0.10386523047571,
         -0.0427651944981445,
         -0.0211907784562277,
         0.0571821399641168,
         -0.0095784590326694,
         -0.0744566567758132,
         0.0791827804312668,
         0.0566950457130152,
         0.0290693709210154,
         0.0291625464840688,
         -0.00773939487542418,
         -0.0521172294171242,
         0.0616956884497935,
         0.0159269875817661,
         -0.09751226196786,
         0.0059488007695227,
         -0.0304907510108188,
         -0.0131133053707046,
         -0.0199539141696699,
         0.0276933090450943,
         0.0217494360435984,
         -0.0802791052376455,
         0.0643521176558797,
         0.0462163944639801,
         -0.0551395956182649,
         0.0403354722311087,
         -0.0173774456401142,
         0.0329231647201867,
         -0.054403541169492,
         0.0362066574321536,
         0.032634347995508,
         -0.101355990082245,
         0.0729428286992978,
         -0.0304907510108187,
         0.0319121311006221,
         -0.0475220421127433,
         0.0794911882164799,
         -0.107928841180507,
         0.104330390467006,
         -0.0551395956182649,
         -0.105956232856516,
         0.120534270646975,
         -0.0821341920091751,
         0.0291560755809167,
         0.0878120226581669,
         -0.0282647643881029,
         -0.0352792399833705,
         0.0392913898306134,
         0.00235949574107243,
         -0.0270077884414148,
         -0.0457958476094318,
         0.0453127012166431,
         0.00251118345602442,
         -0.00998552862413393,
         -0.0496562227875568,
         -0.0188678244776731,
         0.0306488505631236,
         0.0295409100639989,
         -0.0537792523512111,
         0.0112753354973581,
         0.00759196768790047,
         0.0935574501948758,
         0.0150052635028566,
         0.0402221111564848,
         -0.0709130226413931,
         0.0166541164982314,
         0.041408752956329,
         -0.0172610986345096,
         -0.0301068991552689,
         -0.119368641198051,
         0.0235703518035074,
         -0.0678509058865962,
         0.00418825112321523,
         0.0742090237138772,
         -0.0675556066569805,
         -0.0014442969578262,
         0.0121310385431568,
         0.0759760851360061,
         0.108555871192562,
         -0.0137953109020405,
         0.0943733270479572,
         -0.0780113370317097,
         -0.00877763317076535,
         0.0631398654027589,
         -0.0272670318511495,
         -0.0172350505664294,
         -0.123844224815284,
         -0.00776490590118016,
         -0.0698610408868829,
         0.108995220763274,
         -0.0717280474495497,
         0.00285589146622268,
         0.00640979591700276,
         0.0848546428417253,
         0.0195500818029339,
         0.0175479055049883,
         -0.0623637581036453,
         0.0727099509150455,
         -0.0313734722788245,
         -0.0305767072454442,
         0.0920521396397231,
         -0.053786423033656,
         -0.0179201316142493,
         0.0632242684371194,
         -0.0559559786158319,
         -0.119067007138064,
         0.020161886348514,
         0.0350642824504098,
         -0.00274904933970589,
         -0.0592072991642927,
         0.071543303077448,
         0.079458892404223,
         0.0617119374040013,
         -0.0639413397305319,
         0.010314999396991,
         -0.00886107977872317,
         0.0624193910086469,
         -0.0760391563841115,
         0.00142534028328057,
         -0.104733871256125,
         0.0287179051446382,
         0.0166145573910673,
         0.00305588460012727,
         -0.000668463887484514,
         -0.0662130858613644,
         0.075024959028017,
         -0.0603599637489828,
         0.0451113634970516,
         0.0537380030823974,
         -0.0430676803332469,
         0.0173312876607794,
         -0.043067680333247,
         0.0537380030823974,
         0.0451113634970515,
         -0.0603599637489828,
         0.075024959028017,
         -0.0662130858613643,
         -0.000668463887484654,
         0.00305588460012739,
         0.0166145573910674,
         0.0287179051446384,
         -0.104733871256125,
         0.0014253402832806,
         -0.0760391563841116,
         0.0624193910086469,
         -0.0088610797787233,
         0.0103149993969908,
         -0.0639413397305319,
         0.0617119374040013,
         0.079458892404223,
         0.071543303077448,
         -0.0592072991642926,
         -0.0027490493397059,
         0.0350642824504097,
         0.0201618863485138,
         -0.119067007138064,
         -0.0559559786158318,
         0.0632242684371195,
         -0.0179201316142492,
         -0.053786423033656,
         0.0920521396397231,
         -0.0305767072454443,
         -0.0313734722788245,
         0.0727099509150456,
         -0.0623637581036453,
         0.0175479055049884,
         0.0195500818029338,
         0.0848546428417253,
         0.00640979591700276,
         0.00285589146622286,
         -0.0717280474495496,
         0.108995220763274,
         -0.0698610408868827,
         -0.00776490590118006,
         -0.123844224815284,
         -0.0172350505664294,
         -0.0272670318511494,
         0.0631398654027589,
         -0.00877763317076547,
         -0.0780113370317096,
         0.0943733270479571,
         -0.0137953109020405,
         0.108555871192562,
         0.075976085136006,
         0.0121310385431568,
         -0.00144429695782615,
         -0.0675556066569805,
         0.0742090237138774,
         0.00418825112321494,
         -0.067850905886596,
         0.0235703518035072,
         -0.119368641198051,
         -0.0301068991552688,
         -0.0172610986345097,
         0.0414087529563292,
         0.0166541164982313,
         -0.0709130226413929,
         0.0402221111564849,
         0.0150052635028568,
         0.0935574501948757,
         0.00759196768790053,
         0.0112753354973581,
         -0.0537792523512112,
         0.029540910063999,
         0.0306488505631236,
         -0.018867824477673,
         -0.0496562227875571,
         -0.00998552862413407,
         0.00251118345602439,
         0.0453127012166431,
         -0.0457958476094316,
         -0.0270077884414149,
         0.0023594957410725,
         0.0392913898306134,
         -0.0352792399833706,
         -0.0282647643881029,
         0.0878120226581669,
         0.0291560755809168,
         -0.0821341920091748,
         0.120534270646975,
         -0.105956232856516,
         -0.0551395956182648,
         0.104330390467007,
         -0.107928841180507,
         0.0794911882164799,
         -0.0475220421127433,
         0.031912131100622,
         -0.0304907510108188,
         0.0729428286992976,
         -0.101355990082245,
         0.0326343479955079,
         0.0362066574321537,
         -0.0544035411694921,
         0.0329231647201869,
         -0.0173774456401144,
         0.0403354722311087,
         -0.0551395956182649,
         0.0462163944639803,
         0.0643521176558796,
         -0.0802791052376454,
         0.0217494360435982,
         0.0276933090450944,
         -0.0199539141696698,
         -0.0131133053707045,
         -0.0304907510108189,
         0.0059488007695229,
         -0.09751226196786,
         0.0159269875817661,
         0.0616956884497935,
         -0.0521172294171241,
         -0.0077393948754242,
         0.0291625464840688,
         0.0290693709210155,
         0.0566950457130151,
         0.0791827804312668,
         -0.0744566567758132,
         -0.00957845903266935,
         0.0571821399641167,
         -0.0211907784562278,
         -0.0427651944981443,
         -0.10386523047571,
         -0.0168878719975763,
         0.0835435808811676,
         -0.0480952158587622,
         -0.0266512322834252,
         0.0539728508210124,
         0.120742147332244,
         -0.0558771327672202,
         -0.0354483650224055,
         0.0705088589600295,
         -0.0391248919466793,
         -0.102075326764709,
         0.0988070781412929,
         -0.044501166135523,
         -0.00653649724683109,
         0.0543059120057696,
         -0.0718399689439116,
         0.0543059120057697},
        {0.0336214393744076,
         -0.0444769836523589,
         0.0336214393744076,
         -0.0482612494603808,
         0.0387704348161635,
         -0.00514899544175563,
         -0.0189816292884346,
         0.0189752769046113,
         0.0338410848912282,
         -0.0771426182670841,
         0.0725743816199281,
         -0.0300188986753251,
         0.0355431347894811,
         -0.0846615459154819,
         0.0628177183377406,
         0.0143248999293434,
         -0.0808351748641522,
         0.0796030813248942,
         -0.0849967189361555,
         0.0712964478456683,
         0.0159743475796012,
         -0.0830541299496415,
         0.0644671659879984,
         0.0268980740580572,
         -0.101841064623464,
         0.105567430651577,
         -0.00526097128635745,
         -0.0792501734897657,
         0.0666985769014725,
         0.016355553048169,
         -0.0799834059951755,
         0.0421856741932661,
         0.089833981813044,
         -0.086624331594357,
         -0.0717268143830083,
         0.0776921951023028,
         0.00155797838746321,
         -0.064833804297628,
         0.0493175642904511,
         0.0306658417047247,
         -0.0784999000497148,
         -0.0562510726698512,
         0.114593219442932,
         -0.0148975172113488,
         -0.0553797004526232,
         0.0512342986314497,
         0.00300955379250903,
         -0.0466663517016997,
         0.0222488273798639,
         0.074413174632524,
         -0.0866243315943571,
         0.0676812325371373,
         -0.0216009838967505,
         -0.0119109229550203,
         0.0105488459958765,
         0.0226681635266581,
         -0.056251072669851,
         -0.00307012980074663,
         -0.0191687530737763,
         0.0429427008486724,
         -0.0444777657490457,
         0.0724159419743764,
         -0.0773036712100929,
         0.0814206702424468,
         -0.0980074891842424,
         0.0986044303983148,
         -0.117828383953402,
         0.0770881994703072,
         -0.0329231709902815,
         -0.00251773169352844,
         0.0516491838215055,
         -0.101739337776826,
         0.114660066502878,
         -0.0203803154584846,
         -0.0177971661536389,
         0.0220704748940783,
         -0.0249556509080112,
         0.00803126669533424,
         0.0588599075744852,
         -0.0770416505174136,
         -0.0192752031378603,
         0.00810560770132692,
         0.00268541992960901,
         0.0123870412522125,
         -0.015626321333411,
         -0.00736445207771373,
         -0.0103477041607919,
         0.0344630646860248,
         0.0127030343946631,
         0.0131473472857547,
         0.0156674820521295,
         -0.0481814123725767,
         0.0284799454353021,
         0.0256961826935076,
         -0.0394431702297625,
         -0.00771789064037795,
         0.00955805525708496,
         0.0167104972425844,
         -0.0645090726165283,
         0.045638452102298,
         0.0290650078219327,
         -0.0823656765055287,
         0.0478655842164916,
         0.0513523508944359,
         -0.070810707543207,
         0.0394926219947605,
         0.0456968191981252,
         -0.104448352598068,
         0.0830465859070734,
         0.00805023534448429,
         -0.091127865828305,
         0.0880422398862195,
         -0.110928096274578,
         0.0735681515490688,
         0.00167894644409967,
         -0.0704226383418949,
         0.0872689205081162,
         -0.0780134626972608,
         0.126008925540326,
         -0.130331796846282,
         0.090148860898441,
         -0.0326536701735703,
         0.0477730130190906,
         -0.0602363486061305,
         0.0273495450201608,
         0.012530073661951,
         -0.0138176449135821,
         -0.0246168304913557,
         0.00548768679881347,
         0.0306130876779104,
         -0.0268193623580757,
         0.0231582602507462,
         -0.0310742480319807,
         0.00926982928723012,
         0.0742693517100577,
         -0.03448797845998,
         -0.0619067534760959,
         0.0488257300308978,
         -0.0143722774116823,
         -0.0196860742544455,
         0.0618242428963356,
         -0.0684305405085668,
         -0.0710177573285411,
         0.0260393755657657,
         0.095210932845979,
         -0.00859962749249527,
         -0.047546985735185,
         0.0604483980750466,
         -0.047546985735185,
         -0.00859962749249532,
         0.0952109328459789,
         0.0260393755657655,
         -0.0710177573285412,
         -0.0684305405085668,
         0.0618242428963357,
         -0.0196860742544455,
         -0.0143722774116825,
         0.048825730030898,
         -0.0619067534760961,
         -0.0344879784599801,
         0.0742693517100578,
         0.00926982928723001,
         -0.0310742480319809,
         0.0231582602507461,
         -0.0268193623580756,
         0.0306130876779103,
         0.00548768679881339,
         -0.0246168304913556,
         -0.0138176449135822,
         0.0125300736619511,
         0.0273495450201607,
         -0.0602363486061304,
         0.0477730130190906,
         -0.0326536701735703,
         0.090148860898441,
         -0.130331796846282,
         0.126008925540326,
         -0.0780134626972607,
         0.087268920508116,
         -0.0704226383418949,
         0.00167894644409971,
         0.0735681515490688,
         -0.110928096274578,
         0.0880422398862194,
         -0.0911278658283049,
         0.00805023534448436,
         0.0830465859070735,
         -0.104448352598068,
         0.0456968191981254,
         0.0394926219947604,
         -0.0708107075432072,
         0.0513523508944359,
         0.0478655842164917,
         -0.0823656765055286,
         0.0290650078219325,
         0.0456384521022981,
         -0.0645090726165284,
         0.0167104972425843,
         0.00955805525708496,
         -0.00771789064037791,
         -0.0394431702297625,
         0.0256961826935075,
         0.0284799454353021,
         -0.0481814123725767,
         0.0156674820521295,
         0.0131473472857546,
         0.0127030343946633,
         0.0344630646860246,
         -0.010347704160792,
         -0.00736445207771368,
         -0.0156263213334109,
         0.0123870412522125,
         0.00268541992960896,
         0.00810560770132691,
         -0.0192752031378603,
         -0.0770416505174138,
         0.0588599075744852,
         0.00803126669533424,
         -0.0249556509080113,
         0.0220704748940781,
         -0.0177971661536387,
         -0.0203803154584847,
         0.114660066502878,
         -0.101739337776826,
         0.0516491838215054,
         -0.00251773169352852,
         -0.0329231709902815,
         0.0770881994703073,
         -0.117828383953402,
         0.0986044303983147,
         -0.0980074891842424,
         0.0814206702424467,
         -0.0773036712100928,
         0.0724159419743765,
         -0.0444777657490457,
         0.0429427008486725,
         -0.0191687530737764,
         -0.00307012980074664,
         -0.0562510726698511,
         0.0226681635266581,
         0.0105488459958765,
         -0.0119109229550202,
         -0.0216009838967506,
         0.0676812325371373,
         -0.0866243315943573,
         0.0744131746325239,
         0.0222488273798639,
         -0.0466663517016995,
         0.00300955379250916,
         0.0512342986314497,
         -0.0553797004526233,
         -0.0148975172113487,
         0.114593219442932,
         -0.0562510726698511,
         -0.0784999000497151,
         0.0306658417047246,
         0.049317564290451,
         -0.0648338042976279,
         0.00155797838746332,
         0.0776921951023026,
         -0.0717268143830084,
         -0.0866243315943571,
         0.0898339818130441,
         0.0421856741932662,
         -0.0799834059951755,
         0.0163555530481691,
         0.0666985769014724,
         -0.0792501734897657,
         -0.00526097128635743,
         0.105567430651577,
         -0.101841064623465,
         0.0268980740580571,
         0.0644671659879985,
         -0.0830541299496413,
         0.015974347579601,
         0.0712964478456682,
         -0.0849967189361556,
         0.0796030813248941,
         -0.0808351748641525,
         0.0143248999293435,
         0.0628177183377408,
         -0.0846615459154819,
         0.0355431347894813,
         -0.0300188986753252,
         0.0725743816199281,
         -0.0771426182670844,
         0.0338410848912281,
         0.0189752769046114,
         -0.0189816292884345,
         -0.00514899544175574,
         0.0387704348161634,
         -0.0482612494603809,
         0.0336214393744076,
         -0.0444769836523588,
         0.0336214393744077},
        {-0.000890421773024286,
         0.00117791728668952,
         -0.000890421773024197,
         -0.0348608358787632,
         0.0531816755911689,
         -0.0540720973641929,
         0.0366416794248117,
         0.0588690976073748,
         -0.0469636650035143,
         7.01150897366308e-05,
         0.0476252718009099,
         -0.0607774950949088,
         -0.0769316150861221,
         0.0333359174626956,
         0.0134077484110815,
         -0.0134778635008181,
         -0.0339049102884221,
         0.0791019425689052,
         0.0936088432333842,
         -0.0187737009763181,
         -0.0174051777598396,
         0.0042136605092262,
         0.00948043415206033,
         0.0259730099992047,
         -0.100696108619993,
         -0.0978625174969477,
         -0.018548634889752,
         0.0434710395434213,
         -0.0274758308037527,
         0.0232621702945264,
         -0.0315488665868843,
         0.000445528615678731,
         0.120018081894389,
         0.0702295408846552,
         0.0765642353607665,
         -0.0555320603273295,
         0.012061020783908,
         0.014004840999674,
         -0.036073273434498,
         0.0676221400213824,
         -0.068127321986689,
         -0.111899800854894,
         -0.0929049499355201,
         -0.00633469447611168,
         0.0545613492108386,
         -0.061852414684517,
         0.0501351240421242,
         -0.021033424088155,
         -0.0437724788682054,
         0.148029522409852,
         0.0702295408846549,
         -0.0425965642723621,
         0.001131215450759,
         0.0380457366322321,
         -0.0735271437003352,
         0.1037815198154,
         -0.111899800854894,
         0.0511895367168742,
         -0.0761546818014898,
         0.0755250585276682,
         -0.0499302901692309,
         -0.0321827981802974,
         0.0243462685944617,
         0.00153465328047149,
         -0.0262136448485908,
         0.0317709957321073,
         0.03156129612093,
         -0.0489556887054708,
         0.0592701060031825,
         -0.0606565955497389,
         0.0513821885979405,
         -0.0318979494521289,
         -0.0461191366198778,
         0.0762356274634518,
         -0.0534272671505157,
         -0.00927329476648729,
         0.0723688027733667,
         -0.094130771753563,
         0.057362783957503,
         0.0437011316966597,
         -0.0510818533504296,
         -0.0231626603726403,
         0.0889377517479567,
         -0.0815488632480167,
         0.000755462720988732,
         0.0863124957232191,
         -0.0799834203262955,
         -0.0105808543053145,
         0.0106825478071816,
         0.0602866071279065,
         -0.0563634638766718,
         -0.0202867227881904,
         0.0914324272196596,
         -0.077356476513327,
         -0.0260448327803845,
         0.0676441248487102,
         -0.0337885031411858,
         -0.0274964683471414,
         -0.00985893711439768,
         0.0574302333068604,
         -0.0444477135233927,
         -0.0275753192027102,
         0.0828359183633906,
         -0.0223410792751456,
         0.0834482877403431,
         -0.0283963824866612,
         0.00760611955658357,
         -0.0276041383472651,
         0.0446625913268212,
         -0.0145638496311751,
         -0.0567840287227745,
         -0.0887387148930004,
         0.0931325029972584,
         -0.0832366697487611,
         0.0837044964016786,
         -0.0945058429381014,
         0.0906060911471299,
         -0.0562973855082294,
         0.0446825430545112,
         -0.000810299531988018,
         -0.0428897958551405,
         0.0544738348848447,
         0.0105468055882579,
         0.0674925424482911,
         -0.130384219430941,
         0.13003838663434,
         -0.0673142267575546,
         -0.00928071416350009,
         0.0252149193926615,
         -0.0791073756624193,
         0.0591078774658691,
         0.0184632880279175,
         -0.0930907473470574,
         0.106061246141485,
         -0.0441063871696413,
         -0.00933884054701539,
         0.0144720896349715,
         0.0233815921058201,
         -0.0529079925195876,
         0.0404713722664056,
         0.0102810965542542,
         -0.0607818946264051,
         0.0584059786108784,
         -0.0311438116955943,
         0.0080635248890081,
         0.00807994234484782,
         -0.0193533362686906,
         0.0235481159421277,
         -0.0193533362686906,
         0.00807994234484779,
         0.00806352488900818,
         -0.0311438116955944,
         0.0584059786108785,
         -0.060781894626405,
         0.010281096554254,
         0.0404713722664058,
         -0.0529079925195876,
         0.0233815921058201,
         0.0144720896349714,
         -0.00933884054701531,
         -0.0441063871696414,
         0.106061246141485,
         -0.0930907473470574,
         0.0184632880279175,
         0.0591078774658691,
         -0.0791073756624192,
         0.0252149193926615,
         -0.00928071416350017,
         -0.0673142267575544,
         0.13003838663434,
         -0.130384219430941,
         0.0674925424482912,
         0.0105468055882579,
         0.0544738348848446,
         -0.0428897958551404,
         -0.00081029953198818,
         0.0446825430545112,
         -0.0562973855082294,
         0.0906060911471297,
         -0.0945058429381013,
         0.0837044964016786,
         -0.083236669748761,
         0.0931325029972585,
         -0.0887387148930005,
         -0.0567840287227743,
         -0.0145638496311751,
         0.0446625913268215,
         -0.027604138347265,
         0.00760611955658359,
         -0.0283963824866612,
         0.0834482877403431,
         -0.0223410792751457,
         0.0828359183633905,
         -0.0275753192027101,
         -0.0444477135233928,
         0.0574302333068602,
         -0.00985893711439784,
         -0.0274964683471414,
         -0.0337885031411858,
         0.0676441248487104,
         -0.0260448327803847,
         -0.077356476513327,
         0.0914324272196596,
         -0.0202867227881903,
         -0.0563634638766719,
         0.0602866071279064,
         0.0106825478071818,
         -0.0105808543053145,
         -0.0799834203262954,
         0.0863124957232192,
         0.000755462720988794,
         -0.0815488632480167,
         0.0889377517479568,
         -0.0231626603726404,
         -0.0510818533504298,
         0.0437011316966598,
         0.0573627839575031,
         -0.0941307717535631,
         0.0723688027733668,
         -0.0092732947664872,
         -0.0534272671505157,
         0.0762356274634516,
         -0.0461191366198776,
         -0.0318979494521289,
         0.0513821885979405,
         -0.060656595549739,
         0.0592701060031824,
         -0.0489556887054708,
         0.03156129612093,
         0.0317709957321074,
         -0.0262136448485909,
         0.00153465328047142,
         0.0243462685944617,
         -0.0321827981802973,
         -0.0499302901692311,
         0.075525058527668,
         -0.0761546818014898,
         0.0511895367168742,
         -0.111899800854894,
         0.1037815198154,
         -0.073527143700335,
         0.0380457366322321,
         0.00113121545075905,
         -0.0425965642723622,
         0.0702295408846551,
         0.148029522409852,
         -0.0437724788682054,
         -0.021033424088155,
         0.050135124042124,
         -0.061852414684517,
         0.0545613492108385,
         -0.00633469447611149,
         -0.0929049499355203,
         -0.111899800854894,
         -0.0681273219866891,
         0.0676221400213826,
         -0.036073273434498,
         0.014004840999674,
         0.012061020783908,
         -0.0555320603273298,
         0.0765642353607667,
         0.070229540884655,
         0.120018081894389,
         0.000445528615678674,
         -0.0315488665868843,
         0.0232621702945264,
         -0.0274758308037526,
         0.0434710395434216,
         -0.018548634889752,
         -0.0978625174969475,
         -0.100696108619994,
         0.0259730099992048,
         0.00948043415206037,
         0.00421366050922624,
         -0.0174051777598395,
         -0.018773700976318,
         0.0936088432333842,
         0.0791019425689052,
         -0.0339049102884222,
         -0.0134778635008181,
         0.0134077484110814,
         0.0333359174626958,
         -0.0769316150861221,
         -0.0607774950949088,
         0.0476252718009099,
         7.01150897367036e-05,
         -0.0469636650035142,
         0.0588690976073748,
         0.0366416794248114,
         -0.0540720973641929,
         0.0531816755911688,
         -0.0348608358787632,
         -0.00089042177302434,
         0.00117791728668974,
         -0.000890421773024261},
        {-0.109413388162106,
         0.144740307588955,
         -0.109413388162106,
         0.110746388933641,
         -0.0567061952383555,
         -0.0527071929237502,
         0.10808038739057,
         -0.0862169733481692,
         -0.0101826974853005,
         0.0682522889048874,
         -0.0137094860242395,
         -0.081755899504639,
         0.0601296183491966,
         0.0342521856121964,
         -0.0293930985093973,
         -0.0388591903954903,
         0.0455178916834366,
         0.0487724139754483,
         -0.048652150811132,
         -0.0220950481933596,
         -0.0145305584506034,
         0.0462995997191698,
         -0.00506446656451045,
         -0.0412806549531924,
         -0.0238902017468864,
         0.0579935888659309,
         0.000207497926903775,
         0.0261733531915476,
         -0.0122725832370712,
         -0.0340270164820987,
         0.037345328783567,
         0.0105781467881129,
         0.0205579252582826,
         -0.0735025393834982,
         -0.0134878439153986,
         0.0132525633816206,
         -0.039425916573168,
         0.0510687113141122,
         -0.0187878490950559,
         -0.0185574796885111,
         0.00656298865996117,
         -0.0373998765473847,
         0.0972347199702335,
         -0.0600146954680997,
         0.0412403240919927,
         -0.00613791826602661,
         -0.0365892310970996,
         0.0551377614921413,
         -0.0439628652073457,
         0.0494753862044482,
         -0.0735025393834983,
         0.089011489901065,
         -0.100555026617305,
         0.0992768346493812,
         -0.0802541513965897,
         0.0542418278364869,
         -0.0373998765473846,
         0.0754818009522623,
         -0.0358557527063723,
         -0.0415111960156486,
         0.0792520964917795,
         -0.0863392663215163,
         -0.0172769570172326,
         0.0770053655417529,
         -0.0153918092474737,
         -0.0887238105928861,
         0.0652328305661661,
         0.0720385586366554,
         -0.0633827084886314,
         -0.0367040780025015,
         0.0497176149462371,
         0.0793498348833835,
         -0.0187646661893652,
         -0.112220307450078,
         0.0341363111284297,
         0.0412559166453539,
         0.0130601049590898,
         -0.0784493586793391,
         -0.0500417988684086,
         -0.0386577672309409,
         0.115211227270481,
         0.0153019696530771,
         -0.0452627526809305,
         -0.0166989744250421,
         0.00504683147412445,
         0.0977018851717576,
         -0.00127444343500082,
         0.0739071121926195,
         -0.053791475291867,
         -0.0840231919656165,
         0.0555552626833603,
         -0.00480404392690678,
         0.0367203627370442,
         -0.0596449470311316,
         -0.0627853986075032,
         0.0502638222520709,
         -0.0588865242564262,
         0.112717383880189,
         -0.0216315150514762,
         -0.0145510868790816,
         -0.00373001888869414,
         -0.023931900603121,
         0.10468662765219,
         -0.0489500270559107,
         0.00691238022392357,
         -0.0757244434519835,
         0.0630106052079913,
         -0.0448578355298895,
         0.0678222067996857,
         -0.0866035145373785,
         0.0225043207337153,
         0.0300411758723863,
         -0.0109145131373726,
         0.0142499060096558,
         -0.0311442309866049,
         0.0288533549299375,
         0.00262759039231997,
         -0.038114286237505,
         -0.00510517919699691,
         0.0292618292196559,
         -0.00184000747999963,
         -0.0422444380684146,
         0.0579884179205735,
         0.0211985449466798,
         -0.0101675313369167,
         -0.0537994233340974,
         0.0546059909895909,
         0.0407778999200144,
         -0.0804852216350814,
         -0.0124769223484032,
         -0.0534460772434232,
         0.101898055626361,
         -0.031553505047928,
         -0.0465185527110385,
         -0.0507630074479944,
         0.0992426048516831,
         0.00569288411624452,
         0.0811578125060476,
         -0.0518103769877193,
         -0.0674554026660451,
         0.0867747830169924,
         0.0152831457507904,
         0.0787669151341269,
         -0.0902971637257686,
         -0.0331405639283489,
         -0.0490871868764036,
         -0.0452952552339346,
         0.121897062879777,
         -0.0452952552339346,
         -0.0490871868764037,
         -0.0331405639283489,
         -0.0902971637257684,
         0.078766915134127,
         0.0152831457507904,
         0.0867747830169924,
         -0.0674554026660452,
         -0.0518103769877194,
         0.0811578125060478,
         0.00569288411624452,
         0.0992426048516831,
         -0.0507630074479945,
         -0.0465185527110383,
         -0.0315535050479279,
         0.101898055626361,
         -0.0534460772434231,
         -0.0124769223484031,
         -0.0804852216350813,
         0.0407778999200146,
         0.0546059909895908,
         -0.0537994233340974,
         -0.0101675313369165,
         0.0211985449466799,
         0.0579884179205735,
         -0.0422444380684146,
         -0.00184000747999962,
         0.0292618292196557,
         -0.00510517919699698,
         -0.0381142862375049,
         0.0026275903923201,
         0.0288533549299375,
         -0.0311442309866047,
         0.0142499060096558,
         -0.0109145131373727,
         0.0300411758723862,
         0.0225043207337153,
         -0.0866035145373783,
         0.0678222067996857,
         -0.0448578355298895,
         0.0630106052079913,
         -0.0757244434519835,
         0.0069123802239234,
         -0.0489500270559109,
         0.10468662765219,
         -0.023931900603121,
         -0.00373001888869407,
         -0.0145510868790816,
         -0.0216315150514762,
         0.112717383880189,
         -0.0588865242564262,
         0.0502638222520708,
         -0.062785398607503,
         -0.0596449470311315,
         0.0367203627370443,
         -0.00480404392690657,
         0.0555552626833605,
         -0.0840231919656165,
         -0.053791475291867,
         0.0739071121926193,
         -0.00127444343500062,
         0.0977018851717575,
         0.0050468314741243,
         -0.0166989744250421,
         -0.0452627526809306,
         0.015301969653077,
         0.115211227270481,
         -0.0386577672309409,
         -0.0500417988684086,
         -0.0784493586793392,
         0.0130601049590899,
         0.0412559166453539,
         0.0341363111284298,
         -0.112220307450077,
         -0.0187646661893653,
         0.0793498348833834,
         0.0497176149462371,
         -0.0367040780025016,
         -0.0633827084886314,
         0.0720385586366554,
         0.0652328305661664,
         -0.088723810592886,
         -0.0153918092474737,
         0.077005365541753,
         -0.0172769570172327,
         -0.0863392663215162,
         0.0792520964917796,
         -0.0415111960156485,
         -0.0358557527063723,
         0.0754818009522624,
         -0.0373998765473846,
         0.0542418278364868,
         -0.0802541513965899,
         0.0992768346493814,
         -0.100555026617305,
         0.0890114899010652,
         -0.0735025393834982,
         0.0494753862044483,
         -0.0439628652073456,
         0.0551377614921412,
         -0.0365892310970995,
         -0.0061379182660267,
         0.0412403240919927,
         -0.0600146954680997,
         0.0972347199702335,
         -0.0373998765473848,
         0.00656298865996091,
         -0.0185574796885111,
         -0.0187878490950558,
         0.0510687113141123,
         -0.0394259165731679,
         0.0132525633816206,
         -0.0134878439153987,
         -0.073502539383498,
         0.0205579252582826,
         0.010578146788113,
         0.0373453287835669,
         -0.0340270164820986,
         -0.0122725832370712,
         0.0261733531915476,
         0.000207497926903641,
         0.057993588865931,
         -0.0238902017468864,
         -0.0412806549531926,
         -0.00506446656451045,
         0.0462995997191698,
         -0.0145305584506035,
         -0.0220950481933596,
         -0.0486521508111319,
         0.0487724139754482,
         0.0455178916834366,
         -0.0388591903954903,
         -0.0293930985093971,
         0.0342521856121963,
         0.0601296183491965,
         -0.0817558995046389,
         -0.0137094860242396,
         0.0682522889048873,
         -0.0101826974853005,
         -0.0862169733481691,
         0.108080387390571,
         -0.05270719292375,
         -0.0567061952383556,
         0.110746388933641,
         -0.109413388162105,
         0.144740307588955,
         -0.109413388162106},
        {-0.0535977507647971,
         -0.0388247116423502,
         0.0924224624071475,
         0.0584646335246738,
         -0.0253550301236848,
         -0.0727825405248232,
         -0.0661811968723215,
         0.0109128685411544,
         0.0168621753487759,
         0.0608591819901473,
         0.0305080148335438,
         0.050449497852244,
         -0.0672191045111225,
         0.0445001910446224,
         -0.092325568841897,
         0.0554150919210417,
         -0.110926253838304,
         0.071064125041322,
         -0.0097017586479235,
         -0.0317664773158179,
         0.116931776364264,
         -0.171923356678699,
         0.116508264757657,
         -0.0305851580030718,
         -0.0196647667127357,
         0.0265249460421178,
         -0.00191873851975019,
         -0.115013037844514,
         0.0924224624071473,
         -0.0388247116423502,
         -0.0253550301236848,
         -0.0208645476275908,
         -0.0253550301236848,
         0.0109128685411543,
         -0.0411645570827628,
         0.0816690265926776,
         0.0168621753487759,
         0.0504494978522439,
         -0.0205982939005297,
         0.0592047417749104,
         -0.147638672762998,
         0.0445001910446224,
         -0.110926253838304,
         0.0413507990132096,
         -0.0618112433511658,
         0.0501375862013572,
         0.0704031410090103,
         -0.0317664773158177,
         0.116508264757657,
         -0.0287181787543898,
         0.0732904864957657,
         -0.0671147240601155,
         0.0282057584872586,
         -0.0740026919739017,
         -0.0019187385197502,
         0.0554150919210416,
         -0.110926253838304,
         0.071064125041322,
         -0.00970175864792342,
         -0.0317664773158178,
         0.116931776364264,
         -0.0727825405248235,
         -0.0253550301236848,
         0.0584646335246738,
         0.0168621753487759,
         0.0816690265926777,
         -0.041164557082763,
         0.0109128685411545,
         -0.0672191045111224,
         0.0592047417749104,
         -0.105360014672688,
         0.0592047417749103,
         -0.0672191045111225,
         0.0710641250413218,
         -0.0618112433511658,
         0.0234535733195054,
         0.0278601537175383,
         0.0501375862013574,
         -0.0097017586479234,
         -0.0305851580030719,
         0.0732904864957658,
         -0.0469304609272261,
         0.0799025747591783,
         -0.153531873378955,
         0.0282057584872588,
         0.0265249460421178,
         -0.110926253838304,
         0.0413507990132095,
         -0.0618112433511657,
         0.0501375862013573,
         0.0704031410090104,
         -0.0317664773158177,
         0.0305080148335436,
         0.0504494978522439,
         -0.0672191045111226,
         0.0445001910446227,
         -0.0923255688418969,
         0.0608591819901473,
         0.016862175348776,
         0.0109128685411545,
         -0.0661811968723215,
         0.0445001910446227,
         -0.147638672762998,
         0.0592047417749105,
         -0.0205982939005296,
         0.050449497852244,
         -0.0097017586479235,
         0.0501375862013573,
         0.0278601537175383,
         0.0234535733195054,
         -0.0618112433511656,
         0.071064125041322,
         -0.0196647667127358,
         -0.0671147240601153,
         0.0799025747591785,
         -0.131216301796222,
         0.0799025747591785,
         -0.0671147240601153,
         -0.019664766712736,
         0.071064125041322,
         -0.0618112433511658,
         0.0234535733195053,
         0.0278601537175383,
         0.0501375862013572,
         -0.00970175864792346,
         0.0504494978522438,
         -0.0205982939005296,
         0.0592047417749104,
         -0.147638672762999,
         0.0445001910446226,
         -0.0661811968723214,
         0.0109128685411545,
         0.0168621753487759,
         0.0608591819901474,
         -0.092325568841897,
         0.0445001910446226,
         -0.0672191045111224,
         0.050449497852244,
         0.0305080148335438,
         -0.0317664773158178,
         0.0704031410090104,
         0.0501375862013574,
         -0.0618112433511658,
         0.0413507990132096,
         -0.110926253838304,
         0.0265249460421177,
         0.0282057584872587,
         -0.153531873378955,
         0.0799025747591786,
         -0.0469304609272259,
         0.0732904864957657,
         -0.0305851580030715,
         -0.00970175864792341,
         0.0501375862013573,
         0.0278601537175383,
         0.0234535733195052,
         -0.0618112433511657,
         0.071064125041322,
         -0.0672191045111225,
         0.0592047417749103,
         -0.105360014672689,
         0.0592047417749105,
         -0.0672191045111225,
         0.0109128685411544,
         -0.041164557082763,
         0.0816690265926776,
         0.0168621753487759,
         0.0584646335246739,
         -0.0253550301236848,
         -0.0727825405248233,
         0.116931776364264,
         -0.0317664773158178,
         -0.00970175864792337,
         0.0710641250413221,
         -0.110926253838304,
         0.0554150919210416,
         -0.00191873851975029,
         -0.0740026919739015,
         0.0282057584872588,
         -0.0671147240601152,
         0.0732904864957656,
         -0.0287181787543897,
         0.116508264757657,
         -0.031766477315818,
         0.0704031410090104,
         0.0501375862013572,
         -0.0618112433511658,
         0.0413507990132094,
         -0.110926253838304,
         0.0445001910446225,
         -0.147638672762998,
         0.0592047417749104,
         -0.0205982939005294,
         0.0504494978522441,
         0.016862175348776,
         0.0816690265926777,
         -0.041164557082763,
         0.0109128685411544,
         -0.0253550301236849,
         -0.0208645476275908,
         -0.0253550301236849,
         -0.0388247116423501,
         0.0924224624071473,
         -0.115013037844514,
         -0.00191873851975025,
         0.0265249460421177,
         -0.0196647667127359,
         -0.0305851580030717,
         0.116508264757657,
         -0.171923356678699,
         0.116931776364264,
         -0.0317664773158179,
         -0.00970175864792352,
         0.0710641250413221,
         -0.110926253838304,
         0.0554150919210417,
         -0.0923255688418968,
         0.0445001910446226,
         -0.0672191045111225,
         0.050449497852244,
         0.0305080148335437,
         0.0608591819901475,
         0.0168621753487761,
         0.0109128685411544,
         -0.0661811968723215,
         -0.0727825405248234,
         -0.0253550301236847,
         0.0584646335246739,
         0.0924224624071473,
         -0.0388247116423501,
         -0.0535977507647971},
        {0.00641440806980907,
         -0.0474424439677582,
         0.0410280358979489,
         0.0452550263371674,
         0.00282394401815939,
         -0.0432154535285397,
         -0.0354598795959514,
         -0.0138524293668623,
         0.0107589536871068,
         0.0356077244179142,
         0.0592690478903648,
         -0.0336712487107828,
         0.0520595809974799,
         -0.058282631764752,
         0.00560431972834047,
         -0.103194662418713,
         0.0567077245134063,
         -0.0284489510907797,
         -0.0190747269868653,
         0.0706172839621342,
         -0.0603042326762896,
         -0.00172461988247592,
         0.104919282301189,
         -0.148844896829537,
         0.168961343063472,
         -0.155473474261777,
         0.100773561313828,
         -0.0404693286375386,
         0.0410280358979489,
         -0.0474424439677581,
         0.00282394401815934,
         0.00276871201882465,
         0.00282394401815928,
         -0.0138524293668622,
         -0.0293104289057199,
         0.0243542992563044,
         0.0107589536871069,
         -0.0336712487107829,
         0.10266850966721,
         -0.0696297055682334,
         0.0316009056533444,
         -0.0582826317647521,
         0.0567077245134062,
         -0.0848600688487851,
         0.00657346760007961,
         0.0262445552191054,
         -0.0143467530157465,
         0.0706172839621343,
         0.104919282301189,
         -0.0749339774297227,
         0.11586843175016,
         -0.101752712992213,
         0.0912826902852509,
         -0.131635850217454,
         0.100773561313828,
         -0.103194662418713,
         0.0567077245134062,
         -0.0284489510907798,
         -0.0190747269868653,
         0.0706172839621344,
         -0.0603042326762896,
         -0.0432154535285395,
         0.00282394401815925,
         0.0452550263371673,
         0.0107589536871071,
         0.0243542992563044,
         -0.0293104289057199,
         -0.0138524293668623,
         0.0520595809974799,
         -0.0696297055682334,
         0.0812316504737445,
         -0.0696297055682334,
         0.0520595809974799,
         -0.0284489510907799,
         0.0065734676000797,
         -0.033593861814067,
         0.0159251453605966,
         0.0262445552191054,
         -0.0190747269868652,
         -0.148844896829537,
         0.11586843175016,
         -0.0382092358725604,
         0.0658023702106393,
         -0.105685407079892,
         0.0912826902852508,
         -0.155473474261778,
         0.0567077245134064,
         -0.0848600688487851,
         0.00657346760007961,
         0.0262445552191054,
         -0.0143467530157465,
         0.0706172839621343,
         0.0592690478903649,
         -0.0336712487107829,
         0.0520595809974801,
         -0.0582826317647523,
         0.00560431972834069,
         0.0356077244179142,
         0.010758953687107,
         -0.0138524293668622,
         -0.0354598795959515,
         -0.0582826317647521,
         0.0316009056533445,
         -0.0696297055682334,
         0.10266850966721,
         -0.0336712487107829,
         -0.0190747269868653,
         0.0262445552191054,
         0.0159251453605967,
         -0.033593861814067,
         0.0065734676000797,
         -0.0284489510907798,
         0.168961343063472,
         -0.101752712992213,
         0.0658023702106391,
         -0.048133653757169,
         0.0658023702106392,
         -0.101752712992213,
         0.168961343063472,
         -0.0284489510907799,
         0.00657346760007983,
         -0.0335938618140669,
         0.0159251453605967,
         0.0262445552191055,
         -0.0190747269868654,
         -0.0336712487107828,
         0.10266850966721,
         -0.0696297055682334,
         0.0316009056533445,
         -0.058282631764752,
         -0.0354598795959514,
         -0.0138524293668623,
         0.0107589536871069,
         0.0356077244179142,
         0.00560431972834043,
         -0.0582826317647522,
         0.05205958099748,
         -0.0336712487107828,
         0.0592690478903648,
         0.0706172839621343,
         -0.0143467530157467,
         0.0262445552191055,
         0.00657346760007975,
         -0.084860068848785,
         0.0567077245134064,
         -0.155473474261777,
         0.091282690285251,
         -0.105685407079892,
         0.0658023702106392,
         -0.0382092358725606,
         0.11586843175016,
         -0.148844896829537,
         -0.0190747269868653,
         0.0262445552191053,
         0.0159251453605967,
         -0.0335938618140669,
         0.00657346760007972,
         -0.0284489510907797,
         0.0520595809974799,
         -0.0696297055682335,
         0.0812316504737444,
         -0.0696297055682334,
         0.05205958099748,
         -0.0138524293668623,
         -0.0293104289057199,
         0.0243542992563043,
         0.0107589536871071,
         0.0452550263371674,
         0.00282394401815936,
         -0.0432154535285394,
         -0.0603042326762896,
         0.0706172839621343,
         -0.0190747269868653,
         -0.0284489510907798,
         0.0567077245134063,
         -0.103194662418713,
         0.100773561313828,
         -0.131635850217454,
         0.091282690285251,
         -0.101752712992213,
         0.11586843175016,
         -0.074933977429723,
         0.104919282301189,
         0.0706172839621344,
         -0.0143467530157466,
         0.0262445552191054,
         0.00657346760007956,
         -0.084860068848785,
         0.0567077245134063,
         -0.0582826317647522,
         0.0316009056533445,
         -0.0696297055682335,
         0.10266850966721,
         -0.0336712487107827,
         0.010758953687107,
         0.0243542992563045,
         -0.0293104289057197,
         -0.0138524293668623,
         0.0028239440181594,
         0.00276871201882487,
         0.00282394401815932,
         -0.0474424439677581,
         0.0410280358979489,
         -0.0404693286375384,
         0.100773561313828,
         -0.155473474261777,
         0.168961343063472,
         -0.148844896829537,
         0.104919282301189,
         -0.00172461988247581,
         -0.0603042326762897,
         0.0706172839621344,
         -0.0190747269868655,
         -0.0284489510907799,
         0.0567077245134062,
         -0.103194662418713,
         0.0056043197283404,
         -0.0582826317647521,
         0.0520595809974799,
         -0.0336712487107829,
         0.0592690478903648,
         0.0356077244179142,
         0.0107589536871069,
         -0.0138524293668623,
         -0.0354598795959514,
         -0.0432154535285395,
         0.00282394401815934,
         0.0452550263371675,
         0.0410280358979487,
         -0.0474424439677579,
         0.00641440806980926},
        {0.228259438887484,
         -0.144287466624427,
         -0.0839719722630574,
         0.0868712617154229,
         0.0741240018050016,
         0.0265557673540533,
         -0.0792673726747522,
         -0.0107535230080966,
         -0.0704452526742097,
         0.0232565485142801,
         0.0861248575840794,
         -0.00969794816253898,
         0.0224034641886473,
         0.0499937815035742,
         -0.0586074904326161,
         -0.0742004276420028,
         -0.01539437285956,
         0.0265616387101916,
         -0.0470131098808275,
         -0.00272096847382324,
         0.0607151435495509,
         0.0658847842857527,
         0.00831564335624996,
         0.00360878658582667,
         -0.0223907014372301,
         0.0556339902386316,
         -0.0535263371216968,
         -0.00718880642785394,
         -0.0839719722630574,
         -0.144287466624427,
         0.0741240018050017,
         0.132565764039144,
         0.0741240018050017,
         -0.0107535230080965,
         -0.167357158482421,
         -0.0226248104657263,
         -0.0704452526742099,
         -0.00969794816253914,
         0.108190120574748,
         0.0731438857502761,
         0.00566619938571506,
         0.0499937815035742,
         -0.0153943728595599,
         -0.0525358378619641,
         -0.053454213781943,
         -0.0355313134181957,
         -0.00858163820916459,
         -0.00272096847382334,
         0.00831564335624994,
         0.0857588341892138,
         -0.0212985663851728,
         0.0513134493372255,
         0.0143653425590619,
         -0.00367605123296286,
         -0.0535263371216969,
         -0.0742004276420027,
         -0.0153943728595599,
         0.0265616387101917,
         -0.0470131098808272,
         -0.00272096847382316,
         0.0607151435495507,
         0.0265557673540532,
         0.0741240018050017,
         0.0868712617154227,
         -0.0704452526742096,
         -0.0226248104657262,
         -0.167357158482422,
         -0.0107535230080964,
         0.0224034641886474,
         0.0731438857502763,
         0.109856856610135,
         0.0731438857502765,
         0.0224034641886475,
         0.0265616387101916,
         -0.0534542137819429,
         -0.129759075548614,
         -0.0468687080098655,
         -0.0355313134181956,
         -0.0470131098808272,
         0.0036087865858268,
         -0.0212985663851727,
         0.132390561611285,
         0.0461653117407855,
         0.0331388993639662,
         0.0143653425590619,
         0.0556339902386314,
         -0.0153943728595598,
         -0.0525358378619643,
         -0.053454213781943,
         -0.0355313134181958,
         -0.00858163820916466,
         -0.00272096847382319,
         0.0861248575840794,
         -0.00969794816253906,
         0.0224034641886475,
         0.0499937815035741,
         -0.0586074904326161,
         0.0232565485142801,
         -0.0704452526742097,
         -0.0107535230080963,
         -0.0792673726747522,
         0.0499937815035742,
         0.00566619938571506,
         0.0731438857502761,
         0.108190120574747,
         -0.00969794816253916,
         -0.0470131098808273,
         -0.0355313134181955,
         -0.0468687080098656,
         -0.129759075548614,
         -0.053454213781943,
         0.0265616387101917,
         -0.0223907014372302,
         0.0513134493372254,
         0.0461653117407856,
         0.130462471817694,
         0.0461653117407856,
         0.0513134493372255,
         -0.0223907014372303,
         0.0265616387101917,
         -0.053454213781943,
         -0.129759075548614,
         -0.0468687080098654,
         -0.0355313134181957,
         -0.0470131098808273,
         -0.00969794816253927,
         0.108190120574748,
         0.0731438857502762,
         0.00566619938571516,
         0.0499937815035742,
         -0.0792673726747521,
         -0.0107535230080966,
         -0.07044525267421,
         0.0232565485142802,
         -0.0586074904326162,
         0.0499937815035742,
         0.0224034641886474,
         -0.00969794816253922,
         0.0861248575840795,
         -0.00272096847382324,
         -0.00858163820916462,
         -0.0355313134181958,
         -0.053454213781943,
         -0.0525358378619642,
         -0.0153943728595599,
         0.0556339902386314,
         0.014365342559062,
         0.0331388993639661,
         0.0461653117407856,
         0.132390561611285,
         -0.0212985663851728,
         0.00360878658582677,
         -0.0470131098808273,
         -0.0355313134181957,
         -0.0468687080098654,
         -0.129759075548614,
         -0.053454213781943,
         0.0265616387101917,
         0.0224034641886474,
         0.0731438857502763,
         0.109856856610134,
         0.0731438857502761,
         0.0224034641886474,
         -0.0107535230080964,
         -0.167357158482422,
         -0.0226248104657263,
         -0.0704452526742097,
         0.0868712617154227,
         0.0741240018050018,
         0.0265557673540534,
         0.0607151435495506,
         -0.00272096847382323,
         -0.0470131098808271,
         0.0265616387101917,
         -0.0153943728595599,
         -0.0742004276420028,
         -0.0535263371216968,
         -0.00367605123296273,
         0.0143653425590619,
         0.0513134493372255,
         -0.0212985663851728,
         0.0857588341892139,
         0.00831564335624978,
         -0.00272096847382315,
         -0.00858163820916462,
         -0.0355313134181957,
         -0.053454213781943,
         -0.0525358378619642,
         -0.0153943728595599,
         0.0499937815035744,
         0.00566619938571497,
         0.0731438857502762,
         0.108190120574747,
         -0.00969794816253908,
         -0.0704452526742097,
         -0.0226248104657264,
         -0.167357158482422,
         -0.0107535230080963,
         0.0741240018050017,
         0.132565764039144,
         0.0741240018050016,
         -0.144287466624427,
         -0.0839719722630574,
         -0.00718880642785402,
         -0.0535263371216967,
         0.0556339902386315,
         -0.0223907014372301,
         0.00360878658582665,
         0.00831564335624995,
         0.0658847842857526,
         0.0607151435495507,
         -0.00272096847382321,
         -0.0470131098808273,
         0.0265616387101916,
         -0.0153943728595599,
         -0.0742004276420028,
         -0.058607490432616,
         0.0499937815035742,
         0.0224034641886474,
         -0.00969794816253912,
         0.0861248575840792,
         0.0232565485142802,
         -0.0704452526742097,
         -0.0107535230080965,
         -0.0792673726747522,
         0.0265557673540533,
         0.0741240018050019,
         0.0868712617154227,
         -0.0839719722630575,
         -0.144287466624427,
         0.228259438887484},
        {-0.037612386785419,
         -0.0151470500044742,
         0.0527594367898934,
         0.109434765080418,
         -0.121724916747027,
         0.0415282782860505,
         -0.142692791397436,
         0.047033951875289,
         0.0863090135502806,
         -0.102557967044975,
         0.121583489005734,
         0.0298530617345809,
         -0.0842255034666647,
         -0.00942199994041066,
         0.109220327095179,
         -0.0744854174011495,
         -0.0608033489876794,
         0.0367536698902409,
         0.0401333437196289,
         -0.0280354929319561,
         -0.0875041276495425,
         0.0503796184008457,
         0.0241057990003039,
         0.0229922726042801,
         -0.0489810418171612,
         0.0206024823213213,
         0.00111371712431529,
         0.0863904105252273,
         0.0527594367898932,
         -0.0151470500044744,
         -0.121724916747026,
         0.11953380500782,
         -0.121724916747026,
         0.047033951875289,
         -0.0188046259212156,
         -0.00644146401066095,
         0.0863090135502807,
         0.0298530617345808,
         0.0339581339799936,
         -0.0530321788421212,
         -0.00617669037246748,
         -0.00942199994041052,
         -0.0608033489876794,
         -0.0853053077814993,
         0.0331239285241791,
         0.0794646749680721,
         -0.0597019412520441,
         -0.0280354929319563,
         0.024105799000304,
         0.128876404408486,
         0.00352697497759745,
         -0.0597536156002813,
         -0.0411659355702739,
         0.122584076267955,
         0.00111371712431536,
         -0.0744854174011497,
         -0.0608033489876794,
         0.0367536698902411,
         0.0401333437196289,
         -0.0280354929319562,
         -0.0875041276495424,
         0.0415282782860504,
         -0.121724916747026,
         0.109434765080418,
         0.0863090135502807,
         -0.00644146401066095,
         -0.0188046259212155,
         0.047033951875289,
         -0.0842255034666649,
         -0.0530321788421212,
         0.0833399311828327,
         -0.0530321788421214,
         -0.0842255034666649,
         0.036753669890241,
         0.033123928524179,
         -0.0121497384208008,
         -0.0227786583862349,
         0.0794646749680721,
         0.0401333437196288,
         0.0229922726042801,
         0.00352697497759748,
         0.0454928871121383,
         -0.0635810201011401,
         0.0138186868126598,
         -0.041165935570274,
         0.0206024823213212,
         -0.0608033489876794,
         -0.085305307781499,
         0.0331239285241789,
         0.079464674968072,
         -0.0597019412520441,
         -0.0280354929319562,
         0.121583489005734,
         0.029853061734581,
         -0.084225503466665,
         -0.00942199994041048,
         0.109220327095179,
         -0.102557967044975,
         0.0863090135502805,
         0.0470339518752889,
         -0.142692791397436,
         -0.00942199994041068,
         -0.00617669037246746,
         -0.0530321788421212,
         0.0339581339799935,
         0.0298530617345807,
         0.0401333437196289,
         0.0794646749680722,
         -0.0227786583862348,
         -0.0121497384208009,
         0.0331239285241789,
         0.036753669890241,
         -0.0489810418171613,
         -0.0597536156002812,
         -0.0635810201011399,
         0.0985094169081759,
         -0.06358102010114,
         -0.0597536156002812,
         -0.0489810418171614,
         0.036753669890241,
         0.0331239285241788,
         -0.012149738420801,
         -0.0227786583862349,
         0.0794646749680721,
         0.0401333437196289,
         0.029853061734581,
         0.0339581339799934,
         -0.0530321788421214,
         -0.00617669037246736,
         -0.0094219999404107,
         -0.142692791397436,
         0.0470339518752891,
         0.0863090135502808,
         -0.102557967044975,
         0.109220327095179,
         -0.00942199994041054,
         -0.0842255034666649,
         0.0298530617345808,
         0.121583489005734,
         -0.0280354929319561,
         -0.0597019412520441,
         0.079464674968072,
         0.0331239285241789,
         -0.085305307781499,
         -0.0608033489876795,
         0.0206024823213212,
         -0.0411659355702741,
         0.0138186868126596,
         -0.06358102010114,
         0.0454928871121382,
         0.00352697497759739,
         0.02299227260428,
         0.0401333437196288,
         0.079464674968072,
         -0.022778658386235,
         -0.0121497384208008,
         0.0331239285241789,
         0.0367536698902411,
         -0.084225503466665,
         -0.0530321788421213,
         0.0833399311828325,
         -0.0530321788421212,
         -0.084225503466665,
         0.047033951875289,
         -0.0188046259212156,
         -0.00644146401066096,
         0.0863090135502806,
         0.109434765080418,
         -0.121724916747027,
         0.0415282782860504,
         -0.0875041276495422,
         -0.0280354929319563,
         0.0401333437196287,
         0.0367536698902408,
         -0.0608033489876793,
         -0.0744854174011495,
         0.00111371712431536,
         0.122584076267955,
         -0.0411659355702739,
         -0.0597536156002813,
         0.00352697497759738,
         0.128876404408486,
         0.0241057990003041,
         -0.0280354929319561,
         -0.0597019412520442,
         0.079464674968072,
         0.033123928524179,
         -0.0853053077814989,
         -0.0608033489876794,
         -0.00942199994041071,
         -0.00617669037246756,
         -0.0530321788421213,
         0.0339581339799937,
         0.0298530617345808,
         0.0863090135502805,
         -0.00644146401066096,
         -0.0188046259212155,
         0.0470339518752891,
         -0.121724916747027,
         0.11953380500782,
         -0.121724916747026,
         -0.0151470500044742,
         0.0527594367898934,
         0.0863904105252269,
         0.00111371712431527,
         0.0206024823213211,
         -0.048981041817161,
         0.0229922726042801,
         0.0241057990003041,
         0.0503796184008457,
         -0.0875041276495425,
         -0.0280354929319562,
         0.040133343719629,
         0.036753669890241,
         -0.0608033489876798,
         -0.0744854174011496,
         0.109220327095179,
         -0.00942199994041053,
         -0.0842255034666649,
         0.0298530617345807,
         0.121583489005734,
         -0.102557967044975,
         0.0863090135502806,
         0.0470339518752891,
         -0.142692791397436,
         0.0415282782860503,
         -0.121724916747026,
         0.109434765080418,
         0.0527594367898934,
         -0.0151470500044742,
         -0.0376123867854191},
        {0.00755889448885631,
         -0.0906549497751239,
         0.0830960552862678,
         0.0809039992990896,
         0.012588422934458,
         -0.0928470057623018,
         -0.0252045394662255,
         -0.0787709315124915,
         0.0649810051032555,
         0.0468984964054721,
         -0.0327315651951838,
         0.0819340249632322,
         -0.00346499526893511,
         -0.0618179116525145,
         -0.00318663187718822,
         0.0158159302059924,
         0.0218379908678873,
         -0.105856345381099,
         0.10901943883184,
         -0.0430889019746832,
         0.0365631518280507,
         0.10643696009875,
         -0.122252890304742,
         0.105337255315551,
         -0.0304855156649497,
         -0.0466028688141967,
         0.079979388765059,
         -0.11654254059311,
         0.0830960552862679,
         -0.090654949775124,
         0.012588422934458,
         -0.00869268963786766,
         0.0125884229344578,
         -0.0787709315124912,
         0.0142433362399143,
         -0.015301597078081,
         0.0649810051032557,
         0.0819340249632324,
         0.0207312498091346,
         0.0227029617456856,
         -0.0513717860625635,
         -0.0618179116525148,
         0.0218379908678871,
         -0.111333369109621,
         0.0357838261632327,
         -0.056036666257475,
         0.146237894185193,
         -0.0430889019746833,
         -0.122252890304742,
         0.0782442351167637,
         0.0161734990036654,
         0.0260122260078586,
         -0.0519463668926588,
         -0.0609150073416723,
         0.079979388765059,
         0.0158159302059923,
         0.0218379908678872,
         -0.1058563453811,
         0.10901943883184,
         -0.0430889019746832,
         0.0365631518280508,
         -0.0928470057623017,
         0.0125884229344579,
         0.0809039992990895,
         0.0649810051032555,
         -0.0153015970780811,
         0.0142433362399146,
         -0.0787709315124917,
         -0.00346499526893533,
         0.0227029617456859,
         -0.0238115877024114,
         0.0227029617456859,
         -0.00346499526893526,
         -0.1058563453811,
         0.0357838261632328,
         -0.0848003159166047,
         0.087887029835201,
         -0.0560366662574751,
         0.10901943883184,
         0.105337255315551,
         0.0161734990036654,
         0.0559606525390633,
         -0.00382635126153538,
         -0.0329064349793193,
         -0.0519463668926588,
         -0.0466028688141966,
         0.0218379908678872,
         -0.111333369109621,
         0.0357838261632328,
         -0.0560366662574751,
         0.146237894185193,
         -0.0430889019746832,
         -0.032731565195184,
         0.0819340249632322,
         -0.00346499526893524,
         -0.0618179116525147,
         -0.00318663187718837,
         0.0468984964054722,
         0.0649810051032554,
         -0.0787709315124915,
         -0.0252045394662256,
         -0.0618179116525147,
         -0.0513717860625633,
         0.0227029617456857,
         0.0207312498091344,
         0.0819340249632323,
         0.10901943883184,
         -0.0560366662574752,
         0.0878870298352009,
         -0.0848003159166045,
         0.0357838261632325,
         -0.1058563453811,
         -0.0304855156649498,
         0.0260122260078585,
         -0.00382635126153526,
         0.000739637342938961,
         -0.00382635126153542,
         0.0260122260078585,
         -0.0304855156649498,
         -0.1058563453811,
         0.0357838261632327,
         -0.0848003159166046,
         0.087887029835201,
         -0.0560366662574751,
         0.10901943883184,
         0.0819340249632322,
         0.0207312498091343,
         0.0227029617456857,
         -0.0513717860625635,
         -0.0618179116525145,
         -0.0252045394662255,
         -0.0787709315124915,
         0.0649810051032556,
         0.0468984964054722,
         -0.00318663187718806,
         -0.0618179116525146,
         -0.00346499526893526,
         0.0819340249632323,
         -0.0327315651951839,
         -0.0430889019746831,
         0.146237894185194,
         -0.0560366662574751,
         0.0357838261632328,
         -0.111333369109621,
         0.0218379908678872,
         -0.0466028688141966,
         -0.0519463668926589,
         -0.0329064349793195,
         -0.00382635126153543,
         0.0559606525390631,
         0.0161734990036654,
         0.105337255315551,
         0.10901943883184,
         -0.056036666257475,
         0.0878870298352007,
         -0.0848003159166045,
         0.0357838261632326,
         -0.1058563453811,
         -0.00346499526893515,
         0.0227029617456859,
         -0.0238115877024113,
         0.0227029617456858,
         -0.00346499526893513,
         -0.0787709315124916,
         0.0142433362399145,
         -0.015301597078081,
         0.0649810051032556,
         0.0809039992990894,
         0.0125884229344577,
         -0.0928470057623018,
         0.0365631518280507,
         -0.0430889019746831,
         0.10901943883184,
         -0.1058563453811,
         0.0218379908678872,
         0.0158159302059926,
         0.079979388765059,
         -0.0609150073416723,
         -0.0519463668926588,
         0.0260122260078585,
         0.0161734990036654,
         0.0782442351167641,
         -0.122252890304742,
         -0.0430889019746833,
         0.146237894185194,
         -0.056036666257475,
         0.0357838261632328,
         -0.111333369109621,
         0.0218379908678871,
         -0.0618179116525146,
         -0.0513717860625635,
         0.0227029617456859,
         0.0207312498091346,
         0.0819340249632322,
         0.0649810051032556,
         -0.0153015970780812,
         0.0142433362399145,
         -0.0787709315124916,
         0.0125884229344579,
         -0.00869268963786764,
         0.012588422934458,
         -0.0906549497751238,
         0.0830960552862678,
         -0.11654254059311,
         0.0799793887650591,
         -0.0466028688141967,
         -0.0304855156649498,
         0.105337255315551,
         -0.122252890304742,
         0.10643696009875,
         0.0365631518280507,
         -0.0430889019746832,
         0.109019438831841,
         -0.1058563453811,
         0.0218379908678872,
         0.0158159302059924,
         -0.0031866318771883,
         -0.0618179116525146,
         -0.00346499526893527,
         0.0819340249632322,
         -0.0327315651951839,
         0.0468984964054723,
         0.0649810051032557,
         -0.0787709315124913,
         -0.0252045394662257,
         -0.0928470057623019,
         0.012588422934458,
         0.0809039992990895,
         0.0830960552862677,
         -0.0906549497751239,
         0.0075588944888563},
        {0.12528704197393,
         -0.0826047880154116,
         -0.0426822539585186,
         0.0493071685019766,
         0.0429870419479612,
         0.00938463444508369,
         0.0194044061909706,
         -0.0971728408227781,
         0.0500828957121398,
         -0.0447985896245966,
         -0.084621579775794,
         0.0922310113832977,
         0.00541350291869323,
         -0.0550247251516202,
         0.0837069459122332,
         0.129568960998281,
         -0.0580268196434432,
         -0.0286658152653023,
         0.023723985825822,
         0.0285735349922147,
         -0.105839910945658,
         -0.168299444164851,
         0.0387304831665697,
         0.00621689805591765,
         0.0140528943064186,
         -0.0308282855606308,
         0.00869532052720625,
         0.0971445904184515,
         -0.0426822539585184,
         -0.0826047880154118,
         0.0429870419479613,
         0.0697910094515388,
         0.0429870419479613,
         -0.0971728408227783,
         0.032619948361527,
         -0.1357085773265,
         0.0500828957121397,
         0.0922310113832976,
         -0.0124156039747226,
         0.0531370084815458,
         0.0517873918408443,
         -0.0550247251516201,
         -0.0580268196434431,
         0.0290995346436258,
         -0.0897181645686969,
         0.0327532314633699,
         -0.0427785083926672,
         0.0285735349922148,
         0.0387304831665696,
         -0.0933871421273721,
         0.109234988706233,
         -0.00706409209017037,
         -0.039610772003501,
         0.0602563153627438,
         0.00869532052720649,
         0.129568960998281,
         -0.0580268196434429,
         -0.0286658152653023,
         0.0237239858258221,
         0.0285735349922149,
         -0.105839910945658,
         0.00938463444508373,
         0.0429870419479612,
         0.0493071685019769,
         0.0500828957121398,
         -0.1357085773265,
         0.0326199483615269,
         -0.0971728408227782,
         0.00541350291869314,
         0.0531370084815457,
         0.0448799525976017,
         0.053137008481546,
         0.00541350291869319,
         -0.0286658152653024,
         -0.0897181645686968,
         0.0524882527118228,
         -0.145875435615568,
         0.03275323146337,
         0.023723985825822,
         0.00621689805591755,
         0.109234988706233,
         -0.0400531982453871,
         0.0694660497872913,
         0.0465099129888169,
         -0.0396107720035011,
         -0.0308282855606306,
         -0.0580268196434429,
         0.0290995346436258,
         -0.0897181645686969,
         0.0327532314633699,
         -0.0427785083926671,
         0.0285735349922147,
         -0.0846215797757939,
         0.0922310113832976,
         0.00541350291869325,
         -0.0550247251516202,
         0.0837069459122333,
         -0.0447985896245965,
         0.0500828957121399,
         -0.0971728408227783,
         0.0194044061909706,
         -0.0550247251516203,
         0.0517873918408444,
         0.0531370084815457,
         -0.0124156039747224,
         0.0922310113832977,
         0.0237239858258221,
         0.03275323146337,
         -0.145875435615568,
         0.0524882527118228,
         -0.0897181645686969,
         -0.0286658152653023,
         0.0140528943064184,
         -0.0070640920901704,
         0.0694660497872914,
         0.0239211331164538,
         0.0694660497872914,
         -0.00706409209017054,
         0.0140528943064185,
         -0.0286658152653023,
         -0.0897181645686968,
         0.0524882527118228,
         -0.145875435615568,
         0.0327532314633699,
         0.0237239858258221,
         0.0922310113832978,
         -0.0124156039747225,
         0.0531370084815459,
         0.0517873918408445,
         -0.0550247251516202,
         0.0194044061909705,
         -0.0971728408227781,
         0.0500828957121397,
         -0.0447985896245966,
         0.0837069459122331,
         -0.0550247251516203,
         0.00541350291869312,
         0.0922310113832977,
         -0.084621579775794,
         0.0285735349922147,
         -0.0427785083926671,
         0.0327532314633698,
         -0.0897181645686969,
         0.0290995346436259,
         -0.058026819643443,
         -0.0308282855606307,
         -0.039610772003501,
         0.0465099129888168,
         0.0694660497872912,
         -0.0400531982453872,
         0.109234988706233,
         0.00621689805591744,
         0.023723985825822,
         0.0327532314633699,
         -0.145875435615568,
         0.0524882527118228,
         -0.0897181645686968,
         -0.0286658152653022,
         0.00541350291869318,
         0.0531370084815458,
         0.0448799525976018,
         0.0531370084815458,
         0.00541350291869307,
         -0.0971728408227781,
         0.0326199483615269,
         -0.1357085773265,
         0.0500828957121397,
         0.0493071685019767,
         0.0429870419479615,
         0.00938463444508374,
         -0.105839910945658,
         0.0285735349922146,
         0.0237239858258218,
         -0.0286658152653024,
         -0.0580268196434429,
         0.129568960998282,
         0.00869532052720639,
         0.0602563153627437,
         -0.0396107720035011,
         -0.00706409209017058,
         0.109234988706233,
         -0.093387142127372,
         0.0387304831665696,
         0.0285735349922146,
         -0.0427785083926672,
         0.0327532314633699,
         -0.0897181645686971,
         0.0290995346436259,
         -0.0580268196434429,
         -0.0550247251516203,
         0.0517873918408444,
         0.0531370084815457,
         -0.0124156039747225,
         0.0922310113832977,
         0.0500828957121396,
         -0.1357085773265,
         0.0326199483615269,
         -0.0971728408227781,
         0.0429870419479613,
         0.0697910094515388,
         0.0429870419479613,
         -0.0826047880154119,
         -0.0426822539585185,
         0.0971445904184514,
         0.00869532052720629,
         -0.0308282855606307,
         0.0140528943064184,
         0.00621689805591755,
         0.0387304831665698,
         -0.168299444164851,
         -0.105839910945658,
         0.0285735349922148,
         0.023723985825822,
         -0.0286658152653025,
         -0.0580268196434432,
         0.129568960998281,
         0.083706945912233,
         -0.0550247251516203,
         0.00541350291869303,
         0.0922310113832975,
         -0.0846215797757938,
         -0.0447985896245965,
         0.0500828957121398,
         -0.097172840822778,
         0.0194044061909705,
         0.00938463444508383,
         0.0429870419479612,
         0.0493071685019769,
         -0.0426822539585187,
         -0.0826047880154119,
         0.12528704197393},
        {-0.0427170584069785,
         0.0565093566425428,
         -0.0427170584069784,
         0.0630804132318202,
         -0.0576265620923433,
         0.0206325043369563,
         0.0109077022789538,
         -0.0554003968803577,
         0.0170696726920453,
         0.0293481446072539,
         -0.0412611914384826,
         0.0183829585349569,
         0.0186934249514313,
         0.0382944518943042,
         -0.0615740705576865,
         0.0376114108292912,
         0.00049281747476528,
         -0.01455106359018,
         -0.0001329436567879,
         -0.0226952608528272,
         -0.00832774820591411,
         0.0590532354545098,
         -0.08515649172538,
         0.0708652978520079,
         -0.0353626382310947,
         0.00571746174094488,
         -0.00741485542165593,
         0.0275886520375979,
         -0.0228738556415766,
         -0.0188830875993135,
         0.0781288025821657,
         -0.121723001702177,
         0.121900824542364,
         0.0579093130950462,
         -0.0628607802078701,
         0.0677149425274263,
         -0.0836432582079122,
         0.0961717849199206,
         -0.0858290918864305,
         0.040721406684154,
         0.0389650031897696,
         -0.144534213985727,
         0.0109077022789538,
         0.0206325043369562,
         -0.0576265620923432,
         0.0630804132318201,
         -0.0436469460490815,
         0.00493629360232481,
         0.0186210648738824,
         0.00493629360232481,
         -0.0436469460490816,
         0.0747103284601852,
         -0.0213504810706066,
         0.0101720523724161,
         -0.0409955338521083,
         0.0534085230607481,
         -0.0129842254014074,
         -0.0321899510608939,
         -0.0594051459219295,
         0.0656998309621989,
         -0.0420093423477142,
         0.0510079472921855,
         -0.0843163018545526,
         0.075213504030065,
         -0.00717813657828792,
         0.0490353921877294,
         0.0142551054483143,
         -0.0638618601805868,
         0.0640573676880525,
         -0.0536386094841156,
         0.0752346805117459,
         -0.103355965624733,
         -0.0645112692454783,
         0.0675852028030689,
         -0.104173510823254,
         0.077620066873148,
         -0.0199343857682598,
         -0.0150183202754323,
         0.00989049408150494,
         0.00621100545477608,
         0.00377526625778398,
         0.00571746174094505,
         -0.00741485542165615,
         0.0275886520375981,
         -0.0228738556415765,
         -0.0188830875993137,
         0.0781288025821659,
         -0.121723001702177,
         0.121900824542364,
         0.0183829585349569,
         -0.0412611914384829,
         0.029348144607254,
         0.0170696726920455,
         -0.0554003968803578,
         -0.0129842254014073,
         0.0534085230607481,
         -0.0409955338521084,
         0.0101720523724161,
         -0.0213504810706065,
         0.0747103284601853,
         -0.064972099192909,
         0.0284462675765706,
         -0.0610937834225324,
         0.0873729687946791,
         -0.0610937834225323,
         0.0284462675765708,
         -0.0649720991929089,
         0.0459509183876266,
         0.0547763533679934,
         -0.0382401610595128,
         0.0412217715797753,
         -0.0791954913426178,
         0.0863864156433894,
         -0.0365662768459242,
         0.0242269695291195,
         0.0709315897818104,
         -0.119184340742374,
         0.0270288214623011,
         -0.0064309889727029,
         0.0196578963996558,
         -0.00360873166390352,
         -0.0269456223391764,
         -0.00278549392066228,
         0.0886691197490298,
         -0.00717813657828787,
         0.0490353921877291,
         0.0142551054483142,
         -0.0638618601805869,
         0.0640573676880525,
         -0.0536386094841155,
         0.0752346805117461,
         -0.103355965624733,
         -0.000132943656787907,
         -0.0226952608528271,
         -0.00832774820591399,
         0.0590532354545098,
         -0.08515649172538,
         0.070865297852008,
         -0.0353626382310948,
         -0.0145510635901802,
         0.000492817474765386,
         0.0376114108292912,
         -0.0615740705576864,
         0.0382944518943042,
         0.0186934249514313,
         0.075213504030065,
         -0.0843163018545527,
         0.0510079472921854,
         -0.0420093423477146,
         0.065699830962199,
         -0.0594051459219296,
         -0.0321899510608939,
         0.0242269695291196,
         -0.0365662768459242,
         0.0863864156433892,
         -0.0791954913426178,
         0.0412217715797753,
         -0.0382401610595127,
         0.0547763533679934,
         0.0459509183876265,
         -0.108450357535796,
         0.0225003492246675,
         -0.0393596040871953,
         4.8351834984433e-05,
         0.0293659650120229,
         4.83518349843404e-05,
         -0.0393596040871953,
         0.0225003492246675,
         -0.108450357535796,
         0.0459509183876266,
         0.0547763533679934,
         -0.038240161059513,
         0.0412217715797752,
         -0.0791954913426179,
         0.0863864156433894,
         -0.0365662768459242,
         0.0242269695291196,
         -0.0321899510608938,
         -0.0594051459219296,
         0.0656998309621991,
         -0.0420093423477142,
         0.0510079472921855,
         -0.0843163018545527,
         0.0752135040300651,
         0.0186934249514313,
         0.0382944518943042,
         -0.0615740705576866,
         0.0376114108292912,
         0.000492817474765246,
         -0.0145510635901801,
         -0.0353626382310948,
         0.0708652978520081,
         -0.08515649172538,
         0.0590532354545099,
         -0.00832774820591398,
         -0.0226952608528271,
         -0.000132943656787943,
         -0.103355965624733,
         0.075234680511746,
         -0.0536386094841156,
         0.0640573676880527,
         -0.0638618601805869,
         0.0142551054483144,
         0.0490353921877293,
         -0.00717813657828789,
         0.0886691197490298,
         -0.00278549392066224,
         -0.0269456223391763,
         -0.00360873166390351,
         0.0196578963996557,
         -0.00643098897270306,
         0.0270288214623012,
         -0.119184340742374,
         0.0709315897818101,
         0.0242269695291197,
         -0.0365662768459242,
         0.0863864156433894,
         -0.0791954913426177,
         0.0412217715797754,
         -0.038240161059513,
         0.0547763533679934,
         0.0459509183876267,
         -0.0649720991929087,
         0.0284462675765707,
         -0.0610937834225323,
         0.0873729687946791,
         -0.0610937834225323,
         0.0284462675765708,
         -0.0649720991929089,
         0.0747103284601853,
         -0.0213504810706066,
         0.0101720523724161,
         -0.0409955338521084,
         0.053408523060748,
         -0.0129842254014073,
         -0.0554003968803577,
         0.0170696726920454,
         0.029348144607254,
         -0.0412611914384827,
         0.0183829585349569,
         0.121900824542364,
         -0.121723001702177,
         0.0781288025821659,
         -0.0188830875993135,
         -0.0228738556415765,
         0.0275886520375979,
         -0.00741485542165614,
         0.00571746174094494,
         0.00377526625778386,
         0.00621100545477603,
         0.00989049408150492,
         -0.0150183202754323,
         -0.0199343857682597,
         0.0776200668731479,
         -0.104173510823254,
         0.0675852028030687,
         -0.0645112692454783,
         -0.103355965624733,
         0.075234680511746,
         -0.0536386094841156,
         0.0640573676880524,
         -0.0638618601805866,
         0.0142551054483143,
         0.0490353921877294,
         -0.00717813657828807,
         0.075213504030065,
         -0.0843163018545526,
         0.0510079472921855,
         -0.0420093423477145,
         0.065699830962199,
         -0.0594051459219295,
         -0.0321899510608939,
         -0.0129842254014074,
         0.053408523060748,
         -0.0409955338521085,
         0.010172052372416,
         -0.0213504810706066,
         0.0747103284601852,
         -0.0436469460490817,
         0.00493629360232476,
         0.0186210648738824,
         0.00493629360232481,
         -0.0436469460490815,
         0.06308041323182,
         -0.0576265620923432,
         0.0206325043369562,
         0.0109077022789539,
         -0.144534213985727,
         0.0389650031897697,
         0.0407214066841538,
         -0.0858290918864305,
         0.0961717849199206,
         -0.0836432582079122,
         0.0677149425274265,
         -0.0628607802078701,
         0.057909313095046,
         0.121900824542364,
         -0.121723001702177,
         0.0781288025821659,
         -0.0188830875993134,
         -0.0228738556415764,
         0.0275886520375979,
         -0.00741485542165615,
         0.0057174617409451,
         -0.0353626382310948,
         0.0708652978520081,
         -0.08515649172538,
         0.05905323545451,
         -0.00832774820591392,
         -0.0226952608528272,
         -0.000132943656787981,
         -0.0145510635901801,
         0.000492817474765342,
         0.037611410829291,
         -0.0615740705576866,
         0.0382944518943041,
         0.0186934249514314,
         0.0183829585349568,
         -0.0412611914384829,
         0.0293481446072541,
         0.0170696726920454,
         -0.0554003968803578,
         0.0109077022789538,
         0.0206325043369562,
         -0.0576265620923433,
         0.0630804132318201,
         -0.0427170584069785,
         0.0565093566425429,
         -0.0427170584069786},
        {0.071625140505049,
         -0.0947511546982097,
         0.0716251405050491,
         -0.00889142807329942,
         -0.0486920491170533,
         0.110721240344056,
         -0.115166954380705,
         -0.0360325064756208,
         0.0669133139283373,
         -0.0347202738259477,
         -0.0519063366556259,
         0.114263784176651,
         0.0277011438139149,
         0.000331273387473163,
         -0.0623456384074645,
         0.0906946232752252,
         -0.0356740904299728,
         -0.0659460707954559,
         0.016174952157139,
         -0.0581892620534816,
         0.069242771201735,
         -0.0220832889043479,
         -0.0493017057575214,
         0.0688817980725394,
         0.00792354261508106,
         -0.0493975241040912,
         0.047262635802787,
         -0.00441188929867005,
         -0.0469599747964082,
         0.0625752181315742,
         -0.024502493848085,
         -0.0297322925598968,
         0.0157788848238566,
         -0.0109827877021378,
         0.0537622984603349,
         -0.0847029564759639,
         0.0872501619501856,
         -0.0615291244543189,
         0.0272552659428493,
         -0.0131087445238402,
         0.0325730989867401,
         -0.0462380140875888,
         -0.115166954380706,
         0.110721240344056,
         -0.0486920491170534,
         -0.00889142807329937,
         0.062751218247999,
         0.00821932295057484,
         -0.0499274739303241,
         0.00821932295057473,
         0.0627512182479991,
         0.0266107220589419,
         -0.0810281748107816,
         0.0460955503509073,
         0.0111639509731921,
         0.0132779009511741,
         -0.115354345960696,
         -0.0708546252248346,
         0.0497006982147995,
         0.015396947138365,
         -0.0178713954636307,
         -0.0413687558624816,
         0.0438660705732633,
         0.103016363748975,
         0.039064281858882,
         0.0210937319134427,
         -0.0318381351802778,
         -0.0189885460806193,
         0.04492718495826,
         0.0164260868702914,
         -0.0900718682588283,
         -0.0324738639834464,
         0.0680221353797339,
         -0.0689178194858729,
         0.0201497041954953,
         0.00612824612536936,
         0.0330197210689766,
         -0.0990618967240539,
         0.100965135860967,
         -0.00537615870777211,
         0.0280181272864573,
         -0.0493975241040911,
         0.047262635802787,
         -0.00441188929866988,
         -0.0469599747964081,
         0.062575218131574,
         -0.0245024938480848,
         -0.0297322925598967,
         0.0157788848238565,
         0.114263784176651,
         -0.0519063366556258,
         -0.0347202738259478,
         0.0669133139283373,
         -0.0360325064756208,
         -0.115354345960696,
         0.013277900951174,
         0.0111639509731921,
         0.0460955503509073,
         -0.0810281748107817,
         0.0266107220589418,
         0.041915323005945,
         0.0363454032980818,
         0.013818366371806,
         -0.0572445495320032,
         0.013818366371806,
         0.0363454032980817,
         0.0419153230059449,
         0.04104354643265,
         -0.0264132060152142,
         -0.0457043009908459,
         0.0254177076199499,
         0.0315607147013689,
         -0.0113926556780741,
         -0.0523243581956054,
         -0.0863172697145732,
         -0.102962291271203,
         0.00901922340975577,
         -0.00239280365618611,
         0.0634409539955463,
         -0.069702495959234,
         0.0134873543290652,
         -0.0164285722023268,
         0.140996137417812,
         0.00102737965716978,
         0.039064281858882,
         0.0210937319134425,
         -0.0318381351802778,
         -0.0189885460806196,
         0.04492718495826,
         0.0164260868702916,
         -0.0900718682588282,
         -0.0324738639834463,
         0.0161749521571389,
         -0.0581892620534816,
         0.0692427712017349,
         -0.0220832889043478,
         -0.0493017057575214,
         0.0688817980725395,
         0.00792354261508117,
         -0.0659460707954561,
         -0.0356740904299728,
         0.0906946232752253,
         -0.0623456384074645,
         0.000331273387473278,
         0.0277011438139149,
         0.103016363748975,
         0.0438660705732634,
         -0.0413687558624816,
         -0.0178713954636308,
         0.0153969471383651,
         0.0497006982147999,
         -0.0708546252248347,
         -0.086317269714573,
         -0.0523243581956055,
         -0.0113926556780742,
         0.0315607147013689,
         0.0254177076199498,
         -0.0457043009908457,
         -0.0264132060152141,
         0.0410435464326501,
         0.0694503759397955,
         -0.0140016155414581,
         0.0868984350949669,
         -0.0402789651934153,
         -0.00385633095531287,
         -0.0402789651934152,
         0.086898435094967,
         -0.014001615541458,
         0.0694503759397955,
         0.0410435464326501,
         -0.0264132060152141,
         -0.0457043009908457,
         0.0254177076199498,
         0.031560714701369,
         -0.0113926556780743,
         -0.0523243581956055,
         -0.086317269714573,
         -0.0708546252248347,
         0.0497006982147999,
         0.015396947138365,
         -0.0178713954636308,
         -0.0413687558624816,
         0.0438660705732633,
         0.103016363748975,
         0.027701143813915,
         0.000331273387473243,
         -0.0623456384074645,
         0.0906946232752251,
         -0.0356740904299728,
         -0.0659460707954559,
         0.00792354261508107,
         0.0688817980725396,
         -0.0493017057575214,
         -0.0220832889043479,
         0.0692427712017348,
         -0.0581892620534815,
         0.0161749521571389,
         -0.0324738639834465,
         -0.0900718682588282,
         0.0164260868702915,
         0.0449271849582601,
         -0.0189885460806195,
         -0.0318381351802778,
         0.0210937319134425,
         0.0390642818588818,
         0.00102737965716978,
         0.140996137417812,
         -0.0164285722023268,
         0.013487354329065,
         -0.069702495959234,
         0.0634409539955464,
         -0.00239280365618624,
         0.00901922340975598,
         -0.102962291271203,
         -0.0863172697145731,
         -0.0523243581956055,
         -0.0113926556780742,
         0.0315607147013691,
         0.0254177076199498,
         -0.0457043009908458,
         -0.0264132060152141,
         0.0410435464326501,
         0.0419153230059449,
         0.0363454032980817,
         0.0138183663718059,
         -0.0572445495320034,
         0.013818366371806,
         0.0363454032980817,
         0.0419153230059449,
         0.026610722058942,
         -0.0810281748107816,
         0.0460955503509074,
         0.0111639509731922,
         0.0132779009511741,
         -0.115354345960696,
         -0.0360325064756209,
         0.0669133139283374,
         -0.0347202738259478,
         -0.0519063366556257,
         0.114263784176651,
         0.0157788848238565,
         -0.0297322925598966,
         -0.0245024938480848,
         0.062575218131574,
         -0.0469599747964081,
         -0.00441188929866992,
         0.0472626358027869,
         -0.049397524104091,
         0.0280181272864573,
         -0.00537615870777207,
         0.100965135860967,
         -0.0990618967240539,
         0.0330197210689767,
         0.00612824612536957,
         0.0201497041954953,
         -0.0689178194858729,
         0.0680221353797339,
         -0.0324738639834461,
         -0.0900718682588282,
         0.0164260868702915,
         0.04492718495826,
         -0.0189885460806195,
         -0.031838135180278,
         0.0210937319134425,
         0.0390642818588817,
         0.103016363748975,
         0.0438660705732634,
         -0.0413687558624816,
         -0.0178713954636307,
         0.0153969471383651,
         0.0497006982147998,
         -0.0708546252248348,
         -0.115354345960696,
         0.0132779009511739,
         0.0111639509731921,
         0.0460955503509074,
         -0.0810281748107815,
         0.0266107220589418,
         0.0627512182479991,
         0.00821932295057489,
         -0.0499274739303241,
         0.0082193229505748,
         0.062751218247999,
         -0.00889142807329949,
         -0.0486920491170534,
         0.110721240344056,
         -0.115166954380706,
         -0.0462380140875886,
         0.0325730989867401,
         -0.01310874452384,
         0.0272552659428493,
         -0.0615291244543189,
         0.0872501619501859,
         -0.0847029564759637,
         0.0537622984603347,
         -0.0109827877021378,
         0.0157788848238564,
         -0.0297322925598967,
         -0.0245024938480847,
         0.0625752181315742,
         -0.0469599747964082,
         -0.00441188929866994,
         0.0472626358027871,
         -0.0493975241040911,
         0.00792354261508098,
         0.0688817980725396,
         -0.0493017057575214,
         -0.0220832889043479,
         0.0692427712017349,
         -0.0581892620534815,
         0.0161749521571389,
         -0.065946070795456,
         -0.0356740904299728,
         0.090694623275225,
         -0.0623456384074645,
         0.000331273387473178,
         0.027701143813915,
         0.114263784176651,
         -0.0519063366556257,
         -0.0347202738259476,
         0.0669133139283373,
         -0.0360325064756207,
         -0.115166954380706,
         0.110721240344056,
         -0.0486920491170533,
         -0.00889142807329939,
         0.0716251405050491,
         -0.0947511546982094,
         0.0716251405050491},
        {-0.0966481492887293,
         0.127853483846311,
         -0.0966481492887293,
         0.110866501492697,
         -0.082599999726255,
         -0.00109975278653556,
         0.0565330035328842,
         -0.0964099588182285,
         0.0284850126116927,
         0.0375107728678998,
         -0.0322616848350513,
         -0.0195707891122903,
         0.0622446595323851,
         0.0196601544616759,
         -0.0498703762947079,
         0.0192429585001113,
         0.00888997944805172,
         0.0095369513792215,
         0.000374465541790652,
         -0.0767955258464902,
         0.0735864433953516,
         -0.0368479302792468,
         0.0200514844631129,
         -0.0236624239930419,
         0.00798806113508631,
         -0.0747195438016613,
         0.098426000284359,
         -0.0467005285703765,
         -0.00562141714609677,
         0.0316768385192413,
         -0.044229828274971,
         0.0566439715691768,
         -0.0495699615819368,
         0.103518936304882,
         -0.0388099132134588,
         -0.0256250291658011,
         0.0525875919072054,
         -0.0495086149311421,
         0.032158495923705,
         -0.00662239266293944,
         -0.0304597912483002,
         0.0733886372428761,
         0.0565330035328844,
         -0.00109975278653558,
         -0.0825999997262552,
         0.110866501492697,
         -0.0779488908269202,
         -0.0217242058846571,
         0.0794272843060628,
         -0.0217242058846573,
         -0.0779488908269202,
         0.0879924556802986,
         0.0315146944136672,
         -0.0379547774100374,
         -0.0429036797282751,
         0.0689275796440815,
         0.0222439228990718,
         -0.108340487057759,
         0.000836965366082821,
         -0.0430478947619489,
         0.10515908647117,
         -0.0770694240013697,
         0.00622059043931394,
         -0.0278153087324302,
         0.095890510696547,
         0.00551393701900362,
         0.0432473766318398,
         -0.0529234316749972,
         -0.00835000383472688,
         0.0566365779565726,
         -0.0413663507572612,
         0.051792580290505,
         -0.0172402388496514,
         -0.0252595882162508,
         -0.0438354814949252,
         0.0385633529038864,
         0.00193814149323072,
         -0.0133839161661984,
         -0.00329439334765688,
         0.00117315678150835,
         -0.0161501759167752,
         -0.0747195438016613,
         0.0984260002843589,
         -0.0467005285703764,
         -0.00562141714609684,
         0.0316768385192412,
         -0.0442298282749711,
         0.0566439715691769,
         -0.0495699615819367,
         -0.0195707891122902,
         -0.0322616848350511,
         0.0375107728678999,
         0.0284850126116927,
         -0.0964099588182286,
         0.0222439228990718,
         0.0689275796440817,
         -0.0429036797282751,
         -0.0379547774100375,
         0.0315146944136672,
         0.0879924556802986,
         0.000626789860291423,
         -0.124188202838874,
         0.0635440777003311,
         -0.00671300354358013,
         0.0635440777003309,
         -0.124188202838874,
         0.000626789860291506,
         0.0231474015163364,
         0.0897395552666676,
         0.0125134783593096,
         -0.0329878802107493,
         -0.0361709527509339,
         0.0395900601461968,
         0.0618475374696938,
         -0.0238244119424932,
         -0.0685268412762085,
         -0.0670316701742916,
         -0.020711141168155,
         -0.0217407624601776,
         0.0847155820178145,
         -0.0507933381591812,
         -0.0237462233635326,
         0.0014474773977457,
         -0.0301745161870987,
         0.0958905106965469,
         0.00551393701900369,
         0.0432473766318399,
         -0.0529234316749972,
         -0.00835000383472685,
         0.0566365779565727,
         -0.0413663507572611,
         0.0517925802905049,
         0.00037446554179068,
         -0.0767955258464901,
         0.0735864433953515,
         -0.0368479302792467,
         0.0200514844631131,
         -0.0236624239930418,
         0.0079880611350861,
         0.00953695137922148,
         0.00888997944805179,
         0.0192429585001112,
         -0.0498703762947079,
         0.0196601544616758,
         0.0622446595323851,
         -0.02781530873243,
         0.006220590439314,
         -0.0770694240013697,
         0.10515908647117,
         -0.0430478947619491,
         0.000836965366082828,
         -0.108340487057759,
         -0.0238244119424932,
         0.0618475374696938,
         0.039590060146197,
         -0.0361709527509338,
         -0.0329878802107494,
         0.0125134783593096,
         0.0897395552666678,
         0.0231474015163367,
         0.0496270670807583,
         -0.0487979020334445,
         -0.0915444752879649,
         0.0490021142439823,
         0.00456808741676557,
         0.0490021142439823,
         -0.0915444752879647,
         -0.0487979020334446,
         0.0496270670807582,
         0.0231474015163365,
         0.0897395552666676,
         0.0125134783593096,
         -0.0329878802107494,
         -0.0361709527509338,
         0.0395900601461969,
         0.0618475374696937,
         -0.0238244119424932,
         -0.108340487057759,
         0.000836965366082625,
         -0.0430478947619489,
         0.10515908647117,
         -0.0770694240013699,
         0.006220590439314,
         -0.0278153087324301,
         0.0622446595323851,
         0.0196601544616757,
         -0.0498703762947079,
         0.0192429585001113,
         0.00888997944805204,
         0.00953695137922145,
         0.00798806113508624,
         -0.0236624239930418,
         0.020051484463113,
         -0.036847930279247,
         0.0735864433953515,
         -0.0767955258464902,
         0.000374465541790618,
         0.051792580290505,
         -0.0413663507572611,
         0.0566365779565726,
         -0.0083500038347268,
         -0.0529234316749972,
         0.0432473766318399,
         0.00551393701900362,
         0.095890510696547,
         -0.030174516187099,
         0.0014474773977457,
         -0.0237462233635327,
         -0.050793338159181,
         0.0847155820178145,
         -0.0217407624601777,
         -0.0207111411681552,
         -0.0670316701742916,
         -0.0685268412762087,
         -0.0238244119424931,
         0.0618475374696937,
         0.0395900601461969,
         -0.0361709527509338,
         -0.0329878802107493,
         0.0125134783593097,
         0.0897395552666677,
         0.0231474015163367,
         0.000626789860291392,
         -0.124188202838874,
         0.0635440777003309,
         -0.00671300354358037,
         0.0635440777003309,
         -0.124188202838874,
         0.000626789860291472,
         0.0879924556802985,
         0.0315146944136673,
         -0.0379547774100373,
         -0.042903679728275,
         0.0689275796440817,
         0.0222439228990718,
         -0.0964099588182285,
         0.0284850126116927,
         0.0375107728678999,
         -0.0322616848350511,
         -0.0195707891122902,
         -0.0495699615819367,
         0.0566439715691766,
         -0.044229828274971,
         0.0316768385192411,
         -0.00562141714609693,
         -0.0467005285703764,
         0.0984260002843587,
         -0.0747195438016612,
         -0.016150175916775,
         0.00117315678150843,
         -0.00329439334765689,
         -0.0133839161661984,
         0.00193814149323065,
         0.0385633529038864,
         -0.0438354814949252,
         -0.0252595882162509,
         -0.0172402388496513,
         0.051792580290505,
         -0.0413663507572613,
         0.0566365779565727,
         -0.00835000383472667,
         -0.0529234316749973,
         0.0432473766318397,
         0.00551393701900367,
         0.0958905106965469,
         -0.0278153087324301,
         0.0062205904393139,
         -0.0770694240013698,
         0.10515908647117,
         -0.0430478947619488,
         0.000836965366082766,
         -0.108340487057759,
         0.0222439228990718,
         0.0689275796440816,
         -0.042903679728275,
         -0.0379547774100374,
         0.0315146944136671,
         0.0879924556802986,
         -0.0779488908269202,
         -0.0217242058846571,
         0.0794272843060628,
         -0.0217242058846571,
         -0.0779488908269203,
         0.110866501492697,
         -0.0825999997262552,
         -0.00109975278653563,
         0.0565330035328845,
         0.0733886372428762,
         -0.0304597912483003,
         -0.00662239266293965,
         0.0321584959237049,
         -0.0495086149311421,
         0.0525875919072054,
         -0.0256250291658013,
         -0.038809913213459,
         0.103518936304882,
         -0.0495699615819366,
         0.0566439715691768,
         -0.0442298282749712,
         0.0316768385192413,
         -0.00562141714609675,
         -0.0467005285703764,
         0.0984260002843589,
         -0.0747195438016611,
         0.00798806113508615,
         -0.0236624239930418,
         0.020051484463113,
         -0.0368479302792468,
         0.0735864433953515,
         -0.0767955258464904,
         0.00037446554179078,
         0.00953695137922139,
         0.00888997944805173,
         0.0192429585001113,
         -0.049870376294708,
         0.019660154461676,
         0.062244659532385,
         -0.0195707891122902,
         -0.0322616848350512,
         0.0375107728678998,
         0.0284850126116927,
         -0.0964099588182286,
         0.0565330035328843,
         -0.00109975278653553,
         -0.082599999726255,
         0.110866501492697,
         -0.0966481492887292,
         0.127853483846311,
         -0.0966481492887292},
        {0.00628487037591333,
         -0.00831410201847159,
         0.00628487037591331,
         0.00165828988191032,
         -0.00793029222789873,
         0.0133731496329319,
         -0.0125440046919767,
         -0.00565803966692398,
         0.00709212176835454,
         -0.00133938998243131,
         -0.00878652628348908,
         0.0144270379362847,
         -0.0063000512855479,
         0.0168909107832974,
         -0.0267545286890886,
         0.0278481360302726,
         -0.016493408236619,
         -0.000743788251127067,
         0.0216784395817093,
         -0.0248017038710853,
         0.014005761320319,
         0.00708161248667529,
         -0.0282892809030076,
         0.0364442495954656,
         -0.0236888658329974,
         0.0142372828324164,
         -0.0430713871353437,
         0.069799627972324,
         -0.0840145462046048,
         0.0790070899935415,
         -0.0549491643430388,
         0.0212966680393562,
         0.00392197792375541,
         -0.0423215095048112,
         0.0299916608910743,
         -0.00179481920043747,
         -0.0385040147987196,
         0.084520676913542,
         -0.127794642305845,
         0.159519557131044,
         -0.173461499036857,
         0.170064966521804,
         -0.0125440046919766,
         0.0133731496329318,
         -0.00793029222789839,
         0.00165828988191017,
         0.00427688855004317,
         0.0026649510054542,
         -0.00658495698646073,
         0.00266495100545422,
         0.00427688855004312,
         0.0192397378277792,
         -0.0303023972380084,
         0.0293231138806194,
         -0.0236416795635,
         0.0227082219710007,
         -0.0252881716200086,
         -0.0197459343506804,
         0.0115111357529584,
         0.00323843291048592,
         -0.0119090959005878,
         0.0143576743326783,
         -0.0205683935499418,
         0.0347893943792866,
         -0.0514946165456344,
         0.0735306270538547,
         -0.0777966084856262,
         0.0712744262161864,
         -0.0659284391003759,
         0.0669184796110982,
         -0.0632636260274899,
         0.0311220885414887,
         0.0258817113531623,
         0.0193611715687631,
         -0.053309052185547,
         0.0709963865173225,
         -0.0753783545051458,
         0.0787228354737626,
         -0.0968760104356806,
         0.136401591236553,
         -0.174593676541876,
         0.0142372828324164,
         -0.0430713871353435,
         0.0697996279723238,
         -0.0840145462046049,
         0.0790070899935415,
         -0.0549491643430388,
         0.0212966680393564,
         0.00392197792375543,
         0.0144270379362846,
         -0.00878652628348913,
         -0.00133938998243128,
         0.0070921217683546,
         -0.00565803966692412,
         -0.0252881716200086,
         0.0227082219710007,
         -0.0236416795635001,
         0.0293231138806195,
         -0.0303023972380085,
         0.0192397378277793,
         -0.00418222966554548,
         0.0130356990567342,
         -0.00916239091721603,
         0.00542331692282081,
         -0.00916239091721589,
         0.0130356990567339,
         -0.00418222966554542,
         0.0797732307463399,
         -0.0783312748399503,
         0.0670219194853871,
         -0.0655800307625242,
         0.0698001500069724,
         -0.0692734879089762,
         0.0657806454977835,
         -0.0752559064124083,
         0.0201764738753674,
         -0.060305597570623,
         0.0706815439508358,
         -0.0674185437269355,
         0.067817987021695,
         -0.0752665043687317,
         0.0819499806082324,
         -0.0893835016794066,
         0.146757234309661,
         -0.0514946165456345,
         0.0735306270538545,
         -0.0777966084856262,
         0.0712744262161863,
         -0.0659284391003758,
         0.0669184796110981,
         -0.0632636260274897,
         0.0311220885414889,
         0.0216784395817093,
         -0.024801703871085,
         0.0140057613203191,
         0.00708161248667521,
         -0.0282892809030077,
         0.0364442495954654,
         -0.0236888658329975,
         -0.000743788251126989,
         -0.016493408236619,
         0.0278481360302726,
         -0.0267545286890888,
         0.0168909107832973,
         -0.00630005128554805,
         0.0347893943792867,
         -0.0205683935499417,
         0.0143576743326782,
         -0.0119090959005878,
         0.00323843291048584,
         0.0115111357529586,
         -0.0197459343506804,
         -0.0752559064124084,
         0.0657806454977835,
         -0.0692734879089761,
         0.0698001500069726,
         -0.0655800307625242,
         0.0670219194853873,
         -0.0783312748399502,
         0.07977323074634,
         -0.0853110440293124,
         0.0797784742189174,
         -0.0681588493091441,
         0.0699972472287295,
         -0.0732661375392812,
         0.0699972472287294,
         -0.0681588493091442,
         0.0797784742189175,
         -0.0853110440293124,
         0.0797732307463399,
         -0.0783312748399503,
         0.0670219194853872,
         -0.0655800307625242,
         0.0698001500069726,
         -0.0692734879089762,
         0.0657806454977834,
         -0.0752559064124084,
         -0.0197459343506805,
         0.0115111357529587,
         0.00323843291048585,
         -0.0119090959005877,
         0.0143576743326782,
         -0.0205683935499417,
         0.0347893943792867,
         -0.00630005128554796,
         0.0168909107832974,
         -0.0267545286890889,
         0.0278481360302727,
         -0.0164934082366191,
         -0.000743788251127,
         -0.0236888658329976,
         0.0364442495954654,
         -0.0282892809030076,
         0.00708161248667516,
         0.0140057613203191,
         -0.0248017038710852,
         0.0216784395817094,
         0.0311220885414889,
         -0.0632636260274898,
         0.066918479611098,
         -0.0659284391003759,
         0.0712744262161862,
         -0.0777966084856261,
         0.0735306270538545,
         -0.0514946165456344,
         0.146757234309661,
         -0.0893835016794065,
         0.0819499806082324,
         -0.0752665043687317,
         0.0678179870216951,
         -0.0674185437269355,
         0.0706815439508357,
         -0.0603055975706231,
         0.0201764738753674,
         -0.0752559064124084,
         0.0657806454977834,
         -0.0692734879089761,
         0.0698001500069725,
         -0.0655800307625242,
         0.0670219194853872,
         -0.0783312748399501,
         0.07977323074634,
         -0.00418222966554535,
         0.0130356990567341,
         -0.0091623909172162,
         0.00542331692282085,
         -0.00916239091721609,
         0.0130356990567339,
         -0.00418222966554534,
         0.0192397378277791,
         -0.0303023972380085,
         0.0293231138806194,
         -0.0236416795635001,
         0.0227082219710006,
         -0.0252881716200086,
         -0.00565803966692409,
         0.00709212176835461,
         -0.00133938998243118,
         -0.0087865262834892,
         0.0144270379362846,
         0.00392197792375533,
         0.0212966680393562,
         -0.0549491643430386,
         0.0790070899935415,
         -0.0840145462046049,
         0.069799627972324,
         -0.0430713871353434,
         0.0142372828324163,
         -0.174593676541875,
         0.136401591236554,
         -0.0968760104356804,
         0.0787228354737628,
         -0.0753783545051459,
         0.0709963865173223,
         -0.053309052185547,
         0.0193611715687631,
         0.0258817113531623,
         0.0311220885414888,
         -0.0632636260274898,
         0.0669184796110982,
         -0.0659284391003759,
         0.0712744262161862,
         -0.0777966084856261,
         0.0735306270538545,
         -0.0514946165456343,
         0.0347893943792867,
         -0.0205683935499419,
         0.0143576743326783,
         -0.0119090959005876,
         0.00323843291048575,
         0.0115111357529586,
         -0.0197459343506804,
         -0.0252881716200086,
         0.0227082219710006,
         -0.0236416795635002,
         0.0293231138806194,
         -0.0303023972380085,
         0.0192397378277791,
         0.00427688855004318,
         0.00266495100545415,
         -0.00658495698646084,
         0.00266495100545401,
         0.00427688855004311,
         0.00165828988191017,
         -0.00793029222789854,
         0.0133731496329318,
         -0.0125440046919766,
         0.170064966521804,
         -0.173461499036858,
         0.159519557131044,
         -0.127794642305845,
         0.0845206769135418,
         -0.0385040147987196,
         -0.00179481920043725,
         0.0299916608910742,
         -0.042321509504811,
         0.0039219779237553,
         0.0212966680393562,
         -0.0549491643430389,
         0.0790070899935416,
         -0.0840145462046049,
         0.069799627972324,
         -0.0430713871353435,
         0.0142372828324165,
         -0.0236888658329975,
         0.0364442495954654,
         -0.0282892809030077,
         0.00708161248667528,
         0.0140057613203191,
         -0.0248017038710851,
         0.0216784395817095,
         -0.000743788251126974,
         -0.016493408236619,
         0.0278481360302726,
         -0.0267545286890887,
         0.0168909107832972,
         -0.00630005128554792,
         0.0144270379362846,
         -0.00878652628348917,
         -0.00133938998243104,
         0.00709212176835457,
         -0.00565803966692399,
         -0.0125440046919767,
         0.0133731496329316,
         -0.00793029222789864,
         0.00165828988191026,
         0.00628487037591333,
         -0.00831410201847171,
         0.00628487037591347},
        {0.0188287437203047,
         -0.0249080866918476,
         0.0188287437203046,
         -0.0275707663961853,
         0.0250499792111475,
         -0.00874380882801678,
         -0.00504157437007595,
         -0.0246333520234836,
         0.0697738033262818,
         -0.100287152923365,
         0.0949622057505453,
         -0.0564944409361157,
         0.072762983603483,
         -0.0848788072123014,
         0.0368515891492724,
         0.0450325283236311,
         -0.111234324620342,
         0.11411116973794,
         -0.075204662401127,
         0.0236909026061738,
         0.0502664611860141,
         -0.0830746989635517,
         0.0439295329502886,
         0.0494076531524252,
         -0.126109815371641,
         0.0329001289395166,
         0.0405585890389614,
         -0.0660115843322932,
         0.0321159114153502,
         0.0266267715668086,
         -0.0563232441099444,
         0.0128461419632475,
         0.0968714764696894,
         0.0418212451940594,
         -0.0703135926434642,
         0.0437617634503721,
         -0.00564995746648882,
         -0.011940651670536,
         -0.0026434317501423,
         0.0351616718986517,
         -0.0435714458893274,
         -0.0403217136355301,
         -0.00504157437007577,
         -0.00874380882801693,
         0.0250499792111475,
         -0.0275707663961852,
         0.082138622992393,
         -0.101629450682461,
         0.104562071011735,
         -0.101629450682461,
         0.0821386229923929,
         -0.0579282563500188,
         0.0210919518121783,
         0.0150051819505794,
         -0.0350403334308138,
         0.049166777843799,
         -0.058233298280474,
         -0.0196737309901706,
         0.037443339102831,
         -0.00871448034901402,
         -0.02434208583169,
         0.0255697242485125,
         0.00144796024004171,
         -0.0193001324502859,
         0.07240313553198,
         -0.00655589612570395,
         -0.0427414448247526,
         0.0231474272234551,
         0.0412097579644506,
         -0.0829624284714388,
         0.0434582081995771,
         0.0675753865759409,
         -0.0798110417932661,
         -0.0296304720729574,
         0.00861938638406236,
         0.0613500116280557,
         -0.0953083235218076,
         0.0515845407934101,
         0.0427702425686335,
         -0.0879089061220591,
         -0.0715358323976134,
         0.0329001289395165,
         0.0405585890389613,
         -0.0660115843322933,
         0.03211591141535,
         0.0266267715668085,
         -0.0563232441099445,
         0.0128461419632476,
         0.0968714764696895,
         -0.0564944409361157,
         0.0949622057505455,
         -0.100287152923365,
         0.0697738033262817,
         -0.0246333520234838,
         -0.058233298280474,
         0.0491667778437989,
         -0.0350403334308137,
         0.0150051819505793,
         0.0210919518121784,
         -0.0579282563500186,
         0.0992704039172149,
         -0.019033039612904,
         -0.0366306308326323,
         0.0535453954030721,
         -0.0366306308326323,
         -0.0190330396129039,
         0.0992704039172148,
         -0.0560353886961208,
         -0.02545716659166,
         0.0148414869447679,
         0.0207598741120237,
         -0.0450235050846489,
         0.0530064865194766,
         -0.0322861611411632,
         -0.0511889024394929,
         0.0150517086598111,
         -0.0273718201546216,
         0.0564813201726357,
         -0.0367417514906878,
         0.00429351939291453,
         0.00144183837551219,
         0.0171150898278772,
         -0.0239528024616431,
         0.0110945692017613,
         0.0724031355319799,
         -0.00655589612570406,
         -0.0427414448247525,
         0.023147427223455,
         0.0412097579644508,
         -0.0829624284714389,
         0.0434582081995771,
         0.0675753865759408,
         -0.075204662401127,
         0.0236909026061741,
         0.0502664611860142,
         -0.0830746989635518,
         0.0439295329502888,
         0.049407653152425,
         -0.126109815371642,
         0.11411116973794,
         -0.111234324620343,
         0.045032528323631,
         0.0368515891492725,
         -0.0848788072123012,
         0.0727629836034832,
         -0.0193001324502857,
         0.00144796024004169,
         0.0255697242485124,
         -0.02434208583169,
         -0.00871448034901406,
         0.0374433391028311,
         -0.0196737309901703,
         -0.0511889024394929,
         -0.0322861611411632,
         0.0530064865194768,
         -0.0450235050846487,
         0.0207598741120238,
         0.0148414869447679,
         -0.02545716659166,
         -0.0560353886961208,
         0.0307009946215278,
         0.100621406035414,
         -0.0471614725926121,
         -0.00823616576381878,
         0.0270306934989184,
         -0.00823616576381869,
         -0.0471614725926122,
         0.100621406035414,
         0.0307009946215277,
         -0.0560353886961208,
         -0.02545716659166,
         0.014841486944768,
         0.0207598741120237,
         -0.045023505084649,
         0.0530064865194768,
         -0.0322861611411633,
         -0.0511889024394929,
         -0.0196737309901704,
         0.0374433391028312,
         -0.00871448034901402,
         -0.0243420858316898,
         0.0255697242485126,
         0.0014479602400416,
         -0.0193001324502858,
         0.0727629836034832,
         -0.084878807212301,
         0.0368515891492724,
         0.045032528323631,
         -0.111234324620342,
         0.11411116973794,
         -0.126109815371642,
         0.0494076531524251,
         0.0439295329502887,
         -0.0830746989635518,
         0.050266461186014,
         0.0236909026061742,
         -0.0752046624011272,
         0.0675753865759409,
         0.043458208199577,
         -0.082962428471439,
         0.0412097579644505,
         0.0231474272234551,
         -0.0427414448247529,
         -0.00655589612570405,
         0.0724031355319798,
         0.0110945692017614,
         -0.0239528024616431,
         0.0171150898278771,
         0.00144183837551204,
         0.00429351939291464,
         -0.0367417514906877,
         0.0564813201726358,
         -0.0273718201546216,
         0.0150517086598112,
         -0.0511889024394928,
         -0.0322861611411631,
         0.0530064865194768,
         -0.0450235050846488,
         0.0207598741120235,
         0.0148414869447678,
         -0.0254571665916602,
         -0.0560353886961207,
         0.0992704039172149,
         -0.0190330396129039,
         -0.0366306308326324,
         0.0535453954030724,
         -0.0366306308326323,
         -0.0190330396129041,
         0.0992704039172151,
         -0.0579282563500186,
         0.0210919518121785,
         0.0150051819505793,
         -0.0350403334308136,
         0.0491667778437992,
         -0.0582332982804739,
         -0.0246333520234838,
         0.0697738033262818,
         -0.100287152923365,
         0.0949622057505453,
         -0.0564944409361156,
         0.0968714764696895,
         0.0128461419632477,
         -0.0563232441099447,
         0.0266267715668085,
         0.03211591141535,
         -0.0660115843322932,
         0.0405585890389613,
         0.0329001289395166,
         -0.0715358323976134,
         -0.0879089061220591,
         0.0427702425686335,
         0.05158454079341,
         -0.0953083235218075,
         0.0613500116280555,
         0.00861938638406235,
         -0.0296304720729573,
         -0.0798110417932659,
         0.0675753865759407,
         0.0434582081995771,
         -0.0829624284714389,
         0.0412097579644506,
         0.0231474272234551,
         -0.0427414448247526,
         -0.00655589612570392,
         0.0724031355319798,
         -0.0193001324502858,
         0.00144796024004165,
         0.0255697242485125,
         -0.0243420858316898,
         -0.00871448034901418,
         0.0374433391028311,
         -0.0196737309901706,
         -0.0582332982804739,
         0.0491667778437991,
         -0.0350403334308136,
         0.0150051819505794,
         0.0210919518121784,
         -0.0579282563500187,
         0.0821386229923928,
         -0.101629450682461,
         0.104562071011735,
         -0.101629450682461,
         0.082138622992393,
         -0.0275707663961853,
         0.0250499792111475,
         -0.00874380882801681,
         -0.0050415743700758,
         -0.0403217136355302,
         -0.0435714458893274,
         0.0351616718986517,
         -0.00264343175014219,
         -0.0119406516705359,
         -0.00564995746648882,
         0.0437617634503722,
         -0.0703135926434644,
         0.0418212451940596,
         0.0968714764696896,
         0.0128461419632476,
         -0.0563232441099444,
         0.0266267715668086,
         0.03211591141535,
         -0.0660115843322932,
         0.0405585890389613,
         0.0329001289395165,
         -0.126109815371642,
         0.0494076531524252,
         0.0439295329502888,
         -0.0830746989635517,
         0.050266461186014,
         0.023690902606174,
         -0.0752046624011269,
         0.11411116973794,
         -0.111234324620342,
         0.045032528323631,
         0.0368515891492725,
         -0.0848788072123012,
         0.0727629836034832,
         -0.0564944409361156,
         0.0949622057505456,
         -0.100287152923365,
         0.0697738033262818,
         -0.0246333520234837,
         -0.00504157437007567,
         -0.00874380882801692,
         0.0250499792111475,
         -0.0275707663961855,
         0.0188287437203047,
         -0.0249080866918476,
         0.0188287437203047},
        {0.039087697587861,
         -0.0517081635697897,
         0.039087697587861,
         0.00647241964427956,
         -0.0435595685529511,
         0.0774105076394822,
         -0.0741742978173425,
         -0.0357423045393888,
         0.0492771604321649,
         -0.0190604932257382,
         -0.0408886107710381,
         0.078309377055708,
         0.0639548590778574,
         -0.0573463068842297,
         0.0229201610398865,
         -0.00735733349027496,
         0.0378277685463511,
         -0.0845825641193561,
         -0.0830582524583377,
         0.046258993031329,
         -0.0021977083488997,
         -0.0163976451182832,
         0.0212551380671407,
         -0.0470845879000807,
         0.100451099676275,
         0.0589077151400655,
         0.0149343670127672,
         -0.0560299652530051,
         0.0606988442274823,
         -0.049103958168854,
         0.0315544527206314,
         0.00726636819386931,
         -0.0903895323337358,
         0.07315970240102,
         -0.124175280191214,
         0.114398442006606,
         -0.082049526485098,
         0.0488034002872136,
         -0.0219080547353425,
         0.00369008296295471,
         -0.00844703757378684,
         0.0867266688109973,
         -0.0741742978173425,
         0.0774105076394823,
         -0.043559568552951,
         0.00647241964427945,
         0.0343261492760037,
         0.00435713887423573,
         -0.0271011726251952,
         0.00435713887423568,
         0.0343261492760039,
         -0.0251896075760906,
         0.0324042087805755,
         -0.0746723658143745,
         0.105876968129106,
         -0.0692683749444425,
         -0.0233548982740774,
         0.0066890417798332,
         -0.0345692526354438,
         0.048859662250215,
         -0.00376583590810269,
         -0.0744095837172644,
         0.0951914546700905,
         0.00444199097169756,
         0.0508240430934932,
         -0.00349570231561974,
         0.00568504318335577,
         -0.0446174613510196,
         0.0565158254235937,
         -0.00762012253012335,
         -0.0438188813813561,
         -0.036749204836016,
         -0.141180472787946,
         0.0333418873735365,
         -0.0401643178728344,
         0.0682758523900073,
         -0.0699726691072569,
         0.0569052912577503,
         -0.0694435590387267,
         0.101720318464792,
         0.0176461728386164,
         0.0589077151400655,
         0.014934367012767,
         -0.0560299652530051,
         0.0606988442274823,
         -0.0491039581688536,
         0.0315544527206313,
         0.00726636819386931,
         -0.0903895323337359,
         0.0783093770557079,
         -0.040888610771038,
         -0.0190604932257381,
         0.0492771604321648,
         -0.0357423045393887,
         -0.0233548982740773,
         -0.0692683749444426,
         0.105876968129106,
         -0.0746723658143747,
         0.0324042087805755,
         -0.0251896075760907,
         0.0264679267781913,
         0.0145725173402688,
         0.0137384172453003,
         -0.0377401006424907,
         0.0137384172453002,
         0.0145725173402689,
         0.0264679267781915,
         -0.0635895307002376,
         0.0442260084700883,
         -0.0344227584643702,
         -0.01135043939345,
         0.0432466437554165,
         0.000946420365382249,
         -0.0836845960644863,
         0.0350009023212534,
         0.0957220666885736,
         -0.0746641227134743,
         0.0366732028244656,
         -0.0128045192365414,
         0.0531458412657697,
         -0.126607270875967,
         0.131514225874923,
         -0.0170036307601772,
         0.0152233152143421,
         0.0508240430934933,
         -0.00349570231561958,
         0.00568504318335574,
         -0.0446174613510196,
         0.0565158254235937,
         -0.00762012253012334,
         -0.043818881381356,
         -0.0367492048360159,
         -0.0830582524583377,
         0.0462589930313288,
         -0.00219770834889974,
         -0.0163976451182831,
         0.0212551380671405,
         -0.0470845879000806,
         0.100451099676275,
         -0.0845825641193562,
         0.037827768546351,
         -0.00735733349027498,
         0.0229201610398864,
         -0.0573463068842298,
         0.0639548590778573,
         0.00444199097169758,
         0.0951914546700906,
         -0.0744095837172644,
         -0.00376583590810243,
         0.048859662250215,
         -0.0345692526354438,
         0.00668904177983302,
         0.0350009023212534,
         -0.0836845960644864,
         0.000946420365382286,
         0.0432466437554165,
         -0.0113504393934499,
         -0.0344227584643703,
         0.0442260084700884,
         -0.0635895307002377,
         -0.0438014322890307,
         0.0788152082763116,
         -0.042283654772782,
         0.0696169703725864,
         -0.0943236640328115,
         0.0696169703725864,
         -0.0422836547727821,
         0.0788152082763117,
         -0.0438014322890306,
         -0.0635895307002377,
         0.0442260084700884,
         -0.0344227584643703,
         -0.0113504393934499,
         0.0432466437554165,
         0.000946420365381903,
         -0.0836845960644863,
         0.0350009023212535,
         0.00668904177983304,
         -0.0345692526354436,
         0.048859662250215,
         -0.00376583590810261,
         -0.0744095837172644,
         0.0951914546700907,
         0.00444199097169764,
         0.0639548590778574,
         -0.0573463068842299,
         0.0229201610398864,
         -0.00735733349027513,
         0.037827768546351,
         -0.0845825641193563,
         0.100451099676275,
         -0.0470845879000806,
         0.0212551380671406,
         -0.0163976451182831,
         -0.00219770834889958,
         0.046258993031329,
         -0.0830582524583378,
         -0.036749204836016,
         -0.043818881381356,
         -0.00762012253012341,
         0.0565158254235937,
         -0.0446174613510195,
         0.00568504318335577,
         -0.0034957023156195,
         0.0508240430934932,
         0.015223315214342,
         -0.0170036307601771,
         0.131514225874923,
         -0.126607270875967,
         0.0531458412657697,
         -0.0128045192365414,
         0.0366732028244656,
         -0.0746641227134741,
         0.0957220666885735,
         0.0350009023212535,
         -0.0836845960644863,
         0.000946420365382326,
         0.0432466437554166,
         -0.0113504393934498,
         -0.0344227584643704,
         0.0442260084700882,
         -0.0635895307002377,
         0.0264679267781913,
         0.014572517340269,
         0.0137384172453003,
         -0.0377401006424905,
         0.0137384172453004,
         0.0145725173402688,
         0.0264679267781913,
         -0.0251896075760907,
         0.0324042087805756,
         -0.0746723658143748,
         0.105876968129106,
         -0.0692683749444426,
         -0.0233548982740774,
         -0.0357423045393889,
         0.0492771604321647,
         -0.0190604932257382,
         -0.040888610771038,
         0.0783093770557081,
         -0.0903895323337359,
         0.00726636819386947,
         0.0315544527206312,
         -0.0491039581688537,
         0.0606988442274823,
         -0.0560299652530051,
         0.0149343670127672,
         0.0589077151400656,
         0.0176461728386164,
         0.101720318464792,
         -0.0694435590387268,
         0.0569052912577501,
         -0.0699726691072571,
         0.0682758523900071,
         -0.0401643178728347,
         0.0333418873735368,
         -0.141180472787945,
         -0.0367492048360161,
         -0.043818881381356,
         -0.00762012253012341,
         0.0565158254235938,
         -0.0446174613510195,
         0.00568504318335563,
         -0.00349570231561953,
         0.0508240430934934,
         0.00444199097169769,
         0.0951914546700905,
         -0.0744095837172645,
         -0.00376583590810247,
         0.0488596622502152,
         -0.0345692526354438,
         0.00668904177983302,
         -0.0233548982740775,
         -0.0692683749444425,
         0.105876968129106,
         -0.0746723658143747,
         0.0324042087805757,
         -0.0251896075760906,
         0.0343261492760037,
         0.00435713887423552,
         -0.0271011726251953,
         0.00435713887423555,
         0.0343261492760037,
         0.00647241964427952,
         -0.0435595685529508,
         0.0774105076394824,
         -0.0741742978173425,
         0.0867266688109971,
         -0.0084470375737869,
         0.00369008296295461,
         -0.0219080547353424,
         0.0488034002872136,
         -0.0820495264850981,
         0.114398442006606,
         -0.124175280191214,
         0.0731597024010201,
         -0.090389532333736,
         0.00726636819386965,
         0.0315544527206313,
         -0.0491039581688539,
         0.0606988442274822,
         -0.0560299652530051,
         0.0149343670127671,
         0.0589077151400655,
         0.100451099676275,
         -0.0470845879000806,
         0.0212551380671406,
         -0.0163976451182831,
         -0.00219770834889942,
         0.0462589930313289,
         -0.0830582524583377,
         -0.0845825641193561,
         0.0378277685463512,
         -0.00735733349027508,
         0.0229201610398864,
         -0.0573463068842297,
         0.0639548590778574,
         0.0783093770557079,
         -0.0408886107710379,
         -0.0190604932257383,
         0.0492771604321647,
         -0.0357423045393888,
         -0.0741742978173424,
         0.0774105076394822,
         -0.0435595685529508,
         0.00647241964427955,
         0.039087697587861,
         -0.0517081635697898,
         0.0390876975878612},
        {-0.113000489986603,
         0.0857888677352439,
         0.0272116222513591,
         -0.0298492792875376,
         -0.0740011197379664,
         0.0287279661963476,
         -0.0263772695779195,
         0.0843398232981855,
         -0.000430440626625701,
         -0.0284410057785969,
         0.0480882572582409,
         -0.0343280856608353,
         -0.0618809792935589,
         0.0550276182911673,
         -0.00636151582428937,
         -0.0280482459279507,
         -0.031686040069649,
         0.0789019716932728,
         -0.0136736922234851,
         -0.0435873865926476,
         0.0339285996016999,
         -0.0102663861972452,
         0.0574719481877937,
         -0.0327635243982124,
         -0.0443661846023231,
         0.0550614617655532,
         -0.00471709839565718,
         -0.0307838673379284,
         0.0482819492635862,
         -0.0502898629118147,
         -0.00044860358828254,
         0.0293675822457213,
         0.00775183094087374,
         -0.0534217566046909,
         0.0512736506136548,
         -0.00797536932897037,
         -0.0478397386700317,
         -0.000442210593554297,
         0.038457773659895,
         -0.0381587046010401,
         0.0195850147472795,
         -0.0244877031092247,
         0.0601022075123524,
         -0.098861444179251,
         0.106836813508221,
         0.0272116222513591,
         0.085788867735244,
         -0.0740011197379664,
         -0.0151062102031165,
         -0.0740011197379663,
         0.0843398232981855,
         0.00123382412374554,
         0.0698119745270778,
         -0.000430440626625694,
         -0.0343280856608354,
         -0.0458549961685555,
         -0.0131592604022678,
         -0.0579196372886802,
         0.0550276182911674,
         -0.031686040069649,
         0.0562892402682882,
         0.0134782865476476,
         0.0416467780462017,
         -0.0117270787394002,
         -0.0435873865926477,
         0.0574719481877938,
         -0.00805964802801431,
         -0.0336929935887589,
         -0.0312931423011971,
         -0.00331149431146938,
         0.042064757435312,
         -0.00471709839565699,
         -0.0502898629118149,
         -0.00941430071834901,
         -0.0236311137312978,
         0.0804447242000277,
         -0.0226978038683974,
         -0.0101493393182297,
         -0.0299691492356587,
         0.0512736506136549,
         -0.000442210593554316,
         0.0186874966960647,
         0.0287423670886252,
         -0.00760261465093775,
         -0.0782759602865445,
         0.0923636171113976,
         -0.0477982367723881,
         0.0390081493411484,
         -0.0988614441792508,
         0.0482819492635862,
         -0.0502898629118148,
         -0.000448603588282612,
         0.0293675822457216,
         0.00775183094087384,
         -0.0534217566046909,
         0.051273650613655,
         -0.00797536932897033,
         0.0287279661963476,
         -0.0740011197379663,
         -0.0298492792875376,
         -0.000430440626625688,
         0.0698119745270777,
         0.00123382412374553,
         0.0843398232981857,
         -0.0618809792935589,
         -0.013159260402268,
         -0.0561245998814199,
         -0.0131592604022679,
         -0.0618809792935589,
         0.0789019716932729,
         0.0134782865476477,
         0.0446665612514037,
         0.0230634154506634,
         0.0416467780462018,
         -0.013673692223485,
         -0.0327635243982124,
         -0.0336929935887591,
         -0.0321280440834385,
         -0.025103489012079,
         -0.0340923491273036,
         -0.00331149431146942,
         0.0550614617655534,
         -0.000448603588282486,
         -0.0236311137312977,
         0.0751256422436325,
         -0.0156090207139094,
         0.0668942309940425,
         -0.0265984956341762,
         -0.0101493393182296,
         -0.0534217566046909,
         0.0384577736598951,
         0.0287423670886253,
         0.00746709797393679,
         -0.0617520568387372,
         0.00925518900522595,
         -0.0537262834984086,
         0.0892756550684667,
         -0.0477982367723883,
         0.0601022075123522,
         -0.0502898629118148,
         -0.00941430071834906,
         -0.0236311137312978,
         0.0804447242000277,
         -0.0226978038683973,
         -0.0101493393182297,
         -0.0299691492356587,
         0.0512736506136551,
         -0.0102663861972453,
         0.0574719481877937,
         -0.0327635243982126,
         -0.0443661846023231,
         0.0550614617655533,
         -0.00471709839565718,
         -0.0307838673379284,
         -0.0284410057785968,
         -0.000430440626625775,
         0.0843398232981856,
         -0.0263772695779195,
         0.0550276182911672,
         -0.0579196372886801,
         -0.013159260402268,
         -0.0458549961685554,
         -0.0343280856608354,
         -0.0136736922234848,
         0.0416467780462018,
         0.0230634154506634,
         0.0446665612514036,
         0.0134782865476476,
         0.0789019716932728,
         -0.0443661846023231,
         -0.031293142301197,
         -0.0251034890120787,
         -0.0412685758703407,
         -0.0251034890120788,
         -0.0312931423011971,
         -0.0443661846023231,
         0.0293675822457216,
         0.0804447242000277,
         -0.0156090207139094,
         0.0750427974153991,
         -0.00995896079650438,
         0.0668942309940423,
         -0.0226978038683974,
         0.00775183094087387,
         -0.0381587046010399,
         -0.00760261465093765,
         -0.0617520568387368,
         0.00307976709533817,
         -0.0633145472605269,
         0.00981206837705022,
         -0.0537262834984085,
         0.0923636171113975,
         -0.0244877031092247,
         -0.000448603588282635,
         -0.0236311137312977,
         0.0751256422436325,
         -0.0156090207139093,
         0.0668942309940425,
         -0.026598495634176,
         -0.0101493393182297,
         -0.0534217566046909,
         0.0574719481877938,
         -0.00805964802801414,
         -0.0336929935887589,
         -0.0312931423011972,
         -0.00331149431146933,
         0.0420647574353119,
         -0.00471709839565715,
         -0.0280482459279504,
         -0.0316860400696492,
         0.0789019716932726,
         -0.013673692223485,
         -0.0435873865926476,
         0.0339285996017,
         -0.0063615158242894,
         0.0550276182911673,
         -0.0618809792935589,
         -0.0343280856608353,
         0.0480882572582408,
         -0.0435873865926475,
         -0.0117270787394001,
         0.0416467780462018,
         0.0134782865476474,
         0.0562892402682882,
         -0.0316860400696491,
         0.0550614617655533,
         -0.00331149431146931,
         -0.0340923491273036,
         -0.0251034890120788,
         -0.0321280440834385,
         -0.0336929935887591,
         -0.0327635243982124,
         0.00775183094087369,
         -0.0226978038683974,
         0.0668942309940425,
         -0.00995896079650443,
         0.0750427974153991,
         -0.0156090207139094,
         0.0804447242000277,
         0.0293675822457216,
         0.0195850147472794,
         -0.0782759602865446,
         0.0092551890052261,
         -0.0633145472605268,
         -0.00176928935836752,
         -0.0633145472605268,
         0.00925518900522604,
         -0.0782759602865445,
         0.0195850147472796,
         0.0293675822457217,
         0.0804447242000276,
         -0.0156090207139096,
         0.0750427974153992,
         -0.00995896079650439,
         0.0668942309940425,
         -0.0226978038683975,
         0.00775183094087386,
         -0.0327635243982125,
         -0.033692993588759,
         -0.0321280440834385,
         -0.0251034890120789,
         -0.0340923491273035,
         -0.0033114943114694,
         0.0550614617655532,
         -0.0316860400696491,
         0.0562892402682882,
         0.0134782865476476,
         0.0416467780462018,
         -0.0117270787394001,
         -0.0435873865926476,
         0.0480882572582408,
         -0.0343280856608354,
         -0.0618809792935589,
         0.0550276182911674,
         -0.00636151582428943,
         0.0339285996016999,
         -0.0435873865926476,
         -0.0136736922234849,
         0.0789019716932728,
         -0.0316860400696491,
         -0.0280482459279506,
         -0.004717098395657,
         0.0420647574353118,
         -0.00331149431146925,
         -0.0312931423011971,
         -0.0336929935887589,
         -0.0080596480280142,
         0.0574719481877937,
         -0.053421756604691,
         -0.0101493393182297,
         -0.0265984956341763,
         0.0668942309940425,
         -0.0156090207139094,
         0.0751256422436324,
         -0.0236311137312976,
         -0.000448603588282587,
         -0.0244877031092246,
         0.0923636171113976,
         -0.0537262834984084,
         0.00981206837705017,
         -0.063314547260527,
         0.00307976709533845,
         -0.0617520568387371,
         -0.00760261465093771,
         -0.0381587046010399,
         0.00775183094087376,
         -0.0226978038683974,
         0.0668942309940422,
         -0.00995896079650451,
         0.0750427974153989,
         -0.0156090207139094,
         0.0804447242000276,
         0.0293675822457217,
         -0.0443661846023231,
         -0.031293142301197,
         -0.0251034890120788,
         -0.0412685758703406,
         -0.0251034890120788,
         -0.0312931423011969,
         -0.0443661846023231,
         0.0789019716932729,
         0.0134782865476475,
         0.0446665612514036,
         0.0230634154506634,
         0.0416467780462017,
         -0.013673692223485,
         -0.0343280856608352,
         -0.0458549961685556,
         -0.013159260402268,
         -0.0579196372886802,
         0.0550276182911674,
         -0.0263772695779196,
         0.0843398232981857,
         -0.000430440626625739,
         -0.0284410057785967,
         -0.0307838673379284,
         -0.00471709839565715,
         0.0550614617655532,
         -0.0443661846023232,
         -0.0327635243982126,
         0.0574719481877938,
         -0.0102663861972453,
         0.051273650613655,
         -0.0299691492356587,
         -0.0101493393182299,
         -0.0226978038683973,
         0.0804447242000277,
         -0.0236311137312977,
         -0.00941430071834912,
         -0.0502898629118147,
         0.0601022075123521,
         -0.0477982367723883,
         0.0892756550684666,
         -0.0537262834984087,
         0.00925518900522613,
         -0.0617520568387372,
         0.00746709797393699,
         0.0287423670886252,
         0.038457773659895,
         -0.0534217566046909,
         -0.0101493393182297,
         -0.0265984956341762,
         0.0668942309940425,
         -0.0156090207139095,
         0.0751256422436325,
         -0.0236311137312978,
         -0.000448603588282634,
         0.0550614617655533,
         -0.00331149431146946,
         -0.0340923491273036,
         -0.025103489012079,
         -0.0321280440834385,
         -0.0336929935887589,
         -0.0327635243982124,
         -0.013673692223485,
         0.0416467780462018,
         0.0230634154506634,
         0.0446665612514035,
         0.0134782865476476,
         0.078901971693273,
         -0.061880979293559,
         -0.013159260402268,
         -0.05612459988142,
         -0.0131592604022681,
         -0.061880979293559,
         0.0843398232981856,
         0.00123382412374543,
         0.0698119745270779,
         -0.000430440626625721,
         -0.0298492792875375,
         -0.0740011197379662,
         0.0287279661963477,
         -0.00797536932897047,
         0.051273650613655,
         -0.0534217566046909,
         0.00775183094087383,
         0.0293675822457217,
         -0.000448603588282505,
         -0.0502898629118146,
         0.0482819492635861,
         -0.0988614441792508,
         0.0390081493411483,
         -0.0477982367723881,
         0.0923636171113975,
         -0.0782759602865445,
         -0.00760261465093753,
         0.0287423670886252,
         0.0186874966960645,
         -0.000442210593554407,
         0.0512736506136551,
         -0.0299691492356586,
         -0.0101493393182297,
         -0.0226978038683972,
         0.0804447242000276,
         -0.0236311137312977,
         -0.00941430071834891,
         -0.0502898629118149,
         -0.0047170983956569,
         0.042064757435312,
         -0.00331149431146943,
         -0.0312931423011971,
         -0.0336929935887589,
         -0.00805964802801422,
         0.0574719481877938,
         -0.0435873865926475,
         -0.0117270787394,
         0.0416467780462019,
         0.0134782865476475,
         0.0562892402682882,
         -0.031686040069649,
         0.0550276182911673,
         -0.05791963728868,
         -0.0131592604022681,
         -0.0458549961685554,
         -0.0343280856608352,
         -0.000430440626625742,
         0.0698119745270778,
         0.00123382412374553,
         0.0843398232981856,
         -0.0740011197379665,
         -0.0151062102031165,
         -0.0740011197379663,
         0.0857888677352439,
         0.0272116222513591,
         0.106836813508221,
         -0.098861444179251,
         0.0601022075123522,
         -0.0244877031092247,
         0.0195850147472796,
         -0.03815870460104,
         0.038457773659895,
         -0.000442210593554142,
         -0.0478397386700317,
         -0.00797536932897034,
         0.051273650613655,
         -0.0534217566046912,
         0.00775183094087377,
         0.0293675822457216,
         -0.000448603588282613,
         -0.0502898629118148,
         0.0482819492635862,
         -0.0307838673379285,
         -0.00471709839565712,
         0.0550614617655532,
         -0.0443661846023233,
         -0.0327635243982127,
         0.0574719481877938,
         -0.0102663861972453,
         0.0339285996017,
         -0.0435873865926476,
         -0.013673692223485,
         0.0789019716932727,
         -0.031686040069649,
         -0.0280482459279505,
         -0.00636151582428935,
         0.0550276182911674,
         -0.0618809792935589,
         -0.0343280856608354,
         0.0480882572582408,
         -0.0284410057785968,
         -0.000430440626625849,
         0.0843398232981855,
         -0.0263772695779197,
         0.0287279661963476,
         -0.0740011197379664,
         -0.0298492792875373,
         0.0272116222513589,
         0.0857888677352439,
         -0.113000489986603},
        {0.0120307458604105,
         -0.0696781262544042,
         0.0576473803939938,
         0.0923739029071503,
         -0.0300236904173159,
         -0.0349516037412477,
         -0.0773192039957219,
         -0.0225820483671422,
         0.0566257133462613,
         -0.00279887182292686,
         0.0661432262167355,
         0.0176707724305136,
         0.00695393769768628,
         -0.0658215393622319,
         0.0444280685195425,
         -0.0664521142677456,
         0.000488394891601492,
         -0.021704356305082,
         0.0143742623612167,
         0.0537951686336886,
         -0.0784511205186033,
         0.0608125444302096,
         0.00845935475630394,
         -0.0106646505747172,
         0.0329458850603918,
         -0.0448918335201681,
         -0.013475375374444,
         0.0874347041015662,
         -0.0200278252750286,
         -0.0539531120881111,
         0.0527177239764681,
         -0.0461640225285349,
         0.0185995174597189,
         0.0199141510583131,
         -0.00567846640241563,
         -0.0831421869789868,
         -0.0492523065366288,
         0.0692801318116571,
         -0.028495412656476,
         -0.00664973666116945,
         0.0358464280902686,
         -0.0476097958008246,
         0.0343336950952825,
         -0.0300411779727032,
         0.11318336495169,
         0.0576473803939936,
         -0.0696781262544042,
         -0.0300236904173159,
         0.0517483550027161,
         -0.0300236904173161,
         -0.0225820483671422,
         -0.0187832212141312,
         -0.0102693571358389,
         0.0566257133462613,
         0.0176707724305136,
         0.0832523320989693,
         -0.0560306765417721,
         0.0219332935450744,
         -0.0658215393622319,
         0.00048839489160131,
         -0.0948553907917275,
         0.000510459326640661,
         0.0539151011122904,
         -0.0254127067756546,
         0.0537951686336889,
         0.008459354756304,
         0.0529908620057642,
         0.0496684906856376,
         -0.0384236866747896,
         -0.0265542730636464,
         0.0136065535826175,
         -0.013475375374444,
         -0.053953112088111,
         -0.00212831804309838,
         -0.0640673749992018,
         0.0249742192660424,
         -0.00935911673233387,
         0.0624625215287895,
         -0.0597097360753862,
         -0.00567846640241566,
         0.0692801318116571,
         0.0221209519849386,
         0.0207920852133415,
         0.000564879269215249,
         0.0077368812060888,
         -0.0116698500630351,
         -0.0566930167182384,
         0.120695269916204,
         -0.0300411779727035,
         -0.0200278252750287,
         -0.0539531120881111,
         0.0527177239764679,
         -0.0461640225285349,
         0.0185995174597188,
         0.0199141510583131,
         -0.00567846640241568,
         -0.0831421869789868,
         -0.0349516037412476,
         -0.0300236904173159,
         0.0923739029071504,
         0.0566257133462612,
         -0.0102693571358388,
         -0.0187832212141314,
         -0.0225820483671422,
         0.00695393769768614,
         -0.056030676541772,
         0.0925853937443539,
         -0.0560306765417721,
         0.00695393769768622,
         -0.0217043563050821,
         0.00051045932664046,
         -0.0203296322956875,
         -0.0228413494752566,
         0.0539151011122907,
         0.0143742623612169,
         -0.0106646505747171,
         0.0496684906856374,
         0.0348800741506922,
         -0.0157876952187879,
         -0.00728973768316359,
         -0.0265542730636464,
         -0.0448918335201681,
         0.052717723976468,
         -0.0640673749992018,
         -0.0397104881697234,
         -0.0387117880027928,
         0.0866470459344472,
         -0.0526939688142386,
         0.0624625215287893,
         0.0199141510583129,
         -0.028495412656476,
         0.0207920852133414,
         0.0539818077157309,
         0.0422307942541946,
         -0.0264004984920675,
         -0.0479697079577483,
         0.0455769106962554,
         -0.0566930167182383,
         0.0343336950952826,
         -0.053953112088111,
         -0.00212831804309842,
         -0.064067374999202,
         0.0249742192660425,
         -0.00935911673233387,
         0.0624625215287891,
         -0.0597097360753861,
         -0.00567846640241566,
         0.0608125444302099,
         0.00845935475630408,
         -0.0106646505747172,
         0.0329458850603916,
         -0.0448918335201679,
         -0.013475375374444,
         0.0874347041015662,
         -0.00279887182292682,
         0.0566257133462613,
         -0.0225820483671423,
         -0.077319203995722,
         -0.0658215393622318,
         0.0219332935450745,
         -0.0560306765417721,
         0.0832523320989692,
         0.0176707724305138,
         0.0143742623612167,
         0.0539151011122906,
         -0.0228413494752565,
         -0.0203296322956877,
         0.000510459326640569,
         -0.0217043563050822,
         0.0329458850603917,
         -0.0384236866747897,
         -0.0157876952187879,
         0.0598126737362508,
         -0.0157876952187879,
         -0.0384236866747897,
         0.0329458850603918,
         -0.0461640225285351,
         0.0249742192660424,
         -0.0387117880027926,
         0.0225674252767498,
         -0.067402576244225,
         0.0866470459344474,
         -0.00935911673233374,
         0.0185995174597188,
         -0.00664973666116949,
         0.000564879269215266,
         0.0422307942541944,
         0.0382855013776646,
         -0.0241276999384924,
         0.00932967087929143,
         -0.0479697079577483,
         -0.0116698500630352,
         -0.0476097958008246,
         0.0527177239764681,
         -0.064067374999202,
         -0.0397104881697233,
         -0.0387117880027927,
         0.0866470459344472,
         -0.0526939688142385,
         0.0624625215287894,
         0.0199141510583129,
         0.00845935475630403,
         0.0529908620057642,
         0.0496684906856375,
         -0.0384236866747896,
         -0.0265542730636464,
         0.0136065535826175,
         -0.0134753753744439,
         -0.0664521142677457,
         0.000488394891601345,
         -0.0217043563050821,
         0.0143742623612166,
         0.0537951686336885,
         -0.0784511205186033,
         0.0444280685195424,
         -0.0658215393622319,
         0.00695393769768622,
         0.0176707724305136,
         0.0661432262167355,
         0.0537951686336887,
         -0.0254127067756547,
         0.0539151011122907,
         0.000510459326640434,
         -0.0948553907917273,
         0.000488394891601124,
         -0.0448918335201682,
         -0.0265542730636463,
         -0.00728973768316367,
         -0.0157876952187878,
         0.0348800741506921,
         0.0496684906856375,
         -0.0106646505747171,
         0.0185995174597188,
         -0.00935911673233387,
         0.0866470459344472,
         -0.067402576244225,
         0.0225674252767497,
         -0.0387117880027929,
         0.0249742192660425,
         -0.0461640225285349,
         0.0358464280902686,
         0.00773688120608868,
         -0.0264004984920676,
         -0.0241276999384926,
         0.0689628509059675,
         -0.0241276999384926,
         -0.0264004984920676,
         0.00773688120608866,
         0.0358464280902685,
         -0.0461640225285349,
         0.0249742192660426,
         -0.0387117880027927,
         0.0225674252767498,
         -0.0674025762442249,
         0.086647045934447,
         -0.0093591167323339,
         0.0185995174597188,
         -0.010664650574717,
         0.0496684906856376,
         0.034880074150692,
         -0.0157876952187877,
         -0.00728973768316358,
         -0.0265542730636464,
         -0.0448918335201682,
         0.000488394891601269,
         -0.0948553907917275,
         0.00051045932664064,
         0.0539151011122904,
         -0.0254127067756545,
         0.0537951686336887,
         0.0661432262167355,
         0.0176707724305138,
         0.00695393769768624,
         -0.0658215393622318,
         0.0444280685195424,
         -0.0784511205186033,
         0.0537951686336887,
         0.0143742623612166,
         -0.021704356305082,
         0.000488394891601258,
         -0.0664521142677459,
         -0.0134753753744441,
         0.0136065535826175,
         -0.0265542730636463,
         -0.0384236866747895,
         0.0496684906856375,
         0.0529908620057644,
         0.00845935475630393,
         0.0199141510583128,
         0.0624625215287894,
         -0.0526939688142386,
         0.0866470459344471,
         -0.0387117880027926,
         -0.0397104881697236,
         -0.064067374999202,
         0.0527177239764679,
         -0.0476097958008246,
         -0.011669850063035,
         -0.0479697079577483,
         0.00932967087929148,
         -0.0241276999384926,
         0.0382855013776646,
         0.0422307942541944,
         0.000564879269215334,
         -0.00664973666116924,
         0.0185995174597188,
         -0.0093591167323339,
         0.0866470459344473,
         -0.0674025762442248,
         0.0225674252767498,
         -0.0387117880027927,
         0.0249742192660425,
         -0.0461640225285349,
         0.0329458850603916,
         -0.0384236866747896,
         -0.0157876952187879,
         0.0598126737362508,
         -0.0157876952187879,
         -0.0384236866747897,
         0.0329458850603916,
         -0.0217043563050821,
         0.00051045932664055,
         -0.0203296322956879,
         -0.0228413494752565,
         0.0539151011122905,
         0.0143742623612167,
         0.0176707724305136,
         0.0832523320989693,
         -0.056030676541772,
         0.0219332935450743,
         -0.0658215393622319,
         -0.0773192039957222,
         -0.0225820483671421,
         0.0566257133462612,
         -0.00279887182292691,
         0.0874347041015662,
         -0.013475375374444,
         -0.0448918335201681,
         0.0329458850603916,
         -0.010664650574717,
         0.00845935475630414,
         0.0608125444302097,
         -0.00567846640241568,
         -0.0597097360753861,
         0.062462521528789,
         -0.00935911673233381,
         0.0249742192660427,
         -0.0640673749992021,
         -0.00212831804309854,
         -0.053953112088111,
         0.0343336950952827,
         -0.0566930167182383,
         0.0455769106962556,
         -0.0479697079577483,
         -0.0264004984920675,
         0.0422307942541945,
         0.0539818077157308,
         0.0207920852133412,
         -0.0284954126564759,
         0.0199141510583129,
         0.0624625215287894,
         -0.0526939688142382,
         0.0866470459344471,
         -0.0387117880027927,
         -0.0397104881697233,
         -0.0640673749992019,
         0.0527177239764679,
         -0.0448918335201681,
         -0.0265542730636464,
         -0.00728973768316337,
         -0.0157876952187878,
         0.034880074150692,
         0.0496684906856376,
         -0.0106646505747169,
         0.0143742623612168,
         0.0539151011122906,
         -0.0228413494752567,
         -0.0203296322956876,
         0.000510459326640607,
         -0.0217043563050821,
         0.00695393769768617,
         -0.0560306765417722,
         0.092585393744354,
         -0.0560306765417721,
         0.00695393769768628,
         -0.0225820483671422,
         -0.0187832212141314,
         -0.0102693571358387,
         0.0566257133462613,
         0.0923739029071503,
         -0.0300236904173159,
         -0.0349516037412478,
         -0.0831421869789869,
         -0.00567846640241575,
         0.019914151058313,
         0.0185995174597189,
         -0.0461640225285348,
         0.0527177239764679,
         -0.053953112088111,
         -0.0200278252750285,
         -0.0300411779727034,
         0.120695269916204,
         -0.0566930167182382,
         -0.0116698500630351,
         0.00773688120608882,
         0.000564879269215484,
         0.0207920852133415,
         0.0221209519849386,
         0.0692801318116571,
         -0.00567846640241558,
         -0.0597097360753861,
         0.0624625215287894,
         -0.00935911673233392,
         0.0249742192660424,
         -0.064067374999202,
         -0.00212831804309842,
         -0.053953112088111,
         -0.013475375374444,
         0.0136065535826176,
         -0.0265542730636464,
         -0.0384236866747896,
         0.0496684906856375,
         0.0529908620057643,
         0.00845935475630392,
         0.0537951686336886,
         -0.0254127067756547,
         0.0539151011122903,
         0.000510459326640646,
         -0.0948553907917274,
         0.000488394891601291,
         -0.0658215393622319,
         0.0219332935450744,
         -0.0560306765417722,
         0.0832523320989692,
         0.0176707724305138,
         0.0566257133462613,
         -0.0102693571358388,
         -0.0187832212141313,
         -0.0225820483671423,
         -0.030023690417316,
         0.051748355002716,
         -0.030023690417316,
         -0.0696781262544042,
         0.0576473803939936,
         0.11318336495169,
         -0.0300411779727032,
         0.0343336950952824,
         -0.0476097958008246,
         0.0358464280902687,
         -0.00664973666116947,
         -0.0284954126564759,
         0.069280131811657,
         -0.0492523065366288,
         -0.0831421869789868,
         -0.00567846640241579,
         0.019914151058313,
         0.018599517459719,
         -0.0461640225285349,
         0.052717723976468,
         -0.0539531120881111,
         -0.0200278252750285,
         0.0874347041015662,
         -0.0134753753744439,
         -0.0448918335201681,
         0.0329458850603917,
         -0.0106646505747171,
         0.00845935475630416,
         0.0608125444302099,
         -0.0784511205186032,
         0.0537951686336887,
         0.0143742623612168,
         -0.0217043563050822,
         0.000488394891601356,
         -0.0664521142677458,
         0.0444280685195424,
         -0.0658215393622319,
         0.00695393769768625,
         0.0176707724305136,
         0.0661432262167354,
         -0.00279887182292673,
         0.0566257133462611,
         -0.0225820483671421,
         -0.077319203995722,
         -0.0349516037412478,
         -0.0300236904173158,
         0.0923739029071503,
         0.0576473803939936,
         -0.0696781262544042,
         0.0120307458604104},
        {-0.123071946925928,
         0.027348075197308,
         0.0957238717286201,
         -0.015848268931328,
         -0.0152128137526022,
         -0.0842240654626401,
         -0.00556504751990449,
         0.0321199746768495,
         -0.0148702652778801,
         0.0941375756478935,
         0.0434444418124141,
         -0.0598925811759561,
         0.0295210909791312,
         -0.0103605191576924,
         -0.08758500799187,
         -0.0801729346509729,
         0.0580728461975145,
         0.00217499930763981,
         -0.0332929614766747,
         0.038215409190165,
         0.0634154610406195,
         0.0964541830703848,
         -0.0244218726291176,
         -0.0366586972677266,
         0.0364666604992294,
         -0.00301083525573671,
         -0.0337352749219213,
         -0.0409252777593391,
         -0.0887805118999872,
         -0.010151312779879,
         0.0359323793847139,
         -0.00554612141565594,
         -0.0249640757252384,
         0.0262020471967564,
         0.00664368237680098,
         0.0359031259425625,
         0.0560131299354542,
         0.0327673819645329,
         -0.0250937107941353,
         0.0011387912043262,
         0.00236888396633605,
         0.0134197838281985,
         -0.0308878152927029,
         0.0258656634759261,
         -0.0617687894184885,
         0.09572387172862,
         0.0273480751973081,
         -0.0152128137526024,
         -0.102947285960463,
         -0.0152128137526022,
         0.0321199746768495,
         -0.012207032118481,
         0.126654124344925,
         -0.0148702652778798,
         -0.0598925811759561,
         0.0520835712359042,
         -0.0694961638824561,
         -0.0554507585910152,
         -0.0103605191576923,
         0.0580728461975145,
         -0.0405671881775377,
         0.0315098252552517,
         0.022064836262958,
         0.0435425597538024,
         0.0382154091901649,
         -0.0244218726291176,
         0.024984511498252,
         -0.0252740844412888,
         -0.00802304749529156,
         0.00660281255899834,
         -0.0732364160358639,
         -0.0337352749219212,
         -0.0101513127798791,
         -0.0463924495785128,
         0.0427355205404854,
         0.00466602198615879,
         -0.0201182319954409,
         0.0147260720990331,
         0.0827394244628616,
         0.00664368237680097,
         0.0327673819645328,
         0.0694420544836498,
         -0.0153759337347397,
         -0.0462681723547417,
         0.0458719734466558,
         -0.0132511851369965,
         -0.0172040211817908,
         -0.0705575550978475,
         0.0258656634759263,
         -0.0887805118999874,
         -0.010151312779879,
         0.0359323793847139,
         -0.00554612141565608,
         -0.0249640757252383,
         0.0262020471967564,
         0.00664368237680106,
         0.0359031259425625,
         -0.0842240654626402,
         -0.0152128137526023,
         -0.0158482689313279,
         -0.01487026527788,
         0.126654124344925,
         -0.0122070321184811,
         0.0321199746768496,
         0.0295210909791312,
         -0.0694961638824562,
         -0.0356458493524569,
         -0.0694961638824561,
         0.0295210909791312,
         0.00217499930763984,
         0.0315098252552517,
         -0.0109437729821223,
         0.107879477903235,
         0.022064836262958,
         -0.0332929614766749,
         -0.0366586972677266,
         -0.0252740844412888,
         0.0331140523562952,
         -0.0511585802217124,
         -0.0778069537881558,
         0.00660281255899838,
         -0.00301083525573651,
         0.035932379384714,
         0.0427355205404853,
         -0.0432337281988688,
         0.0329567222972046,
         0.0249144210548025,
         0.0486467493220557,
         0.0147260720990333,
         0.0262020471967563,
         -0.0250937107941353,
         -0.01537593373474,
         0.013310857813674,
         -0.0077663161144772,
         -0.027403049966118,
         0.0205992753459533,
         -0.082233199522292,
         -0.0172040211817906,
         -0.030887815292703,
         -0.0101513127798791,
         -0.0463924495785128,
         0.0427355205404854,
         0.00466602198615871,
         -0.0201182319954411,
         0.0147260720990332,
         0.0827394244628615,
         0.00664368237680093,
         0.0964541830703849,
         -0.0244218726291177,
         -0.0366586972677267,
         0.0364666604992294,
         -0.00301083525573685,
         -0.0337352749219212,
         -0.0409252777593389,
         0.0941375756478933,
         -0.0148702652778798,
         0.0321199746768496,
         -0.00556504751990469,
         -0.0103605191576923,
         -0.0554507585910152,
         -0.0694961638824561,
         0.0520835712359042,
         -0.0598925811759558,
         -0.0332929614766748,
         0.0220648362629578,
         0.107879477903236,
         -0.0109437729821225,
         0.0315098252552517,
         0.00217499930763971,
         0.0364666604992292,
         -0.00802304749529166,
         -0.0511585802217123,
         -0.043009826467429,
         -0.0511585802217124,
         -0.0080230474952917,
         0.0364666604992293,
         -0.00554612141565608,
         0.00466602198615875,
         0.0329567222972047,
         -0.0139276094602185,
         0.105470726535963,
         0.0249144210548026,
         -0.0201182319954411,
         -0.0249640757252384,
         0.00113879120432587,
         -0.0462681723547419,
         -0.00776631611447719,
         0.0162606087557382,
         -0.0335984912973666,
         -0.095508130373886,
         0.0205992753459531,
         -0.0132511851369965,
         0.0134197838281986,
         0.0359323793847137,
         0.0427355205404853,
         -0.0432337281988689,
         0.0329567222972048,
         0.0249144210548025,
         0.0486467493220558,
         0.0147260720990333,
         0.0262020471967564,
         -0.0244218726291176,
         0.024984511498252,
         -0.0252740844412888,
         -0.00802304749529149,
         0.00660281255899825,
         -0.0732364160358639,
         -0.0337352749219212,
         -0.0801729346509731,
         0.0580728461975147,
         0.0021749993076399,
         -0.0332929614766746,
         0.0382154091901649,
         0.0634154610406196,
         -0.08758500799187,
         -0.0103605191576923,
         0.0295210909791311,
         -0.0598925811759561,
         0.0434444418124142,
         0.0382154091901648,
         0.0435425597538025,
         0.0220648362629579,
         0.0315098252552518,
         -0.0405671881775377,
         0.0580728461975146,
         -0.00301083525573673,
         0.00660281255899844,
         -0.0778069537881559,
         -0.0511585802217124,
         0.0331140523562951,
         -0.0252740844412888,
         -0.0366586972677268,
         -0.0249640757252383,
         -0.0201182319954411,
         0.0249144210548025,
         0.105470726535964,
         -0.0139276094602185,
         0.0329567222972047,
         0.00466602198615871,
         -0.00554612141565604,
         0.00236888396633606,
         0.0458719734466556,
         -0.0274030499661181,
         -0.0335984912973666,
         -0.0579446257783783,
         -0.0335984912973668,
         -0.027403049966118,
         0.0458719734466557,
         0.00236888396633611,
         -0.00554612141565594,
         0.00466602198615869,
         0.0329567222972047,
         -0.0139276094602186,
         0.105470726535963,
         0.0249144210548025,
         -0.0201182319954411,
         -0.0249640757252384,
         -0.0366586972677268,
         -0.0252740844412889,
         0.033114052356295,
         -0.0511585802217126,
         -0.0778069537881559,
         0.00660281255899844,
         -0.00301083525573672,
         0.0580728461975146,
         -0.0405671881775378,
         0.0315098252552518,
         0.022064836262958,
         0.0435425597538025,
         0.0382154091901648,
         0.0434444418124141,
         -0.0598925811759562,
         0.0295210909791312,
         -0.0103605191576922,
         -0.0875850079918701,
         0.0634154610406197,
         0.0382154091901649,
         -0.0332929614766746,
         0.00217499930763995,
         0.0580728461975146,
         -0.0801729346509729,
         -0.0337352749219211,
         -0.073236416035864,
         0.00660281255899832,
         -0.00802304749529151,
         -0.0252740844412888,
         0.024984511498252,
         -0.0244218726291176,
         0.0262020471967564,
         0.0147260720990332,
         0.0486467493220556,
         0.0249144210548027,
         0.0329567222972048,
         -0.0432337281988689,
         0.0427355205404852,
         0.0359323793847139,
         0.0134197838281985,
         -0.0132511851369964,
         0.0205992753459531,
         -0.095508130373886,
         -0.0335984912973666,
         0.0162606087557382,
         -0.00776631611447705,
         -0.0462681723547417,
         0.00113879120432587,
         -0.0249640757252383,
         -0.020118231995441,
         0.0249144210548026,
         0.105470726535964,
         -0.0139276094602184,
         0.0329567222972045,
         0.00466602198615874,
         -0.00554612141565607,
         0.0364666604992292,
         -0.00802304749529177,
         -0.0511585802217124,
         -0.0430098264674291,
         -0.0511585802217123,
         -0.00802304749529162,
         0.0364666604992292,
         0.00217499930763978,
         0.0315098252552518,
         -0.0109437729821224,
         0.107879477903235,
         0.022064836262958,
         -0.0332929614766748,
         -0.0598925811759561,
         0.0520835712359042,
         -0.069496163882456,
         -0.0554507585910152,
         -0.0103605191576924,
         -0.00556504751990469,
         0.0321199746768496,
         -0.0148702652778799,
         0.0941375756478936,
         -0.040925277759339,
         -0.0337352749219212,
         -0.0030108352557368,
         0.0364666604992292,
         -0.0366586972677266,
         -0.0244218726291175,
         0.0964541830703849,
         0.00664368237680105,
         0.0827394244628617,
         0.0147260720990333,
         -0.0201182319954409,
         0.00466602198615856,
         0.0427355205404855,
         -0.0463924495785126,
         -0.0101513127798791,
         -0.0308878152927029,
         -0.0172040211817906,
         -0.0822331995222921,
         0.0205992753459534,
         -0.0274030499661181,
         -0.00776631611447716,
         0.0133108578136739,
         -0.01537593373474,
         -0.0250937107941351,
         0.0262020471967565,
         0.0147260720990333,
         0.0486467493220559,
         0.0249144210548025,
         0.0329567222972046,
         -0.0432337281988687,
         0.0427355205404852,
         0.035932379384714,
         -0.00301083525573686,
         0.00660281255899846,
         -0.0778069537881559,
         -0.0511585802217124,
         0.0331140523562952,
         -0.0252740844412888,
         -0.0366586972677268,
         -0.0332929614766747,
         0.0220648362629579,
         0.107879477903235,
         -0.0109437729821225,
         0.0315098252552518,
         0.00217499930763988,
         0.0295210909791313,
         -0.0694961638824561,
         -0.0356458493524571,
         -0.069496163882456,
         0.0295210909791312,
         0.0321199746768497,
         -0.0122070321184811,
         0.126654124344925,
         -0.01487026527788,
         -0.0158482689313282,
         -0.0152128137526023,
         -0.0842240654626403,
         0.0359031259425624,
         0.00664368237680125,
         0.0262020471967563,
         -0.0249640757252385,
         -0.00554612141565598,
         0.035932379384714,
         -0.0101513127798791,
         -0.0887805118999872,
         0.0258656634759263,
         -0.0705575550978476,
         -0.0172040211817906,
         -0.0132511851369964,
         0.0458719734466556,
         -0.0462681723547416,
         -0.0153759337347399,
         0.0694420544836501,
         0.032767381964533,
         0.006643682376801,
         0.0827394244628617,
         0.0147260720990333,
         -0.0201182319954412,
         0.00466602198615869,
         0.0427355205404854,
         -0.0463924495785127,
         -0.010151312779879,
         -0.0337352749219212,
         -0.0732364160358641,
         0.00660281255899856,
         -0.0080230474952916,
         -0.025274084441289,
         0.024984511498252,
         -0.0244218726291176,
         0.0382154091901649,
         0.0435425597538024,
         0.0220648362629579,
         0.0315098252552519,
         -0.0405671881775378,
         0.0580728461975146,
         -0.0103605191576923,
         -0.0554507585910154,
         -0.0694961638824561,
         0.0520835712359043,
         -0.0598925811759561,
         -0.01487026527788,
         0.126654124344925,
         -0.0122070321184812,
         0.0321199746768495,
         -0.0152128137526023,
         -0.102947285960463,
         -0.0152128137526021,
         0.027348075197308,
         0.09572387172862,
         -0.0617687894184884,
         0.025865663475926,
         -0.030887815292703,
         0.0134197838281984,
         0.00236888396633604,
         0.00113879120432617,
         -0.0250937107941353,
         0.0327673819645328,
         0.0560131299354541,
         0.0359031259425624,
         0.00664368237680106,
         0.0262020471967563,
         -0.0249640757252383,
         -0.00554612141565587,
         0.035932379384714,
         -0.0101513127798791,
         -0.0887805118999872,
         -0.0409252777593389,
         -0.0337352749219213,
         -0.00301083525573675,
         0.0364666604992293,
         -0.0366586972677268,
         -0.0244218726291177,
         0.0964541830703849,
         0.0634154610406196,
         0.038215409190165,
         -0.0332929614766749,
         0.0021749993076397,
         0.0580728461975147,
         -0.0801729346509731,
         -0.0875850079918702,
         -0.0103605191576924,
         0.0295210909791313,
         -0.0598925811759561,
         0.0434444418124141,
         0.0941375756478936,
         -0.0148702652778798,
         0.0321199746768497,
         -0.0055650475199047,
         -0.0842240654626402,
         -0.0152128137526021,
         -0.0158482689313282,
         0.09572387172862,
         0.027348075197308,
         -0.123071946925928},
        {-0.108902388819254,
         0.104533301095687,
         0.00436908772356796,
         -0.0629749198212266,
         -0.0549765708713122,
         0.0371892935508924,
         0.0457640954866651,
         0.0258162365018422,
         0.0365213354098481,
         -0.0615368504907911,
         -0.0410753069671811,
         -0.00741362559420927,
         -0.0224500431799356,
         -0.0186977906364358,
         0.0733623716156123,
         0.0229798420322707,
         0.0286114422570136,
         -0.0253362369308091,
         0.0490006602700509,
         -0.0222991030852922,
         -0.0592591805099302,
         0.0106803172324934,
         -0.0504902388971462,
         0.0279050519378792,
         -0.00407827051885564,
         -0.0426171208654745,
         0.0568108281326372,
         0.0213852950881722,
         -0.0257852459707288,
         0.0199819425063616,
         0.0278328457897933,
         -0.0539483380699818,
         0.0573604639905006,
         -0.0187608726821019,
         -0.0335569065064008,
         0.00398134187885112,
         -0.0657226152704396,
         0.0915078612411684,
         -0.106612789979404,
         0.0880575594528747,
         -0.0539376345964919,
         0.0176596918256812,
         -0.00515244337094668,
         0.0305190803379701,
         -0.0345004222168213,
         0.00436908772356798,
         0.104533301095687,
         -0.0549765708713123,
         -0.0361752215889488,
         -0.0549765708713123,
         0.0258162365018421,
         0.0969777322987686,
         -0.0192441294353589,
         0.0365213354098481,
         -0.00741362559420951,
         -0.0727664789407182,
         -0.0469682212981059,
         0.0363186501880724,
         -0.0186977906364356,
         0.0286114422570137,
         0.0075586159286156,
         0.0835424776072291,
         -0.0190669298376571,
         -0.00854059103935349,
         -0.0222991030852921,
         -0.0504902388971464,
         0.00751685397617303,
         -0.039646850318775,
         -0.0293792292305792,
         0.0159477752572088,
         0.00930091607518022,
         0.0568108281326372,
         0.0199819425063615,
         0.0386214158213143,
         -0.0141488474149549,
         0.0359576770593365,
         -0.00550676822790809,
         0.0170482248671914,
         -0.0622099225948368,
         -0.0335569065064008,
         0.0915078612411686,
         -0.0921562405623516,
         0.0384298960028022,
         -0.0445070159966079,
         0.0485425898104228,
         -0.0802132397295545,
         0.0776853670863906,
         0.00989119247546947,
         0.0305190803379703,
         -0.0257852459707287,
         0.0199819425063614,
         0.0278328457897937,
         -0.0539483380699816,
         0.0573604639905006,
         -0.0187608726821018,
         -0.033556906506401,
         0.00398134187885131,
         0.0371892935508925,
         -0.0549765708713124,
         -0.0629749198212267,
         0.0365213354098481,
         -0.019244129435359,
         0.0969777322987685,
         0.0258162365018422,
         -0.0224500431799356,
         -0.0469682212981061,
         -0.0244766458300515,
         -0.0469682212981059,
         -0.0224500431799354,
         -0.0253362369308091,
         0.083542477607229,
         0.0261710766432383,
         0.0397276468794253,
         -0.0190669298376571,
         0.049000660270051,
         0.0279050519378795,
         -0.0396468503187746,
         -0.0600239254884553,
         -0.0379935040075412,
         0.0122686938308417,
         0.0159477752572088,
         -0.0426171208654745,
         0.0278328457897935,
         -0.0141488474149547,
         0.0559134807654693,
         0.0392980245771123,
         0.0232759061380361,
         -0.0476930233008436,
         0.0170482248671915,
         -0.0187608726821019,
         -0.106612789979404,
         0.0384298960028019,
         -0.0610080268534725,
         0.017572656620726,
         -0.0849383872259791,
         0.0674642166775115,
         -0.0348063144745664,
         0.0776853670863908,
         -0.00515244337094676,
         0.0199819425063617,
         0.0386214158213144,
         -0.0141488474149547,
         0.0359576770593363,
         -0.00550676822790816,
         0.0170482248671915,
         -0.0622099225948369,
         -0.0335569065064009,
         0.0106803172324934,
         -0.0504902388971463,
         0.0279050519378791,
         -0.00407827051885565,
         -0.0426171208654745,
         0.056810828132637,
         0.0213852950881723,
         -0.0615368504907908,
         0.0365213354098481,
         0.0258162365018422,
         0.0457640954866651,
         -0.0186977906364359,
         0.0363186501880723,
         -0.0469682212981059,
         -0.0727664789407178,
         -0.00741362559420943,
         0.0490006602700509,
         -0.0190669298376571,
         0.0397276468794252,
         0.0261710766432384,
         0.0835424776072289,
         -0.025336236930809,
         -0.00407827051885566,
         -0.0293792292305793,
         -0.0379935040075408,
         -0.0258500538711417,
         -0.0379935040075409,
         -0.0293792292305792,
         -0.0040782705188556,
         -0.0539483380699817,
         0.0359576770593362,
         0.0392980245771123,
         0.0586488400703273,
         0.00324501648718405,
         0.0232759061380361,
         -0.00550676822790797,
         0.0573604639905005,
         0.0880575594528749,
         -0.0445070159966078,
         0.0175726566207259,
         -0.114909892455845,
         0.0189796728228333,
         -0.0443061527101637,
         0.0674642166775115,
         -0.0802132397295547,
         0.0176596918256812,
         0.0278328457897935,
         -0.0141488474149546,
         0.0559134807654693,
         0.0392980245771123,
         0.0232759061380361,
         -0.0476930233008435,
         0.0170482248671915,
         -0.018760872682102,
         -0.0504902388971463,
         0.00751685397617298,
         -0.0396468503187748,
         -0.0293792292305795,
         0.0159477752572086,
         0.00930091607518004,
         0.0568108281326372,
         0.0229798420322708,
         0.0286114422570136,
         -0.025336236930809,
         0.049000660270051,
         -0.0222991030852921,
         -0.0592591805099301,
         0.0733623716156124,
         -0.0186977906364358,
         -0.0224500431799355,
         -0.00741362559420912,
         -0.0410753069671809,
         -0.0222991030852921,
         -0.00854059103935358,
         -0.019066929837657,
         0.083542477607229,
         0.00755861592861559,
         0.0286114422570136,
         -0.0426171208654745,
         0.0159477752572086,
         0.0122686938308418,
         -0.0379935040075409,
         -0.0600239254884553,
         -0.039646850318775,
         0.0279050519378793,
         0.0573604639905005,
         -0.00550676822790804,
         0.0232759061380361,
         0.00324501648718413,
         0.0586488400703273,
         0.0392980245771121,
         0.0359576770593363,
         -0.0539483380699816,
         -0.053937634596492,
         0.0485425898104226,
         -0.0849383872259792,
         0.0189796728228332,
         -0.0808735293803445,
         0.0189796728228332,
         -0.084938387225979,
         0.0485425898104226,
         -0.053937634596492,
         -0.0539483380699816,
         0.0359576770593362,
         0.0392980245771121,
         0.0586488400703273,
         0.00324501648718414,
         0.0232759061380361,
         -0.00550676822790812,
         0.0573604639905006,
         0.0279050519378793,
         -0.039646850318775,
         -0.0600239254884554,
         -0.037993504007541,
         0.0122686938308417,
         0.0159477752572087,
         -0.0426171208654746,
         0.0286114422570136,
         0.00755861592861558,
         0.083542477607229,
         -0.0190669298376569,
         -0.00854059103935354,
         -0.022299103085292,
         -0.0410753069671809,
         -0.00741362559420908,
         -0.0224500431799354,
         -0.0186977906364357,
         0.0733623716156123,
         -0.0592591805099301,
         -0.022299103085292,
         0.049000660270051,
         -0.0253362369308089,
         0.0286114422570136,
         0.0229798420322708,
         0.0568108281326371,
         0.00930091607517988,
         0.0159477752572087,
         -0.0293792292305795,
         -0.039646850318775,
         0.00751685397617288,
         -0.0504902388971462,
         -0.0187608726821021,
         0.0170482248671916,
         -0.0476930233008435,
         0.023275906138036,
         0.0392980245771124,
         0.0559134807654693,
         -0.0141488474149547,
         0.0278328457897934,
         0.0176596918256813,
         -0.0802132397295546,
         0.0674642166775115,
         -0.0443061527101635,
         0.0189796728228334,
         -0.114909892455845,
         0.017572656620726,
         -0.0445070159966079,
         0.0880575594528749,
         0.0573604639905005,
         -0.00550676822790813,
         0.023275906138036,
         0.00324501648718418,
         0.0586488400703273,
         0.0392980245771124,
         0.0359576770593362,
         -0.0539483380699817,
         -0.00407827051885569,
         -0.0293792292305793,
         -0.0379935040075411,
         -0.0258500538711417,
         -0.037993504007541,
         -0.0293792292305792,
         -0.00407827051885553,
         -0.025336236930809,
         0.083542477607229,
         0.0261710766432382,
         0.0397276468794253,
         -0.0190669298376569,
         0.0490006602700511,
         -0.0074136255942094,
         -0.0727664789407181,
         -0.0469682212981058,
         0.0363186501880722,
         -0.0186977906364358,
         0.0457640954866649,
         0.0258162365018422,
         0.0365213354098482,
         -0.0615368504907911,
         0.0213852950881721,
         0.0568108281326368,
         -0.0426171208654745,
         -0.00407827051885573,
         0.0279050519378793,
         -0.0504902388971461,
         0.0106803172324936,
         -0.0335569065064009,
         -0.0622099225948368,
         0.0170482248671915,
         -0.00550676822790817,
         0.0359576770593362,
         -0.0141488474149547,
         0.0386214158213143,
         0.0199819425063615,
         -0.00515244337094675,
         0.0776853670863906,
         -0.0348063144745662,
         0.0674642166775117,
         -0.084938387225979,
         0.017572656620726,
         -0.0610080268534724,
         0.0384298960028018,
         -0.106612789979404,
         -0.0187608726821019,
         0.0170482248671914,
         -0.0476930233008436,
         0.0232759061380361,
         0.0392980245771125,
         0.0559134807654692,
         -0.0141488474149547,
         0.0278328457897934,
         -0.0426171208654746,
         0.0159477752572087,
         0.0122686938308418,
         -0.0379935040075411,
         -0.0600239254884554,
         -0.039646850318775,
         0.0279050519378793,
         0.0490006602700509,
         -0.0190669298376571,
         0.0397276468794253,
         0.0261710766432381,
         0.0835424776072289,
         -0.0253362369308089,
         -0.0224500431799356,
         -0.046968221298106,
         -0.0244766458300513,
         -0.0469682212981061,
         -0.0224500431799356,
         0.0258162365018422,
         0.0969777322987686,
         -0.019244129435359,
         0.0365213354098481,
         -0.0629749198212266,
         -0.0549765708713122,
         0.0371892935508926,
         0.00398134187885103,
         -0.0335569065064008,
         -0.0187608726821019,
         0.0573604639905005,
         -0.0539483380699817,
         0.0278328457897934,
         0.0199819425063617,
         -0.0257852459707287,
         0.0305190803379699,
         0.00989119247546958,
         0.0776853670863906,
         -0.0802132397295543,
         0.0485425898104227,
         -0.0445070159966079,
         0.038429896002802,
         -0.0921562405623513,
         0.0915078612411684,
         -0.0335569065064009,
         -0.0622099225948368,
         0.0170482248671914,
         -0.00550676822790796,
         0.0359576770593362,
         -0.0141488474149549,
         0.0386214158213143,
         0.0199819425063616,
         0.0568108281326371,
         0.00930091607517997,
         0.0159477752572088,
         -0.0293792292305795,
         -0.0396468503187751,
         0.00751685397617282,
         -0.0504902388971462,
         -0.0222991030852923,
         -0.00854059103935366,
         -0.0190669298376569,
         0.083542477607229,
         0.0075586159286156,
         0.0286114422570135,
         -0.0186977906364358,
         0.0363186501880724,
         -0.046968221298106,
         -0.072766478940718,
         -0.00741362559420949,
         0.0365213354098481,
         -0.019244129435359,
         0.0969777322987685,
         0.0258162365018422,
         -0.0549765708713123,
         -0.0361752215889488,
         -0.0549765708713123,
         0.104533301095687,
         0.00436908772356768,
         -0.0345004222168214,
         0.03051908033797,
         -0.00515244337094673,
         0.0176596918256814,
         -0.0539376345964919,
         0.0880575594528748,
         -0.106612789979404,
         0.0915078612411684,
         -0.06572261527044,
         0.00398134187885104,
         -0.0335569065064009,
         -0.0187608726821022,
         0.0573604639905003,
         -0.0539483380699816,
         0.0278328457897935,
         0.0199819425063615,
         -0.0257852459707287,
         0.0213852950881721,
         0.0568108281326371,
         -0.0426171208654745,
         -0.00407827051885558,
         0.0279050519378792,
         -0.0504902388971463,
         0.0106803172324936,
         -0.0592591805099302,
         -0.0222991030852921,
         0.049000660270051,
         -0.025336236930809,
         0.0286114422570137,
         0.0229798420322707,
         0.0733623716156122,
         -0.0186977906364358,
         -0.0224500431799354,
         -0.00741362559420933,
         -0.0410753069671809,
         -0.061536850490791,
         0.0365213354098481,
         0.025816236501842,
         0.045764095486665,
         0.0371892935508926,
         -0.0549765708713123,
         -0.0629749198212265,
         0.00436908772356764,
         0.104533301095687,
         -0.108902388819254},
        {-0.114963543030859,
         0.0460737915019357,
         0.0688897515289231,
         -0.0517830294232834,
         0.00755261185779254,
         -0.0745989894502705,
         0.0795034320260945,
         -0.0415806039042166,
         0.0330167470221954,
         0.0525878247688073,
         -0.0902959382658352,
         0.0170644506895801,
         0.0303490590434837,
         -0.0615680614245308,
         -0.0136487637242733,
         0.0889346110049661,
         0.00215244739261245,
         -0.0229685863705,
         -0.00902213076961318,
         0.0691165175936292,
         -0.0300643601827202,
         -0.0873598507469329,
         -0.00236214038705,
         0.000382651836579758,
         0.0225652359190203,
         -0.0128481176589843,
         -0.0548201793990119,
         0.0666111464487283,
         0.0762209599285968,
         0.014735367493209,
         -0.0143461958404543,
         0.0147847510054522,
         -0.0336641818882075,
         0.0426861535613558,
         0.0107012049228233,
         -0.0747004970071657,
         -0.0184281148515957,
         -0.0577928450770009,
         0.0466539542586647,
         -0.0370898236983619,
         0.0277391261352232,
         -0.0064480280686387,
         -0.0220094076389322,
         0.0139200570804949,
         0.0607804399266709,
         0.0688897515289231,
         0.0460737915019357,
         0.00755261185779244,
         -0.124954709393217,
         0.0075526118577924,
         -0.0415806039042165,
         0.104162768917251,
         0.0150827025546195,
         0.0330167470221953,
         0.0170644506895802,
         -0.0441137917691219,
         -0.0366571579234809,
         -0.00476529269076586,
         -0.0615680614245307,
         0.00215244739261244,
         0.0599113545143099,
         -0.0317812111749624,
         0.0501885423415362,
         0.00171360656812323,
         0.0691165175936291,
         -0.00236214038705003,
         -0.0887947185765643,
         0.0328951257721692,
         0.0141382218316392,
         -0.0578951407413725,
         0.00301181951375335,
         -0.054820179399012,
         0.0147353674932092,
         0.0714100023954194,
         0.0214980255625943,
         -0.0558111356546625,
         0.028126932450224,
         0.0363664651083455,
         0.00146275917252455,
         0.0107012049228234,
         -0.0577928450770012,
         -0.0379211737836839,
         -0.0446277194300716,
         0.0352323735511963,
         0.0021118751233917,
         -0.00435345710693359,
         -0.056176186180367,
         0.0466240764494054,
         0.0139200570804948,
         0.0762209599285968,
         0.0147353674932091,
         -0.0143461958404542,
         0.0147847510054524,
         -0.0336641818882073,
         0.0426861535613561,
         0.0107012049228234,
         -0.0747004970071658,
         -0.0745989894502707,
         0.00755261185779242,
         -0.0517830294232832,
         0.0330167470221953,
         0.0150827025546196,
         0.104162768917251,
         -0.0415806039042166,
         0.0303490590434837,
         -0.0366571579234809,
         -0.0776801613421762,
         -0.0366571579234809,
         0.0303490590434836,
         -0.0229685863704998,
         -0.0317812111749623,
         0.123664914734429,
         -0.0136561788469353,
         0.0501885423415363,
         -0.00902213076961322,
         0.000382651836579677,
         0.0328951257721692,
         -0.0612427371092468,
         -0.0377703588899326,
         0.00749754032001144,
         -0.0578951407413725,
         -0.0128481176589844,
         -0.0143461958404543,
         0.0214980255625944,
         0.0251010534385,
         0.0090859055778415,
         0.0168555682592872,
         0.024950413582123,
         0.0363664651083455,
         0.0426861535613558,
         0.0466539542586647,
         -0.0446277194300717,
         -0.0511587526728624,
         0.00709822279518424,
         0.0309770765731804,
         -0.0705003527100428,
         0.0134777315481897,
         -0.0561761861803671,
         -0.0220094076389321,
         0.0147353674932092,
         0.0714100023954193,
         0.0214980255625942,
         -0.0558111356546626,
         0.0281269324502241,
         0.0363664651083457,
         0.0014627591725243,
         0.0107012049228234,
         -0.0873598507469329,
         -0.00236214038704989,
         0.00038265183657995,
         0.0225652359190202,
         -0.0128481176589843,
         -0.0548201793990118,
         0.0666111464487283,
         0.0525878247688072,
         0.0330167470221954,
         -0.0415806039042166,
         0.0795034320260945,
         -0.0615680614245307,
         -0.00476529269076602,
         -0.036657157923481,
         -0.0441137917691218,
         0.0170644506895801,
         -0.00902213076961319,
         0.0501885423415363,
         -0.0136561788469351,
         0.123664914734429,
         -0.0317812111749624,
         -0.0229685863704999,
         0.0225652359190202,
         0.0141382218316391,
         -0.0377703588899325,
         -0.0701952818427683,
         -0.0377703588899325,
         0.0141382218316392,
         0.0225652359190204,
         0.0147847510054525,
         -0.0558111356546626,
         0.00908590557784149,
         0.0914788057435696,
         0.0145485847394515,
         0.0168555682592873,
         0.028126932450224,
         -0.0336641818882075,
         -0.0370898236983618,
         0.0352323735511965,
         0.00709822279518436,
         -0.0417766616440867,
         -0.0583217909688448,
         0.0277826101426575,
         -0.0705003527100429,
         -0.00435345710693357,
         -0.00644802806863839,
         -0.0143461958404543,
         0.0214980255625945,
         0.0251010534384997,
         0.00908590557784145,
         0.016855568259287,
         0.0249504135821231,
         0.0363664651083457,
         0.0426861535613559,
         -0.0023621403870499,
         -0.0887947185765642,
         0.0328951257721692,
         0.0141382218316393,
         -0.0578951407413725,
         0.00301181951375344,
         -0.0548201793990119,
         0.0889346110049662,
         0.00215244739261234,
         -0.0229685863704999,
         -0.00902213076961332,
         0.0691165175936293,
         -0.0300643601827203,
         -0.0136487637242735,
         -0.0615680614245308,
         0.0303490590434837,
         0.0170644506895801,
         -0.0902959382658353,
         0.0691165175936293,
         0.00171360656812311,
         0.0501885423415363,
         -0.0317812111749624,
         0.05991135451431,
         0.00215244739261247,
         -0.0128481176589841,
         -0.0578951407413725,
         0.00749754032001151,
         -0.0377703588899328,
         -0.0612427371092468,
         0.0328951257721691,
         0.00038265183657992,
         -0.0336641818882075,
         0.028126932450224,
         0.0168555682592872,
         0.0145485847394515,
         0.0914788057435696,
         0.00908590557784147,
         -0.0558111356546626,
         0.0147847510054525,
         0.0277391261352231,
         0.00211187512339172,
         0.0309770765731804,
         -0.058321790968845,
         -0.0477055995141761,
         -0.0583217909688451,
         0.0309770765731805,
         0.00211187512339183,
         0.0277391261352232,
         0.0147847510054525,
         -0.0558111356546625,
         0.0090859055778412,
         0.0914788057435696,
         0.0145485847394514,
         0.016855568259287,
         0.0281269324502239,
         -0.0336641818882077,
         0.000382651836579783,
         0.0328951257721692,
         -0.0612427371092468,
         -0.0377703588899325,
         0.00749754032001153,
         -0.0578951407413724,
         -0.0128481176589842,
         0.00215244739261248,
         0.0599113545143101,
         -0.0317812111749625,
         0.0501885423415363,
         0.00171360656812337,
         0.0691165175936293,
         -0.090295938265835,
         0.0170644506895802,
         0.0303490590434836,
         -0.0615680614245309,
         -0.0136487637242736,
         -0.0300643601827204,
         0.0691165175936292,
         -0.00902213076961345,
         -0.0229685863705,
         0.00215244739261239,
         0.088934611004966,
         -0.0548201793990119,
         0.00301181951375337,
         -0.0578951407413723,
         0.0141382218316391,
         0.0328951257721691,
         -0.0887947185765643,
         -0.00236214038705011,
         0.042686153561356,
         0.0363664651083458,
         0.0249504135821231,
         0.016855568259287,
         0.00908590557784139,
         0.0251010534384996,
         0.0214980255625943,
         -0.0143461958404544,
         -0.00644802806863837,
         -0.00435345710693364,
         -0.0705003527100429,
         0.0277826101426574,
         -0.0583217909688449,
         -0.0417766616440866,
         0.00709822279518445,
         0.0352323735511965,
         -0.0370898236983618,
         -0.0336641818882077,
         0.028126932450224,
         0.0168555682592871,
         0.0145485847394514,
         0.0914788057435695,
         0.00908590557784138,
         -0.0558111356546626,
         0.0147847510054523,
         0.0225652359190202,
         0.0141382218316391,
         -0.0377703588899325,
         -0.0701952818427683,
         -0.0377703588899325,
         0.0141382218316392,
         0.0225652359190202,
         -0.0229685863704999,
         -0.0317812111749623,
         0.123664914734429,
         -0.013656178846935,
         0.0501885423415363,
         -0.00902213076961325,
         0.0170644506895801,
         -0.0441137917691218,
         -0.036657157923481,
         -0.0047652926907659,
         -0.0615680614245307,
         0.0795034320260946,
         -0.0415806039042166,
         0.0330167470221952,
         0.0525878247688073,
         0.0666111464487282,
         -0.0548201793990117,
         -0.0128481176589844,
         0.0225652359190204,
         0.000382651836579675,
         -0.00236214038705002,
         -0.0873598507469329,
         0.0107012049228233,
         0.00146275917252432,
         0.0363664651083456,
         0.028126932450224,
         -0.0558111356546626,
         0.0214980255625943,
         0.0714100023954193,
         0.0147353674932093,
         -0.0220094076389322,
         -0.056176186180367,
         0.0134777315481899,
         -0.0705003527100429,
         0.0309770765731803,
         0.0070982227951845,
         -0.0511587526728623,
         -0.0446277194300715,
         0.0466539542586645,
         0.0426861535613558,
         0.0363664651083456,
         0.0249504135821232,
         0.0168555682592872,
         0.00908590557784152,
         0.0251010534384998,
         0.0214980255625944,
         -0.0143461958404544,
         -0.0128481176589843,
         -0.0578951407413725,
         0.00749754032001168,
         -0.0377703588899326,
         -0.0612427371092466,
         0.0328951257721691,
         0.000382651836579675,
         -0.00902213076961336,
         0.0501885423415363,
         -0.0136561788469351,
         0.123664914734429,
         -0.0317812111749624,
         -0.0229685863704999,
         0.0303490590434837,
         -0.036657157923481,
         -0.0776801613421763,
         -0.036657157923481,
         0.0303490590434837,
         -0.0415806039042166,
         0.10416276891725,
         0.0150827025546197,
         0.0330167470221954,
         -0.0517830294232834,
         0.00755261185779244,
         -0.0745989894502706,
         -0.0747004970071657,
         0.0107012049228235,
         0.0426861535613559,
         -0.0336641818882074,
         0.0147847510054524,
         -0.0143461958404543,
         0.0147353674932094,
         0.0762209599285967,
         0.0139200570804948,
         0.0466240764494053,
         -0.056176186180367,
         -0.00435345710693353,
         0.00211187512339197,
         0.0352323735511964,
         -0.0446277194300715,
         -0.037921173783684,
         -0.057792845077001,
         0.0107012049228233,
         0.00146275917252421,
         0.0363664651083457,
         0.0281269324502241,
         -0.0558111356546625,
         0.0214980255625943,
         0.0714100023954195,
         0.0147353674932091,
         -0.0548201793990117,
         0.00301181951375349,
         -0.0578951407413724,
         0.0141382218316391,
         0.0328951257721693,
         -0.0887947185765642,
         -0.00236214038705001,
         0.0691165175936293,
         0.00171360656812335,
         0.0501885423415364,
         -0.0317812111749624,
         0.0599113545143099,
         0.00215244739261248,
         -0.0615680614245307,
         -0.0047652926907659,
         -0.036657157923481,
         -0.0441137917691219,
         0.01706445068958,
         0.0330167470221952,
         0.0150827025546197,
         0.10416276891725,
         -0.0415806039042166,
         0.00755261185779256,
         -0.124954709393217,
         0.0075526118577926,
         0.0460737915019356,
         0.0688897515289231,
         0.0607804399266707,
         0.0139200570804949,
         -0.0220094076389322,
         -0.00644802806863847,
         0.0277391261352231,
         -0.0370898236983618,
         0.0466539542586648,
         -0.057792845077001,
         -0.0184281148515959,
         -0.0747004970071656,
         0.0107012049228234,
         0.0426861535613558,
         -0.0336641818882075,
         0.0147847510054524,
         -0.0143461958404542,
         0.0147353674932092,
         0.0762209599285969,
         0.0666111464487281,
         -0.0548201793990119,
         -0.0128481176589843,
         0.0225652359190201,
         0.000382651836579964,
         -0.00236214038704988,
         -0.0873598507469329,
         -0.0300643601827203,
         0.0691165175936292,
         -0.00902213076961333,
         -0.0229685863704999,
         0.00215244739261234,
         0.0889346110049663,
         -0.0136487637242735,
         -0.0615680614245308,
         0.0303490590434837,
         0.0170644506895801,
         -0.0902959382658351,
         0.0525878247688071,
         0.0330167470221954,
         -0.0415806039042165,
         0.0795034320260944,
         -0.0745989894502708,
         0.00755261185779257,
         -0.0517830294232834,
         0.0688897515289231,
         0.0460737915019358,
         -0.114963543030859},
        {-0.0139666929749375,
         -0.0554516972723542,
         0.0694183902472916,
         0.0695604834092142,
         -0.0186641697095632,
         -0.0553096041104321,
         -0.0612731089312931,
         -0.012431061716881,
         0.0335942409221706,
         0.0329134434956514,
         0.032373031852344,
         0.0456950340619523,
         -0.0369553377966757,
         -0.00281989471736842,
         -0.0311299854818995,
         0.0131817606754906,
         -0.0720284513621886,
         0.0314744537387834,
         0.00747989264068443,
         -0.00343823245785865,
         0.0333045146202898,
         -0.0552935444093029,
         0.0631676756007182,
         0.00617277391920832,
         -0.0379811287607774,
         0.0289360132770276,
         -0.0209478119285624,
         -0.0193393066679147,
         0.0686053340159693,
         -0.017609842402227,
         -0.0431999911907184,
         0.0400929141240763,
         -0.00831562192729002,
         -0.0163207140008256,
         0.0328677504463743,
         -0.00550637728501049,
         -0.120050829852267,
         0.0514454958362975,
         -0.0381337062296309,
         0.0669337003567764,
         -0.0922906856898995,
         0.0975499467801146,
         -0.0866694707795643,
         0.0618237868266387,
         -0.0563174095416282,
         0.0694183902472915,
         -0.0554516972723541,
         -0.0186641697095631,
         0.0107236827645668,
         -0.0186641697095631,
         -0.012431061716881,
         -0.0262235150943877,
         0.0296086184666804,
         0.0335942409221706,
         0.0456950340619524,
         0.00766950880924235,
         0.030435265004857,
         -0.0788461598445271,
         -0.0028198947173685,
         -0.0720284513621884,
         0.00926375676987006,
         -0.0547813224063414,
         0.0473366280687375,
         0.0410249533622561,
         -0.0034382324578587,
         0.0631676756007183,
         0.0059537072430187,
         0.0362600429718397,
         -0.0014598264280355,
         -0.0506824145980261,
         0.00355352611853022,
         -0.0209478119285626,
         -0.0176098424022272,
         -0.0161623371801081,
         -0.036174776136332,
         -0.00224366343880702,
         0.027649951386774,
         0.00354977148942182,
         0.00728107764313908,
         0.0328677504463743,
         0.0514454958362974,
         -0.0967551980406005,
         0.126229324827375,
         -0.0655261769035067,
         0.0420463750826293,
         -0.0599207230533385,
         0.067670594863183,
         -0.0997973564592477,
         0.061823786826639,
         0.0686053340159695,
         -0.0176098424022271,
         -0.0431999911907182,
         0.0400929141240763,
         -0.00831562192728988,
         -0.0163207140008255,
         0.0328677504463744,
         -0.00550637728501051,
         -0.0553096041104321,
         -0.0186641697095631,
         0.069560483409214,
         0.0335942409221705,
         0.0296086184666804,
         -0.0262235150943878,
         -0.0124310617168811,
         -0.0369553377966756,
         0.0304352650048572,
         -0.0378954500676634,
         0.030435265004857,
         -0.0369553377966755,
         0.0314744537387834,
         -0.0547813224063411,
         0.0232963482926174,
         -0.0122422789880197,
         0.0473366280687373,
         0.00747989264068452,
         0.00617277391920833,
         0.0362600429718396,
         0.0128734062917232,
         0.0101863162275323,
         -0.0370259735817242,
         -0.0506824145980261,
         0.0289360132770274,
         -0.0431999911907183,
         -0.036174776136332,
         -0.00827440738286951,
         -0.0368261225802032,
         0.0278611847706862,
         0.0529984832682702,
         0.00354977148942172,
         -0.0163207140008256,
         -0.0381337062296311,
         0.126229324827375,
         -0.0690486470514804,
         0.109226208231073,
         -0.0724126972950273,
         0.0228476475782535,
         -0.07897673503723,
         0.0676705948631832,
         -0.0866694707795644,
         -0.0176098424022272,
         -0.0161623371801081,
         -0.0361747761363319,
         -0.00224366343880709,
         0.0276499513867741,
         0.00354977148942172,
         0.00728107764313906,
         0.0328677504463745,
         -0.0552935444093026,
         0.0631676756007183,
         0.00617277391920838,
         -0.0379811287607777,
         0.0289360132770276,
         -0.0209478119285625,
         -0.0193393066679148,
         0.0329134434956516,
         0.0335942409221706,
         -0.012431061716881,
         -0.061273108931293,
         -0.00281989471736854,
         -0.0788461598445273,
         0.030435265004857,
         0.00766950880924216,
         0.0456950340619524,
         0.0074798926406845,
         0.0473366280687374,
         -0.01224227898802,
         0.0232963482926174,
         -0.0547813224063412,
         0.0314744537387833,
         -0.0379811287607775,
         -0.00145982642803549,
         0.0101863162275323,
         -0.0217913893865091,
         0.0101863162275323,
         -0.00145982642803539,
         -0.0379811287607776,
         0.0400929141240763,
         -0.00224366343880699,
         -0.0368261225802032,
         0.0152074152083643,
         -0.00307961389557629,
         0.0278611847706863,
         0.0276499513867741,
         -0.00831562192728992,
         0.0669337003567766,
         -0.0655261769035068,
         0.109226208231073,
         -0.0621336592662033,
         0.0818625714816388,
         -0.105214398241912,
         0.0228476475782534,
         -0.0599207230533386,
         0.0975499467801145,
         -0.0431999911907183,
         -0.0361747761363321,
         -0.00827440738286968,
         -0.0368261225802032,
         0.0278611847706863,
         0.0529984832682703,
         0.00354977148942189,
         -0.0163207140008257,
         0.0631676756007182,
         0.00595370724301876,
         0.0362600429718397,
         -0.00145982642803532,
         -0.0506824145980263,
         0.00355352611853003,
         -0.0209478119285626,
         0.0131817606754905,
         -0.0720284513621886,
         0.0314744537387834,
         0.00747989264068444,
         -0.00343823245785859,
         0.0333045146202898,
         -0.0311299854818994,
         -0.00281989471736864,
         -0.0369553377966755,
         0.0456950340619524,
         0.0323730318523441,
         -0.00343823245785872,
         0.041024953362256,
         0.0473366280687373,
         -0.0547813224063414,
         0.00926375676986995,
         -0.0720284513621884,
         0.0289360132770275,
         -0.0506824145980261,
         -0.0370259735817242,
         0.0101863162275323,
         0.0128734062917231,
         0.0362600429718397,
         0.00617277391920832,
         -0.00831562192728989,
         0.0276499513867741,
         0.0278611847706861,
         -0.00307961389557611,
         0.0152074152083645,
         -0.0368261225802032,
         -0.00224366343880711,
         0.0400929141240763,
         -0.0922906856898997,
         0.0420463750826294,
         -0.0724126972950273,
         0.0818625714816388,
         -0.0939903727944269,
         0.0818625714816388,
         -0.0724126972950273,
         0.0420463750826294,
         -0.0922906856898998,
         0.0400929141240762,
         -0.00224366343880691,
         -0.0368261225802032,
         0.0152074152083644,
         -0.00307961389557612,
         0.0278611847706863,
         0.0276499513867741,
         -0.00831562192728988,
         0.00617277391920827,
         0.0362600429718397,
         0.0128734062917231,
         0.0101863162275324,
         -0.0370259735817242,
         -0.0506824145980263,
         0.0289360132770274,
         -0.0720284513621884,
         0.00926375676986996,
         -0.0547813224063412,
         0.0473366280687373,
         0.041024953362256,
         -0.00343823245785871,
         0.0323730318523441,
         0.0456950340619524,
         -0.0369553377966755,
         -0.00281989471736857,
         -0.0311299854818993,
         0.0333045146202899,
         -0.0034382324578586,
         0.0074798926406843,
         0.0314744537387835,
         -0.0720284513621885,
         0.0131817606754906,
         -0.0209478119285626,
         0.00355352611853006,
         -0.0506824145980261,
         -0.00145982642803525,
         0.0362600429718396,
         0.00595370724301866,
         0.0631676756007183,
         -0.0163207140008256,
         0.00354977148942187,
         0.0529984832682703,
         0.0278611847706863,
         -0.0368261225802032,
         -0.00827440738286966,
         -0.0361747761363319,
         -0.0431999911907182,
         0.0975499467801145,
         -0.0599207230533385,
         0.0228476475782536,
         -0.105214398241912,
         0.0818625714816388,
         -0.0621336592662034,
         0.109226208231073,
         -0.0655261769035068,
         0.0669337003567766,
         -0.00831562192728992,
         0.0276499513867741,
         0.0278611847706863,
         -0.00307961389557622,
         0.0152074152083643,
         -0.0368261225802031,
         -0.00224366343880693,
         0.0400929141240762,
         -0.0379811287607775,
         -0.00145982642803544,
         0.0101863162275323,
         -0.0217913893865094,
         0.0101863162275322,
         -0.00145982642803535,
         -0.0379811287607775,
         0.0314744537387834,
         -0.0547813224063413,
         0.0232963482926174,
         -0.01224227898802,
         0.0473366280687372,
         0.00747989264068448,
         0.0456950340619522,
         0.00766950880924222,
         0.0304352650048571,
         -0.078846159844527,
         -0.00281989471736849,
         -0.0612731089312931,
         -0.0124310617168811,
         0.0335942409221706,
         0.0329134434956515,
         -0.019339306667915,
         -0.0209478119285624,
         0.0289360132770278,
         -0.0379811287607777,
         0.00617277391920827,
         0.0631676756007184,
         -0.0552935444093027,
         0.0328677504463744,
         0.00728107764313918,
         0.00354977148942183,
         0.0276499513867741,
         -0.00224366343880703,
         -0.0361747761363317,
         -0.016162337180108,
         -0.0176098424022271,
         -0.0866694707795643,
         0.0676705948631832,
         -0.0789767350372299,
         0.0228476475782535,
         -0.0724126972950272,
         0.109226208231073,
         -0.0690486470514803,
         0.126229324827375,
         -0.0381337062296311,
         -0.0163207140008255,
         0.00354977148942177,
         0.0529984832682702,
         0.0278611847706862,
         -0.0368261225802033,
         -0.00827440738286955,
         -0.036174776136332,
         -0.0431999911907183,
         0.0289360132770274,
         -0.0506824145980262,
         -0.0370259735817241,
         0.0101863162275323,
         0.0128734062917231,
         0.0362600429718397,
         0.00617277391920835,
         0.00747989264068448,
         0.0473366280687372,
         -0.0122422789880199,
         0.0232963482926172,
         -0.0547813224063412,
         0.0314744537387834,
         -0.0369553377966756,
         0.030435265004857,
         -0.0378954500676635,
         0.0304352650048571,
         -0.0369553377966756,
         -0.0124310617168811,
         -0.0262235150943876,
         0.0296086184666803,
         0.0335942409221706,
         0.0695604834092141,
         -0.0186641697095631,
         -0.0553096041104321,
         -0.00550637728501052,
         0.0328677504463742,
         -0.0163207140008259,
         -0.00831562192728999,
         0.0400929141240762,
         -0.0431999911907183,
         -0.0176098424022271,
         0.0686053340159694,
         0.0618237868266389,
         -0.0997973564592475,
         0.0676705948631831,
         -0.0599207230533386,
         0.0420463750826293,
         -0.0655261769035066,
         0.126229324827375,
         -0.0967551980406004,
         0.0514454958362976,
         0.0328677504463744,
         0.00728107764313907,
         0.00354977148942186,
         0.0276499513867743,
         -0.00224366343880707,
         -0.036174776136332,
         -0.0161623371801079,
         -0.0176098424022271,
         -0.0209478119285625,
         0.00355352611853001,
         -0.0506824145980262,
         -0.00145982642803522,
         0.0362600429718397,
         0.00595370724301856,
         0.0631676756007184,
         -0.00343823245785868,
         0.0410249533622561,
         0.0473366280687372,
         -0.0547813224063413,
         0.00926375676986973,
         -0.0720284513621885,
         -0.00281989471736848,
         -0.078846159844527,
         0.0304352650048571,
         0.00766950880924239,
         0.0456950340619522,
         0.0335942409221706,
         0.0296086184666803,
         -0.0262235150943876,
         -0.0124310617168811,
         -0.0186641697095631,
         0.0107236827645669,
         -0.0186641697095631,
         -0.0554516972723542,
         0.0694183902472915,
         -0.0563174095416284,
         0.0618237868266388,
         -0.0866694707795644,
         0.0975499467801146,
         -0.0922906856898995,
         0.0669337003567765,
         -0.0381337062296311,
         0.0514454958362975,
         -0.120050829852267,
         -0.00550637728501062,
         0.0328677504463743,
         -0.0163207140008255,
         -0.00831562192728989,
         0.0400929141240764,
         -0.0431999911907184,
         -0.0176098424022272,
         0.0686053340159694,
         -0.019339306667915,
         -0.0209478119285625,
         0.0289360132770276,
         -0.0379811287607775,
         0.00617277391920819,
         0.0631676756007185,
         -0.0552935444093027,
         0.0333045146202896,
         -0.00343823245785874,
         0.00747989264068439,
         0.0314744537387835,
         -0.0720284513621887,
         0.0131817606754906,
         -0.0311299854818993,
         -0.00281989471736841,
         -0.0369553377966756,
         0.0456950340619524,
         0.0323730318523441,
         0.0329134434956514,
         0.0335942409221705,
         -0.0124310617168813,
         -0.0612731089312931,
         -0.0553096041104322,
         -0.0186641697095631,
         0.069560483409214,
         0.0694183902472916,
         -0.0554516972723543,
         -0.0139666929749372},
        {0.0157380677900343,
         -0.0451675889328081,
         0.0294295211427744,
         0.00614069369210478,
         0.0516277296249359,
         -0.0684564163834778,
         0.0274294482461892,
         -0.0503552129074407,
         -0.00818512995361472,
         0.0739131696858876,
         -0.0507891503026879,
         0.0369349319807277,
         0.0183057147909155,
         -0.00751623843671634,
         -0.0691594831065021,
         0.0514143919043293,
         -0.000988593774539503,
         -0.0429640918248463,
         0.0236681741792709,
         -0.0122859768001256,
         0.0769298171001788,
         -0.0237865794000825,
         -0.0414417187563704,
         0.0506532878526454,
         -0.0104291617053202,
         -0.0125596300167195,
         0.0221636413735618,
         -0.0917055780158868,
         0.0105698773979642,
         0.0174840533250272,
         0.0216166657531931,
         -0.0674579673148395,
         0.0761836300239406,
         -0.0617659970055256,
         0.0349259947781715,
         0.065304007594578,
         -0.0513401975647227,
         0.0407703201667583,
         -0.0539870221688764,
         0.0395759116667477,
         0.00308825294126948,
         -0.0512710112003173,
         0.0924483425373343,
         -0.118849912958644,
         0.0535459053640658,
         0.0294295211427743,
         -0.0451675889328083,
         0.051627729624936,
         -0.0525589988811972,
         0.051627729624936,
         -0.0503552129074409,
         0.00109505899782532,
         0.0124370446426684,
         -0.00818512995361468,
         0.0369349319807275,
         -0.0102958840262748,
         0.0484977179690407,
         -0.0497512583070021,
         -0.00751623843671613,
         -0.000988593774539454,
         -0.00604700083445533,
         -0.00838670065885222,
         -0.0549381925693063,
         0.100469534539158,
         -0.0122859768001257,
         -0.0414417187563703,
         0.0123112902343298,
         -0.00673995125785224,
         0.0445876190263432,
         -0.00233040459364129,
         -0.0907494441763299,
         0.0221636413735619,
         0.0174840533250272,
         0.0628199290309311,
         -0.0538638003077089,
         0.0297485234910346,
         -0.0654520719461624,
         0.0722475108781831,
         0.0122573677182532,
         0.0349259947781714,
         0.0407703201667582,
         -0.0744694260684294,
         -0.00156720496461973,
         0.0346595012235051,
         -0.0168847370688468,
         0.0234631110609855,
         -0.0460020952663371,
         0.00734315712677473,
         -0.118849912958644,
         0.010569877397964,
         0.0174840533250272,
         0.0216166657531931,
         -0.0674579673148395,
         0.0761836300239407,
         -0.0617659970055254,
         0.0349259947781714,
         0.0653040075945778,
         -0.0684564163834778,
         0.0516277296249359,
         0.00614069369210483,
         -0.00818512995361472,
         0.0124370446426683,
         0.00109505899782522,
         -0.0503552129074408,
         0.0183057147909157,
         0.0484977179690408,
         -0.0685233468834497,
         0.0484977179690408,
         0.0183057147909156,
         -0.0429640918248462,
         -0.00838670065885217,
         -0.0346713346512975,
         0.0604237145680034,
         -0.0549381925693063,
         0.0236681741792709,
         0.0506532878526454,
         -0.00673995125785213,
         0.0241268079687432,
         0.0185112818096514,
         -0.0320204687935561,
         -0.00233040459364113,
         -0.0125596300167194,
         0.0216166657531932,
         -0.0538638003077088,
         0.0568203010273067,
         -0.0793816665188167,
         0.0235657061914937,
         0.0116138332920714,
         0.072247510878183,
         -0.0617659970055256,
         -0.0539870221688764,
         -0.00156720496461952,
         -0.000176915373578592,
         -0.00913997889271389,
         0.0595586396371725,
         -0.0271538992566217,
         -0.0481762495778187,
         -0.046002095266337,
         0.0924483425373345,
         0.0174840533250271,
         0.0628199290309311,
         -0.0538638003077089,
         0.0297485234910349,
         -0.0654520719461625,
         0.0722475108781831,
         0.0122573677182531,
         0.0349259947781713,
         -0.0237865794000824,
         -0.0414417187563703,
         0.0506532878526455,
         -0.0104291617053201,
         -0.0125596300167194,
         0.0221636413735618,
         -0.091705578015887,
         0.0739131696858875,
         -0.0081851299536147,
         -0.0503552129074408,
         0.0274294482461891,
         -0.00751623843671624,
         -0.0497512583070024,
         0.0484977179690409,
         -0.0102958840262747,
         0.0369349319807278,
         0.0236681741792707,
         -0.0549381925693062,
         0.0604237145680035,
         -0.0346713346512975,
         -0.00838670065885222,
         -0.0429640918248462,
         -0.0104291617053201,
         0.0445876190263431,
         0.0185112818096514,
         -0.0452649842259534,
         0.0185112818096515,
         0.0445876190263432,
         -0.0104291617053201,
         -0.0674579673148395,
         0.0297485234910349,
         -0.0793816665188169,
         0.0400362112751395,
         -0.0123325709275089,
         0.0235657061914939,
         -0.0654520719461624,
         0.0761836300239407,
         0.0395759116667478,
         0.0346595012235053,
         -0.00913997889271397,
         0.0359953014185372,
         -0.000723451495859457,
         -0.0093003694472674,
         -0.0271538992566216,
         0.0234631110609853,
         -0.0512710112003176,
         0.0216166657531932,
         -0.053863800307709,
         0.0568203010273066,
         -0.0793816665188168,
         0.0235657061914937,
         0.0116138332920715,
         0.0722475108781831,
         -0.0617659970055256,
         -0.0414417187563704,
         0.0123112902343297,
         -0.00673995125785221,
         0.0445876190263432,
         -0.00233040459364124,
         -0.0907494441763299,
         0.0221636413735618,
         0.0514143919043293,
         -0.000988593774539472,
         -0.0429640918248463,
         0.0236681741792708,
         -0.0122859768001257,
         0.0769298171001789,
         -0.0691594831065021,
         -0.00751623843671632,
         0.0183057147909156,
         0.0369349319807277,
         -0.0507891503026876,
         -0.0122859768001258,
         0.100469534539157,
         -0.0549381925693063,
         -0.0083867006588523,
         -0.00604700083445544,
         -0.000988593774539445,
         -0.0125596300167195,
         -0.00233040459364127,
         -0.0320204687935561,
         0.0185112818096514,
         0.0241268079687434,
         -0.00673995125785211,
         0.0506532878526455,
         0.0761836300239407,
         -0.0654520719461625,
         0.0235657061914936,
         -0.0123325709275089,
         0.0400362112751394,
         -0.079381666518817,
         0.0297485234910349,
         -0.0674579673148395,
         0.0030882529412693,
         -0.0168847370688468,
         0.0595586396371724,
         -0.000723451495859504,
         -0.0269801888517713,
         -0.000723451495859424,
         0.0595586396371724,
         -0.0168847370688466,
         0.00308825294126942,
         -0.0674579673148395,
         0.0297485234910348,
         -0.0793816665188169,
         0.0400362112751394,
         -0.0123325709275089,
         0.0235657061914935,
         -0.0654520719461624,
         0.0761836300239407,
         0.0506532878526453,
         -0.0067399512578522,
         0.0241268079687433,
         0.0185112818096515,
         -0.0320204687935561,
         -0.00233040459364113,
         -0.0125596300167195,
         -0.000988593774539382,
         -0.00604700083445546,
         -0.00838670065885213,
         -0.0549381925693064,
         0.100469534539157,
         -0.0122859768001257,
         -0.0507891503026877,
         0.0369349319807276,
         0.0183057147909156,
         -0.00751623843671641,
         -0.0691594831065023,
         0.0769298171001789,
         -0.0122859768001256,
         0.023668174179271,
         -0.0429640918248462,
         -0.000988593774539403,
         0.0514143919043292,
         0.0221636413735618,
         -0.0907494441763298,
         -0.00233040459364132,
         0.0445876190263431,
         -0.0067399512578523,
         0.0123112902343297,
         -0.0414417187563705,
         -0.0617659970055257,
         0.0722475108781831,
         0.0116138332920716,
         0.0235657061914936,
         -0.0793816665188167,
         0.0568203010273067,
         -0.0538638003077088,
         0.021616665753193,
         -0.0512710112003175,
         0.0234631110609853,
         -0.0271538992566216,
         -0.00930036944726753,
         -0.000723451495859376,
         0.0359953014185372,
         -0.00913997889271384,
         0.0346595012235053,
         0.0395759116667476,
         0.0761836300239407,
         -0.0654520719461625,
         0.0235657061914939,
         -0.0123325709275087,
         0.0400362112751394,
         -0.0793816665188169,
         0.0297485234910348,
         -0.0674579673148396,
         -0.0104291617053201,
         0.0445876190263433,
         0.0185112818096514,
         -0.0452649842259533,
         0.0185112818096514,
         0.0445876190263432,
         -0.0104291617053202,
         -0.0429640918248462,
         -0.00838670065885211,
         -0.0346713346512974,
         0.0604237145680034,
         -0.0549381925693062,
         0.0236681741792709,
         0.0369349319807277,
         -0.0102958840262749,
         0.0484977179690408,
         -0.0497512583070024,
         -0.0075162384367162,
         0.0274294482461893,
         -0.0503552129074408,
         -0.00818512995361468,
         0.0739131696858876,
         -0.0917055780158869,
         0.022163641373562,
         -0.0125596300167194,
         -0.0104291617053202,
         0.0506532878526455,
         -0.0414417187563703,
         -0.0237865794000823,
         0.0349259947781714,
         0.012257367718253,
         0.0722475108781832,
         -0.0654520719461625,
         0.0297485234910348,
         -0.0538638003077089,
         0.0628199290309314,
         0.0174840533250271,
         0.0924483425373345,
         -0.046002095266337,
         -0.0481762495778188,
         -0.0271538992566216,
         0.0595586396371725,
         -0.00913997889271398,
         -0.000176915373578656,
         -0.00156720496461996,
         -0.0539870221688762,
         -0.0617659970055256,
         0.0722475108781831,
         0.0116138332920716,
         0.0235657061914938,
         -0.0793816665188167,
         0.0568203010273068,
         -0.0538638003077089,
         0.0216166657531931,
         -0.0125596300167196,
         -0.00233040459364117,
         -0.0320204687935561,
         0.0185112818096514,
         0.0241268079687433,
         -0.00673995125785206,
         0.0506532878526454,
         0.0236681741792709,
         -0.0549381925693061,
         0.0604237145680036,
         -0.0346713346512976,
         -0.00838670065885217,
         -0.0429640918248462,
         0.0183057147909154,
         0.0484977179690409,
         -0.0685233468834497,
         0.0484977179690409,
         0.0183057147909156,
         -0.0503552129074407,
         0.00109505899782506,
         0.0124370446426684,
         -0.0081851299536146,
         0.00614069369210499,
         0.0516277296249358,
         -0.0684564163834779,
         0.0653040075945779,
         0.0349259947781714,
         -0.0617659970055253,
         0.0761836300239406,
         -0.0674579673148395,
         0.0216166657531931,
         0.0174840533250271,
         0.0105698773979642,
         -0.118849912958644,
         0.00734315712677465,
         -0.046002095266337,
         0.0234631110609853,
         -0.0168847370688468,
         0.0346595012235051,
         -0.00156720496461973,
         -0.0744694260684293,
         0.0407703201667583,
         0.0349259947781713,
         0.0122573677182532,
         0.072247510878183,
         -0.0654520719461625,
         0.0297485234910348,
         -0.0538638003077089,
         0.0628199290309311,
         0.017484053325027,
         0.0221636413735618,
         -0.0907494441763296,
         -0.00233040459364135,
         0.0445876190263432,
         -0.00673995125785218,
         0.0123112902343299,
         -0.0414417187563704,
         -0.0122859768001257,
         0.100469534539158,
         -0.0549381925693063,
         -0.00838670065885216,
         -0.00604700083445543,
         -0.000988593774539501,
         -0.00751623843671628,
         -0.0497512583070021,
         0.0484977179690409,
         -0.0102958840262748,
         0.0369349319807276,
         -0.00818512995361471,
         0.0124370446426685,
         0.00109505899782507,
         -0.0503552129074408,
         0.051627729624936,
         -0.0525589988811972,
         0.0516277296249359,
         -0.0451675889328084,
         0.0294295211427743,
         0.0535459053640657,
         -0.118849912958643,
         0.0924483425373346,
         -0.0512710112003175,
         0.00308825294126931,
         0.0395759116667477,
         -0.0539870221688764,
         0.0407703201667583,
         -0.0513401975647227,
         0.0653040075945779,
         0.0349259947781712,
         -0.0617659970055256,
         0.0761836300239406,
         -0.0674579673148394,
         0.0216166657531932,
         0.017484053325027,
         0.0105698773979641,
         -0.091705578015887,
         0.0221636413735617,
         -0.0125596300167194,
         -0.01042916170532,
         0.0506532878526456,
         -0.0414417187563704,
         -0.0237865794000825,
         0.0769298171001789,
         -0.0122859768001257,
         0.0236681741792708,
         -0.0429640918248462,
         -0.00098859377453951,
         0.0514143919043293,
         -0.0691594831065021,
         -0.0075162384367163,
         0.0183057147909155,
         0.0369349319807276,
         -0.0507891503026877,
         0.0739131696858877,
         -0.00818512995361471,
         -0.0503552129074407,
         0.0274294482461892,
         -0.068456416383478,
         0.0516277296249359,
         0.00614069369210488,
         0.0294295211427743,
         -0.0451675889328082,
         0.0157380677900339},
        {-0.0210041270679403,
         -0.00781756649231744,
         0.0288216935602577,
         0.0233785742671913,
         -0.0205852783609291,
         -0.0132606857853842,
         -0.0206049332156069,
         -0.00416046157737644,
         0.0275019732396869,
         -0.00507396304107404,
         0.00704754579282629,
         0.0214361116886537,
         -0.0193335632679899,
         -0.011939025074192,
         0.0126248654963352,
         0.00354698014507112,
         -0.0167514163467435,
         -0.00559928189866652,
         0.0259786469699386,
         -0.00979627038899628,
         -0.00642916009551705,
         0.021807400021876,
         -0.0380315702504205,
         0.0644507415761787,
         -0.062337764857212,
         0.034493287871506,
         -0.0195655970445942,
         0.0194728914585799,
         -0.0969531780580115,
         0.0994085203800372,
         -0.0746870968037825,
         0.0218869012337249,
         0.0302686147657852,
         -0.0575744844292471,
         0.0680311572316817,
         -0.0708996124411408,
         0.156608842899173,
         -0.0596556648411613,
         -0.0154901131949742,
         0.0652815110641623,
         -0.0791240028285062,
         0.059980449972889,
         -0.0215974603533911,
         -0.0298292606291698,
         0.100728873070311,
         0.0288216935602575,
         -0.00781756649231735,
         -0.0205852783609292,
         0.00622763653808885,
         -0.0205852783609292,
         -0.00416046157737644,
         0.0100938817049025,
         -0.000760510468117529,
         0.0275019732396869,
         0.0214361116886536,
         -0.00704784297528019,
         -0.000308869934485544,
         -0.0173017406803027,
         -0.011939025074192,
         -0.0167514163467435,
         -0.0144546995050348,
         0.00949627663036293,
         0.00371834304620412,
         0.0217416541438642,
         -0.00979627038899614,
         -0.0380315702504206,
         0.0799866900753032,
         -0.0656628294529064,
         0.06293759967891,
         -0.0798565316718628,
         0.0512668191644543,
         -0.0195655970445941,
         0.0994085203800369,
         -0.096265156209482,
         0.0472072104362376,
         -0.0270651005850069,
         0.00678311518879381,
         0.0475080590166127,
         -0.0801212576111701,
         0.0680311572316818,
         -0.0596556648411613,
         0.025103731335936,
         -0.0039843531625893,
         0.0121429047306516,
         -0.00334110872139624,
         -0.0214776054680609,
         0.0179624252777804,
         0.0107321113508289,
         -0.02982926062917,
         -0.0969531780580114,
         0.0994085203800371,
         -0.0746870968037825,
         0.0218869012337248,
         0.030268614765785,
         -0.0575744844292472,
         0.068031157231682,
         -0.070899612441141,
         -0.0132606857853842,
         -0.0205852783609291,
         0.0233785742671913,
         0.027501973239687,
         -0.000760510468117486,
         0.0100938817049024,
         -0.00416046157737629,
         -0.0193335632679899,
         -0.000308869934485542,
         -0.00898314565073613,
         -0.00030886993448559,
         -0.01933356326799,
         -0.00559928189866636,
         0.00949627663036257,
         -0.0039521529494343,
         0.0132076962782083,
         0.00371834304620411,
         0.0259786469699385,
         0.0644507415761788,
         -0.0656628294529063,
         0.0815865703262301,
         -0.0902087900252811,
         0.0692608871644216,
         -0.0798565316718629,
         0.0344932878715059,
         -0.0746870968037827,
         0.0472072104362379,
         -0.0550325429876493,
         0.0299187698909809,
         0.00763264631695265,
         -0.00968908333774099,
         0.0475080590166126,
         -0.0575744844292471,
         -0.0154901131949741,
         -0.00398435316258919,
         0.0467215641277662,
         -0.0333218674412429,
         0.0275827179210522,
         -0.0404988433357122,
         0.00828975686367442,
         0.0179624252777805,
         -0.0215974603533913,
         0.0994085203800371,
         -0.096265156209482,
         0.0472072104362376,
         -0.0270651005850071,
         0.0067831151887939,
         0.0475080590166124,
         -0.0801212576111702,
         0.0680311572316817,
         0.021807400021876,
         -0.0380315702504206,
         0.0644507415761789,
         -0.062337764857212,
         0.0344932878715058,
         -0.0195655970445942,
         0.0194728914585798,
         -0.00507396304107396,
         0.0275019732396869,
         -0.00416046157737633,
         -0.0206049332156069,
         -0.011939025074192,
         -0.017301740680303,
         -0.000308869934485475,
         -0.0070478429752801,
         0.0214361116886536,
         0.0259786469699384,
         0.00371834304620415,
         0.0132076962782087,
         -0.00395215294943437,
         0.00949627663036286,
         -0.00559928189866647,
         -0.0623377648572121,
         0.06293759967891,
         -0.0902087900252812,
         0.0858328704871484,
         -0.0902087900252811,
         0.0629375996789097,
         -0.062337764857212,
         0.0218869012337249,
         -0.027065100585007,
         0.0299187698909811,
         -0.0180353090589636,
         0.0177820110061456,
         0.00763264631695246,
         0.00678311518879401,
         0.0302686147657852,
         0.0652815110641623,
         0.0121429047306516,
         -0.033321867441243,
         0.0568172578802364,
         -0.0671653861150633,
         0.0421424110280978,
         -0.0404988433357121,
         -0.0214776054680609,
         0.0599804499728891,
         -0.0746870968037826,
         0.0472072104362379,
         -0.0550325429876494,
         0.0299187698909809,
         0.00763264631695264,
         -0.00968908333774109,
         0.0475080590166125,
         -0.0575744844292472,
         -0.0380315702504206,
         0.0799866900753032,
         -0.0656628294529063,
         0.06293759967891,
         -0.0798565316718628,
         0.0512668191644542,
         -0.0195655970445942,
         0.00354698014507115,
         -0.0167514163467436,
         -0.00559928189866656,
         0.0259786469699386,
         -0.00979627038899636,
         -0.0064291600955171,
         0.0126248654963353,
         -0.011939025074192,
         -0.0193335632679899,
         0.0214361116886536,
         0.00704754579282619,
         -0.0097962703889961,
         0.0217416541438644,
         0.00371834304620409,
         0.00949627663036266,
         -0.0144546995050348,
         -0.0167514163467437,
         0.0344932878715061,
         -0.0798565316718629,
         0.0692608871644215,
         -0.0902087900252811,
         0.0815865703262302,
         -0.0656628294529063,
         0.0644507415761788,
         0.0302686147657853,
         0.00678311518879404,
         0.00763264631695244,
         0.0177820110061454,
         -0.0180353090589636,
         0.0299187698909809,
         -0.027065100585007,
         0.0218869012337249,
         -0.0791240028285064,
         -0.0033411087213961,
         0.0275827179210522,
         -0.067165386115063,
         0.0674186841678815,
         -0.067165386115063,
         0.0275827179210522,
         -0.00334110872139607,
         -0.0791240028285064,
         0.0218869012337249,
         -0.027065100585007,
         0.0299187698909809,
         -0.0180353090589636,
         0.0177820110061457,
         0.00763264631695255,
         0.00678311518879402,
         0.0302686147657853,
         0.0644507415761789,
         -0.0656628294529063,
         0.0815865703262302,
         -0.0902087900252811,
         0.0692608871644215,
         -0.0798565316718627,
         0.0344932878715059,
         -0.0167514163467436,
         -0.0144546995050348,
         0.00949627663036279,
         0.00371834304620398,
         0.0217416541438645,
         -0.00979627038899616,
         0.00704754579282638,
         0.0214361116886537,
         -0.0193335632679899,
         -0.0119390250741919,
         0.0126248654963355,
         -0.00642916009551698,
         -0.00979627038899616,
         0.0259786469699387,
         -0.00559928189866665,
         -0.0167514163467434,
         0.00354698014507111,
         -0.0195655970445942,
         0.051266819164454,
         -0.0798565316718629,
         0.0629375996789099,
         -0.0656628294529064,
         0.0799866900753032,
         -0.0380315702504207,
         -0.0575744844292472,
         0.0475080590166126,
         -0.00968908333774104,
         0.00763264631695258,
         0.029918769890981,
         -0.0550325429876495,
         0.0472072104362378,
         -0.0746870968037826,
         0.0599804499728892,
         -0.0214776054680609,
         -0.0404988433357122,
         0.0421424110280978,
         -0.0671653861150632,
         0.0568172578802365,
         -0.033321867441243,
         0.0121429047306515,
         0.0652815110641623,
         0.0302686147657852,
         0.00678311518879416,
         0.00763264631695267,
         0.0177820110061455,
         -0.0180353090589634,
         0.0299187698909809,
         -0.027065100585007,
         0.0218869012337249,
         -0.0623377648572121,
         0.0629375996789097,
         -0.0902087900252813,
         0.0858328704871483,
         -0.0902087900252811,
         0.0629375996789099,
         -0.0623377648572121,
         -0.00559928189866651,
         0.00949627663036274,
         -0.00395215294943441,
         0.0132076962782084,
         0.00371834304620414,
         0.0259786469699387,
         0.0214361116886536,
         -0.00704784297528019,
         -0.000308869934485336,
         -0.0173017406803029,
         -0.011939025074192,
         -0.0206049332156069,
         -0.00416046157737628,
         0.0275019732396868,
         -0.005073963041074,
         0.0194728914585797,
         -0.0195655970445943,
         0.0344932878715059,
         -0.062337764857212,
         0.0644507415761788,
         -0.0380315702504206,
         0.0218074000218759,
         0.0680311572316817,
         -0.0801212576111703,
         0.0475080590166124,
         0.00678311518879386,
         -0.0270651005850068,
         0.0472072104362376,
         -0.0962651562094821,
         0.0994085203800372,
         -0.0215974603533912,
         0.0179624252777804,
         0.00828975686367424,
         -0.0404988433357121,
         0.0275827179210521,
         -0.033321867441243,
         0.0467215641277662,
         -0.00398435316258908,
         -0.0154901131949741,
         -0.0575744844292473,
         0.0475080590166125,
         -0.00968908333774126,
         0.00763264631695261,
         0.0299187698909807,
         -0.0550325429876493,
         0.0472072104362378,
         -0.0746870968037824,
         0.034493287871506,
         -0.0798565316718629,
         0.0692608871644214,
         -0.0902087900252812,
         0.0815865703262301,
         -0.0656628294529064,
         0.0644507415761788,
         0.0259786469699387,
         0.00371834304620431,
         0.0132076962782085,
         -0.00395215294943443,
         0.00949627663036266,
         -0.00559928189866663,
         -0.0193335632679899,
         -0.000308869934485445,
         -0.00898314565073619,
         -0.000308869934485494,
         -0.0193335632679898,
         -0.00416046157737653,
         0.0100938817049024,
         -0.000760510468117401,
         0.0275019732396869,
         0.0233785742671912,
         -0.0205852783609289,
         -0.0132606857853841,
         -0.0708996124411408,
         0.0680311572316817,
         -0.0575744844292472,
         0.0302686147657853,
         0.0218869012337248,
         -0.0746870968037827,
         0.099408520380037,
         -0.0969531780580114,
         -0.0298292606291699,
         0.010732111350829,
         0.0179624252777804,
         -0.0214776054680611,
         -0.00334110872139614,
         0.0121429047306515,
         -0.00398435316258928,
         0.0251037313359359,
         -0.0596556648411614,
         0.0680311572316818,
         -0.0801212576111702,
         0.0475080590166125,
         0.00678311518879375,
         -0.027065100585007,
         0.0472072104362378,
         -0.0962651562094821,
         0.0994085203800369,
         -0.019565597044594,
         0.0512668191644541,
         -0.0798565316718629,
         0.0629375996789099,
         -0.0656628294529062,
         0.0799866900753032,
         -0.0380315702504207,
         -0.00979627038899626,
         0.0217416541438644,
         0.0037183430462043,
         0.00949627663036283,
         -0.0144546995050347,
         -0.0167514163467435,
         -0.011939025074192,
         -0.0173017406803028,
         -0.000308869934485606,
         -0.00704784297528028,
         0.0214361116886538,
         0.027501973239687,
         -0.000760510468117462,
         0.0100938817049022,
         -0.00416046157737636,
         -0.020585278360929,
         0.006227636538089,
         -0.020585278360929,
         -0.00781756649231751,
         0.0288216935602577,
         0.100728873070311,
         -0.0298292606291698,
         -0.021597460353391,
         0.0599804499728891,
         -0.0791240028285064,
         0.0652815110641622,
         -0.0154901131949742,
         -0.0596556648411617,
         0.156608842899173,
         -0.0708996124411407,
         0.0680311572316818,
         -0.0575744844292471,
         0.0302686147657853,
         0.0218869012337249,
         -0.0746870968037826,
         0.0994085203800369,
         -0.0969531780580113,
         0.0194728914585797,
         -0.0195655970445942,
         0.034493287871506,
         -0.062337764857212,
         0.0644507415761788,
         -0.0380315702504206,
         0.0218074000218758,
         -0.00642916009551699,
         -0.00979627038899619,
         0.0259786469699386,
         -0.00559928189866656,
         -0.0167514163467436,
         0.00354698014507108,
         0.0126248654963354,
         -0.0119390250741922,
         -0.0193335632679899,
         0.0214361116886536,
         0.00704754579282626,
         -0.00507396304107403,
         0.0275019732396868,
         -0.00416046157737646,
         -0.0206049332156069,
         -0.0132606857853842,
         -0.0205852783609292,
         0.0233785742671913,
         0.0288216935602576,
         -0.00781756649231752,
         -0.0210041270679403}};

    m_array_all = {
        {{0, 0, 0, 0}},
        {{0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1}},
        {{0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2}},
        {{0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2}},
        {{0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2}},
        {{-1, -1, 1, 1},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 1, -1, -1}},
        {{-1, -1, 1, 1},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 1, -1, -1}},
        {{-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2}},
        {{-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2}},
        {{-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}},
        {{-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}},
        {{-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}},
        {{-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}},
        {{0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3}},
        {{0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4}},
        {{0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3}},
        {{0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4}},
        {{0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4}},
        {{0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3}},
        {{0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4}},
        {{0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4}},
        {{0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4}},
        {{-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3}},
        {{-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4}},
        {{-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3}},
        {{-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3}},
        {{-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4}},
        {{-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4}},
        {{-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3}},
        {{-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3}},
        {{-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4}},
        {{-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4}},
        {{-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3}},
        {{-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3}},
        {{-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4}},
        {{-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4}},
        {{-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}},
        {{-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}},
        {{-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3}},
        {{-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3}},
        {{-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3}},
        {{-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3}},
        {{-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}},
        {{-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}},
        {{-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}},
        {{-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}},
        {{-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}},
        {{-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}},
        {{-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}},
        {{-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}},
        {{-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4}},
        {{-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4}},
        {{-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4}},
        {{-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4}},
        {{-3, -3, 3, 3},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 3, -3, -3}},
        {{-3, -3, 3, 3},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 3, -3, -3}},
        {{-3, -3, 3, 3},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 3, -3, -3}},
        {{-3, -3, 3, 3},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 3, -3, -3}},
        {{-3, -3, 3, 3},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 3, -3, -3}},
        {{-3, -3, 3, 3},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 3, -3, -3}},
        {{-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4}},
        {{-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4}},
        {{-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4}},
        {{-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4}},
        {{-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4}},
        {{-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}},
        {{-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}}
    };

}
