/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_order5.h"

GtinvDataOrder5::GtinvDataOrder5(){

    set_gtinv_info();
}

GtinvDataOrder5::~GtinvDataOrder5(){}

const vector2i& GtinvDataOrder5::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataOrder5::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataOrder5::get_coeffs() const{ return coeffs_all; }

void GtinvDataOrder5::set_gtinv_info(){

    l_array_all =
        {{0, 0, 0, 0, 0},
        {0, 0, 0, 1, 1},
        {0, 1, 1, 1, 1},
        {0, 1, 1, 1, 1}};

    coeffs_all =
        {{1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {-0.221288179974227,
         0.0545140597182974,
         0.16677412025593,
         -0.26307320284771,
         0.208559143129412,
         -0.375333263385342,
         0.16677412025593,
         0.0545140597182974,
         0.208559143129412,
         -0.42984732310364,
         0.208559143129412,
         0.0545140597182972,
         0.166774120255929,
         -0.375333263385342,
         0.208559143129413,
         -0.26307320284771,
         0.16677412025593,
         0.0545140597182974,
         -0.221288179974227},
        {0.176688245674687,
         -0.353471044321463,
         0.176782798646776,
         0.287917424895051,
         0.0655536194264122,
         -0.242336418073188,
         0.176782798646776,
         -0.353471044321463,
         0.0655536194264122,
         0.111134626248275,
         0.0655536194264122,
         -0.353471044321463,
         0.176782798646776,
         -0.242336418073188,
         0.0655536194264121,
         0.28791742489505,
         0.176782798646776,
         -0.353471044321463,
         0.176688245674687}};

    m_array_all = {
        {{0, 0, 0, 0, 0}},
        {{0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1}},
        {{0, -1, -1, 1, 1},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 1, -1, -1}},
        {{0, -1, -1, 1, 1},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 1, -1, -1}}
    };

}
