/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_ver2_order4.h"

GtinvDataVer2Order4::GtinvDataVer2Order4(){

    set_gtinv_info();
}

GtinvDataVer2Order4::~GtinvDataVer2Order4(){}

const vector2i& GtinvDataVer2Order4::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataVer2Order4::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataVer2Order4::get_coeffs() const{ return coeffs_all; }

void GtinvDataVer2Order4::set_gtinv_info(){

    l_array_all = {
        {0, 0, 0, 0},
        {0, 0, 1, 1},
        {0, 0, 2, 2},
        {0, 0, 3, 3},
        {0, 0, 4, 4},
        {0, 1, 1, 2},
        {0, 1, 2, 3},
        {0, 1, 3, 4},
        {0, 2, 2, 2},
        {0, 2, 2, 4},
        {0, 2, 3, 3},
        {0, 2, 4, 4},
        {0, 3, 3, 4},
        {0, 4, 4, 4},
        {1, 1, 1, 1},
        {1, 1, 1, 1},
        {1, 1, 1, 1},
        {1, 1, 1, 3},
        {1, 1, 2, 2},
        {1, 1, 2, 2},
        {1, 1, 2, 2},
        {1, 1, 2, 4},
        {1, 1, 3, 3},
        {1, 1, 3, 3},
        {1, 1, 3, 3},
        {1, 1, 4, 4},
        {1, 1, 4, 4},
        {1, 1, 4, 4},
        {1, 2, 2, 3},
        {1, 2, 2, 3},
        {1, 2, 2, 3},
        {1, 2, 3, 4},
        {1, 2, 3, 4},
        {1, 2, 3, 4},
        {1, 3, 3, 3},
        {1, 3, 3, 3},
        {1, 3, 3, 3},
        {1, 3, 4, 4},
        {1, 3, 4, 4},
        {1, 3, 4, 4},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 4},
        {2, 2, 2, 4},
        {2, 2, 2, 4},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4}
    };

    coeffs_all = {
        {1.0},
        {0.5773502691896258,
         -0.5773502691896255,
         0.5773502691896256},
        {0.44721359549995804,
         -0.447213595499958,
         0.4472135954999579,
         -0.4472135954999579,
         0.4472135954999581},
        {0.3779644730092273,
         -0.3779644730092271,
         0.37796447300922714,
         -0.3779644730092272,
         0.37796447300922714,
         -0.37796447300922714,
         0.37796447300922725},
        {0.3333333333333333,
         -0.3333333333333336,
         0.3333333333333333,
         -0.33333333333333337,
         0.33333333333333337,
         -0.33333333333333337,
         0.33333333333333337,
         -0.3333333333333333,
         0.3333333333333335},
        {0.44721359549995815,
         -0.31622776601683733,
         0.18257418583505536,
         -0.3162277660168378,
         0.36514837167011066,
         -0.31622776601683783,
         0.18257418583505539,
         -0.3162277660168379,
         0.44721359549995787},
        {0.3779644730092273,
         -0.30860669992418366,
         0.23904572186687864,
         -0.1690308509457032,
         0.09759000729485333,
         -0.2182178902359923,
         0.27602622373694163,
         -0.29277002188455986,
         0.27602622373694163,
         -0.2182178902359923,
         0.0975900072948533,
         -0.1690308509457032,
         0.23904572186687864,
         -0.3086066999241837,
         0.3779644730092273},
        {0.3333333333333335,
         -0.28867513459481287,
         0.24397501823713313,
         -0.19920476822239888,
         0.15430334996209172,
         -0.1091089451179961,
         0.0629940788348712,
         -0.16666666666666663,
         0.2182178902359925,
         -0.24397501823713313,
         0.2519763153394846,
         -0.24397501823713313,
         0.2182178902359925,
         -0.16666666666666663,
         0.0629940788348712,
         -0.10910894511799613,
         0.15430334996209172,
         -0.19920476822239888,
         0.2439750182371332,
         -0.288675134594813,
         0.33333333333333337},
        {0.23904572186687892,
         -0.2927700218845595,
         0.23904572186687875,
         -0.29277002188455986,
         0.11952286093343933,
         0.1195228609334393,
         -0.29277002188455986,
         0.23904572186687875,
         0.11952286093343933,
         -0.2390457218668786,
         0.1195228609334393,
         0.2390457218668787,
         -0.2927700218845598,
         0.11952286093343933,
         0.11952286093343933,
         -0.2927700218845598,
         0.2390457218668788,
         -0.29277002188456,
         0.2390457218668788},
        {0.33333333333333337,
         -0.23570226039551623,
         0.154303349962092,
         -0.08908708063747484,
         0.03984095364447979,
         -0.23570226039551595,
         0.2519763153394849,
         -0.21821789023599228,
         0.15936381457791912,
         -0.08908708063747482,
         0.15430334996209197,
         -0.21821789023599228,
         0.23904572186687875,
         -0.21821789023599233,
         0.15430334996209197,
         -0.08908708063747482,
         0.15936381457791912,
         -0.2182178902359923,
         0.251976315339485,
         -0.23570226039551592,
         0.03984095364447978,
         -0.08908708063747486,
         0.15430334996209205,
         -0.23570226039551598,
         0.3333333333333337},
        {0.154303349962092,
         -0.21821789023599225,
         0.23904572186687875,
         -0.21821789023599228,
         0.15430334996209194,
         -0.24397501823713325,
         0.18898223650461368,
         -0.0690065559342354,
         -0.0690065559342354,
         0.18898223650461368,
         -0.24397501823713325,
         0.2439750182371333,
         -0.14638501094228,
         0.19518001458970644,
         -0.14638501094228004,
         0.24397501823713336,
         -0.24397501823713322,
         0.18898223650461368,
         -0.0690065559342354,
         -0.0690065559342354,
         0.18898223650461368,
         -0.24397501823713322,
         0.15430334996209197,
         -0.21821789023599233,
         0.23904572186687875,
         -0.21821789023599233,
         0.15430334996209194},
        {0.11009637651263611,
         -0.16514456476895423,
         0.19738550848793063,
         -0.2080625946441197,
         0.19738550848793063,
         -0.16514456476895414,
         0.11009637651263607,
         -0.20597146021777485,
         0.19462473604038077,
         -0.13241022442571232,
         0.046524210519923614,
         0.04652421051992362,
         -0.13241022442571232,
         0.19462473604038077,
         -0.2059714602177749,
         0.23783535600422534,
         -0.059458839001056356,
         -0.06795295885835019,
         0.1444000375739935,
         -0.16988239714587522,
         0.1444000375739935,
         -0.06795295885835019,
         -0.05945883900105637,
         0.23783535600422534,
         -0.2059714602177749,
         0.19462473604038077,
         -0.13241022442571238,
         0.04652421051992362,
         0.04652421051992362,
         -0.13241022442571238,
         0.19462473604038075,
         -0.20597146021777493,
         0.1100963765126361,
         -0.16514456476895417,
         0.19738550848793066,
         -0.20806259464411972,
         0.19738550848793066,
         -0.16514456476895414,
         0.1100963765126361},
        {0.17407765595569796,
         -0.21320071635561033,
         0.1973855084879307,
         -0.14712247158412492,
         0.08058229640253804,
         -0.22473328748774732,
         0.10050378152592122,
         0.04652421051992355,
         -0.1519474352795172,
         0.1880253582725887,
         -0.1471224715841249,
         0.17407765595569785,
         0.10050378152592122,
         -0.1698823971458753,
         0.10403129732205986,
         0.026860765467512586,
         -0.1519474352795172,
         0.19738550848793066,
         -0.21320071635561044,
         0.04652421051992355,
         0.10403129732205986,
         -0.16116459280507572,
         0.10403129732205985,
         0.04652421051992356,
         -0.2132007163556104,
         0.19738550848793066,
         -0.1519474352795172,
         0.026860765467512586,
         0.10403129732205985,
         -0.1698823971458753,
         0.10050378152592125,
         0.17407765595569788,
         -0.1471224715841249,
         0.1880253582725887,
         -0.1519474352795172,
         0.04652421051992356,
         0.10050378152592124,
         -0.22473328748774732,
         0.08058229640253804,
         -0.1471224715841249,
         0.1973855084879307,
         -0.21320071635561053,
         0.17407765595569794},
        {0.10429770312912395,
         -0.16490914830605163,
         0.1869893980016915,
         -0.1649091483060513,
         0.10429770312912398,
         -0.16490914830605122,
         0.15644655469368593,
         -0.0623297993338971,
         -0.0623297993338971,
         0.15644655469368593,
         -0.1649091483060512,
         0.18698939800169145,
         -0.0623297993338971,
         -0.08194819531574034,
         0.14135069854804366,
         -0.08194819531574034,
         -0.0623297993338971,
         0.1869893980016914,
         -0.16490914830605122,
         -0.0623297993338971,
         0.14135069854804366,
         -0.0670485234401511,
         -0.0670485234401511,
         0.14135069854804366,
         -0.0623297993338971,
         -0.16490914830605125,
         0.10429770312912393,
         0.15644655469368596,
         -0.08194819531574032,
         -0.0670485234401511,
         0.13409704688030202,
         -0.06704852344015108,
         -0.08194819531574034,
         0.15644655469368596,
         0.10429770312912393,
         -0.16490914830605125,
         -0.062329799333897117,
         0.14135069854804366,
         -0.06704852344015107,
         -0.06704852344015107,
         0.14135069854804366,
         -0.062329799333897117,
         -0.16490914830605127,
         0.18698939800169145,
         -0.06232979933389713,
         -0.08194819531574031,
         0.14135069854804366,
         -0.08194819531574031,
         -0.06232979933389713,
         0.18698939800169145,
         -0.16490914830605125,
         0.15644655469368599,
         -0.062329799333897144,
         -0.062329799333897144,
         0.15644655469368599,
         -0.16490914830605125,
         0.10429770312912393,
         -0.1649091483060513,
         0.18698939800169143,
         -0.16490914830605136,
         0.10429770312912394},
        {0.28857110751590526,
         -0.28857110751590537,
         -0.27962316619758293,
         -0.00894794131832261,
         0.29751904883422814,
         -0.28857110751590537,
         0.2885711075159055,
         -0.008947941318322583,
         0.008947941318322578,
         -0.008947941318322576,
         0.2885711075159054,
         -0.2885711075159054,
         0.29751904883422803,
         -0.008947941318322569,
         -0.27962316619758276,
         -0.28857110751590537,
         0.2885711075159054},
        {-0.007749144493239756,
         0.007749144493239786,
         0.3409623577025525,
         -0.3332132132093128,
         0.32546406871607286,
         0.007749144493239798,
         -0.0077491444932397974,
         -0.33321321320931263,
         0.3332132132093127,
         -0.3332132132093127,
         -0.0077491444932397974,
         0.007749144493239798,
         0.325464068716073,
         -0.3332132132093128,
         0.3409623577025524,
         0.007749144493239758,
         -0.007749144493239773},
        {0.44721359549995804,
         -0.22360679774997916,
         -0.2236067977499789,
         0.07453559924999306,
         0.14907119849998607,
         0.07453559924999306,
         -0.2236067977499789,
         -0.2236067977499789,
         0.1490711984999861,
         0.298142396999972,
         0.1490711984999861,
         -0.2236067977499789,
         -0.2236067977499789,
         0.07453559924999303,
         0.14907119849998604,
         0.07453559924999303,
         -0.22360679774997894,
         -0.22360679774997885,
         0.447213595499958},
        {0.37796447300922764,
         -0.21821789023599203,
         0.09759000729485336,
         -0.21821789023599233,
         0.19518001458970663,
         -0.11952286093343929,
         0.09759000729485333,
         -0.11952286093343933,
         0.09759000729485333,
         -0.21821789023599233,
         0.19518001458970663,
         -0.11952286093343929,
         0.19518001458970666,
         -0.2390457218668787,
         0.19518001458970663,
         -0.11952286093343926,
         0.1951800145897066,
         -0.21821789023599233,
         0.09759000729485333,
         -0.11952286093343933,
         0.09759000729485333,
         -0.11952286093343926,
         0.19518001458970663,
         -0.21821789023599233,
         0.09759000729485337,
         -0.2182178902359924,
         0.3779644730092274},
        {-0.18257418583505536,
         0.223606797749979,
         -0.223606797749979,
         0.18257418583505536,
         0.2581988897471611,
         -0.12909944487358047,
         0.1290994448735806,
         -0.2581988897471612,
         0.18257418583505533,
         -0.223606797749979,
         0.22360679774997894,
         -0.18257418583505527,
         -0.18257418583505533,
         0.223606797749979,
         -0.2236067977499789,
         0.18257418583505536,
         -0.25819888974716126,
         0.12909944487358058,
         -0.12909944487358047,
         0.25819888974716115,
         0.18257418583505536,
         -0.223606797749979,
         0.22360679774997896,
         -0.18257418583505536},
        {0.23904572186687886,
         -0.2927700218845597,
         0.23904572186687884,
         -0.20701966780270617,
         0.08451542547285161,
         0.0845154254728516,
         -0.20701966780270623,
         0.09759000729485333,
         0.04879500364742665,
         -0.09759000729485331,
         0.04879500364742665,
         0.09759000729485333,
         -0.20701966780270623,
         0.08451542547285161,
         0.08451542547285164,
         -0.20701966780270623,
         0.19518001458970669,
         0.09759000729485331,
         -0.19518001458970663,
         0.09759000729485331,
         0.1951800145897067,
         -0.20701966780270617,
         0.08451542547285165,
         0.08451542547285165,
         -0.20701966780270617,
         0.09759000729485333,
         0.04879500364742665,
         -0.09759000729485331,
         0.04879500364742665,
         0.09759000729485334,
         -0.20701966780270617,
         0.08451542547285165,
         0.08451542547285167,
         -0.20701966780270617,
         0.2390457218668789,
         -0.29277002188456014,
         0.2390457218668789},
        {0.25819888974716126,
         -0.25819888974716115,
         0.2581988897471611,
         -0.2581988897471611,
         0.25819888974716115,
         -0.2581988897471612,
         0.2581988897471611,
         -0.25819888974716115,
         0.25819888974716115,
         -0.2581988897471611,
         0.2581988897471611,
         -0.25819888974716115,
         0.25819888974716115,
         -0.2581988897471612,
         0.25819888974716126},
        {0.3333333333333334,
         -0.23570226039551623,
         0.15430334996209197,
         -0.08908708063747481,
         0.03984095364447977,
         -0.16666666666666663,
         0.17817416127494956,
         -0.1543033499620918,
         0.11268723396380212,
         -0.0629940788348712,
         0.06299407883487122,
         -0.08908708063747474,
         0.09759000729485333,
         -0.08908708063747478,
         0.06299407883487122,
         -0.16666666666666666,
         0.17817416127494956,
         -0.1543033499620918,
         0.11268723396380217,
         -0.0629940788348712,
         0.12598815766974245,
         -0.17817416127494953,
         0.1951800145897066,
         -0.17817416127494953,
         0.12598815766974245,
         -0.0629940788348712,
         0.11268723396380217,
         -0.1543033499620918,
         0.17817416127494956,
         -0.16666666666666663,
         0.06299407883487122,
         -0.08908708063747478,
         0.0975900072948533,
         -0.08908708063747478,
         0.06299407883487124,
         -0.0629940788348712,
         0.11268723396380212,
         -0.15430334996209175,
         0.17817416127494956,
         -0.16666666666666663,
         0.03984095364447977,
         -0.08908708063747481,
         0.15430334996209194,
         -0.23570226039551584,
         0.3333333333333336},
        {0.13362836122374017,
         -0.17251347253351199,
         0.18897904076030483,
         -0.18897904076030475,
         0.17251347253351193,
         -0.13362836122374047,
         -0.23272016185101982,
         0.1555697915271244,
         -0.07841942120322941,
         0.0012690508793342316,
         0.07588131944456093,
         -0.153031689768456,
         0.23018206009235137,
         -0.13362836122374047,
         0.1725134725335119,
         -0.18897904076030478,
         0.18897904076030475,
         -0.172513472533512,
         0.13362836122374053,
         0.0012690508793342292,
         -0.0012690508793342103,
         0.0012690508793342056,
         -0.001269050879334186,
         0.0012690508793342125,
         -0.0012690508793342244,
         0.0012690508793342205,
         0.13362836122374058,
         -0.17251347253351196,
         0.18897904076030475,
         -0.18897904076030472,
         0.17251347253351193,
         -0.1336283612237405,
         0.23018206009235137,
         -0.15303168976845602,
         0.07588131944456093,
         0.0012690508793342038,
         -0.07841942120322935,
         0.15556979152712438,
         -0.23272016185101982,
         -0.1336283612237405,
         0.17251347253351199,
         -0.18897904076030475,
         0.18897904076030478,
         -0.17251347253351199,
         0.13362836122374058},
        {-0.0007771317779998745,
         0.0010032728113339158,
         -0.0010990303001984169,
         0.0010990303001984511,
         -0.001003272811333934,
         0.0007771317779998215,
         -0.21686816838464662,
         0.2173168456258706,
         -0.21776552286709452,
         0.21821420010831857,
         -0.2186628773495425,
         0.21911155459076656,
         -0.21956023183199064,
         0.0007771317779998075,
         -0.0010032728113339448,
         0.0010990303001984336,
         -0.001099030300198448,
         0.0010032728113339101,
         -0.0007771317779998121,
         0.21821420010831855,
         -0.2182142001083185,
         0.2182142001083185,
         -0.2182142001083185,
         0.21821420010831846,
         -0.21821420010831846,
         0.21821420010831857,
         -0.0007771317779997827,
         0.001003272811333894,
         -0.0010990303001984555,
         0.0010990303001984373,
         -0.001003272811333921,
         0.0007771317779998128,
         -0.2195602318319906,
         0.2191115545907666,
         -0.21866287734954257,
         0.2182142001083186,
         -0.21776552286709452,
         0.21731684562587056,
         -0.2168681683846466,
         0.0007771317779998071,
         -0.0010032728113339284,
         0.001099030300198439,
         -0.0010990303001984331,
         0.0010032728113339418,
         -0.0007771317779997825},
        {0.15430334996209197,
         -0.21821789023599236,
         0.23904572186687875,
         -0.21821789023599233,
         0.15430334996209197,
         -0.17251638983558848,
         0.13363062095621223,
         -0.048795003647426644,
         -0.048795003647426644,
         0.13363062095621223,
         -0.1725163898355885,
         0.09960238411119951,
         -0.05976143046671974,
         0.0796819072889595,
         -0.05976143046671974,
         0.0996023841111995,
         -0.17251638983558848,
         0.13363062095621223,
         -0.048795003647426644,
         -0.048795003647426644,
         0.1336306209562122,
         -0.17251638983558848,
         0.19920476822239902,
         -0.11952286093343947,
         0.15936381457791907,
         -0.11952286093343947,
         0.199204768222399,
         -0.1725163898355885,
         0.13363062095621223,
         -0.048795003647426644,
         -0.048795003647426644,
         0.1336306209562122,
         -0.1725163898355885,
         0.09960238411119952,
         -0.05976143046671972,
         0.0796819072889595,
         -0.05976143046671974,
         0.09960238411119951,
         -0.17251638983558848,
         0.13363062095621217,
         -0.04879500364742664,
         -0.048795003647426644,
         0.1336306209562122,
         -0.17251638983558845,
         0.15430334996209188,
         -0.21821789023599245,
         0.2390457218668787,
         -0.21821789023599245,
         0.15430334996209186},
        {0.11009637651263608,
         -0.16514456476895434,
         0.19738550848793066,
         -0.20806259464411972,
         0.19738550848793066,
         -0.1651445647689542,
         0.1100963765126361,
         -0.14564381625088382,
         0.1376204706407951,
         -0.09362816758985384,
         0.0328975847479885,
         0.0328975847479885,
         -0.09362816758985383,
         0.1376204706407951,
         -0.14564381625088382,
         0.09709587750058928,
         -0.024273969375147343,
         -0.027741679285882698,
         0.05895106848250048,
         -0.0693541982147066,
         0.05895106848250048,
         -0.02774167928588269,
         -0.024273969375147333,
         0.09709587750058926,
         -0.14564381625088382,
         0.1376204706407951,
         -0.09362816758985384,
         0.032897584747988505,
         0.0328975847479885,
         -0.09362816758985386,
         0.1376204706407951,
         -0.14564381625088385,
         0.19419175500117852,
         -0.04854793875029466,
         -0.0554833585717654,
         0.11790213696500092,
         -0.1387083964294132,
         0.11790213696500092,
         -0.0554833585717654,
         -0.04854793875029466,
         0.19419175500117852,
         -0.14564381625088385,
         0.1376204706407951,
         -0.09362816758985389,
         0.032897584747988505,
         0.03289758474798851,
         -0.09362816758985387,
         0.13762047064079508,
         -0.1456438162508839,
         0.0970958775005893,
         -0.024273969375147336,
         -0.02774167928588269,
         0.058951068482500465,
         -0.0693541982147066,
         0.05895106848250048,
         -0.02774167928588269,
         -0.024273969375147343,
         0.0970958775005893,
         -0.1456438162508839,
         0.1376204706407951,
         -0.09362816758985387,
         0.03289758474798851,
         0.032897584747988505,
         -0.09362816758985384,
         0.1376204706407951,
         -0.1456438162508839,
         0.11009637651263615,
         -0.1651445647689542,
         0.19738550848793068,
         -0.20806259464411966,
         0.19738550848793066,
         -0.1651445647689542,
         0.11009637651263615},
        {-0.1053315110207335,
         0.1393404916897601,
         -0.1579972665311003,
         0.16654374210632247,
         -0.1665437421063225,
         0.15799726653110027,
         -0.13934049168976004,
         0.10533151102073353,
         0.2180530823028813,
         -0.16538732679251456,
         0.11272157128214781,
         -0.060055815771781,
         0.007390060261414263,
         0.045275695248952454,
         -0.09794145075931927,
         0.15060720626968596,
         -0.20327296178005277,
         0.10533151102073356,
         -0.13934049168976004,
         0.1579972665311003,
         -0.16654374210632253,
         0.16654374210632253,
         -0.1579972665311003,
         0.13934049168976004,
         -0.10533151102073351,
         -0.007390060261414214,
         0.007390060261414286,
         -0.007390060261414257,
         0.007390060261414265,
         -0.0073900602614142795,
         0.007390060261414272,
         -0.007390060261414231,
         0.0073900602614142795,
         -0.007390060261414256,
         -0.10533151102073351,
         0.13934049168976004,
         -0.15799726653110033,
         0.16654374210632256,
         -0.16654374210632247,
         0.15799726653110027,
         -0.13934049168976004,
         0.10533151102073353,
         -0.2032729617800528,
         0.150607206269686,
         -0.09794145075931926,
         0.04527569524895244,
         0.007390060261414262,
         -0.06005581577178098,
         0.11272157128214777,
         -0.16538732679251453,
         0.2180530823028813,
         0.10533151102073354,
         -0.13934049168976004,
         0.1579972665311003,
         -0.16654374210632245,
         0.1665437421063225,
         -0.15799726653110033,
         0.13934049168976004,
         -0.10533151102073356},
        {-0.004047702706499083,
         0.005354607371259845,
         -0.006071554059748624,
         0.006399979921882592,
         -0.006399979921882606,
         0.0060715540597486555,
         -0.005354607371259836,
         0.004047702706499111,
         -0.18421274326086778,
         0.18623659461411723,
         -0.1882604459673667,
         0.1902842973206163,
         -0.19230814867386584,
         0.1943320000271154,
         -0.19635585138036496,
         0.1983797027336145,
         -0.2004035540868641,
         0.004047702706499113,
         -0.005354607371259847,
         0.00607155405974865,
         -0.006399979921882598,
         0.006399979921882584,
         -0.006071554059748657,
         0.005354607371259812,
         -0.0040477027064991095,
         0.1923081486738659,
         -0.1923081486738658,
         0.19230814867386578,
         -0.19230814867386586,
         0.19230814867386584,
         -0.19230814867386584,
         0.19230814867386578,
         -0.19230814867386578,
         0.19230814867386586,
         -0.0040477027064991095,
         0.005354607371259826,
         -0.006071554059748643,
         0.006399979921882598,
         -0.006399979921882612,
         0.006071554059748657,
         -0.005354607371259867,
         0.004047702706499096,
         -0.2004035540868641,
         0.19837970273361444,
         -0.196355851380365,
         0.19433200002711537,
         -0.1923081486738658,
         0.19028429732061625,
         -0.18826044596736666,
         0.18623659461411715,
         -0.1842127432608678,
         0.0040477027064991025,
         -0.005354607371259885,
         0.006071554059748671,
         -0.006399979921882591,
         0.0063999799218825565,
         -0.006071554059748616,
         0.005354607371259812,
         -0.004047702706499096},
        {-0.1478534467209445,
         0.14785344672094478,
         -0.11452678736591648,
         0.06612207151513516,
         0.14688729385344565,
         0.027920473507880066,
         -0.13615389314876578,
         0.17725800910439038,
         -0.1490953244268909,
         -0.1468872938534457,
         0.07127257580021887,
         0.04587801946947391,
         -0.15778099893161476,
         0.21527820732464742,
         0.09289968158306784,
         -0.09478489699370901,
         0.0405353565277324,
         0.06839091347120171,
         -0.23161486724458483,
         0.2090963495963678,
         -0.20909634959636783,
         0.16196533594789927,
         -0.09351073030890782,
         -0.045319906344099777,
         -0.04835967868702912,
         0.1035813175516962,
         -0.1199984171994953,
         0.0962753411304409,
         -0.03948551230272268,
         0.04994566138208152,
         -0.05297537378117532,
         0.0499456613820815,
         -0.039485512302722674,
         0.09627534113044088,
         -0.11999841719949535,
         0.10358131755169621,
         -0.04835967868702911,
         -0.04531990634409977,
         -0.0935107303089078,
         0.16196533594789927,
         -0.20909634959636783,
         0.20909634959636778,
         -0.23161486724458477,
         0.0683909134712017,
         0.04053535652773241,
         -0.09478489699370898,
         0.09289968158306783,
         0.2152782073246473,
         -0.1577809989316148,
         0.045878019469473896,
         0.07127257580021884,
         -0.14688729385344568,
         -0.1490953244268909,
         0.17725800910439046,
         -0.13615389314876578,
         0.02792047350788006,
         0.1468872938534456,
         0.06612207151513519,
         -0.11452678736591687,
         0.14785344672094464,
         -0.14785344672094464},
        {-0.044146144817646116,
         0.04414614481764612,
         -0.034195456735600885,
         0.019742756151361375,
         0.16859455182303945,
         -0.09351073030890787,
         0.03823764350001781,
         -0.00285825767194174,
         -0.012310020917631167,
         -0.1685945518230394,
         0.17906165720683812,
         -0.1536538090769125,
         0.11067074373563641,
         -0.0604590229087944,
         0.1066285569712195,
         -0.16494332206054335,
         0.20534460957301376,
         -0.22905357473183383,
         0.2363860461090775,
         0.062432076727601905,
         -0.06243207672760189,
         0.048359678687029145,
         -0.027920473507880086,
         -0.22958225290920645,
         0.16196533594789927,
         -0.1057150536064593,
         0.060791594524686736,
         -0.027038097015456286,
         0.1322441430302703,
         -0.1672770796770943,
         0.17742413606513358,
         -0.16727707967709432,
         0.1322441430302703,
         -0.027038097015456296,
         0.060791594524686736,
         -0.10571505360645933,
         0.16196533594789925,
         -0.22958225290920647,
         -0.027920473507880097,
         0.04835967868702912,
         -0.06243207672760188,
         0.06243207672760188,
         0.23638604610907746,
         -0.2290535747318338,
         0.20534460957301376,
         -0.16494332206054335,
         0.1066285569712195,
         -0.06045902290879439,
         0.11067074373563641,
         -0.15365380907691253,
         0.17906165720683814,
         -0.1685945518230393,
         -0.012310020917631163,
         -0.002858257671941748,
         0.038237643500017834,
         -0.09351073030890786,
         0.1685945518230394,
         0.019742756151361385,
         -0.03419545673560088,
         0.04414614481764614,
         -0.04414614481764614},
        {0.2439750182371334,
         -0.2439750182371334,
         0.15430334996209205,
         -0.1992047682223989,
         0.15430334996209197,
         -0.17817416127494956,
         0.09759000729485336,
         0.1195228609334394,
         -0.09258200997725521,
         -0.04364357804719848,
         0.15118578920369088,
         -0.09759000729485327,
         -0.03086066999241837,
         0.08728715609439679,
         -0.03086066999241837,
         -0.09759000729485327,
         0.06172133998483679,
         -0.017817416127494958,
         -0.03779644730092277,
         0.0487950036474267,
         0.039840953644479815,
         -0.14085904245475273,
         0.10910894511799622,
         -0.12598815766974236,
         0.11268723396380226,
         0.1380131118684709,
         -0.10690449676496987,
         -0.05039526306789697,
         0.17457431218879396,
         -0.16903085094570325,
         -0.05345224838248487,
         0.1511857892036907,
         -0.05345224838248487,
         -0.16903085094570325,
         0.17457431218879396,
         -0.05039526306789697,
         -0.10690449676496984,
         0.1380131118684709,
         0.11268723396380226,
         -0.1259881576697424,
         0.10910894511799622,
         -0.14085904245475273,
         0.03984095364447982,
         0.048795003647426685,
         -0.03779644730092278,
         -0.017817416127494958,
         0.061721339984836775,
         -0.0975900072948533,
         -0.03086066999241837,
         0.0872871560943968,
         -0.030860669992418377,
         -0.0975900072948533,
         0.1511857892036909,
         -0.043643578047198484,
         -0.09258200997725519,
         0.1195228609334394,
         0.09759000729485336,
         -0.17817416127494945,
         0.154303349962092,
         -0.19920476822239896,
         0.1543033499620919,
         -0.24397501823713344,
         0.24397501823713352},
        {0.17407765595569796,
         -0.21320071635561033,
         0.19738550848793077,
         -0.14712247158412492,
         0.08058229640253803,
         -0.18349396085439346,
         0.08206099398622183,
         0.03798685881987933,
         -0.12406456138646275,
         0.1535220621572794,
         -0.12012499502607447,
         0.11009637651263608,
         0.0635641726163728,
         -0.10744306187005076,
         0.06579516949597689,
         0.016988239714587457,
         -0.09609999602085956,
         0.12483755678647186,
         -0.09534625892455918,
         0.02080625946441197,
         0.04652421051992352,
         -0.07207499701564457,
         0.04652421051992352,
         0.020806259464411975,
         -0.0953462589245592,
         0.05096471914376256,
         -0.039232659089099974,
         0.006935419821470636,
         0.026860765467512673,
         -0.043863446330651305,
         0.02594996480538409,
         0.0449466574975495,
         -0.12974982402692045,
         0.05802588531856594,
         0.026860765467512687,
         -0.08772689266130249,
         0.10855649121315486,
         -0.08494119857293757,
         0.1271283452327457,
         0.07339758434175737,
         -0.12406456138646285,
         0.0759737176397586,
         0.01961632954454992,
         -0.11096671714353049,
         0.14414999403128947,
         -0.165144564768954,
         0.03603749850782237,
         0.08058229640253796,
         -0.1248375567864716,
         0.08058229640253796,
         0.03603749850782236,
         -0.165144564768954,
         0.14414999403128942,
         -0.11096671714353049,
         0.01961632954454992,
         0.07597371763975862,
         -0.12406456138646288,
         0.07339758434175737,
         0.12712834523274566,
         -0.08494119857293754,
         0.10855649121315489,
         -0.08772689266130247,
         0.026860765467512687,
         0.05802588531856594,
         -0.12974982402692045,
         0.04494665749754949,
         0.02594996480538409,
         -0.0438634463306513,
         0.026860765467512673,
         0.0069354198214706345,
         -0.03923265908909998,
         0.05096471914376256,
         -0.09534625892455921,
         0.020806259464411964,
         0.04652421051992352,
         -0.07207499701564457,
         0.04652421051992353,
         0.020806259464411975,
         -0.09534625892455921,
         0.12483755678647183,
         -0.09609999602085956,
         0.016988239714587447,
         0.06579516949597687,
         -0.10744306187005076,
         0.0635641726163728,
         0.11009637651263608,
         -0.12012499502607447,
         0.15352206215727934,
         -0.1240645613864627,
         0.03798685881987934,
         0.08206099398622184,
         -0.18349396085439348,
         0.08058229640253796,
         -0.1471224715841249,
         0.1973855084879308,
         -0.2132007163556105,
         0.1740776559556979},
        {0.12167834619164217,
         -0.13604052673713216,
         0.1259490540368821,
         -0.10283697199219563,
         0.07271672025237258,
         -0.03982858799001723,
         -0.18514357377305307,
         0.054962499342462695,
         0.042607640023714574,
         -0.10750571265313481,
         0.1395996962512028,
         -0.13854047986082502,
         0.10298142933878648,
         0.16033903823490225,
         -0.14094794188409346,
         0.08045686067661457,
         -0.003438312416941195,
         -0.07379859731167886,
         0.13499261008565633,
         -0.1557905784424164,
         -0.08570482097140736,
         0.11592519845904385,
         -0.11795289588661427,
         0.09290358033959119,
         -0.04106646330245828,
         -0.037449089054259185,
         0.14259243693118165,
         -0.172079167431349,
         0.192390357944032,
         -0.1781188603870206,
         0.14543344050474516,
         -0.10283697199219564,
         0.056326129305652554,
         0.10992499868492546,
         -0.034358668276295384,
         -0.022380111315581017,
         0.06025630238224778,
         -0.07919423704312496,
         0.07899382804156768,
         -0.05888330388079055,
         -0.0026260544855899286,
         0.003438312416941202,
         -0.00384415014608107,
         0.003970221198958055,
         -0.0038441501460810723,
         0.003438312416941198,
         -0.0026260544855899177,
         -0.05888330388079056,
         0.07899382804156767,
         -0.07919423704312496,
         0.0602563023822478,
         -0.02238011131558103,
         -0.03435866827629537,
         0.10992499868492542,
         0.05632612930565257,
         -0.10283697199219564,
         0.1454334405047452,
         -0.17811886038702054,
         0.19239035794403206,
         -0.17207916743134896,
         0.14259243693118168,
         -0.037449089054259206,
         -0.04106646330245827,
         0.0929035803395912,
         -0.11795289588661426,
         0.11592519845904387,
         -0.08570482097140736,
         -0.15579057844241637,
         0.1349926100856563,
         -0.07379859731167886,
         -0.00343831241694119,
         0.0804568606766146,
         -0.14094794188409335,
         0.1603390382349023,
         0.10298142933878651,
         -0.13854047986082496,
         0.13959969625120283,
         -0.10750571265313479,
         0.04260764002371458,
         0.05496249934246268,
         -0.1851435737730531,
         -0.03982858799001725,
         0.07271672025237255,
         -0.10283697199219559,
         0.12594905403688217,
         -0.13604052673713216,
         0.12167834619164206},
        {-0.0030323065283246464,
         0.0033902217629743665,
         -0.0031387354508479997,
         0.0025627667640540407,
         -0.0018121497574621111,
         0.0009925552997395158,
         -0.10082807909995373,
         0.08994573240093669,
         -0.07823743955496937,
         0.06569275165463426,
         -0.05228907179128454,
         0.03796651254530702,
         -0.022493028307714533,
         0.08731967791534664,
         -0.11604745155311062,
         0.13166707021722485,
         -0.13797027598487482,
         0.1355112203633059,
         -0.12292407638699301,
         0.09519784137211644,
         -0.04667433112609689,
         0.0816527309283123,
         -0.11662050362260065,
         0.15203603686664832,
         -0.18801750617659216,
         0.22460947794084302,
         -0.2618325530160754,
         0.004288329017628193,
         -0.004794497596650783,
         0.004438842243290459,
         -0.0036242995149242466,
         0.0025627667640540364,
         -0.0014036851662969207,
         0.17989146480187318,
         -0.1573067317065784,
         0.13422983698127885,
         -0.1106444481039829,
         0.08651523898002629,
         -0.0617485642282415,
         0.035981401945827995,
         -0.10537653889243954,
         0.13797027598487502,
         -0.1542554579882935,
         0.15931435196006888,
         -0.15425545798829346,
         0.13797027598487505,
         -0.10537653889243957,
         0.03598140194582801,
         -0.061748564228241515,
         0.08651523898002629,
         -0.11064444810398295,
         0.13422983698127883,
         -0.15730673170657844,
         0.1798914648018732,
         -0.0014036851662969224,
         0.00256276676405404,
         -0.0036242995149242258,
         0.004438842243290438,
         -0.004794497596650779,
         0.004288329017628201,
         -0.26183255301607544,
         0.22460947794084318,
         -0.18801750617659216,
         0.15203603686664832,
         -0.11662050362260065,
         0.0816527309283123,
         -0.04667433112609689,
         0.09519784137211641,
         -0.12292407638699303,
         0.13551122036330582,
         -0.1379702759848748,
         0.1316670702172248,
         -0.11604745155311058,
         0.08731967791534662,
         -0.022493028307714526,
         0.037966512545307016,
         -0.05228907179128453,
         0.0656927516546342,
         -0.0782374395549694,
         0.08994573240093667,
         -0.10082807909995371,
         0.0009925552997395205,
         -0.0018121497574621146,
         0.00256276676405404,
         -0.003138735450847991,
         0.0033902217629743388,
         -0.0030323065283238953},
        {0.1740776559556981,
         -0.224733287487747,
         0.174077655955698,
         -0.1846372364689992,
         0.08703882797784897,
         0.087038827977849,
         -0.1846372364689992,
         0.14447139909926607,
         0.03405223533019976,
         -0.12434118282549847,
         0.034052235330199764,
         0.14447139909926607,
         -0.08792249355666618,
         -0.09080596088053261,
         0.0621705914127492,
         0.062170591412749214,
         -0.09080596088053253,
         -0.08792249355666622,
         0.03730235484764949,
         0.08703882797784877,
         0.012434118282549783,
         -0.07460470969529887,
         0.012434118282549783,
         0.0870388279778488,
         0.03730235484764949,
         -0.04815713303308867,
         -0.04973647313019933,
         0.03405223533019968,
         0.03405223533019969,
         -0.049736473130199375,
         -0.04815713303308869,
         0.03730235484764952,
         0.00879224935566663,
         -0.03210475535539247,
         0.00879224935566663,
         0.03730235484764952,
         -0.10660035817780522,
         0.05025189076296063,
         0.05025189076296063,
         -0.10660035817780525,
         0.12921914767618445,
         0.030457245193658698,
         -0.11121413488021765,
         0.030457245193658698,
         0.12921914767618448,
         -0.10768262306348692,
         -0.11121413488021753,
         0.07614311298414649,
         0.0761431129841465,
         -0.11121413488021742,
         -0.10768262306348692,
         0.06091449038731717,
         0.14213381090374022,
         0.02030483012910566,
         -0.12182898077463424,
         0.02030483012910566,
         0.14213381090374022,
         0.0609144903873172,
         -0.10768262306348692,
         -0.11121413488021742,
         0.0761431129841465,
         0.07614311298414649,
         -0.1112141348802175,
         -0.10768262306348689,
         0.12921914767618442,
         0.030457245193658705,
         -0.11121413488021763,
         0.03045724519365871,
         0.12921914767618442,
         -0.10660035817780525,
         0.05025189076296062,
         0.05025189076296061,
         -0.10660035817780525,
         0.03730235484764952,
         0.00879224935566663,
         -0.03210475535539248,
         0.00879224935566663,
         0.037302354847649516,
         -0.04815713303308869,
         -0.04973647313019938,
         0.03405223533019968,
         0.03405223533019968,
         -0.04973647313019935,
         -0.04815713303308869,
         0.03730235484764949,
         0.08703882797784881,
         0.012434118282549781,
         -0.07460470969529893,
         0.012434118282549774,
         0.08703882797784876,
         0.037302354847649474,
         -0.08792249355666618,
         -0.0908059608805325,
         0.0621705914127492,
         0.0621705914127492,
         -0.09080596088053261,
         -0.08792249355666616,
         0.14447139909926607,
         0.034052235330199764,
         -0.12434118282549853,
         0.03405223533019976,
         0.14447139909926607,
         -0.18463723646899932,
         0.08703882797784902,
         0.08703882797784902,
         -0.18463723646899932,
         0.1740776559556982,
         -0.22473328748774726,
         0.1740776559556982},
        {-0.07672571258440614,
         0.10850654331960698,
         -0.10850654331960718,
         0.076725712584406,
         0.13654794038432908,
         -0.09405548018386393,
         -0.005473927012242044,
         0.10404945785967001,
         -0.14361474976991853,
         -0.1437747978936205,
         -0.007495483256854575,
         0.11124350682572785,
         -0.10576957981348581,
         -0.007495483256854564,
         0.16312805244400333,
         0.09482172578900186,
         0.10850654331960688,
         -0.10029565280124375,
         -0.010947854024484074,
         0.11671743383796988,
         -0.10850654331960682,
         -0.12219136085021207,
         -0.12241432161315015,
         -0.013684817530605117,
         0.10404945785966997,
         -0.09405548018386388,
         -0.013684817530605135,
         0.15774836854109744,
         0.09482172578900185,
         -0.05737245803402306,
         -0.02120042815676838,
         0.09607896713478875,
         -0.12219136085021214,
         0.13289283244311803,
         -0.18793884598323274,
         0.18793884598323277,
         -0.132892832443118,
         -0.11739163090371592,
         0.07742161490438632,
         0.012240072903245525,
         -0.09976882835310408,
         0.13319349707392747,
         0.046844415824199355,
         0.01224007290324554,
         -0.048767053504116135,
         0.039828168124629054,
         0.012240072903245547,
         -0.07844814816462242,
         0.016760410086538315,
         -0.010056246051922997,
         0.013408328069230644,
         -0.010056246051922997,
         0.01676041008653832,
         -0.07844814816462242,
         0.012240072903245549,
         0.03982816812462905,
         -0.04876705350411614,
         0.012240072903245575,
         0.04684441582419935,
         0.1331934970739275,
         -0.09976882835310402,
         0.012240072903245532,
         0.0774216149043863,
         -0.1173916309037159,
         -0.13289283244311803,
         0.1879388459832327,
         -0.18793884598323274,
         0.13289283244311806,
         -0.12219136085021208,
         0.09607896713478875,
         -0.021200428156768376,
         -0.05737245803402307,
         0.09482172578900186,
         0.15774836854109744,
         -0.013684817530605143,
         -0.09405548018386387,
         0.10404945785966996,
         -0.013684817530605162,
         -0.12241432161315019,
         -0.12219136085021207,
         -0.10850654331960685,
         0.1167174338379699,
         -0.010947854024484107,
         -0.10029565280124376,
         0.10850654331960688,
         0.09482172578900187,
         0.16312805244400336,
         -0.007495483256854575,
         -0.10576957981348582,
         0.11124350682572784,
         -0.007495483256854553,
         -0.1437747978936205,
         -0.1436147497699185,
         0.10404945785966999,
         -0.00547392701224204,
         -0.09405548018386388,
         0.13654794038432908,
         0.07672571258440604,
         -0.108506543319607,
         0.10850654331960703,
         -0.07672571258440598},
        {-0.008096047232822201,
         0.01144953979827007,
         -0.011449539798270014,
         0.008096047232822047,
         0.04826713857419074,
         -0.057808089954286,
         0.05187604995023041,
         -0.03690418588573378,
         0.018704553933898055,
         -0.10789686121809391,
         0.07103420688001483,
         -0.01448848517684513,
         -0.037387564773385236,
         0.07103420688001483,
         -0.07551267228680583,
         0.14113966467384603,
         0.01144953979827001,
         -0.08926361472361564,
         0.10375209990046064,
         -0.06636453512707555,
         -0.011449539798270125,
         0.1182405850773059,
         -0.1822105235903683,
         0.129690124875576,
         -0.03690418588573379,
         -0.05780808995428598,
         0.129690124875576,
         -0.15264793895007558,
         0.1411396646738461,
         -0.19150558073772184,
         0.2009150775242664,
         -0.1753134862720778,
         0.11824058507730595,
         0.014022765147725207,
         -0.019831184653885697,
         0.019831184653885694,
         -0.014022765147725151,
         -0.08809741827740711,
         0.115240053639481,
         -0.1159983740928897,
         0.09654303344251415,
         -0.06165583873889288,
         0.1563636519009285,
         -0.11599837409288978,
         0.037682362367157315,
         0.04703087246564077,
         -0.11599837409288981,
         0.14314286213167138,
         -0.1588373153114964,
         0.09530238918689786,
         -0.127069852249197,
         0.09530238918689786,
         -0.15883731531149636,
         0.14314286213167138,
         -0.11599837409288982,
         0.047030872465640756,
         0.037682362367157315,
         -0.11599837409288978,
         0.1563636519009285,
         -0.06165583873889289,
         0.09654303344251412,
         -0.11599837409288978,
         0.11524005363948102,
         -0.08809741827740712,
         -0.014022765147725144,
         0.01983118465388573,
         -0.019831184653885676,
         0.014022765147725168,
         0.11824058507730591,
         -0.1753134862720778,
         0.2009150775242664,
         -0.1915055807377218,
         0.1411396646738461,
         -0.15264793895007564,
         0.12969012487557605,
         -0.05780808995428596,
         -0.03690418588573379,
         0.129690124875576,
         -0.18221052359036835,
         0.1182405850773059,
         -0.01144953979827011,
         -0.06636453512707555,
         0.10375209990046065,
         -0.08926361472361564,
         0.011449539798270007,
         0.1411396646738461,
         -0.07551267228680585,
         0.07103420688001484,
         -0.03738756477338523,
         -0.014488485176845119,
         0.07103420688001486,
         -0.10789686121809396,
         0.01870455393389803,
         -0.03690418588573375,
         0.0518760499502304,
         -0.05780808995428596,
         0.04826713857419078,
         0.008096047232822036,
         -0.011449539798270068,
         0.011449539798270078,
         -0.008096047232822024},
        {0.000572295421297303,
         -0.0009048785128926674,
         0.0010815366865812503,
         -0.0010815366865812453,
         0.0009048785128926378,
         -0.0005722954212973573,
         -0.02530313241397895,
         0.03731485288835203,
         -0.04383501780007881,
         0.045400035990305655,
         -0.04230549394971155,
         0.03475546995788648,
         -0.02274374948351339,
         0.07950351544819648,
         -0.07418338346149188,
         0.049569209484100395,
         -0.01645939243592209,
         -0.01870732422561221,
         0.05051702074811631,
         -0.07292954701428592,
         0.07618617602414075,
         -0.12847439892161505,
         0.031102876118834437,
         0.03757759135894947,
         -0.07805068142200737,
         0.09080007198061132,
         -0.07630944094503142,
         0.035062466225539705,
         0.03245717426759354,
         -0.12576580262409676,
         0.14363874467857846,
         -0.1348674129584186,
         0.09093319531510188,
         -0.03107663752406998,
         -0.033128709105647046,
         0.09179842466436688,
         -0.13372282211582384,
         0.1406104419561509,
         -0.09403363145971728,
         0.1405548248162629,
         -0.1674027657603712,
         0.17583358330767115,
         -0.16621800168035128,
         0.13857233532301078,
         -0.09205114196646519,
         -0.0009912447466260538,
         0.0015672955590074172,
         -0.001873276491408423,
         0.0018732764914084373,
         -0.0015672955590074612,
         0.0009912447466260735,
         0.0548626378574432,
         -0.08172166136486742,
         0.09699204380510101,
         -0.10151756665526045,
         0.09562399608404965,
         -0.07943247967967798,
         0.05257345617225375,
         -0.12779724984723545,
         0.12037314303677743,
         -0.08152659361844174,
         0.028254646761486684,
         0.029172361071707044,
         -0.08191353594665865,
         0.11986126645068433,
         -0.12644295169847633,
         0.1556896914723372,
         -0.03892242286808433,
         -0.04448276899209639,
         0.09452588410820442,
         -0.11120692248024079,
         0.09452588410820442,
         -0.0444827689920964,
         -0.03892242286808434,
         0.15568969147233722,
         -0.12644295169847633,
         0.1198612664506843,
         -0.08191353594665864,
         0.029172361071707037,
         0.028254646761486688,
         -0.08152659361844171,
         0.12037314303677744,
         -0.1277972498472355,
         0.052573456172253764,
         -0.07943247967967801,
         0.09562399608404965,
         -0.10151756665526047,
         0.09699204380510101,
         -0.08172166136486743,
         0.05486263785744319,
         0.0009912447466260761,
         -0.001567295559007429,
         0.0018732764914084273,
         -0.0018732764914084269,
         0.0015672955590074107,
         -0.000991244746626048,
         -0.09205114196646516,
         0.1385723353230108,
         -0.16621800168035125,
         0.17583358330767115,
         -0.16740276576037116,
         0.1405548248162629,
         -0.09403363145971728,
         0.14061044195615094,
         -0.13372282211582387,
         0.09179842466436693,
         -0.03312870910564705,
         -0.031076637524069993,
         0.0909331953151019,
         -0.13486741295841861,
         0.14363874467857848,
         -0.12576580262409678,
         0.03245717426759355,
         0.035062466225539705,
         -0.0763094409450314,
         0.09080007198061132,
         -0.07805068142200743,
         0.03757759135894949,
         0.031102876118834444,
         -0.12847439892161497,
         0.0761861760241408,
         -0.07292954701428592,
         0.05051702074811631,
         -0.018707324225612207,
         -0.01645939243592209,
         0.0495692094841004,
         -0.07418338346149186,
         0.07950351544819645,
         -0.02274374948351341,
         0.03475546995788647,
         -0.04230549394971156,
         0.045400035990305655,
         -0.04383501780007881,
         0.03731485288835205,
         -0.025303132413978944,
         -0.0005722954212973188,
         0.0009048785128926626,
         -0.001081536686581244,
         0.0010815366865812776,
         -0.0009048785128926301,
         0.0005722954212973891},
        {0.10429770312912395,
         -0.16490914830605152,
         0.18698939800169154,
         -0.16490914830605133,
         0.10429770312912401,
         -0.142815511749496,
         0.13548669069928373,
         -0.05397918963594132,
         -0.05397918963594132,
         0.1354866906992837,
         -0.142815511749496,
         0.13686222536283968,
         -0.04562074178761322,
         -0.05997993733997372,
         0.10345811776827145,
         -0.05997993733997372,
         -0.04562074178761321,
         0.1368622253628397,
         -0.09855206599818045,
         -0.03724917968897284,
         0.0844731994270117,
         -0.04006915671464814,
         -0.04006915671464814,
         0.08447319942701169,
         -0.03724917968897284,
         -0.09855206599818046,
         0.0482804549585267,
         0.07242068243779008,
         -0.037934643181699604,
         -0.031037435330481443,
         0.06207487066096281,
         -0.03103743533048145,
         -0.037934643181699604,
         0.07242068243779007,
         0.048280454958526696,
         -0.05397918963594129,
         -0.02040221596421368,
         0.04626787683080675,
         -0.021946780992822375,
         -0.021946780992822375,
         0.04626787683080676,
         -0.020402215964213682,
         -0.0539791896359413,
         0.035337674637010985,
         -0.011779224879003656,
         -0.015486753228285513,
         0.026712771143098734,
         -0.015486753228285513,
         -0.01177922487900365,
         0.03533767463701098,
         -0.08245457415302562,
         0.07822327734684299,
         -0.031164899666948558,
         -0.031164899666948565,
         0.078223277346843,
         -0.08245457415302564,
         0.12241329578528223,
         -0.04080443192842741,
         -0.053647686871343706,
         0.09253575366161365,
         -0.053647686871343706,
         -0.04080443192842741,
         0.12241329578528226,
         -0.12070113739631685,
         -0.04562074178761322,
         0.10345811776827146,
         -0.04907449418725114,
         -0.04907449418725114,
         0.10345811776827146,
         -0.04562074178761322,
         -0.12070113739631685,
         0.07884165279854431,
         0.1182624791978165,
         -0.06194701291314203,
         -0.05068391965620703,
         0.10136783931241394,
         -0.05068391965620703,
         -0.061947012913142044,
         0.1182624791978165,
         0.07884165279854433,
         -0.12070113739631683,
         -0.04562074178761321,
         0.10345811776827146,
         -0.049074494187251155,
         -0.049074494187251155,
         0.10345811776827146,
         -0.04562074178761322,
         -0.12070113739631683,
         0.12241329578528223,
         -0.04080443192842741,
         -0.05364768687134371,
         0.09253575366161364,
         -0.05364768687134371,
         -0.040804431928427407,
         0.12241329578528223,
         -0.08245457415302562,
         0.078223277346843,
         -0.03116489966694855,
         -0.031164899666948558,
         0.07822327734684299,
         -0.08245457415302562,
         0.035337674637010964,
         -0.011779224879003652,
         -0.015486753228285513,
         0.026712771143098737,
         -0.015486753228285516,
         -0.011779224879003656,
         0.035337674637010964,
         -0.0539791896359413,
         -0.02040221596421369,
         0.046267876830806756,
         -0.021946780992822372,
         -0.021946780992822375,
         0.046267876830806756,
         -0.02040221596421369,
         -0.0539791896359413,
         0.048280454958526696,
         0.07242068243779003,
         -0.037934643181699604,
         -0.031037435330481457,
         0.06207487066096282,
         -0.031037435330481457,
         -0.0379346431816996,
         0.07242068243779004,
         0.04828045495852671,
         -0.09855206599818045,
         -0.03724917968897284,
         0.08447319942701169,
         -0.04006915671464815,
         -0.04006915671464815,
         0.08447319942701169,
         -0.03724917968897283,
         -0.09855206599818041,
         0.1368622253628397,
         -0.04562074178761322,
         -0.05997993733997369,
         0.10345811776827145,
         -0.059979937339973706,
         -0.04562074178761322,
         0.1368622253628397,
         -0.14281551174949608,
         0.13548669069928365,
         -0.05397918963594133,
         -0.05397918963594133,
         0.13548669069928368,
         -0.14281551174949608,
         0.10429770312912395,
         -0.16490914830605136,
         0.1869893980016914,
         -0.16490914830605136,
         0.10429770312912397},
        {0.0502486318540446,
         -0.0794500629830349,
         0.09496098829074281,
         -0.09496098829074281,
         0.07945006298303489,
         -0.05024863185404443,
         -0.11208574705779435,
         0.11194894228568908,
         -0.06665701983601999,
         -0.0005170734359386673,
         0.06763809770110117,
         -0.11276977091831988,
         0.11263296614621487,
         0.1447477747811885,
         -0.054206863585377164,
         -0.0421797750307778,
         0.09888661555452744,
         -0.09848609219329614,
         0.0410398655609401,
         0.05588237301555379,
         -0.1465209672898249,
         -0.11746216039542279,
         -0.05981693441318253,
         0.11000273826615342,
         -0.07556309616922269,
         -0.0010341468718773165,
         0.07732114585141413,
         -0.11083005576365529,
         0.0590930316028684,
         0.12035777163667925,
         0.13132668771407452,
         -0.0487191080036771,
         -0.03902498553320343,
         0.09045352969072168,
         -0.08972227742487437,
         0.03694380509939067,
         0.05177815570441162,
         -0.13456407950000554,
         -0.0859734981739391,
         0.08544365556989406,
         -0.050112426253427704,
         -0.0020026168061566684,
         0.05391212448621987,
         -0.08862271119416347,
         0.08809286859011868,
         -0.0870331833820289,
         0.1376115457511638,
         -0.16447725645651987,
         0.1644772564565199,
         -0.13761154575116386,
         0.08703318338202895,
         0.09988545416794195,
         -0.09957954939786832,
         0.05896172397309444,
         0.0011562113521182142,
         -0.06115548077063633,
         0.10141497801830904,
         -0.10110907324823577,
         -0.058007177387397316,
         0.021103823599349543,
         0.01791787018698255,
         -0.04061556121616337,
         0.03996150930610928,
         -0.016056405817603408,
         -0.023839919041452266,
         0.060902788628653795,
         -0.001773192508636362,
         0.0004432981271590545,
         0.0005066264310389645,
         -0.0010765811659577788,
         0.0012665660775973732,
         -0.0010765811659577754,
         0.0005066264310389593,
         0.00044329812715906275,
         -0.0017731925086363655,
         0.06090278862865379,
         -0.023839919041452284,
         -0.0160564058176034,
         0.03996150930610927,
         -0.04061556121616337,
         0.017917870186982564,
         0.021103823599349536,
         -0.05800717738739732,
         -0.10110907324823576,
         0.10141497801830905,
         -0.06115548077063633,
         0.001156211352118193,
         0.05896172397309444,
         -0.09957954939786834,
         0.09988545416794195,
         0.08703318338202892,
         -0.13761154575116388,
         0.1644772564565199,
         -0.16447725645651992,
         0.1376115457511638,
         -0.08703318338202892,
         0.0880928685901187,
         -0.08862271119416346,
         0.053912124486219896,
         -0.002002616806156668,
         -0.0501124262534277,
         0.08544365556989404,
         -0.08597349817393912,
         -0.13456407950000557,
         0.05177815570441165,
         0.03694380509939068,
         -0.08972227742487437,
         0.09045352969072173,
         -0.03902498553320345,
         -0.0487191080036771,
         0.13132668771407455,
         0.12035777163667931,
         0.0590930316028684,
         -0.11083005576365529,
         0.07732114585141411,
         -0.0010341468718773118,
         -0.07556309616922272,
         0.11000273826615345,
         -0.05981693441318256,
         -0.1174621603954228,
         -0.1465209672898249,
         0.05588237301555379,
         0.041039865560940095,
         -0.09848609219329608,
         0.09888661555452748,
         -0.04217977503077781,
         -0.054206863585377144,
         0.1447477747811885,
         0.11263296614621496,
         -0.11276977091831984,
         0.06763809770110119,
         -0.00051707343593868,
         -0.06665701983601997,
         0.11194894228568907,
         -0.11208574705779438,
         -0.05024863185404445,
         0.07945006298303488,
         -0.09496098829074283,
         0.09496098829074277,
         -0.07945006298303486,
         0.050248631854044455},
        {-0.011743119049574407,
         0.011743119049574303,
         0.13921994769213125,
         -0.1561265921012359,
         0.1157337095929823,
         -0.19527983469762078,
         0.06865905910076528,
         0.08746753300047055,
         -0.1871506512300496,
         0.126218621788175,
         0.06906121290944582,
         -0.12512109991493534,
         0.05370415827786808,
         0.1334464929521815,
         0.011743119049574466,
         -0.01174311904957447,
         -0.15612659210123586,
         0.19121524296383513,
         -0.1561265921012358,
         0.06865905910076527,
         -0.03209453523653034,
         -0.03164387908474805,
         0.08746753300047054,
         0.06906121290944581,
         0.04212879127994061,
         -0.06609414304889978,
         0.02632108049658062,
         0.0537041582778681,
         -0.19527983469762072,
         0.06865905910076525,
         0.08746753300047055,
         -0.18715065123004962,
         0.11573370959298238,
         -0.15612659210123586,
         0.13921994769213128,
         0.08746753300047051,
         -0.03164387908474803,
         -0.03209453523653034,
         0.06865905910076527,
         -0.12512109991493534,
         -0.06609414304889977,
         0.12983255737017813,
         -0.06609414304889978,
         -0.12512109991493534,
         0.06865905910076524,
         -0.03209453523653031,
         -0.031643879084748014,
         0.08746753300047051,
         0.13921994769213128,
         -0.15612659210123592,
         0.11573370959298233,
         -0.18715065123004956,
         0.08746753300047055,
         0.06865905910076525,
         -0.19527983469762075,
         0.053704158277868064,
         0.026321080496580634,
         -0.0660941430488998,
         0.04212879127994062,
         0.06906121290944581,
         0.08746753300047051,
         -0.031643879084747986,
         -0.0320945352365303,
         0.06865905910076527,
         -0.15612659210123583,
         0.19121524296383513,
         -0.15612659210123583,
         -0.011743119049574483,
         0.011743119049574485,
         0.13344649295218164,
         0.0537041582778681,
         -0.1251210999149353,
         0.06906121290944583,
         0.126218621788175,
         -0.18715065123004948,
         0.08746753300047051,
         0.06865905910076525,
         -0.1952798346976207,
         0.1157337095929823,
         -0.15612659210123586,
         0.13921994769213125,
         0.011743119049574459,
         -0.011743119049574475},
        {0.03945153327604953,
         -0.08286338777190524,
         0.043411854495855884,
         0.06597537999991565,
         0.020683500906765545,
         -0.06029986226784534,
         0.0751856552181232,
         -0.17288625392362073,
         0.1522027530168552,
         -0.06397316517820391,
         -0.22326930332439007,
         0.14808364810626673,
         -0.006922612888227807,
         -0.11735041455782151,
         0.1813235797360256,
         0.043411854495855946,
         -0.08286338777190531,
         0.020683500906765493,
         0.01411952161806506,
         0.0206835009067655,
         -0.17288625392362073,
         0.12043416116915838,
         -0.15144169055921294,
         0.1522027530168552,
         0.14808364810626679,
         -0.011527750497331547,
         0.03225462454621216,
         -0.0050859614330485345,
         -0.1173504145578216,
         0.07518565521812319,
         -0.17288625392362075,
         0.15220275301685524,
         -0.06397316517820394,
         -0.060299862267845505,
         0.020683500906765493,
         0.0659753799999158,
         0.1522027530168552,
         -0.15144169055921294,
         0.12043416116915838,
         -0.17288625392362064,
         -0.006922612888227809,
         0.03225462454621212,
         -0.001247095156157539,
         0.03225462454621213,
         -0.006922612888227802,
         -0.17288625392362067,
         0.12043416116915834,
         -0.15144169055921294,
         0.15220275301685518,
         0.06597537999991576,
         0.020683500906765493,
         -0.06029986226784551,
         -0.06397316517820391,
         0.15220275301685524,
         -0.17288625392362073,
         0.0751856552181232,
         -0.1173504145578216,
         -0.005085961433048549,
         0.032254624546212134,
         -0.011527750497331632,
         0.1480836481062668,
         0.1522027530168552,
         -0.15144169055921297,
         0.12043416116915837,
         -0.1728862539236207,
         0.020683500906765497,
         0.01411952161806506,
         0.020683500906765497,
         -0.08286338777190526,
         0.04341185449585587,
         0.18132357973602561,
         -0.11735041455782155,
         -0.006922612888227818,
         0.1480836481062668,
         -0.22326930332439004,
         -0.06397316517820391,
         0.15220275301685524,
         -0.17288625392362078,
         0.0751856552181232,
         -0.060299862267845485,
         0.020683500906765497,
         0.06597537999991573,
         0.043411854495855946,
         -0.08286338777190527,
         0.03945153327604944},
        {-0.044768084625539134,
         0.19728052717483827,
         -0.15251244254929924,
         -0.17820251255229502,
         -0.023365700565293197,
         0.17159045717184218,
         0.13884148941186358,
         0.048207211223969315,
         -0.024841510658676014,
         -0.1513074486539535,
         -0.11905908045448516,
         -0.01978240895737845,
         -0.019578614183053143,
         0.03986162270094172,
         0.11144582595301177,
         -0.1525124425492992,
         0.19728052717483818,
         -0.023365700565293218,
         -0.01615106269172454,
         -0.02336570056529324,
         0.04820721122396929,
         0.14777799977546224,
         -0.1125489224611947,
         -0.024841510658676007,
         -0.019782408957378393,
         -0.1781006151651324,
         -0.009038407750761337,
         0.1418703387298445,
         0.039861622700941714,
         0.13884148941186364,
         0.048207211223969273,
         -0.024841510658676035,
         -0.1513074486539535,
         0.17159045717184218,
         -0.02336570056529321,
         -0.17820251255229524,
         -0.024841510658676024,
         -0.11254892246119473,
         0.14777799977546222,
         0.04820721122396923,
         -0.01957861418305309,
         -0.009038407750761321,
         -0.026190669563506182,
         -0.009038407750761342,
         -0.019578614183053098,
         0.04820721122396922,
         0.14777799977546224,
         -0.11254892246119472,
         -0.024841510658675993,
         -0.17820251255229527,
         -0.02336570056529324,
         0.17159045717184224,
         -0.15130744865395349,
         -0.02484151065867602,
         0.048207211223969273,
         0.13884148941186367,
         0.039861622700941665,
         0.1418703387298445,
         -0.00903840775076133,
         -0.17810061516513226,
         -0.019782408957378404,
         -0.024841510658675986,
         -0.11254892246119472,
         0.14777799977546227,
         0.04820721122396926,
         -0.023365700565293225,
         -0.016151062691724557,
         -0.023365700565293225,
         0.19728052717483818,
         -0.15251244254929922,
         0.11144582595301174,
         0.03986162270094171,
         -0.01957861418305306,
         -0.01978240895737846,
         -0.11905908045448513,
         -0.1513074486539535,
         -0.024841510658676017,
         0.04820721122396928,
         0.1388414894118636,
         0.1715904571718422,
         -0.023365700565293253,
         -0.17820251255229513,
         -0.15251244254929922,
         0.1972805271748382,
         -0.04476808462553907},
        {0.3277873061612292,
         -0.13254232086575612,
         -0.19524498529547235,
         0.04047412885387067,
         0.11276004598485323,
         0.10317679328358648,
         -0.014754477592920142,
         -0.03150001097582934,
         -0.08126003500902391,
         -0.036828252532651165,
         0.009918821761172654,
         0.004835655831747507,
         0.020883995429202978,
         0.04546454532173234,
         -0.008636292789081195,
         -0.1952449852954724,
         -0.13254232086575649,
         0.11276004598485322,
         0.18968501814340014,
         0.11276004598485322,
         -0.031500010975829267,
         -0.13999693998027365,
         -0.14175627017501213,
         -0.08126003500902385,
         0.004835655831747513,
         0.04849829865259835,
         0.11721829258862573,
         0.09088651833732173,
         0.04546454532173233,
         -0.01475447759292015,
         -0.03150001097582932,
         -0.08126003500902393,
         -0.03682825253265118,
         0.1031767932835865,
         0.11276004598485323,
         0.040474128853870646,
         -0.08126003500902383,
         -0.14175627017501213,
         -0.13999693998027365,
         -0.03150001097582927,
         0.020883995429202964,
         0.1172182925886257,
         0.16453491756666008,
         0.11721829258862573,
         0.020883995429202964,
         -0.031500010975829267,
         -0.13999693998027363,
         -0.14175627017501216,
         -0.08126003500902385,
         0.04047412885387062,
         0.11276004598485323,
         0.1031767932835865,
         -0.03682825253265117,
         -0.08126003500902393,
         -0.03150001097582932,
         -0.014754477592920128,
         0.045464545321732344,
         0.09088651833732174,
         0.1172182925886257,
         0.04849829865259836,
         0.004835655831747512,
         -0.08126003500902385,
         -0.14175627017501216,
         -0.13999693998027363,
         -0.031500010975829267,
         0.1127600459848532,
         0.18968501814340005,
         0.1127600459848532,
         -0.13254232086575637,
         -0.1952449852954723,
         -0.008636292789081195,
         0.04546454532173232,
         0.020883995429202953,
         0.004835655831747501,
         0.009918821761172649,
         -0.03682825253265118,
         -0.08126003500902393,
         -0.03150001097582928,
         -0.01475447759292011,
         0.10317679328358649,
         0.11276004598485323,
         0.040474128853870535,
         -0.19524498529547232,
         -0.13254232086575637,
         0.32778730616122903},
        {-0.01029505472570276,
         0.0008650960354894335,
         0.009429958690213257,
         0.003690793260727576,
         -0.005579802050169724,
         -0.004874069393996039,
         -0.014502176071551798,
         0.013241185650208098,
         -0.007661383600038404,
         0.011129562908603228,
         -0.17623093132094814,
         0.19073310739249982,
         -0.20154449020332407,
         0.20779998371793118,
         -0.21892954662653447,
         0.009429958690213213,
         0.0008650960354895435,
         -0.005579802050169712,
         -0.0034612207813771263,
         -0.005579802050169719,
         0.013241185650208162,
         -0.013074033532638226,
         0.02109114361023242,
         -0.007661383600038397,
         0.19073310739249996,
         -0.1924480055371845,
         0.19471065625899853,
         -0.2095463063546238,
         0.2077999837179313,
         -0.014502176071551737,
         0.01324118565020815,
         -0.007661383600038395,
         0.011129562908603221,
         -0.0048740693939961464,
         -0.005579802050169724,
         0.0036907932607275415,
         -0.0076613836000383965,
         0.02109114361023243,
         -0.01307403353263821,
         0.01324118565020814,
         -0.2015444902033241,
         0.1947106562589984,
         -0.20272776633659262,
         0.19471065625899836,
         -0.20154449020332407,
         0.013241185650208126,
         -0.013074033532638203,
         0.021091143610232423,
         -0.007661383600038409,
         0.003690793260727538,
         -0.005579802050169721,
         -0.004874069393996105,
         0.011129562908603237,
         -0.007661383600038403,
         0.013241185650208154,
         -0.014502176071551751,
         0.20779998371793132,
         -0.2095463063546238,
         0.19471065625899853,
         -0.1924480055371844,
         0.1907331073925,
         -0.0076613836000384156,
         0.021091143610232427,
         -0.013074033532638238,
         0.013241185650208102,
         -0.005579802050169717,
         -0.0034612207813771254,
         -0.005579802050169717,
         0.0008650960354895376,
         0.009429958690213215,
         -0.21892954662653444,
         0.20779998371793124,
         -0.20154449020332407,
         0.1907331073924999,
         -0.17623093132094814,
         0.01112956290860323,
         -0.007661383600038402,
         0.01324118565020814,
         -0.014502176071551746,
         -0.004874069393996122,
         -0.00557980205016972,
         0.0036907932607275346,
         0.009429958690213201,
         0.0008650960354895376,
         -0.010295054725702742},
        {0.2378353560042255,
         -0.20597146021777524,
         0.11009637651263612,
         -0.14564381625088388,
         -0.04204374825912613,
         0.13762047064079513,
         -0.11677484162422846,
         0.05096471914376258,
         0.09009374626955595,
         -0.031456107575038944,
         -0.0612940235943595,
         0.0913717355809759,
         -0.0441367414752375,
         -0.03538812102191872,
         0.038592533374226266,
         0.012434118282549873,
         -0.05560706744010878,
         0.02359208068127914,
         0.005560706744010887,
         -0.02030483012910574,
         0.0055607067440108845,
         0.02359208068127914,
         -0.14564381625088388,
         -0.04204374825912613,
         0.13762047064079516,
         -0.11677484162422849,
         0.08322503785764794,
         0.147122471584125,
         -0.05136760856862809,
         -0.10009272139219579,
         0.14920941939059812,
         -0.10811249552346704,
         -0.08668283945955961,
         0.09453201464818463,
         0.030457245193658663,
         -0.13620894132079878,
         0.09436832272511657,
         0.02224282697604355,
         -0.08121932051642303,
         0.02224282697604355,
         0.09436832272511658,
         -0.05560706744010879,
         0.012434118282549873,
         0.038592533374226266,
         -0.03538812102191872,
         -0.0441367414752375,
         0.05096471914376257,
         0.09009374626955592,
         -0.031456107575038944,
         -0.0612940235943595,
         0.0913717355809759,
         -0.10811249552346704,
         -0.08668283945955958,
         0.09453201464818463,
         0.03045724519365867,
         -0.13620894132079875,
         0.1415524840876749,
         0.033364240464065324,
         -0.12182898077463453,
         0.033364240464065324,
         0.1415524840876749,
         -0.13620894132079875,
         0.030457245193658663,
         0.09453201464818466,
         -0.08668283945955958,
         -0.10811249552346704,
         0.0913717355809759,
         -0.06129402359435949,
         -0.031456107575038944,
         0.09009374626955592,
         0.05096471914376258,
         -0.0441367414752375,
         -0.0353881210219187,
         0.038592533374226266,
         0.01243411828254987,
         -0.05560706744010881,
         0.09436832272511658,
         0.02224282697604355,
         -0.08121932051642307,
         0.02224282697604355,
         0.09436832272511658,
         -0.13620894132079878,
         0.030457245193658656,
         0.09453201464818463,
         -0.08668283945955962,
         -0.10811249552346706,
         0.14920941939059823,
         -0.10009272139219579,
         -0.051367608568628084,
         0.14712247158412498,
         0.08322503785764794,
         -0.11677484162422844,
         0.13762047064079508,
         -0.0420437482591261,
         -0.14564381625088382,
         0.023592080681279125,
         0.005560706744010887,
         -0.020304830129105746,
         0.005560706744010888,
         0.02359208068127913,
         -0.05560706744010879,
         0.012434118282549875,
         0.03859253337422628,
         -0.035388121021918725,
         -0.0441367414752375,
         0.0913717355809759,
         -0.06129402359435949,
         -0.03145610757503896,
         0.0900937462695559,
         0.05096471914376258,
         -0.11677484162422846,
         0.1376204706407951,
         -0.04204374825912611,
         -0.14564381625088388,
         0.11009637651263604,
         -0.205971460217775,
         0.23783535600422553},
        {0.18006963581926694,
         -0.1559448790696972,
         0.10208988751108894,
         -0.04812563449977517,
         -0.17643727957381025,
         -0.031184882228949218,
         0.1225051851328664,
         -0.12967002564965105,
         0.0843496940091279,
         0.15279916628553683,
         -0.06125929226753362,
         -0.03536033273255887,
         0.09039084995909817,
         -0.08662424713796323,
         -0.08167458988931123,
         0.06737967822294919,
         -0.021091748140746415,
         -0.028871590776601,
         0.05444526012547387,
         -0.1800696358192667,
         0.1559448790696972,
         -0.10208988751108891,
         0.04812563449977515,
         0.03602101746104141,
         -0.025470705711941367,
         0.016674490989845064,
         -0.009627021861587058,
         0.00430533506067706,
         0.09356488064932317,
         -0.016669020706803334,
         -0.05775265636136216,
         0.09489556807950111,
         -0.08251904726533874,
         -0.14292718245574434,
         0.10587829086113713,
         -0.010545874070373195,
         -0.08662424713796306,
         0.12931251757382564,
         0.10587829086113727,
         -0.12483353044451445,
         0.08252291533957254,
         0.006800632739858873,
         -0.1018577548616541,
         0.11761520437685373,
         0.07277837048418216,
         -0.1497345148967037,
         0.14539088651865564,
         -0.09138027672271004,
         -0.11436162477693965,
         0.03890167535993008,
         0.03849861263818807,
         -0.08083440265233684,
         0.07465861683083645,
         0.013614664881918676,
         -0.019254043723174064,
         0.021091748140746377,
         -0.019254043723174064,
         0.01361466488191867,
         0.07465861683083645,
         -0.08083440265233685,
         0.03849861263818809,
         0.03890167535993006,
         -0.11436162477693965,
         -0.09138027672271007,
         0.1453908865186556,
         -0.1497345148967037,
         0.0727783704841821,
         0.11761520437685374,
         -0.10185775486165403,
         0.006800632739858893,
         0.08252291533957257,
         -0.12483353044451445,
         0.10587829086113733,
         0.1293125175738256,
         -0.08662424713796306,
         -0.010545874070373194,
         0.1058782908611371,
         -0.14292718245574434,
         -0.08251904726533875,
         0.09489556807950111,
         -0.05775265636136212,
         -0.016669020706803324,
         0.09356488064932317,
         0.004305335060677052,
         -0.00962702186158705,
         0.01667449098984509,
         -0.025470705711941374,
         0.03602101746104141,
         0.048125634499775145,
         -0.10208988751108887,
         0.15594487906969728,
         -0.18006963581926672,
         0.05444526012547384,
         -0.02887159077660102,
         -0.02109174814074643,
         0.0673796782229492,
         -0.08167458988931117,
         -0.08662424713796327,
         0.09039084995909817,
         -0.03536033273255887,
         -0.06125929226753363,
         0.15279916628553677,
         0.08434969400912794,
         -0.129670025649651,
         0.12250518513286647,
         -0.031184882228949235,
         -0.1764372795738102,
         -0.04812563449977516,
         0.10208988751108893,
         -0.15594487906969715,
         0.1800696358192668},
        {0.030137345424739337,
         -0.026099706740450937,
         0.01708626882203801,
         -0.00805454436615955,
         0.15112293123430065,
         -0.13295975620901318,
         0.10412886128070618,
         -0.06998358799467484,
         0.03570926765285792,
         -0.13087629754327307,
         0.15699891609529854,
         -0.15076219256092488,
         0.12090744348438726,
         -0.07363022392882067,
         0.0699563236366303,
         -0.10698772602684355,
         0.1260224931217131,
         -0.1230968147591626,
         0.09273801539934759,
         -0.03013734542473932,
         0.026099706740451017,
         -0.01708626882203793,
         0.008054544366159542,
         -0.21522438040361275,
         0.1521866188600676,
         -0.09962952866937913,
         0.05752113519650157,
         -0.025724233688466644,
         0.07952973147473202,
         -0.07106997913758804,
         0.04946659083034198,
         -0.027301978907998573,
         0.010329889237712631,
         0.017891892996277213,
         -0.04141204646418247,
         0.06301124656085651,
         -0.07363022392882056,
         0.06345527652171168,
         -0.04141204646418246,
         0.08488642602334583,
         -0.13103266875322503,
         0.16838976197665712,
         -0.17349694017686218,
         0.20033701022937553,
         -0.11555995171537925,
         0.05856547775527165,
         -0.023948032443375233,
         0.006298230054379757,
         0.044730122487464115,
         -0.06176939242158409,
         0.06557567956266103,
         -0.05671301650647678,
         0.03663592098131238,
         -0.0813471695179889,
         0.11504227039300302,
         -0.12602249312171301,
         0.11504227039300302,
         -0.08134716951798891,
         0.03663592098131238,
         -0.05671301650647678,
         0.06557567956266105,
         -0.06176939242158406,
         0.044730122487464115,
         0.00629823005437977,
         -0.0239480324433752,
         0.05856547775527165,
         -0.1155599517153792,
         0.20033701022937553,
         -0.17349694017686212,
         0.16838976197665712,
         -0.13103266875322503,
         0.08488642602334584,
         -0.04141204646418249,
         0.06345527652171166,
         -0.07363022392882056,
         0.06301124656085651,
         -0.04141204646418246,
         0.01789189299627723,
         0.010329889237712636,
         -0.02730197890799857,
         0.049466590830341974,
         -0.07106997913758807,
         0.07952973147473205,
         -0.02572423368846663,
         0.05752113519650158,
         -0.09962952866937909,
         0.15218661886006757,
         -0.21522438040361275,
         0.008054544366159556,
         -0.017086268822037978,
         0.026099706740451,
         -0.030137345424739247,
         0.09273801539934755,
         -0.12309681475916263,
         0.1260224931217131,
         -0.10698772602684352,
         0.06995632363663026,
         -0.07363022392882064,
         0.12090744348438723,
         -0.15076219256092488,
         0.15699891609529848,
         -0.13087629754327304,
         0.03570926765285798,
         -0.0699835879946748,
         0.10412886128070624,
         -0.13295975620901324,
         0.15112293123430057,
         -0.008054544366159528,
         0.017086268822037967,
         -0.02609970674045098,
         0.030137345424739226},
        {-0.0068851300280049765,
         0.009737044264306771,
         -0.009737044264306771,
         0.006885130028005004,
         0.020641193124727286,
         -0.02230592523254679,
         0.016892634776390178,
         -0.008535665176536979,
         0.0011671045961137516,
         0.05494180384022401,
         -0.09157075688598809,
         0.1175888336980347,
         -0.12953373030052784,
         0.12428320346724973,
         -0.09717339078119942,
         -0.1828709891193246,
         0.13801119413377974,
         -0.08009676236872577,
         0.012206817579471303,
         0.06257951647867488,
         -0.14118311605040393,
         0.2205248573804072,
         0.006885130028004904,
         -0.00973704426430678,
         0.00973704426430681,
         -0.006885130028004928,
         -0.013354800393690521,
         0.01888653983954269,
         -0.020689167806675072,
         0.01888653983954268,
         -0.01335480039369051,
         -0.09992628442709031,
         0.1255056152592504,
         -0.1380064581848647,
         0.1428829418026001,
         -0.13886041565294097,
         0.11716725759931947,
         0.11558129664100744,
         -0.06051480719946182,
         0.021213007413597315,
         0.00848235022720377,
         -0.034729513233559016,
         0.06368672911608596,
         -0.10151224538540242,
         0.05494180384022403,
         -0.09157075688598806,
         0.11758883369803469,
         -0.12953373030052787,
         0.12428320346724976,
         -0.09717339078119938,
         0.0011671045961137896,
         -0.008535665176536972,
         0.016892634776390168,
         -0.022305925232546812,
         0.020641193124727352,
         0.1171672575993195,
         -0.138860415652941,
         0.14288294180260008,
         -0.13800645818486468,
         0.12550561525925047,
         -0.0999262844270903,
         -0.015655012213917106,
         -0.0015859609583120653,
         0.01193054486164962,
         -0.01537873949609544,
         0.01193054486164963,
         -0.001585960958312091,
         -0.015655012213917106,
         -0.0999262844270903,
         0.1255056152592505,
         -0.13800645818486468,
         0.14288294180260008,
         -0.13886041565294097,
         0.11716725759931948,
         0.020641193124727387,
         -0.022305925232546788,
         0.01689263477639016,
         -0.008535665176536979,
         0.0011671045961138124,
         -0.09717339078119944,
         0.12428320346724972,
         -0.12953373030052787,
         0.11758883369803472,
         -0.09157075688598809,
         0.05494180384022401,
         -0.10151224538540243,
         0.063686729116086,
         -0.034729513233559016,
         0.00848235022720376,
         0.021213007413597322,
         -0.0605148071994618,
         0.1155812966410075,
         0.11716725759931948,
         -0.13886041565294102,
         0.1428829418026001,
         -0.13800645818486465,
         0.12550561525925047,
         -0.09992628442709031,
         -0.013354800393690516,
         0.018886539839542665,
         -0.020689167806675013,
         0.018886539839542662,
         -0.013354800393690514,
         -0.006885130028004877,
         0.009737044264306764,
         -0.009737044264306808,
         0.006885130028004972,
         0.22052485738040725,
         -0.1411831160504039,
         0.06257951647867488,
         0.012206817579471278,
         -0.0800967623687257,
         0.13801119413377969,
         -0.18287098911932453,
         -0.09717339078119941,
         0.12428320346724975,
         -0.12953373030052784,
         0.11758883369803472,
         -0.09157075688598808,
         0.05494180384022401,
         0.00116710459611386,
         -0.00853566517653697,
         0.01689263477639014,
         -0.02230592523254682,
         0.020641193124727397,
         0.00688513002800495,
         -0.009737044264306783,
         0.009737044264306783,
         -0.006885130028004866},
        {0.17407765595569807,
         -0.22473328748774712,
         0.17407765595569807,
         -0.15075567228888187,
         0.07106690545187017,
         0.07106690545187018,
         -0.15075567228888187,
         0.0913717355809759,
         0.021536524612697436,
         -0.07864026893759724,
         0.02153652461269744,
         0.09137173558097589,
         -0.03932013446879858,
         -0.04060966025821153,
         0.027803533720054393,
         0.027803533720054386,
         -0.040609660258211486,
         -0.03932013446879858,
         0.00963142660661773,
         0.02247332874877472,
         0.0032104755355392336,
         -0.019262853213235447,
         0.003210475535539234,
         0.022473328748774727,
         0.009631426606617732,
         -0.15075567228888184,
         0.07106690545187018,
         0.07106690545187018,
         -0.15075567228888187,
         0.14920941939059817,
         0.035168997422666534,
         -0.12841902142156997,
         0.03516899742266653,
         0.14920941939059812,
         -0.09631426606617738,
         -0.09947294626039872,
         0.06810447066039939,
         0.06810447066039939,
         -0.09947294626039864,
         -0.09631426606617736,
         0.03852570642647095,
         0.0898933149950989,
         0.012841902142156934,
         -0.07705141285294179,
         0.012841902142156929,
         0.08989331499509892,
         0.03852570642647095,
         -0.03932013446879858,
         -0.040609660258211486,
         0.02780353372005438,
         0.027803533720054386,
         -0.04060966025821152,
         -0.03932013446879858,
         0.0913717355809759,
         0.021536524612697436,
         -0.07864026893759724,
         0.021536524612697436,
         0.0913717355809759,
         -0.09631426606617736,
         -0.09947294626039872,
         0.06810447066039939,
         0.06810447066039939,
         -0.0994729462603986,
         -0.09631426606617739,
         0.057788559639706465,
         0.1348399724926483,
         0.0192628532132354,
         -0.11557711927941275,
         0.0192628532132354,
         0.13483997249264834,
         0.05778855963970645,
         -0.09631426606617739,
         -0.09947294626039864,
         0.06810447066039939,
         0.06810447066039939,
         -0.09947294626039872,
         -0.09631426606617738,
         0.09137173558097594,
         0.021536524612697436,
         -0.07864026893759725,
         0.02153652461269744,
         0.09137173558097594,
         -0.03932013446879858,
         -0.040609660258211534,
         0.027803533720054386,
         0.027803533720054386,
         -0.0406096602582115,
         -0.03932013446879856,
         0.03852570642647093,
         0.08989331499509888,
         0.012841902142156934,
         -0.07705141285294179,
         0.012841902142156933,
         0.08989331499509888,
         0.03852570642647093,
         -0.09631426606617738,
         -0.09947294626039865,
         0.06810447066039939,
         0.06810447066039939,
         -0.09947294626039874,
         -0.09631426606617743,
         0.14920941939059823,
         0.03516899742266651,
         -0.12841902142156997,
         0.03516899742266651,
         0.14920941939059823,
         -0.15075567228888187,
         0.07106690545187018,
         0.07106690545187018,
         -0.15075567228888184,
         0.009631426606617735,
         0.022473328748774717,
         0.0032104755355392344,
         -0.019262853213235447,
         0.003210475535539235,
         0.022473328748774727,
         0.009631426606617734,
         -0.039320134468798555,
         -0.04060966025821148,
         0.02780353372005438,
         0.02780353372005438,
         -0.04060966025821154,
         -0.03932013446879854,
         0.09137173558097596,
         0.021536524612697446,
         -0.07864026893759726,
         0.02153652461269744,
         0.09137173558097596,
         -0.15075567228888187,
         0.07106690545187018,
         0.07106690545187018,
         -0.1507556722888819,
         0.17407765595569813,
         -0.22473328748774746,
         0.17407765595569813},
        {-0.10875144634875206,
         0.1537977703540952,
         -0.15379777035409511,
         0.10875144634875206,
         0.15676444329289366,
         -0.1129469554539263,
         0.004595949954244283,
         0.10455593724357783,
         -0.15083109741529657,
         -0.1306367337612907,
         0.01188685479391006,
         0.07446693847875134,
         -0.0777167658573915,
         -0.002986835977514566,
         0.1191468588756799,
         0.06328623984418597,
         0.04337820661547355,
         -0.05089611368836294,
         0.00790260671192858,
         0.03696718897638349,
         -0.03507814803912724,
         -0.06220485486114365,
         0.10875144634875203,
         -0.15379777035409511,
         0.15379777035409506,
         -0.10875144634875201,
         -0.003633417466889705,
         0.005138428259438685,
         -0.005628866135633144,
         0.0051384282594386845,
         -0.003633417466889691,
         -0.08786967877743583,
         -0.010924946978928221,
         0.07942139718811293,
         -0.07809466071648043,
         0.007291529512038553,
         0.0925604005571301,
         0.09671042984530322,
         0.0978236953917919,
         -0.09687917492316371,
         -0.0022737405762954174,
         0.10236480043169342,
         -0.10612375396813821,
         -0.08371964948926264,
         -0.1306367337612907,
         0.011886854793910098,
         0.07446693847875133,
         -0.07771676585739148,
         -0.002986835977514572,
         0.11914685887567986,
         -0.15083109741529657,
         0.10455593724357783,
         0.004595949954244334,
         -0.11294695545392601,
         0.15676444329289363,
         0.09256040055713012,
         0.007291529512038512,
         -0.07809466071648044,
         0.07942139718811288,
         -0.010924946978928223,
         -0.08786967877743582,
         -0.00884075106786743,
         0.004150029288173162,
         -0.001335596220356583,
         0.0003974518644177318,
         -0.0013355962203565883,
         0.004150029288173126,
         -0.00884075106786743,
         -0.0878696787774358,
         -0.010924946978928197,
         0.0794213971881129,
         -0.07809466071648041,
         0.007291529512038534,
         0.09256040055713011,
         0.1567644432928936,
         -0.112946955453926,
         0.004595949954244346,
         0.10455593724357785,
         -0.15083109741529654,
         0.11914685887567988,
         -0.0029868359775145816,
         -0.07771676585739147,
         0.07446693847875133,
         0.011886854793910035,
         -0.13063673376129067,
         -0.08371964948926264,
         -0.10612375396813817,
         0.10236480043169344,
         -0.002273740576295443,
         -0.09687917492316371,
         0.0978236953917919,
         0.09671042984530322,
         0.09256040055713012,
         0.007291529512038485,
         -0.07809466071648041,
         0.07942139718811292,
         -0.01092494697892821,
         -0.08786967877743575,
         -0.0036334174668896653,
         0.005138428259438698,
         -0.005628866135633124,
         0.0051384282594387045,
         -0.0036334174668896783,
         -0.10875144634875197,
         0.1537977703540951,
         -0.1537977703540951,
         0.10875144634875207,
         -0.06220485486114367,
         -0.03507814803912726,
         0.0369671889763835,
         0.007902606711928594,
         -0.050896113688362936,
         0.04337820661547352,
         0.06328623984418598,
         0.11914685887567987,
         -0.0029868359775145773,
         -0.07771676585739144,
         0.07446693847875134,
         0.011886854793910096,
         -0.13063673376129067,
         -0.15083109741529657,
         0.10455593724357785,
         0.004595949954244369,
         -0.11294695545392598,
         0.1567644432928936,
         0.10875144634875204,
         -0.1537977703540951,
         0.15379777035409514,
         -0.10875144634875201},
        {-0.0016551753071210248,
         0.002340771367435629,
         -0.0023407713674357122,
         0.001655175307121004,
         0.01751507335560576,
         -0.02311487897833653,
         0.023507927556202235,
         -0.019804528364094503,
         0.01283353062073478,
         -0.03414542872514932,
         0.026566485578266033,
         -0.011197418583164568,
         -0.005425196403468175,
         0.01895642038624488,
         -0.02462439016535636,
         0.19797356795894636,
         -0.1700939421505505,
         0.15329182137988326,
         -0.1468269887466643,
         0.1499592273506132,
         -0.16194832029144976,
         0.18205405066889366,
         0.0016551753071209964,
         -0.0023407713674355644,
         0.0023407713674355496,
         -0.0016551753071210006,
         -0.0185846485369588,
         0.0262826620129044,
         -0.028791213711503755,
         0.026282662012904405,
         -0.01858464853695879,
         0.014125676118272257,
         -0.013952518425921158,
         0.009544888779909395,
         -0.0027587346285775976,
         -0.004632130111037611,
         0.009867001974647543,
         -0.1561541292463527,
         0.16990807893647616,
         -0.17590262540689447,
         0.17561820245816812,
         -0.1705352438908578,
         0.16213418350552417,
         -0.15189545510272795,
         -0.0341454287251493,
         0.026566485578266047,
         -0.011197418583164562,
         -0.005425196403468158,
         0.018956420386244857,
         -0.024624390165356377,
         0.012833530620734746,
         -0.019804528364094482,
         0.023507927556202294,
         -0.023114878978336452,
         0.017515073355605894,
         0.009867001974647547,
         -0.0046321301110375844,
         -0.002758734628577583,
         0.009544888779909382,
         -0.01395251842592116,
         0.014125676118272272,
         0.14202845312808038,
         -0.1660211312210001,
         0.18041673807675196,
         -0.1852152736953359,
         0.180416738076752,
         -0.16602113122100007,
         0.14202845312808038,
         0.014125676118272305,
         -0.013952518425921157,
         0.009544888779909378,
         -0.002758734628577577,
         -0.004632130111037599,
         0.00986700197464755,
         0.01751507335560587,
         -0.02311487897833647,
         0.0235079275562023,
         -0.019804528364094486,
         0.012833530620734732,
         -0.024624390165356384,
         0.01895642038624488,
         -0.005425196403468156,
         -0.01119741858316457,
         0.026566485578266043,
         -0.0341454287251493,
         -0.15189545510272795,
         0.16213418350552414,
         -0.17053524389085778,
         0.1756182024581681,
         -0.17590262540689441,
         0.16990807893647616,
         -0.15615412924635272,
         0.009867001974647533,
         -0.004632130111037603,
         -0.0027587346285776002,
         0.009544888779909394,
         -0.013952518425921143,
         0.01412567611827225,
         -0.01858464853695879,
         0.02628266201290439,
         -0.02879121371150374,
         0.02628266201290439,
         -0.018584648536958785,
         -0.0016551753071209995,
         0.0023407713674355644,
         -0.002340771367435569,
         0.001655175307120969,
         0.1820540506688937,
         -0.16194832029144973,
         0.14995922735061326,
         -0.14682698874666436,
         0.15329182137988326,
         -0.17009394215055051,
         0.19797356795894633,
         -0.024624390165356416,
         0.01895642038624488,
         -0.005425196403468157,
         -0.011197418583164557,
         0.02656648557826604,
         -0.03414542872514932,
         0.012833530620734713,
         -0.019804528364094468,
         0.0235079275562023,
         -0.02311487897833645,
         0.017515073355605818,
         0.0016551753071209756,
         -0.0023407713674355657,
         0.0023407713674355474,
         -0.0016551753071210257},
        {0.005266896715960034,
         -0.007448516767329119,
         0.0074485167673290775,
         -0.005266896715960104,
         0.07283074604014303,
         -0.10826512552368098,
         0.12436809915965924,
         -0.11879891895560114,
         0.08772777957480125,
         -0.16027572239844634,
         0.13408432184337232,
         -0.06302020973714095,
         -0.024921316541935,
         0.10675346657904411,
         -0.1506445255007015,
         0.1190623622523961,
         0.011802217091656771,
         -0.09660458820048148,
         0.1329893232566064,
         -0.11860099444256046,
         0.05108417394087181,
         0.0719165660659307,
         -0.005266896715960118,
         0.007448516767329113,
         -0.0074485167673291105,
         0.005266896715960098,
         -0.098321615402549,
         0.1390477619767162,
         -0.1523191916105132,
         0.13904776197671612,
         -0.098321615402549,
         0.08114134842800876,
         -0.0658974701091404,
         0.0329540059937226,
         0.002947971770493038,
         -0.032424145293408604,
         0.04579131124741884,
         0.07723450676368318,
         -0.027511275847639155,
         -0.006247134403205144,
         0.01932986835390669,
         -0.00702607036952285,
         -0.0353751151848895,
         0.11258454394427314,
         -0.1602757223984463,
         0.13408432184337232,
         -0.06302020973714098,
         -0.024921316541934996,
         0.1067534665790441,
         -0.15064452550070154,
         0.08772777957480127,
         -0.11879891895560116,
         0.12436809915965924,
         -0.10826512552368092,
         0.07283074604014302,
         0.045791311247418844,
         -0.03242414529340863,
         0.0029479717704930385,
         0.03295400599372258,
         -0.06589747010914039,
         0.08114134842800878,
         -0.15837585519169195,
         0.03144319551626437,
         0.04471640028899231,
         -0.0701029322240777,
         0.04471640028899231,
         0.03144319551626436,
         -0.15837585519169198,
         0.0811413484280088,
         -0.06589747010914035,
         0.03295400599372257,
         0.0029479717704930354,
         -0.03242414529340862,
         0.045791311247418844,
         0.07283074604014302,
         -0.10826512552368095,
         0.1243680991596592,
         -0.11879891895560116,
         0.08772777957480124,
         -0.15064452550070154,
         0.10675346657904408,
         -0.02492131654193499,
         -0.06302020973714095,
         0.13408432184337224,
         -0.16027572239844634,
         0.11258454394427311,
         -0.035375115184889484,
         -0.007026070369522852,
         0.01932986835390668,
         -0.006247134403205137,
         -0.027511275847639162,
         0.0772345067636832,
         0.04579131124741885,
         -0.032424145293408604,
         0.002947971770493037,
         0.032954005993722564,
         -0.06589747010914038,
         0.08114134842800877,
         -0.09832161540254902,
         0.13904776197671614,
         -0.15231919161051322,
         0.13904776197671614,
         -0.09832161540254904,
         0.0052668967159600465,
         -0.007448516767329105,
         0.007448516767329131,
         -0.0052668967159601125,
         0.0719165660659307,
         0.05108417394087179,
         -0.11860099444256043,
         0.13298932325660642,
         -0.09660458820048144,
         0.011802217091656762,
         0.11906236225239612,
         -0.15064452550070156,
         0.10675346657904408,
         -0.024921316541934985,
         -0.06302020973714094,
         0.1340843218433723,
         -0.1602757223984463,
         0.08772777957480125,
         -0.11879891895560116,
         0.1243680991596593,
         -0.10826512552368095,
         0.07283074604014299,
         -0.005266896715960107,
         0.007448516767329133,
         -0.0074485167673291105,
         0.005266896715960029},
        {-0.0006051190714129739,
         0.0009567772606355578,
         -0.0011435675546721982,
         0.0011435675546722075,
         -0.0009567772606355521,
         0.0006051190714129885,
         0.059875991700599845,
         -0.08928993906274171,
         0.10609553194778842,
         -0.1111742711385308,
         0.10484281645633844,
         -0.08719374511010931,
         0.05777979774796746,
         -0.13501991041048447,
         0.1267604226046758,
         -0.08527882261989417,
         0.028637487955578956,
         0.032255168161190034,
         -0.08802471487584203,
         0.1279718338072552,
         -0.13456337013843864,
         0.12205323127819569,
         -0.026579737031741955,
         -0.04117655890959695,
         0.08137738142035131,
         -0.09418445537505268,
         0.07975950564823096,
         -0.038264257114417694,
         -0.030139565351857227,
         0.12529023687606258,
         0.0006051190714129881,
         -0.00095677726063556,
         0.0011435675546722095,
         -0.001143567554672195,
         0.0009567772606355435,
         -0.0006051190714129667,
         -0.07204916235833073,
         0.10807374353749606,
         -0.1291728301938833,
         0.13616011840761352,
         -0.12917283019388331,
         0.10807374353749609,
         -0.07204916235833074,
         0.0533472194925104,
         -0.0505140527950396,
         0.03425415912712397,
         -0.011542999170011467,
         -0.013316323591463364,
         0.03649671378685032,
         -0.05347995541113363,
         0.05670969392922743,
         0.06889375721471179,
         -0.01962031027003649,
         -0.015066775586693148,
         0.03549095010453828,
         -0.04197566303256088,
         0.03484436411982193,
         -0.014420503115383329,
         -0.01897247023169394,
         0.06501110617234818,
         -0.13501991041048447,
         0.12676042260467577,
         -0.08527882261989417,
         0.028637487955578956,
         0.03225516816119004,
         -0.08802471487584201,
         0.12797183380725521,
         -0.13456337013843864,
         0.0577797977479675,
         -0.08719374511010931,
         0.10484281645633846,
         -0.1111742711385308,
         0.10609553194778844,
         -0.08928993906274167,
         0.05987599170059985,
         0.05670969392922746,
         -0.05347995541113364,
         0.03649671378685032,
         -0.01331632359146336,
         -0.01154299917001147,
         0.034254159127123956,
         -0.05051405279503959,
         0.053347219492510416,
         -0.13049382028374965,
         0.03518173739842015,
         0.032898321805386724,
         -0.07374635732767053,
         0.08736236916843207,
         -0.07374635732767053,
         0.03289832180538672,
         0.035181737398420156,
         -0.13049382028374965,
         0.05334721949251042,
         -0.0505140527950396,
         0.03425415912712396,
         -0.011542999170011468,
         -0.013316323591463364,
         0.03649671378685031,
         -0.05347995541113365,
         0.056709693929227444,
         0.059875991700599866,
         -0.08928993906274167,
         0.10609553194778841,
         -0.11117427113853084,
         0.10484281645633843,
         -0.0871937451101093,
         0.05777979774796749,
         -0.13456337013843864,
         0.12797183380725521,
         -0.088024714875842,
         0.03225516816119002,
         0.028637487955578952,
         -0.08527882261989417,
         0.12676042260467582,
         -0.13501991041048444,
         0.06501110617234815,
         -0.01897247023169397,
         -0.014420503115383313,
         0.03484436411982192,
         -0.04197566303256089,
         0.03549095010453829,
         -0.015066775586693146,
         -0.019620310270036523,
         0.06889375721471172,
         0.05670969392922748,
         -0.053479955411133644,
         0.03649671378685032,
         -0.013316323591463364,
         -0.011542999170011467,
         0.03425415912712398,
         -0.0505140527950396,
         0.05334721949251041,
         -0.07204916235833073,
         0.10807374353749606,
         -0.1291728301938833,
         0.13616011840761358,
         -0.1291728301938833,
         0.108073743537496,
         -0.07204916235833073,
         -0.000605119071412974,
         0.0009567772606355692,
         -0.0011435675546721976,
         0.0011435675546722108,
         -0.0009567772606355425,
         0.0006051190714129822,
         0.12529023687606256,
         -0.030139565351857245,
         -0.038264257114417694,
         0.07975950564823095,
         -0.09418445537505264,
         0.08137738142035135,
         -0.04117655890959689,
         -0.026579737031741955,
         0.12205323127819566,
         -0.1345633701384386,
         0.1279718338072552,
         -0.08802471487584206,
         0.03225516816119003,
         0.02863748795557896,
         -0.08527882261989425,
         0.12676042260467582,
         -0.13501991041048442,
         0.05777979774796749,
         -0.08719374511010934,
         0.10484281645633842,
         -0.11117427113853083,
         0.10609553194778842,
         -0.08928993906274167,
         0.05987599170059988,
         0.0006051190714129988,
         -0.0009567772606355684,
         0.001143567554672196,
         -0.0011435675546722062,
         0.0009567772606355778,
         -0.0006051190714129421},
        {0.10429770312912398,
         -0.16490914830605152,
         0.18698939800169148,
         -0.16490914830605133,
         0.10429770312912398,
         -0.11660837704690692,
         0.11062441971717746,
         -0.04407382377899542,
         -0.04407382377899542,
         0.11062441971717746,
         -0.11660837704690692,
         0.0865592715571677,
         -0.028853090519055883,
         -0.03793464318169963,
         0.06543265891633486,
         -0.03793464318169963,
         -0.028853090519055876,
         0.0865592715571677,
         -0.04407382377899543,
         -0.016658339578129545,
         0.037777563239138896,
         -0.017919471643009083,
         -0.017919471643009083,
         0.037777563239138896,
         -0.016658339578129552,
         -0.04407382377899543,
         0.012465959866779426,
         0.01869893980016913,
         -0.009794682752469558,
         -0.008013831342929625,
         0.016027662685859232,
         -0.008013831342929625,
         -0.009794682752469558,
         0.018698939800169134,
         0.01246595986677942,
         -0.11660837704690692,
         0.11062441971717746,
         -0.04407382377899543,
         -0.04407382377899543,
         0.11062441971717746,
         -0.11660837704690692,
         0.141350698548044,
         -0.04711689951601463,
         -0.06194701291314204,
         0.10685108457239498,
         -0.06194701291314204,
         -0.04711689951601463,
         0.141350698548044,
         -0.10795837927188259,
         -0.04080443192842735,
         0.0925357536616135,
         -0.04389356198564474,
         -0.04389356198564474,
         0.0925357536616135,
         -0.04080443192842735,
         -0.10795837927188259,
         0.0498638394671177,
         0.07479575920067658,
         -0.03917873100987822,
         -0.0320553253717185,
         0.06411065074343694,
         -0.0320553253717185,
         -0.03917873100987823,
         0.07479575920067658,
         0.0498638394671177,
         -0.044073823778995436,
         -0.016658339578129545,
         0.0377775632391389,
         -0.017919471643009076,
         -0.017919471643009076,
         0.0377775632391389,
         -0.016658339578129545,
         -0.044073823778995436,
         0.08655927155716765,
         -0.028853090519055876,
         -0.03793464318169963,
         0.06543265891633486,
         -0.03793464318169963,
         -0.028853090519055876,
         0.08655927155716765,
         -0.10795837927188259,
         -0.04080443192842735,
         0.0925357536616135,
         -0.043893561985644744,
         -0.04389356198564474,
         0.09253575366161351,
         -0.04080443192842735,
         -0.10795837927188259,
         0.07479575920067653,
         0.11219363880101481,
         -0.05876809651481736,
         -0.04808298805757776,
         0.09616597611515545,
         -0.04808298805757776,
         -0.05876809651481735,
         0.11219363880101484,
         0.07479575920067655,
         -0.10795837927188259,
         -0.04080443192842735,
         0.0925357536616135,
         -0.04389356198564474,
         -0.04389356198564474,
         0.09253575366161353,
         -0.04080443192842734,
         -0.10795837927188257,
         0.08655927155716764,
         -0.02885309051905587,
         -0.037934643181699625,
         0.06543265891633493,
         -0.03793464318169962,
         -0.02885309051905587,
         0.08655927155716764,
         -0.044073823778995436,
         -0.01665833957812954,
         0.037777563239138896,
         -0.017919471643009083,
         -0.017919471643009076,
         0.03777756323913891,
         -0.01665833957812954,
         -0.04407382377899545,
         0.049863839467117727,
         0.07479575920067659,
         -0.03917873100987822,
         -0.032055325371718506,
         0.06411065074343694,
         -0.0320553253717185,
         -0.03917873100987822,
         0.07479575920067659,
         0.04986383946711771,
         -0.10795837927188259,
         -0.04080443192842734,
         0.0925357536616135,
         -0.04389356198564474,
         -0.04389356198564474,
         0.0925357536616135,
         -0.04080443192842734,
         -0.10795837927188259,
         0.14135069854804397,
         -0.04711689951601463,
         -0.061947012913141995,
         0.10685108457239491,
         -0.061947012913141995,
         -0.04711689951601463,
         0.14135069854804397,
         -0.1166083770469069,
         0.11062441971717743,
         -0.04407382377899542,
         -0.044073823778995415,
         0.11062441971717743,
         -0.11660837704690692,
         0.01246595986677943,
         0.018698939800169158,
         -0.009794682752469556,
         -0.00801383134292963,
         0.016027662685859236,
         -0.008013831342929626,
         -0.009794682752469554,
         0.01869893980016915,
         0.012465959866779432,
         -0.04407382377899546,
         -0.016658339578129535,
         0.037777563239138896,
         -0.017919471643009083,
         -0.017919471643009083,
         0.037777563239138896,
         -0.01665833957812954,
         -0.044073823778995457,
         0.08655927155716762,
         -0.02885309051905587,
         -0.03793464318169961,
         0.06543265891633496,
         -0.03793464318169962,
         -0.02885309051905587,
         0.08655927155716761,
         -0.11660837704690695,
         0.11062441971717746,
         -0.044073823778995394,
         -0.0440738237789954,
         0.11062441971717743,
         -0.11660837704690695,
         0.10429770312912395,
         -0.16490914830605138,
         0.18698939800169148,
         -0.1649091483060514,
         0.10429770312912397},
        {0.0009111490705091013,
         -0.0014406531753770428,
         0.0017219098913391628,
         -0.0017219098913390796,
         0.0014406531753770047,
         -0.000911149070509094,
         -0.0009223723440408875,
         0.0005944802743658837,
         0.00023258905787058474,
         -0.00123931553318616,
         0.0021188468368259633,
         -0.0025618326924159063,
         0.0022339406227408986,
         -0.06671309238538439,
         0.08905192370358957,
         -0.10136456893303254,
         0.10671335193467,
         -0.10603455086127736,
         0.09943266720995358,
         -0.0862122950832095,
         0.06370791192726154,
         0.18957556413121368,
         -0.14240228411158373,
         0.09480202866416017,
         -0.047018312621094425,
         -0.0007053491854617317,
         0.048125441923356736,
         -0.09499845076043906,
         0.14108086086455693,
         -0.186129157403559,
         -0.0009111490705090822,
         0.001440653175377043,
         -0.00172190989133909,
         0.001721909891339089,
         -0.0014406531753770272,
         0.0009111490705090791,
         -0.0008031682614088588,
         0.0012047523921132855,
         -0.001439954526217847,
         0.0015178453433056871,
         -0.0014399545262178477,
         0.0012047523921132868,
         -0.000803168261408862,
         0.08343211840089111,
         -0.10902253846488319,
         0.12251348024239322,
         -0.12841883261336737,
         0.12814171323558982,
         -0.121724784666602,
         0.10786326493506075,
         -0.08220525861632703,
         -0.09522900409195384,
         0.07014795008486094,
         -0.04637620053634717,
         0.023426725782109234,
         -0.000812496157843955,
         -0.02195351800075187,
         0.04535834635798151,
         -0.06988901857814815,
         0.09603256432555501,
         -0.06671309238538438,
         0.08905192370358954,
         -0.10136456893303254,
         0.10671335193467,
         -0.10603455086127739,
         0.09943266720995358,
         -0.08621229508320948,
         0.06370791192726152,
         0.002233940622740899,
         -0.0025618326924159033,
         0.002118846836825958,
         -0.0012393155331861599,
         0.0002325890578706094,
         0.0005944802743658907,
         -0.00092237234404088,
         -0.08220525861632705,
         0.10786326493506074,
         -0.12172478466660204,
         0.12814171323558987,
         -0.12841883261336748,
         0.12251348024239318,
         -0.10902253846488318,
         0.08343211840089113,
         -0.0011101079436765748,
         4.7616203362596205e-05,
         0.0007113064682902533,
         -0.0011666600712819566,
         0.0013184446056125126,
         -0.0011666600712819648,
         0.0007113064682902517,
         4.761620336260011e-05,
         -0.0011101079436765717,
         0.08343211840089111,
         -0.10902253846488318,
         0.1225134802423932,
         -0.1284188326133674,
         0.12814171323558984,
         -0.12172478466660203,
         0.10786326493506074,
         -0.08220525861632703,
         -0.0009223723440408804,
         0.0005944802743658896,
         0.00023258905787061025,
         -0.0012393155331861506,
         0.0021188468368259603,
         -0.002561832692415915,
         0.002233940622740894,
         0.0637079119272615,
         -0.08621229508320948,
         0.09943266720995356,
         -0.1060345508612774,
         0.10671335193466998,
         -0.10136456893303254,
         0.08905192370358957,
         -0.0667130923853844,
         0.09603256432555501,
         -0.06988901857814812,
         0.04535834635798153,
         -0.02195351800075187,
         -0.0008124961578439572,
         0.02342672578210923,
         -0.04637620053634718,
         0.07014795008486094,
         -0.09522900409195384,
         -0.08220525861632703,
         0.10786326493506075,
         -0.121724784666602,
         0.1281417132355899,
         -0.12841883261336742,
         0.12251348024239325,
         -0.10902253846488316,
         0.08343211840089113,
         -0.0008031682614088559,
         0.0012047523921132836,
         -0.0014399545262178473,
         0.001517845343305701,
         -0.0014399545262178493,
         0.0012047523921132875,
         -0.000803168261408854,
         0.0009111490705091016,
         -0.0014406531753770433,
         0.0017219098913391123,
         -0.0017219098913390882,
         0.0014406531753770606,
         -0.0009111490705091079,
         -0.186129157403559,
         0.141080860864557,
         -0.09499845076043907,
         0.04812544192335672,
         -0.0007053491854617363,
         -0.0470183126210944,
         0.09480202866416017,
         -0.14240228411158387,
         0.18957556413121374,
         0.06370791192726148,
         -0.08621229508320942,
         0.09943266720995361,
         -0.10603455086127739,
         0.10671335193467002,
         -0.1013645689330326,
         0.08905192370358958,
         -0.0667130923853844,
         0.0022339406227409268,
         -0.002561832692415938,
         0.0021188468368259403,
         -0.0012393155331861462,
         0.00023258905787061174,
         0.0005944802743658795,
         -0.0009223723440408833,
         -0.000911149070509109,
         0.0014406531753770372,
         -0.001721909891339096,
         0.0017219098913391247,
         -0.0014406531753770346,
         0.0009111490705090976},
        {0.016427557113801172,
         -0.025974248436056894,
         0.031045164836734352,
         -0.031045164836734345,
         0.025974248436056897,
         -0.01642755711380126,
         -0.027030720291764145,
         0.0263193986549745,
         -0.01445356117035712,
         -0.002688543075892396,
         0.01955471299473405,
         -0.03058732847571205,
         0.029876006838922494,
         0.023167176788439083,
         -0.007238003725579654,
         -0.00902296614897302,
         0.01785580885957205,
         -0.01638323317008146,
         0.004831942263768212,
         0.013398229802792832,
         -0.02968654727653549,
         0.13478007067692085,
         -0.1511617384849736,
         0.15503061421430392,
         -0.15077714718073368,
         0.14279178670008444,
         -0.13546498208817817,
         0.13318718266083654,
         -0.1403488377338815,
         0.1613403966231348,
         -0.016427557113801262,
         0.025974248436056894,
         -0.03104516483673434,
         0.031045164836734362,
         -0.025974248436056894,
         0.016427557113801255,
         -0.0017423750531358711,
         0.002613562579703798,
         -0.0031238047675477506,
         0.0032927793437145894,
         -0.0031238047675477606,
         0.0026135625797037913,
         -0.0017423750531358737,
         0.02219596616848672,
         -0.008739956617710388,
         -0.00586910938685219,
         0.01480358810038465,
         -0.015404764608197837,
         0.007580087723280272,
         0.006225054852817218,
         -0.019534444311820828,
         -0.16754340629302655,
         0.1319394679215242,
         -0.12234894751058131,
         0.12999094642855408,
         -0.14608456604379905,
         0.16184890772467253,
         -0.16850307283953095,
         0.15726616275673075,
         -0.1193572788446283,
         0.023167176788439072,
         -0.007238003725579645,
         -0.009022966148973015,
         0.01785580885957205,
         -0.016383233170081453,
         0.00483194226376819,
         0.013398229802792816,
         -0.02968654727653549,
         0.029876006838922508,
         -0.03058732847571206,
         0.019554712994734064,
         -0.0026885430758924,
         -0.014453561170357121,
         0.0263193986549745,
         -0.027030720291764124,
         -0.01953444431182084,
         0.0062250548528172195,
         0.007580087723280279,
         -0.015404764608197832,
         0.01480358810038466,
         -0.005869109386852183,
         -0.008739956617710395,
         0.022195966168486733,
         0.1419137122084273,
         -0.14421865774902742,
         0.14586504742088466,
         -0.1468528812239991,
         0.1471821591583705,
         -0.14685288122399906,
         0.14586504742088466,
         -0.14421865774902742,
         0.1419137122084273,
         0.022195966168486726,
         -0.008739956617710392,
         -0.005869109386852177,
         0.014803588100384662,
         -0.015404764608197835,
         0.007580087723280268,
         0.006225054852817214,
         -0.01953444431182083,
         -0.027030720291764135,
         0.026319398654974496,
         -0.014453561170357126,
         -0.002688543075892391,
         0.01955471299473407,
         -0.030587328475712057,
         0.0298760068389225,
         -0.029686547276535486,
         0.013398229802792785,
         0.004831942263768208,
         -0.016383233170081446,
         0.017855808859572067,
         -0.009022966148973023,
         -0.007238003725579673,
         0.023167176788439072,
         -0.11935727884462831,
         0.15726616275673078,
         -0.16850307283953095,
         0.16184890772467247,
         -0.14608456604379902,
         0.12999094642855413,
         -0.12234894751058134,
         0.13193946792152422,
         -0.16754340629302658,
         -0.019534444311820824,
         0.0062250548528172064,
         0.007580087723280278,
         -0.015404764608197844,
         0.014803588100384653,
         -0.0058691093868521805,
         -0.008739956617710409,
         0.02219596616848672,
         -0.001742375053135839,
         0.0026135625797038013,
         -0.003123804767547751,
         0.0032927793437145868,
         -0.003123804767547751,
         0.002613562579703798,
         -0.0017423750531358445,
         0.01642755711380121,
         -0.02597424843605688,
         0.031045164836734366,
         -0.03104516483673434,
         0.02597424843605691,
         -0.01642755711380126,
         0.1613403966231348,
         -0.14034883773388152,
         0.1331871826608365,
         -0.13546498208817814,
         0.14279178670008444,
         -0.1507771471807337,
         0.155030614214304,
         -0.15116173848497363,
         0.13478007067692077,
         -0.029686547276535483,
         0.01339822980279281,
         0.004831942263768204,
         -0.016383233170081463,
         0.017855808859572036,
         -0.00902296614897302,
         -0.007238003725579664,
         0.02316717678843909,
         0.029876006838922515,
         -0.030587328475712064,
         0.0195547129947341,
         -0.0026885430758924285,
         -0.014453561170357133,
         0.026319398654974496,
         -0.027030720291764142,
         -0.01642755711380125,
         0.025974248436056908,
         -0.031045164836734345,
         0.03104516483673437,
         -0.025974248436056873,
         0.016427557113801238},
        {0.06913352338814047,
         -0.10930969828952247,
         0.13065007867334877,
         -0.13065007867334813,
         0.10930969828952242,
         -0.0691335233881406,
         -0.11957455257016733,
         0.11949044134799536,
         -0.07125839881190021,
         -0.0003179105376229767,
         0.07186159164653459,
         -0.1199951086810258,
         0.11991099745885424,
         0.11016262692180369,
         -0.04217685713241795,
         -0.030400795305262004,
         0.07318630768446616,
         -0.07301218091174154,
         0.029905221822179886,
         0.04290528168385868,
         -0.11093351900659812,
         -0.0881256122525364,
         0.010228871722805332,
         0.01231560671154048,
         0.002015465631002801,
         -0.034745377431939145,
         0.06739741737277244,
         -0.08149487413500664,
         0.05856103640014575,
         0.01988080715030646,
         -0.06913352338814056,
         0.10930969828952243,
         -0.13065007867334813,
         0.13065007867334819,
         -0.10930969828952243,
         0.06913352338814056,
         -0.0002060295759625974,
         0.00030904436394390785,
         -0.00036937866533930195,
         0.0003893593005151047,
         -0.00036937866533930715,
         0.0003090443639439007,
         -0.00020602957596259006,
         0.08878239160567367,
         -0.03271766066865333,
         -0.026974304411758545,
         0.062238205629421714,
         -0.06230929258671061,
         0.027176621439026046,
         0.032420282590795726,
         -0.08846767622992423,
         -0.06766786880692567,
         -0.08711667826205696,
         0.1310798933501146,
         -0.10117519909423962,
         0.03435601813142404,
         0.03242422690134001,
         -0.06221211336706048,
         0.018054218628745275,
         0.1370028799505979,
         0.11016262692180367,
         -0.042176857132417936,
         -0.030400795305261977,
         0.07318630768446618,
         -0.0730121809117415,
         0.029905221822179893,
         0.04290528168385868,
         -0.1109335190065981,
         0.11991099745885422,
         -0.11999510868102578,
         0.07186159164653458,
         -0.0003179105376229875,
         -0.07125839881190023,
         0.11949044134799539,
         -0.1195745525701673,
         -0.0884676762299243,
         0.03242028259079575,
         0.027176621439026067,
         -0.062309292586710585,
         0.062238205629421756,
         -0.026974304411758535,
         -0.03271766066865331,
         0.0887823916056737,
         -0.03484920657874316,
         0.03457665506838259,
         -0.03438197541812503,
         0.03426516762797051,
         -0.03422623169791898,
         0.034265167627970515,
         -0.03438197541812505,
         0.03457665506838261,
         -0.03484920657874318,
         0.0887823916056737,
         -0.03271766066865331,
         -0.026974304411758538,
         0.06223820562942176,
         -0.06230929258671057,
         0.027176621439026077,
         0.032420282590795754,
         -0.08846767622992427,
         -0.11957455257016733,
         0.11949044134799539,
         -0.07125839881190023,
         -0.0003179105376229915,
         0.07186159164653458,
         -0.11999510868102582,
         0.11991099745885418,
         -0.11093351900659809,
         0.04290528168385866,
         0.029905221822179896,
         -0.07301218091174148,
         0.07318630768446618,
         -0.03040079530526198,
         -0.042176857132417964,
         0.11016262692180367,
         0.13700287995059793,
         0.01805421862874527,
         -0.0622121133670605,
         0.032424226901339975,
         0.03435601813142404,
         -0.1011751990942396,
         0.13107989335011463,
         -0.08711667826205693,
         -0.06766786880692563,
         -0.08846767622992426,
         0.03242028259079575,
         0.02717662143902603,
         -0.06230929258671063,
         0.0622382056294217,
         -0.026974304411758562,
         -0.032717660668653316,
         0.08878239160567367,
         -0.00020602957596258615,
         0.00030904436394391067,
         -0.0003693786653392933,
         0.0003893593005151255,
         -0.0003693786653392933,
         0.0003090443639439215,
         -0.0002060295759625905,
         0.06913352338814055,
         -0.10930969828952243,
         0.1306500786733482,
         -0.13065007867334816,
         0.10930969828952243,
         -0.06913352338814058,
         0.019880807150306424,
         0.05856103640014573,
         -0.08149487413500671,
         0.06739741737277247,
         -0.03474537743193913,
         0.002015465631002779,
         0.012315606711540457,
         0.010228871722805344,
         -0.0881256122525364,
         -0.11093351900659809,
         0.04290528168385867,
         0.02990522182217989,
         -0.07301218091174157,
         0.07318630768446616,
         -0.03040079530526201,
         -0.04217685713241796,
         0.1101626269218037,
         0.11991099745885424,
         -0.11999510868102584,
         0.07186159164653459,
         -0.0003179105376229924,
         -0.07125839881190023,
         0.11949044134799536,
         -0.11957455257016733,
         -0.06913352338814059,
         0.10930969828952238,
         -0.13065007867334813,
         0.13065007867334816,
         -0.10930969828952244,
         0.06913352338814058},
        {0.0041581187589605495,
         -0.005092634624673681,
         0.004304061820820715,
         -0.0024849512508596204,
         0.04522929467408776,
         -0.060043264790523784,
         0.059893323219853176,
         -0.04784990564289164,
         0.02796559857550633,
         -0.049587800777354994,
         4.6500007693573696e-05,
         0.055546210757270155,
         -0.09425598479621121,
         0.1037134235513202,
         -0.07846824110507718,
         -0.010718802360717322,
         0.07001515982817916,
         -0.05921666086604508,
         0.0029969099642805346,
         0.07068897540287283,
         -0.1303207263009843,
         0.1393097569845689,
         0.01198398535797456,
         -0.06701897022859139,
         0.0940904841033977,
         -0.07500131095215876,
         0.00811111178978658,
         0.09108966851702764,
         -0.17737041969894904,
         -0.007845360004308688,
         0.043222941212665816,
         -0.08209871542431575,
         0.10467330136763602,
         -0.09014834525635275,
         0.016557071691896807,
         0.1392684446417349,
         -0.00509263462467367,
         0.006237178138440309,
         -0.005271377641202521,
         0.0030434313001484444,
         -0.07871586702094434,
         0.09787697141676374,
         -0.09197753129689987,
         0.06957048122754363,
         -0.03866097389658487,
         0.014374796315462297,
         0.0399535629489571,
         -0.08761647543570784,
         0.11186057342265042,
         -0.10689200071408804,
         0.07337800092825493,
         0.07929791497070493,
         -0.051215596702634675,
         0.006270412526408928,
         0.04023404737358558,
         -0.07565942882020786,
         0.08991542985316477,
         -0.07483530090780326,
         -0.0895403768369556,
         0.06860968808528047,
         -0.028343410908331076,
         -0.010550706281663014,
         0.03516501265264065,
         -0.03819231442368273,
         0.019822567258840663,
         0.06926972083408262,
         -0.05953848858364507,
         0.02006334337611878,
         0.025461082943206995,
         -0.05082295484317423,
         0.02654215769018496,
         0.08027133978041354,
         -0.03629455379698352,
         0.03316003211841931,
         0.0022788323894659995,
         -0.06590408941645198,
         0.14247308200239417,
         -0.1939835486615124,
         0.08591793997536869,
         -0.10081720538820352,
         0.08925540358810691,
         -0.06348361862724677,
         0.03310445397888966,
         0.08306396510649527,
         -0.09910551436783728,
         0.09367871216218447,
         -0.074916727020696,
         0.04964021375001845,
         -0.024145633530114795,
         -0.12651898313494178,
         0.00425137844302017,
         0.05401062991305923,
         -0.06333808845927366,
         0.04076703869826295,
         -0.005380421266659501,
         -0.021261328277486852,
         0.08627946689642985,
         -0.026890702945883926,
         -0.027676572434567583,
         0.04846255785426807,
         -0.0276765724345676,
         -0.026890702945883926,
         0.08627946689642982,
         -0.021261328277486856,
         -0.005380421266659473,
         0.04076703869826293,
         -0.06333808845927366,
         0.05401062991305923,
         0.004251378443020154,
         -0.1265189831349418,
         -0.024145633530114792,
         0.04964021375001844,
         -0.074916727020696,
         0.09367871216218442,
         -0.09910551436783731,
         0.08306396510649529,
         0.03310445397888965,
         -0.0634836186272468,
         0.08925540358810692,
         -0.1008172053882035,
         0.08591793997536872,
         -0.19398354866151232,
         0.1424730820023942,
         -0.06590408941645201,
         0.0022788323894659675,
         0.03316003211841924,
         -0.0362945537969835,
         0.08027133978041356,
         0.026542157690184965,
         -0.050822954843174215,
         0.025461082943206998,
         0.020063343376118776,
         -0.05953848858364509,
         0.06926972083408259,
         0.01982256725884068,
         -0.03819231442368272,
         0.03516501265264065,
         -0.01055070628166302,
         -0.028343410908331066,
         0.06860968808528042,
         -0.08954037683695559,
         -0.07483530090780327,
         0.08991542985316477,
         -0.07565942882020787,
         0.040234047373585595,
         0.006270412526408936,
         -0.05121559670263468,
         0.07929791497070496,
         0.07337800092825493,
         -0.10689200071408803,
         0.11186057342265038,
         -0.08761647543570779,
         0.039953562948957105,
         0.01437479631546228,
         -0.03866097389658487,
         0.06957048122754363,
         -0.09197753129689987,
         0.09787697141676373,
         -0.07871586702094435,
         0.003043431300148441,
         -0.005271377641202529,
         0.006237178138440324,
         -0.005092634624673677,
         0.13926844464173493,
         0.016557071691896835,
         -0.09014834525635276,
         0.10467330136763595,
         -0.08209871542431572,
         0.04322294121266586,
         -0.00784536000430874,
         -0.17737041969894904,
         0.09108966851702764,
         0.0081111117897866,
         -0.07500131095215874,
         0.09409048410339772,
         -0.06701897022859137,
         0.01198398535797457,
         0.13930975698456888,
         -0.1303207263009842,
         0.07068897540287282,
         0.00299690996428053,
         -0.05921666086604509,
         0.07001515982817914,
         -0.0107188023607173,
         -0.07846824110507719,
         0.10371342355132021,
         -0.09425598479621121,
         0.05554621075727017,
         4.6500007693567814e-05,
         -0.04958780077735494,
         0.027965598575506324,
         -0.04784990564289161,
         0.05989332321985318,
         -0.060043264790523805,
         0.04522929467408764,
         -0.002484951250859632,
         0.00430406182082073,
         -0.0050926346246737055,
         0.004158118758960237},
        {0.005803310545011597,
         -0.007107574827095951,
         0.006006997105921431,
         -0.003468141396125035,
         -0.0574969883166071,
         0.06393084312463287,
         -0.053181462454269544,
         0.03516177044037157,
         -0.01680654853269607,
         0.1367923070969842,
         -0.082519307172715,
         0.017209573639613847,
         0.02937092422667866,
         -0.04800456995814623,
         0.03931148234428317,
         -0.1684087966207644,
         -0.02168938046850578,
         0.09472890538518809,
         -0.09139738539800067,
         0.0480454902281423,
         0.0032108880521984485,
         -0.033951498006582405,
         0.18828675862648298,
         -0.10493174549515072,
         0.007604748016479297,
         0.05873709851366093,
         -0.07947085281534208,
         0.05684082172404264,
         -0.008516799593032393,
         -0.12326261768053401,
         0.1317480770070367,
         -0.0973252506927315,
         0.043216181201346834,
         0.010596654074014122,
         -0.046166859864241454,
         0.04735743826189634,
         -0.0071075748270959275,
         0.00870496581751771,
         -0.007357038897941397,
         0.004247588388165001,
         0.08085909212422394,
         -0.09697997826466866,
         0.08788643387766029,
         -0.06409081735410792,
         0.03432848640205682,
         -0.14602050513625678,
         0.11350918483889898,
         -0.05729851663878213,
         0.006347344600854213,
         0.025105979370303667,
         -0.030508899754887662,
         0.12415691562584306,
         -0.02541194616629181,
         -0.03950364537581151,
         0.07092596349672727,
         -0.07299072370022741,
         0.053633524025273646,
         -0.024586527691939492,
         -0.032977543558540975,
         0.056709221997269944,
         -0.054669601310306064,
         0.028282029339550104,
         0.013144609305430514,
         -0.055102629448174276,
         0.07698367919877365,
         -0.07277239464336165,
         0.04921190239215252,
         0.00045822921138000046,
         -0.04662138656812645,
         0.0657317087043831,
         -0.03936590876781214,
         -0.04595620614102134,
         0.10012171685605877,
         -0.1407129230746552,
         0.14277325492632031,
         -0.11002930759980113,
         0.053171690298846115,
         0.00728901971868701,
         -0.07080746340816332,
         0.09287641802495945,
         -0.09168559242821059,
         0.07258599413043797,
         -0.04208348631937345,
         0.08412302247031544,
         -0.10275736417570146,
         0.09782124392740928,
         -0.07767726599697242,
         0.05027312158010046,
         -0.023288134337455777,
         -0.029563888804222626,
         0.05800814730236583,
         -0.0364892134775868,
         -0.010037018304333218,
         0.05922417865999629,
         -0.09117739475076649,
         0.0876135653720936,
         -0.07131482179613821,
         0.009617424979226479,
         0.0454323529962027,
         -0.06626485847895498,
         0.045432352996202706,
         0.009617424979226477,
         -0.0713148217961382,
         0.0876135653720936,
         -0.09117739475076647,
         0.05922417865999629,
         -0.010037018304333222,
         -0.0364892134775868,
         0.0580081473023658,
         -0.029563888804222654,
         -0.023288134337455777,
         0.050273121580100444,
         -0.07767726599697243,
         0.09782124392740922,
         -0.10275736417570147,
         0.08412302247031546,
         -0.04208348631937345,
         0.07258599413043794,
         -0.0916855924282106,
         0.09287641802495945,
         -0.07080746340816331,
         0.007289019718687058,
         0.053171690298846136,
         -0.11002930759980115,
         0.14277325492632031,
         -0.14071292307465522,
         0.10012171685605875,
         -0.04595620614102137,
         -0.039365908767812145,
         0.06573170870438308,
         -0.04662138656812645,
         0.00045822921137999743,
         0.04921190239215252,
         -0.07277239464336159,
         0.07698367919877365,
         -0.05510262944817426,
         0.013144609305430517,
         0.0282820293395501,
         -0.05466960131030605,
         0.05670922199726991,
         -0.03297754355854098,
         -0.02458652769193949,
         0.05363352402527365,
         -0.07299072370022743,
         0.07092596349672728,
         -0.03950364537581151,
         -0.025411946166291815,
         0.1241569156258431,
         -0.030508899754887662,
         0.025105979370303653,
         0.00634734460085421,
         -0.05729851663878208,
         0.11350918483889896,
         -0.14602050513625678,
         0.03432848640205681,
         -0.06409081735410788,
         0.08788643387766028,
         -0.09697997826466867,
         0.08085909212422397,
         0.004247588388165002,
         -0.007357038897941412,
         0.008704965817517722,
         -0.007107574827095943,
         0.04735743826189635,
         -0.046166859864241475,
         0.0105966540740141,
         0.04321618120134683,
         -0.0973252506927315,
         0.13174807700703672,
         -0.12326261768053406,
         -0.008516799593032445,
         0.056840821724042645,
         -0.0794708528153421,
         0.058737098513660914,
         0.007604748016479289,
         -0.10493174549515069,
         0.18828675862648303,
         -0.03395149800658243,
         0.003210888052198494,
         0.048045490228142286,
         -0.09139738539800069,
         0.09472890538518809,
         -0.021689380468505784,
         -0.16840879662076444,
         0.039311482344283194,
         -0.0480045699581462,
         0.02937092422667868,
         0.017209573639613843,
         -0.082519307172715,
         0.1367923070969842,
         -0.01680654853269608,
         0.03516177044037158,
         -0.053181462454269544,
         0.0639308431246329,
         -0.057496988316607225,
         -0.003468141396125044,
         0.006006997105921441,
         -0.007107574827095958,
         0.005803310545011795},
        {-0.10610611803124056,
         0.12995292388203267,
         -0.10983026653331085,
         0.06341053394817531,
         0.1446002294054272,
         -0.058468142993109096,
         -0.055699284553914485,
         0.12337844283868664,
         -0.11241517480602498,
         -0.10859549322830479,
         -0.05568493691204026,
         0.10568521582712932,
         -0.04081334197906808,
         -0.06670914000276283,
         0.1236145207482295,
         0.045019321189791524,
         0.0940138975761156,
         -0.027902011692331776,
         -0.06350972022966557,
         0.0808082965119572,
         -0.005467416785634349,
         -0.09777421899099091,
         -0.05033313124063519,
         -0.04650547641515694,
         0.055460067147783954,
         0.001948970557074499,
         -0.058649760541697765,
         0.047790122343107665,
         0.051348318167494925,
         0.032950769124908234,
         0.007825813902811687,
         -0.03591041589657459,
         0.02674859340653997,
         0.0120213199755905,
         -0.04144584874032195,
         -0.00857579008413055,
         0.1299529238820325,
         -0.15915917704686092,
         0.13451405566024377,
         -0.07766172624523003,
         -0.04485185012799371,
         0.01741789562404926,
         0.018605541962377528,
         -0.03975499427711028,
         0.03595373357882986,
         -0.0405401258075766,
         -0.006776671311227216,
         0.022805706931706755,
         -0.006231639387203849,
         -0.022659056521096968,
         0.037261342079582926,
         0.05502602176462519,
         0.07878598811907032,
         -0.030547483772482772,
         -0.04349935420088555,
         0.056773743402232055,
         0.007239765109678477,
         -0.09287608265983249,
         -0.09922630524702349,
         -0.058235328466763055,
         0.08150110155501039,
         -0.0010336165927562705,
         -0.07931468539905695,
         0.05578379758645831,
         0.10172999464770338,
         0.11076572438993883,
         0.0013783220780341568,
         -0.08340709850758798,
         0.06446613186660596,
         0.03412906206338187,
         -0.10153513078500162,
         -0.06211433303385043,
         -0.07948376232253848,
         0.03928030111259685,
         0.03396820823390069,
         -0.07756387232666402,
         0.04304181044639833,
         0.06911643631629706,
         -0.13892933729601523,
         0.057610459961221064,
         0.05085721769134791,
         -0.11556845821334952,
         0.10583653081884818,
         0.11024056689940279,
         0.03590647631427182,
         -0.0823605258748404,
         0.027142744795484036,
         0.06588133973370418,
         -0.1137464221360411,
         -0.0372784204553935,
         -0.05585986278328211,
         0.021300062219602785,
         0.030829602494323687,
         -0.0396601168484355,
         -0.0061303281247879916,
         0.06680807807757802,
         -0.0019973784510383813,
         0.0014462385475600744,
         -0.0008327925647531651,
         0.0005901484734169414,
         -0.0008327925647531615,
         0.001446238547560071,
         -0.0019973784510384125,
         0.06680807807757802,
         -0.006130328124787979,
         -0.0396601168484355,
         0.030829602494323694,
         0.02130006221960279,
         -0.05585986278328212,
         -0.03727842045539349,
         -0.11374642213604108,
         0.06588133973370418,
         0.02714274479548403,
         -0.08236052587484037,
         0.03590647631427181,
         0.11024056689940281,
         0.10583653081884818,
         -0.11556845821334953,
         0.050857217691347906,
         0.057610459961221064,
         -0.13892933729601523,
         0.06911643631629703,
         0.0430418104463983,
         -0.077563872326664,
         0.033968208233900676,
         0.039280301112596866,
         -0.07948376232253848,
         -0.062114333033850416,
         -0.10153513078500159,
         0.03412906206338188,
         0.06446613186660594,
         -0.08340709850758798,
         0.001378322078034162,
         0.11076572438993884,
         0.10172999464770335,
         0.05578379758645831,
         -0.07931468539905696,
         -0.0010336165927562757,
         0.08150110155501038,
         -0.058235328466763055,
         -0.09922630524702344,
         -0.09287608265983249,
         0.007239765109678472,
         0.056773743402232055,
         -0.04349935420088556,
         -0.030547483772482772,
         0.07878598811907031,
         0.055026021764625135,
         0.03726134207958293,
         -0.02265905652109697,
         -0.006231639387203855,
         0.022805706931706745,
         -0.006776671311227174,
         -0.040540125807576655,
         0.03595373357882989,
         -0.03975499427711028,
         0.018605541962377542,
         0.017417895624049273,
         -0.0448518501279937,
         -0.07766172624522996,
         0.13451405566024374,
         -0.15915917704686086,
         0.12995292388203253,
         -0.008575790084130548,
         -0.041445848740321936,
         0.01202131997559051,
         0.02674859340653998,
         -0.03591041589657461,
         0.007825813902811691,
         0.03295076912490824,
         0.05134831816749491,
         0.04779012234310765,
         -0.05864976054169778,
         0.0019489705570744763,
         0.055460067147783954,
         -0.04650547641515693,
         -0.050333131240635196,
         -0.09777421899099081,
         -0.0054674167856343684,
         0.08080829651195716,
         -0.06350972022966556,
         -0.027902011692331773,
         0.09401389757611564,
         0.04501932118979152,
         0.12361452074822957,
         -0.06670914000276283,
         -0.040813341979068087,
         0.10568521582712936,
         -0.05568493691204032,
         -0.10859549322830478,
         -0.11241517480602507,
         0.12337844283868664,
         -0.05569928455391467,
         -0.058468142993109117,
         0.1446002294054272,
         0.06341053394817538,
         -0.1098302665333109,
         0.12995292388203253,
         -0.10610611803124065},
        {0.0019117177030915922,
         -0.002341366452409949,
         0.001978815819132951,
         -0.0011424698458530611,
         -0.0013443051471340173,
         -0.0004909345344136415,
         0.002433332878765529,
         -0.0032886214717793567,
         0.002609100338493252,
         0.0057067136150267496,
         -0.004733868951123978,
         0.004837228084272408,
         -0.005936388167747059,
         0.006745015567605834,
         -0.005715397609014939,
         0.04432130056576362,
         -0.04537264045122145,
         0.042729591150256756,
         -0.03883814527060025,
         0.03468220446818524,
         -0.029748688558601605,
         0.021842015953750193,
         -0.04955272045812361,
         0.07078675046709394,
         -0.08461008547116143,
         0.09300140627974855,
         -0.09656260150501936,
         0.09414687696931681,
         -0.08009347130881563,
         0.03243987034147691,
         -0.05959791731136376,
         0.08848494388045564,
         -0.11947911090694155,
         0.15330472952037583,
         -0.19119974301780573,
         0.23494681548119048,
         -0.0023413664524099776,
         0.002867576554637437,
         -0.002423544525911572,
         0.0013992340844280963,
         -0.0011856591238679564,
         0.0021280242069611345,
         -0.0025959240894503554,
         0.0024012989376227794,
         -0.0015707096192063104,
         -0.007758784857855732,
         0.010950759667558962,
         -0.011674526573953004,
         0.010320014488089719,
         -0.00752461075628797,
         0.004065233327282927,
         -0.08375601266993828,
         0.07800211075927245,
         -0.07353188980415257,
         0.06729045645880403,
         -0.05746197879694522,
         0.043443830633184695,
         -0.02570729215208978,
         0.07123985478465729,
         -0.09460065792941973,
         0.11040678145659036,
         -0.1202747420336611,
         0.12216391859720926,
         -0.11250368169397296,
         0.08577622735491057,
         -0.03372162315794012,
         0.056611161307582016,
         -0.08026073936925604,
         0.10562529379483032,
         -0.13177825314786004,
         0.1561322940628978,
         -0.17448063392790655,
         0.004176886674900729,
         -0.006641986221588046,
         0.009085541032026445,
         -0.01207811197258148,
         0.015506451168923184,
         -0.017352637612342785,
         0.00449685131535154,
         -0.0034798127585316074,
         0.0013444110777640073,
         0.0003971692312333998,
         -0.0009839306183648737,
         0.011547227527433682,
         -0.015777769406136694,
         0.015492329383084398,
         -0.011926872597703116,
         0.006900788349641186,
         -0.002380483359239231,
         0.1262076739059753,
         -0.11548993981721521,
         0.10377250794517318,
         -0.08953690741486069,
         0.07213605802101113,
         -0.051766090984622704,
         0.02931441054589648,
         -0.08203736665474738,
         0.10956460268851882,
         -0.1239408747388411,
         0.12850267810601015,
         -0.12394087473884115,
         0.10956460268851882,
         -0.08203736665474737,
         0.02931441054589647,
         -0.05176609098462271,
         0.07213605802101115,
         -0.08953690741486069,
         0.10377250794517313,
         -0.11548993981721521,
         0.1262076739059753,
         -0.0023804833592392305,
         0.0069007883496411794,
         -0.011926872597703109,
         0.015492329383084407,
         -0.015777769406136687,
         0.01154722752743368,
         -0.0009839306183648728,
         0.0003971692312333989,
         0.0013444110777640036,
         -0.0034798127585316235,
         0.004496851315351541,
         -0.01735263761234281,
         0.015506451168923178,
         -0.012078111972581478,
         0.009085541032026447,
         -0.006641986221588033,
         0.004176886674900725,
         -0.17448063392790655,
         0.15613229406289783,
         -0.13177825314785999,
         0.10562529379483035,
         -0.08026073936925604,
         0.05661116130758203,
         -0.03372162315794012,
         0.08577622735491056,
         -0.11250368169397293,
         0.12216391859720926,
         -0.12027474203366112,
         0.11040678145659037,
         -0.09460065792941971,
         0.07123985478465726,
         -0.02570729215208977,
         0.04344383063318469,
         -0.057461978796945194,
         0.06729045645880403,
         -0.07353188980415258,
         0.07800211075927241,
         -0.08375601266993828,
         0.004065233327282934,
         -0.00752461075628796,
         0.010320014488089729,
         -0.011674526573953002,
         0.01095075966755897,
         -0.007758784857855734,
         -0.001570709619206304,
         0.0024012989376227816,
         -0.0025959240894503502,
         0.0021280242069611527,
         -0.0011856591238679592,
         0.0013992340844281,
         -0.0024235445259115675,
         0.002867576554637436,
         -0.0023413664524099707,
         0.2349468154811905,
         -0.19119974301780573,
         0.1533047295203758,
         -0.11947911090694156,
         0.08848494388045569,
         -0.059597917311363775,
         0.032439870341476926,
         -0.08009347130881561,
         0.0941468769693168,
         -0.09656260150501936,
         0.09300140627974854,
         -0.08461008547116144,
         0.07078675046709394,
         -0.04955272045812361,
         0.0218420159537502,
         -0.029748688558601615,
         0.03468220446818523,
         -0.03883814527060025,
         0.042729591150256756,
         -0.04537264045122145,
         0.04432130056576362,
         -0.00571539760901493,
         0.006745015567605839,
         -0.005936388167747064,
         0.0048372280842724005,
         -0.004733868951123973,
         0.005706713615026729,
         0.0026091003384932513,
         -0.0032886214717793537,
         0.002433332878765523,
         -0.0004909345344136361,
         -0.0013443051471340001,
         -0.0011424698458530685,
         0.0019788158191329027,
         -0.0023413664524099703,
         0.0019117177030916253},
        {0.18064892093237805,
         -0.2019716336333921,
         0.1322214713369863,
         -0.15328569240638037,
         0.031289310938737144,
         0.10577717706958903,
         -0.13740858372430326,
         0.09328670163752545,
         0.057126204699798365,
         -0.07933288280219182,
         -0.019710413199636036,
         0.10795837927188258,
         -0.04257935900177235,
         -0.06664723881643136,
         0.008814764755799101,
         0.0575778022783374,
         -0.025446034023019096,
         -0.06968683416725756,
         0.012903494352312719,
         0.04097409765787013,
         0.02707392032138284,
         -0.0293029886595109,
         -0.021901576452566723,
         0.03519716642792158,
         0.03657796832137062,
         -0.014426545259527954,
         -0.025185042159425967,
         -0.0014078866571168647,
         0.021810886305444973,
         -0.0014078866571168662,
         -0.025185042159425974,
         -0.014426545259527954,
         0.009444390809784726,
         0.009087869293935411,
         -0.005654962723765298,
         -0.00756599913815937,
         0.0069904561680841516,
         0.01057946652365382,
         0.0033316679156259036,
         -0.12515724375494863,
         0.025547615401063387,
         0.0863667034175061,
         -0.11219363880101478,
         0.11799938103165603,
         0.07225956837295137,
         -0.10034904120085102,
         -0.024931919733558815,
         0.13655774839978382,
         -0.07374961314478497,
         -0.11543640381423581,
         0.015267620413811512,
         0.09972767893423548,
         -0.04407382377899536,
         -0.12070113739631692,
         0.029799343751178275,
         0.09462562525029343,
         0.06252454074227551,
         -0.06767235356251677,
         -0.05057952424226631,
         0.08128437404749045,
         0.08447319942701181,
         -0.04562074178761327,
         -0.0796420961911515,
         -0.004452128523849801,
         0.06897207851218108,
         -0.004452128523849801,
         -0.07964209619115149,
         -0.04562074178761328,
         0.04626787683080684,
         0.04452128523849801,
         -0.02770354637536864,
         -0.03706567456565551,
         0.034246101362195094,
         0.05182858946761614,
         0.016321772771370962,
         -0.031164899666948576,
         -0.011379812366648626,
         0.025749575977880933,
         0.003942082639927226,
         -0.029805551301240633,
         -0.019042068233266117,
         0.05899969051582798,
         0.036129784186475666,
         -0.05017452060042549,
         -0.012465959866779407,
         0.06827887419989187,
         -0.05712620469979832,
         -0.08941665390372187,
         0.011826247919781673,
         0.0772487279336428,
         -0.03413943709994589,
         -0.09349469900084573,
         0.03160697706205067,
         0.10036563193274914,
         0.06631729012415633,
         -0.07177737015436378,
         -0.05364768687134378,
         0.08621509814022643,
         0.0895973582150454,
         -0.06451747176156374,
         -0.11263093256934921,
         -0.0062962605398565,
         0.09754124885698846,
         -0.0062962605398565,
         -0.11263093256934921,
         -0.06451747176156374,
         0.0895973582150454,
         0.08621509814022643,
         -0.053647686871343754,
         -0.07177737015436378,
         0.06631729012415631,
         0.10036563193274914,
         0.03160697706205067,
         -0.09349469900084573,
         -0.034139437099945893,
         0.07724872793364282,
         0.011826247919781673,
         -0.08941665390372187,
         -0.05712620469979832,
         0.06827887419989187,
         -0.012465959866779407,
         -0.05017452060042549,
         0.036129784186475666,
         0.05899969051582798,
         -0.019042068233266117,
         -0.029805551301240626,
         0.003942082639927226,
         0.025749575977880933,
         -0.01137981236664863,
         -0.031164899666948576,
         0.016321772771370962,
         0.05182858946761615,
         0.034246101362195094,
         -0.03706567456565551,
         -0.02770354637536865,
         0.044521285238498014,
         0.04626787683080684,
         -0.045620741787613266,
         -0.0796420961911515,
         -0.004452128523849801,
         0.06897207851218107,
         -0.004452128523849798,
         -0.07964209619115149,
         -0.045620741787613266,
         0.08447319942701181,
         0.08128437404749045,
         -0.05057952424226631,
         -0.06767235356251677,
         0.06252454074227551,
         0.09462562525029343,
         0.029799343751178275,
         -0.12070113739631687,
         -0.04407382377899537,
         0.0997276789342355,
         0.015267620413811508,
         -0.11543640381423578,
         -0.07374961314478497,
         0.13655774839978385,
         -0.024931919733558815,
         -0.10034904120085103,
         0.07225956837295142,
         0.117999381031656,
         -0.11219363880101478,
         0.0863667034175061,
         0.025547615401063387,
         -0.1251572437549487,
         0.0033316679156259106,
         0.010579466523653824,
         0.0069904561680841516,
         -0.007565999138159371,
         -0.005654962723765295,
         0.009087869293935411,
         0.009444390809784724,
         -0.014426545259527954,
         -0.025185042159425967,
         -0.0014078866571168636,
         0.021810886305444973,
         -0.0014078866571168643,
         -0.025185042159425963,
         -0.014426545259527957,
         0.03657796832137061,
         0.035197166427921596,
         -0.021901576452566723,
         -0.0293029886595109,
         0.02707392032138283,
         0.04097409765787012,
         0.012903494352312719,
         -0.06968683416725759,
         -0.025446034023019107,
         0.0575778022783374,
         0.0088147647557991,
         -0.06664723881643136,
         -0.04257935900177234,
         0.10795837927188255,
         -0.019710413199636033,
         -0.07933288280219182,
         0.05712620469979835,
         0.0932867016375255,
         -0.13740858372430328,
         0.105777177069589,
         0.031289310938737144,
         -0.15328569240638037,
         0.13222147133698622,
         -0.20197163363339124,
         0.18064892093237828},
        {-0.0011194243312134533,
         0.001679136496820166,
         -0.0016791364968202216,
         0.001119424331213703,
         -0.032490719142526076,
         0.05285319684958084,
         -0.061609028579134355,
         0.05581491524152643,
         -0.03623702950515011,
         0.08044350033653598,
         -0.07845626329619845,
         0.033843278390774244,
         0.027765750188360114,
         -0.07618117116107305,
         0.0825586678001246,
         -0.11224708060623811,
         0.041178278899369654,
         0.044555713449410915,
         -0.08263979349197999,
         0.05063324165182503,
         0.033818361857150855,
         -0.10957005151729939,
         0.10849671880093265,
         0.033950549703226224,
         -0.08771376190453771,
         0.045492577495370806,
         0.03714721599660926,
         -0.08587418503688296,
         0.04008622914785933,
         0.10065891935012407,
         -0.06987985002408761,
         -0.09286522817731127,
         0.054368923296450905,
         0.03334483860808697,
         -0.07650288706321383,
         0.04126194367815585,
         0.04461224135872725,
         -0.09006575278312054,
         -0.06092262624206549,
         0.09244235240911348,
         0.022985378153223688,
         -0.06822008149232062,
         0.036820958348793086,
         0.02718594917144891,
         -0.06504612043963333,
         0.029143126541055015,
         0.08059305912672143,
         -0.06987985002408763,
         0.031262981247242645,
         0.01698968121575412,
         -0.03940544561106413,
         0.023413020667316906,
         0.021186333134006956,
         -0.060922626242065514,
         0.0015831050712526067,
         -0.0023746576068789226,
         0.0023746576068789157,
         -0.001583105071252623,
         0.06328767854087584,
         -0.10085815854249101,
         0.11525993843754247,
         -0.10244126361374366,
         0.06529016566108439,
         -0.09799497713049869,
         0.09419634208867306,
         -0.039979226474661955,
         -0.03262771000970755,
         0.08804562212803858,
         -0.09410492026540547,
         0.08034566874040613,
         -0.030408182005208145,
         -0.028527246571654192,
         0.054095710222747125,
         -0.03278355421814577,
         -0.02202946637296057,
         0.06987270194924877,
         -0.03261097942749441,
         -0.0045267140217768245,
         0.019466824412661732,
         -0.01145324121876328,
         -0.005684829825061471,
         0.015532783274510128,
         -0.006419659443999096,
         -0.020093389894094118,
         -0.005199983740265043,
         -0.019956296000476447,
         0.007219421950991792,
         0.013609407294868703,
         -0.02250106522637068,
         0.011573155022774962,
         0.012535332839783874,
         -0.026289362981418304,
         -0.013116802488390908,
         0.057212491430728846,
         0.02901828678308572,
         -0.058440901617211875,
         0.027618624724965103,
         0.02794089123330506,
         -0.060476507193374225,
         0.030513936039934398,
         0.06275400587604438,
         -0.1066250072510602,
         0.03465620356011989,
         0.050408654037032576,
         -0.08739608063028122,
         0.0546664285754448,
         0.029906241650430664,
         -0.10583280801950247,
         0.10402501538092769,
         -0.10169093435806607,
         0.045601491307306084,
         0.031238467651055507,
         -0.0911758319448743,
         0.09927440677530702,
         -0.07596865767867526,
         0.11874598531656222,
         -0.1330907129673897,
         0.11600396689943278,
         -0.0725002482449718,
         0.034142836312081086,
         -0.03282464394650633,
         0.015496589722496507,
         0.0066851957720684375,
         -0.02285119577486133,
         0.024544651741917677,
         0.030569498850091914,
         -0.006154835604926938,
         -0.02148490156834925,
         0.032062384395533126,
         -0.018139351871708058,
         -0.013929420647477757,
         0.04197143330368453,
         -0.06319080607233407,
         -0.031842059481825384,
         0.0629912572516193,
         -0.02844350014183933,
         -0.031602989183139626,
         0.06514602032513825,
         -0.030805250573948117,
         -0.07004697222536797,
         0.04714974347934657,
         0.08100563033244271,
         -0.039983659909036025,
         -0.03765413160345339,
         0.07237083031735736,
         -0.0376541316034534,
         -0.03998365990903603,
         0.08100563033244272,
         0.047149743479346556,
         -0.07004697222536797,
         -0.030805250573948093,
         0.06514602032513825,
         -0.03160298918313962,
         -0.028443500141839325,
         0.0629912572516193,
         -0.03184205948182537,
         -0.06319080607233406,
         0.041971433303684504,
         -0.013929420647477741,
         -0.018139351871708065,
         0.032062384395533126,
         -0.021484901568349247,
         -0.006154835604926942,
         0.030569498850091918,
         0.024544651741917688,
         -0.02285119577486134,
         0.006685195772068409,
         0.015496589722496503,
         -0.03282464394650636,
         0.0341428363120811,
         -0.07250024824497175,
         0.11600396689943278,
         -0.1330907129673897,
         0.11874598531656223,
         -0.07596865767867526,
         0.09927440677530704,
         -0.0911758319448743,
         0.031238467651055507,
         0.04560149130730608,
         -0.10169093435806606,
         0.10402501538092765,
         -0.10583280801950246,
         0.029906241650430657,
         0.05466642857544478,
         -0.08739608063028119,
         0.05040865403703257,
         0.03465620356011989,
         -0.10662500725106022,
         0.06275400587604438,
         0.03051393603993439,
         -0.06047650719337419,
         0.02794089123330508,
         0.027618624724965093,
         -0.05844090161721188,
         0.02901828678308571,
         0.05721249143072882,
         -0.013116802488390901,
         -0.0262893629814183,
         0.012535332839783867,
         0.01157315502277496,
         -0.022501065226370694,
         0.0136094072948687,
         0.007219421950991774,
         -0.019956296000476444,
         -0.0051999837402650516,
         -0.020093389894094118,
         -0.006419659443999068,
         0.01553278327451012,
         -0.005684829825061483,
         -0.011453241218763278,
         0.01946682441266174,
         -0.004526714021776839,
         -0.032610979427494406,
         0.06987270194924879,
         -0.022029466372960587,
         -0.032783554218145786,
         0.0540957102227471,
         -0.02852724657165419,
         -0.030408182005208145,
         0.08034566874040615,
         -0.09410492026540547,
         0.0880456221280386,
         -0.032627710009707545,
         -0.03997922647466196,
         0.09419634208867306,
         -0.09799497713049866,
         0.06529016566108439,
         -0.10244126361374366,
         0.11525993843754248,
         -0.10085815854249106,
         0.06328767854087583,
         -0.001583105071252619,
         0.0023746576068789035,
         -0.0023746576068789152,
         0.0015831050712525854,
         -0.06092262624206553,
         0.02118633313400699,
         0.02341302066731687,
         -0.03940544561106413,
         0.0169896812157541,
         0.031262981247242624,
         -0.0698798500240877,
         0.08059305912672146,
         0.029143126541055053,
         -0.06504612043963333,
         0.027185949171448915,
         0.036820958348793086,
         -0.06822008149232062,
         0.02298537815322369,
         0.09244235240911348,
         -0.06092262624206547,
         -0.09006575278312053,
         0.04461224135872727,
         0.04126194367815584,
         -0.07650288706321384,
         0.033344838608086964,
         0.05436892329645092,
         -0.09286522817731127,
         -0.06987985002408763,
         0.10065891935012407,
         0.04008622914785933,
         -0.08587418503688296,
         0.03714721599660927,
         0.04549257749537082,
         -0.08771376190453774,
         0.03395054970322623,
         0.10849671880093265,
         -0.10957005151729939,
         0.033818361857150876,
         0.050633241651825034,
         -0.08263979349197999,
         0.04455571344941091,
         0.04117827889936962,
         -0.11224708060623813,
         0.08255866780012458,
         -0.07618117116107306,
         0.027765750188360118,
         0.03384327839077423,
         -0.07845626329619847,
         0.08044350033653598,
         -0.0362370295051501,
         0.05581491524152643,
         -0.06160902857913434,
         0.05285319684958061,
         -0.0324907191425261,
         0.0011194243312135305,
         -0.0016791364968203062,
         0.0016791364968203135,
         -0.0011194243312135064},
        {-0.004428533801541623,
         0.006642800702312324,
         -0.00664280070231249,
         0.004428533801541512,
         0.00879750312282775,
         -0.008051674239528905,
         0.002486939730043519,
         0.0036651248719943266,
         -0.00602320570879194,
         -0.013513593540649708,
         0.008170612796854448,
         -0.0006360097382380719,
         -0.001850929991805423,
         -0.001928443615273904,
         0.006933769489348424,
         0.008568775924554803,
         0.008513703594263941,
         -0.019941572277851465,
         0.02169067596992084,
         -0.018726652024284095,
         0.01759628479480582,
         -0.019039691315511788,
         0.019952539066012458,
         -0.03994315253708916,
         0.035115455689766886,
         -0.01599467751049995,
         -0.005695998459420947,
         0.024130350628458166,
         -0.039829081706755504,
         0.05286473952866586,
         -0.06437830463422407,
         0.034449496035205356,
         0.01084178176181895,
         -0.045957237451585684,
         0.06113112086350124,
         -0.055727422259327024,
         0.03159707163086899,
         0.013564862002336928,
         -0.09286197129533581,
         0.085164491945057,
         -0.09882780066942948,
         0.07759637496005478,
         -0.03516380140819257,
         -0.015982163795522305,
         0.06599364667886559,
         -0.10642683329767273,
         0.12284484115133852,
         -0.0643783046342241,
         0.10880407020243571,
         -0.14010827287183125,
         0.15515791912015509,
         -0.1528960312802781,
         0.1328592030620057,
         -0.09286197129533577,
         0.006262892563567973,
         -0.00939433884535196,
         0.009394338845351952,
         -0.006262892563567974,
         -0.006556118651444865,
         0.007234687492654677,
         -0.004652638205689465,
         0.0009717949290867175,
         0.0013658834452773907,
         0.008994845877466797,
         -0.011769944444369164,
         0.011136887750993073,
         -0.008206001171799728,
         0.004413477515020324,
         -0.001240448867984365,
         0.009506295441108252,
         -0.01819615834707043,
         0.03072705533764327,
         -0.04322623010411614,
         0.04962065984958665,
         -0.0448401887883092,
         0.027865297776788728,
         -0.06064594554218465,
         0.05913723254958414,
         -0.049857515762840095,
         0.029565823200572057,
         0.003960041714211323,
         -0.0450026718999856,
         0.07865936695320186,
         -0.08258915037262696,
         0.10834985595352574,
         -0.02656877224507328,
         -0.022763226869131233,
         0.0587640784034451,
         -0.08117686436568432,
         0.07976415060247267,
         -0.04370232564459692,
         -0.029024060447644603,
         0.12222795723908703,
         -0.11700244816213538,
         0.1001576631338635,
         -0.07067839425001499,
         0.03185561385130835,
         0.01781685320221949,
         -0.07227460410268795,
         0.11461613218975832,
         -0.11767860624134803,
         0.07148011239398216,
         -0.0893962924304458,
         0.09922593776185908,
         -0.10506057855896615,
         0.10256465020608732,
         -0.08558868806944912,
         0.0520152766240656,
         -0.017305184417219347,
         0.01882527986820788,
         -0.015848027942462314,
         0.012746269138669353,
         -0.011039927058956685,
         0.009098701995477937,
         -0.003864071371156797,
         0.0006858092259301743,
         0.0053724038409934975,
         -0.010161838896514837,
         0.009857238758033317,
         -0.0017700737823953684,
         0.01234056906299232,
         -0.020004438968373953,
         0.01910903832820838,
         -0.010093131292913626,
         -0.0005989336352507955,
         -0.032044916761783816,
         0.04261919762489059,
         -0.055575016036602656,
         0.06979358229360785,
         -0.0777051623990708,
         0.0710399615379638,
         -0.04611559105389396,
         0.09620273516978402,
         -0.08742957455693207,
         0.06272237336208489,
         -0.028280444325877285,
         -0.014255580203249357,
         0.06006326586523394,
         -0.09812228794044114,
         0.1082215234393736,
         -0.1277909613925254,
         0.028202010731333535,
         0.03758191171694956,
         -0.0749118482620346,
         0.0869984242897492,
         -0.0749118482620346,
         0.03758191171694955,
         0.028202010731333528,
         -0.12779096139252538,
         0.1082215234393736,
         -0.09812228794044113,
         0.06006326586523394,
         -0.014255580203249366,
         -0.028280444325877296,
         0.06272237336208489,
         -0.08742957455693208,
         0.09620273516978402,
         -0.04611559105389395,
         0.0710399615379638,
         -0.07770516239907081,
         0.06979358229360785,
         -0.055575016036602656,
         0.042619197624890595,
         -0.032044916761783795,
         -0.0005989336352508123,
         -0.01009313129291364,
         0.019109038328208407,
         -0.02000443896837397,
         0.012340569062992343,
         -0.0017700737823953601,
         0.009857238758033295,
         -0.010161838896514805,
         0.005372403840993494,
         0.0006858092259301862,
         -0.003864071371156809,
         0.009098701995477939,
         -0.011039927058956686,
         0.012746269138669372,
         -0.015848027942462307,
         0.018825279868207864,
         -0.017305184417219312,
         0.05201527662406559,
         -0.08558868806944914,
         0.10256465020608731,
         -0.10506057855896614,
         0.0992259377618591,
         -0.08939629243044579,
         0.07148011239398218,
         -0.11767860624134806,
         0.1146161321897583,
         -0.0722746041026879,
         0.017816853202219488,
         0.03185561385130834,
         -0.07067839425001497,
         0.10015766313386348,
         -0.11700244816213536,
         0.12222795723908704,
         -0.029024060447644603,
         -0.04370232564459691,
         0.07976415060247272,
         -0.08117686436568436,
         0.058764078403445115,
         -0.022763226869131216,
         -0.026568772245073282,
         0.10834985595352577,
         -0.08258915037262696,
         0.07865936695320187,
         -0.045002671899985594,
         0.003960041714211332,
         0.02956582320057205,
         -0.04985751576284011,
         0.05913723254958417,
         -0.060645945542184644,
         0.027865297776788728,
         -0.04484018878830922,
         0.049620659849586655,
         -0.04322623010411614,
         0.030727055337643264,
         -0.018196158347070453,
         0.009506295441108252,
         -0.0012404488679843713,
         0.0044134775150203144,
         -0.008206001171799706,
         0.01113688775099307,
         -0.011769944444369155,
         0.008994845877466781,
         0.0013658834452773918,
         0.0009717949290867185,
         -0.004652638205689459,
         0.007234687492654684,
         -0.00655611865144487,
         -0.0062628925635679735,
         0.009394338845351949,
         -0.009394338845351985,
         0.006262892563567951,
         -0.09286197129533579,
         0.1328592030620057,
         -0.15289603128027807,
         0.1551579191201551,
         -0.14010827287183125,
         0.10880407020243572,
         -0.06437830463422407,
         0.12284484115133854,
         -0.10642683329767275,
         0.06599364667886559,
         -0.01598216379552232,
         -0.035163801408192565,
         0.07759637496005477,
         -0.09882780066942948,
         0.08516449194505699,
         -0.09286197129533576,
         0.013564862002336918,
         0.031597071630869,
         -0.05572742225932701,
         0.06113112086350125,
         -0.04595723745158568,
         0.010841781761818929,
         0.034449496035205356,
         -0.06437830463422407,
         0.05286473952866589,
         -0.03982908170675551,
         0.024130350628458145,
         -0.00569599845942096,
         -0.015994677510499922,
         0.0351154556897669,
         -0.03994315253708914,
         0.019952539066012482,
         -0.019039691315511798,
         0.01759628479480583,
         -0.018726652024284085,
         0.02169067596992083,
         -0.01994157227785145,
         0.008513703594263945,
         0.008568775924554808,
         0.006933769489348441,
         -0.0019284436152738856,
         -0.001850929991805427,
         -0.0006360097382380758,
         0.008170612796854458,
         -0.0135135935406497,
         -0.006023205708791944,
         0.0036651248719943175,
         0.002486939730043529,
         -0.0080516742395285,
         0.008797503122827774,
         0.004428533801541694,
         -0.006642800702312572,
         0.00664280070231257,
         -0.004428533801541702},
        {0.14322297480788643,
         -0.18946618668626802,
         0.14322297480788643,
         -0.14322297480788682,
         0.0716114874039434,
         0.07161148740394341,
         -0.1432229748078868,
         0.1089353980936868,
         0.017224198789660826,
         -0.09114189305956422,
         0.017224198789660826,
         0.1089353980936868,
         -0.06889679515864304,
         -0.054467699046843364,
         0.04557094652978203,
         0.045570946529782046,
         -0.05446769904684335,
         -0.06889679515864303,
         0.03631179936456234,
         0.054467699046843496,
         -0.048035995387952515,
         0.05446769904684356,
         0.03631179936456234,
         -0.015190315509927381,
         -0.037319097377598316,
         -0.022785473264891096,
         0.024017997693976275,
         0.024017997693976296,
         -0.022785473264891068,
         -0.03731909737759833,
         -0.015190315509927381,
         0.004340090145693534,
         0.018445383119197533,
         0.02387049580131443,
         -0.001085022536423339,
         -0.021700450728467723,
         -0.0010850225364233378,
         0.02387049580131443,
         0.018445383119197536,
         0.004340090145693534,
         -0.0057413995965535855,
         -0.014105292973503965,
         -0.00861209939483038,
         0.009077949841140576,
         0.009077949841140567,
         -0.008612099394830389,
         -0.014105292973503969,
         -0.005741399596553586,
         0.004340090145693535,
         0.006510135218540307,
         -0.005741399596553579,
         0.006510135218540301,
         0.0043400901456935375,
         -0.10127393670836676,
         0.050636968354183395,
         0.050636968354183395,
         -0.10127393670836679,
         0.11645683913097231,
         0.01841344303788491,
         -0.09743478211739404,
         0.018413443037884916,
         0.11645683913097231,
         -0.097434782117394,
         -0.07702895870330195,
         0.0644470506325969,
         0.06444705063259691,
         -0.07702895870330195,
         -0.097434782117394,
         0.06495652141159604,
         0.09743478211739402,
         -0.08592940084346253,
         0.0974347821173941,
         0.06495652141159602,
         -0.03396657807986699,
         -0.08344803859524398,
         -0.05094986711980054,
         0.05370587552716411,
         0.053705875527164174,
         -0.050949867119800485,
         -0.08344803859524395,
         -0.03396657807986699,
         0.012275628691923253,
         0.05217142194067386,
         0.06751595780557781,
         -0.0030689071729806837,
         -0.06137814345961641,
         -0.003068907172980683,
         0.06751595780557781,
         0.05217142194067386,
         0.012275628691923253,
         -0.02148235021086566,
         -0.05277717364692172,
         -0.03222352531629848,
         0.03396657807986696,
         0.03396657807986695,
         -0.03222352531629852,
         -0.0527771736469217,
         -0.021482350210865652,
         0.02455125738384647,
         0.03682688607576974,
         -0.032478260705797964,
         0.03682688607576972,
         0.02455125738384647,
         -0.018413443037884843,
         -0.014557104891371525,
         0.012179347764674235,
         0.012179347764674235,
         -0.014557104891371525,
         -0.018413443037884843,
         0.05042729056592986,
         0.007973254720973027,
         -0.04219049826293248,
         0.007973254720973025,
         0.050427290565929865,
         -0.06378603776778395,
         -0.050427290565929817,
         0.042190498262932426,
         0.04219049826293242,
         -0.05042729056592982,
         -0.06378603776778395,
         0.05625399768390997,
         0.08438099652586495,
         -0.0744170440624145,
         0.084380996525865,
         0.05625399768390997,
         -0.03720852203120732,
         -0.09141274623635368,
         -0.05581278304681104,
         0.05883183899358488,
         0.058831838993584934,
         -0.05581278304681099,
         -0.09141274623635365,
         -0.037208522031207315,
         0.016809096855309985,
         0.07143866163506751,
         0.09245003270420486,
         -0.0042022742138273245,
         -0.08404548427655013,
         -0.004202274213827324,
         0.09245003270420486,
         0.0714386616350675,
         0.016809096855309985,
         -0.03720852203120732,
         -0.09141274623635368,
         -0.05581278304681099,
         0.058831838993584934,
         0.05883183899358488,
         -0.05581278304681104,
         -0.09141274623635366,
         -0.03720852203120732,
         0.05625399768390997,
         0.084380996525865,
         -0.0744170440624145,
         0.08438099652586495,
         0.056253997683909956,
         -0.06378603776778397,
         -0.050427290565929817,
         0.04219049826293242,
         0.04219049826293243,
         -0.050427290565929817,
         -0.06378603776778397,
         0.05042729056592986,
         0.007973254720973022,
         -0.04219049826293248,
         0.007973254720973025,
         0.050427290565929865,
         -0.018413443037884843,
         -0.014557104891371525,
         0.012179347764674235,
         0.012179347764674235,
         -0.014557104891371525,
         -0.018413443037884843,
         0.024551257383846472,
         0.03682688607576972,
         -0.032478260705797964,
         0.03682688607576973,
         0.024551257383846475,
         -0.021482350210865652,
         -0.0527771736469217,
         -0.03222352531629851,
         0.03396657807986694,
         0.03396657807986696,
         -0.03222352531629848,
         -0.05277717364692171,
         -0.02148235021086566,
         0.012275628691923252,
         0.05217142194067386,
         0.06751595780557784,
         -0.003068907172980683,
         -0.0613781434596164,
         -0.003068907172980683,
         0.06751595780557784,
         0.05217142194067386,
         0.012275628691923253,
         -0.033966578079866985,
         -0.08344803859524397,
         -0.050949867119800485,
         0.05370587552716416,
         0.053705875527164125,
         -0.05094986711980054,
         -0.08344803859524397,
         -0.03396657807986699,
         0.06495652141159604,
         0.09743478211739413,
         -0.08592940084346253,
         0.09743478211739402,
         0.06495652141159602,
         -0.097434782117394,
         -0.07702895870330195,
         0.0644470506325969,
         0.06444705063259691,
         -0.07702895870330195,
         -0.09743478211739401,
         0.11645683913097231,
         0.018413443037884912,
         -0.09743478211739406,
         0.018413443037884912,
         0.11645683913097231,
         -0.10127393670836679,
         0.05063696835418339,
         0.050636968354183395,
         -0.10127393670836679,
         0.004340090145693536,
         0.0065101352185403015,
         -0.0057413995965535786,
         0.006510135218540305,
         0.004340090145693535,
         -0.005741399596553586,
         -0.014105292973503972,
         -0.008612099394830387,
         0.00907794984114057,
         0.009077949841140576,
         -0.00861209939483038,
         -0.014105292973503969,
         -0.005741399596553586,
         0.004340090145693532,
         0.018445383119197536,
         0.023870495801314427,
         -0.0010850225364233375,
         -0.02170045072846772,
         -0.0010850225364233371,
         0.023870495801314427,
         0.018445383119197536,
         0.004340090145693534,
         -0.015190315509927381,
         -0.037319097377598316,
         -0.022785473264891068,
         0.024017997693976296,
         0.02401799769397628,
         -0.022785473264891096,
         -0.03731909737759834,
         -0.015190315509927381,
         0.03631179936456234,
         0.054467699046843544,
         -0.048035995387952515,
         0.05446769904684351,
         0.03631179936456234,
         -0.06889679515864304,
         -0.054467699046843336,
         0.045570946529782046,
         0.045570946529782046,
         -0.05446769904684331,
         -0.06889679515864305,
         0.10893539809368677,
         0.017224198789660826,
         -0.09114189305956422,
         0.017224198789660826,
         0.1089353980936868,
         -0.14322297480788676,
         0.07161148740394344,
         0.0716114874039434,
         -0.14322297480788682,
         0.14322297480788637,
         -0.1894661866862681,
         0.14322297480788637},
        {0.0009059592142721118,
         -0.0013589388214082683,
         0.001358938821408263,
         -0.0009059592142720563,
         0.0003924813871168213,
         -0.0018190389507222182,
         0.0034215351165865176,
         -0.004215981729653264,
         0.003424400828123842,
         0.015234642956408497,
         -0.024676807621521333,
         0.03155702275146159,
         -0.03497855786804812,
         0.03326479260581299,
         -0.024287173976970836,
         -0.05384314285453776,
         0.056676628740960515,
         -0.03824710169553668,
         0.007051962396537181,
         0.028288478923973015,
         -0.05693263213295281,
         0.06355601732063447,
         0.0965072659712677,
         -0.04253362883429053,
         -0.01951292632925187,
         0.060884415424496116,
         -0.06793637782103333,
         0.03616162804489062,
         0.028120705306207187,
         -0.09722122532039137,
         -0.10368088862827171,
         -0.04108001032862986,
         0.0893086121511979,
         -0.06979568582194604,
         0.012035657797157446,
         0.05241444917170622,
         -0.0885760772165969,
         0.05669019453147178,
         0.08914164344911525,
         0.1371569235102959,
         -0.06260087829964173,
         -0.023554007284439637,
         0.0807405536646615,
         -0.09081030743658629,
         0.04949726963498972,
         0.03245144891764336,
         -0.11792331001297457,
         -0.10368088862827174,
         0.11085451128527556,
         -0.07785067614475531,
         0.02279082637579184,
         0.036516564589409974,
         -0.08106206157783902,
         0.0891416434491153,
         -0.0012812198077805708,
         0.0019218297116708838,
         -0.0019218297116708589,
         0.00128121980778058,
         -0.002760051828593426,
         0.00500463502312427,
         -0.0064011060715411915,
         0.00628585483090484,
         -0.004380680938957348,
         -0.0331951730917937,
         0.05585985626853462,
         -0.07079761613047016,
         0.07482993393548053,
         -0.06598089363373605,
         0.04386368321102901,
         0.08807936951468158,
         -0.09309881397776403,
         0.06112555105332439,
         -0.008510495244410781,
         -0.04727325719272972,
         0.08727014889318815,
         -0.09059469886317215,
         -0.11506551044000396,
         0.05102450271632129,
         0.023123085752690495,
         -0.07077600404400308,
         0.07613276582972801,
         -0.037603618555138836,
         -0.031989239549148556,
         0.09849084783137661,
         0.08345849388137995,
         0.03023511047671074,
         -0.06848587496972924,
         0.05331048415190392,
         -0.0097628184398029,
         -0.03598787559933717,
         0.05857881495928148,
         -0.035375509906468414,
         -0.051606406308320196,
         -0.051874281393571954,
         0.026888067222599944,
         0.0026723450873528303,
         -0.021896395470078982,
         0.025775708468145662,
         -0.015890515049586842,
         -0.001058077535805818,
         0.01437694889349762,
         -0.021439178034926183,
         0.02009007602382881,
         -0.008510735564754611,
         -0.009714441807626475,
         0.030316272072046135,
         -0.046801764167130916,
         0.048655711675485123,
         0.06316842497561627,
         -0.10223294411520913,
         0.12573276031649125,
         -0.13000016436418535,
         0.11294404326653529,
         -0.07445891482964533,
         0.005526209965244338,
         -0.007628136257876234,
         0.007391360627031346,
         -0.005408998455136631,
         0.00271919800586892,
         0.055745606621448694,
         -0.09127747820169146,
         0.11158747964761771,
         -0.11281937308545628,
         0.09436950619085893,
         -0.05900489029970191,
         -0.0950622167370319,
         0.09759668238366835,
         -0.061941728710807255,
         0.0077564308503502155,
         0.04604702048594056,
         -0.08134167112768742,
         0.0809404933988085,
         0.07553645954111647,
         -0.03361098987552616,
         -0.011605475337808872,
         0.038884120487935554,
         -0.04158112666724234,
         0.021655910454535413,
         0.01185750934619169,
         -0.04143317518277364,
         -0.01950745886017313,
         -0.00027651526690250337,
         0.007045953954891127,
         -0.008162828606572387,
         0.008044322063614204,
         -0.008162828606572383,
         0.007045953954891128,
         -0.00027651526690250196,
         -0.019507458860173132,
         -0.04143317518277367,
         0.01185750934619169,
         0.021655910454535406,
         -0.04158112666724235,
         0.03888412048793556,
         -0.011605475337808873,
         -0.03361098987552619,
         0.07553645954111647,
         0.08094049339880849,
         -0.08134167112768742,
         0.04604702048594056,
         0.007756430850350217,
         -0.06194172871080724,
         0.09759668238366837,
         -0.09506221673703188,
         -0.0590048902997019,
         0.09436950619085893,
         -0.11281937308545628,
         0.11158747964761773,
         -0.09127747820169145,
         0.05574560662144869,
         0.002719198005868939,
         -0.0054089984551366314,
         0.007391360627031323,
         -0.00762813625787622,
         0.005526209965244332,
         -0.07445891482964533,
         0.11294404326653527,
         -0.13000016436418532,
         0.12573276031649125,
         -0.10223294411520913,
         0.06316842497561623,
         0.04865571167548513,
         -0.04680176416713095,
         0.03031627207204613,
         -0.009714441807626465,
         -0.008510735564754623,
         0.020090076023828816,
         -0.021439178034926183,
         0.014376948893497629,
         -0.0010580775358058272,
         -0.01589051504958684,
         0.025775708468145676,
         -0.021896395470078985,
         0.00267234508735283,
         0.026888067222599926,
         -0.05187428139357193,
         -0.051606406308320175,
         -0.03537550990646842,
         0.05857881495928149,
         -0.03598787559933718,
         -0.009762818439802905,
         0.053310484151903925,
         -0.06848587496972923,
         0.030235110476710746,
         0.08345849388137996,
         0.09849084783137661,
         -0.031989239549148535,
         -0.037603618555138815,
         0.07613276582972803,
         -0.07077600404400307,
         0.023123085752690502,
         0.05102450271632132,
         -0.11506551044000396,
         -0.09059469886317222,
         0.0872701488931882,
         -0.04727325719272972,
         -0.00851049524441078,
         0.06112555105332438,
         -0.09309881397776405,
         0.08807936951468158,
         0.043863683211029035,
         -0.06598089363373605,
         0.07482993393548056,
         -0.07079761613047017,
         0.05585985626853462,
         -0.03319517309179368,
         -0.0043806809389573525,
         0.0062858548309048185,
         -0.006401106071541192,
         0.005004635023124258,
         -0.0027600518285934407,
         0.001281219807780579,
         -0.0019218297116708647,
         0.0019218297116708873,
         -0.0012812198077805724,
         0.0891416434491153,
         -0.08106206157783903,
         0.036516564589409994,
         0.022790826375791842,
         -0.07785067614475527,
         0.11085451128527558,
         -0.10368088862827175,
         -0.11792331001297453,
         0.03245144891764339,
         0.04949726963498974,
         -0.09081030743658632,
         0.08074055366466151,
         -0.023554007284439637,
         -0.06260087829964177,
         0.13715692351029588,
         0.08914164344911525,
         0.05669019453147176,
         -0.0885760772165969,
         0.05241444917170621,
         0.012035657797157479,
         -0.06979568582194602,
         0.08930861215119794,
         -0.04108001032862986,
         -0.10368088862827174,
         -0.09722122532039133,
         0.02812070530620718,
         0.036161628044890634,
         -0.06793637782103334,
         0.060884415424496095,
         -0.019512926329251893,
         -0.042533628834290536,
         0.09650726597126771,
         0.06355601732063446,
         -0.05693263213295281,
         0.02828847892397299,
         0.007051962396537184,
         -0.0382471016955367,
         0.05667662874096053,
         -0.05384314285453777,
         -0.02428717397697081,
         0.03326479260581298,
         -0.03497855786804811,
         0.0315570227514616,
         -0.024676807621521347,
         0.015234642956408473,
         0.003424400828123856,
         -0.004215981729653267,
         0.0034215351165865185,
         -0.0018190389507216295,
         0.00039248138711687195,
         -0.0009059592142721674,
         0.001358938821408252,
         -0.0013589388214082523,
         0.0009059592142721772},
        {0.06811988606451169,
         -0.10217982909676726,
         0.1021798290967672,
         -0.06811988606451141,
         -0.11448627959787203,
         0.0909045632516948,
         -0.0008962569339154315,
         -0.08932371461305667,
         0.11348646313105734,
         0.12095449382602065,
         -0.019516427464691382,
         -0.07974949357288398,
         0.0806457505067994,
         0.017266840414358293,
         -0.11858322086806314,
         -0.09600398052274278,
         -0.047239876077385334,
         0.07978904384690104,
         -4.168964932587533e-05,
         -0.08060620023278242,
         0.05017314521121245,
         0.09154892659982132,
         0.05882843953850577,
         0.0739729109287119,
         -0.027414945499284946,
         -0.05520714705870937,
         0.05524883670803518,
         0.028192551611149304,
         -0.07775063220975192,
         -0.050647942767374596,
         -0.026767478712679708,
         -0.0614751805950791,
         -0.022402216293308356,
         0.04981716179259329,
         0.0025569365550228676,
         -0.054970585176656026,
         0.02677803356550676,
         0.061382896622372736,
         0.014589017528689298,
         0.035410045948982866,
         0.03470770188239937,
         -0.01085241821020801,
         -0.03138452000775981,
         0.02924523340178844,
         0.017652316516079923,
         -0.046793879093683405,
         -0.01929945612683692,
         -0.026767478712679642,
         -0.005293482113146471,
         0.011292516818231822,
         0.009136291200718188,
         -0.029127318788133634,
         0.02146990770999609,
         0.01458901752868923,
         -0.09633606673974222,
         0.14450410010961331,
         -0.14450410010961334,
         0.09633606673974227,
         0.061863521011034164,
         -0.049646781866404165,
         0.0016767431886159764,
         0.04668928487333792,
         -0.0599930356767964,
         -0.0005841247262073512,
         3.986103168532411e-05,
         0.0010086058806271945,
         -0.0020648548067222663,
         0.0026113027319145405,
         -0.0022104472548193296,
         -0.04191180183867811,
         -0.021783852952037462,
         0.03642345539211931,
         -0.0018080271771204587,
         -0.03239173759254602,
         0.01690160696111411,
         0.04684337568790961,
         0.04806261162297573,
         0.0705725841171223,
         -0.028734328527911763,
         -0.045717967348651044,
         0.04754463870374161,
         0.023335121568152505,
         -0.06204734834049333,
         -0.0580201157833549,
         -0.02641357990959354,
         -0.09117807012704941,
         -0.032712485529762726,
         0.07592465650328342,
         -0.005517302421212095,
         -0.06673536719392005,
         0.02884789303436251,
         0.08687233388324102,
         0.0406790278917608,
         0.05854783557739261,
         0.09198807626228837,
         -0.03785286622491963,
         -0.058396983606834534,
         0.062487659473895056,
         0.02678097302655517,
         -0.07739066614782678,
         -0.07133453506302671,
         -0.07747530129039491,
         -0.045837024504453434,
         0.07487333516592748,
         -0.008137076651538818,
         -0.060318038991917414,
         0.03587731276609461,
         0.08165052828841227,
         0.06426851133559819,
         -0.009289778641428333,
         -0.04463183563139448,
         0.04574966442380517,
         0.006484050640071727,
         -0.06131101434253193,
         0.10445094849812236,
         -0.0817219694122154,
         -0.0019361362626186432,
         0.08513699278236408,
         -0.10661079892059716,
         -0.11205455455708076,
         0.01914747803675704,
         0.07139183664587424,
         -0.07106914726877113,
         -0.019957421945185096,
         0.11290831039961799,
         0.07360510392509756,
         0.038332453279305366,
         -0.0649896180328679,
         0.004961071737674703,
         0.05588519629729657,
         -0.03148960205349232,
         -0.077306499736698,
         -0.023728587049135386,
         -0.042721000629491426,
         0.019237024256681497,
         0.023682922239071025,
         -0.02739911086754222,
         -0.009282588117822442,
         0.029917927952356187,
         0.03437531571298338,
         -0.007273545047130856,
         0.003168292775829498,
         0.0016924681523097476,
         -0.005380299860077123,
         0.006738139621146872,
         -0.005380299860077131,
         0.001692468152309751,
         0.003168292775829488,
         -0.007273545047130858,
         0.034375315712983356,
         0.029917927952356132,
         -0.009282588117822439,
         -0.027399110867542216,
         0.023682922239071032,
         0.019237024256681497,
         -0.04272100062949141,
         -0.023728587049135375,
         -0.077306499736698,
         -0.03148960205349231,
         0.055885196297296574,
         0.004961071737674681,
         -0.0649896180328679,
         0.03833245327930537,
         0.07360510392509753,
         0.1129083103996179,
         -0.019957421945185093,
         -0.07106914726877114,
         0.07139183664587424,
         0.019147478036757048,
         -0.11205455455708077,
         -0.10661079892059716,
         0.0851369927823641,
         -0.0019361362626186397,
         -0.08172196941221542,
         0.10445094849812238,
         -0.06131101434253192,
         0.0064840506400717255,
         0.04574966442380519,
         -0.04463183563139447,
         -0.009289778641428319,
         0.06426851133559819,
         0.08165052828841227,
         0.035877312766094606,
         -0.060318038991917414,
         -0.00813707665153883,
         0.07487333516592748,
         -0.04583702450445345,
         -0.07747530129039491,
         -0.07133453506302677,
         -0.07739066614782676,
         0.026780973026555167,
         0.06248765947389505,
         -0.05839698360683454,
         -0.03785286622491961,
         0.0919880762622884,
         0.05854783557739262,
         0.04067902789176083,
         0.08687233388324103,
         0.02884789303436253,
         -0.06673536719392005,
         -0.005517302421212075,
         0.07592465650328342,
         -0.032712485529762705,
         -0.09117807012704941,
         -0.026413579909593535,
         -0.0580201157833549,
         -0.06204734834049335,
         0.023335121568152536,
         0.04754463870374162,
         -0.04571796734865102,
         -0.028734328527911752,
         0.07057258411712232,
         0.048062611622975725,
         0.04684337568790965,
         0.01690160696111419,
         -0.03239173759254603,
         -0.001808027177120438,
         0.03642345539211931,
         -0.02178385295203744,
         -0.04191180183867808,
         -0.002210447254819339,
         0.002611302731914546,
         -0.0020648548067222806,
         0.0010086058806272028,
         3.9861031685318015e-05,
         -0.000584124726207352,
         -0.05999303567679642,
         0.04668928487333792,
         0.0016767431886159352,
         -0.049646781866404185,
         0.061863521011034185,
         0.09633606673974222,
         -0.1445041001096133,
         0.14450410010961334,
         -0.09633606673974222,
         0.014589017528689237,
         0.021469907709996135,
         -0.029127318788133644,
         0.009136291200718204,
         0.011292516818231842,
         -0.005293482113146461,
         -0.026767478712679628,
         -0.01929945612683691,
         -0.0467938790936834,
         0.017652316516079937,
         0.029245233401788442,
         -0.03138452000775982,
         -0.010852418210208024,
         0.03470770188239937,
         0.035410045948982845,
         0.014589017528689277,
         0.06138289662237272,
         0.026778033565506752,
         -0.05497058517665601,
         0.0025569365550228776,
         0.04981716179259329,
         -0.02240221629330835,
         -0.0614751805950791,
         -0.02676747871267971,
         -0.050647942767374596,
         -0.07775063220975188,
         0.02819255161114931,
         0.05524883670803519,
         -0.05520714705870932,
         -0.027414945499284946,
         0.07397291092871192,
         0.05882843953850578,
         0.09154892659982129,
         0.050173145211212404,
         -0.0806062002327824,
         -4.16896493258617e-05,
         0.07978904384690107,
         -0.04723987607738535,
         -0.09600398052274282,
         -0.11858322086806314,
         0.01726684041435829,
         0.08064575050679935,
         -0.07974949357288401,
         -0.01951642746469134,
         0.1209544938260206,
         0.1134864631310573,
         -0.08932371461305669,
         -0.0008962569339154378,
         0.09090456325169499,
         -0.11448627959787197,
         -0.06811988606451154,
         0.10217982909676734,
         -0.10217982909676733,
         0.0681198860645115},
        {-0.00398222629958177,
         0.003982226299581736,
         0.012862611289770554,
         -0.011464527724970487,
         0.004898158690606955,
         -0.02025734657471518,
         0.010457734930127447,
         0.002101025962091607,
         -0.006383808395851134,
         0.02305482318577723,
         -0.003956229363785514,
         -0.007122042512861835,
         0.004400479604250122,
         0.0032721994272127816,
         -0.08083590323578074,
         0.07459505358651365,
         -0.07775855769149484,
         0.08426006325783683,
         -0.08093563214369778,
         0.059420271654249485,
         0.1805380492552171,
         -0.09970214601943622,
         0.04192106596943277,
         0.01306253746950865,
         -0.0726433995823326,
         0.1353358706637948,
         -0.19475614231804442,
         0.0039822262995818135,
         -0.003982226299581785,
         -0.011464527724970471,
         0.014800641650314611,
         -0.011464527724970471,
         0.010457734930127522,
         -0.012851440209345134,
         0.006931183549219305,
         0.0021010259620918904,
         -0.003956229363785526,
         0.011062829226950127,
         -0.0061412014813686565,
         -0.0028107089519139013,
         0.0044004796042501045,
         0.07459505358651364,
         -0.11376167004699213,
         0.11556542558148232,
         -0.10438817954337018,
         0.09499203443794753,
         -0.08093563214369777,
         -0.09970214601943629,
         0.08423624917187773,
         -0.02825565917488907,
         -0.022257054817273667,
         0.05796912715912182,
         -0.09026869051560714,
         0.13533587066379482,
         -0.08083590323578073,
         0.0745950535865137,
         -0.07775855769149483,
         0.08426006325783687,
         -0.08093563214369774,
         0.05942027165424948,
         0.004898158690606966,
         -0.011464527724970485,
         0.01286261128977057,
         0.0021010259620918943,
         0.0069311835492193085,
         -0.012851440209345158,
         0.01045773493012753,
         -0.00712204251286184,
         -0.0061412014813686504,
         0.012647605823185313,
         -0.006141201481368655,
         -0.007122042512861839,
         -0.07775855769149483,
         0.11556542558148239,
         -0.13093106098121554,
         0.12388957946057984,
         -0.10438817954337021,
         0.0842600632578369,
         0.04192106596943278,
         -0.02825565917488907,
         0.015421748304556298,
         0.010012995245555165,
         -0.03860964025146296,
         0.05796912715912181,
         -0.0726433995823326,
         0.07459505358651367,
         -0.1137616700469921,
         0.11556542558148233,
         -0.10438817954337022,
         0.09499203443794756,
         -0.08093563214369777,
         0.023054823185777246,
         -0.003956229363785508,
         -0.007122042512861835,
         0.00440047960425011,
         0.00327219942721279,
         -0.0063838083958511335,
         0.0021010259620918826,
         0.01045773493012753,
         -0.02025734657471516,
         0.004400479604250094,
         -0.002810708951913901,
         -0.006141201481368651,
         0.0110628292269501,
         -0.003956229363785515,
         0.08426006325783691,
         -0.10438817954337022,
         0.1238895794605798,
         -0.1309310609812155,
         0.11556542558148236,
         -0.07775855769149488,
         0.013062537469508657,
         -0.022257054817273667,
         0.010012995245555172,
         -0.00297151372491943,
         0.010012995245555165,
         -0.02225705481727366,
         0.013062537469508653,
         -0.07775855769149488,
         0.11556542558148236,
         -0.1309310609812155,
         0.12388957946057981,
         -0.10438817954337022,
         0.08426006325783689,
         -0.003956229363785515,
         0.011062829226950099,
         -0.006141201481368667,
         -0.002810708951913906,
         0.0044004796042500975,
         -0.020257346574715167,
         0.010457734930127532,
         0.0021010259620918743,
         -0.006383808395851137,
         0.0032721994272127877,
         0.004400479604250105,
         -0.007122042512861837,
         -0.003956229363785509,
         0.023054823185777253,
         -0.0809356321436978,
         0.09499203443794753,
         -0.10438817954337021,
         0.1155654255814823,
         -0.11376167004699211,
         0.07459505358651367,
         -0.07264339958233261,
         0.057969127159121794,
         -0.03860964025146294,
         0.010012995245555163,
         0.015421748304556303,
         -0.028255659174889064,
         0.041921065969432784,
         0.08426006325783685,
         -0.10438817954337025,
         0.1238895794605798,
         -0.13093106098121554,
         0.11556542558148238,
         -0.07775855769149488,
         -0.0071220425128618444,
         -0.006141201481368668,
         0.012647605823185337,
         -0.006141201481368654,
         -0.007122042512861842,
         0.010457734930127522,
         -0.01285144020934513,
         0.006931183549219304,
         0.0021010259620918804,
         0.012862611289770566,
         -0.011464527724970476,
         0.004898158690606977,
         0.05942027165424948,
         -0.08093563214369777,
         0.08426006325783687,
         -0.07775855769149484,
         0.07459505358651368,
         -0.0808359032357807,
         0.13533587066379482,
         -0.09026869051560711,
         0.05796912715912179,
         -0.022257054817273657,
         -0.02825565917488909,
         0.08423624917187775,
         -0.09970214601943628,
         -0.08093563214369776,
         0.09499203443794753,
         -0.10438817954337018,
         0.1155654255814823,
         -0.11376167004699214,
         0.07459505358651365,
         0.004400479604250102,
         -0.0028107089519139148,
         -0.006141201481368663,
         0.0110628292269501,
         -0.00395622936378552,
         0.002101025962091885,
         0.006931183549219316,
         -0.012851440209345132,
         0.010457734930127529,
         -0.011464527724970471,
         0.014800641650314614,
         -0.011464527724970471,
         -0.003982226299581781,
         0.003982226299581814,
         -0.19475614231804442,
         0.13533587066379468,
         -0.0726433995823326,
         0.013062537469508636,
         0.04192106596943277,
         -0.09970214601943621,
         0.18053804925521702,
         0.059420271654249485,
         -0.08093563214369778,
         0.08426006325783685,
         -0.07775855769149487,
         0.07459505358651367,
         -0.0808359032357807,
         0.0032721994272127885,
         0.004400479604250108,
         -0.007122042512861831,
         -0.003956229363785506,
         0.023054823185777243,
         -0.006383808395851132,
         0.002101025962091874,
         0.010457734930127532,
         -0.020257346574715167,
         0.004898158690606974,
         -0.011464527724970471,
         0.012862611289770561,
         0.0039822262995818205,
         -0.003982226299581798},
        {-0.005488504815743418,
         0.00548850481574336,
         0.09589081967436314,
         -0.11670888663534451,
         0.08491381004287657,
         -0.13845529190210296,
         0.06019525389972279,
         0.06765292584326002,
         -0.13275165267375622,
         0.11598730997658338,
         0.0317745247582234,
         -0.10074784475942862,
         0.024316852814686127,
         0.11555704115137648,
         -0.056435280489587986,
         -0.07688133947866202,
         0.05244476300912794,
         0.03952501564881812,
         -0.05827938578456486,
         -0.07041402303721299,
         0.0005370464124116621,
         0.05589823407717634,
         0.0036537954098189813,
         -0.040737842971294735,
         0.012789436379511066,
         0.03235358173465231,
         0.03806044130256069,
         0.005488504815743302,
         -0.005488504815743336,
         -0.11670888663534458,
         0.1506705247643662,
         -0.11670888663534458,
         0.0601952538997228,
         -0.030349239365476715,
         -0.02991897054026979,
         0.06765292584326005,
         0.03177452475822335,
         0.008390383595583958,
         -0.0225723218905252,
         0.002686744367237208,
         0.024316852814686107,
         -0.07688133947866199,
         -0.06166989134929693,
         0.033752335454509126,
         0.06005947065533753,
         -0.0747079006725301,
         -0.058279385784564854,
         0.055898234077176326,
         0.09979042889073722,
         0.02143149194555492,
         -0.089327065335224,
         0.006552113960527134,
         0.11329880482616636,
         0.03235358173465231,
         -0.05643528048958799,
         -0.07688133947866198,
         0.05244476300912794,
         0.039525015648818135,
         -0.058279385784564895,
         -0.070414023037213,
         0.08491381004287651,
         -0.11670888663534455,
         0.09589081967436311,
         0.06765292584326006,
         -0.02991897054026979,
         -0.030349239365476705,
         0.06019525389972278,
         -0.10074784475942863,
         -0.02257232189052526,
         0.08499494965516316,
         -0.022572321890525257,
         -0.10074784475942862,
         0.052444763009127975,
         0.033752335454509196,
         -0.020637474839999392,
         -0.0437518583573165,
         0.06005947065533755,
         0.039525015648818135,
         0.003653795409818991,
         0.021431491945554965,
         0.0032645684099098086,
         -0.013438619398103783,
         0.002363932972506996,
         0.006552113960527141,
         0.012789436379511056,
         -0.07688133947866196,
         -0.061669891349296846,
         0.03375233545450914,
         0.06005947065533754,
         -0.07470790067253015,
         -0.05827938578456486,
         0.11598730997658344,
         0.03177452475822337,
         -0.10074784475942863,
         0.024316852814686145,
         0.11555704115137647,
         -0.1327516526737562,
         0.06765292584326009,
         0.06019525389972279,
         -0.13845529190210304,
         0.024316852814686124,
         0.00268674436723718,
         -0.02257232189052522,
         0.008390383595583969,
         0.031774524758223344,
         0.03952501564881814,
         0.0600594706553376,
         -0.04375185835731651,
         -0.020637474839999396,
         0.03375233545450914,
         0.052444763009127954,
         -0.040737842971294735,
         -0.08932706533522404,
         -0.013438619398103754,
         0.07782795259541946,
         -0.013438619398103748,
         -0.08932706533522404,
         -0.040737842971294735,
         0.052444763009127975,
         0.03375233545450913,
         -0.020637474839999403,
         -0.043751858357316493,
         0.0600594706553376,
         0.03952501564881814,
         0.03177452475822332,
         0.008390383595583967,
         -0.022572321890525222,
         0.002686744367237189,
         0.024316852814686124,
         -0.138455291902103,
         0.060195253899722787,
         0.06765292584326005,
         -0.13275165267375622,
         0.11555704115137647,
         0.02431685281468615,
         -0.10074784475942863,
         0.03177452475822337,
         0.11598730997658341,
         -0.05827938578456486,
         -0.07470790067253016,
         0.06005947065533753,
         0.03375233545450915,
         -0.061669891349296825,
         -0.07688133947866196,
         0.012789436379511077,
         0.006552113960527138,
         0.002363932972506999,
         -0.013438619398103776,
         0.0032645684099098125,
         0.021431491945554937,
         0.0036537954098189896,
         0.039525015648818135,
         0.06005947065533754,
         -0.043751858357316493,
         -0.020637474839999396,
         0.033752335454509196,
         0.05244476300912797,
         -0.1007478447594286,
         -0.02257232189052525,
         0.08499494965516317,
         -0.022572321890525257,
         -0.1007478447594286,
         0.06019525389972278,
         -0.030349239365476708,
         -0.029918970540269794,
         0.06765292584326002,
         0.09589081967436311,
         -0.11670888663534454,
         0.0849138100428765,
         -0.07041402303721302,
         -0.058279385784564916,
         0.039525015648818114,
         0.052444763009127954,
         -0.07688133947866198,
         -0.056435280489588,
         0.03235358173465232,
         0.11329880482616637,
         0.006552113960527128,
         -0.08932706533522401,
         0.02143149194555493,
         0.09979042889073723,
         0.055898234077176326,
         -0.05827938578456487,
         -0.0747079006725301,
         0.06005947065533754,
         0.03375233545450914,
         -0.061669891349296936,
         -0.07688133947866198,
         0.024316852814686117,
         0.0026867443672372307,
         -0.02257232189052521,
         0.008390383595583972,
         0.03177452475822334,
         0.06765292584326002,
         -0.029918970540269783,
         -0.030349239365476743,
         0.06019525389972278,
         -0.11670888663534462,
         0.1506705247643662,
         -0.11670888663534462,
         -0.005488504815743324,
         0.005488504815743344,
         0.0380604413025607,
         0.03235358173465233,
         0.012789436379511075,
         -0.040737842971294735,
         0.0036537954098189852,
         0.05589823407717632,
         0.0005370464124116538,
         -0.070414023037213,
         -0.05827938578456484,
         0.03952501564881812,
         0.052444763009127954,
         -0.076881339478662,
         -0.05643528048958798,
         0.11555704115137647,
         0.024316852814686152,
         -0.1007478447594286,
         0.03177452475822337,
         0.11598730997658342,
         -0.1327516526737562,
         0.06765292584326006,
         0.060195253899722787,
         -0.138455291902103,
         0.0849138100428765,
         -0.11670888663534452,
         0.09589081967436311,
         0.005488504815743355,
         -0.0054885048157433},
        {0.27735009811261424,
         -0.13867504905630712,
         -0.13867504905630745,
         0.06303411320741231,
         0.09765202827810443,
         0.06303411320741231,
         -0.02521364528296497,
         -0.05348621867405017,
         -0.053486218674050165,
         -0.025213645282964967,
         0.008404548427654993,
         0.023771652744022306,
         0.03255067609270149,
         0.02377165274402233,
         0.008404548427654996,
         -0.0021011371069137564,
         -0.008137669023175373,
         -0.014857282965013945,
         -0.014857282965013947,
         -0.00813766902317537,
         -0.002101137106913753,
         0.000300162443844806,
         0.0018009746630689221,
         0.004502436657672328,
         0.0060032488768964175,
         0.004502436657672316,
         0.001800974663068931,
         0.00030016244384481315,
         -0.13867504905630743,
         -0.13867504905630745,
         0.09765202827810439,
         0.15128187169778978,
         0.09765202827810439,
         -0.05348621867405018,
         -0.11346140377334227,
         -0.11346140377334223,
         -0.053486218674050186,
         0.023771652744022317,
         0.06723638742123991,
         0.09206721518942426,
         0.06723638742123997,
         0.02377165274402232,
         -0.00813766902317537,
         -0.031517056603706156,
         -0.05754200949339013,
         -0.05754200949339012,
         -0.031517056603706156,
         -0.008137669023175375,
         0.00180097466306892,
         0.010805847978413574,
         0.0270146199460339,
         0.03601949326137858,
         0.027014619946033908,
         0.010805847978413574,
         0.001800974663068931,
         -0.0021011371069137538,
         -0.008137669023175373,
         -0.014857282965013941,
         -0.014857282965013952,
         -0.008137669023175377,
         -0.0021011371069137533,
         0.06303411320741233,
         0.0976520282781044,
         0.06303411320741231,
         -0.05348621867405018,
         -0.11346140377334223,
         -0.11346140377334227,
         -0.05348621867405018,
         0.03255067609270152,
         0.09206721518942429,
         0.12606822641482493,
         0.09206721518942437,
         0.03255067609270152,
         -0.014857282965013941,
         -0.05754200949339013,
         -0.10505685534568737,
         -0.10505685534568736,
         -0.05754200949339012,
         -0.014857282965013945,
         0.004502436657672319,
         0.027014619946033908,
         0.06753654986508473,
         0.09004873315344633,
         0.0675365498650847,
         0.0270146199460339,
         0.004502436657672316,
         -0.008137669023175371,
         -0.03151705660370616,
         -0.05754200949339012,
         -0.057542009493390105,
         -0.03151705660370617,
         -0.008137669023175375,
         0.008404548427654993,
         0.02377165274402232,
         0.032550676092701486,
         0.02377165274402231,
         0.00840454842765499,
         -0.025213645282964957,
         -0.05348621867405018,
         -0.05348621867405016,
         -0.025213645282964957,
         0.02377165274402232,
         0.0672363874212399,
         0.09206721518942426,
         0.06723638742123998,
         0.023771652744022324,
         -0.014857282965013947,
         -0.05754200949339011,
         -0.10505685534568736,
         -0.10505685534568739,
         -0.05754200949339012,
         -0.014857282965013941,
         0.006003248876896424,
         0.03601949326137858,
         0.09004873315344636,
         0.12006497753792855,
         0.09004873315344634,
         0.03601949326137858,
         0.006003248876896425,
         -0.014857282965013945,
         -0.05754200949339012,
         -0.10505685534568737,
         -0.10505685534568736,
         -0.05754200949339011,
         -0.014857282965013945,
         0.023771652744022324,
         0.06723638742123998,
         0.09206721518942426,
         0.0672363874212399,
         0.02377165274402232,
         -0.025213645282964964,
         -0.05348621867405016,
         -0.053486218674050165,
         -0.025213645282964957,
         0.008404548427654993,
         0.023771652744022303,
         0.032550676092701486,
         0.023771652744022327,
         0.008404548427654993,
         -0.00813766902317537,
         -0.03151705660370616,
         -0.057542009493390105,
         -0.05754200949339012,
         -0.031517056603706156,
         -0.008137669023175375,
         0.004502436657672317,
         0.0270146199460339,
         0.06753654986508471,
         0.09004873315344633,
         0.06753654986508473,
         0.0270146199460339,
         0.00450243665767232,
         -0.014857282965013945,
         -0.05754200949339011,
         -0.10505685534568736,
         -0.10505685534568739,
         -0.05754200949339013,
         -0.014857282965013945,
         0.03255067609270152,
         0.09206721518942439,
         0.1260682264148249,
         0.0920672151894243,
         0.03255067609270152,
         -0.05348621867405018,
         -0.11346140377334227,
         -0.11346140377334223,
         -0.053486218674050165,
         0.06303411320741231,
         0.0976520282781044,
         0.06303411320741231,
         -0.0021011371069137533,
         -0.008137669023175366,
         -0.014857282965013945,
         -0.014857282965013952,
         -0.00813766902317537,
         -0.002101137106913752,
         0.0018009746630689276,
         0.010805847978413574,
         0.027014619946033904,
         0.03601949326137857,
         0.0270146199460339,
         0.010805847978413568,
         0.0018009746630689276,
         -0.008137669023175373,
         -0.031517056603706156,
         -0.057542009493390105,
         -0.05754200949339012,
         -0.031517056603706156,
         -0.008137669023175373,
         0.023771652744022324,
         0.06723638742123998,
         0.09206721518942426,
         0.06723638742123993,
         0.023771652744022317,
         -0.053486218674050165,
         -0.11346140377334224,
         -0.11346140377334224,
         -0.05348621867405018,
         0.0976520282781044,
         0.15128187169778975,
         0.0976520282781044,
         -0.1386750490563074,
         -0.13867504905630743,
         0.00030016244384482404,
         0.0018009746630689254,
         0.004502436657672318,
         0.006003248876896424,
         0.00450243665767232,
         0.0018009746630689271,
         0.0003001624438448237,
         -0.0021011371069137533,
         -0.00813766902317537,
         -0.014857282965013945,
         -0.014857282965013952,
         -0.008137669023175365,
         -0.0021011371069137507,
         0.00840454842765499,
         0.023771652744022327,
         0.03255067609270149,
         0.023771652744022306,
         0.008404548427654989,
         -0.025213645282964957,
         -0.05348621867405018,
         -0.05348621867405016,
         -0.025213645282964964,
         0.06303411320741231,
         0.09765202827810443,
         0.06303411320741233,
         -0.13867504905630743,
         -0.1386750490563074,
         0.27735009811261424},
        {-0.012945581457426357,
         0.012945581457426246,
         0.012948128928232258,
         -3.288770668788063e-06,
         -0.012943033986620358,
         0.0014064306453281383,
         -0.02030041283082175,
         0.020304015498585334,
         -0.0014140730577460207,
         0.013438275016631807,
         -0.02099358407658041,
         0.0452353071914654,
         -0.0615980124059874,
         0.044970445337632864,
         -0.058645609514846944,
         0.05836241787933856,
         -0.042939241489532626,
         0.0016452445821305047,
         0.05472913886999391,
         -0.0873634540167847,
         0.1920319513976901,
         -0.13338634188284315,
         0.08817900738462787,
         -0.057816378548372634,
         0.056653014947637644,
         -0.09904602362678958,
         0.1864094776435742,
         0.012945581457426329,
         -0.012945581457426327,
         -3.2887706688113518e-06,
         4.2457846766133365e-06,
         -3.2887706688104963e-06,
         -0.020300412830821724,
         0.015765236003565216,
         -0.015766934317435855,
         0.02030401549858528,
         -0.020993584076580425,
         0.05699209982571259,
         -0.06397703595236699,
         0.059812603528786805,
         -0.06159801240598739,
         0.05836241787933853,
         -0.059094421189737276,
         0.018564537969562932,
         0.013426305518662248,
         -0.028512715243112417,
         0.05472913886999392,
         -0.13338634188284315,
         0.11668639390066476,
         -0.10279930720914265,
         0.11621490901941332,
         -0.1296347566143606,
         0.11575446317832114,
         -0.09904602362678956,
         -0.05864560951484696,
         0.05836241787933852,
         -0.04293924148953265,
         0.0016452445821305266,
         0.05472913886999392,
         -0.08736345401678465,
         -0.01294303398662034,
         -3.2887706688373756e-06,
         0.012948128928232282,
         0.020304015498585286,
         -0.015766934317435855,
         0.015765236003565195,
         -0.020300412830821745,
         0.04523530719146544,
         -0.063977035952367,
         0.07008502982073145,
         -0.06397703595236699,
         0.04523530719146545,
         -0.04293924148953262,
         0.018564537969562922,
         -0.0072452007500333334,
         -0.00443705281498077,
         0.013426305518662238,
         0.0016452445821305314,
         0.08817900738462778,
         -0.10279930720914264,
         0.14155729596769848,
         -0.1512591222436497,
         0.14343969106441817,
         -0.12963475661436052,
         0.0566530149476376,
         0.058362417879338525,
         -0.05909442118973728,
         0.018564537969562932,
         0.01342630551866226,
         -0.028512715243112417,
         0.05472913886999391,
         0.013438275016631782,
         -0.020993584076580425,
         0.04523530719146542,
         -0.06159801240598741,
         0.04497044533763288,
         -0.0014140730577460662,
         0.020304015498585275,
         -0.020300412830821728,
         0.0014064306453281572,
         -0.061598012405987446,
         0.059812603528786756,
         -0.06397703595236699,
         0.056992099825712544,
         -0.02099358407658042,
         0.0016452445821305219,
         0.013426305518662232,
         -0.004437052814980776,
         -0.007245200750033335,
         0.01856453796956293,
         -0.04293924148953263,
         -0.057816378548372564,
         0.11621490901941327,
         -0.1512591222436497,
         0.16294137580866372,
         -0.15125912224364968,
         0.1162149090194133,
         -0.057816378548372585,
         -0.04293924148953263,
         0.018564537969562925,
         -0.007245200750033324,
         -0.004437052814980778,
         0.013426305518662229,
         0.0016452445821305414,
         -0.02099358407658042,
         0.05699209982571253,
         -0.063977035952367,
         0.059812603528786784,
         -0.061598012405987425,
         0.0014064306453281683,
         -0.020300412830821745,
         0.020304015498585265,
         -0.0014140730577460684,
         0.04497044533763287,
         -0.0615980124059874,
         0.04523530719146546,
         -0.020993584076580418,
         0.013438275016631801,
         0.054729138869993865,
         -0.02851271524311241,
         0.013426305518662255,
         0.018564537969562932,
         -0.05909442118973728,
         0.058362417879338546,
         0.05665301494763757,
         -0.1296347566143605,
         0.14343969106441815,
         -0.1512591222436497,
         0.14155729596769845,
         -0.10279930720914264,
         0.0881790073846278,
         0.001645244582130532,
         0.01342630551866224,
         -0.004437052814980762,
         -0.00724520075003333,
         0.018564537969562922,
         -0.042939241489532626,
         0.04523530719146541,
         -0.063977035952367,
         0.07008502982073148,
         -0.06397703595236698,
         0.04523530719146542,
         -0.020300412830821752,
         0.01576523600356522,
         -0.015766934317435848,
         0.020304015498585272,
         0.012948128928232284,
         -3.2887706688164124e-06,
         -0.01294303398662034,
         -0.08736345401678469,
         0.05472913886999391,
         0.0016452445821305086,
         -0.04293924148953263,
         0.058362417879338574,
         -0.05864560951484697,
         -0.09904602362678956,
         0.11575446317832115,
         -0.1296347566143606,
         0.11621490901941332,
         -0.1027993072091427,
         0.11668639390066472,
         -0.13338634188284318,
         0.05472913886999388,
         -0.028512715243112413,
         0.013426305518662255,
         0.01856453796956293,
         -0.05909442118973729,
         0.05836241787933855,
         -0.06159801240598744,
         0.05981260352878676,
         -0.06397703595236699,
         0.05699209982571257,
         -0.020993584076580432,
         0.020304015498585275,
         -0.01576693431743586,
         0.01576523600356523,
         -0.02030041283082175,
         -3.2887706688136138e-06,
         4.245784676614554e-06,
         -3.2887706688136138e-06,
         -0.01294558145742632,
         0.012945581457426343,
         0.1864094776435743,
         -0.09904602362678955,
         0.05665301494763764,
         -0.05781637854837265,
         0.08817900738462785,
         -0.13338634188284315,
         0.1920319513976902,
         -0.08736345401678466,
         0.054729138869993935,
         0.0016452445821305232,
         -0.042939241489532626,
         0.058362417879338595,
         -0.05864560951484698,
         0.04497044533763285,
         -0.06159801240598742,
         0.04523530719146545,
         -0.020993584076580415,
         0.013438275016631772,
         -0.0014140730577460574,
         0.020304015498585265,
         -0.020300412830821745,
         0.0014064306453281635,
         -0.012943033986620346,
         -3.2887706688068638e-06,
         0.012948128928232282,
         0.012945581457426344,
         -0.012945581457426325},
        {0.021977489618769996,
         -0.021977489618770024,
         -0.020923893101145286,
         -0.001360187255460818,
         0.023031086136394555,
         -0.047160287351394325,
         0.09628557137903834,
         -0.09479556089454454,
         0.04399949779852009,
         0.1114550559140495,
         -0.09092653369094657,
         -0.005870531656576278,
         0.10015459858263606,
         -0.11481949362331868,
         -0.1086567343590759,
         -0.003612617593248732,
         0.09488395798587125,
         -0.08952492029777959,
         -0.009703524292731207,
         0.12233581122037208,
         0.08019570860152614,
         0.028461025757549704,
         -0.02566270420257604,
         -0.04143038591505298,
         0.10473406414279811,
         -0.0972177465457447,
         -0.025118064674627346,
         -0.021977489618769955,
         0.021977489618769955,
         -0.001360187255460805,
         0.0017559941960411068,
         -0.0013601872554608052,
         0.09628557137903833,
         -0.11348847360789234,
         0.11278607592947587,
         -0.09479556089454448,
         -0.09092653369094658,
         0.039581463571626195,
         0.006378590223031066,
         -0.05157832157828787,
         0.10015459858263609,
         -0.003612617593248725,
         0.02179835046955078,
         0.003193172691030767,
         -0.005420670170526475,
         -0.014293302031189453,
         -0.00970352429273122,
         0.02846102575754972,
         0.08485957785981545,
         -0.10385960677439254,
         0.03385156213528518,
         0.03440048830778112,
         -0.012590868679538252,
         -0.09721774654574475,
         -0.1086567343590759,
         -0.00361261759324872,
         0.09488395798587126,
         -0.08952492029777956,
         -0.009703524292731226,
         0.12233581122037208,
         0.023031086136394575,
         -0.0013601872554608165,
         -0.020923893101145258,
         -0.09479556089454447,
         0.11278607592947587,
         -0.11348847360789237,
         0.09628557137903836,
         -0.005870531656576292,
         0.006378590223031086,
         -0.006284997822055619,
         0.006378590223031074,
         -0.0058705316565763,
         0.09488395798587126,
         0.003193172691030791,
         -0.0500668044978723,
         0.050528972736201196,
         -0.0054206701705264695,
         -0.0895249202977796,
         -0.025662704202576044,
         -0.10385960677439253,
         0.07856331087906766,
         -0.03141146090267376,
         -0.014169139618206155,
         0.034400488307781134,
         0.10473406414279811,
         -0.0036126175932487434,
         0.021798350469550778,
         0.0031931726910307827,
         -0.005420670170526465,
         -0.014293302031189456,
         -0.009703524292731223,
         0.11145505591404951,
         -0.0909265336909466,
         -0.005870531656576294,
         0.10015459858263609,
         -0.11481949362331872,
         0.04399949779852012,
         -0.09479556089454452,
         0.09628557137903834,
         -0.04716028735139409,
         0.1001545985826361,
         -0.051578321578287845,
         0.006378590223031071,
         0.0395814635716262,
         -0.0909265336909466,
         -0.08952492029777959,
         -0.0054206701705264764,
         0.05052897273620119,
         -0.0500668044978723,
         0.003193172691030787,
         0.09488395798587124,
         -0.041430385915052985,
         0.033851562135285174,
         -0.03141146090267377,
         0.03094929266434488,
         -0.03141146090267379,
         0.033851562135285174,
         -0.04143038591505298,
         0.09488395798587125,
         0.0031931726910307662,
         -0.05006680449787228,
         0.05052897273620118,
         -0.005420670170526476,
         -0.0895249202977796,
         -0.09092653369094658,
         0.039581463571626195,
         0.006378590223031067,
         -0.05157832157828784,
         0.10015459858263609,
         -0.04716028735139409,
         0.09628557137903834,
         -0.09479556089454448,
         0.04399949779852012,
         -0.11481949362331868,
         0.10015459858263609,
         -0.005870531656576295,
         -0.09092653369094658,
         0.1114550559140495,
         -0.009703524292731216,
         -0.014293302031189482,
         -0.005420670170526465,
         0.0031931726910307714,
         0.0217983504695508,
         -0.0036126175932487434,
         0.10473406414279812,
         0.034400488307781134,
         -0.014169139618206131,
         -0.03141146090267375,
         0.07856331087906766,
         -0.10385960677439257,
         -0.025662704202576037,
         -0.0895249202977796,
         -0.005420670170526472,
         0.050528972736201196,
         -0.0500668044978723,
         0.003193172691030785,
         0.09488395798587124,
         -0.005870531656576289,
         0.006378590223031075,
         -0.006284997822055614,
         0.006378590223031086,
         -0.005870531656576289,
         0.09628557137903831,
         -0.11348847360789235,
         0.1127860759294759,
         -0.09479556089454448,
         -0.020923893101145254,
         -0.001360187255460807,
         0.023031086136394582,
         0.12233581122037213,
         -0.009703524292731198,
         -0.08952492029777956,
         0.09488395798587126,
         -0.003612617593248727,
         -0.10865673435907586,
         -0.09721774654574473,
         -0.012590868679538252,
         0.034400488307781106,
         0.03385156213528518,
         -0.10385960677439254,
         0.08485957785981543,
         0.02846102575754973,
         -0.009703524292731204,
         -0.01429330203118946,
         -0.0054206701705264634,
         0.003193172691030782,
         0.021798350469550785,
         -0.0036126175932487356,
         0.1001545985826361,
         -0.05157832157828787,
         0.006378590223031068,
         0.039581463571626195,
         -0.0909265336909466,
         -0.0947955608945445,
         0.11278607592947587,
         -0.11348847360789233,
         0.09628557137903831,
         -0.0013601872554607865,
         0.0017559941960411196,
         -0.0013601872554607865,
         0.02197748961876998,
         -0.02197748961876995,
         -0.02511806467462735,
         -0.09721774654574472,
         0.10473406414279811,
         -0.04143038591505298,
         -0.025662704202576037,
         0.02846102575754973,
         0.08019570860152615,
         0.1223358112203721,
         -0.009703524292731212,
         -0.0895249202977796,
         0.09488395798587122,
         -0.0036126175932487303,
         -0.10865673435907588,
         -0.11481949362331868,
         0.10015459858263612,
         -0.005870531656576295,
         -0.09092653369094658,
         0.1114550559140495,
         0.04399949779852012,
         -0.09479556089454451,
         0.09628557137903833,
         -0.04716028735139409,
         0.023031086136394593,
         -0.0013601872554608026,
         -0.02092389310114526,
         -0.021977489618769955,
         0.021977489618769955},
        {-0.06984288287745274,
         0.06984288287745288,
         0.0678567297431501,
         0.0025641126707237616,
         -0.07182903601175512,
         -0.03823314764227481,
         -0.04189407157313105,
         0.03908522687365078,
         0.044191607045182,
         -0.03046132846469174,
         0.09714865977058626,
         -0.06052836872280987,
         0.016169361323804452,
         -0.05562507208469964,
         0.10114388995437733,
         -0.09125079450561153,
         0.002811577311397501,
         0.05244301088605768,
         -0.06263423997213682,
         0.10414134574758858,
         -0.030545227334134336,
         -0.07059866262024296,
         0.14128122410992883,
         -0.14326930949264807,
         0.10618650086927685,
         -0.05767022720638781,
         -0.04647111854120075,
         0.06984288287745279,
         -0.06984288287745283,
         0.0025641126707236705,
         -0.003310255223837406,
         0.0025641126707236696,
         -0.04189407157313112,
         -0.011919820765236575,
         0.01324392285477151,
         0.039085226873650764,
         0.09714865977058627,
         -0.039908640369906774,
         0.08922624287050726,
         -0.12233339505736346,
         0.01616936132380444,
         -0.0912507945056115,
         0.010876645400235203,
         -0.04344807121103893,
         -0.0029781516814097494,
         0.11361859811047936,
         -0.06263423997213678,
         -0.07059866262024304,
         0.08725904181534182,
         -0.027453125725891342,
         0.06512752148046666,
         -0.09949166201120459,
         0.03438933756361417,
         -0.05767022720638784,
         0.1011438899543773,
         -0.09125079450561152,
         0.002811577311397485,
         0.05244301088605771,
         -0.0626342399721368,
         0.10414134574758857,
         -0.07182903601175514,
         0.002564112670723687,
         0.06785672974315024,
         0.03908522687365075,
         0.013243922854771507,
         -0.011919820765236545,
         -0.041894071573131124,
         -0.06052836872280985,
         0.08922624287050725,
         -0.0990665539727576,
         0.08922624287050725,
         -0.06052836872280984,
         0.002811577311397468,
         -0.04344807121103891,
         -0.010238834148562227,
         0.027853344885300915,
         -0.0029781516814097447,
         0.05244301088605765,
         0.1412812241099288,
         -0.027453125725891283,
         0.06417145769040979,
         -0.014270142404552837,
         -0.010864534388114813,
         -0.09949166201120457,
         0.10618650086927689,
         -0.09125079450561152,
         0.010876645400235209,
         -0.043448071211038934,
         -0.002978151681409742,
         0.11361859811047939,
         -0.06263423997213678,
         -0.030461328464691635,
         0.09714865977058629,
         -0.06052836872280985,
         0.01616936132380446,
         -0.05562507208469968,
         0.04419160704518205,
         0.03908522687365077,
         -0.04189407157313113,
         -0.038233147642274715,
         0.016169361323804463,
         -0.12233339505736344,
         0.08922624287050726,
         -0.03990864036990679,
         0.09714865977058629,
         0.052443010886057656,
         -0.002978151681409753,
         0.027853344885300915,
         -0.010238834148562208,
         -0.043448071211038906,
         0.0028115773113974647,
         -0.14326930949264807,
         0.06512752148046663,
         -0.014270142404552818,
         -0.0033443683321858295,
         -0.014270142404552818,
         0.06512752148046663,
         -0.1432693094926481,
         0.0028115773113974777,
         -0.04344807121103892,
         -0.010238834148562206,
         0.027853344885300942,
         -0.0029781516814097564,
         0.05244301088605767,
         0.09714865977058629,
         -0.03990864036990679,
         0.08922624287050726,
         -0.12233339505736346,
         0.016169361323804456,
         -0.03823314764227473,
         -0.04189407157313111,
         0.03908522687365078,
         0.04419160704518204,
         -0.05562507208469965,
         0.01616936132380446,
         -0.06052836872280985,
         0.09714865977058629,
         -0.030461328464691656,
         -0.06263423997213677,
         0.11361859811047938,
         -0.0029781516814097564,
         -0.04344807121103893,
         0.010876645400235219,
         -0.09125079450561152,
         0.10618650086927683,
         -0.09949166201120459,
         -0.010864534388114817,
         -0.01427014240455285,
         0.06417145769040979,
         -0.027453125725891304,
         0.1412812241099288,
         0.05244301088605765,
         -0.002978151681409745,
         0.02785334488530092,
         -0.010238834148562217,
         -0.04344807121103893,
         0.0028115773113974838,
         -0.060528368722809825,
         0.08922624287050725,
         -0.09906655397275761,
         0.08922624287050725,
         -0.06052836872280984,
         -0.041894071573131145,
         -0.01191982076523654,
         0.013243922854771521,
         0.03908522687365078,
         0.06785672974315024,
         0.0025641126707236723,
         -0.07182903601175517,
         0.10414134574758857,
         -0.06263423997213682,
         0.052443010886057684,
         0.002811577311397482,
         -0.09125079450561153,
         0.10114388995437731,
         -0.05767022720638783,
         0.03438933756361415,
         -0.09949166201120457,
         0.06512752148046666,
         -0.027453125725891342,
         0.08725904181534187,
         -0.07059866262024303,
         -0.06263423997213677,
         0.11361859811047938,
         -0.002978151681409758,
         -0.04344807121103892,
         0.010876645400235212,
         -0.09125079450561153,
         0.01616936132380447,
         -0.12233339505736344,
         0.08922624287050726,
         -0.0399086403699068,
         0.09714865977058629,
         0.03908522687365077,
         0.013243922854771509,
         -0.011919820765236538,
         -0.041894071573131124,
         0.0025641126707236714,
         -0.0033102552238374336,
         0.0025641126707236714,
         -0.06984288287745284,
         0.0698428828774528,
         -0.04647111854120081,
         -0.05767022720638784,
         0.10618650086927679,
         -0.1432693094926481,
         0.14128122410992877,
         -0.070598662620243,
         -0.030545227334134343,
         0.10414134574758856,
         -0.06263423997213681,
         0.0524430108860577,
         0.0028115773113975,
         -0.09125079450561155,
         0.10114388995437733,
         -0.05562507208469966,
         0.016169361323804442,
         -0.06052836872280984,
         0.09714865977058629,
         -0.030461328464691666,
         0.044191607045182074,
         0.03908522687365078,
         -0.04189407157313111,
         -0.03823314764227472,
         -0.07182903601175517,
         0.0025641126707236918,
         0.06785672974315025,
         0.06984288287745283,
         -0.06984288287745284},
        {-0.1309681812426653,
         0.13096818124266538,
         0.12814538756229943,
         0.0036442109712787607,
         -0.13379097492303105,
         -0.09693416898478724,
         -0.04413932861050878,
         0.040147295503954225,
         0.10540255002588499,
         0.08590173646073951,
         0.01560221570147461,
         0.03126084093269965,
         -0.0686844084129883,
         -0.056835339075274494,
         -0.08221048067592754,
         -0.004765390727056053,
         -0.010381991708405551,
         -0.018155121200628507,
         0.0792732820875264,
         -0.004569481189563918,
         0.009385000226762901,
         0.07282548044916459,
         -0.06913422466435273,
         0.07647540140358879,
         -0.0636377920893608,
         0.0022329718245222454,
         0.002336509365041666,
         0.1309681812426655,
         -0.13096818124266543,
         0.003644210971278846,
         -0.004704656133943119,
         0.003644210971278847,
         -0.04413932861050874,
         -0.07042760654121832,
         0.07230946899479562,
         0.04014729550395423,
         0.015602215701474638,
         0.1372917410917155,
         -0.039055812638480514,
         -0.06504497791895651,
         -0.06868440841298831,
         -0.004765390727056082,
         -0.10181450853414883,
         -0.050948785414421494,
         0.06789984544379603,
         0.05162839386843119,
         0.07927328208752639,
         0.07282548044916462,
         0.015537093201449304,
         0.08996867111751133,
         -0.03611782929666049,
         -0.013028356390247214,
         -0.1000048577430224,
         0.002232971824522268,
         -0.08221048067592751,
         -0.004765390727056073,
         -0.01038199170840555,
         -0.01815512120062853,
         0.07927328208752636,
         -0.004569481189563927,
         -0.1337909749230311,
         0.0036442109712788127,
         0.12814538756229932,
         0.04014729550395423,
         0.07230946899479561,
         -0.07042760654121835,
         -0.044139328610508746,
         0.03126084093269966,
         -0.039055812638480486,
         0.04090163671400497,
         -0.03905581263848048,
         0.031260840932699666,
         -0.010381991708405536,
         -0.050948785414421494,
         -0.0386966438261956,
         0.033447923085175836,
         0.06789984544379603,
         -0.01815512120062849,
         -0.0691342246643527,
         0.08996867111751138,
         0.06765743551457531,
         0.017548873393235225,
         -0.11298059147954694,
         -0.013028356390247284,
         -0.06363779208936078,
         -0.004765390727056097,
         -0.10181450853414883,
         -0.050948785414421494,
         0.06789984544379604,
         0.05162839386843118,
         0.07927328208752639,
         0.08590173646073938,
         0.015602215701474638,
         0.031260840932699666,
         -0.06868440841298831,
         -0.05683533907527454,
         0.10540255002588496,
         0.04014729550395421,
         -0.044139328610508705,
         -0.09693416898478735,
         -0.06868440841298835,
         -0.06504497791895653,
         -0.03905581263848049,
         0.13729174109171552,
         0.015602215701474673,
         -0.018155121200628475,
         0.06789984544379603,
         0.033447923085175836,
         -0.0386966438261956,
         -0.05094878541442151,
         -0.010381991708405543,
         0.07647540140358877,
         -0.0361178292966605,
         0.0175488733932352,
         -0.012300152652215495,
         0.017548873393235197,
         -0.036117829296660506,
         0.07647540140358881,
         -0.010381991708405553,
         -0.05094878541442147,
         -0.03869664382619559,
         0.03344792308517583,
         0.06789984544379604,
         -0.018155121200628503,
         0.015602215701474659,
         0.1372917410917155,
         -0.0390558126384805,
         -0.06504497791895653,
         -0.06868440841298833,
         -0.09693416898478735,
         -0.0441393286105087,
         0.04014729550395421,
         0.10540255002588496,
         -0.05683533907527451,
         -0.06868440841298831,
         0.03126084093269968,
         0.015602215701474631,
         0.08590173646073941,
         0.07927328208752635,
         0.05162839386843118,
         0.06789984544379606,
         -0.05094878541442151,
         -0.10181450853414883,
         -0.004765390727056064,
         -0.0636377920893608,
         -0.013028356390247284,
         -0.11298059147954695,
         0.017548873393235232,
         0.06765743551457529,
         0.0899686711175114,
         -0.06913422466435276,
         -0.018155121200628482,
         0.06789984544379603,
         0.03344792308517584,
         -0.038696643826195615,
         -0.0509487854144215,
         -0.010381991708405564,
         0.03126084093269965,
         -0.03905581263848049,
         0.04090163671400497,
         -0.039055812638480486,
         0.03126084093269966,
         -0.044139328610508725,
         -0.07042760654121834,
         0.07230946899479562,
         0.040147295503954246,
         0.12814538756229935,
         0.0036442109712788284,
         -0.1337909749230311,
         -0.004569481189563913,
         0.07927328208752639,
         -0.018155121200628496,
         -0.010381991708405574,
         -0.00476539072705605,
         -0.08221048067592751,
         0.0022329718245222667,
         -0.1000048577430224,
         -0.013028356390247221,
         -0.03611782929666053,
         0.08996867111751133,
         0.015537093201449264,
         0.07282548044916462,
         0.07927328208752638,
         0.0516283938684312,
         0.06789984544379604,
         -0.05094878541442151,
         -0.10181450853414885,
         -0.004765390727056066,
         -0.06868440841298834,
         -0.06504497791895657,
         -0.039055812638480514,
         0.13729174109171552,
         0.015602215701474652,
         0.04014729550395425,
         0.0723094689947956,
         -0.07042760654121831,
         -0.04413932861050873,
         0.003644210971278845,
         -0.00470465613394315,
         0.003644210971278845,
         -0.1309681812426654,
         0.13096818124266546,
         0.0023365093650417022,
         0.0022329718245222493,
         -0.06363779208936078,
         0.0764754014035888,
         -0.06913422466435272,
         0.07282548044916462,
         0.009385000226762915,
         -0.00456948118956392,
         0.07927328208752639,
         -0.018155121200628517,
         -0.010381991708405543,
         -0.004765390727056042,
         -0.08221048067592751,
         -0.05683533907527452,
         -0.0686844084129883,
         0.03126084093269967,
         0.015602215701474647,
         0.08590173646073937,
         0.10540255002588499,
         0.04014729550395421,
         -0.04413932861050872,
         -0.09693416898478735,
         -0.1337909749230311,
         0.003644210971278857,
         0.12814538756229935,
         0.1309681812426655,
         -0.13096818124266543},
        {9.573102446108761e-05,
         -0.00014359653669154815,
         0.00014359653669154815,
         -9.573102446081005e-05,
         0.05399795823669397,
         -0.08548529905242641,
         0.09705257924310876,
         -0.08569936013067692,
         0.05426872646295917,
         -0.10300472977707523,
         0.0967310555168547,
         -0.036471716867054436,
         -0.04277138225516104,
         0.10216754472585075,
         -0.10665280361834764,
         0.10249855293214137,
         -0.027593314874662676,
         -0.056575236105149564,
         0.08941456720720249,
         -0.05169553627818633,
         -0.03588705109502367,
         0.11100635023075282,
         -0.05863399725517712,
         -0.03703137842039301,
         0.06531024375679213,
         -0.026674350346013533,
         -0.036551296463059706,
         0.07122986873597818,
         -0.036070210944897284,
         -0.06655097265716504,
         0.00811899507715186,
         0.04265953607125851,
         -0.01841680825697202,
         -0.019290078556851956,
         0.03390022194815928,
         -0.01388025236928273,
         -0.027244331519776028,
         0.05085782751806406,
         0.006777005449604442,
         -9.573102446099457e-05,
         0.00014359653669149714,
         -0.00014359653669146851,
         9.573102446101283e-05,
         -0.0698858444651409,
         0.11049922235705859,
         -0.12529434103834516,
         0.1104992223570586,
         -0.06988584446514089,
         0.0470843532211184,
         -0.04307575330826172,
         0.014059749619644683,
         0.023295805548059566,
         -0.05068594602515789,
         0.051749155839380626,
         0.03345458171354624,
         -0.01864348000377553,
         -0.0011617216618671732,
         0.01080178021074734,
         -0.0048654709831448895,
         -0.012627558840966774,
         0.027741388630775462,
         -0.08087296084803447,
         -0.022754806971913726,
         0.061126099263600096,
         -0.03082029649182694,
         -0.026521101910243015,
         0.057243715387867454,
         -0.019454454449972732,
         -0.08364806459269936,
         0.05958571312072864,
         0.08161153702662378,
         -0.038137487284498395,
         -0.0451301039135956,
         0.08153348795245365,
         -0.042760267368304794,
         -0.0410312628180615,
         0.0810867737681661,
         0.07006943850728689,
         -0.05863399725517711,
         -0.03703137842039301,
         0.06531024375679209,
         -0.026674350346013526,
         -0.03655129646305969,
         0.07122986873597817,
         -0.03607021094489731,
         -0.06655097265716509,
         0.054268726462959126,
         -0.08569936013067687,
         0.09705257924310878,
         -0.08548529905242644,
         0.05399795823669392,
         0.05174915583938066,
         -0.050685946025157864,
         0.023295805548059545,
         0.014059749619644683,
         -0.04307575330826172,
         0.04708435322111837,
         -0.09981794680023737,
         0.039227697843297396,
         0.032357032381581406,
         -0.06195049378061651,
         0.032357032381581385,
         0.03922769784329744,
         -0.09981794680023738,
         0.049007894991888235,
         0.02001680776762175,
         -0.04325810128064057,
         0.020044532327451133,
         0.02030410177697353,
         -0.04088540422119611,
         0.01344028275992033,
         0.058807810051413216,
         0.012749262078424976,
         0.017647288871504362,
         -0.016947929908212936,
         0.006707317317011377,
         -0.0004405046468075363,
         0.003466266043696014,
         -0.012750419584548891,
         0.016749150610604686,
         0.004747664938940692,
         -0.08087296084803448,
         -0.022754806971913722,
         0.06112609926360008,
         -0.03082029649182694,
         -0.026521101910243015,
         0.057243715387867426,
         -0.019454454449972743,
         -0.08364806459269934,
         0.10249855293214138,
         -0.02759331487466268,
         -0.056575236105149564,
         0.08941456720720248,
         -0.05169553627818633,
         -0.035887051095023666,
         0.11100635023075285,
         -0.10665280361834764,
         0.10216754472585077,
         -0.042771382255161,
         -0.03647171686705441,
         0.09673105551685471,
         -0.10300472977707523,
         0.027741388630775465,
         -0.012627558840966774,
         -0.004865470983144886,
         0.010801780210747328,
         -0.0011617216618671935,
         -0.01864348000377557,
         0.033454581713546226,
         0.058807810051413195,
         0.013440282759920322,
         -0.0408854042211961,
         0.020304101776973532,
         0.020044532327451164,
         -0.0432581012806406,
         0.020016807767621745,
         0.04900789499188823,
         -0.05276404077776666,
         -0.07928269102948482,
         0.048307444139176675,
         0.02039544041034631,
         -0.05164935799607683,
         0.02039544041034629,
         0.04830744413917669,
         -0.07928269102948482,
         -0.052764040777766655,
         0.049007894991888235,
         0.020016807767621717,
         -0.0432581012806406,
         0.02004453232745115,
         0.020304101776973525,
         -0.04088540422119609,
         0.013440282759920324,
         0.058807810051413216,
         0.03345458171354623,
         -0.01864348000377556,
         -0.0011617216618671972,
         0.010801780210747321,
         -0.004865470983144879,
         -0.012627558840966792,
         0.02774138863077545,
         -0.10300472977707525,
         0.09673105551685467,
         -0.03647171686705441,
         -0.04277138225516101,
         0.1021675447258508,
         -0.10665280361834763,
         0.11100635023075285,
         -0.03588705109502367,
         -0.05169553627818633,
         0.0894145672072025,
         -0.05657523610514957,
         -0.027593314874662683,
         0.10249855293214138,
         -0.08364806459269937,
         -0.019454454449972763,
         0.05724371538786743,
         -0.026521101910243018,
         -0.030820296491826948,
         0.061126099263600076,
         -0.022754806971913722,
         -0.08087296084803447,
         0.004747664938940679,
         0.016749150610604686,
         -0.01275041958454884,
         0.003466266043696009,
         -0.000440504646807519,
         0.006707317317011377,
         -0.016947929908212905,
         0.017647288871504355,
         0.012749262078424957,
         0.058807810051413216,
         0.013440282759920317,
         -0.040885404221196096,
         0.02030410177697353,
         0.020044532327451164,
         -0.043258101280640573,
         0.02001680776762171,
         0.049007894991888214,
         -0.09981794680023737,
         0.039227697843297424,
         0.03235703238158139,
         -0.06195049378061647,
         0.032357032381581385,
         0.03922769784329743,
         -0.09981794680023738,
         0.047084353221118376,
         -0.04307575330826172,
         0.014059749619644655,
         0.023295805548059552,
         -0.050685946025157864,
         0.051749155839380646,
         0.05399795823669393,
         -0.08548529905242645,
         0.09705257924310871,
         -0.08569936013067689,
         0.054268726462959105,
         -0.06655097265716507,
         -0.0360702109448973,
         0.0712298687359782,
         -0.036551296463059706,
         -0.026674350346013533,
         0.0653102437567921,
         -0.03703137842039301,
         -0.05863399725517712,
         0.07006943850728689,
         0.08108677376816611,
         -0.04103126281806143,
         -0.042760267368304815,
         0.08153348795245366,
         -0.045130103913595614,
         -0.0381374872844984,
         0.0816115370266238,
         0.05958571312072862,
         -0.08364806459269936,
         -0.019454454449972763,
         0.05724371538786745,
         -0.026521101910243018,
         -0.030820296491826948,
         0.06112609926360007,
         -0.022754806971913708,
         -0.08087296084803446,
         0.027741388630775462,
         -0.0126275588409668,
         -0.00486547098314489,
         0.010801780210747345,
         -0.0011617216618671935,
         -0.01864348000377552,
         0.03345458171354621,
         0.051749155839380646,
         -0.05068594602515786,
         0.023295805548059545,
         0.01405974961964466,
         -0.04307575330826171,
         0.04708435322111837,
         -0.06988584446514087,
         0.11049922235705863,
         -0.12529434103834525,
         0.11049922235705863,
         -0.06988584446514089,
         9.573102446098418e-05,
         -0.00014359653669146678,
         0.00014359653669148632,
         -9.573102446096518e-05,
         0.0067770054496043815,
         0.0508578275180641,
         -0.027244331519776,
         -0.01388025236928273,
         0.0339002219481593,
         -0.019290078556851994,
         -0.018416808256972058,
         0.04265953607125849,
         0.00811899507715189,
         -0.06655097265716507,
         -0.036070210944897325,
         0.07122986873597817,
         -0.03655129646305971,
         -0.026674350346013526,
         0.0653102437567921,
         -0.03703137842039303,
         -0.05863399725517713,
         0.11100635023075285,
         -0.03588705109502369,
         -0.05169553627818634,
         0.08941456720720248,
         -0.05657523610514955,
         -0.02759331487466267,
         0.10249855293214138,
         -0.10665280361834761,
         0.10216754472585077,
         -0.042771382255160986,
         -0.036471716867054416,
         0.09673105551685468,
         -0.10300472977707524,
         0.05426872646295911,
         -0.0856993601306769,
         0.09705257924310873,
         -0.08548529905242645,
         0.05399795823669391,
         -9.573102446096485e-05,
         0.00014359653669147838,
         -0.00014359653669146448,
         9.573102446101059e-05},
        {0.001163129390329698,
         -0.0017446940854944915,
         0.001744694085494436,
         -0.001163129390329587,
         0.0032375086100396994,
         -0.006419368767767997,
         0.00875341562963938,
         -0.00902020515117298,
         0.006527335327237433,
         -0.010417594228114134,
         0.012506540683899963,
         -0.009004994596149866,
         0.0018578606631100309,
         0.005432623114279215,
         -0.008491944745580307,
         0.05262343704178784,
         -0.06617626045956039,
         0.06751695301625321,
         -0.06381657010294954,
         0.059102621513978194,
         -0.05365689265368346,
         0.042704905619315774,
         -0.12285523448322869,
         0.10368740763501592,
         -0.061641321063965145,
         0.014651491988614016,
         0.030473637483248352,
         -0.07070169536963972,
         0.10234652088458628,
         -0.11345893034288548,
         0.128068659469809,
         -0.02167290541943896,
         -0.046206436595018614,
         0.08179506990450282,
         -0.0898200225677731,
         0.0731289239089628,
         -0.032309281055138674,
         -0.034692244526146485,
         0.13295056048929438,
         -0.0011631293903295874,
         0.0017446940854943943,
         -0.0017446940854944123,
         0.0011631293903295952,
         -0.006303179657898161,
         0.009966202110099538,
         -0.011300610985341618,
         0.00996620211009954,
         -0.006303179657898148,
         0.008821848058578866,
         -0.00970516212506004,
         0.007379372640712932,
         -0.004010181393978967,
         0.0012485592113875672,
         9.219409969489685e-05,
         -0.05637697586745312,
         0.08278285188310436,
         -0.09814665153261976,
         0.1026294580442492,
         -0.09527417177761174,
         0.07576939105486248,
         -0.04568537695228669,
         0.07822179785840534,
         -0.08000353337326131,
         0.05739598362460881,
         -0.01934520452607169,
         -0.025197456853067186,
         0.06533162358263626,
         -0.08850370356703423,
         0.0812420283833478,
         0.013792345930684359,
         0.005148779452864775,
         -0.005412794843595621,
         -0.001779012186949994,
         0.007433184827505835,
         -0.006306990876856683,
         -0.0015686834063866285,
         0.009366439454011893,
         -0.0019394725384304905,
         -0.12285523448322865,
         0.10368740763501587,
         -0.061641321063965145,
         0.014651491988614007,
         0.030473637483248373,
         -0.07070169536963969,
         0.1023465208845863,
         -0.11345893034288547,
         0.00652733532723744,
         -0.009020205151172975,
         0.008753415629639359,
         -0.00641936876776812,
         0.0032375086100397063,
         9.219409969489076e-05,
         0.0012485592113875756,
         -0.004010181393978972,
         0.007379372640712929,
         -0.009705162125060039,
         0.008821848058578883,
         0.04992213164536275,
         -0.0848493995781437,
         0.1085615637936828,
         -0.11694518286486728,
         0.10856156379368279,
         -0.08484939957814372,
         0.04992213164536276,
         -0.018981548918968822,
         0.026999729470350616,
         -0.02202381546644643,
         0.007729189086336181,
         0.010286174312037372,
         -0.026480734557018305,
         0.036157887702574,
         -0.03494051613192736,
         -0.08375604886414115,
         0.019548974886895915,
         0.02306945950475891,
         -0.047867529817452105,
         0.05555965099906454,
         -0.04570999475094668,
         0.018636106840139256,
         0.022687475588409427,
         -0.07072560669962283,
         0.07822179785840533,
         -0.08000353337326131,
         0.0573959836246088,
         -0.019345204526071694,
         -0.02519745685306718,
         0.06533162358263626,
         -0.0885037035670342,
         0.08124202838334782,
         0.05262343704178787,
         -0.06617626045956038,
         0.06751695301625321,
         -0.06381657010294954,
         0.059102621513978194,
         -0.05365689265368343,
         0.04270490561931576,
         -0.0084919447455803,
         0.005432623114279229,
         0.0018578606631100255,
         -0.009004994596149883,
         0.012506540683899949,
         -0.010417594228114134,
         -0.045685376952286694,
         0.07576939105486248,
         -0.09527417177761176,
         0.10262945804424918,
         -0.09814665153261971,
         0.08278285188310437,
         -0.05637697586745311,
         -0.034940516131927356,
         0.03615788770257397,
         -0.026480734557018295,
         0.010286174312037369,
         0.007729189086336167,
         -0.022023815466446443,
         0.026999729470350616,
         -0.018981548918968822,
         0.09925441865719145,
         -0.03321364603126271,
         -0.025258945401171042,
         0.06486274465476768,
         -0.07881738513832291,
         0.0648627446547677,
         -0.02525894540117105,
         -0.03321364603126269,
         0.09925441865719148,
         -0.01898154891896883,
         0.026999729470350616,
         -0.02202381546644645,
         0.00772918908633617,
         0.010286174312037363,
         -0.0264807345570183,
         0.03615788770257398,
         -0.03494051613192736,
         -0.056376975867453126,
         0.08278285188310436,
         -0.09814665153261971,
         0.10262945804424918,
         -0.09527417177761174,
         0.07576939105486247,
         -0.04568537695228668,
         -0.01041759422811414,
         0.012506540683899947,
         -0.00900499459614988,
         0.0018578606631100285,
         0.005432623114279223,
         -0.008491944745580304,
         0.042704905619315746,
         -0.05365689265368344,
         0.05910262151397818,
         -0.06381657010294951,
         0.0675169530162532,
         -0.06617626045956042,
         0.05262343704178787,
         0.08124202838334779,
         -0.08850370356703423,
         0.06533162358263625,
         -0.02519745685306718,
         -0.01934520452607169,
         0.0573959836246088,
         -0.08000353337326131,
         0.07822179785840533,
         -0.07072560669962284,
         0.022687475588409417,
         0.018636106840139253,
         -0.045709994750946684,
         0.05555965099906456,
         -0.047867529817452084,
         0.02306945950475891,
         0.019548974886895904,
         -0.08375604886414117,
         -0.03494051613192737,
         0.03615788770257398,
         -0.0264807345570183,
         0.010286174312037351,
         0.00772918908633618,
         -0.022023815466446436,
         0.026999729470350623,
         -0.01898154891896882,
         0.049922131645362765,
         -0.08484939957814372,
         0.10856156379368281,
         -0.11694518286486727,
         0.10856156379368276,
         -0.0848493995781437,
         0.04992213164536276,
         0.008821848058578894,
         -0.009705162125060049,
         0.0073793726407129405,
         -0.0040101813939789855,
         0.0012485592113875713,
         9.219409969490255e-05,
         0.00323750861003971,
         -0.006419368767768121,
         0.008753415629639374,
         -0.009020205151172989,
         0.006527335327237429,
         -0.11345893034288551,
         0.10234652088458629,
         -0.07070169536963967,
         0.03047363748324837,
         0.014651491988614014,
         -0.06164132106396515,
         0.10368740763501591,
         -0.12285523448322867,
         -0.0019394725384304843,
         0.009366439454011881,
         -0.0015686834063865888,
         -0.006306990876856702,
         0.007433184827505834,
         -0.0017790121869499889,
         -0.00541279484359562,
         0.0051487794528647865,
         0.01379234593068435,
         0.0812420283833478,
         -0.0885037035670342,
         0.06533162358263625,
         -0.025197456853067183,
         -0.01934520452607169,
         0.0573959836246088,
         -0.08000353337326133,
         0.07822179785840527,
         -0.04568537695228669,
         0.0757693910548625,
         -0.09527417177761176,
         0.1026294580442492,
         -0.09814665153261973,
         0.08278285188310434,
         -0.05637697586745312,
         9.219409969490194e-05,
         0.0012485592113875667,
         -0.004010181393978986,
         0.0073793726407129475,
         -0.009705162125060044,
         0.008821848058578883,
         -0.00630317965789817,
         0.009966202110099551,
         -0.011300610985341665,
         0.009966202110099551,
         -0.006303179657898169,
         0.0011631293903296073,
         -0.0017446940854944073,
         0.0017446940854944004,
         -0.0011631293903295852,
         0.13295056048929435,
         -0.03469224452614646,
         -0.03230928105513867,
         0.0731289239089628,
         -0.08982002256777309,
         0.08179506990450279,
         -0.04620643659501863,
         -0.021672905419439004,
         0.12806865946980903,
         -0.11345893034288548,
         0.10234652088458628,
         -0.07070169536963967,
         0.030473637483248394,
         0.014651491988614013,
         -0.06164132106396515,
         0.10368740763501591,
         -0.12285523448322866,
         0.04270490561931577,
         -0.05365689265368344,
         0.059102621513978194,
         -0.06381657010294955,
         0.06751695301625321,
         -0.0661762604595604,
         0.05262343704178789,
         -0.008491944745580293,
         0.005432623114279224,
         0.0018578606631100192,
         -0.009004994596149885,
         0.012506540683899963,
         -0.010417594228114134,
         0.006527335327237436,
         -0.009020205151172998,
         0.00875341562963937,
         -0.0064193687677681285,
         0.0032375086100397067,
         -0.001163129390329589,
         0.0017446940854943976,
         -0.0017446940854944017,
         0.0011631293903296089},
        {-0.004091346462885906,
         0.0061370196943288345,
         -0.006137019694328828,
         0.004091346462885975,
         0.0066151785757027695,
         -0.005885251308726636,
         0.0014865194222744688,
         0.003263277501789452,
         -0.0049568967366580225,
         -0.006838302962569265,
         0.0027104003120666503,
         0.0022091359581008934,
         -0.003422873983870649,
         0.0003360579544711594,
         0.0036270539896001057,
         0.0038758164181451884,
         0.0025614518552109487,
         -0.005570863626121893,
         0.004068453907649411,
         -0.0012083274839358154,
         0.0007506499325661228,
         -0.0034619104697261645,
         0.049869813633637836,
         -0.07030485689151322,
         0.077553392621256,
         -0.0775961770650252,
         0.07471934571798136,
         -0.07003057876612602,
         0.06120166376952218,
         -0.04333826082489248,
         -0.17900397096865492,
         0.135815445479929,
         -0.08979011284730087,
         0.04501464074084994,
         -0.0025134641861706344,
         -0.038412006945594795,
         0.078844180447723,
         -0.11891007428787603,
         0.15644210911806897,
         0.004091346462885892,
         -0.006137019694328852,
         0.006137019694328852,
         -0.0040913464628858955,
         -0.0010704163243230938,
         0.0016924768147432347,
         -0.0019190883220942812,
         0.0016924768147432365,
         -0.0010704163243230953,
         -0.0024067876328426885,
         -0.0007266854823692517,
         0.003290952669802897,
         -0.002718791077399054,
         -0.0007094287168778804,
         0.003920584916085953,
         0.006363056024909688,
         -0.0006747391431522753,
         -0.000295125959858736,
         -0.003651406766376052,
         0.007444780419029913,
         -0.0058632955840609395,
         -0.001386361053774602,
         -0.07030205993248324,
         0.08185120790705049,
         -0.09386272278379297,
         0.1023973060785832,
         -0.10179732253869207,
         0.09146854578270869,
         -0.07631370211853745,
         0.06123760973502735,
         0.12141927031702038,
         -0.08600770332209783,
         0.06285613933741384,
         -0.03767046854460489,
         0.0077658155958835184,
         0.023290290346094398,
         -0.05103474556836241,
         0.07546570176777587,
         -0.1063993960111451,
         0.049869813633637836,
         -0.07030485689151322,
         0.07755339262125599,
         -0.07759617706502515,
         0.07471934571798139,
         -0.07003057876612603,
         0.061201663769522185,
         -0.04333826082489247,
         -0.004956896736658022,
         0.0032632775017895285,
         0.001486519422274455,
         -0.005885251308726618,
         0.006615178575702797,
         0.003920584916085965,
         -0.0007094287168778806,
         -0.0027187910773990576,
         0.0032909526698028935,
         -0.0007266854823692582,
         -0.002406787632842692,
         -0.0037413341863591367,
         0.003919524464795468,
         -0.003470989749539866,
         0.003232280376304613,
         -0.0034709897495398667,
         0.003919524464795469,
         -0.0037413341863591337,
         0.06948317870666273,
         -0.09444953863130749,
         0.10403719441084949,
         -0.10661080673835047,
         0.10668902761018526,
         -0.10378973619880885,
         0.09270390771602562,
         -0.06544207591868237,
         -0.05853919633010162,
         0.052040122044779584,
         -0.03377373738298314,
         0.01878886675647119,
         -0.00861432045519811,
         -0.00204506790252066,
         0.018612403919842615,
         -0.0399426949712323,
         0.051626812752295505,
         -0.07030205993248326,
         0.08185120790705047,
         -0.09386272278379298,
         0.10239730607858322,
         -0.10179732253869211,
         0.09146854578270869,
         -0.0763137021185375,
         0.06123760973502736,
         0.0038758164181451824,
         0.002561451855210955,
         -0.0055708636261218945,
         0.004068453907649408,
         -0.0012083274839358102,
         0.0007506499325661293,
         -0.0034619104697261385,
         0.0036270539896001083,
         0.000336057954471166,
         -0.0034228739838706498,
         0.002209135958100893,
         0.002710400312066651,
         -0.006838302962569383,
         -0.0013863610537746159,
         -0.005863295584060953,
         0.007444780419029903,
         -0.0036514067663760614,
         -0.0002951259598587379,
         -0.0006747391431522667,
         0.006363056024909667,
         -0.06544207591868234,
         0.09270390771602563,
         -0.10378973619880888,
         0.10668902761018526,
         -0.10661080673835045,
         0.10403719441084952,
         -0.09444953863130752,
         0.06948317870666273,
         0.0018064184841213218,
         -0.006755738398466535,
         0.008371878586618857,
         -0.008573927370672509,
         0.00851333774388412,
         -0.008573927370672512,
         0.008371878586618845,
         -0.006755738398466532,
         0.00180641848412132,
         0.06948317870666273,
         -0.09444953863130753,
         0.1040371944108495,
         -0.10661080673835045,
         0.10668902761018528,
         -0.10378973619880888,
         0.09270390771602564,
         -0.06544207591868235,
         0.00636305602490966,
         -0.0006747391431522667,
         -0.00029512595985875176,
         -0.003651406766376061,
         0.007444780419029892,
         -0.00586329558406095,
         -0.0013863610537746124,
         -0.006838302962569352,
         0.002710400312066659,
         0.002209135958100886,
         -0.003422873983870641,
         0.0003360579544711695,
         0.0036270539896000875,
         -0.0034619104697261385,
         0.0007506499325661302,
         -0.0012083274839358085,
         0.004068453907649407,
         -0.005570863626121889,
         0.0025614518552109556,
         0.0038758164181451962,
         0.06123760973502734,
         -0.07631370211853748,
         0.09146854578270867,
         -0.10179732253869214,
         0.10239730607858319,
         -0.09386272278379301,
         0.08185120790705047,
         -0.07030205993248326,
         0.05162681275229551,
         -0.039942694971232304,
         0.01861240391984262,
         -0.002045067902520674,
         -0.008614320455198108,
         0.01878886675647121,
         -0.03377373738298316,
         0.052040122044779584,
         -0.0585391963301016,
         -0.06544207591868237,
         0.09270390771602566,
         -0.1037897361988089,
         0.10668902761018528,
         -0.10661080673835047,
         0.10403719441084952,
         -0.0944495386313075,
         0.06948317870666272,
         -0.0037413341863591345,
         0.00391952446479547,
         -0.003470989749539869,
         0.0032322803763046148,
         -0.0034709897495398684,
         0.00391952446479547,
         -0.0037413341863591363,
         -0.0024067876328426954,
         -0.0007266854823692551,
         0.0032909526698029004,
         -0.0027187910773990645,
         -0.0007094287168778811,
         0.003920584916085957,
         0.006615178575702783,
         -0.005885251308726636,
         0.0014865194222744558,
         0.00326327750178957,
         -0.0049568967366580285,
         -0.04333826082489248,
         0.06120166376952217,
         -0.07003057876612603,
         0.07471934571798139,
         -0.07759617706502518,
         0.07755339262125605,
         -0.07030485689151322,
         0.04986981363363784,
         -0.10639939601114509,
         0.07546570176777588,
         -0.05103474556836241,
         0.023290290346094412,
         0.007765815595883525,
         -0.03767046854460489,
         0.06285613933741385,
         -0.08600770332209783,
         0.12141927031702035,
         0.061237609735027336,
         -0.0763137021185375,
         0.09146854578270869,
         -0.10179732253869211,
         0.10239730607858322,
         -0.093862722783793,
         0.08185120790705049,
         -0.07030205993248326,
         -0.0013863610537746159,
         -0.005863295584060948,
         0.007444780419029899,
         -0.0036514067663760657,
         -0.00029512595985874135,
         -0.0006747391431522788,
         0.006363056024909677,
         0.00392058491608596,
         -0.0007094287168778759,
         -0.0027187910773990506,
         0.0032909526698029004,
         -0.0007266854823692551,
         -0.002406787632842699,
         -0.0010704163243230938,
         0.0016924768147432365,
         -0.0019190883220942803,
         0.0016924768147432365,
         -0.0010704163243230938,
         -0.004091346462885906,
         0.006137019694328859,
         -0.006137019694328838,
         0.004091346462885885,
         0.156442109118069,
         -0.11891007428787609,
         0.078844180447723,
         -0.0384120069455948,
         -0.0025134641861706344,
         0.045014640740849945,
         -0.08979011284730086,
         0.13581544547992905,
         -0.17900397096865495,
         -0.04333826082489247,
         0.06120166376952217,
         -0.07003057876612603,
         0.07471934571798138,
         -0.07759617706502517,
         0.077553392621256,
         -0.07030485689151322,
         0.04986981363363784,
         -0.0034619104697261455,
         0.0007506499325661206,
         -0.0012083274839358137,
         0.004068453907649403,
         -0.005570863626121893,
         0.0025614518552109543,
         0.003875816418145203,
         0.0036270539896000875,
         0.00033605795447116255,
         -0.0034228739838706532,
         0.0022091359581008947,
         0.0027104003120666607,
         -0.006838302962569383,
         -0.0049568967366580355,
         0.0032632775017895563,
         0.0014865194222744575,
         -0.005885251308726632,
         0.006615178575702801,
         0.004091346462885878,
         -0.006137019694328838,
         0.006137019694328845,
         -0.004091346462885908},
        {0.002407075954957927,
         -0.0036106139324370568,
         0.0036106139324371678,
         -0.0024070759549579823,
         -0.000530091879360095,
         -0.0018530438771774405,
         0.005152679984681996,
         -0.0072354293394686076,
         0.006278147042967655,
         -0.00407101381673175,
         0.007086065334056425,
         -0.006753882747625901,
         0.002546737157518328,
         0.003473786289099895,
         -0.007060047144134986,
         0.007412279354007539,
         -0.006132465737604816,
         0.0007692767807772624,
         0.004703633245310561,
         -0.006434952419628497,
         0.0026930841729583617,
         0.003969114905735837,
         -0.0042206800562335865,
         -0.0027037453557074566,
         0.008248638575676885,
         -0.009268213556665442,
         0.005942242592691853,
         -0.001087107808119073,
         -0.001048567457088044,
         -0.0025618718574231705,
         0.1196340552761946,
         -0.11597883912624996,
         0.11774885594802342,
         -0.12251120965013848,
         0.1275876192828993,
         -0.1308423195930846,
         0.1314699615787403,
         -0.13078351304397265,
         0.1330021591537416,
         -0.0024070759549580955,
         0.00361061393243714,
         -0.0036106139324371227,
         0.0024070759549580795,
         -0.0037103536536222267,
         0.0058665842350868755,
         -0.006652081256336558,
         0.005866584235086874,
         -0.003710353653622212,
         0.006725093885149809,
         -0.006025932548874354,
         0.0034573003295040278,
         -0.0014740328787012386,
         0.0010479707548359197,
         -0.001477861426996684,
         -0.0034313432216412773,
         0.0004360919714449262,
         0.00041878119123290485,
         0.0006350479889584662,
         -0.0008555838516004327,
         -0.00199859295866843,
         0.006615184227164483,
         -0.0058735692148118145,
         0.005553299517530505,
         -0.00268595128371669,
         0.002045165679671016,
         -0.005113357767414579,
         0.009038258109312532,
         -0.007894002968940113,
         -0.002755560819531508,
         -0.1147604337429351,
         0.12498249991031428,
         -0.1279058778035635,
         0.12514551398632964,
         -0.12151525487431414,
         0.1218762445161006,
         -0.12798532237398208,
         0.135343421104789,
         -0.1300439643407164,
         -0.004220680056233614,
         -0.002703745355707456,
         0.008248638575676875,
         -0.009268213556665439,
         0.005942242592691854,
         -0.0010871078081190657,
         -0.0010485674570880484,
         -0.0025618718574232243,
         0.006278147042967645,
         -0.007235429339468608,
         0.005152679984681979,
         -0.0018530438771771443,
         -0.0005300918793601331,
         -0.0014778614269966807,
         0.0010479707548359338,
         -0.0014740328787012397,
         0.0034573003295040147,
         -0.006025932548874357,
         0.006725093885149804,
         -0.005263812079287097,
         0.0020291338838437857,
         0.0017818667199676673,
         -0.003356492719836329,
         0.0017818667199676575,
         0.002029133883843804,
         -0.005263812079287089,
         0.010494192756526266,
         -0.0035993269251344572,
         0.0018340751934273626,
         -0.0037003141587023144,
         0.0058511955004494015,
         -0.0063261703278835,
         0.005412040172913852,
         -0.004808625894691801,
         0.12001391375688275,
         -0.12629977249739838,
         0.12493870699531766,
         -0.12443423323503433,
         0.12585433373676688,
         -0.12677096033052399,
         0.1251995369300701,
         -0.12353846230689103,
         0.1325086128641593,
         -0.005873569214811813,
         0.005553299517530504,
         -0.0026859512837166767,
         0.0020451656796710116,
         -0.005113357767414571,
         0.009038258109312547,
         -0.007894002968940108,
         -0.0027555608195314984,
         0.007412279354007525,
         -0.006132465737604812,
         0.0007692767807772602,
         0.004703633245310569,
         -0.006434952419628496,
         0.0026930841729583756,
         0.003969114905735845,
         -0.007060047144134981,
         0.0034737862890999007,
         0.002546737157518333,
         -0.006753882747625891,
         0.007086065334056451,
         -0.00407101381673173,
         0.006615184227164475,
         -0.001998592958668422,
         -0.0008555838516004192,
         0.0006350479889584682,
         0.0004187811912329315,
         0.0004360919714449244,
         -0.0034313432216412773,
         -0.004808625894691788,
         0.005412040172913844,
         -0.006326170327883498,
         0.005851195500449401,
         -0.003700314158702314,
         0.0018340751934273491,
         -0.0035993269251344616,
         0.010494192756526261,
         -0.1285823862621829,
         0.12161901740719723,
         -0.12329726376711536,
         0.12696504408560083,
         -0.1286311096088518,
         0.12696504408560086,
         -0.12329726376711535,
         0.12161901740719722,
         -0.12858238626218293,
         0.010494192756526263,
         -0.003599326925134453,
         0.001834075193427361,
         -0.003700314158702317,
         0.005851195500449402,
         -0.006326170327883494,
         0.005412040172913838,
         -0.004808625894691794,
         -0.003431343221641283,
         0.00043609197144491333,
         0.00041878119123292263,
         0.0006350479889584719,
         -0.0008555838516004234,
         -0.001998592958668422,
         0.006615184227164482,
         -0.004071013816731725,
         0.00708606533405645,
         -0.006753882747625898,
         0.0025467371575183377,
         0.0034737862890998985,
         -0.007060047144134987,
         0.003969114905735831,
         0.0026930841729583695,
         -0.006434952419628492,
         0.00470363324531056,
         0.000769276780777255,
         -0.0061324657376047925,
         0.007412279354007556,
         -0.002755560819531514,
         -0.007894002968940116,
         0.009038258109312539,
         -0.005113357767414572,
         0.002045165679671027,
         -0.0026859512837166867,
         0.005553299517530498,
         -0.005873569214811817,
         0.1325086128641594,
         -0.12353846230689099,
         0.1251995369300701,
         -0.12677096033052396,
         0.1258543337367669,
         -0.12443423323503434,
         0.12493870699531764,
         -0.12629977249739838,
         0.12001391375688278,
         -0.004808625894691791,
         0.0054120401729138255,
         -0.006326170327883492,
         0.005851195500449401,
         -0.0037003141587023235,
         0.0018340751934273502,
         -0.00359932692513446,
         0.01049419275652626,
         -0.005263812079287097,
         0.0020291338838438005,
         0.0017818667199676636,
         -0.003356492719836321,
         0.0017818667199676573,
         0.002029133883843816,
         -0.0052638120792870965,
         0.006725093885149799,
         -0.006025932548874354,
         0.003457300329504024,
         -0.0014740328787012462,
         0.0010479707548359245,
         -0.001477861426996681,
         -0.0005300918793601444,
         -0.001853043877177129,
         0.005152679984681969,
         -0.007235429339468634,
         0.006278147042967643,
         -0.0025618718574232043,
         -0.001048567457088048,
         -0.0010871078081190692,
         0.005942242592691851,
         -0.009268213556665442,
         0.008248638575676882,
         -0.0027037453557074557,
         -0.004220680056233585,
         -0.13004396434071644,
         0.135343421104789,
         -0.12798532237398208,
         0.1218762445161006,
         -0.12151525487431415,
         0.12514551398632964,
         -0.1279058778035635,
         0.12498249991031432,
         -0.1147604337429351,
         -0.002755560819531506,
         -0.007894002968940111,
         0.009038258109312532,
         -0.0051133577674145735,
         0.0020451656796710224,
         -0.002685951283716688,
         0.005553299517530493,
         -0.005873569214811815,
         0.006615184227164475,
         -0.0019985929586684294,
         -0.000855583851600431,
         0.0006350479889584526,
         0.0004187811912329251,
         0.00043609197144493366,
         -0.003431343221641286,
         -0.0014778614269966824,
         0.001047970754835929,
         -0.0014740328787012512,
         0.0034573003295040087,
         -0.006025932548874365,
         0.006725093885149803,
         -0.0037103536536222293,
         0.0058665842350868695,
         -0.00665208125633653,
         0.0058665842350868695,
         -0.0037103536536222284,
         0.0024070759549580808,
         -0.003610613932437126,
         0.003610613932437143,
         -0.002407075954958094,
         0.13300215915374164,
         -0.13078351304397268,
         0.1314699615787403,
         -0.13084231959308465,
         0.12758761928289927,
         -0.12251120965013843,
         0.11774885594802346,
         -0.11597883912624994,
         0.11963405527619461,
         -0.0025618718574231965,
         -0.001048567457088054,
         -0.0010871078081190538,
         0.00594224259269186,
         -0.009268213556665452,
         0.008248638575676887,
         -0.0027037453557074522,
         -0.004220680056233588,
         0.003969114905735843,
         0.0026930841729583717,
         -0.006434952419628498,
         0.004703633245310568,
         0.0007692767807772527,
         -0.006132465737604823,
         0.007412279354007535,
         -0.00706004714413497,
         0.0034737862890998955,
         0.0025467371575183394,
         -0.006753882747625902,
         0.007086065334056435,
         -0.004071013816731748,
         0.006278147042967645,
         -0.0072354293394686145,
         0.00515267998468198,
         -0.0018530438771771282,
         -0.0005300918793601357,
         -0.0024070759549580925,
         0.003610613932437139,
         -0.0036106139324371244,
         0.002407075954958083},
        {0.14322297480788646,
         -0.18946618668626802,
         0.1432229748078864,
         -0.12403473458920862,
         0.062017367294604324,
         0.06201736729460431,
         -0.12403473458920859,
         0.07973254720972982,
         0.012606822641482525,
         -0.06670903506412212,
         0.012606822641482522,
         0.07973254720972982,
         -0.041173710332530755,
         -0.032550676092701424,
         0.027233849523421713,
         0.027233849523421713,
         -0.032550676092701424,
         -0.041173710332530755,
         0.016809096855309975,
         0.025213645282964967,
         -0.022236345021374008,
         0.025213645282964988,
         0.016809096855309978,
         -0.0049721979038931325,
         -0.012215542042876587,
         -0.007458296855839713,
         0.007861735176708651,
         0.00786173517670866,
         -0.007458296855839716,
         -0.012215542042876587,
         -0.004972197903893136,
         0.0008201999423648031,
         0.0034858497550503947,
         0.004511099683006392,
         -0.0002050499855911862,
         -0.004100999711824002,
         -0.00020504998559118644,
         0.0045110996830063895,
         0.003485849755050398,
         0.0008201999423648013,
         -0.12403473458920859,
         0.062017367294604296,
         0.062017367294604324,
         -0.12403473458920859,
         0.12352113099759215,
         0.019530405655620975,
         -0.10334519273796469,
         0.01953040565562098,
         0.12352113099759213,
         -0.08734262934822935,
         -0.06905041139206802,
         0.05777171902747655,
         0.05777171902747655,
         -0.06905041139206802,
         -0.08734262934822935,
         0.047543305488044654,
         0.07131495823206697,
         -0.06289388141366911,
         0.07131495823206703,
         0.047543305488044654,
         -0.019257239675825526,
         -0.04731059089695752,
         -0.02888585951373833,
         0.030448369411685595,
         0.03044836941168562,
         -0.0288858595137383,
         -0.04731059089695753,
         -0.01925723967582553,
         0.004921199654188798,
         0.020915098530302396,
         0.027066598098038356,
         -0.0012302999135471488,
         -0.024605998270944025,
         -0.0012302999135471488,
         0.027066598098038356,
         0.020915098530302392,
         0.004921199654188796,
         -0.004972197903893136,
         -0.012215542042876587,
         -0.007458296855839705,
         0.007861735176708655,
         0.007861735176708655,
         -0.00745829685583972,
         -0.012215542042876587,
         -0.0049721979038931385,
         0.07973254720972983,
         0.012606822641482524,
         -0.0667090350641221,
         0.012606822641482524,
         0.07973254720972985,
         -0.08734262934822935,
         -0.06905041139206802,
         0.057771719027476534,
         0.05777171902747655,
         -0.06905041139206804,
         -0.08734262934822935,
         0.06510135218540304,
         0.09765202827810458,
         -0.08612099394830375,
         0.09765202827810465,
         0.06510135218540304,
         -0.035158748552443754,
         -0.0863769261438741,
         -0.05273812282866568,
         0.055590862553435066,
         0.0555908625534351,
         -0.05273812282866562,
         -0.0863769261438741,
         -0.035158748552443754,
         0.012302999135471976,
         0.052287746325755925,
         0.06766649524509583,
         -0.003075749783867866,
         -0.061514995677360004,
         -0.003075749783867866,
         0.0676664952450958,
         0.052287746325755925,
         0.012302999135471972,
         -0.01925723967582553,
         -0.04731059089695753,
         -0.0288858595137383,
         0.03044836941168562,
         0.0304483694116856,
         -0.028885859513738323,
         -0.04731059089695753,
         -0.019257239675825533,
         0.016809096855309975,
         0.02521364528296499,
         -0.022236345021374,
         0.025213645282964967,
         0.01680909685530998,
         -0.041173710332530755,
         -0.032550676092701424,
         0.027233849523421713,
         0.027233849523421713,
         -0.032550676092701424,
         -0.04117371033253077,
         0.047543305488044654,
         0.07131495823206696,
         -0.06289388141366913,
         0.07131495823206702,
         0.04754330548804465,
         -0.035158748552443754,
         -0.0863769261438741,
         -0.052738122828665676,
         0.055590862553435066,
         0.055590862553435115,
         -0.05273812282866562,
         -0.0863769261438741,
         -0.035158748552443754,
         0.016403998847295986,
         0.06971699510100797,
         0.09022199366012786,
         -0.004100999711823823,
         -0.08201999423648008,
         -0.004100999711823823,
         0.09022199366012786,
         0.06971699510100798,
         0.01640399884729599,
         -0.03515874855244375,
         -0.0863769261438741,
         -0.05273812282866562,
         0.0555908625534351,
         0.055590862553435066,
         -0.05273812282866568,
         -0.0863769261438741,
         -0.035158748552443754,
         0.04754330548804463,
         0.07131495823206702,
         -0.06289388141366911,
         0.07131495823206697,
         0.047543305488044654,
         -0.04117371033253077,
         -0.032550676092701424,
         0.027233849523421713,
         0.027233849523421713,
         -0.03255067609270144,
         -0.041173710332530755,
         0.016809096855309985,
         0.025213645282964967,
         -0.022236345021374,
         0.02521364528296499,
         0.016809096855309975,
         -0.01925723967582553,
         -0.04731059089695753,
         -0.028885859513738323,
         0.0304483694116856,
         0.03044836941168562,
         -0.0288858595137383,
         -0.04731059089695753,
         -0.019257239675825526,
         0.012302999135471972,
         0.052287746325755925,
         0.0676664952450958,
         -0.0030757497838678647,
         -0.061514995677360004,
         -0.003075749783867865,
         0.06766649524509583,
         0.052287746325755925,
         0.012302999135471976,
         -0.035158748552443754,
         -0.0863769261438741,
         -0.05273812282866563,
         0.0555908625534351,
         0.055590862553435066,
         -0.05273812282866568,
         -0.08637692614387411,
         -0.035158748552443754,
         0.06510135218540304,
         0.09765202827810465,
         -0.08612099394830375,
         0.09765202827810457,
         0.06510135218540304,
         -0.08734262934822935,
         -0.06905041139206802,
         0.057771719027476534,
         0.057771719027476534,
         -0.06905041139206802,
         -0.08734262934822935,
         0.07973254720972983,
         0.012606822641482524,
         -0.06670903506412212,
         0.012606822641482525,
         0.07973254720972985,
         -0.004972197903893139,
         -0.012215542042876587,
         -0.0074582968558397165,
         0.007861735176708648,
         0.007861735176708658,
         -0.007458296855839702,
         -0.012215542042876589,
         -0.004972197903893136,
         0.004921199654188795,
         0.02091509853030239,
         0.02706659809803835,
         -0.0012302999135471498,
         -0.024605998270944025,
         -0.0012302999135471498,
         0.027066598098038356,
         0.020915098530302392,
         0.004921199654188795,
         -0.019257239675825526,
         -0.047310590896957536,
         -0.028885859513738284,
         0.030448369411685612,
         0.030448369411685588,
         -0.028885859513738336,
         -0.04731059089695753,
         -0.01925723967582553,
         0.047543305488044654,
         0.07131495823206702,
         -0.06289388141366913,
         0.07131495823206696,
         0.04754330548804463,
         -0.08734262934822935,
         -0.06905041139206802,
         0.057771719027476534,
         0.057771719027476534,
         -0.06905041139206802,
         -0.08734262934822935,
         0.12352113099759218,
         0.01953040565562098,
         -0.10334519273796464,
         0.01953040565562098,
         0.12352113099759218,
         -0.12403473458920862,
         0.062017367294604296,
         0.06201736729460431,
         -0.12403473458920862,
         0.0008201999423648003,
         0.003485849755050398,
         0.004511099683006389,
         -0.0002050499855911892,
         -0.004100999711824005,
         -0.00020504998559118964,
         0.004511099683006389,
         0.003485849755050399,
         0.0008201999423648009,
         -0.004972197903893139,
         -0.012215542042876587,
         -0.007458296855839707,
         0.007861735176708655,
         0.007861735176708648,
         -0.0074582968558397165,
         -0.012215542042876589,
         -0.0049721979038931385,
         0.01680909685530998,
         0.025213645282964995,
         -0.022236345021373997,
         0.02521364528296497,
         0.016809096855309975,
         -0.04117371033253076,
         -0.03255067609270144,
         0.027233849523421706,
         0.027233849523421706,
         -0.032550676092701424,
         -0.04117371033253077,
         0.07973254720972986,
         0.012606822641482524,
         -0.06670903506412212,
         0.012606822641482524,
         0.07973254720972983,
         -0.12403473458920862,
         0.06201736729460431,
         0.062017367294604296,
         -0.12403473458920862,
         0.1432229748078864,
         -0.18946618668626813,
         0.1432229748078864},
        {0.07796271238296273,
         -0.11694406857444423,
         0.11694406857444416,
         -0.0779627123829629,
         -0.10974832119115921,
         0.08636236987260897,
         0.0009100542707688899,
         -0.08796755472596035,
         0.11076352923159793,
         0.07934280835434815,
         0.008961698345720984,
         -0.09066729614308333,
         0.08992423994254181,
         -0.0070966420843368815,
         -0.08130875027112569,
         -0.022775475136895654,
         -0.06301148490845017,
         0.06701620902265515,
         0.0033882504156167886,
         -0.0728693933224732,
         0.06646394387202867,
         0.022079020681194557,
         -0.012318488237742457,
         0.041759583515647944,
         0.005903507637408329,
         -0.056173776429133834,
         0.053777921583893065,
         0.0005082261487609621,
         -0.04998751218332948,
         0.019126829129878405,
         0.0021888847869811433,
         0.008479238963123652,
         -0.03581730359887891,
         0.03240891187525821,
         -0.00164126738476957,
         -0.02781411336247262,
         0.02752068885867627,
         0.005203819481700071,
         -0.021768139402018962,
         -0.07796271238296282,
         0.1169440685744442,
         -0.11694406857444423,
         0.07796271238296283,
         -0.0006553139722591178,
         0.001036142367435611,
         -0.0011748750116110083,
         0.0010361423674356137,
         -0.0006553139722591314,
         0.08816442823091221,
         -0.04362270343953946,
         -0.005274039411038712,
         0.005624319463175814,
         0.04274350748639339,
         -0.08723767432373078,
         -0.10521638945684247,
         -0.018867234772183508,
         0.05707062571168142,
         -0.0035046985982645617,
         -0.050285264781088586,
         0.012849683387491624,
         0.10960643607825792,
         0.050693212866212575,
         0.0815265562239913,
         -0.03372406050708166,
         -0.04974151603372177,
         0.05060042271152322,
         0.030859233185074303,
         -0.07607998399043013,
         -0.05841889140928118,
         0.012035280213158596,
         -0.05804389144641293,
         -0.03819668905541217,
         0.059924727922174924,
         0.006015479862257636,
         -0.07125076263972359,
         0.047956223757479516,
         0.04906760675208623,
         -0.0003176204917395568,
         -0.012318488237742476,
         0.04175958351564794,
         0.005903507637408289,
         -0.05617377642913386,
         0.05377792158389307,
         0.0005082261487609492,
         -0.04998751218332947,
         0.01912682912987839,
         0.11076352923159793,
         -0.08796755472596016,
         0.0009100542707689463,
         0.08636236987260895,
         -0.1097483211911593,
         -0.08723767432373078,
         0.042743507486393405,
         0.00562431946317581,
         -0.0052740394110387095,
         -0.04362270343953947,
         0.08816442823091222,
         -0.0030262129835099223,
         0.003503177107829289,
         -0.0034440413023013915,
         0.003369254954408068,
         -0.003444041302301388,
         0.003503177107829306,
         -0.003026212983509935,
         0.0689620785048008,
         0.030113583608680397,
         -0.02144318231404129,
         -0.01712278612381592,
         0.01699116860315389,
         0.02210555677378919,
         -0.031933189250875814,
         -0.06569339489742028,
         -0.05737666819984591,
         -0.08376101875277227,
         -0.013021258094395334,
         0.05566597372840342,
         -0.007230157334817289,
         -0.04171104730193009,
         0.0006608213981796774,
         0.09320288922931148,
         0.05256906543627209,
         0.05069321286621258,
         0.08152655622399131,
         -0.03372406050708167,
         -0.04974151603372175,
         0.050600422711523194,
         0.030859233185074296,
         -0.0760799839904301,
         -0.05841889140928117,
         -0.02277547513689567,
         -0.06301148490845015,
         0.06701620902265518,
         0.0033882504156168016,
         -0.07286939332247323,
         0.06646394387202867,
         0.02207902068119458,
         -0.08130875027112573,
         -0.007096642084336887,
         0.08992423994254181,
         -0.09066729614308332,
         0.008961698345720994,
         0.07934280835434834,
         0.1096064360782579,
         0.012849683387491656,
         -0.050285264781088586,
         -0.0035046985982645712,
         0.057070625711681415,
         -0.018867234772183508,
         -0.10521638945684246,
         -0.06569339489742027,
         -0.03193318925087582,
         0.02210555677378919,
         0.016991168603153913,
         -0.01712278612381589,
         -0.02144318231404129,
         0.030113583608680383,
         0.0689620785048008,
         0.0010693668870065543,
         -0.005072670371347628,
         0.006757297848551676,
         -0.0072981243302296765,
         0.0074000748233483,
         -0.007298124330229662,
         0.0067572978485516645,
         -0.0050726703713476155,
         0.0010693668870065695,
         0.06896207850480084,
         0.03011358360868041,
         -0.021443182314041274,
         -0.017122786123815893,
         0.016991168603153917,
         0.022105556773789208,
         -0.03193318925087582,
         -0.06569339489742029,
         -0.10521638945684246,
         -0.018867234772183505,
         0.057070625711681415,
         -0.0035046985982645613,
         -0.05028526478108858,
         0.012849683387491671,
         0.10960643607825792,
         0.0793428083543483,
         0.00896169834572098,
         -0.09066729614308332,
         0.0899242399425418,
         -0.00709664208433691,
         -0.08130875027112572,
         0.02207902068119453,
         0.06646394387202867,
         -0.0728693933224732,
         0.003388250415616786,
         0.06701620902265515,
         -0.06301148490845018,
         -0.022775475136895686,
         -0.05841889140928119,
         -0.07607998399043013,
         0.030859233185074286,
         0.050600422711523214,
         -0.04974151603372173,
         -0.03372406050708167,
         0.0815265562239913,
         0.05069321286621259,
         0.05256906543627209,
         0.0932028892293115,
         0.0006608213981796914,
         -0.04171104730193008,
         -0.00723015733481729,
         0.05566597372840345,
         -0.013021258094395338,
         -0.08376101875277223,
         -0.057376668199845896,
         -0.0656933948974203,
         -0.03193318925087582,
         0.02210555677378919,
         0.01699116860315391,
         -0.0171227861238159,
         -0.02144318231404132,
         0.0301135836086804,
         0.06896207850480082,
         -0.003026212983509934,
         0.00350317710782931,
         -0.0034440413023013824,
         0.0033692549544080772,
         -0.0034440413023013794,
         0.0035031771078292994,
         -0.0030262129835099353,
         0.08816442823091224,
         -0.04362270343953947,
         -0.005274039411038714,
         0.005624319463175822,
         0.04274350748639341,
         -0.0872376743237308,
         -0.10974832119115932,
         0.08636236987260894,
         0.0009100542707689345,
         -0.0879675547259602,
         0.1107635292315979,
         0.019126829129878422,
         -0.04998751218332947,
         0.000508226148760948,
         0.05377792158389308,
         -0.05617377642913385,
         0.005903507637408331,
         0.041759583515647965,
         -0.012318488237742472,
         -0.00031762049173956515,
         0.049067606752086254,
         0.0479562237574795,
         -0.0712507626397236,
         0.006015479862257637,
         0.059924727922174896,
         -0.03819668905541216,
         -0.05804389144641291,
         0.012035280213158544,
         -0.05841889140928117,
         -0.07607998399043012,
         0.03085923318507431,
         0.05060042271152321,
         -0.04974151603372173,
         -0.03372406050708167,
         0.08152655622399131,
         0.05069321286621256,
         0.1096064360782579,
         0.012849683387491644,
         -0.05028526478108859,
         -0.003504698598264556,
         0.057070625711681394,
         -0.0188672347721835,
         -0.10521638945684247,
         -0.0872376743237308,
         0.04274350748639339,
         0.005624319463175801,
         -0.005274039411038724,
         -0.04362270343953947,
         0.08816442823091225,
         -0.0006553139722591207,
         0.0010361423674356046,
         -0.0011748750116109888,
         0.0010361423674356046,
         -0.0006553139722591135,
         0.07796271238296285,
         -0.11694406857444423,
         0.11694406857444423,
         -0.07796271238296285,
         -0.021768139402018966,
         0.005203819481700078,
         0.027520688858676284,
         -0.02781411336247262,
         -0.001641267384769571,
         0.032408911875258205,
         -0.03581730359887892,
         0.008479238963123623,
         0.0021888847869811208,
         0.01912682912987841,
         -0.04998751218332944,
         0.0005082261487609741,
         0.0537779215838931,
         -0.05617377642913383,
         0.0059035076374083185,
         0.04175958351564795,
         -0.012318488237742462,
         0.02207902068119455,
         0.06646394387202867,
         -0.07286939332247323,
         0.0033882504156167977,
         0.06701620902265518,
         -0.06301148490845017,
         -0.02277547513689569,
         -0.08130875027112572,
         -0.007096642084336901,
         0.08992423994254181,
         -0.09066729614308333,
         0.00896169834572098,
         0.07934280835434834,
         0.11076352923159793,
         -0.08796755472596017,
         0.0009100542707689348,
         0.08636236987260895,
         -0.10974832119115929,
         -0.07796271238296282,
         0.11694406857444421,
         -0.11694406857444424,
         0.07796271238296283},
        {-0.029848405417348955,
         0.044772608126023294,
         -0.04477260812602318,
         0.029848405417348983,
         0.044019855525351016,
         -0.03622997109924608,
         0.003241165547997171,
         0.03051309243391906,
         -0.04040418398749951,
         -0.07804891438751116,
         0.06949307688993805,
         -0.04951767819166813,
         0.04687127760350775,
         -0.06285066413100791,
         0.07104719656178385,
         0.11758238239558869,
         -0.08078356597959735,
         0.032216741843123405,
         0.006471587267669387,
         -0.042445822267484355,
         0.08419663788006801,
         -0.11414088499724202,
         -0.11811943334750741,
         0.024796222824231606,
         0.04015830062265832,
         -0.06634350723471472,
         0.06176740399270516,
         -0.028583975773440885,
         -0.037547771466248714,
         0.12485010190372058,
         0.061959456891415764,
         0.040334973068148476,
         -0.056567911359724526,
         0.03338250568503489,
         0.0029553297714255498,
         -0.03678673025676485,
         0.053289696364070695,
         -0.028708909946786793,
         -0.07941444996691116,
         0.029848405417348886,
         -0.044772608126023336,
         0.04477260812602337,
         -0.029848405417348872,
         -0.002333905941909084,
         0.003690229310516728,
         -0.004184326729897981,
         0.0036902293105167136,
         -0.0023339059419090593,
         0.0300089404241376,
         -0.08296122794056206,
         0.11975690366712993,
         -0.11850937846604702,
         0.07982996453704222,
         -0.02670829898778659,
         -0.03110191468521796,
         0.07749191874485015,
         -0.06130728382166629,
         -0.004568506208145195,
         0.07045857932785797,
         -0.08636117498732365,
         0.038362233404024886,
         -0.027118523167558355,
         -0.027862985578544986,
         0.012735338039475106,
         0.01803261805850807,
         -0.018038502695635467,
         -0.014215620309900813,
         0.03443965124797106,
         0.013172293314567369,
         0.07443311638800315,
         0.05818074419759261,
         -0.05086516167802218,
         0.018187395479097486,
         0.00539945346564493,
         -0.026475706372448532,
         0.05357437026484266,
         -0.05810040163114775,
         -0.06475002991801941,
         -0.1181194333475074,
         0.024796222824231575,
         0.04015830062265827,
         -0.06634350723471473,
         0.06176740399270512,
         -0.02858397577344091,
         -0.0375477714662487,
         0.12485010190372063,
         -0.04040418398749961,
         0.03051309243391894,
         0.0032411655479971705,
         -0.03622997109924609,
         0.04401985552535099,
         -0.026708298987786535,
         0.07982996453704228,
         -0.11850937846604703,
         0.11975690366712992,
         -0.08296122794056204,
         0.030008940424137553,
         -0.006190777923277555,
         0.005595937574399584,
         -0.004042024096811374,
         0.0033308171166477997,
         -0.004042024096811371,
         0.0055959375743996715,
         -0.006190777923277553,
         0.06650713546717775,
         -0.04562554918398616,
         -0.018938946358492376,
         0.06895945256097617,
         -0.06830907068571186,
         0.01811287363177199,
         0.04382670234675178,
         -0.059820331060146115,
         -0.05017757188717774,
         -0.0009572705611620751,
         0.06674684187000418,
         -0.060775617446156574,
         -0.005391131332009709,
         0.07105825754267876,
         -0.07525165914870834,
         0.005569199425747614,
         0.05296837260964389,
         -0.027118523167558334,
         -0.027862985578544976,
         0.012735338039475132,
         0.01803261805850806,
         -0.018038502695635457,
         -0.014215620309900862,
         0.03443965124797106,
         0.0131722933145674,
         0.1175823823955887,
         -0.08078356597959734,
         0.03221674184312341,
         0.006471587267669398,
         -0.04244582226748437,
         0.08419663788006798,
         -0.11414088499724197,
         0.07104719656178386,
         -0.06285066413100797,
         0.046871277603507774,
         -0.049517678191668094,
         0.06949307688993807,
         -0.07804891438751123,
         0.03836223340402486,
         -0.08636117498732364,
         0.07045857932785796,
         -0.004568506208145221,
         -0.061307283821666274,
         0.0774919187448501,
         -0.031101914685218016,
         -0.05982033106014613,
         0.043826702346751775,
         0.01811287363177203,
         -0.0683090706857118,
         0.06895945256097621,
         -0.018938946358492418,
         -0.045625549183986154,
         0.06650713546717776,
         -0.004125276829069961,
         -0.00406435257444069,
         0.005729761132764608,
         -0.005055275575799778,
         0.004551491941485003,
         -0.005055275575799776,
         0.00572976113276465,
         -0.004064352574440723,
         -0.0041252768290699435,
         0.06650713546717776,
         -0.04562554918398621,
         -0.018938946358492432,
         0.0689594525609762,
         -0.0683090706857118,
         0.018112873631772056,
         0.043826702346751775,
         -0.059820331060146115,
         -0.031101914685218016,
         0.0774919187448501,
         -0.06130728382166627,
         -0.00456850620814521,
         0.07045857932785793,
         -0.08636117498732367,
         0.03836223340402484,
         -0.07804891438751123,
         0.06949307688993803,
         -0.0495176781916681,
         0.04687127760350777,
         -0.06285066413100796,
         0.07104719656178388,
         -0.11414088499724198,
         0.08419663788006795,
         -0.042445822267484355,
         0.006471587267669383,
         0.032216741843123405,
         -0.08078356597959735,
         0.11758238239558866,
         0.013172293314567356,
         0.034439651247971034,
         -0.014215620309900857,
         -0.018038502695635464,
         0.018032618058508035,
         0.012735338039475142,
         -0.027862985578544972,
         -0.027118523167558386,
         0.0529683726096439,
         0.005569199425747616,
         -0.07525165914870827,
         0.07105825754267876,
         -0.005391131332009709,
         -0.06077561744615662,
         0.06674684187000421,
         -0.000957270561162103,
         -0.05017757188717773,
         -0.05982033106014613,
         0.04382670234675179,
         0.018112873631772,
         -0.06830907068571188,
         0.0689594525609762,
         -0.018938946358492366,
         -0.0456255491839862,
         0.06650713546717776,
         -0.00619077792327755,
         0.005595937574399657,
         -0.0040420240968113644,
         0.0033308171166478483,
         -0.0040420240968113575,
         0.005595937574399678,
         -0.00619077792327755,
         0.03000894042413753,
         -0.08296122794056206,
         0.11975690366712989,
         -0.11850937846604707,
         0.07982996453704228,
         -0.026708298987786545,
         0.044019855525351016,
         -0.03622997109924607,
         0.0032411655479971002,
         0.030513092433918965,
         -0.04040418398749959,
         0.12485010190372062,
         -0.037547771466248665,
         -0.02858397577344088,
         0.06176740399270512,
         -0.06634350723471473,
         0.0401583006226583,
         0.02479622282423158,
         -0.11811943334750742,
         -0.06475002991801938,
         -0.058100401631147755,
         0.05357437026484268,
         -0.026475706372448535,
         0.005399453465644929,
         0.018187395479097458,
         -0.05086516167802217,
         0.0581807441975926,
         0.07443311638800314,
         0.013172293314567367,
         0.03443965124797106,
         -0.01421562030990083,
         -0.018038502695635453,
         0.018032618058508056,
         0.012735338039475111,
         -0.02786298557854494,
         -0.02711852316755836,
         0.03836223340402486,
         -0.08636117498732367,
         0.07045857932785796,
         -0.004568506208145176,
         -0.06130728382166627,
         0.07749191874485017,
         -0.03110191468521804,
         -0.02670829898778653,
         0.07982996453704225,
         -0.11850937846604707,
         0.11975690366712989,
         -0.08296122794056204,
         0.030008940424137525,
         -0.0023339059419090636,
         0.0036902293105167223,
         -0.004184326729898,
         0.0036902293105167223,
         -0.002333905941909066,
         -0.0298484054173489,
         0.04477260812602338,
         -0.04477260812602337,
         0.029848405417348966,
         -0.07941444996691117,
         -0.02870890994678679,
         0.05328969636407069,
         -0.03678673025676484,
         0.0029553297714255663,
         0.03338250568503488,
         -0.05656791135972455,
         0.040334973068148434,
         0.06195945689141575,
         0.12485010190372059,
         -0.037547771466248686,
         -0.028583975773440833,
         0.06176740399270518,
         -0.06634350723471469,
         0.04015830062265833,
         0.024796222824231596,
         -0.11811943334750742,
         -0.114140884997242,
         0.08419663788006798,
         -0.04244582226748437,
         0.006471587267669399,
         0.03221674184312341,
         -0.08078356597959736,
         0.11758238239558873,
         0.07104719656178385,
         -0.06285066413100798,
         0.04687127760350777,
         -0.04951767819166813,
         0.06949307688993805,
         -0.07804891438751123,
         -0.04040418398749965,
         0.03051309243391895,
         0.003241165547997095,
         -0.03622997109924607,
         0.044019855525350954,
         0.029848405417348962,
         -0.04477260812602337,
         0.04477260812602339,
         -0.029848405417348862},
        {-0.0005290338343285176,
         0.0005290338343288785,
         -7.848594428705447e-06,
         0.0007102286948864056,
         -0.001065916263086275,
         3.9286107705760465e-05,
         -4.7156269915915594e-05,
         -0.0007581673732197647,
         0.0015713611785662523,
         -0.0010842908677247687,
         0.0016522976036887232,
         -0.0018171668561848264,
         0.0024017691130588494,
         -0.0030903733407879447,
         0.0023273298081209087,
         -0.0019654171359670403,
         0.0003742494231204504,
         0.0015412126282500797,
         -0.003691240111505213,
         0.005424918569374008,
         -0.029242268810984212,
         0.04037240850429499,
         -0.04602568411595127,
         0.04814108146815935,
         -0.04713276261809724,
         0.042935916265560654,
         -0.034048862746414464,
         0.09703971281951171,
         -0.08968758818619493,
         0.06132375750849626,
         -0.024050078104759297,
         -0.016227640393770053,
         0.05482898983102101,
         -0.08622054282704586,
         0.09922546681080224,
         -0.13094233026870994,
         0.03390261744919816,
         0.033894826559329454,
         -0.07477733156499343,
         0.08998793650819058,
         -0.07972467556929741,
         0.04317201568195031,
         0.022004588382437594,
         -0.12123005519323986,
         0.0005290338343288041,
         -0.0005290338343288271,
         0.0007102286948861876,
         -0.0009395442503253265,
         0.0007102286948861697,
         -4.715626991594731e-05,
         -0.0008609612510229097,
         0.0012636230725909302,
         -0.0007581673732201215,
         0.0016522976036887048,
         -0.00258106360287919,
         0.00393853611938506,
         -0.004231640524290285,
         0.0024017691130588667,
         -0.0019654171359670307,
         0.0015793763186678512,
         -5.177428636931735e-05,
         -0.002888362737540052,
         0.005129206006698903,
         -0.0036912401115052284,
         0.04037240850429497,
         -0.05977834521357307,
         0.07104678836103132,
         -0.0750848152792948,
         0.07314532447743811,
         -0.06399242989624981,
         0.042935916265560654,
         -0.08968758818619492,
         0.0873291830694649,
         -0.06175838594237264,
         0.024736055780810184,
         0.016048561119243673,
         -0.054807373095954626,
         0.08370404546075214,
         -0.08622054282704586,
         0.033902617449198195,
         -0.012296803253786728,
         -0.00723493580715068,
         0.020818207660241603,
         -0.026303271802965676,
         0.023139343169998494,
         -0.011356443315803178,
         -0.007170998080561187,
         0.02200458838243762,
         0.09703971281951175,
         -0.08968758818619495,
         0.06132375750849624,
         -0.0240500781047593,
         -0.016227640393770053,
         0.054828989831021004,
         -0.08622054282704587,
         0.09922546681080224,
         -0.0010659162630861669,
         0.0007102286948861843,
         -7.848594428574788e-06,
         -0.0007581673732201453,
         0.001263623072590907,
         -0.0008609612510229134,
         -4.7156269915942726e-05,
         -0.0018171668561848013,
         0.003938536119385054,
         -0.004868542007941569,
         0.003938536119385063,
         -0.0018171668561848047,
         0.0003742494231204608,
         -5.1774286369317666e-05,
         -0.0018229344751978895,
         0.0032180141159599764,
         -0.0028883627375400718,
         0.0015412126282500738,
         -0.04602568411595127,
         0.0710467883610314,
         -0.0864346482608018,
         0.09307732137085177,
         -0.08910233668313693,
         0.07314532447743818,
         -0.04713276261809724,
         0.061323757508496266,
         -0.06175838594237266,
         0.044888618552970584,
         -0.018864017279786868,
         -0.011392840547184046,
         0.038712765109466155,
         -0.054807373095954647,
         0.054828989831021004,
         0.03389482655932948,
         -0.007234935807150673,
         -0.01006681987248619,
         0.019643978178270703,
         -0.022443669136721692,
         0.01982467710932768,
         -0.010201882477251213,
         -0.011356443315803145,
         0.04317201568195031,
         -0.08968758818619495,
         0.08732918306946494,
         -0.061758385942372644,
         0.024736055780810177,
         0.016048561119243673,
         -0.054807373095954605,
         0.08370404546075214,
         -0.08622054282704585,
         -0.029242268810984226,
         0.04037240850429499,
         -0.04602568411595127,
         0.04814108146815932,
         -0.04713276261809723,
         0.04293591626556066,
         -0.034048862746414464,
         0.0015713611785662322,
         -0.0007581673732201204,
         -4.7156269915955134e-05,
         3.928610770588493e-05,
         0.002401769113058864,
         -0.004231640524290304,
         0.003938536119385053,
         -0.0025810636028792146,
         0.0016522976036887043,
         0.0015412126282500673,
         -0.0028883627375400566,
         0.0032180141159600306,
         -0.0018229344751978854,
         -5.177428636930291e-05,
         0.00037424942312047,
         0.048141081468159354,
         -0.07508481527929482,
         0.0930773213708518,
         -0.09950719098721464,
         0.09307732137085177,
         -0.07508481527929482,
         0.048141081468159354,
         -0.024050078104759332,
         0.024736055780810198,
         -0.018864017279786892,
         0.008206957055982756,
         0.0029993337194246534,
         -0.011392840547184053,
         0.0160485611192437,
         -0.01622764039377008,
         -0.0747773315649935,
         0.020818207660241606,
         0.01964397817827073,
         -0.044648176589607694,
         0.05433719766109515,
         -0.0465283338360535,
         0.019824677109327702,
         0.023139343169998498,
         -0.0797246755692975,
         0.06132375750849629,
         -0.06175838594237267,
         0.04488861855297056,
         -0.018864017279786875,
         -0.011392840547184027,
         0.038712765109466155,
         -0.05480737309595464,
         0.05482898983102099,
         0.040372408504295,
         -0.059778345213573024,
         0.07104678836103132,
         -0.07508481527929475,
         0.07314532447743813,
         -0.06399242989624979,
         0.04293591626556065,
         0.0023273298081208857,
         -0.001965417135967036,
         0.0003742494231204652,
         0.0015412126282500637,
         -0.00369124011150521,
         0.005424918569374022,
         -0.0030903733407879248,
         0.0024017691130588507,
         -0.0018171668561847937,
         0.0016522976036887106,
         -0.0010842908677247806,
         -0.0036912401115052184,
         0.005129206006698901,
         -0.00288836273754009,
         -5.1774286369304676e-05,
         0.001579376318667821,
         -0.0019654171359670273,
         -0.04713276261809725,
         0.07314532447743811,
         -0.08910233668313691,
         0.09307732137085177,
         -0.0864346482608018,
         0.07104678836103137,
         -0.04602568411595128,
         -0.016227640393770074,
         0.01604856111924368,
         -0.011392840547184068,
         0.002999333719424645,
         0.008206957055982749,
         -0.01886401727978688,
         0.02473605578081021,
         -0.024050078104759346,
         0.08998793650819063,
         -0.026303271802965652,
         -0.022443669136721713,
         0.054337197661095106,
         -0.06554348843650262,
         0.05433719766109511,
         -0.02244366913672171,
         -0.02630327180296565,
         0.08998793650819065,
         -0.024050078104759343,
         0.024736055780810208,
         -0.018864017279786892,
         0.008206957055982752,
         0.002999333719424672,
         -0.011392840547184062,
         0.01604856111924368,
         -0.016227640393770067,
         -0.04602568411595129,
         0.07104678836103137,
         -0.08643464826080181,
         0.09307732137085174,
         -0.08910233668313693,
         0.07314532447743811,
         -0.047132762618097256,
         -0.001965417135967034,
         0.0015793763186678223,
         -5.1774286369296626e-05,
         -0.002888362737540086,
         0.005129206006698913,
         -0.0036912401115052258,
         -0.0010842908677247695,
         0.0016522976036887134,
         -0.001817166856184792,
         0.0024017691130588693,
         -0.0030903733407879296,
         0.005424918569374019,
         -0.003691240111505208,
         0.0015412126282500728,
         0.00037424942312046656,
         -0.001965417135967026,
         0.002327329808120905,
         0.04293591626556064,
         -0.06399242989624979,
         0.07314532447743811,
         -0.07508481527929474,
         0.07104678836103132,
         -0.05977834521357307,
         0.040372408504294965,
         0.05482898983102099,
         -0.05480737309595464,
         0.038712765109466155,
         -0.011392840547184062,
         -0.01886401727978687,
         0.04488861855297059,
         -0.06175838594237264,
         0.06132375750849625,
         -0.07972467556929749,
         0.0231393431699985,
         0.01982467710932772,
         -0.04652833383605351,
         0.054337197661095155,
         -0.04464817658960773,
         0.01964397817827073,
         0.020818207660241617,
         -0.0747773315649935,
         -0.016227640393770067,
         0.016048561119243687,
         -0.011392840547184046,
         0.002999333719424678,
         0.008206957055982745,
         -0.01886401727978688,
         0.024736055780810208,
         -0.02405007810475936,
         0.048141081468159354,
         -0.07508481527929485,
         0.09307732137085178,
         -0.0995071909872146,
         0.09307732137085177,
         -0.07508481527929482,
         0.048141081468159375,
         0.0003742494231204744,
         -5.177428636929418e-05,
         -0.0018229344751978902,
         0.0032180141159600193,
         -0.00288836273754006,
         0.0015412126282500652,
         0.0016522976036887126,
         -0.002581063602879226,
         0.0039385361193850724,
         -0.00423164052429029,
         0.002401769113058866,
         3.928610770585969e-05,
         -4.7156269915946724e-05,
         -0.0007581673732200958,
         0.0015713611785662359,
         -0.03404886274641447,
         0.042935916265560654,
         -0.04713276261809722,
         0.04814108146815932,
         -0.04602568411595126,
         0.040372408504294986,
         -0.02924226881098418,
         -0.08622054282704592,
         0.08370404546075212,
         -0.05480737309595462,
         0.016048561119243673,
         0.02473605578081018,
         -0.06175838594237265,
         0.08732918306946491,
         -0.08968758818619493,
         0.04317201568195032,
         -0.011356443315803164,
         -0.01020188247725122,
         0.01982467710932768,
         -0.022443669136721692,
         0.019643978178270724,
         -0.01006681987248621,
         -0.007234935807150663,
         0.03389482655932948,
         0.054828989831021,
         -0.05480737309595465,
         0.03871276510946616,
         -0.011392840547184046,
         -0.01886401727978688,
         0.044888618552970556,
         -0.06175838594237267,
         0.06132375750849625,
         -0.047132762618097256,
         0.07314532447743813,
         -0.08910233668313691,
         0.09307732137085174,
         -0.08643464826080181,
         0.07104678836103136,
         -0.04602568411595128,
         0.0015412126282500643,
         -0.0028883627375400765,
         0.003218014115960007,
         -0.0018229344751978993,
         -5.177428636928778e-05,
         0.00037424942312045605,
         -0.0018171668561848004,
         0.003938536119385053,
         -0.004868542007941567,
         0.003938536119385056,
         -0.001817166856184793,
         -4.715626991593688e-05,
         -0.0008609612510229461,
         0.00126362307259094,
         -0.0007581673732201279,
         -7.848594428548232e-06,
         0.0007102286948861807,
         -0.001065916263086165,
         0.09922546681080226,
         -0.08622054282704587,
         0.054828989831021,
         -0.01622764039377005,
         -0.0240500781047593,
         0.061323757508496245,
         -0.08968758818619496,
         0.0970397128195117,
         0.022004588382437643,
         -0.007170998080561203,
         -0.011356443315803169,
         0.023139343169998494,
         -0.026303271802965673,
         0.02081820766024162,
         -0.007234935807150684,
         -0.012296803253786712,
         0.03390261744919818,
         -0.08622054282704586,
         0.0837040454607521,
         -0.05480737309595464,
         0.016048561119243666,
         0.02473605578081017,
         -0.06175838594237262,
         0.0873291830694649,
         -0.08968758818619495,
         0.04293591626556062,
         -0.06399242989624979,
         0.07314532447743813,
         -0.07508481527929475,
         0.07104678836103133,
         -0.059778345213573066,
         0.04037240850429498,
         -0.0036912401115052054,
         0.005129206006698902,
         -0.002888362737540076,
         -5.177428636929143e-05,
         0.0015793763186678054,
         -0.0019654171359670286,
         0.0024017691130588637,
         -0.004231640524290315,
         0.003938536119385076,
         -0.0025810636028792016,
         0.00165229760368873,
         -0.0007581673732201279,
         0.0012636230725909389,
         -0.0008609612510229384,
         -4.715626991595581e-05,
         0.0007102286948861929,
         -0.0009395442503253306,
         0.0007102286948861823,
         -0.0005290338343288224,
         0.0005290338343288267,
         -0.12123005519323987,
         0.022004588382437594,
         0.04317201568195032,
         -0.07972467556929741,
         0.08998793650819063,
         -0.07477733156499339,
         0.033894826559329475,
         0.03390261744919815,
         -0.1309423302687099,
         0.09922546681080227,
         -0.08622054282704587,
         0.054828989831021004,
         -0.016227640393770067,
         -0.02405007810475931,
         0.06132375750849625,
         -0.08968758818619493,
         0.09703971281951174,
         -0.03404886274641446,
         0.04293591626556066,
         -0.04713276261809723,
         0.04814108146815932,
         -0.04602568411595127,
         0.04037240850429499,
         -0.029242268810984233,
         0.0054249185693740236,
         -0.0036912401115052063,
         0.0015412126282500723,
         0.0003742494231204635,
         -0.0019654171359670394,
         0.0023273298081209013,
         -0.003090373340787931,
         0.0024017691130588667,
         -0.001817166856184805,
         0.0016522976036887147,
         -0.0010842908677247888,
         0.0015713611785662226,
         -0.0007581673732201238,
         -4.7156269915946704e-05,
         3.9286107705879774e-05,
         -0.0010659162630861658,
         0.0007102286948861828,
         -7.848594428548264e-06,
         0.0005290338343288385,
         -0.0005290338343288096},
        {0.002328096904216386,
         -0.002328096904216939,
         -0.0030273837817175464,
         0.000925069586478533,
         0.0016288100267162209,
         0.002599426271215538,
         0.0006419362657532207,
         -0.0016908665820041802,
         -0.0005015656387132206,
         0.03068775765832288,
         -0.052631659055147634,
         0.05891143124494305,
         -0.0501726689448007,
         0.03223354766974662,
         -0.08061319871422695,
         0.07893905346256931,
         -0.03144335043279399,
         -0.030654750552015646,
         0.07582027335504561,
         -0.08018649899345079,
         0.10405280943813233,
         -0.035159416085858215,
         -0.04748493323217205,
         0.08149686495102212,
         -0.0482330647679111,
         -0.031574749737015864,
         0.10123633215146133,
         -0.08264132596236756,
         -0.02832473023892131,
         0.06727664129950539,
         -0.02903803182591796,
         -0.039147137366448224,
         0.0774929126345788,
         -0.04049601322930157,
         -0.07062422355308602,
         0.04458411347417867,
         0.038057212488188864,
         -0.01664572901242406,
         -0.028205365187246232,
         0.04657062905491795,
         -0.021811805464225596,
         -0.029850136292160306,
         0.06046224489053561,
         0.010161978662550369,
         -0.0023280969042168884,
         0.0023280969042168962,
         0.0009250695864789735,
         -0.0012237520356264463,
         0.0009250695864789914,
         0.0006419362657531728,
         0.0008407273474615366,
         -0.0003162621893359327,
         -0.0016908665820043172,
         -0.05263165905514761,
         0.07965562915400072,
         -0.09175954709749602,
         0.08236782058930325,
         -0.050172668944800713,
         0.07893905346256928,
         -0.07228340047423694,
         0.03097429592415113,
         0.02647447187708011,
         -0.07278597090142334,
         0.07582027335504561,
         -0.035159416085858194,
         0.008538720203254118,
         0.0165171500690979,
         -0.02909814594931877,
         0.020518219759009537,
         0.007666245289714296,
         -0.03157474973701587,
         -0.028324730238921302,
         -0.013843589226756561,
         0.032593176418960285,
         -0.019216752468851538,
         -0.0047214655464688235,
         0.015519151754557483,
         -0.0003030174987806323,
         -0.040496013229301554,
         0.038057212488188885,
         0.08205420955676708,
         -0.04679913685424574,
         -0.026796437092832522,
         0.0612395895909923,
         -0.03253050451091165,
         -0.03281804261255126,
         0.06373316870970717,
         0.06046224489053564,
         -0.08264132596236756,
         -0.02832473023892133,
         0.06727664129950539,
         -0.02903803182591796,
         -0.039147137366448245,
         0.07749291263457882,
         -0.040496013229301575,
         -0.07062422355308601,
         0.0016288100267161105,
         0.0009250695864789809,
         -0.003027383781717648,
         -0.0016908665820043005,
         -0.00031626218933591927,
         0.0008407273474615389,
         0.0006419362657531699,
         0.05891143124494308,
         -0.09175954709749601,
         0.10352108142868581,
         -0.09175954709749604,
         0.05891143124494309,
         -0.03144335043279399,
         0.030974295924151112,
         -0.012631447209724516,
         -0.009965320206996824,
         0.02647447187708013,
         -0.030654750552015643,
         -0.04748493323217206,
         0.016517150069097895,
         0.01552026552444643,
         -0.03036184322385197,
         0.01661896142833991,
         0.020518219759009543,
         -0.0482330647679111,
         0.06727664129950539,
         0.03259317641896028,
         -0.06523767875717669,
         0.03783999791228555,
         0.016867100873615815,
         -0.04978727260167724,
         0.015519151754557451,
         0.0774929126345788,
         -0.016645729012424053,
         -0.04679913685424576,
         0.023685537834334955,
         0.012807661175433943,
         -0.03262794656259745,
         0.020576671166653248,
         0.015523996067947248,
         -0.03281804261255124,
         -0.029850136292160316,
         -0.028324730238921302,
         -0.013843589226756586,
         0.032593176418960285,
         -0.019216752468851562,
         -0.004721465546468848,
         0.015519151754557446,
         -0.0003030174987806324,
         -0.04049601322930156,
         0.10405280943813236,
         -0.035159416085858215,
         -0.04748493323217205,
         0.08149686495102211,
         -0.0482330647679111,
         -0.031574749737015885,
         0.10123633215146134,
         -0.0005015656387131852,
         -0.001690866582004327,
         0.0006419362657531793,
         0.002599426271215509,
         -0.05017266894480072,
         0.0823678205893033,
         -0.09175954709749604,
         0.07965562915400078,
         -0.05263165905514762,
         -0.03065475055201563,
         0.026474471877080106,
         -0.009965320206996876,
         -0.012631447209724526,
         0.030974295924151112,
         -0.03144335043279402,
         0.08149686495102212,
         -0.029098145949318765,
         -0.03036184322385197,
         0.05460096026616177,
         -0.030361843223851978,
         -0.02909814594931879,
         0.08149686495102212,
         -0.029038031825917954,
         -0.01921675246885154,
         0.037839997912285546,
         -0.023402932694618756,
         -0.0023942540070466278,
         0.016867100873615797,
         -0.004721465546468808,
         -0.039147137366448245,
         -0.028205365187246253,
         -0.026796437092832515,
         0.01280766117543397,
         0.012543157562129911,
         -0.025038398885162745,
         0.011431116006876806,
         0.02057667116665323,
         -0.032530504510911634,
         -0.021811805464225613,
         0.06727664129950543,
         0.032593176418960285,
         -0.06523767875717663,
         0.03783999791228554,
         0.016867100873615808,
         -0.049787272601677236,
         0.015519151754557441,
         0.0774929126345788,
         -0.03515941608585822,
         0.008538720203254094,
         0.016517150069097902,
         -0.02909814594931878,
         0.020518219759009554,
         0.0076662452897143215,
         -0.03157474973701588,
         -0.08061319871422692,
         0.0789390534625693,
         -0.031443350432794004,
         -0.030654750552015622,
         0.07582027335504557,
         -0.08018649899345077,
         0.0322335476697466,
         -0.050172668944800686,
         0.05891143124494308,
         -0.0526316590551476,
         0.030687757658322854,
         0.07582027335504558,
         -0.07278597090142332,
         0.02647447187708015,
         0.03097429592415113,
         -0.0722834004742369,
         0.0789390534625693,
         -0.048233064767911116,
         0.020518219759009578,
         0.016618961428339907,
         -0.03036184322385192,
         0.01552026552444643,
         0.016517150069097902,
         -0.047484933232172066,
         -0.03914713736644823,
         -0.004721465546468802,
         0.01686710087361581,
         -0.0023942540070466117,
         -0.02340293269461874,
         0.03783999791228554,
         -0.019216752468851562,
         -0.02903803182591797,
         0.04657062905491798,
         0.06123958959099231,
         -0.03262794656259746,
         -0.025038398885162735,
         0.050835585586828,
         -0.025038398885162738,
         -0.03262794656259746,
         0.06123958959099231,
         0.04657062905491797,
         -0.02903803182591796,
         -0.019216752468851545,
         0.03783999791228553,
         -0.023402932694618777,
         -0.0023942540070466256,
         0.016867100873615808,
         -0.004721465546468814,
         -0.03914713736644823,
         -0.047484933232172066,
         0.01651715006909787,
         0.015520265524446474,
         -0.030361843223851943,
         0.016618961428339907,
         0.020518219759009575,
         -0.04823306476791111,
         0.07893905346256931,
         -0.07228340047423691,
         0.030974295924151126,
         0.02647447187708015,
         -0.07278597090142333,
         0.0758202733550456,
         0.03068775765832283,
         -0.052631659055147606,
         0.05891143124494309,
         -0.05017266894480073,
         0.03223354766974661,
         -0.08018649899345077,
         0.07582027335504558,
         -0.030654750552015643,
         -0.03144335043279403,
         0.0789390534625693,
         -0.08061319871422692,
         -0.03157474973701588,
         0.007666245289714296,
         0.02051821975900956,
         -0.029098145949318765,
         0.016517150069097895,
         0.008538720203254134,
         -0.03515941608585822,
         0.0774929126345788,
         0.015519151754557469,
         -0.049787272601677236,
         0.01686710087361583,
         0.03783999791228554,
         -0.06523767875717673,
         0.03259317641896027,
         0.06727664129950539,
         -0.021811805464225602,
         -0.03253050451091161,
         0.020576671166653213,
         0.011431116006876824,
         -0.02503839888516276,
         0.012543157562129946,
         0.012807661175433964,
         -0.026796437092832512,
         -0.028205365187246263,
         -0.039147137366448245,
         -0.0047214655464688105,
         0.016867100873615808,
         -0.002394254007046666,
         -0.023402932694618756,
         0.03783999791228552,
         -0.019216752468851562,
         -0.029038031825917975,
         0.08149686495102211,
         -0.029098145949318775,
         -0.030361843223851954,
         0.05460096026616178,
         -0.030361843223851964,
         -0.02909814594931877,
         0.08149686495102211,
         -0.03144335043279401,
         0.030974295924151112,
         -0.012631447209724492,
         -0.009965320206996852,
         0.026474471877080134,
         -0.03065475055201564,
         -0.05263165905514761,
         0.07965562915400079,
         -0.09175954709749605,
         0.08236782058930328,
         -0.05017266894480071,
         0.0025994262712155324,
         0.0006419362657531691,
         -0.0016908665820043558,
         -0.0005015656387131915,
         0.10123633215146131,
         -0.03157474973701586,
         -0.04823306476791112,
         0.08149686495102214,
         -0.04748493323217205,
         -0.03515941608585822,
         0.10405280943813236,
         -0.040496013229301596,
         -0.00030301749878063213,
         0.015519151754557444,
         -0.004721465546468827,
         -0.019216752468851562,
         0.03259317641896028,
         -0.013843589226756573,
         -0.028324730238921313,
         -0.029850136292160323,
         -0.032818042612551224,
         0.015523996067947276,
         0.02057667116665322,
         -0.032627946562597446,
         0.012807661175433954,
         0.02368553783433498,
         -0.046799136854245735,
         -0.016645729012424046,
         0.07749291263457882,
         0.015519151754557457,
         -0.04978727260167725,
         0.01686710087361581,
         0.03783999791228555,
         -0.06523767875717663,
         0.032593176418960285,
         0.06727664129950539,
         -0.048233064767911116,
         0.020518219759009526,
         0.01661896142833994,
         -0.03036184322385195,
         0.015520265524446483,
         0.01651715006909791,
         -0.04748493323217208,
         -0.030654750552015633,
         0.026474471877080123,
         -0.009965320206996845,
         -0.012631447209724495,
         0.03097429592415112,
         -0.031443350432794025,
         0.058911431244943066,
         -0.09175954709749604,
         0.10352108142868577,
         -0.09175954709749602,
         0.05891143124494307,
         0.0006419362657531464,
         0.0008407273474615728,
         -0.00031626218933596183,
         -0.0016908665820043074,
         -0.0030273837817176934,
         0.0009250695864789815,
         0.0016288100267161114,
         -0.07062422355308602,
         -0.040496013229301575,
         0.0774929126345788,
         -0.03914713736644823,
         -0.029038031825917965,
         0.06727664129950539,
         -0.02832473023892133,
         -0.08264132596236753,
         0.060462244890535616,
         0.0637331687097072,
         -0.03281804261255125,
         -0.032530504510911634,
         0.061239589590992315,
         -0.026796437092832522,
         -0.04679913685424573,
         0.08205420955676707,
         0.03805721248818887,
         -0.04049601322930157,
         -0.0003030174987806393,
         0.015519151754557467,
         -0.0047214655464688305,
         -0.01921675246885154,
         0.03259317641896027,
         -0.013843589226756556,
         -0.028324730238921316,
         -0.03157474973701588,
         0.0076662452897142885,
         0.020518219759009554,
         -0.029098145949318765,
         0.016517150069097875,
         0.008538720203254137,
         -0.03515941608585821,
         0.0758202733550456,
         -0.07278597090142332,
         0.0264744718770801,
         0.030974295924151116,
         -0.07228340047423691,
         0.07893905346256927,
         -0.05017266894480071,
         0.08236782058930327,
         -0.09175954709749605,
         0.07965562915400076,
         -0.05263165905514761,
         -0.0016908665820043074,
         -0.00031626218933596204,
         0.0008407273474615584,
         0.0006419362657531778,
         0.0009250695864789646,
         -0.0012237520356264402,
         0.0009250695864789673,
         0.002328096904216898,
         -0.0023280969042169196,
         0.010161978662550345,
         0.060462244890535595,
         -0.02985013629216033,
         -0.021811805464225606,
         0.04657062905491797,
         -0.02820536518724626,
         -0.01664572901242407,
         0.03805721248818888,
         0.044584113474178615,
         -0.07062422355308602,
         -0.04049601322930157,
         0.0774929126345788,
         -0.03914713736644825,
         -0.02903803182591797,
         0.0672766412995054,
         -0.028324730238921333,
         -0.08264132596236755,
         0.10123633215146133,
         -0.031574749737015864,
         -0.04823306476791112,
         0.08149686495102211,
         -0.04748493323217204,
         -0.035159416085858215,
         0.10405280943813233,
         -0.08018649899345076,
         0.07582027335504557,
         -0.030654750552015636,
         -0.03144335043279401,
         0.07893905346256926,
         -0.08061319871422692,
         0.03223354766974661,
         -0.05017266894480073,
         0.05891143124494307,
         -0.05263165905514763,
         0.030687757658322865,
         -0.0005015656387131666,
         -0.0016908665820043022,
         0.000641936265753161,
         0.002599426271215505,
         0.0016288100267161036,
         0.0009250695864789848,
         -0.0030273837817176947,
         -0.0023280969042169418,
         0.0023280969042168784},
        {-0.0022450023443224562,
         0.002245002344322615,
         0.0022665337134250424,
         -2.848332401572673e-05,
         -0.0022234709752200765,
         -0.00191498140041918,
         -0.0005273284695088282,
         0.0005596255231624658,
         0.001850387293111687,
         0.0049830726033452954,
         -0.004851078135186176,
         0.006130883645950158,
         -0.005996828244738068,
         0.0019423399049286524,
         -0.008866914112118285,
         0.006140892619413719,
         -0.0015416231722826467,
         -0.004920895624610649,
         0.010113944908596255,
         -0.008338960313054184,
         0.010183521640487986,
         -0.0019749112925545546,
         -0.00460264725035013,
         0.006393239364755149,
         -0.0013967879152643342,
         -0.008426293997940738,
         0.013956489645014683,
         0.02931675953432753,
         -0.05225396035284405,
         0.06122533305477782,
         -0.060478014319503615,
         0.05512904650294883,
         -0.051131369040550156,
         0.05252492168934343,
         -0.05366159833734194,
         -0.1426883494729584,
         0.11337158993863082,
         -0.07387130876381531,
         0.033054420060630085,
         0.005195234662151802,
         -0.040061905098683556,
         0.07414948445905034,
         -0.11385459315137758,
         0.16751619148871963,
         0.0022450023443225877,
         -0.0022450023443225976,
         -2.8483324015959183e-05,
         3.767989592938373e-05,
         -2.848332401596959e-05,
         -0.0005273284695088386,
         -0.0014378611132324637,
         0.0014217125864056015,
         0.0005596255231625656,
         -0.00485107813518619,
         0.010376202111997732,
         -0.009736503181363907,
         0.006791992417245381,
         -0.005996828244738055,
         0.006140892619413724,
         -0.007022448367962467,
         -0.0003414320417488223,
         0.006517351777310493,
         -0.008452072930141486,
         0.010113944908596226,
         -0.001974911292554539,
         0.0021196772790176457,
         0.0012178537851184716,
         0.00010391914820717489,
         -0.0035036904772169555,
         0.004986850289651506,
         -0.00842629399794074,
         -0.05225396035284406,
         0.06190433735427098,
         -0.07110351624055727,
         0.07680026470409286,
         -0.08094229066819955,
         0.08099589814423193,
         -0.07080098885967624,
         0.052524921689343446,
         0.11337158993863083,
         -0.07356285741703118,
         0.05115880123757574,
         -0.029268282835841992,
         0.0032622260534735472,
         0.029592282568179338,
         -0.06693637110979789,
         0.09803225127714683,
         -0.11385459315137764,
         0.029316759534327535,
         -0.05225396035284404,
         0.06122533305477779,
         -0.060478014319503615,
         0.05512904650294885,
         -0.05113136904055013,
         0.05252492168934346,
         -0.05366159833734193,
         -0.0022234709752200995,
         -2.848332401597653e-05,
         0.0022665337134250745,
         0.0005596255231625543,
         0.001421712586405588,
         -0.0014378611132324585,
         -0.0005273284695088386,
         0.006130883645950182,
         -0.009736503181363909,
         0.011056305408517464,
         -0.009736503181363907,
         0.006130883645950179,
         -0.0015416231722826506,
         -0.000341432041748794,
         0.0010720441141345268,
         -0.003541560836892634,
         0.006517351777310482,
         -0.00492089562461066,
         -0.004602647250350138,
         0.0012178537851184924,
         0.005974924026444339,
         -0.007127041883591463,
         0.004850058725425835,
         -0.0035036904772169637,
         -0.0013967879152643383,
         0.06122533305477777,
         -0.07110351624055725,
         0.07704851816991835,
         -0.08858843825883347,
         0.09562853514512851,
         -0.09263985506701028,
         0.0809958981442319,
         -0.05113136904055012,
         -0.0738713087638154,
         0.05115880123757577,
         -0.03243932945695096,
         0.01809821839195154,
         0.0016884418794326228,
         -0.024688456930467964,
         0.04589664409549311,
         -0.06693637110979789,
         0.07414948445905042,
         -0.052253960352844055,
         0.06190433735427099,
         -0.07110351624055727,
         0.07680026470409285,
         -0.08094229066819954,
         0.08099589814423193,
         -0.07080098885967624,
         0.05252492168934345,
         0.010183521640488007,
         -0.001974911292554552,
         -0.004602647250350134,
         0.006393239364755152,
         -0.0013967879152643348,
         -0.008426293997940738,
         0.013956489645014676,
         0.0018503872931117243,
         0.0005596255231625664,
         -0.000527328469508842,
         -0.0019149814004191645,
         -0.005996828244738054,
         0.006791992417245384,
         -0.009736503181363912,
         0.010376202111997725,
         -0.004851078135186187,
         -0.004920895624610667,
         0.006517351777310477,
         -0.0035415608368926143,
         0.0010720441141345196,
         -0.00034143204174881016,
         -0.0015416231722826402,
         0.006393239364755152,
         0.0001039191482071853,
         -0.0071270418835914515,
         0.009982078499946657,
         -0.007127041883591451,
         0.00010391914820719918,
         0.006393239364755167,
         -0.06047801431950364,
         0.0768002647040929,
         -0.08858843825883356,
         0.09491805083578259,
         -0.09813882373625957,
         0.0956285351451286,
         -0.0809422906681996,
         0.05512904650294889,
         0.03305442006063013,
         -0.02926828283584201,
         0.01809821839195154,
         -0.0017663234768315467,
         -0.009109355582416523,
         0.016526985209456023,
         -0.024688456930467964,
         0.02959228256817937,
         -0.04006190509868361,
         0.06122533305477778,
         -0.07110351624055727,
         0.07704851816991834,
         -0.0885884382588335,
         0.09562853514512852,
         -0.09263985506701028,
         0.08099589814423193,
         -0.05113136904055011,
         -0.001974911292554555,
         0.0021196772790176887,
         0.0012178537851184777,
         0.00010391914820719224,
         -0.003503690477216959,
         0.004986850289651488,
         -0.008426293997940752,
         -0.008866914112118287,
         0.006140892619413724,
         -0.0015416231722826471,
         -0.00492089562461066,
         0.010113944908596233,
         -0.008338960313054169,
         0.0019423399049286734,
         -0.005996828244738069,
         0.0061308836459501685,
         -0.004851078135186179,
         0.004983072603345291,
         0.010113944908596247,
         -0.008452072930141495,
         0.00651735177731046,
         -0.0003414320417488015,
         -0.007022448367962484,
         0.006140892619413724,
         -0.0013967879152643366,
         -0.003503690477216973,
         0.0048500587254258366,
         -0.007127041883591474,
         0.00597492402644436,
         0.0012178537851184942,
         -0.004602647250350126,
         0.05512904650294887,
         -0.0809422906681996,
         0.09562853514512859,
         -0.09813882373625955,
         0.09491805083578259,
         -0.08858843825883356,
         0.0768002647040929,
         -0.06047801431950364,
         0.005195234662151802,
         0.003262226053473548,
         0.0016884418794326055,
         -0.00910935558241652,
         0.012330128482893499,
         -0.009109355582416507,
         0.0016884418794326124,
         0.0032622260534735477,
         0.005195234662151806,
         -0.06047801431950363,
         0.0768002647040929,
         -0.08858843825883357,
         0.09491805083578259,
         -0.09813882373625954,
         0.09562853514512862,
         -0.08094229066819958,
         0.05512904650294888,
         -0.004602647250350126,
         0.0012178537851184838,
         0.0059749240264443185,
         -0.007127041883591461,
         0.0048500587254258305,
         -0.003503690477216973,
         -0.0013967879152643357,
         0.006140892619413731,
         -0.007022448367962468,
         -0.00034143204174880387,
         0.006517351777310454,
         -0.008452072930141484,
         0.01011394490859623,
         0.004983072603345287,
         -0.004851078135186173,
         0.006130883645950179,
         -0.005996828244738053,
         0.001942339904928661,
         -0.008338960313054172,
         0.010113944908596233,
         -0.004920895624610667,
         -0.0015416231722826385,
         0.006140892619413735,
         -0.008866914112118273,
         -0.008426293997940752,
         0.0049868502896515034,
         -0.0035036904772169607,
         0.00010391914820717836,
         0.001217853785118482,
         0.0021196772790176522,
         -0.0019749112925545546,
         -0.051131369040550136,
         0.08099589814423191,
         -0.0926398550670103,
         0.09562853514512851,
         -0.08858843825883347,
         0.07704851816991835,
         -0.07110351624055725,
         0.061225333054777814,
         -0.040061905098683626,
         0.02959228256817935,
         -0.02468845693046796,
         0.016526985209456026,
         -0.00910935558241651,
         -0.0017663234768315501,
         0.018098218391951533,
         -0.02926828283584201,
         0.033054420060630134,
         0.055129046502948885,
         -0.08094229066819957,
         0.09562853514512862,
         -0.09813882373625955,
         0.09491805083578256,
         -0.08858843825883359,
         0.07680026470409292,
         -0.06047801431950363,
         0.0063932393647551725,
         0.00010391914820718183,
         -0.007127041883591449,
         0.009982078499946662,
         -0.007127041883591445,
         0.00010391914820717869,
         0.0063932393647551725,
         -0.001541623172282635,
         -0.0003414320417487963,
         0.001072044114134509,
         -0.0035415608368926143,
         0.006517351777310466,
         -0.004920895624610674,
         -0.004851078135186178,
         0.010376202111997732,
         -0.009736503181363907,
         0.006791992417245384,
         -0.005996828244738055,
         -0.0019149814004191788,
         -0.0005273284695088368,
         0.0005596255231625738,
         0.0018503872931117209,
         0.013956489645014678,
         -0.008426293997940721,
         -0.0013967879152643285,
         0.0063932393647551655,
         -0.004602647250350126,
         -0.0019749112925545546,
         0.010183521640487983,
         0.052524921689343466,
         -0.07080098885967623,
         0.08099589814423191,
         -0.08094229066819955,
         0.07680026470409286,
         -0.07110351624055727,
         0.061904337354270964,
         -0.05225396035284401,
         0.0741494844590504,
         -0.06693637110979786,
         0.0458966440954931,
         -0.024688456930467974,
         0.0016884418794326124,
         0.018098218391951547,
         -0.03243932945695097,
         0.05115880123757578,
         -0.0738713087638154,
         -0.051131369040550136,
         0.0809958981442319,
         -0.09263985506701028,
         0.09562853514512851,
         -0.08858843825883347,
         0.07704851816991833,
         -0.07110351624055726,
         0.061225333054777786,
         -0.0013967879152643314,
         -0.003503690477216954,
         0.0048500587254258305,
         -0.0071270418835914584,
         0.005974924026444325,
         0.0012178537851184647,
         -0.004602647250350115,
         -0.004920895624610677,
         0.00651735177731047,
         -0.003541560836892608,
         0.001072044114134512,
         -0.00034143204174879455,
         -0.001541623172282628,
         0.006130883645950172,
         -0.009736503181363917,
         0.011056305408517472,
         -0.009736503181363917,
         0.0061308836459501755,
         -0.0005273284695088299,
         -0.0014378611132324845,
         0.0014217125864056032,
         0.0005596255231625664,
         0.002266533713425105,
         -2.848332401596959e-05,
         -0.0022234709752201043,
         -0.05366159833734195,
         0.052524921689343446,
         -0.051131369040550156,
         0.055129046502948836,
         -0.0604780143195036,
         0.061225333054777786,
         -0.05225396035284403,
         0.02931675953432751,
         -0.11385459315137764,
         0.0980322512771468,
         -0.06693637110979787,
         0.02959228256817933,
         0.0032622260534735433,
         -0.02926828283584198,
         0.05115880123757573,
         -0.07356285741703118,
         0.11337158993863083,
         0.05252492168934345,
         -0.07080098885967623,
         0.08099589814423193,
         -0.08094229066819952,
         0.07680026470409287,
         -0.07110351624055726,
         0.06190433735427099,
         -0.05225396035284402,
         -0.008426293997940752,
         0.004986850289651502,
         -0.0035036904772169607,
         0.00010391914820718964,
         0.0012178537851184734,
         0.002119677279017653,
         -0.001974911292554558,
         0.01011394490859625,
         -0.00845207293014149,
         0.0065173517773104905,
         -0.0003414320417488006,
         -0.007022448367962477,
         0.0061408926194137375,
         -0.005996828244738055,
         0.006791992417245388,
         -0.009736503181363902,
         0.010376202111997739,
         -0.004851078135186184,
         0.0005596255231625664,
         0.001421712586405591,
         -0.0014378611132324776,
         -0.000527328469508842,
         -2.8483324015962652e-05,
         3.767989592937289e-05,
         -2.848332401596612e-05,
         -0.0022450023443226046,
         0.0022450023443226054,
         0.1675161914887195,
         -0.11385459315137755,
         0.07414948445905035,
         -0.04006190509868358,
         0.005195234662151795,
         0.03305442006063008,
         -0.07387130876381533,
         0.11337158993863079,
         -0.1426883494729584,
         -0.05366159833734192,
         0.052524921689343446,
         -0.05113136904055013,
         0.05512904650294885,
         -0.060478014319503594,
         0.06122533305477782,
         -0.05225396035284402,
         0.02931675953432752,
         0.013956489645014681,
         -0.008426293997940738,
         -0.001396787915264329,
         0.006393239364755169,
         -0.004602647250350133,
         -0.001974911292554539,
         0.010183521640487986,
         -0.008338960313054186,
         0.010113944908596247,
         -0.00492089562461067,
         -0.0015416231722826333,
         0.006140892619413731,
         -0.008866914112118285,
         0.0019423399049286715,
         -0.005996828244738052,
         0.006130883645950179,
         -0.0048510781351861765,
         0.004983072603345282,
         0.0018503872931117243,
         0.0005596255231625647,
         -0.0005273284695088316,
         -0.0019149814004191575,
         -0.002223470975220118,
         -2.848332401596612e-05,
         0.0022665337134251014,
         0.002245002344322615,
         -0.002245002344322594},
        {-0.24253562503633264,
         0.12126781251816598,
         0.12126781251816629,
         -0.056591645841810694,
         -0.08555852638929934,
         -0.05659164584181081,
         0.024253562503633277,
         0.04850712500726666,
         0.04850712500726669,
         0.02425356250363334,
         -0.009328293270628172,
         -0.02359892273376522,
         -0.03121844038128564,
         -0.023598922733765217,
         -0.009328293270628164,
         0.0031094310902093957,
         0.009832884472402216,
         0.016453562767173052,
         0.01645356276717304,
         0.009832884472402215,
         0.0031094310902093974,
         -0.0008480266609661919,
         -0.0033921066438648015,
         -0.00709510008665583,
         -0.008974670600276204,
         -0.0070951000866558275,
         -0.0033921066438648033,
         -0.0008480266609662085,
         0.00016960533219326907,
         0.0008974670600276223,
         0.00237447465070536,
         0.0037543740712808367,
         0.0037543740712808575,
         0.0023744746507053617,
         0.0008974670600276167,
         0.00016960533219322518,
         -1.884503691034492e-05,
         -0.00015076029528288885,
         -0.0005276610334900647,
         -0.001055322066980144,
         -0.0013191525837251959,
         -0.0010553220669801606,
         -0.00052766103349007,
         -0.00015076029528287977,
         -1.8845036910354422e-05,
         0.1212678125181662,
         0.12126781251816623,
         -0.0855585263892994,
         -0.12935233335271043,
         -0.08555852638929941,
         0.04850712500726672,
         0.09701425001453332,
         0.09701425001453332,
         0.0485071250072667,
         -0.023598922733765196,
         -0.05970107693202043,
         -0.07897710128243042,
         -0.05970107693202038,
         -0.02359892273376521,
         0.00983288447240219,
         0.031094310902094,
         0.05203073396880948,
         0.052030733968809494,
         0.031094310902093997,
         0.009832884472402194,
         -0.003392106643864799,
         -0.013568426575459206,
         -0.028380400346623348,
         -0.03589868240110485,
         -0.028380400346623345,
         -0.013568426575459216,
         -0.003392106643864799,
         0.0008974670600276176,
         0.004748949301410713,
         0.0125645388403867,
         0.019866280242636387,
         0.01986628024263638,
         0.012564538840386703,
         0.004748949301410708,
         0.0008974670600276175,
         -0.0001507602952828794,
         -0.001206082362263035,
         -0.004221288267920631,
         -0.008442576535841283,
         -0.010553220669801588,
         -0.00844257653584129,
         -0.0042212882679206285,
         -0.0012060823622630273,
         -0.00015076029528289045,
         0.00016960533219326367,
         0.0008974670600276149,
         0.002374474650705364,
         0.0037543740712808467,
         0.0037543740712808354,
         0.002374474650705361,
         0.0008974670600276203,
         0.00016960533219324573,
         -0.05659164584181075,
         -0.0855585263892993,
         -0.05659164584181078,
         0.04850712500726672,
         0.0970142500145333,
         0.09701425001453333,
         0.04850712500726673,
         -0.031218440381285628,
         -0.07897710128243045,
         -0.10447688463103567,
         -0.07897710128243046,
         -0.031218440381285628,
         0.01645356276717303,
         0.0520307339688095,
         0.08706407052586315,
         0.0870640705258632,
         0.0520307339688095,
         0.016453562767173028,
         -0.0070951000866558474,
         -0.028380400346623376,
         -0.05936186626763399,
         -0.07508748142561689,
         -0.05936186626763399,
         -0.028380400346623397,
         -0.007095100086655833,
         0.0023744746507053543,
         0.012564538840386684,
         0.03324264510987509,
         0.05256123699793189,
         0.052561236997931894,
         0.03324264510987507,
         0.012564538840386684,
         0.0023744746507053612,
         -0.0005276610334900782,
         -0.004221288267920642,
         -0.014774508937722244,
         -0.029549017875444523,
         -0.03693627234430562,
         -0.029549017875444516,
         -0.014774508937722235,
         -0.0042212882679206415,
         -0.0005276610334900791,
         0.0008974670600276275,
         0.004748949301410702,
         0.012564538840386694,
         0.019866280242636397,
         0.01986628024263637,
         0.012564538840386682,
         0.004748949301410701,
         0.0008974670600276145,
         -0.0008480266609662068,
         -0.003392106643864813,
         -0.007095100086655836,
         -0.008974670600276196,
         -0.0070951000866558344,
         -0.0033921066438647894,
         -0.0008480266609661956,
         0.02425356250363337,
         0.04850712500726668,
         0.04850712500726668,
         0.024253562503633346,
         -0.023598922733765213,
         -0.05970107693202036,
         -0.07897710128243046,
         -0.05970107693202039,
         -0.023598922733765217,
         0.016453562767173024,
         0.05203073396880949,
         0.08706407052586317,
         0.08706407052586314,
         0.0520307339688095,
         0.016453562767173024,
         -0.008974670600276196,
         -0.035898682401104776,
         -0.07508748142561676,
         -0.09497898602821452,
         -0.07508748142561673,
         -0.03589868240110486,
         -0.008974670600276194,
         0.0037543740712808397,
         0.01986628024263636,
         0.0525612369979318,
         0.08310661277468781,
         0.08310661277468781,
         0.05256123699793178,
         0.019866280242636352,
         0.003754374071280835,
         -0.0010553220669801606,
         -0.008442576535841281,
         -0.02954901787544447,
         -0.05909803575088906,
         -0.07387254468861124,
         -0.059098035750889046,
         -0.029549017875444464,
         -0.00844257653584128,
         -0.0010553220669801612,
         0.002374474650705354,
         0.012564538840386703,
         0.03324264510987512,
         0.05256123699793188,
         0.05256123699793189,
         0.03324264510987508,
         0.012564538840386679,
         0.0023744746507053625,
         -0.0033921066438648124,
         -0.013568426575459232,
         -0.02838040034662337,
         -0.03589868240110485,
         -0.028380400346623355,
         -0.013568426575459182,
         -0.0033921066438647846,
         0.003109431090209405,
         0.009832884472402213,
         0.016453562767173035,
         0.016453562767173052,
         0.009832884472402194,
         0.0031094310902094074,
         -0.009328293270628174,
         -0.0235989227337652,
         -0.03121844038128565,
         -0.023598922733765227,
         -0.00932829327062819,
         0.009832884472402185,
         0.031094310902094007,
         0.05203073396880954,
         0.05203073396880952,
         0.031094310902094035,
         0.009832884472402194,
         -0.007095100086655839,
         -0.028380400346623334,
         -0.059361866267634004,
         -0.07508748142561683,
         -0.05936186626763399,
         -0.02838040034662341,
         -0.007095100086655842,
         0.0037543740712808397,
         0.019866280242636352,
         0.0525612369979318,
         0.0831066127746878,
         0.08310661277468781,
         0.0525612369979318,
         0.019866280242636345,
         0.003754374071280835,
         -0.0013191525837252002,
         -0.010553220669801607,
         -0.036936272344305604,
         -0.07387254468861136,
         -0.09234068086076415,
         -0.07387254468861136,
         -0.036936272344305604,
         -0.010553220669801603,
         -0.0013191525837251991,
         0.0037543740712808406,
         0.01986628024263636,
         0.0525612369979318,
         0.08310661277468781,
         0.08310661277468778,
         0.05256123699793179,
         0.019866280242636345,
         0.0037543740712808393,
         -0.007095100086655849,
         -0.02838040034662341,
         -0.059361866267634,
         -0.07508748142561686,
         -0.059361866267634004,
         -0.02838040034662333,
         -0.007095100086655836,
         0.009832884472402199,
         0.031094310902094024,
         0.052030733968809514,
         0.05203073396880953,
         0.031094310902093986,
         0.009832884472402192,
         -0.009328293270628183,
         -0.023598922733765217,
         -0.03121844038128564,
         -0.02359892273376522,
         -0.00932829327062817,
         0.0031094310902094035,
         0.009832884472402192,
         0.01645356276717305,
         0.01645356276717304,
         0.009832884472402206,
         0.003109431090209401,
         -0.0033921066438647915,
         -0.013568426575459189,
         -0.028380400346623355,
         -0.035898682401104845,
         -0.02838040034662337,
         -0.01356842657545922,
         -0.003392106643864807,
         0.002374474650705374,
         0.012564538840386694,
         0.033242645109875076,
         0.0525612369979319,
         0.052561236997931894,
         0.03324264510987508,
         0.012564538840386712,
         0.002374474650705357,
         -0.001055322066980165,
         -0.008442576535841273,
         -0.029549017875444474,
         -0.059098035750889025,
         -0.07387254468861122,
         -0.059098035750889046,
         -0.029549017875444453,
         -0.00844257653584128,
         -0.0010553220669801634,
         0.0037543740712808384,
         0.01986628024263634,
         0.05256123699793178,
         0.08310661277468777,
         0.08310661277468781,
         0.05256123699793177,
         0.01986628024263635,
         0.003754374071280837,
         -0.008974670600276197,
         -0.03589868240110484,
         -0.07508748142561673,
         -0.09497898602821452,
         -0.07508748142561676,
         -0.035898682401104776,
         -0.008974670600276196,
         0.01645356276717302,
         0.0520307339688095,
         0.08706407052586317,
         0.08706407052586321,
         0.05203073396880952,
         0.016453562767173042,
         -0.023598922733765213,
         -0.05970107693202039,
         -0.07897710128243048,
         -0.0597010769320204,
         -0.023598922733765203,
         0.024253562503633377,
         0.048507125007266706,
         0.04850712500726667,
         0.02425356250363337,
         -0.0008480266609662036,
         -0.003392106643864787,
         -0.007095100086655838,
         -0.008974670600276194,
         -0.0070951000866558344,
         -0.0033921066438648115,
         -0.0008480266609662145,
         0.0008974670600276199,
         0.004748949301410704,
         0.012564538840386684,
         0.019866280242636383,
         0.019866280242636383,
         0.012564538840386713,
         0.004748949301410721,
         0.0008974670600276165,
         -0.0005276610334900752,
         -0.004221288267920636,
         -0.014774508937722232,
         -0.02954901787544452,
         -0.036936272344305604,
         -0.029549017875444533,
         -0.014774508937722246,
         -0.004221288267920635,
         -0.0005276610334900775,
         0.00237447465070538,
         0.012564538840386686,
         0.033242645109875076,
         0.05256123699793189,
         0.05256123699793187,
         0.03324264510987511,
         0.012564538840386733,
         0.0023744746507053595,
         -0.007095100086655831,
         -0.028380400346623407,
         -0.05936186626763397,
         -0.07508748142561684,
         -0.05936186626763399,
         -0.028380400346623393,
         -0.007095100086655847,
         0.016453562767173042,
         0.05203073396880952,
         0.08706407052586321,
         0.08706407052586318,
         0.05203073396880953,
         0.016453562767173028,
         -0.031218440381285635,
         -0.07897710128243046,
         -0.10447688463103566,
         -0.07897710128243043,
         -0.031218440381285635,
         0.0485071250072667,
         0.0970142500145333,
         0.09701425001453329,
         0.048507125007266706,
         -0.05659164584181081,
         -0.0855585263892993,
         -0.056591645841810735,
         0.0001696053321932584,
         0.0008974670600276207,
         0.0023744746507053634,
         0.0037543740712808454,
         0.0037543740712808415,
         0.0023744746507053643,
         0.0008974670600276126,
         0.00016960533219327725,
         -0.00015076029528286167,
         -0.0012060823622630271,
         -0.0042212882679206355,
         -0.008442576535841278,
         -0.010553220669801583,
         -0.008442576535841281,
         -0.0042212882679206355,
         -0.0012060823622630367,
         -0.00015076029528288004,
         0.0008974670600276175,
         0.004748949301410702,
         0.012564538840386696,
         0.01986628024263638,
         0.019866280242636394,
         0.01256453884038671,
         0.00474894930141071,
         0.0008974670600276226,
         -0.0033921066438647837,
         -0.01356842657545921,
         -0.02838040034662335,
         -0.03589868240110485,
         -0.02838040034662339,
         -0.01356842657545919,
         -0.0033921066438648054,
         0.00983288447240219,
         0.03109431090209401,
         0.052030733968809514,
         0.05203073396880952,
         0.031094310902094042,
         0.0098328844724022,
         -0.023598922733765206,
         -0.05970107693202038,
         -0.07897710128243048,
         -0.059701076932020425,
         -0.023598922733765217,
         0.048507125007266706,
         0.09701425001453329,
         0.09701425001453329,
         0.0485071250072667,
         -0.08555852638929941,
         -0.1293523333527104,
         -0.08555852638929942,
         0.12126781251816626,
         0.12126781251816623,
         -1.88450369103463e-05,
         -0.00015076029528286308,
         -0.0005276610334900783,
         -0.0010553220669801515,
         -0.0013191525837251926,
         -0.001055322066980164,
         -0.0005276610334900755,
         -0.00015076029528288365,
         -1.884503691035115e-05,
         0.0001696053321932252,
         0.0008974670600276222,
         0.0023744746507053695,
         0.0037543740712808454,
         0.003754374071280838,
         0.0023744746507053643,
         0.0008974670600276133,
         0.00016960533219325405,
         -0.0008480266609661991,
         -0.003392106643864798,
         -0.007095100086655836,
         -0.0089746706002762,
         -0.007095100086655836,
         -0.003392106643864802,
         -0.0008480266609662033,
         0.0031094310902094,
         0.00983288447240219,
         0.01645356276717305,
         0.01645356276717304,
         0.009832884472402204,
         0.003109431090209403,
         -0.009328293270628167,
         -0.023598922733765213,
         -0.031218440381285642,
         -0.023598922733765217,
         -0.009328293270628167,
         0.024253562503633395,
         0.04850712500726671,
         0.04850712500726668,
         0.024253562503633346,
         -0.056591645841810714,
         -0.08555852638929931,
         -0.05659164584181082,
         0.1212678125181662,
         0.12126781251816626,
         -0.24253562503633255},
        {-0.004599384070258484,
         0.004599384070258598,
         0.04360032347743656,
         -0.05159339328464602,
         0.03440155533691955,
         -0.038395175214320884,
         -0.007807722394673441,
         0.06630913150544067,
         -0.0786076430072134,
         0.00835266770879341,
         0.04750137517008533,
         -0.04452948352027021,
         -0.030624648606679176,
         0.09797637143509463,
         0.015237778487458855,
         -0.03729977049990627,
         -0.012193249762917394,
         0.05913144674791285,
         -0.018848269198427702,
         -0.08605567931128949,
         -0.01992911838948028,
         0.007037009853032175,
         0.03388312880057457,
         -0.023522703991304197,
         -0.033781419517771895,
         0.04614460153580611,
         0.055292611620752115,
         0.010964394819991828,
         0.011859214568652798,
         -0.020484095207264772,
         -0.00828997859479839,
         0.027970484740316184,
         0.001728431638583017,
         -0.042220046761926214,
         -0.02337725617115936,
         0.07643838879157068,
         -0.08740278361156249,
         0.07843806004207407,
         -0.06478199657056424,
         0.07002503939328521,
         -0.08771512720096171,
         0.08656283944190638,
         -0.05464748399231362,
         0.07802474016347305,
         0.004599384070258519,
         -0.004599384070258502,
         -0.05159339328464604,
         0.06825164396256163,
         -0.05159339328464603,
         -0.0078077223946733925,
         0.03636290407713522,
         -0.06561360863251885,
         0.06630913150544068,
         0.04750137517008534,
         -0.024999509957487755,
         -0.006982794449475868,
         0.027565766818756755,
         -0.030624648606679235,
         -0.03729977049990629,
         -0.024482820981981672,
         0.023235033128656633,
         0.01381180084923184,
         -0.019752820055876683,
         -0.018848269198427713,
         0.007037009853032197,
         0.0331828222236237,
         0.01779748581546929,
         -0.0351232394905369,
         -0.017888980784003507,
         0.04664050731709432,
         0.046144601535806136,
         0.011859214568652791,
         -0.006314662636672668,
         -0.03578510877835327,
         -0.002665421663691836,
         0.050863316609483414,
         -0.009916956007976313,
         -0.0686576418876739,
         -0.042220046761926235,
         -0.08740278361156256,
         0.06075012254496602,
         -0.0634001834777816,
         0.10861574643826385,
         -0.10114265185567406,
         0.04089726022389607,
         -0.03330361486299358,
         0.13387661220026034,
         -0.054647483992313645,
         0.010964394819991846,
         0.0118592145686528,
         -0.020484095207264765,
         -0.00828997859479838,
         0.02797048474031619,
         0.0017284316385830034,
         -0.04222004676192622,
         -0.02337725617115936,
         0.034401555336919534,
         -0.051593393284646,
         0.04360032347743658,
         0.0663091315054407,
         -0.06561360863251887,
         0.03636290407713522,
         -0.007807722394673405,
         -0.04452948352027023,
         -0.006982794449475874,
         0.03716844922806734,
         -0.006982794449475874,
         -0.04452948352027025,
         -0.012193249762917392,
         0.02323503312865664,
         0.0051460782959686134,
         -0.03615628166750411,
         0.013811800849231821,
         0.05913144674791288,
         0.03388312880057459,
         0.0177974858154693,
         -0.02456041957309315,
         -2.6860551745605296e-05,
         0.024625982159319944,
         -0.017888980784003507,
         -0.03378141951777189,
         -0.020484095207264755,
         -0.03578510877835325,
         -0.013878387101531229,
         0.024822152733588062,
         0.004590918302272893,
         -0.014014314537988725,
         -0.009916956007976305,
         0.0017284316385830088,
         0.07843806004207411,
         -0.06340018347778162,
         0.1102913454574188,
         -0.06485345886691521,
         0.043535148906770176,
         -0.09044578024695242,
         0.11320602790489889,
         -0.03330361486299356,
         0.0865628394419064,
         0.0118592145686528,
         -0.006314662636672661,
         -0.03578510877835326,
         -0.0026654216636918097,
         0.050863316609483414,
         -0.009916956007976319,
         -0.0686576418876739,
         -0.04222004676192623,
         -0.019929118389480263,
         0.007037009853032198,
         0.03388312880057456,
         -0.023522703991304208,
         -0.0337814195177719,
         0.046144601535806094,
         0.05529261162075215,
         -0.07860764300721339,
         0.06630913150544067,
         -0.007807722394673413,
         -0.03839517521432103,
         -0.030624648606679242,
         0.027565766818756773,
         -0.006982794449475865,
         -0.02499950995748779,
         0.047501375170085326,
         0.0591314467479129,
         0.013811800849231828,
         -0.036156281667504106,
         0.005146078295968628,
         0.023235033128656633,
         -0.012193249762917392,
         -0.023522703991304208,
         -0.0351232394905369,
         -2.6860551745600234e-05,
         0.031038516879110467,
         -2.6860551745608603e-05,
         -0.035123239490536924,
         -0.023522703991304215,
         -0.00828997859479838,
         -0.002665421663691808,
         0.024822152733588093,
         -0.00157611327490285,
         -0.02943692144739016,
         0.004590918302272905,
         0.05086331660948339,
         0.027970484740316204,
         -0.06478199657056424,
         0.1086157464382639,
         -0.06485345886691517,
         0.05256699961287549,
         -0.07453924805798655,
         0.09962084198929591,
         -0.09044578024695238,
         0.04089726022389604,
         -0.08771512720096179,
         -0.020484095207264755,
         -0.03578510877835325,
         -0.013878387101531187,
         0.024822152733588065,
         0.004590918302272882,
         -0.01401431453798877,
         -0.009916956007976308,
         0.0017284316385830208,
         0.007037009853032203,
         0.03318282222362373,
         0.017797485815469288,
         -0.035123239490536924,
         -0.01788898078400349,
         0.0466405073170943,
         0.04614460153580612,
         0.015237778487458829,
         -0.037299770499906244,
         -0.01219324976291738,
         0.05913144674791286,
         -0.01884826919842769,
         -0.0860556793112895,
         0.09797637143509492,
         -0.030624648606679267,
         -0.044529483520270224,
         0.04750137517008538,
         0.008352667708793397,
         -0.018848269198427716,
         -0.0197528200558767,
         0.013811800849231833,
         0.02323503312865665,
         -0.024482820981981727,
         -0.03729977049990629,
         -0.0337814195177719,
         -0.017888980784003503,
         0.024625982159319944,
         -2.6860551745613506e-05,
         -0.02456041957309314,
         0.017797485815469288,
         0.033883128800574584,
         0.0279704847403162,
         0.05086331660948339,
         0.00459091830227292,
         -0.029436921447390133,
         -0.0015761132749028692,
         0.024822152733588072,
         -0.0026654216636918097,
         -0.008289978594798372,
         0.07002503939328523,
         -0.10114265185567403,
         0.043535148906770176,
         -0.07453924805798658,
         0.10555228278027974,
         -0.07453924805798652,
         0.04353514890677016,
         -0.10114265185567406,
         0.07002503939328523,
         -0.008289978594798374,
         -0.002665421663691811,
         0.02482215273358807,
         -0.001576113274902873,
         -0.02943692144739012,
         0.004590918302272911,
         0.050863316609483386,
         0.02797048474031618,
         0.033883128800574584,
         0.01779748581546929,
         -0.024560419573093132,
         -2.6860551745607404e-05,
         0.024625982159319944,
         -0.01788898078400351,
         -0.03378141951777187,
         -0.0372997704999063,
         -0.02448282098198171,
         0.023235033128656647,
         0.013811800849231838,
         -0.0197528200558767,
         -0.018848269198427716,
         0.008352667708793412,
         0.04750137517008539,
         -0.04452948352027023,
         -0.030624648606679256,
         0.0979763714350949,
         -0.0860556793112895,
         -0.01884826919842768,
         0.05913144674791285,
         -0.012193249762917373,
         -0.037299770499906244,
         0.01523777848745882,
         0.046144601535806136,
         0.046640507317094314,
         -0.017888980784003503,
         -0.03512323949053694,
         0.017797485815469284,
         0.03318282222362373,
         0.007037009853032192,
         0.0017284316385830182,
         -0.009916956007976294,
         -0.014014314537988754,
         0.0045909183022728875,
         0.024822152733588065,
         -0.013878387101531211,
         -0.035785108778353274,
         -0.020484095207264765,
         -0.08771512720096176,
         0.040897260223896025,
         -0.0904457802469524,
         0.09962084198929586,
         -0.07453924805798653,
         0.052566999612875503,
         -0.06485345886691518,
         0.10861574643826395,
         -0.06478199657056427,
         0.0279704847403162,
         0.05086331660948337,
         0.004590918302272904,
         -0.029436921447390144,
         -0.001576113274902852,
         0.024822152733588093,
         -0.0026654216636918145,
         -0.008289978594798386,
         -0.023522703991304215,
         -0.035123239490536896,
         -2.686055174560067e-05,
         0.031038516879110467,
         -2.6860551745598164e-05,
         -0.03512323949053688,
         -0.0235227039913042,
         -0.012193249762917396,
         0.023235033128656643,
         0.005146078295968603,
         -0.03615628166750411,
         0.013811800849231835,
         0.059131446747912916,
         0.04750137517008534,
         -0.024999509957487762,
         -0.006982794449475866,
         0.02756576681875677,
         -0.03062464860667924,
         -0.03839517521432105,
         -0.007807722394673439,
         0.06630913150544065,
         -0.07860764300721343,
         0.05529261162075213,
         0.04614460153580608,
         -0.033781419517771874,
         -0.023522703991304215,
         0.03388312880057456,
         0.007037009853032189,
         -0.019929118389480242,
         -0.04222004676192623,
         -0.0686576418876739,
         -0.00991695600797632,
         0.05086331660948338,
         -0.0026654216636918062,
         -0.03578510877835326,
         -0.006314662636672686,
         0.011859214568652793,
         0.08656283944190643,
         -0.03330361486299355,
         0.1132060279048989,
         -0.0904457802469524,
         0.043535148906770155,
         -0.0648534588669152,
         0.11029134545741881,
         -0.06340018347778163,
         0.07843806004207408,
         0.0017284316385830132,
         -0.0099169560079763,
         -0.01401431453798874,
         0.004590918302272896,
         0.024822152733588045,
         -0.0138783871015312,
         -0.03578510877835325,
         -0.02048409520726477,
         -0.033781419517771895,
         -0.017888980784003503,
         0.024625982159319926,
         -2.6860551745604405e-05,
         -0.02456041957309313,
         0.017797485815469284,
         0.03388312880057458,
         0.05913144674791291,
         0.013811800849231832,
         -0.0361562816675041,
         0.005146078295968616,
         0.02323503312865664,
         -0.012193249762917403,
         -0.044529483520270245,
         -0.006982794449475872,
         0.03716844922806734,
         -0.006982794449475879,
         -0.04452948352027024,
         -0.007807722394673411,
         0.03636290407713522,
         -0.06561360863251887,
         0.06630913150544067,
         0.0436003234774366,
         -0.05159339328464602,
         0.03440155533691955,
         -0.023377256171159384,
         -0.04222004676192622,
         0.0017284316385830054,
         0.027970484740316204,
         -0.008289978594798393,
         -0.020484095207264772,
         0.011859214568652807,
         0.010964394819991837,
         -0.05464748399231365,
         0.13387661220026031,
         -0.03330361486299358,
         0.040897260223896066,
         -0.10114265185567405,
         0.1086157464382639,
         -0.06340018347778162,
         0.060750122544965986,
         -0.08740278361156252,
         -0.0422200467619262,
         -0.06865764188767391,
         -0.009916956007976303,
         0.05086331660948343,
         -0.0026654216636918288,
         -0.03578510877835329,
         -0.00631466263667268,
         0.011859214568652793,
         0.04614460153580613,
         0.04664050731709433,
         -0.017888980784003496,
         -0.03512323949053693,
         0.017797485815469277,
         0.033182822223623704,
         0.007037009853032187,
         -0.018848269198427702,
         -0.019752820055876707,
         0.013811800849231842,
         0.023235033128656633,
         -0.02448282098198171,
         -0.03729977049990631,
         -0.030624648606679242,
         0.027565766818756773,
         -0.00698279444947587,
         -0.02499950995748777,
         0.04750137517008534,
         0.06630913150544068,
         -0.06561360863251887,
         0.03636290407713522,
         -0.00780772239467341,
         -0.051593393284646016,
         0.06825164396256161,
         -0.05159339328464602,
         -0.004599384070258517,
         0.00459938407025852,
         0.07802474016347301,
         -0.05464748399231359,
         0.08656283944190633,
         -0.08771512720096171,
         0.07002503939328522,
         -0.06478199657056419,
         0.07843806004207403,
         -0.08740278361156252,
         0.0764383887915707,
         -0.023377256171159377,
         -0.04222004676192621,
         0.0017284316385830088,
         0.027970484740316198,
         -0.008289978594798391,
         -0.02048409520726478,
         0.011859214568652797,
         0.010964394819991848,
         0.05529261162075211,
         0.04614460153580613,
         -0.033781419517771874,
         -0.02352270399130422,
         0.033883128800574584,
         0.00703700985303217,
         -0.019929118389480235,
         -0.0860556793112895,
         -0.018848269198427692,
         0.05913144674791286,
         -0.012193249762917382,
         -0.03729977049990625,
         0.015237778487458805,
         0.09797637143509495,
         -0.030624648606679256,
         -0.044529483520270224,
         0.04750137517008538,
         0.008352667708793412,
         -0.07860764300721344,
         0.06630913150544064,
         -0.007807722394673421,
         -0.03839517521432104,
         0.03440155533691954,
         -0.05159339328464601,
         0.04360032347743659,
         0.004599384070258528,
         -0.004599384070258531},
        {0.015829661287152956,
         -0.015829661287152966,
         0.01933050782737311,
         -0.04651253176600522,
         0.05098983040167919,
         -0.08046417694912042,
         0.09170050368262066,
         -0.0389602500108312,
         -0.02501633039445837,
         0.11916838281727632,
         -0.061196722785713996,
         -0.04021250425905949,
         0.07653180470280788,
         -0.023386632866353285,
         -0.11529601573564913,
         -0.00612274995710016,
         0.08046215978751926,
         -0.038074458494902756,
         -0.044676427248191895,
         0.0516424864309724,
         0.0802772934488821,
         0.0525280834301506,
         -0.05584052222651131,
         -0.021601081131175093,
         0.05661318774541165,
         -0.004982210814326149,
         -0.04832101255475497,
         -0.03970093083674371,
         -0.05367748228964861,
         0.008336460488056894,
         0.040459310708355005,
         -0.022386549595981294,
         -0.026128245458567862,
         0.02743684349060903,
         0.027580708372825554,
         0.041116944808771386,
         -0.0014160139720276075,
         0.041992376584165984,
         -0.047550016909537245,
         0.021961302029768766,
         -0.007802804894644144,
         0.025221635200356043,
         -0.045961939382285454,
         0.018381231009459865,
         -0.015829661287152928,
         0.01582966128715296,
         -0.046512531766005207,
         0.06153029595042083,
         -0.0465125317660052,
         0.09170050368262074,
         -0.09535096740088336,
         0.06898084056498864,
         -0.038960250010831275,
         -0.06119672278571395,
         0.039673936095579815,
         -0.006187245710083116,
         -0.03755070274132394,
         0.07653180470280774,
         -0.006122749957100772,
         -0.012726950442817523,
         0.014052565967683454,
         0.01927769983401226,
         -0.026981141374128305,
         -0.04467642724819195,
         0.05252808343015061,
         0.04618480829449162,
         -0.035361424989558354,
         -0.03117993024216207,
         0.03438258112539475,
         0.026470463702064684,
         -0.004982210814326143,
         -0.05367748228964861,
         -0.08806078402286585,
         0.0077753945500433005,
         0.06439245431236688,
         -0.02115085199792764,
         -0.04835804420320338,
         0.01949879645786782,
         0.027436843490609042,
         -0.0014160139720276474,
         0.11212557938001347,
         0.016511567254990776,
         -0.028926461021969125,
         -0.050536846391378475,
         0.08239141592030749,
         -0.022324799330880645,
         -0.017914301308916438,
         -0.045961939382285454,
         -0.03970093083674373,
         -0.053677482289648616,
         0.008336460488056894,
         0.040459310708355,
         -0.022386549595981298,
         -0.02612824545856788,
         0.027436843490609014,
         0.02758070837282555,
         0.05098983040167921,
         -0.046512531766005165,
         0.019330507827373184,
         -0.038960250010831254,
         0.06898084056498864,
         -0.0953509674008834,
         0.0917005036826207,
         -0.040212504259059464,
         -0.0061872457100831165,
         0.03338580402846523,
         -0.00618724571008312,
         -0.04021250425905947,
         0.08046215978751929,
         0.014052565967683433,
         -0.04945428778214349,
         0.021525121570122086,
         0.019277699834012247,
         -0.03807445849490278,
         -0.0558405222265113,
         -0.03536142498955835,
         0.03819590837803575,
         -0.0005258243845034121,
         -0.03715516161347664,
         0.03438258112539477,
         0.05661318774541171,
         0.008336460488056904,
         0.00777539455004332,
         -0.012736290190777162,
         0.004349051565750522,
         0.02226377408249089,
         -0.012732640246835191,
         -0.04835804420320334,
         -0.026128245458567855,
         0.041992376584166026,
         0.01651156725499082,
         0.06273274805723723,
         -0.05685371130806736,
         -0.0011467538082998,
         -0.002278444421524715,
         0.057658870952074885,
         -0.022324799330880683,
         0.02522163520035606,
         -0.05367748228964862,
         -0.08806078402286589,
         0.007775394550043335,
         0.06439245431236688,
         -0.021150851997927683,
         -0.04835804420320339,
         0.019498796457867812,
         0.02743684349060903,
         0.0802772934488821,
         0.05252808343015063,
         -0.05584052222651131,
         -0.02160108113117511,
         0.0566131877454117,
         -0.004982210814326169,
         -0.04832101255475492,
         -0.025016330394458372,
         -0.03896025001083127,
         0.09170050368262064,
         -0.08046417694912043,
         0.07653180470280775,
         -0.03755070274132392,
         -0.006187245710083117,
         0.039673936095579815,
         -0.061196722785713954,
         -0.038074458494902784,
         0.019277699834012254,
         0.021525121570122093,
         -0.04945428778214347,
         0.014052565967683445,
         0.0804621597875193,
         -0.021601081131175114,
         -0.03117993024216203,
         -0.0005258243845034136,
         0.02848343378011708,
         -0.000525824384503415,
         -0.03117993024216207,
         -0.021601081131175114,
         0.040459310708354984,
         0.0643924543123669,
         0.0043490515657505216,
         -0.04222594367970443,
         0.014241350710873424,
         0.022263774082490882,
         -0.021150851997927655,
         -0.0223865495959813,
         -0.04755001690953728,
         -0.028926461021969184,
         -0.05685371130806734,
         0.06500569862908004,
         -0.026905627532163596,
         -0.008456993802338834,
         -0.00227844442152473,
         0.08239141592030753,
         -0.0078028048946441496,
         0.008336460488056906,
         0.007775394550043332,
         -0.01273629019077711,
         0.004349051565750523,
         0.022263774082490882,
         -0.012732640246835179,
         -0.048358044203203346,
         -0.026128245458567873,
         0.05252808343015062,
         0.046184808294491626,
         -0.03536142498955834,
         -0.031179930242162077,
         0.03438258112539475,
         0.02647046370206465,
         -0.00498221081432614,
         -0.11529601573564915,
         -0.006122749957100759,
         0.08046215978751924,
         -0.03807445849490274,
         -0.044676427248191874,
         0.051642486430972356,
         -0.023386632866353313,
         0.07653180470280778,
         -0.040212504259059444,
         -0.061196722785714,
         0.1191683828172763,
         -0.04467642724819192,
         -0.0269811413741283,
         0.01927769983401226,
         0.014052565967683445,
         -0.012726950442817533,
         -0.006122749957100764,
         0.05661318774541173,
         0.03438258112539475,
         -0.03715516161347666,
         -0.0005258243845034217,
         0.03819590837803572,
         -0.03536142498955835,
         -0.055840522226511334,
         -0.022386549595981284,
         -0.021150851997927638,
         0.022263774082490907,
         0.014241350710873438,
         -0.04222594367970445,
         0.004349051565750526,
         0.0643924543123669,
         0.04045931070835497,
         0.021961302029768794,
         -0.050536846391378495,
         -0.0011467538082998094,
         -0.02690562753216361,
         0.05489022050099472,
         -0.02690562753216361,
         -0.0011467538082998133,
         -0.050536846391378454,
         0.021961302029768794,
         0.04045931070835497,
         0.06439245431236691,
         0.0043490515657505216,
         -0.04222594367970447,
         0.014241350710873443,
         0.022263774082490907,
         -0.021150851997927662,
         -0.02238654959598128,
         -0.05584052222651133,
         -0.03536142498955836,
         0.03819590837803577,
         -0.000525824384503422,
         -0.03715516161347666,
         0.034382581125394746,
         0.05661318774541172,
         -0.006122749957100773,
         -0.012726950442817533,
         0.014052565967683445,
         0.01927769983401226,
         -0.026981141374128294,
         -0.044676427248191916,
         0.11916838281727632,
         -0.061196722785713996,
         -0.040212504259059464,
         0.07653180470280782,
         -0.023386632866353323,
         0.051642486430972384,
         -0.044676427248191874,
         -0.038074458494902756,
         0.08046215978751922,
         -0.006122749957100758,
         -0.11529601573564915,
         -0.004982210814326146,
         0.02647046370206463,
         0.03438258112539475,
         -0.031179930242162063,
         -0.03536142498955835,
         0.04618480829449163,
         0.05252808343015064,
         -0.02612824545856786,
         -0.04835804420320335,
         -0.01273264024683518,
         0.022263774082490858,
         0.0043490515657505155,
         -0.012736290190777103,
         0.0077753945500433205,
         0.00833646048805689,
         -0.007802804894644147,
         0.08239141592030752,
         -0.002278444421524735,
         -0.008456993802338853,
         -0.0269056275321636,
         0.06500569862907998,
         -0.05685371130806731,
         -0.02892646102196918,
         -0.04755001690953729,
         -0.022386549595981294,
         -0.021150851997927662,
         0.022263774082490886,
         0.014241350710873431,
         -0.04222594367970443,
         0.004349051565750523,
         0.06439245431236688,
         0.04045931070835497,
         -0.021601081131175124,
         -0.03117993024216207,
         -0.0005258243845034162,
         0.02848343378011705,
         -0.0005258243845034076,
         -0.031179930242162028,
         -0.02160108113117512,
         0.0804621597875193,
         0.014052565967683443,
         -0.04945428778214349,
         0.021525121570122086,
         0.019277699834012247,
         -0.03807445849490279,
         -0.06119672278571395,
         0.039673936095579815,
         -0.006187245710083116,
         -0.03755070274132393,
         0.07653180470280774,
         -0.08046417694912043,
         0.09170050368262066,
         -0.038960250010831254,
         -0.02501633039445836,
         -0.04832101255475494,
         -0.004982210814326169,
         0.05661318774541169,
         -0.021601081131175127,
         -0.05584052222651131,
         0.05252808343015063,
         0.0802772934488821,
         0.027436843490609004,
         0.019498796457867812,
         -0.048358044203203374,
         -0.021150851997927666,
         0.0643924543123669,
         0.007775394550043327,
         -0.08806078402286587,
         -0.05367748228964863,
         0.025221635200356068,
         -0.02232479933088068,
         0.057658870952074906,
         -0.0022784444215247163,
         -0.0011467538082998057,
         -0.05685371130806734,
         0.06273274805723723,
         0.01651156725499083,
         0.04199237658416602,
         -0.026128245458567848,
         -0.04835804420320335,
         -0.012732640246835177,
         0.0222637740824909,
         0.004349051565750524,
         -0.012736290190777134,
         0.007775394550043318,
         0.008336460488056894,
         0.056613187745411714,
         0.034382581125394766,
         -0.03715516161347666,
         -0.0005258243845034239,
         0.03819590837803575,
         -0.03536142498955834,
         -0.05584052222651133,
         -0.03807445849490279,
         0.01927769983401224,
         0.02152512157012208,
         -0.04945428778214351,
         0.014052565967683438,
         0.08046215978751929,
         -0.040212504259059485,
         -0.006187245710083118,
         0.0333858040284652,
         -0.006187245710083126,
         -0.04021250425905948,
         0.0917005036826207,
         -0.09535096740088338,
         0.06898084056498865,
         -0.03896025001083125,
         0.01933050782737318,
         -0.04651253176600519,
         0.0509898304016792,
         0.02758070837282555,
         0.027436843490609018,
         -0.026128245458567855,
         -0.02238654959598129,
         0.04045931070835499,
         0.008336460488056894,
         -0.05367748228964863,
         -0.03970093083674369,
         -0.04596193938228542,
         -0.017914301308916428,
         -0.022324799330880652,
         0.08239141592030749,
         -0.050536846391378475,
         -0.028926461021969118,
         0.016511567254990783,
         0.11212557938001345,
         -0.001416013972027648,
         0.02743684349060902,
         0.019498796457867815,
         -0.048358044203203374,
         -0.02115085199792764,
         0.06439245431236688,
         0.007775394550043294,
         -0.08806078402286585,
         -0.05367748228964862,
         -0.0049822108143261455,
         0.02647046370206468,
         0.03438258112539476,
         -0.031179930242162077,
         -0.035361424989558354,
         0.0461848082944916,
         0.05252808343015063,
         -0.044676427248191944,
         -0.026981141374128294,
         0.019277699834012254,
         0.014052565967683438,
         -0.012726950442817535,
         -0.006122749957100774,
         0.07653180470280775,
         -0.03755070274132393,
         -0.006187245710083122,
         0.0396739360955798,
         -0.06119672278571394,
         -0.03896025001083125,
         0.06898084056498864,
         -0.09535096740088338,
         0.09170050368262071,
         -0.046512531766005207,
         0.061530295950420845,
         -0.04651253176600522,
         0.01582966128715297,
         -0.015829661287152953,
         0.01838123100945991,
         -0.045961939382285474,
         0.025221635200356047,
         -0.007802804894644151,
         0.02196130202976878,
         -0.047550016909537245,
         0.041992376584166,
         -0.0014160139720276117,
         0.04111694480877137,
         0.027580708372825547,
         0.027436843490609025,
         -0.026128245458567862,
         -0.022386549595981308,
         0.040459310708355,
         0.008336460488056885,
         -0.053677482289648616,
         -0.03970093083674371,
         -0.048321012554754975,
         -0.004982210814326137,
         0.05661318774541172,
         -0.021601081131175117,
         -0.055840522226511306,
         0.05252808343015059,
         0.08027729344888206,
         0.05164248643097239,
         -0.04467642724819187,
         -0.03807445849490277,
         0.08046215978751925,
         -0.006122749957100764,
         -0.11529601573564915,
         -0.023386632866353316,
         0.07653180470280783,
         -0.04021250425905947,
         -0.06119672278571401,
         0.11916838281727632,
         -0.02501633039445837,
         -0.03896025001083127,
         0.09170050368262066,
         -0.08046417694912045,
         0.05098983040167919,
         -0.04651253176600518,
         0.01933050782737317,
         -0.015829661287152953,
         0.015829661287152946},
        {0.03520858381909409,
         -0.035208583819094155,
         -0.0858622428102711,
         0.0670084923430623,
         -0.015445075172082639,
         0.09329114200944566,
         -0.011143348798762026,
         -0.06483713968800314,
         0.05866983496408516,
         -0.06908683642538516,
         -0.03827036741418172,
         0.056713367042784624,
         0.018327857725418423,
         -0.07026138997285192,
         0.035696721735075404,
         0.05279440687781322,
         -0.017359547490034228,
         -0.042421590387408004,
         0.017164591213727924,
         0.059405549304633154,
         -0.00803491936734356,
         -0.041492703551597836,
         -0.010269964156721727,
         0.02818504023121131,
         0.013505977355042269,
         -0.027583672374566676,
         -0.04101643438825543,
         -0.007609469602363189,
         0.020695581313703013,
         0.018026120097037718,
         -0.00994394191671386,
         -0.013637354590995378,
         0.0016376191578315361,
         0.022882268105042833,
         0.023719065577098686,
         0.08285225340268489,
         -0.07524278380032166,
         0.05959839483061493,
         -0.07161580822864011,
         0.07790490930408733,
         -0.06927988895070746,
         0.06818814284548642,
         -0.08548551165664313,
         0.061766446079544506,
         -0.0352085838190941,
         0.03520858381909411,
         0.06700849234306247,
         -0.08864390323455952,
         0.06700849234306244,
         -0.01114334879876211,
         0.013933362773854449,
         0.02405688146952833,
         -0.06483713968800343,
         -0.038270367414181695,
         -0.016065354851151434,
         0.010841031698430374,
         0.00960698704600242,
         0.01832785772541843,
         0.05279440687781326,
         0.04612231365976206,
         -0.006995258574495517,
         -0.04224110357173517,
         0.014142900780387001,
         0.01716459121372796,
         -0.04149270355159786,
         -0.05693295313345326,
         -0.026987634762659574,
         0.04739414646934644,
         0.024108837909089374,
         -0.045169642413330574,
         -0.027583672374566683,
         0.020695581313703006,
         0.04289629399775347,
         0.047281611082320145,
         -0.01600491662032267,
         -0.04678290317532731,
         0.012968576923269207,
         0.05212154753058104,
         0.022882268105042843,
         -0.0752427838003217,
         0.05547457270569798,
         -0.11401525567315832,
         0.060299380771701536,
         -0.04061960573201938,
         0.08838601109740976,
         -0.10091496700175799,
         0.03149605066002014,
         -0.08548551165664318,
         -0.007609469602363195,
         0.02069558131370301,
         0.018026120097037714,
         -0.009943941916713895,
         -0.013637354590995378,
         0.0016376191578315628,
         0.022882268105042843,
         0.023719065577098693,
         -0.015445075172082642,
         0.06700849234306243,
         -0.08586224281027106,
         -0.06483713968800345,
         0.024056881469528328,
         0.013933362773854437,
         -0.011143348798762094,
         0.056713367042784464,
         0.010841031698430377,
         -0.050282818741703414,
         0.010841031698430377,
         0.056713367042784464,
         -0.01735954749003424,
         -0.006995258574495512,
         0.012133713530759559,
         0.02858821393447208,
         -0.04224110357173516,
         -0.042421590387408024,
         -0.010269964156721746,
         -0.026987634762659588,
         -0.00550498731523505,
         -0.0008180527606728096,
         0.007529301891658832,
         0.024108837909089405,
         0.01350597735504229,
         0.018026120097037718,
         0.04728161108232013,
         0.03557703865278228,
         -0.007897868694774329,
         -0.03093686638715614,
         0.0016490855791320785,
         0.012968576923269205,
         0.0016376191578315515,
         0.059598394830614944,
         -0.1140152556731583,
         0.017506654028135647,
         -0.0947821541843496,
         0.11566540426951286,
         -0.04717473082198703,
         0.03408843544372777,
         -0.10091496700175802,
         0.06818814284548644,
         0.02069558131370301,
         0.042896293997753465,
         0.047281611082320145,
         -0.016004916620322714,
         -0.046782903175327295,
         0.01296857692326924,
         0.05212154753058103,
         0.022882268105042854,
         -0.008034919367343556,
         -0.041492703551597857,
         -0.010269964156721729,
         0.028185040231211305,
         0.01350597735504228,
         -0.027583672374566687,
         -0.04101643438825543,
         0.05866983496408514,
         -0.06483713968800339,
         -0.011143348798762075,
         0.09329114200944574,
         0.018327857725418426,
         0.00960698704600243,
         0.010841031698430351,
         -0.01606535485115142,
         -0.038270367414181716,
         -0.042421590387408024,
         -0.04224110357173515,
         0.02858821393447209,
         0.012133713530759583,
         -0.0069952585744954675,
         -0.01735954749003424,
         0.0281850402312113,
         0.04739414646934638,
         -0.0008180527606727906,
         -0.039859624141926786,
         -0.0008180527606727886,
         0.04739414646934642,
         0.028185040231211305,
         -0.009943941916713881,
         -0.0160049166203227,
         -0.007897868694774376,
         0.014692375217349297,
         0.025943321915551945,
         -0.03093686638715619,
         -0.04678290317532729,
         -0.01363735459099539,
         -0.07161580822864012,
         0.060299380771701536,
         -0.0947821541843496,
         0.06753020011037651,
         -0.07472999920679735,
         0.07813596572676093,
         -0.04717473082198702,
         0.08838601109740975,
         -0.06927988895070747,
         0.018026120097037742,
         0.04728161108232014,
         0.03557703865278231,
         -0.00789786869477436,
         -0.03093686638715614,
         0.0016490855791321357,
         0.012968576923269193,
         0.001637619157831527,
         -0.041492703551597884,
         -0.0569329531334533,
         -0.026987634762659567,
         0.047394146469346435,
         0.024108837909089385,
         -0.04516964241333051,
         -0.027583672374566662,
         0.035696721735075404,
         0.05279440687781323,
         -0.01735954749003422,
         -0.042421590387408,
         0.017164591213727935,
         0.059405549304633175,
         -0.07026138997285195,
         0.018327857725418454,
         0.05671336704278444,
         -0.038270367414181716,
         -0.0690868364253851,
         0.017164591213727955,
         0.014142900780387003,
         -0.04224110357173516,
         -0.006995258574495486,
         0.04612231365976209,
         0.05279440687781327,
         0.013505977355042281,
         0.024108837909089367,
         0.007529301891658835,
         -0.000818052760672807,
         -0.005504987315235044,
         -0.026987634762659602,
         -0.010269964156721736,
         -0.013637354590995373,
         -0.0467829031753273,
         -0.030936866387156176,
         0.02594332191555192,
         0.0146923752173493,
         -0.007897868694774332,
         -0.016004916620322707,
         -0.009943941916713888,
         0.07790490930408739,
         -0.04061960573201937,
         0.11566540426951291,
         -0.07472999920679736,
         0.03409430207389596,
         -0.07472999920679738,
         0.1156654042695129,
         -0.040619605732019365,
         0.07790490930408735,
         -0.009943941916713881,
         -0.0160049166203227,
         -0.007897868694774338,
         0.014692375217349302,
         0.02594332191555191,
         -0.03093686638715618,
         -0.0467829031753273,
         -0.013637354590995387,
         -0.010269964156721734,
         -0.026987634762659602,
         -0.005504987315235051,
         -0.0008180527606728027,
         0.00752930189165885,
         0.024108837909089385,
         0.01350597735504228,
         0.05279440687781327,
         0.04612231365976207,
         -0.006995258574495503,
         -0.04224110357173517,
         0.014142900780387001,
         0.017164591213727962,
         -0.06908683642538511,
         -0.038270367414181716,
         0.05671336704278445,
         0.01832785772541845,
         -0.07026138997285196,
         0.05940554930463317,
         0.017164591213727914,
         -0.04242159038740798,
         -0.017359547490034224,
         0.05279440687781321,
         0.035696721735075425,
         -0.027583672374566687,
         -0.04516964241333052,
         0.02410883790908938,
         0.04739414646934643,
         -0.026987634762659574,
         -0.05693295313345328,
         -0.04149270355159786,
         0.0016376191578315582,
         0.012968576923269182,
         0.0016490855791321324,
         -0.030936866387156155,
         -0.007897868694774357,
         0.035577038652782327,
         0.047281611082320145,
         0.018026120097037714,
         -0.06927988895070747,
         0.0883860110974098,
         -0.047174730821987004,
         0.07813596572676093,
         -0.07472999920679735,
         0.06753020011037653,
         -0.09478215418434961,
         0.06029938077170154,
         -0.07161580822864011,
         -0.01363735459099541,
         -0.0467829031753273,
         -0.030936866387156182,
         0.025943321915551917,
         0.0146923752173493,
         -0.007897868694774381,
         -0.01600491662032269,
         -0.009943941916713883,
         0.028185040231211298,
         0.047394146469346414,
         -0.000818052760672781,
         -0.03985962414192677,
         -0.0008180527606727867,
         0.047394146469346386,
         0.02818504023121131,
         -0.01735954749003424,
         -0.006995258574495496,
         0.012133713530759592,
         0.028588213934472098,
         -0.042241103571735154,
         -0.042421590387408024,
         -0.03827036741418173,
         -0.016065354851151428,
         0.010841031698430365,
         0.009606987046002432,
         0.018327857725418433,
         0.09329114200944576,
         -0.011143348798762064,
         -0.06483713968800338,
         0.05866983496408513,
         -0.04101643438825543,
         -0.027583672374566687,
         0.01350597735504227,
         0.02818504023121131,
         -0.010269964156721715,
         -0.041492703551597857,
         -0.008034919367343565,
         0.022882268105042822,
         0.052121547530581,
         0.012968576923269247,
         -0.04678290317532728,
         -0.016004916620322714,
         0.047281611082320166,
         0.042896293997753465,
         0.020695581313703013,
         0.06818814284548645,
         -0.100914967001758,
         0.034088435443727784,
         -0.047174730821986983,
         0.11566540426951288,
         -0.09478215418434963,
         0.017506654028135653,
         -0.11401525567315833,
         0.059598394830614965,
         0.0016376191578315682,
         0.01296857692326919,
         0.001649085579132089,
         -0.03093686638715615,
         -0.007897868694774329,
         0.035577038652782285,
         0.04728161108232014,
         0.0180261200970377,
         0.013505977355042269,
         0.024108837909089385,
         0.007529301891658838,
         -0.0008180527606727933,
         -0.005504987315235054,
         -0.02698763476265959,
         -0.010269964156721734,
         -0.04242159038740803,
         -0.04224110357173515,
         0.028588213934472088,
         0.012133713530759586,
         -0.0069952585744955135,
         -0.017359547490034242,
         0.05671336704278445,
         0.010841031698430372,
         -0.05028281874170345,
         0.010841031698430372,
         0.05671336704278445,
         -0.011143348798762104,
         0.013933362773854445,
         0.02405688146952834,
         -0.06483713968800343,
         -0.08586224281027108,
         0.06700849234306244,
         -0.015445075172082627,
         0.023719065577098696,
         0.02288226810504284,
         0.0016376191578315648,
         -0.013637354590995387,
         -0.009943941916713881,
         0.018026120097037714,
         0.02069558131370299,
         -0.007609469602363184,
         -0.08548551165664317,
         0.03149605066002013,
         -0.100914967001758,
         0.08838601109740976,
         -0.04061960573201937,
         0.060299380771701536,
         -0.1140152556731583,
         0.055474572705697965,
         -0.07524278380032172,
         0.02288226810504285,
         0.05212154753058103,
         0.012968576923269191,
         -0.0467829031753273,
         -0.016004916620322673,
         0.04728161108232015,
         0.042896293997753465,
         0.020695581313703006,
         -0.027583672374566683,
         -0.04516964241333055,
         0.02410883790908938,
         0.047394146469346435,
         -0.02698763476265957,
         -0.05693295313345324,
         -0.04149270355159788,
         0.01716459121372796,
         0.014142900780387015,
         -0.04224110357173519,
         -0.006995258574495525,
         0.046122313659762076,
         0.05279440687781326,
         0.018327857725418426,
         0.009606987046002387,
         0.010841031698430365,
         -0.016065354851151445,
         -0.0382703674141817,
         -0.06483713968800343,
         0.024056881469528342,
         0.013933362773854435,
         -0.011143348798762102,
         0.06700849234306244,
         -0.08864390323455948,
         0.06700849234306247,
         0.03520858381909413,
         -0.03520858381909411,
         0.06176644607954452,
         -0.08548551165664314,
         0.0681881428454864,
         -0.06927988895070746,
         0.07790490930408736,
         -0.0716158082286401,
         0.059598394830614944,
         -0.07524278380032165,
         0.08285225340268489,
         0.023719065577098703,
         0.02288226810504283,
         0.001637619157831542,
         -0.013637354590995375,
         -0.009943941916713866,
         0.018026120097037735,
         0.020695581313703,
         -0.0076094696023631826,
         -0.04101643438825543,
         -0.027583672374566704,
         0.01350597735504227,
         0.02818504023121131,
         -0.01026996415672172,
         -0.04149270355159783,
         -0.008034919367343575,
         0.05940554930463317,
         0.01716459121372792,
         -0.04242159038740798,
         -0.01735954749003422,
         0.05279440687781319,
         0.03569672173507542,
         -0.07026138997285196,
         0.018327857725418412,
         0.05671336704278445,
         -0.038270367414181744,
         -0.06908683642538511,
         0.05866983496408515,
         -0.06483713968800339,
         -0.01114334879876207,
         0.09329114200944574,
         -0.015445075172082613,
         0.06700849234306241,
         -0.0858622428102711,
         -0.035208583819094114,
         0.035208583819094134},
        {0.12301619688351301,
         -0.12301619688351337,
         -0.11169052267467316,
         -0.01498245869336512,
         0.13434187109235415,
         0.07600805981364528,
         0.0535236942915409,
         -0.03653518297828014,
         -0.10998508244016685,
         -0.047899551605678714,
         -0.04444345378335669,
         -0.013578910930708954,
         0.05048693811337735,
         0.07805433913491965,
         0.030972262550058603,
         0.026764394013900003,
         0.021130518022587287,
         -0.006817089127388377,
         -0.04478335214317149,
         -0.0497308603289587,
         -0.02138640786128244,
         -0.014378782033164244,
         -0.01316203858320372,
         -0.0072565111646074685,
         0.013351389540455248,
         0.03131464428175737,
         0.028854430807787143,
         0.015486120229533381,
         0.0078053468686791454,
         0.005528350585540632,
         0.005780433761186689,
         0.0002907990623386314,
         -0.011446450140713505,
         -0.017522100232384194,
         -0.01560896804709124,
         -0.03219829175011342,
         0.01671217152058002,
         -0.022612459152329126,
         0.018926892095302003,
         -0.022582759405118762,
         0.022398841929432502,
         -0.014767875168956796,
         0.028013337929652726,
         -0.012404369882561493,
         -0.12301619688351328,
         0.12301619688351319,
         -0.014982458693365034,
         0.019819929865470872,
         -0.014982458693365064,
         0.053523694291540885,
         0.051224911102832095,
         -0.05971916675946248,
         -0.03653518297828011,
         -0.04444345378335662,
         -0.0860223307310399,
         -0.001003544697249213,
         0.08496099864446906,
         0.0504869381133774,
         0.02676439401389998,
         0.07585259948654595,
         0.04575124690853384,
         -0.03564081062903081,
         -0.08707250038313576,
         -0.044783352143171466,
         -0.014378782033164252,
         -0.051722312139362236,
         -0.04907318994656346,
         -0.010585376595887198,
         0.0499944863401071,
         0.07356759092122515,
         0.03131464428175736,
         0.007805346868679151,
         0.032629077555467956,
         0.03251903058998841,
         0.023569814347015154,
         -0.008938223737602,
         -0.04739355078657008,
         -0.052646837399205344,
         -0.017522100232384187,
         0.01671217152058004,
         -0.04252379510567428,
         0.0039944299184571895,
         -0.036359086248154926,
         0.012983297441361183,
         -0.005688960407577794,
         0.05511711021124495,
         0.010775189948656368,
         0.028013337929652722,
         0.0154861202295334,
         0.007805346868679151,
         0.005528350585540669,
         0.005780433761186691,
         0.0002907990623386193,
         -0.011446450140713485,
         -0.017522100232384197,
         -0.01560896804709124,
         0.13434187109235415,
         -0.014982458693365067,
         -0.11169052267467311,
         -0.0365351829782801,
         -0.0597191667594625,
         0.05122491110283208,
         0.05352369429154089,
         -0.013578910930708852,
         -0.0010035446972492185,
         0.009632168384541383,
         -0.0010035446972492114,
         -0.013578910930708853,
         0.021130518022587284,
         0.045751246908533896,
         0.032477044241149486,
         -0.041224169392871234,
         -0.03564081062903083,
         -0.0068170891273883535,
         -0.01316203858320374,
         -0.04907318994656348,
         -0.07188211812891349,
         0.0011877877871557861,
         0.06991657652414889,
         0.049994486340107155,
         0.013351389540455259,
         0.005528350585540648,
         0.032519030589988486,
         0.07350287793564811,
         0.04157005470330227,
         -0.03390148102686982,
         -0.07958319596265276,
         -0.04739355078657006,
         -0.011446450140713493,
         -0.022612459152329116,
         0.003994429918457203,
         -0.07349662225307316,
         -0.028685344955245832,
         -0.030471393137800232,
         0.07011141647663784,
         0.05126896252920662,
         0.055117110211244935,
         -0.014767875168956807,
         0.007805346868679147,
         0.03262907755546796,
         0.03251903058998848,
         0.02356981434701512,
         -0.008938223737602053,
         -0.04739355078657001,
         -0.05264683739920533,
         -0.017522100232384197,
         -0.02138640786128244,
         -0.014378782033164256,
         -0.013162038583203717,
         -0.007256511164607471,
         0.013351389540455234,
         0.031314644281757356,
         0.028854430807787153,
         -0.10998508244016685,
         -0.03653518297828012,
         0.05352369429154087,
         0.0760080598136453,
         0.050486938113377414,
         0.08496099864446915,
         -0.0010035446972492432,
         -0.0860223307310398,
         -0.04444345378335663,
         -0.006817089127388356,
         -0.035640810629030815,
         -0.04122416939287119,
         0.0324770442411495,
         0.04575124690853388,
         0.021130518022587298,
         -0.007256511164607467,
         -0.010585376595887187,
         0.0011877877871558102,
         0.007495086890273813,
         0.0011877877871558108,
         -0.01058537659588719,
         -0.0072565111646074746,
         0.0057804337611866916,
         0.023569814347015147,
         0.0415700547033022,
         0.02681139476072244,
         -0.03543331608629934,
         -0.03390148102686992,
         -0.008938223737602027,
         0.000290799062338623,
         0.018926892095302017,
         -0.036359086248154884,
         -0.02868534495524585,
         -0.08863621808714603,
         0.022388006730354425,
         0.04520707818531285,
         0.07011141647663782,
         -0.005688960407577819,
         0.022398841929432495,
         0.005528350585540644,
         0.03251903058998849,
         0.07350287793564826,
         0.04157005470330221,
         -0.033901481026869906,
         -0.07958319596265262,
         -0.04739355078657006,
         -0.01144645014071349,
         -0.014378782033164256,
         -0.05172231213936228,
         -0.04907318994656349,
         -0.010585376595887201,
         0.04999448634010707,
         0.0735675909212251,
         0.031314644281757356,
         0.030972262550058628,
         0.0267643940139,
         0.021130518022587304,
         -0.006817089127388361,
         -0.044783352143171494,
         -0.04973086032895871,
         0.07805433913491967,
         0.050486938113377434,
         -0.013578910930708857,
         -0.04444345378335659,
         -0.047899551605678714,
         -0.04478335214317147,
         -0.08707250038313576,
         -0.03564081062903077,
         0.04575124690853391,
         0.07585259948654598,
         0.026764394013899975,
         0.013351389540455267,
         0.04999448634010711,
         0.06991657652414887,
         0.0011877877871557915,
         -0.0718821181289135,
         -0.04907318994656354,
         -0.013162038583203748,
         0.0002907990623386128,
         -0.008938223737602035,
         -0.03390148102686985,
         -0.035433316086299384,
         0.026811394760722425,
         0.041570054703302266,
         0.02356981434701514,
         0.005780433761186683,
         -0.02258275940511877,
         0.012983297441361178,
         -0.030471393137800264,
         0.022388006730354435,
         -0.013766085404777473,
         0.02238800673035443,
         -0.03047139313780026,
         0.01298329744136118,
         -0.02258275940511876,
         0.005780433761186689,
         0.02356981434701515,
         0.04157005470330228,
         0.026811394760722414,
         -0.03543331608629941,
         -0.03390148102686985,
         -0.008938223737602032,
         0.0002907990623386217,
         -0.013162038583203757,
         -0.04907318994656353,
         -0.07188211812891354,
         0.0011877877871558078,
         0.06991657652414886,
         0.04999448634010709,
         0.013351389540455262,
         0.026764394013899986,
         0.075852599486546,
         0.0457512469085339,
         -0.035640810629030774,
         -0.08707250038313577,
         -0.04478335214317148,
         -0.04789955160567869,
         -0.04444345378335659,
         -0.01357891093070886,
         0.05048693811337745,
         0.07805433913491966,
         -0.04973086032895871,
         -0.044783352143171494,
         -0.006817089127388369,
         0.021130518022587304,
         0.02676439401390001,
         0.030972262550058634,
         0.03131464428175736,
         0.07356759092122508,
         0.04999448634010709,
         -0.010585376595887194,
         -0.049073189946563484,
         -0.05172231213936229,
         -0.01437878203316425,
         -0.011446450140713504,
         -0.04739355078657005,
         -0.07958319596265265,
         -0.033901481026869906,
         0.041570054703302196,
         0.07350287793564825,
         0.03251903058998846,
         0.0055283505855406485,
         0.0223988419294325,
         -0.005688960407577844,
         0.07011141647663782,
         0.045207078185312916,
         0.022388006730354428,
         -0.08863621808714607,
         -0.028685344955245835,
         -0.03635908624815489,
         0.01892689209530201,
         0.0002907990623386257,
         -0.008938223737602035,
         -0.03390148102686993,
         -0.03543331608629935,
         0.02681139476072244,
         0.04157005470330218,
         0.02356981434701514,
         0.005780433761186688,
         -0.007256511164607472,
         -0.010585376595887189,
         0.0011877877871558239,
         0.007495086890273822,
         0.0011877877871558258,
         -0.010585376595887189,
         -0.007256511164607475,
         0.021130518022587298,
         0.045751246908533896,
         0.03247704424114949,
         -0.04122416939287118,
         -0.03564081062903081,
         -0.006817089127388344,
         -0.04444345378335663,
         -0.08602233073103983,
         -0.001003544697249214,
         0.08496099864446914,
         0.0504869381133774,
         0.0760080598136453,
         0.053523694291540864,
         -0.03653518297828011,
         -0.10998508244016683,
         0.028854430807787157,
         0.03131464428175735,
         0.013351389540455248,
         -0.007256511164607474,
         -0.01316203858320373,
         -0.014378782033164252,
         -0.021386407861282455,
         -0.017522100232384194,
         -0.05264683739920532,
         -0.04739355078656999,
         -0.00893822373760204,
         0.023569814347015123,
         0.03251903058998851,
         0.032629077555468,
         0.007805346868679139,
         -0.014767875168956807,
         0.05511711021124493,
         0.051268962529206576,
         0.0701114164766378,
         -0.030471393137800243,
         -0.028685344955245832,
         -0.07349662225307314,
         0.0039944299184572225,
         -0.022612459152329126,
         -0.011446450140713504,
         -0.04739355078657007,
         -0.0795831959626528,
         -0.033901481026869816,
         0.04157005470330227,
         0.07350287793564808,
         0.032519030589988465,
         0.00552835058554065,
         0.013351389540455269,
         0.04999448634010715,
         0.06991657652414889,
         0.0011877877871558245,
         -0.07188211812891353,
         -0.0490731899465635,
         -0.013162038583203755,
         -0.006817089127388353,
         -0.03564081062903081,
         -0.04122416939287122,
         0.0324770442411495,
         0.0457512469085339,
         0.0211305180225873,
         -0.013578910930708857,
         -0.001003544697249211,
         0.009632168384541395,
         -0.0010035446972492044,
         -0.013578910930708857,
         0.05352369429154087,
         0.05122491110283207,
         -0.05971916675946249,
         -0.03653518297828009,
         -0.11169052267467312,
         -0.014982458693365048,
         0.13434187109235415,
         -0.015608968047091238,
         -0.0175221002323842,
         -0.011446450140713492,
         0.0002907990623386225,
         0.005780433761186686,
         0.0055283505855406685,
         0.007805346868679149,
         0.015486120229533372,
         0.028013337929652733,
         0.010775189948656377,
         0.055117110211244956,
         -0.005688960407577794,
         0.012983297441361183,
         -0.036359086248154926,
         0.003994429918457192,
         -0.04252379510567428,
         0.016712171520580056,
         -0.0175221002323842,
         -0.05264683739920534,
         -0.047393550786570086,
         -0.008938223737602015,
         0.023569814347015158,
         0.032519030589988424,
         0.03262907755546798,
         0.00780534686867914,
         0.03131464428175737,
         0.07356759092122515,
         0.049994486340107086,
         -0.010585376595887198,
         -0.04907318994656349,
         -0.051722312139362236,
         -0.014378782033164242,
         -0.044783352143171494,
         -0.08707250038313576,
         -0.03564081062903082,
         0.04575124690853387,
         0.07585259948654596,
         0.026764394013899986,
         0.050486938113377414,
         0.08496099864446904,
         -0.0010035446972492088,
         -0.08602233073103992,
         -0.04444345378335664,
         -0.03653518297828009,
         -0.0597191667594625,
         0.05122491110283207,
         0.05352369429154087,
         -0.014982458693365062,
         0.0198199298654709,
         -0.014982458693365073,
         0.12301619688351319,
         -0.12301619688351327,
         -0.012404369882561472,
         0.028013337929652715,
         -0.01476787516895679,
         0.022398841929432492,
         -0.022582759405118766,
         0.018926892095302007,
         -0.022612459152329126,
         0.016712171520580025,
         -0.03219829175011344,
         -0.015608968047091241,
         -0.017522100232384197,
         -0.011446450140713514,
         0.00029079906233861886,
         0.005780433761186695,
         0.005528350585540635,
         0.007805346868679149,
         0.01548612022953338,
         0.028854430807787147,
         0.03131464428175738,
         0.013351389540455245,
         -0.007256511164607478,
         -0.013162038583203719,
         -0.014378782033164247,
         -0.02138640786128246,
         -0.04973086032895871,
         -0.04478335214317151,
         -0.006817089127388383,
         0.02113051802258729,
         0.02676439401390002,
         0.030972262550058634,
         0.07805433913491967,
         0.050486938113377344,
         -0.013578910930708864,
         -0.04444345378335666,
         -0.04789955160567873,
         -0.10998508244016682,
         -0.036535182978280116,
         0.05352369429154088,
         0.07600805981364529,
         0.13434187109235413,
         -0.014982458693365041,
         -0.11169052267467316,
         -0.12301619688351328,
         0.12301619688351327},
        {-0.0034007555963516565,
         0.003400755596351522,
         -0.0008339733586780751,
         0.0056020198423862855,
         -0.007635484551381216,
         0.002826861785038215,
         -0.0029893326395405914,
         -0.003362760793004127,
         0.009877325080050427,
         -0.0017070418037077872,
         -0.0017705908551860691,
         0.005580597212082206,
         -0.0013769630193944285,
         -0.009006457201028637,
         0.02616666993083709,
         -0.03867406780122357,
         0.04834061312090479,
         -0.05422307908562646,
         0.04674324580593391,
         -0.020556567194144216,
         -0.07867206519932152,
         0.0787580929027265,
         -0.05028165488711705,
         0.004660904867704036,
         0.04701880689561278,
         -0.08368329281764314,
         0.07634542907257304,
         0.11078198153431165,
         -0.0424774266207371,
         -0.030593218400241484,
         0.0765923351466077,
         -0.08049192793689382,
         0.03702259143673271,
         0.04115087061791238,
         -0.10745256332651339,
         -0.06241210326408548,
         -0.048369878270226076,
         0.08047979460521607,
         -0.06008431567172176,
         0.011643069596872408,
         0.03926449551087208,
         -0.06394622313536057,
         0.032839088881420286,
         0.07461347444509307,
         0.0034007555963515876,
         -0.0034007555963515793,
         0.0056020198423864034,
         -0.007410775671301857,
         0.005602019842386402,
         -0.0029893326395405793,
         -0.002092803353312945,
         0.00526885006958517,
         -0.003362760793003878,
         -0.0017705908551860709,
         0.004456687127599081,
         -0.00042066918350291055,
         -0.002656014192990144,
         -0.0013769630193944317,
         -0.03867406780122361,
         0.06565566207485765,
         -0.08246184475542907,
         0.07918487086781192,
         -0.06272393408934888,
         0.04674324580593393,
         0.0787580929027265,
         -0.08315473896710353,
         0.050150244649779845,
         0.0018323416455264436,
         -0.046629496451641245,
         0.07217394543267674,
         -0.08368329281764318,
         -0.04247742662073709,
         0.016727279431464168,
         0.015786137051807553,
         -0.033269190904797616,
         0.028583063921502207,
         -0.01261695540001496,
         -0.005257974790503696,
         0.04115087061791241,
         -0.04836987827022608,
         -0.0062197496778528365,
         0.02160238658137865,
         -0.015128971915039419,
         -0.005477272014634705,
         0.03247053010338992,
         -0.04602514896413402,
         0.02017598950069744,
         0.03283908888142033,
         0.11078198153431165,
         -0.04247742662073714,
         -0.030593218400241467,
         0.07659233514660774,
         -0.08049192793689379,
         0.03702259143673274,
         0.04115087061791237,
         -0.1074525633265134,
         -0.007635484551381226,
         0.00560201984238641,
         -0.0008339733586780263,
         -0.0033627607930038716,
         0.005268850069585179,
         -0.002092803353312948,
         -0.0029893326395405715,
         0.005580597212082053,
         -0.00042066918350289835,
         -0.002699052697510514,
         -0.0004206691835029053,
         0.005580597212082056,
         0.048340613120904784,
         -0.08246184475542907,
         0.09458106292134282,
         -0.09151101487590653,
         0.07918487086781187,
         -0.05422307908562646,
         -0.05028165488711709,
         0.050150244649779865,
         -0.02703591321521354,
         0.0015256719686866404,
         0.0238128191995488,
         -0.04662949645164126,
         0.047018806895612796,
         -0.030593218400241505,
         0.015786137051807553,
         0.005313934881653916,
         -0.02133138290449594,
         0.018272663926043695,
         -0.002134754538575785,
         -0.012616955400015,
         0.03702259143673274,
         0.08047979460521612,
         0.021602386581378672,
         -0.05622946292775643,
         0.03699346377894748,
         0.011078265052043295,
         -0.05232754314856028,
         0.06558940645088045,
         -0.04602514896413401,
         -0.06394622313536055,
         -0.0424774266207371,
         0.016727279431464164,
         0.01578613705180754,
         -0.03326919090479764,
         0.028583063921502196,
         -0.012616955400014996,
         -0.005257974790503706,
         0.04115087061791238,
         -0.07867206519932154,
         0.07875809290272648,
         -0.05028165488711708,
         0.004660904867704055,
         0.04701880689561277,
         -0.08368329281764313,
         0.07634542907257302,
         0.00987732508005044,
         -0.0033627607930038707,
         -0.0029893326395405654,
         0.002826861785038426,
         -0.0013769630193944352,
         -0.0026560141929901485,
         -0.000420669183502914,
         0.004456687127599078,
         -0.0017705908551860694,
         -0.05422307908562646,
         0.07918487086781188,
         -0.0915110148759065,
         0.0945810629213428,
         -0.08246184475542905,
         0.04834061312090477,
         0.004660904867704063,
         0.0018323416455264451,
         0.0015256719686866217,
         -0.0046782475065439075,
         0.0015256719686866278,
         0.0018323416455264324,
         0.004660904867704052,
         0.07659233514660775,
         -0.033269190904797644,
         -0.021331382904495978,
         0.04791296562723434,
         -0.04468209763568731,
         0.018272663926043674,
         0.028583063921502234,
         -0.08049192793689387,
         -0.0600843156717218,
         -0.01512897191503942,
         0.036993463778947494,
         -0.019822146787472964,
         -0.007854092153945735,
         0.035201218712105214,
         -0.05232754314856028,
         0.032470530103389905,
         0.039264495510872084,
         -0.030593218400241515,
         0.01578613705180755,
         0.005313934881653907,
         -0.021331382904495964,
         0.018272663926043677,
         -0.0021347545385757955,
         -0.012616955400014984,
         0.037022591436732706,
         0.07875809290272655,
         -0.08315473896710351,
         0.050150244649779865,
         0.0018323416455264428,
         -0.046629496451641265,
         0.07217394543267673,
         -0.08368329281764317,
         0.0261666699308371,
         -0.0386740678012236,
         0.0483406131209048,
         -0.05422307908562646,
         0.04674324580593391,
         -0.020556567194144212,
         -0.00900645720102865,
         -0.0013769630193944259,
         0.005580597212082055,
         -0.0017705908551860722,
         -0.0017070418037077489,
         0.04674324580593394,
         -0.06272393408934887,
         0.07918487086781191,
         -0.08246184475542909,
         0.06565566207485768,
         -0.038674067801223615,
         0.047018806895612796,
         -0.046629496451641245,
         0.023812819199548793,
         0.0015256719686866436,
         -0.027035913215213567,
         0.05015024464977986,
         -0.0502816548871171,
         -0.08049192793689385,
         0.028583063921502234,
         0.018272663926043688,
         -0.04468209763568727,
         0.047912965627234384,
         -0.021331382904495957,
         -0.033269190904797644,
         0.07659233514660775,
         0.011643069596872377,
         -0.005477272014634701,
         0.011078265052043314,
         -0.007854092153945738,
         0.004623224162398666,
         -0.00785409215394574,
         0.01107826505204331,
         -0.005477272014634703,
         0.011643069596872401,
         0.07659233514660775,
         -0.033269190904797644,
         -0.021331382904495964,
         0.04791296562723436,
         -0.044682097635687285,
         0.018272663926043698,
         0.028583063921502196,
         -0.08049192793689386,
         -0.050281654887117104,
         0.050150244649779845,
         -0.027035913215213554,
         0.00152567196868664,
         0.02381281919954879,
         -0.04662949645164126,
         0.047018806895612796,
         -0.038674067801223615,
         0.06565566207485765,
         -0.0824618447554291,
         0.07918487086781194,
         -0.06272393408934888,
         0.04674324580593393,
         -0.0017070418037077643,
         -0.0017705908551860718,
         0.005580597212082055,
         -0.001376963019394429,
         -0.009006457201028646,
         -0.02055656719414422,
         0.04674324580593392,
         -0.05422307908562646,
         0.04834061312090478,
         -0.03867406780122362,
         0.02616666993083711,
         -0.08368329281764315,
         0.07217394543267672,
         -0.04662949645164127,
         0.0018323416455264749,
         0.05015024464977986,
         -0.0831547389671035,
         0.07875809290272655,
         0.03702259143673273,
         -0.01261695540001499,
         -0.0021347545385757964,
         0.018272663926043663,
         -0.02133138290449596,
         0.005313934881653893,
         0.015786137051807553,
         -0.030593218400241484,
         0.039264495510872056,
         0.03247053010338994,
         -0.05232754314856027,
         0.0352012187121052,
         -0.007854092153945731,
         -0.019822146787472964,
         0.0369934637789475,
         -0.015128971915039414,
         -0.0600843156717218,
         -0.08049192793689387,
         0.028583063921502214,
         0.018272663926043677,
         -0.04468209763568732,
         0.04791296562723434,
         -0.02133138290449599,
         -0.03326919090479764,
         0.07659233514660777,
         0.0046609048677040636,
         0.0018323416455264475,
         0.0015256719686866235,
         -0.004678247506543921,
         0.0015256719686866371,
         0.0018323416455264467,
         0.004660904867704051,
         0.04834061312090478,
         -0.08246184475542909,
         0.09458106292134282,
         -0.09151101487590653,
         0.07918487086781187,
         -0.054223079085626465,
         -0.0017705908551860668,
         0.004456687127599104,
         -0.0004206691835029201,
         -0.0026560141929901485,
         -0.0013769630193944346,
         0.0028268617850384305,
         -0.002989332639540568,
         -0.0033627607930038755,
         0.00987732508005045,
         0.07634542907257302,
         -0.08368329281764314,
         0.04701880689561276,
         0.0046609048677040575,
         -0.05028165488711705,
         0.07875809290272649,
         -0.07867206519932153,
         0.04115087061791239,
         -0.005257974790503682,
         -0.012616955400014977,
         0.02858306392150218,
         -0.033269190904797644,
         0.01578613705180754,
         0.016727279431464157,
         -0.04247742662073711,
         -0.06394622313536055,
         -0.046025148964134004,
         0.06558940645088043,
         -0.052327543148560265,
         0.01107826505204331,
         0.03699346377894748,
         -0.05622946292775642,
         0.02160238658137865,
         0.0804797946052161,
         0.03702259143673272,
         -0.012616955400014986,
         -0.0021347545385757755,
         0.01827266392604368,
         -0.021331382904495943,
         0.00531393488165393,
         0.01578613705180755,
         -0.03059321840024148,
         0.04701880689561279,
         -0.046629496451641245,
         0.02381281919954879,
         0.0015256719686866432,
         -0.027035913215213564,
         0.050150244649779865,
         -0.05028165488711712,
         -0.054223079085626465,
         0.07918487086781185,
         -0.09151101487590652,
         0.09458106292134282,
         -0.08246184475542907,
         0.04834061312090479,
         0.005580597212082069,
         -0.00042066918350290973,
         -0.0026990526975105423,
         -0.0004206691835029124,
         0.00558059721208205,
         -0.0029893326395405728,
         -0.002092803353312938,
         0.005268850069585172,
         -0.0033627607930038837,
         -0.0008339733586780328,
         0.005602019842386408,
         -0.007635484551381208,
         -0.10745256332651344,
         0.04115087061791238,
         0.037022591436732755,
         -0.08049192793689378,
         0.07659233514660774,
         -0.030593218400241463,
         -0.04247742662073713,
         0.1107819815343117,
         0.03283908888142032,
         0.020175989500697454,
         -0.04602514896413403,
         0.03247053010338992,
         -0.005477272014634696,
         -0.01512897191503942,
         0.021602386581378676,
         -0.006219749677852837,
         -0.04836987827022611,
         0.04115087061791237,
         -0.0052579747905036715,
         -0.012616955400014965,
         0.028583063921502182,
         -0.033269190904797616,
         0.01578613705180755,
         0.01672727943146417,
         -0.042477426620737106,
         -0.08368329281764315,
         0.07217394543267672,
         -0.04662949645164128,
         0.0018323416455264373,
         0.05015024464977985,
         -0.0831547389671035,
         0.07875809290272655,
         0.04674324580593394,
         -0.06272393408934887,
         0.07918487086781194,
         -0.08246184475542911,
         0.06565566207485768,
         -0.03867406780122361,
         -0.0013769630193944341,
         -0.0026560141929901377,
         -0.0004206691835029142,
         0.004456687127599099,
         -0.0017705908551860848,
         -0.0033627607930038837,
         0.005268850069585163,
         -0.002092803353312937,
         -0.0029893326395405676,
         0.005602019842386397,
         -0.007410775671301841,
         0.005602019842386414,
         -0.003400755596351571,
         0.0034007555963515676,
         0.07461347444509304,
         0.032839088881420286,
         -0.06394622313536054,
         0.03926449551087208,
         0.01164306959687239,
         -0.06008431567172177,
         0.08047979460521608,
         -0.04836987827022608,
         -0.062412103264085486,
         -0.10745256332651343,
         0.041150870617912394,
         0.037022591436732706,
         -0.08049192793689386,
         0.07659233514660772,
         -0.030593218400241498,
         -0.04247742662073712,
         0.11078198153431164,
         0.07634542907257302,
         -0.08368329281764313,
         0.047018806895612775,
         0.0046609048677040636,
         -0.050281654887117055,
         0.07875809290272648,
         -0.07867206519932153,
         -0.02055656719414421,
         0.04674324580593392,
         -0.05422307908562646,
         0.048340613120904784,
         -0.03867406780122359,
         0.0261666699308371,
         -0.009006457201028656,
         -0.0013769630193944333,
         0.005580597212082069,
         -0.001770590855186071,
         -0.0017070418037077575,
         0.009877325080050446,
         -0.0033627607930038794,
         -0.002989332639540574,
         0.0028268617850384266,
         -0.00763548455138121,
         0.005602019842386407,
         -0.000833973358678056,
         0.00340075559635156,
         -0.003400755596351577}
    };

    m_array_all = {
        {
        {0, 0, 0, 0}
        },
        {
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1}
        },
        {
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2}
        },
        {
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3}
        },
        {
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4}
        },
        {
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2}
        },
        {
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3}
        },
        {
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4}
        },
        {
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2}
        },
        {
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4}
        },
        {
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3}
        },
        {
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4}
        },
        {
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4}
        },
        {
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4}
        },
        {
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, 0, -1, 0},
        {1, 0, 0, -1}
        },
        {
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, 0, -1, 0},
        {1, 0, 0, -1}
        },
        {
        {-1, -1, 1, 1},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 1, -1, -1}
        },
        {
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3}
        },
        {
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2}
        },
        {
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2}
        },
        {
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2}
        },
        {
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4}
        },
        {
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3}
        },
        {
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3}
        },
        {
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 3, -3},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {1, -1, -3, 3},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3}
        },
        {
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4}
        },
        {
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4}
        },
        {
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4}
        },
        {
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3}
        },
        {
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3}
        },
        {
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -1, 3},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 1, -3},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3}
        },
        {
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4}
        },
        {
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4}
        },
        {
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4}
        },
        {
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3}
        },
        {
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3}
        },
        {
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3}
        },
        {
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4}
        },
        {
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4}
        },
        {
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4}
        },
        {
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2}
        },
        {
        {-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}
        },
        {
        {-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}
        },
        {
        {-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}
        },
        {
        {-2, -2, 2, 2},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 2, -2, -2}
        },
        {
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}
        },
        {
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4}
        },
        {
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4}
        },
        {
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3}
        },
        {
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3}
        },
        {
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3}
        },
        {
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3}
        },
        {
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3}
        },
        {
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4}
        },
        {
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}
        },
        {
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4}
        },
        {
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4}
        },
        {
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4}
        },
        {
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}
        },
        {
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}
        },
        {
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}
        },
        {
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4}
        },
        {
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}
        },
        {
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}
        },
        {
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}
        },
        {
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 1, 1},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -1, -1},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 1, 1},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -1, -1},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 1, 1},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -1, -1},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 1, 1},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -1, -1},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 1, 1},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -1, -1},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4}
        },
        {
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}
        },
        {
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4}
        },
        {
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3}
        },
        {
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3}
        },
        {
        {-3, -3, 3, 3},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 3, -3, -3}
        },
        {
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3}
        },
        {
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3}
        },
        {
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3}
        },
        {
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 2, -3, -2},
        {3, 2, -2, -3}
        },
        {
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4}
        },
        {
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4}
        },
        {
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4}
        },
        {
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4}
        },
        {
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 1, 1},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 1, 1},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 1, 1},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -1, -1},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 1, 1},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -1, -1},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 1, 1},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -1, -1},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -1, -1},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -1, -1},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4}
        },
        {
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4}
        },
        {
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        },
        {
        {-4, -4, 4, 4},
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4},
        {4, 4, -4, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        },
        {
        {-4, -3, 3, 4},
        {-4, -3, 4, 3},
        {-4, -2, 2, 4},
        {-4, -2, 3, 3},
        {-4, -2, 4, 2},
        {-4, -1, 1, 4},
        {-4, -1, 2, 3},
        {-4, -1, 3, 2},
        {-4, -1, 4, 1},
        {-4, 0, 0, 4},
        {-4, 0, 1, 3},
        {-4, 0, 2, 2},
        {-4, 0, 3, 1},
        {-4, 0, 4, 0},
        {-4, 1, -1, 4},
        {-4, 1, 0, 3},
        {-4, 1, 1, 2},
        {-4, 1, 2, 1},
        {-4, 1, 3, 0},
        {-4, 1, 4, -1},
        {-4, 2, -2, 4},
        {-4, 2, -1, 3},
        {-4, 2, 0, 2},
        {-4, 2, 1, 1},
        {-4, 2, 2, 0},
        {-4, 2, 3, -1},
        {-4, 2, 4, -2},
        {-4, 3, -3, 4},
        {-4, 3, -2, 3},
        {-4, 3, -1, 2},
        {-4, 3, 0, 1},
        {-4, 3, 1, 0},
        {-4, 3, 2, -1},
        {-4, 3, 3, -2},
        {-4, 3, 4, -3},
        {-4, 4, -4, 4},
        {-4, 4, -3, 3},
        {-4, 4, -2, 2},
        {-4, 4, -1, 1},
        {-4, 4, 0, 0},
        {-4, 4, 1, -1},
        {-4, 4, 2, -2},
        {-4, 4, 3, -3},
        {-4, 4, 4, -4},
        {-3, -4, 3, 4},
        {-3, -4, 4, 3},
        {-3, -3, 2, 4},
        {-3, -3, 3, 3},
        {-3, -3, 4, 2},
        {-3, -2, 1, 4},
        {-3, -2, 2, 3},
        {-3, -2, 3, 2},
        {-3, -2, 4, 1},
        {-3, -1, 0, 4},
        {-3, -1, 1, 3},
        {-3, -1, 2, 2},
        {-3, -1, 3, 1},
        {-3, -1, 4, 0},
        {-3, 0, -1, 4},
        {-3, 0, 0, 3},
        {-3, 0, 1, 2},
        {-3, 0, 2, 1},
        {-3, 0, 3, 0},
        {-3, 0, 4, -1},
        {-3, 1, -2, 4},
        {-3, 1, -1, 3},
        {-3, 1, 0, 2},
        {-3, 1, 1, 1},
        {-3, 1, 2, 0},
        {-3, 1, 3, -1},
        {-3, 1, 4, -2},
        {-3, 2, -3, 4},
        {-3, 2, -2, 3},
        {-3, 2, -1, 2},
        {-3, 2, 0, 1},
        {-3, 2, 1, 0},
        {-3, 2, 2, -1},
        {-3, 2, 3, -2},
        {-3, 2, 4, -3},
        {-3, 3, -4, 4},
        {-3, 3, -3, 3},
        {-3, 3, -2, 2},
        {-3, 3, -1, 1},
        {-3, 3, 0, 0},
        {-3, 3, 1, -1},
        {-3, 3, 2, -2},
        {-3, 3, 3, -3},
        {-3, 3, 4, -4},
        {-3, 4, -4, 3},
        {-3, 4, -3, 2},
        {-3, 4, -2, 1},
        {-3, 4, -1, 0},
        {-3, 4, 0, -1},
        {-3, 4, 1, -2},
        {-3, 4, 2, -3},
        {-3, 4, 3, -4},
        {-2, -4, 2, 4},
        {-2, -4, 3, 3},
        {-2, -4, 4, 2},
        {-2, -3, 1, 4},
        {-2, -3, 2, 3},
        {-2, -3, 3, 2},
        {-2, -3, 4, 1},
        {-2, -2, 0, 4},
        {-2, -2, 1, 3},
        {-2, -2, 2, 2},
        {-2, -2, 3, 1},
        {-2, -2, 4, 0},
        {-2, -1, -1, 4},
        {-2, -1, 0, 3},
        {-2, -1, 1, 2},
        {-2, -1, 2, 1},
        {-2, -1, 3, 0},
        {-2, -1, 4, -1},
        {-2, 0, -2, 4},
        {-2, 0, -1, 3},
        {-2, 0, 0, 2},
        {-2, 0, 1, 1},
        {-2, 0, 2, 0},
        {-2, 0, 3, -1},
        {-2, 0, 4, -2},
        {-2, 1, -3, 4},
        {-2, 1, -2, 3},
        {-2, 1, -1, 2},
        {-2, 1, 0, 1},
        {-2, 1, 1, 0},
        {-2, 1, 2, -1},
        {-2, 1, 3, -2},
        {-2, 1, 4, -3},
        {-2, 2, -4, 4},
        {-2, 2, -3, 3},
        {-2, 2, -2, 2},
        {-2, 2, -1, 1},
        {-2, 2, 0, 0},
        {-2, 2, 1, -1},
        {-2, 2, 2, -2},
        {-2, 2, 3, -3},
        {-2, 2, 4, -4},
        {-2, 3, -4, 3},
        {-2, 3, -3, 2},
        {-2, 3, -2, 1},
        {-2, 3, -1, 0},
        {-2, 3, 0, -1},
        {-2, 3, 1, -2},
        {-2, 3, 2, -3},
        {-2, 3, 3, -4},
        {-2, 4, -4, 2},
        {-2, 4, -3, 1},
        {-2, 4, -2, 0},
        {-2, 4, -1, -1},
        {-2, 4, 0, -2},
        {-2, 4, 1, -3},
        {-2, 4, 2, -4},
        {-1, -4, 1, 4},
        {-1, -4, 2, 3},
        {-1, -4, 3, 2},
        {-1, -4, 4, 1},
        {-1, -3, 0, 4},
        {-1, -3, 1, 3},
        {-1, -3, 2, 2},
        {-1, -3, 3, 1},
        {-1, -3, 4, 0},
        {-1, -2, -1, 4},
        {-1, -2, 0, 3},
        {-1, -2, 1, 2},
        {-1, -2, 2, 1},
        {-1, -2, 3, 0},
        {-1, -2, 4, -1},
        {-1, -1, -2, 4},
        {-1, -1, -1, 3},
        {-1, -1, 0, 2},
        {-1, -1, 1, 1},
        {-1, -1, 2, 0},
        {-1, -1, 3, -1},
        {-1, -1, 4, -2},
        {-1, 0, -3, 4},
        {-1, 0, -2, 3},
        {-1, 0, -1, 2},
        {-1, 0, 0, 1},
        {-1, 0, 1, 0},
        {-1, 0, 2, -1},
        {-1, 0, 3, -2},
        {-1, 0, 4, -3},
        {-1, 1, -4, 4},
        {-1, 1, -3, 3},
        {-1, 1, -2, 2},
        {-1, 1, -1, 1},
        {-1, 1, 0, 0},
        {-1, 1, 1, -1},
        {-1, 1, 2, -2},
        {-1, 1, 3, -3},
        {-1, 1, 4, -4},
        {-1, 2, -4, 3},
        {-1, 2, -3, 2},
        {-1, 2, -2, 1},
        {-1, 2, -1, 0},
        {-1, 2, 0, -1},
        {-1, 2, 1, -2},
        {-1, 2, 2, -3},
        {-1, 2, 3, -4},
        {-1, 3, -4, 2},
        {-1, 3, -3, 1},
        {-1, 3, -2, 0},
        {-1, 3, -1, -1},
        {-1, 3, 0, -2},
        {-1, 3, 1, -3},
        {-1, 3, 2, -4},
        {-1, 4, -4, 1},
        {-1, 4, -3, 0},
        {-1, 4, -2, -1},
        {-1, 4, -1, -2},
        {-1, 4, 0, -3},
        {-1, 4, 1, -4},
        {0, -4, 0, 4},
        {0, -4, 1, 3},
        {0, -4, 2, 2},
        {0, -4, 3, 1},
        {0, -4, 4, 0},
        {0, -3, -1, 4},
        {0, -3, 0, 3},
        {0, -3, 1, 2},
        {0, -3, 2, 1},
        {0, -3, 3, 0},
        {0, -3, 4, -1},
        {0, -2, -2, 4},
        {0, -2, -1, 3},
        {0, -2, 0, 2},
        {0, -2, 1, 1},
        {0, -2, 2, 0},
        {0, -2, 3, -1},
        {0, -2, 4, -2},
        {0, -1, -3, 4},
        {0, -1, -2, 3},
        {0, -1, -1, 2},
        {0, -1, 0, 1},
        {0, -1, 1, 0},
        {0, -1, 2, -1},
        {0, -1, 3, -2},
        {0, -1, 4, -3},
        {0, 0, -4, 4},
        {0, 0, -3, 3},
        {0, 0, -2, 2},
        {0, 0, -1, 1},
        {0, 0, 0, 0},
        {0, 0, 1, -1},
        {0, 0, 2, -2},
        {0, 0, 3, -3},
        {0, 0, 4, -4},
        {0, 1, -4, 3},
        {0, 1, -3, 2},
        {0, 1, -2, 1},
        {0, 1, -1, 0},
        {0, 1, 0, -1},
        {0, 1, 1, -2},
        {0, 1, 2, -3},
        {0, 1, 3, -4},
        {0, 2, -4, 2},
        {0, 2, -3, 1},
        {0, 2, -2, 0},
        {0, 2, -1, -1},
        {0, 2, 0, -2},
        {0, 2, 1, -3},
        {0, 2, 2, -4},
        {0, 3, -4, 1},
        {0, 3, -3, 0},
        {0, 3, -2, -1},
        {0, 3, -1, -2},
        {0, 3, 0, -3},
        {0, 3, 1, -4},
        {0, 4, -4, 0},
        {0, 4, -3, -1},
        {0, 4, -2, -2},
        {0, 4, -1, -3},
        {0, 4, 0, -4},
        {1, -4, -1, 4},
        {1, -4, 0, 3},
        {1, -4, 1, 2},
        {1, -4, 2, 1},
        {1, -4, 3, 0},
        {1, -4, 4, -1},
        {1, -3, -2, 4},
        {1, -3, -1, 3},
        {1, -3, 0, 2},
        {1, -3, 1, 1},
        {1, -3, 2, 0},
        {1, -3, 3, -1},
        {1, -3, 4, -2},
        {1, -2, -3, 4},
        {1, -2, -2, 3},
        {1, -2, -1, 2},
        {1, -2, 0, 1},
        {1, -2, 1, 0},
        {1, -2, 2, -1},
        {1, -2, 3, -2},
        {1, -2, 4, -3},
        {1, -1, -4, 4},
        {1, -1, -3, 3},
        {1, -1, -2, 2},
        {1, -1, -1, 1},
        {1, -1, 0, 0},
        {1, -1, 1, -1},
        {1, -1, 2, -2},
        {1, -1, 3, -3},
        {1, -1, 4, -4},
        {1, 0, -4, 3},
        {1, 0, -3, 2},
        {1, 0, -2, 1},
        {1, 0, -1, 0},
        {1, 0, 0, -1},
        {1, 0, 1, -2},
        {1, 0, 2, -3},
        {1, 0, 3, -4},
        {1, 1, -4, 2},
        {1, 1, -3, 1},
        {1, 1, -2, 0},
        {1, 1, -1, -1},
        {1, 1, 0, -2},
        {1, 1, 1, -3},
        {1, 1, 2, -4},
        {1, 2, -4, 1},
        {1, 2, -3, 0},
        {1, 2, -2, -1},
        {1, 2, -1, -2},
        {1, 2, 0, -3},
        {1, 2, 1, -4},
        {1, 3, -4, 0},
        {1, 3, -3, -1},
        {1, 3, -2, -2},
        {1, 3, -1, -3},
        {1, 3, 0, -4},
        {1, 4, -4, -1},
        {1, 4, -3, -2},
        {1, 4, -2, -3},
        {1, 4, -1, -4},
        {2, -4, -2, 4},
        {2, -4, -1, 3},
        {2, -4, 0, 2},
        {2, -4, 1, 1},
        {2, -4, 2, 0},
        {2, -4, 3, -1},
        {2, -4, 4, -2},
        {2, -3, -3, 4},
        {2, -3, -2, 3},
        {2, -3, -1, 2},
        {2, -3, 0, 1},
        {2, -3, 1, 0},
        {2, -3, 2, -1},
        {2, -3, 3, -2},
        {2, -3, 4, -3},
        {2, -2, -4, 4},
        {2, -2, -3, 3},
        {2, -2, -2, 2},
        {2, -2, -1, 1},
        {2, -2, 0, 0},
        {2, -2, 1, -1},
        {2, -2, 2, -2},
        {2, -2, 3, -3},
        {2, -2, 4, -4},
        {2, -1, -4, 3},
        {2, -1, -3, 2},
        {2, -1, -2, 1},
        {2, -1, -1, 0},
        {2, -1, 0, -1},
        {2, -1, 1, -2},
        {2, -1, 2, -3},
        {2, -1, 3, -4},
        {2, 0, -4, 2},
        {2, 0, -3, 1},
        {2, 0, -2, 0},
        {2, 0, -1, -1},
        {2, 0, 0, -2},
        {2, 0, 1, -3},
        {2, 0, 2, -4},
        {2, 1, -4, 1},
        {2, 1, -3, 0},
        {2, 1, -2, -1},
        {2, 1, -1, -2},
        {2, 1, 0, -3},
        {2, 1, 1, -4},
        {2, 2, -4, 0},
        {2, 2, -3, -1},
        {2, 2, -2, -2},
        {2, 2, -1, -3},
        {2, 2, 0, -4},
        {2, 3, -4, -1},
        {2, 3, -3, -2},
        {2, 3, -2, -3},
        {2, 3, -1, -4},
        {2, 4, -4, -2},
        {2, 4, -3, -3},
        {2, 4, -2, -4},
        {3, -4, -3, 4},
        {3, -4, -2, 3},
        {3, -4, -1, 2},
        {3, -4, 0, 1},
        {3, -4, 1, 0},
        {3, -4, 2, -1},
        {3, -4, 3, -2},
        {3, -4, 4, -3},
        {3, -3, -4, 4},
        {3, -3, -3, 3},
        {3, -3, -2, 2},
        {3, -3, -1, 1},
        {3, -3, 0, 0},
        {3, -3, 1, -1},
        {3, -3, 2, -2},
        {3, -3, 3, -3},
        {3, -3, 4, -4},
        {3, -2, -4, 3},
        {3, -2, -3, 2},
        {3, -2, -2, 1},
        {3, -2, -1, 0},
        {3, -2, 0, -1},
        {3, -2, 1, -2},
        {3, -2, 2, -3},
        {3, -2, 3, -4},
        {3, -1, -4, 2},
        {3, -1, -3, 1},
        {3, -1, -2, 0},
        {3, -1, -1, -1},
        {3, -1, 0, -2},
        {3, -1, 1, -3},
        {3, -1, 2, -4},
        {3, 0, -4, 1},
        {3, 0, -3, 0},
        {3, 0, -2, -1},
        {3, 0, -1, -2},
        {3, 0, 0, -3},
        {3, 0, 1, -4},
        {3, 1, -4, 0},
        {3, 1, -3, -1},
        {3, 1, -2, -2},
        {3, 1, -1, -3},
        {3, 1, 0, -4},
        {3, 2, -4, -1},
        {3, 2, -3, -2},
        {3, 2, -2, -3},
        {3, 2, -1, -4},
        {3, 3, -4, -2},
        {3, 3, -3, -3},
        {3, 3, -2, -4},
        {3, 4, -4, -3},
        {3, 4, -3, -4},
        {4, -4, -4, 4},
        {4, -4, -3, 3},
        {4, -4, -2, 2},
        {4, -4, -1, 1},
        {4, -4, 0, 0},
        {4, -4, 1, -1},
        {4, -4, 2, -2},
        {4, -4, 3, -3},
        {4, -4, 4, -4},
        {4, -3, -4, 3},
        {4, -3, -3, 2},
        {4, -3, -2, 1},
        {4, -3, -1, 0},
        {4, -3, 0, -1},
        {4, -3, 1, -2},
        {4, -3, 2, -3},
        {4, -3, 3, -4},
        {4, -2, -4, 2},
        {4, -2, -3, 1},
        {4, -2, -2, 0},
        {4, -2, -1, -1},
        {4, -2, 0, -2},
        {4, -2, 1, -3},
        {4, -2, 2, -4},
        {4, -1, -4, 1},
        {4, -1, -3, 0},
        {4, -1, -2, -1},
        {4, -1, -1, -2},
        {4, -1, 0, -3},
        {4, -1, 1, -4},
        {4, 0, -4, 0},
        {4, 0, -3, -1},
        {4, 0, -2, -2},
        {4, 0, -1, -3},
        {4, 0, 0, -4},
        {4, 1, -4, -1},
        {4, 1, -3, -2},
        {4, 1, -2, -3},
        {4, 1, -1, -4},
        {4, 2, -4, -2},
        {4, 2, -3, -3},
        {4, 2, -2, -4},
        {4, 3, -4, -3},
        {4, 3, -3, -4}
        }
    };

}
