/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_ver2_order5.h"

GtinvDataVer2Order5::GtinvDataVer2Order5(){

    set_gtinv_info();
}

GtinvDataVer2Order5::~GtinvDataVer2Order5(){}

const vector2i& GtinvDataVer2Order5::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataVer2Order5::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataVer2Order5::get_coeffs() const{ return coeffs_all; }

void GtinvDataVer2Order5::set_gtinv_info(){

    l_array_all = {
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, 1},
        {0, 0, 0, 2, 2},
        {0, 0, 1, 1, 2},
        {0, 0, 2, 2, 2},
        {0, 1, 1, 1, 1},
        {0, 1, 1, 1, 1},
        {0, 1, 1, 1, 1},
        {0, 1, 1, 2, 2},
        {0, 1, 1, 2, 2},
        {0, 1, 1, 2, 2},
        {0, 2, 2, 2, 2},
        {0, 2, 2, 2, 2},
        {0, 2, 2, 2, 2},
        {0, 2, 2, 2, 2},
        {0, 2, 2, 2, 2},
        {1, 1, 1, 1, 2},
        {1, 1, 1, 1, 2},
        {1, 1, 1, 1, 2},
        {1, 1, 1, 1, 2},
        {1, 1, 1, 1, 2},
        {1, 1, 1, 1, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {1, 1, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2},
        {2, 2, 2, 2, 2}
    };

    coeffs_all = {
        {1.0},
        {0.5773502691896258,
         -0.5773502691896255,
         0.5773502691896256},
        {0.44721359549995804,
         -0.447213595499958,
         0.4472135954999579,
         -0.4472135954999579,
         0.4472135954999581},
        {0.44721359549995815,
         -0.31622776601683733,
         0.18257418583505536,
         -0.3162277660168378,
         0.36514837167011066,
         -0.31622776601683783,
         0.18257418583505539,
         -0.3162277660168379,
         0.44721359549995787},
        {0.23904572186687892,
         -0.2927700218845595,
         0.23904572186687875,
         -0.29277002188455986,
         0.11952286093343933,
         0.1195228609334393,
         -0.29277002188455986,
         0.23904572186687875,
         0.11952286093343933,
         -0.2390457218668786,
         0.1195228609334393,
         0.2390457218668787,
         -0.2927700218845598,
         0.11952286093343933,
         0.11952286093343933,
         -0.2927700218845598,
         0.2390457218668788,
         -0.29277002188456,
         0.2390457218668788},
        {0.2883343901782501,
         -0.28833439017824986,
         -0.30452544836356005,
         0.01619105818531022,
         0.27214333199293966,
         -0.2883343901782499,
         0.28833439017824997,
         0.01619105818531017,
         -0.016191058185310206,
         0.0161910581853102,
         0.28833439017824997,
         -0.28833439017824997,
         0.27214333199293966,
         0.01619105818531017,
         -0.3045254483635601,
         -0.28833439017824986,
         0.2883343901782499},
        {-0.01402186770263054,
         0.014021867702630616,
         -0.3189180078694474,
         0.3329398755720785,
         -0.346961743274709,
         0.014021867702630674,
         -0.01402186770263067,
         0.33293987557207827,
         -0.3329398755720783,
         0.33293987557207827,
         -0.014021867702630704,
         0.014021867702630681,
         -0.346961743274709,
         0.3329398755720783,
         -0.31891800786944763,
         0.014021867702630626,
         -0.014021867702630586},
        {0.44721359549995787,
         -0.22360679774997927,
         -0.223606797749979,
         0.07453559924999308,
         0.14907119849998607,
         0.07453559924999309,
         -0.223606797749979,
         -0.223606797749979,
         0.1490711984999861,
         0.29814239699997214,
         0.14907119849998607,
         -0.223606797749979,
         -0.22360679774997896,
         0.07453559924999308,
         0.14907119849998604,
         0.0745355992499931,
         -0.223606797749979,
         -0.22360679774997894,
         0.44721359549995815},
        {0.23904572186687875,
         -0.29277002188456014,
         0.23904572186687886,
         -0.20701966780270623,
         0.08451542547285161,
         0.08451542547285162,
         -0.20701966780270623,
         0.09759000729485336,
         0.048795003647426644,
         -0.09759000729485333,
         0.04879500364742665,
         0.09759000729485338,
         -0.20701966780270623,
         0.08451542547285164,
         0.08451542547285164,
         -0.20701966780270623,
         0.19518001458970669,
         0.09759000729485333,
         -0.1951800145897066,
         0.09759000729485333,
         0.19518001458970669,
         -0.20701966780270623,
         0.08451542547285164,
         0.08451542547285164,
         -0.20701966780270623,
         0.09759000729485336,
         0.04879500364742665,
         -0.09759000729485334,
         0.04879500364742665,
         0.09759000729485338,
         -0.20701966780270617,
         0.08451542547285164,
         0.08451542547285164,
         -0.20701966780270617,
         0.23904572186687892,
         -0.2927700218845601,
         0.23904572186687892},
        {0.1798102963308435,
         -0.22022173825460228,
         0.22022173825460253,
         -0.17981029633084336,
         -0.2990470735320471,
         0.1719019936693451,
         -0.04475691380664317,
         -0.08238816605605874,
         0.2095332459187608,
         -0.17981029633084336,
         0.22022173825460228,
         -0.22022173825460234,
         0.1798102963308434,
         0.044756913806643164,
         -0.04475691380664316,
         0.044756913806643144,
         -0.04475691380664313,
         0.04475691380664312,
         0.17981029633084342,
         -0.22022173825460228,
         0.2202217382546023,
         -0.17981029633084336,
         0.20953324591876085,
         -0.08238816605605874,
         -0.04475691380664317,
         0.17190199366934508,
         -0.2990470735320471,
         -0.17981029633084336,
         0.2202217382546023,
         -0.2202217382546023,
         0.17981029633084342},
        {0.03164791725765979,
         -0.03876062435154341,
         0.03876062435154343,
         -0.03164791725765918,
         0.20953324591876077,
         -0.2319117028220823,
         0.25429015972540386,
         -0.27666861662872544,
         0.29904707353204707,
         -0.03164791725765918,
         0.0387606243515434,
         -0.038760624351543455,
         0.03164791725765917,
         -0.25429015972540386,
         0.2542901597254038,
         -0.25429015972540386,
         0.2542901597254038,
         -0.2542901597254039,
         0.03164791725765917,
         -0.03876062435154347,
         0.03876062435154341,
         -0.03164791725765918,
         0.29904707353204707,
         -0.27666861662872544,
         0.25429015972540386,
         -0.23191170282208234,
         0.20953324591876074,
         -0.031647917257659176,
         0.03876062435154341,
         -0.03876062435154349,
         0.03164791725765914},
        {0.006345863760326296,
         -0.0063458637603261625,
         -0.13233315721340566,
         0.154302291517166,
         -0.11964142969275327,
         0.21163252322888007,
         -0.09712149183205665,
         -0.05718079968510925,
         0.16632935713035735,
         -0.16382839355300122,
         -0.04780412967587894,
         0.12710349569135337,
         -0.08041556825374853,
         -0.08591378887660939,
         -0.0063458637603263385,
         0.006345863760326276,
         0.15430229151716598,
         -0.18898094017961886,
         0.154302291517166,
         -0.09712149183205677,
         0.062301266056998296,
         0.0006923806695413681,
         -0.05718079968510914,
         -0.04780412967587893,
         -0.04487934452978943,
         0.0618774444882656,
         -0.015881897720202025,
         -0.08041556825374847,
         0.21163252322887996,
         -0.09712149183205677,
         -0.05718079968510914,
         0.16632935713035782,
         -0.11964142969275299,
         0.154302291517166,
         -0.1323331572134056,
         -0.05718079968510917,
         0.0006923806695413453,
         0.0623012660569983,
         -0.09712149183205673,
         0.12710349569135335,
         0.06187744448826555,
         -0.12487109121480522,
         0.061877444488265564,
         0.12710349569135337,
         -0.09712149183205679,
         0.062301266056998275,
         0.0006923806695413319,
         -0.057180799685109134,
         -0.1323331572134056,
         0.154302291517166,
         -0.119641429692753,
         0.16632935713035776,
         -0.05718079968510921,
         -0.09712149183205679,
         0.21163252322888,
         -0.08041556825374845,
         -0.01588189772020199,
         0.061877444488265584,
         -0.044879344529789436,
         -0.04780412967587884,
         -0.057180799685109196,
         0.0006923806695413127,
         0.06230126605699826,
         -0.09712149183205679,
         0.154302291517166,
         -0.18898094017961886,
         0.15430229151716598,
         0.006345863760326301,
         -0.0063458637603263654,
         -0.08591378887660935,
         -0.08041556825374854,
         0.12710349569135343,
         -0.047804129675879,
         -0.16382839355300116,
         0.1663293571303579,
         -0.05718079968510918,
         -0.09712149183205677,
         0.21163252322888,
         -0.11964142969275302,
         0.154302291517166,
         -0.13233315721340566,
         -0.006345863760326304,
         0.006345863760326293},
        {0.013254832322646024,
         -0.013254832322645946,
         0.007865249622046988,
         -0.025866712045132856,
         0.034374914267339046,
         0.08984042311177576,
         -0.11966452158661467,
         0.14553123363174755,
         -0.15320066894585493,
         -0.204476463789358,
         0.11463604067758196,
         -0.01693036794375907,
         -0.10189538673475683,
         0.2550960556806119,
         -0.013254832322645993,
         0.013254832322646026,
         -0.02586671204513289,
         0.031680122917039505,
         -0.025866712045132884,
         -0.11966452158661456,
         0.17037338239572686,
         -0.18093342336807344,
         0.1455312336317475,
         0.11463604067758201,
         -0.05791795468862346,
         -0.014749754973280479,
         0.07685742366283783,
         -0.10189538673475688,
         0.0898404231117759,
         -0.11966452158661461,
         0.1455312336317475,
         -0.1532006689458549,
         0.03437491426733906,
         -0.025866712045132897,
         0.007865249622047016,
         0.1455312336317475,
         -0.18093342336807336,
         0.1703733823957268,
         -0.11966452158661454,
         -0.016930367943759076,
         -0.014749754973280474,
         0.025309795945626996,
         -0.014749754973280462,
         -0.016930367943759076,
         -0.11966452158661453,
         0.17037338239572683,
         -0.18093342336807333,
         0.14553123363174747,
         0.00786524962204699,
         -0.02586671204513288,
         0.03437491426733906,
         -0.15320066894585496,
         0.14553123363174753,
         -0.11966452158661466,
         0.0898404231117759,
         -0.10189538673475694,
         0.07685742366283785,
         -0.014749754973280457,
         -0.05791795468862344,
         0.114636040677582,
         0.1455312336317475,
         -0.18093342336807328,
         0.17037338239572686,
         -0.11966452158661456,
         -0.02586671204513287,
         0.03168012291703947,
         -0.02586671204513288,
         0.013254832322645979,
         -0.013254832322646015,
         0.25509605568061194,
         -0.10189538673475688,
         -0.016930367943759062,
         0.11463604067758197,
         -0.20447646378935797,
         -0.15320066894585493,
         0.1455312336317475,
         -0.11966452158661468,
         0.08984042311177591,
         0.03437491426733901,
         -0.025866712045132825,
         0.007865249622047104,
         -0.01325483232264605,
         0.013254832322645942},
        {0.18780689843962875,
         -0.1878068984396286,
         -0.18503693449108505,
         -0.0033924991399184035,
         0.1905768623881724,
         0.09973270775260162,
         0.10447591420598268,
         -0.10108341506606422,
         -0.1080425995982327,
         -0.0015439061618599723,
         -0.09818880159074155,
         0.012884574852258277,
         0.06964968793768128,
         0.03839291166055133,
         -0.18780689843962867,
         0.18780689843962853,
         -0.0033924991399185,
         0.004154945922815532,
         -0.0033924991399185062,
         0.10447591420598268,
         0.06123554030617545,
         -0.06262052228044729,
         -0.10108341506606419,
         -0.0981888015907415,
         -0.12950024626958476,
         -0.017039520775073824,
         0.16219430584546052,
         0.06964968793768127,
         0.09973270775260164,
         0.10447591420598265,
         -0.10108341506606416,
         -0.10804259959823267,
         0.1905768623881723,
         -0.003392499139918471,
         -0.18503693449108488,
         -0.10108341506606418,
         -0.06262052228044729,
         0.06123554030617542,
         0.10447591420598269,
         0.012884574852258293,
         -0.017039520775073803,
         0.01842450274934566,
         -0.01703952077507377,
         0.012884574852258286,
         0.1044759142059826,
         0.06123554030617544,
         -0.06262052228044729,
         -0.10108341506606419,
         -0.1850369344910849,
         -0.0033924991399184885,
         0.1905768623881723,
         -0.10804259959823272,
         -0.10108341506606422,
         0.10447591420598268,
         0.09973270775260162,
         0.06964968793768124,
         0.16219430584546055,
         -0.017039520775073817,
         -0.1295002462695847,
         -0.0981888015907415,
         -0.10108341506606418,
         -0.06262052228044727,
         0.06123554030617546,
         0.10447591420598268,
         -0.003392499139918498,
         0.004154945922815541,
         -0.003392499139918502,
         0.18780689843962858,
         -0.1878068984396286,
         0.038392911660551365,
         0.06964968793768127,
         0.012884574852258298,
         -0.09818880159074156,
         -0.0015439061618599417,
         -0.10804259959823272,
         -0.10108341506606414,
         0.10447591420598272,
         0.09973270775260162,
         0.19057686238817242,
         -0.003392499139918476,
         -0.18503693449108502,
         -0.18780689843962867,
         0.1878068984396287},
        {0.33333333333333365,
         -0.1666666666666664,
         -0.16666666666666669,
         0.07142857142857138,
         0.11664236870396089,
         0.07142857142857138,
         -0.02380952380952379,
         -0.05832118435198044,
         -0.058321184351980436,
         -0.023809523809523784,
         0.0047619047619047485,
         0.019047619047619032,
         0.028571428571428557,
         0.01904761904761903,
         0.004761904761904751,
         -0.16666666666666666,
         -0.16666666666666663,
         0.11664236870396082,
         0.19047619047619044,
         0.11664236870396082,
         -0.058321184351980346,
         -0.14285714285714274,
         -0.1428571428571427,
         -0.05832118435198034,
         0.01904761904761904,
         0.0761904761904761,
         0.11428571428571423,
         0.0761904761904761,
         0.019047619047619025,
         -0.023809523809523798,
         -0.05832118435198041,
         -0.05832118435198043,
         -0.023809523809523794,
         0.07142857142857138,
         0.11664236870396084,
         0.0714285714285714,
         -0.05832118435198034,
         -0.1428571428571427,
         -0.14285714285714274,
         -0.058321184351980346,
         0.028571428571428536,
         0.1142857142857142,
         0.17142857142857132,
         0.1142857142857142,
         0.028571428571428536,
         -0.05832118435198036,
         -0.14285714285714274,
         -0.14285714285714274,
         -0.05832118435198034,
         0.07142857142857138,
         0.11664236870396082,
         0.07142857142857138,
         -0.02380952380952379,
         -0.05832118435198043,
         -0.058321184351980394,
         -0.023809523809523798,
         0.019047619047619025,
         0.0761904761904761,
         0.11428571428571423,
         0.0761904761904761,
         0.019047619047619053,
         -0.05832118435198035,
         -0.14285714285714274,
         -0.14285714285714274,
         -0.058321184351980346,
         0.11664236870396079,
         0.19047619047619047,
         0.11664236870396079,
         -0.16666666666666655,
         -0.1666666666666666,
         0.004761904761904759,
         0.01904761904761903,
         0.02857142857142854,
         0.01904761904761901,
         0.00476190476190476,
         -0.02380952380952379,
         -0.05832118435198044,
         -0.0583211843519804,
         -0.02380952380952379,
         0.07142857142857141,
         0.11664236870396083,
         0.07142857142857129,
         -0.16666666666666663,
         -0.16666666666666657,
         0.3333333333333336},
        {-0.015063002556152637,
         0.015063002556152755,
         0.015107036472701674,
         -5.3930313460570645e-05,
         -0.015018968639603614,
         -0.010905528837980655,
         -0.0051457749277371845,
         0.0051997052411978315,
         0.010773427088333728,
         0.20599923531400668,
         -0.195093706476026,
         0.19929521411074708,
         -0.20354075566201707,
         0.1927673285736834,
         0.015063002556152732,
         -0.015063002556152696,
         -5.393031346063716e-05,
         6.605087482340898e-05,
         -5.393031346064767e-05,
         -0.005145774927737198,
         -0.008738724145796618,
         0.008716707187522136,
         0.005199705241197822,
         -0.19509370647602606,
         0.21230149676608823,
         -0.19936126498557055,
         0.18639901624677832,
         -0.20354075566201713,
         -0.010905528837980604,
         -0.005145774927737194,
         0.005199705241197841,
         0.010773427088333752,
         -0.015018968639603683,
         -5.393031346061575e-05,
         0.015107036472701722,
         0.005199705241197838,
         0.00871670718752214,
         -0.008738724145796638,
         -0.005145774927737191,
         0.19929521411074705,
         -0.19936126498557039,
         0.19938328194384491,
         -0.19936126498557039,
         0.19929521411074705,
         -0.0051457749277371845,
         -0.008738724145796621,
         0.008716707187522169,
         0.005199705241197838,
         0.015107036472701672,
         -5.393031346060534e-05,
         -0.015018968639603725,
         0.010773427088333724,
         0.005199705241197783,
         -0.005145774927737195,
         -0.01090552883798061,
         -0.20354075566201713,
         0.1863990162467783,
         -0.19936126498557047,
         0.21230149676608825,
         -0.19509370647602606,
         0.005199705241197852,
         0.008716707187522217,
         -0.00873872414579661,
         -0.005145774927737171,
         -5.39303134605984e-05,
         6.605087482345479e-05,
         -5.39303134605984e-05,
         -0.015063002556152713,
         0.015063002556152727,
         0.1927673285736834,
         -0.20354075566201704,
         0.19929521411074713,
         -0.19509370647602592,
         0.20599923531400677,
         0.01077342708833371,
         0.0051997052411978245,
         -0.005145774927737198,
         -0.010905528837980627,
         -0.015018968639603801,
         -5.3930313460515134e-05,
         0.015107036472701757,
         0.0150630025561527,
         -0.015063002556152758},
        {0.01598721822740792,
         -0.011304670420909255,
         -0.07397379375053997,
         0.04100270077019262,
         -0.017146165816560144,
         -0.16856671606676554,
         0.11919466801315709,
         0.2762090552116243,
         -0.08741929837302118,
         -0.011818763704720401,
         -0.1430019247741672,
         0.1093608348838597,
         -0.04641659760282852,
         -0.06019278654156396,
         0.16175739555521135,
         -0.1622077495305785,
         -0.15274656842321493,
         0.045269151977752664,
         0.07433809718219023,
         0.17075047215993477,
         -0.18785849560513418,
         0.11309253445242974,
         0.15257949783935768,
         -0.1078899975922479,
         -0.2182224796884922,
         0.03511192718191929,
         0.04854519305311675,
         0.20661396638617838,
         -0.1632334300488164,
         0.07611462795211187,
         -0.047449552603295024,
         0.044856570830966974,
         -0.03242470775479431,
         -0.00745080036013491,
         0.00860344318720413,
         -0.007450800360134916,
         -0.03242470775479432,
         0.044856570830966974,
         -0.04744955260329499,
         0.0761146279521119,
         -0.1632334300488164,
         0.20661396638617838,
         0.048545193053116734,
         0.03511192718191929,
         -0.21822247968849223,
         -0.10788999759224792,
         0.15257949783935768,
         0.1130925344524297,
         -0.18785849560513418,
         0.17075047215993477,
         0.07433809718219024,
         0.04526915197775264,
         -0.1527465684232149,
         -0.16220774953057845,
         0.16175739555521138,
         -0.06019278654156394,
         -0.046416597602828596,
         0.10936083488385967,
         -0.14300192477416715,
         -0.011818763704720379,
         -0.0874192983730212,
         0.27620905521162437,
         0.1191946680131572,
         -0.16856671606676552,
         -0.017146165816560498,
         0.04100270077019262,
         -0.07397379375054014,
         -0.011304670420909296,
         0.01598721822740788},
        {-0.034868771046692365,
         0.024655944458757316,
         -0.17013972457879362,
         0.14496289745763372,
         -0.09792948404006097,
         0.010881266215561278,
         -0.007694217128919399,
         0.10432963137975526,
         -0.056810462497479904,
         0.023006677975904305,
         0.04653476317155869,
         -0.07776169009774067,
         0.08815243496015383,
         -0.2501060601395268,
         0.1691574740115904,
         -0.0932208548254438,
         0.103079501313192,
         -0.12437655517142547,
         0.11234701151411043,
         -0.08637983587487877,
         0.16657599181458863,
         -0.25956153162107204,
         0.02398750483113108,
         -0.01696172732983783,
         0.10067886424573064,
         -0.06349649050139651,
         0.032217457552992726,
         0.04911624536856045,
         -0.07539192947121727,
         0.08146640695623726,
         0.13489516254421005,
         -0.12004122864302985,
         0.0835409518412947,
         -0.24034818164190638,
         0.2775301747403835,
         -0.24034818164190636,
         0.08354095184129473,
         -0.12004122864302988,
         0.13489516254421008,
         0.08146640695623725,
         -0.07539192947121727,
         0.04911624536856045,
         0.032217457552992726,
         -0.06349649050139651,
         0.10067886424573068,
         -0.01696172732983785,
         0.023987504831131073,
         -0.259561531621072,
         0.16657599181458857,
         -0.08637983587487875,
         0.11234701151411043,
         -0.12437655517142544,
         0.10307950131319205,
         -0.09322085482544382,
         0.16915747401159037,
         -0.2501060601395267,
         0.08815243496015379,
         -0.07776169009774067,
         0.046534763171558635,
         0.02300667797590428,
         -0.05681046249747992,
         0.1043296313797553,
         -0.0076942171289194556,
         0.010881266215561264,
         -0.09792948404006102,
         0.1449628974576338,
         -0.17013972457879373,
         0.02465594445875731,
         -0.03486877104669239},
        {0.3779644730092276,
         -0.12598815766974214,
         -0.1781741612749496,
         0.02519763153394848,
         0.07126966450997985,
         0.06172133998483676,
         -0.12598815766974236,
         -0.17817416127494953,
         0.05039526306789694,
         0.14253932901995964,
         0.12344267996967348,
         -0.05345224838248482,
         -0.09258200997725502,
         -0.05345224838248483,
         0.02519763153394848,
         0.07126966450997985,
         0.061721339984836726,
         -0.053452248382484864,
         -0.09258200997725508,
         -0.053452248382484864,
         0.061721339984836726,
         0.07126966450997985,
         0.025197631533948484,
         -0.12598815766974236,
         -0.17817416127494953,
         0.050395263067896955,
         0.14253932901995964,
         0.12344267996967348,
         -0.05345224838248482,
         -0.092582009977255,
         -0.05345224838248482,
         0.050395263067896955,
         0.14253932901995967,
         0.12344267996967347,
         -0.10690449676496969,
         -0.18516401995451015,
         -0.10690449676496969,
         0.12344267996967347,
         0.1425393290199597,
         0.05039526306789696,
         -0.05345224838248483,
         -0.09258200997725503,
         -0.05345224838248482,
         0.12344267996967345,
         0.1425393290199596,
         0.05039526306789694,
         -0.1781741612749496,
         -0.1259881576697424,
         0.02519763153394849,
         0.07126966450997985,
         0.061721339984836726,
         -0.05345224838248486,
         -0.0925820099772551,
         -0.05345224838248486,
         0.061721339984836705,
         0.07126966450997983,
         0.025197631533948488,
         -0.05345224838248483,
         -0.09258200997725503,
         -0.053452248382484836,
         0.12344267996967345,
         0.14253932901995964,
         0.050395263067896975,
         -0.17817416127494953,
         -0.12598815766974236,
         0.06172133998483676,
         0.07126966450997987,
         0.025197631533948474,
         -0.1781741612749496,
         -0.12598815766974242,
         0.3779644730092274},
        {-0.2907637121150761,
         0.20560099255954334,
         0.19899852725577993,
         0.0648877844908449,
         -0.15616676824281425,
         0.15841851255794842,
         -0.11201880449521158,
         0.0719569213894949,
         0.04270096099651246,
         -0.0786831127962883,
         -0.19159443513651755,
         0.04850070753240276,
         0.10758874548735747,
         -0.09417079938171015,
         -0.04542999366264632,
         0.09090310600002242,
         0.015707583764745958,
         -0.0074931699704750415,
         -0.0027290326661338336,
         0.10154832098640809,
         -0.08230466330743982,
         -0.015948828461194872,
         0.13234519955712754,
         -0.0935821880643317,
         0.019808263469800497,
         0.09801224707218575,
         -0.12126148416061704,
         -0.15471976549172403,
         -0.004722878818311657,
         0.16290003156303076,
         -0.13620463456573317,
         -0.10928977182907765,
         0.18180226758509746,
         0.03142343623962063,
         -0.03628465874361604,
         0.031423436239620614,
         0.18180226758509743,
         -0.10928977182907769,
         -0.13620463456573315,
         0.16290003156303073,
         -0.004722878818311642,
         -0.15471976549172403,
         -0.121261484160617,
         0.09801224707218573,
         0.0198082634698005,
         -0.09358218806433163,
         0.1323451995571275,
         -0.01594882846119488,
         -0.08230466330743982,
         0.10154832098640809,
         -0.0027290326661338253,
         -0.007493169970475039,
         0.015707583764745955,
         0.0909031060000224,
         -0.0454299936626464,
         -0.09417079938171014,
         0.10758874548735747,
         0.04850070753240276,
         -0.19159443513651758,
         -0.07868311279628833,
         0.04270096099651246,
         0.07195692138949487,
         -0.11201880449521147,
         0.15841851255794834,
         -0.15616676824281436,
         0.06488778449084488,
         0.19899852725578052,
         0.2056009925595434,
         -0.2907637121150761},
        {-0.04914052880552175,
         0.03474760114947732,
         -0.06622144593513363,
         0.08157323463018869,
         -0.06715786584975222,
         -0.1466324059977067,
         0.10368476862267784,
         -0.0010327996851838828,
         0.13916266943315525,
         -0.16026957061089045,
         0.04755593314171208,
         -0.15489836443171845,
         0.22073590406334398,
         0.2590375025075245,
         -0.07948240598202055,
         -0.013973240585608152,
         -0.18243687494369706,
         0.07087356269003708,
         0.05968026345113497,
         0.07787354805792625,
         0.0035514279701697195,
         -0.2007954124044335,
         0.19577293480322838,
         -0.13843236977215462,
         0.11639477442583918,
         -0.18598830291386667,
         0.16724282582860944,
         -0.035477900810478046,
         0.08076724336424713,
         -0.10441506828367818,
         -0.11137229682463408,
         0.04400450517154245,
         -0.005344476029001849,
         -0.0028211283091688984,
         0.003257558377434274,
         -0.0028211283091688836,
         -0.005344476029001859,
         0.044004505171542446,
         -0.11137229682463406,
         -0.10441506828367816,
         0.08076724336424711,
         -0.03547790081047806,
         0.16724282582860941,
         -0.1859883029138667,
         0.11639477442583919,
         -0.13843236977215465,
         0.1957729348032285,
         -0.20079541240443352,
         0.003551427970169696,
         0.07787354805792625,
         0.059680263451134974,
         0.07087356269003708,
         -0.18243687494369712,
         -0.013973240585608148,
         -0.07948240598202057,
         0.2590375025075245,
         0.22073590406334404,
         -0.15489836443171842,
         0.04755593314171206,
         -0.16026957061089053,
         0.13916266943315542,
         -0.0010327996851838433,
         0.10368476862267736,
         -0.14663240599770666,
         -0.06715786584975239,
         0.08157323463018862,
         -0.0662214459351336,
         0.03474760114947723,
         -0.04914052880552184},
        {0.021427521875064883,
         -0.015151546021881554,
         0.2526200317253514,
         -0.19378088351843814,
         0.12062719443754599,
         -0.11729561611224995,
         0.08294052555642561,
         -0.09933399642843696,
         0.13802872201145233,
         -0.1188289053915714,
         -0.10838959501964869,
         0.0947672873159104,
         -0.055752161506985705,
         -0.008800124461690779,
         0.0891631532385731,
         -0.09936410528081754,
         0.07646237015905519,
         -0.17531486032750548,
         0.22719187525002557,
         0.018433191867741387,
         0.03586175467395096,
         -0.1465842740675831,
         0.09586809423718494,
         -0.06778897953454446,
         -0.17471355717197937,
         0.04060061548510424,
         0.02444495847714207,
         -0.05508819645502653,
         0.12024385403606494,
         -0.15318026803333398,
         0.22542973700237767,
         -0.14425134969359965,
         0.07453580640219436,
         0.034377987802957144,
         -0.03969628102446999,
         0.034377987802957144,
         0.07453580640219437,
         -0.14425134969359962,
         0.22542973700237764,
         -0.15318026803333396,
         0.12024385403606491,
         -0.05508819645502653,
         0.024444958477142065,
         0.04060061548510421,
         -0.17471355717197934,
         -0.06778897953454444,
         0.095868094237185,
         -0.14658427406758306,
         0.035861754673950974,
         0.018433191867741377,
         0.22719187525002565,
         -0.1753148603275055,
         0.07646237015905519,
         -0.09936410528081756,
         0.08916315323857311,
         -0.008800124461690761,
         -0.0557521615069857,
         0.09476728731591039,
         -0.10838959501964865,
         -0.1188289053915714,
         0.13802872201145244,
         -0.09933399642843696,
         0.08294052555642596,
         -0.11729561611224987,
         0.12062719443754619,
         -0.19378088351843828,
         0.2526200317253516,
         -0.01515154602188147,
         0.02142752187506501},
        {-0.04214203029175797,
         0.04214203029175795,
         0.12916551297354728,
         -0.10658156410515618,
         0.044881452390031495,
         -0.16052750828562612,
         0.03841044291507553,
         0.06817112119008056,
         -0.10054293975974167,
         0.12593999252756732,
         0.03458751575805886,
         -0.0659495110701377,
         0.01028802370042727,
         0.09025491605931449,
         0.04577356589493683,
         -0.04577356589493683,
         -0.15470954704193604,
         0.17350507379226107,
         -0.128623052008052,
         0.1354784814561805,
         -0.0677806611714848,
         -0.04418951789401303,
         0.13879132366235225,
         -0.06248713118080191,
         0.010070645509170162,
         0.035533736105602995,
         -0.03070283338164152,
         -0.06818653396293065,
         -0.026565891558024076,
         -0.00650079953306494,
         0.015563593464520171,
         0.004366670781966793,
         0.11224129875999923,
         -0.16983375385803928,
         0.165096059942421,
         -0.03383631273376055,
         0.038595721555128165,
         -0.0001002432636459973,
         -0.060457966484757514,
         -0.020140416256191035,
         -0.03421648619885492,
         0.03475394761693435,
         -0.009140874301820161,
         -0.014953827442714744,
         0.06885194571230008,
         -0.027815181961092183,
         -0.027454177761725138,
         0.06652978401893472,
         -0.040879553622026846,
         0.05984225509171375,
         -0.0568424397327513,
         0.013824264889605123,
         -0.013824264889605137,
         0.003980453585486785,
         0.011099610388028603,
         -0.02210604144839729,
         -0.08115791214892304,
         0.0031888864435711687,
         0.04724639789516346,
         -0.042382799513160506,
         0.11140126505464179,
         0.1015065612983466,
         -0.1268717272986295,
         0.04026671423341446,
         0.0827359966100907,
         -0.2004542877934677,
         0.06082136884032241,
         0.08084493068467159,
         -0.14655585979105448,
         0.027268899121672633,
         -0.07553947463952115,
         0.09608654641481883,
         0.06714549541197855,
         -0.002923436159384641,
         -0.041980405177525826,
         0.04284600335434694,
         -0.06322420360448106,
         -0.05742234045346272,
         0.097637855139444,
         -0.05742234045346273,
         -0.06322420360448107,
         0.04284600335434693,
         -0.041980405177525826,
         -0.0029234361593846337,
         0.06714549541197858,
         0.09608654641481884,
         -0.07553947463952114,
         0.02726889912167264,
         -0.14655585979105445,
         0.08084493068467158,
         0.060821368840322354,
         -0.20045428779346763,
         0.0827359966100907,
         0.04026671423341445,
         -0.1268717272986295,
         0.10150656129834663,
         0.11140126505464182,
         -0.042382799513160485,
         0.04724639789516346,
         0.003188886443571173,
         -0.08115791214892303,
         -0.022106041448397284,
         0.011099610388028659,
         0.0039804535854867625,
         -0.01382426488960514,
         0.013824264889605156,
         -0.05684243973275132,
         0.05984225509171374,
         -0.040879553622026846,
         0.06652978401893472,
         -0.02745417776172512,
         -0.027815181961092197,
         0.06885194571230006,
         -0.014953827442714741,
         -0.009140874301820165,
         0.03475394761693434,
         -0.03421648619885492,
         -0.020140416256191025,
         -0.06045796648475748,
         -0.00010024326364600728,
         0.03859572155512815,
         -0.03383631273376055,
         0.16509605994242105,
         -0.16983375385803925,
         0.11224129875999933,
         0.004366670781966782,
         0.015563593464520189,
         -0.006500799533064928,
         -0.02656589155802407,
         -0.06818653396293066,
         -0.030702833381641564,
         0.03553373610560301,
         0.01007064550917016,
         -0.062487131180801896,
         0.13879132366235222,
         -0.044189517894013014,
         -0.06778066117148483,
         0.1354784814561805,
         -0.128623052008052,
         0.17350507379226107,
         -0.15470954704193604,
         -0.045773565894936814,
         0.04577356589493682,
         0.09025491605931456,
         0.010288023700427265,
         -0.06594951107013769,
         0.034587515758058886,
         0.12593999252756727,
         -0.1005429397597417,
         0.06817112119008058,
         0.03841044291507558,
         -0.160527508285626,
         0.04488145239003123,
         -0.10658156410515612,
         0.1291655129735473,
         0.042142030291757976,
         -0.04214203029175802},
        {0.024459819617658543,
         -0.02445981961765851,
         0.02657252910117521,
         -0.06250160736845853,
         0.07549216833649212,
         -0.041179648594314784,
         0.017889994685026958,
         0.04461161268343167,
         -0.11191739756218577,
         0.005540826982310565,
         0.03563882161200449,
         -0.050245941105143854,
         0.013820711879449957,
         0.09809668568273622,
         0.0972646971917937,
         -0.09726469719179369,
         -0.09334309406719955,
         -0.00023892577141438053,
         0.09373325821811028,
         0.026321871580189685,
         0.06329428299464215,
         -0.02697003738426395,
         -0.115297738617148,
         -0.0024617318192616446,
         -0.0006574366360845908,
         -0.07296563960575879,
         0.0741791503982601,
         0.1461687144051123,
         -0.0014562245133115043,
         -0.01885028614957,
         0.1074359890356176,
         -0.21553354606330033,
         -0.06965212130612006,
         0.016529551396841966,
         0.042659476906538873,
         0.04481824391885862,
         0.08076474171357127,
         -0.0941231200549194,
         -0.012097033191509413,
         0.036512039690402176,
         -0.11001532796267507,
         -0.00729238507601719,
         0.11698666347479565,
         -0.020643071282781412,
         -0.042977226092003516,
         0.14548565734337243,
         -0.09606654059937723,
         -0.07807439346981725,
         0.03593150977663976,
         -0.13724327889232818,
         0.18818582616515284,
         -0.13185610582828583,
         0.1318561058282858,
         0.004952473256607283,
         0.1084948852883059,
         -0.18212387902870253,
         -0.0010215984658421145,
         -0.02360393426078993,
         -0.048805631188552114,
         0.17838808631339267,
         0.0528626366899534,
         -0.02249303044037276,
         0.03576817145396146,
         -0.012719066857171996,
         -0.1266232762235433,
         -0.05678059302252658,
         0.04415055926391756,
         -0.044345641339372924,
         0.05725844456535532,
         0.03319179357083282,
         -0.01619165933050732,
         -0.0067509246050213145,
         0.07126591861402025,
         -0.05797275452990588,
         0.008691581644353071,
         0.04944780888146589,
         -0.06947294288057919,
         -0.03569962013197935,
         0.07075714113616548,
         -0.03569962013197936,
         -0.0694729428805792,
         0.04944780888146593,
         0.008691581644353063,
         -0.05797275452990585,
         0.07126591861402028,
         -0.006750924605021335,
         -0.016191659330507327,
         0.0331917935708328,
         0.05725844456535535,
         -0.04434564133937292,
         0.04415055926391757,
         -0.056780593022526575,
         -0.12662327622354333,
         -0.01271906685717199,
         0.03576817145396148,
         -0.022493030440372756,
         0.05286263668995339,
         0.17838808631339267,
         -0.04880563118855211,
         -0.02360393426078994,
         -0.0010215984658421085,
         -0.18212387902870258,
         0.10849488528830588,
         0.004952473256607296,
         0.1318561058282858,
         -0.1318561058282858,
         0.18818582616515292,
         -0.1372432788923281,
         0.03593150977663973,
         -0.07807439346981723,
         -0.09606654059937725,
         0.14548565734337243,
         -0.042977226092003475,
         -0.020643071282781377,
         0.11698666347479565,
         -0.007292385076017202,
         -0.11001532796267506,
         0.036512039690402176,
         -0.012097033191509402,
         -0.0941231200549194,
         0.0807647417135713,
         0.044818243918858636,
         0.042659476906538936,
         0.01652955139684197,
         -0.06965212130612006,
         -0.21553354606330027,
         0.10743598903561762,
         -0.018850286149570045,
         -0.0014562245133114874,
         0.14616871440511237,
         0.07417915039826013,
         -0.07296563960575878,
         -0.0006574366360845861,
         -0.0024617318192616034,
         -0.11529773861714805,
         -0.026970037384263977,
         0.06329428299464218,
         0.026321871580189615,
         0.09373325821811025,
         -0.00023892577141437272,
         -0.09334309406719961,
         -0.0972646971917937,
         0.09726469719179377,
         0.09809668568273616,
         0.013820711879449912,
         -0.05024594110514397,
         0.035638821612004296,
         0.005540826982310517,
         -0.11191739756218605,
         0.044611612683431744,
         0.01788999468502684,
         -0.04117964859431474,
         0.07549216833649211,
         -0.06250160736845863,
         0.026572529101175177,
         -0.024459819617658505,
         0.02445981961765842},
        {0.018686448916786048,
         -0.018686448916786107,
         -0.018980528979053928,
         0.00036017304804114505,
         0.018392368854518205,
         0.10800486776653821,
         -0.10903210235899874,
         0.1086719293109576,
         -0.10712262757973459,
         -0.19884436283382326,
         0.09083949506728493,
         -0.0018151562798006287,
         -0.0869151024454158,
         0.19403773002515054,
         -0.08926252398887763,
         0.08926252398887768,
         0.049846697618430635,
         0.014999721979540935,
         -0.07434114104075466,
         -0.07598385471309597,
         0.045432609856043554,
         -0.0606402778418259,
         0.11323488145592178,
         0.016079827490942722,
         0.0006100344786097482,
         0.01690706931262538,
         -0.019008559111836836,
         -0.043928144833786556,
         0.12452436986957185,
         -0.15461802023686452,
         0.14186143691636188,
         -0.09327724987304184,
         0.06829759422377306,
         -0.020528992235587684,
         -0.034773890283274704,
         -0.042481476589875174,
         -0.051515561546929774,
         0.05961731999452145,
         0.022636302373992386,
         0.08028993812127183,
         0.02546773138964326,
         -0.00018269937308752854,
         -0.02442393988572204,
         -0.0833689078984316,
         -0.10970484499753115,
         0.06375369589160679,
         -0.07333229753737121,
         0.1331675314790371,
         0.017679452386824467,
         0.022778868461801077,
         -0.05487718881975046,
         0.06283589449816668,
         -0.06283589449816675,
         -0.049337336009090425,
         -0.015623559998265027,
         0.07485050265009564,
         -0.07821082317705141,
         0.169635214570262,
         -0.15421960057823844,
         0.040450434824884605,
         0.11238661843233548,
         -0.09296928825780272,
         -0.013716212665180558,
         0.10519404560238155,
         -0.0789883718195674,
         0.028217578928179155,
         0.00042334234671704673,
         0.011823879364444572,
         -0.058217022887260966,
         0.01581575672530228,
         -0.0006838180197048799,
         -0.014699086575170587,
         0.08775236064324364,
         -0.12365018342366116,
         0.12456869154676806,
         -0.09000223686945708,
         -0.0006836184558801617,
         0.002241467164561059,
         -0.0027607500674546623,
         0.0022414671645610592,
         -0.0006836184558801694,
         -0.09000223686945709,
         0.12456869154676804,
         -0.12365018342366114,
         0.08775236064324363,
         -0.014699086575170613,
         -0.0006838180197048921,
         0.015815756725302266,
         -0.05821702288726099,
         0.011823879364444569,
         0.00042334234671702504,
         0.028217578928179155,
         -0.0789883718195674,
         0.10519404560238156,
         -0.013716212665180534,
         -0.09296928825780273,
         0.11238661843233547,
         0.04045043482488462,
         -0.15421960057823847,
         0.16963521457026212,
         -0.07821082317705143,
         0.07485050265009564,
         -0.01562355999826499,
         -0.04933733600909047,
         -0.06283589449816677,
         0.06283589449816672,
         -0.05487718881975043,
         0.022778868461801098,
         0.017679452386824456,
         0.13316753147903712,
         -0.0733322975373712,
         0.06375369589160679,
         -0.10970484499753116,
         -0.08336890789843159,
         -0.024423939885722015,
         -0.0001826993730875338,
         0.025467731389643276,
         0.08028993812127186,
         0.022636302373992404,
         0.0596173199945214,
         -0.05151556154692978,
         -0.042481476589875146,
         -0.03477389028327468,
         -0.020528992235587646,
         0.06829759422377313,
         -0.09327724987304183,
         0.14186143691636188,
         -0.1546180202368645,
         0.12452436986957185,
         -0.04392814483378657,
         -0.019008559111836874,
         0.016907069312625398,
         0.0006100344786097487,
         0.016079827490942725,
         0.11323488145592182,
         -0.0606402778418259,
         0.045432609856043575,
         -0.07598385471309599,
         -0.07434114104075466,
         0.014999721979540921,
         0.04984669761843141,
         0.08926252398887759,
         -0.08926252398887757,
         0.1940377300251505,
         -0.0869151024454158,
         -0.0018151562798006588,
         0.09083949506728489,
         -0.19884436283382317,
         -0.10712262757973466,
         0.10867192931095766,
         -0.10903210235899874,
         0.10800486776653823,
         0.018392368854518233,
         0.00036017304804107945,
         -0.018980528979053952,
         -0.018686448916786075,
         0.01868644891678608},
        {0.02083130775536808,
         -0.020831307755368022,
         0.05375700937548004,
         -0.09135165887173524,
         0.09541962488621573,
         -0.09345286822635475,
         0.048617299543093594,
         0.042734359328641655,
         -0.13031208316618856,
         0.05824884485517784,
         0.03520402337117734,
         -0.07489988222205174,
         0.040007423942079456,
         0.09030465922410952,
         -0.09560561003247976,
         0.09560561003247979,
         0.04772836731065048,
         0.022420577974062075,
         -0.08434101782714079,
         -0.10257588689168474,
         0.029162272449710928,
         0.0011590544167421697,
         0.028304107744731827,
         0.16609900975321462,
         0.025611438490008284,
         -0.08284292191819684,
         0.05701117363941712,
         0.00046807323826476485,
         -0.20728716294659405,
         0.12801255548646304,
         -0.017128125823019827,
         -0.06432311014837283,
         0.012861845286499602,
         0.0518508961221706,
         -0.09753400409008155,
         0.06907629674199221,
         -0.13121173763630148,
         0.07593113150579882,
         0.06633298094951091,
         -0.08879624276330675,
         0.0767275078011626,
         0.037647383986117,
         -0.11424769587142736,
         0.012992691127663394,
         -0.008696993221666244,
         -0.08441321347786035,
         0.09459521276166946,
         -0.0162437095850497,
         0.12677836455661204,
         -0.10849908437604863,
         0.050399898297053124,
         0.06614569208287066,
         -0.0661456920828706,
         -0.17691912223233885,
         0.1358051365474834,
         -0.04484973709454763,
         0.1713311312714828,
         -0.031168082595019655,
         -0.051895149111948584,
         0.03213140279715845,
         -0.11631300245159681,
         -0.027442765038682617,
         0.030541636655224552,
         -0.0033191814053134413,
         0.05611096829623341,
         0.07512484925821744,
         -0.05925731110666501,
         0.07756363636491014,
         -0.11996600520634157,
         0.08523382441772558,
         -0.08355838156933262,
         0.051216441300703346,
         0.025922393841487958,
         -0.02563048445754562,
         0.0025039584450248322,
         0.03072579441239006,
         -0.053831470801470466,
         -0.026534147653178308,
         0.05332268713806121,
         -0.0265341476531783,
         -0.05383147080147047,
         0.03072579441239008,
         0.002503958445024847,
         -0.02563048445754563,
         0.025922393841487954,
         0.05121644130070327,
         -0.08355838156933272,
         0.08523382441772556,
         -0.11996600520634156,
         0.07756363636491015,
         -0.05925731110666502,
         0.07512484925821747,
         0.05611096829623339,
         -0.003319181405313441,
         0.030541636655224556,
         -0.027442765038682634,
         -0.11631300245159679,
         0.0321314027971584,
         -0.05189514911194858,
         -0.031168082595019617,
         0.17133113127148286,
         -0.0448497370945476,
         0.13580513654748344,
         -0.17691912223233888,
         -0.06614569208287066,
         0.06614569208287074,
         0.050399898297053096,
         -0.10849908437604862,
         0.12677836455661198,
         -0.016243709585049657,
         0.09459521276166945,
         -0.08441321347786036,
         -0.008696993221666192,
         0.012992691127663419,
         -0.11424769587142738,
         0.03764738398611697,
         0.07672750780116261,
         -0.08879624276330671,
         0.0663329809495109,
         0.0759311315057988,
         -0.13121173763630156,
         0.06907629674199223,
         -0.09753400409008155,
         0.05185089612217058,
         0.012861845286499644,
         -0.06432311014837294,
         -0.01712812582301978,
         0.12801255548646298,
         -0.20728716294659397,
         0.00046807323826475157,
         0.057011173639417115,
         -0.08284292191819678,
         0.02561143849000816,
         0.1660990097532147,
         0.02830410774473185,
         0.0011590544167421892,
         0.029162272449710883,
         -0.10257588689168481,
         -0.0843410178271407,
         0.022420577974062043,
         0.04772836731065041,
         0.09560561003247978,
         -0.09560561003247964,
         0.0903046592241095,
         0.04000742394207908,
         -0.07489988222205192,
         0.035204023371177,
         0.058248844855177846,
         -0.13031208316618856,
         0.042734359328641745,
         0.04861729954309348,
         -0.09345286822635476,
         0.0954196248862157,
         -0.09135165887173526,
         0.053757009375479885,
         -0.02083130775536784,
         0.02083130775536798},
        {-0.0016265464592301428,
         0.0016265464592300936,
         -0.016991066485064737,
         0.022801825971078663,
         -0.020244159403524815,
         0.08437492246836492,
         -0.08252803203013641,
         0.05972620605905772,
         -0.028522083635480557,
         -0.13332173672402703,
         0.048946814255662004,
         0.018437041727638194,
         -0.06720328476664363,
         0.09572536840212419,
         0.09337879710793806,
         -0.09337879710793842,
         -0.07112892072859592,
         -0.005113874206735067,
         0.07947984233878326,
         -0.03489104255342236,
         0.1418619046259572,
         -0.14991267078163936,
         0.054611311673311895,
         0.0986279583528922,
         -0.11555741276755235,
         0.021343089649884496,
         0.09408663998588286,
         -0.14080340512552125,
         -0.004355254235765188,
         0.06964882623165276,
         -0.09772001696172956,
         0.07311534799679875,
         -0.03320679664195802,
         -0.02535892677148448,
         0.07461775065178529,
         0.12089229589541274,
         -0.06455968056103259,
         0.08821765421580663,
         -0.17884225969781628,
         -0.12512977787206628,
         0.0017392512755984245,
         -0.01908357953811522,
         0.017418046153023847,
         0.16300206538626844,
         0.08351155554126735,
         -0.0032090474747960103,
         0.009970188458212096,
         -0.10007290102965608,
         -0.06567239236199242,
         0.016029691542530505,
         0.03949601568638795,
         -0.09107851304546531,
         0.09107851304546531,
         0.10337557226376647,
         -0.034380046880516775,
         -0.047233190803612705,
         -0.08182121961955761,
         -0.014384084525979784,
         0.0355994910440793,
         0.029854298964497535,
         -0.029406709797578198,
         0.06995474905816622,
         -0.007923083023897222,
         -0.06215934916605401,
         0.045763608372512615,
         0.12367941391470516,
         -0.18636108840463275,
         0.18218562759953905,
         -0.11345166550123507,
         -0.027938539927315858,
         0.03259103703091919,
         -0.025282400681952935,
         0.06273966712562976,
         -0.07170337158869342,
         0.06789472725513769,
         -0.053410431896675825,
         0.0036445285424564393,
         0.0020434179427493604,
         -0.003939400104484629,
         0.0020434179427493626,
         0.0036445285424564337,
         -0.05341043189667583,
         0.06789472725513766,
         -0.07170337158869343,
         0.06273966712562977,
         -0.025282400681952952,
         0.03259103703091918,
         -0.02793853992731586,
         -0.11345166550123496,
         0.182185627599539,
         -0.18636108840463267,
         0.12367941391470517,
         0.04576360837251264,
         -0.06215934916605404,
         -0.007923083023897213,
         0.06995474905816622,
         -0.029406709797578208,
         0.02985429896449753,
         0.035599491044079314,
         -0.0143840845259798,
         -0.08182121961955759,
         -0.047233190803612726,
         -0.03438004688051676,
         0.10337557226376648,
         0.09107851304546533,
         -0.0910785130454653,
         0.03949601568638795,
         0.016029691542530505,
         -0.06567239236199243,
         -0.10007290102965608,
         0.009970188458212103,
         -0.003209047474796007,
         0.08351155554126738,
         0.16300206538626852,
         0.01741804615302386,
         -0.019083579538115222,
         0.0017392512755984536,
         -0.12512977787206625,
         -0.1788422596978163,
         0.08821765421580662,
         -0.06455968056103259,
         0.12089229589541267,
         0.0746177506517853,
         -0.025358926771484464,
         -0.033206796641958025,
         0.07311534799679878,
         -0.09772001696172955,
         0.06964882623165268,
         -0.0043552542357652,
         -0.14080340512552109,
         0.09408663998588288,
         0.021343089649884503,
         -0.11555741276755235,
         0.09862795835289226,
         0.05461131167331191,
         -0.14991267078163942,
         0.14186190462595719,
         -0.03489104255342235,
         0.07947984233878329,
         -0.005113874206735066,
         -0.07112892072859599,
         -0.09337879710793835,
         0.09337879710793834,
         0.09572536840212414,
         -0.06720328476664354,
         0.01843704172763815,
         0.048946814255662045,
         -0.13332173672402706,
         -0.02852208363548055,
         0.05972620605905767,
         -0.08252803203013635,
         0.08437492246836494,
         -0.020244159403524923,
         0.02280182597107871,
         -0.016991066485064734,
         0.001626546459230102,
         -0.001626546459230072},
        {0.33333333333333365,
         -0.16666666666666663,
         -0.16666666666666669,
         0.0714285714285714,
         0.11664236870396086,
         0.07142857142857142,
         -0.023809523809523794,
         -0.05832118435198043,
         -0.058321184351980436,
         -0.023809523809523787,
         0.004761904761904752,
         0.019047619047619035,
         0.028571428571428557,
         0.019047619047619032,
         0.004761904761904754,
         -0.11785113019775793,
         -0.1178511301977579,
         0.0824786098842322,
         0.13468700594029476,
         0.0824786098842322,
         -0.041239304942116056,
         -0.10101525445522098,
         -0.10101525445522098,
         -0.04123930494211606,
         0.013468700594029463,
         0.05387480237611785,
         0.08081220356417682,
         0.05387480237611785,
         0.013468700594029465,
         -0.016835875742536848,
         -0.041239304942116126,
         -0.04123930494211613,
         -0.01683587574253683,
         0.029160592175990208,
         0.04761904761904765,
         0.02916059217599022,
         -0.023809523809523774,
         -0.05832118435198041,
         -0.05832118435198042,
         -0.02380952380952378,
         0.011664236870396078,
         0.04665694748158432,
         0.06998542122237653,
         0.04665694748158432,
         0.011664236870396073,
         -0.023809523809523774,
         -0.05832118435198042,
         -0.05832118435198041,
         -0.023809523809523787,
         0.02916059217599022,
         0.04761904761904765,
         0.0291605921759902,
         -0.11785113019775793,
         -0.1178511301977579,
         0.0824786098842322,
         0.13468700594029473,
         0.0824786098842322,
         -0.04123930494211606,
         -0.10101525445522098,
         -0.10101525445522097,
         -0.04123930494211606,
         0.013468700594029452,
         0.05387480237611785,
         0.08081220356417682,
         0.05387480237611785,
         0.013468700594029461,
         -0.016835875742536848,
         -0.04123930494211611,
         -0.041239304942116126,
         -0.016835875742536827,
         0.05832118435198042,
         0.09523809523809526,
         0.05832118435198044,
         -0.04761904761904757,
         -0.11664236870396079,
         -0.11664236870396077,
         -0.047619047619047554,
         0.02332847374079216,
         0.09331389496316864,
         0.139970842444753,
         0.09331389496316864,
         0.02332847374079216,
         -0.047619047619047554,
         -0.11664236870396077,
         -0.11664236870396079,
         -0.04761904761904756,
         0.05832118435198044,
         0.09523809523809526,
         0.05832118435198042,
         -0.016835875742536827,
         -0.04123930494211611,
         -0.04123930494211612,
         -0.01683587574253684,
         0.013468700594029465,
         0.05387480237611785,
         0.08081220356417682,
         0.05387480237611784,
         0.013468700594029452,
         -0.04123930494211606,
         -0.10101525445522098,
         -0.10101525445522098,
         -0.04123930494211607,
         0.08247860988423217,
         0.13468700594029479,
         0.08247860988423214,
         -0.1178511301977579,
         -0.11785113019775792,
         0.029160592175990208,
         0.04761904761904764,
         0.02916059217599022,
         -0.02380952380952378,
         -0.05832118435198041,
         -0.058321184351980436,
         -0.023809523809523774,
         0.011664236870396076,
         0.04665694748158433,
         0.06998542122237653,
         0.04665694748158432,
         0.011664236870396076,
         -0.023809523809523774,
         -0.058321184351980436,
         -0.058321184351980394,
         -0.023809523809523774,
         0.02916059217599022,
         0.047619047619047665,
         0.029160592175990208,
         -0.01683587574253683,
         -0.041239304942116105,
         -0.04123930494211612,
         -0.01683587574253684,
         0.013468700594029465,
         0.05387480237611786,
         0.08081220356417687,
         0.053874802376117824,
         0.013468700594029452,
         -0.04123930494211604,
         -0.10101525445522101,
         -0.101015254455221,
         -0.041239304942116035,
         0.08247860988423217,
         0.13468700594029479,
         0.08247860988423214,
         -0.1178511301977579,
         -0.11785113019775792,
         0.004761904761904759,
         0.019047619047619032,
         0.028571428571428567,
         0.01904761904761905,
         0.004761904761904755,
         -0.02380952380952379,
         -0.05832118435198044,
         -0.05832118435198046,
         -0.02380952380952378,
         0.07142857142857144,
         0.11664236870396101,
         0.07142857142857134,
         -0.16666666666666663,
         -0.1666666666666666,
         0.33333333333333337},
        {-0.10386407888797385,
         0.10386407888797387,
         0.10996998714825706,
         -0.007478179826969486,
         -0.09775817062769063,
         -0.05668509361597938,
         -0.06526040007630404,
         0.07273857990327348,
         0.03836736883512967,
         0.0038375241289657636,
         0.05284756948701397,
         0.0004373240452640037,
         -0.05982812583782515,
         0.021460757002695417,
         0.1008410404424875,
         -0.10084104044248747,
         -0.011412809832985838,
         -0.013420265627989786,
         0.03332801183377693,
         -0.05318427959491211,
         0.0013544303441119154,
         0.016383364420027084,
         0.00973573326056046,
         0.04221382071879375,
         0.06300576704178439,
         -0.026682087834419613,
         -0.03169691527323343,
         -0.007356700786479957,
         -0.04492736005335237,
         -0.04527251596401953,
         0.06680586029758011,
         -0.00781834601952259,
         -0.187799859156462,
         0.15870153083114977,
         -0.07135865546679783,
         0.18611114002674256,
         -0.032068729874836194,
         -0.08976233346387742,
         0.11231279997380418,
         -0.10735704249392053,
         -0.08297465700859064,
         0.11426140615965519,
         -0.03395801255391218,
         -0.11048071621399966,
         0.10163530831214582,
         -0.03638662129188477,
         -0.06246987427402705,
         0.140512663584046,
         -0.057046058317620135,
         0.10242556272679473,
         -0.1102141852144324,
         0.046044948564274095,
         -0.046044948564274046,
         0.0008370664998207724,
         0.026372853036437473,
         -0.043903755166941956,
         -0.03910786327889107,
         -0.03088856156029387,
         0.008833237660005632,
         0.0931321529464078,
         0.03252392878819546,
         0.05545564028176294,
         0.013111030830007631,
         -0.06393990717763923,
         -0.07725304618473626,
         -0.03523746812275413,
         -0.047019626909783695,
         0.036062025909388125,
         0.06207799937873367,
         0.029278204072559287,
         -0.13972240916939707,
         0.19888753465903566,
         -0.07422569911655286,
         0.06910752007286347,
         0.03749716946596454,
         -0.18690139444139156,
         0.10945448973553343,
         0.046713454659223906,
         -0.09876943612414303,
         0.04671345465922389,
         0.10945448973553344,
         -0.1869013944413915,
         0.03749716946596452,
         0.0691075200728635,
         -0.07422569911655286,
         0.19888753465903566,
         -0.1397224091693971,
         0.029278204072559273,
         0.06207799937873368,
         0.03606202590938814,
         -0.047019626909783695,
         -0.035237468122754134,
         -0.07725304618473625,
         -0.06393990717763923,
         0.013111030830007633,
         0.05545564028176294,
         0.032523928788195426,
         0.0931321529464078,
         0.008833237660005658,
         -0.03088856156029388,
         -0.039107863278891083,
         -0.04390375516694198,
         0.02637285303643749,
         0.0008370664998207738,
         -0.046044948564274074,
         0.046044948564274074,
         -0.1102141852144324,
         0.10242556272679475,
         -0.05704605831762011,
         0.14051266358404602,
         -0.06246987427402703,
         -0.03638662129188477,
         0.10163530831214579,
         -0.11048071621399964,
         -0.03395801255391219,
         0.11426140615965517,
         -0.08297465700859061,
         -0.10735704249392053,
         0.1123127999738042,
         -0.08976233346387744,
         -0.03206872987483618,
         0.1861111400267426,
         -0.0713586554667978,
         0.15870153083114977,
         -0.18779985915646194,
         -0.007818346019522604,
         0.06680586029758014,
         -0.04527251596401951,
         -0.04492736005335233,
         -0.007356700786479972,
         -0.03169691527323345,
         -0.026682087834419617,
         0.06300576704178441,
         0.042213820718793725,
         0.00973573326056048,
         0.01638336442002709,
         0.0013544303441119334,
         -0.05318427959491215,
         0.03332801183377689,
         -0.013420265627989775,
         -0.01141280983298583,
         -0.1008410404424875,
         0.1008410404424875,
         0.021460757002695365,
         -0.059828125837824965,
         0.0004373240452640389,
         0.052847569487013635,
         0.003837524128965614,
         0.03836736883512956,
         0.07273857990327347,
         -0.06526040007630397,
         -0.0566850936159793,
         -0.09775817062769054,
         -0.007478179826969437,
         0.10996998714825706,
         0.10386407888797375,
         -0.10386407888797379},
        {-0.14707738570116108,
         0.1470773857011614,
         0.13790661322453446,
         0.011231856557448745,
         -0.15624815817778884,
         -0.06785059835873397,
         -0.08580074491702111,
         0.07456888835957234,
         0.0953629157886167,
         -0.019423375506528215,
         0.08727397386526206,
         -0.017217958999462345,
         -0.04366728338970976,
         -0.051695632398906906,
         0.07757898995582464,
         -0.07757898995582463,
         0.04881995157753049,
         -0.03337155848351045,
         0.005675575226501344,
         -0.10261969491441594,
         -0.03162374164750387,
         0.058510584724071994,
         0.03676064858254136,
         0.09075726173923775,
         0.08290330151798804,
         -0.0017424766959716796,
         -0.09982047579567047,
         -0.01263370445267793,
         -0.07702286120503903,
         -0.05518901171422995,
         0.06655253124207262,
         0.04918803667967206,
         0.0009766738377928335,
         -0.05605280614922579,
         0.09055717530670214,
         -0.06177789777302702,
         0.04016457080740516,
         0.02486943203857439,
         -0.09752222513033189,
         0.07880155722806344,
         0.0694236883920834,
         -0.09133028344651904,
         0.03267974956705926,
         0.060766391614480046,
         -0.16068687829047892,
         0.01391235488392307,
         0.07842394795207187,
         -0.065489948392812,
         0.17566945637461018,
         -0.12292950992915778,
         0.025073592729946415,
         0.1304198436211363,
         -0.1304198436211362,
         -0.03293570770335726,
         0.013917412262683438,
         0.010208668647671913,
         -0.018720882208949734,
         -0.03424855781286156,
         0.013846430143235784,
         0.06869568466665099,
         0.032666775743210835,
         0.03823914693715178,
         0.045546494050222236,
         -0.10244529196102811,
         -0.04912115994903885,
         -0.018932375209012094,
         -0.06615156540913567,
         0.038903802007119744,
         0.08567549217603294,
         -0.20438926367649823,
         0.10324731675413318,
         0.035787101437074864,
         0.15496178666667776,
         0.0033687536373584047,
         -0.07643797819962114,
         0.024020529411705863,
         -0.0908715814016939,
         -0.01311632716297597,
         0.04777896335119924,
         -0.013116327162975968,
         -0.09087158140169391,
         0.024020529411705877,
         -0.07643797819962114,
         0.0033687536373584155,
         0.1549617866666777,
         0.035787101437074864,
         0.10324731675413314,
         -0.20438926367649818,
         0.08567549217603293,
         0.03890380200711974,
         -0.06615156540913564,
         -0.018932375209012083,
         -0.0491211599490389,
         -0.10244529196102811,
         0.045546494050222215,
         0.038239146937151795,
         0.03266677574321084,
         0.06869568466665098,
         0.013846430143235774,
         -0.034248557812861576,
         -0.018720882208949744,
         0.010208668647671908,
         0.01391741226268346,
         -0.032935707703357256,
         -0.1304198436211362,
         0.13041984362113618,
         0.02507359272994642,
         -0.12292950992915773,
         0.1756694563746102,
         -0.06548994839281198,
         0.07842394795207189,
         0.01391235488392308,
         -0.16068687829047892,
         0.06076639161448005,
         0.03267974956705926,
         -0.09133028344651901,
         0.06942368839208342,
         0.07880155722806341,
         -0.09752222513033187,
         0.024869432038574387,
         0.040164570807405174,
         -0.06177789777302702,
         0.09055717530670214,
         -0.05605280614922578,
         0.0009766738377928262,
         0.049188036679672045,
         0.06655253124207262,
         -0.05518901171422996,
         -0.077022861205039,
         -0.012633704452677925,
         -0.09982047579567044,
         -0.001742476695971693,
         0.08290330151798803,
         0.09075726173923773,
         0.03676064858254135,
         0.05851058472407201,
         -0.03162374164750388,
         -0.10261969491441592,
         0.005675575226501286,
         -0.03337155848351045,
         0.04881995157753048,
         -0.07757898995582463,
         0.07757898995582464,
         -0.05169563239890689,
         -0.043667283389709766,
         -0.01721795899946238,
         0.08727397386526208,
         -0.019423375506528232,
         0.09536291578861675,
         0.07456888835957229,
         -0.08580074491702108,
         -0.0678505983587339,
         -0.1562481581777888,
         0.011231856557448868,
         0.13790661322453363,
         0.14707738570116113,
         -0.14707738570116116},
        {0.011609286981032852,
         -0.011609286981032876,
         -0.0007631250941254053,
         -0.01328378114527326,
         0.022455448867940653,
         -0.01121626385438701,
         0.01467169517709499,
         -0.0013879140318219102,
         -0.021322221806336458,
         -0.18465688382588835,
         0.19587314768027528,
         -0.2078525366287873,
         0.20898576369039154,
         -0.1876635418840551,
         -0.0007363347857941863,
         0.0007363347857941767,
         -0.024384432792726753,
         0.02239203824145011,
         -0.012181612535567089,
         0.02758440262517909,
         -0.0033795357119543266,
         -0.011343107909416197,
         0.008478561912020224,
         0.1255962045516876,
         -0.1514489639662618,
         0.14635779251825212,
         -0.13421337206895145,
         0.1389063844796528,
         0.004975930194374515,
         0.006507316732631085,
         -0.006004235941536553,
         -0.006208221431951782,
         0.004639123070100287,
         -0.005161074867601111,
         0.0037888768965163647,
         0.011250604144835967,
         -0.0011758450134203794,
         -0.007538204309676928,
         0.010094370290197573,
         -0.09962460286191907,
         0.06634036498423013,
         -0.06321334411777696,
         0.07730049483240231,
         -0.09565877169794891,
         0.03320479348976814,
         -0.006012865224625818,
         -0.015273501566009477,
         0.018935943625013503,
         -0.029984454991997797,
         0.025634687812147,
         -0.011876814911537543,
         -0.0156816763122639,
         0.015681676312263908,
         0.005598329337485313,
         0.0006161456187886542,
         -0.0066044909196743525,
         -0.006835492322727153,
         0.0020548199501998973,
         0.004998429051091043,
         -0.01044136875923073,
         0.15141025740246583,
         -0.13510742700575454,
         0.12458189989559061,
         -0.12877901640679726,
         0.1566441168741976,
         -0.02083812265640364,
         0.01424159356982087,
         0.004041429094326062,
         -0.023945953826496596,
         0.031121041756525053,
         -0.02650604930263465,
         0.01216315550248085,
         -0.016793114477331065,
         0.0027300202195512553,
         0.005628297264678363,
         -0.0036804984672148475,
         -0.15692464096190567,
         0.16282022661561354,
         -0.1647854218335162,
         0.16282022661561357,
         -0.15692464096190564,
         -0.0036804984672148336,
         0.005628297264678353,
         0.002730020219551252,
         -0.016793114477331075,
         0.01216315550248083,
         -0.026506049302634664,
         0.031121041756525043,
         -0.023945953826496585,
         0.00404142909432607,
         0.014241593569820847,
         -0.020838122656403647,
         0.15664411687419763,
         -0.12877901640679723,
         0.12458189989559063,
         -0.13510742700575454,
         0.15141025740246583,
         -0.010441368759230702,
         0.004998429051091054,
         0.0020548199501998904,
         -0.006835492322727161,
         -0.006604490919674351,
         0.0006161456187886508,
         0.005598329337485317,
         0.01568167631226388,
         -0.015681676312263887,
         -0.01187681491153754,
         0.025634687812146974,
         -0.029984454991997783,
         0.018935943625013524,
         -0.015273501566009484,
         -0.006012865224625807,
         0.03320479348976812,
         -0.09565877169794895,
         0.07730049483240228,
         -0.06321334411777697,
         0.06634036498423013,
         -0.09962460286191907,
         0.010094370290197593,
         -0.007538204309676924,
         -0.001175845013420376,
         0.011250604144835976,
         0.0037888768965163855,
         -0.005161074867601133,
         0.004639123070100264,
         -0.006208221431951801,
         -0.00600423594153655,
         0.006507316732631096,
         0.0049759301943745095,
         0.13890638447965284,
         -0.1342133720689515,
         0.1463577925182521,
         -0.15144896396626178,
         0.12559620455168774,
         0.008478561912020247,
         -0.011343107909416214,
         -0.003379535711954311,
         0.027584402625179097,
         -0.012181612535567057,
         0.022392038241450102,
         -0.024384432792726733,
         0.0007363347857942031,
         -0.0007363347857941749,
         -0.18766354188405512,
         0.2089857636903915,
         -0.20785253662878733,
         0.19587314768027536,
         -0.18465688382588838,
         -0.021322221806336514,
         -0.0013879140318218963,
         0.014671695177095205,
         -0.011216263854386947,
         0.022455448867940698,
         -0.013283781145273302,
         -0.0007631250941250358,
         -0.011609286981032862,
         0.011609286981032864},
        {0.23764207857168007,
         -0.13881544620244235,
         -0.15223547075506047,
         0.045562556730887875,
         0.08301293851879857,
         0.05651996089406705,
         -0.14537112512075093,
         -0.033626672063451726,
         -0.025972866568163763,
         0.06199531134492352,
         0.10407110073410124,
         0.06529891001281467,
         -0.027610900993293677,
         -0.07374155868977407,
         -0.07901191970636705,
         -0.03495172929516024,
         0.050687411229008925,
         0.06442712511683671,
         0.0629280035942191,
         -0.010662899455873698,
         -0.024663365490925203,
         -0.016817583428544093,
         -0.01828937825137917,
         -0.04046928598295694,
         -0.038938449260219145,
         -0.016688215896673957,
         0.009525662318579426,
         0.04258002531883711,
         0.06420456700860758,
         0.04660046338535611,
         0.012894703711832496,
         -0.03092127674020126,
         -0.031157870206643845,
         -0.01835875081329388,
         -0.025500728421410757,
         -0.01666645153425611,
         0.009236554389932315,
         0.024231694708084135,
         0.025932399204251663,
         0.01231031967727575,
         0.003883404484654999,
         0.007203995111263419,
         0.009033596163609336,
         0.003972453892358098,
         0.001389352049834478,
         -0.015549910555943241,
         -0.03576561389354413,
         -0.03581485349613228,
         -0.017182074289015407,
         0.010727045613708724,
         0.017783382639627816,
         0.010920223370128943,
         0.0035250320924728766,
         0.003314440222838255,
         0.0029867462218245346,
         0.0022531075710219037,
         -0.00414466924415798,
         -0.009409150122521272,
         -0.013690385979552175,
         -0.010470075527796743,
         -0.004599726091781652,
         0.0011927579157419482,
         0.0025532299850768853,
         0.003761255613406476,
         0.00424413889088118,
         0.011722566042581843,
         0.01754636281225497,
         0.010563780016840394,
         -0.14567979183675137,
         -0.03400190070185271,
         -0.02521959995237196,
         0.06245563773056422,
         0.10396687770460246,
         0.06463074114426262,
         -0.028191606690349577,
         -0.07349066875115766,
         -0.07917771189774378,
         -0.03427080294110155,
         0.08329197817390577,
         0.10764842820708027,
         0.10011051057651622,
         -0.02168501404559519,
         -0.037654677856285644,
         -0.02756712096764962,
         -0.025917716412408642,
         -0.06614974908281133,
         -0.06605787115922052,
         -0.024583969018368387,
         0.01594439492200541,
         0.0657758291740465,
         0.1084498250891899,
         0.07464749419865079,
         0.01915900705597929,
         -0.07724386124140399,
         -0.07545497308415611,
         -0.043362673738866514,
         -0.06591691196391614,
         -0.03606134957474504,
         0.024146731018663745,
         0.06075613648979354,
         0.06295300692791912,
         0.02595905499550199,
         0.004007536206679449,
         0.01645084732299812,
         0.021985798907690198,
         0.012912176011207706,
         0.0020919103872493044,
         -0.033061014433427065,
         -0.08698012960838952,
         -0.09184383456036703,
         -0.038451509731847675,
         0.045502380304026625,
         0.069796492728628,
         0.04390666990319896,
         0.007647331192865886,
         0.016598553122475417,
         0.013151018735017556,
         0.0030820425799202964,
         -0.009848064871894662,
         -0.03832810415231381,
         -0.05881168133919049,
         -0.038466059609270735,
         -0.009412195383086283,
         0.003269753044282925,
         0.013325477270814096,
         0.016124504779617473,
         0.00757612945594168,
         0.04308772105495167,
         0.07012144751506404,
         0.04629473084463276,
         -0.01666292619304627,
         -0.03582159252042538,
         -0.03568707627583189,
         -0.015627595138037895,
         0.001551130307924066,
         0.003939432599783488,
         0.009049884234044936,
         0.006912061617401969,
         0.0033803833696937585,
         0.012092995226562566,
         0.025163983042833144,
         0.024983822799067062,
         0.009871814279498067,
         -0.01573662016777539,
         -0.02527999666447352,
         -0.01952302297032717,
         -0.03190351545245633,
         -0.03048429821038925,
         0.05093943654726948,
         0.06505437907349819,
         0.06242676229668785,
         -0.010747997203113408,
         -0.024867809177426866,
         -0.016902681175783814,
         -0.018275560420848453,
         -0.040945768650514,
         -0.038153299876661585,
         -0.01657602106807438,
         0.009999806534750817,
         0.0428032795963921,
         0.06411946926136784,
         0.04621028153678027,
         0.012338729671879968,
         -0.07865832772962159,
         -0.07429253191419904,
         -0.042600740422618445,
         -0.06606287335377728,
         -0.03648204003412146,
         0.023455999439339882,
         0.060754030274901165,
         0.0632680021036935,
         0.026192034990515783,
         0.00413564669072781,
         0.017154888967704167,
         0.021672909946808205,
         0.012268998009123091,
         0.002337552506704366,
         -0.03366326913364681,
         -0.08724552465484679,
         -0.09125348472747369,
         -0.0381411778113502,
         0.06714695578504634,
         0.10870251665369256,
         0.060992271812375945,
         0.011568611527336865,
         0.023967697199316185,
         0.01925685493239827,
         0.0070202519993227035,
         -0.013875194652105268,
         -0.05859460297779849,
         -0.08688326098621271,
         -0.05859460297779848,
         -0.01387519465210527,
         0.007020251999322701,
         0.01925685493239826,
         0.023967697199316188,
         0.011568611527336858,
         0.06099227181237595,
         0.10870251665369254,
         0.06714695578504633,
         -0.0381411778113502,
         -0.09125348472747365,
         -0.0872455246548468,
         -0.03366326913364681,
         0.0023375525067043635,
         0.012268998009123087,
         0.02167290994680821,
         0.017154888967704167,
         0.004135646690727806,
         0.026192034990515783,
         0.0632680021036935,
         0.060754030274901165,
         0.023455999439339882,
         -0.036482040034121435,
         -0.06606287335377728,
         -0.042600740422618445,
         -0.07429253191419904,
         -0.07865832772962157,
         0.012338729671879971,
         0.04621028153678028,
         0.06411946926136784,
         0.042803279596392095,
         0.009999806534750813,
         -0.01657602106807438,
         -0.038153299876661585,
         -0.040945768650514004,
         -0.018275560420848453,
         -0.016902681175783817,
         -0.02486780917742685,
         -0.010747997203113415,
         0.06242676229668783,
         0.0650543790734982,
         0.050939436547269484,
         -0.03048429821038924,
         -0.031903515452456316,
         -0.01952302297032718,
         -0.02527999666447353,
         -0.015736620167775387,
         0.009871814279498068,
         0.024983822799067065,
         0.025163983042833144,
         0.012092995226562564,
         0.003380383369693753,
         0.006912061617401974,
         0.009049884234044936,
         0.003939432599783483,
         0.0015511303079240675,
         -0.015627595138037898,
         -0.03568707627583189,
         -0.03582159252042539,
         -0.016662926193046275,
         0.046294730844632766,
         0.07012144751506404,
         0.04308772105495169,
         0.007576129455941681,
         0.01612450477961747,
         0.013325477270814094,
         0.0032697530442829213,
         -0.00941219538308628,
         -0.03846605960927074,
         -0.05881168133919049,
         -0.038328104152313816,
         -0.009848064871894664,
         0.003082042579920299,
         0.013151018735017556,
         0.01659855312247542,
         0.007647331192865886,
         0.043906669903198935,
         0.06979649272862799,
         0.045502380304026625,
         -0.038451509731847675,
         -0.09184383456036702,
         -0.08698012960838954,
         -0.033061014433427065,
         0.0020919103872493053,
         0.012912176011207718,
         0.021985798907690195,
         0.016450847322998122,
         0.004007536206679449,
         0.025959054995502,
         0.06295300692791914,
         0.06075613648979354,
         0.024146731018663745,
         -0.03606134957474505,
         -0.06591691196391616,
         -0.043362673738866514,
         -0.07545497308415608,
         -0.07724386124140398,
         0.019159007055979293,
         0.0746474941986508,
         0.1084498250891899,
         0.06577582917404651,
         0.015944394922005403,
         -0.024583969018368377,
         -0.06605787115922053,
         -0.06614974908281135,
         -0.025917716412408653,
         -0.027567120967649614,
         -0.037654677856285665,
         -0.021685014045595197,
         0.10011051057651625,
         0.10764842820708027,
         0.08329197817390578,
         -0.03427080294110153,
         -0.07917771189774378,
         -0.07349066875115766,
         -0.028191606690349567,
         0.06463074114426261,
         0.10396687770460243,
         0.06245563773056422,
         -0.025219599952371947,
         -0.0340019007018527,
         -0.1456797918367513,
         0.010563780016840385,
         0.017546362812254974,
         0.011722566042581827,
         0.004244138890881186,
         0.003761255613406478,
         0.002553229985076887,
         0.0011927579157419493,
         -0.004599726091781659,
         -0.01047007552779676,
         -0.01369038597955218,
         -0.009409150122521276,
         -0.004144669244157979,
         0.002253107571021913,
         0.0029867462218245372,
         0.0033144402228382523,
         0.0035250320924728735,
         0.01092022337012894,
         0.017783382639627816,
         0.010727045613708725,
         -0.0171820742890154,
         -0.03581485349613229,
         -0.03576561389354413,
         -0.015549910555943253,
         0.0013893520498344783,
         0.003972453892358098,
         0.009033596163609338,
         0.007203995111263416,
         0.0038834044846549954,
         0.012310319677275748,
         0.02593239920425166,
         0.024231694708084138,
         0.009236554389932322,
         -0.01666645153425611,
         -0.025500728421410764,
         -0.018358750813293884,
         -0.031157870206643856,
         -0.030921276740201266,
         0.012894703711832496,
         0.04660046338535612,
         0.06420456700860754,
         0.04258002531883711,
         0.009525662318579422,
         -0.016688215896673957,
         -0.038938449260219145,
         -0.04046928598295693,
         -0.01828937825137917,
         -0.0168175834285441,
         -0.024663365490925213,
         -0.010662899455873693,
         0.06292800359421909,
         0.06442712511683664,
         0.05068741122900892,
         -0.03495172929516025,
         -0.07901191970636709,
         -0.07374155868977408,
         -0.027610900993293688,
         0.06529891001281471,
         0.10407110073410125,
         0.061995311344923566,
         -0.025972866568163767,
         -0.03362667206345174,
         -0.14537112512075087,
         0.05651996089406706,
         0.08301293851879857,
         0.0455625567308879,
         -0.1522354707550604,
         -0.1388154462024419,
         0.2376420785716803},
        {0.015463832462912837,
         -0.01546383246291282,
         -0.0246960584854919,
         0.014782538510780072,
         0.0005562741825231368,
         -0.15446426194340118,
         0.0806143453397819,
         0.10856496728868556,
         -0.020177562293847894,
         -0.08948347254182668,
         -0.022875851574736615,
         0.012300270512895364,
         0.02980892755194206,
         0.031184129676515245,
         -0.0072378766315874974,
         0.14337910978398546,
         0.06194710500040869,
         -0.016146902155926693,
         -0.08959373740086807,
         -0.0648719347717771,
         -0.03945035219343657,
         0.018729850180404895,
         0.1115025483767089,
         0.04285285893689461,
         0.027336990963220287,
         0.024403453786683738,
         -0.05819799719448676,
         -0.06265237987176629,
         -0.003520962609701514,
         -0.014951476069217005,
         -0.14673859734919317,
         -0.02886423202343454,
         0.03769587531841554,
         0.02470136823354011,
         0.019545866207243245,
         0.04421498347886264,
         0.009409566167270986,
         0.030761000370965914,
         -0.005211765642616891,
         -0.015238425471296618,
         -0.06185293673348802,
         -0.059059177810491775,
         -0.014554681497368886,
         -0.012543074742423532,
         -0.014649579398186256,
         0.12066204004836703,
         -0.009788043421931514,
         0.030854818377931116,
         0.0740289208158224,
         0.05607205624536057,
         -0.022215095451685162,
         -0.04148094612516347,
         -0.06092122010697309,
         -0.005030004809873088,
         0.006286398281110598,
         -0.0325054243785656,
         0.03909401692696772,
         0.014144324576415469,
         -0.034230571395352474,
         0.03174310298365435,
         0.05504927727135198,
         -0.03353885223833705,
         0.06761614441659074,
         -0.026334127838862145,
         -0.032986215183952956,
         -0.04420265305096975,
         -0.0036911283685821614,
         0.15446426194340113,
         -0.09955359484079322,
         -0.08962571778767428,
         0.02593437127832854,
         0.07470093403104665,
         0.04125882689322463,
         0.017946100460797507,
         -0.023217707293676622,
         -0.04984524208626486,
         0.006556582679454685,
         -0.02113856742922664,
         -0.020137143218894055,
         0.041275710648120724,
         0.03570983031160438,
         -0.0001333191495716345,
         -0.056630688481236154,
         -0.010527192526704612,
         -0.03659911545964853,
         0.0488023267607045,
         0.0017741190449789264,
         -0.04218827538237828,
         0.022469096935389996,
         0.0020322468973768973,
         -0.02664244535994119,
         0.02554962026709509,
         -0.025608870245774337,
         -0.09188088749070045,
         -0.0123077587251349,
         0.0033984925041181417,
         0.044153752733608866,
         0.03263810818573338,
         0.020958814633000058,
         0.028743724951775775,
         0.021218860283710877,
         -0.024470120523035436,
         -0.021339960212537017,
         -0.054061188475125664,
         -0.05847407604230726,
         0.0029765515682612913,
         0.05173654064377521,
         0.00023066479674913975,
         0.09303331780898573,
         -0.019316841887171622,
         0.06799254840438165,
         0.09482940489372693,
         0.03802054938180018,
         -0.05883895809808352,
         -0.018551847177210617,
         -0.08244311290096865,
         -0.02384201443364792,
         0.006953624343756457,
         -0.0190792512663674,
         0.008989405206988108,
         0.01959373111339469,
         -0.011169270878772798,
         0.03669166433161888,
         0.06096330436682154,
         0.03233009565598502,
         0.022577065700723303,
         -0.06973382762844156,
         -0.09158970568794537,
         -0.02431010877557637,
         -0.04918559497866902,
         -0.08178166402373531,
         -0.041428863053327776,
         0.02092142594081548,
         0.0812917979252188,
         0.06821370127669726,
         0.06345023549463784,
         0.04179779107411818,
         -0.045163600862396194,
         -0.07400991256030401,
         -0.024126848446398914,
         -0.05821199832049381,
         0.03474005642491501,
         -0.0008962525896119002,
         0.0024666642247408773,
         -0.0316724280347917,
         0.08460235092413555,
         0.0487233435900389,
         -0.10885997372063796,
         -0.010124038323639496,
         -0.07019530058419007,
         0.04446226920753041,
         0.07987218254215186,
         0.0946056544149621,
         -0.03199188424073286,
         -0.0470360282482622,
         -0.10753708832493618,
         -0.048060816367953355,
         0.01979365293772257,
         -0.009781163197829625,
         0.07140362673663225,
         0.06624528028986584,
         -0.026214604932429615,
         0.05931034686532703,
         0.07543897890282149,
         -0.0032649283675753498,
         -0.02052474138622023,
         -0.02879877490049346,
         -0.057820745970633115,
         -0.013383334378714109,
         -0.03117396904239621,
         0.033637709152546304,
         0.06751211983280683,
         0.048188551552728144,
         0.04019865453076048,
         0.029976652691164507,
         -0.025286291294730222,
         -0.0356358988631056,
         -0.024732008629516015,
         -0.06842311934642142,
         0.020209129839032523,
         -0.032334435240651355,
         -0.0016742769177894932,
         0.017808949966780258,
         0.038508608637485106,
         0.004243782958048539,
         0.014249507302954899,
         -0.041530598583671786,
         -0.00913240756232157,
         -0.007188506895696208,
         -0.00463075631663826,
         -0.00718850689569622,
         -0.009132407562321554,
         -0.0415305985836718,
         0.014249507302954899,
         0.004243782958048519,
         0.03850860863748511,
         0.01780894996678028,
         -0.001674276917789495,
         -0.03233443524065136,
         0.020209129839032502,
         -0.06842311934642144,
         -0.024732008629516043,
         -0.035635898863105586,
         -0.02528629129473022,
         0.029976652691164507,
         0.040198654530760485,
         0.04818855155272814,
         0.06751211983280685,
         0.03363770915254631,
         -0.031173969042396214,
         -0.013383334378714097,
         -0.05782074597063309,
         -0.02879877490049346,
         -0.020524741386220235,
         -0.003264928367575366,
         0.0754389789028215,
         0.05931034686532703,
         -0.026214604932429643,
         0.06624528028986587,
         0.07140362673663224,
         -0.009781163197829611,
         0.019793652937722554,
         -0.04806081636795335,
         -0.10753708832493619,
         -0.047036028248262175,
         -0.03199188424073285,
         0.09460565441496209,
         0.07987218254215188,
         0.04446226920753043,
         -0.07019530058419007,
         -0.010124038323639487,
         -0.10885997372063794,
         0.04872334359003891,
         0.0846023509241356,
         -0.0316724280347917,
         0.0024666642247408617,
         -0.0008962525896118726,
         0.03474005642491498,
         -0.058211998320493806,
         -0.024126848446398917,
         -0.074009912560304,
         -0.04516360086239624,
         0.04179779107411819,
         0.06345023549463782,
         0.06821370127669732,
         0.0812917979252188,
         0.02092142594081549,
         -0.04142886305332777,
         -0.0817816640237353,
         -0.04918559497866904,
         -0.024310108775576378,
         -0.09158970568794537,
         -0.06973382762844156,
         0.022577065700723296,
         0.032330095655985,
         0.06096330436682157,
         0.0366916643316189,
         -0.011169270878772805,
         0.01959373111339469,
         0.008989405206988106,
         -0.019079251266367392,
         0.006953624343756453,
         -0.023842014433647928,
         -0.08244311290096863,
         -0.01855184717721061,
         -0.05883895809808353,
         0.03802054938180019,
         0.09482940489372689,
         0.06799254840438167,
         -0.019316841887171587,
         0.09303331780898574,
         0.00023066479674914471,
         0.051736540643775246,
         0.002976551568261271,
         -0.05847407604230726,
         -0.054061188475125664,
         -0.021339960212536983,
         -0.02447012052303542,
         0.021218860283710877,
         0.02874372495177579,
         0.020958814633000037,
         0.03263810818573339,
         0.044153752733608866,
         0.0033984925041181412,
         -0.012307758725134902,
         -0.09188088749070039,
         -0.025608870245774334,
         0.025549620267095115,
         -0.02664244535994121,
         0.0020322468973768873,
         0.02246909693539,
         -0.0421882753823783,
         0.0017741190449789236,
         0.048802326760704534,
         -0.03659911545964855,
         -0.010527192526704652,
         -0.05663068848123614,
         -0.00013331914957164087,
         0.03570983031160439,
         0.04127571064812072,
         -0.02013714321889407,
         -0.021138567429226648,
         0.006556582679454689,
         -0.04984524208626487,
         -0.0232177072936766,
         0.017946100460797528,
         0.04125882689322463,
         0.0747009340310466,
         0.025934371278328504,
         -0.08962571778767432,
         -0.09955359484079325,
         0.15446426194340115,
         -0.003691128368582159,
         -0.0442026530509698,
         -0.03298621518395296,
         -0.02633412783886213,
         0.06761614441659072,
         -0.03353885223833706,
         0.05504927727135194,
         0.03174310298365432,
         -0.03423057139535247,
         0.014144324576415457,
         0.03909401692696771,
         -0.03250542437856562,
         0.006286398281110598,
         -0.005030004809873117,
         -0.06092122010697311,
         -0.04148094612516348,
         -0.02221509545168517,
         0.05607205624536058,
         0.07402892081582241,
         0.030854818377931102,
         -0.009788043421931503,
         0.12066204004836702,
         -0.01464957939818629,
         -0.012543074742423528,
         -0.01455468149736888,
         -0.05905917781049175,
         -0.06185293673348797,
         -0.015238425471296604,
         -0.005211765642616921,
         0.030761000370965894,
         0.009409566167270981,
         0.044214983478862664,
         0.01954586620724324,
         0.02470136823354009,
         0.037695875318415534,
         -0.02886423202343461,
         -0.14673859734919317,
         -0.01495147606921703,
         -0.0035209626097015105,
         -0.0626523798717663,
         -0.05819799719448673,
         0.02440345378668408,
         0.027336990963220342,
         0.042852858936894694,
         0.1115025483767088,
         0.018729850180404916,
         -0.03945035219343654,
         -0.06487193477177697,
         -0.08959373740086816,
         -0.016146902155926627,
         0.06194710500040866,
         0.14337910978398544,
         -0.007237876631587511,
         0.03118412967651516,
         0.029808927551942012,
         0.012300270512895367,
         -0.022875851574736518,
         -0.08948347254182669,
         -0.02017756229384796,
         0.10856496728868557,
         0.08061434533978196,
         -0.15446426194340113,
         0.0005562741825231922,
         0.014782538510780048,
         -0.024696058485491893,
         -0.015463832462912854,
         0.015463832462912894},
        {-0.0014346057525376121,
         -0.020080454649956433,
         0.0218374806878456,
         -0.04163376523492916,
         0.07107119509815711,
         -0.07585961611779396,
         -0.0067175620105199285,
         0.000675707249962243,
         0.008986198123214051,
         0.06867055131269717,
         -0.06485101987485581,
         0.026134209556580412,
         -0.023338128833716422,
         0.0015464675192025483,
         -0.006625219321799432,
         0.04601009336661743,
         -0.012222518427203427,
         -0.003079728990423269,
         0.023529547038265687,
         0.03422170923268458,
         -0.03896854957564138,
         -0.0006980576692560241,
         -0.11213237393699244,
         0.011316781487452231,
         0.09250278796304491,
         -0.1009643619854329,
         0.08344577858576739,
         0.05726984894819541,
         -0.06805642985900885,
         -0.0008465609173002809,
         0.0454602970197203,
         0.012842790649065128,
         0.0021266761101414256,
         -0.06578734122885038,
         0.07150180040975472,
         -0.08364694637567822,
         0.04206990319387868,
         -0.012865052277105247,
         -0.019668198557008125,
         0.10040402091973902,
         0.03736263638800603,
         0.04844601533164565,
         -0.04689774454199266,
         -0.025936844864044028,
         0.026623119710482663,
         -0.1395624257502027,
         0.017126388624963813,
         0.08922188930580399,
         -0.08230038533732335,
         0.05839209474323514,
         -0.08435820921565419,
         0.06714176562509629,
         0.008530895286385719,
         -0.003052923764764336,
         0.013550137597790335,
         0.0024127826307482575,
         -0.027588139664464335,
         -0.02492993377979393,
         0.03848712874227118,
         -0.035978249465256726,
         -0.06738081460727394,
         -0.0035742038227184773,
         -0.011707746897278506,
         0.011512466226766284,
         0.05590118740996357,
         0.11687056865180863,
         -0.09984872215920816,
         0.02155485484692365,
         0.00847458804840905,
         0.025352332350320562,
         -0.03429693484722838,
         -0.0024433522300224483,
         -0.007977201261190624,
         0.02298006408466163,
         0.07432886928191727,
         -0.04695678398441245,
         -0.004559246260545687,
         0.046898582419385326,
         0.02168702876972626,
         0.009661875307862989,
         -0.03310593011547859,
         -0.12684433739779677,
         0.11749057986140264,
         -0.04215859663665321,
         0.07656777319415327,
         -0.0046512349230721515,
         -0.05337535138570015,
         0.04563775204607047,
         -0.07886166052848025,
         -0.04869685311387383,
         0.08957193865834387,
         -0.03685906883861505,
         -0.1016873589934582,
         -0.00042689456417170505,
         -0.013911664270069018,
         0.042431728185835224,
         -0.06029475015661888,
         0.07448341907025309,
         0.04389578884666712,
         0.015401058714803986,
         -0.040779200927363965,
         0.0015412173967955327,
         -0.0170731019466541,
         -0.018331653915410764,
         -0.0016582832679319724,
         0.020284625482887522,
         0.02289753563985466,
         0.03021273764256742,
         -0.007764646983514448,
         -0.024885466766324936,
         0.05618323875301834,
         -0.008333895496183174,
         -0.002113057953307134,
         0.01390054509157524,
         0.020516915309493667,
         -0.0029747915569280654,
         0.006613870742982906,
         -0.022935923738113283,
         -0.060241460827293564,
         -0.060717571434306714,
         0.058795575474143734,
         -0.008571228414957938,
         -0.06562973563832307,
         0.05732797785326936,
         -0.0073148784368382265,
         -0.011530565697614605,
         0.025712923080921216,
         0.03693140789975776,
         -0.03040078581782704,
         -0.009979769297289281,
         -0.08004631385297468,
         0.04797811311818028,
         0.02262538087376449,
         -0.08464431573626095,
         0.025257537278901853,
         0.025740965978193496,
         -0.05999332234758385,
         0.025055932353928053,
         0.080111524489698,
         0.05689556124544094,
         -0.002265102032757236,
         -0.017172570995764937,
         0.0348943714874777,
         -0.10078533395334742,
         0.10008789115889986,
         -0.10153201365874283,
         -0.043287907413713037,
         0.0734495242318484,
         -0.0246268570072597,
         -0.040160692670837675,
         0.054408341428651884,
         0.08065898767504587,
         -0.08065021813037776,
         0.04573922077310517,
         -0.1207632404251626,
         0.05210996098942074,
         0.03651745840214763,
         -0.09853566478729084,
         0.0037010085548778524,
         0.026028330420920832,
         -0.021619151416647626,
         -0.003637982252330675,
         0.0447348487459436,
         -0.025169378431011195,
         0.023235158176826757,
         0.07475073390409848,
         -0.0380538391112834,
         0.0007811076818786719,
         0.0063807753569763105,
         -0.0246724358577905,
         0.011086322462199993,
         -0.005020372806212811,
         0.018946053112165517,
         0.00022637788562493864,
         -0.013450312084901448,
         0.025922961078877593,
         0.0228667767950303,
         0.07393835261463733,
         -0.0331104385609555,
         -0.027827403053403827,
         0.056939445871619344,
         -0.025884570926234245,
         0.06305089956766645,
         -0.06080433782817488,
         -0.10684443234199599,
         0.01322312201215386,
         0.03364462333433131,
         -0.05308871272893524,
         0.04147380126351854,
         0.027807405124484437,
         -0.031759149993651765,
         0.02780740512448445,
         0.04147380126351853,
         -0.053088712728935256,
         0.03364462333433129,
         0.013223122012153839,
         -0.10684443234199596,
         -0.060804337828174855,
         0.06305089956766646,
         -0.025884570926234227,
         0.05693944587161936,
         -0.02782740305340381,
         -0.033110438560955524,
         0.07393835261463735,
         0.022866776795030297,
         0.025922961078877583,
         -0.013450312084901444,
         0.00022637788562494577,
         0.018946053112165503,
         -0.0050203728062128035,
         0.011086322462200001,
         -0.024672435857790498,
         0.00638077535697631,
         0.0007811076818786786,
         -0.03805383911128338,
         0.07475073390409846,
         0.023235158176826736,
         -0.02516937843101119,
         0.04473484874594359,
         -0.0036379822523306704,
         -0.0216191514166476,
         0.02602833042092084,
         0.0037010085548778394,
         -0.09853566478729084,
         0.03651745840214762,
         0.05210996098942075,
         -0.12076324042516262,
         0.0457392207731052,
         -0.08065021813037773,
         0.08065898767504584,
         0.054408341428651905,
         -0.04016069267083768,
         -0.024626857007259688,
         0.07344952423184835,
         -0.04328790741371304,
         -0.10153201365874286,
         0.10008789115889984,
         -0.10078533395334738,
         0.03489437148747769,
         -0.017172570995764937,
         -0.002265102032757248,
         0.05689556124544094,
         0.080111524489698,
         0.025055932353928053,
         -0.059993322347583845,
         0.0257409659781935,
         0.025257537278901857,
         -0.08464431573626095,
         0.02262538087376449,
         0.047978113118180274,
         -0.08004631385297473,
         -0.009979769297289262,
         -0.03040078581782703,
         0.03693140789975776,
         0.02571292308092123,
         -0.011530565697614611,
         -0.007314878436838232,
         0.057327977853269395,
         -0.06562973563832306,
         -0.008571228414957945,
         0.058795575474143706,
         -0.06071757143430671,
         -0.06024146082729354,
         -0.022935923738113272,
         0.006613870742982906,
         -0.0029747915569280723,
         0.0205169153094937,
         0.013900545091575242,
         -0.002113057953307132,
         -0.00833389549618317,
         0.05618323875301833,
         -0.02488546676632492,
         -0.00776464698351444,
         0.03021273764256742,
         0.02289753563985465,
         0.020284625482887536,
         -0.0016582832679319641,
         -0.01833165391541075,
         -0.017073101946654092,
         0.0015412173967955273,
         -0.04077920092736395,
         0.015401058714803963,
         0.04389578884666712,
         0.07448341907025308,
         -0.060294750156618865,
         0.04243172818583523,
         -0.013911664270069025,
         -0.00042689456417170874,
         -0.10168735899345821,
         -0.03685906883861507,
         0.08957193865834388,
         -0.048696853113873825,
         -0.07886166052848023,
         0.045637752046070484,
         -0.053375351385700175,
         -0.004651234923072199,
         0.07656777319415324,
         -0.04215859663665319,
         0.11749057986140264,
         -0.1268443373977967,
         -0.03310593011547858,
         0.009661875307862984,
         0.021687028769726283,
         0.04689858241938537,
         -0.004559246260545693,
         -0.04695678398441243,
         0.07432886928191727,
         0.02298006408466167,
         -0.007977201261190668,
         -0.002443352230022439,
         -0.03429693484722838,
         0.025352332350320583,
         0.008474588048409061,
         0.02155485484692361,
         -0.09984872215920818,
         0.11687056865180863,
         0.055901187409963575,
         0.011512466226766275,
         -0.011707746897278494,
         -0.0035742038227184764,
         -0.06738081460727395,
         -0.03597824946525674,
         0.03848712874227118,
         -0.024929933779793943,
         -0.027588139664464325,
         0.0024127826307482787,
         0.01355013759779034,
         -0.0030529237647643273,
         0.008530895286385702,
         0.0671417656250963,
         -0.08435820921565418,
         0.05839209474323516,
         -0.0823003853373234,
         0.08922188930580398,
         0.0171263886249638,
         -0.13956242575020267,
         0.026623119710482653,
         -0.02593684486404406,
         -0.04689774454199265,
         0.048446015331645664,
         0.03736263638800605,
         0.10040402091973905,
         -0.019668198557008132,
         -0.012865052277105238,
         0.0420699031938787,
         -0.08364694637567821,
         0.07150180040975468,
         -0.06578734122885041,
         0.00212667611014142,
         0.012842790649065138,
         0.045460297019720305,
         -0.0008465609173002722,
         -0.06805642985900887,
         0.0572698489481954,
         0.08344577858576742,
         -0.10096436198543288,
         0.09250278796304491,
         0.011316781487452222,
         -0.11213237393699246,
         -0.0006980576692560962,
         -0.03896854957564139,
         0.0342217092326846,
         0.02352954703826568,
         -0.003079728990423287,
         -0.0122225184272034,
         0.04601009336661747,
         -0.0066252193217994125,
         0.0015464675192025366,
         -0.023338128833716425,
         0.026134209556580426,
         -0.0648510198748558,
         0.06867055131269685,
         0.008986198123214153,
         0.0006757072499624455,
         -0.006717562010519717,
         -0.0758596161177939,
         0.07107119509815721,
         -0.04163376523492907,
         0.02183748068784571,
         -0.020080454649956322,
         -0.001434605752537626},
        {-0.0019472363452581872,
         0.022159602065607943,
         -0.01977473433836581,
         0.033048105173227454,
         -0.06263509938572817,
         0.06728734747054499,
         0.020702921740340552,
         -0.012732176287316488,
         -0.010676384591728871,
         -0.06542911354766179,
         0.07356803680113283,
         -0.03324566294593134,
         0.09805833891766658,
         -0.087715439312156,
         0.07878873329298128,
         -0.09212565037271297,
         0.0020610919129660094,
         0.007148121824068508,
         -0.03456501096133803,
         0.06319604221118105,
         -0.07055998652495618,
         0.10285338330100025,
         -0.0816327790981964,
         0.10271427020476483,
         -0.1057223204809415,
         0.01671419284536513,
         -0.04289981324653264,
         0.0044361446581387505,
         -0.0005865557806598871,
         0.00811973568811276,
         0.08799648928411702,
         -0.008049151385812166,
         0.005524839635940413,
         -0.07761991232505594,
         0.094359115379679,
         -0.0469898967984541,
         0.0559189084208276,
         -0.050820835354637835,
         0.027021706499914974,
         -0.07792661747055918,
         0.06498957257608125,
         -0.03349664134034718,
         -0.018396793509779727,
         0.09709740749080624,
         -0.022127804365655642,
         -0.012448246318733378,
         0.033077699026609,
         -0.017470224245180643,
         -0.08564544458553162,
         0.034930917738603975,
         -0.03473231096754449,
         0.023847800479799307,
         0.033682960865273275,
         0.0014359610134249527,
         -0.05012104294757903,
         0.05981910271891172,
         -0.08509168283810449,
         -0.012080259155750192,
         0.05213933644927794,
         -0.024081424469711937,
         0.028744902674037384,
         0.039226029577966955,
         0.007402233248926185,
         -0.044520650697435576,
         -0.013077367763022046,
         -0.021863968475987858,
         -0.01519987079300476,
         0.08060683874216364,
         -0.018318054013098377,
         -0.012460446349357383,
         0.03684262540103189,
         0.005241149392502449,
         -0.013317805142647047,
         -0.009822680060569099,
         -0.13853383623778653,
         0.1313793508807016,
         -0.06936406402175328,
         0.00971581664861911,
         -0.023227233490212357,
         -0.013863879674906451,
         0.03470624543787659,
         0.018328610276350573,
         0.01972446673040995,
         -0.07217585124040626,
         0.08205495987748863,
         -0.06275629856273303,
         -0.006162276316933928,
         0.1123724835949449,
         -0.045517012660318636,
         0.003937550102950057,
         0.011651318599553047,
         -0.01431505129237675,
         -0.015647598578474253,
         0.0006489431417935238,
         0.025737400038993084,
         0.008910935403476592,
         -0.0017309718711398662,
         -0.026085198687553882,
         -0.04590609735465629,
         -0.040334278780867885,
         0.07995277166953091,
         -0.05099955057802264,
         0.04493694663824211,
         -0.007577301521524235,
         0.026802028430448117,
         -0.014270610582611028,
         -0.07760976721748901,
         0.05370959442508184,
         -0.045226506474932385,
         0.012170344089422898,
         0.008777594041952679,
         0.05254715146527995,
         -0.05710249266226278,
         0.01637557730927576,
         -0.007104767629520813,
         0.022860666141750866,
         -0.05154959933629557,
         0.09317175748417644,
         -0.050422871289210004,
         0.059428747885785276,
         -0.0004600969397156838,
         -0.05000620636153258,
         0.07628262970851493,
         -0.05827071449496746,
         0.023076285916051285,
         -0.034397298406015187,
         0.023753209223402977,
         0.004032195286066775,
         -0.00391530390092326,
         0.04175720451719945,
         -0.07646442321862987,
         0.006171340977049054,
         0.06881146219685769,
         -0.0890265740505158,
         0.07053264128877486,
         -0.02064641130589742,
         -0.004230580501879136,
         0.031059988695016916,
         -0.09502427484758938,
         0.04913006344318488,
         -0.05812799667639403,
         0.02016265481377056,
         0.011352960894737505,
         -0.03358014332360808,
         0.06066046219723868,
         -0.020069748945665045,
         0.041977654052238245,
         -0.083522941555549,
         0.03392158520011258,
         0.03873688517325607,
         -0.050223527666952324,
         -0.007745950666942078,
         -0.022695120334615227,
         0.03191139042287712,
         0.04087366005032055,
         -0.046992063006908315,
         0.0830049884841706,
         -0.08986199965957857,
         0.1502768888421485,
         -0.02148194344603767,
         -0.07152854865878301,
         0.07311932338326566,
         0.004843279664535565,
         0.02963582394032939,
         -0.03510997404668936,
         -0.013375666004920643,
         -0.035011215243180245,
         0.06355480449008354,
         -0.05447747279918287,
         0.06840086298939398,
         -0.03458362631966708,
         0.01080291822348406,
         -0.07477005561517912,
         0.00012100969983572785,
         0.03260328464938421,
         -0.05963067131005371,
         -0.001365770689086655,
         -0.019760105410177985,
         0.029637637772429268,
         -0.009506611396599205,
         0.01568680713313179,
         -0.060471842896879936,
         0.03697146628643273,
         -0.02081450180706068,
         0.04409992958070056,
         0.011928836220450417,
         -0.005373724920887322,
         -0.016087008218600072,
         0.04296809618478014,
         0.02596500395041893,
         -0.06596042437939548,
         0.025965003950418935,
         0.04296809618478016,
         -0.016087008218600072,
         -0.005373724920887311,
         0.011928836220450401,
         0.04409992958070052,
         -0.020814501807060688,
         0.03697146628643275,
         -0.06047184289687991,
         0.015686807133131798,
         -0.00950661139659919,
         0.029637637772429296,
         -0.019760105410177996,
         -0.0013657706890866511,
         -0.059630671310053715,
         0.032603284649384216,
         0.00012100969983573763,
         -0.0747700556151791,
         0.01080291822348405,
         -0.034583626319667084,
         0.06840086298939398,
         -0.05447747279918285,
         0.06355480449008352,
         -0.035011215243180266,
         -0.013375666004920664,
         -0.03510997404668937,
         0.029635823940329393,
         0.00484327966453557,
         0.07311932338326568,
         -0.07152854865878301,
         -0.021481943446037686,
         0.15027688884214851,
         -0.08986199965957851,
         0.08300498848417057,
         -0.04699206300690833,
         0.04087366005032056,
         0.03191139042287715,
         -0.022695120334615224,
         -0.007745950666942098,
         -0.05022352766695233,
         0.03873688517325606,
         0.03392158520011259,
         -0.08352294155554899,
         0.04197765405223823,
         -0.02006974894566502,
         0.06066046219723867,
         -0.03358014332360808,
         0.011352960894737514,
         0.02016265481377056,
         -0.05812799667639402,
         0.04913006344318491,
         -0.09502427484758941,
         0.031059988695016943,
         -0.0042305805018791375,
         -0.020646411305897408,
         0.07053264128877484,
         -0.08902657405051577,
         0.0688114621968577,
         0.006171340977049055,
         -0.07646442321862996,
         0.04175720451719949,
         -0.003915303900923229,
         0.004032195286066821,
         0.02375320922340299,
         -0.034397298406015187,
         0.0230762859160513,
         -0.058270714494967436,
         0.07628262970851493,
         -0.05000620636153259,
         -0.00046009693971569383,
         0.05942874788578529,
         -0.05042287128920999,
         0.09317175748417644,
         -0.05154959933629557,
         0.022860666141750887,
         -0.007104767629520793,
         0.016375577309275753,
         -0.0571024926622628,
         0.052547151465279975,
         0.008777594041952684,
         0.012170344089422911,
         -0.0452265064749324,
         0.05370959442508183,
         -0.07760976721748904,
         -0.014270610582611053,
         0.02680202843044808,
         -0.007577301521524224,
         0.044936946638242097,
         -0.050999550578022586,
         0.07995277166953087,
         -0.040334278780867885,
         -0.04590609735465634,
         -0.026085198687553872,
         -0.001730971871139884,
         0.008910935403476563,
         0.02573740003899309,
         0.0006489431417935524,
         -0.015647598578474208,
         -0.014315051292376792,
         0.011651318599553045,
         0.003937550102950072,
         -0.0455170126603187,
         0.11237248359494481,
         -0.006162276316933891,
         -0.06275629856273307,
         0.08205495987748863,
         -0.07217585124040625,
         0.01972446673040995,
         0.018328610276350594,
         0.0347062454378766,
         -0.013863879674906439,
         -0.023227233490212346,
         0.009715816648619204,
         -0.0693640640217533,
         0.1313793508807016,
         -0.13853383623778653,
         -0.009822680060569076,
         -0.013317805142647042,
         0.0052411493925024295,
         0.03684262540103189,
         -0.012460446349357395,
         -0.018318054013098356,
         0.0806068387421636,
         -0.015199870793004697,
         -0.021863968475987903,
         -0.01307736776302204,
         -0.04452065069743559,
         0.007402233248926171,
         0.03922602957796692,
         0.028744902674037374,
         -0.024081424469711957,
         0.052139336449277936,
         -0.012080259155750181,
         -0.08509168283810449,
         0.05981910271891173,
         -0.05012104294757902,
         0.001435961013424938,
         0.03368296086527326,
         0.023847800479799293,
         -0.034732310967544505,
         0.03493091773860394,
         -0.08564544458553162,
         -0.01747022424518065,
         0.033077699026609036,
         -0.012448246318733387,
         -0.022127804365655625,
         0.09709740749080625,
         -0.018396793509779744,
         -0.033496641340347195,
         0.06498957257608126,
         -0.07792661747055922,
         0.027021706499914974,
         -0.05082083535463785,
         0.0559189084208276,
         -0.04698989679845406,
         0.09435911537967906,
         -0.07761991232505591,
         0.005524839635940426,
         -0.008049151385812164,
         0.08799648928411703,
         0.00811973568811276,
         -0.0005865557806598874,
         0.004436144658138782,
         -0.04289981324653266,
         0.016714192845365093,
         -0.1057223204809415,
         0.10271427020476481,
         -0.0816327790981964,
         0.10285338330100026,
         -0.07055998652495618,
         0.06319604221118104,
         -0.03456501096133805,
         0.007148121824068486,
         0.00206109191296595,
         -0.09212565037271304,
         0.07878873329298117,
         -0.08771543931215597,
         0.0980583389176665,
         -0.03324566294593134,
         0.07356803680113286,
         -0.06542911354766166,
         -0.01067638459172906,
         -0.012732176287316337,
         0.02070292174034061,
         0.06728734747054511,
         -0.06263509938572812,
         0.03304810517322739,
         -0.019774734338365813,
         0.022159602065608044,
         -0.0019472363452581257},
        {-0.005174658096276915,
         0.005174658096276896,
         0.010985681950450415,
         -0.008279999531276368,
         0.0025355006642903116,
         -0.04506026527111006,
         0.0361422335222582,
         0.01904509527207831,
         -0.027229593861636238,
         -0.005741051618631251,
         -0.018582636897616654,
         0.025105571630287565,
         -0.01450400818636339,
         0.02595214851127537,
         -0.00808740865899246,
         -0.006215129170712375,
         0.040263936151107085,
         0.021138521813941713,
         -0.03543663370120534,
         -0.05017722906519628,
         0.0007859188861401023,
         0.06609969519958948,
         -0.004205121879196159,
         0.060123402563023794,
         -0.03129383461497381,
         -0.12893033979119392,
         0.032082724494055415,
         -0.0141452486709442,
         -0.0608974524667813,
         0.1020962993597042,
         -0.017556256640556763,
         0.025168204217423048,
         -0.03628308159344831,
         0.012680725437307923,
         -0.0520420434688035,
         -0.009047982735385068,
         0.09891982393639441,
         -0.061423320308505884,
         0.10140805560378689,
         0.021603857821599237,
         -0.09147765006624116,
         -0.0032370519909571,
         0.004536969736439191,
         -0.0904090023041047,
         0.13630291460444038,
         -0.0686823997286759,
         0.08547069028252192,
         -0.03463291672475339,
         0.07304760685962736,
         -0.0719084252282009,
         0.03816323064710638,
         0.005969124569505259,
         -0.04407517996937812,
         0.09243439434485594,
         -0.0641403637264484,
         0.008629970522836287,
         -0.00689264249065022,
         -0.02979987557001034,
         -0.012482587753721984,
         -0.010369886326906184,
         -0.032173369959703574,
         0.10785327757005989,
         -0.07541036011714777,
         0.10310946739989676,
         -0.08502141717598871,
         0.037436808600396915,
         -0.0559108694999788,
         0.0450602652711101,
         -0.029804597557638125,
         -0.025382731236698552,
         0.022581547875805918,
         0.014021051149907487,
         0.009709500268706251,
         -0.03856022925784086,
         0.013659213196968235,
         -0.01834676221451014,
         0.004982067223993089,
         0.05267221284797639,
         -0.04851779917901993,
         -0.004154413668956434,
         0.032485125670025504,
         0.013298298690216639,
         -0.0015289436474842243,
         -0.07271152889441733,
         0.05391512702943425,
         -0.0739740170270212,
         0.06917336134714624,
         0.13280120079575203,
         -0.0466350142737814,
         0.0033032696143901557,
         0.05088649045771868,
         -0.11695451036986552,
         -0.012546871699038535,
         -0.04574802168065425,
         0.038525304181684726,
         -0.01547880745167642,
         0.03688637952960102,
         -0.026472956859708432,
         -0.01911040793049032,
         0.06226045266411031,
         -0.08683458269279537,
         0.03637143052232768,
         0.019004564527060463,
         -0.05037581598925635,
         0.01299882772571701,
         0.03992549715485222,
         -0.07008868032037563,
         0.06214958530249686,
         -0.012771626224016515,
         0.0012176402470508456,
         -0.015262589984822635,
         0.051615752214026596,
         -0.016945816215727917,
         0.049549863981955655,
         -0.056323938927099394,
         0.01930489221076524,
         0.003679593543072437,
         -0.026041201856727886,
         0.006825860946560662,
         -0.012159212119009576,
         -0.019254201734742325,
         0.019689792622701787,
         -0.03425575240009487,
         0.07683046774855191,
         -0.011652397757384273,
         0.017395481892521967,
         -0.01323247871284949,
         -0.05799818135565166,
         0.012856666357430602,
         -0.09543380643826285,
         0.059097048117835324,
         -0.042528149983877724,
         0.017400142715670565,
         -0.016538636707609564,
         0.05645345459441149,
         -0.022730455018415214,
         -0.033780201354535175,
         0.07684082882224054,
         0.03766684182134506,
         -0.08715377525346707,
         0.1441436819088137,
         -0.10343031730931367,
         0.016572309459459877,
         -0.0771711053638317,
         0.005038438227184722,
         0.06669273604433996,
         0.031039742074746576,
         -0.07979823422982799,
         0.03262766217188815,
         -0.008016756736396843,
         -0.019300944358751185,
         0.020181198708485032,
         0.01692160822859432,
         0.06827146220932974,
         -0.08763302553586332,
         0.05343077567747077,
         -0.07025715415427174,
         -0.07694743104401161,
         0.05590241185790636,
         0.001990440671509884,
         -0.02726972411397095,
         0.09142511698672907,
         0.009154807142576205,
         0.006133404536846451,
         -0.022492630672690302,
         0.04518719046172993,
         -0.031203022213160365,
         0.06669936008410027,
         -0.07462701182974389,
         -0.00033635706670374693,
         0.01919016499313337,
         -0.08543444217883625,
         0.024526352885882813,
         0.06773759764081128,
         -0.03705326920405752,
         -0.0009123523450037965,
         -0.00026571636639402156,
         -0.0188178406431056,
         -0.041418133848092335,
         0.05272667211988196,
         -0.0036463174596850475,
         0.008620222277171307,
         0.03257623512766041,
         -0.061602211303931904,
         0.05945737516571996,
         -0.09620414019192082,
         0.0462686096201219,
         0.011284850097399355,
         0.014895061219868316,
         0.019384983374645927,
         0.0148950612198683,
         0.01128485009739937,
         0.046268609620121914,
         -0.0962041401919208,
         0.05945737516571994,
         -0.06160221130393192,
         0.03257623512766043,
         0.008620222277171281,
         -0.003646317459685057,
         0.052726672119881954,
         -0.04141813384809232,
         -0.018817840643105602,
         -0.0002657163663940175,
         -0.0009123523450037948,
         -0.03705326920405753,
         0.06773759764081128,
         0.02452635288588279,
         -0.08543444217883625,
         0.01919016499313338,
         -0.00033635706670374807,
         -0.07462701182974386,
         0.06669936008410025,
         -0.03120302221316038,
         0.04518719046172993,
         -0.022492630672690316,
         0.006133404536846465,
         0.009154807142576205,
         0.09142511698672907,
         -0.027269724113970946,
         0.00199044067150991,
         0.055902411857906315,
         -0.07694743104401162,
         -0.07025715415427172,
         0.05343077567747078,
         -0.08763302553586329,
         0.06827146220932974,
         0.01692160822859433,
         0.02018119870848506,
         -0.01930094435875118,
         -0.008016756736396848,
         0.03262766217188815,
         -0.07979823422982797,
         0.03103974207474654,
         0.06669273604433995,
         0.005038438227184749,
         -0.07717110536383168,
         0.016572309459459894,
         -0.10343031730931368,
         0.1441436819088137,
         -0.08715377525346706,
         0.037666841821345075,
         0.07684082882224054,
         -0.03378020135453515,
         -0.022730455018415217,
         0.05645345459441148,
         -0.016538636707609553,
         0.017400142715670572,
         -0.04252814998387776,
         0.05909704811783534,
         -0.09543380643826285,
         0.012856666357430586,
         -0.05799818135565166,
         -0.013232478712849488,
         0.017395481892521984,
         -0.011652397757384273,
         0.07683046774855193,
         -0.0342557524000949,
         0.019689792622701777,
         -0.01925420173474232,
         -0.012159212119009586,
         0.0068258609465606515,
         -0.02604120185672787,
         0.003679593543072457,
         0.019304892210765263,
         -0.05632393892709939,
         0.04954986398195565,
         -0.01694581621572792,
         0.05161575221402661,
         -0.015262589984822628,
         0.0012176402470508284,
         -0.012771626224016492,
         0.06214958530249684,
         -0.0700886803203756,
         0.039925497154852184,
         0.012998827725717019,
         -0.050375815989256376,
         0.01900456452706046,
         0.036371430522327663,
         -0.08683458269279536,
         0.06226045266411032,
         -0.019110407930490295,
         -0.02647295685970842,
         0.036886379529601006,
         -0.01547880745167642,
         0.03852530418168474,
         -0.045748021680654255,
         -0.012546871699038538,
         -0.11695451036986554,
         0.05088649045771867,
         0.0033032696143901435,
         -0.0466350142737814,
         0.132801200795752,
         0.06917336134714624,
         -0.0739740170270212,
         0.05391512702943426,
         -0.07271152889441733,
         -0.0015289436474842269,
         0.013298298690216655,
         0.03248512567002549,
         -0.0041544136689564345,
         -0.04851779917901994,
         0.052672212847976414,
         0.004982067223993084,
         -0.018346762214510152,
         0.01365921319696824,
         -0.038560229257840875,
         0.009709500268706255,
         0.014021051149907503,
         0.022581547875805914,
         -0.02538273123669856,
         -0.02980459755763811,
         0.04506026527111014,
         -0.05591086949997884,
         0.03743680860039692,
         -0.08502141717598868,
         0.10310946739989676,
         -0.07541036011714779,
         0.10785327757005989,
         -0.03217336995970355,
         -0.010369886326906207,
         -0.012482587753721968,
         -0.029799875570010317,
         -0.006892642490650247,
         0.008629970522836296,
         -0.06414036372644841,
         0.09243439434485592,
         -0.044075179969378105,
         0.005969124569505245,
         0.03816323064710641,
         -0.07190842522820087,
         0.07304760685962737,
         -0.03463291672475336,
         0.08547069028252191,
         -0.0686823997286759,
         0.13630291460444036,
         -0.09040900230410469,
         0.004536969736439195,
         -0.003237051990957101,
         -0.0914776500662411,
         0.021603857821599216,
         0.10140805560378693,
         -0.061423320308505905,
         0.0989198239363944,
         -0.009047982735385094,
         -0.05204204346880351,
         0.012680725437307942,
         -0.0362830815934483,
         0.025168204217423017,
         -0.017556256640556774,
         0.1020962993597042,
         -0.06089745246678132,
         -0.014145248670944216,
         0.03208272449405539,
         -0.1289303397911939,
         -0.03129383461497382,
         0.06012340256302377,
         -0.004205121879196154,
         0.0660996951995895,
         0.0007859188861401871,
         -0.050177229065196484,
         -0.03543663370120529,
         0.021138521813941647,
         0.0402639361511074,
         -0.0062151291707124405,
         -0.008087408658992516,
         0.02595214851127535,
         -0.01450400818636316,
         0.02510557163028764,
         -0.0185826368976166,
         -0.005741051618631159,
         -0.027229593861636217,
         0.01904509527207848,
         0.03614223352225818,
         -0.04506026527111008,
         0.0025355006642902387,
         -0.008279999531276325,
         0.010985681950450363,
         0.005174658096276892,
         -0.005174658096276901},
        {-0.006748193648184257,
         0.00674819364818431,
         -0.0066290192928007835,
         0.014867051029397832,
         -0.017648773375162075,
         -0.05533383277264479,
         0.035256743241741634,
         0.03251308466099493,
         -0.0606176702764948,
         0.03780885896773464,
         -0.06889376577810945,
         0.07210560973815981,
         -0.021064286156078943,
         -0.021945414253836282,
         0.08858004302874989,
         0.08374007045948492,
         -0.029190853592816417,
         0.013220611036067996,
         0.06276009805924601,
         -0.0842942754640433,
         0.023092292011108448,
         -0.0147047282909301,
         0.015385613120271951,
         0.03109980337603635,
         0.020408590642942648,
         -0.03564179941736295,
         -0.037964448017081376,
         0.04646643366498139,
         -0.049913902535203544,
         -0.07898264151484684,
         -0.03595385939287448,
         -0.06660636243234998,
         -0.0010556097260901558,
         0.07299806022043889,
         -0.01843941042636589,
         -0.02243921526802843,
         -0.048089941810305084,
         0.0593861570539095,
         -0.053141475773696586,
         -0.0322718623823628,
         0.07776371675945583,
         -0.04505938806942293,
         -0.04542657236052312,
         0.08551600555026412,
         0.07592397342594608,
         -0.08752102554997902,
         0.07784542818237702,
         0.011217579574004911,
         0.00945128462539575,
         0.024378447019858744,
         0.03447894855400427,
         -0.043886928656475525,
         0.04535461589384139,
         -0.12486220111822838,
         0.08885333225926698,
         0.11023495941826851,
         -0.034045453357092956,
         0.027956110528378982,
         0.048417496400895314,
         -0.10409868361778878,
         -0.1027378388132214,
         0.05443673862566423,
         -0.04560201285666386,
         0.04197832332923826,
         0.021893429410166643,
         0.009137296897951314,
         -0.043434272839861315,
         0.0553338327726448,
         -0.026991927679970606,
         -0.04077790022276594,
         0.0755115051310666,
         -0.052675909997132474,
         0.07827772359150054,
         -0.06398675235694616,
         0.009484960947907661,
         0.021385843128026216,
         -0.06696479835116778,
         -0.04722638905257963,
         0.04790466553469616,
         -0.0006782764821165986,
         -0.04580444290654442,
         -0.010837052454380424,
         0.016274886406636907,
         0.02014511160820707,
         0.016532299556404617,
         0.006443649231957222,
         -0.029198073443431338,
         -0.028453498694576463,
         0.00018952970515582427,
         -0.004233616325910997,
         -0.0005707133296698561,
         0.008153542095519089,
         -0.010514911968511299,
         -0.015384880704482781,
         -0.03982090739853025,
         0.029805224242488333,
         -0.021890468421193042,
         -0.031373253849001644,
         0.08053334233843362,
         -0.03067552641837027,
         0.011807266980458999,
         0.08987132565134726,
         -0.061414987735748744,
         -0.04821295466726836,
         0.04705194872962293,
         -0.04616123834767647,
         -0.01938124963465425,
         0.09677816386235852,
         -0.09111851910956179,
         0.11515787099736075,
         0.03563862999885153,
         0.005183714584926703,
         0.06553626266343159,
         0.07266209507226513,
         -0.07480509644657699,
         -0.018835279615353643,
         -0.0011850089960754734,
         -0.04827094620718602,
         0.02014186494132075,
         0.013395162231950091,
         -0.012372950387180198,
         0.05250487017190467,
         -0.018677988989817693,
         -0.006970171911107961,
         0.07857880064380555,
         -0.093285336092984,
         -0.027359900929286318,
         0.002712841355669208,
         -0.04814982839520517,
         0.03231151628345994,
         -0.08466327847930073,
         0.0605258746041605,
         -0.1310812476717581,
         -0.09112277253910862,
         0.030036089839859045,
         0.06313740424660906,
         0.0047719277883311656,
         0.03864099662023542,
         0.049638135123173235,
         -0.059213225047454104,
         -0.03768735202497346,
         0.004268451009790958,
         0.049497473148517795,
         -0.019957581973685662,
         0.037623549489422696,
         -0.03595116228522668,
         0.04405860600529182,
         -0.006619700077497209,
         -0.057301953208086114,
         -0.003848174617153249,
         -0.0111204064266032,
         0.11685815904611327,
         -0.05078821247474083,
         -0.03971495535745943,
         -0.030221980009966745,
         -0.03396026903901406,
         0.0002389324409809504,
         0.0754771489236689,
         0.042605253219964015,
         -0.027414070820867772,
         0.03375667125058224,
         0.048019189652801525,
         0.009961101539939406,
         0.05449887632404851,
         0.037720684770378474,
         -0.05752835697910173,
         0.0062938584966727475,
         0.05703258514733896,
         -0.04882941841596505,
         0.021780540534787347,
         0.0011159200563354821,
         -0.08308755600230253,
         0.028279523072591718,
         0.02869373913397267,
         -0.029189485342976548,
         0.0633440262404732,
         0.04245868367796351,
         -0.09273407724160332,
         0.09592284876514263,
         -0.12134922475843708,
         0.007389916709999205,
         -0.00837248610846598,
         -0.03227788933813836,
         -0.0014679338247333557,
         -0.0030198353940053685,
         0.037579074412046096,
         0.011268210436809513,
         -0.015984224943873773,
         -0.013644065043718123,
         -0.015040023484745056,
         -0.013644065043718115,
         -0.01598422494387377,
         0.011268210436809523,
         0.03757907441204611,
         -0.003019835394005365,
         -0.0014679338247333747,
         -0.03227788933813836,
         -0.008372486108465988,
         0.00738991670999923,
         -0.12134922475843711,
         0.09592284876514266,
         -0.09273407724160336,
         0.042458683677963495,
         0.06334402624047321,
         -0.029189485342976555,
         0.028693739133972666,
         0.028279523072591687,
         -0.08308755600230255,
         0.0011159200563354843,
         0.02178054053478734,
         -0.048829418415965026,
         0.05703258514733893,
         0.006293858496672765,
         -0.057528356979101754,
         0.03772068477037849,
         0.054498876324048526,
         0.009961101539939416,
         0.0480191896528015,
         0.0337566712505822,
         -0.027414070820867758,
         0.04260525321996399,
         0.07547714892366887,
         0.00023893244098094867,
         -0.03396026903901408,
         -0.03022198000996673,
         -0.03971495535745943,
         -0.050788212474740815,
         0.11685815904611328,
         -0.011120406426603217,
         -0.0038481746171532757,
         -0.05730195320808612,
         -0.006619700077497135,
         0.0440586060052918,
         -0.03595116228522667,
         0.037623549489422724,
         -0.019957581973685655,
         0.04949747314851784,
         0.004268451009790973,
         -0.037687352024973454,
         -0.0592132250474541,
         0.04963813512317322,
         0.03864099662023545,
         0.004771927788331146,
         0.06313740424660906,
         0.03003608983985903,
         -0.09112277253910865,
         -0.1310812476717581,
         0.06052587460416049,
         -0.0846632784793007,
         0.03231151628345994,
         -0.04814982839520518,
         0.002712841355669181,
         -0.027359900929286328,
         -0.09328533609298398,
         0.07857880064380554,
         -0.006970171911107961,
         -0.018677988989817745,
         0.05250487017190468,
         -0.012372950387180177,
         0.013395162231950081,
         0.020141864941320763,
         -0.04827094620718602,
         -0.00118500899607547,
         -0.01883527961535367,
         -0.074805096446577,
         0.07266209507226515,
         0.06553626266343159,
         0.0051837145849266825,
         0.035638629998851576,
         0.11515787099736075,
         -0.09111851910956176,
         0.09677816386235857,
         -0.01938124963465427,
         -0.046161238347676464,
         0.047051948729622955,
         -0.048212954667268354,
         -0.061414987735748716,
         0.08987132565134726,
         0.011807266980458968,
         -0.030675526418370284,
         0.08053334233843361,
         -0.03137325384900164,
         -0.021890468421193056,
         0.02980522424248832,
         -0.03982090739853027,
         -0.015384880704482816,
         -0.010514911968511318,
         0.008153542095519085,
         -0.0005707133296698544,
         -0.0042336163259109934,
         0.0001895297051558052,
         -0.028453498694576456,
         -0.02919807344343133,
         0.006443649231957192,
         0.01653229955640461,
         0.020145111608207082,
         0.016274886406636886,
         -0.01083705245438044,
         -0.045804442906544444,
         -0.0006782764821165969,
         0.04790466553469618,
         -0.04722638905257963,
         -0.0669647983511678,
         0.02138584312802621,
         0.009484960947907668,
         -0.06398675235694616,
         0.07827772359150055,
         -0.052675909997132474,
         0.07551150513106655,
         -0.04077790022276588,
         -0.026991927679970648,
         0.05533383277264478,
         -0.04343427283986134,
         0.009137296897951327,
         0.021893429410166636,
         0.041978323329238246,
         -0.045602012856663855,
         0.054436738625664206,
         -0.10273783881322139,
         -0.10409868361778876,
         0.048417496400895314,
         0.027956110528379007,
         -0.03404545335709298,
         0.11023495941826847,
         0.0888533322592669,
         -0.12486220111822834,
         0.04535461589384138,
         -0.04388692865647552,
         0.03447894855400428,
         0.024378447019858796,
         0.00945128462539574,
         0.011217579574004873,
         0.07784542818237702,
         -0.08752102554997904,
         0.07592397342594608,
         0.08551600555026412,
         -0.04542657236052314,
         -0.04505938806942293,
         0.07776371675945584,
         -0.032271862382362806,
         -0.05314147577369656,
         0.05938615705390951,
         -0.04808994181030507,
         -0.022439215268028438,
         -0.018439410426365908,
         0.07299806022043887,
         -0.0010556097260901558,
         -0.06660636243234998,
         -0.03595385939287443,
         -0.07898264151484681,
         -0.049913902535203586,
         0.04646643366498142,
         -0.037964448017081334,
         -0.035641799417363215,
         0.0204085906429426,
         0.03109980337603657,
         0.015385613120272146,
         -0.014704728290930079,
         0.023092292011108413,
         -0.08429427546404324,
         0.06276009805924601,
         0.013220611036067947,
         -0.029190853592816344,
         0.08374007045948487,
         0.08858004302874997,
         -0.021945414253836254,
         -0.021064286156079023,
         0.0721056097381598,
         -0.06889376577810949,
         0.03780885896773458,
         -0.060617670276494846,
         0.03251308466099494,
         0.03525674324174159,
         -0.055333832772644746,
         -0.01764877337516205,
         0.01486705102939788,
         -0.006629019292800738,
         0.0067481936481842975,
         -0.006748193648184256},
        {-0.0030903327137056387,
         0.003090332713705608,
         0.0002854385353938031,
         0.0027407433313844593,
         -0.004761053653945634,
         -0.018366919111575092,
         0.01349887840252801,
         0.008995911582637746,
         0.01071323972047302,
         -0.026563334782967237,
         0.010169714351023772,
         -0.009866000709694,
         0.0010846555144766418,
         0.018366408954578764,
         -0.019412263081896374,
         0.01814525965792726,
         0.014066141066394708,
         -0.00971661073915614,
         -0.03569557551214036,
         0.009957856815492747,
         -0.007409856886699253,
         0.033136391103334384,
         -0.009986637424007482,
         0.026592115391481895,
         -0.024472228761105098,
         -0.046783865995490635,
         0.02573080866250004,
         -0.01866140886530969,
         -0.021417371386049627,
         0.06966466979881149,
         -0.008280574960632281,
         -0.013942738745482549,
         0.05212901336952988,
         -0.07279160094574022,
         0.08053490254606352,
         -0.08361624037533728,
         0.08228179282957063,
         -0.019448048699323137,
         -0.05724578039065096,
         0.06998570882262989,
         -0.008160772318123757,
         -0.0641343830874394,
         0.056990316395280655,
         0.043093396213663517,
         -0.012687408880781249,
         -0.008708339995032299,
         0.07973525337114522,
         -0.12841484326694644,
         -0.10869171762301431,
         0.1414001986821621,
         -0.10406858025203154,
         0.08130391229326298,
         -0.043013845351760935,
         -0.013004840122273154,
         0.0298335748789256,
         0.009126508092010452,
         -0.025086817321918524,
         0.0009178601557316187,
         0.0279662452352548,
         -0.007258982672844987,
         -0.08116335280203345,
         0.09801966007688737,
         -0.04657201572181574,
         -0.0342029944135762,
         0.07662882603148118,
         -0.1354895619401863,
         0.13277690846400675,
         0.018366919111575127,
         -0.009714009260523421,
         -0.012780780724642385,
         -0.007213809113862266,
         0.02382259145158278,
         -0.009193529839082762,
         0.00951641132737289,
         -0.004726805388784362,
         -0.016962066639546927,
         0.025243339126986508,
         -0.0038563945945399797,
         -0.015393197112797305,
         0.01924959170733728,
         0.014064305543192289,
         -0.0021573160074953622,
         -0.014397817849531062,
         -0.04383860975417856,
         0.03296649577504765,
         -0.028571372208276394,
         0.03692919425364772,
         0.06716430065154266,
         -0.022976101515042948,
         -0.0009671266508532064,
         0.023148913672648732,
         -0.0659091839713866,
         -0.022069809009113636,
         0.008647648852911466,
         -0.037354202866507584,
         0.07260577554661336,
         -0.07765915547149219,
         0.10554290954437123,
         -0.06504337936210752,
         -0.013535636220228181,
         0.10915889682867475,
         -0.07206716305906467,
         -0.03664125275511732,
         0.07687219165384417,
         -0.05647755452212011,
         -0.09797085704123655,
         0.03659189629097571,
         0.0020072836018245354,
         -0.04856906207093625,
         0.10902812228898545,
         0.06670429596869275,
         -0.04638528403030678,
         0.04060997547765051,
         -0.04274009250355749,
         -0.02073823185601222,
         0.04543997541795805,
         -0.05835680779797934,
         -0.011224905667894159,
         0.017923717963550533,
         0.000675090736621327,
         -0.01670016466563792,
         0.01172634705996584,
         0.032025825178308626,
         -0.0007681992724336536,
         -0.024413578607228547,
         0.06253412507157845,
         -0.05238164707846388,
         0.048499714052017306,
         -0.05523674113340453,
         0.05181571142826655,
         -0.0214736051749545,
         -0.05610574777542507,
         0.09762388505775386,
         -0.09248155627266663,
         0.0021020250546945987,
         0.06748445321803484,
         -0.04815747905986177,
         -0.020943173078838334,
         0.11536470931914479,
         -0.09044826963854427,
         0.02166317746331747,
         0.021182679431852786,
         -0.07524408601913177,
         0.07247932337113384,
         -0.04431495074792832,
         0.04163880025737154,
         -0.027128275740336404,
         -0.01184779365562714,
         0.007285975415891763,
         -0.01793297174543041,
         0.005444360985246277,
         -0.003694231195907053,
         0.03373007961068742,
         0.035237766779272046,
         -0.040990151621490514,
         0.02086179136581479,
         -0.04157013109382,
         -0.06260953915388832,
         0.015716596407363434,
         0.022478527632077017,
         -0.022550042314745417,
         0.03320352327599008,
         0.03778703482240923,
         -0.021216141665057017,
         0.03868309443611262,
         -0.07359719254026807,
         0.07280738161368595,
         -0.07576860533338498,
         0.02275074220541588,
         0.0560200934829622,
         -0.13169027323279134,
         0.05302181619358987,
         0.05822874028706219,
         -0.08047765961686966,
         0.03599535701996854,
         0.12163291956109101,
         -0.07267140980328118,
         0.021935944564071618,
         0.0263872750491407,
         -0.07411450779052063,
         -0.014134908035794999,
         -0.0019379355829055867,
         0.014150810589646132,
         -0.02544861417430612,
         0.04367541459529047,
         -0.041101679824135214,
         0.026857066440796797,
         -0.002883356057184597,
         -0.0024145106304690744,
         0.0010317331918702534,
         -0.00241451063046908,
         -0.0028833560571845966,
         0.026857066440796804,
         -0.041101679824135186,
         0.04367541459529047,
         -0.025448614174306133,
         0.01415081058964613,
         -0.0019379355829055778,
         -0.014134908035794988,
         -0.07411450779052062,
         0.026387275049140704,
         0.021935944564071618,
         -0.07267140980328118,
         0.12163291956109103,
         0.03599535701996854,
         -0.08047765961686967,
         0.05822874028706221,
         0.05302181619358988,
         -0.1316902732327914,
         0.056020093482962226,
         0.022750742205415887,
         -0.075768605333385,
         0.07280738161368594,
         -0.07359719254026811,
         0.03868309443611261,
         -0.021216141665057003,
         0.03778703482240922,
         0.033203523275990084,
         -0.02255004231474542,
         0.02247852763207702,
         0.01571659640736342,
         -0.06260953915388834,
         -0.041570131093819976,
         0.020861791365814793,
         -0.0409901516214905,
         0.03523776677927206,
         0.03373007961068744,
         -0.0036942311959070446,
         0.005444360985246276,
         -0.017932971745430404,
         0.007285975415891753,
         -0.011847793655627131,
         -0.027128275740336407,
         0.041638800257371544,
         -0.044314950747928336,
         0.07247932337113384,
         -0.07524408601913177,
         0.02118267943185279,
         0.021663177463317466,
         -0.09044826963854424,
         0.11536470931914476,
         -0.02094317307883834,
         -0.0481574790598618,
         0.06748445321803485,
         0.0021020250546946056,
         -0.09248155627266662,
         0.09762388505775386,
         -0.05610574777542505,
         -0.02147360517495448,
         0.051815711428266534,
         -0.055236741133404516,
         0.04849971405201733,
         -0.052381647078463905,
         0.06253412507157848,
         -0.02441357860722853,
         -0.0007681992724336584,
         0.03202582517830862,
         0.011726347059965853,
         -0.016700164665637927,
         0.0006750907366213247,
         0.017923717963550533,
         -0.011224905667894166,
         -0.0583568077979793,
         0.04543997541795804,
         -0.02073823185601222,
         -0.04274009250355747,
         0.04060997547765051,
         -0.046385284030306784,
         0.06670429596869279,
         0.10902812228898542,
         -0.04856906207093624,
         0.0020072836018245385,
         0.03659189629097573,
         -0.09797085704123658,
         -0.05647755452212013,
         0.07687219165384417,
         -0.03664125275511731,
         -0.07206716305906463,
         0.10915889682867475,
         -0.01353563622022819,
         -0.06504337936210752,
         0.1055429095443712,
         -0.0776591554714922,
         0.07260577554661339,
         -0.037354202866507605,
         0.008647648852911466,
         -0.02206980900911363,
         -0.06590918397138659,
         0.02314891367264874,
         -0.0009671266508531885,
         -0.022976101515042948,
         0.06716430065154269,
         0.03692919425364771,
         -0.0285713722082764,
         0.03296649577504766,
         -0.04383860975417857,
         -0.01439781784953106,
         -0.0021573160074953492,
         0.014064305543192303,
         0.01924959170733728,
         -0.015393197112797304,
         -0.0038563945945399606,
         0.0252433391269865,
         -0.016962066639546924,
         -0.004726805388784369,
         0.009516411327372893,
         -0.009193529839082773,
         0.02382259145158277,
         -0.007213809113862255,
         -0.012780780724642404,
         -0.009714009260523416,
         0.018366919111575113,
         0.13277690846400672,
         -0.13548956194018633,
         0.0766288260314811,
         -0.03420299441357618,
         -0.04657201572181571,
         0.09801966007688734,
         -0.08116335280203349,
         -0.007258982672845003,
         0.027966245235254827,
         0.0009178601557316209,
         -0.025086817321918527,
         0.009126508092010462,
         0.029833574878925594,
         -0.013004840122273152,
         -0.043013845351760935,
         0.08130391229326295,
         -0.1040685802520315,
         0.14140019868216208,
         -0.10869171762301429,
         -0.12841484326694647,
         0.07973525337114518,
         -0.008708339995032299,
         -0.01268740888078125,
         0.04309339621366352,
         0.05699031639528065,
         -0.06413438308743939,
         -0.008160772318123762,
         0.0699857088226299,
         -0.057245780390650994,
         -0.01944804869932314,
         0.0822817928295706,
         -0.08361624037533728,
         0.08053490254606353,
         -0.0727916009457402,
         0.052129013369529825,
         -0.013942738745482543,
         -0.00828057496063258,
         0.06966466979881153,
         -0.02141737138604959,
         -0.018661408865309675,
         0.025730808662499948,
         -0.046783865995490746,
         -0.02447222876110508,
         0.026592115391481937,
         -0.009986637424007435,
         0.03313639110333432,
         -0.007409856886699268,
         0.009957856815492765,
         -0.03569557551214043,
         -0.009716610739156167,
         0.014066141066394727,
         0.01814525965792725,
         -0.019412263081896378,
         0.01836640895457873,
         0.0010846555144766795,
         -0.009866000709694036,
         0.010169714351023788,
         -0.02656333478296727,
         0.010713239720473028,
         0.008995911582637768,
         0.013498878402528029,
         -0.018366919111575123,
         -0.004761053653945635,
         0.0027407433313844914,
         0.0002854385353938376,
         0.003090332713705626,
         -0.003090332713705624},
        {-0.001788844149771809,
         0.04045390849656913,
         -0.038263030798417176,
         0.029951458427096997,
         -0.07713680359585444,
         0.09422357022254857,
         0.0071873794967415305,
         -0.017971916355199374,
         0.01095805432759242,
         -0.07291184260386133,
         0.07085550918132999,
         -0.03756970149120127,
         -0.0688571658008878,
         0.12729284484996192,
         -0.12216418943670271,
         0.05348895287140121,
         0.010026975335661228,
         0.027593064812614657,
         -0.046422746325655115,
         0.0405082458417608,
         -0.06139571857388254,
         0.08559408629723889,
         0.09431741862549287,
         -0.07582863579544238,
         0.06636884518799502,
         -0.10221431998215713,
         0.05033528572507438,
         -0.06032024367736948,
         -0.0050587793092000165,
         0.07303303356978288,
         -0.03632903429298083,
         -0.029197294238684543,
         0.016916807620763398,
         -0.0605527541132262,
         0.06956450467226867,
         -0.024188949475748595,
         -0.04309867290669304,
         0.07733428731129956,
         -0.08550307340968566,
         0.00840783027633041,
         -0.06368232742099346,
         0.0009524312827834595,
         -0.002458082798640659,
         0.02159231102033123,
         0.09329670615012785,
         0.002034444379178332,
         0.05788146991172153,
         -0.05081567440179418,
         -0.048802907717190404,
         0.04461370516335414,
         -0.02544311235390982,
         0.006961698662561921,
         0.054841503155533176,
         -0.05122780077927281,
         0.01520283480556197,
         0.0016529287486009238,
         0.011072125401160414,
         -0.03514030222361232,
         0.023224921824726668,
         0.03138521046753207,
         -0.04181745675148717,
         0.05012179862051768,
         -0.006561631865949632,
         -0.014656273758049673,
         -0.04208099045910438,
         -0.042585394083287396,
         -0.0071316436316734,
         0.0742063921223283,
         -0.0049965017985895335,
         -0.029784956453946344,
         0.03769324055643952,
         -0.00658533278215328,
         0.004090416716372575,
         -0.009791417997087402,
         0.03217427070160257,
         -0.06277139867749601,
         0.12241352381371677,
         -0.16888878726567286,
         -0.019467866114662523,
         -0.018970831726857797,
         0.03624782014336847,
         0.06169715133413279,
         -0.004571968003302151,
         -0.07223843983107972,
         0.04264079634921167,
         -0.048290190930685574,
         -0.008330933315949047,
         0.11771081053058617,
         0.007209282759072718,
         -0.013167184008999128,
         -8.558040007986029e-05,
         0.006684178302149165,
         -0.008995154438463772,
         -0.0018608037709359237,
         0.01567699761614564,
         -0.009245055910181996,
         0.00882500263354703,
         -0.018349605920960285,
         -0.11234216248197607,
         0.03284180663485412,
         0.013034553034076926,
         0.010058098956466817,
         -0.06665810044342559,
         0.05770707251802335,
         0.019655133641200476,
         -0.0785486885354478,
         0.024278691900040752,
         0.007493282632765076,
         0.009182589676406384,
         -0.021014882682414478,
         0.02306711165882392,
         0.05169828532721219,
         -0.03184090570043774,
         -0.003491522560661531,
         0.0721050504995324,
         -0.06813298720299595,
         0.02850679498866032,
         0.01767491605570582,
         0.11002115141267423,
         -0.01764228196587426,
         -0.010209718644142293,
         0.03848133771922566,
         -0.08085503589994036,
         0.010573653138513994,
         -0.04947579907362275,
         0.042037400277291914,
         -0.02400511899416429,
         -0.017787751147964187,
         -0.0015221531814118825,
         0.03638039321509182,
         -0.10948190974812758,
         0.03777541698360977,
         0.00899678789956713,
         -0.01017923348174727,
         -0.06840203195600905,
         0.05093738804907085,
         0.0156767884250543,
         -0.058711398264981944,
         0.04956278694242261,
         -0.037318238982949135,
         0.022629626009996545,
         -0.048933283332077665,
         0.06197072353182158,
         -0.012239389856163952,
         0.03311816472633731,
         -0.008011641116412173,
         0.05928788663136939,
         -0.08375225454462143,
         0.019975072755728265,
         0.04935420233142852,
         -0.06320983513443539,
         -0.01400522388120034,
         -0.006814507404256203,
         0.031080616574277818,
         -0.05450091366671509,
         0.09196789317200532,
         -0.0892438024841218,
         0.05157806102008432,
         -0.03215653674542567,
         0.04725217737958835,
         -0.05957224903216116,
         0.010025984815719115,
         0.14524163020337452,
         0.03324586913385122,
         -0.02937777270870841,
         -0.03348126369709298,
         -0.018359636601053768,
         0.05434022560867155,
         0.008004214798631703,
         -0.03035516081816633,
         0.058850787418804076,
         -0.05553046965597322,
         0.025955681292534723,
         -0.03348198529071063,
         0.037035866709493756,
         -0.014688461215074096,
         -0.11304465339257314,
         -0.0026286766326951622,
         0.004070174732672564,
         0.014416284780345203,
         -0.021180207544917416,
         -0.04228892501512701,
         0.01335444618742,
         0.0027969154403510977,
         0.04948216789262566,
         0.03401473447574409,
         -0.0353839601604491,
         -0.009383409091212361,
         0.048363940591311855,
         0.018820394373557318,
         -0.055321774665989254,
         0.018820394373557325,
         0.04836394059131187,
         -0.00938340909121235,
         -0.03538396016044908,
         0.03401473447574412,
         0.04948216789262564,
         0.0027969154403510777,
         0.013354446187420004,
         -0.04228892501512702,
         -0.02118020754491741,
         0.014416284780345207,
         0.004070174732672568,
         -0.0026286766326951675,
         -0.11304465339257315,
         -0.01468846121507411,
         0.037035866709493756,
         -0.03348198529071063,
         0.025955681292534713,
         -0.05553046965597322,
         0.05885078741880407,
         -0.03035516081816634,
         0.008004214798631708,
         0.054340225608671584,
         -0.01835963660105378,
         -0.03348126369709297,
         -0.029377772708708443,
         0.033245869133851226,
         0.14524163020337444,
         0.010025984815719088,
         -0.059572249032161136,
         0.04725217737958838,
         -0.03215653674542572,
         0.051578061020084325,
         -0.08924380248412177,
         0.09196789317200534,
         -0.054500913666715084,
         0.031080616574277815,
         -0.006814507404256196,
         -0.01400522388120035,
         -0.06320983513443545,
         0.049354202331428516,
         0.019975072755728268,
         -0.08375225454462144,
         0.059287886631369385,
         -0.008011641116412133,
         0.033118164726337315,
         -0.012239389856163962,
         0.061970723531821544,
         -0.04893328333207764,
         0.022629626009996573,
         -0.03731823898294913,
         0.0495627869424226,
         -0.058711398264981986,
         0.01567678842505432,
         0.05093738804907083,
         -0.06840203195600904,
         -0.010179233481747292,
         0.00899678789956712,
         0.0377754169836098,
         -0.10948190974812758,
         0.036380393215091844,
         -0.0015221531814118736,
         -0.017787751147964208,
         -0.024005118994164285,
         0.04203740027729193,
         -0.04947579907362275,
         0.010573653138514,
         -0.0808550358999404,
         0.03848133771922569,
         -0.010209718644142309,
         -0.017642281965874276,
         0.11002115141267423,
         0.017674916055705824,
         0.028506794988660305,
         -0.06813298720299597,
         0.07210505049953238,
         -0.0034915225606615146,
         -0.03184090570043773,
         0.0516982853272122,
         0.0230671116588239,
         -0.021014882682414505,
         0.00918258967640638,
         0.007493282632765071,
         0.024278691900040766,
         -0.07854868853544782,
         0.01965513364120045,
         0.05770707251802333,
         -0.06665810044342561,
         0.01005809895646679,
         0.013034553034076912,
         0.03284180663485413,
         -0.1123421624819761,
         -0.01834960592096029,
         0.008825002633547026,
         -0.009245055910181982,
         0.015676997616145664,
         -0.0018608037709359078,
         -0.008995154438463767,
         0.006684178302149184,
         -8.558040007984519e-05,
         -0.013167184008999114,
         0.007209282759072729,
         0.11771081053058616,
         -0.00833093331594905,
         -0.04829019093068556,
         0.04264079634921163,
         -0.07223843983107973,
         -0.0045719680033021294,
         0.06169715133413282,
         0.036247820143368435,
         -0.0189708317268578,
         -0.019467866114662526,
         -0.1688887872656728,
         0.12241352381371677,
         -0.06277139867749604,
         0.0321742707016026,
         -0.009791417997087402,
         0.004090416716372608,
         -0.006585332782153256,
         0.03769324055643955,
         -0.029784956453946333,
         -0.004996501798589541,
         0.07420639212232831,
         -0.007131643631673402,
         -0.04258539408328741,
         -0.04208099045910437,
         -0.014656273758049659,
         -0.0065616318659496445,
         0.05012179862051762,
         -0.04181745675148716,
         0.03138521046753208,
         0.023224921824726658,
         -0.035140302223612314,
         0.011072125401160428,
         0.0016529287486008828,
         0.015202834805561956,
         -0.051227800779272824,
         0.05484150315553318,
         0.006961698662561905,
         -0.02544311235390983,
         0.0446137051633541,
         -0.04880290771719041,
         -0.050815674401794186,
         0.057881469911721536,
         0.00203444437917836,
         0.09329670615012786,
         0.021592311020331253,
         -0.0024580827986406626,
         0.0009524312827834562,
         -0.06368232742099346,
         0.008407830276330422,
         -0.0855030734096857,
         0.0773342873112995,
         -0.043098672906693065,
         -0.02418894947574857,
         0.0695645046722687,
         -0.06055275411322619,
         0.016916807620763433,
         -0.029197294238684546,
         -0.03632903429298082,
         0.07303303356978288,
         -0.005058779309200003,
         -0.06032024367736961,
         0.0503352857250744,
         -0.10221431998215716,
         0.06636884518799503,
         -0.0758286357954423,
         0.09431741862549287,
         0.08559408629723891,
         -0.06139571857388256,
         0.04050824584176077,
         -0.04642274632565511,
         0.027593064812614736,
         0.010026975335661298,
         0.053488952871401256,
         -0.12216418943670242,
         0.12729284484996203,
         -0.06885716580088783,
         -0.03756970149120124,
         0.07085550918132986,
         -0.07291184260386122,
         0.010958054327592223,
         -0.01797191635519948,
         0.007187379496741394,
         0.09422357022254865,
         -0.07713680359585437,
         0.02995145842709686,
         -0.03826303079841725,
         0.040453908496569116,
         -0.0017888441497717897},
        {-0.018413520582533975,
         0.01841352058253402,
         0.018094789416977834,
         -0.0037479799548203355,
         -0.011974363779984907,
         0.008467994640754716,
         0.0061275461237501215,
         -0.016498679130985856,
         -0.05072716762833544,
         0.07303667828628096,
         -0.05817009557056214,
         0.05434626057589667,
         -0.033927925708282666,
         -0.02264605957628747,
         0.07576314144626975,
         -0.009435426864210842,
         -0.02677076856163154,
         0.025835062418606773,
         0.0716514609473659,
         -0.06247207851321,
         0.04167185522186363,
         0.002390654931405608,
         -0.028554863296482078,
         0.017990263523411237,
         0.0018092516918445552,
         -0.0686318515216656,
         -0.0003191073293805913,
         0.057561981288099195,
         -0.04960491036866599,
         -0.044994860250012994,
         -0.02837422720964377,
         0.03993021787097645,
         0.03534066146966337,
         0.01787829482215664,
         -0.0730355153810669,
         -0.13361223762809896,
         0.032602849580610715,
         0.011990934110442669,
         0.02157310345589718,
         0.12623832626367018,
         0.03447463415999222,
         -0.038522620444120914,
         0.008541422810267058,
         -0.0371788423585204,
         -0.04218181809840137,
         0.006611996663672708,
         -0.03272039007077093,
         0.09228606668870509,
         0.008244641744032352,
         0.01827664451717911,
         -0.04752570412645966,
         0.06496953012440333,
         -0.12315640203028014,
         0.09363601767606324,
         0.02198433523617875,
         -0.047587972293696816,
         0.10162911110521132,
         -0.0050928242860008134,
         -0.09833375009336849,
         0.04983544480600804,
         -0.06795520125704012,
         -0.07429234254295049,
         0.11083875470995251,
         -0.02385686308115642,
         0.08992649973728878,
         -0.018163908563858088,
         -0.05587221078117066,
         -0.008467994640754671,
         0.016424318773971915,
         -0.0060531857667361615,
         0.05518424310907962,
         -0.06928869833146059,
         0.04759259445282505,
         -0.07650776111325104,
         0.020423455519049637,
         0.03921074258401699,
         -0.06109760081855612,
         0.0030879960205780037,
         0.016814686169036495,
         -0.01990268218961449,
         -0.03313160161925432,
         -0.0025678063831375206,
         0.04041280790446467,
         0.0048536354506224745,
         0.030176218557672472,
         -0.03066862499303139,
         -0.006735486958508356,
         0.029710247589372143,
         -0.012402382502640294,
         -0.0012100430382778575,
         0.01272586344687981,
         -0.020655917116085134,
         0.07095738468055333,
         -0.06530396510542304,
         -0.09825069171048832,
         0.05555171401458845,
         0.006771121728782808,
         0.07295820110066124,
         -9.685362408938915e-05,
         -0.0018788154978770589,
         -0.07967481051260362,
         -0.0883685460742284,
         -0.009321756606922554,
         0.0025573399237756762,
         0.015301111910278766,
         0.08872020506104268,
         0.12061292423303605,
         -0.0782059253081476,
         0.030328748129233692,
         -0.018427116259214744,
         -0.008834113958984919,
         -0.04771093000066837,
         0.07165688995649935,
         0.05538807877920846,
         0.025989217851349226,
         -0.05718268724261861,
         0.04104398983861411,
         0.026590467257307505,
         -0.05016967767426853,
         -0.0023428017640608977,
         0.051613747801250436,
         -0.025873951759030938,
         -0.0505759410682209,
         0.07263809632022787,
         -0.04139904659894147,
         -0.03979178405929516,
         -0.04487653101897139,
         0.05014002948947558,
         -0.024434286025952132,
         -0.07506711281686802,
         0.0925275336475855,
         -0.06849454018826585,
         0.03622252715197677,
         -0.006686405117773202,
         -0.03860409096897067,
         0.04239234976451375,
         -0.016230811550914073,
         -0.08302004067585565,
         0.029186645412428484,
         -0.027243156671869825,
         -0.009078029845711414,
         0.07771687599349823,
         0.06759362702960484,
         -0.026596122305440856,
         -0.025747973222644126,
         -0.09197311079158342,
         0.08659311217140672,
         0.0043927504787701415,
         -0.023239363868872414,
         0.029217746397338026,
         -0.0445567224402709,
         0.06291730882302209,
         -0.07453632816577328,
         0.0033211055038221988,
         -0.01708350836788827,
         0.02345489787632676,
         0.007792889790918442,
         0.03821000978816613,
         0.05217137275311867,
         -0.05864620209953739,
         0.0002846155934906108,
         0.06675146787244814,
         -0.0872078566396647,
         0.07903309887181399,
         0.11456760716070619,
         -0.050462569438730565,
         -0.027281247443632983,
         -0.044680234932029446,
         -0.0004597191076649024,
         0.0021183273943616112,
         0.04599748956664737,
         0.060147253748486985,
         -0.014690935792489089,
         -0.0010769374848874978,
         0.010476391161527467,
         -0.06635521728732735,
         -0.13474473689951091,
         0.09181835084906574,
         -0.04184456853783567,
         0.024901977966694234,
         0.01809808313382939,
         -0.002262852310561691,
         -0.011881522591672992,
         -0.030095588169381477,
         -0.0012227243864505056,
         -0.0020188090146893486,
         0.03185969894520662,
         0.0022079570675935314,
         1.816615595313416e-05,
         0.0017611309622516693,
         1.8166155953129847e-05,
         0.0022079570675935336,
         0.03185969894520662,
         -0.002018809014689343,
         -0.0012227243864505065,
         -0.03009558816938146,
         -0.011881522591672994,
         -0.002262852310561698,
         0.018098083133829396,
         0.024901977966694237,
         -0.041844568537835664,
         0.09181835084906576,
         -0.13474473689951097,
         -0.06635521728732732,
         0.010476391161527465,
         -0.0010769374848874965,
         -0.01469093579248908,
         0.06014725374848698,
         0.045997489566647363,
         0.0021183273943616125,
         -0.00045971910766490367,
         -0.04468023493202944,
         -0.02728124744363299,
         -0.05046256943873056,
         0.11456760716070612,
         0.07903309887181402,
         -0.08720785663966471,
         0.06675146787244811,
         0.0002846155934906185,
         -0.05864620209953737,
         0.052171372753118665,
         0.038210009788166126,
         0.00779288979091844,
         0.023454897876326757,
         -0.017083508367888287,
         0.0033211055038221914,
         -0.07453632816577328,
         0.0629173088230221,
         -0.04455672244027092,
         0.029217746397338012,
         -0.023239363868872428,
         0.004392750478770152,
         0.0865931121714067,
         -0.09197311079158338,
         -0.02574797322264414,
         -0.026596122305440846,
         0.06759362702960484,
         0.07771687599349826,
         -0.009078029845711417,
         -0.027243156671869804,
         0.029186645412428474,
         -0.08302004067585565,
         -0.016230811550914073,
         0.04239234976451373,
         -0.038604090968970654,
         -0.006686405117773208,
         0.036222527151976755,
         -0.06849454018826587,
         0.09252753364758551,
         -0.07506711281686802,
         -0.02443428602595214,
         0.05014002948947558,
         -0.044876531018971384,
         -0.03979178405929516,
         -0.04139904659894145,
         0.07263809632022783,
         -0.050575941068220914,
         -0.025873951759030924,
         0.051613747801250436,
         -0.0023428017640608964,
         -0.05016967767426851,
         0.026590467257307522,
         0.04104398983861413,
         -0.057182687242618574,
         0.025989217851349236,
         0.0553880787792085,
         0.07165688995649935,
         -0.04771093000066838,
         -0.008834113958984913,
         -0.01842711625921473,
         0.030328748129233713,
         -0.07820592530814759,
         0.12061292423303602,
         0.08872020506104271,
         0.015301111910278763,
         0.002557339923775679,
         -0.00932175660692256,
         -0.08836854607422838,
         -0.07967481051260364,
         -0.0018788154978770445,
         -9.685362408940863e-05,
         0.07295820110066126,
         0.006771121728782812,
         0.05555171401458843,
         -0.09825069171048835,
         -0.06530396510542302,
         0.07095738468055332,
         -0.02065591711608514,
         0.012725863446879824,
         -0.0012100430382778712,
         -0.012402382502640294,
         0.02971024758937216,
         -0.006735486958508363,
         -0.0306686249930314,
         0.030176218557672455,
         0.004853635450622491,
         0.04041280790446467,
         -0.002567806383137521,
         -0.0331316016192543,
         -0.01990268218961448,
         0.016814686169036475,
         0.0030879960205779703,
         -0.061097600818556114,
         0.03921074258401701,
         0.02042345551904963,
         -0.07650776111325104,
         0.04759259445282504,
         -0.06928869833146059,
         0.05518424310907962,
         -0.006053185766736156,
         0.016424318773971918,
         -0.008467994640754687,
         -0.05587221078117067,
         -0.018163908563858088,
         0.08992649973728871,
         -0.023856863081156417,
         0.11083875470995251,
         -0.07429234254295052,
         -0.06795520125704008,
         0.049835444806008024,
         -0.09833375009336842,
         -0.005092824286000801,
         0.10162911110521132,
         -0.047587972293696816,
         0.02198433523617876,
         0.0936360176760632,
         -0.12315640203028014,
         0.06496953012440333,
         -0.04752570412645965,
         0.018276644517179103,
         0.008244641744032338,
         0.09228606668870513,
         -0.032720390070770926,
         0.0066119966636727055,
         -0.042181818098401394,
         -0.03717884235852041,
         0.008541422810267044,
         -0.03852262044412091,
         0.03447463415999218,
         0.1262383262636702,
         0.021573103455897198,
         0.01199093411044268,
         0.032602849580610715,
         -0.13361223762809896,
         -0.07303551538106691,
         0.017878294822156648,
         0.0353406614696634,
         0.03993021787097647,
         -0.028374227209643766,
         -0.04499486025001299,
         -0.049604910368666016,
         0.05756198128809944,
         -0.00031910732938051533,
         -0.06863185152166551,
         0.0018092516918445294,
         0.01799026352341117,
         -0.028554863296482044,
         0.0023906549314056304,
         0.041671855221863625,
         -0.06247207851321005,
         0.071651460947366,
         0.02583506241860671,
         -0.026770768561631596,
         -0.00943542686421085,
         0.0757631414462698,
         -0.022646059576287465,
         -0.03392792570828274,
         0.054346260575896685,
         -0.05817009557056217,
         0.07303667828628091,
         -0.05072716762833542,
         -0.016498679130985842,
         0.006127546123750086,
         0.00846799464075469,
         -0.011974363779984886,
         -0.0037479799548203363,
         0.018094789416977796,
         0.01841352058253404,
         -0.01841352058253402},
        {-0.0037174113432043663,
         0.0948966309578146,
         -0.09034375048037219,
         -0.09885409010686508,
         0.026174408916650044,
         0.052394047987162545,
         0.043683166747445434,
         -0.09455368943961134,
         0.0447703663427384,
         0.01895731105402368,
         -0.002310354234287937,
         0.030881393365701088,
         0.05433973940555947,
         0.013344461903126437,
         -0.03282938095834727,
         -0.041189035833396156,
         -0.07582304094297676,
         0.08772379925540086,
         -0.06540149275250184,
         -0.012867370830342562,
         0.024124119408035327,
         0.0009338653952104536,
         -0.014148985291058328,
         0.009870274114583886,
         -0.03168403928833097,
         -0.005945349012009609,
         -0.01643054764317375,
         -0.03597278421548228,
         0.014569277244978661,
         0.044130013462270586,
         0.012261395944255266,
         -0.08014248260784615,
         0.17300636313607115,
         0.01878350853226827,
         -0.05030179637082713,
         -0.0347863664755379,
         0.012932289734246673,
         -0.023084514836248706,
         0.049262191799040594,
         -0.006369910092595105,
         -0.017333697356246656,
         0.018823838999496665,
         -0.005609598277831843,
         -0.011968554232877758,
         0.027051604661100934,
         0.03745692631637885,
         -0.009980268236925863,
         -8.791193825037447e-06,
         -0.04206868645992926,
         0.10234036832535234,
         -0.045198358634955395,
         -0.10435479869035642,
         -0.11993763198924229,
         0.02576912280805567,
         0.052206427232233565,
         0.07098191628668188,
         0.09091099463427874,
         0.043049715297150834,
         -0.049970410669034133,
         -0.0424584277361219,
         -0.038106400104943705,
         -0.09400907707519447,
         0.018338774527893453,
         0.03621185395536846,
         0.01961901343462477,
         0.04617463773868225,
         -0.04452612564744842,
         0.018330081268106518,
         -0.039130286270002985,
         -0.017953061295107948,
         0.06959509006358311,
         -0.036327383025082656,
         -0.028416935159804372,
         0.027372603710253417,
         0.06673130046890498,
         0.05345265512136479,
         -0.05162164011118851,
         -0.022980305730325896,
         0.049180713780779595,
         -0.035318293772165936,
         -0.01841530048605612,
         0.1083455231562821,
         0.023067026074585745,
         -0.09379785156801418,
         -0.060228711723731385,
         -0.04156074605867376,
         0.043582446715541255,
         0.010648743398419229,
         -0.03421651044542726,
         -0.026625817705305813,
         0.0060204070966921085,
         0.027348644130734952,
         0.026171954034567818,
         0.08625333624212486,
         -0.07066412227353575,
         -0.11468503254591746,
         0.009738669102225985,
         0.12156081991188984,
         0.01724938807600581,
         -0.000494447138293946,
         -0.052008509053070674,
         0.013939303574869069,
         0.051808889873549084,
         0.014978801630940303,
         0.019017346498650244,
         0.015278625587781165,
         -0.03944736100384186,
         0.006528153454578391,
         0.03843711773020572,
         -0.07188088827847679,
         -0.004868001418546705,
         -0.022969782303071447,
         0.0026362744775575517,
         -0.07274749080311962,
         0.08109387072023785,
         0.04532687694088915,
         -0.016146810389124928,
         -0.02057597763428715,
         -0.08261392742920834,
         -0.05076376415167343,
         0.024779761785250654,
         0.0031531464840223516,
         0.011344996125942607,
         0.05506200911556562,
         -0.024542579844160514,
         -0.014674310625512582,
         0.007366622597081345,
         -0.08206954790583411,
         0.056760174955286374,
         0.03320211791369766,
         -0.0054032092535592005,
         -0.07275303319992867,
         0.10750482939160216,
         0.05682608821443386,
         0.008594857557801119,
         0.035652112964762436,
         -0.03429915081755137,
         -0.08292072867587233,
         -0.02431129819095616,
         -0.01882357491932854,
         -0.013984233887466693,
         0.0688514633899781,
         0.05653654175524626,
         0.050623722745525325,
         -0.022284476818614604,
         -0.07857022130929435,
         -0.01202602511136728,
         0.02207645262214391,
         -0.008206139699411088,
         0.07874007235446294,
         -0.022609315229781036,
         -0.034183304895739605,
         -0.032582752683896835,
         -0.020382068670186566,
         0.031018041547469306,
         0.04836841610344564,
         0.012631271740255584,
         -0.017303925228754565,
         -0.02654821488375246,
         -0.08619864467429932,
         -0.0067466568204183845,
         0.04805490674291916,
         -0.002605969927937324,
         -0.09757195478254195,
         0.0455442675075656,
         0.04165780316180136,
         0.01106760081598426,
         -0.00934766785781969,
         -0.0653661995085565,
         -0.06947558209354804,
         0.06194466136659352,
         0.0692098045947258,
         0.025305311112528327,
         0.09749837074462865,
         -0.025954688965759865,
         -0.0898858093050625,
         0.009383387442433696,
         0.043149399456177844,
         -0.0178317071215921,
         0.03851183705104981,
         -0.03883138399262964,
         0.03035638301827322,
         -0.023316404407015243,
         0.044157619243826246,
         0.01634177374967384,
         0.03906883805250539,
         -0.0408373434928595,
         -0.11492414585247175,
         0.01672097116850506,
         0.022195343271872895,
         0.008705847907463751,
         0.022195343271872902,
         0.016720971168505044,
         -0.11492414585247177,
         -0.04083734349285949,
         0.03906883805250539,
         0.016341773749673875,
         0.04415761924382624,
         -0.023316404407015223,
         0.030356383018273248,
         -0.038831383992629656,
         0.038511837051049824,
         -0.017831707121592096,
         0.04314939945617784,
         0.009383387442433706,
         -0.0898858093050625,
         -0.025954688965759868,
         0.09749837074462864,
         0.025305311112528327,
         0.0692098045947258,
         0.06194466136659354,
         -0.06947558209354804,
         -0.06536619950855649,
         -0.009347667857819701,
         0.011067600815984272,
         0.041657803161801364,
         0.04554426750756559,
         -0.09757195478254196,
         -0.0026059699279373386,
         0.04805490674291917,
         -0.006746656820418369,
         -0.08619864467429933,
         -0.02654821488375246,
         -0.01730392522875454,
         0.012631271740255568,
         0.04836841610344564,
         0.031018041547469302,
         -0.020382068670186597,
         -0.03258275268389685,
         -0.03418330489573959,
         -0.022609315229781036,
         0.07874007235446295,
         -0.00820613969941108,
         0.022076452622143906,
         -0.012026025111367297,
         -0.07857022130929435,
         -0.022284476818614604,
         0.050623722745525325,
         0.05653654175524624,
         0.0688514633899781,
         -0.013984233887466682,
         -0.018823574919328557,
         -0.024311298190956166,
         -0.08292072867587232,
         -0.03429915081755138,
         0.03565211296476244,
         0.008594857557801112,
         0.05682608821443387,
         0.10750482939160218,
         -0.07275303319992867,
         -0.005403209253559204,
         0.03320211791369766,
         0.05676017495528636,
         -0.0820695479058341,
         0.00736662259708133,
         -0.014674310625512596,
         -0.024542579844160528,
         0.05506200911556567,
         0.011344996125942577,
         0.003153146484022357,
         0.02477976178525065,
         -0.05076376415167341,
         -0.08261392742920835,
         -0.020575977634287167,
         -0.01614681038912491,
         0.04532687694088914,
         0.08109387072023788,
         -0.07274749080311962,
         0.002636274477557538,
         -0.02296978230307147,
         -0.004868001418546719,
         -0.0718808882784768,
         0.03843711773020571,
         0.006528153454578396,
         -0.039447361003841865,
         0.015278625587781175,
         0.019017346498650212,
         0.01497880163094028,
         0.05180888987354908,
         0.013939303574869059,
         -0.05200850905307069,
         -0.0004944471382939447,
         0.0172493880760058,
         0.12156081991188983,
         0.009738669102225985,
         -0.11468503254591746,
         -0.07066412227353577,
         0.08625333624212486,
         0.026171954034567794,
         0.027348644130734987,
         0.006020407096692096,
         -0.026625817705305817,
         -0.03421651044542726,
         0.01064874339841923,
         0.04358244671554127,
         -0.04156074605867377,
         -0.06022871172373133,
         -0.09379785156801414,
         0.02306702607458573,
         0.10834552315628214,
         -0.01841530048605608,
         -0.035318293772165936,
         0.0491807137807796,
         -0.02298030573032586,
         -0.05162164011118851,
         0.05345265512136478,
         0.066731300468905,
         0.02737260371025341,
         -0.028416935159804375,
         -0.03632738302508267,
         0.0695950900635831,
         -0.01795306129510788,
         -0.039130286270002985,
         0.018330081268106563,
         -0.04452612564744843,
         0.04617463773868227,
         0.019619013434624737,
         0.03621185395536845,
         0.018338774527893464,
         -0.0940090770751945,
         -0.03810640010494368,
         -0.04245842773612191,
         -0.04997041066903413,
         0.043049715297150834,
         0.09091099463427875,
         0.07098191628668188,
         0.05220642723223356,
         0.02576912280805567,
         -0.11993763198924229,
         -0.10435479869035645,
         -0.04519835863495538,
         0.10234036832535236,
         -0.042068686459929235,
         -8.791193825054733e-06,
         -0.009980268236925847,
         0.03745692631637886,
         0.02705160466110094,
         -0.01196855423287776,
         -0.005609598277831855,
         0.0188238389994967,
         -0.017333697356246663,
         -0.006369910092595123,
         0.0492621917990406,
         -0.023084514836248703,
         0.012932289734246654,
         -0.03478636647553788,
         -0.05030179637082712,
         0.018783508532268293,
         0.17300636313607118,
         -0.08014248260784614,
         0.012261395944255295,
         0.044130013462270586,
         0.014569277244978666,
         -0.035972784215482306,
         -0.01643054764317377,
         -0.0059453490120096025,
         -0.031684039288330995,
         0.009870274114583867,
         -0.014148985291058352,
         0.0009338653952104896,
         0.024124119408035202,
         -0.012867370830342529,
         -0.0654014927525017,
         0.08772379925540091,
         -0.07582304094297658,
         -0.04118903583339612,
         -0.032829380958347254,
         0.013344461903126487,
         0.05433973940555952,
         0.030881393365701112,
         -0.002310354234288052,
         0.018957311054023714,
         0.044770366342738295,
         -0.09455368943961133,
         0.04368316674744543,
         0.05239404798716251,
         0.026174408916650033,
         -0.0988540901068647,
         -0.0903437504803721,
         0.09489663095781456,
         -0.0037174113432044166},
        {-0.003515778224516322,
         0.0035157782245163983,
         0.0408843812288155,
         -0.046557158005494086,
         0.03514313942958008,
         -0.03296981639317291,
         0.04204033179433527,
         -0.0016607182560744176,
         -0.06117017534604109,
         0.02694495600499112,
         -0.02321036709486683,
         0.003582898755144412,
         0.015897657242147065,
         0.00011563863572754737,
         -0.00983748636297699,
         -0.11887068368022052,
         0.04162851756719888,
         0.11762177965128218,
         -0.003199748162804694,
         -0.09855411899863518,
         -0.035491960196477684,
         0.020079121356264995,
         0.05424493278619269,
         0.017364230207451422,
         0.04452449269651855,
         -0.002813455853391257,
         -0.02165380237795228,
         -0.03853465701677528,
         0.024241183786221823,
         -0.05671726551229946,
         0.12659980954038705,
         0.018986450655774586,
         -0.07035256597552353,
         -0.0914201785666883,
         -0.05847988846817198,
         0.023005324493005658,
         0.0619071663323927,
         0.12806713123293065,
         -0.010594526116260349,
         0.0022706524026383165,
         -0.05503810649328144,
         -0.0611139926253039,
         -0.08431736881507805,
         0.04276181625941895,
         0.001175113224689316,
         0.06563275222029098,
         0.022801270821887345,
         0.02670236379612488,
         -0.06244882063032843,
         -0.050115936748939036,
         0.02541711896110597,
         0.024095319270394367,
         0.10329076790489354,
         0.01227298632810855,
         0.016974786883847518,
         -0.014537345014256752,
         -0.03797859817970739,
         -0.11585915937050892,
         -0.0009802017385099303,
         -0.009215055324187158,
         0.015533886347222707,
         0.07023365886118053,
         0.09552486653473134,
         -0.031475724511530995,
         -0.013642841021188998,
         -0.09979512706300105,
         0.0038974327036637984,
         0.03296981639317314,
         -0.03773440044490886,
         -0.002645213093352314,
         0.024591725466652007,
         0.01961220200050298,
         -0.016238703684139946,
         -0.05365583498515476,
         0.00023860202283414785,
         0.02176186242848914,
         -0.033203893418000625,
         0.17855607658933495,
         -0.06950317775760197,
         -0.1090528988317328,
         0.027348052932614685,
         0.04732334158284885,
         0.07392933045577813,
         0.04674315887890837,
         -0.05416438180196188,
         -0.031172720110084762,
         -0.01626687965584218,
         -0.00013713312781683112,
         0.0034669104789187763,
         0.027582921551626543,
         -0.01999340698170094,
         0.07930166641852086,
         -0.07781030134072017,
         -0.022004654037651207,
         0.03909850612583873,
         0.07341974942086807,
         -0.028965131684642906,
         -0.04884857893850318,
         -0.0183532877359553,
         -0.021920702069031697,
         0.0019130436706115447,
         -0.020046635387718195,
         0.0025461164515667785,
         0.02568075093376977,
         0.013234836650520668,
         -0.04017954233933193,
         0.023028044336100943,
         -0.0066678697164627085,
         -0.010419881466823776,
         -0.00022750138725870228,
         -0.022251080847889106,
         -0.004050144880534295,
         0.009809211440476471,
         0.03389297190985849,
         0.0032077084439006247,
         0.0013237348099526883,
         0.0676237481228124,
         -0.011248949363593223,
         0.006560427877468165,
         -0.04196183823073617,
         -0.042007569291094976,
         -0.03256273371466523,
         0.0360584545187311,
         0.006390276615383506,
         0.05979017670698574,
         0.04632891327106533,
         -0.053429125094344644,
         -0.0085139891144324,
         -0.059402286638887546,
         0.05238855352105364,
         0.020537289233683264,
         0.023689131219033904,
         -0.04810427297701194,
         -0.006290780520533307,
         -0.10408606418077307,
         0.0003617959271442796,
         -0.0308055668936884,
         -0.005688695135959546,
         0.033490895557423225,
         0.10239369109671285,
         0.026104817916162412,
         0.04874498923152903,
         -0.07561586547653229,
         -0.10321677680507449,
         -0.060872567069563066,
         0.11650412663491308,
         0.09502176634759488,
         -0.17271016839790188,
         0.06756376508876213,
         0.06476678977087871,
         -0.009186916736253577,
         -0.025281732207800754,
         -0.04147912876992664,
         -0.01894754906084105,
         0.004338953050381766,
         0.001330577156916128,
         0.05663142075478409,
         0.04392177454219546,
         0.04074048323694732,
         -0.044521825590223996,
         0.021673551462452405,
         -0.037638674043307264,
         -0.011231017695647019,
         -0.03474445296504275,
         0.003056618699148538,
         0.025047335035344162,
         0.06408870006059747,
         -0.02524263287301982,
         0.002864736240557988,
         -0.054592964951151214,
         -0.05957549447054753,
         -0.018007025288677675,
         0.010621915391585222,
         0.03713498983937602,
         0.04754428352257739,
         -0.011288145531903538,
         -0.025746796158526306,
         -0.02438196231408269,
         0.0028303668968981776,
         -0.04819748966367931,
         0.06813758561748003,
         0.025601740297718858,
         0.035845373583807,
         -0.024142899097193964,
         -0.09019796669994237,
         -0.0291728511751568,
         -0.040571660108781105,
         0.07118028243777738,
         0.04913144109338634,
         0.05655507710195336,
         0.049131441093386366,
         0.0711802824377774,
         -0.04057166010878105,
         -0.029172851175156795,
         -0.0901979666999424,
         -0.02414289909719397,
         0.03584537358380695,
         0.02560174029771889,
         0.06813758561748001,
         -0.048197489663679316,
         0.002830366896898182,
         -0.02438196231408266,
         -0.025746796158526302,
         -0.011288145531903548,
         0.04754428352257743,
         0.03713498983937603,
         0.010621915391585253,
         -0.01800702528867764,
         -0.05957549447054752,
         -0.05459296495115119,
         0.0028647362405579743,
         -0.025242632873019775,
         0.06408870006059746,
         0.02504733503534415,
         0.0030566186991485347,
         -0.03474445296504275,
         -0.011231017695647017,
         -0.03763867404330723,
         0.021673551462452388,
         -0.044521825590224065,
         0.04074048323694729,
         0.043921774542195466,
         0.056631420754784084,
         0.0013305771569161419,
         0.0043389530503817044,
         -0.018947549060841028,
         -0.04147912876992667,
         -0.025281732207800736,
         -0.009186916736253586,
         0.06476678977087864,
         0.06756376508876215,
         -0.17271016839790188,
         0.09502176634759495,
         0.11650412663491297,
         -0.06087256706956301,
         -0.10321677680507457,
         -0.07561586547653235,
         0.048744989231529104,
         0.026104817916162426,
         0.10239369109671287,
         0.03349089555742324,
         -0.005688695135959586,
         -0.030805566893688397,
         0.00036179592714424835,
         -0.10408606418077304,
         -0.006290780520533305,
         -0.04810427297701196,
         0.023689131219033977,
         0.020537289233683243,
         0.05238855352105369,
         -0.0594022866388875,
         -0.008513989114432347,
         -0.0534291250943445,
         0.04632891327106535,
         0.05979017670698574,
         0.006390276615383511,
         0.036058454518731145,
         -0.032562733714665205,
         -0.042007569291095025,
         -0.041961838230736195,
         0.006560427877468165,
         -0.01124894936359323,
         0.06762374812281235,
         0.0013237348099526761,
         0.003207708443900601,
         0.033892971909858516,
         0.009809211440476476,
         -0.004050144880534319,
         -0.022251080847889078,
         -0.00022750138725869534,
         -0.01041988146682378,
         -0.006667869716462671,
         0.02302804433610093,
         -0.040179542339331985,
         0.01323483665052061,
         0.025680750933769758,
         0.0025461164515668067,
         -0.020046635387718167,
         0.0019130436706116007,
         -0.021920702069031732,
         -0.01835328773595532,
         -0.04884857893850321,
         -0.02896513168464285,
         0.07341974942086808,
         0.03909850612583868,
         -0.022004654037651228,
         -0.07781030134072002,
         0.07930166641852086,
         -0.019993406981701007,
         0.027582921551626543,
         0.0034669104789187763,
         -0.00013713312781682765,
         -0.016266879655842195,
         -0.03117272011008474,
         -0.05416438180196191,
         0.04674315887890839,
         0.07392933045577821,
         0.04732334158284885,
         0.02734805293261471,
         -0.10905289883173276,
         -0.06950317775760201,
         0.17855607658933487,
         -0.033203893418000584,
         0.0217618624284891,
         0.00023860202283417647,
         -0.053655834985154784,
         -0.01623870368413997,
         0.019612202000502933,
         0.024591725466651993,
         -0.002645213093352316,
         -0.03773440044490885,
         0.03296981639317312,
         0.003897432703663876,
         -0.099795127063001,
         -0.013642841021188998,
         -0.03147572451153097,
         0.09552486653473137,
         0.07023365886118052,
         0.015533886347222645,
         -0.009215055324187173,
         -0.0009802017385098904,
         -0.1158591593705089,
         -0.037978598179707355,
         -0.01453734501425671,
         0.01697478688384755,
         0.012272986328108535,
         0.10329076790489358,
         0.02409531927039437,
         0.0254171189611059,
         -0.050115936748939105,
         -0.06244882063032842,
         0.02670236379612485,
         0.022801270821887314,
         0.065632752220291,
         0.0011751132246893183,
         0.04276181625941898,
         -0.08431736881507812,
         -0.061113992625303926,
         -0.05503810649328148,
         0.0022706524026383165,
         -0.010594526116260416,
         0.12806713123293065,
         0.061907166332392766,
         0.02300532449300563,
         -0.05847988846817198,
         -0.09142017856668826,
         -0.07035256597552351,
         0.01898645065577466,
         0.12659980954038705,
         -0.05671726551229944,
         0.02424118378622181,
         -0.03853465701677532,
         -0.021653802377952263,
         -0.002813455853391325,
         0.04452449269651859,
         0.017364230207451467,
         0.05424493278619269,
         0.020079121356265193,
         -0.03549196019647792,
         -0.09855411899863524,
         -0.003199748162804876,
         0.11762177965128218,
         0.041628517567199375,
         -0.11887068368022044,
         -0.009837486362977169,
         0.00011563863572752915,
         0.015897657242146982,
         0.003582898755144401,
         -0.02321036709486669,
         0.026944956004991128,
         -0.06117017534604097,
         -0.0016607182560743061,
         0.04204033179433549,
         -0.032969816393173194,
         0.03514313942958011,
         -0.046557158005494065,
         0.040884381228815526,
         0.0035157782245163176,
         -0.0035157782245163263},
        {0.007488573043203673,
         -0.14446649590664512,
         0.13529490447794001,
         0.0932113287215135,
         0.03030639909937588,
         -0.13521289816805282,
         0.019421251732702538,
         0.07407002897594919,
         -0.10534468047478565,
         0.03608795398739775,
         0.009551071229443708,
         -0.012921563451433582,
         -0.05234429412744101,
         -0.06519087692971487,
         0.03264738868180543,
         0.09429480019496744,
         -0.03584372618870685,
         0.020491943275357305,
         -0.008434295542283171,
         -0.09677487459978024,
         0.002710240802183461,
         0.11156607366859499,
         0.029412533352109544,
         0.038303145402933746,
         -0.05056445743456076,
         -0.057358803605377026,
         0.012425770422375599,
         0.022270102004711034,
         0.011646387664730879,
         -0.0030080697347519047,
         -0.05512019959755202,
         -0.05006897533787922,
         0.09396839515906227,
         0.03128454502642147,
         -0.013344013168391042,
         -0.05739523669251085,
         0.05183471897330945,
         0.016724639048130905,
         -0.006090866681923336,
         -0.04919766515540707,
         -0.037704420920236834,
         -0.061802734679978336,
         0.006774950228913749,
         0.04988037388757029,
         0.08062411474079803,
         0.02248602232234306,
         0.009831859208617134,
         -0.0270099705712116,
         -0.01311593297361558,
         0.051406463575100536,
         -0.012890827282103662,
         -0.06619955696147237,
         -0.062207898659462905,
         -0.00650220375829705,
         0.027922861287310377,
         0.07811580566813697,
         0.013828275700502551,
         0.010525810169412897,
         -0.017679217011165097,
         -0.005270472455468245,
         -0.041203794755797385,
         0.02076831117585747,
         0.022978656322042167,
         -0.010831163008740628,
         -0.030159978431763518,
         -0.035317015411588354,
         0.0020465485828742784,
         0.03533463369902325,
         -0.028592843161407644,
         0.09537599793042442,
         -0.06784563295318999,
         0.04763531724066624,
         -0.03068587890011452,
         -0.017567278765285473,
         -0.06181580267982803,
         -0.0651380586591058,
         0.06544790261893998,
         0.07130650338234847,
         0.024478168088480422,
         -0.13523554227616422,
         0.11992896561638874,
         -0.01639089333155628,
         0.016257672471569028,
         0.008205999160475515,
         -0.027877091815270313,
         -0.02950628345264908,
         0.03050510918274796,
         -0.008219281082620192,
         0.03712589552954712,
         0.10491129309299213,
         0.025593616766202087,
         -0.1305954040669107,
         -0.026786618427784833,
         0.07667350367424894,
         -0.0708092883129698,
         0.055111542839374666,
         0.0009660104359841361,
         -0.05601559455623668,
         0.019017375745429672,
         0.026060524286586492,
         -0.04549710954261324,
         -0.006135487918539468,
         0.004339992376364735,
         -0.02290163390995123,
         -0.004926994184259063,
         0.06120470115590868,
         0.013735032163649484,
         -0.06223551294437304,
         -0.05358056592025272,
         0.022500587351337312,
         0.07419194097525535,
         -0.02136928784062245,
         -0.017664579370688306,
         0.008507483610023424,
         -0.0395919936380511,
         -0.028922745476429545,
         0.053275144827984684,
         0.05243330419684758,
         -0.019484698522962182,
         -0.007151362705517592,
         -0.0036420267046886256,
         0.0008371632399941716,
         -0.008342511128074898,
         0.05625282210201477,
         0.03458448125982397,
         -0.03154718406873984,
         -0.08722857722298925,
         -0.0020544843143152957,
         0.01899225520865685,
         0.00773900851513984,
         -0.0007519039605199597,
         -0.029116285215052204,
         0.05406467027591316,
         0.002961762208821624,
         0.045271788915083475,
         0.05728000734295038,
         -0.00458231008585128,
         -0.10585920271470363,
         -0.027651669359102418,
         -0.049789968470011485,
         -0.019381893139477562,
         0.04137292582045018,
         0.083412546116849,
         -0.013097523510549878,
         -0.01692412871860395,
         0.012434808215300764,
         0.0412077849153262,
         -0.04532245998825341,
         0.003359618128673608,
         0.03838931863826266,
         -0.006729998746498213,
         -0.12962820680752388,
         -0.005066903962368691,
         0.07871274146085137,
         0.025598624448092726,
         0.06906858698010479,
         -0.03331580411762163,
         -0.03394322254267004,
         0.020159224771627335,
         0.02995073808335366,
         -0.02120694454301272,
         -0.017038717923031337,
         -0.03635033384869686,
         0.013759513662527553,
         -0.047098642618628804,
         0.09651489276834563,
         -0.0047259153991383715,
         -0.07211937022062752,
         0.025250609401396857,
         0.0005711950580602774,
         -0.007965842369327746,
         0.006148769840684188,
         -0.011891608986743353,
         -0.010490244595157596,
         -0.016968932129018347,
         0.021631905468493966,
         0.014847165098895717,
         -0.053737365930516666,
         -0.07692434393894135,
         0.08250119994937115,
         0.054309942291153976,
         -0.1003026021316278,
         0.012087723360258509,
         0.10803834613674732,
         -0.03453692494675328,
         -0.043102175544142425,
         0.03699249571244539,
         0.009717778277928614,
         -0.00038291612776372686,
         -0.011535149945478813,
         0.028005606144974417,
         -0.011535149945478804,
         -0.0003829161277637298,
         0.009717778277928609,
         0.0369924957124454,
         -0.04310217554414242,
         -0.03453692494675327,
         0.10803834613674734,
         0.012087723360258533,
         -0.10030260213162782,
         0.054309942291153976,
         0.08250119994937119,
         -0.07692434393894135,
         -0.053737365930516666,
         0.014847165098895729,
         0.021631905468493973,
         -0.01696893212901834,
         -0.01049024459515763,
         -0.011891608986743348,
         0.006148769840684192,
         -0.007965842369327755,
         0.0005711950580602844,
         0.025250609401396864,
         -0.07211937022062748,
         -0.004725915399138381,
         0.09651489276834561,
         -0.04709864261862883,
         0.013759513662527565,
         -0.036350333848696875,
         -0.017038717923031344,
         -0.021206944543012727,
         0.029950738083353665,
         0.020159224771627342,
         -0.033943222542670036,
         -0.033315804117621604,
         0.06906858698010479,
         0.02559862444809273,
         0.07871274146085139,
         -0.00506690396236869,
         -0.12962820680752388,
         -0.006729998746498228,
         0.03838931863826267,
         0.003359618128673619,
         -0.04532245998825341,
         0.0412077849153262,
         0.012434808215300757,
         -0.01692412871860396,
         -0.013097523510549875,
         0.08341254611684902,
         0.041372925820450185,
         -0.019381893139477566,
         -0.04978996847001149,
         -0.02765166935910242,
         -0.1058592027147036,
         -0.004582310085851288,
         0.057280007342950356,
         0.04527178891508347,
         0.002961762208821629,
         0.0540646702759132,
         -0.02911628521505221,
         -0.0007519039605199627,
         0.007739008515139867,
         0.018992255208656883,
         -0.002054484314315274,
         -0.08722857722298927,
         -0.031547184068739874,
         0.03458448125982397,
         0.05625282210201479,
         -0.008342511128074919,
         0.0008371632399941622,
         -0.0036420267046886386,
         -0.007151362705517563,
         -0.019484698522962154,
         0.05243330419684755,
         0.05327514482798467,
         -0.02892274547642952,
         -0.03959199363805109,
         0.00850748361002344,
         -0.017664579370688323,
         -0.021369287840622447,
         0.07419194097525532,
         0.02250058735133735,
         -0.053580565920252746,
         -0.06223551294437302,
         0.013735032163649479,
         0.06120470115590868,
         -0.004926994184259074,
         -0.022901633909951237,
         0.004339992376364742,
         -0.006135487918539483,
         -0.045497109542613254,
         0.026060524286586482,
         0.019017375745429648,
         -0.05601559455623668,
         0.0009660104359841215,
         0.05511154283937464,
         -0.07080928831296979,
         0.07667350367424895,
         -0.02678661842778484,
         -0.13059540406691064,
         0.025593616766202098,
         0.1049112930929921,
         0.037125895529547114,
         -0.008219281082620192,
         0.030505109182747982,
         -0.029506283452649096,
         -0.027877091815270295,
         0.008205999160475536,
         0.016257672471569007,
         -0.016390893331556272,
         0.1199289656163888,
         -0.1352355422761642,
         0.024478168088480433,
         0.07130650338234848,
         0.06544790261893997,
         -0.06513805865910574,
         -0.06181580267982801,
         -0.017567278765285445,
         -0.030685878900114524,
         0.04763531724066624,
         -0.06784563295319,
         0.0953759979304244,
         -0.02859284316140763,
         0.03533463369902327,
         0.002046548582874299,
         -0.03531701541158836,
         -0.030159978431763556,
         -0.010831163008740636,
         0.02297865632204216,
         0.02076831117585744,
         -0.04120379475579738,
         -0.005270472455468247,
         -0.017679217011165115,
         0.010525810169412904,
         0.013828275700502546,
         0.078115805668137,
         0.02792286128731037,
         -0.006502203758297047,
         -0.06220789865946293,
         -0.06619955696147238,
         -0.012890827282103653,
         0.05140646357510054,
         -0.01311593297361559,
         -0.027009970571211593,
         0.009831859208617138,
         0.022486022322343056,
         0.08062411474079803,
         0.04988037388757025,
         0.00677495022891375,
         -0.061802734679978336,
         -0.03770442092023681,
         -0.04919766515540713,
         -0.0060908666819233315,
         0.01672463904813092,
         0.051834718973309456,
         -0.057395236692510856,
         -0.013344013168391058,
         0.03128454502642152,
         0.09396839515906229,
         -0.05006897533787922,
         -0.05512019959755199,
         -0.0030080697347518986,
         0.011646387664730863,
         0.022270102004711002,
         0.012425770422375599,
         -0.057358803605377005,
         -0.050564457434560776,
         0.03830314540293375,
         0.029412533352109548,
         0.11156607366859501,
         0.0027102408021834317,
         -0.09677487459978021,
         -0.00843429554228309,
         0.020491943275357357,
         -0.03584372618870681,
         0.09429480019496742,
         0.03264738868180541,
         -0.06519087692971488,
         -0.05234429412744098,
         -0.012921563451433542,
         0.0095510712294436,
         0.0360879539873977,
         -0.10534468047478554,
         0.07407002897594933,
         0.01942125173270262,
         -0.13521289816805288,
         0.030306399099375932,
         0.09321132872151341,
         0.13529490447794,
         -0.14446649590664506,
         0.007488573043203712},
        {0.028672318197349004,
         -0.02867231819734891,
         -0.13640751999942205,
         0.1383920923411886,
         -0.08958582044860758,
         0.007882847229260248,
         -0.06049646961694255,
         0.05084199290094221,
         0.05365258431211728,
         -0.020290304769871925,
         -0.010864178654953094,
         0.1094624311739049,
         -0.05130861550299024,
         -0.045121090250442364,
         0.11885829673946781,
         -0.01765296030647115,
         0.06644164393316765,
         -0.058443160342696476,
         0.001199421273732043,
         -0.008750306806966951,
         0.014745763031711281,
         -0.055981823981377604,
         0.0013837392855270403,
         0.027656872291311925,
         -0.026463326041769087,
         -0.06651693244811091,
         -0.011564794760806381,
         0.0617435918682685,
         -0.03920424328283712,
         -0.0799035200293967,
         0.026783489274095858,
         -0.005163116673865956,
         -0.0885113172284438,
         0.0002462299075816353,
         0.06245778157617645,
         0.043293351645002406,
         0.053911486389439926,
         -0.045407409490054666,
         -0.04012855001047289,
         0.04470353804348121,
         -0.02916339662371159,
         -0.026131829051255304,
         0.04388236624999803,
         0.037675692421329655,
         0.036762733833043376,
         0.0053599619120701355,
         -0.045767004706600826,
         0.06018573394080894,
         0.004292873755479813,
         -0.03204116438965132,
         0.030377168284235995,
         0.0470368975658184,
         0.026610244413056375,
         -0.0006497891176254323,
         -0.07526886855875842,
         -0.05649836050802356,
         -0.04440319019688636,
         -0.02622559852587928,
         0.06395038224091948,
         0.06836332851234038,
         0.02449253923075381,
         0.048216929288237516,
         -0.000654781688620493,
         -0.12140332840807691,
         -0.050014721020384616,
         -0.002908499772589912,
         0.049983956575144387,
         -0.007882847229260432,
         0.025380194953831665,
         -0.01572571823783153,
         0.047638661024193715,
         -0.11810178757131663,
         0.13556627376667135,
         0.05760197936463265,
         0.018221130166390213,
         -0.03478809463697224,
         -0.009138522595628138,
         0.013737525370969403,
         -0.015164168982586112,
         0.0014266436116166605,
         0.00691302837383561,
         0.04522181680680882,
         -0.06702242061506497,
         -0.10660970683473656,
         0.02081175030345375,
         0.04696310311375207,
         -0.07314162680031185,
         -0.02799615929738031,
         -0.03245854440642061,
         0.04248164008935931,
         -0.015581276966198652,
         -0.02099687037732918,
         -0.08159162475311692,
         0.08241962131588146,
         0.0255607341280362,
         0.002416840977970803,
         -0.022976684414128354,
         0.01407115636612823,
         -0.058205071946652684,
         0.01771100975183016,
         0.06349826102348366,
         0.06774832747767608,
         0.10156961159614114,
         -0.06530610834847046,
         -0.021949746182122625,
         0.06022373500201521,
         0.033056757488563265,
         -0.06802081027262546,
         0.028447952708849807,
         0.04539559433728926,
         0.05141550234654337,
         0.010174561881839782,
         -0.08651144919369867,
         0.008343573877262773,
         -0.004428312465670446,
         -0.006497069378922649,
         0.04792125671654779,
         -0.0415454200887912,
         -0.0292002574654303,
         0.04781509756804415,
         -0.02195404334353695,
         -0.07437788957101799,
         -0.07679541448356665,
         0.014145652857548591,
         0.024681906996615488,
         -0.020340464204059692,
         -0.0003702106120395265,
         0.0523968182032918,
         -0.077929120843488,
         -0.05229457268137385,
         0.008339133591104069,
         0.009514872593029692,
         0.03806458749524114,
         0.022159179708416576,
         -0.025245078470123923,
         0.00032473281167579113,
         -0.002258208225041701,
         -0.008458767427988838,
         0.07090443889468703,
         0.027448809900787578,
         -0.045401294864333426,
         0.016374393084401112,
         -0.028199320078075903,
         -0.05534299657241091,
         0.09935892895113715,
         0.06416377283638708,
         -0.05830909469467806,
         -0.004780324685137669,
         -0.006562385016273118,
         0.020997186417410867,
         -0.07866332000911856,
         0.0732954815359567,
         -0.06511697825113932,
         -0.007624019105816014,
         0.04733477027769933,
         -0.0025284642423394474,
         -0.06838481310666392,
         -0.024173050860472983,
         -0.038750658842548934,
         -0.018119149414582092,
         0.05497172646042245,
         0.02460544532733308,
         0.08275647438420429,
         -0.0948011134427733,
         -0.01730959351928571,
         -0.036422015288975144,
         0.08857246141757667,
         0.08562552209477271,
         -0.013472959194702988,
         -0.055172352394690594,
         0.07666578639189311,
         0.04215690199201254,
         -0.008832610245592171,
         -0.037154858953899396,
         0.04742859064370611,
         0.016640026077203048,
         0.016304301386588897,
         0.057997714589686764,
         -0.055348315832010456,
         -0.015529662094628242,
         0.009305870385029233,
         -0.012823960639516123,
         0.02285221214300845,
         -0.04797546437142725,
         0.03934629141280816,
         0.005129602914312884,
         -0.08844283332590311,
         -0.03769195845152799,
         -0.025653333246701295,
         0.057985072975248846,
         -0.025653333246701306,
         -0.03769195845152799,
         -0.0884428333259031,
         0.005129602914312868,
         0.03934629141280813,
         -0.04797546437142722,
         0.02285221214300846,
         -0.01282396063951614,
         0.009305870385029254,
         -0.01552966209462825,
         -0.055348315832010435,
         0.05799771458968678,
         0.0163043013865889,
         0.016640026077203055,
         0.0474285906437061,
         -0.03715485895389939,
         -0.00883261024559215,
         0.04215690199201254,
         0.07666578639189311,
         -0.05517235239469059,
         -0.013472959194702988,
         0.08562552209477269,
         0.08857246141757667,
         -0.03642201528897515,
         -0.017309593519285724,
         -0.09480111344277327,
         0.0827564743842043,
         0.02460544532733308,
         0.05497172646042245,
         -0.018119149414582078,
         -0.03875065884254892,
         -0.024173050860472965,
         -0.06838481310666392,
         -0.002528464242339452,
         0.04733477027769935,
         -0.007624019105816061,
         -0.06511697825113934,
         0.07329548153595673,
         -0.07866332000911856,
         0.020997186417410885,
         -0.006562385016273126,
         -0.004780324685137664,
         -0.05830909469467807,
         0.06416377283638705,
         0.09935892895113713,
         -0.05534299657241091,
         -0.0281993200780759,
         0.016374393084401122,
         -0.045401294864333426,
         0.027448809900787567,
         0.07090443889468705,
         -0.00845876742798883,
         -0.002258208225041671,
         0.0003247328116757889,
         -0.02524507847012394,
         0.022159179708416587,
         0.03806458749524116,
         0.009514872593029682,
         0.008339133591104077,
         -0.05229457268137384,
         -0.07792912084348799,
         0.05239681820329181,
         -0.0003702106120395281,
         -0.020340464204059685,
         0.02468190699661549,
         0.014145652857548591,
         -0.07679541448356664,
         -0.074377889571018,
         -0.021954043343536952,
         0.04781509756804414,
         -0.029200257465430268,
         -0.041545420088791175,
         0.047921256716547796,
         -0.006497069378922633,
         -0.00442831246567042,
         0.008343573877262799,
         -0.08651144919369867,
         0.010174561881839801,
         0.051415502346543386,
         0.04539559433728928,
         0.028447952708849807,
         -0.06802081027262548,
         0.033056757488563265,
         0.060223735002015236,
         -0.021949746182122625,
         -0.06530610834847048,
         0.10156961159614115,
         0.06774832747767606,
         0.06349826102348363,
         0.01771100975183019,
         -0.05820507194665269,
         0.014071156366128205,
         -0.022976684414128378,
         0.0024168409779707907,
         0.025560734128036205,
         0.08241962131588143,
         -0.08159162475311689,
         -0.0209968703773292,
         -0.015581276966198663,
         0.042481640089359285,
         -0.03245854440642064,
         -0.027996159297380314,
         -0.07314162680031183,
         0.04696310311375204,
         0.020811750303453756,
         -0.10660970683473657,
         -0.067022420615065,
         0.045221816806808826,
         0.006913028373835613,
         0.0014266436116166378,
         -0.015164168982586098,
         0.013737525370969434,
         -0.009138522595628097,
         -0.034788094636972244,
         0.018221130166390234,
         0.05760197936463264,
         0.13556627376667138,
         -0.11810178757131662,
         0.047638661024193715,
         -0.015725718237831532,
         0.025380194953831675,
         -0.007882847229260453,
         0.04998395657514436,
         -0.0029084997725898937,
         -0.050014721020384616,
         -0.12140332840807688,
         -0.0006547816886204843,
         0.04821692928823753,
         0.024492539230753795,
         0.06836332851234038,
         0.06395038224091945,
         -0.026225598525879263,
         -0.04440319019688637,
         -0.056498360508023544,
         -0.07526886855875842,
         -0.0006497891176254231,
         0.026610244413056372,
         0.047036897565818366,
         0.03037716828423599,
         -0.03204116438965132,
         0.004292873755479826,
         0.060185733940808964,
         -0.04576700470660082,
         0.005359961912070154,
         0.03676273383304339,
         0.03767569242132964,
         0.04388236624999801,
         -0.026131829051255318,
         -0.0291633966237116,
         0.04470353804348123,
         -0.04012855001047293,
         -0.04540740949005469,
         0.0539114863894399,
         0.043293351645002434,
         0.062457781576176444,
         0.00024622990758165153,
         -0.08851131722844383,
         -0.005163116673865975,
         0.026783489274095868,
         -0.07990352002939663,
         -0.03920424328283712,
         0.06174359186826848,
         -0.011564794760806423,
         -0.06651693244811092,
         -0.026463326041769077,
         0.027656872291311876,
         0.001383739285527029,
         -0.055981823981377604,
         0.014745763031711231,
         -0.008750306806966906,
         0.0011994212737320526,
         -0.058443160342696525,
         0.06644164393316758,
         -0.01765296030647121,
         0.11885829673946781,
         -0.0451210902504423,
         -0.05130861550299028,
         0.10946243117390496,
         -0.010864178654953097,
         -0.020290304769872026,
         0.053652584312117314,
         0.0508419929009424,
         -0.06049646961694256,
         0.00788284722926051,
         -0.08958582044860748,
         0.1383920923411887,
         -0.136407519999422,
         -0.02867231819734891,
         0.028672318197348994},
        {0.00884878561951558,
         -0.008848785619515505,
         -0.06688279275506193,
         0.07306557179159295,
         -0.05243278634766813,
         0.0027479869617594347,
         0.07830649522815424,
         -0.0816720781662201,
         -0.06036817156798417,
         -0.030818655523671384,
         0.11406040823378408,
         0.08070879179983714,
         0.02840328548998411,
         -0.06289774817748206,
         0.0010370537742467323,
         -0.018288770712345456,
         -0.07243450237366547,
         0.0873576901479452,
         -0.01183139762097287,
         0.007298750424298013,
         -0.011645016748209221,
         0.03193630245609455,
         0.049312229436544903,
         -0.025792324337171525,
         -0.08135604685009531,
         0.019965405242582737,
         -0.15074938653173914,
         0.08208283430889263,
         0.0018742585040687394,
         0.07821166205466051,
         0.0515241313303628,
         -0.02912505319636095,
         0.04274396469596322,
         -0.015160797580738159,
         -0.05119844440496832,
         -0.018061055064489354,
         -0.015739823424488566,
         0.02360187058092872,
         0.04357261452035059,
         -0.08245158625774526,
         0.06545794817558732,
         -0.09903035418764354,
         0.10122080794388638,
         -0.054945742974460435,
         0.057999058581637356,
         0.04994716262289409,
         -0.05117205132951404,
         -0.0408435890099972,
         -0.04140626997182872,
         -0.0008120145389099931,
         0.02444351344885046,
         0.0007509942709352016,
         -0.0022574711059068393,
         0.015299217589400501,
         0.009353550796012758,
         0.06765227889161265,
         -0.050511000208895755,
         0.0656199833253036,
         -0.10019004754753107,
         0.045161719660463215,
         -0.00040519535271078946,
         -0.0026043500509194185,
         0.017842312327888486,
         -0.00036584156291656454,
         -0.04702519240883761,
         -0.0002593357772350948,
         0.03364735916476259,
         -0.002747986961759417,
         -0.08914400003369967,
         0.09250958297176548,
         0.11641345951750062,
         -0.042246916267921576,
         -0.05079011708057061,
         0.0012055656112715174,
         -0.051007177061969645,
         0.025843850198102532,
         0.06317973239783065,
         0.01965109117224243,
         -0.009939680095142575,
         -0.009711411077099847,
         -0.007479426346474612,
         0.0321714660841402,
         -0.025405266603548488,
         -0.045887005920973306,
         0.009314976274506982,
         0.018171347192717756,
         -0.041091552651056656,
         -0.10516131947594491,
         0.06913396798580969,
         -0.05828361408118029,
         0.0737011522376836,
         -0.09682638575870436,
         0.02761935748624251,
         -0.033398159904349446,
         0.05085377730730579,
         -0.0052941858407907815,
         -0.03002367623746069,
         -0.002503194524476871,
         -0.038225341612295384,
         0.005388656602461901,
         0.06053723950906439,
         0.04908044970859749,
         -0.021751102343516,
         0.010398200948441965,
         -0.012898860108142103,
         0.07043890170820556,
         0.05974993174575574,
         0.022926476408122745,
         -0.040153311415212674,
         -0.03006294438950935,
         -0.06444161032390289,
         -0.0064262660143536935,
         0.06242569048736809,
         -0.03098126125310492,
         -0.002641116491089727,
         0.025561065949542362,
         -1.3854754722478615e-05,
         0.05139093358015129,
         0.007680036969269518,
         0.04603793314461651,
         -0.09625850232944758,
         -0.02143981726804289,
         -0.04060022514676854,
         -0.006225180488432534,
         0.03064699199764671,
         -0.0050656343965122105,
         -0.07395601975745707,
         0.0017595119386933874,
         0.06754766833397131,
         0.04996112252051757,
         0.044658251719761,
         -0.038748220396225545,
         -0.03929061853128372,
         -0.08360777588139129,
         0.06387692034304344,
         -0.09634055015811532,
         0.0946160578233831,
         -0.06466513533338973,
         -0.01664501775257272,
         -0.015314985215590734,
         0.020487228342502627,
         0.05547639046499187,
         0.0501258033899013,
         -0.018403280371941274,
         -0.051041608914727164,
         0.05785319900616165,
         -0.040950094795678675,
         -0.013801326794924408,
         0.09950343680560943,
         -0.08233652707261921,
         -0.021162533444603705,
         0.013231037245029378,
         -0.020976152571840108,
         -0.07993121627370282,
         -0.01876273600777042,
         0.047778615030662656,
         0.03275519383841264,
         0.0848795175982701,
         -0.0064248116240981585,
         0.07275169848526185,
         -0.13760662449736244,
         0.027472377428813796,
         -0.03554869142667816,
         0.025282445091150154,
         -0.03343467086568858,
         -0.01083223148971445,
         0.06514035391810902,
         0.05586962679192481,
         0.0028458252928455366,
         -0.03498815655996514,
         0.005959579745540765,
         0.07424999153284483,
         -0.006544938973886515,
         0.00970384720572808,
         -0.031898113652478764,
         0.042170623451964984,
         -0.030333722434178957,
         -0.033776830312752165,
         0.02473577325870933,
         0.048944618492577974,
         -0.0046996824610146485,
         0.01546732306839653,
         -0.004513301588251053,
         -0.017369321529723977,
         0.004638708645500779,
         -0.0011413077164458439,
         -0.030499708516881236,
         -0.09842753351811656,
         0.054340256757174056,
         -0.023599449083224963,
         0.05434025675717403,
         -0.09842753351811655,
         -0.0304997085168812,
         -0.0011413077164458539,
         0.004638708645500789,
         -0.017369321529723994,
         -0.00451330158825106,
         0.015467323068396543,
         -0.004699682461014656,
         0.04894461849257797,
         0.02473577325870932,
         -0.033776830312752165,
         -0.03033372243417895,
         0.04217062345196498,
         -0.03189811365247876,
         0.009703847205728087,
         -0.006544938973886501,
         0.07424999153284481,
         0.005959579745540749,
         -0.03498815655996516,
         0.002845825292845532,
         0.05586962679192478,
         0.06514035391810902,
         -0.010832231489714452,
         -0.03343467086568858,
         0.025282445091150137,
         -0.03554869142667816,
         0.02747237742881379,
         -0.13760662449736238,
         0.0727516984852618,
         -0.006424811624098165,
         0.08487951759827016,
         0.03275519383841261,
         0.04777861503066262,
         -0.018762736007770443,
         -0.07993121627370284,
         -0.02097615257184013,
         0.013231037245029378,
         -0.021162533444603688,
         -0.0823365270726192,
         0.09950343680560943,
         -0.013801326794924426,
         -0.0409500947956787,
         0.057853199006161656,
         -0.051041608914727185,
         -0.018403280371941277,
         0.05012580338990131,
         0.055476390464991886,
         0.020487228342502623,
         -0.015314985215590729,
         -0.01664501775257276,
         -0.06466513533338977,
         0.09461605782338317,
         -0.09634055015811534,
         0.06387692034304343,
         -0.08360777588139129,
         -0.039290618531283725,
         -0.03874822039622555,
         0.044658251719761,
         0.049961122520517584,
         0.06754766833397133,
         0.0017595119386933835,
         -0.07395601975745704,
         -0.005065634396512198,
         0.03064699199764672,
         -0.00622518048843255,
         -0.04060022514676855,
         -0.021439817268042883,
         -0.0962585023294476,
         0.046037933144616516,
         0.007680036969269529,
         0.051390933580151316,
         -1.3854754722502391e-05,
         0.025561065949542373,
         -0.002641116491089694,
         -0.03098126125310493,
         0.06242569048736807,
         -0.006426266014353698,
         -0.06444161032390293,
         -0.030062944389509346,
         -0.04015331141521267,
         0.02292647640812275,
         0.05974993174575576,
         0.07043890170820558,
         -0.012898860108142094,
         0.010398200948441988,
         -0.02175110234351598,
         0.049080449708597505,
         0.06053723950906438,
         0.005388656602461902,
         -0.038225341612295405,
         -0.002503194524476878,
         -0.030023676237460682,
         -0.005294185840790783,
         0.050853777307305795,
         -0.03339815990434941,
         0.02761935748624249,
         -0.09682638575870435,
         0.07370115223768359,
         -0.05828361408118025,
         0.0691339679858097,
         -0.1051613194759449,
         -0.04109155265105668,
         0.018171347192717752,
         0.009314976274506979,
         -0.04588700592097329,
         -0.025405266603548502,
         0.032171466084140204,
         -0.007479426346474652,
         -0.00971141107709984,
         -0.009939680095142563,
         0.01965109117224243,
         0.06317973239783062,
         0.025843850198102543,
         -0.051007177061969625,
         0.001205565611271501,
         -0.050790117080570595,
         -0.042246916267921576,
         0.11641345951750058,
         0.09250958297176545,
         -0.08914400003369966,
         -0.0027479869617594334,
         0.03364735916476255,
         -0.00025933577723506984,
         -0.04702519240883763,
         -0.0003658415629165489,
         0.017842312327888483,
         -0.0026043500509194207,
         -0.0004051953527107912,
         0.04516171966046321,
         -0.10019004754753107,
         0.0656199833253036,
         -0.050511000208895755,
         0.0676522788916126,
         0.009353550796012758,
         0.015299217589400498,
         -0.0022574711059068636,
         0.0007509942709351866,
         0.02444351344885047,
         -0.0008120145389100002,
         -0.04140626997182873,
         -0.04084358900999721,
         -0.05117205132951404,
         0.049947162622894066,
         0.057999058581637356,
         -0.05494574297446042,
         0.10122080794388638,
         -0.09903035418764354,
         0.06545794817558728,
         -0.08245158625774528,
         0.0435726145203506,
         0.023601870580928684,
         -0.015739823424488597,
         -0.018061055064489333,
         -0.051198444404968325,
         -0.015160797580738154,
         0.042743964695963234,
         -0.029125053196360964,
         0.05152413133036278,
         0.07821166205466053,
         0.0018742585040687446,
         0.08208283430889271,
         -0.15074938653173914,
         0.01996540524258276,
         -0.08135604685009529,
         -0.025792324337171543,
         0.049312229436544876,
         0.03193630245609456,
         -0.01164501674820923,
         0.0072987504242979975,
         -0.011831397620972876,
         0.0873576901479452,
         -0.07243450237366549,
         -0.0182887707123455,
         0.001037053774246714,
         -0.06289774817748195,
         0.028403285489984005,
         0.08070879179983696,
         0.11406040823378402,
         -0.030818655523671388,
         -0.06036817156798411,
         -0.08167207816622009,
         0.07830649522815433,
         0.0027479869617594295,
         -0.052432786347668105,
         0.07306557179159295,
         -0.0668827927550619,
         -0.008848785619515635,
         0.008848785619515579},
        {-0.0035988050834163763,
         0.035993005416044666,
         -0.03158538734699266,
         -0.07956340845093224,
         0.061451871034668315,
         -0.02438588181532142,
         0.009021934053300373,
         0.011598501569596409,
         -0.01904926394799296,
         -0.016596242662010506,
         -0.029872047644567586,
         0.06922904949118969,
         0.06471871594709269,
         0.016895735673691698,
         -0.04268055349801055,
         -0.0017657670820868492,
         -0.018539187597080647,
         -0.02012607833279289,
         0.027615698468060657,
         0.0021568926449128806,
         0.0078024627011236,
         -0.014937118638351201,
         -0.007297301001222166,
         0.026621851855915854,
         -0.004552266912471881,
         -0.05057502048333481,
         -0.08497034525843393,
         0.01300373082040528,
         -0.05163611751241664,
         0.09803358137993087,
         -0.04529594671873815,
         0.013047601969597034,
         0.009658172959694027,
         0.014334040616935174,
         -0.005953833482193616,
         -0.030640278986035364,
         -0.002822958524281428,
         -0.01673978196214456,
         0.014891152743214573,
         0.033418822323479314,
         0.07926236757632643,
         -0.06686763162531402,
         0.05698556173154275,
         -0.06732444756228542,
         0.08833641327114625,
         0.024804626999313135,
         0.02134056864027158,
         -0.01623296744390544,
         -0.03286043483254506,
         -0.07649225680432362,
         0.0806358972526667,
         -0.07372479960644061,
         0.0801136168722404,
         -0.03596052520551866,
         -0.025017124519698973,
         0.10564012647398739,
         -0.1268980458240892,
         0.03160226295546347,
         0.018026236987621822,
         -0.00516768776883005,
         -0.1576333376668241,
         0.07615536323634171,
         -0.0391856640604419,
         -0.025369089243230447,
         0.10472420859663516,
         -0.0824334868379088,
         0.08187711955400127,
         -0.05867652557094319,
         -0.004614315984248249,
         -0.05208194527545048,
         0.06133211019555518,
         0.0520774023236721,
         -0.035987441459153176,
         -0.006159126511722711,
         0.03272616050362049,
         -0.012595191109887284,
         -0.008196428573795876,
         0.031632250769762935,
         0.013683840875990607,
         0.001422171852822497,
         -0.019513630797865247,
         0.003479314566477739,
         0.03448037335162055,
         -0.043163275545871675,
         -0.03545522088617751,
         0.0036811676114885373,
         0.015612506711725711,
         -0.021080659276073367,
         0.0393482786285469,
         -0.1013379341930825,
         0.09482089349200669,
         -0.06602756993229073,
         0.057241745520688024,
         0.022685282333650764,
         -0.02090530867037824,
         0.004452125282404109,
         -0.009753719290256875,
         0.021998498923188732,
         0.00975309274601304,
         -0.023815933243467792,
         -0.0072814049361793675,
         0.03930612515454917,
         -0.004808531923804711,
         0.04358438254854266,
         -0.04518626793488313,
         0.04057207652884053,
         -0.012318601908891367,
         0.04158727473383853,
         0.021178065475904798,
         -0.03694381229292474,
         -0.012491985628335669,
         0.04617823259116575,
         -0.09738783869976418,
         0.09253628079307774,
         -0.09421175562938565,
         0.04942037371736961,
         0.04471146757680961,
         -0.10904313317646117,
         0.032644826164909914,
         0.07361844657037324,
         -0.08555491230670847,
         0.03596627436517104,
         0.016024946232380568,
         -0.11335472618666724,
         0.029948109841299954,
         0.05426455408424116,
         -0.09287573947295093,
         0.03071357849344715,
         -0.08813262792436434,
         0.11515514204770573,
         0.013569882350023325,
         0.013694380399579655,
         -1.647748412311118e-05,
         -0.015346056261626663,
         0.07530411394042766,
         -0.07477585753330576,
         0.05260452246939385,
         -0.06867143242969359,
         0.08742049539379405,
         0.0020248923159526685,
         -0.012789809690051591,
         0.015322219733270501,
         0.034540588046382346,
         0.02834826034567766,
         -0.0028140165213793355,
         -0.044214822575098234,
         0.01908287068165353,
         -0.01001334578991121,
         -0.007405236064746513,
         0.05468832004458814,
         -0.04163172414315333,
         -0.0028363054957227752,
         0.00028160647816042244,
         -0.01993031677898692,
         -0.049849133852169006,
         0.0007446902270292268,
         0.03496114475396349,
         -0.002456211866220885,
         -0.05884853312369817,
         0.06861646973871996,
         -0.05662931565305234,
         0.036280089069917754,
         -0.07256531410453661,
         -0.035019290078177355,
         0.025665312209115724,
         -0.00935361170170431,
         -0.009955039688741904,
         0.04067840742054811,
         0.0222228135736867,
         -0.017186456167142355,
         -0.007568808222321344,
         0.024937809667395838,
         0.0016298635878058583,
         0.06442559325650073,
         -0.0515283417250666,
         0.014938988078731785,
         -0.017206801372469133,
         0.009027067087492185,
         -0.014661024774828946,
         0.00815048873320887,
         0.0196655812210406,
         -0.0724986599957613,
         0.10389837474138423,
         -0.08959267127902544,
         0.0800065376009685,
         -0.019485866254589774,
         -0.04563804250669926,
         0.047738509098723216,
         -0.03579966112169586,
         -0.10135026275603881,
         0.16183851842123875,
         -0.10135026275603877,
         -0.03579966112169586,
         0.04773850909872322,
         -0.04563804250669925,
         -0.019485866254589777,
         0.08000653760096847,
         -0.08959267127902543,
         0.10389837474138425,
         -0.07249865999576134,
         0.01966558122104059,
         0.00815048873320887,
         -0.014661024774828958,
         0.009027067087492189,
         -0.01720680137246914,
         0.014938988078731803,
         -0.05152834172506658,
         0.06442559325650073,
         0.0016298635878058587,
         0.024937809667395845,
         -0.007568808222321344,
         -0.017186456167142348,
         0.0222228135736867,
         0.04067840742054811,
         -0.009955039688741889,
         -0.009353611701704293,
         0.025665312209115713,
         -0.03501929007817734,
         -0.0725653141045366,
         0.03628008906991774,
         -0.05662931565305235,
         0.06861646973871996,
         -0.058848533123698185,
         -0.002456211866220892,
         0.034961144753963495,
         0.0007446902270292357,
         -0.049849133852169006,
         -0.01993031677898691,
         0.0002816064781604256,
         -0.0028363054957227735,
         -0.04163172414315333,
         0.054688320044588144,
         -0.007405236064746516,
         -0.01001334578991121,
         0.019082870681653537,
         -0.04421482257509827,
         -0.002814016521379344,
         0.028348260345677657,
         0.034540588046382326,
         0.015322219733270503,
         -0.012789809690051597,
         0.002024892315952679,
         0.08742049539379404,
         -0.06867143242969358,
         0.05260452246939385,
         -0.07477585753330578,
         0.07530411394042771,
         -0.015346056261626672,
         -1.6477484123092307e-05,
         0.01369438039957965,
         0.013569882350023285,
         0.11515514204770572,
         -0.0881326279243643,
         0.030713578493447136,
         -0.09287573947295094,
         0.05426455408424116,
         0.029948109841299943,
         -0.11335472618666717,
         0.016024946232380568,
         0.03596627436517102,
         -0.08555491230670849,
         0.07361844657037322,
         0.03264482616490985,
         -0.10904313317646121,
         0.04471146757680964,
         0.049420373717369626,
         -0.0942117556293857,
         0.09253628079307771,
         -0.0973878386997642,
         0.04617823259116575,
         -0.012491985628335684,
         -0.03694381229292473,
         0.021178065475904798,
         0.041587274733838504,
         -0.012318601908891355,
         0.04057207652884055,
         -0.04518626793488313,
         0.043584382548542654,
         -0.004808531923804704,
         0.039306125154549156,
         -0.0072814049361793415,
         -0.023815933243467795,
         0.009753092746013022,
         0.021998498923188746,
         -0.009753719290256868,
         0.004452125282404116,
         -0.02090530867037826,
         0.022685282333650764,
         0.057241745520688024,
         -0.06602756993229067,
         0.09482089349200667,
         -0.10133793419308254,
         0.03934827862854688,
         -0.021080659276073402,
         0.01561250671172568,
         0.0036811676114885386,
         -0.03545522088617749,
         -0.04316327554587165,
         0.03448037335162053,
         0.0034793145664777357,
         -0.019513630797865247,
         0.0014221718528224503,
         0.013683840875990597,
         0.03163225076976292,
         -0.008196428573795869,
         -0.012595191109887285,
         0.0327261605036205,
         -0.006159126511722716,
         -0.03598744145915315,
         0.052077402323672105,
         0.06133211019555518,
         -0.05208194527545045,
         -0.004614315984248295,
         -0.05867652557094321,
         0.08187711955400132,
         -0.08243348683790881,
         0.10472420859663516,
         -0.025369089243230437,
         -0.0391856640604419,
         0.07615536323634166,
         -0.15763333766682408,
         -0.005167687768830052,
         0.018026236987621812,
         0.03160226295546347,
         -0.12689804582408923,
         0.10564012647398736,
         -0.025017124519698956,
         -0.03596052520551868,
         0.08011361687224042,
         -0.07372479960644064,
         0.08063589725266672,
         -0.07649225680432364,
         -0.03286043483254507,
         -0.016232967443905438,
         0.0213405686402716,
         0.02480462699931313,
         0.08833641327114629,
         -0.06732444756228542,
         0.05698556173154272,
         -0.06686763162531403,
         0.07926236757632646,
         0.03341882232347933,
         0.014891152743214574,
         -0.01673978196214455,
         -0.0028229585242814347,
         -0.030640278986035344,
         -0.005953833482193621,
         0.014334040616935195,
         0.009658172959694039,
         0.013047601969597054,
         -0.04529594671873813,
         0.09803358137993087,
         -0.05163611751241662,
         0.013003730820405278,
         -0.08497034525843393,
         -0.05057502048333481,
         -0.004552266912471876,
         0.02662185185591585,
         -0.007297301001222151,
         -0.014937118638351206,
         0.007802462701123593,
         0.0021568926449128845,
         0.02761569846806064,
         -0.02012607833279288,
         -0.018539187597080654,
         -0.0017657670820868457,
         -0.042680553498010566,
         0.01689573567369168,
         0.06471871594709275,
         0.06922904949118974,
         -0.029872047644567544,
         -0.016596242662010482,
         -0.01904926394799297,
         0.011598501569596466,
         0.009021934053300505,
         -0.02438588181532122,
         0.061451871034668544,
         -0.07956340845093203,
         -0.03158538734699243,
         0.035993005416044714,
         -0.0035988050834164166},
        {0.0008263843132989009,
         -0.0008263843132989293,
         -0.011062285989026652,
         0.012722093717628538,
         -0.009712806056344912,
         -0.0018103023464261635,
         0.06132153513704452,
         -0.059104376622590986,
         -0.05381128510538576,
         -0.010024524522441507,
         0.06796410658693143,
         0.03820998951914084,
         0.018076082394918556,
         -0.020278638419604676,
         -0.03100454878234039,
         0.05967777839174793,
         -0.09301659879137913,
         0.035555978914084796,
         0.01127698619253506,
         0.02500693565501505,
         0.0031303202467066332,
         0.024111982910616232,
         0.022562637042891857,
         -0.03754504817546539,
         -0.040439023367603834,
         -0.08528990449841661,
         0.014380432888306392,
         -0.050878831285459364,
         0.10181287317109831,
         -0.023401187692512797,
         0.0008805588917031688,
         -0.07397061191304011,
         0.05962837592999105,
         0.04001149582266125,
         -0.007828476734962782,
         -0.03080767836805455,
         -0.04910943253297092,
         -0.01590899894470532,
         0.017687799732590843,
         0.07398898781703478,
         -0.06578846914513724,
         0.09233526463521631,
         -0.03888121751504556,
         0.0667456619799108,
         0.030469385298879426,
         0.014457478313662817,
         -0.038970074901914314,
         -0.038085177369033815,
         0.049426412677369275,
         -0.06141530432959536,
         0.11054213771787934,
         -0.09131114053961292,
         0.0027780624694473104,
         0.014698073995296148,
         -0.09586628017050297,
         0.015939845528207472,
         0.12670068391665457,
         -0.08938106263163034,
         0.08767263188066894,
         0.012051303364952998,
         -0.093511231878481,
         0.003366977311938668,
         0.010622657445980836,
         -0.08150543396972115,
         0.051473452187615024,
         -0.05658150479493601,
         0.09764532526914996,
         0.0018103023464261792,
         -0.0623336450865559,
         0.060116486572102286,
         0.06386146114490118,
         -0.002697569195187082,
         -0.05723919058107513,
         -0.024661511488213286,
         -0.022595115439920547,
         0.014410125441920899,
         0.04290025818667004,
         -0.07127975067491078,
         0.04062866900550235,
         0.03065108166940843,
         -0.02300957121320368,
         -0.020566789710153337,
         -0.014684752503707653,
         -0.0018359214721877584,
         0.02037921370411502,
         0.010575122028724107,
         -0.002706655725157773,
         0.06624838359677343,
         -0.07796094015551316,
         0.06501115687445136,
         -0.06885408707238926,
         0.05966503339321739,
         0.03226036041305953,
         -0.00463862973163922,
         0.027080623710303238,
         -0.022170370620915245,
         -0.037792959758346074,
         -0.005610912332163624,
         -0.009391050756878551,
         0.031710133626147705,
         0.024030600796898054,
         -0.02943971178056771,
         0.014448200379936316,
         -0.043858679329407256,
         0.03222882714056968,
         -0.017906196137415738,
         0.03359224823085341,
         0.02699450383300643,
         -0.014652807204815047,
         -0.03176705981982242,
         -0.11013324859393196,
         0.09449386152827109,
         -0.012118533408723209,
         0.05601313901070323,
         -0.05126378707324128,
         -0.03638900669934167,
         0.08379112489376489,
         -0.07574980052852111,
         0.04482761026531777,
         0.05592491131927354,
         -0.038256395001744735,
         -0.11148551029507611,
         0.054841327907704095,
         -0.05033750725395715,
         -0.037120152609619976,
         0.09172616687388968,
         -0.10324815388053463,
         0.08660318175088805,
         -0.012030624708472548,
         0.030776395101720738,
         0.023013603855809004,
         -0.050022132710549956,
         -0.03951963607213248,
         0.07178889647816669,
         -0.06726729005097766,
         0.08806518955068557,
         -0.029511716831822077,
         0.08110650818069264,
         -0.0281131277841828,
         -0.04983070296599858,
         -0.010917653427146979,
         9.942699933996143e-05,
         0.059686972161125694,
         0.039447771372532595,
         -0.00844462047016905,
         -0.0064603417846656325,
         -0.06300910654381897,
         0.05672156703914306,
         0.027682370079616467,
         -0.08662109563321314,
         0.017259420165848558,
         0.021300585020612987,
         0.009112754220020041,
         -0.04222639772937216,
         -0.04763581929171658,
         0.02903280346629065,
         0.02442125159608214,
         -0.03395553888811803,
         0.10638599633344403,
         -0.04489639731214594,
         0.006781087105252105,
         -0.08374420989683339,
         -0.007233857028251051,
         0.03781179906227614,
         -0.04469972150260191,
         -0.015462512384376875,
         0.02182663059264533,
         0.03045640501755506,
         0.02836586298711066,
         -0.009728415733671343,
         -0.006639192568032617,
         -0.023152843313293116,
         0.03032645060372935,
         -0.040177043713577415,
         0.015625152653551723,
         -0.02860012448374511,
         -0.02402898584671978,
         -0.014044720551944636,
         0.018495737402752954,
         0.03926989073082756,
         0.055761651512019575,
         -0.09894487837907937,
         0.04761498556619109,
         -0.07748285038884282,
         0.060713971782182144,
         0.057707066119937894,
         -0.07002876593231681,
         0.10977080304418552,
         -0.04530346915327888,
         -0.034385314859135395,
         -0.04530346915327889,
         0.10977080304418552,
         -0.07002876593231683,
         0.0577070661199379,
         0.06071397178218213,
         -0.07748285038884281,
         0.047614985566191065,
         -0.09894487837907937,
         0.05576165151201955,
         0.03926989073082755,
         0.018495737402752937,
         -0.01404472055194462,
         -0.02402898584671978,
         -0.028600124483745108,
         0.015625152653551723,
         -0.040177043713577415,
         0.03032645060372932,
         -0.02315284331329312,
         -0.006639192568032616,
         -0.00972841573367134,
         0.02836586298711067,
         0.030456405017555043,
         0.02182663059264532,
         -0.015462512384376861,
         -0.04469972150260193,
         0.03781179906227618,
         -0.007233857028251063,
         -0.0837442098968334,
         0.006781087105252097,
         -0.04489639731214595,
         0.10638599633344406,
         -0.03395553888811801,
         0.024421251596082154,
         0.02903280346629064,
         -0.04763581929171655,
         -0.04222639772937217,
         0.009112754220020046,
         0.021300585020612994,
         0.017259420165848555,
         -0.08662109563321313,
         0.027682370079616478,
         0.05672156703914306,
         -0.06300910654381897,
         -0.006460341784665643,
         -0.008444620470169039,
         0.03944777137253261,
         0.05968697216112569,
         9.942699933994381e-05,
         -0.010917653427146994,
         -0.04983070296599857,
         -0.0281131277841828,
         0.08110650818069265,
         -0.02951171683182207,
         0.08806518955068557,
         -0.06726729005097767,
         0.07178889647816669,
         -0.03951963607213249,
         -0.05002213271054998,
         0.023013603855809,
         0.030776395101720765,
         -0.012030624708472562,
         0.08660318175088802,
         -0.10324815388053464,
         0.09172616687388971,
         -0.03712015260961997,
         -0.05033750725395716,
         0.05484132790770416,
         -0.11148551029507614,
         -0.03825639500174473,
         0.055924911319273525,
         0.044827610265317785,
         -0.07574980052852112,
         0.08379112489376486,
         -0.03638900669934167,
         -0.05126378707324127,
         0.05601313901070322,
         -0.012118533408723205,
         0.09449386152827108,
         -0.11013324859393196,
         -0.031767059819822405,
         -0.01465280720481505,
         0.026994503833006445,
         0.03359224823085341,
         -0.01790619613741574,
         0.03222882714056969,
         -0.04385867932940723,
         0.014448200379936322,
         -0.029439711780567715,
         0.02403060079689804,
         0.031710133626147705,
         -0.009391050756878528,
         -0.005610912332163624,
         -0.03779295975834609,
         -0.022170370620915238,
         0.027080623710303266,
         -0.004638629731639227,
         0.032260360413059505,
         0.0596650333932174,
         -0.06885408707238924,
         0.06501115687445136,
         -0.07796094015551316,
         0.06624838359677343,
         -0.002706655725157773,
         0.01057512202872412,
         0.020379213704115048,
         -0.0018359214721877619,
         -0.014684752503707639,
         -0.020566789710153306,
         -0.023009571213203694,
         0.030651081669408442,
         0.04062866900550237,
         -0.07127975067491082,
         0.04290025818667002,
         0.01441012544192091,
         -0.022595115439920543,
         -0.02466151148821324,
         -0.05723919058107513,
         -0.002697569195187088,
         0.0638614611449012,
         0.06011648657210227,
         -0.06233364508655592,
         0.0018103023464261653,
         0.09764532526915001,
         -0.05658150479493601,
         0.05147345218761504,
         -0.08150543396972114,
         0.010622657445980831,
         0.0033669773119386383,
         -0.09351123187848102,
         0.012051303364952989,
         0.08767263188066894,
         -0.08938106263163034,
         0.12670068391665457,
         0.01593984552820744,
         -0.095866280170503,
         0.014698073995296148,
         0.002778062469447312,
         -0.09131114053961292,
         0.11054213771787938,
         -0.06141530432959534,
         0.049426412677369275,
         -0.03808517736903383,
         -0.038970074901914314,
         0.014457478313662803,
         0.030469385298879405,
         0.06674566197991083,
         -0.038881217515045564,
         0.09233526463521627,
         -0.0657884691451372,
         0.07398898781703478,
         0.017687799732590853,
         -0.015908998944705335,
         -0.049109432532970905,
         -0.03080767836805455,
         -0.007828476734962774,
         0.04001149582266124,
         0.05962837592999104,
         -0.07397061191304016,
         0.0008805588917031575,
         -0.0234011876925128,
         0.10181287317109831,
         -0.05087883128545936,
         0.014380432888306396,
         -0.08528990449841661,
         -0.040439023367603855,
         -0.03754504817546541,
         0.02256263704289186,
         0.024111982910616253,
         0.0031303202467066506,
         0.025006935655015005,
         0.011276986192535109,
         0.03555597891408485,
         -0.09301659879137905,
         0.05967777839174787,
         -0.03100454878234041,
         -0.02027863841960474,
         0.0180760823949185,
         0.03820998951914076,
         0.0679641065869314,
         -0.010024524522441474,
         -0.053811285105385805,
         -0.05910437662259093,
         0.06132153513704454,
         -0.0018103023464261826,
         -0.009712806056344964,
         0.012722093717628582,
         -0.011062285989026737,
         -0.0008263843132989696,
         0.0008263843132989244}
    };

    m_array_all = {
        {
        {0, 0, 0, 0, 0}
        },
        {
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1}
        },
        {
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2}
        },
        {
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2}
        },
        {
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2}
        },
        {
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1}
        },
        {
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1}
        },
        {
        {0, -1, -1, 1, 1},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 1, -1, -1}
        },
        {
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2}
        },
        {
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2}
        },
        {
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2}
        },
        {
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2}
        },
        {
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2}
        },
        {
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2}
        },
        {
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2}
        },
        {
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2}
        },
        {
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2}
        },
        {
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2}
        },
        {
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2}
        },
        {
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2}
        },
        {
        {-2, -2, 0, 2, 2},
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2},
        {2, 2, 0, -2, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 0, 2, 2},
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2},
        {2, 2, 0, -2, -2}
        },
        {
        {-2, -2, 0, 2, 2},
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2},
        {2, 2, 0, -2, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 0, 2, 2},
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2},
        {2, 2, 0, -2, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 0, 2, 2},
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2},
        {2, 2, 0, -2, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 0, 2, 2},
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2},
        {2, 2, 0, -2, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        },
        {
        {-2, -2, 0, 2, 2},
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2},
        {2, 2, 0, -2, -2}
        },
        {
        {-2, -2, 1, 1, 2},
        {-2, -2, 1, 2, 1},
        {-2, -2, 2, 0, 2},
        {-2, -2, 2, 1, 1},
        {-2, -2, 2, 2, 0},
        {-2, -1, -1, 2, 2},
        {-2, -1, 0, 1, 2},
        {-2, -1, 0, 2, 1},
        {-2, -1, 1, 0, 2},
        {-2, -1, 1, 1, 1},
        {-2, -1, 1, 2, 0},
        {-2, -1, 2, -1, 2},
        {-2, -1, 2, 0, 1},
        {-2, -1, 2, 1, 0},
        {-2, -1, 2, 2, -1},
        {-2, 0, -2, 2, 2},
        {-2, 0, -1, 1, 2},
        {-2, 0, -1, 2, 1},
        {-2, 0, 0, 0, 2},
        {-2, 0, 0, 1, 1},
        {-2, 0, 0, 2, 0},
        {-2, 0, 1, -1, 2},
        {-2, 0, 1, 0, 1},
        {-2, 0, 1, 1, 0},
        {-2, 0, 1, 2, -1},
        {-2, 0, 2, -2, 2},
        {-2, 0, 2, -1, 1},
        {-2, 0, 2, 0, 0},
        {-2, 0, 2, 1, -1},
        {-2, 0, 2, 2, -2},
        {-2, 1, -2, 1, 2},
        {-2, 1, -2, 2, 1},
        {-2, 1, -1, 0, 2},
        {-2, 1, -1, 1, 1},
        {-2, 1, -1, 2, 0},
        {-2, 1, 0, -1, 2},
        {-2, 1, 0, 0, 1},
        {-2, 1, 0, 1, 0},
        {-2, 1, 0, 2, -1},
        {-2, 1, 1, -2, 2},
        {-2, 1, 1, -1, 1},
        {-2, 1, 1, 0, 0},
        {-2, 1, 1, 1, -1},
        {-2, 1, 1, 2, -2},
        {-2, 1, 2, -2, 1},
        {-2, 1, 2, -1, 0},
        {-2, 1, 2, 0, -1},
        {-2, 1, 2, 1, -2},
        {-2, 2, -2, 0, 2},
        {-2, 2, -2, 1, 1},
        {-2, 2, -2, 2, 0},
        {-2, 2, -1, -1, 2},
        {-2, 2, -1, 0, 1},
        {-2, 2, -1, 1, 0},
        {-2, 2, -1, 2, -1},
        {-2, 2, 0, -2, 2},
        {-2, 2, 0, -1, 1},
        {-2, 2, 0, 0, 0},
        {-2, 2, 0, 1, -1},
        {-2, 2, 0, 2, -2},
        {-2, 2, 1, -2, 1},
        {-2, 2, 1, -1, 0},
        {-2, 2, 1, 0, -1},
        {-2, 2, 1, 1, -2},
        {-2, 2, 2, -2, 0},
        {-2, 2, 2, -1, -1},
        {-2, 2, 2, 0, -2},
        {-1, -2, -1, 2, 2},
        {-1, -2, 0, 1, 2},
        {-1, -2, 0, 2, 1},
        {-1, -2, 1, 0, 2},
        {-1, -2, 1, 1, 1},
        {-1, -2, 1, 2, 0},
        {-1, -2, 2, -1, 2},
        {-1, -2, 2, 0, 1},
        {-1, -2, 2, 1, 0},
        {-1, -2, 2, 2, -1},
        {-1, -1, -2, 2, 2},
        {-1, -1, -1, 1, 2},
        {-1, -1, -1, 2, 1},
        {-1, -1, 0, 0, 2},
        {-1, -1, 0, 1, 1},
        {-1, -1, 0, 2, 0},
        {-1, -1, 1, -1, 2},
        {-1, -1, 1, 0, 1},
        {-1, -1, 1, 1, 0},
        {-1, -1, 1, 2, -1},
        {-1, -1, 2, -2, 2},
        {-1, -1, 2, -1, 1},
        {-1, -1, 2, 0, 0},
        {-1, -1, 2, 1, -1},
        {-1, -1, 2, 2, -2},
        {-1, 0, -2, 1, 2},
        {-1, 0, -2, 2, 1},
        {-1, 0, -1, 0, 2},
        {-1, 0, -1, 1, 1},
        {-1, 0, -1, 2, 0},
        {-1, 0, 0, -1, 2},
        {-1, 0, 0, 0, 1},
        {-1, 0, 0, 1, 0},
        {-1, 0, 0, 2, -1},
        {-1, 0, 1, -2, 2},
        {-1, 0, 1, -1, 1},
        {-1, 0, 1, 0, 0},
        {-1, 0, 1, 1, -1},
        {-1, 0, 1, 2, -2},
        {-1, 0, 2, -2, 1},
        {-1, 0, 2, -1, 0},
        {-1, 0, 2, 0, -1},
        {-1, 0, 2, 1, -2},
        {-1, 1, -2, 0, 2},
        {-1, 1, -2, 1, 1},
        {-1, 1, -2, 2, 0},
        {-1, 1, -1, -1, 2},
        {-1, 1, -1, 0, 1},
        {-1, 1, -1, 1, 0},
        {-1, 1, -1, 2, -1},
        {-1, 1, 0, -2, 2},
        {-1, 1, 0, -1, 1},
        {-1, 1, 0, 0, 0},
        {-1, 1, 0, 1, -1},
        {-1, 1, 0, 2, -2},
        {-1, 1, 1, -2, 1},
        {-1, 1, 1, -1, 0},
        {-1, 1, 1, 0, -1},
        {-1, 1, 1, 1, -2},
        {-1, 1, 2, -2, 0},
        {-1, 1, 2, -1, -1},
        {-1, 1, 2, 0, -2},
        {-1, 2, -2, -1, 2},
        {-1, 2, -2, 0, 1},
        {-1, 2, -2, 1, 0},
        {-1, 2, -2, 2, -1},
        {-1, 2, -1, -2, 2},
        {-1, 2, -1, -1, 1},
        {-1, 2, -1, 0, 0},
        {-1, 2, -1, 1, -1},
        {-1, 2, -1, 2, -2},
        {-1, 2, 0, -2, 1},
        {-1, 2, 0, -1, 0},
        {-1, 2, 0, 0, -1},
        {-1, 2, 0, 1, -2},
        {-1, 2, 1, -2, 0},
        {-1, 2, 1, -1, -1},
        {-1, 2, 1, 0, -2},
        {-1, 2, 2, -2, -1},
        {-1, 2, 2, -1, -2},
        {0, -2, -2, 2, 2},
        {0, -2, -1, 1, 2},
        {0, -2, -1, 2, 1},
        {0, -2, 0, 0, 2},
        {0, -2, 0, 1, 1},
        {0, -2, 0, 2, 0},
        {0, -2, 1, -1, 2},
        {0, -2, 1, 0, 1},
        {0, -2, 1, 1, 0},
        {0, -2, 1, 2, -1},
        {0, -2, 2, -2, 2},
        {0, -2, 2, -1, 1},
        {0, -2, 2, 0, 0},
        {0, -2, 2, 1, -1},
        {0, -2, 2, 2, -2},
        {0, -1, -2, 1, 2},
        {0, -1, -2, 2, 1},
        {0, -1, -1, 0, 2},
        {0, -1, -1, 1, 1},
        {0, -1, -1, 2, 0},
        {0, -1, 0, -1, 2},
        {0, -1, 0, 0, 1},
        {0, -1, 0, 1, 0},
        {0, -1, 0, 2, -1},
        {0, -1, 1, -2, 2},
        {0, -1, 1, -1, 1},
        {0, -1, 1, 0, 0},
        {0, -1, 1, 1, -1},
        {0, -1, 1, 2, -2},
        {0, -1, 2, -2, 1},
        {0, -1, 2, -1, 0},
        {0, -1, 2, 0, -1},
        {0, -1, 2, 1, -2},
        {0, 0, -2, 0, 2},
        {0, 0, -2, 1, 1},
        {0, 0, -2, 2, 0},
        {0, 0, -1, -1, 2},
        {0, 0, -1, 0, 1},
        {0, 0, -1, 1, 0},
        {0, 0, -1, 2, -1},
        {0, 0, 0, -2, 2},
        {0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, -1},
        {0, 0, 0, 2, -2},
        {0, 0, 1, -2, 1},
        {0, 0, 1, -1, 0},
        {0, 0, 1, 0, -1},
        {0, 0, 1, 1, -2},
        {0, 0, 2, -2, 0},
        {0, 0, 2, -1, -1},
        {0, 0, 2, 0, -2},
        {0, 1, -2, -1, 2},
        {0, 1, -2, 0, 1},
        {0, 1, -2, 1, 0},
        {0, 1, -2, 2, -1},
        {0, 1, -1, -2, 2},
        {0, 1, -1, -1, 1},
        {0, 1, -1, 0, 0},
        {0, 1, -1, 1, -1},
        {0, 1, -1, 2, -2},
        {0, 1, 0, -2, 1},
        {0, 1, 0, -1, 0},
        {0, 1, 0, 0, -1},
        {0, 1, 0, 1, -2},
        {0, 1, 1, -2, 0},
        {0, 1, 1, -1, -1},
        {0, 1, 1, 0, -2},
        {0, 1, 2, -2, -1},
        {0, 1, 2, -1, -2},
        {0, 2, -2, -2, 2},
        {0, 2, -2, -1, 1},
        {0, 2, -2, 0, 0},
        {0, 2, -2, 1, -1},
        {0, 2, -2, 2, -2},
        {0, 2, -1, -2, 1},
        {0, 2, -1, -1, 0},
        {0, 2, -1, 0, -1},
        {0, 2, -1, 1, -2},
        {0, 2, 0, -2, 0},
        {0, 2, 0, -1, -1},
        {0, 2, 0, 0, -2},
        {0, 2, 1, -2, -1},
        {0, 2, 1, -1, -2},
        {0, 2, 2, -2, -2},
        {1, -2, -2, 1, 2},
        {1, -2, -2, 2, 1},
        {1, -2, -1, 0, 2},
        {1, -2, -1, 1, 1},
        {1, -2, -1, 2, 0},
        {1, -2, 0, -1, 2},
        {1, -2, 0, 0, 1},
        {1, -2, 0, 1, 0},
        {1, -2, 0, 2, -1},
        {1, -2, 1, -2, 2},
        {1, -2, 1, -1, 1},
        {1, -2, 1, 0, 0},
        {1, -2, 1, 1, -1},
        {1, -2, 1, 2, -2},
        {1, -2, 2, -2, 1},
        {1, -2, 2, -1, 0},
        {1, -2, 2, 0, -1},
        {1, -2, 2, 1, -2},
        {1, -1, -2, 0, 2},
        {1, -1, -2, 1, 1},
        {1, -1, -2, 2, 0},
        {1, -1, -1, -1, 2},
        {1, -1, -1, 0, 1},
        {1, -1, -1, 1, 0},
        {1, -1, -1, 2, -1},
        {1, -1, 0, -2, 2},
        {1, -1, 0, -1, 1},
        {1, -1, 0, 0, 0},
        {1, -1, 0, 1, -1},
        {1, -1, 0, 2, -2},
        {1, -1, 1, -2, 1},
        {1, -1, 1, -1, 0},
        {1, -1, 1, 0, -1},
        {1, -1, 1, 1, -2},
        {1, -1, 2, -2, 0},
        {1, -1, 2, -1, -1},
        {1, -1, 2, 0, -2},
        {1, 0, -2, -1, 2},
        {1, 0, -2, 0, 1},
        {1, 0, -2, 1, 0},
        {1, 0, -2, 2, -1},
        {1, 0, -1, -2, 2},
        {1, 0, -1, -1, 1},
        {1, 0, -1, 0, 0},
        {1, 0, -1, 1, -1},
        {1, 0, -1, 2, -2},
        {1, 0, 0, -2, 1},
        {1, 0, 0, -1, 0},
        {1, 0, 0, 0, -1},
        {1, 0, 0, 1, -2},
        {1, 0, 1, -2, 0},
        {1, 0, 1, -1, -1},
        {1, 0, 1, 0, -2},
        {1, 0, 2, -2, -1},
        {1, 0, 2, -1, -2},
        {1, 1, -2, -2, 2},
        {1, 1, -2, -1, 1},
        {1, 1, -2, 0, 0},
        {1, 1, -2, 1, -1},
        {1, 1, -2, 2, -2},
        {1, 1, -1, -2, 1},
        {1, 1, -1, -1, 0},
        {1, 1, -1, 0, -1},
        {1, 1, -1, 1, -2},
        {1, 1, 0, -2, 0},
        {1, 1, 0, -1, -1},
        {1, 1, 0, 0, -2},
        {1, 1, 1, -2, -1},
        {1, 1, 1, -1, -2},
        {1, 1, 2, -2, -2},
        {1, 2, -2, -2, 1},
        {1, 2, -2, -1, 0},
        {1, 2, -2, 0, -1},
        {1, 2, -2, 1, -2},
        {1, 2, -1, -2, 0},
        {1, 2, -1, -1, -1},
        {1, 2, -1, 0, -2},
        {1, 2, 0, -2, -1},
        {1, 2, 0, -1, -2},
        {1, 2, 1, -2, -2},
        {2, -2, -2, 0, 2},
        {2, -2, -2, 1, 1},
        {2, -2, -2, 2, 0},
        {2, -2, -1, -1, 2},
        {2, -2, -1, 0, 1},
        {2, -2, -1, 1, 0},
        {2, -2, -1, 2, -1},
        {2, -2, 0, -2, 2},
        {2, -2, 0, -1, 1},
        {2, -2, 0, 0, 0},
        {2, -2, 0, 1, -1},
        {2, -2, 0, 2, -2},
        {2, -2, 1, -2, 1},
        {2, -2, 1, -1, 0},
        {2, -2, 1, 0, -1},
        {2, -2, 1, 1, -2},
        {2, -2, 2, -2, 0},
        {2, -2, 2, -1, -1},
        {2, -2, 2, 0, -2},
        {2, -1, -2, -1, 2},
        {2, -1, -2, 0, 1},
        {2, -1, -2, 1, 0},
        {2, -1, -2, 2, -1},
        {2, -1, -1, -2, 2},
        {2, -1, -1, -1, 1},
        {2, -1, -1, 0, 0},
        {2, -1, -1, 1, -1},
        {2, -1, -1, 2, -2},
        {2, -1, 0, -2, 1},
        {2, -1, 0, -1, 0},
        {2, -1, 0, 0, -1},
        {2, -1, 0, 1, -2},
        {2, -1, 1, -2, 0},
        {2, -1, 1, -1, -1},
        {2, -1, 1, 0, -2},
        {2, -1, 2, -2, -1},
        {2, -1, 2, -1, -2},
        {2, 0, -2, -2, 2},
        {2, 0, -2, -1, 1},
        {2, 0, -2, 0, 0},
        {2, 0, -2, 1, -1},
        {2, 0, -2, 2, -2},
        {2, 0, -1, -2, 1},
        {2, 0, -1, -1, 0},
        {2, 0, -1, 0, -1},
        {2, 0, -1, 1, -2},
        {2, 0, 0, -2, 0},
        {2, 0, 0, -1, -1},
        {2, 0, 0, 0, -2},
        {2, 0, 1, -2, -1},
        {2, 0, 1, -1, -2},
        {2, 0, 2, -2, -2},
        {2, 1, -2, -2, 1},
        {2, 1, -2, -1, 0},
        {2, 1, -2, 0, -1},
        {2, 1, -2, 1, -2},
        {2, 1, -1, -2, 0},
        {2, 1, -1, -1, -1},
        {2, 1, -1, 0, -2},
        {2, 1, 0, -2, -1},
        {2, 1, 0, -1, -2},
        {2, 1, 1, -2, -2},
        {2, 2, -2, -2, 0},
        {2, 2, -2, -1, -1},
        {2, 2, -2, 0, -2},
        {2, 2, -1, -2, -1},
        {2, 2, -1, -1, -2}
        }
    };

}
