# Guide des Backends GestVenv v1.1

GestVenv v1.1 offre un systme de backends modulaire avec auto-dtection intelligente pour optimiser les performances selon votre projet.

## < Vue d'Ensemble des Backends

### Backends Supports

| Backend | Performance | Lock Files | Groupes | Workspace | Auto-dtection | Statut |
|---------|-------------|------------|---------|-----------|----------------|--------|
| **uv** | =%=%=% |  uv.lock |  |  |  | Recommand |
| **PDM** | =%=%=% |  pdm.lock |  |  |  | Stable |
| **Poetry** | =%=% |  poetry.lock |  | L |  | Stable |
| **pip** | =% | L |  | L |  | Legacy |

### Scores de Performance

```bash
# Voir les performances en temps rel
gestvenv backend list --detailed

# Exemple de sortie :
# Backend: uv        Score: 10/10  Temps moyen: 2.1s
# Backend: pdm       Score: 8/10   Temps moyen: 3.2s  
# Backend: poetry    Score: 6/10   Temps moyen: 5.8s
# Backend: pip       Score: 4/10   Temps moyen: 12.4s
```

## = Backend UV (Recommand)

### Description
UV est le backend le plus performant, dvelopp par Astral (crateurs de Ruff). Il offre des vitesses d'installation jusqu' 10x suprieures  pip.

### Avantages
- **Performance exceptionnelle** : Installation et rsolution ultra-rapides
- **Compatibilit totale** : Compatible avec l'cosystme Python existant
- **Lock files** : Gnration de uv.lock pour la reproductibilit
- **Installation parallle** : Jusqu' 8 jobs simultans
- **Cache optimis** : Rutilisation intelligente des tlchargements

### Installation
```bash
# Installation automatique
pip install uv

# Vrification
gestvenv backend list
# UV devrait apparatre comme disponible

# Configuration comme backend par dfaut
gestvenv backend set uv
```

### Utilisation
```bash
# Auto-dtection (recommand)
gestvenv create monapp --backend auto

# Spcifique
gestvenv create monapp --backend uv

# Avec lock file
gestvenv create-from-pyproject pyproject.toml monapp --backend uv
# Gnre automatiquement uv.lock
```

### Fonctionnalits Avances
```bash
# Installation parallle maximale
gestvenv config set backend_configs.uv.max_parallel_jobs 8

# Cache personnalis
export UV_CACHE_DIR=/custom/cache/path

# Mode verbose
gestvenv install numpy --backend uv --verbose
```

## = Backend PDM

### Description
PDM (Python Dependency Manager) est un gestionnaire moderne qui suit les standards PEP 582 et PEP 621.

### Avantages
- **Standards modernes** : Conforme PEP 621 (pyproject.toml)
- **Groupes de dpendances** : Support natif des dependency groups
- **Workspace** : Gestion de projets multi-packages
- **Lock files** : pdm.lock pour la reproductibilit
- **Performance** : Rsolution rapide des dpendances

### Installation
```bash
pip install pdm

# Configuration
gestvenv backend set pdm
```

### Utilisation avec Groupes
```bash
# Cration avec groupes
gestvenv create-from-pyproject pyproject.toml monapp --backend pdm

# Installation par groupes
gestvenv install --group dev --backend pdm --env monapp
gestvenv install --group test,lint --backend pdm --env monapp

# Synchronisation
gestvenv sync monapp  # Utilise PDM automatiquement si dtect
```

### Workspace et Multi-packages
```bash
# Projet avec workspace
gestvenv create monworkspace --backend pdm

# Structure typique :
# monworkspace/
#    pyproject.toml (workspace root)
#    packages/
#       core/
#          pyproject.toml
#       api/
#           pyproject.toml
#    pdm.lock
```

## < Backend Poetry

### Description
Poetry est un gestionnaire de dpendances Python populaire avec une interface lgante et des fonctionnalits compltes.

### Avantages
- **cosystme mature** : Large adoption dans la communaut
- **Interface intuitive** : Commandes simples et claires
- **Packaging intgr** : Build et publication simplifis
- **Lock files** : poetry.lock pour la reproductibilit
- **Environnements virtuels** : Gestion automatique

### Auto-dtection
GestVenv dtecte automatiquement Poetry quand :
- `poetry.lock` existe
- `pyproject.toml` contient `[tool.poetry]`
- `build-backend = "poetry.core.masonry.api"`

### Utilisation
```bash
# Auto-dtection depuis projet Poetry existant
gestvenv import ./mon-projet-poetry/pyproject.toml

# Cration spcifique
gestvenv create monapp --backend poetry

# Migration depuis Poetry
cd mon-projet-poetry
gestvenv create-from-pyproject pyproject.toml mon-env
```

### Commandes quivalentes

| Poetry | GestVenv | Description |
|--------|----------|-------------|
| `poetry install` | `gestvenv sync mon-env` | Installation des dpendances |
| `poetry add requests` | `gestvenv install requests --env mon-env` | Ajouter une dpendance |
| `poetry remove requests` | `gestvenv uninstall requests --env mon-env` | Supprimer une dpendance |
| `poetry show` | `gestvenv list-packages --env mon-env` | Lister les packages |
| `poetry lock` | `gestvenv sync mon-env` | Mettre  jour le lock file |

## = Backend pip (Legacy)

### Description
pip est le gestionnaire de packages par dfaut de Python. Bien que moins performant, il reste universellement compatible.

### Avantages
- **Universalit** : Disponible partout o Python est install
- **Compatibilit** : Fonctionne avec tous les packages PyPI
- **Simplicit** : Interface familire
- **Stabilit** : Mature et test

### Limitations
- Performance plus lente
- Pas de lock files natifs
- Rsolution de dpendances basique
- Pas de workspace

### Utilisation
```bash
# Fallback automatique si aucun autre backend
gestvenv create monapp

# Spcifique
gestvenv create monapp --backend pip

# Avec requirements.txt
gestvenv cache add -r requirements.txt
gestvenv create monapp --backend pip
gestvenv install -r requirements.txt --env monapp
```

## < Auto-dtection Intelligente

### Mcanisme de Dtection

GestVenv utilise plusieurs stratgies pour choisir le backend optimal :

#### 1. Dtection par Fichiers Projet
```bash
# Recherche dans cet ordre :
# 1. uv.lock          backend uv
# 2. poetry.lock      backend poetry  
# 3. pdm.lock         backend pdm
# 4. pyproject.toml   analyse des sections [tool.*]
# 5. requirements.txt  backend pip
```

#### 2. Analyse pyproject.toml
```toml
# Dtection Poetry
[tool.poetry]
name = "mon-projet"

# Dtection PDM  
[tool.pdm]
name = "mon-projet"

# Dtection UV
[tool.uv]
name = "mon-projet"

# Build backend
[build-system]
build-backend = "poetry.core.masonry.api"  #  Poetry
build-backend = "pdm.backend"              #  PDM
```

#### 3. Slection par Performance
Si aucun fichier spcifique n'est trouv :
1. **uv** (si disponible) - Performance maximale
2. **pdm** (si disponible) - Standards modernes
3. **poetry** (si disponible) - cosystme mature
4. **pip** (toujours disponible) - Fallback universel

### Configuration de l'Auto-dtection

```bash
# Activer l'auto-dtection (par dfaut)
gestvenv config set preferred_backend auto

# Voir les recommandations pour un projet
gestvenv backend info --project /chemin/vers/projet

# Exemple de sortie :
# Detected: poetry (poetry.lock found)
# Optimal: uv (best performance available)
# Alternatives: pdm, pip
# Recommendation: Use poetry for consistency, or uv for performance
```

##  Configuration Avance

### Configuration Globale
```bash
# Backend par dfaut
gestvenv config set preferred_backend uv

# Configuration spcifique par backend
gestvenv config set backend_configs.uv.max_parallel_jobs 6
gestvenv config set backend_configs.poetry.create_virtualenv false
gestvenv config set backend_configs.pdm.use_venv true
```

### Configuration Locale
```bash
# Pour le projet actuel
gestvenv config set --local preferred_backend poetry

# Variables d'environnement
export GESTVENV_BACKEND=uv
export GESTVENV_PDM_USE_VENV=true
export GESTVENV_UV_PARALLEL_JOBS=8
```

### Validation de Compatibilit
```bash
# Vrifier la compatibilit backend/projet
gestvenv backend validate poetry /mon/projet

# Exemple de sortie :
#  Poetry available
#  pyproject.toml compatible  
#   No poetry.lock found (will be created)
#  Compatible with dependency groups
```

## = Migration Entre Backends

### Depuis pip vers uv
```bash
# Projet existant avec requirements.txt
gestvenv convert-to-pyproject requirements.txt
gestvenv create-from-pyproject pyproject.toml monapp --backend uv
```

### Depuis Poetry vers PDM
```bash
# Projet Poetry existant
cd mon-projet-poetry
gestvenv create-from-pyproject pyproject.toml mon-env --backend pdm
# PDM utilisera le pyproject.toml existant et crera pdm.lock
```

### Depuis PDM vers UV
```bash
# Projet PDM existant
gestvenv create-from-pyproject pyproject.toml mon-env --backend uv
# UV respectera la structure pyproject.toml et crera uv.lock
```

## = Benchmarks et Performance

### Tests de Performance Typiques

```bash
# Installation de 50 packages courants
# Rsultats moyens sur Python 3.11 :

Backend | Temps | Tlchargement | Cache Hit
--------|-------|----------------|----------
uv      | 8s    | 2.1s          | 0.3s
pdm     | 12s   | 3.4s          | 1.1s  
poetry  | 24s   | 8.2s          | 2.8s
pip     | 45s   | 18.7s         | 7.2s
```

### Optimisations Recommandes

```bash
# Cache partag pour UV
export UV_CACHE_DIR=/shared/cache/uv

# Paralllisation maximale
gestvenv config set backend_configs.uv.max_parallel_jobs 8

# Pr-chargement du cache
gestvenv cache add -r requirements.txt --platforms linux_x86_64,macosx_11_0_arm64

# Mode offline pour CI/CD
gestvenv --offline install requirements.txt
```

## =' Dpannage

### Problmes Courants

#### Backend non dtect
```bash
# Vrifier la disponibilit
gestvenv backend list

# Installer le backend manquant
pip install uv  # ou poetry, pdm

# Forcer un backend spcifique
gestvenv create monapp --backend pip
```

#### Conflits de lock files
```bash
# Multiple lock files dtects
# Solution : spcifier explicitement
gestvenv create-from-pyproject pyproject.toml monapp --backend uv
# Ou supprimer les lock files non dsirs
rm poetry.lock  # Garder seulement uv.lock
```

#### Performance dgrade
```bash
# Diagnostic
gestvenv doctor --performance

# Vrifier le cache
gestvenv cache info

# Nettoyer si ncessaire
gestvenv cache clean --size-limit 1GB
```

### Support et Compatibilit

#### Versions Minimales
- **uv** : e0.1.0
- **PDM** : e2.0.0  
- **Poetry** : e1.2.0
- **pip** : e21.0 (inclus avec Python 3.8+)

#### Compatibilit Systme
Tous les backends sont tests sur :
- Linux x86_64 / ARM64
- macOS Intel / Apple Silicon  
- Windows x64
- Python 3.8, 3.9, 3.10, 3.11, 3.12

Ce guide couvre l'utilisation complte du systme de backends de GestVenv v1.1. L'auto-dtection et la modularit vous permettent de travailler efficacement avec n'importe quel type de projet Python.