# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...types.metric_definition_execution import MetricDefinitionExecution
from ...types.metric_definition_history_item import MetricDefinitionHistoryItem
from ...types.metric_definition_input import MetricDefinitionInput

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawMetricDefinitionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def execute_metric_definition(
        self,
        id: str,
        *,
        inputs: typing.Sequence[MetricDefinitionInput],
        release_tag: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MetricDefinitionExecution]:
        """
        Parameters
        ----------
        id : str
            Either the Metric Definition's ID or its unique name

        inputs : typing.Sequence[MetricDefinitionInput]

        release_tag : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MetricDefinitionExecution]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/execute",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[MetricDefinitionInput], direction="write"
                ),
                "release_tag": release_tag,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetricDefinitionExecution,
                    parse_obj_as(
                        type_=MetricDefinitionExecution,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def metric_definition_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MetricDefinitionHistoryItem]:
        """
        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Metric Definition History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Metric Definition History Item you'd like to retrieve.

        id : str
            A UUID string identifying this metric definition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MetricDefinitionHistoryItem]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/history/{jsonable_encoder(history_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetricDefinitionHistoryItem,
                    parse_obj_as(
                        type_=MetricDefinitionHistoryItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMetricDefinitionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def execute_metric_definition(
        self,
        id: str,
        *,
        inputs: typing.Sequence[MetricDefinitionInput],
        release_tag: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MetricDefinitionExecution]:
        """
        Parameters
        ----------
        id : str
            Either the Metric Definition's ID or its unique name

        inputs : typing.Sequence[MetricDefinitionInput]

        release_tag : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MetricDefinitionExecution]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/execute",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[MetricDefinitionInput], direction="write"
                ),
                "release_tag": release_tag,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetricDefinitionExecution,
                    parse_obj_as(
                        type_=MetricDefinitionExecution,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def metric_definition_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MetricDefinitionHistoryItem]:
        """
        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Metric Definition History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Metric Definition History Item you'd like to retrieve.

        id : str
            A UUID string identifying this metric definition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MetricDefinitionHistoryItem]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/history/{jsonable_encoder(history_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetricDefinitionHistoryItem,
                    parse_obj_as(
                        type_=MetricDefinitionHistoryItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
