# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from vellum.client.utils import convert_input_variable_to_uuid
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .ephemeral_prompt_cache_config import EphemeralPromptCacheConfig
from .prompt_block_state import PromptBlockState


class VariablePromptBlock(UniversalBaseModel):
    """
    A block that represents a variable in a prompt template.
    """

    block_type: typing.Literal["VARIABLE"] = "VARIABLE"
    state: typing.Optional[PromptBlockState] = None
    cache_config: typing.Optional[EphemeralPromptCacheConfig] = None
    input_variable: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


    @pydantic.field_serializer("input_variable")
    def serialize_input_variable(self, value: str, info: pydantic.SerializationInfo) -> str:
        """Convert input_variable to UUID using executable_id from context."""
        return convert_input_variable_to_uuid(value, info)
