[![PyPI](https://img.shields.io/pypi/v/optigatrust.svg)](https://pypi.org/project/optigatrust/)

# Infineon OPTIGA™ Trust M Host Library for Python

A [ctypes](https://docs.python.org/3/library/ctypes.html) based Python wrapper for the [OPTIGA™ Trust M Host Library for C](https://github.com/Infineon/optiga-trust-m).

## Features

This Python module is a wrapper for the [OPTIGA™ Trust M Host Library for C](https://github.com/Infineon/optiga-trust-m) and allows the communication with OPTIGA™ Trust M devices.

Please see the [OPTIGA™ Trust M Overview Repository](https://github.com/Infineon/optiga-trust-m-overview) for more information on our OPTIGA™ Trust M product family.
 
## Installation

```bash
$ python -m pip install optigatrust
```

## Documentation

The documentation of this Python module can be found here:
* [Online documentation on GitHub.io](https://infineon.github.io/python-optiga-trust)
* [Source code documentation on GitHub](https://github.com/Infineon/python-optiga-trust)

## OPTIGA™ Trust M product information

Please find more information about the OPTIGA™ Trust M product family on the [OPTIGA™ Trust M Overview Repository](https://github.com/Infineon/optiga-trust-m-overview).

## Source code and examples

Please find the source code and examples for this Python module on the [OPTIGA™ Trust M Host Library for Python](https://github.com/Infineon/python-optiga-trust) GitHub repository.


## Licensing
   
Please see our [LICENSE](LICENSE) for copyright and license information.
   
This project follows the REUSE approach, so copyright and licensing information is available for every file (including third party components) either in the file header, an individual *.license file or the .reuse/dep5 file. All licenses can be found in the [LICENSES](LICENSES) folder.