# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoringJobArgs', 'MonitoringJob']

@pulumi.input_type
class MonitoringJobArgs:
    def __init__(__self__, *,
                 config: pulumi.Input[Mapping[str, Any]],
                 frequency: pulumi.Input[int],
                 job_type: pulumi.Input[str],
                 regions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 active: Optional[pulumi.Input[bool]] = None,
                 mute: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 notify_delay: Optional[pulumi.Input[int]] = None,
                 notify_failback: Optional[pulumi.Input[bool]] = None,
                 notify_list: Optional[pulumi.Input[str]] = None,
                 notify_regional: Optional[pulumi.Input[bool]] = None,
                 notify_repeat: Optional[pulumi.Input[int]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 rapid_recheck: Optional[pulumi.Input[bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]]] = None):
        """
        The set of arguments for constructing a MonitoringJob resource.
        :param pulumi.Input[Mapping[str, Any]] config: A configuration dictionary with keys and values depending on the job_type. Configuration details for each job_type are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        :param pulumi.Input[int] frequency: The frequency, in seconds, at which to run the monitoring job in each region.
        :param pulumi.Input[str] job_type: The type of monitoring job to be run. Refer to the NS1 API documentation (https://ns1.com/api#monitoring-jobs) for supported values which include ping, tcp, dns, http.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: The list of region codes in which to run the monitoring
               job. See NS1 API docs for supported values.
        :param pulumi.Input[bool] active: Indicates if the job is active or temporarily disabled.
        :param pulumi.Input[bool] mute: turn off the notifications for the monitoring job.
        :param pulumi.Input[str] name: The free-form display name for the monitoring job.
        :param pulumi.Input[str] notes: Freeform notes to be included in any notifications about this job.
        :param pulumi.Input[int] notify_delay: The time in seconds after a failure to wait before sending a notification.
        :param pulumi.Input[bool] notify_failback: If true, a notification is sent when a job returns to an "up" state.
        :param pulumi.Input[bool] notify_regional: If true, notifications are sent for any regional failure (and failback if desired), in addition to global state notifications.
        :param pulumi.Input[int] notify_repeat: The time in seconds between repeat notifications of a failed job.
        :param pulumi.Input[str] policy: The policy for determining the monitor's global status
               based on the status of the job in all regions. See NS1 API docs for supported values.
        :param pulumi.Input[bool] rapid_recheck: If true, on any apparent state change, the job is quickly re-run after one second to confirm the state change before notification.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]] rules: A list of rules for determining failure conditions. Each rule acts on one of the outputs from the monitoring job. You must specify key (the output key); comparison (a comparison to perform on the the output); and value (the value to compare to). For example, {"key":"rtt", "comparison":"<", "value":100} is a rule requiring the rtt from a job to be under 100ms, or the job will be marked failed. Available output keys, comparators, and value types are are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "regions", regions)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if mute is not None:
            pulumi.set(__self__, "mute", mute)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if notify_delay is not None:
            pulumi.set(__self__, "notify_delay", notify_delay)
        if notify_failback is not None:
            pulumi.set(__self__, "notify_failback", notify_failback)
        if notify_list is not None:
            pulumi.set(__self__, "notify_list", notify_list)
        if notify_regional is not None:
            pulumi.set(__self__, "notify_regional", notify_regional)
        if notify_repeat is not None:
            pulumi.set(__self__, "notify_repeat", notify_repeat)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if rapid_recheck is not None:
            pulumi.set(__self__, "rapid_recheck", rapid_recheck)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input[Mapping[str, Any]]:
        """
        A configuration dictionary with keys and values depending on the job_type. Configuration details for each job_type are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input[Mapping[str, Any]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[int]:
        """
        The frequency, in seconds, at which to run the monitoring job in each region.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        The type of monitoring job to be run. Refer to the NS1 API documentation (https://ns1.com/api#monitoring-jobs) for supported values which include ping, tcp, dns, http.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of region codes in which to run the monitoring
        job. See NS1 API docs for supported values.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the job is active or temporarily disabled.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def mute(self) -> Optional[pulumi.Input[bool]]:
        """
        turn off the notifications for the monitoring job.
        """
        return pulumi.get(self, "mute")

    @mute.setter
    def mute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The free-form display name for the monitoring job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Freeform notes to be included in any notifications about this job.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="notifyDelay")
    def notify_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds after a failure to wait before sending a notification.
        """
        return pulumi.get(self, "notify_delay")

    @notify_delay.setter
    def notify_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_delay", value)

    @property
    @pulumi.getter(name="notifyFailback")
    def notify_failback(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, a notification is sent when a job returns to an "up" state.
        """
        return pulumi.get(self, "notify_failback")

    @notify_failback.setter
    def notify_failback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_failback", value)

    @property
    @pulumi.getter(name="notifyList")
    def notify_list(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "notify_list")

    @notify_list.setter
    def notify_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notify_list", value)

    @property
    @pulumi.getter(name="notifyRegional")
    def notify_regional(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, notifications are sent for any regional failure (and failback if desired), in addition to global state notifications.
        """
        return pulumi.get(self, "notify_regional")

    @notify_regional.setter
    def notify_regional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_regional", value)

    @property
    @pulumi.getter(name="notifyRepeat")
    def notify_repeat(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds between repeat notifications of a failed job.
        """
        return pulumi.get(self, "notify_repeat")

    @notify_repeat.setter
    def notify_repeat(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_repeat", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The policy for determining the monitor's global status
        based on the status of the job in all regions. See NS1 API docs for supported values.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="rapidRecheck")
    def rapid_recheck(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, on any apparent state change, the job is quickly re-run after one second to confirm the state change before notification.
        """
        return pulumi.get(self, "rapid_recheck")

    @rapid_recheck.setter
    def rapid_recheck(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rapid_recheck", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]]]:
        """
        A list of rules for determining failure conditions. Each rule acts on one of the outputs from the monitoring job. You must specify key (the output key); comparison (a comparison to perform on the the output); and value (the value to compare to). For example, {"key":"rtt", "comparison":"<", "value":100} is a rule requiring the rtt from a job to be under 100ms, or the job will be marked failed. Available output keys, comparators, and value types are are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _MonitoringJobState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 job_type: Optional[pulumi.Input[str]] = None,
                 mute: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 notify_delay: Optional[pulumi.Input[int]] = None,
                 notify_failback: Optional[pulumi.Input[bool]] = None,
                 notify_list: Optional[pulumi.Input[str]] = None,
                 notify_regional: Optional[pulumi.Input[bool]] = None,
                 notify_repeat: Optional[pulumi.Input[int]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 rapid_recheck: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering MonitoringJob resources.
        :param pulumi.Input[bool] active: Indicates if the job is active or temporarily disabled.
        :param pulumi.Input[Mapping[str, Any]] config: A configuration dictionary with keys and values depending on the job_type. Configuration details for each job_type are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        :param pulumi.Input[int] frequency: The frequency, in seconds, at which to run the monitoring job in each region.
        :param pulumi.Input[str] job_type: The type of monitoring job to be run. Refer to the NS1 API documentation (https://ns1.com/api#monitoring-jobs) for supported values which include ping, tcp, dns, http.
        :param pulumi.Input[bool] mute: turn off the notifications for the monitoring job.
        :param pulumi.Input[str] name: The free-form display name for the monitoring job.
        :param pulumi.Input[str] notes: Freeform notes to be included in any notifications about this job.
        :param pulumi.Input[int] notify_delay: The time in seconds after a failure to wait before sending a notification.
        :param pulumi.Input[bool] notify_failback: If true, a notification is sent when a job returns to an "up" state.
        :param pulumi.Input[bool] notify_regional: If true, notifications are sent for any regional failure (and failback if desired), in addition to global state notifications.
        :param pulumi.Input[int] notify_repeat: The time in seconds between repeat notifications of a failed job.
        :param pulumi.Input[str] policy: The policy for determining the monitor's global status
               based on the status of the job in all regions. See NS1 API docs for supported values.
        :param pulumi.Input[bool] rapid_recheck: If true, on any apparent state change, the job is quickly re-run after one second to confirm the state change before notification.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: The list of region codes in which to run the monitoring
               job. See NS1 API docs for supported values.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]] rules: A list of rules for determining failure conditions. Each rule acts on one of the outputs from the monitoring job. You must specify key (the output key); comparison (a comparison to perform on the the output); and value (the value to compare to). For example, {"key":"rtt", "comparison":"<", "value":100} is a rule requiring the rtt from a job to be under 100ms, or the job will be marked failed. Available output keys, comparators, and value types are are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if mute is not None:
            pulumi.set(__self__, "mute", mute)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if notify_delay is not None:
            pulumi.set(__self__, "notify_delay", notify_delay)
        if notify_failback is not None:
            pulumi.set(__self__, "notify_failback", notify_failback)
        if notify_list is not None:
            pulumi.set(__self__, "notify_list", notify_list)
        if notify_regional is not None:
            pulumi.set(__self__, "notify_regional", notify_regional)
        if notify_repeat is not None:
            pulumi.set(__self__, "notify_repeat", notify_repeat)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if rapid_recheck is not None:
            pulumi.set(__self__, "rapid_recheck", rapid_recheck)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the job is active or temporarily disabled.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A configuration dictionary with keys and values depending on the job_type. Configuration details for each job_type are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[int]]:
        """
        The frequency, in seconds, at which to run the monitoring job in each region.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of monitoring job to be run. Refer to the NS1 API documentation (https://ns1.com/api#monitoring-jobs) for supported values which include ping, tcp, dns, http.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def mute(self) -> Optional[pulumi.Input[bool]]:
        """
        turn off the notifications for the monitoring job.
        """
        return pulumi.get(self, "mute")

    @mute.setter
    def mute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The free-form display name for the monitoring job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Freeform notes to be included in any notifications about this job.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="notifyDelay")
    def notify_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds after a failure to wait before sending a notification.
        """
        return pulumi.get(self, "notify_delay")

    @notify_delay.setter
    def notify_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_delay", value)

    @property
    @pulumi.getter(name="notifyFailback")
    def notify_failback(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, a notification is sent when a job returns to an "up" state.
        """
        return pulumi.get(self, "notify_failback")

    @notify_failback.setter
    def notify_failback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_failback", value)

    @property
    @pulumi.getter(name="notifyList")
    def notify_list(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "notify_list")

    @notify_list.setter
    def notify_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notify_list", value)

    @property
    @pulumi.getter(name="notifyRegional")
    def notify_regional(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, notifications are sent for any regional failure (and failback if desired), in addition to global state notifications.
        """
        return pulumi.get(self, "notify_regional")

    @notify_regional.setter
    def notify_regional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_regional", value)

    @property
    @pulumi.getter(name="notifyRepeat")
    def notify_repeat(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds between repeat notifications of a failed job.
        """
        return pulumi.get(self, "notify_repeat")

    @notify_repeat.setter
    def notify_repeat(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_repeat", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The policy for determining the monitor's global status
        based on the status of the job in all regions. See NS1 API docs for supported values.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="rapidRecheck")
    def rapid_recheck(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, on any apparent state change, the job is quickly re-run after one second to confirm the state change before notification.
        """
        return pulumi.get(self, "rapid_recheck")

    @rapid_recheck.setter
    def rapid_recheck(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rapid_recheck", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of region codes in which to run the monitoring
        job. See NS1 API docs for supported values.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]]]:
        """
        A list of rules for determining failure conditions. Each rule acts on one of the outputs from the monitoring job. You must specify key (the output key); comparison (a comparison to perform on the the output); and value (the value to compare to). For example, {"key":"rtt", "comparison":"<", "value":100} is a rule requiring the rtt from a job to be under 100ms, or the job will be marked failed. Available output keys, comparators, and value types are are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringJobRuleArgs']]]]):
        pulumi.set(self, "rules", value)


class MonitoringJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 job_type: Optional[pulumi.Input[str]] = None,
                 mute: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 notify_delay: Optional[pulumi.Input[int]] = None,
                 notify_failback: Optional[pulumi.Input[bool]] = None,
                 notify_list: Optional[pulumi.Input[str]] = None,
                 notify_regional: Optional[pulumi.Input[bool]] = None,
                 notify_repeat: Optional[pulumi.Input[int]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 rapid_recheck: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoringJobRuleArgs']]]]] = None,
                 __props__=None):
        """
        Provides a NS1 Monitoring Job resource. This can be used to create, modify, and delete monitoring jobs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ns1 as ns1

        uswest_monitor = ns1.MonitoringJob("uswest_monitor",
            name="uswest",
            active=True,
            regions=[
                "lga",
                "sjc",
                "sin",
            ],
            job_type="tcp",
            frequency=60,
            rapid_recheck=True,
            policy="quorum",
            mute=True,
            config={
                "ssl": 1,
                "send": "HEAD / HTTP/1.0\\\\r\\\\n\\\\r\\\\n",
                "port": 443,
                "host": "example-elb-uswest.aws.amazon.com",
            },
            rules=[ns1.MonitoringJobRuleArgs(
                value="200 OK",
                comparison="contains",
                key="output",
            )])
        ```

        ## NS1 Documentation

        [MonitoringJob Api Doc](https://ns1.com/api#monitoring-jobs)

        ## Import

        ```sh
        $ pulumi import ns1:index/monitoringJob:MonitoringJob <name> <monitoringjob_id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Indicates if the job is active or temporarily disabled.
        :param pulumi.Input[Mapping[str, Any]] config: A configuration dictionary with keys and values depending on the job_type. Configuration details for each job_type are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        :param pulumi.Input[int] frequency: The frequency, in seconds, at which to run the monitoring job in each region.
        :param pulumi.Input[str] job_type: The type of monitoring job to be run. Refer to the NS1 API documentation (https://ns1.com/api#monitoring-jobs) for supported values which include ping, tcp, dns, http.
        :param pulumi.Input[bool] mute: turn off the notifications for the monitoring job.
        :param pulumi.Input[str] name: The free-form display name for the monitoring job.
        :param pulumi.Input[str] notes: Freeform notes to be included in any notifications about this job.
        :param pulumi.Input[int] notify_delay: The time in seconds after a failure to wait before sending a notification.
        :param pulumi.Input[bool] notify_failback: If true, a notification is sent when a job returns to an "up" state.
        :param pulumi.Input[bool] notify_regional: If true, notifications are sent for any regional failure (and failback if desired), in addition to global state notifications.
        :param pulumi.Input[int] notify_repeat: The time in seconds between repeat notifications of a failed job.
        :param pulumi.Input[str] policy: The policy for determining the monitor's global status
               based on the status of the job in all regions. See NS1 API docs for supported values.
        :param pulumi.Input[bool] rapid_recheck: If true, on any apparent state change, the job is quickly re-run after one second to confirm the state change before notification.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: The list of region codes in which to run the monitoring
               job. See NS1 API docs for supported values.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoringJobRuleArgs']]]] rules: A list of rules for determining failure conditions. Each rule acts on one of the outputs from the monitoring job. You must specify key (the output key); comparison (a comparison to perform on the the output); and value (the value to compare to). For example, {"key":"rtt", "comparison":"<", "value":100} is a rule requiring the rtt from a job to be under 100ms, or the job will be marked failed. Available output keys, comparators, and value types are are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoringJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NS1 Monitoring Job resource. This can be used to create, modify, and delete monitoring jobs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ns1 as ns1

        uswest_monitor = ns1.MonitoringJob("uswest_monitor",
            name="uswest",
            active=True,
            regions=[
                "lga",
                "sjc",
                "sin",
            ],
            job_type="tcp",
            frequency=60,
            rapid_recheck=True,
            policy="quorum",
            mute=True,
            config={
                "ssl": 1,
                "send": "HEAD / HTTP/1.0\\\\r\\\\n\\\\r\\\\n",
                "port": 443,
                "host": "example-elb-uswest.aws.amazon.com",
            },
            rules=[ns1.MonitoringJobRuleArgs(
                value="200 OK",
                comparison="contains",
                key="output",
            )])
        ```

        ## NS1 Documentation

        [MonitoringJob Api Doc](https://ns1.com/api#monitoring-jobs)

        ## Import

        ```sh
        $ pulumi import ns1:index/monitoringJob:MonitoringJob <name> <monitoringjob_id>`
        ```

        :param str resource_name: The name of the resource.
        :param MonitoringJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoringJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 job_type: Optional[pulumi.Input[str]] = None,
                 mute: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 notify_delay: Optional[pulumi.Input[int]] = None,
                 notify_failback: Optional[pulumi.Input[bool]] = None,
                 notify_list: Optional[pulumi.Input[str]] = None,
                 notify_regional: Optional[pulumi.Input[bool]] = None,
                 notify_repeat: Optional[pulumi.Input[int]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 rapid_recheck: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoringJobRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoringJobArgs.__new__(MonitoringJobArgs)

            __props__.__dict__["active"] = active
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            if job_type is None and not opts.urn:
                raise TypeError("Missing required property 'job_type'")
            __props__.__dict__["job_type"] = job_type
            __props__.__dict__["mute"] = mute
            __props__.__dict__["name"] = name
            __props__.__dict__["notes"] = notes
            __props__.__dict__["notify_delay"] = notify_delay
            __props__.__dict__["notify_failback"] = notify_failback
            __props__.__dict__["notify_list"] = notify_list
            __props__.__dict__["notify_regional"] = notify_regional
            __props__.__dict__["notify_repeat"] = notify_repeat
            __props__.__dict__["policy"] = policy
            __props__.__dict__["rapid_recheck"] = rapid_recheck
            if regions is None and not opts.urn:
                raise TypeError("Missing required property 'regions'")
            __props__.__dict__["regions"] = regions
            __props__.__dict__["rules"] = rules
        super(MonitoringJob, __self__).__init__(
            'ns1:index/monitoringJob:MonitoringJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            frequency: Optional[pulumi.Input[int]] = None,
            job_type: Optional[pulumi.Input[str]] = None,
            mute: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notes: Optional[pulumi.Input[str]] = None,
            notify_delay: Optional[pulumi.Input[int]] = None,
            notify_failback: Optional[pulumi.Input[bool]] = None,
            notify_list: Optional[pulumi.Input[str]] = None,
            notify_regional: Optional[pulumi.Input[bool]] = None,
            notify_repeat: Optional[pulumi.Input[int]] = None,
            policy: Optional[pulumi.Input[str]] = None,
            rapid_recheck: Optional[pulumi.Input[bool]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoringJobRuleArgs']]]]] = None) -> 'MonitoringJob':
        """
        Get an existing MonitoringJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Indicates if the job is active or temporarily disabled.
        :param pulumi.Input[Mapping[str, Any]] config: A configuration dictionary with keys and values depending on the job_type. Configuration details for each job_type are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        :param pulumi.Input[int] frequency: The frequency, in seconds, at which to run the monitoring job in each region.
        :param pulumi.Input[str] job_type: The type of monitoring job to be run. Refer to the NS1 API documentation (https://ns1.com/api#monitoring-jobs) for supported values which include ping, tcp, dns, http.
        :param pulumi.Input[bool] mute: turn off the notifications for the monitoring job.
        :param pulumi.Input[str] name: The free-form display name for the monitoring job.
        :param pulumi.Input[str] notes: Freeform notes to be included in any notifications about this job.
        :param pulumi.Input[int] notify_delay: The time in seconds after a failure to wait before sending a notification.
        :param pulumi.Input[bool] notify_failback: If true, a notification is sent when a job returns to an "up" state.
        :param pulumi.Input[bool] notify_regional: If true, notifications are sent for any regional failure (and failback if desired), in addition to global state notifications.
        :param pulumi.Input[int] notify_repeat: The time in seconds between repeat notifications of a failed job.
        :param pulumi.Input[str] policy: The policy for determining the monitor's global status
               based on the status of the job in all regions. See NS1 API docs for supported values.
        :param pulumi.Input[bool] rapid_recheck: If true, on any apparent state change, the job is quickly re-run after one second to confirm the state change before notification.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: The list of region codes in which to run the monitoring
               job. See NS1 API docs for supported values.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoringJobRuleArgs']]]] rules: A list of rules for determining failure conditions. Each rule acts on one of the outputs from the monitoring job. You must specify key (the output key); comparison (a comparison to perform on the the output); and value (the value to compare to). For example, {"key":"rtt", "comparison":"<", "value":100} is a rule requiring the rtt from a job to be under 100ms, or the job will be marked failed. Available output keys, comparators, and value types are are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoringJobState.__new__(_MonitoringJobState)

        __props__.__dict__["active"] = active
        __props__.__dict__["config"] = config
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["mute"] = mute
        __props__.__dict__["name"] = name
        __props__.__dict__["notes"] = notes
        __props__.__dict__["notify_delay"] = notify_delay
        __props__.__dict__["notify_failback"] = notify_failback
        __props__.__dict__["notify_list"] = notify_list
        __props__.__dict__["notify_regional"] = notify_regional
        __props__.__dict__["notify_repeat"] = notify_repeat
        __props__.__dict__["policy"] = policy
        __props__.__dict__["rapid_recheck"] = rapid_recheck
        __props__.__dict__["regions"] = regions
        __props__.__dict__["rules"] = rules
        return MonitoringJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if the job is active or temporarily disabled.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        A configuration dictionary with keys and values depending on the job_type. Configuration details for each job_type are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[int]:
        """
        The frequency, in seconds, at which to run the monitoring job in each region.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[str]:
        """
        The type of monitoring job to be run. Refer to the NS1 API documentation (https://ns1.com/api#monitoring-jobs) for supported values which include ping, tcp, dns, http.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def mute(self) -> pulumi.Output[Optional[bool]]:
        """
        turn off the notifications for the monitoring job.
        """
        return pulumi.get(self, "mute")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The free-form display name for the monitoring job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[str]]:
        """
        Freeform notes to be included in any notifications about this job.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="notifyDelay")
    def notify_delay(self) -> pulumi.Output[Optional[int]]:
        """
        The time in seconds after a failure to wait before sending a notification.
        """
        return pulumi.get(self, "notify_delay")

    @property
    @pulumi.getter(name="notifyFailback")
    def notify_failback(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, a notification is sent when a job returns to an "up" state.
        """
        return pulumi.get(self, "notify_failback")

    @property
    @pulumi.getter(name="notifyList")
    def notify_list(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "notify_list")

    @property
    @pulumi.getter(name="notifyRegional")
    def notify_regional(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, notifications are sent for any regional failure (and failback if desired), in addition to global state notifications.
        """
        return pulumi.get(self, "notify_regional")

    @property
    @pulumi.getter(name="notifyRepeat")
    def notify_repeat(self) -> pulumi.Output[Optional[int]]:
        """
        The time in seconds between repeat notifications of a failed job.
        """
        return pulumi.get(self, "notify_repeat")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[Optional[str]]:
        """
        The policy for determining the monitor's global status
        based on the status of the job in all regions. See NS1 API docs for supported values.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="rapidRecheck")
    def rapid_recheck(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, on any apparent state change, the job is quickly re-run after one second to confirm the state change before notification.
        """
        return pulumi.get(self, "rapid_recheck")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of region codes in which to run the monitoring
        job. See NS1 API docs for supported values.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.MonitoringJobRule']]]:
        """
        A list of rules for determining failure conditions. Each rule acts on one of the outputs from the monitoring job. You must specify key (the output key); comparison (a comparison to perform on the the output); and value (the value to compare to). For example, {"key":"rtt", "comparison":"<", "value":100} is a rule requiring the rtt from a job to be under 100ms, or the job will be marked failed. Available output keys, comparators, and value types are are found by submitting a GET request to https://api.nsone.net/v1/monitoring/jobtypes.
        """
        return pulumi.get(self, "rules")

