def 带分隔符打印(*args, 分隔符: str = " | ", 结束符: str = "\n") -> None:
    """
    打印多个值，自动使用指定分隔符连接，出现异常时安全忽略。

    Args:
        *args: 任意数量的待打印值（可为任意类型）。
        分隔符 (str): 各个值之间的分隔符，默认为 " | "。
        结束符 (str): 打印结尾字符，默认为换行符 "\\n"。

    Returns:
        None: 仅执行打印操作，无返回值。

    Example:
        a, b, c = 1, "苹果", 3.14
        带分隔符打印(a, b, c)
        # 输出: 1 | 苹果 | 3.14

        带分隔符打印(a, b, c, 分隔符=" ~ ")
        # 输出: 1 ~ 苹果 ~ 3.14
    """
    try:
        输出文本 = 分隔符.join(str(项) for 项 in args)
        print(输出文本, end=结束符)
    except Exception:
        print(f"打印失败，传递了异常参数，出现未知错误！")