def 加密(待加密文本, 密码):
    """
    使用简单的字符偏移算法对文本进行加密。

    参数:
        - 待加密文本 (str): 需要加密的文本。
        - 密码 (str): 用于加密的密码，建议使用至少5位的数字字符。

    返回:
        str: 加密后的文本。如果密码长度不足或包含非数字字符，则返回空字符串。

    示例:
        待加密文本 = "hello"
        加密的密码 = "12345"
        加密后文本 = 加密(待加密文本, 加密的密码)
        print("加密后文本:", 加密后文本)
    """
    # 检查密码长度
    if len(密码) < 5:
        return ""  # 密码太短

    # 检查密码是否由数字组成
    if not 密码.isdigit():
        return ""  # 非数字密码

    try:
        加密结果 = ""
        for i, 字符 in enumerate(待加密文本):
            # 根据密码的每一位数字，对字符进行偏移
            加密后字符 = chr(ord(字符) + int(密码[i % len(密码)]))
            加密结果 += 加密后字符
        return 加密结果
    except (ValueError, TypeError):  # 捕获具体的异常类型
        return ""
