def 十六进制替换(十六进制文本, 要替换的旧十六进制, 替换为的新十六进制):
    """
    将十六进制文本中的指定内容替换为新内容。

    参数:
        十六进制文本 (str): 十六进制文本。
        要替换的旧十六进制 (str): 要替换的十六进制内容。
        替换为的新十六进制 (str): 替换后的新十六进制内容。

    返回:
        str: 替换后的十六进制文本，如果出现任何异常，则返回 None。

    示例:
        十六进制文本 = "48 65 6c 6c 6f 2c 20 57 6f 72 6c 64 21"
        新的十六进制文本 = 十六进制替换(十六进制文本, "6c 6c", "aa")
        print("替换后的十六进制文本:", 新的十六进制文本)  # 输出: 48 65 aa 6f 2c 20 57 6f 72 6c 64 21
    """
    try:
        # 将十六进制字符串转换为字节列表
        字节列表 = bytes.fromhex(十六进制文本.replace(' ', ''))
        # 将要替换的十六进制内容转换为字节
        旧字节 = bytes.fromhex(要替换的旧十六进制)
        # 将新的十六进制内容转换为字节
        新字节 = bytes.fromhex(替换为的新十六进制)
        # 替换所有匹配的内容
        替换后的字节列表 = 字节列表.replace(旧字节, 新字节)
        # 将替换后的字节列表转换为十六进制字符串
        替换后的十六进制文本 = ' '.join([format(字节, '02x') for 字节 in 替换后的字节列表])
        return 替换后的十六进制文本
    except Exception:
        return None