def 取出中间文本(欲取全文本, 前面文本, 后面文本, 起始搜寻位置=None, 是否不区分大小写=False):
    """
    从全文本中提取位于前文本和后文本之间的中间文本。

    参数:
        欲取全文本 (str): 要搜索的全文本。
        前面文本 (str): 中间文本的前部分。
        后面文本 (str): 中间文本的后部分。
        起始搜寻位置 (int): 可选参数，指定搜索起始位置，默认为 None。
        是否不区分大小写 (bool): 是否不区分大小写，默认为 False。

    返回:
        str: 提取出的中间文本。如果出现任何异常或找不到指定的前后文本，则返回空字符串。

    示例:
        全文本 = "这是一个示例文本，中间包含了要取出的部分。"
        前文本 = "示例文本，中间包含了"
        后文本 = "部分。"
        中间文本 = zfx_textutils.取出中间文本(全文本, 前文本, 后文本)
        print("取出的中间文本:", 中间文本)
    """
    try:
        if 是否不区分大小写:
            欲取全文本 = 欲取全文本.lower()
            前面文本 = 前面文本.lower()
            后面文本 = 后面文本.lower()

        if 起始搜寻位置 is not None:
            起始索引 = 欲取全文本.find(前面文本, 起始搜寻位置)
        else:
            起始索引 = 欲取全文本.find(前面文本)

        if 起始索引 == -1:
            return ""

        起始索引 += len(前面文本)
        结束索引 = 欲取全文本.find(后面文本, 起始索引)
        if 结束索引 == -1:
            return ""

        return 欲取全文本[起始索引:结束索引]
    except Exception:  # 捕获所有异常
        return ""