def 解密(参数_待解密文本, 参数_解密的密码):
    """
    解密文本。

    参数:
        - 参数_待解密文本 (str): 待解密的文本。
        - 参数_解密的密码 (str): 解密的密码，建议使用5位以上的数字。

    返回:
        - str: 解密后的文本。如果密码长度不足或出现任何异常，则返回空字符串。

    示例:
        待解密文本 = "igopt"
        解密的密码 = "12345"
        解密后文本 = zfx_textutils.解密(待解密文本, 解密的密码)
        print("解密后文本:", 解密后文本)
    """
    try:
        if len(参数_解密的密码) < 5:  # 密码建议使用5位以上的数字
            return ""  # 密码长度不足，解密失败，返回空文本

        解密结果 = ""
        for i, 字符 in enumerate(参数_待解密文本):
            解密后字符 = chr(ord(字符) - int(参数_解密的密码[i % len(参数_解密的密码)]))
            解密结果 += 解密后字符
        return 解密结果
    except Exception:  # 捕获所有异常
        return ""