def 屏蔽_网页资源_全部(驱动器对象):
    """
    屏蔽网页中的所有高开销资源类型，包括图片、视频、字体、图标等，适用于极致加载优化场景。

    参数：
        - 驱动器对象：Selenium Chrome 浏览器驱动对象（webdriver.Chrome 实例）

    功能说明：
        本函数通过 Chrome DevTools 协议（CDP）屏蔽常见的媒体与视觉资源，
        可在执行自动化任务、表单填报、数据提取时大幅提升页面加载速度、减少带宽占用。

        屏蔽的资源类型包括：

        ✅ 图片（图像资源）：
            - *.jpg：常见网页图片格式
            - *.jpeg：JPEG 图片格式，常与 jpg 混用
            - *.png：支持透明背景的网页图片格式
            - *.gif：动态图像格式（动画）

        ✅ 视频与音频（媒体资源）：
            - *.mp4：常见网页视频格式（HTML5 视频）
            - *.webm：高效网页视频格式（开放格式，现代浏览器支持）
            - *.mp3：网页嵌入音频（背景音乐、语音提示）

        ✅ 字体资源（自定义网页字体）：
            - *.woff：Web Open Font Format，网页常用字体
            - *.woff2：woff 的压缩优化版本
            - *.ttf：TrueType Font，传统字体文件
            - *.otf：OpenType Font，功能更强的字体格式

        ✅ 图标资源（矢量图标）：
            - *.svg：可缩放矢量图，用于网页图标、LOGO、按钮等

    返回值：
        - 无返回值。屏蔽设置立即生效于当前页面的资源加载行为。

    注意事项：
        1. 调用本函数将覆盖当前所有屏蔽设置，如需更细粒度控制，请使用各资源类别的专用函数。
        2. 使用过程中网页的媒体播放器、图标区域可能出现加载失败或显示占位，属于正常现象。
        3. 本函数适用于 Chrome + Selenium 环境，不适用于远程 WebDriver。

    使用示例：
        from zfx.谷歌填表 import 屏蔽_网页资源_全部

        驱动器对象 = 初始化_普通模式(浏览器路径, 驱动器路径)
        屏蔽_网页资源_全部(驱动器对象)
    """
    try:
        驱动器对象.execute_cdp_cmd("Network.enable", {})
        驱动器对象.execute_cdp_cmd("Network.setBlockedURLs", {
            "urls": [
                "*.jpg", "*.jpeg", "*.png", "*.gif",       # 图片
                "*.mp4", "*.webm", "*.mp3",                # 视频/音频
                "*.woff", "*.woff2", "*.ttf", "*.otf",     # 字体
                "*.svg"                                     # 图标
            ]
        })
    except Exception:
        pass