def 屏蔽_网页资源_视频(驱动器对象):
    """
    屏蔽网页中的视频与音频资源，适用于自动化脚本中减少媒体加载、提升加载效率。

    参数：
        - 驱动器对象：Selenium Chrome 浏览器驱动对象（webdriver.Chrome 实例）

    功能说明：
        本函数通过 Chrome DevTools 协议（CDP）屏蔽网页中的音视频资源，
        避免页面在加载时播放视频、音频或预加载媒体文件，适合无需媒体渲染的自动化环境。

        屏蔽的媒体资源类型包括：
            - *.mp4：常见网页视频格式
            - *.webm：高效视频编码格式
            - *.mp3：网页嵌入音频格式（例如背景音乐）

    返回值：
        - 无返回值。CDP 命令成功执行后立即生效于当前页面加载行为。

    注意事项：
        1. 本功能需在使用 Chrome 浏览器并通过 Selenium 启动时有效。
        2. 每次调用会替换前一次设置的屏蔽资源列表，如需组合屏蔽其他资源，请使用组合函数或手动合并列表。
        3. 屏蔽后网页中相关音视频播放器可能会显示加载失败、黑屏或占位图。

    使用示例：
        from zfx.谷歌填表 import 屏蔽_网页资源_视频

        驱动器对象 = 初始化_普通模式(浏览器路径, 驱动器路径)
        屏蔽_网页资源_视频(驱动器对象)
    """
    try:
        驱动器对象.execute_cdp_cmd("Network.enable", {})
        驱动器对象.execute_cdp_cmd("Network.setBlockedURLs", {
            "urls": ["*.mp4", "*.webm", "*.mp3"]
        })
    except Exception:
        pass