def 获取最新十封邮件(服务器对象):
    """
    从已连接的 POP3 服务器中获取最新的十封邮件，以列表形式返回。

    参数：
        - 服务器对象 (poplib.POP3)：已连接并登录的 POP3 服务器对象。

    返回值：
        - list：如果获取成功，返回包含最新十封邮件原始内容的字节序列列表。
        - bool：如果获取失败或邮箱中没有邮件，返回 False。

    使用示例：
        邮件服务器 = zfx_pop3.登录('pop.服务器.com', '用户名', '密码')
        最新邮件列表 = zfx_pop3.获取最新十封邮件(邮件服务器)
        if 最新邮件列表:
            for idx, 邮件内容 in enumerate(最新邮件列表, 1):
                print(f"第 {idx} 封邮件内容: {邮件内容}")
        else:
            print("获取邮件失败或邮箱中无邮件")

    注意：
        - 此函数最多返回最新的十封邮件，如果邮箱中邮件少于十封，则返回全部邮件。
        - 返回的是原始邮件内容（字节序列），可以使用 email 模块对其进行解析和处理。
    """
    try:
        # 获取邮箱中的邮件数量和总大小
        邮件数量, _ = 服务器对象.stat()

        if 邮件数量 == 0:
            return False  # 如果邮箱中没有邮件，返回 False

        # 确定要获取的邮件数量（最多获取十封）
        获取邮件数量 = min(10, 邮件数量)

        # 初始化存储邮件内容的列表
        邮件列表 = []

        # 从最新开始获取邮件，编号从1开始，获取最新的十封邮件
        for i in range(邮件数量, 邮件数量 - 获取邮件数量, -1):
            响应状态, 邮件内容, _ = 服务器对象.retr(i)
            邮件完整内容 = b'\r\n'.join(邮件内容)
            邮件列表.append(邮件完整内容)

        return 邮件列表  # 返回最新十封邮件的字节序列列表
    except Exception:
        return False  # 捕获异常并返回 False