"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagRules = exports.NagRulePostValidationStates = exports.NagRuleCompliance = exports.NagMessageLevel = exports.VALIDATION_FAILURE_ID = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
exports.VALIDATION_FAILURE_ID = 'CdkNagValidationFailure';
/**
 * The severity level of the rule.
 */
var NagMessageLevel;
(function (NagMessageLevel) {
    NagMessageLevel["WARN"] = "Warning";
    NagMessageLevel["ERROR"] = "Error";
})(NagMessageLevel = exports.NagMessageLevel || (exports.NagMessageLevel = {}));
/**
 * The compliance level of a resource in relation to a rule.
 */
var NagRuleCompliance;
(function (NagRuleCompliance) {
    NagRuleCompliance["COMPLIANT"] = "Compliant";
    NagRuleCompliance["NON_COMPLIANT"] = "Non-Compliant";
    NagRuleCompliance["NOT_APPLICABLE"] = "N/A";
})(NagRuleCompliance = exports.NagRuleCompliance || (exports.NagRuleCompliance = {}));
/**
 * Additional states a rule can be in post compliance validation
 */
var NagRulePostValidationStates;
(function (NagRulePostValidationStates) {
    NagRulePostValidationStates["SUPPRESSED"] = "Suppressed";
    NagRulePostValidationStates["UNKNOWN"] = "UNKNOWN";
})(NagRulePostValidationStates = exports.NagRulePostValidationStates || (exports.NagRulePostValidationStates = {}));
/**
 * Helper class with methods for rule creation
 */
class NagRules {
    /**
     * Use in cases where a primitive value must be known to pass a rule.
     * https://developer.mozilla.org/en-US/docs/Glossary/Primitive
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return a value if resolves to a primitive data type, otherwise throw an error.
     */
    static resolveIfPrimitive(node, parameter) {
        const resolvedValue = aws_cdk_lib_1.Stack.of(node).resolve(parameter);
        if (resolvedValue === Object(resolvedValue)) {
            throw Error(`The parameter resolved to to a non-primitive value "${JSON.stringify(resolvedValue)}", therefore the rule could not be validated.`);
        }
        else {
            return resolvedValue;
        }
    }
    /**
     * Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule.
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return the Logical resource Id if resolves to a intrinsic function, otherwise the resolved provided value.
     */
    static resolveResourceFromInstrinsic(node, parameter) {
        const resolvedValue = aws_cdk_lib_1.Stack.of(node).resolve(parameter);
        const ref = resolvedValue?.Ref;
        const getAtt = resolvedValue?.['Fn::GetAtt'];
        if (ref != undefined) {
            return ref;
        }
        else if (Array.isArray(getAtt) && getAtt.length > 0) {
            return getAtt[0];
        }
        return resolvedValue;
    }
}
exports.NagRules = NagRules;
_a = JSII_RTTI_SYMBOL_1;
NagRules[_a] = { fqn: "cdk-nag.NagRules", version: "2.28.126" };
//# sourceMappingURL=data:application/json;base64,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