import pytest

from starknet_py.constants import (
    DEFAULT_ENTRY_POINT_NAME,
    DEFAULT_ENTRY_POINT_SELECTOR,
    DEFAULT_L1_ENTRY_POINT_NAME,
)
from starknet_py.hash.selector import get_selector_from_name

# fmt: off


@pytest.mark.parametrize(
    "value, selector",
    [
        (DEFAULT_ENTRY_POINT_NAME, DEFAULT_ENTRY_POINT_SELECTOR),
        (DEFAULT_L1_ENTRY_POINT_NAME, DEFAULT_ENTRY_POINT_SELECTOR),
        ("a", 1247650000417123719142308899207783949116295758836619114717800638088997106123),
        ("a" * 32, 1639766182393060139699536825713183380146349476460289054183902158918808727042),
        ("a" * 64, 96895255643671738432263532767971916031595176428400706637069408720254155666),
        ("function_name", 1149639848148111379680850217760201712915686151121335401965830059977414798617),
        ("another_function_name", 185510097891389418066086344733255734231442981008241915970875484770947426608),
    ]
)
def test_get_selector_from_name(value, selector):
    assert get_selector_from_name(value) == selector
