"""
    Ory APIs

    Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers.   # noqa: E501

    The version of the OpenAPI document: v0.0.1-alpha.91
    Contact: support@ory.sh
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ory_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from ory_client.exceptions import ApiAttributeError


def lazy_import():
    from ory_client.model.string_slice_json_format import StringSliceJSONFormat
    globals()['StringSliceJSONFormat'] = StringSliceJSONFormat


class ProjectRevisionThirdPartyLoginProvider(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'apple_private_key': (str,),  # noqa: E501
            'apple_private_key_id': (str,),  # noqa: E501
            'apple_team_id': (str,),  # noqa: E501
            'auth_url': (str,),  # noqa: E501
            'azure_tenant': (str,),  # noqa: E501
            'client_id': (str,),  # noqa: E501
            'client_secret': (str,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'issuer_url': (str,),  # noqa: E501
            'label': (str,),  # noqa: E501
            'mapper_url': (str,),  # noqa: E501
            'project_revision_id': (str,),  # noqa: E501
            'provider': (str,),  # noqa: E501
            'provider_id': (str,),  # noqa: E501
            'requested_claims': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'scope': (StringSliceJSONFormat,),  # noqa: E501
            'token_url': (str,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'apple_private_key': 'apple_private_key',  # noqa: E501
        'apple_private_key_id': 'apple_private_key_id',  # noqa: E501
        'apple_team_id': 'apple_team_id',  # noqa: E501
        'auth_url': 'auth_url',  # noqa: E501
        'azure_tenant': 'azure_tenant',  # noqa: E501
        'client_id': 'client_id',  # noqa: E501
        'client_secret': 'client_secret',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
        'id': 'id',  # noqa: E501
        'issuer_url': 'issuer_url',  # noqa: E501
        'label': 'label',  # noqa: E501
        'mapper_url': 'mapper_url',  # noqa: E501
        'project_revision_id': 'project_revision_id',  # noqa: E501
        'provider': 'provider',  # noqa: E501
        'provider_id': 'provider_id',  # noqa: E501
        'requested_claims': 'requested_claims',  # noqa: E501
        'scope': 'scope',  # noqa: E501
        'token_url': 'token_url',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
    }

    read_only_vars = {
        'created_at',  # noqa: E501
        'updated_at',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """ProjectRevisionThirdPartyLoginProvider - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            apple_private_key (str): Apple Private Key  Sign In with Apple Private Key needed for generating a JWT token for client secret. [optional]  # noqa: E501
            apple_private_key_id (str): Apple Private Key Identifier  Sign In with Apple Private Key Identifier needed for generating a JWT token for client secret. [optional]  # noqa: E501
            apple_team_id (str): Apple Developer Team ID  Apple Developer Team ID needed for generating a JWT token for client secret. [optional]  # noqa: E501
            auth_url (str): AuthURL is the authorize url, typically something like: https://example.org/oauth2/auth Should only be used when the OAuth2 / OpenID Connect server is not supporting OpenID Connect Discovery and when `provider` is set to `generic`.. [optional]  # noqa: E501
            azure_tenant (str): Tenant is the Azure AD Tenant to use for authentication, and must be set when `provider` is set to `microsoft`.  Can be either `common`, `organizations`, `consumers` for a multitenant application or a specific tenant like `8eaef023-2b34-4da1-9baa-8bc8c9d6a490` or `contoso.onmicrosoft.com`.. [optional]  # noqa: E501
            client_id (str): ClientID is the application's Client ID.. [optional]  # noqa: E501
            client_secret (str): ClientSecret is the application's secret.. [optional]  # noqa: E501
            created_at (datetime): The Project's Revision Creation Date. [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            issuer_url (str): IssuerURL is the OpenID Connect Server URL. You can leave this empty if `provider` is not set to `generic`. If set, neither `auth_url` nor `token_url` are required.. [optional]  # noqa: E501
            label (str): Label represents an optional label which can be used in the UI generation.. [optional]  # noqa: E501
            mapper_url (str): Mapper specifies the JSONNet code snippet which uses the OpenID Connect Provider's data (e.g. GitHub or Google profile information) to hydrate the identity's data.  It can be either a URL (file://, http(s)://, base64://) or an inline JSONNet code snippet.. [optional]  # noqa: E501
            project_revision_id (str): [optional]  # noqa: E501
            provider (str): Provider is either \"generic\" for a generic OAuth 2.0 / OpenID Connect Provider or one of: generic google github gitlab microsoft discord slack facebook vk yandex apple. [optional]  # noqa: E501
            provider_id (str): ID is the provider's ID. [optional]  # noqa: E501
            requested_claims ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            scope (StringSliceJSONFormat): [optional]  # noqa: E501
            token_url (str): TokenURL is the token url, typically something like: https://example.org/oauth2/token  Should only be used when the OAuth2 / OpenID Connect server is not supporting OpenID Connect Discovery and when `provider` is set to `generic`.. [optional]  # noqa: E501
            updated_at (datetime): Last Time Project's Revision was Updated. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ProjectRevisionThirdPartyLoginProvider - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            apple_private_key (str): Apple Private Key  Sign In with Apple Private Key needed for generating a JWT token for client secret. [optional]  # noqa: E501
            apple_private_key_id (str): Apple Private Key Identifier  Sign In with Apple Private Key Identifier needed for generating a JWT token for client secret. [optional]  # noqa: E501
            apple_team_id (str): Apple Developer Team ID  Apple Developer Team ID needed for generating a JWT token for client secret. [optional]  # noqa: E501
            auth_url (str): AuthURL is the authorize url, typically something like: https://example.org/oauth2/auth Should only be used when the OAuth2 / OpenID Connect server is not supporting OpenID Connect Discovery and when `provider` is set to `generic`.. [optional]  # noqa: E501
            azure_tenant (str): Tenant is the Azure AD Tenant to use for authentication, and must be set when `provider` is set to `microsoft`.  Can be either `common`, `organizations`, `consumers` for a multitenant application or a specific tenant like `8eaef023-2b34-4da1-9baa-8bc8c9d6a490` or `contoso.onmicrosoft.com`.. [optional]  # noqa: E501
            client_id (str): ClientID is the application's Client ID.. [optional]  # noqa: E501
            client_secret (str): ClientSecret is the application's secret.. [optional]  # noqa: E501
            created_at (datetime): The Project's Revision Creation Date. [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            issuer_url (str): IssuerURL is the OpenID Connect Server URL. You can leave this empty if `provider` is not set to `generic`. If set, neither `auth_url` nor `token_url` are required.. [optional]  # noqa: E501
            label (str): Label represents an optional label which can be used in the UI generation.. [optional]  # noqa: E501
            mapper_url (str): Mapper specifies the JSONNet code snippet which uses the OpenID Connect Provider's data (e.g. GitHub or Google profile information) to hydrate the identity's data.  It can be either a URL (file://, http(s)://, base64://) or an inline JSONNet code snippet.. [optional]  # noqa: E501
            project_revision_id (str): [optional]  # noqa: E501
            provider (str): Provider is either \"generic\" for a generic OAuth 2.0 / OpenID Connect Provider or one of: generic google github gitlab microsoft discord slack facebook vk yandex apple. [optional]  # noqa: E501
            provider_id (str): ID is the provider's ID. [optional]  # noqa: E501
            requested_claims ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            scope (StringSliceJSONFormat): [optional]  # noqa: E501
            token_url (str): TokenURL is the token url, typically something like: https://example.org/oauth2/token  Should only be used when the OAuth2 / OpenID Connect server is not supporting OpenID Connect Discovery and when `provider` is set to `generic`.. [optional]  # noqa: E501
            updated_at (datetime): Last Time Project's Revision was Updated. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
