jumper_colors = [
    "#FF6B2C",  # Warm, energetic orange
    "#2CA891",  # Cool teal
    "#F2CF82",  # Pale golden yellow
    "#267FA0",  # Steel blue
    "#D39244",  # Burnished warm bronze
    "#8BCD4A",  # Bright, lively green
    "#9E633F",  # Rustic terracotta
    "#289FB0",  # Muted cyan
    "#FFA033",  # Soft amber
    "#415B80",  # Dimmed blue-gray
    "#C4D250",  # Fresh, light chartreuse
    "#6A8389",  # “Puddle Jumper” muted teal-gray
    "#F4E8A0",  # Creamy light yellow
    "#2E6F90",  # Deep slate blue
    "#5ABF7F",  # Balanced teal-green
    "#7C8D93",  # Gray-blue
    "#96A5AE",  # Light, airy blue-gray
    "#6C919F",  # “Wave Jumper” muted bluish-gray
    "#617B89",  # Slate gray
    "#B0BCC5",  # Soft neutral gray
]

# Now, the logo

logo_image = (
    "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAABJ4AAAJPCAYAAAA9oR5aAAAg"
    "AElEQVR4nOzde3Bk6Xkf5vegNqlSxTEQpZKoZFnTdFJOHJc9YFWqYIq7O70L6i56QFlWWY"
    "mW07M7wM5SYBZLypJ8kbfXjiyRIkWsuOIuZ2Z3e0SVpfJFwtiJU7ECs0eRRSFOIowiW5Zs"
    "iw1dGN0DyFJ0n84f3ZjBYHDpRvfpr885z1PVNTON06d/PewFp394v+9k3W43AIA0/sNXby"
    "zNRNSziPmZiAtZFpFFxExEZBG3s4i1X7x6ZTt1znF75s1rtaz3updmIuaziHMHXndkWdyZ"
    "iVh/ubHSSpsUAIBRZIonAJisz+qVTUtZ7za7X7bMRMSh4imyiL2ZiPnPXL3SSRh5LN79xr"
    "W5mYhGFtGYyeJ8//UdfK0Hi6f9399cb6w0koUGAGAkiicAmIB/72M3eqVLFmtZxLmjypZj"
    "iqeYibj5matXGomij+xr37hWyyKaWcSle681O6JsiiOLp5iJeOk7GivNNOkBABjFI6kDAE"
    "CZzfQKp7UsYi0iZs94mksR0Rhfqsn4mn7hNNPLP4pGRDRHTwQAwKSZeAKAnGQfu7HWL15m"
    "T5loOm3iKbKIt/5CQfZ6+urXr8/NZN1mFvH8sa91uImnyCLe8uHGSmfiLwYAgJGYeAKAMX"
    "vk1evz3YhWRHZ+jKedG+O5cvMXX7++lEW04uzTXcepRURnzOcEACBniicAGKN//7VraxHZ"
    "R1LnmLSvfP36XBaxPoZldQAAlIjiCQDG4LM+/vG5bjdrRcTF1Fkm7V2vX5/vTzmNc8ILAI"
    "ASmEkdAACK7j/4+GvzEdGOfEun+RzPfWYXX79ej95rVzoBAPAQE08AMII/cu1e6TTuPY0O"
    "m7o9nv7869cbWcSbqXMAADC9TDwBwBn90WuvTqp0mjrvfP16IyZbOk3lxBcAACdTPAHAGc"
    "xd/1hlS6cvn3zpFDGFE18AAJxO8QQAQ/rsCpdOX3bj+lJYXgcAwIAUTwAwhP/4xnfNRe8K"
    "bpUrnb70xvX56L12AAAYiOIJAIbTigpewe2Lb1yfi4iNqGDhBgDA2SmeAGBA/8mNV9Yi4m"
    "LqHIm0IuJc6hAAABSL4gkABvCfvf7KfER8JHWOFL7oxvUqF24AAIxA8QQAg2mlDpDCO25c"
    "r0VEM3EMAAAKSvEEAKf4nNc/uhYV3Nepbz3s6wQAwBkpngDgBJ/7xkfnoqITP4s3rtfDEj"
    "sAAEageAKAk61FdSd+WqkDAABQbIonADjG573xnbWIeDF1jhSevHG9Ea5iBwDAiBRPAHC8"
    "tdQBEmqmDgAAQPEpngDgCH/8zZfnIqKROkcK9d7eTqadAAAYmeIJAI62FNXd26nKk14AAI"
    "yR4gkAjlbJ8uXC9eu1cCU7AADGRPEEAIece/Pl+Yg4nzpHIkupAwAAUB6KJwB4WCN1gIQa"
    "qQMAAFAeiicAeFg9dYAUHr9+fS6qO+kFAEAOFE8AcMBbWuu1qG75YpkdAABjpXgCgAfVUw"
    "dIqJ46AAAA5aJ4AoAH1VMHSGg+dQAAAMpF8QQAD6py+VLVJYYAAORE8QQAD6pk+fLo9ev1"
    "1BkAACgfxRMA9P2Jmx+pp86Q0FzqAAAAlI/iCQDuq3L5UuUlhgAA5ETxBAD3KV8AAGCMFE"
    "8AQES1p70AAMiJ4gkA7pvmiaftnM8/za8dAICCUjwBwH3TPPWzm/P58y62AACoIMUTABCR"
    "f7E1qnbqAAAADE/xBABERHRSBwAAoHwUTwBAhOIJAIAcKJ4AgPjh5eV26gwAAJSP4gkA7p"
    "v2fY7ydid1AAAAykXxBAD3Vf3KblV//QAAjJniCQDY104dAACAclE8AcB9VZ/4qfrrBwBg"
    "zBRPAHBfpfd4+qHl5e2I2Eud4xid1AEAABie4gkA+n7m0gvt1BmmwFROPX24sdJJnQEAgO"
    "EpngDgQVW/sls7dQAAAMpD8QQAD5rKiZ8JqvrrBwBgjBRPAPCgduoAiU1l8fT+1rX51BkA"
    "ABie4gkAHrSROkBKt5eXO6kzHGMudQAAAIaneAKAAz7dWNsN+zztpA5wBBNPAAAFpHgCgI"
    "e1UgdIrJM6wBHqqQMAADA8xRMAPKyVOsARqj7xc/H9rWu11CEAABiO4gkADtm5/PxuRNxM"
    "neOQ+gSfa1r3U1pLHQAAgOEongDgaK3UAQ65+Hmv3ahN6LnOT+h5hvW8q9sBABSL4gkAjv"
    "Bzl59vR8Tt1DkOaeX9BBeuX1/K+zlG1P565RMAQGEongDgeM3UAQ658Pkfv97K+TmaOZ9/"
    "VLPRK58aqYMAAHC6rNvtps4AAFPrc9/4aPtuNy50I4u73Yi7kUW3m8XdiLjbzfp/fvj+bv"
    "/XLHo/5bn3axYP3DfM17OImMm6kUXcmYlY+/Szy+1xvc5Hr1+fm4loZREXs+yEfP2Mx+Z7"
    "MOcJXz/58QefY//XfQd+fyci1iNi40ONld1x/V0wPt/23dfrh+/LjjjuyPuzo4895fGd9z"
    "+13BkoHAAwEYonADjB577x0drdbnx6yoqn/ft2soiNmYh2FrH908+e/oH7v7l2fS7LYv7A"
    "OedmIupZRGMmYvakYmkKi6eD7mQRnYjYjlOOPba4OOILZyg+6iM+ftTnP/hC5rIj9uvK/f"
    "nH9fizFU/77kTEdhax8b6nljeOeQgAMAGKJwA4xee8/tFmN7IXp7B4OuLrx5RFcXpxNOrX"
    "ExdPoxcf4yme0j/+wAspZP4Dd4zp+feiNxm3/r6nlk3GAcCE2eMJAE7xi8+8txm9CQqgeG"
    "Yj4sWI2P6OT1y3MT0ATJjiCQAGsxS9yQmgmM5FRPsjyicAmCjFEwAM4JeeWe1Er3wCims2"
    "IjY+8onrc6mDAEBVKJ4AYEC/cmW1HRGXU+cARnIuIhqpQwBAVSieAGAIv3bl61qhfIKiW0"
    "sdAACqQvEEAEP69eX3tEL5BEV27iOfuF5LHQIAqkDxBABnsHu/fLLhOBRTLXUAAKgCxRMA"
    "nNFvrDzXioh6ROykTQKcQS11AACoAsUTAIzgN1eubkfEfETcSp0FGEotdQAAqALFEwCM6L"
    "eevbr7288+uxQR7wrTTwAAcI/iCQDG5HeurmxEb/rppbD3EwAAKJ4AYJx+7+rK7h88t9yM"
    "3jIeBRQAAJX2SOoAAFBGf/jc8m5ENCOi+cjHbjQiYikiLqbMBDxgPnUAAKgCE08AkLM/eM"
    "+V1u+/58pSRPxHEXE5ehuRm4SCtOZSBwCAKjDxBAAT8rvvubIbEa3+Lf7Iqzdq0Zu6qEdv"
    "IupcmmQAAJAPxRMAJPKbz13pREQnIjYiYu2zX71Rj4hGRFxKFgoAAMbIUjsAmBK//tyV9q"
    "9dvdKIiLdGxJ3EcQAAYGSKJwCYMr969cr2L1+9Mh8RL6fOAiW2nToAAFSBpXYAMKV+6eqV"
    "tc957cZ2RLyZOssY7UREO3pLDA/a3+tqdrJxqLDd1AEAoAoUTwAwxX7x6pXW5752ox7F3/"
    "fpdkQ0W0+vtE866OvevLYUEWsRcWECmQAAyFnW7XZTZwAATvHHXruxnUWcn8m6kUVvrXzW"
    "vz3w++zB+448Ljv6/lG//sCx/ZxZxN5MRON7nl7ZGOb1vrd1bWkmopVFzO6fc192zGOOun"
    "/Q+yJ6r2ukx4/6/ON6/IEXUsj8B+7I+flfeuGp5eYxpwMAxsQeTwBQDGupA5zBXkTUhy2d"
    "IiI+2ljZiN7Su71xhwIAYHIUTwBQAL9w9Uo7Im6lzjGk+t95euXMGzi/3FjZjl75BABAQS"
    "meAKA41lMHGMJL3ztC6bRvvVc+vTSGPAAAJKB4AoCC+Pne1NNO6hwDGmdJth6W3DF+7dQB"
    "AKAKFE8AUCxD75eUwM3ve3plbJeq/47Gym4U43UDAHCI4gkAiqWdOsAA2jmcU/EEAFBAii"
    "cAKJaR902agE4O5yzC6wYA4BDFEwAUyM8+u9yJ6d/vaOwl0YcbK51xnxMAgPwpngCgeKZ6"
    "+ufvPrM8tv2dIEed1AEAoAoUTwDAWH3169fr4z7n+1vX5sZ9TqrthaeWO6kzAEAVKJ4AoH"
    "jaqQOcIo+SaD6HcwIAkDPFEwAwbvUczrmUwzkBAMiZ4gkAGLc8SiLFEwBAASmeAIBxO/eX"
    "3rjWGNfJ3te61oiIc+M6H8T0XxkSAEpD8QQA5GH9a94YfUPwtd6m4utjyAMHtVMHAICqUD"
    "wBAHmYjYj2fztC+fR8r3Rq988F47SROgAAVIXiCQDIy/mIaH/tG9dqwz7wva1rteiVTufH"
    "GwliJxRPADAxj6QOAACU2vmI2H7qjWvrWcT6dz+9snvSwV/35rW5LGIty2ItTDqRj8YLTy"
    "2f+D4EAMZH8QQA5G02Il6MiLXGG9c2soj2TBadLGI7i4iZiPksopZF1Gd6V69TOJGHveiV"
    "Tu3UQQCgShRPAMCkzEbEpf4NJmUvekvr1t5n0gkAJk7xBABA2eyXTRvve2rZfk4AkJDiCQ"
    "CKp5Y6AEyhe2XT+5VNADA1FE8AUDy11AFgSiibAGDKKZ4AACiSneiVTa2vf2p5O3UYAOBk"
    "iicAAKadsgkACkrxBADANLq3jO4vW0YHAIWleAIAYFrcK5u+QdkEAKWgeAIAIKX7ZdO7lU"
    "0AUDaKJwAonlrqADCie2XTNyqbAKDUFE8AUDznUgeAM1A2AUAFKZ4AAMjLvbLpm5RNAFBJ"
    "iicAAMbtZiibAIBQPAEAMB63oj/d9FfevbybOgwAMB0UTwAAnJWyCQA4keIJAIBh3Cub/q"
    "qyCQA4heIJAIDTKJsAgDNRPAEAcJTbEdGKiI2/pmwCAM5I8QQAwL470S+b/vq7lztpowAA"
    "ZaB4AgCoNmUTAJAbxRMAQPXcK5u+WdkEAORI8QQABfL5H79ez1KHoKiUTQDAxCmeAADK61"
    "7Z9DeUTQBAAoonAIByUTYBAFND8QQAUHz3yqYXlU0AwBRRPAEAFNO9sql5aaWTNgoAwNEU"
    "TwAAxaFsAgAKRfEEADDdbkVEOyI2XlI2AQAFo3gCAJg+tyJiI3pl027qMAAAZ6V4AgCYDv"
    "fKpr+pbAIASkLxBACQxl70i6aIaCubAIAyUjwBAEzOTvT3a/pbl1Y2EmcBAMid4gkAIF87"
    "0Ztqav0Pl1a2U4cBAJgkxRMAwPjdiYhWRLSVTQBAlSmeAADGY39z8Pa3XFrpJM4CADAVFE"
    "8AAGezv4SuHb2yyebgAACHKJ4AAAa3v4Ru42+bagIAOJXiCQDgZDvRK5ta36psAgAYiuIJ"
    "AOBoOxHR/NZLK63UQQAAikrxBADwoL2IaH7bpZX11EEAAIpO8QQAcN+diFj6NkvqAADGQv"
    "EEANBz89surTRShwAAKJOZ1AEAAKaA0gkAIAeKJwCg6m5/oKF0AgDIg+IJAKiyvYhopA4B"
    "AFBWiicAoMrWP9CwkTgAQF4UTwBAVe1FxHrqEAAAZaZ4AgCqauMDjZXd1CEAAMpM8QQAVN"
    "VG6gAAAGWneAIAqqqdOgAAQNkpngCASrLMDgAgf4onAKCKbqcOAABQBYonAAAAAHKheAIA"
    "AAAgF4onAKCK5lMHAACoAsUTAFBFs6kDAABUgeIJAAAAgFwongCgQH722eV26gwAADAoxR"
    "MAAAAAuVA8AQCV9I2ta7XUGQAAyk7xBABUVS11AACAslM8AQAAAJALxRMAAAAAuVA8AQAA"
    "AJALxRMAAAAAuVA8AQAAAJALxRMAAAAAuVA8AQAAAJALxRMAAAAAuVA8AQAAAJALxRMAAA"
    "AAuVA8AQAAAJALxRMAAAAAuVA8AQAAAJALxRMAAAAAuVA8AQAAAJALxRMAUFWd1AEAAMpO"
    "8QQAVNIHGiud1BkAAMpO8QQAAABALhRPAAAAAORC8QQAAABALhRPAEAV7aQOAABQBYonAK"
    "CKOqkDAABUgeIJAAAAgFwongAAAADIheIJAKii7dQBAACqQPEEAFTRbuoAAABVoHgCAAAA"
    "IBeKJwCgiiy1AwCYAMUTAFBFltoBAEyA4gkAqCLFEwDABCieAIDK+UBjxVI7AIAJUDwBAA"
    "AAkAvFEwBQNbdTBwAAqArFEwAAAAC5UDwBAFXTTh0AAKAqFE8AAAAA5ELxBAAF8vkfv15P"
    "naEE2qkDAABUheIJAIplPnWAEthNHQAAoCoUTwBQLEupAxTdBxor26kzAABUheIJAAri81"
    "67UY+IC6lzFNxO6gAAAFWieAKAAvhjr92Yi4j11DlKoJM6AABAlSieAKAY1iPifOoQJdBO"
    "HQAAoEoeSR0AADje57x2Y24mYiOzxG5cOqkDAABUieIJAKbQf/rajbksYi2LWIuI2dR5Sq"
    "STOgAAQJUongBgSnz2qzfmsizqWcTSTO/qdQqnMftgY6WdOgMAQJUonqBifviTf7QWkdUi"
    "suhGFtG71boRtch6fz5wf3Qjm4/I5u7dlz309Qd/n2UXDt7/8NcjImaiG3H0ObKHz33a1x"
    "/4/ZH5Irr7W9qdnv/Ycx/99ei/lohu99Cf7/3av7978P7s4eO6x9wfEdE95v7947sP33//"
    "sUdkeeDcD97fjYi73d5rvNuNuBtZ/8/9+w/cd7f/uu/2j+0eOvbu/XPduduN3buR9Y/fP9"
    "fBY/Yfc9xzHP1ch8918JjD5zr6tT14rm73pNe2f86sczeiczjvUa8ni96Givd+zeKB+7KI"
    "+ZmIuSyiNhNxLsjTndQBAACqRvEEBba1mc1FZPP9EmQ+snsF0cGyqNaN7Nx+KbNfSMCElW"
    "1TbPstFVMndQAAgKpRPMGUu3Mrq3dnYq47E/PdLGp3Z6LW7d3O6ZAAhrKdOgAAQNUonmBK"
    "/Kvvzea7Wcx3Z3q3u72iaXZ/hRgAI2unDgAAUDWKJ0jgZ97Iav0JpvrdXtF0QcEEkDsTTw"
    "AAE6Z4ggn4uVezue5M1O/ORL2bxVLM2EAYYMJ2PthY2U0dAgCgahRPkJPPfGc2152JpX7R"
    "dDF1HoCKa6cOAABQRYonGKNf/nA2181i6e6MsglgylhmBwCQgOIJxuBXP5DVujPRjJlYio"
    "jZ1HkAeEg7dQAAgCpSPMEIfv1vZ/VuFs2YiQupswBwrL0PNlZMPAEAJKB4gjPY+5tZvT/h"
    "pHACmH5KJwCARBRPMIR/92JW62axbv8mgEJppw4AAFBVM6kDQFH85jdnzYj4dITSCaBg2q"
    "kDAABUlYknOMVv/9VsvptFK2bifOosAAzvg42VduoMAABVZeIJTvA735StRcSPRSidAArq"
    "VuoAAABVZuIJjvB7X5/NdWeiZS8ngMJrpw4AAFBliic45Pffn81FFu0w5QRQBu3UAQAAqs"
    "xSOzjgD1/I5iOiE0ongDLY+WBjZTt1CACAKlM8Qd/d57P56P1kfDZxFADGo506AABA1Sme"
    "ICK671U6AZTQRuoAAABVp3iC1awWSieAMmqnDgAAUHWKJ6ptNZuL3k/ElU4A5XLr2xsru6"
    "lDAABUneKJqmuFjcQBysgyOwCAKaB4orpWs2ZEXEwdA4BctFMHAABA8URVrWbzEfFi6hgA"
    "5OLOtzdWOqlDAACgeKKK7u/rBEA5tVIHAACgR/FEFTUj4lzqEADkxg8XAACmhOKJauktsX"
    "s+dQwAcmOZHQDAFFE8UTXrqQMAkCvf5wEApojiiepYzZYi4kLqGADkyjI7AIAponiiSvwU"
    "HKDcbn17Y2U3dQgAAO5TPFENq1kjbCgOUHat1AEAAHiQ4omqaKYOAECu9r69sWKZHQDAlF"
    "E8UX69vZ1MOwGUWyt1AAAAHqZ4ogrWUgcAIHf28QMAmEKKJ8ptNauFK9kBlN2dDzVWOqlD"
    "AADwMMUTZddMHQCA3Jl2AgCYUoonym4pdQAAcrX3ocZKK3UIAACOpniivFazRkTMpo4BQK"
    "5aqQMAAHA8xRNlZtoJoPwsswMAmGKKJ8ppNZuLiIupYwCQq1s2FQcAmG6KJ8rKtBNA+Zl2"
    "AgCYcoonykrxBFBudz7UWGmnDgEAwMkUT5RVPXUAAHJl2gkAoAAUT5TPalYPV7MDKLOdDz"
    "VWWqlDAABwOsUTZWSZHUC5NVMHAABgMIonyqieOgAAuTHtBABQIIonymU1m4uI86ljAJCb"
    "VuoAAAAMTvFE2dRTBwAgN3thU3EAgEJRPFE286kDAJCb9Q83VnZThwAAYHCKJ8qmnjoAAL"
    "nYCdNOAACFo3iibC6kDgBALpqmnQAAikfxRHmsZpbZAZTTzoddyQ4AoJAUT5SJ4gmgnJqp"
    "AwAAcDaKJ8pE8QRQPne+w7QTAEBhKZ4oE8UTQPmspQ4AAMDZKZ4oE8UTQLncXm+stFOHAA"
    "Dg7BRPlMNqNhcRs6ljADBWjdQBAAAYjeKJsjDtBFAuL73cWOmkDgEAwGgUT5SF4gmgPPYi"
    "Yj11CAAARqd4oizmUgcAYGzWPtpY2U0dAgCA0SmeKIt66gAAjMXtVy6vtFKHAABgPBRPlI"
    "WJJ4ByWEsdAACA8VE8URbnUwcAYGQvfdflle3UIQAAGB/FE8W3mpl2Aii+nVcvrzRThwAA"
    "YLwUT5SBK9oBFF8jdQAAAMZP8UQZmHgCKLaXX7u80k4dAgCA8VM8UQYmngCKaycimqlDAA"
    "CQD8UTAJBS4+OXV3ZThwAAIB+KJ8qgnjoAAGfy8nVL7AAASk3xBACkcCcssQMAKD3FE2Vg"
    "c3GA4mncsMQOAKD0FE+UwfnUAQAYyguvX17ZTh0CAID8KZ4AgEm6/ebTK+upQwAAMBmKJ4"
    "ptNauljgDAwPYiYil1CAAAJkfxRNHVUgcAYGBLraft6wQAUCWKJwBgEl767qdX2qlDAAAw"
    "WYonis4V7QCm361PPL3STB0CAIDJUzxRdPOpAwBwop2IaKQOAQBAGoonACAvexGx9D32dQ"
    "IAqCzFEwCQl7W/8/TKduoQAACko3ii6OzxBDCdLn/v0yut1CEAAEhL8UTR2eMJYPq8/H1K"
    "JwAAQvEEAEVzMyLeEr39k6bRzb/7zPJa6hAAAEwHxRMAFMfOzz673Nh5drkTEUupwxzhTk"
    "QonQAAuEfxBADFsb7/m08/u9yO3vTTtNiJiPrfe2bZFewAALhH8UTR2VwcqJL2oT83E2Q4"
    "yl5ELP0DpRMAAIconii686kDAEzI3s9fvbJ98I6f6S25m4app8b3P7O8ffphAABUjeIJAI"
    "rhuGJn/Zj7J+XyDzyzvJE4AwAAU0rxBADF0Dnqzn/77PJ29Db1TuHmrWeWW4meGwCAAlA8"
    "AUAxdE74WmtCGQ669Q+fWW4keF4AAApE8QQAxdee8PPdiYjGhJ8TAIACUjwBQMH9695yu5"
    "0JPd1ORNT/kSvYAQAwAMUTxbWazaWOADBF2hN4jr2IWPqflE4AAAxI8USRzacOADBF2jmf"
    "fy8i6v/4yvJxV9cDAICHKJ4AoBzaOZ+/8T8rnQAAGJLiCQBK4KefXe5Efvs8Xf5frixv5H"
    "RuAABKTPEEAOXRzuGcl//JleVWDucFAKACFE8AUB7tMZ/v8v+qdAIAYASKJwAoj/YYz3V5"
    "U+kEAMCIFE8AUBI/Nb59ni7/U6UTAABjoHgCgHIZZRPwvYi43FY6AQAwJoonACiX1hkftx"
    "cR9dvLy2d9PAAAPETxBAAl8pMry9sx/HK7OxFR/6Hl5e0cIgEAUGGKJwAon/Uhjr0ZEfUf"
    "VjoBAJCDR1IHAADGrhURzYiYPeGYvYhofGp5eZQ9oQAA4EQmngCgZP7lyvJuRDSO+fJeRL"
    "wUEbUfVToBAJAzE08AUEI/sbK88WeuXX9LRKxFxHxEdCKiHREb/3x5eTdhNAAAKkTxBMBB"
    "OxFxLnUIxuP/XlnuRK94AgCAJCy1A2DfXvQmY+6kDgIAAJSD4gmAfevvf/zju9HbmBoAAG"
    "BkiicA9q33f7Xh9HSqpQ4AAADDUjwBEBFx+329aaf4+sc/3gnL7aZRLXUAAAAYluIJgIje"
    "1c4OaiXIAAAAlIziCYCIiO1Df26lCAEAAJSL4gmAiIjdg3/4hguv7UbErURZAACAklA8AX"
    "Acm4wDAAAjUTwBcBzFEwAAMBLFEwBH+sYLr+6Gq9sBAAAjUDwBcJJW6gAAAEBxKZ4AOInl"
    "dgAAwJkpngA41l+pv9oJy+0AAIAzUjwBcJpW6gAAAEAxKZ4AOE07dQAAAKCYFE8AnOiv1T"
    "+2HRE7qXMAAADFo3gCYBA2GQcAAIameAJgEO3UAQAAgOJRPAFwqm9+4rs2ImIvdQ4AAKBY"
    "FE8ADMpyOwAAYCiKJwAG1U4dAAAAKBbFEwCDMvEEAAAMRfEEwED+xhPftRsRt1PnAAAAik"
    "PxBMAwTD0BAAADUzwBMAzFEwAAMDDFEwADaz75Sici7qTOAQAAFIPiCYBhtVMHAAAAikHx"
    "BMCwWqkDAAAAxaB4AmAoLy2+sh2W2wEAAANQPAFwFq3UAQAAgOmneALgLFqpAwAAANNP8Q"
    "TA0P7W4kd3I+Jm6hwAAMB0UzwBcFbN1AEAAIDppngC4Ey+5R3f2YmIl1PnAAAAptcjqQMA"
    "UGjNiFiKiHOJc0T0rrS3GxHt/q/bh75ei4h69PLOTjAXAABUluIJgDP71nd85+43/eDzS9"
    "EreyZR5hxVLnXaX/3XOwM+vvVnv+fb5yJiLSJezCMgAABwn+IJgJF82xe+vP0NP7g2H70r"
    "3V0Ywyl3IqITvVLpXsn0P37lS4cnmM7kx7/2L+9GRPNPf+JDnYh4cxznBAAAjqZ4AmBkH/"
    "zC9U5E1N//T16Yj4hGRMzH8SXUfrEU0SuV9n/d/b6L3zKWcmkQ/+Kpr2/9qU98eCkiLk7q"
    "OQEAoGoUTwCMzYe/6CPb0VvGVhRroXgCAIDcuKodAJX1k0+9vxO9faMAAIAcKJ4AqLpW6g"
    "AAAFBWiicAqm5i+0oBAEDVKJ4AqLSfevf726kzAABAWSmeAAAAAMiF4gkAInZSBwAAgDJS"
    "PAFARCd1AAAAKCPFEwAAAAC5UDwBgCvbAQBALhRPABCxmzoAAACUkeIJAAAAgFwongDAxB"
    "MAAORC8QQA9ngCAIBcKJ4AAAAAyIXiCQAAAIBcKJ4AIKKTOgAAAJSR4gmAyvvpd7+vkzoD"
    "AACUkeIJADFcvNwAACAASURBVAAAgFw8kjoAMJA70VsKtB0RtQO3c6kCAQAAwGkUTzC99i"
    "JiPSLW59/Z3T3qgK3NrBYRjf5NCQWjuRMR51OHAACAMlE8wXTai4j6n31Xd/ukgxYWu52I"
    "aEZE80c3H2n0f6+AgrM5suAFAADOzh5PMJ2W/sxXnlw6HfbnFv+g9eee/P1aRFyOiJ1cUg"
    "EAAMAQFE8wfe786a/qts/64Lc9+Xuttz35u7WIeCF6k1PAYNqpAwAAQNkonmD6bIzjJG97"
    "8nfWo7cB+c1xnA8AAACGpXiCEvuCJ3979wue/P8aEfFE9DZOBo7XSR0AAADKRvEE06cz7h"
    "O+/cnfar/9yd+cj4iXxn1uKJFO6gAAAFA2iieYPp28Tvz2J/5dMyLeGqaf4Cid1AEAAKBs"
    "FE9QMY8+8Rvbjz6xZ/oJDvk3l17opM4AAABlo3iCinr0id1m9KafdhJHgWliGhAAAMZI8Q"
    "QV9tgT/+92RMyHK9/Bvk7qAAAAUCaKJ5g+u5N8ssee+PXdx574tUZEvCsi9ib53DCFtlMH"
    "AACAMlE8wZT5r7+6m+SD7+NP/NpG9KafLDWiytqpAwAAQJkonoB7Hq//aufx+q/MR8TLqb"
    "NAIiaeAABgjBRPwEMu1H95LSy9o4J+5tILu2HqDwAAxkbxBBzpQv2XLL2jqtqpAwAAQFko"
    "nmC6TNWE0YX6L3bq9f/H0juqpp06AAAAlIXiCabLVO4vU69/xtI7KuPTjbWN8F4HAICxUD"
    "wBA3mi/guW3lElG6kDAABAGSiegIE9Uf/5zhMXfs7SO6pA8QQAAGOgeAKG9uSFn7X0jlLb"
    "ufz8RkTspM4BAABFp3iC6dJJHWBQT17YsfSOsmulDgAAAEWneILp0kkdYBhPXuh0IqIeET"
    "fTJoFcrIepPgAAGIniCRjJ4oVP7y5e+JlGRFwOH9IpkZ+7/Pxu9MonAADgjBRPwFgsXvi3"
    "rbD0jvIx9QQAACNQPAFj844L/6bzjsf/taveURo///R/vxsRzdQ5AACgqBRPMF06qQOMwz"
    "se/2lXvaM0PvP0e9cj4nbqHAAAUESKJ5gundQBxuULH/+p/ave+cBOGTRCkQoAAENTPAG5"
    "+cLH/1Xnix7/yXpEvJQ6C4ziF595byci1lLnAACAolE8UWS11AEYzBc9/i+bEfHWsPE4Bf"
    "ZLz6y2wv5lAAAwFMUTRVZLHYDBfdHj/2I7IurhgzsF9itXVtci4mbqHAAAUBSKJ5gif+ov"
    "ddupM+Tpix//id0vfuwn1iLiiYjYSZ0HzuLXrnxdI5RPAAAwEMUTMHFf/NiPt6O38bjpJw"
    "rp15ff0wjlEwAAnErxBCTxJY/9+O6XPHbH9BOFtdsrn15InQMAAKaZ4glI6kse225/6WM/"
    "VgtXvqOAfmPlufXolad7qbMAAMA0UjzB9Kj0B9cvfez/akbEWyLiduIoMJTfXLnajt7SUV"
    "dtBACAQxRPMD22UwdI7Usf+z87X/bo/1GPiHeF5XcUyG89e7Xz288+Ox8m9wAA4AGKJ2Dq"
    "fNmj/3zjyx7932vR2z+n0pNgFMvvXF1pRsRbI5/pp90czgkAALlSPAFT68sf3VqPiFr0pk"
    "gUUBTC711d2f6D55bnY/zFaeWnIgEAKB7FEzDVvvzRH939ikc/1QwFFAXzh88t7xenN8d0"
    "yo0xnQcAACZG8QTTwzTDCb7i0R/Z/YpH/1nznW//4bmIuBw2cqYAuu+5snv3PVca0ds4f5"
    "QCaucXrl7xPQIAgMJRPMH0sH/LgN759v+t9c63/9B89PbSuRmmoJhyf/CeK53ff7CAGvY9"
    "2xh3JgAAmIRHUgcAOKs///bb29H/QH7rnz25FBH1/u18slBwgt99z5VORDQ+69UbcxGx1L"
    "9dPOEhOxHR+MzVK+380wEAwPgpnoBSuPj2f7oR/T1wNn7kC+ciYj56JVTtwO1cknBwyG8/"
    "d2U3Ilr9W8y+eqMevffs3IHDtn/p6hX7OgEAUGiKJ5geltqNydIX/OBuRLT7t3u+/0e+bC"
    "56ZdRSRFyadC44zt5zV9px6P0KAABloHiC6WHj4Jx95Rf8493oTUVt/INPvXMtIpoR8XzS"
    "UAAAACVmc3Ggkv7C2/7R7l942z9ci4h3hc3JAQAAcqF4Airtq952ayNcMQwAACAXiieg8r"
    "7qbRsbEfFy6hwAAABlo3iCKfFffU23nTpDxTXDkjsAAICxUjwBRMRXve0H9i9vDwAAwJgo"
    "ngDu20gdAAAAoEwUTwB9f/Ft399OnQEAAKBMFE8wHXZSB+CeO6kDAAAAlIXiCaZDJ3UA7t"
    "lNHQAAAKAsFE8AD9pOHQAAAKAsFE8ADzLxBAAAMCaKJ5gOyg4AAABKR/FEkdVSBxgjy7sA"
    "AAAoHcUTRVZLHYBSqqUOAAAAUBaKJ4AH1VIHAAAAKAvFEwAAAAC5UDzBdGinDsA9c6kDAA"
    "AAlIXiCeBB51MHAAAAKAvFEwAAAAC5UDwB9P29T33lfOoMAAAAZfJI6gBAxH/533XbqTMQ"
    "EfZ3AphqW5vZXPT2RTxpWfSdiKgvLHZ3q5YnT1ubWSMi3jzlsMsLi91W/mkoqwH/m5omOx"
    "HRiYjt/q29sNjtpAx0nK3NrBURl1LnSGQvet+Ht/M4eYH+bvei9z7txP33ay5/J4cpngDu"
    "UzwBTLdWnP6B9Hz/uKW8w8T05cnF1mY2H6eXThERb25tZtuT+iBDKa1FcUqniIhz/duF/T"
    "u2NrOdiNiIiNa0/LewtZmtRTGKkbzMRq/QHPu/9Qv2dzsbvffqhehn3trM9uL++7Wd1xNb"
    "agdwn6V2ANNt0A8Nk/pBwrTlycsw+Yv+WmFU5yLi+Yj4sa3NrN2fFkzNf5e90iUPRf+7nY"
    "1eCfXJrc2sk9f7VfEEAAAA43chepOA7a3NrJ46DJziXPTer52tzWysU7qKJ0jvTuoA3FP0"
    "n1gAADB9LkRvomS9v48VTLNzEfED/cJ0LO9XxROkV+jNRkvGUjsAAPLyfES0+/umwbS7EB"
    "GdcUzrKZ4AAABgMs5Hr3wq7AUHqJTZ6E3rNUY5ieIJAAAAJmc2ekuZGqmDVMhe6gAF9+Yo"
    "79dHxhZjNZuP+/ujzMWDS1ba9373Sn6X6IOCmorLrBIREbXUAQAAqIw3tzazTp6XsScieq"
    "VTPXWIEnhzazOLhcVua9gHDl88rWZz0fsfrR69cunCAI968cDjIyJ2oldGtSNiI17p2uOG"
    "KvP+nx7nUgcAAGAgb11Y7E70B7gH9rqpRe+zcD16S+dGsbG1mdUn/VpOMPG/1wqZ6N9tfy"
    "+xubg/GFSPwfqbk5ypLB28eFrN6hHRiIhLwzzBMc71z3MpIt6M1exWRKybhgIAAOA0KcqR"
    "oz5sb21mtYhYioi1ONsPMWcjotUvn5L/QFrplJ9J/90eer6N/d/0l8w14uwl1MbWZlYb5v"
    "16+h5Pq1ktVrN2RHwyxlM6HeViRHwyVrN2v+ACAACAqbaw2O0sLHbXFxa7tYi4HGfbS+h8"
    "RDTHmQuOs7DYbS0sdusR8URE3DnDKWYjojXMA04unlazRvT2nxl1HGtQF6JXQK1P6Pkotr"
    "JchtRPFabA3//Uu+ZOPwoAAI7W3/umFhG3zvDw58dx2XoY1MJit72w2J2PiJfO8PCLw1yZ"
    "8fjiaTVrRsSb0WuzJu35WM22+/tJwXFSvDfzkHyklogoT5EJAEAiC4vd3YXF7lJEvHCGhz"
    "fHHAdOtbDYbUZv+mnYab2BB4aOLp56k04vHvm1yTkfEW3lEwAAAEWysNhdj97Su2FcGGaK"
    "BMalv39ZPYYrn87194s61cPF02q2FL1Jp2lwPoZcOwgAAACp9ZfeDTv5tJZDFDhVfzPyYY"
    "vP5iAHPVg89aaLWkM+Ud4uxmrmPz7KzB5PAABQQv3Jp2H2fLqwtZnZAoIk+pNPw+z5dG6Q"
    "vckOTzw1Yzr3zWlackdZ/cmn0l82lYjobQQJAADj1ojhljA18okBp+vv+TTM1e4apx1wv3"
    "hazWoR8fxwkSZmNobYuArgDGqpAwAAUD4Li93dGG4JnX2eSG2s79eDE0/TvpxtydQTAAAA"
    "RdPf72lnwMPPbW1mtdzCwCn6S+5uD3j47GnLQw8WT40zZpqU2Zj+jDCsYUYYAQCA4moNcW"
    "w9pwwwqNYQx9ZP+mKveOpdyW4a93Y6rJE6AIyZ/Z0AAKAaWkMca4NxUtsY4tiBJp6Ksob0"
    "vOV2QE58bwEAIDcLi91ODL7cTvFEUv29yQZdblc76Yv7xVN9hDyTVk8dACgl/+cOAEDe2g"
    "MeV8sxAwxqe8DjLpz0xZn+BNG50fNMjA+HlMmg/yEDAADF1xnwuCJ9Rqe8OuM4yUwUr8ip"
    "pw4AY2SPJwAAqA4/eKZIxvJ+nYniFTn2YQEAAKCIBv7B89ZmVssvBozX1mZ27FDTI1G8ta"
    "PnUwcAAADKZ2szq0fv81HtlEPbEdHpbxadRL+UqEVvBctJP5zv9G/b/c2CKY5ajGmpE0zA"
    "sd+Hilg8QcTq8W1qwbRTBwAAKIKtzWwuev92Ou0H0bcWFrsDXbV7azNbit4KkPoA5z3oxf"
    "7j9/qZNiJiI89ip//6l/q3ekTMnuEcd6Kfd2Gx2x5jPIBjPZI6wJmsZvV4xTfKirPkknEr"
    "S5kJAGW1FoOVQxdP+mJ/UqjRP9/Q5c0hs/3nuxgR61ub2UZENMc5CdWfwlqLU17XgM73b8"
    "9vbWY7EdGKiHWTUMAYdI77wkycctk7gIoY9R+eAMAU29rM5rY2s/WI+HT0JpbG/f/9sxFx"
    "KSI+vbWZtfoTSme2tZnVtzazdkR8MsZTOh12Lnp/D52tzWwth/MzIlNpTIHaoAeeVLjPjC"
    "MJcGZ+ugQAkLP+krpORDw/oae8FL1CZ6Alfwf1C7KN6BVOkxgSmI2Ij2xtZm2bWU9EPXUA"
    "GEJtHCdRPEFC/8WlrsupAgDkqD/l9AMx+enm2Yj4ga3NrDnoA/pXhepEPhNOp7kQEdsnXZ"
    "mKsailDgBDqA943J2Tvqh4AgAASmlrM2vF5KacjvNiP8eJtjazRkT8WKRd/j8bEe1+FvIx"
    "aLF3O9cUMJhBpy5PXMmjeAIAAEqnX/ZcSp2j71J/8upI/aLnzcnFOdFsRLxp8mn8+ksZB7"
    "16Yie3IDCAIQvo9klfVDxBOjupAwAAlFF/edu0lE77nj/qg1y/4JmW0ukgez6N3zB7ftmS"
    "g9QaQxzbPumLj4wUAxhFJ3UAAICSevEMj9lf2tTp32pxfz+ecW3yvb61mbX3r/7Uv/Jd+w"
    "zn2Yv7xcT+4+cjYi56mc+NErJvNiJaYTPscRrm6oHtvELAabY2s3oM8X3vtCswKp4AAIAq"
    "2omI9YhoLyyefsGX/gexpf7trMXObP859ydfWjH4nk63ImIjenk7Jx3YL7Tq/ecZZfLrwt"
    "Zmtraw2D12mSCD6U+7Dfq+2RvkPQk5ag5x7K3TDlA8AZX39z+1VI/IUscAACbjTkSsnfYT"
    "+sP6x7cjYq1fIjTjbAXUxX6JFTHY1etuRkTztLLpoIXF7m70SqqN/rLDZpy9gGpubWat/j"
    "k5g34R2BziIRs5RYFTbW1mazHclOep71d7PEE67dQBAAAq5oWFxe78sKXTYQuL3Vb0lrbd"
    "POMp1qM37XSSOxHx1oXFbmOY0umwhcVuZ2Gx24iIt8bZ9hidjeGWiPGw9RiupGzllANO1N"
    "9z7iNDPGSv//3wRIonAACg7PaiV+KMbcnYwmJ3t1/oXD7Dw8/HyUXErYioj3O5Vf9c89Er"
    "tIaleDqj/nTcMNNmO6MWo3AW/dKpPeTDBvqeqngCAADKbC/GXOIc1P9p/1nKp+PcXFjsLu"
    "WxtK1/znoMXz7Nbm1mw1yRjbhXOg17xcLm+JPAyQ6UToPuORfR+96qeKLU6qkDjEEndQAA"
    "gApYynuj5n759PIYTnWnP0WVmwPl07DL7hRPQzhj6bQzyLIlGKf+nk4/FsOVThG9vecGKs"
    "gVT5BOJ3UAAICSe3lSy5YWFrtrcbY9lPbtxYTKnf6HxcaQD1M8DWBrM5vb2sw2YvjSKWL4"
    "/03gzLY2s/rWZtaO4fZ02ndnmKXLiicAAKCM9mLyy5YaIzx2qCvXjapfyA2zOfpsfzkOx+"
    "hPOXVisKsVHnbL3k5MwtZmttQvnD4Zw129bt9eDPm97pEzPAkAAMC0W89jn6STLCx221ub"
    "2e0Y/sPczjg3Ph9CM4bb+Ho+InJdtlg0W5tZLXofwhsx3JXrDtqJKZl22trMuqkzHOOyZY"
    "jD6RfFc/3bfP9Wj+GX1B22NuzyZcUTJPKfN/xEAwAgRymKnIiIVgxfPLXGH+N0C4vdztZm"
    "disGn9Cp5RhnavXLpdqBu+YP3M6PePq96O1DNtGStIDe3NrMtvPery1PU1zqDeOlsxSAii"
    "cA4n2Pf7ydOgMAjNGthB/kz7K/TyuHHIPaiMGLp6lZaleSD/ERE9j8vkTmUgeouJsLi93m"
    "WR5ojycAAKBs2qmeuF943R7iITuT3NvpCBtDHOuD//jsRW/5WDt1EBjAC6NccVPxBGmMcs"
    "UTAABOlnqCpD3EsUmz9osy/zadrL2IqNuziALYi4h3jboHneIJ0uikDgAAUGKpi6fOEMem"
    "zhrh36aTdCci5i2vowBuR++9OsxU5JHs8QQAAJTKFGzU3Bni2NRZI3oTWme5rDrDeemse+"
    "TABO1E78p1IxdO+4paPNUj4bptGINp+AcGAADpmXwpv9sR0Ui8l1cZ+AyVr9sRsT7Owmlf"
    "UYsnKDr/wAAAgHK7GREtG4iPxWXLE3NxO3oXGNjIsxhVPFFU9dQBAAAADtn/IN+agiWfZ/"
    "FWBU8l3FlY7M5P6smKWjzVUgeAEbVTBwAAAM5sL3qrGHb7v7bLMNmkdMpV7qXe1mbWjIgX"
    "Bzi0trWZzU2qHH0kehtHnZvEk41RLXUAAAAAkjGZQ6FM6P26HhFrETF7ynGz/eOaeQeKiJ"
    "gJl86kmGqpA4ziTzxd/J+GlEwtdQAAAAandIKH9SeY1gc8fG1rM5vLM8++mUk8SQ5c6pOi"
    "TekdtJc6AA+ppQ4AAAAwBoMWT7MRsZRnkH1F3eOJKlvNaqkjjMhPZwDI1dZmth4RJ20a2l"
    "pY7LYmFAcAmJCFxe7u1mZ2MyIuDXB4MyJauQaK3sRTO+8nycVqVk8dgWRqqQOMqJM6AADl"
    "tbWZtSLi+ehNiB93e3NrM5vITzkBgIlrDnjcua3NrJFjjogo7lK7iOKXD5xdPXWAEXVSBw"
    "Cg1Ab5CWfEyRNRAEBBLSx2OxFxc8DDm/kl6Sny5uL+sVRdtdQBRtROHYCHtFMHAAAAGKPm"
    "gMflPvWkeKKI6qkDjMgeTwAAAOSmP/V0e8DDm/klKXbx5Mp2VbSazUWxr2i385Yr3d3UIQ"
    "AAACi95oDH5Tr1NBOvdDt5nTx3NhivonrqACMy7QQAAEDuFha77ZiCqaf9zcXv5PUEOaun"
    "DsDEFf0KPIonAAAAJqU54HG5TT3tF0+dPE4+AUUvIRhePXWAEbVTBwAAAKAa+lNPOwMe3s"
    "gjw37xVNQpjPOxmtVSh2BCVrP5KPb+TlFb7rZTZwAAAKBSmgMed2Frc/xbGu0XT+1xn3iC"
    "6qkDMDGN1AFGVNQlrQAAABTUwmK3FYNPPTXH/fxFn3iKiFhLHYCJKfrSynbqAAAAAFRSc8"
    "Djxj711CueXunuxuDt17Sx3K4KelcwLPQyu1A8AQDFNDfEsbu5pQDgzPpTT3sDHt4c53PP"
    "HPi9qSemWSN1gFF9/rPdjdQZAICxGrRkqeUZYgLmBz1wYbFb5M8UAGW3PuBxY516Olg8tc"
    "d10gQaqQOQo9VsLiIupY4xotupAwDAIcNMsXC0QUuWok9tA1AO65Fg6qksxdNsrGaN1CHI"
    "TRkm2kw7ATApg17MYuAplilS2LJsazOrpc4wgkHfK4N+mAEggYXF7m4kmHq6Xzy90t2OYv"
    "+fRTN1AHLQm3ZSPAHA4Mq8x875AY/r5BnigPYQxxax6Ns3aHbL7ACm36DFU8SYPovPHPpz"
    "kT8cnzP1VEprETGbOsSIdv74c91O6hAAVMagxdOFXFOM2ZATQ518UjxkmJKvnleIPPX/3g"
    "ddKtjJLQgAY9Gfero54OEXxzGxe7h4ao96wsSaqQMwRqadAOAsBp462drMijSFUx/i2E5O"
    "GR4w5EbaS7kFyVd9iGNNPAEUQzOnY49UpomniN7UUzN1CMamGcWfdoqIaKUOAECldIY4tv"
    "7/t3d3vW1k5x3A/8fdvgVFZG/f0BfAWu11YS1sQM1Nlobsa2vRyECvLLeofJFpVvsWuQVa"
    "0yhS2GnaldEpAhMFTAe9stKujN4UsISlcpMIsBD5A6yX+gKx9QV0evGcMYeHQ3LOvM/w/w"
    "ME2eRw5ugMDznzzHOeyakNeWg5LFtkACTuDUTO1yzQF3AJmPXyagQREWVnaVn3ET/r6Uba"
    "rKfhwJOvXyN+Qcqq2jCZMlRnnloE8GHZzcjA8Z9+l7cVJiKiQvUcll3LqQ15iB0AccxESs"
    "vlwu1aXo3IgznRuBZz8ZOC+52IiNJp57TsCDvjCah/dsYc6v83kFvBsyrrlt0AIiKaLeYq"
    "5nHMxS/U4W5rB3tqDfGzoONmIGWl57Ds2sFerS6Qth2W7eXUBiIiyoE5Xngac/FUWU9Rga"
    "e6T7cDgGvwVF3n0ZOnNlCzgqcTdMtuABERzaSew7LtnNqQpTWHZQs9ljVZPnEDfXOoSf1K"
    "c4Jxw+ElTTiHICKaNS4JH+2kGxkNPPm6j/pPtwOALqfc1ZBMsWuX3YyM7P+Jx7vZ1US/7A"
    "YQEWXMJQiQunZDng721ArcLkiVEQDpOix7p8r9HeJyMnKytKy7eTWEiIjysbSse4ifKZz4"
    "eCEq4wloxjQnTrmrpy6aUVAc4PuvNr7zrZ1+2W0gIsrS0rLeAXDi8JJuTk1JxUxLczku3T"
    "dTB4rmeuxc6ewgE+yLW9sJqOj7h4iIYmnntOwb4wJPlf4ydHDNTNuiOvBUF8CFspuRkRM0"
    "ZxwREVE9dR2Wff9gr5LHTFsAzjss382pHRMtLevXiH93IEBqa1XyQq+5817X8WWV/FuIiG"
    "g6k/UUd9bbjSS1CqMDT77zl2eVfQ5PtcpuBE3hqTW41RGoup0//p5+XXYjiIhoprkGAz43"
    "QYdKMAXFXY4Njkue7tV2XP5D8zdWhjmZ2IFb9vnjkrLMiIgoOy7HDM4XqsZlPAHNSpndMb"
    "WDqIpk3zwquxkZa5fdACIHcYviElGNmGCA64XEXhWCTyYg43ps0M6+JfGZ/n7g+LJHVQk+"
    "maBTD24ZZifgMQ8RUe2ZCzdxzwk2XLOexgeefKd0q6qbgwSfWGy8aiTo1Cu7GRnb/6MNXv"
    "mjWumX3QAiyk0bbrWe5lBy8Clh0OlFRYpbt+EezH90sKfa2TclPrO/j+Be8mCL2U5ERI3R"
    "jrmc8x1aJ2U8Ac2ar30eQI/BpwoZBJ2aUkw80C67AURERMCbLBzX47kg+LSWeYOmMHWPkm"
    "RBV6I+lan1lKQtdw721E6Suhlpmf3cg1umEyDBvnbW7SEionLkmfU0OfDkO224Di6Awadq"
    "aG7Q6fgPP9a9shtBREQUMMEB1yz2OUgmzk7SWye7ONhTrYM9dQTgwwQvf2AKo1aCuaOg65"
    "Q7QO4i1y8q4Hewp+YP9lQPEuhzPR47AbCWdZuIiKh03ZjLOWU9Tct4ctlwXTD4VLbmBp0A"
    "ZjsREVE1rcBtyl3gGoCjgz3VziMAdbCnFg/2VBfAl0h2Z9sXS8u6EtlOYaZNSUpWBAG/3A"
    "JQJuDUBfA1gPcTrmZjaVkfZdcqIiKqiC3EP16InfUUJ/DksuG6CIJPpRfPnDnNDjod/8En"
    "lagvQURENMRMuVtJ+PI5AHcAfG0yoFbSTAkzgY81k+H0SyS/q+0JgFbSdhSgheT1Us9jEI"
    "DaSltzK9TnPUjAKc2dhO9WpJ4WERFlzEwZjztFP3bW01tTl/D1a3hqC3LA0SRB8KkFn1ds"
    "CuGpFUgGXRODTgCznepuH8mv/BIRVd7Ssu4d7KmbSHcn2WvmBwd7ah9SkLpvfgNAPyg2bY"
    "IlQYCqBWAewCKSZTbZTgC0zAFyJS0t69cHe6oFueCW9G8+D5l++OHBnjqB9HMP0ud9s8xR"
    "0A9me4EWsu1zAHjMuk5EzXawp3TZbchB8J3B8/54tiABpTjn7RsHe2pr2vfx9MCT+4brZA"
    "7AL+Gpm6aeFeXFU200L3gZdvz7n/E9RERE1ba0rLsHewpIF3wKvI+IgL1Zf55qcwKRUfAp"
    "MIfy+hyQWlqVm9ZIRBTDHORzmOV2YjDfXTuIlx07B8mo7k5aKM5UO8l6anY2xyN4qsu6Tz"
    "nw1Fl4agfNDjoBzR4fRETUIGaa1E3Us5TCC9Qk6BQwV4FbAJ6W3JQ0bjLoREQ117Qkmry1"
    "s1w2XuAJAHy9hWbd4c52A6z7lC1PtSAp4ddKbkneXvzeJrOdiIioPkzwqYV6Hds9Rc2CTo"
    "GlZf16aVmvALhbdlscHQN4jzWdiIhmi5k2/zjm4uen3RAjfuBJNP1KxwXI1Lt22Q2pNcly"
    "2oLcoeZ82c0pQNPHBRERNZAJ4CwCeFB2W6Y4AfDR0rJeqXJNpzhMfaT3kLzoeJEeAFisY6"
    "CPiIgy0c5qWbfAk693IAV4m+4OPHVkMnbIxSDL6cOSW1KU/d/9O90ruxFEKXGaMdGMMpk4"
    "GwAuo5rBkMeQ4EfcO+xU3tKyPlpa1osAPkI1pzvuQ7KcNuoe6CMiouSyzHpyzXgCgLEra5"
    "gLAL5k7aeYPDVvajnNSpZTYK3sBhBlIKu7HRFRTS0t654JhtxENabfPQVweWlZrwV3yWsa"
    "E0ybh0y/q0IAah/S57WczkhERLnoOizbHveEe+DJ133Ub356GjcA9OGpNgNQEWRaXRvA12"
    "h+LSfb3bf/vpkHwzNqpq/q/tvPbrXKbgMRlW9pWXeXlvU8JAOq6GLYJ5DpXe+YaXW9grdf"
    "OJNx1l5a1mchQb+iZxacQK5mv2cCLKLDqAAAFmtJREFUTr2Ct5+XKgTyXI4rqnAMUoU2uK"
    "jCPq6Tuu3fPOT1nonbt7V8z5rvhbjfTefNnVxHJMl4AnzdRjWuhhVlDnJXNgagAoOAUx/N"
    "v2NdlGMAjUn7JwAyRXSWrZTdACKqDpMBtQLgHCQg8hT5HDQfQwIfHywt67Nmelc/h+1Ung"
    "n6tQC8A5mGl1fgz+7ztRplOG1h+pTQE0jh/FKZPr0ZY9GbVeh/k4E3bUrNCfKvbVqbfVwn"
    "Mfdvk+X2nnEYO7lsvyBriPed9AJjzqmU1jrZpqWWz5fJXlx7J5APxS34Mzb33VPzkDfeBh"
    "p0S0qtAH1Gfk7PDP9fm/+fhv6tz+Dy3D825qogAfjpzz9oa6g7UAqAgob8Dv9bQ2H0eSD4"
    "FNXa+v+b3+ZxHX5cjS6nxzwOAHrM48HyevTxwWsj2jK0bkBDnQCY//jbD2frM42InBzsqU"
    "VIQfJ5DA6i34/58n3IleGj4GdWg0wuzNXjoM8XIXX54kyRPoH0M/uciIhKlTzwBMDcuWxW"
    "ikiP8xhAF37DgxASaFyDTD1sHMfA04NvtjXvZNcwDDwpALj78bcftsd0ERERERERkbN0gS"
    "cA8NQRWJgWGEy92jF1sOpvkN20hoYXDHcIPB1rhcVvtmcs020GMPD05vHLn3z7YS+6l4iI"
    "iIiIiNwkq/E0bA01LZSVsfMAPgfwNTx1BE9tmMBNvXhq0bT9CFIw/A4aHnRytMagEzXczo"
    "9+dov1noiIiIiIKBPpM54AwFNrAB6lX1EjHQPYAdAD0KtcTSgplN6CFBZuYUaDTDEznh78"
    "zj9xil1TMeNp8LgGcKrVUw21sfn+j/tR/UVERERERBRHNoEnAPBUFw2t/5OxoNK7/BRdG8"
    "p7U6ByETMcaLLFCDy9+MYP9GLZ7aT8/PTnH6xoqC8YeHoTeIKGwqnG/inUzqlWvX+4/B+l"
    "33UnK3/2Xz9qnWrgVP5G87cqnEL249C/h5aR12jz/Kl5Xkc8HvSjgqQXv/mtMPSYy/MKwB"
    "mlpzwfsU7732rC9uM///p///pvGvOeICIiIqJ8ZBl4OgvJ6mG9J3fHAPoYvvOIZEa5BqYk"
    "sATIHU8WQ7/nwSDTWFMCTydaYfEbP2hI7S6K9NOff9DSUF8y8DQSeDKBlzeBlGOt0Q8eiw"
    "7ODIIup8DiqVZz44I2UYGacCBneBvR27LXFV7GXlf038bAU8LAU/T2rXZazx+fAfoKODqj"
    "0FdA7z9vrjN4RURERNRg2QWegKAY9RGAuexWSpS/KYGnD377n/VO2W2kfDHwFDvwNCYoND"
    "bwNLIuBp5mOvAUev7NYydngJ4CdhSw8+Ob69Wakk5EREREqWRRXHxA7ubWAouNU3PcZdCJ"
    "iChXcwCuQWpFvvruo86O96izVm6TiIiIiCgr2QaeAMDXRwBYgJma4PFv3dPtshtBRDRjrg"
    "F49LfdTv/Dbqe90e2cLbtBRERERJRc9oEnAPB1F8DNXNZNVIwXYACViKhM5wHcAdD/uNtp"
    "l9wWIiIiIkoon8ATEASfHue2fqL8HANo/eYPNeuMzBYWOCaqpjkAdz7pdvqfdDsrZTeGiI"
    "iIiNzkF3gCAF+vgcEnqpcTACu/8SMGnWbNd771Bfc5UbWdB/DFJ93OzqecfkdERERUG/kG"
    "ngAGn6hOTgC0fv1fNTNfiIiq6xqA/qfMfiIiIiKqhfwDTwCDT1QHJwBav/Y5g05ERDUwB+"
    "CLT1n7iYiIiKjyigk8AQw+UZWdAGidecCgExFRzdz5tNvpcuodERERUXUVF3gCGHyiKjoB"
    "0FL/zqATAZDC8kRULzcA9Bh8IiIiIqqmYgNPQBB8+qjw7RKNOgHQgs+gE73RL7sBRJTIBQ"
    "C9zxh8IiIiIqqc4gNPAODrLQA3S9k2kXgBYJFBJyKixmDwiYiIiKiC3ipty77uwlNHAHqQ"
    "IqFERdkHsAJfvy67IURElKkLAHYAtEpuR3146iGA9dAj78LXL61lFgB8FXqkA1/fctjGVw"
    "AWzP924eurEcvY24jjFYD7Zp2HEeu0/7Zb8HUn9tqH2w2E+8ZTmwDuObZ3nNH+HN12Mr5W"
    "I48lW3fQz7up2jO87VcALo2836av4x6AzdAj0fu1en04ed15v6fCPHURwBXI+LD/jpcAOg"
    "AOU+9v2Vb2Y3uw7qrt4/jjJM+2D29nAcCq+bloPbsN4BDyfnkVa3t59kuRnw+T17EO4KH1"
    "6G34+r7jeuy/593Y/Syv16H/bcPX12O+btL4ln0e92/J8H1aTsbToAFHkIPDF6W2g2bJY/"
    "i6xaATEVFjvf9Zt9MtuxFUiHOQE/Xn8NSTiOftA+vNiGWiyYlH+GC743wC1CybAJ7BU0/g"
    "qXMZrfMcRk/uJvPUFbjsRxrmqQV46hmA55CxE3VCuWCeewZPPTd9XrRpY7uq8hgnyUnw/S"
    "tIX9pBJ0CCUfcA/MoEbPKSpF/K/HyIes+vplxn8J5O8/rJZHw/weTxLfvcU9oEuwtTbuAJ"
    "CAefnpbcEmq+m6bGGNE4DEgSNcONz7qdtbIbQYVaNSfUAxIoCl/pXjABpTjsA3K3K93NtQ"
    "rg2dSl4rsS++RHTljdTkRpQLIgniP6pHqci5CAQdxxk4fRsV19WY8TNxKAeI7hjM9pNk2g"
    "Mc+AmWu/FP/5IOuJGiMXzRhKYz2DdUQbjG+XANm9IsdWeVPtwiT7ZAWe2gDwednNocY5hk"
    "ytYz0nmuYIwLWyG0FEmdj6rNs5+pe1dX7219O0qUKbkJPi8EG2nKQMTyG4b5YJTqY2MRyM"
    "ilq3ne10fyTbSbYxPhg1PEUienphfC/h63dTvD75uqUvLmL4BPZiRD+nsQlPbcfIKNtE8i"
    "kf5fVhXPm/p55gOGsimM4m25YT7mA/25kZD+GpV/D1tuM2o2Q1tm11HidZt/0JRjOcOmY7"
    "90PT7+x+vggJ3sSb0lXM50cRnw9hVzA+u+gKZGpiGg8BXEq5jmGyP59htN23AWDKPr8CTz"
    "2JOY0v1fu0/IynMCk6fhlytzGiLDwFi4gTEc2iOQDdshtBOfH1fXOgbJ/Abg5dsZeTlfAJ"
    "Tpysp/AV9sHJ+SzydRAksIMcmxlmRkzPVJCr+Zxil5SnVjF8Un4IqTdz/00AwNev3vxf6g"
    "bZQaY8p2INxB3bVVLMOIlnELgLvITUSroV2tcvQ/18FfI5F1jNLMMtm34p+vMhHJR5Bem/"
    "qOeSuphDBuEmhoNOhwDetsa3vc/DVouYUlutwBMA+LoHYB6cekfpnAD4AL5mEXEiotl14f"
    "vdTrvsRlCOpGhsOIMpappEB8MnVuNPUOSkzc52il8MtqmkKPDt0CPjpqMkNW1KTZ3q/FSR"
    "nf1yfer7Wk5Qw9kdC4XWe4o3tqsl/3EShz2Ork4s0C5ttrNdsg2MpO+XIj8fwu3axXAA9q"
    "LJHErrXmYByeFMRUACZVcnjm/ZH3ZgN/fptNULPAEy9c7XKwA+ArOfyN1TAPPw9U7ZDSEi"
    "otJtfL/bmS+7EZQrOzNj+MRADsCnZz3JAbyd7eR2N6Rms+9IlXWtks3IkzopepzFyd4sC+"
    "+rVw6F8u1sv3zq04w3eWxXU97jZDzJbAsHNEanCUeRQIQdYMm63Wn7Jf/Ph9H+28Vou7PI"
    "ekpbaDxs9EJLnIslEtgNvzdmMOMpTKbeLQLYL7spVAvHYJYTpdMvuwFElLk5AO2yG0G5sk"
    "+sok5C4mQ9rWP0pI3ZTgN2X6S9Ym8Xfx+dUjM6heYVhjMnKF9p69mkFWdsV03W48SF3T8u"
    "+89eNuvAk2u/lPH5YAdftk1QbngqYjIvMfx+Xs8og9De53agbJLwsucyyuYaq9qBJwDwdR"
    "++boHZTzTZXUgtJ2Y5URr9shtARLm4waynRrNPYEav8E/LehrNdnqZYfHsprD7OYug3G3Y"
    "V92Hs9HsKTS3M9rurAkHFc45nPAGJ/LBT9GBqOlju3ryGCdJt50m8JR1wCxJvxT9+RAOKu"
    "2GLjyEA2AXU0yTs6e3ZZH1ZAeLXP5+ezzl+l6tfuApINlP82DtJxq2D+A9+LrNLCciIpqg"
    "XXYDKDfxTqIlkBQ+0A4XuB3NdiKb3c/pT1LkxG70ZExuB2/X29o200PInZ0F8TDWVKrhgu"
    "P3TfZHkapd0yla9uMkvmoWXxfu/VLk54MEY+1pdgE7KJesHpKMHzuIVd5NE4IbCQx+GHh6"
    "Y1D76TJkWhXNrhMAN+HrFu9YR0REMTDrqYmi72Y06Zbvw1lPMt0hKtuJAY4wmYJh93M2QQ"
    "g5GQvvl2BKTTgbgFPs0hg94V0A8ByeiheAKoP72C5fnuOkztL0S3GfD6PT7AZt2MZwoCxN"
    "QNTOyoquXdVA9Qo8BXzdg6/nwel3s+oBpHh4t+yGEBFRrWyU3QDKkFwpfo7hq9SdicV0Rw"
    "uqbmL0VtTMdgqL7ufdiXfKcmdno9kndvGKJNN4clt7O3CzDglAPSs188KWZGyXrZhxUj/Z"
    "9EsRnw/hLKbDiPWFA2VXEk+3k6wi+w5/1Rl7OXqr7Aak4usteKoLSZ//sNzGUAGeAtiAr/"
    "tlN4SaafVb/9Pb/sVflN0MIsrPChh8qov1yDvPTfYS8a5638egSK190H9YwWynBXhKx1hu"
    "F76+mtO6w6Kmv6Tj61fw1C0AzyKe3c2g3lYV+jDJurPl6+tmXN3DcCDgCuRk+h5kfGznGD"
    "DJa2xXYR+HuYyT+ryHhhXz+ZH354Nk14XHQ1Rm3TaGa0CtI+lFCl93zB30ggDaOjwVFDKv"
    "slTv03pmPIXJ9LsNAO8AeFx2cygX+wAum7vV9ctuDBER1db573c7K2U3gnJxCOBqwttIh3"
    "E612QvIf2cfebJ6JQaII8g16zzdQe+fhujhZsDkqEiWVBVqLEUf2xXR37jpN6S90u+nw/2"
    "neqiAkD2Y2mnqNrtfhi5VIPUP/AUkLvfrYEBqCYJAk4t+LpXdmOIiKgRGHhqll0At+DrS4"
    "4nM1EnK7s1uOJclkMAt+Hrd3OeOmRPqeEUu7xIYeF3AVzHcP2nwBUAz0wAqoyi1UnHdpmK"
    "Gid1k1W/5PX5EA48vYxsowQ+w5lQq6nGhbQ7fKFjoVLTXXNQ76l2USQjZg2eakOm4N0osz"
    "mUyD6ANoNNRESUg1bZDcjF8AHrYQMCKB1TkyYfvt6Fp3YxXCukqrWdXpoAQXHrlmK3X4Ue"
    "2c5gutt0MqXmOoL9kt02i+/DupDCydsAbpnPEbvm2RVIBlRWGTx5je06j5O6voeK/fzI4/"
    "NBptkN3x1vvEMMB6lWER20jasDmbIXbH/TTLmraqA11fu0ORlPtkEG1DkAd8Ei5HXwGMxw"
    "ovK9KLsBRJSr85vdzmLZjcjBvdCPPW2AotkH91U92C+enPiEg5ebhWW9+PrQZONUNRDYXN"
    "Lvb0MyAsNT2xYAPCmnURVW5jipsjz7JfvPh/F3sxtlB5nSTUWNLjR+b8zStdfcwFNAakC1"
    "4euzAG6CJ5VVcwK5S9078PUaA05UAa/LbgAR5a6JgSeirNm3MHctCE11JXXQLmE4GHsxQV"
    "HwWcBxEq0u/RK+UPNq4lRACRRlc3e7wTqDjMNBe6pRWy1zzQ88hfm6C18vAngPkl3DLKjy"
    "vABwE74+C1/zTnVERFQkBp6IppHpmuGTrKqeONIknroIT+nQT7yMSMlasafENfKEOJVqjZ"
    "PqFGCvVr9Ek2l24SLhcabNhf+mc8hmTNzG8L4rptC4pzatz4aF6S9KbrYCTwFfH5lpePOQ"
    "LKj9UtszO44xyG5ahK+7JbeHiIhmU9MDT2muwI6euIzWm4i/frkaHD6Yrc6JEcURzlpYYM"
    "ZLI8QfvxI8CI9ZTiOLVpVxYn++ugQS7GWzmHpclX4Zxw4a2YGY0Z/RqXDpp7bLd6zdV3EL"
    "jSf/fnZ7f6Q2m4GngEzD68LXLcjd8D4Cp+Jl7QSSXfYBfD3P7CaqgX7ZDSCi3DUx8BQ++H"
    "S5Ahu+2vtqwi3Lw9MPXKYX2G1hHaU6kcBDeJ81+q5LDZUmGAEw2DRddcaJ/fnq8l2Q/Wd1"
    "dfplnCzqIaafbgcEhdLD37Nxaz1ltc9f5V3UfLYDT2FSjHzLTMVjECqdcLDprKndtFN2o4"
    "hi6pfdACLK3VzZDcjBcPp/nCvLMuUmHHiadCc8e3pB3BMIe7lJhVupmqqetUCTyMlkOPi0"
    "HntKzWitmfH1b6j8cSL1gtz3tUw5CwdhDifWOnJTfr9EkWDRxanLTZfVdDtgdGprHPb39n"
    "qsQJjsh/B7I/c74TLwFGU4CHUOMh2PNaEmewGZRvceg01ERFR1DbyznR3QeTixQKk8Z9eR"
    "mFTfwn5uc+JUAE+dg6eewQ5sZXcyQ0WRQtNVzlqg6cKfD+cAPDPBhvHkefszIveT09qqzj"
    "ixi3pP3tfyXfDMejROraN4qtMvNjsAdhu+VrF+gKvWa7MJPMn3o9vd+iRLOby/FiD7fHzw"
    "SS46uXz/Z+KtvDdQe75+DaBrfgBPLQJohX6aeNU0jmMAPfOzY/qJiIioLs6W3YBM+XoXnu"
    "pg+GD6GTy1DclSCA4q1yHBIHuKwbaZFjFu/S/hqdsYTv+/Zw5gZRvShnUMMqLsA9/boLrq"
    "YLDvJWtBTiipHu5DxnwwJhcAPA99PryEr7dNdkywnB0g2J34GUFAFcaJr+9b2azBvpYAkD"
    "wf7Odx3wVZt7n8fhllB4viv7flu+4VBuNpFcmylaLch3xPu0zfu43h8X0RwK/MdzZi7PP7"
    "RYxtBp5c+foIwBGALQDhQNSi+blQVtNytg/5u3sAegw0UYMdld0AIqJEfH3LHFyGD6hXzc"
    "+kehGHiHPQPDh4DQe3BncF8tSkV19ltlNiC6aorTu5Op+FDoaDiZso4Ap5hvLswyrsn2nb"
    "eQlPXYVktoRPaIPPh2nj9xDA9byal5Eq7IeqjJPrAJ5gOONUPrc9lf67wF1V+kVINlD4ez"
    "LJ1MJdDAI45+CpVTPVMR1fvzIBo/h3tpPXRI1v2deT9/kufB33olCqMcapdmnJHfK2zNSy"
    "RfPBdRlSI+ox6nfHvGNIm+9Cphi+Z9IKW6YwOLObqOn4/iaaDc0c676+CrfMovvw9aUJRc"
    "Xt9d+CnJjEvTvdIYBLzJSoOXl/2LVasqprQkWQE+tLcK+z1nH6jJhlVRknvn4JX1+CW3Dn"
    "dm77uSr9MmBn/CT5frLHURb1ooRkg7m1aTC+XV532xwzFIIZT3nwdQ+SGTTgqbOQjKj5iJ"
    "/zRTXNCIJhR5ADb/kt7Saaaat//t+97V985wWam71IVHXHmFzkP/jusgXfZyOP/3BtfbYy"
    "GSUzKZh2dwXRUwp2ISeU7icZclDcMTWe7AwoQIJScoee+AEnntRWX1TWAgOKdSKFxq9PmX"
    "YDBNNnk35GDJu1sV2dcSJZsME0S/tmEkC2+3ma6vTL6Hdikkyl0aLe2U4nvwXgq9D/p+8f"
    "Gd9XTU2vK6ZNdnH5YGq8Wy2pDCitk2VLUQ5k2l5QcyIIVKXRC/27D1/3U66PaGY8+cVqC1"
    "AAFHT4txp67PVfLv1ktk5oHXzv/z6ZPwXmT7X016kGTqGgtcIpgFNt/dv8lmVk2VPzvB76"
    "LevSoefNuhZPgbPhZex16TfbGjxvr0tre7vhZUb/hvA2tFZnT4HF8LYU5E4eb34rDD3m8r"
    "wCcEbpKc+PrPNIAa+HllMTth//+ddK1h29rNJR7Tv6yV+tNzPTiIiIiIgi/T+C/YAsGA2g"
    "xAAAAABJRU5ErkJggg=="
)
