"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.apigatewayv2.create_integration
hub.exec.boto3.client.apigatewayv2.delete_integration
hub.exec.boto3.client.apigatewayv2.get_apis
hub.exec.boto3.client.apigatewayv2.get_integration
hub.exec.boto3.client.apigatewayv2.get_integrations
hub.exec.boto3.client.apigatewayv2.update_integration
"""
import copy
from dataclasses import field
from dataclasses import make_dataclass
from typing import Any
from typing import Dict

__contracts__ = ["resource"]


async def present(
    hub,
    ctx,
    name: str,
    api_id: str,
    integration_type: str,
    resource_id: str = None,
    connection_id: str = None,
    connection_type: str = None,
    content_handling_strategy: str = None,
    credentials_arn: str = None,
    description: str = None,
    integration_method: str = None,
    integration_subtype: str = None,
    integration_uri: str = None,
    passthrough_behavior: str = None,
    payload_format_version: str = None,
    request_parameters: Dict[str, str] = None,
    request_templates: Dict[str, str] = None,
    response_parameters: Dict[str, Dict[str, str]] = None,
    template_selection_expression: str = None,
    timeout_in_millis: int = None,
    tls_config: make_dataclass(
        "TlsConfigInput", [("ServerNameToVerify", str, field(default=None))]
    ) = None,
) -> Dict[str, Any]:
    """
    Creates an API Gateway v2 integration resource.

    Args:
        name(str): An Idem name of the resource.
        api_id(str): The API resource identifier in Amazon Web Services.
        integration_type(str): The integration type of an integration. One of the following: AWS: for integrating the route or
            method request with an AWS service action, including the Lambda function-invoking action. With
            the Lambda function-invoking action, this is referred to as the Lambda custom integration. With
            any other AWS service action, this is known as AWS integration. Supported only for WebSocket
            APIs. AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS
            service action. This integration is also referred to as a Lambda proxy integration. HTTP: for
            integrating the route or method request with an HTTP endpoint. This integration is also referred
            to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for
            integrating the route or method request with an HTTP endpoint, with the client request passed
            through as-is. This is also referred to as HTTP proxy integration. For HTTP API private
            integrations, use an HTTP_PROXY integration. MOCK: for integrating the route or method request
            with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for
            WebSocket APIs.
        resource_id(str, Optional): The integration resource identifier in Amazon Web Services.
        connection_id(str, Optional): The ID of the VPC link for a private integration. Supported only for HTTP APIs. Defaults to None.
        connection_type(str, Optional): The type of the network connection to the integration endpoint. Specify INTERNET for connections
            through the public routable internet or VPC_LINK for private connections between API Gateway and
            resources in a VPC. The default value is INTERNET.
        content_handling_strategy(str, Optional): Supported only for WebSocket APIs. Specifies how to handle response payload content type
            conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following
            behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the
            corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
            Base64-encoded string. If this property is not defined, the response payload will be passed
            through from the integration response to the route response or method response without
            modification.
        credentials_arn(str, Optional): Specifies the credentials required for the integration, if any. For AWS integrations, three
            options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon
            Resource Name (ARN). To require that the caller's identity be passed through from the request,
            specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS
            services, specify null.
        description(str, Optional): The description of the integration.
        integration_method(str, Optional): Specifies the integration's HTTP method type. Defaults to None.
        integration_subtype(str, Optional): Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke.
            To learn more, see Integration subtype reference.
        integration_uri(str, Optional): For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify
            a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application
            Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify
            the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources.
            You can use query parameters to target specific resources. To learn more, see DiscoverInstances.
            For private integrations, all resources must be owned by the same AWS account.
        passthrough_behavior(str, Optional): Specifies the pass-through behavior for incoming requests based on the Content-Type header in
            the request, and the available mapping templates specified as the requestTemplates property on
            the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
            NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped
            content types through to the integration backend without transformation. NEVER rejects unmapped
            content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-
            through when the integration has no content types mapped to templates. However, if there is at
            least one content type defined, unmapped content types will be rejected with the same HTTP 415
            Unsupported Media Type response.
        payload_format_version(str, Optional): Specifies the format of the payload sent to an integration. Required for HTTP APIs. Defaults to None.
        request_parameters(Dict, Optional): For WebSocket APIs, a key-value map specifying request parameters that are passed from the
            method request to the backend. The key is an integration request parameter name and the
            associated value is a method request parameter value or static value that must be enclosed
            within single quotes and pre-encoded as required by the backend. The method request parameter
            value must match the pattern of method.request.{location}.{name}, where
            {location} is querystring, path, or header; and {name}
            must be a valid and unique method request parameter name. For HTTP API integrations with a
            specified integrationSubtype, request parameters are a key-value map specifying parameters that
            are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage
            variables, or context variables that are evaluated at runtime. To learn more, see Working with
            AWS service integrations for HTTP APIs. For HTTP API integrations without a specified
            integrationSubtype request parameters are a key-value map specifying how to transform HTTP
            requests before sending them to the backend. The key should follow the pattern
            <action>:<header|querystring|path>.<location> where action can be append, overwrite or remove.
            For values, you can provide static values, or map request data, stage variables, or context
            variables that are evaluated at runtime. To learn more, see Transforming API requests and
            responses.
        request_templates(Dict, Optional): Represents a map of Velocity templates that are applied on the request payload based on the
            value of the Content-Type header sent by the client. The content type value is the key in this
            map, and the template (as a String) is the value. Supported only for WebSocket APIs.
        response_parameters(Dict, Optional): Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a
            backend integration before returning the response to clients. Specify a key-value map from a
            selection key to response parameters. The selection key must be a valid HTTP status code within
            the range of 200-599. Response parameters are a key-value map. The key must match pattern
            <action>:<header>.<location> or overwrite.statuscode. The action can be append, overwrite or
            remove. The value can be a static value, or map to response data, stage variables, or context
            variables that are evaluated at runtime. To learn more, see Transforming API requests and
            responses.
        template_selection_expression(str, Optional): The template selection expression for the integration.
        timeout_in_millis(int, Optional): Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000
            milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds
            for HTTP APIs.
        tls_config(Dict[str, Any], Optional): The TLS configuration for a private integration. If you specify a TLS configuration, private
            integration traffic uses the HTTPS protocol. Supported only for HTTP APIs. Defaults to None.
            * ServerNameToVerify (str, Optional): If you specify a server name, API Gateway uses it to verify the hostname on the integration's
                certificate. The server name is also included in the TLS handshake to support Server Name
                Indication (SNI) or virtual hosting.

    Request Syntax:
        [idem_test_aws_apigatewayv2_route]:
          aws.apigatewayv2.route.present:
            - name: 'string'
            - api_id: 'string'
            - integration_type: 'AWS'|'HTTP'|'MOCK'|'HTTP_PROXY'|'AWS_PROXY'
            - connection_id: 'string'
            - connection_type: 'INTERNET'|'VPC_LINK'
            - content_handling_strategy: 'AWS'|'HTTP'|'MOCK'|'HTTP_PROXY'|'AWS_PROXY'
            - credentials_arn: 'string'
            - description: 'string'
            - integration_method: 'string'
            - integration_subtype: 'string'
            - integration_uri: 'string'
            - passthrough_behavior: 'WHEN_NO_MATCH'|'NEVER'|'WHEN_NO_TEMPLATES'
            - payload_format_version: 'string'
            - request_parameters: {'string': 'string'}
            - request_templates: {'string': 'string'}
            - response_parameters: {string': {'string': 'string'}}
            - template_selection_expression: 'string'
            - timeout_in_millis: int
            - tls_config: {'ServerNameToVerify': 'string'}

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            idem_test_aws_apigatewayv2_route:
              aws.apigatewayv2.route.present:
                - name: value
                - api_id: value
                - integration_type: value
                - connection_id: value
                - connection_type: value
                - content_handling_strategy: value
                - credentials_arn: value
                - description: value
                - integration_method: value
                - integration_subtype: value
                - integration_uri: value
                - passthrough_behavior: value
                - payload_format_version: value
                - request_parameters: {}
                - request_templates: {}
                - response_parameters: {}
                - template_selection_expression: value
                - timeout_in_millis: value
                - tls_config: {}
    """

    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)
    resource_updated = False

    if resource_id:
        before_ret = await hub.exec.aws.apigatewayv2.integration.get(
            ctx=ctx, name=name, resource_id=resource_id, api_id=api_id
        )
        if not before_ret["result"] or not before_ret["ret"]:
            result["result"] = False
            result["comment"] = tuple(before_ret["comment"])
            return result

        result["comment"] = hub.tool.aws.comment_utils.already_exists_comment(
            resource_type="aws.apigatewayv2.integration", name=name
        )
        result["old_state"] = copy.deepcopy(before_ret["ret"])
        result["new_state"] = copy.deepcopy(result["old_state"])

        resource_parameters = {
            "connection_id": connection_id,
            "connection_type": connection_type,
            "content_handling_strategy": content_handling_strategy,
            "credentials_arn": credentials_arn,
            "description": description,
            "integration_method": integration_method,
            "integration_subtype": integration_subtype,
            "integration_type": integration_type,
            "integration_uri": integration_uri,
            "passthrough_behavior": passthrough_behavior,
            "payload_format_version": payload_format_version,
            "request_parameters": request_parameters,
            "request_templates": request_templates,
            "response_parameters": response_parameters,
            "template_selection_expression": template_selection_expression,
            "timeout_in_millis": timeout_in_millis,
            "tls_config": tls_config,
        }

        update_integration_ret = await hub.tool.aws.apigatewayv2.integration.update(
            ctx,
            api_id=api_id,
            resource_id=resource_id,
            raw_resource=before_ret["ret"],
            resource_parameters=resource_parameters,
        )
        result["comment"] = result["comment"] + update_integration_ret["comment"]
        if not update_integration_ret["result"]:
            result["result"] = False
            return result

        resource_updated = resource_updated or bool(update_integration_ret["ret"])
        if update_integration_ret["ret"] and ctx.get("test", False):
            result["new_state"].update(update_integration_ret["ret"])

        if resource_updated and ctx.get("test", False):
            return result
    else:
        if ctx.get("test", False):
            result["new_state"] = hub.tool.aws.test_state_utils.generate_test_state(
                enforced_state={},
                desired_state={
                    "name": name,
                    "api_id": api_id,
                    "connection_id": connection_id,
                    "connection_type": connection_type,
                    "content_handling_strategy": content_handling_strategy,
                    "credentials_arn": credentials_arn,
                    "description": description,
                    "integration_method": integration_method,
                    "integration_subtype": integration_subtype,
                    "integration_type": integration_type,
                    "integration_uri": integration_uri,
                    "passthrough_behavior": passthrough_behavior,
                    "payload_format_version": payload_format_version,
                    "request_parameters": request_parameters,
                    "request_templates": request_templates,
                    "response_parameters": response_parameters,
                    "template_selection_expression": template_selection_expression,
                    "timeout_in_millis": timeout_in_millis,
                    "tls_config": tls_config,
                },
            )
            result["comment"] = hub.tool.aws.comment_utils.would_create_comment(
                resource_type="aws.apigatewayv2.integration", name=name
            )
            return result

        create_ret = await hub.exec.boto3.client.apigatewayv2.create_integration(
            ctx,
            ApiId=api_id,
            ConnectionId=connection_id,
            ConnectionType=connection_type,
            ContentHandlingStrategy=content_handling_strategy,
            CredentialsArn=credentials_arn,
            Description=description,
            IntegrationMethod=integration_method,
            IntegrationSubtype=integration_subtype,
            IntegrationType=integration_type,
            IntegrationUri=integration_uri,
            PassthroughBehavior=passthrough_behavior,
            PayloadFormatVersion=payload_format_version,
            RequestParameters=request_parameters,
            RequestTemplates=request_templates,
            ResponseParameters=response_parameters,
            TemplateSelectionExpression=template_selection_expression,
            TimeoutInMillis=timeout_in_millis,
            TlsConfig=tls_config,
        )
        if not create_ret["result"]:
            result["result"] = False
            result["comment"] = create_ret["comment"]
            return result

        result["comment"] = hub.tool.aws.comment_utils.create_comment(
            resource_type="aws.apigatewayv2.integration", name=name
        )
        resource_id = create_ret["ret"]["IntegrationId"]

    if (not result["old_state"]) or resource_updated:
        after_ret = await hub.exec.aws.apigatewayv2.integration.get(
            ctx=ctx, name=name, resource_id=resource_id, api_id=api_id
        )
        if not after_ret["result"] or not after_ret["ret"]:
            result["result"] = False
            result["comment"] = result["comment"] + tuple(after_ret["comment"])
            return result
        result["new_state"] = after_ret["ret"]

    return result


async def absent(
    hub, ctx, name: str, api_id: str, resource_id: str = None
) -> Dict[str, Any]:
    """
    Deletes an API Gateway v2 integration resource.

    Args:
        name(str): An Idem name of the resource.
        api_id(str): The API resource identifier in Amazon Web Services.
        resource_id(str, Optional): The Integration resource identifier in Amazon Web Services.
            Idem automatically considers this resource being absent if this field is not specified.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            idem_test_aws_apigatewayv2_integration:
              aws.apigatewayv2.integration.absent:
                - name: value
                - api_id: value
                - resource_id: value
    """

    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)

    if not resource_id:
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.apigatewayv2.integration", name=name
        )
        return result

    before_ret = await hub.exec.aws.apigatewayv2.integration.get(
        ctx=ctx, name=name, resource_id=resource_id, api_id=api_id
    )
    if not before_ret["result"]:
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.apigatewayv2.integration", name=name
        )
        return result
    if not before_ret["ret"]:
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.apigatewayv2.integration", name=name
        )
    elif ctx.get("test", False):
        result["old_state"] = before_ret["ret"]
        result["comment"] = hub.tool.aws.comment_utils.would_delete_comment(
            resource_type="aws.apigatewayv2.integration", name=name
        )
        return result
    else:
        result["old_state"] = before_ret["ret"]
        delete_ret = await hub.exec.boto3.client.apigatewayv2.delete_integration(
            ctx, ApiId=api_id, IntegrationId=resource_id
        )
        if not delete_ret["result"]:
            result["result"] = False
            result["comment"] = delete_ret["comment"]
            return result

        result["comment"] = hub.tool.aws.comment_utils.delete_comment(
            resource_type="aws.apigatewayv2.integration", name=name
        )
    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    """
    Describe the resource in a way that can be recreated/managed with the corresponding "present" function

    Gets the API Gateway v2 integration resources for an AWS account.

    Returns:
        Dict[str, Dict[str, Any]]

    Examples:

        .. code-block:: bash

            $ idem describe aws.apigatewayv2.integration
    """

    result = {}

    get_apis_ret = await hub.exec.boto3.client.apigatewayv2.get_apis(ctx)
    if not get_apis_ret["result"]:
        hub.log.debug(f"Could not get apis {get_apis_ret['comment']}")
        return result

    for api in get_apis_ret["ret"]["Items"]:
        api_id = api.get("ApiId")

        get_integrations_ret = (
            await hub.exec.boto3.client.apigatewayv2.get_integrations(ctx, ApiId=api_id)
        )
        if not get_integrations_ret["result"]:
            hub.log.debug(
                f"Could not get integrations for ApiId '{api_id}': "
                f"{get_integrations_ret['comment']}. Describe will skip this api and continue."
            )
            continue

        for integration in get_integrations_ret["ret"]["Items"]:
            resource_translated = hub.tool.aws.apigatewayv2.integration.convert_raw_integration_to_present(
                api_id=api_id,
                raw_resource=integration,
            )

            result[resource_translated["name"]] = {
                "aws.apigatewayv2.integration.present": [
                    {parameter_key: parameter_value}
                    for parameter_key, parameter_value in resource_translated.items()
                ]
            }

    return result
