# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AwsProxyCertificates',
    'AzureProxyCertificates',
    'GcpProxyCertificates',
    'RuleEcsContainer',
    'RuleEcsDepend',
    'RuleEcsHttp',
    'RuleRdsDatabase',
    'RuleRdsDepend',
    'RuleRdsTcp',
    'RuleRdsTcpForwardRule',
    'RuleVmDepend',
    'RuleVmFilter',
    'RuleVmFilterTag',
    'RuleVmHttp',
    'RuleVmHttpHealth',
    'RuleVmHttpRouting',
    'RuleVmTcp',
    'RuleVmTcpForwardRule',
    'RuleVmTcpRdp',
    'RuleVmTcpSsh',
    'ScheduleRepeat',
    'GetAwsProxyCertificatesResult',
    'GetAzureProxyCertificatesResult',
    'GetGcpProxyCertificatesResult',
    'GetRuleEcsContainerResult',
    'GetRuleEcsDependResult',
    'GetRuleEcsHttpResult',
    'GetRuleRdsDatabaseResult',
    'GetRuleRdsDependResult',
    'GetRuleRdsTcpResult',
    'GetRuleRdsTcpForwardRuleResult',
    'GetRuleVmDependResult',
    'GetRuleVmFilterResult',
    'GetRuleVmFilterTagResult',
    'GetRuleVmHttpResult',
    'GetRuleVmHttpHealthResult',
    'GetRuleVmHttpRoutingResult',
    'GetRuleVmTcpResult',
    'GetRuleVmTcpForwardRuleResult',
    'GetRuleVmTcpRdpResult',
    'GetRuleVmTcpSshResult',
    'GetScheduleRepeatResult',
]

@pulumi.output_type
class AwsProxyCertificates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSecretId":
            suggest = "cert_secret_id"
        elif key == "keySecretId":
            suggest = "key_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsProxyCertificates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsProxyCertificates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsProxyCertificates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_secret_id: _builtins.str,
                 key_secret_id: _builtins.str):
        """
        :param _builtins.str cert_secret_id: Certificate secret ID
        :param _builtins.str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @_builtins.property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> _builtins.str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @_builtins.property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> _builtins.str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class AzureProxyCertificates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSecretId":
            suggest = "cert_secret_id"
        elif key == "keySecretId":
            suggest = "key_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureProxyCertificates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureProxyCertificates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureProxyCertificates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_secret_id: _builtins.str,
                 key_secret_id: _builtins.str):
        """
        :param _builtins.str cert_secret_id: ID of certificate secret uploaded to vault
        :param _builtins.str key_secret_id: ID of certificate key uploaded to vault
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @_builtins.property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> _builtins.str:
        """
        ID of certificate secret uploaded to vault
        """
        return pulumi.get(self, "cert_secret_id")

    @_builtins.property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> _builtins.str:
        """
        ID of certificate key uploaded to vault
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GcpProxyCertificates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSecretId":
            suggest = "cert_secret_id"
        elif key == "keySecretId":
            suggest = "key_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpProxyCertificates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpProxyCertificates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpProxyCertificates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_secret_id: _builtins.str,
                 key_secret_id: _builtins.str):
        """
        :param _builtins.str cert_secret_id: Certificate secret ID
        :param _builtins.str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @_builtins.property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> _builtins.str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @_builtins.property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> _builtins.str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class RuleEcsContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: _builtins.str,
                 region: _builtins.str,
                 service: _builtins.str,
                 task_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str cluster: Name of cluster in which service belong to
        :param _builtins.str region: Region of cluster
        :param _builtins.str service: Name of service to be onboarded
        :param _builtins.int task_count: Desired number of tasks on warming up a rule
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service", service)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        Name of cluster in which service belong to
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region of cluster
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        Name of service to be onboarded
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[_builtins.int]:
        """
        Desired number of tasks on warming up a rule
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class RuleEcsDepend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "delayInSec":
            suggest = "delay_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsDepend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsDepend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsDepend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: _builtins.int,
                 delay_in_sec: Optional[_builtins.int] = None):
        """
        :param _builtins.int rule_id: Rule id of the dependent rule
        :param _builtins.int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[_builtins.int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class RuleEcsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: _builtins.str):
        """
        :param _builtins.str proxy_id: Id of the proxy
        """
        pulumi.set(__self__, "proxy_id", proxy_id)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")


@pulumi.output_type
class RuleRdsDatabase(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str id: ID of the database
        :param _builtins.str region: Region to which database belong to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the database
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region to which database belong to
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RuleRdsDepend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "delayInSec":
            suggest = "delay_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRdsDepend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRdsDepend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRdsDepend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: _builtins.int,
                 delay_in_sec: Optional[_builtins.int] = None):
        """
        :param _builtins.int rule_id: Rule id of the dependent rule
        :param _builtins.int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[_builtins.int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class RuleRdsTcp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"
        elif key == "forwardRules":
            suggest = "forward_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRdsTcp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRdsTcp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRdsTcp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: _builtins.str,
                 forward_rules: Optional[Sequence['outputs.RuleRdsTcpForwardRule']] = None):
        """
        :param _builtins.str proxy_id: Id of the Proxy
        :param Sequence['RuleRdsTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.RuleRdsTcpForwardRule']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")


@pulumi.output_type
class RuleRdsTcpForwardRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRdsTcpForwardRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRdsTcpForwardRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRdsTcpForwardRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 connect_on: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Port to listen on the vm
        :param _builtins.int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class RuleVmDepend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "delayInSec":
            suggest = "delay_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmDepend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmDepend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmDepend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: _builtins.int,
                 delay_in_sec: Optional[_builtins.int] = None):
        """
        :param _builtins.int rule_id: Rule id of the dependent rule
        :param _builtins.int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[_builtins.int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class RuleVmFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmIds":
            suggest = "vm_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_ids: Sequence[_builtins.str],
                 regions: Optional[Sequence[_builtins.str]] = None,
                 tags: Optional[Sequence['outputs.RuleVmFilterTag']] = None,
                 zones: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] vm_ids: Ids of instances that needs to be managed using the AutoStopping rules
        :param Sequence[_builtins.str] regions: Regions of instances that needs to be managed using the AutoStopping rules
        :param Sequence['RuleVmFilterTagArgs'] tags: Tags of instances that needs to be managed using the AutoStopping rules
        :param Sequence[_builtins.str] zones: Zones of instances that needs to be managed using the AutoStopping rules
        """
        pulumi.set(__self__, "vm_ids", vm_ids)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="vmIds")
    def vm_ids(self) -> Sequence[_builtins.str]:
        """
        Ids of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "vm_ids")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Regions of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.RuleVmFilterTag']]:
        """
        Tags of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[_builtins.str]]:
        """
        Zones of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class RuleVmFilterTag(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleVmHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: _builtins.str,
                 healths: Optional[Sequence['outputs.RuleVmHttpHealth']] = None,
                 routings: Optional[Sequence['outputs.RuleVmHttpRouting']] = None):
        """
        :param _builtins.str proxy_id: Id of the proxy
        :param Sequence['RuleVmHttpHealthArgs'] healths: Health Check Details
        :param Sequence['RuleVmHttpRoutingArgs'] routings: Routing configuration used to access the instances
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if routings is not None:
            pulumi.set(__self__, "routings", routings)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter
    def healths(self) -> Optional[Sequence['outputs.RuleVmHttpHealth']]:
        """
        Health Check Details
        """
        return pulumi.get(self, "healths")

    @_builtins.property
    @pulumi.getter
    def routings(self) -> Optional[Sequence['outputs.RuleVmHttpRouting']]:
        """
        Routing configuration used to access the instances
        """
        return pulumi.get(self, "routings")


@pulumi.output_type
class RuleVmHttpHealth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodeFrom":
            suggest = "status_code_from"
        elif key == "statusCodeTo":
            suggest = "status_code_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmHttpHealth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmHttpHealth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmHttpHealth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 path: Optional[_builtins.str] = None,
                 status_code_from: Optional[_builtins.int] = None,
                 status_code_to: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Health check port on the VM
        :param _builtins.str protocol: Protocol can be http or https
        :param _builtins.str path: API path to use for health check
        :param _builtins.int status_code_from: Lower limit for acceptable status code
        :param _builtins.int status_code_to: Upper limit for acceptable status code
        :param _builtins.int timeout: Health check timeout
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code_from is not None:
            pulumi.set(__self__, "status_code_from", status_code_from)
        if status_code_to is not None:
            pulumi.set(__self__, "status_code_to", status_code_to)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Health check port on the VM
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol can be http or https
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        API path to use for health check
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="statusCodeFrom")
    def status_code_from(self) -> Optional[_builtins.int]:
        """
        Lower limit for acceptable status code
        """
        return pulumi.get(self, "status_code_from")

    @_builtins.property
    @pulumi.getter(name="statusCodeTo")
    def status_code_to(self) -> Optional[_builtins.int]:
        """
        Upper limit for acceptable status code
        """
        return pulumi.get(self, "status_code_to")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Health check timeout
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class RuleVmHttpRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceProtocol":
            suggest = "source_protocol"
        elif key == "targetProtocol":
            suggest = "target_protocol"
        elif key == "sourcePort":
            suggest = "source_port"
        elif key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmHttpRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmHttpRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmHttpRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_protocol: _builtins.str,
                 target_protocol: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 source_port: Optional[_builtins.int] = None,
                 target_port: Optional[_builtins.int] = None):
        """
        :param _builtins.str source_protocol: Source protocol of the proxy can be http or https
        :param _builtins.str target_protocol: Target protocol of the instance can be http or https
        :param _builtins.str action: Organization Identifier for the Entity
        :param _builtins.int source_port: Port on the proxy
        :param _builtins.int target_port: Port on the VM
        """
        pulumi.set(__self__, "source_protocol", source_protocol)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @_builtins.property
    @pulumi.getter(name="sourceProtocol")
    def source_protocol(self) -> _builtins.str:
        """
        Source protocol of the proxy can be http or https
        """
        return pulumi.get(self, "source_protocol")

    @_builtins.property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> _builtins.str:
        """
        Target protocol of the instance can be http or https
        """
        return pulumi.get(self, "target_protocol")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[_builtins.int]:
        """
        Port on the proxy
        """
        return pulumi.get(self, "source_port")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[_builtins.int]:
        """
        Port on the VM
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class RuleVmTcp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"
        elif key == "forwardRules":
            suggest = "forward_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: _builtins.str,
                 forward_rules: Optional[Sequence['outputs.RuleVmTcpForwardRule']] = None,
                 rdps: Optional[Sequence['outputs.RuleVmTcpRdp']] = None,
                 sshes: Optional[Sequence['outputs.RuleVmTcpSsh']] = None):
        """
        :param _builtins.str proxy_id: Id of the Proxy
        :param Sequence['RuleVmTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        :param Sequence['RuleVmTcpRdpArgs'] rdps: RDP configuration
        :param Sequence['RuleVmTcpSshArgs'] sshes: SSH configuration
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)
        if rdps is not None:
            pulumi.set(__self__, "rdps", rdps)
        if sshes is not None:
            pulumi.set(__self__, "sshes", sshes)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.RuleVmTcpForwardRule']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @_builtins.property
    @pulumi.getter
    def rdps(self) -> Optional[Sequence['outputs.RuleVmTcpRdp']]:
        """
        RDP configuration
        """
        return pulumi.get(self, "rdps")

    @_builtins.property
    @pulumi.getter
    def sshes(self) -> Optional[Sequence['outputs.RuleVmTcpSsh']]:
        """
        SSH configuration
        """
        return pulumi.get(self, "sshes")


@pulumi.output_type
class RuleVmTcpForwardRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcpForwardRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcpForwardRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcpForwardRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 connect_on: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Port to listen on the vm
        :param _builtins.int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class RuleVmTcpRdp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcpRdp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcpRdp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcpRdp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_on: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.int connect_on: Port to listen on the proxy
        :param _builtins.int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RuleVmTcpSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcpSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcpSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcpSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_on: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.int connect_on: Port to listen on the proxy
        :param _builtins.int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ScheduleRepeat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleRepeat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleRepeat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleRepeat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Sequence[_builtins.str],
                 end_time: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] days: List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        :param _builtins.str end_time: Ending time of schedule action on the day. Defaults to 24:00Hrs unless specified. Accepted format is HH:MM. Eg : 20:00 for 8pm
        :param _builtins.str start_time: Starting time of schedule action on the day. Defaults to 00:00Hrs unless specified. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        pulumi.set(__self__, "days", days)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def days(self) -> Sequence[_builtins.str]:
        """
        List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        Ending time of schedule action on the day. Defaults to 24:00Hrs unless specified. Accepted format is HH:MM. Eg : 20:00 for 8pm
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Starting time of schedule action on the day. Defaults to 00:00Hrs unless specified. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetAwsProxyCertificatesResult(dict):
    def __init__(__self__, *,
                 cert_secret_id: _builtins.str,
                 key_secret_id: _builtins.str):
        """
        :param _builtins.str cert_secret_id: Certificate secret ID
        :param _builtins.str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @_builtins.property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> _builtins.str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @_builtins.property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> _builtins.str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GetAzureProxyCertificatesResult(dict):
    def __init__(__self__, *,
                 cert_secret_id: _builtins.str,
                 key_secret_id: _builtins.str):
        """
        :param _builtins.str cert_secret_id: ID of certificate secret uploaded to vault
        :param _builtins.str key_secret_id: ID of certificate key uploaded to vault
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @_builtins.property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> _builtins.str:
        """
        ID of certificate secret uploaded to vault
        """
        return pulumi.get(self, "cert_secret_id")

    @_builtins.property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> _builtins.str:
        """
        ID of certificate key uploaded to vault
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GetGcpProxyCertificatesResult(dict):
    def __init__(__self__, *,
                 cert_secret_id: _builtins.str,
                 key_secret_id: _builtins.str):
        """
        :param _builtins.str cert_secret_id: Certificate secret ID
        :param _builtins.str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @_builtins.property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> _builtins.str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @_builtins.property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> _builtins.str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GetRuleEcsContainerResult(dict):
    def __init__(__self__, *,
                 cluster: _builtins.str,
                 region: _builtins.str,
                 service: _builtins.str,
                 task_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str cluster: Name of cluster in which service belong to
        :param _builtins.str region: Region of cluster
        :param _builtins.str service: Name of service to be onboarded
        :param _builtins.int task_count: Desired number of tasks on warming up a rule
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service", service)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        Name of cluster in which service belong to
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region of cluster
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        Name of service to be onboarded
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[_builtins.int]:
        """
        Desired number of tasks on warming up a rule
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class GetRuleEcsDependResult(dict):
    def __init__(__self__, *,
                 rule_id: _builtins.int,
                 delay_in_sec: Optional[_builtins.int] = None):
        """
        :param _builtins.int rule_id: Rule id of the dependent rule
        :param _builtins.int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[_builtins.int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class GetRuleEcsHttpResult(dict):
    def __init__(__self__, *,
                 proxy_id: _builtins.str):
        """
        :param _builtins.str proxy_id: Id of the proxy
        """
        pulumi.set(__self__, "proxy_id", proxy_id)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")


@pulumi.output_type
class GetRuleRdsDatabaseResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str id: ID of the database
        :param _builtins.str region: Region to which database belong to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the database
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region to which database belong to
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetRuleRdsDependResult(dict):
    def __init__(__self__, *,
                 rule_id: _builtins.int,
                 delay_in_sec: Optional[_builtins.int] = None):
        """
        :param _builtins.int rule_id: Rule id of the dependent rule
        :param _builtins.int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[_builtins.int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class GetRuleRdsTcpResult(dict):
    def __init__(__self__, *,
                 proxy_id: _builtins.str,
                 forward_rules: Optional[Sequence['outputs.GetRuleRdsTcpForwardRuleResult']] = None):
        """
        :param _builtins.str proxy_id: Id of the Proxy
        :param Sequence['GetRuleRdsTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.GetRuleRdsTcpForwardRuleResult']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")


@pulumi.output_type
class GetRuleRdsTcpForwardRuleResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 connect_on: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Port to listen on the vm
        :param _builtins.int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class GetRuleVmDependResult(dict):
    def __init__(__self__, *,
                 rule_id: _builtins.int,
                 delay_in_sec: Optional[_builtins.int] = None):
        """
        :param _builtins.int rule_id: Rule id of the dependent rule
        :param _builtins.int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[_builtins.int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class GetRuleVmFilterResult(dict):
    def __init__(__self__, *,
                 vm_ids: Sequence[_builtins.str],
                 regions: Optional[Sequence[_builtins.str]] = None,
                 tags: Optional[Sequence['outputs.GetRuleVmFilterTagResult']] = None,
                 zones: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] vm_ids: Ids of instances that needs to be managed using the AutoStopping rules
        :param Sequence[_builtins.str] regions: Regions of instances that needs to be managed using the AutoStopping rules
        :param Sequence['GetRuleVmFilterTagArgs'] tags: Tags of instances that needs to be managed using the AutoStopping rules
        :param Sequence[_builtins.str] zones: Zones of instances that needs to be managed using the AutoStopping rules
        """
        pulumi.set(__self__, "vm_ids", vm_ids)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="vmIds")
    def vm_ids(self) -> Sequence[_builtins.str]:
        """
        Ids of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "vm_ids")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Regions of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.GetRuleVmFilterTagResult']]:
        """
        Tags of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[_builtins.str]]:
        """
        Zones of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetRuleVmFilterTagResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRuleVmHttpResult(dict):
    def __init__(__self__, *,
                 proxy_id: _builtins.str,
                 healths: Optional[Sequence['outputs.GetRuleVmHttpHealthResult']] = None,
                 routings: Optional[Sequence['outputs.GetRuleVmHttpRoutingResult']] = None):
        """
        :param _builtins.str proxy_id: Id of the proxy
        :param Sequence['GetRuleVmHttpHealthArgs'] healths: Health Check Details
        :param Sequence['GetRuleVmHttpRoutingArgs'] routings: Routing configuration used to access the instances
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if routings is not None:
            pulumi.set(__self__, "routings", routings)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter
    def healths(self) -> Optional[Sequence['outputs.GetRuleVmHttpHealthResult']]:
        """
        Health Check Details
        """
        return pulumi.get(self, "healths")

    @_builtins.property
    @pulumi.getter
    def routings(self) -> Optional[Sequence['outputs.GetRuleVmHttpRoutingResult']]:
        """
        Routing configuration used to access the instances
        """
        return pulumi.get(self, "routings")


@pulumi.output_type
class GetRuleVmHttpHealthResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 path: Optional[_builtins.str] = None,
                 status_code_from: Optional[_builtins.int] = None,
                 status_code_to: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Health check port on the VM
        :param _builtins.str protocol: Protocol can be http or https
        :param _builtins.str path: API path to use for health check
        :param _builtins.int status_code_from: Lower limit for acceptable status code
        :param _builtins.int status_code_to: Upper limit for acceptable status code
        :param _builtins.int timeout: Health check timeout
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code_from is not None:
            pulumi.set(__self__, "status_code_from", status_code_from)
        if status_code_to is not None:
            pulumi.set(__self__, "status_code_to", status_code_to)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Health check port on the VM
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol can be http or https
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        API path to use for health check
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="statusCodeFrom")
    def status_code_from(self) -> Optional[_builtins.int]:
        """
        Lower limit for acceptable status code
        """
        return pulumi.get(self, "status_code_from")

    @_builtins.property
    @pulumi.getter(name="statusCodeTo")
    def status_code_to(self) -> Optional[_builtins.int]:
        """
        Upper limit for acceptable status code
        """
        return pulumi.get(self, "status_code_to")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Health check timeout
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetRuleVmHttpRoutingResult(dict):
    def __init__(__self__, *,
                 source_protocol: _builtins.str,
                 target_protocol: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 source_port: Optional[_builtins.int] = None,
                 target_port: Optional[_builtins.int] = None):
        """
        :param _builtins.str source_protocol: Source protocol of the proxy can be http or https
        :param _builtins.str target_protocol: Target protocol of the instance can be http or https
        :param _builtins.str action: Organization Identifier for the Entity
        :param _builtins.int source_port: Port on the proxy
        :param _builtins.int target_port: Port on the VM
        """
        pulumi.set(__self__, "source_protocol", source_protocol)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @_builtins.property
    @pulumi.getter(name="sourceProtocol")
    def source_protocol(self) -> _builtins.str:
        """
        Source protocol of the proxy can be http or https
        """
        return pulumi.get(self, "source_protocol")

    @_builtins.property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> _builtins.str:
        """
        Target protocol of the instance can be http or https
        """
        return pulumi.get(self, "target_protocol")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[_builtins.int]:
        """
        Port on the proxy
        """
        return pulumi.get(self, "source_port")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[_builtins.int]:
        """
        Port on the VM
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class GetRuleVmTcpResult(dict):
    def __init__(__self__, *,
                 proxy_id: _builtins.str,
                 forward_rules: Optional[Sequence['outputs.GetRuleVmTcpForwardRuleResult']] = None,
                 rdps: Optional[Sequence['outputs.GetRuleVmTcpRdpResult']] = None,
                 sshes: Optional[Sequence['outputs.GetRuleVmTcpSshResult']] = None):
        """
        :param _builtins.str proxy_id: Id of the Proxy
        :param Sequence['GetRuleVmTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        :param Sequence['GetRuleVmTcpRdpArgs'] rdps: RDP configuration
        :param Sequence['GetRuleVmTcpSshArgs'] sshes: SSH configuration
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)
        if rdps is not None:
            pulumi.set(__self__, "rdps", rdps)
        if sshes is not None:
            pulumi.set(__self__, "sshes", sshes)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.GetRuleVmTcpForwardRuleResult']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @_builtins.property
    @pulumi.getter
    def rdps(self) -> Optional[Sequence['outputs.GetRuleVmTcpRdpResult']]:
        """
        RDP configuration
        """
        return pulumi.get(self, "rdps")

    @_builtins.property
    @pulumi.getter
    def sshes(self) -> Optional[Sequence['outputs.GetRuleVmTcpSshResult']]:
        """
        SSH configuration
        """
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetRuleVmTcpForwardRuleResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 connect_on: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Port to listen on the vm
        :param _builtins.int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class GetRuleVmTcpRdpResult(dict):
    def __init__(__self__, *,
                 connect_on: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.int connect_on: Port to listen on the proxy
        :param _builtins.int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRuleVmTcpSshResult(dict):
    def __init__(__self__, *,
                 connect_on: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.int connect_on: Port to listen on the proxy
        :param _builtins.int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[_builtins.int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetScheduleRepeatResult(dict):
    def __init__(__self__, *,
                 days: Sequence[_builtins.str],
                 end_time: _builtins.str,
                 start_time: _builtins.str):
        """
        :param Sequence[_builtins.str] days: List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        :param _builtins.str end_time: Ending time of schedule action on the day. Accepted format is HH:MM. Eg : 20:00 for 8pm
        :param _builtins.str start_time: Starting time of schedule action on the day. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def days(self) -> Sequence[_builtins.str]:
        """
        List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        Ending time of schedule action on the day. Accepted format is HH:MM. Eg : 20:00 for 8pm
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Starting time of schedule action on the day. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        return pulumi.get(self, "start_time")


