# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityGovernanceConditionArgs', 'SecurityGovernanceCondition']

@pulumi.input_type
class SecurityGovernanceConditionArgs:
    def __init__(__self__, *,
                 fault_spec: pulumi.Input['SecurityGovernanceConditionFaultSpecArgs'],
                 infra_type: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 k8s_spec: Optional[pulumi.Input['SecurityGovernanceConditionK8sSpecArgs']] = None,
                 machine_spec: Optional[pulumi.Input['SecurityGovernanceConditionMachineSpecArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecurityGovernanceCondition resource.
        :param pulumi.Input['SecurityGovernanceConditionFaultSpecArgs'] fault_spec: Specification for faults to be included in the condition
        :param pulumi.Input[_builtins.str] infra_type: Type of infrastructure (Kubernetes, KubernetesV2, Linux, Windows, CloudFoundry, Container)
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance condition
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance condition
        :param pulumi.Input[_builtins.str] description: Description of the security governance condition
        :param pulumi.Input['SecurityGovernanceConditionK8sSpecArgs'] k8s_spec: Kubernetes specific configuration (required when infra*type is KUBERNETES or KUBERNETESV2)
        :param pulumi.Input['SecurityGovernanceConditionMachineSpecArgs'] machine_spec: Machine specific configuration (required when infra*type is LINUX or WINDOWS)
        :param pulumi.Input[_builtins.str] name: Name of the security governance condition
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance condition
        """
        pulumi.set(__self__, "fault_spec", fault_spec)
        pulumi.set(__self__, "infra_type", infra_type)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if k8s_spec is not None:
            pulumi.set(__self__, "k8s_spec", k8s_spec)
        if machine_spec is not None:
            pulumi.set(__self__, "machine_spec", machine_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="faultSpec")
    def fault_spec(self) -> pulumi.Input['SecurityGovernanceConditionFaultSpecArgs']:
        """
        Specification for faults to be included in the condition
        """
        return pulumi.get(self, "fault_spec")

    @fault_spec.setter
    def fault_spec(self, value: pulumi.Input['SecurityGovernanceConditionFaultSpecArgs']):
        pulumi.set(self, "fault_spec", value)

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of infrastructure (Kubernetes, KubernetesV2, Linux, Windows, CloudFoundry, Container)
        """
        return pulumi.get(self, "infra_type")

    @infra_type.setter
    def infra_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "infra_type", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The organization ID of the security governance condition
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The project ID of the security governance condition
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the security governance condition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="k8sSpec")
    def k8s_spec(self) -> Optional[pulumi.Input['SecurityGovernanceConditionK8sSpecArgs']]:
        """
        Kubernetes specific configuration (required when infra*type is KUBERNETES or KUBERNETESV2)
        """
        return pulumi.get(self, "k8s_spec")

    @k8s_spec.setter
    def k8s_spec(self, value: Optional[pulumi.Input['SecurityGovernanceConditionK8sSpecArgs']]):
        pulumi.set(self, "k8s_spec", value)

    @_builtins.property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> Optional[pulumi.Input['SecurityGovernanceConditionMachineSpecArgs']]:
        """
        Machine specific configuration (required when infra*type is LINUX or WINDOWS)
        """
        return pulumi.get(self, "machine_spec")

    @machine_spec.setter
    def machine_spec(self, value: Optional[pulumi.Input['SecurityGovernanceConditionMachineSpecArgs']]):
        pulumi.set(self, "machine_spec", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the security governance condition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for the security governance condition
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SecurityGovernanceConditionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_spec: Optional[pulumi.Input['SecurityGovernanceConditionFaultSpecArgs']] = None,
                 infra_type: Optional[pulumi.Input[_builtins.str]] = None,
                 k8s_spec: Optional[pulumi.Input['SecurityGovernanceConditionK8sSpecArgs']] = None,
                 machine_spec: Optional[pulumi.Input['SecurityGovernanceConditionMachineSpecArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecurityGovernanceCondition resources.
        :param pulumi.Input[_builtins.str] description: Description of the security governance condition
        :param pulumi.Input['SecurityGovernanceConditionFaultSpecArgs'] fault_spec: Specification for faults to be included in the condition
        :param pulumi.Input[_builtins.str] infra_type: Type of infrastructure (Kubernetes, KubernetesV2, Linux, Windows, CloudFoundry, Container)
        :param pulumi.Input['SecurityGovernanceConditionK8sSpecArgs'] k8s_spec: Kubernetes specific configuration (required when infra*type is KUBERNETES or KUBERNETESV2)
        :param pulumi.Input['SecurityGovernanceConditionMachineSpecArgs'] machine_spec: Machine specific configuration (required when infra*type is LINUX or WINDOWS)
        :param pulumi.Input[_builtins.str] name: Name of the security governance condition
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance condition
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance condition
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance condition
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fault_spec is not None:
            pulumi.set(__self__, "fault_spec", fault_spec)
        if infra_type is not None:
            pulumi.set(__self__, "infra_type", infra_type)
        if k8s_spec is not None:
            pulumi.set(__self__, "k8s_spec", k8s_spec)
        if machine_spec is not None:
            pulumi.set(__self__, "machine_spec", machine_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the security governance condition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="faultSpec")
    def fault_spec(self) -> Optional[pulumi.Input['SecurityGovernanceConditionFaultSpecArgs']]:
        """
        Specification for faults to be included in the condition
        """
        return pulumi.get(self, "fault_spec")

    @fault_spec.setter
    def fault_spec(self, value: Optional[pulumi.Input['SecurityGovernanceConditionFaultSpecArgs']]):
        pulumi.set(self, "fault_spec", value)

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of infrastructure (Kubernetes, KubernetesV2, Linux, Windows, CloudFoundry, Container)
        """
        return pulumi.get(self, "infra_type")

    @infra_type.setter
    def infra_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infra_type", value)

    @_builtins.property
    @pulumi.getter(name="k8sSpec")
    def k8s_spec(self) -> Optional[pulumi.Input['SecurityGovernanceConditionK8sSpecArgs']]:
        """
        Kubernetes specific configuration (required when infra*type is KUBERNETES or KUBERNETESV2)
        """
        return pulumi.get(self, "k8s_spec")

    @k8s_spec.setter
    def k8s_spec(self, value: Optional[pulumi.Input['SecurityGovernanceConditionK8sSpecArgs']]):
        pulumi.set(self, "k8s_spec", value)

    @_builtins.property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> Optional[pulumi.Input['SecurityGovernanceConditionMachineSpecArgs']]:
        """
        Machine specific configuration (required when infra*type is LINUX or WINDOWS)
        """
        return pulumi.get(self, "machine_spec")

    @machine_spec.setter
    def machine_spec(self, value: Optional[pulumi.Input['SecurityGovernanceConditionMachineSpecArgs']]):
        pulumi.set(self, "machine_spec", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the security governance condition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization ID of the security governance condition
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of the security governance condition
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for the security governance condition
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("harness:chaos/securityGovernanceCondition:SecurityGovernanceCondition")
class SecurityGovernanceCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionFaultSpecArgs', 'SecurityGovernanceConditionFaultSpecArgsDict']]] = None,
                 infra_type: Optional[pulumi.Input[_builtins.str]] = None,
                 k8s_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionK8sSpecArgs', 'SecurityGovernanceConditionK8sSpecArgsDict']]] = None,
                 machine_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionMachineSpecArgs', 'SecurityGovernanceConditionMachineSpecArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing a Harness Chaos Security Governance Condition

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Example of a Kubernetes Security Governance Condition
        k8s_condition = harness.chaos.SecurityGovernanceCondition("k8s_condition",
            org_id=org_id,
            project_id=project_id,
            name="k8s-security-condition",
            description="Security governance condition for Kubernetes workloads",
            infra_type="KubernetesV2",
            fault_spec={
                "operator": "NOT_EQUAL_TO",
                "faults": [
                    {
                        "fault_type": "FAULT",
                        "name": "pod-delete",
                    },
                    {
                        "fault_type": "FAULT",
                        "name": "pod-dns",
                    },
                ],
            },
            k8s_spec={
                "infra_spec": {
                    "operator": "EQUAL_TO",
                    "infra_ids": [k8s_infra_id],
                },
                "application_spec": {
                    "operator": "EQUAL_TO",
                    "workloads": [{
                        "namespace": "default",
                        "kind": "deployment",
                        "label": "app=nginx",
                        "services": ["nginx-service"],
                        "application_map_id": "nginx-app",
                    }],
                },
                "chaos_service_account_spec": {
                    "operator": "EQUAL_TO",
                    "service_accounts": [
                        "default",
                        "chaos-service-account",
                    ],
                },
            },
            tags=[
                "env:prod",
                "team:security",
                "platform:k8s",
            ])
        # Example of a Windows Security Governance Condition
        windows_condition = harness.chaos.SecurityGovernanceCondition("windows_condition",
            org_id=org_id,
            project_id=project_id,
            name="windows-security-condition",
            description="Security governance condition for Windows hosts",
            infra_type="Windows",
            fault_spec={
                "operator": "NOT_EQUAL_TO",
                "faults": [
                    {
                        "fault_type": "FAULT",
                        "name": "process-kill",
                    },
                    {
                        "fault_type": "FAULT",
                        "name": "cpu-hog",
                    },
                ],
            },
            machine_spec={
                "infra_spec": {
                    "operator": "EQUAL_TO",
                    "infra_ids": [windows_infra_id],
                },
            },
            tags=[
                "env:prod",
                "team:security",
                "platform:windows",
            ])
        # Example of a Linux Security Governance Condition
        linux_condition = harness.chaos.SecurityGovernanceCondition("linux_condition",
            org_id=org_id,
            project_id=project_id,
            name="linux-security-condition",
            description="Security governance condition for Linux hosts",
            infra_type="Linux",
            fault_spec={
                "operator": "NOT_EQUAL_TO",
                "faults": [
                    {
                        "fault_type": "FAULT",
                        "name": "process-kill",
                    },
                    {
                        "fault_type": "FAULT",
                        "name": "memory-hog",
                    },
                ],
            },
            machine_spec={
                "infra_spec": {
                    "operator": "EQUAL_TO",
                    "infra_ids": [linux_infra_id],
                },
            },
            tags=[
                "env:prod",
                "team:security",
                "platform:linux",
            ])
        pulumi.export("k8sConditionId", k8s_condition.id)
        pulumi.export("windowsConditionId", windows_condition.id)
        pulumi.export("linuxConditionId", linux_condition.id)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Security Governance Condition

        ```sh
        $ pulumi import harness:chaos/securityGovernanceCondition:SecurityGovernanceCondition example org_id/project_id/condition_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the security governance condition
        :param pulumi.Input[Union['SecurityGovernanceConditionFaultSpecArgs', 'SecurityGovernanceConditionFaultSpecArgsDict']] fault_spec: Specification for faults to be included in the condition
        :param pulumi.Input[_builtins.str] infra_type: Type of infrastructure (Kubernetes, KubernetesV2, Linux, Windows, CloudFoundry, Container)
        :param pulumi.Input[Union['SecurityGovernanceConditionK8sSpecArgs', 'SecurityGovernanceConditionK8sSpecArgsDict']] k8s_spec: Kubernetes specific configuration (required when infra*type is KUBERNETES or KUBERNETESV2)
        :param pulumi.Input[Union['SecurityGovernanceConditionMachineSpecArgs', 'SecurityGovernanceConditionMachineSpecArgsDict']] machine_spec: Machine specific configuration (required when infra*type is LINUX or WINDOWS)
        :param pulumi.Input[_builtins.str] name: Name of the security governance condition
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance condition
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance condition
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance condition
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGovernanceConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness Chaos Security Governance Condition

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Example of a Kubernetes Security Governance Condition
        k8s_condition = harness.chaos.SecurityGovernanceCondition("k8s_condition",
            org_id=org_id,
            project_id=project_id,
            name="k8s-security-condition",
            description="Security governance condition for Kubernetes workloads",
            infra_type="KubernetesV2",
            fault_spec={
                "operator": "NOT_EQUAL_TO",
                "faults": [
                    {
                        "fault_type": "FAULT",
                        "name": "pod-delete",
                    },
                    {
                        "fault_type": "FAULT",
                        "name": "pod-dns",
                    },
                ],
            },
            k8s_spec={
                "infra_spec": {
                    "operator": "EQUAL_TO",
                    "infra_ids": [k8s_infra_id],
                },
                "application_spec": {
                    "operator": "EQUAL_TO",
                    "workloads": [{
                        "namespace": "default",
                        "kind": "deployment",
                        "label": "app=nginx",
                        "services": ["nginx-service"],
                        "application_map_id": "nginx-app",
                    }],
                },
                "chaos_service_account_spec": {
                    "operator": "EQUAL_TO",
                    "service_accounts": [
                        "default",
                        "chaos-service-account",
                    ],
                },
            },
            tags=[
                "env:prod",
                "team:security",
                "platform:k8s",
            ])
        # Example of a Windows Security Governance Condition
        windows_condition = harness.chaos.SecurityGovernanceCondition("windows_condition",
            org_id=org_id,
            project_id=project_id,
            name="windows-security-condition",
            description="Security governance condition for Windows hosts",
            infra_type="Windows",
            fault_spec={
                "operator": "NOT_EQUAL_TO",
                "faults": [
                    {
                        "fault_type": "FAULT",
                        "name": "process-kill",
                    },
                    {
                        "fault_type": "FAULT",
                        "name": "cpu-hog",
                    },
                ],
            },
            machine_spec={
                "infra_spec": {
                    "operator": "EQUAL_TO",
                    "infra_ids": [windows_infra_id],
                },
            },
            tags=[
                "env:prod",
                "team:security",
                "platform:windows",
            ])
        # Example of a Linux Security Governance Condition
        linux_condition = harness.chaos.SecurityGovernanceCondition("linux_condition",
            org_id=org_id,
            project_id=project_id,
            name="linux-security-condition",
            description="Security governance condition for Linux hosts",
            infra_type="Linux",
            fault_spec={
                "operator": "NOT_EQUAL_TO",
                "faults": [
                    {
                        "fault_type": "FAULT",
                        "name": "process-kill",
                    },
                    {
                        "fault_type": "FAULT",
                        "name": "memory-hog",
                    },
                ],
            },
            machine_spec={
                "infra_spec": {
                    "operator": "EQUAL_TO",
                    "infra_ids": [linux_infra_id],
                },
            },
            tags=[
                "env:prod",
                "team:security",
                "platform:linux",
            ])
        pulumi.export("k8sConditionId", k8s_condition.id)
        pulumi.export("windowsConditionId", windows_condition.id)
        pulumi.export("linuxConditionId", linux_condition.id)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import Project level Chaos Security Governance Condition

        ```sh
        $ pulumi import harness:chaos/securityGovernanceCondition:SecurityGovernanceCondition example org_id/project_id/condition_id
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGovernanceConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGovernanceConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionFaultSpecArgs', 'SecurityGovernanceConditionFaultSpecArgsDict']]] = None,
                 infra_type: Optional[pulumi.Input[_builtins.str]] = None,
                 k8s_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionK8sSpecArgs', 'SecurityGovernanceConditionK8sSpecArgsDict']]] = None,
                 machine_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionMachineSpecArgs', 'SecurityGovernanceConditionMachineSpecArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGovernanceConditionArgs.__new__(SecurityGovernanceConditionArgs)

            __props__.__dict__["description"] = description
            if fault_spec is None and not opts.urn:
                raise TypeError("Missing required property 'fault_spec'")
            __props__.__dict__["fault_spec"] = fault_spec
            if infra_type is None and not opts.urn:
                raise TypeError("Missing required property 'infra_type'")
            __props__.__dict__["infra_type"] = infra_type
            __props__.__dict__["k8s_spec"] = k8s_spec
            __props__.__dict__["machine_spec"] = machine_spec
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
        super(SecurityGovernanceCondition, __self__).__init__(
            'harness:chaos/securityGovernanceCondition:SecurityGovernanceCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            fault_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionFaultSpecArgs', 'SecurityGovernanceConditionFaultSpecArgsDict']]] = None,
            infra_type: Optional[pulumi.Input[_builtins.str]] = None,
            k8s_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionK8sSpecArgs', 'SecurityGovernanceConditionK8sSpecArgsDict']]] = None,
            machine_spec: Optional[pulumi.Input[Union['SecurityGovernanceConditionMachineSpecArgs', 'SecurityGovernanceConditionMachineSpecArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecurityGovernanceCondition':
        """
        Get an existing SecurityGovernanceCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the security governance condition
        :param pulumi.Input[Union['SecurityGovernanceConditionFaultSpecArgs', 'SecurityGovernanceConditionFaultSpecArgsDict']] fault_spec: Specification for faults to be included in the condition
        :param pulumi.Input[_builtins.str] infra_type: Type of infrastructure (Kubernetes, KubernetesV2, Linux, Windows, CloudFoundry, Container)
        :param pulumi.Input[Union['SecurityGovernanceConditionK8sSpecArgs', 'SecurityGovernanceConditionK8sSpecArgsDict']] k8s_spec: Kubernetes specific configuration (required when infra*type is KUBERNETES or KUBERNETESV2)
        :param pulumi.Input[Union['SecurityGovernanceConditionMachineSpecArgs', 'SecurityGovernanceConditionMachineSpecArgsDict']] machine_spec: Machine specific configuration (required when infra*type is LINUX or WINDOWS)
        :param pulumi.Input[_builtins.str] name: Name of the security governance condition
        :param pulumi.Input[_builtins.str] org_id: The organization ID of the security governance condition
        :param pulumi.Input[_builtins.str] project_id: The project ID of the security governance condition
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for the security governance condition
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGovernanceConditionState.__new__(_SecurityGovernanceConditionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["fault_spec"] = fault_spec
        __props__.__dict__["infra_type"] = infra_type
        __props__.__dict__["k8s_spec"] = k8s_spec
        __props__.__dict__["machine_spec"] = machine_spec
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        return SecurityGovernanceCondition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the security governance condition
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="faultSpec")
    def fault_spec(self) -> pulumi.Output['outputs.SecurityGovernanceConditionFaultSpec']:
        """
        Specification for faults to be included in the condition
        """
        return pulumi.get(self, "fault_spec")

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of infrastructure (Kubernetes, KubernetesV2, Linux, Windows, CloudFoundry, Container)
        """
        return pulumi.get(self, "infra_type")

    @_builtins.property
    @pulumi.getter(name="k8sSpec")
    def k8s_spec(self) -> pulumi.Output[Optional['outputs.SecurityGovernanceConditionK8sSpec']]:
        """
        Kubernetes specific configuration (required when infra*type is KUBERNETES or KUBERNETESV2)
        """
        return pulumi.get(self, "k8s_spec")

    @_builtins.property
    @pulumi.getter(name="machineSpec")
    def machine_spec(self) -> pulumi.Output[Optional['outputs.SecurityGovernanceConditionMachineSpec']]:
        """
        Machine specific configuration (required when infra*type is LINUX or WINDOWS)
        """
        return pulumi.get(self, "machine_spec")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the security governance condition
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The organization ID of the security governance condition
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID of the security governance condition
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags for the security governance condition
        """
        return pulumi.get(self, "tags")

