# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HarRegistryArgs', 'HarRegistry']

@pulumi.input_type
class HarRegistryArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 package_type: pulumi.Input[_builtins.str],
                 allowed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 space_ref: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HarRegistry resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the registry
        :param pulumi.Input[_builtins.str] package_type: Type of package (DOCKER, HELM, MAVEN, etc.)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_patterns: Allowed artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_patterns: Blocked artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]] configs: Configuration for the registry
        :param pulumi.Input[_builtins.str] description: Description of the registry
        :param pulumi.Input[_builtins.str] parent_ref: Parent reference for the registry
        :param pulumi.Input[_builtins.str] space_ref: Space reference for the registry
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "package_type", package_type)
        if allowed_patterns is not None:
            pulumi.set(__self__, "allowed_patterns", allowed_patterns)
        if blocked_patterns is not None:
            pulumi.set(__self__, "blocked_patterns", blocked_patterns)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if space_ref is not None:
            pulumi.set(__self__, "space_ref", space_ref)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the registry
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of package (DOCKER, HELM, MAVEN, etc.)
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter(name="allowedPatterns")
    def allowed_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed artifact patterns
        """
        return pulumi.get(self, "allowed_patterns")

    @allowed_patterns.setter
    def allowed_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_patterns", value)

    @_builtins.property
    @pulumi.getter(name="blockedPatterns")
    def blocked_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Blocked artifact patterns
        """
        return pulumi.get(self, "blocked_patterns")

    @blocked_patterns.setter
    def blocked_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_patterns", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]]]:
        """
        Configuration for the registry
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the registry
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent reference for the registry
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_ref", value)

    @_builtins.property
    @pulumi.getter(name="spaceRef")
    def space_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Space reference for the registry
        """
        return pulumi.get(self, "space_ref")

    @space_ref.setter
    def space_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space_ref", value)


@pulumi.input_type
class _HarRegistryState:
    def __init__(__self__, *,
                 allowed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 space_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HarRegistry resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_patterns: Allowed artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_patterns: Blocked artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]] configs: Configuration for the registry
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.str] description: Description of the registry
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the registry
        :param pulumi.Input[_builtins.str] package_type: Type of package (DOCKER, HELM, MAVEN, etc.)
        :param pulumi.Input[_builtins.str] parent_ref: Parent reference for the registry
        :param pulumi.Input[_builtins.str] space_ref: Space reference for the registry
        :param pulumi.Input[_builtins.str] url: URL of the registry
        """
        if allowed_patterns is not None:
            pulumi.set(__self__, "allowed_patterns", allowed_patterns)
        if blocked_patterns is not None:
            pulumi.set(__self__, "blocked_patterns", blocked_patterns)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if space_ref is not None:
            pulumi.set(__self__, "space_ref", space_ref)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="allowedPatterns")
    def allowed_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed artifact patterns
        """
        return pulumi.get(self, "allowed_patterns")

    @allowed_patterns.setter
    def allowed_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_patterns", value)

    @_builtins.property
    @pulumi.getter(name="blockedPatterns")
    def blocked_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Blocked artifact patterns
        """
        return pulumi.get(self, "blocked_patterns")

    @blocked_patterns.setter
    def blocked_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_patterns", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]]]:
        """
        Configuration for the registry
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HarRegistryConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the registry
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the registry
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of package (DOCKER, HELM, MAVEN, etc.)
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent reference for the registry
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_ref", value)

    @_builtins.property
    @pulumi.getter(name="spaceRef")
    def space_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Space reference for the registry
        """
        return pulumi.get(self, "space_ref")

    @space_ref.setter
    def space_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space_ref", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the registry
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("harness:platform/harRegistry:HarRegistry")
class HarRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HarRegistryConfigArgs', 'HarRegistryConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 space_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating and managing Harness Registries.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Example of a Virtual Registry
        virtual_registry = harness.platform.HarRegistry("virtual_registry",
            identifier="virtual_docker_registry",
            description="Virtual Docker Registry",
            space_ref="accountId/orgId/projectId",
            package_type="DOCKER",
            configs=[{
                "type": "VIRTUAL",
                "upstream_proxies": [
                    "registry1",
                    "registry2",
                ],
            }],
            parent_ref="accountId/orgId/projectId")
        # Example of an Upstream Registry with Authentication
        upstream_registry = harness.platform.HarRegistry("upstream_registry",
            identifier="upstream_helm_registry",
            description="Upstream Helm Registry",
            space_ref="accountId/orgId/projectId",
            package_type="HELM",
            configs=[{
                "type": "UPSTREAM",
                "source": "CUSTOM",
                "url": "https://helm.sh",
                "auths": [{
                    "auth_type": "UserPassword",
                    "user_name": "registry_user",
                    "secret_identifier": "registry_password",
                    "secret_space_path": "accountId/orgId/projectId",
                }],
            }],
            parent_ref="accountId/orgId/projectId")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_patterns: Allowed artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_patterns: Blocked artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input[Union['HarRegistryConfigArgs', 'HarRegistryConfigArgsDict']]]] configs: Configuration for the registry
        :param pulumi.Input[_builtins.str] description: Description of the registry
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the registry
        :param pulumi.Input[_builtins.str] package_type: Type of package (DOCKER, HELM, MAVEN, etc.)
        :param pulumi.Input[_builtins.str] parent_ref: Parent reference for the registry
        :param pulumi.Input[_builtins.str] space_ref: Space reference for the registry
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HarRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating and managing Harness Registries.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Example of a Virtual Registry
        virtual_registry = harness.platform.HarRegistry("virtual_registry",
            identifier="virtual_docker_registry",
            description="Virtual Docker Registry",
            space_ref="accountId/orgId/projectId",
            package_type="DOCKER",
            configs=[{
                "type": "VIRTUAL",
                "upstream_proxies": [
                    "registry1",
                    "registry2",
                ],
            }],
            parent_ref="accountId/orgId/projectId")
        # Example of an Upstream Registry with Authentication
        upstream_registry = harness.platform.HarRegistry("upstream_registry",
            identifier="upstream_helm_registry",
            description="Upstream Helm Registry",
            space_ref="accountId/orgId/projectId",
            package_type="HELM",
            configs=[{
                "type": "UPSTREAM",
                "source": "CUSTOM",
                "url": "https://helm.sh",
                "auths": [{
                    "auth_type": "UserPassword",
                    "user_name": "registry_user",
                    "secret_identifier": "registry_password",
                    "secret_space_path": "accountId/orgId/projectId",
                }],
            }],
            parent_ref="accountId/orgId/projectId")
        ```

        :param str resource_name: The name of the resource.
        :param HarRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HarRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HarRegistryConfigArgs', 'HarRegistryConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 space_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HarRegistryArgs.__new__(HarRegistryArgs)

            __props__.__dict__["allowed_patterns"] = allowed_patterns
            __props__.__dict__["blocked_patterns"] = blocked_patterns
            __props__.__dict__["configs"] = configs
            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            if package_type is None and not opts.urn:
                raise TypeError("Missing required property 'package_type'")
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["parent_ref"] = parent_ref
            __props__.__dict__["space_ref"] = space_ref
            __props__.__dict__["created_at"] = None
            __props__.__dict__["url"] = None
        super(HarRegistry, __self__).__init__(
            'harness:platform/harRegistry:HarRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            blocked_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HarRegistryConfigArgs', 'HarRegistryConfigArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            package_type: Optional[pulumi.Input[_builtins.str]] = None,
            parent_ref: Optional[pulumi.Input[_builtins.str]] = None,
            space_ref: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'HarRegistry':
        """
        Get an existing HarRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_patterns: Allowed artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_patterns: Blocked artifact patterns
        :param pulumi.Input[Sequence[pulumi.Input[Union['HarRegistryConfigArgs', 'HarRegistryConfigArgsDict']]]] configs: Configuration for the registry
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp
        :param pulumi.Input[_builtins.str] description: Description of the registry
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the registry
        :param pulumi.Input[_builtins.str] package_type: Type of package (DOCKER, HELM, MAVEN, etc.)
        :param pulumi.Input[_builtins.str] parent_ref: Parent reference for the registry
        :param pulumi.Input[_builtins.str] space_ref: Space reference for the registry
        :param pulumi.Input[_builtins.str] url: URL of the registry
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HarRegistryState.__new__(_HarRegistryState)

        __props__.__dict__["allowed_patterns"] = allowed_patterns
        __props__.__dict__["blocked_patterns"] = blocked_patterns
        __props__.__dict__["configs"] = configs
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["parent_ref"] = parent_ref
        __props__.__dict__["space_ref"] = space_ref
        __props__.__dict__["url"] = url
        return HarRegistry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedPatterns")
    def allowed_patterns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Allowed artifact patterns
        """
        return pulumi.get(self, "allowed_patterns")

    @_builtins.property
    @pulumi.getter(name="blockedPatterns")
    def blocked_patterns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Blocked artifact patterns
        """
        return pulumi.get(self, "blocked_patterns")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Optional[Sequence['outputs.HarRegistryConfig']]]:
        """
        Configuration for the registry
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the registry
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the registry
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of package (DOCKER, HELM, MAVEN, etc.)
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Parent reference for the registry
        """
        return pulumi.get(self, "parent_ref")

    @_builtins.property
    @pulumi.getter(name="spaceRef")
    def space_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Space reference for the registry
        """
        return pulumi.get(self, "space_ref")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the registry
        """
        return pulumi.get(self, "url")

