# -*- coding: utf-8 -*-
'''
Created on Wed Feb  5 16:19:16 2020

@author: butkus
'''
import setuptools
import codecs
import os.path

with open('README.md', 'r') as fh:
    long_description = fh.read()
    
with open('requirements.txt', 'r') as fr:
    install_requires = [line.strip() for line in fr.readlines()]


def read(rel_path):
    here = os.path.abspath(os.path.dirname(__file__))
    with codecs.open(os.path.join(here, rel_path), 'r') as fp:
        return fp.read()

def get_version(rel_path):
    for line in read(rel_path).splitlines():
        if line.startswith('__version__'):
            delim = '"' if '"' in line else "'"
            return line.split(delim)[1]
    else:
        raise RuntimeError("Unable to find version string.")

setuptools.setup(
    name='lightcon', # Replace with your own username
    version=get_version("lightcon/__init__.py"),
    author='Vytautas Butkus',
    author_email='vytautas.butkus@lightcon.com',
    description='A set of APIs to Light Conversion devices',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://bitbucket.org/harpiasoftware/light-conversion-apis.git',
    install_requires = install_requires,
    packages=setuptools.find_packages(),
    include_package_data=True,
    data_files = [('Lib/site-packages/lightcon/harpia_daq', 
                ['lightcon/harpia_daq/LightConversion.Hardware.HarpiaDaq.dll', 
                'lightcon/harpia_daq/FTD2XX_NET.dll', 
                'lightcon/harpia_daq/LightConversion.Abstractions.dll',
                'lightcon/harpia_daq/System.Threading.dll']),
            ('Lib/site-packages/lightcon/fast_daq', 
                ['lightcon/fast_daq/LightConversion.Hardware.FastDaq.dll', 
                'lightcon/fast_daq/FTD2XX_NET.dll', 
                'lightcon/fast_daq/LightConversion.Abstractions.dll',
                'lightcon/fast_daq/System.Threading.dll']),
            ('Lib/site-packages/lightcon/style', 
                ['lightcon/style/lclogo.png',
                'lightcon/style/lcstyle.mplstyle'])],
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Development Status :: 1 - Planning',
    ],
    project_urls = {
            'Examples': 'https://bitbucket.org/harpiasoftware/light-conversion-apis/src/master/examples/'},
    python_requires='>=3.7',
)

