# mypy-boto3-sagemaker

[![PyPI - mypy-boto3-sagemaker](https://img.shields.io/pypi/v/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.SageMaker 1.13.19](https://boto3.amazonaws.com/v1/documentation/api/1.13.19/reference/services/sagemaker.html#SageMaker) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-sagemaker](#mypy-boto3-sagemaker)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `SageMaker` service.

```bash
python -m pip install boto3-stubs[sagemaker]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import sagemaker
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_sagemaker as sagemaker

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("sagemaker")
client: sagemaker.SageMakerClient = boto3.client("sagemaker")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: sagemaker.SageMakerClient = session.client("sagemaker")


# Waiters need type annotation on creation
endpoint_deleted_waiter: sagemaker.EndpointDeletedWaiter = client.get_waiter("endpoint_deleted")
endpoint_in_service_waiter: sagemaker.EndpointInServiceWaiter = client.get_waiter("endpoint_in_service")
notebook_instance_deleted_waiter: sagemaker.NotebookInstanceDeletedWaiter = client.get_waiter("notebook_instance_deleted")
notebook_instance_in_service_waiter: sagemaker.NotebookInstanceInServiceWaiter = client.get_waiter("notebook_instance_in_service")
notebook_instance_stopped_waiter: sagemaker.NotebookInstanceStoppedWaiter = client.get_waiter("notebook_instance_stopped")
processing_job_completed_or_stopped_waiter: sagemaker.ProcessingJobCompletedOrStoppedWaiter = client.get_waiter("processing_job_completed_or_stopped")
training_job_completed_or_stopped_waiter: sagemaker.TrainingJobCompletedOrStoppedWaiter = client.get_waiter("training_job_completed_or_stopped")
transform_job_completed_or_stopped_waiter: sagemaker.TransformJobCompletedOrStoppedWaiter = client.get_waiter("transform_job_completed_or_stopped")

# Paginators need type annotation on creation
list_algorithms_paginator: sagemaker.ListAlgorithmsPaginator = client.get_paginator("list_algorithms")
list_apps_paginator: sagemaker.ListAppsPaginator = client.get_paginator("list_apps")
list_auto_ml_jobs_paginator: sagemaker.ListAutoMLJobsPaginator = client.get_paginator("list_auto_ml_jobs")
list_candidates_for_auto_ml_job_paginator: sagemaker.ListCandidatesForAutoMLJobPaginator = client.get_paginator("list_candidates_for_auto_ml_job")
list_code_repositories_paginator: sagemaker.ListCodeRepositoriesPaginator = client.get_paginator("list_code_repositories")
list_compilation_jobs_paginator: sagemaker.ListCompilationJobsPaginator = client.get_paginator("list_compilation_jobs")
list_domains_paginator: sagemaker.ListDomainsPaginator = client.get_paginator("list_domains")
list_endpoint_configs_paginator: sagemaker.ListEndpointConfigsPaginator = client.get_paginator("list_endpoint_configs")
list_endpoints_paginator: sagemaker.ListEndpointsPaginator = client.get_paginator("list_endpoints")
list_experiments_paginator: sagemaker.ListExperimentsPaginator = client.get_paginator("list_experiments")
list_flow_definitions_paginator: sagemaker.ListFlowDefinitionsPaginator = client.get_paginator("list_flow_definitions")
list_human_task_uis_paginator: sagemaker.ListHumanTaskUisPaginator = client.get_paginator("list_human_task_uis")
list_hyper_parameter_tuning_jobs_paginator: sagemaker.ListHyperParameterTuningJobsPaginator = client.get_paginator("list_hyper_parameter_tuning_jobs")
list_labeling_jobs_paginator: sagemaker.ListLabelingJobsPaginator = client.get_paginator("list_labeling_jobs")
list_labeling_jobs_for_workteam_paginator: sagemaker.ListLabelingJobsForWorkteamPaginator = client.get_paginator("list_labeling_jobs_for_workteam")
list_model_packages_paginator: sagemaker.ListModelPackagesPaginator = client.get_paginator("list_model_packages")
list_models_paginator: sagemaker.ListModelsPaginator = client.get_paginator("list_models")
list_monitoring_executions_paginator: sagemaker.ListMonitoringExecutionsPaginator = client.get_paginator("list_monitoring_executions")
list_monitoring_schedules_paginator: sagemaker.ListMonitoringSchedulesPaginator = client.get_paginator("list_monitoring_schedules")
list_notebook_instance_lifecycle_configs_paginator: sagemaker.ListNotebookInstanceLifecycleConfigsPaginator = client.get_paginator("list_notebook_instance_lifecycle_configs")
list_notebook_instances_paginator: sagemaker.ListNotebookInstancesPaginator = client.get_paginator("list_notebook_instances")
list_processing_jobs_paginator: sagemaker.ListProcessingJobsPaginator = client.get_paginator("list_processing_jobs")
list_subscribed_workteams_paginator: sagemaker.ListSubscribedWorkteamsPaginator = client.get_paginator("list_subscribed_workteams")
list_tags_paginator: sagemaker.ListTagsPaginator = client.get_paginator("list_tags")
list_training_jobs_paginator: sagemaker.ListTrainingJobsPaginator = client.get_paginator("list_training_jobs")
list_training_jobs_for_hyper_parameter_tuning_job_paginator: sagemaker.ListTrainingJobsForHyperParameterTuningJobPaginator = client.get_paginator("list_training_jobs_for_hyper_parameter_tuning_job")
list_transform_jobs_paginator: sagemaker.ListTransformJobsPaginator = client.get_paginator("list_transform_jobs")
list_trial_components_paginator: sagemaker.ListTrialComponentsPaginator = client.get_paginator("list_trial_components")
list_trials_paginator: sagemaker.ListTrialsPaginator = client.get_paginator("list_trials")
list_user_profiles_paginator: sagemaker.ListUserProfilesPaginator = client.get_paginator("list_user_profiles")
list_workteams_paginator: sagemaker.ListWorkteamsPaginator = client.get_paginator("list_workteams")
search_paginator: sagemaker.SearchPaginator = client.get_paginator("search")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.