"""
API route generator.
"""

from .base import CodeGenerator


class APIGenerator(CodeGenerator):
    """Generate API routes with CRUD operations."""

    def generate(self) -> dict[str, str]:
        model_name = self.options.get("model", self.class_name)
        service_name = f"{self.class_name}Service"

        # Generate request/response models
        create_model = f"{model_name}Create"
        update_model = f"{model_name}Update"

        code = f'''"""
{self.class_name} API routes.

Auto-generated by Zenith framework.
"""

from typing import Optional
from zenith import Router, Service, Inject
from zenith.exceptions import HTTPException
from pydantic import BaseModel
from models.{self.variable_name} import {model_name}
from services.{self.variable_name}_service import {service_name}


# Request/Response models
class {create_model}(BaseModel):
    """Create {self.variable_name} request."""
    # Add fields here
    pass


class {update_model}(BaseModel):
    """Update {self.variable_name} request."""
    # Add fields here
    pass


# Create router
router = Router(prefix="/{self.table_name}")


@router.get("/", response_model=list[{model_name}])
async def get_{self.table_name}(
    limit: int = 100,
    offset: int = 0,
    {self.variable_name}_service: {service_name} = Inject()
):
    """Get all {self.table_name}."""
    return await {self.variable_name}_service.get_all(limit=limit, offset=offset)


@router.get("/{{{self.variable_name}_id}}", response_model={model_name})
async def get_{self.variable_name}(
    {self.variable_name}_id: int,
    {self.variable_name}_service: {service_name} = Inject()
):
    """Get {self.variable_name} by ID."""
    obj = await {self.variable_name}_service.get_by_id({self.variable_name}_id)
    if not obj:
        raise HTTPException(404, "{model_name} not found")
    return obj


@router.post("/", response_model={model_name}, status_code=201)
async def create_{self.variable_name}(
    data: {create_model},
    {self.variable_name}_service: {service_name} = Inject()
):
    """Create new {self.variable_name}."""
    return await {self.variable_name}_service.create(**data.model_dump())


@router.patch("/{{{self.variable_name}_id}}", response_model={model_name})
async def update_{self.variable_name}(
    {self.variable_name}_id: int,
    data: {update_model},
    {self.variable_name}_service: {service_name} = Inject()
):
    """Update {self.variable_name}."""
    obj = await {self.variable_name}_service.update(
        {self.variable_name}_id,
        **data.model_dump(exclude_unset=True)
    )
    if not obj:
        raise HTTPException(404, "{model_name} not found")
    return obj


@router.delete("/{{{self.variable_name}_id}}", status_code=204)
async def delete_{self.variable_name}(
    {self.variable_name}_id: int,
    {self.variable_name}_service: {service_name} = Inject()
):
    """Delete {self.variable_name}."""
    deleted = await {self.variable_name}_service.delete({self.variable_name}_id)
    if not deleted:
        raise HTTPException(404, "{model_name} not found")
'''

        return {f"routes/{self.variable_name}_api.py": code}
