"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.App = exports.AppProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const elasticsearchserverless_generated_1 = require("./elasticsearchserverless.generated");
Object.defineProperty(exports, "AppProperty", { enumerable: true, get: function () { return elasticsearchserverless_generated_1.RosApp; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ElasticSearchServerless::App`, which is used to create an Elasticsearch serverless application.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosApp`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-elasticsearchserverless-app
 */
class App extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosApp = new elasticsearchserverless_generated_1.RosApp(this, id, {
            appVersion: props.appVersion === undefined || props.appVersion === null ? '7.10' : props.appVersion,
            description: props.description,
            authentication: props.authentication,
            quotaInfo: props.quotaInfo,
            network: props.network,
            logProConfiguration: props.logProConfiguration,
            privateNetwork: props.privateNetwork,
            scenario: props.scenario === undefined || props.scenario === null ? 'SEARCH' : props.scenario,
            appName: props.appName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApp;
        this.attrInstanceId = rosApp.attrInstanceId;
        this.attrPrivateEsDomain = rosApp.attrPrivateEsDomain;
        this.attrPrivateKibanaDomain = rosApp.attrPrivateKibanaDomain;
        this.attrPublicEsDomain = rosApp.attrPublicEsDomain;
        this.attrPublicKibanaDomain = rosApp.attrPublicKibanaDomain;
        this.attrUsername = rosApp.attrUsername;
    }
}
exports.App = App;
//# sourceMappingURL=data:application/json;base64,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