# generate auto __version__
from importlib.metadata import PackageNotFoundError, version

try:
    __version__ = version("ncca-ngl")
except PackageNotFoundError:
    __version__ = "0.0.0"

__author__ = "Jon Macey jmacey@bournemouth.ac.uk"
__license__ = "MIT"

from .abstract_vao import AbstractVAO, VertexData
from .base_mesh import BaseMesh, Face
from .bbox import BBox
from .bezier_curve import BezierCurve
from .first_person_camera import FirstPersonCamera
from .image import Image, ImageModes
from .log import logger
from .mat2 import Mat2
from .mat3 import Mat3, Mat3Error, Mat3NotSquare
from .mat4 import Mat4, Mat4Error, Mat4NotSquare
from .multi_buffer_vao import MultiBufferVAO
from .obj import (
    Obj,
    ObjParseFaceError,
    ObjParseNormalError,
    ObjParseUVError,
    ObjParseVertexError,
)
from .plane import Plane
from .prim_data import PrimData, Prims
from .primitives import Primitives
from .pyside_event_handling_mixin import PySideEventHandlingMixin
from .quaternion import Quaternion
from .random import Random
from .shader import MatrixTranspose, Shader, ShaderType
from .shader_lib import DefaultShader, ShaderLib
from .shader_program import ShaderProgram
from .simple_index_vao import IndexVertexData, SimpleIndexVAO
from .simple_vao import SimpleVAO
from .text import Text
from .texture import Texture
from .transform import Transform, TransformRotationOrder
from .util import PerspMode, calc_normal, clamp, frustum, lerp, look_at, ortho, perspective
from .vao_factory import VAOFactory, VAOType
from .vec2 import Vec2
from .vec2_array import Vec2Array
from .vec3 import Vec3
from .vec3_array import Vec3Array
from .vec4 import Vec4
from .vec4_array import Vec4Array

all = [
    AbstractVAO,
    VertexData,
    BaseMesh,
    Face,
    BBox,
    BezierCurve,
    Image,
    ImageModes,
    Mat2,
    Mat3,
    Mat4,
    MultiBufferVAO,
    Obj,
    Plane,
    Quaternion,
    MatrixTranspose,
    Shader,
    ShaderProgram,
    ShaderType,
    ShaderLib,
    IndexVertexData,
    SimpleIndexVAO,
    SimpleVAO,
    Texture,
    VAOFactory,
    Vec2,
    Vec3,
    Vec4,
    Vec3Array,
    Vec2Array,
    Vec4Array,
    ObjParseVertexError,
    ObjParseNormalError,
    ObjParseUVError,
    ObjParseFaceError,
    clamp,
    lerp,
    look_at,
    perspective,
    ortho,
    frustum,
    Transform,
    TransformRotationOrder,
    Random,
    Text,
    calc_normal,
    Mat3Error,
    Mat4Error,
    Mat3NotSquare,
    Mat4NotSquare,
    Mat4NotSquare,
    VAOType,
    DefaultShader,
    logger,
    Primitives,
    Prims,
    PrimData,
    FirstPersonCamera,
    PySideEventHandlingMixin,
    PerspMode,
]
