from setuptools import setup

setup(
    name="pytest-adaptavist-fixed",
    description="pytest plugin for generating test execution results within Jira Test Management (tm4j)",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    version="0.15",
    url="https://github.com/devolo/pytest-adaptavist",
    author="Stephan Steinberg, Markus Bong, Guido Schmitz",
    author_email="markus.bong@devolo.de, guido.schmitz@devolo.de",
    license="MIT",
    license_files=("LICENSE.md",),
    py_modules=["pytest_adaptavist"],
    packages=["pytest_adaptavist"],
    package_data={"pytest_adaptavist": ["py.typed"]},
    entry_points={"pytest11": ["adaptavist = pytest_adaptavist"]},
    platforms="any",
    python_requires=">=3.8",
    install_requires=["adaptavist-fixed==0.3", "pytest>=5.4.0", "pytest-assume>=2.3.2", "pytest-metadata>=1.6.0"],
    extras_require={"test": ["beautifulsoup4", "lxml", "requests"]},
    setup_requires=["setuptools_scm"],
    keywords="python pytest adaptavist kanoah tm4j jira test testmanagement report",
    classifiers=[
        "Framework :: Pytest",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Topic :: Software Development :: Quality Assurance",
        "Topic :: Software Development :: Testing",
        "Topic :: Utilities",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
)
