"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceInstance = exports.ServiceInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const computenest_generated_1 = require("./computenest.generated");
Object.defineProperty(exports, "ServiceInstanceProperty", { enumerable: true, get: function () { return computenest_generated_1.RosServiceInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::ComputeNest::ServiceInstance`, which type is used to query the information about a service instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosServiceInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-computenest-serviceinstance
 */
class ServiceInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosServiceInstance = new computenest_generated_1.RosServiceInstance(this, id, {
            serviceInstanceId: props.serviceInstanceId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosServiceInstance;
        this.attrComponents = rosServiceInstance.attrComponents;
        this.attrCreateTime = rosServiceInstance.attrCreateTime;
        this.attrEnableInstanceOps = rosServiceInstance.attrEnableInstanceOps;
        this.attrEnableUserPrometheus = rosServiceInstance.attrEnableUserPrometheus;
        this.attrIsOperated = rosServiceInstance.attrIsOperated;
        this.attrLicenseEndTime = rosServiceInstance.attrLicenseEndTime;
        this.attrMarketInstanceId = rosServiceInstance.attrMarketInstanceId;
        this.attrNetworkConfig = rosServiceInstance.attrNetworkConfig;
        this.attrOutputs = rosServiceInstance.attrOutputs;
        this.attrParameters = rosServiceInstance.attrParameters;
        this.attrPredefinedParameterName = rosServiceInstance.attrPredefinedParameterName;
        this.attrProgress = rosServiceInstance.attrProgress;
        this.attrResourceGroupId = rosServiceInstance.attrResourceGroupId;
        this.attrService = rosServiceInstance.attrService;
        this.attrServiceInstanceId = rosServiceInstance.attrServiceInstanceId;
        this.attrServiceInstanceName = rosServiceInstance.attrServiceInstanceName;
        this.attrServiceType = rosServiceInstance.attrServiceType;
        this.attrSource = rosServiceInstance.attrSource;
        this.attrStatusDetail = rosServiceInstance.attrStatusDetail;
        this.attrSupplierUid = rosServiceInstance.attrSupplierUid;
        this.attrTags = rosServiceInstance.attrTags;
        this.attrTemplateName = rosServiceInstance.attrTemplateName;
        this.attrUpdateTime = rosServiceInstance.attrUpdateTime;
        this.attrUserId = rosServiceInstance.attrUserId;
    }
}
exports.ServiceInstance = ServiceInstance;
//# sourceMappingURL=data:application/json;base64,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