"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntranetConnectorEndpoint = exports.IntranetConnectorEndpointProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const computenest_generated_1 = require("./computenest.generated");
Object.defineProperty(exports, "IntranetConnectorEndpointProperty", { enumerable: true, get: function () { return computenest_generated_1.RosIntranetConnectorEndpoint; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ComputeNest::IntranetConnectorEndpoint`, which is used to create an endpoint.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosIntranetConnectorEndpoint`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-computenest-intranetconnectorendpoint
 */
class IntranetConnectorEndpoint extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosIntranetConnectorEndpoint = new computenest_generated_1.RosIntranetConnectorEndpoint(this, id, {
            enablePrivateZone: props.enablePrivateZone,
            type: props.type,
            endpointRegionId: props.endpointRegionId,
            description: props.description,
            vpcId: props.vpcId,
            resourceIds: props.resourceIds,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosIntranetConnectorEndpoint;
        this.attrEndpointId = rosIntranetConnectorEndpoint.attrEndpointId;
    }
}
exports.IntranetConnectorEndpoint = IntranetConnectorEndpoint;
//# sourceMappingURL=data:application/json;base64,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