"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceInstance = exports.ServiceInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const computenest_generated_1 = require("./computenest.generated");
Object.defineProperty(exports, "ServiceInstanceProperty", { enumerable: true, get: function () { return computenest_generated_1.RosServiceInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ComputeNest::ServiceInstance`The , which type is used to create and deploy a service instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosServiceInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-computenest-serviceinstance
 */
class ServiceInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosServiceInstance = new computenest_generated_1.RosServiceInstance(this, id, {
            specificationCode: props.specificationCode,
            parameters: props.parameters,
            resourceGroupId: props.resourceGroupId,
            operationName: props.operationName,
            serviceInstanceName: props.serviceInstanceName,
            enableInstanceOps: props.enableInstanceOps,
            dryRun: props.dryRun,
            service: props.service,
            predefinedParameterName: props.predefinedParameterName,
            resourceAutoPay: props.resourceAutoPay,
            commodity: props.commodity,
            enableUserPrometheus: props.enableUserPrometheus,
            templateName: props.templateName,
            contactGroup: props.contactGroup,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosServiceInstance;
        this.attrComponents = rosServiceInstance.attrComponents;
        this.attrCreateTime = rosServiceInstance.attrCreateTime;
        this.attrEnableInstanceOps = rosServiceInstance.attrEnableInstanceOps;
        this.attrEnableUserPrometheus = rosServiceInstance.attrEnableUserPrometheus;
        this.attrIsOperated = rosServiceInstance.attrIsOperated;
        this.attrLicenseEndTime = rosServiceInstance.attrLicenseEndTime;
        this.attrMarketInstanceId = rosServiceInstance.attrMarketInstanceId;
        this.attrNetworkConfig = rosServiceInstance.attrNetworkConfig;
        this.attrOutput = rosServiceInstance.attrOutput;
        this.attrOutputs = rosServiceInstance.attrOutputs;
        this.attrParameters = rosServiceInstance.attrParameters;
        this.attrPredefinedParameterName = rosServiceInstance.attrPredefinedParameterName;
        this.attrProgress = rosServiceInstance.attrProgress;
        this.attrResourceGroupId = rosServiceInstance.attrResourceGroupId;
        this.attrService = rosServiceInstance.attrService;
        this.attrServiceInstanceId = rosServiceInstance.attrServiceInstanceId;
        this.attrServiceInstanceName = rosServiceInstance.attrServiceInstanceName;
        this.attrServiceType = rosServiceInstance.attrServiceType;
        this.attrSource = rosServiceInstance.attrSource;
        this.attrStatusDetail = rosServiceInstance.attrStatusDetail;
        this.attrSupplierUid = rosServiceInstance.attrSupplierUid;
        this.attrTags = rosServiceInstance.attrTags;
        this.attrTemplateName = rosServiceInstance.attrTemplateName;
        this.attrUpdateTime = rosServiceInstance.attrUpdateTime;
        this.attrUserId = rosServiceInstance.attrUserId;
    }
}
exports.ServiceInstance = ServiceInstance;
//# sourceMappingURL=data:application/json;base64,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