# studio_wrapper.py

from enum import Enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = 'e2114ed3c1a0e386e8a51ec7452ad557'
g_compiler_version = '1.0'

class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_focus_z_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_beam_shifter_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_lateral(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_lateral'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        No_Error = 'No Error'
        Calibration_Error = 'Calibration Error'
        Sensor_Signal_Failed = 'Sensor Signal Failed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_offset_calibration_status'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status.EnumType(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_normal(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_normal'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyScan_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.scan_mode'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.scan_mode.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.scan_mode.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value', float(new_val))


class RootCoreLaser_align_drive_implPropertySensor_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        Undefined = 'Undefined'
        Low = 'Low'
        Ok = 'Ok'
        High = 'High'
        Fail = 'Fail'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.sensor_status'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreLaser_align_drive_implPropertySensor_status.EnumType(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_spot_intensity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.value', float(new_val))


class RootCoreLaser_align_drive_implProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property'
        self.laser_spot_intensity = RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(self._context)
        self.motor_laser_clean_drive_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(self._context)
        self.sensor_status = RootCoreLaser_align_drive_implPropertySensor_status(self._context)
        self.laser_clean_drive_amplitude = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(self._context)
        self.laser_readout_enabled = RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(self._context)
        self.scan_mode = RootCoreLaser_align_drive_implPropertyScan_mode(self._context)
        self.motor_speed_max_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(self._context)
        self.deflection_normal = RootCoreLaser_align_drive_implPropertyDeflection_normal(self._context)
        self.motor_laser_photodetector_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(self._context)
        self.laser_clean_drive_enabled = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(self._context)
        self.motor_laser_clean_drive_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(self._context)
        self.deflection_offset_calibration_status = RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(self._context)
        self.motor_speed_max_beam_shifter = RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(self._context)
        self.deflection_lateral = RootCoreLaser_align_drive_implPropertyDeflection_lateral(self._context)
        self.laser_readout_power = RootCoreLaser_align_drive_implPropertyLaser_readout_power(self._context)
        self.motor_speed_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(self._context)
        self.motor_beam_shifter_position = RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(self._context)
        self.laser_clean_drive_power = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(self._context)
        self.motor_laser_readout_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(self._context)
        self.motor_laser_photodetector_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(self._context)
        self.motor_laser_focus_z_position = RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(self._context)
        self.motor_speed_max_laser_focus = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(self._context)
        self.motor_laser_readout_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(self._context)


class RootCoreLaser_align_drive_implSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_finished'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.call', *args)


class RootCoreLaser_align_drive_implSignalCenter_detector_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.center_detector_finished'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.call', *args)


class RootCoreLaser_align_drive_implSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.procedure_info'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.call', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_started'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.call', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_finished'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.call', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_search_step_finished'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.call', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_pte_aligned'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.call', *args)


class RootCoreLaser_align_drive_implSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal'
        self.auto_align_pte_aligned = RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(self._context)
        self.auto_align_search_step_finished = RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(self._context)
        self.auto_align_finished = RootCoreLaser_align_drive_implSignalAuto_align_finished(self._context)
        self.motor_move_started = RootCoreLaser_align_drive_implSignalMotor_move_started(self._context)
        self.procedure_info = RootCoreLaser_align_drive_implSignalProcedure_info(self._context)
        self.center_detector_finished = RootCoreLaser_align_drive_implSignalCenter_detector_finished(self._context)
        self.motor_move_finished = RootCoreLaser_align_drive_implSignalMotor_move_finished(self._context)


class RootCoreLaser_align_drive_impl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl'
        self.signal = RootCoreLaser_align_drive_implSignal(self._context)
        self.property = RootCoreLaser_align_drive_implProperty(self._context)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.zero_position', *args)

    def reference_motor(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.reference_motor', *args)

    def stop_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_updating_detector_status', *args)

    def start_search_algorithm(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_search_algorithm', *args)

    def start_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_updating_detector_status', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_motors', *args)

    def abort_auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_auto_align', *args)

    def abort_center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_center_detector', *args)

    def start_optimizing(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_optimizing', *args)

    def start_move_to_optical_center(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_move_to_optical_center', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_moving_motors', *args)

    def auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.auto_align', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.move_motors_by_step', *args)

    def center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.center_detector', *args)


class RootCoreComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.comp_dc'


class RootCoreAcquisition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.acquisition'

    def delete_data_segment(self, *args) -> Any:
        return self._context.call('root.core.acquisition.delete_data_segment', *args)

    def get_segment_state(self, *args) -> Any:
        return self._context.call('root.core.acquisition.get_segment_state', *args)

    def create_data_segment(self, *args) -> Any:
        return self._context.call('root.core.acquisition.create_data_segment', *args)

    def synchronize_segment(self, *args) -> Any:
        return self._context.call('root.core.acquisition.synchronize_segment', *args)

    def trim_sampler_segment(self, *args) -> Any:
        return self._context.call('root.core.acquisition.trim_sampler_segment', *args)

    def write_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.write_data', *args)

    def get_segment_channel_count(self, *args) -> Any:
        return self._context.call('root.core.acquisition.get_segment_channel_count', *args)

    def get_segment_channel_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.get_segment_channel_data', *args)


class RootCoreImaging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.imaging'


class RootCoreDirect_motor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.direct_motor_control'


class RootCoreOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.oscilloscope'


class RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.value', float(new_val))


class RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value', float(new_val))


class RootCoreCore_cantileverProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property'
        self.selected_cantilever_deflection_sensitivity = RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(self._context)
        self.selected_cantilever_spring_constant = RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(self._context)


class RootCoreCore_cantilever(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever'
        self.property = RootCoreCore_cantileverProperty(self._context)

    def select_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.select_cantilever', *args)

    def apply(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.apply', *args)

    def selected_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.selected_cantilever', *args)


class RootCorePosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.position_control'


class RootCoreSignal_store(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_store'

    def get_signal_calibration_min_max(self, *args) -> Any:
        return self._context.call('root.core.signal_store.get_signal_calibration_min_max', *args)


class RootCoreSignal_analyzer1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_analyzer1'


class RootCoreSpectroscopySignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.signal'


class RootCoreSpectroscopyPropertyBackward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyForward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.value', float(new_val))


class RootCoreSpectroscopyPropertyRepetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.repetition_count'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.repetition_count.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.repetition_count.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.repetition_count.value', int(new_val))


class RootCoreSpectroscopyPropertySample_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.sample_mask'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.sample_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.sample_mask.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.sample_mask.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.sample_mask.value', int(new_val))


class RootCoreSpectroscopyPropertyStart_offste_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offste_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.auto_recalibrate_probe_interval'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Is_Less_Than = 'Is Less Than'
        Is_Greater_Than = 'Is Greater Than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyBackward_modulation_stop_mode.EnumType(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Fixed_Length = 'Fixed Length'
        Stop_by_Value = 'Stop by Value'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyBackward_modulation_mode.EnumType(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyModulation_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        Position_Z = 'Position Z'
        Tip_Voltage = 'Tip Voltage'
        External_Z = 'External Z'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_output'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyModulation_output.EnumType(self._context.get('root.core.spectroscopy.property.modulation_output.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.modulation_output.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.modulation_output.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.modulation_output.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Fixed_Length = 'Fixed Length'
        Stop_by_Value = 'Stop by Value'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyForward_modulation_mode.EnumType(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyStart_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offset.value', float(new_val))


class RootCoreSpectroscopyPropertyFeedback_active(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.feedback_active'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.feedback_active.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.feedback_active.value', bool(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Z_Off = 'Z Off'
        Z_On = 'Z On'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyBackward_pause_mode.EnumType(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyModulation_relative_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_relative_value'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.modulation_relative_value.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.modulation_relative_value.value', bool(new_val))


class RootCoreSpectroscopyPropertyForward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyForward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.value', float(new_val))


class RootCoreSpectroscopyPropertySpec_end_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Keep_Last_Z_Position = 'Keep Last Z Position'
        Z_Controller_Active = 'Z-Controller Active'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.spec_end_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertySpec_end_mode.EnumType(self._context.get('root.core.spectroscopy.property.spec_end_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.spec_end_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_pause_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Z_Off = 'Z Off'
        Z_On = 'Z On'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyForward_pause_mode.EnumType(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Is_Less_Than = 'Is Less Than'
        Is_Greater_Than = 'Is Greater Than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyForward_modulation_stop_mode.EnumType(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property'
        self.backward_pause_sampling_rate = RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(self._context)
        self.forward_modulation_stop_mode = RootCoreSpectroscopyPropertyForward_modulation_stop_mode(self._context)
        self.backward_modulation_range = RootCoreSpectroscopyPropertyBackward_modulation_range(self._context)
        self.forward_pause_mode = RootCoreSpectroscopyPropertyForward_pause_mode(self._context)
        self.spec_end_mode = RootCoreSpectroscopyPropertySpec_end_mode(self._context)
        self.backward_modulation_stop_value = RootCoreSpectroscopyPropertyBackward_modulation_stop_value(self._context)
        self.backward_pause_time = RootCoreSpectroscopyPropertyBackward_pause_time(self._context)
        self.forward_modulation_range = RootCoreSpectroscopyPropertyForward_modulation_range(self._context)
        self.backward_datapoints = RootCoreSpectroscopyPropertyBackward_datapoints(self._context)
        self.forward_datapoints = RootCoreSpectroscopyPropertyForward_datapoints(self._context)
        self.forward_pause_datapoints = RootCoreSpectroscopyPropertyForward_pause_datapoints(self._context)
        self.forward_modulation_time = RootCoreSpectroscopyPropertyForward_modulation_time(self._context)
        self.forward_sampling_rate = RootCoreSpectroscopyPropertyForward_sampling_rate(self._context)
        self.modulation_relative_value = RootCoreSpectroscopyPropertyModulation_relative_value(self._context)
        self.backward_pause_mode = RootCoreSpectroscopyPropertyBackward_pause_mode(self._context)
        self.forward_modulation_stop_value = RootCoreSpectroscopyPropertyForward_modulation_stop_value(self._context)
        self.feedback_active = RootCoreSpectroscopyPropertyFeedback_active(self._context)
        self.start_offset = RootCoreSpectroscopyPropertyStart_offset(self._context)
        self.forward_modulation_mode = RootCoreSpectroscopyPropertyForward_modulation_mode(self._context)
        self.backward_move_speed = RootCoreSpectroscopyPropertyBackward_move_speed(self._context)
        self.modulation_output = RootCoreSpectroscopyPropertyModulation_output(self._context)
        self.backward_modulation_mode = RootCoreSpectroscopyPropertyBackward_modulation_mode(self._context)
        self.backward_modulation_time = RootCoreSpectroscopyPropertyBackward_modulation_time(self._context)
        self.backward_modulation_stop_mode = RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(self._context)
        self.backward_sampling_rate = RootCoreSpectroscopyPropertyBackward_sampling_rate(self._context)
        self.auto_recalibrate_probe_interval = RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(self._context)
        self.xy_move_speed = RootCoreSpectroscopyPropertyXy_move_speed(self._context)
        self.start_offste_move_speed = RootCoreSpectroscopyPropertyStart_offste_move_speed(self._context)
        self.sample_mask = RootCoreSpectroscopyPropertySample_mask(self._context)
        self.repetition_count = RootCoreSpectroscopyPropertyRepetition_count(self._context)
        self.forward_pause_time = RootCoreSpectroscopyPropertyForward_pause_time(self._context)
        self.forward_pause_sampling_rate = RootCoreSpectroscopyPropertyForward_pause_sampling_rate(self._context)
        self.forward_move_speed = RootCoreSpectroscopyPropertyForward_move_speed(self._context)
        self.backward_pause_datapoints = RootCoreSpectroscopyPropertyBackward_pause_datapoints(self._context)


class RootCoreSpectroscopy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy'
        self.property = RootCoreSpectroscopyProperty(self._context)
        self.signal = RootCoreSpectroscopySignal(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.start', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.abort', *args)


class RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_approach_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.value', float(new_val))


class RootCoreApproach_motors_drivePropertyRelative_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.relative_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_front_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_front_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_front_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_front_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_right_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_right_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_right_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_right_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_left_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_left_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_left_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_left_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_advance_retract'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.value', float(new_val))


class RootCoreApproach_motors_driveProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property'
        self.motor_speed_advance_retract = RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(self._context)
        self.motor_left_position = RootCoreApproach_motors_drivePropertyMotor_left_position(self._context)
        self.motor_right_position = RootCoreApproach_motors_drivePropertyMotor_right_position(self._context)
        self.motor_front_position = RootCoreApproach_motors_drivePropertyMotor_front_position(self._context)
        self.motor_speed = RootCoreApproach_motors_drivePropertyMotor_speed(self._context)
        self.relative_tip_position = RootCoreApproach_motors_drivePropertyRelative_tip_position(self._context)
        self.motor_speed_approach_motors = RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(self._context)


class RootCoreApproach_motors_driveSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_finished'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.call', *args)


class RootCoreApproach_motors_driveSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_started'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.call', *args)


class RootCoreApproach_motors_driveSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal'
        self.motor_move_started = RootCoreApproach_motors_driveSignalMotor_move_started(self._context)
        self.motor_move_finished = RootCoreApproach_motors_driveSignalMotor_move_finished(self._context)


class RootCoreApproach_motors_drive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive'
        self.signal = RootCoreApproach_motors_driveSignal(self._context)
        self.property = RootCoreApproach_motors_driveProperty(self._context)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.stop_motors', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.start_moving_motors', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.move_motors_by_step', *args)

    def reference_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.reference_motors', *args)


class RootCoreConverter_channel_correction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.converter_channel_correction'


class RootCoreApproachSignalApproach_or_withdraw_done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal.approach_or_withdraw_done'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.call', *args)


class RootCoreApproachSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal'
        self.approach_or_withdraw_done = RootCoreApproachSignalApproach_or_withdraw_done(self._context)


class RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_coarse_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.value', int(new_val))


class RootCoreApproachPropertyApproach_result(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_result'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_result.value'))

    @value.setter
    def value(self, new_val:str):
        self._context.set('root.core.approach.property.approach_result.value', str(new_val))


class RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_fine_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.value', int(new_val))


class RootCoreApproachPropertyStep_by_step_slope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_slope.value', float(new_val))


class RootCoreApproachPropertyStep_by_step_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_time.value', float(new_val))


class RootCoreApproachPropertyMotor_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        Internal = 'Internal'
        External = 'External'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.motor_source'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreApproachPropertyMotor_source.EnumType(self._context.get('root.core.approach.property.motor_source.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.approach.property.motor_source.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.motor_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.motor_source.enum', list(new_val))


class RootCoreApproachPropertyApproach_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_speed.value', float(new_val))


class RootCoreApproachPropertyApproach_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Continuous = 'Continuous'
        Step_by_Step = 'Step by Step'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreApproachPropertyApproach_mode.EnumType(self._context.get('root.core.approach.property.approach_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.approach.property.approach_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.approach_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.approach_mode.enum', list(new_val))


class RootCoreApproachPropertyApproach_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.approach_steps.value', int(new_val))


class RootCoreApproachPropertyDeflection_offset_voltage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.deflection_offset_voltage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.deflection_offset_voltage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.deflection_offset_voltage.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.deflection_offset_voltage.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.deflection_offset_voltage.value', float(new_val))


class RootCoreApproachPropertyStep_by_step_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Position_Controlled = 'Position Controlled'
        Not_Controlled = 'Not Controlled'
        Tip_Position_Ignored = 'Tip Position Ignored'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreApproachPropertyStep_by_step_mode.EnumType(self._context.get('root.core.approach.property.step_by_step_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.approach.property.step_by_step_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.step_by_step_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.step_by_step_mode.enum', list(new_val))


class RootCoreApproachPropertyApproach_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_pos.value', float(new_val))


class RootCoreApproachPropertyWithdraw_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.withdraw_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.withdraw_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.withdraw_steps.value', int(new_val))


class RootCoreApproachPropertyStep_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_period.value', float(new_val))


class RootCoreApproachProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property'
        self.step_period = RootCoreApproachPropertyStep_period(self._context)
        self.withdraw_steps = RootCoreApproachPropertyWithdraw_steps(self._context)
        self.approach_pos = RootCoreApproachPropertyApproach_pos(self._context)
        self.step_by_step_mode = RootCoreApproachPropertyStep_by_step_mode(self._context)
        self.deflection_offset_voltage = RootCoreApproachPropertyDeflection_offset_voltage(self._context)
        self.approach_steps = RootCoreApproachPropertyApproach_steps(self._context)
        self.approach_mode = RootCoreApproachPropertyApproach_mode(self._context)
        self.approach_speed = RootCoreApproachPropertyApproach_speed(self._context)
        self.motor_source = RootCoreApproachPropertyMotor_source(self._context)
        self.step_by_step_time = RootCoreApproachPropertyStep_by_step_time(self._context)
        self.step_by_step_slope = RootCoreApproachPropertyStep_by_step_slope(self._context)
        self.step_by_step_fine_step_size_percentage = RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(self._context)
        self.approach_result = RootCoreApproachPropertyApproach_result(self._context)
        self.step_by_step_coarse_step_size_percentage = RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(self._context)


class RootCoreApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach'
        self.property = RootCoreApproachProperty(self._context)
        self.signal = RootCoreApproachSignal(self._context)

    def approach(self, *args) -> Any:
        return self._context.call('root.core.approach.approach', *args)

    def withdraw(self, *args) -> Any:
        return self._context.call('root.core.approach.withdraw', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.approach.abort', *args)


class RootCoreThermal_tuneSignalNew_average(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_average'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.call', *args)


class RootCoreThermal_tuneSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.procedure_info'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.call', *args)


class RootCoreThermal_tuneSignalProgress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.progress'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.call', *args)


class RootCoreThermal_tuneSignalEnded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.ended'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.call', *args)


class RootCoreThermal_tuneSignalStarted(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.started'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.call', *args)


class RootCoreThermal_tuneSignalNew_frequency_list(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_frequency_list'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.call', *args)


class RootCoreThermal_tuneSignalNew_fit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_fit'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.call', *args)


class RootCoreThermal_tuneSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal'
        self.new_fit = RootCoreThermal_tuneSignalNew_fit(self._context)
        self.new_frequency_list = RootCoreThermal_tuneSignalNew_frequency_list(self._context)
        self.started = RootCoreThermal_tuneSignalStarted(self._context)
        self.ended = RootCoreThermal_tuneSignalEnded(self._context)
        self.progress = RootCoreThermal_tuneSignalProgress(self._context)
        self.procedure_info = RootCoreThermal_tuneSignalProcedure_info(self._context)
        self.new_average = RootCoreThermal_tuneSignalNew_average(self._context)


class RootCoreThermal_tunePropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.value', float(new_val))


class RootCoreThermal_tunePropertyMax_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.max_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.max_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.max_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.max_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.max_frequency.value', float(new_val))


class RootCoreThermal_tunePropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.value', float(new_val))


class RootCoreThermal_tunePropertyIterations(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.iterations'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.iterations.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.iterations.value', int(new_val))


class RootCoreThermal_tunePropertyResolution(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.resolution'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.resolution.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.resolution.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.resolution.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.resolution.value', float(new_val))


class RootCoreThermal_tunePropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.temperature.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.temperature.value', float(new_val))


class RootCoreThermal_tunePropertyMeasurement_environment(wrap.CmdTreeProp):

    class EnumType(Enum):
        Air = 'Air'
        Liquid = 'Liquid'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreThermal_tunePropertyMeasurement_environment.EnumType(self._context.get('root.core.thermal_tune.property.measurement_environment.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.thermal_tune.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.thermal_tune.property.measurement_environment.enum', list(new_val))


class RootCoreThermal_tuneProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property'
        self.measurement_environment = RootCoreThermal_tunePropertyMeasurement_environment(self._context)
        self.temperature = RootCoreThermal_tunePropertyTemperature(self._context)
        self.resolution = RootCoreThermal_tunePropertyResolution(self._context)
        self.iterations = RootCoreThermal_tunePropertyIterations(self._context)
        self.fit_frequency_upper_bound = RootCoreThermal_tunePropertyFit_frequency_upper_bound(self._context)
        self.max_frequency = RootCoreThermal_tunePropertyMax_frequency(self._context)
        self.fit_frequency_lower_bound = RootCoreThermal_tunePropertyFit_frequency_lower_bound(self._context)


class RootCoreThermal_tune(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune'
        self.property = RootCoreThermal_tuneProperty(self._context)
        self.signal = RootCoreThermal_tuneSignal(self._context)

    def add_raw_data_to_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.add_raw_data_to_fft_average_buffer', *args)

    def generate_frequency_list(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.generate_frequency_list', *args)

    def auto_calc_properties(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.auto_calc_properties', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.abort', *args)

    def create_fit_from_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.create_fit_from_fft_average_buffer', *args)

    def set_fit_window_range(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.set_fit_window_range', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.start', *args)

    def calculate_cantilever_calibration(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.calculate_cantilever_calibration', *args)


class RootCoreOrtPropertyAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.average_periods'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.average_periods.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.average_periods.value', int(new_val))


class RootCoreOrtPropertyFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.feedback_amplitude_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.feedback_amplitude_position.value', float(new_val))


class RootCoreOrtPropertyBaseline_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_value.value', float(new_val))


class RootCoreOrtPropertyBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_end.value', float(new_val))


class RootCoreOrtPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.amplitude_reduction.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.amplitude_reduction.value', float(new_val))


class RootCoreOrtPropertyBaseline_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_amplitude.value', float(new_val))


class RootCoreOrtPropertyCantilever_samples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.cantilever_samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.cantilever_samples_per_period.value', int(new_val))


class RootCoreOrtPropertyBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_frequency.value', float(new_val))


class RootCoreOrtPropertyFree_wave_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.free_wave_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.free_wave_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.free_wave_delay.value', float(new_val))


class RootCoreOrtPropertyAdhesion_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_position.value', float(new_val))


class RootCoreOrtPropertyBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_begin.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_begin.value', float(new_val))


class RootCoreOrtPropertyBaseline_controller_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_controller_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.baseline_controller_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.baseline_controller_enabled.value', bool(new_val))


class RootCoreOrtPropertyExcitation_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.excitation_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.excitation_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.excitation_enabled.value', bool(new_val))


class RootCoreOrtPropertyInput_select(wrap.CmdTreeProp):

    class EnumType(Enum):
        Fast_In_Deflection = 'Fast In Deflection'
        Hi_Res_In_Deflection = 'Hi Res In Deflection'
        Fast_In_User = 'Fast In User'
        Hi_Res_In_User1 = 'Hi Res In User1'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.input_select'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreOrtPropertyInput_select.EnumType(self._context.get('root.core.ort.property.input_select.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.ort.property.input_select.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.ort.property.input_select.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.ort.property.input_select.enum', list(new_val))


class RootCoreOrtPropertyAdhesion_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.adhesion_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.adhesion_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_value.value', float(new_val))


class RootCoreOrtPropertySamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.samples_per_period.value', int(new_val))


class RootCoreOrtProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property'
        self.samples_per_period = RootCoreOrtPropertySamples_per_period(self._context)
        self.adhesion_value = RootCoreOrtPropertyAdhesion_value(self._context)
        self.input_select = RootCoreOrtPropertyInput_select(self._context)
        self.excitation_enabled = RootCoreOrtPropertyExcitation_enabled(self._context)
        self.baseline_controller_enabled = RootCoreOrtPropertyBaseline_controller_enabled(self._context)
        self.baseline_window_begin = RootCoreOrtPropertyBaseline_window_begin(self._context)
        self.adhesion_position = RootCoreOrtPropertyAdhesion_position(self._context)
        self.free_wave_delay = RootCoreOrtPropertyFree_wave_delay(self._context)
        self.baseline_frequency = RootCoreOrtPropertyBaseline_frequency(self._context)
        self.cantilever_samples_per_period = RootCoreOrtPropertyCantilever_samples_per_period(self._context)
        self.baseline_amplitude = RootCoreOrtPropertyBaseline_amplitude(self._context)
        self.amplitude_reduction = RootCoreOrtPropertyAmplitude_reduction(self._context)
        self.baseline_window_end = RootCoreOrtPropertyBaseline_window_end(self._context)
        self.baseline_value = RootCoreOrtPropertyBaseline_value(self._context)
        self.feedback_amplitude_position = RootCoreOrtPropertyFeedback_amplitude_position(self._context)
        self.average_periods = RootCoreOrtPropertyAverage_periods(self._context)


class RootCoreOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort'
        self.property = RootCoreOrtProperty(self._context)

    def apply_samples_per_period(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_per_period', *args)

    def update_free_wave(self, *args) -> Any:
        return self._context.call('root.core.ort.update_free_wave', *args)

    def apply_samples_values(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_values', *args)

    def is_averaging(self, *args) -> Any:
        return self._context.call('root.core.ort.is_averaging', *args)

    def excitation_amplitude(self, *args) -> Any:
        return self._context.call('root.core.ort.excitation_amplitude', *args)

    def select_input(self, *args) -> Any:
        return self._context.call('root.core.ort.select_input', *args)


class RootCoreHv_amp_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.hv_amp_control'


class RootCoreCore_options(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_options'


class RootCoreScan_head_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.scan_head_calibration'


class RootCoreCore_monitoring(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_monitoring'


class RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_data_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_data_points'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.sweep_data_points.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.sweep_data_points.value', int(new_val))


class RootCoreFrequency_sweepPropertyNew_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_excitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.value', float(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.value', float(new_val))


class RootCoreFrequency_sweepPropertyFrequency_selection_criteria(wrap.CmdTreeProp):

    class EnumType(Enum):
        Below_Peak = 'Below Peak'
        Above_Peak = 'Above Peak'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.frequency_selection_criteria'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyFrequency_selection_criteria.EnumType(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.enum', list(new_val))


class RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_free_vibration_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertyNew_excitation_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_excitation_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.value', float(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.temperature.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.temperature.value', float(new_val))


class RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(wrap.CmdTreeProp):

    class EnumType(Enum):
        num_90_Hz = '90 Hz'
        num_180_Hz = '180 Hz'
        num_360_Hz = '360 Hz'
        num_750_Hz = '750 Hz'
        num_1500_Hz = '1500 Hz'
        num_3_kHz = '3 kHz'
        num_6_kHz = '6 kHz'
        num_12_kHz = '12 kHz'
        num_23_kHz = '23 kHz'
        num_45_kHz = '45 kHz'
        num_100_kHz = '100 kHz'
        num_230_kHz = '230 kHz'
        num_500_kHz = '500 kHz'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.analyzer_demodulator_bandwidth'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth.EnumType(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum', list(new_val))


class RootCoreFrequency_sweepPropertyMeasurement_environment(wrap.CmdTreeProp):

    class EnumType(Enum):
        Air = 'Air'
        Liquid = 'Liquid'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyMeasurement_environment.EnumType(self._context.get('root.core.frequency_sweep.property.measurement_environment.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.enum', list(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_unit(wrap.CmdTreeProp):

    class EnumType(Enum):
        Meters_m_ = 'Meters [m]'
        Volts_V_ = 'Volts [V]'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_unit'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyAmplitude_unit.EnumType(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.amplitude_unit.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.enum', list(new_val))


class RootCoreFrequency_sweepProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property'
        self.amplitude_unit = RootCoreFrequency_sweepPropertyAmplitude_unit(self._context)
        self.measurement_environment = RootCoreFrequency_sweepPropertyMeasurement_environment(self._context)
        self.analyzer_demodulator_bandwidth = RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(self._context)
        self.temperature = RootCoreFrequency_sweepPropertyTemperature(self._context)
        self.fit_frequency_upper_bound = RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(self._context)
        self.new_excitation_frequency = RootCoreFrequency_sweepPropertyNew_excitation_frequency(self._context)
        self.sweep_frequency_upper_bound = RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(self._context)
        self.sweep_frequency_lower_bound = RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(self._context)
        self.sweep_free_vibration_amplitude = RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(self._context)
        self.frequency_selection_criteria = RootCoreFrequency_sweepPropertyFrequency_selection_criteria(self._context)
        self.amplitude_reduction = RootCoreFrequency_sweepPropertyAmplitude_reduction(self._context)
        self.sweep_excitation_amplitude = RootCoreFrequency_sweepPropertySweep_excitation_amplitude(self._context)
        self.new_spring_constant = RootCoreFrequency_sweepPropertyNew_spring_constant(self._context)
        self.sweep_data_points = RootCoreFrequency_sweepPropertySweep_data_points(self._context)
        self.fit_frequency_lower_bound = RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(self._context)


class RootCoreFrequency_sweepSignalSweep_progress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_progress'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.call', *args)


class RootCoreFrequency_sweepSignalProcess_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.process_sweep_data'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.call', *args)


class RootCoreFrequency_sweepSignalSweep_ended(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_ended'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.call', *args)


class RootCoreFrequency_sweepSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.data_invalidated'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.call', *args)


class RootCoreFrequency_sweepSignalNew_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_sweep_data'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.call', *args)


class RootCoreFrequency_sweepSignalSho_fit_failed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sho_fit_failed'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.call', *args)


class RootCoreFrequency_sweepSignalNew_fit_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_fit_data'

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect', *args)

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.empty', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect_extended', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.call', *args)


class RootCoreFrequency_sweepSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal'
        self.new_fit_data = RootCoreFrequency_sweepSignalNew_fit_data(self._context)
        self.sho_fit_failed = RootCoreFrequency_sweepSignalSho_fit_failed(self._context)
        self.new_sweep_data = RootCoreFrequency_sweepSignalNew_sweep_data(self._context)
        self.data_invalidated = RootCoreFrequency_sweepSignalData_invalidated(self._context)
        self.sweep_ended = RootCoreFrequency_sweepSignalSweep_ended(self._context)
        self.process_sweep_data = RootCoreFrequency_sweepSignalProcess_sweep_data(self._context)
        self.sweep_progress = RootCoreFrequency_sweepSignalSweep_progress(self._context)


class RootCoreFrequency_sweep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep'
        self.signal = RootCoreFrequency_sweepSignal(self._context)
        self.property = RootCoreFrequency_sweepProperty(self._context)

    def calculate_spring_constant(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.calculate_spring_constant', *args)

    def set_sweep_parameters(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.set_sweep_parameters', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.abort', *args)

    def do_sho_fit(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.do_sho_fit', *args)

    def convert_and_emit_sweep_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.convert_and_emit_sweep_data', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.start', *args)

    def invalidate_sweep_and_fit_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.invalidate_sweep_and_fit_data', *args)


class RootCoreZ_controllerPropertyActual_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_tip_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_tip_position.value', float(new_val))


class RootCoreZ_controllerPropertyI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.i_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.i_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.i_gain.value', int(new_val))


class RootCoreZ_controllerPropertyAbsolute_idle_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.absolute_idle_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.absolute_idle_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.absolute_idle_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.absolute_idle_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.absolute_idle_position.value', float(new_val))


class RootCoreZ_controllerPropertyIdle_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Enable_Z_Controller = 'Enable Z Controller'
        Retract_Tip = 'Retract Tip'
        Keep_Last_Z_Position = 'Keep Last Z Position'
        Absolute_Z_Position = 'Absolute Z Position'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.idle_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyIdle_mode.EnumType(self._context.get('root.core.z_controller.property.idle_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.idle_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.idle_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.idle_mode.enum', list(new_val))


class RootCoreZ_controllerPropertyMax_z_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.max_z_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.max_z_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.max_z_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.max_z_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.max_z_value.value', float(new_val))


class RootCoreZ_controllerPropertySetpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.setpoint.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.setpoint.value', float(new_val))


class RootCoreZ_controllerPropertyP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.p_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.p_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.p_gain.value', int(new_val))


class RootCoreZ_controllerPropertyActual_feedback_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_feedback_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_feedback_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_feedback_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_feedback_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_feedback_value.value', float(new_val))


class RootCoreZ_controllerPropertyD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.d_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.d_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.d_gain.value', int(new_val))


class RootCoreZ_controllerPropertyFeedback(wrap.CmdTreeProp):

    class EnumType(Enum):
        Deflection = 'Deflection'
        WaveMode_Amplitude_Reduction = 'WaveMode Amplitude Reduction'
        Dynamic_Mode_Amplitude_Reduction = 'Dynamic Mode Amplitude Reduction'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyFeedback.EnumType(self._context.get('root.core.z_controller.property.feedback.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.feedback.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback.enum', list(new_val))


class RootCoreZ_controllerPropertyFeedback_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'
        invalid = 'invalid'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback_polarity'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyFeedback_polarity.EnumType(self._context.get('root.core.z_controller.property.feedback_polarity.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.feedback_polarity.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback_polarity.enum', list(new_val))


class RootCoreZ_controllerPropertyBase_work_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Control_Z_by_Z_Sensor = 'Control Z by Z-Sensor'
        Drive_Z = 'Drive Z'
        Control_Z_by_Measurement_Mode = 'Control Z by Measurement Mode'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.base_work_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyBase_work_mode.EnumType(self._context.get('root.core.z_controller.property.base_work_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.base_work_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.base_work_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.base_work_mode.enum', list(new_val))


class RootCoreZ_controllerProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property'
        self.base_work_mode = RootCoreZ_controllerPropertyBase_work_mode(self._context)
        self.feedback_polarity = RootCoreZ_controllerPropertyFeedback_polarity(self._context)
        self.feedback = RootCoreZ_controllerPropertyFeedback(self._context)
        self.d_gain = RootCoreZ_controllerPropertyD_gain(self._context)
        self.actual_feedback_value = RootCoreZ_controllerPropertyActual_feedback_value(self._context)
        self.p_gain = RootCoreZ_controllerPropertyP_gain(self._context)
        self.setpoint = RootCoreZ_controllerPropertySetpoint(self._context)
        self.max_z_value = RootCoreZ_controllerPropertyMax_z_value(self._context)
        self.idle_mode = RootCoreZ_controllerPropertyIdle_mode(self._context)
        self.absolute_idle_position = RootCoreZ_controllerPropertyAbsolute_idle_position(self._context)
        self.i_gain = RootCoreZ_controllerPropertyI_gain(self._context)
        self.actual_tip_position = RootCoreZ_controllerPropertyActual_tip_position(self._context)


class RootCoreZ_controllerSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.signal'


class RootCoreZ_controller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller'
        self.signal = RootCoreZ_controllerSignal(self._context)
        self.property = RootCoreZ_controllerProperty(self._context)

    def retract_tip(self, *args) -> Any:
        return self._context.call('root.core.z_controller.retract_tip', *args)

    def tip_position_lower_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.tip_position_lower_limit', *args)

    def setpoint_upper_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_upper_limit', *args)

    def setpoint_limits_from_calibration(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_limits_from_calibration', *args)


class RootCoreCore_environment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_environment'


class RootCore(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core'
        self.core_environment = RootCoreCore_environment(self._context)
        self.z_controller = RootCoreZ_controller(self._context)
        self.frequency_sweep = RootCoreFrequency_sweep(self._context)
        self.core_monitoring = RootCoreCore_monitoring(self._context)
        self.scan_head_calibration = RootCoreScan_head_calibration(self._context)
        self.core_options = RootCoreCore_options(self._context)
        self.hv_amp_control = RootCoreHv_amp_control(self._context)
        self.ort = RootCoreOrt(self._context)
        self.thermal_tune = RootCoreThermal_tune(self._context)
        self.approach = RootCoreApproach(self._context)
        self.converter_channel_correction = RootCoreConverter_channel_correction(self._context)
        self.approach_motors_drive = RootCoreApproach_motors_drive(self._context)
        self.spectroscopy = RootCoreSpectroscopy(self._context)
        self.signal_analyzer1 = RootCoreSignal_analyzer1(self._context)
        self.signal_store = RootCoreSignal_store(self._context)
        self.position_control = RootCorePosition_control(self._context)
        self.core_cantilever = RootCoreCore_cantilever(self._context)
        self.oscilloscope = RootCoreOscilloscope(self._context)
        self.direct_motor_control = RootCoreDirect_motor_control(self._context)
        self.imaging = RootCoreImaging(self._context)
        self.acquisition = RootCoreAcquisition(self._context)
        self.comp_dc = RootCoreComp_dc(self._context)
        self.laser_align_drive_impl = RootCoreLaser_align_drive_impl(self._context)


class RootLuLithoInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.busy'


class RootLuLithoInstanceAttributeOp_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        user = 'user'
        stm = 'stm'
        static_afm = 'static_afm'
        dynamic_afm = 'dynamic_afm'
        z_modulation = 'z_modulation'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.op_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuLithoInstanceAttributeOp_mode.EnumType(self._context.call('root.lu.litho.instance.attribute.op_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.litho.instance.attribute.op_mode.set_value', new_val.value)


class RootLuLithoInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.litho.instance.attribute.xy_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.litho.instance.attribute.xy_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.litho.instance.attribute.xy_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.xy_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.xy_move_speed.get_min'))



class RootLuLithoInstanceAttributeMove_z_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.move_z_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.litho.instance.attribute.move_z_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.litho.instance.attribute.move_z_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.litho.instance.attribute.move_z_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.move_z_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.move_z_pos.get_min'))



class RootLuLithoInstanceAttributeAbsolute_y_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.absolute_y_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.litho.instance.attribute.absolute_y_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.litho.instance.attribute.absolute_y_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.litho.instance.attribute.absolute_y_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.absolute_y_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.absolute_y_pos.get_min'))



class RootLuLithoInstanceAttributeZ_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.z_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.litho.instance.attribute.z_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.litho.instance.attribute.z_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.litho.instance.attribute.z_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.z_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.z_move_speed.get_min'))



class RootLuLithoInstanceAttributeMod_rel_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.mod_rel_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.litho.instance.attribute.mod_rel_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.litho.instance.attribute.mod_rel_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.litho.instance.attribute.mod_rel_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.mod_rel_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.mod_rel_value.get_min'))



class RootLuLithoInstanceAttributePause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.litho.instance.attribute.pause_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.litho.instance.attribute.pause_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.litho.instance.attribute.pause_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.pause_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.pause_time.get_min'))



class RootLuLithoInstanceAttributeAbsolute_x_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.absolute_x_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.litho.instance.attribute.absolute_x_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.litho.instance.attribute.absolute_x_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.litho.instance.attribute.absolute_x_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.absolute_x_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.litho.instance.attribute.absolute_x_pos.get_min'))



class RootLuLithoInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute'
        self.absolute_x_pos = RootLuLithoInstanceAttributeAbsolute_x_pos(self._context)
        self.pause_time = RootLuLithoInstanceAttributePause_time(self._context)
        self.mod_rel_value = RootLuLithoInstanceAttributeMod_rel_value(self._context)
        self.z_move_speed = RootLuLithoInstanceAttributeZ_move_speed(self._context)
        self.absolute_y_pos = RootLuLithoInstanceAttributeAbsolute_y_pos(self._context)
        self.move_z_pos = RootLuLithoInstanceAttributeMove_z_pos(self._context)
        self.xy_move_speed = RootLuLithoInstanceAttributeXy_move_speed(self._context)
        self.op_mode = RootLuLithoInstanceAttributeOp_mode(self._context)


class RootLuLithoInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger'

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.user_abort', *args)

    def next_cmd_item(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.next_cmd_item', *args)

    def end_sequence(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.end_sequence', *args)

    def move_to_abs_xy_pos(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.move_to_abs_xy_pos', *args)

    def first_cmd_item(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.first_cmd_item', *args)

    def start_sequence(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.start_sequence', *args)

    def move_to_z(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.move_to_z', *args)

    def make_pause(self, *args) -> Any:
        return self._context.call('root.lu.litho.instance.trigger.make_pause', *args)


class RootLuLithoInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance'
        self.trigger = RootLuLithoInstanceTrigger(self._context)
        self.attribute = RootLuLithoInstanceAttribute(self._context)
        self.busy = RootLuLithoInstanceBusy(self._context)


class RootLuLitho(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho'
        self.instance = RootLuLithoInstance(self._context)


class RootLuRescanInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.busy'


class RootLuRescanInstanceAttributeEnable(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.enable'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.rescan.instance.attribute.enable.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.rescan.instance.attribute.enable.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.rescan.instance.attribute.enable.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.enable.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.enable.get_min'))



class RootLuRescanInstanceAttributeLine_repetition_max_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max_count.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.rescan.instance.attribute.line_repetition_max_count.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max_count.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max_count.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max_count.get_min'))



class RootLuRescanInstanceAttributeLine_repetition_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.rescan.instance.attribute.line_repetition_max.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_max.get_min'))



class RootLuRescanInstanceAttributeLine_repetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.rescan.instance.attribute.line_repetition_count.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.rescan.instance.attribute.line_repetition_count.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_count.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_count.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.rescan.instance.attribute.line_repetition_count.get_min'))



class RootLuRescanInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute'
        self.line_repetition_count = RootLuRescanInstanceAttributeLine_repetition_count(self._context)
        self.line_repetition_max = RootLuRescanInstanceAttributeLine_repetition_max(self._context)
        self.line_repetition_max_count = RootLuRescanInstanceAttributeLine_repetition_max_count(self._context)
        self.enable = RootLuRescanInstanceAttributeEnable(self._context)


class RootLuRescanInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.trigger'


class RootLuRescanInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance'
        self.trigger = RootLuRescanInstanceTrigger(self._context)
        self.attribute = RootLuRescanInstanceAttribute(self._context)
        self.busy = RootLuRescanInstanceBusy(self._context)


class RootLuRescan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan'
        self.instance = RootLuRescanInstance(self._context)


class RootLuMainboard_relaysInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.busy'


class RootLuMainboard_relaysInstanceAttributeSet_state_mask(wrap.CmdTreeProp):

    class EnumType(Enum):
        none = 'none'
        hires_out_user1 = 'hires_out_user1'
        hires_out_user2 = 'hires_out_user2'
        hires_out_user3 = 'hires_out_user3'
        hires_out_user4 = 'hires_out_user4'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute.set_state_mask'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuMainboard_relaysInstanceAttributeSet_state_mask.EnumType(self._context.call('root.lu.mainboard_relays.instance.attribute.set_state_mask.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.mainboard_relays.instance.attribute.set_state_mask.set_value', new_val.value)


class RootLuMainboard_relaysInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute'
        self.set_state_mask = RootLuMainboard_relaysInstanceAttributeSet_state_mask(self._context)


class RootLuMainboard_relaysInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.trigger'


class RootLuMainboard_relaysInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance'
        self.trigger = RootLuMainboard_relaysInstanceTrigger(self._context)
        self.attribute = RootLuMainboard_relaysInstanceAttribute(self._context)
        self.busy = RootLuMainboard_relaysInstanceBusy(self._context)


class RootLuMainboard_relays(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays'
        self.instance = RootLuMainboard_relaysInstance(self._context)


class RootLuMemory_signal_genInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.busy'

    def is_busy(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.busy.is_busy', *args)


class RootLuMemory_signal_genInstanceAttributeOffset_value_binary_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_binary_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeData_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.data_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.memory_signal_gen.instance.attribute.data_group_id.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.memory_signal_gen.instance.attribute.data_group_id.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.data_group_id.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.data_group_id.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.data_group_id.get_min'))



class RootLuMemory_signal_genInstanceAttributeOutput_binary_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.output_binary_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_binary_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_binary_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_binary_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_binary_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_binary_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_binary_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_binary_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeOffset_value_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.offset_value_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.offset_value_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeOutput_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.output_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.output_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeUnder_run(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.under_run'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.memory_signal_gen.instance.attribute.under_run.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.memory_signal_gen.instance.attribute.under_run.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.under_run.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.under_run.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.under_run.get_min'))



class RootLuMemory_signal_genInstanceAttributeFirst_datapoint_value_binary_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_binary_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeCurrent_datapoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.current_datapoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.memory_signal_gen.instance.attribute.current_datapoint.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.memory_signal_gen.instance.attribute.current_datapoint.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.current_datapoint.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.current_datapoint.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.current_datapoint.get_min'))



class RootLuMemory_signal_genInstanceAttributeEnd_reached(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.end_reached'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.memory_signal_gen.instance.attribute.end_reached.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.memory_signal_gen.instance.attribute.end_reached.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.end_reached.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.end_reached.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.end_reached.get_min'))



class RootLuMemory_signal_genInstanceAttributeLast_datapoint_value_binary_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_binary_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeJoin(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.join'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuMemory_signal_genInstanceAttributeJoin.EnumType(self._context.call('root.lu.memory_signal_gen.instance.attribute.join.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.memory_signal_gen.instance.attribute.join.set_value', new_val.value)


class RootLuMemory_signal_genInstanceAttributeSweep_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.sweep_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.memory_signal_gen.instance.attribute.sweep_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.memory_signal_gen.instance.attribute.sweep_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.sweep_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.sweep_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.memory_signal_gen.instance.attribute.sweep_time.get_min'))



class RootLuMemory_signal_genInstanceAttributeLast_datapoint_value_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.last_datapoint_value_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeFirst_datapoint_value_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.attribute.first_datapoint_value_vec.get_vector', *args)


class RootLuMemory_signal_genInstanceAttributeLinear_interpolation(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute.linear_interpolation'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuMemory_signal_genInstanceAttributeLinear_interpolation.EnumType(self._context.call('root.lu.memory_signal_gen.instance.attribute.linear_interpolation.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.memory_signal_gen.instance.attribute.linear_interpolation.set_value', new_val.value)


class RootLuMemory_signal_genInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.attribute'
        self.linear_interpolation = RootLuMemory_signal_genInstanceAttributeLinear_interpolation(self._context)
        self.first_datapoint_value_vec = RootLuMemory_signal_genInstanceAttributeFirst_datapoint_value_vec(self._context)
        self.last_datapoint_value_vec = RootLuMemory_signal_genInstanceAttributeLast_datapoint_value_vec(self._context)
        self.sweep_time = RootLuMemory_signal_genInstanceAttributeSweep_time(self._context)
        self.join = RootLuMemory_signal_genInstanceAttributeJoin(self._context)
        self.last_datapoint_value_binary_vec = RootLuMemory_signal_genInstanceAttributeLast_datapoint_value_binary_vec(self._context)
        self.end_reached = RootLuMemory_signal_genInstanceAttributeEnd_reached(self._context)
        self.current_datapoint = RootLuMemory_signal_genInstanceAttributeCurrent_datapoint(self._context)
        self.first_datapoint_value_binary_vec = RootLuMemory_signal_genInstanceAttributeFirst_datapoint_value_binary_vec(self._context)
        self.under_run = RootLuMemory_signal_genInstanceAttributeUnder_run(self._context)
        self.output_vec = RootLuMemory_signal_genInstanceAttributeOutput_vec(self._context)
        self.offset_value_vec = RootLuMemory_signal_genInstanceAttributeOffset_value_vec(self._context)
        self.output_binary_vec = RootLuMemory_signal_genInstanceAttributeOutput_binary_vec(self._context)
        self.data_group_id = RootLuMemory_signal_genInstanceAttributeData_group_id(self._context)
        self.offset_value_binary_vec = RootLuMemory_signal_genInstanceAttributeOffset_value_binary_vec(self._context)


class RootLuMemory_signal_genInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.trigger.stop', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.trigger.start', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.trigger.abort', *args)

    def enable_preset_value(self, *args) -> Any:
        return self._context.call('root.lu.memory_signal_gen.instance.trigger.enable_preset_value', *args)


class RootLuMemory_signal_genInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen.instance'
        self.trigger = RootLuMemory_signal_genInstanceTrigger(self._context)
        self.attribute = RootLuMemory_signal_genInstanceAttribute(self._context)
        self.busy = RootLuMemory_signal_genInstanceBusy(self._context)


class RootLuMemory_signal_gen(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.memory_signal_gen'
        self.instance = RootLuMemory_signal_genInstance(self._context)


class RootLuPosition_controlInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy'

    def is_busy(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.busy.is_busy', *args)

    def is_range_switching(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.busy.is_range_switching', *args)

    def is_calibrating(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.busy.is_calibrating', *args)

    def is_tip_moving(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.busy.is_tip_moving', *args)


class RootLuPosition_controlInstanceAttributeCurrent_pos_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.current_pos_x.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.current_pos_x.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_x.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_x.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_x.get_min'))



class RootLuPosition_controlInstanceAttributeAxis_scale_xylv(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_xylv'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xylv.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.axis_scale_xylv.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xylv.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xylv.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xylv.get_min'))



class RootLuPosition_controlInstanceAttributePid_controller_settings_y(wrap.CmdTreeProp):

    class EnumType(Enum):
        p_gain = 'p_gain'
        i_gain = 'i_gain'
        d_gain = 'd_gain'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_y'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributePid_controller_settings_y.EnumType(self._context.call('root.lu.position_control.instance.attribute.pid_controller_settings_y.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.pid_controller_settings_y.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeAxis_scale_xy(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_xy'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xy.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.axis_scale_xy.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xy.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xy.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_xy.get_min'))



class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        moving = 'moving'
        keep_position = 'keep_position'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_mode.EnumType(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeTarget_move_pos_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_y.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.target_move_pos_y.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_y.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_y.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_y.get_min'))



class RootLuPosition_controlInstanceAttributeTarget_move_pos_z(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_z'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_z.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.target_move_pos_z.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_z.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_z.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_z.get_min'))



class RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_select(wrap.CmdTreeProp):

    class EnumType(Enum):
        off = 'off'
        full_range = 'full_range'
        reduced_range = 'reduced_range'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_scan_axis_range_select'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_select.EnumType(self._context.call('root.lu.position_control.instance.attribute.target_scan_axis_range_select.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.target_scan_axis_range_select.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeScan_correction_y_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.scan_correction_y_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.scan_correction_y_rotation.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.scan_correction_y_rotation.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.scan_correction_y_rotation.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.scan_correction_y_rotation.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.scan_correction_y_rotation.get_min'))



class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_keep_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos.get_min'))



class RootLuPosition_controlInstanceAttributeTarget_moving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.target_moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.target_moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_moving_time.get_min'))



class RootLuPosition_controlInstanceAttributeTarget_move_pos_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_x.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.target_move_pos_x.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_x.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_x.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_move_pos_x.get_min'))



class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_moving(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving.get_min'))



class RootLuPosition_controlInstanceAttributeLast_move_stop_event(wrap.CmdTreeProp):

    class EnumType(Enum):
        finish = 'finish'
        position_reached = 'position_reached'
        setpoint_reached = 'setpoint_reached'
        timer_expired = 'timer_expired'
        user_abort = 'user_abort'
        out_of_bound_lower_limit = 'out_of_bound_lower_limit'
        out_of_bound_upper_limit = 'out_of_bound_upper_limit'
        out_of_data = 'out_of_data'
        out_of_bound_max = 'out_of_bound_max'
        out_of_bound_min = 'out_of_bound_min'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_move_stop_event'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributeLast_move_stop_event.EnumType(self._context.call('root.lu.position_control.instance.attribute.last_move_stop_event.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.last_move_stop_event.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeAxis_scale_zlv(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_zlv'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.axis_scale_zlv.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.axis_scale_zlv.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_zlv.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_zlv.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_zlv.get_min'))



class RootLuPosition_controlInstanceAttributeCurrent_pos_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.current_pos_y.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.current_pos_y.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_y.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_y.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_y.get_min'))



class RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_result(wrap.CmdTreeProp):

    class EnumType(Enum):
        off = 'off'
        full_range = 'full_range'
        reduced_range = 'reduced_range'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_result.EnumType(self._context.call('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeRamp_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.ramp_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.ramp_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.ramp_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.ramp_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.ramp_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.ramp_time.get_min'))



class RootLuPosition_controlInstanceAttributePid_controller_settings_x(wrap.CmdTreeProp):

    class EnumType(Enum):
        p_gain = 'p_gain'
        i_gain = 'i_gain'
        d_gain = 'd_gain'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_x'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributePid_controller_settings_x.EnumType(self._context.call('root.lu.position_control.instance.attribute.pid_controller_settings_x.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.pid_controller_settings_x.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeTarget_moving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.target_moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.target_moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.target_moving_speed.get_min'))



class RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possible(wrap.CmdTreeProp):

    class EnumType(Enum):
        not_possible = 'not_possible'
        possible = 'possible'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.is_xy_closed_loop_possible'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possible.EnumType(self._context.call('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeCurrent_pos_z(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_z'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.current_pos_z.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.current_pos_z.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_z.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_z.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.current_pos_z.get_min'))



class RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_select(wrap.CmdTreeProp):

    class EnumType(Enum):
        off = 'off'
        full_range = 'full_range'
        reduced_range = 'reduced_range'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_scan_axis_range_select'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_select.EnumType(self._context.call('root.lu.position_control.instance.attribute.current_scan_axis_range_select.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.position_control.instance.attribute.current_scan_axis_range_select.set_value', new_val.value)


class RootLuPosition_controlInstanceAttributeEnable_xy_closed_loop(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.enable_xy_closed_loop'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.enable_xy_closed_loop.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.enable_xy_closed_loop.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.enable_xy_closed_loop.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.enable_xy_closed_loop.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.enable_xy_closed_loop.get_min'))



class RootLuPosition_controlInstanceAttributeScan_correction_x_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.scan_correction_x_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.scan_correction_x_rotation.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.scan_correction_x_rotation.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.scan_correction_x_rotation.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.scan_correction_x_rotation.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.scan_correction_x_rotation.get_min'))



class RootLuPosition_controlInstanceAttributeAxis_scale_z(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_z'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.axis_scale_z.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.axis_scale_z.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_z.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_z.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.axis_scale_z.get_min'))



class RootLuPosition_controlInstanceAttributeRamp_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.ramp_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.position_control.instance.attribute.ramp_count.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.position_control.instance.attribute.ramp_count.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.position_control.instance.attribute.ramp_count.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.ramp_count.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.position_control.instance.attribute.ramp_count.get_min'))



class RootLuPosition_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute'
        self.ramp_count = RootLuPosition_controlInstanceAttributeRamp_count(self._context)
        self.axis_scale_z = RootLuPosition_controlInstanceAttributeAxis_scale_z(self._context)
        self.scan_correction_x_rotation = RootLuPosition_controlInstanceAttributeScan_correction_x_rotation(self._context)
        self.enable_xy_closed_loop = RootLuPosition_controlInstanceAttributeEnable_xy_closed_loop(self._context)
        self.current_scan_axis_range_select = RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_select(self._context)
        self.current_pos_z = RootLuPosition_controlInstanceAttributeCurrent_pos_z(self._context)
        self.is_xy_closed_loop_possible = RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possible(self._context)
        self.target_moving_speed = RootLuPosition_controlInstanceAttributeTarget_moving_speed(self._context)
        self.pid_controller_settings_x = RootLuPosition_controlInstanceAttributePid_controller_settings_x(self._context)
        self.ramp_time = RootLuPosition_controlInstanceAttributeRamp_time(self._context)
        self.last_scan_axis_range_select_switch_result = RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_result(self._context)
        self.current_pos_y = RootLuPosition_controlInstanceAttributeCurrent_pos_y(self._context)
        self.axis_scale_zlv = RootLuPosition_controlInstanceAttributeAxis_scale_zlv(self._context)
        self.last_move_stop_event = RootLuPosition_controlInstanceAttributeLast_move_stop_event(self._context)
        self.xy_closed_loop_speed_moving = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_moving(self._context)
        self.target_move_pos_x = RootLuPosition_controlInstanceAttributeTarget_move_pos_x(self._context)
        self.target_moving_time = RootLuPosition_controlInstanceAttributeTarget_moving_time(self._context)
        self.xy_closed_loop_speed_keep_pos = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_keep_pos(self._context)
        self.scan_correction_y_rotation = RootLuPosition_controlInstanceAttributeScan_correction_y_rotation(self._context)
        self.target_scan_axis_range_select = RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_select(self._context)
        self.target_move_pos_z = RootLuPosition_controlInstanceAttributeTarget_move_pos_z(self._context)
        self.target_move_pos_y = RootLuPosition_controlInstanceAttributeTarget_move_pos_y(self._context)
        self.xy_closed_loop_speed_mode = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_mode(self._context)
        self.axis_scale_xy = RootLuPosition_controlInstanceAttributeAxis_scale_xy(self._context)
        self.pid_controller_settings_y = RootLuPosition_controlInstanceAttributePid_controller_settings_y(self._context)
        self.axis_scale_xylv = RootLuPosition_controlInstanceAttributeAxis_scale_xylv(self._context)
        self.current_pos_x = RootLuPosition_controlInstanceAttributeCurrent_pos_x(self._context)


class RootLuPosition_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger'

    def switch_to_target_scan_axis_range_select(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.switch_to_target_scan_axis_range_select', *args)

    def start_switch_to_target_scan_axis_range_select(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.start_switch_to_target_scan_axis_range_select', *args)

    def calib_xy_sensor_zero_to_center_of_ramp(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.calib_xy_sensor_zero_to_center_of_ramp', *args)

    def start_move_to_target_fix_time_xyz(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.start_move_to_target_fix_time_xyz', *args)

    def move_to_target_fix_speed_xyz(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.move_to_target_fix_speed_xyz', *args)

    def start_move_to_target_fix_time_xy(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.start_move_to_target_fix_time_xy', *args)

    def start_move_to_target_fix_speed_xyz(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.start_move_to_target_fix_speed_xyz', *args)

    def start_calib_xy_sensor_zero_to_center_of_ramp(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.start_calib_xy_sensor_zero_to_center_of_ramp', *args)

    def start_move_to_target_fix_speed_xy(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.start_move_to_target_fix_speed_xy', *args)

    def move_to_target_fix_speed_xy(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.move_to_target_fix_speed_xy', *args)

    def move_to_target_fix_time_xyz(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.move_to_target_fix_time_xyz', *args)

    def move_to_target_fix_time_xy(self, *args) -> Any:
        return self._context.call('root.lu.position_control.instance.trigger.move_to_target_fix_time_xy', *args)


class RootLuPosition_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance'
        self.trigger = RootLuPosition_controlInstanceTrigger(self._context)
        self.attribute = RootLuPosition_controlInstanceAttribute(self._context)
        self.busy = RootLuPosition_controlInstanceBusy(self._context)


class RootLuPosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control'
        self.instance = RootLuPosition_controlInstance(self._context)


class RootLuRamp_generatorPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_x.busy.is_moving', *args)


class RootLuRamp_generatorPosition_xAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPosition_xAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorPosition_xAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_x.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_x.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.lower_limit.get_min'))



class RootLuRamp_generatorPosition_xAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_x.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_speed.get_min'))



class RootLuRamp_generatorPosition_xAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_x.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_x.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.upper_limit.get_min'))



class RootLuRamp_generatorPosition_xAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPosition_xAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.position_x.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.position_x.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorPosition_xAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_x.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_time.get_min'))



class RootLuRamp_generatorPosition_xAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_x.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_x.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.current_value.get_min'))



class RootLuRamp_generatorPosition_xAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPosition_xAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.position_x.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.position_x.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorPosition_xAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_x.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute'
        self.end_value_relative = RootLuRamp_generatorPosition_xAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_xAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorPosition_xAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorPosition_xAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorPosition_xAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_xAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_xAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_xAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_xAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.start', *args)


class RootLuRamp_generatorPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x'
        self.trigger = RootLuRamp_generatorPosition_xTrigger(self._context)
        self.attribute = RootLuRamp_generatorPosition_xAttribute(self._context)
        self.busy = RootLuRamp_generatorPosition_xBusy(self._context)


class RootLuRamp_generatorUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user1.busy.is_moving', *args)


class RootLuRamp_generatorUser1AttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser1AttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user1.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorUser1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user1.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user1.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.lower_limit.get_min'))



class RootLuRamp_generatorUser1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user1.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user1.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.moving_speed.get_min'))



class RootLuRamp_generatorUser1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user1.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user1.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.upper_limit.get_min'))



class RootLuRamp_generatorUser1AttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser1AttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.user1.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user1.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorUser1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user1.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user1.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.moving_time.get_min'))



class RootLuRamp_generatorUser1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user1.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user1.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.current_value.get_min'))



class RootLuRamp_generatorUser1AttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser1AttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.user1.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user1.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorUser1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user1.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorUser1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user1.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user1.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute'
        self.end_value_relative = RootLuRamp_generatorUser1AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser1AttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorUser1AttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorUser1AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorUser1AttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorUser1AttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorUser1AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorUser1AttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorUser1AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorUser1AttributeEnd_value_mode(self._context)


class RootLuRamp_generatorUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user1.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user1.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user1.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user1.trigger.start', *args)


class RootLuRamp_generatorUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1'
        self.trigger = RootLuRamp_generatorUser1Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser1Attribute(self._context)
        self.busy = RootLuRamp_generatorUser1Busy(self._context)


class RootLuRamp_generatorCtrl_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.ctrl_z.busy.is_moving', *args)


class RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorCtrl_zAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorCtrl_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.get_min'))



class RootLuRamp_generatorCtrl_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.get_min'))



class RootLuRamp_generatorCtrl_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.get_min'))



class RootLuRamp_generatorCtrl_zAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorCtrl_zAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorCtrl_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_time.get_min'))



class RootLuRamp_generatorCtrl_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.current_value.get_min'))



class RootLuRamp_generatorCtrl_zAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorCtrl_zAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorCtrl_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute'
        self.end_value_relative = RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorCtrl_zAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorCtrl_zAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorCtrl_zAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorCtrl_zAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorCtrl_zAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorCtrl_zAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorCtrl_zAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorCtrl_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.start', *args)


class RootLuRamp_generatorCtrl_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z'
        self.trigger = RootLuRamp_generatorCtrl_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorCtrl_zAttribute(self._context)
        self.busy = RootLuRamp_generatorCtrl_zBusy(self._context)


class RootLuRamp_generatorUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user4.busy.is_moving', *args)


class RootLuRamp_generatorUser4AttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser4AttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user4.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorUser4AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user4.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user4.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.lower_limit.get_min'))



class RootLuRamp_generatorUser4AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user4.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user4.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.moving_speed.get_min'))



class RootLuRamp_generatorUser4AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user4.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user4.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.upper_limit.get_min'))



class RootLuRamp_generatorUser4AttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser4AttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.user4.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user4.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorUser4AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user4.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user4.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.moving_time.get_min'))



class RootLuRamp_generatorUser4AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user4.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user4.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.current_value.get_min'))



class RootLuRamp_generatorUser4AttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser4AttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.user4.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user4.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorUser4AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user4.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorUser4AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user4.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user4.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute'
        self.end_value_relative = RootLuRamp_generatorUser4AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser4AttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorUser4AttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorUser4AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorUser4AttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorUser4AttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorUser4AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorUser4AttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorUser4AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorUser4AttributeEnd_value_mode(self._context)


class RootLuRamp_generatorUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user4.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user4.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user4.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user4.trigger.start', *args)


class RootLuRamp_generatorUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4'
        self.trigger = RootLuRamp_generatorUser4Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser4Attribute(self._context)
        self.busy = RootLuRamp_generatorUser4Busy(self._context)


class RootLuRamp_generatorAlternate_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.alternate_z.busy.is_moving', *args)


class RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorAlternate_zAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorAlternate_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.alternate_z.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.lower_limit.get_min'))



class RootLuRamp_generatorAlternate_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_speed.get_min'))



class RootLuRamp_generatorAlternate_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.alternate_z.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.upper_limit.get_min'))



class RootLuRamp_generatorAlternate_zAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorAlternate_zAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.alternate_z.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorAlternate_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_time.get_min'))



class RootLuRamp_generatorAlternate_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.alternate_z.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.current_value.get_min'))



class RootLuRamp_generatorAlternate_zAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorAlternate_zAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorAlternate_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute'
        self.end_value_relative = RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorAlternate_zAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorAlternate_zAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorAlternate_zAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorAlternate_zAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorAlternate_zAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorAlternate_zAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorAlternate_zAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorAlternate_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.start', *args)


class RootLuRamp_generatorAlternate_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z'
        self.trigger = RootLuRamp_generatorAlternate_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorAlternate_zAttribute(self._context)
        self.busy = RootLuRamp_generatorAlternate_zBusy(self._context)


class RootLuRamp_generatorVirtual0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual0.busy.is_moving', *args)


class RootLuRamp_generatorVirtual0AttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual0AttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorVirtual0AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual0.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.lower_limit.get_min'))



class RootLuRamp_generatorVirtual0AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_speed.get_min'))



class RootLuRamp_generatorVirtual0AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual0.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.upper_limit.get_min'))



class RootLuRamp_generatorVirtual0AttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual0AttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.virtual0.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorVirtual0AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_time.get_min'))



class RootLuRamp_generatorVirtual0AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual0.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.current_value.get_min'))



class RootLuRamp_generatorVirtual0AttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual0AttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorVirtual0AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual0.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorVirtual0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute'
        self.end_value_relative = RootLuRamp_generatorVirtual0AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual0AttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual0AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorVirtual0AttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorVirtual0AttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual0AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual0AttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual0AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual0AttributeEnd_value_mode(self._context)


class RootLuRamp_generatorVirtual0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.start', *args)


class RootLuRamp_generatorVirtual0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0'
        self.trigger = RootLuRamp_generatorVirtual0Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual0Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual0Busy(self._context)


class RootLuRamp_generatorPlane_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.plane_z.busy.is_moving', *args)


class RootLuRamp_generatorPlane_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPlane_zAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorPlane_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.plane_z.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.lower_limit.get_min'))



class RootLuRamp_generatorPlane_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_speed.get_min'))



class RootLuRamp_generatorPlane_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.plane_z.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.upper_limit.get_min'))



class RootLuRamp_generatorPlane_zAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPlane_zAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.plane_z.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorPlane_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_time.get_min'))



class RootLuRamp_generatorPlane_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.plane_z.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.current_value.get_min'))



class RootLuRamp_generatorPlane_zAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPlane_zAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorPlane_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.plane_z.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorPlane_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute'
        self.end_value_relative = RootLuRamp_generatorPlane_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorPlane_zAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorPlane_zAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorPlane_zAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorPlane_zAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorPlane_zAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorPlane_zAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorPlane_zAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorPlane_zAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorPlane_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.start', *args)


class RootLuRamp_generatorPlane_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z'
        self.trigger = RootLuRamp_generatorPlane_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorPlane_zAttribute(self._context)
        self.busy = RootLuRamp_generatorPlane_zBusy(self._context)


class RootLuRamp_generatorVirtual1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual1.busy.is_moving', *args)


class RootLuRamp_generatorVirtual1AttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual1AttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorVirtual1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual1.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.lower_limit.get_min'))



class RootLuRamp_generatorVirtual1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_speed.get_min'))



class RootLuRamp_generatorVirtual1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual1.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.upper_limit.get_min'))



class RootLuRamp_generatorVirtual1AttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual1AttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.virtual1.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorVirtual1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_time.get_min'))



class RootLuRamp_generatorVirtual1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual1.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.current_value.get_min'))



class RootLuRamp_generatorVirtual1AttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual1AttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorVirtual1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual1.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorVirtual1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute'
        self.end_value_relative = RootLuRamp_generatorVirtual1AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual1AttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual1AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorVirtual1AttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorVirtual1AttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual1AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual1AttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual1AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual1AttributeEnd_value_mode(self._context)


class RootLuRamp_generatorVirtual1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.start', *args)


class RootLuRamp_generatorVirtual1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1'
        self.trigger = RootLuRamp_generatorVirtual1Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual1Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual1Busy(self._context)


class RootLuRamp_generatorVirtual2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual2.busy.is_moving', *args)


class RootLuRamp_generatorVirtual2AttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual2AttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorVirtual2AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual2.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.lower_limit.get_min'))



class RootLuRamp_generatorVirtual2AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_speed.get_min'))



class RootLuRamp_generatorVirtual2AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual2.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.upper_limit.get_min'))



class RootLuRamp_generatorVirtual2AttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual2AttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.virtual2.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorVirtual2AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_time.get_min'))



class RootLuRamp_generatorVirtual2AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual2.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.current_value.get_min'))



class RootLuRamp_generatorVirtual2AttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorVirtual2AttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorVirtual2AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.virtual2.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorVirtual2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute'
        self.end_value_relative = RootLuRamp_generatorVirtual2AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual2AttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual2AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorVirtual2AttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorVirtual2AttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual2AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual2AttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual2AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual2AttributeEnd_value_mode(self._context)


class RootLuRamp_generatorVirtual2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.start', *args)


class RootLuRamp_generatorVirtual2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2'
        self.trigger = RootLuRamp_generatorVirtual2Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual2Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual2Busy(self._context)


class RootLuRamp_generatorTestBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.test.busy.is_moving', *args)


class RootLuRamp_generatorTestAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorTestAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.test.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.test.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorTestAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.test.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.test.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.lower_limit.get_min'))



class RootLuRamp_generatorTestAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.test.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.test.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.moving_speed.get_min'))



class RootLuRamp_generatorTestAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.test.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.test.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.upper_limit.get_min'))



class RootLuRamp_generatorTestAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorTestAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.test.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.test.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorTestAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.test.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.test.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.moving_time.get_min'))



class RootLuRamp_generatorTestAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.test.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.test.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.current_value.get_min'))



class RootLuRamp_generatorTestAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorTestAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.test.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.test.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorTestAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.test.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.test.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorTestAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.test.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.test.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.test.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorTestAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute'
        self.end_value_relative = RootLuRamp_generatorTestAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorTestAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorTestAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorTestAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorTestAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorTestAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorTestAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorTestAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorTestAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorTestAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorTestTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.test.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.test.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.test.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.test.trigger.start', *args)


class RootLuRamp_generatorTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test'
        self.trigger = RootLuRamp_generatorTestTrigger(self._context)
        self.attribute = RootLuRamp_generatorTestAttribute(self._context)
        self.busy = RootLuRamp_generatorTestBusy(self._context)


class RootLuRamp_generatorTip_voltageBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.tip_voltage.busy.is_moving', *args)


class RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorTip_voltageAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorTip_voltageAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.get_min'))



class RootLuRamp_generatorTip_voltageAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.get_min'))



class RootLuRamp_generatorTip_voltageAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.get_min'))



class RootLuRamp_generatorTip_voltageAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorTip_voltageAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorTip_voltageAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_time.get_min'))



class RootLuRamp_generatorTip_voltageAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.current_value.get_min'))



class RootLuRamp_generatorTip_voltageAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorTip_voltageAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorTip_voltageAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute'
        self.end_value_relative = RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorTip_voltageAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorTip_voltageAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorTip_voltageAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorTip_voltageAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorTip_voltageAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorTip_voltageAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorTip_voltageAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorTip_voltageTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.start', *args)


class RootLuRamp_generatorTip_voltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage'
        self.trigger = RootLuRamp_generatorTip_voltageTrigger(self._context)
        self.attribute = RootLuRamp_generatorTip_voltageAttribute(self._context)
        self.busy = RootLuRamp_generatorTip_voltageBusy(self._context)


class RootLuRamp_generatorPosition_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_y.busy.is_moving', *args)


class RootLuRamp_generatorPosition_yAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPosition_yAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorPosition_yAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_y.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_y.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.lower_limit.get_min'))



class RootLuRamp_generatorPosition_yAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_y.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_speed.get_min'))



class RootLuRamp_generatorPosition_yAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_y.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_y.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.upper_limit.get_min'))



class RootLuRamp_generatorPosition_yAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPosition_yAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.position_y.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.position_y.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorPosition_yAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_y.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_time.get_min'))



class RootLuRamp_generatorPosition_yAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_y.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_y.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.current_value.get_min'))



class RootLuRamp_generatorPosition_yAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorPosition_yAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.position_y.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.position_y.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorPosition_yAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.position_y.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute'
        self.end_value_relative = RootLuRamp_generatorPosition_yAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_yAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorPosition_yAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorPosition_yAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorPosition_yAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_yAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_yAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_yAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_yAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.start', *args)


class RootLuRamp_generatorPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y'
        self.trigger = RootLuRamp_generatorPosition_yTrigger(self._context)
        self.attribute = RootLuRamp_generatorPosition_yAttribute(self._context)
        self.busy = RootLuRamp_generatorPosition_yBusy(self._context)


class RootLuRamp_generatorApproachBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.approach.busy.is_moving', *args)


class RootLuRamp_generatorApproachAttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorApproachAttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.approach.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorApproachAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.approach.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.approach.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.lower_limit.get_min'))



class RootLuRamp_generatorApproachAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.approach.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.approach.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.moving_speed.get_min'))



class RootLuRamp_generatorApproachAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.approach.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.approach.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.upper_limit.get_min'))



class RootLuRamp_generatorApproachAttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorApproachAttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.approach.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.approach.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorApproachAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.approach.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.approach.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.moving_time.get_min'))



class RootLuRamp_generatorApproachAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.approach.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.approach.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.current_value.get_min'))



class RootLuRamp_generatorApproachAttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorApproachAttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.approach.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.approach.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorApproachAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.approach.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorApproachAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.approach.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.approach.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorApproachAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute'
        self.end_value_relative = RootLuRamp_generatorApproachAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorApproachAttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorApproachAttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorApproachAttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorApproachAttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorApproachAttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorApproachAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorApproachAttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorApproachAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorApproachAttributeEnd_value_mode(self._context)


class RootLuRamp_generatorApproachTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.approach.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.approach.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.approach.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.approach.trigger.start', *args)


class RootLuRamp_generatorApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach'
        self.trigger = RootLuRamp_generatorApproachTrigger(self._context)
        self.attribute = RootLuRamp_generatorApproachAttribute(self._context)
        self.busy = RootLuRamp_generatorApproachBusy(self._context)


class RootLuRamp_generatorUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.busy'

    def is_moving(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user2.busy.is_moving', *args)


class RootLuRamp_generatorUser2AttributeEnd_value_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        move_to_absolute = 'move_to_absolute'
        move_relative = 'move_relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser2AttributeEnd_value_mode.EnumType(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user2.attribute.end_value_mode.set_value', new_val.value)


class RootLuRamp_generatorUser2AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user2.attribute.lower_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user2.attribute.lower_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.lower_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.lower_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.lower_limit.get_min'))



class RootLuRamp_generatorUser2AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user2.attribute.moving_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user2.attribute.moving_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.moving_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.moving_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.moving_speed.get_min'))



class RootLuRamp_generatorUser2AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user2.attribute.upper_limit.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user2.attribute.upper_limit.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.upper_limit.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.upper_limit.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.upper_limit.get_min'))



class RootLuRamp_generatorUser2AttributeStatus(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_moving = 'is_moving'
        reached_endposition = 'reached_endposition'
        reached_lower_limit = 'reached_lower_limit'
        reached_upper_limit = 'reached_upper_limit'
        stopped_by_external_event = 'stopped_by_external_event'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser2AttributeStatus.EnumType(self._context.call('root.lu.ramp_generator.user2.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user2.attribute.status.set_value', new_val.value)


class RootLuRamp_generatorUser2AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user2.attribute.moving_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user2.attribute.moving_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.moving_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.moving_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.moving_time.get_min'))



class RootLuRamp_generatorUser2AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user2.attribute.current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user2.attribute.current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.current_value.get_min'))



class RootLuRamp_generatorUser2AttributeMoving_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_time = 'fix_time'
        fix_speed = 'fix_speed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuRamp_generatorUser2AttributeMoving_mode.EnumType(self._context.call('root.lu.ramp_generator.user2.attribute.moving_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ramp_generator.user2.attribute.moving_mode.set_value', new_val.value)


class RootLuRamp_generatorUser2AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user2.attribute.end_value_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_absolute.get_min'))



class RootLuRamp_generatorUser2AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_relative.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ramp_generator.user2.attribute.end_value_relative.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_relative.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_relative.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ramp_generator.user2.attribute.end_value_relative.get_min'))



class RootLuRamp_generatorUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute'
        self.end_value_relative = RootLuRamp_generatorUser2AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser2AttributeEnd_value_absolute(self._context)
        self.moving_mode = RootLuRamp_generatorUser2AttributeMoving_mode(self._context)
        self.current_value = RootLuRamp_generatorUser2AttributeCurrent_value(self._context)
        self.moving_time = RootLuRamp_generatorUser2AttributeMoving_time(self._context)
        self.status = RootLuRamp_generatorUser2AttributeStatus(self._context)
        self.upper_limit = RootLuRamp_generatorUser2AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorUser2AttributeMoving_speed(self._context)
        self.lower_limit = RootLuRamp_generatorUser2AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorUser2AttributeEnd_value_mode(self._context)


class RootLuRamp_generatorUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger'

    def prepare(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user2.trigger.prepare', *args)

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user2.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user2.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.ramp_generator.user2.trigger.start', *args)


class RootLuRamp_generatorUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2'
        self.trigger = RootLuRamp_generatorUser2Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser2Attribute(self._context)
        self.busy = RootLuRamp_generatorUser2Busy(self._context)


class RootLuRamp_generator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator'
        self.user2 = RootLuRamp_generatorUser2(self._context)
        self.approach = RootLuRamp_generatorApproach(self._context)
        self.position_y = RootLuRamp_generatorPosition_y(self._context)
        self.tip_voltage = RootLuRamp_generatorTip_voltage(self._context)
        self.test = RootLuRamp_generatorTest(self._context)
        self.virtual2 = RootLuRamp_generatorVirtual2(self._context)
        self.virtual1 = RootLuRamp_generatorVirtual1(self._context)
        self.plane_z = RootLuRamp_generatorPlane_z(self._context)
        self.virtual0 = RootLuRamp_generatorVirtual0(self._context)
        self.alternate_z = RootLuRamp_generatorAlternate_z(self._context)
        self.user4 = RootLuRamp_generatorUser4(self._context)
        self.ctrl_z = RootLuRamp_generatorCtrl_z(self._context)
        self.user1 = RootLuRamp_generatorUser1(self._context)
        self.position_x = RootLuRamp_generatorPosition_x(self._context)


class RootLuMacro_cmdInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.busy'


class RootLuMacro_cmdInstanceAttributeActive_sampler_set(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.active_sampler_set'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.active_sampler_set.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.active_sampler_set.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.active_sampler_set.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.active_sampler_set.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.active_sampler_set.get_min'))



class RootLuMacro_cmdInstanceAttributeI2_c_bus(wrap.CmdTreeProp):

    class EnumType(Enum):
        digital_io = 'digital_io'
        aux = 'aux'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_bus'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuMacro_cmdInstanceAttributeI2_c_bus.EnumType(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_bus.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_bus.set_value', new_val.value)


class RootLuMacro_cmdInstanceAttributeMo_move_stop_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_less_than = 'is_less_than'
        is_greater_than = 'is_greater_than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_stop_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuMacro_cmdInstanceAttributeMo_move_stop_mode.EnumType(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.set_value', new_val.value)


class RootLuMacro_cmdInstanceAttributeAbsolute_y_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.absolute_y_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_y_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.absolute_y_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_y_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_y_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_y_pos.get_min'))



class RootLuMacro_cmdInstanceAttributeI2_c_register(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_register'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_register.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_register.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_register.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_register.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_register.get_min'))



class RootLuMacro_cmdInstanceAttributeMo_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_speed.get_min'))



class RootLuMacro_cmdInstanceAttributeRelative_pos_mo(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.relative_pos_mo'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.relative_pos_mo.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.relative_pos_mo.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.relative_pos_mo.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.relative_pos_mo.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.relative_pos_mo.get_min'))



class RootLuMacro_cmdInstanceAttributeSystem_abort_event_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.system_abort_event_mask'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.get_min'))



class RootLuMacro_cmdInstanceAttributeTarget_output_channel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.target_output_channel'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.target_output_channel.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.target_output_channel.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.target_output_channel.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.target_output_channel.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.target_output_channel.get_min'))



class RootLuMacro_cmdInstanceAttributeMo_move_stop_feedback_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.get_min'))



class RootLuMacro_cmdInstanceAttributeTarget_z_ctrl_output_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.get_min'))



class RootLuMacro_cmdInstanceAttributeUser_event_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.user_event_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.user_event_id.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.user_event_id.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.user_event_id.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.user_event_id.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.user_event_id.get_min'))



class RootLuMacro_cmdInstanceAttributePause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.pause_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.pause_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.pause_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.pause_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.pause_time.get_min'))



class RootLuMacro_cmdInstanceAttributeAbsolute_x_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.absolute_x_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_x_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.absolute_x_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_x_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_x_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_x_pos.get_min'))



class RootLuMacro_cmdInstanceAttributeI2_c_data(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_data'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_data.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_data.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_data.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_data.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_data.get_min'))



class RootLuMacro_cmdInstanceAttributeAbsolute_pos_mo(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.absolute_pos_mo'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.get_min'))



class RootLuMacro_cmdInstanceAttributeMo_move_stop_value(wrap.CmdTreeProp):

    class EnumType(Enum):
        z_off = 'z_off'
        z_on = 'z_on'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_stop_value'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuMacro_cmdInstanceAttributeMo_move_stop_value.EnumType(self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.set_value', new_val.value)


class RootLuMacro_cmdInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.xy_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.xy_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.xy_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.xy_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.xy_move_speed.get_min'))



class RootLuMacro_cmdInstanceAttributeModulation_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        position_z = 'position_z'
        tip_voltage = 'tip_voltage'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.modulation_output'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuMacro_cmdInstanceAttributeModulation_output.EnumType(self._context.call('root.lu.macro_cmd.instance.attribute.modulation_output.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.macro_cmd.instance.attribute.modulation_output.set_value', new_val.value)


class RootLuMacro_cmdInstanceAttributeI2_c_address(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_address'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_address.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_address.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_address.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_address.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.i2_c_address.get_min'))



class RootLuMacro_cmdInstanceAttributeEnable_daq_sync_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.enable_daq_sync_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.get_min'))



class RootLuMacro_cmdInstanceAttributeEnable_daq(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.enable_daq'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.macro_cmd.instance.attribute.enable_daq.get_min'))



class RootLuMacro_cmdInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute'
        self.enable_daq = RootLuMacro_cmdInstanceAttributeEnable_daq(self._context)
        self.enable_daq_sync_end = RootLuMacro_cmdInstanceAttributeEnable_daq_sync_end(self._context)
        self.i2_c_address = RootLuMacro_cmdInstanceAttributeI2_c_address(self._context)
        self.modulation_output = RootLuMacro_cmdInstanceAttributeModulation_output(self._context)
        self.xy_move_speed = RootLuMacro_cmdInstanceAttributeXy_move_speed(self._context)
        self.mo_move_stop_value = RootLuMacro_cmdInstanceAttributeMo_move_stop_value(self._context)
        self.absolute_pos_mo = RootLuMacro_cmdInstanceAttributeAbsolute_pos_mo(self._context)
        self.i2_c_data = RootLuMacro_cmdInstanceAttributeI2_c_data(self._context)
        self.absolute_x_pos = RootLuMacro_cmdInstanceAttributeAbsolute_x_pos(self._context)
        self.pause_time = RootLuMacro_cmdInstanceAttributePause_time(self._context)
        self.user_event_id = RootLuMacro_cmdInstanceAttributeUser_event_id(self._context)
        self.target_z_ctrl_output_mode = RootLuMacro_cmdInstanceAttributeTarget_z_ctrl_output_mode(self._context)
        self.mo_move_stop_feedback_mode = RootLuMacro_cmdInstanceAttributeMo_move_stop_feedback_mode(self._context)
        self.target_output_channel = RootLuMacro_cmdInstanceAttributeTarget_output_channel(self._context)
        self.system_abort_event_mask = RootLuMacro_cmdInstanceAttributeSystem_abort_event_mask(self._context)
        self.relative_pos_mo = RootLuMacro_cmdInstanceAttributeRelative_pos_mo(self._context)
        self.mo_move_speed = RootLuMacro_cmdInstanceAttributeMo_move_speed(self._context)
        self.i2_c_register = RootLuMacro_cmdInstanceAttributeI2_c_register(self._context)
        self.absolute_y_pos = RootLuMacro_cmdInstanceAttributeAbsolute_y_pos(self._context)
        self.mo_move_stop_mode = RootLuMacro_cmdInstanceAttributeMo_move_stop_mode(self._context)
        self.i2_c_bus = RootLuMacro_cmdInstanceAttributeI2_c_bus(self._context)
        self.active_sampler_set = RootLuMacro_cmdInstanceAttributeActive_sampler_set(self._context)


class RootLuMacro_cmdInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.trigger'

    def auto_recalibrate_probe(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.auto_recalibrate_probe', *args)

    def write_i2_c_data(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.write_i2_c_data', *args)

    def move_to_stop_value_mo(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_stop_value_mo', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.user_abort', *args)

    def activate_z_feedback(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.activate_z_feedback', *args)

    def move_to_rel_mo_pos(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_rel_mo_pos', *args)

    def move_to_abs_mo_pos(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_abs_mo_pos', *args)

    def user_event(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.user_event', *args)

    def stop_z_feedback(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.stop_z_feedback', *args)

    def move_to_abs_xy_pos(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_abs_xy_pos', *args)

    def make_pause(self, *args) -> Any:
        return self._context.call('root.lu.macro_cmd.instance.trigger.make_pause', *args)


class RootLuMacro_cmdInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance'
        self.trigger = RootLuMacro_cmdInstanceTrigger(self._context)
        self.attribute = RootLuMacro_cmdInstanceAttribute(self._context)
        self.busy = RootLuMacro_cmdInstanceBusy(self._context)


class RootLuMacro_cmd(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd'
        self.instance = RootLuMacro_cmdInstance(self._context)


class RootLuSensor_controlInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.busy'


class RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance.get_min'))



class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        idle = 'idle'
        running = 'running'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status.EnumType(self._context.call('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.set_value', new_val.value)


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_i_gain.get_min'))



class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        no_error = 'no_error'
        calibration_error = 'calibration_error'
        sensor_signal_failed = 'sensor_signal_failed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status.EnumType(self._context.call('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.set_value', new_val.value)


class RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status.get_min'))



class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fix_from_attr = 'fix_from_attr'
        auto_from_head_typ = 'auto_from_head_typ'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode.EnumType(self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.set_value', new_val.value)


class RootLuSensor_controlInstanceAttributeOffset_calib_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        no_auto_calibration = 'no_auto_calibration'
        auto_calibrate_deflection = 'auto_calibrate_deflection'
        auto_calibrate_z_ctrl_input = 'auto_calibrate_z_ctrl_input'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSensor_controlInstanceAttributeOffset_calib_mode.EnumType(self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.sensor_control.instance.attribute.offset_calib_mode.set_value', new_val.value)


class RootLuSensor_controlInstanceAttributeSensor_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.sensor_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.sensor_control.instance.attribute.sensor_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.sensor_control.instance.attribute.sensor_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.sensor_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.sensor_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.sensor_control.instance.attribute.sensor_amplitude.get_min'))



class RootLuSensor_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute'
        self.sensor_amplitude = RootLuSensor_controlInstanceAttributeSensor_amplitude(self._context)
        self.offset_calib_mode = RootLuSensor_controlInstanceAttributeOffset_calib_mode(self._context)
        self.offset_calib_i_gain_mode = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(self._context)
        self.enable10_hz_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(self._context)
        self.deflection_offset_calibration_status = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(self._context)
        self.offset_calib_i_gain = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(self._context)
        self.detector_auto_adjustment_status = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(self._context)
        self.detector_adjustment_tolerance = RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(self._context)


class RootLuSensor_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger'

    def start_detector_auto_adjustment(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_detector_auto_adjustment', *args)

    def start_deflection_offset_calibration(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_deflection_offset_calibration', *args)

    def deflection_offset_calibration(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.deflection_offset_calibration', *args)

    def update_laser_spot_on_detector_status(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.update_laser_spot_on_detector_status', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.user_abort', *args)

    def start_update_laser_spot_on_detector_status(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_update_laser_spot_on_detector_status', *args)

    def start_set_dynamic_amplitude(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_set_dynamic_amplitude', *args)

    def deflection_offset_calibration_with_retract(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.deflection_offset_calibration_with_retract', *args)

    def start_sensor_calibration(self, *args) -> Any:
        return self._context.call('root.lu.sensor_control.instance.trigger.start_sensor_calibration', *args)


class RootLuSensor_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance'
        self.trigger = RootLuSensor_controlInstanceTrigger(self._context)
        self.attribute = RootLuSensor_controlInstanceAttribute(self._context)
        self.busy = RootLuSensor_controlInstanceBusy(self._context)


class RootLuSensor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control'
        self.instance = RootLuSensor_controlInstance(self._context)


class RootLuAnalog_fast_outFast3Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.busy'


class RootLuAnalog_fast_outFast3AttributeCalib_sig_source_dir(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_sig_source_dir.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_sig_source_dir.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_sig_source_dir.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_sig_source_dir.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_sig_source_dir.get_min'))



class RootLuAnalog_fast_outFast3AttributeInput(wrap.CmdTreeProp):

    class EnumType(Enum):
        static = 'static'
        in_deflection = 'in_deflection'
        fast_in2 = 'fast_in2'
        in_user = 'in_user'
        analyzer1_reference = 'analyzer1_reference'
        analyzer2_reference = 'analyzer2_reference'
        ort_excitation = 'ort_excitation'
        ort_free_wave = 'ort_free_wave'
        ctrl_z_out = 'ctrl_z_out'
        ctrl_w_out = 'ctrl_w_out'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast3AttributeInput.EnumType(self._context.call('root.lu.analog_fast_out.fast3.attribute.input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.input.set_value', new_val.value)


class RootLuAnalog_fast_outFast3AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.output_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_gain.get_min'))



class RootLuAnalog_fast_outFast3AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_gain.get_min'))



class RootLuAnalog_fast_outFast3AttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.output_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.output_offset.get_min'))



class RootLuAnalog_fast_outFast3AttributeModulation(wrap.CmdTreeProp):

    class EnumType(Enum):
        analyzer2_reference = 'analyzer2_reference'
        disabled = 'disabled'
        damping = 'damping'
        hi_res_signal = 'hi_res_signal'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.modulation'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast3AttributeModulation.EnumType(self._context.call('root.lu.analog_fast_out.fast3.attribute.modulation.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.modulation.set_value', new_val.value)


class RootLuAnalog_fast_outFast3AttributeDamping_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.damping_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.damping_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.damping_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.damping_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.damping_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.damping_gain.get_min'))



class RootLuAnalog_fast_outFast3AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_offset.get_min'))



class RootLuAnalog_fast_outFast3AttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.static_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.static_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.static_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.static_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.static_value.get_min'))



class RootLuAnalog_fast_outFast3AttributeCalib_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast3AttributeCalib_polarity.EnumType(self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.calib_polarity.set_value', new_val.value)


class RootLuAnalog_fast_outFast3AttributeAnalog_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        enabled = 'enabled'
        disabled = 'disabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.analog_output'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast3AttributeAnalog_output.EnumType(self._context.call('root.lu.analog_fast_out.fast3.attribute.analog_output.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.analog_output.set_value', new_val.value)


class RootLuAnalog_fast_outFast3AttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast3.attribute.current_output_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast3.attribute.current_output_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.current_output_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.current_output_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast3.attribute.current_output_value.get_min'))



class RootLuAnalog_fast_outFast3Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.attribute'
        self.current_output_value = RootLuAnalog_fast_outFast3AttributeCurrent_output_value(self._context)
        self.analog_output = RootLuAnalog_fast_outFast3AttributeAnalog_output(self._context)
        self.calib_polarity = RootLuAnalog_fast_outFast3AttributeCalib_polarity(self._context)
        self.static_value = RootLuAnalog_fast_outFast3AttributeStatic_value(self._context)
        self.calib_offset = RootLuAnalog_fast_outFast3AttributeCalib_offset(self._context)
        self.damping_gain = RootLuAnalog_fast_outFast3AttributeDamping_gain(self._context)
        self.modulation = RootLuAnalog_fast_outFast3AttributeModulation(self._context)
        self.output_offset = RootLuAnalog_fast_outFast3AttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_fast_outFast3AttributeCalib_gain(self._context)
        self.output_gain = RootLuAnalog_fast_outFast3AttributeOutput_gain(self._context)
        self.input = RootLuAnalog_fast_outFast3AttributeInput(self._context)
        self.calib_sig_source_dir = RootLuAnalog_fast_outFast3AttributeCalib_sig_source_dir(self._context)


class RootLuAnalog_fast_outFast3Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3.trigger'


class RootLuAnalog_fast_outFast3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast3'
        self.trigger = RootLuAnalog_fast_outFast3Trigger(self._context)
        self.attribute = RootLuAnalog_fast_outFast3Attribute(self._context)
        self.busy = RootLuAnalog_fast_outFast3Busy(self._context)


class RootLuAnalog_fast_outExcitationBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.busy'


class RootLuAnalog_fast_outExcitationAttributeCalib_sig_source_dir(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_sig_source_dir.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_sig_source_dir.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_sig_source_dir.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_sig_source_dir.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_sig_source_dir.get_min'))



class RootLuAnalog_fast_outExcitationAttributeInput(wrap.CmdTreeProp):

    class EnumType(Enum):
        static = 'static'
        in_deflection = 'in_deflection'
        fast_in2 = 'fast_in2'
        in_user = 'in_user'
        analyzer1_reference = 'analyzer1_reference'
        analyzer2_reference = 'analyzer2_reference'
        ort_excitation = 'ort_excitation'
        ort_free_wave = 'ort_free_wave'
        ctrl_z_out = 'ctrl_z_out'
        ctrl_w_out = 'ctrl_w_out'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outExcitationAttributeInput.EnumType(self._context.call('root.lu.analog_fast_out.excitation.attribute.input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.input.set_value', new_val.value)


class RootLuAnalog_fast_outExcitationAttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.output_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_gain.get_min'))



class RootLuAnalog_fast_outExcitationAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_gain.get_min'))



class RootLuAnalog_fast_outExcitationAttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.output_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.output_offset.get_min'))



class RootLuAnalog_fast_outExcitationAttributeModulation(wrap.CmdTreeProp):

    class EnumType(Enum):
        analyzer2_reference = 'analyzer2_reference'
        disabled = 'disabled'
        damping = 'damping'
        hi_res_signal = 'hi_res_signal'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.modulation'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outExcitationAttributeModulation.EnumType(self._context.call('root.lu.analog_fast_out.excitation.attribute.modulation.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.modulation.set_value', new_val.value)


class RootLuAnalog_fast_outExcitationAttributeDamping_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.damping_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.damping_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.damping_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.damping_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.damping_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.damping_gain.get_min'))



class RootLuAnalog_fast_outExcitationAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_offset.get_min'))



class RootLuAnalog_fast_outExcitationAttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.static_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.static_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.static_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.static_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.static_value.get_min'))



class RootLuAnalog_fast_outExcitationAttributeCalib_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outExcitationAttributeCalib_polarity.EnumType(self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.calib_polarity.set_value', new_val.value)


class RootLuAnalog_fast_outExcitationAttributeAnalog_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        enabled = 'enabled'
        disabled = 'disabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.analog_output'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outExcitationAttributeAnalog_output.EnumType(self._context.call('root.lu.analog_fast_out.excitation.attribute.analog_output.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.analog_output.set_value', new_val.value)


class RootLuAnalog_fast_outExcitationAttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.excitation.attribute.current_output_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.excitation.attribute.current_output_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.current_output_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.current_output_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.excitation.attribute.current_output_value.get_min'))



class RootLuAnalog_fast_outExcitationAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.attribute'
        self.current_output_value = RootLuAnalog_fast_outExcitationAttributeCurrent_output_value(self._context)
        self.analog_output = RootLuAnalog_fast_outExcitationAttributeAnalog_output(self._context)
        self.calib_polarity = RootLuAnalog_fast_outExcitationAttributeCalib_polarity(self._context)
        self.static_value = RootLuAnalog_fast_outExcitationAttributeStatic_value(self._context)
        self.calib_offset = RootLuAnalog_fast_outExcitationAttributeCalib_offset(self._context)
        self.damping_gain = RootLuAnalog_fast_outExcitationAttributeDamping_gain(self._context)
        self.modulation = RootLuAnalog_fast_outExcitationAttributeModulation(self._context)
        self.output_offset = RootLuAnalog_fast_outExcitationAttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_fast_outExcitationAttributeCalib_gain(self._context)
        self.output_gain = RootLuAnalog_fast_outExcitationAttributeOutput_gain(self._context)
        self.input = RootLuAnalog_fast_outExcitationAttributeInput(self._context)
        self.calib_sig_source_dir = RootLuAnalog_fast_outExcitationAttributeCalib_sig_source_dir(self._context)


class RootLuAnalog_fast_outExcitationTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation.trigger'


class RootLuAnalog_fast_outExcitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.excitation'
        self.trigger = RootLuAnalog_fast_outExcitationTrigger(self._context)
        self.attribute = RootLuAnalog_fast_outExcitationAttribute(self._context)
        self.busy = RootLuAnalog_fast_outExcitationBusy(self._context)


class RootLuAnalog_fast_outFast2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.busy'


class RootLuAnalog_fast_outFast2AttributeCalib_sig_source_dir(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_sig_source_dir.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_sig_source_dir.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_sig_source_dir.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_sig_source_dir.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_sig_source_dir.get_min'))



class RootLuAnalog_fast_outFast2AttributeInput(wrap.CmdTreeProp):

    class EnumType(Enum):
        static = 'static'
        in_deflection = 'in_deflection'
        fast_in2 = 'fast_in2'
        in_user = 'in_user'
        analyzer1_reference = 'analyzer1_reference'
        analyzer2_reference = 'analyzer2_reference'
        ort_excitation = 'ort_excitation'
        ort_free_wave = 'ort_free_wave'
        ctrl_z_out = 'ctrl_z_out'
        ctrl_w_out = 'ctrl_w_out'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast2AttributeInput.EnumType(self._context.call('root.lu.analog_fast_out.fast2.attribute.input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.input.set_value', new_val.value)


class RootLuAnalog_fast_outFast2AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.output_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_gain.get_min'))



class RootLuAnalog_fast_outFast2AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_gain.get_min'))



class RootLuAnalog_fast_outFast2AttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.output_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.output_offset.get_min'))



class RootLuAnalog_fast_outFast2AttributeModulation(wrap.CmdTreeProp):

    class EnumType(Enum):
        analyzer2_reference = 'analyzer2_reference'
        disabled = 'disabled'
        damping = 'damping'
        hi_res_signal = 'hi_res_signal'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.modulation'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast2AttributeModulation.EnumType(self._context.call('root.lu.analog_fast_out.fast2.attribute.modulation.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.modulation.set_value', new_val.value)


class RootLuAnalog_fast_outFast2AttributeDamping_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.damping_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.damping_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.damping_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.damping_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.damping_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.damping_gain.get_min'))



class RootLuAnalog_fast_outFast2AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_offset.get_min'))



class RootLuAnalog_fast_outFast2AttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.static_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.static_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.static_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.static_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.static_value.get_min'))



class RootLuAnalog_fast_outFast2AttributeCalib_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast2AttributeCalib_polarity.EnumType(self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.calib_polarity.set_value', new_val.value)


class RootLuAnalog_fast_outFast2AttributeAnalog_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        enabled = 'enabled'
        disabled = 'disabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.analog_output'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outFast2AttributeAnalog_output.EnumType(self._context.call('root.lu.analog_fast_out.fast2.attribute.analog_output.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.analog_output.set_value', new_val.value)


class RootLuAnalog_fast_outFast2AttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.fast2.attribute.current_output_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.fast2.attribute.current_output_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.current_output_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.current_output_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.fast2.attribute.current_output_value.get_min'))



class RootLuAnalog_fast_outFast2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.attribute'
        self.current_output_value = RootLuAnalog_fast_outFast2AttributeCurrent_output_value(self._context)
        self.analog_output = RootLuAnalog_fast_outFast2AttributeAnalog_output(self._context)
        self.calib_polarity = RootLuAnalog_fast_outFast2AttributeCalib_polarity(self._context)
        self.static_value = RootLuAnalog_fast_outFast2AttributeStatic_value(self._context)
        self.calib_offset = RootLuAnalog_fast_outFast2AttributeCalib_offset(self._context)
        self.damping_gain = RootLuAnalog_fast_outFast2AttributeDamping_gain(self._context)
        self.modulation = RootLuAnalog_fast_outFast2AttributeModulation(self._context)
        self.output_offset = RootLuAnalog_fast_outFast2AttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_fast_outFast2AttributeCalib_gain(self._context)
        self.output_gain = RootLuAnalog_fast_outFast2AttributeOutput_gain(self._context)
        self.input = RootLuAnalog_fast_outFast2AttributeInput(self._context)
        self.calib_sig_source_dir = RootLuAnalog_fast_outFast2AttributeCalib_sig_source_dir(self._context)


class RootLuAnalog_fast_outFast2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2.trigger'


class RootLuAnalog_fast_outFast2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.fast2'
        self.trigger = RootLuAnalog_fast_outFast2Trigger(self._context)
        self.attribute = RootLuAnalog_fast_outFast2Attribute(self._context)
        self.busy = RootLuAnalog_fast_outFast2Busy(self._context)


class RootLuAnalog_fast_outUserBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.busy'


class RootLuAnalog_fast_outUserAttributeCalib_sig_source_dir(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.calib_sig_source_dir.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.calib_sig_source_dir.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_sig_source_dir.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_sig_source_dir.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_sig_source_dir.get_min'))



class RootLuAnalog_fast_outUserAttributeInput(wrap.CmdTreeProp):

    class EnumType(Enum):
        static = 'static'
        in_deflection = 'in_deflection'
        fast_in2 = 'fast_in2'
        in_user = 'in_user'
        analyzer1_reference = 'analyzer1_reference'
        analyzer2_reference = 'analyzer2_reference'
        ort_excitation = 'ort_excitation'
        ort_free_wave = 'ort_free_wave'
        ctrl_z_out = 'ctrl_z_out'
        ctrl_w_out = 'ctrl_w_out'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outUserAttributeInput.EnumType(self._context.call('root.lu.analog_fast_out.user.attribute.input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.user.attribute.input.set_value', new_val.value)


class RootLuAnalog_fast_outUserAttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.output_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.output_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.output_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.output_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.output_gain.get_min'))



class RootLuAnalog_fast_outUserAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.calib_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.calib_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_gain.get_min'))



class RootLuAnalog_fast_outUserAttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.output_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.output_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.output_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.output_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.output_offset.get_min'))



class RootLuAnalog_fast_outUserAttributeModulation(wrap.CmdTreeProp):

    class EnumType(Enum):
        analyzer2_reference = 'analyzer2_reference'
        disabled = 'disabled'
        damping = 'damping'
        hi_res_signal = 'hi_res_signal'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.modulation'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outUserAttributeModulation.EnumType(self._context.call('root.lu.analog_fast_out.user.attribute.modulation.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.user.attribute.modulation.set_value', new_val.value)


class RootLuAnalog_fast_outUserAttributeDamping_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.damping_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.damping_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.damping_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.damping_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.damping_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.damping_gain.get_min'))



class RootLuAnalog_fast_outUserAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.calib_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.calib_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.calib_offset.get_min'))



class RootLuAnalog_fast_outUserAttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.static_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.static_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.static_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.static_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.static_value.get_min'))



class RootLuAnalog_fast_outUserAttributeCalib_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outUserAttributeCalib_polarity.EnumType(self._context.call('root.lu.analog_fast_out.user.attribute.calib_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.user.attribute.calib_polarity.set_value', new_val.value)


class RootLuAnalog_fast_outUserAttributeAnalog_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        enabled = 'enabled'
        disabled = 'disabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.analog_output'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_outUserAttributeAnalog_output.EnumType(self._context.call('root.lu.analog_fast_out.user.attribute.analog_output.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_out.user.attribute.analog_output.set_value', new_val.value)


class RootLuAnalog_fast_outUserAttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_out.user.attribute.current_output_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_out.user.attribute.current_output_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.current_output_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.current_output_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_out.user.attribute.current_output_value.get_min'))



class RootLuAnalog_fast_outUserAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.attribute'
        self.current_output_value = RootLuAnalog_fast_outUserAttributeCurrent_output_value(self._context)
        self.analog_output = RootLuAnalog_fast_outUserAttributeAnalog_output(self._context)
        self.calib_polarity = RootLuAnalog_fast_outUserAttributeCalib_polarity(self._context)
        self.static_value = RootLuAnalog_fast_outUserAttributeStatic_value(self._context)
        self.calib_offset = RootLuAnalog_fast_outUserAttributeCalib_offset(self._context)
        self.damping_gain = RootLuAnalog_fast_outUserAttributeDamping_gain(self._context)
        self.modulation = RootLuAnalog_fast_outUserAttributeModulation(self._context)
        self.output_offset = RootLuAnalog_fast_outUserAttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_fast_outUserAttributeCalib_gain(self._context)
        self.output_gain = RootLuAnalog_fast_outUserAttributeOutput_gain(self._context)
        self.input = RootLuAnalog_fast_outUserAttributeInput(self._context)
        self.calib_sig_source_dir = RootLuAnalog_fast_outUserAttributeCalib_sig_source_dir(self._context)


class RootLuAnalog_fast_outUserTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user.trigger'


class RootLuAnalog_fast_outUser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out.user'
        self.trigger = RootLuAnalog_fast_outUserTrigger(self._context)
        self.attribute = RootLuAnalog_fast_outUserAttribute(self._context)
        self.busy = RootLuAnalog_fast_outUserBusy(self._context)


class RootLuAnalog_fast_out(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_out'
        self.user = RootLuAnalog_fast_outUser(self._context)
        self.fast2 = RootLuAnalog_fast_outFast2(self._context)
        self.excitation = RootLuAnalog_fast_outExcitation(self._context)
        self.fast3 = RootLuAnalog_fast_outFast3(self._context)


class RootLuTestInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.busy'


class RootLuTestInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.attribute'


class RootLuTestInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.trigger'

    def force_all_dac_to_max(self, *args) -> Any:
        return self._context.call('root.lu.test.instance.trigger.force_all_dac_to_max', *args)

    def force_all_dac_to_zero(self, *args) -> Any:
        return self._context.call('root.lu.test.instance.trigger.force_all_dac_to_zero', *args)

    def force_all_dac_to_min(self, *args) -> Any:
        return self._context.call('root.lu.test.instance.trigger.force_all_dac_to_min', *args)


class RootLuTestInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance'
        self.trigger = RootLuTestInstanceTrigger(self._context)
        self.attribute = RootLuTestInstanceAttribute(self._context)
        self.busy = RootLuTestInstanceBusy(self._context)


class RootLuTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test'
        self.instance = RootLuTestInstance(self._context)


class RootLuSignal_analyzerInst1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.busy'


class RootLuSignal_analyzerInst1AttributePhase_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain.get_min'))



class RootLuSignal_analyzerInst1AttributeReference_amplitude_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor.get_min'))



class RootLuSignal_analyzerInst1AttributeDelay_comp(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.delay_comp'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.delay_comp.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.delay_comp.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.delay_comp.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.delay_comp.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.delay_comp.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        const_drive = 'const_drive'
        const_amplitude = 'const_amplitude'
        free_vibration = 'free_vibration'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributePhase_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain.get_min'))



class RootLuSignal_analyzerInst1AttributeLock_in_calc_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase.get_min'))



class RootLuSignal_analyzerInst1AttributeOperating_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        lock_in = 'lock_in'
        pll = 'pll'
        kpfm = 'kpfm'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.operating_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeOperating_mode.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.operating_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.operating_mode.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain.get_min'))



class RootLuSignal_analyzerInst1AttributeHarmonic_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        analyzer1 = 'analyzer1'
        analyzer2 = 'analyzer2'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.harmonic_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeHarmonic_source.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.harmonic_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.harmonic_source.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeCurrent_x_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_x_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x_binary.get_min'))



class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result(wrap.CmdTreeProp):

    class EnumType(Enum):
        no_error = 'no_error'
        amplitude_calibration_error = 'amplitude_calibration_error'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude.get_min'))



class RootLuSignal_analyzerInst1AttributePhase_lock_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_lock_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.phase_lock_range.get_min'))



class RootLuSignal_analyzerInst1AttributeDemodulator_bw(wrap.CmdTreeProp):

    class EnumType(Enum):
        bw_23_hz = 'bw_23_hz'
        bw_45_hz = 'bw_45_hz'
        bw_90_hz = 'bw_90_hz'
        bw_180_hz = 'bw_180_hz'
        bw_360_hz = 'bw_360_hz'
        bw_750_hz = 'bw_750_hz'
        bw_1500_hz = 'bw_1500_hz'
        bw_3_k_hz = 'bw_3_k_hz'
        bw_6_k_hz = 'bw_6_k_hz'
        bw_12_k_hz = 'bw_12_k_hz'
        bw_23_k_hz = 'bw_23_k_hz'
        bw_45_k_hz = 'bw_45_k_hz'
        bw_100_k_hz = 'bw_100_k_hz'
        bw_230_k_hz = 'bw_230_k_hz'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.demodulator_bw'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeDemodulator_bw.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeCurrent_phase_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_phase_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase_binary.get_min'))



class RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        const_drive = 'const_drive'
        const_amplitude = 'const_amplitude'
        free_vibration = 'free_vibration'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeReference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_amplitude.get_min'))



class RootLuSignal_analyzerInst1AttributeReference_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        own = 'own'
        harmonic1 = 'harmonic1'
        harmonic2 = 'harmonic2'
        harmonic3 = 'harmonic3'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeReference_source.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_source.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeReference_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_frequency.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_frequency.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_frequency.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_frequency.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_frequency.get_min'))



class RootLuSignal_analyzerInst1AttributeReset_flag_pll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_reference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude.get_min'))



class RootLuSignal_analyzerInst1AttributeInput(wrap.CmdTreeProp):

    class EnumType(Enum):
        fast_in_deflection = 'fast_in_deflection'
        fast_in2 = 'fast_in2'
        fast_in_user = 'fast_in_user'
        in_lateral = 'in_lateral'
        in_user1 = 'in_user1'
        in_user2 = 'in_user2'
        in_user3 = 'in_user3'
        in_user4 = 'in_user4'
        in_tip_current = 'in_tip_current'
        test_ana_gnd = 'test_ana_gnd'
        test_ref = 'test_ref'
        test_tip_voltage = 'test_tip_voltage'
        in_position_x = 'in_position_x'
        in_position_y = 'in_position_y'
        in_position_z = 'in_position_z'
        analyzer1_amplitude = 'analyzer1_amplitude'
        analyzer1_ctrl_delta_f = 'analyzer1_ctrl_delta_f'
        ctrl_z_out = 'ctrl_z_out'
        static = 'static'
        gen_test_dynamic = 'gen_test_dynamic'
        ramp_gen_test = 'ramp_gen_test'
        in_deflection = 'in_deflection'
        in_detector_sum = 'in_detector_sum'
        in6 = 'in6'
        memory_gen_position_x = 'memory_gen_position_x'
        memory_gen_drive_x = 'memory_gen_drive_x'
        memory_gen_position_y = 'memory_gen_position_y'
        memory_gen_drive_y = 'memory_gen_drive_y'
        memory_gen_position_z = 'memory_gen_position_z'
        memory_gen_drive_z = 'memory_gen_drive_z'
        memory_gen_out7 = 'memory_gen_out7'
        memory_gen_out8 = 'memory_gen_out8'
        ramp_gen_approach = 'ramp_gen_approach'
        ramp_gen_position_x = 'ramp_gen_position_x'
        ramp_gen_position_y = 'ramp_gen_position_y'
        ramp_gen_tip_voltage = 'ramp_gen_tip_voltage'
        ramp_gen_alternate_z = 'ramp_gen_alternate_z'
        ramp_gen_user4 = 'ramp_gen_user4'
        ramp_gen_plane_z = 'ramp_gen_plane_z'
        ramp_gen_ctrl_z = 'ramp_gen_ctrl_z'
        ramp_gen_max_z = 'ramp_gen_max_z'
        ctrl_z_in = 'ctrl_z_in'
        ctrl_z_error = 'ctrl_z_error'
        ctrl_z_pid_command = 'ctrl_z_pid_command'
        ctrl_z_sum = 'ctrl_z_sum'
        ctrl_z_nominal = 'ctrl_z_nominal'
        ctrl_x_out = 'ctrl_x_out'
        ctrl_y_out = 'ctrl_y_out'
        ctrl_w_out = 'ctrl_w_out'
        ctrl_user1_out = 'ctrl_user1_out'
        ctrl_user2_out = 'ctrl_user2_out'
        analyzer1_ctrl_amplitude = 'analyzer1_ctrl_amplitude'
        analyzer1_phase = 'analyzer1_phase'
        analyzer1_x = 'analyzer1_x'
        analyzer1_y = 'analyzer1_y'
        analyzer2_ctrl_delta_f = 'analyzer2_ctrl_delta_f'
        analyzer2_ctrl_amplitude = 'analyzer2_ctrl_amplitude'
        analyzer2_phase = 'analyzer2_phase'
        analyzer2_amplitude = 'analyzer2_amplitude'
        analyzer2_x = 'analyzer2_x'
        analyzer2_y = 'analyzer2_y'
        ort_baseline = 'ort_baseline'
        ort_baseline_corrected = 'ort_baseline_corrected'
        ort_amplitude_reduction = 'ort_amplitude_reduction'
        ort_adhesion_value = 'ort_adhesion_value'
        ort_adhesion_position = 'ort_adhesion_position'
        analyzer1_reference = 'analyzer1_reference'
        analyzer2_reference = 'analyzer2_reference'
        ort_excitation = 'ort_excitation'
        ort_free_wave = 'ort_free_wave'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeInput.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.input.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point.get_min'))



class RootLuSignal_analyzerInst1AttributeEnable_dc_block(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.enable_dc_block'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeEnable_dc_block.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeCurrent_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y.get_min'))



class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_phase.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_x.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_ctrl_delta_f(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f.get_min'))



class RootLuSignal_analyzerInst1AttributePll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.pll_unlocked.get_min'))



class RootLuSignal_analyzerInst1AttributeAmplitude_modulation(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_modulation'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst1AttributeAmplitude_modulation.EnumType(self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.set_value', new_val.value)


class RootLuSignal_analyzerInst1AttributeReference_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_phase.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_phase.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_phase.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_phase.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.reference_phase.get_min'))



class RootLuSignal_analyzerInst1AttributeLock_in_calc_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_ctrl_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point.get_min'))



class RootLuSignal_analyzerInst1AttributeCurrent_y_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_y_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.current_y_binary.get_min'))



class RootLuSignal_analyzerInst1AttributeDisplay_df_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.display_df_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst1.attribute.display_df_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst1.attribute.display_df_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.display_df_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.display_df_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst1.attribute.display_df_range.get_min'))



class RootLuSignal_analyzerInst1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute'
        self.display_df_range = RootLuSignal_analyzerInst1AttributeDisplay_df_range(self._context)
        self.current_y_binary = RootLuSignal_analyzerInst1AttributeCurrent_y_binary(self._context)
        self.current_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_set_point(self._context)
        self.current_amplitude_binary = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_binary(self._context)
        self.current_ctrl_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_ctrl_amplitude(self._context)
        self.lock_in_calc_amplitude = RootLuSignal_analyzerInst1AttributeLock_in_calc_amplitude(self._context)
        self.reference_phase = RootLuSignal_analyzerInst1AttributeReference_phase(self._context)
        self.amplitude_modulation = RootLuSignal_analyzerInst1AttributeAmplitude_modulation(self._context)
        self.pll_unlocked = RootLuSignal_analyzerInst1AttributePll_unlocked(self._context)
        self.current_ctrl_delta_f = RootLuSignal_analyzerInst1AttributeCurrent_ctrl_delta_f(self._context)
        self.current_x = RootLuSignal_analyzerInst1AttributeCurrent_x(self._context)
        self.current_phase = RootLuSignal_analyzerInst1AttributeCurrent_phase(self._context)
        self.amplitude_ctrl_i_gain = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_i_gain(self._context)
        self.current_y = RootLuSignal_analyzerInst1AttributeCurrent_y(self._context)
        self.enable_dc_block = RootLuSignal_analyzerInst1AttributeEnable_dc_block(self._context)
        self.target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_set_point(self._context)
        self.input = RootLuSignal_analyzerInst1AttributeInput(self._context)
        self.current_reference_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_reference_amplitude(self._context)
        self.reset_flag_pll_unlocked = RootLuSignal_analyzerInst1AttributeReset_flag_pll_unlocked(self._context)
        self.reference_frequency = RootLuSignal_analyzerInst1AttributeReference_frequency(self._context)
        self.reference_source = RootLuSignal_analyzerInst1AttributeReference_source(self._context)
        self.reference_amplitude = RootLuSignal_analyzerInst1AttributeReference_amplitude(self._context)
        self.target_amplitude_ctrl_mode = RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode(self._context)
        self.current_phase_binary = RootLuSignal_analyzerInst1AttributeCurrent_phase_binary(self._context)
        self.demodulator_bw = RootLuSignal_analyzerInst1AttributeDemodulator_bw(self._context)
        self.phase_lock_range = RootLuSignal_analyzerInst1AttributePhase_lock_range(self._context)
        self.current_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_amplitude(self._context)
        self.amplitude_ctrl_set_point_calib_result = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result(self._context)
        self.current_x_binary = RootLuSignal_analyzerInst1AttributeCurrent_x_binary(self._context)
        self.harmonic_source = RootLuSignal_analyzerInst1AttributeHarmonic_source(self._context)
        self.amplitude_ctrl_p_gain = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_p_gain(self._context)
        self.operating_mode = RootLuSignal_analyzerInst1AttributeOperating_mode(self._context)
        self.lock_in_calc_phase = RootLuSignal_analyzerInst1AttributeLock_in_calc_phase(self._context)
        self.phase_ctrl_i_gain = RootLuSignal_analyzerInst1AttributePhase_ctrl_i_gain(self._context)
        self.current_amplitude_ctrl_mode = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode(self._context)
        self.delay_comp = RootLuSignal_analyzerInst1AttributeDelay_comp(self._context)
        self.reference_amplitude_factor = RootLuSignal_analyzerInst1AttributeReference_amplitude_factor(self._context)
        self.phase_ctrl_p_gain = RootLuSignal_analyzerInst1AttributePhase_ctrl_p_gain(self._context)


class RootLuSignal_analyzerInst1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger'

    def switch_to_target_amplitude_ctrl_set_point(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.switch_to_target_amplitude_ctrl_set_point', *args)

    def switch_to_target_amplitude_ctrl_mode(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.switch_to_target_amplitude_ctrl_mode', *args)

    def start_phase_zero_calibration(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_phase_zero_calibration', *args)

    def start_update_current_free_amplitude(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_update_current_free_amplitude', *args)

    def start_switch_to_target_amplitude_ctrl_set_point(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_switch_to_target_amplitude_ctrl_set_point', *args)

    def kpfm_phase_calibration(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.kpfm_phase_calibration', *args)

    def start_switch_to_target_amplitude_ctrl_mode(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_switch_to_target_amplitude_ctrl_mode', *args)

    def start_kpfm_phase_calibration(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.start_kpfm_phase_calibration', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst1.trigger.user_abort', *args)


class RootLuSignal_analyzerInst1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1'
        self.trigger = RootLuSignal_analyzerInst1Trigger(self._context)
        self.attribute = RootLuSignal_analyzerInst1Attribute(self._context)
        self.busy = RootLuSignal_analyzerInst1Busy(self._context)


class RootLuSignal_analyzerInst2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.busy'


class RootLuSignal_analyzerInst2AttributePhase_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain.get_min'))



class RootLuSignal_analyzerInst2AttributeReference_amplitude_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor.get_min'))



class RootLuSignal_analyzerInst2AttributeDelay_comp(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.delay_comp'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.delay_comp.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.delay_comp.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.delay_comp.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.delay_comp.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.delay_comp.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        const_drive = 'const_drive'
        const_amplitude = 'const_amplitude'
        free_vibration = 'free_vibration'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributePhase_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain.get_min'))



class RootLuSignal_analyzerInst2AttributeLock_in_calc_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase.get_min'))



class RootLuSignal_analyzerInst2AttributeOperating_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        lock_in = 'lock_in'
        pll = 'pll'
        kpfm = 'kpfm'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.operating_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeOperating_mode.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.operating_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.operating_mode.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain.get_min'))



class RootLuSignal_analyzerInst2AttributeHarmonic_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        analyzer1 = 'analyzer1'
        analyzer2 = 'analyzer2'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.harmonic_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeHarmonic_source.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.harmonic_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.harmonic_source.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeCurrent_x_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_x_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x_binary.get_min'))



class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result(wrap.CmdTreeProp):

    class EnumType(Enum):
        no_error = 'no_error'
        amplitude_calibration_error = 'amplitude_calibration_error'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude.get_min'))



class RootLuSignal_analyzerInst2AttributePhase_lock_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_lock_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.phase_lock_range.get_min'))



class RootLuSignal_analyzerInst2AttributeDemodulator_bw(wrap.CmdTreeProp):

    class EnumType(Enum):
        bw_23_hz = 'bw_23_hz'
        bw_45_hz = 'bw_45_hz'
        bw_90_hz = 'bw_90_hz'
        bw_180_hz = 'bw_180_hz'
        bw_360_hz = 'bw_360_hz'
        bw_750_hz = 'bw_750_hz'
        bw_1500_hz = 'bw_1500_hz'
        bw_3_k_hz = 'bw_3_k_hz'
        bw_6_k_hz = 'bw_6_k_hz'
        bw_12_k_hz = 'bw_12_k_hz'
        bw_23_k_hz = 'bw_23_k_hz'
        bw_45_k_hz = 'bw_45_k_hz'
        bw_100_k_hz = 'bw_100_k_hz'
        bw_230_k_hz = 'bw_230_k_hz'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.demodulator_bw'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeDemodulator_bw.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeCurrent_phase_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_phase_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase_binary.get_min'))



class RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        const_drive = 'const_drive'
        const_amplitude = 'const_amplitude'
        free_vibration = 'free_vibration'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeReference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_amplitude.get_min'))



class RootLuSignal_analyzerInst2AttributeReference_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        own = 'own'
        harmonic1 = 'harmonic1'
        harmonic2 = 'harmonic2'
        harmonic3 = 'harmonic3'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeReference_source.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_source.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeReference_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_frequency.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_frequency.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_frequency.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_frequency.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_frequency.get_min'))



class RootLuSignal_analyzerInst2AttributeReset_flag_pll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_reference_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude.get_min'))



class RootLuSignal_analyzerInst2AttributeInput(wrap.CmdTreeProp):

    class EnumType(Enum):
        fast_in_deflection = 'fast_in_deflection'
        fast_in2 = 'fast_in2'
        fast_in_user = 'fast_in_user'
        in_lateral = 'in_lateral'
        in_user1 = 'in_user1'
        in_user2 = 'in_user2'
        in_user3 = 'in_user3'
        in_user4 = 'in_user4'
        in_tip_current = 'in_tip_current'
        test_ana_gnd = 'test_ana_gnd'
        test_ref = 'test_ref'
        test_tip_voltage = 'test_tip_voltage'
        in_position_x = 'in_position_x'
        in_position_y = 'in_position_y'
        in_position_z = 'in_position_z'
        analyzer1_amplitude = 'analyzer1_amplitude'
        analyzer1_ctrl_delta_f = 'analyzer1_ctrl_delta_f'
        ctrl_z_out = 'ctrl_z_out'
        static = 'static'
        gen_test_dynamic = 'gen_test_dynamic'
        ramp_gen_test = 'ramp_gen_test'
        in_deflection = 'in_deflection'
        in_detector_sum = 'in_detector_sum'
        in6 = 'in6'
        memory_gen_position_x = 'memory_gen_position_x'
        memory_gen_drive_x = 'memory_gen_drive_x'
        memory_gen_position_y = 'memory_gen_position_y'
        memory_gen_drive_y = 'memory_gen_drive_y'
        memory_gen_position_z = 'memory_gen_position_z'
        memory_gen_drive_z = 'memory_gen_drive_z'
        memory_gen_out7 = 'memory_gen_out7'
        memory_gen_out8 = 'memory_gen_out8'
        ramp_gen_approach = 'ramp_gen_approach'
        ramp_gen_position_x = 'ramp_gen_position_x'
        ramp_gen_position_y = 'ramp_gen_position_y'
        ramp_gen_tip_voltage = 'ramp_gen_tip_voltage'
        ramp_gen_alternate_z = 'ramp_gen_alternate_z'
        ramp_gen_user4 = 'ramp_gen_user4'
        ramp_gen_plane_z = 'ramp_gen_plane_z'
        ramp_gen_ctrl_z = 'ramp_gen_ctrl_z'
        ramp_gen_max_z = 'ramp_gen_max_z'
        ctrl_z_in = 'ctrl_z_in'
        ctrl_z_error = 'ctrl_z_error'
        ctrl_z_pid_command = 'ctrl_z_pid_command'
        ctrl_z_sum = 'ctrl_z_sum'
        ctrl_z_nominal = 'ctrl_z_nominal'
        ctrl_x_out = 'ctrl_x_out'
        ctrl_y_out = 'ctrl_y_out'
        ctrl_w_out = 'ctrl_w_out'
        ctrl_user1_out = 'ctrl_user1_out'
        ctrl_user2_out = 'ctrl_user2_out'
        analyzer1_ctrl_amplitude = 'analyzer1_ctrl_amplitude'
        analyzer1_phase = 'analyzer1_phase'
        analyzer1_x = 'analyzer1_x'
        analyzer1_y = 'analyzer1_y'
        analyzer2_ctrl_delta_f = 'analyzer2_ctrl_delta_f'
        analyzer2_ctrl_amplitude = 'analyzer2_ctrl_amplitude'
        analyzer2_phase = 'analyzer2_phase'
        analyzer2_amplitude = 'analyzer2_amplitude'
        analyzer2_x = 'analyzer2_x'
        analyzer2_y = 'analyzer2_y'
        ort_baseline = 'ort_baseline'
        ort_baseline_corrected = 'ort_baseline_corrected'
        ort_amplitude_reduction = 'ort_amplitude_reduction'
        ort_adhesion_value = 'ort_adhesion_value'
        ort_adhesion_position = 'ort_adhesion_position'
        analyzer1_reference = 'analyzer1_reference'
        analyzer2_reference = 'analyzer2_reference'
        ort_excitation = 'ort_excitation'
        ort_free_wave = 'ort_free_wave'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeInput.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.input.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point.get_min'))



class RootLuSignal_analyzerInst2AttributeEnable_dc_block(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.enable_dc_block'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeEnable_dc_block.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeCurrent_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y.get_min'))



class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_phase.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_x.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_ctrl_delta_f(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f.get_min'))



class RootLuSignal_analyzerInst2AttributePll_unlocked(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.pll_unlocked'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.pll_unlocked.get_min'))



class RootLuSignal_analyzerInst2AttributeAmplitude_modulation(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_modulation'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSignal_analyzerInst2AttributeAmplitude_modulation.EnumType(self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.set_value', new_val.value)


class RootLuSignal_analyzerInst2AttributeReference_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_phase.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_phase.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_phase.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_phase.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.reference_phase.get_min'))



class RootLuSignal_analyzerInst2AttributeLock_in_calc_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_ctrl_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_set_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point.get_min'))



class RootLuSignal_analyzerInst2AttributeCurrent_y_binary(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_y_binary'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y_binary.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y_binary.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y_binary.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y_binary.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.current_y_binary.get_min'))



class RootLuSignal_analyzerInst2AttributeDisplay_df_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.display_df_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.signal_analyzer.inst2.attribute.display_df_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.signal_analyzer.inst2.attribute.display_df_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.display_df_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.display_df_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.signal_analyzer.inst2.attribute.display_df_range.get_min'))



class RootLuSignal_analyzerInst2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute'
        self.display_df_range = RootLuSignal_analyzerInst2AttributeDisplay_df_range(self._context)
        self.current_y_binary = RootLuSignal_analyzerInst2AttributeCurrent_y_binary(self._context)
        self.current_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_set_point(self._context)
        self.current_amplitude_binary = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_binary(self._context)
        self.current_ctrl_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_ctrl_amplitude(self._context)
        self.lock_in_calc_amplitude = RootLuSignal_analyzerInst2AttributeLock_in_calc_amplitude(self._context)
        self.reference_phase = RootLuSignal_analyzerInst2AttributeReference_phase(self._context)
        self.amplitude_modulation = RootLuSignal_analyzerInst2AttributeAmplitude_modulation(self._context)
        self.pll_unlocked = RootLuSignal_analyzerInst2AttributePll_unlocked(self._context)
        self.current_ctrl_delta_f = RootLuSignal_analyzerInst2AttributeCurrent_ctrl_delta_f(self._context)
        self.current_x = RootLuSignal_analyzerInst2AttributeCurrent_x(self._context)
        self.current_phase = RootLuSignal_analyzerInst2AttributeCurrent_phase(self._context)
        self.amplitude_ctrl_i_gain = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_i_gain(self._context)
        self.current_y = RootLuSignal_analyzerInst2AttributeCurrent_y(self._context)
        self.enable_dc_block = RootLuSignal_analyzerInst2AttributeEnable_dc_block(self._context)
        self.target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_set_point(self._context)
        self.input = RootLuSignal_analyzerInst2AttributeInput(self._context)
        self.current_reference_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_reference_amplitude(self._context)
        self.reset_flag_pll_unlocked = RootLuSignal_analyzerInst2AttributeReset_flag_pll_unlocked(self._context)
        self.reference_frequency = RootLuSignal_analyzerInst2AttributeReference_frequency(self._context)
        self.reference_source = RootLuSignal_analyzerInst2AttributeReference_source(self._context)
        self.reference_amplitude = RootLuSignal_analyzerInst2AttributeReference_amplitude(self._context)
        self.target_amplitude_ctrl_mode = RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode(self._context)
        self.current_phase_binary = RootLuSignal_analyzerInst2AttributeCurrent_phase_binary(self._context)
        self.demodulator_bw = RootLuSignal_analyzerInst2AttributeDemodulator_bw(self._context)
        self.phase_lock_range = RootLuSignal_analyzerInst2AttributePhase_lock_range(self._context)
        self.current_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_amplitude(self._context)
        self.amplitude_ctrl_set_point_calib_result = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result(self._context)
        self.current_x_binary = RootLuSignal_analyzerInst2AttributeCurrent_x_binary(self._context)
        self.harmonic_source = RootLuSignal_analyzerInst2AttributeHarmonic_source(self._context)
        self.amplitude_ctrl_p_gain = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_p_gain(self._context)
        self.operating_mode = RootLuSignal_analyzerInst2AttributeOperating_mode(self._context)
        self.lock_in_calc_phase = RootLuSignal_analyzerInst2AttributeLock_in_calc_phase(self._context)
        self.phase_ctrl_i_gain = RootLuSignal_analyzerInst2AttributePhase_ctrl_i_gain(self._context)
        self.current_amplitude_ctrl_mode = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode(self._context)
        self.delay_comp = RootLuSignal_analyzerInst2AttributeDelay_comp(self._context)
        self.reference_amplitude_factor = RootLuSignal_analyzerInst2AttributeReference_amplitude_factor(self._context)
        self.phase_ctrl_p_gain = RootLuSignal_analyzerInst2AttributePhase_ctrl_p_gain(self._context)


class RootLuSignal_analyzerInst2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger'

    def switch_to_target_amplitude_ctrl_set_point(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.switch_to_target_amplitude_ctrl_set_point', *args)

    def switch_to_target_amplitude_ctrl_mode(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.switch_to_target_amplitude_ctrl_mode', *args)

    def start_phase_zero_calibration(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_phase_zero_calibration', *args)

    def start_update_current_free_amplitude(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_update_current_free_amplitude', *args)

    def start_switch_to_target_amplitude_ctrl_set_point(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_switch_to_target_amplitude_ctrl_set_point', *args)

    def kpfm_phase_calibration(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.kpfm_phase_calibration', *args)

    def start_switch_to_target_amplitude_ctrl_mode(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_switch_to_target_amplitude_ctrl_mode', *args)

    def start_kpfm_phase_calibration(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.start_kpfm_phase_calibration', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.signal_analyzer.inst2.trigger.user_abort', *args)


class RootLuSignal_analyzerInst2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2'
        self.trigger = RootLuSignal_analyzerInst2Trigger(self._context)
        self.attribute = RootLuSignal_analyzerInst2Attribute(self._context)
        self.busy = RootLuSignal_analyzerInst2Busy(self._context)


class RootLuSignal_analyzer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer'
        self.inst2 = RootLuSignal_analyzerInst2(self._context)
        self.inst1 = RootLuSignal_analyzerInst1(self._context)


class RootLuSpecInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.busy'


class RootLuSpecInstanceAttributeBwd_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.bwd_datapoints.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.bwd_datapoints.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_datapoints.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_datapoints.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_datapoints.get_min'))



class RootLuSpecInstanceAttributeBwd_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.bwd_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.bwd_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_move_speed.get_min'))



class RootLuSpecInstanceAttributeFwd_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.fwd_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.fwd_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_move_speed.get_min'))



class RootLuSpecInstanceAttributeFwd_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.fwd_pause_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.fwd_pause_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_pause_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_pause_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_pause_time.get_min'))



class RootLuSpecInstanceAttributePhase_bwd_pause_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_pause_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.phase_bwd_pause_rate.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.phase_bwd_pause_rate.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_bwd_pause_rate.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_bwd_pause_rate.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_bwd_pause_rate.get_min'))



class RootLuSpecInstanceAttributeCurrent_repetition(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.current_repetition'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.current_repetition.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.current_repetition.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.current_repetition.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.current_repetition.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.current_repetition.get_min'))



class RootLuSpecInstanceAttributePhase_data_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_data_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.phase_data_group_id.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.phase_data_group_id.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_data_group_id.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_data_group_id.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_data_group_id.get_min'))



class RootLuSpecInstanceAttributePhase_fwd_mod_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_mod_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.phase_fwd_mod_rate.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.phase_fwd_mod_rate.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_fwd_mod_rate.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_fwd_mod_rate.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_fwd_mod_rate.get_min'))



class RootLuSpecInstanceAttributePhase_sample_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_sample_mask'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.phase_sample_mask.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.phase_sample_mask.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_sample_mask.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_sample_mask.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_sample_mask.get_min'))



class RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.auto_recalibrate_probe_interval'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.get_min'))



class RootLuSpecInstanceAttributeRepetition_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        list = 'list'
        position = 'position'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeRepetition_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.repetition_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.repetition_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributeSpec_end_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        keep_last_z_pos = 'keep_last_z_pos'
        z_controller_active = 'z_controller_active'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_end_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeSpec_end_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.spec_end_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.spec_end_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributePhase_bwd_mod_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_mod_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.phase_bwd_mod_rate.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.phase_bwd_mod_rate.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_bwd_mod_rate.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_bwd_mod_rate.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_bwd_mod_rate.get_min'))



class RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_configuration_blob_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.get_vector', *args)


class RootLuSpecInstanceAttributeSpec_map_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.spec_map_mode.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.spec_map_mode.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.spec_map_mode.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.spec_map_mode.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.spec_map_mode.get_min'))



class RootLuSpecInstanceAttributeStart_offset_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.start_offset_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.start_offset_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.start_offset_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.start_offset_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.start_offset_move_speed.get_min'))



class RootLuSpecInstanceAttributeDeflection_force_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.deflection_force_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.deflection_force_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.deflection_force_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.deflection_force_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.deflection_force_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.deflection_force_offset.get_min'))



class RootLuSpecInstanceAttributeBwd_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.bwd_pause_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.bwd_pause_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_pause_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_pause_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_pause_time.get_min'))



class RootLuSpecInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.xy_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.xy_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.xy_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.xy_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.xy_move_speed.get_min'))



class RootLuSpecInstanceAttributeModulation_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        position_z = 'position_z'
        tip_voltage = 'tip_voltage'
        external_z = 'external_z'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.modulation_output'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeModulation_output.EnumType(self._context.call('root.lu.spec.instance.attribute.modulation_output.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.modulation_output.set_value', new_val.value)


class RootLuSpecInstanceAttributeFwd_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.fwd_pause_datapoints.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.fwd_pause_datapoints.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_pause_datapoints.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_pause_datapoints.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_pause_datapoints.get_min'))



class RootLuSpecInstanceAttributeFwd_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.fwd_datapoints.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.fwd_datapoints.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_datapoints.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_datapoints.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_datapoints.get_min'))



class RootLuSpecInstanceAttributeStart_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.start_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.start_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.start_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.start_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.start_offset.get_min'))



class RootLuSpecInstanceAttributeFeedback_active(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.feedback_active'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.feedback_active.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.feedback_active.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.feedback_active.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.feedback_active.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.feedback_active.get_min'))



class RootLuSpecInstanceAttributeMod_rel_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.mod_rel_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.mod_rel_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.mod_rel_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.mod_rel_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.mod_rel_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.mod_rel_value.get_min'))



class RootLuSpecInstanceAttributeFwd_pause_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        z_off = 'z_off'
        z_on = 'z_on'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeFwd_pause_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.fwd_pause_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.fwd_pause_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributeFwd_mod_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fixed_length = 'fixed_length'
        stop_by_value = 'stop_by_value'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeFwd_mod_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.fwd_mod_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.fwd_mod_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributeBwd_mod_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.bwd_mod_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.bwd_mod_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_time.get_min'))



class RootLuSpecInstanceAttributeBwd_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.bwd_pause_datapoints.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.bwd_pause_datapoints.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_pause_datapoints.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_pause_datapoints.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_pause_datapoints.get_min'))



class RootLuSpecInstanceAttributeBwd_pause_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        z_off = 'z_off'
        z_on = 'z_on'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeBwd_pause_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.bwd_pause_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.bwd_pause_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributeBwd_mod_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        fixed_length = 'fixed_length'
        stop_by_value = 'stop_by_value'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeBwd_mod_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.bwd_mod_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.bwd_mod_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributeFwd_mod_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.fwd_mod_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.fwd_mod_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_time.get_min'))



class RootLuSpecInstanceAttributeBwd_mod_stop_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_less_than = 'is_less_than'
        is_greater_than = 'is_greater_than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeBwd_mod_stop_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.bwd_mod_stop_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.bwd_mod_stop_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributeFwd_mod_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.fwd_mod_stop_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.fwd_mod_stop_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_stop_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_stop_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_stop_value.get_min'))



class RootLuSpecInstanceAttributePoint_coords_blob_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.point_coords_blob_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.point_coords_blob_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.point_coords_blob_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.point_coords_blob_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.point_coords_blob_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.point_coords_blob_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.point_coords_blob_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.attribute.point_coords_blob_vec.get_vector', *args)


class RootLuSpecInstanceAttributeFwd_mod_stop_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        is_less_than = 'is_less_than'
        is_greater_than = 'is_greater_than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSpecInstanceAttributeFwd_mod_stop_mode.EnumType(self._context.call('root.lu.spec.instance.attribute.fwd_mod_stop_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.spec.instance.attribute.fwd_mod_stop_mode.set_value', new_val.value)


class RootLuSpecInstanceAttributeBwd_mod_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.bwd_mod_stop_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.bwd_mod_stop_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_stop_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_stop_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_stop_value.get_min'))



class RootLuSpecInstanceAttributeFwd_mod_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.fwd_mod_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.fwd_mod_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.fwd_mod_range.get_min'))



class RootLuSpecInstanceAttributeRepetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.repetition_count.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.repetition_count.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.repetition_count.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.repetition_count.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.repetition_count.get_min'))



class RootLuSpecInstanceAttributePhase_fwd_pause_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_pause_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.phase_fwd_pause_rate.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.phase_fwd_pause_rate.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_fwd_pause_rate.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_fwd_pause_rate.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.phase_fwd_pause_rate.get_min'))



class RootLuSpecInstanceAttributeBwd_mod_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.spec.instance.attribute.bwd_mod_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.spec.instance.attribute.bwd_mod_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.spec.instance.attribute.bwd_mod_range.get_min'))



class RootLuSpecInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute'
        self.bwd_mod_range = RootLuSpecInstanceAttributeBwd_mod_range(self._context)
        self.phase_fwd_pause_rate = RootLuSpecInstanceAttributePhase_fwd_pause_rate(self._context)
        self.repetition_count = RootLuSpecInstanceAttributeRepetition_count(self._context)
        self.fwd_mod_range = RootLuSpecInstanceAttributeFwd_mod_range(self._context)
        self.bwd_mod_stop_value = RootLuSpecInstanceAttributeBwd_mod_stop_value(self._context)
        self.fwd_mod_stop_mode = RootLuSpecInstanceAttributeFwd_mod_stop_mode(self._context)
        self.point_coords_blob_vec = RootLuSpecInstanceAttributePoint_coords_blob_vec(self._context)
        self.fwd_mod_stop_value = RootLuSpecInstanceAttributeFwd_mod_stop_value(self._context)
        self.bwd_mod_stop_mode = RootLuSpecInstanceAttributeBwd_mod_stop_mode(self._context)
        self.fwd_mod_time = RootLuSpecInstanceAttributeFwd_mod_time(self._context)
        self.bwd_mod_mode = RootLuSpecInstanceAttributeBwd_mod_mode(self._context)
        self.bwd_pause_mode = RootLuSpecInstanceAttributeBwd_pause_mode(self._context)
        self.bwd_pause_datapoints = RootLuSpecInstanceAttributeBwd_pause_datapoints(self._context)
        self.bwd_mod_time = RootLuSpecInstanceAttributeBwd_mod_time(self._context)
        self.fwd_mod_mode = RootLuSpecInstanceAttributeFwd_mod_mode(self._context)
        self.fwd_pause_mode = RootLuSpecInstanceAttributeFwd_pause_mode(self._context)
        self.mod_rel_value = RootLuSpecInstanceAttributeMod_rel_value(self._context)
        self.feedback_active = RootLuSpecInstanceAttributeFeedback_active(self._context)
        self.start_offset = RootLuSpecInstanceAttributeStart_offset(self._context)
        self.fwd_datapoints = RootLuSpecInstanceAttributeFwd_datapoints(self._context)
        self.fwd_pause_datapoints = RootLuSpecInstanceAttributeFwd_pause_datapoints(self._context)
        self.modulation_output = RootLuSpecInstanceAttributeModulation_output(self._context)
        self.xy_move_speed = RootLuSpecInstanceAttributeXy_move_speed(self._context)
        self.bwd_pause_time = RootLuSpecInstanceAttributeBwd_pause_time(self._context)
        self.deflection_force_offset = RootLuSpecInstanceAttributeDeflection_force_offset(self._context)
        self.start_offset_move_speed = RootLuSpecInstanceAttributeStart_offset_move_speed(self._context)
        self.spec_map_mode = RootLuSpecInstanceAttributeSpec_map_mode(self._context)
        self.spec_map_configuration_blob_vec = RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(self._context)
        self.phase_bwd_mod_rate = RootLuSpecInstanceAttributePhase_bwd_mod_rate(self._context)
        self.spec_end_mode = RootLuSpecInstanceAttributeSpec_end_mode(self._context)
        self.repetition_mode = RootLuSpecInstanceAttributeRepetition_mode(self._context)
        self.auto_recalibrate_probe_interval = RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(self._context)
        self.phase_sample_mask = RootLuSpecInstanceAttributePhase_sample_mask(self._context)
        self.phase_fwd_mod_rate = RootLuSpecInstanceAttributePhase_fwd_mod_rate(self._context)
        self.phase_data_group_id = RootLuSpecInstanceAttributePhase_data_group_id(self._context)
        self.current_repetition = RootLuSpecInstanceAttributeCurrent_repetition(self._context)
        self.phase_bwd_pause_rate = RootLuSpecInstanceAttributePhase_bwd_pause_rate(self._context)
        self.fwd_pause_time = RootLuSpecInstanceAttributeFwd_pause_time(self._context)
        self.fwd_move_speed = RootLuSpecInstanceAttributeFwd_move_speed(self._context)
        self.bwd_move_speed = RootLuSpecInstanceAttributeBwd_move_speed(self._context)
        self.bwd_datapoints = RootLuSpecInstanceAttributeBwd_datapoints(self._context)


class RootLuSpecInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger'

    def resume_next_point(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.trigger.resume_next_point', *args)

    def pause(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.trigger.pause', *args)

    def resume_last_point(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.trigger.resume_last_point', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.trigger.start', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.spec.instance.trigger.user_abort', *args)


class RootLuSpecInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance'
        self.trigger = RootLuSpecInstanceTrigger(self._context)
        self.attribute = RootLuSpecInstanceAttribute(self._context)
        self.busy = RootLuSpecInstanceBusy(self._context)


class RootLuSpec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec'
        self.instance = RootLuSpecInstance(self._context)


class RootLuHv_amplifierInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.busy'


class RootLuHv_amplifierInstanceAttributeMode_current(wrap.CmdTreeProp):

    class EnumType(Enum):
        off = 'off'
        hv = 'hv'
        lv = 'lv'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_current'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuHv_amplifierInstanceAttributeMode_current.EnumType(self._context.call('root.lu.hv_amplifier.instance.attribute.mode_current.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.hv_amplifier.instance.attribute.mode_current.set_value', new_val.value)


class RootLuHv_amplifierInstanceAttributeHv_module_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.hv_module_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.hv_module_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.hv_module_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.hv_module_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.hv_module_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.hv_module_enabled.get_min'))



class RootLuHv_amplifierInstanceAttributeInterlock_open_hv_cable(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable.get_min'))



class RootLuHv_amplifierInstanceAttributeOutput_discharge_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.output_discharge_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.output_discharge_delay.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.output_discharge_delay.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.output_discharge_delay.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.output_discharge_delay.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.output_discharge_delay.get_min'))



class RootLuHv_amplifierInstanceAttributeMode_target(wrap.CmdTreeProp):

    class EnumType(Enum):
        off = 'off'
        hv = 'hv'
        lv = 'lv'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_target'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuHv_amplifierInstanceAttributeMode_target.EnumType(self._context.call('root.lu.hv_amplifier.instance.attribute.mode_target.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.hv_amplifier.instance.attribute.mode_target.set_value', new_val.value)


class RootLuHv_amplifierInstanceAttributePower_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.power_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.power_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.power_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.power_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.power_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.power_enabled.get_min'))



class RootLuHv_amplifierInstanceAttributeZ_modulation_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.z_modulation_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.z_modulation_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.z_modulation_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.z_modulation_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.z_modulation_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.z_modulation_enabled.get_min'))



class RootLuHv_amplifierInstanceAttributeTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.temperature.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.temperature.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.temperature.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.temperature.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.temperature.get_min'))



class RootLuHv_amplifierInstanceAttributeType(wrap.CmdTreeProp):

    class EnumType(Enum):
        not_connected = 'not_connected'
        unknown = 'unknown'
        a201 = 'a201'
        hv180 = 'hv180'
        hv500 = 'hv500'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.type'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuHv_amplifierInstanceAttributeType.EnumType(self._context.call('root.lu.hv_amplifier.instance.attribute.type.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.hv_amplifier.instance.attribute.type.set_value', new_val.value)


class RootLuHv_amplifierInstanceAttributeInterlock_open_cx_cable(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable.get_min'))



class RootLuHv_amplifierInstanceAttributeInterlock_open_user(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_user'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_user.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_user.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_user.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_user.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.hv_amplifier.instance.attribute.interlock_open_user.get_min'))



class RootLuHv_amplifierInstanceAttributeLast_mode_switch_retval(wrap.CmdTreeProp):

    class EnumType(Enum):
        ok = 'ok'
        mode_not_supported = 'mode_not_supported'
        interlock_open = 'interlock_open'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuHv_amplifierInstanceAttributeLast_mode_switch_retval.EnumType(self._context.call('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.set_value', new_val.value)


class RootLuHv_amplifierInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute'
        self.last_mode_switch_retval = RootLuHv_amplifierInstanceAttributeLast_mode_switch_retval(self._context)
        self.interlock_open_user = RootLuHv_amplifierInstanceAttributeInterlock_open_user(self._context)
        self.interlock_open_cx_cable = RootLuHv_amplifierInstanceAttributeInterlock_open_cx_cable(self._context)
        self.type = RootLuHv_amplifierInstanceAttributeType(self._context)
        self.temperature = RootLuHv_amplifierInstanceAttributeTemperature(self._context)
        self.z_modulation_enabled = RootLuHv_amplifierInstanceAttributeZ_modulation_enabled(self._context)
        self.power_enabled = RootLuHv_amplifierInstanceAttributePower_enabled(self._context)
        self.mode_target = RootLuHv_amplifierInstanceAttributeMode_target(self._context)
        self.output_discharge_delay = RootLuHv_amplifierInstanceAttributeOutput_discharge_delay(self._context)
        self.interlock_open_hv_cable = RootLuHv_amplifierInstanceAttributeInterlock_open_hv_cable(self._context)
        self.hv_module_enabled = RootLuHv_amplifierInstanceAttributeHv_module_enabled(self._context)
        self.mode_current = RootLuHv_amplifierInstanceAttributeMode_current(self._context)


class RootLuHv_amplifierInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger'

    def enable_power(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.enable_power', *args)

    def disable_z_modulation(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.disable_z_modulation', *args)

    def enable_module(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.enable_module', *args)

    def enable_z_modulation(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.enable_z_modulation', *args)

    def disable_module(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.disable_module', *args)

    def switch_to_target_mode(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.switch_to_target_mode', *args)

    def depreciated_6(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.depreciated_6', *args)

    def start_switch_to_target_mode(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.start_switch_to_target_mode', *args)

    def disable_power(self, *args) -> Any:
        return self._context.call('root.lu.hv_amplifier.instance.trigger.disable_power', *args)


class RootLuHv_amplifierInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance'
        self.trigger = RootLuHv_amplifierInstanceTrigger(self._context)
        self.attribute = RootLuHv_amplifierInstanceAttribute(self._context)
        self.busy = RootLuHv_amplifierInstanceBusy(self._context)


class RootLuHv_amplifier(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier'
        self.instance = RootLuHv_amplifierInstance(self._context)


class RootLuApproachInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.busy'


class RootLuApproachInstanceAttributeStep_by_step_coarse_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.get_min'))



class RootLuApproachInstanceAttributeApproach_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        adjusting_tip_pos = 'adjusting_tip_pos'
        home_position_reached = 'home_position_reached'
        move_to_home_position = 'move_to_home_position'
        sensor_failed = 'sensor_failed'
        approach_aborted = 'approach_aborted'
        initializing = 'initializing'
        idle = 'idle'
        move_away = 'move_away'
        cancel_dialog = 'cancel_dialog'
        init_done = 'init_done'
        calibration_failed = 'calibration_failed'
        user_abort = 'user_abort'
        approach_done = 'approach_done'
        max_out = 'max_out'
        move_toward = 'move_toward'
        process_dialog = 'process_dialog'
        approaching = 'approaching'
        limit_failed = 'limit_failed'
        timeout = 'timeout'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuApproachInstanceAttributeApproach_status.EnumType(self._context.call('root.lu.approach.instance.attribute.approach_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.approach.instance.attribute.approach_status.set_value', new_val.value)


class RootLuApproachInstanceAttributeCurrent_z_stage_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.current_z_stage_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.current_z_stage_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.current_z_stage_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.current_z_stage_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.current_z_stage_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.current_z_stage_pos.get_min'))



class RootLuApproachInstanceAttributeApproach_pos_error(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_pos_error'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.approach_pos_error.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.approach_pos_error.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_pos_error.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_pos_error.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_pos_error.get_min'))



class RootLuApproachInstanceAttributeStep_by_step_fine_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.get_min'))



class RootLuApproachInstanceAttributeStep_by_step_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.step_by_step_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.step_by_step_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_time.get_min'))



class RootLuApproachInstanceAttributeApproach_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.approach_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.approach_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_speed.get_min'))



class RootLuApproachInstanceAttributeStepper_direction(wrap.CmdTreeProp):

    class EnumType(Enum):
        forward = 'forward'
        backward = 'backward'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.stepper_direction'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuApproachInstanceAttributeStepper_direction.EnumType(self._context.call('root.lu.approach.instance.attribute.stepper_direction.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.approach.instance.attribute.stepper_direction.set_value', new_val.value)


class RootLuApproachInstanceAttributeStep_by_step_slope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.step_by_step_slope.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.step_by_step_slope.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_slope.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_slope.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_by_step_slope.get_min'))



class RootLuApproachInstanceAttributeStep_by_step_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        position_controlled = 'position_controlled'
        not_controlled = 'not_controlled'
        tip_position_ignored = 'tip_position_ignored'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuApproachInstanceAttributeStep_by_step_mode.EnumType(self._context.call('root.lu.approach.instance.attribute.step_by_step_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.approach.instance.attribute.step_by_step_mode.set_value', new_val.value)


class RootLuApproachInstanceAttributeEnable_pre_approach_xycl_calibration(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.get_min'))



class RootLuApproachInstanceAttributeRetract_tip(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.retract_tip'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.retract_tip.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.retract_tip.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.retract_tip.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.retract_tip.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.retract_tip.get_min'))



class RootLuApproachInstanceAttributeRelease_tip(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.release_tip'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.release_tip.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.release_tip.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.release_tip.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.release_tip.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.release_tip.get_min'))



class RootLuApproachInstanceAttributeMotor_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        internal = 'internal'
        external = 'external'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.motor_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuApproachInstanceAttributeMotor_source.EnumType(self._context.call('root.lu.approach.instance.attribute.motor_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.approach.instance.attribute.motor_source.set_value', new_val.value)


class RootLuApproachInstanceAttributeApproach_result(wrap.CmdTreeProp):

    class EnumType(Enum):
        no_error = 'no_error'
        approach_done = 'approach_done'
        end_of_travel = 'end_of_travel'
        sensor_error = 'sensor_error'
        limit_switch_error = 'limit_switch_error'
        user_abort = 'user_abort'
        tip_pos_adjust_done = 'tip_pos_adjust_done'
        tip_pos_adjust_failed = 'tip_pos_adjust_failed'
        park_position = 'park_position'
        timeout = 'timeout'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_result'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuApproachInstanceAttributeApproach_result.EnumType(self._context.call('root.lu.approach.instance.attribute.approach_result.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.approach.instance.attribute.approach_result.set_value', new_val.value)


class RootLuApproachInstanceAttributeApproach_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_steps'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.approach_steps.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.approach_steps.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_steps.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_steps.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_steps.get_min'))



class RootLuApproachInstanceAttributeStep_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.step_period.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.step_period.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.step_period.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_period.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.step_period.get_min'))



class RootLuApproachInstanceAttributeApproach_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.approach_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.approach_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.approach_pos.get_min'))



class RootLuApproachInstanceAttributeWithdraw_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.withdraw_steps'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.approach.instance.attribute.withdraw_steps.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.approach.instance.attribute.withdraw_steps.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.approach.instance.attribute.withdraw_steps.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.withdraw_steps.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.approach.instance.attribute.withdraw_steps.get_min'))



class RootLuApproachInstanceAttributeAfm_approach_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        continuous = 'continuous'
        step_by_step = 'step_by_step'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.afm_approach_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuApproachInstanceAttributeAfm_approach_mode.EnumType(self._context.call('root.lu.approach.instance.attribute.afm_approach_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.approach.instance.attribute.afm_approach_mode.set_value', new_val.value)


class RootLuApproachInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute'
        self.afm_approach_mode = RootLuApproachInstanceAttributeAfm_approach_mode(self._context)
        self.withdraw_steps = RootLuApproachInstanceAttributeWithdraw_steps(self._context)
        self.approach_pos = RootLuApproachInstanceAttributeApproach_pos(self._context)
        self.step_period = RootLuApproachInstanceAttributeStep_period(self._context)
        self.approach_steps = RootLuApproachInstanceAttributeApproach_steps(self._context)
        self.approach_result = RootLuApproachInstanceAttributeApproach_result(self._context)
        self.motor_source = RootLuApproachInstanceAttributeMotor_source(self._context)
        self.release_tip = RootLuApproachInstanceAttributeRelease_tip(self._context)
        self.retract_tip = RootLuApproachInstanceAttributeRetract_tip(self._context)
        self.enable_pre_approach_xycl_calibration = RootLuApproachInstanceAttributeEnable_pre_approach_xycl_calibration(self._context)
        self.step_by_step_mode = RootLuApproachInstanceAttributeStep_by_step_mode(self._context)
        self.step_by_step_slope = RootLuApproachInstanceAttributeStep_by_step_slope(self._context)
        self.stepper_direction = RootLuApproachInstanceAttributeStepper_direction(self._context)
        self.approach_speed = RootLuApproachInstanceAttributeApproach_speed(self._context)
        self.step_by_step_time = RootLuApproachInstanceAttributeStep_by_step_time(self._context)
        self.step_by_step_fine_step_size_percentage = RootLuApproachInstanceAttributeStep_by_step_fine_step_size_percentage(self._context)
        self.approach_pos_error = RootLuApproachInstanceAttributeApproach_pos_error(self._context)
        self.current_z_stage_pos = RootLuApproachInstanceAttributeCurrent_z_stage_pos(self._context)
        self.approach_status = RootLuApproachInstanceAttributeApproach_status(self._context)
        self.step_by_step_coarse_step_size_percentage = RootLuApproachInstanceAttributeStep_by_step_coarse_step_size_percentage(self._context)


class RootLuApproachInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger'

    def start_approach_afm(self, *args) -> Any:
        return self._context.call('root.lu.approach.instance.trigger.start_approach_afm', *args)

    def start_adjust_tip_pos(self, *args) -> Any:
        return self._context.call('root.lu.approach.instance.trigger.start_adjust_tip_pos', *args)

    def user_done(self, *args) -> Any:
        return self._context.call('root.lu.approach.instance.trigger.user_done', *args)

    def start_approach_steps(self, *args) -> Any:
        return self._context.call('root.lu.approach.instance.trigger.start_approach_steps', *args)

    def start_pre_approach(self, *args) -> Any:
        return self._context.call('root.lu.approach.instance.trigger.start_pre_approach', *args)

    def start_approach_motor(self, *args) -> Any:
        return self._context.call('root.lu.approach.instance.trigger.start_approach_motor', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.approach.instance.trigger.user_abort', *args)


class RootLuApproachInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance'
        self.trigger = RootLuApproachInstanceTrigger(self._context)
        self.attribute = RootLuApproachInstanceAttribute(self._context)
        self.busy = RootLuApproachInstanceBusy(self._context)


class RootLuApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach'
        self.instance = RootLuApproachInstance(self._context)


class RootLuSystem_infraInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.busy'


class RootLuSystem_infraInstanceAttributeHas_video_source_detection(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.has_video_source_detection'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.has_video_source_detection.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.has_video_source_detection.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.has_video_source_detection.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.has_video_source_detection.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.has_video_source_detection.get_min'))



class RootLuSystem_infraInstanceAttributeExtra_in1_input(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.extra_in1_input'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.extra_in1_input.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.extra_in1_input.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.extra_in1_input.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.extra_in1_input.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.extra_in1_input.get_min'))



class RootLuSystem_infraInstanceAttributeApproach_motor_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        undefined = 'undefined'
        limit_switches = 'limit_switches'
        position_sensor = 'position_sensor'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeApproach_motor_mode.EnumType(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.approach_motor_mode.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeFast_out2_output_mask(wrap.CmdTreeProp):

    class EnumType(Enum):
        none = 'none'
        monitor1 = 'monitor1'
        monitor2 = 'monitor2'
        tip_voltage_or_user_out_a = 'tip_voltage_or_user_out_a'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.fast_out2_output_mask'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeFast_out2_output_mask.EnumType(self._context.call('root.lu.system_infra.instance.attribute.fast_out2_output_mask.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.fast_out2_output_mask.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeCurrent_video_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        undefined = 'undefined'
        top_view = 'top_view'
        side_view = 'side_view'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_video_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeCurrent_video_source.EnumType(self._context.call('root.lu.system_infra.instance.attribute.current_video_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.current_video_source.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeLaser_power_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.laser_power_absolute.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.laser_power_absolute.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_absolute.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_absolute.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_absolute.get_min'))



class RootLuSystem_infraInstanceAttributeMain_in1_coupling(wrap.CmdTreeProp):

    class EnumType(Enum):
        ac_coupling = 'ac_coupling'
        dc_coupling = 'dc_coupling'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_coupling'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeMain_in1_coupling.EnumType(self._context.call('root.lu.system_infra.instance.attribute.main_in1_coupling.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.main_in1_coupling.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeMain_in2_input(wrap.CmdTreeProp):

    class EnumType(Enum):
        deflection = 'deflection'
        lateral = 'lateral'
        user1 = 'user1'
        user2 = 'user2'
        tip_current = 'tip_current'
        user3 = 'user3'
        test_ana_gnd = 'test_ana_gnd'
        test_ref = 'test_ref'
        test_tip_voltage = 'test_tip_voltage'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeMain_in2_input.EnumType(self._context.call('root.lu.system_infra.instance.attribute.main_in2_input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.main_in2_input.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeScan_head_type(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.scan_head_type'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.scan_head_type.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.scan_head_type.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.scan_head_type.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.scan_head_type.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.scan_head_type.get_min'))



class RootLuSystem_infraInstanceAttributeMain_in2_coupling(wrap.CmdTreeProp):

    class EnumType(Enum):
        ac_coupling = 'ac_coupling'
        dc_coupling = 'dc_coupling'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_coupling'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeMain_in2_coupling.EnumType(self._context.call('root.lu.system_infra.instance.attribute.main_in2_coupling.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.main_in2_coupling.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeEnable10_hz_update_sensor_status(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status.get_min'))



class RootLuSystem_infraInstanceAttributeTarget_clock_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        internal = 'internal'
        external = 'external'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.target_clock_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeTarget_clock_source.EnumType(self._context.call('root.lu.system_infra.instance.attribute.target_clock_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.target_clock_source.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_input(wrap.CmdTreeProp):

    class EnumType(Enum):
        tip_current = 'tip_current'
        in_user3 = 'in_user3'
        ana_gnd = 'ana_gnd'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_input.EnumType(self._context.call('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeDeflection_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.deflection_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.deflection_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.deflection_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.deflection_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.deflection_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.deflection_offset.get_min'))



class RootLuSystem_infraInstanceAttributeInterface_box_type(wrap.CmdTreeProp):

    class EnumType(Enum):
        unknown = 'unknown'
        not_connected = 'not_connected'
        i100 = 'i100'
        i100_afsem = 'i100_afsem'
        i100_integrated = 'i100_integrated'
        icxarac = 'icxarac'
        icxcytomass = 'icxcytomass'
        icxflex = 'icxflex'
        icxp6 = 'icxp6'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.interface_box_type'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeInterface_box_type.EnumType(self._context.call('root.lu.system_infra.instance.attribute.interface_box_type.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.interface_box_type.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeTip_signal_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        current_sense_input = 'current_sense_input'
        voltage_output = 'voltage_output'
        external_feedthrough = 'external_feedthrough'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_signal_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeTip_signal_mode.EnumType(self._context.call('root.lu.system_infra.instance.attribute.tip_signal_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.tip_signal_mode.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeSensor_light(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.sensor_light'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.sensor_light.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.sensor_light.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.sensor_light.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.sensor_light.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.sensor_light.get_min'))



class RootLuSystem_infraInstanceAttributeDepreciated_0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_0'


class RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_position(wrap.CmdTreeProp):

    class EnumType(Enum):
        undefined = 'undefined'
        working_pos = 'working_pos'
        open_pos = 'open_pos'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_scanhead_tilt_position'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_position.EnumType(self._context.call('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeApproach_motor_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        dummy_0 = 'dummy_0'
        in_range = 'in_range'
        min_in = 'min_in'
        max_out = 'max_out'
        not_connected = 'not_connected'
        error = 'error'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeApproach_motor_status.EnumType(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.approach_motor_status.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeHas_scanhead_tilt_detection(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection.get_min'))



class RootLuSystem_infraInstanceAttributeApproach_motor_status_normalized(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status_normalized'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_status_normalized.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.approach_motor_status_normalized.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_status_normalized.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_status_normalized.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_status_normalized.get_min'))



class RootLuSystem_infraInstanceAttributeApproach_motor_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_position.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.approach_motor_position.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_position.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_position.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.approach_motor_position.get_min'))



class RootLuSystem_infraInstanceAttributeDepreciated_1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_1'


class RootLuSystem_infraInstanceAttributeMain_in2_gain(wrap.CmdTreeProp):

    class EnumType(Enum):
        gain1 = 'gain1'
        gain4 = 'gain4'
        gain16 = 'gain16'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_gain'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeMain_in2_gain.EnumType(self._context.call('root.lu.system_infra.instance.attribute.main_in2_gain.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.main_in2_gain.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeController_type(wrap.CmdTreeProp):

    class EnumType(Enum):
        unknown = 'unknown'
        c3000 = 'c3000'
        core_afm = 'core_afm'
        cx = 'cx'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_type'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeController_type.EnumType(self._context.call('root.lu.system_infra.instance.attribute.controller_type.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.controller_type.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeLaser_power_lock(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_lock'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.laser_power_lock.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.laser_power_lock.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_lock.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_lock.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_lock.get_min'))



class RootLuSystem_infraInstanceAttributeControl_laser_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.control_laser_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.control_laser_power.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.control_laser_power.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.control_laser_power.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.control_laser_power.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.control_laser_power.get_min'))



class RootLuSystem_infraInstanceAttributeSensor_value_normalized(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.sensor_value_normalized'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.sensor_value_normalized.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.sensor_value_normalized.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.sensor_value_normalized.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.sensor_value_normalized.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.sensor_value_normalized.get_min'))



class RootLuSystem_infraInstanceAttributeCurrent_clock_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        internal = 'internal'
        external = 'external'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_clock_source'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeCurrent_clock_source.EnumType(self._context.call('root.lu.system_infra.instance.attribute.current_clock_source.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.current_clock_source.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeAfm_sensor_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        undefined = 'undefined'
        laser_power = 'laser_power'
        detector_intensity = 'detector_intensity'
        laser_drive = 'laser_drive'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeAfm_sensor_mode.EnumType(self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_mode.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeFriction_normalized(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.friction_normalized'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.friction_normalized.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.friction_normalized.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.friction_normalized.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.friction_normalized.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.friction_normalized.get_min'))



class RootLuSystem_infraInstanceAttributeMain_in1_gain(wrap.CmdTreeProp):

    class EnumType(Enum):
        gain1 = 'gain1'
        gain4 = 'gain4'
        gain16 = 'gain16'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_gain'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeMain_in1_gain.EnumType(self._context.call('root.lu.system_infra.instance.attribute.main_in1_gain.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.main_in1_gain.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeAfm_sensor_status_normalized(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status_normalized'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_status_normalized.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_status_normalized.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_status_normalized.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_status_normalized.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_status_normalized.get_min'))



class RootLuSystem_infraInstanceAttributeAfm_sensor_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        fail = 'fail'
        undefined = 'undefined'
        ok = 'ok'
        low = 'low'
        high = 'high'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuSystem_infraInstanceAttributeAfm_sensor_status.EnumType(self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.system_infra.instance.attribute.afm_sensor_status.set_value', new_val.value)


class RootLuSystem_infraInstanceAttributeController_temperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.controller_temperature.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.controller_temperature.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.controller_temperature.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.controller_temperature.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.controller_temperature.get_min'))



class RootLuSystem_infraInstanceAttributeDepreciated_2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_2'


class RootLuSystem_infraInstanceAttributeLaser_power_current(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_current'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.system_infra.instance.attribute.laser_power_current.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.system_infra.instance.attribute.laser_power_current.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_current.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_current.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.system_infra.instance.attribute.laser_power_current.get_min'))



class RootLuSystem_infraInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute'
        self.laser_power_current = RootLuSystem_infraInstanceAttributeLaser_power_current(self._context)
        self.depreciated_2 = RootLuSystem_infraInstanceAttributeDepreciated_2(self._context)
        self.controller_temperature = RootLuSystem_infraInstanceAttributeController_temperature(self._context)
        self.afm_sensor_status = RootLuSystem_infraInstanceAttributeAfm_sensor_status(self._context)
        self.afm_sensor_status_normalized = RootLuSystem_infraInstanceAttributeAfm_sensor_status_normalized(self._context)
        self.main_in1_gain = RootLuSystem_infraInstanceAttributeMain_in1_gain(self._context)
        self.friction_normalized = RootLuSystem_infraInstanceAttributeFriction_normalized(self._context)
        self.afm_sensor_mode = RootLuSystem_infraInstanceAttributeAfm_sensor_mode(self._context)
        self.current_clock_source = RootLuSystem_infraInstanceAttributeCurrent_clock_source(self._context)
        self.sensor_value_normalized = RootLuSystem_infraInstanceAttributeSensor_value_normalized(self._context)
        self.control_laser_power = RootLuSystem_infraInstanceAttributeControl_laser_power(self._context)
        self.laser_power_lock = RootLuSystem_infraInstanceAttributeLaser_power_lock(self._context)
        self.controller_type = RootLuSystem_infraInstanceAttributeController_type(self._context)
        self.main_in2_gain = RootLuSystem_infraInstanceAttributeMain_in2_gain(self._context)
        self.depreciated_1 = RootLuSystem_infraInstanceAttributeDepreciated_1(self._context)
        self.approach_motor_position = RootLuSystem_infraInstanceAttributeApproach_motor_position(self._context)
        self.approach_motor_status_normalized = RootLuSystem_infraInstanceAttributeApproach_motor_status_normalized(self._context)
        self.has_scanhead_tilt_detection = RootLuSystem_infraInstanceAttributeHas_scanhead_tilt_detection(self._context)
        self.approach_motor_status = RootLuSystem_infraInstanceAttributeApproach_motor_status(self._context)
        self.current_scanhead_tilt_position = RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_position(self._context)
        self.depreciated_0 = RootLuSystem_infraInstanceAttributeDepreciated_0(self._context)
        self.sensor_light = RootLuSystem_infraInstanceAttributeSensor_light(self._context)
        self.tip_signal_mode = RootLuSystem_infraInstanceAttributeTip_signal_mode(self._context)
        self.interface_box_type = RootLuSystem_infraInstanceAttributeInterface_box_type(self._context)
        self.deflection_offset = RootLuSystem_infraInstanceAttributeDeflection_offset(self._context)
        self.tip_current_or_in_user3_input = RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_input(self._context)
        self.target_clock_source = RootLuSystem_infraInstanceAttributeTarget_clock_source(self._context)
        self.enable10_hz_update_sensor_status = RootLuSystem_infraInstanceAttributeEnable10_hz_update_sensor_status(self._context)
        self.main_in2_coupling = RootLuSystem_infraInstanceAttributeMain_in2_coupling(self._context)
        self.scan_head_type = RootLuSystem_infraInstanceAttributeScan_head_type(self._context)
        self.main_in2_input = RootLuSystem_infraInstanceAttributeMain_in2_input(self._context)
        self.main_in1_coupling = RootLuSystem_infraInstanceAttributeMain_in1_coupling(self._context)
        self.laser_power_absolute = RootLuSystem_infraInstanceAttributeLaser_power_absolute(self._context)
        self.current_video_source = RootLuSystem_infraInstanceAttributeCurrent_video_source(self._context)
        self.fast_out2_output_mask = RootLuSystem_infraInstanceAttributeFast_out2_output_mask(self._context)
        self.approach_motor_mode = RootLuSystem_infraInstanceAttributeApproach_motor_mode(self._context)
        self.extra_in1_input = RootLuSystem_infraInstanceAttributeExtra_in1_input(self._context)
        self.has_video_source_detection = RootLuSystem_infraInstanceAttributeHas_video_source_detection(self._context)


class RootLuSystem_infraInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger'

    def switch_clock_source(self, *args) -> Any:
        return self._context.call('root.lu.system_infra.instance.trigger.switch_clock_source', *args)

    def detect_scan_head_arrival_removal(self, *args) -> Any:
        return self._context.call('root.lu.system_infra.instance.trigger.detect_scan_head_arrival_removal', *args)

    def detect_limit_switch_status_info_change(self, *args) -> Any:
        return self._context.call('root.lu.system_infra.instance.trigger.detect_limit_switch_status_info_change', *args)

    def detect_scan_head_lever_change(self, *args) -> Any:
        return self._context.call('root.lu.system_infra.instance.trigger.detect_scan_head_lever_change', *args)


class RootLuSystem_infraInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance'
        self.trigger = RootLuSystem_infraInstanceTrigger(self._context)
        self.attribute = RootLuSystem_infraInstanceAttribute(self._context)
        self.busy = RootLuSystem_infraInstanceBusy(self._context)


class RootLuSystem_infra(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra'
        self.instance = RootLuSystem_infraInstance(self._context)


class RootLuAnalog_fast_inCh2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.busy'


class RootLuAnalog_fast_inCh2AttributeCalib_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_inCh2AttributeCalib_polarity.EnumType(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_polarity.set_value', new_val.value)


class RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class EnumType(Enum):
        position_x = 'position_x'
        position_y = 'position_y'
        position_z = 'position_z'
        self = 'self'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_id.EnumType(self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.set_value', new_val.value)


class RootLuAnalog_fast_inCh2AttributeInput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.input_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.ch2.attribute.input_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_gain.get_min'))



class RootLuAnalog_fast_inCh2AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_gain.get_min'))



class RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec.get_vector', *args)


class RootLuAnalog_fast_inCh2AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.ch2.attribute.input_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.input_offset.get_min'))



class RootLuAnalog_fast_inCh2AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.ch2.attribute.current_input_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.ch2.attribute.current_input_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.current_input_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.current_input_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.current_input_value.get_min'))



class RootLuAnalog_fast_inCh2AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.ch2.attribute.calib_offset.get_min'))



class RootLuAnalog_fast_inCh2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute'
        self.calib_offset = RootLuAnalog_fast_inCh2AttributeCalib_offset(self._context)
        self.current_input_value = RootLuAnalog_fast_inCh2AttributeCurrent_input_value(self._context)
        self.input_offset = RootLuAnalog_fast_inCh2AttributeInput_offset(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_gain = RootLuAnalog_fast_inCh2AttributeCalib_gain(self._context)
        self.input_gain = RootLuAnalog_fast_inCh2AttributeInput_gain(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_id(self._context)
        self.calib_polarity = RootLuAnalog_fast_inCh2AttributeCalib_polarity(self._context)


class RootLuAnalog_fast_inCh2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.trigger'


class RootLuAnalog_fast_inCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2'
        self.trigger = RootLuAnalog_fast_inCh2Trigger(self._context)
        self.attribute = RootLuAnalog_fast_inCh2Attribute(self._context)
        self.busy = RootLuAnalog_fast_inCh2Busy(self._context)


class RootLuAnalog_fast_inDeflectionBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.busy'


class RootLuAnalog_fast_inDeflectionAttributeCalib_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_inDeflectionAttributeCalib_polarity.EnumType(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_polarity.set_value', new_val.value)


class RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class EnumType(Enum):
        position_x = 'position_x'
        position_y = 'position_y'
        position_z = 'position_z'
        self = 'self'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_id.EnumType(self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.set_value', new_val.value)


class RootLuAnalog_fast_inDeflectionAttributeInput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.input_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.deflection.attribute.input_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_gain.get_min'))



class RootLuAnalog_fast_inDeflectionAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_gain.get_min'))



class RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec.get_vector', *args)


class RootLuAnalog_fast_inDeflectionAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.deflection.attribute.input_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.input_offset.get_min'))



class RootLuAnalog_fast_inDeflectionAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.deflection.attribute.current_input_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.deflection.attribute.current_input_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.current_input_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.current_input_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.current_input_value.get_min'))



class RootLuAnalog_fast_inDeflectionAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.deflection.attribute.calib_offset.get_min'))



class RootLuAnalog_fast_inDeflectionAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute'
        self.calib_offset = RootLuAnalog_fast_inDeflectionAttributeCalib_offset(self._context)
        self.current_input_value = RootLuAnalog_fast_inDeflectionAttributeCurrent_input_value(self._context)
        self.input_offset = RootLuAnalog_fast_inDeflectionAttributeInput_offset(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_gain = RootLuAnalog_fast_inDeflectionAttributeCalib_gain(self._context)
        self.input_gain = RootLuAnalog_fast_inDeflectionAttributeInput_gain(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_id(self._context)
        self.calib_polarity = RootLuAnalog_fast_inDeflectionAttributeCalib_polarity(self._context)


class RootLuAnalog_fast_inDeflectionTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.trigger'


class RootLuAnalog_fast_inDeflection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection'
        self.trigger = RootLuAnalog_fast_inDeflectionTrigger(self._context)
        self.attribute = RootLuAnalog_fast_inDeflectionAttribute(self._context)
        self.busy = RootLuAnalog_fast_inDeflectionBusy(self._context)


class RootLuAnalog_fast_inUserBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.busy'


class RootLuAnalog_fast_inUserAttributeCalib_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_inUserAttributeCalib_polarity.EnumType(self._context.call('root.lu.analog_fast_in.user.attribute.calib_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_in.user.attribute.calib_polarity.set_value', new_val.value)


class RootLuAnalog_fast_inUserAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class EnumType(Enum):
        position_x = 'position_x'
        position_y = 'position_y'
        position_z = 'position_z'
        self = 'self'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAnalog_fast_inUserAttributeCross_coupling_axis_id.EnumType(self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.set_value', new_val.value)


class RootLuAnalog_fast_inUserAttributeInput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.input_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.user.attribute.input_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.user.attribute.input_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.input_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.input_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.input_gain.get_min'))



class RootLuAnalog_fast_inUserAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.user.attribute.calib_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.user.attribute.calib_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.calib_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.calib_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.calib_gain.get_min'))



class RootLuAnalog_fast_inUserAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec.get_vector', *args)


class RootLuAnalog_fast_inUserAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.user.attribute.input_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.user.attribute.input_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.input_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.input_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.input_offset.get_min'))



class RootLuAnalog_fast_inUserAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.user.attribute.current_input_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.user.attribute.current_input_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.current_input_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.current_input_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.current_input_value.get_min'))



class RootLuAnalog_fast_inUserAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.analog_fast_in.user.attribute.calib_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.analog_fast_in.user.attribute.calib_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.calib_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.calib_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.analog_fast_in.user.attribute.calib_offset.get_min'))



class RootLuAnalog_fast_inUserAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute'
        self.calib_offset = RootLuAnalog_fast_inUserAttributeCalib_offset(self._context)
        self.current_input_value = RootLuAnalog_fast_inUserAttributeCurrent_input_value(self._context)
        self.input_offset = RootLuAnalog_fast_inUserAttributeInput_offset(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_fast_inUserAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_gain = RootLuAnalog_fast_inUserAttributeCalib_gain(self._context)
        self.input_gain = RootLuAnalog_fast_inUserAttributeInput_gain(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_fast_inUserAttributeCross_coupling_axis_id(self._context)
        self.calib_polarity = RootLuAnalog_fast_inUserAttributeCalib_polarity(self._context)


class RootLuAnalog_fast_inUserTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.trigger'


class RootLuAnalog_fast_inUser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user'
        self.trigger = RootLuAnalog_fast_inUserTrigger(self._context)
        self.attribute = RootLuAnalog_fast_inUserAttribute(self._context)
        self.busy = RootLuAnalog_fast_inUserBusy(self._context)


class RootLuAnalog_fast_in(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in'
        self.user = RootLuAnalog_fast_inUser(self._context)
        self.deflection = RootLuAnalog_fast_inDeflection(self._context)
        self.ch2 = RootLuAnalog_fast_inCh2(self._context)


class RootLuAuto_alignmentInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.busy'


class RootLuAuto_alignmentInstanceAttributeAlign_state(wrap.CmdTreeProp):

    class EnumType(Enum):
        idle = 'idle'
        running = 'running'
        failed = 'failed'
        aligned_successfully = 'aligned_successfully'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.align_state'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAuto_alignmentInstanceAttributeAlign_state.EnumType(self._context.call('root.lu.auto_alignment.instance.attribute.align_state.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.auto_alignment.instance.attribute.align_state.set_value', new_val.value)


class RootLuAuto_alignmentInstanceAttributePte_optical_center_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.pte_optical_center_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.get_min'))



class RootLuAuto_alignmentInstanceAttributeComponent_state(wrap.CmdTreeProp):

    class EnumType(Enum):
        idle_not_positioned = 'idle_not_positioned'
        idle_positioned = 'idle_positioned'
        configuring = 'configuring'
        searching = 'searching'
        coarse_positioning_x = 'coarse_positioning_x'
        coarse_positioning_y = 'coarse_positioning_y'
        optimizing = 'optimizing'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.component_state'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAuto_alignmentInstanceAttributeComponent_state.EnumType(self._context.call('root.lu.auto_alignment.instance.attribute.component_state.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.auto_alignment.instance.attribute.component_state.set_value', new_val.value)


class RootLuAuto_alignmentInstanceAttributeReadout_optical_center_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.readout_optical_center_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.get_min'))



class RootLuAuto_alignmentInstanceAttributeCurrent_optic_component(wrap.CmdTreeProp):

    class EnumType(Enum):
        beam_shifter = 'beam_shifter'
        all = 'all'
        readout = 'readout'
        focus = 'focus'
        pte = 'pte'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.current_optic_component'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAuto_alignmentInstanceAttributeCurrent_optic_component.EnumType(self._context.call('root.lu.auto_alignment.instance.attribute.current_optic_component.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.auto_alignment.instance.attribute.current_optic_component.set_value', new_val.value)


class RootLuAuto_alignmentInstanceAttributeReadout_optical_center_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.readout_optical_center_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.get_min'))



class RootLuAuto_alignmentInstanceAttributePte_optical_center_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.pte_optical_center_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.get_min'))



class RootLuAuto_alignmentInstanceAttributeSearch_algorithm(wrap.CmdTreeProp):

    class EnumType(Enum):
        minimalistic = 'minimalistic'
        rhombus_spiral = 'rhombus_spiral'
        bottom_to_top_stepped = 'bottom_to_top_stepped'
        cantilever_between_two_reflecting_edges = 'cantilever_between_two_reflecting_edges'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.search_algorithm'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuAuto_alignmentInstanceAttributeSearch_algorithm.EnumType(self._context.call('root.lu.auto_alignment.instance.attribute.search_algorithm.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.auto_alignment.instance.attribute.search_algorithm.set_value', new_val.value)


class RootLuAuto_alignmentInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute'
        self.search_algorithm = RootLuAuto_alignmentInstanceAttributeSearch_algorithm(self._context)
        self.pte_optical_center_x = RootLuAuto_alignmentInstanceAttributePte_optical_center_x(self._context)
        self.readout_optical_center_y = RootLuAuto_alignmentInstanceAttributeReadout_optical_center_y(self._context)
        self.current_optic_component = RootLuAuto_alignmentInstanceAttributeCurrent_optic_component(self._context)
        self.readout_optical_center_x = RootLuAuto_alignmentInstanceAttributeReadout_optical_center_x(self._context)
        self.component_state = RootLuAuto_alignmentInstanceAttributeComponent_state(self._context)
        self.pte_optical_center_y = RootLuAuto_alignmentInstanceAttributePte_optical_center_y(self._context)
        self.align_state = RootLuAuto_alignmentInstanceAttributeAlign_state(self._context)


class RootLuAuto_alignmentInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.trigger'

    def start_align(self, *args) -> Any:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_align', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.auto_alignment.instance.trigger.user_abort', *args)

    def start_move_to_optical_center(self, *args) -> Any:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_move_to_optical_center', *args)

    def start_optimization(self, *args) -> Any:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_optimization', *args)

    def start_search_algorithm(self, *args) -> Any:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_search_algorithm', *args)


class RootLuAuto_alignmentInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance'
        self.trigger = RootLuAuto_alignmentInstanceTrigger(self._context)
        self.attribute = RootLuAuto_alignmentInstanceAttribute(self._context)
        self.busy = RootLuAuto_alignmentInstanceBusy(self._context)


class RootLuAuto_alignment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment'
        self.instance = RootLuAuto_alignmentInstance(self._context)


class RootLuOrtInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.busy'

    def is_averaging(self, *args) -> Any:
        return self._context.call('root.lu.ort.instance.busy.is_averaging', *args)


class RootLuOrtInstanceAttributeCantilever_samples_per_period(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuOrtInstanceAttributeCantilever_samples_per_period.EnumType(self._context.call('root.lu.ort.instance.attribute.cantilever_samples_per_period.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ort.instance.attribute.cantilever_samples_per_period.set_value', new_val.value)


class RootLuOrtInstanceAttributeFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.feedback_amplitude_position.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.feedback_amplitude_position.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.feedback_amplitude_position.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.feedback_amplitude_position.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.feedback_amplitude_position.get_min'))



class RootLuOrtInstanceAttributeMin_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.min_position.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.min_position.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.min_position.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.min_position.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.min_position.get_min'))



class RootLuOrtInstanceAttributeBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.baseline_window_end.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.baseline_window_end.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_window_end.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_window_end.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_window_end.get_min'))



class RootLuOrtInstanceAttributeAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.amplitude_reduction.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.amplitude_reduction.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.amplitude_reduction.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.amplitude_reduction.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.amplitude_reduction.get_min'))



class RootLuOrtInstanceAttributeBaseline_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.baseline_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.baseline_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_amplitude.get_min'))



class RootLuOrtInstanceAttributeInput_select(wrap.CmdTreeProp):

    class EnumType(Enum):
        fast_in_deflection = 'fast_in_deflection'
        hi_res_in_deflection = 'hi_res_in_deflection'
        fast_in_user = 'fast_in_user'
        hi_res_in_user1 = 'hi_res_in_user1'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.input_select'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuOrtInstanceAttributeInput_select.EnumType(self._context.call('root.lu.ort.instance.attribute.input_select.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ort.instance.attribute.input_select.set_value', new_val.value)


class RootLuOrtInstanceAttributeFree_wave_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.free_wave_delay.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.free_wave_delay.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.free_wave_delay.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.free_wave_delay.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.free_wave_delay.get_min'))



class RootLuOrtInstanceAttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.min_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.min_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.min_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.min_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.min_value.get_min'))



class RootLuOrtInstanceAttributeExcitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.excitation_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.excitation_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.excitation_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.excitation_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.excitation_amplitude.get_min'))



class RootLuOrtInstanceAttributeBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.baseline_window_begin.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.baseline_window_begin.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_window_begin.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_window_begin.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_window_begin.get_min'))



class RootLuOrtInstanceAttributeBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.baseline_frequency.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.baseline_frequency.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_frequency.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_frequency.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.baseline_frequency.get_min'))



class RootLuOrtInstanceAttributeSamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.samples_per_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.samples_per_period.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.samples_per_period.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.samples_per_period.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.samples_per_period.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.samples_per_period.get_min'))



class RootLuOrtInstanceAttributeFree_wave_output_state(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_output_state'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuOrtInstanceAttributeFree_wave_output_state.EnumType(self._context.call('root.lu.ort.instance.attribute.free_wave_output_state.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ort.instance.attribute.free_wave_output_state.set_value', new_val.value)


class RootLuOrtInstanceAttributeAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.average_periods'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.ort.instance.attribute.average_periods.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.ort.instance.attribute.average_periods.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.ort.instance.attribute.average_periods.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.average_periods.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.ort.instance.attribute.average_periods.get_min'))



class RootLuOrtInstanceAttributeBaseline_controller_state(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_controller_state'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuOrtInstanceAttributeBaseline_controller_state.EnumType(self._context.call('root.lu.ort.instance.attribute.baseline_controller_state.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.ort.instance.attribute.baseline_controller_state.set_value', new_val.value)


class RootLuOrtInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute'
        self.baseline_controller_state = RootLuOrtInstanceAttributeBaseline_controller_state(self._context)
        self.average_periods = RootLuOrtInstanceAttributeAverage_periods(self._context)
        self.free_wave_output_state = RootLuOrtInstanceAttributeFree_wave_output_state(self._context)
        self.samples_per_period = RootLuOrtInstanceAttributeSamples_per_period(self._context)
        self.baseline_frequency = RootLuOrtInstanceAttributeBaseline_frequency(self._context)
        self.baseline_window_begin = RootLuOrtInstanceAttributeBaseline_window_begin(self._context)
        self.excitation_amplitude = RootLuOrtInstanceAttributeExcitation_amplitude(self._context)
        self.min_value = RootLuOrtInstanceAttributeMin_value(self._context)
        self.free_wave_delay = RootLuOrtInstanceAttributeFree_wave_delay(self._context)
        self.input_select = RootLuOrtInstanceAttributeInput_select(self._context)
        self.baseline_amplitude = RootLuOrtInstanceAttributeBaseline_amplitude(self._context)
        self.amplitude_reduction = RootLuOrtInstanceAttributeAmplitude_reduction(self._context)
        self.baseline_window_end = RootLuOrtInstanceAttributeBaseline_window_end(self._context)
        self.min_position = RootLuOrtInstanceAttributeMin_position(self._context)
        self.feedback_amplitude_position = RootLuOrtInstanceAttributeFeedback_amplitude_position(self._context)
        self.cantilever_samples_per_period = RootLuOrtInstanceAttributeCantilever_samples_per_period(self._context)


class RootLuOrtInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger'

    def apply_samples_per_period(self, *args) -> Any:
        return self._context.call('root.lu.ort.instance.trigger.apply_samples_per_period', *args)

    def process_averaged_samples(self, *args) -> Any:
        return self._context.call('root.lu.ort.instance.trigger.process_averaged_samples', *args)

    def apply_samples_values(self, *args) -> Any:
        return self._context.call('root.lu.ort.instance.trigger.apply_samples_values', *args)

    def update_free_wave(self, *args) -> Any:
        return self._context.call('root.lu.ort.instance.trigger.update_free_wave', *args)

    def average_start(self, *args) -> Any:
        return self._context.call('root.lu.ort.instance.trigger.average_start', *args)

    def average_stop(self, *args) -> Any:
        return self._context.call('root.lu.ort.instance.trigger.average_stop', *args)


class RootLuOrtInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance'
        self.trigger = RootLuOrtInstanceTrigger(self._context)
        self.attribute = RootLuOrtInstanceAttribute(self._context)
        self.busy = RootLuOrtInstanceBusy(self._context)


class RootLuOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort'
        self.instance = RootLuOrtInstance(self._context)


class RootLuScanInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.busy'


class RootLuScanInstanceAttributeGenerator(wrap.CmdTreeProp):

    class EnumType(Enum):
        linear_line = 'linear_line'
        generic_line = 'generic_line'
        generic_frame = 'generic_frame'
        generic_frame_fast = 'generic_frame_fast'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.generator'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanInstanceAttributeGenerator.EnumType(self._context.call('root.lu.scan.instance.attribute.generator.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scan.instance.attribute.generator.set_value', new_val.value)


class RootLuScanInstanceAttributeOverscan_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.overscan_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.overscan_points.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.overscan_points.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.overscan_points.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.overscan_points.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.overscan_points.get_min'))



class RootLuScanInstanceAttributeSlow_increment(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_increment'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.slow_increment.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.slow_increment.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_increment.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_increment.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_increment.get_min'))



class RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.get_min'))



class RootLuScanInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.xy_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.xy_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.xy_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.xy_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.xy_move_speed.get_min'))



class RootLuScanInstanceAttributeY_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.y_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.y_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.y_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.y_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.y_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.y_offset.get_min'))



class RootLuScanInstanceAttributeZ_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.z_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.z_rotation.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.z_rotation.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.z_rotation.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.z_rotation.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.z_rotation.get_min'))



class RootLuScanInstanceAttributeScan_direction_slow_axis(wrap.CmdTreeProp):

    class EnumType(Enum):
        downward = 'downward'
        upward = 'upward'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.scan_direction_slow_axis'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanInstanceAttributeScan_direction_slow_axis.EnumType(self._context.call('root.lu.scan.instance.attribute.scan_direction_slow_axis.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scan.instance.attribute.scan_direction_slow_axis.set_value', new_val.value)


class RootLuScanInstanceAttributeLine_z_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.line_z_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.line_z_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.line_z_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.line_z_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.line_z_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.line_z_offset.get_min'))



class RootLuScanInstanceAttributeSlow_axis_move_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        stepwise = 'stepwise'
        serpentine = 'serpentine'
        continuous = 'continuous'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_axis_move_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanInstanceAttributeSlow_axis_move_mode.EnumType(self._context.call('root.lu.scan.instance.attribute.slow_axis_move_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scan.instance.attribute.slow_axis_move_mode.set_value', new_val.value)


class RootLuScanInstanceAttributeSnd_scan_enable_dark_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_enable_dark_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.get_min'))



class RootLuScanInstanceAttributeSlow_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.slow_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.slow_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_range.get_min'))



class RootLuScanInstanceAttributeLine_scanning(wrap.CmdTreeProp):

    class EnumType(Enum):
        standard = 'standard'
        dual_scan = 'dual_scan'
        interlaced = 'interlaced'
        snd_scan_only = 'snd_scan_only'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.line_scanning'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanInstanceAttributeLine_scanning.EnumType(self._context.call('root.lu.scan.instance.attribute.line_scanning.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scan.instance.attribute.line_scanning.set_value', new_val.value)


class RootLuScanInstanceAttributeTime_per_line(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.time_per_line'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.time_per_line.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.time_per_line.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.time_per_line.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.time_per_line.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.time_per_line.get_min'))



class RootLuScanInstanceAttributeSnd_scan_enable_kpfm(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_enable_kpfm'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.get_min'))



class RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.get_min'))



class RootLuScanInstanceAttributeContour_data_channel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.contour_data_channel'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.contour_data_channel.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.contour_data_channel.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.contour_data_channel.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.contour_data_channel.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.contour_data_channel.get_min'))



class RootLuScanInstanceAttributeAuto_readjust_probe_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.auto_readjust_probe_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.get_min'))



class RootLuScanInstanceAttributeMove_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        controlled = 'controlled'
        lifted = 'lifted'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.move_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanInstanceAttributeMove_mode.EnumType(self._context.call('root.lu.scan.instance.attribute.move_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scan.instance.attribute.move_mode.set_value', new_val.value)


class RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.get_min'))



class RootLuScanInstanceAttributeContour_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.contour_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.contour_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.contour_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.contour_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.contour_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.contour_enabled.get_min'))



class RootLuScanInstanceAttributeBackward_fast_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.backward_fast_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.backward_fast_points.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.backward_fast_points.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.backward_fast_points.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.backward_fast_points.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.backward_fast_points.get_min'))



class RootLuScanInstanceAttributeReadjust_lift_height(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.readjust_lift_height'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.readjust_lift_height.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.readjust_lift_height.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.readjust_lift_height.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.readjust_lift_height.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.readjust_lift_height.get_min'))



class RootLuScanInstanceAttributeSlow_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.slow_points.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.slow_points.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_points.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_points.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.slow_points.get_min'))



class RootLuScanInstanceAttributeZ_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.z_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.z_move_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.z_move_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.z_move_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.z_move_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.z_move_speed.get_min'))



class RootLuScanInstanceAttributeLinearization_enable(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.linearization_enable'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanInstanceAttributeLinearization_enable.EnumType(self._context.call('root.lu.scan.instance.attribute.linearization_enable.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scan.instance.attribute.linearization_enable.set_value', new_val.value)


class RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.get_min'))



class RootLuScanInstanceAttributeX_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.x_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.x_rotation.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.x_rotation.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.x_rotation.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.x_rotation.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.x_rotation.get_min'))



class RootLuScanInstanceAttributeY_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.y_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.y_rotation.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.y_rotation.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.y_rotation.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.y_rotation.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.y_rotation.get_min'))



class RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.get_min'))



class RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.get_min'))



class RootLuScanInstanceAttributeFast_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.fast_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.fast_points.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.fast_points.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.fast_points.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.fast_points.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.fast_points.get_min'))



class RootLuScanInstanceAttributeFast_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.fast_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.fast_range.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.fast_range.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.fast_range.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.fast_range.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.fast_range.get_min'))



class RootLuScanInstanceAttributeX_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.x_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.x_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.x_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.x_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.x_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.x_offset.get_min'))



class RootLuScanInstanceAttributeFirst_line_repetition(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.first_line_repetition'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.first_line_repetition.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.first_line_repetition.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.first_line_repetition.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.first_line_repetition.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.first_line_repetition.get_min'))



class RootLuScanInstanceAttributeZ_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.z_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scan.instance.attribute.z_offset.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scan.instance.attribute.z_offset.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scan.instance.attribute.z_offset.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.z_offset.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scan.instance.attribute.z_offset.get_min'))



class RootLuScanInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute'
        self.z_offset = RootLuScanInstanceAttributeZ_offset(self._context)
        self.first_line_repetition = RootLuScanInstanceAttributeFirst_line_repetition(self._context)
        self.x_offset = RootLuScanInstanceAttributeX_offset(self._context)
        self.fast_range = RootLuScanInstanceAttributeFast_range(self._context)
        self.fast_points = RootLuScanInstanceAttributeFast_points(self._context)
        self.snd_scan_snd_lock_in_excitation_amplitude = RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude(self._context)
        self.snd_scan_snd_lock_in_excitation_amplitude_enabled = RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude_enabled(self._context)
        self.y_rotation = RootLuScanInstanceAttributeY_rotation(self._context)
        self.x_rotation = RootLuScanInstanceAttributeX_rotation(self._context)
        self.snd_scan_force_modulation_amplitude_enabled = RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude_enabled(self._context)
        self.linearization_enable = RootLuScanInstanceAttributeLinearization_enable(self._context)
        self.z_move_speed = RootLuScanInstanceAttributeZ_move_speed(self._context)
        self.slow_points = RootLuScanInstanceAttributeSlow_points(self._context)
        self.readjust_lift_height = RootLuScanInstanceAttributeReadjust_lift_height(self._context)
        self.backward_fast_points = RootLuScanInstanceAttributeBackward_fast_points(self._context)
        self.contour_enabled = RootLuScanInstanceAttributeContour_enabled(self._context)
        self.snd_scan_dynamic_amplitude = RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude(self._context)
        self.move_mode = RootLuScanInstanceAttributeMove_mode(self._context)
        self.auto_readjust_probe_enabled = RootLuScanInstanceAttributeAuto_readjust_probe_enabled(self._context)
        self.contour_data_channel = RootLuScanInstanceAttributeContour_data_channel(self._context)
        self.snd_scan_dynamic_amplitude_enabled = RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude_enabled(self._context)
        self.snd_scan_enable_kpfm = RootLuScanInstanceAttributeSnd_scan_enable_kpfm(self._context)
        self.time_per_line = RootLuScanInstanceAttributeTime_per_line(self._context)
        self.line_scanning = RootLuScanInstanceAttributeLine_scanning(self._context)
        self.slow_range = RootLuScanInstanceAttributeSlow_range(self._context)
        self.snd_scan_enable_dark_mode = RootLuScanInstanceAttributeSnd_scan_enable_dark_mode(self._context)
        self.slow_axis_move_mode = RootLuScanInstanceAttributeSlow_axis_move_mode(self._context)
        self.line_z_offset = RootLuScanInstanceAttributeLine_z_offset(self._context)
        self.scan_direction_slow_axis = RootLuScanInstanceAttributeScan_direction_slow_axis(self._context)
        self.z_rotation = RootLuScanInstanceAttributeZ_rotation(self._context)
        self.y_offset = RootLuScanInstanceAttributeY_offset(self._context)
        self.xy_move_speed = RootLuScanInstanceAttributeXy_move_speed(self._context)
        self.snd_scan_force_modulation_amplitude = RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude(self._context)
        self.slow_increment = RootLuScanInstanceAttributeSlow_increment(self._context)
        self.overscan_points = RootLuScanInstanceAttributeOverscan_points(self._context)
        self.generator = RootLuScanInstanceAttributeGenerator(self._context)


class RootLuScanInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.trigger'

    def start_move_to_start_and_do_frame_quick(self, *args) -> Any:
        return self._context.call('root.lu.scan.instance.trigger.start_move_to_start_and_do_frame_quick', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.scan.instance.trigger.user_abort', *args)

    def start_move_to_start_and_do_frame(self, *args) -> Any:
        return self._context.call('root.lu.scan.instance.trigger.start_move_to_start_and_do_frame', *args)

    def start_move_to_start(self, *args) -> Any:
        return self._context.call('root.lu.scan.instance.trigger.start_move_to_start', *args)

    def offset_xyz(self, *args) -> Any:
        return self._context.call('root.lu.scan.instance.trigger.offset_xyz', *args)

    def start_do_frame(self, *args) -> Any:
        return self._context.call('root.lu.scan.instance.trigger.start_do_frame', *args)

    def do_set_xy_sensor_data_acquisition(self, *args) -> Any:
        return self._context.call('root.lu.scan.instance.trigger.do_set_xy_sensor_data_acquisition', *args)


class RootLuScanInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance'
        self.trigger = RootLuScanInstanceTrigger(self._context)
        self.attribute = RootLuScanInstanceAttribute(self._context)
        self.busy = RootLuScanInstanceBusy(self._context)


class RootLuScan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan'
        self.instance = RootLuScanInstance(self._context)


class RootLuDirect_motor_controlInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.busy'


class RootLuDirect_motor_controlInstanceAttributeCurrent_axis(wrap.CmdTreeProp):

    class EnumType(Enum):
        all = 'all'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.current_axis'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuDirect_motor_controlInstanceAttributeCurrent_axis.EnumType(self._context.call('root.lu.direct_motor_control.instance.attribute.current_axis.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.direct_motor_control.instance.attribute.current_axis.set_value', new_val.value)


class RootLuDirect_motor_controlInstanceAttributeAxis_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        idle_unreferenced = 'idle_unreferenced'
        idle_referenced = 'idle_referenced'
        referencing = 'referencing'
        moving = 'moving'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuDirect_motor_controlInstanceAttributeAxis_status.EnumType(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.direct_motor_control.instance.attribute.axis_status.set_value', new_val.value)


class RootLuDirect_motor_controlInstanceAttributeTransaction_move_destination(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.transaction_move_destination'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.direct_motor_control.instance.attribute.transaction_move_destination.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.direct_motor_control.instance.attribute.transaction_move_destination.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.transaction_move_destination.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.transaction_move_destination.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.transaction_move_destination.get_min'))



class RootLuDirect_motor_controlInstanceAttributeAxis_last_reference_move_distance(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_last_reference_move_distance'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_last_reference_move_distance.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.direct_motor_control.instance.attribute.axis_last_reference_move_distance.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_last_reference_move_distance.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_last_reference_move_distance.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_last_reference_move_distance.get_min'))



class RootLuDirect_motor_controlInstanceAttributeTransaction_move_relative(wrap.CmdTreeProp):

    class EnumType(Enum):
        absolute = 'absolute'
        relative = 'relative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.transaction_move_relative'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuDirect_motor_controlInstanceAttributeTransaction_move_relative.EnumType(self._context.call('root.lu.direct_motor_control.instance.attribute.transaction_move_relative.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.direct_motor_control.instance.attribute.transaction_move_relative.set_value', new_val.value)


class RootLuDirect_motor_controlInstanceAttributeAxis_limit_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        in_no_limit = 'in_no_limit'
        in_upper_limit = 'in_upper_limit'
        in_lower_limit = 'in_lower_limit'
        in_both_limits = 'in_both_limits'
        in_limit = 'in_limit'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_limit_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuDirect_motor_controlInstanceAttributeAxis_limit_status.EnumType(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_limit_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.direct_motor_control.instance.attribute.axis_limit_status.set_value', new_val.value)


class RootLuDirect_motor_controlInstanceAttributeAxis_speed_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_speed_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_speed_factor.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.direct_motor_control.instance.attribute.axis_speed_factor.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_speed_factor.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_speed_factor.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_speed_factor.get_min'))



class RootLuDirect_motor_controlInstanceAttributeMove_adjust(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.move_adjust'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.direct_motor_control.instance.attribute.move_adjust.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.direct_motor_control.instance.attribute.move_adjust.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.move_adjust.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.move_adjust.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.move_adjust.get_min'))



class RootLuDirect_motor_controlInstanceAttributeLayout_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        uninitialized = 'uninitialized'
        initialized = 'initialized'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.layout_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuDirect_motor_controlInstanceAttributeLayout_status.EnumType(self._context.call('root.lu.direct_motor_control.instance.attribute.layout_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.direct_motor_control.instance.attribute.layout_status.set_value', new_val.value)


class RootLuDirect_motor_controlInstanceAttributeCurrent_layout(wrap.CmdTreeProp):

    class EnumType(Enum):
        all = 'all'
        p6 = 'p6'
        dummy2 = 'dummy2'
        dummy3 = 'dummy3'
        dummy4 = 'dummy4'
        sim = 'sim'
        core = 'core'
        arac = 'arac'
        p6_mount = 'p6_mount'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.current_layout'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuDirect_motor_controlInstanceAttributeCurrent_layout.EnumType(self._context.call('root.lu.direct_motor_control.instance.attribute.current_layout.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.direct_motor_control.instance.attribute.current_layout.set_value', new_val.value)


class RootLuDirect_motor_controlInstanceAttributeAxis_max_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_max_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_max_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.direct_motor_control.instance.attribute.axis_max_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_max_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_max_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_max_speed.get_min'))



class RootLuDirect_motor_controlInstanceAttributeAxis_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute.axis_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_position.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.direct_motor_control.instance.attribute.axis_position.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_position.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_position.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.direct_motor_control.instance.attribute.axis_position.get_min'))



class RootLuDirect_motor_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.attribute'
        self.axis_position = RootLuDirect_motor_controlInstanceAttributeAxis_position(self._context)
        self.axis_max_speed = RootLuDirect_motor_controlInstanceAttributeAxis_max_speed(self._context)
        self.current_layout = RootLuDirect_motor_controlInstanceAttributeCurrent_layout(self._context)
        self.layout_status = RootLuDirect_motor_controlInstanceAttributeLayout_status(self._context)
        self.move_adjust = RootLuDirect_motor_controlInstanceAttributeMove_adjust(self._context)
        self.axis_speed_factor = RootLuDirect_motor_controlInstanceAttributeAxis_speed_factor(self._context)
        self.axis_limit_status = RootLuDirect_motor_controlInstanceAttributeAxis_limit_status(self._context)
        self.transaction_move_relative = RootLuDirect_motor_controlInstanceAttributeTransaction_move_relative(self._context)
        self.axis_last_reference_move_distance = RootLuDirect_motor_controlInstanceAttributeAxis_last_reference_move_distance(self._context)
        self.transaction_move_destination = RootLuDirect_motor_controlInstanceAttributeTransaction_move_destination(self._context)
        self.axis_status = RootLuDirect_motor_controlInstanceAttributeAxis_status(self._context)
        self.current_axis = RootLuDirect_motor_controlInstanceAttributeCurrent_axis(self._context)


class RootLuDirect_motor_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance.trigger'

    def commit_transaction(self, *args) -> Any:
        return self._context.call('root.lu.direct_motor_control.instance.trigger.commit_transaction', *args)

    def position_zero_axis(self, *args) -> Any:
        return self._context.call('root.lu.direct_motor_control.instance.trigger.position_zero_axis', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.direct_motor_control.instance.trigger.user_abort', *args)

    def reset_transaction(self, *args) -> Any:
        return self._context.call('root.lu.direct_motor_control.instance.trigger.reset_transaction', *args)

    def search_reference(self, *args) -> Any:
        return self._context.call('root.lu.direct_motor_control.instance.trigger.search_reference', *args)

    def add_transaction_move(self, *args) -> Any:
        return self._context.call('root.lu.direct_motor_control.instance.trigger.add_transaction_move', *args)


class RootLuDirect_motor_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control.instance'
        self.trigger = RootLuDirect_motor_controlInstanceTrigger(self._context)
        self.attribute = RootLuDirect_motor_controlInstanceAttribute(self._context)
        self.busy = RootLuDirect_motor_controlInstanceBusy(self._context)


class RootLuDirect_motor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.direct_motor_control'
        self.instance = RootLuDirect_motor_controlInstance(self._context)


class RootLuSequencerInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.busy'

    def is_running(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.busy.is_running', *args)


class RootLuSequencerInstanceAttributeInstruction_pointer(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.instruction_pointer'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.sequencer.instance.attribute.instruction_pointer.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.sequencer.instance.attribute.instruction_pointer.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.sequencer.instance.attribute.instruction_pointer.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.sequencer.instance.attribute.instruction_pointer.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.sequencer.instance.attribute.instruction_pointer.get_min'))



class RootLuSequencerInstanceAttributeStatus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.status'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.sequencer.instance.attribute.status.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.sequencer.instance.attribute.status.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.sequencer.instance.attribute.status.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.sequencer.instance.attribute.status.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.sequencer.instance.attribute.status.get_min'))



class RootLuSequencerInstanceAttributeMemory_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.memory_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.attribute.memory_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.attribute.memory_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.attribute.memory_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.attribute.memory_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.attribute.memory_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.attribute.memory_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.attribute.memory_vec.get_vector', *args)


class RootLuSequencerInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute'
        self.memory_vec = RootLuSequencerInstanceAttributeMemory_vec(self._context)
        self.status = RootLuSequencerInstanceAttributeStatus(self._context)
        self.instruction_pointer = RootLuSequencerInstanceAttributeInstruction_pointer(self._context)


class RootLuSequencerInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.trigger'

    def start(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.trigger.start', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.trigger.abort', *args)

    def step(self, *args) -> Any:
        return self._context.call('root.lu.sequencer.instance.trigger.step', *args)


class RootLuSequencerInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance'
        self.trigger = RootLuSequencerInstanceTrigger(self._context)
        self.attribute = RootLuSequencerInstanceAttribute(self._context)
        self.busy = RootLuSequencerInstanceBusy(self._context)


class RootLuSequencer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer'
        self.instance = RootLuSequencerInstance(self._context)


class RootLuScanheadInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.busy'


class RootLuScanheadInstanceAttributeHas_z_sensor(wrap.CmdTreeProp):

    class EnumType(Enum):
        no = 'no'
        yes = 'yes'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_z_sensor'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanheadInstanceAttributeHas_z_sensor.EnumType(self._context.call('root.lu.scanhead.instance.attribute.has_z_sensor.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scanhead.instance.attribute.has_z_sensor.set_value', new_val.value)


class RootLuScanheadInstanceAttributeReadout_laser_power_monitor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_power_monitor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.get_min'))



class RootLuScanheadInstanceAttributeFast_in2_channel(wrap.CmdTreeProp):

    class EnumType(Enum):
        friction_channel = 'friction_channel'
        addon_in = 'addon_in'
        pte_monitor = 'pte_monitor'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.fast_in2_channel'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanheadInstanceAttributeFast_in2_channel.EnumType(self._context.call('root.lu.scanhead.instance.attribute.fast_in2_channel.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scanhead.instance.attribute.fast_in2_channel.set_value', new_val.value)


class RootLuScanheadInstanceAttributeReadout_laser_setpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_setpoint.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scanhead.instance.attribute.readout_laser_setpoint.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_setpoint.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_setpoint.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.readout_laser_setpoint.get_min'))



class RootLuScanheadInstanceAttributeTilt_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        override = 'override'
        measured = 'measured'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanheadInstanceAttributeTilt_mode.EnumType(self._context.call('root.lu.scanhead.instance.attribute.tilt_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scanhead.instance.attribute.tilt_mode.set_value', new_val.value)


class RootLuScanheadInstanceAttributeType(wrap.CmdTreeProp):

    class EnumType(Enum):
        not_connected = 'not_connected'
        unknown = 'unknown'
        e_stm = 'e_stm'
        dummy3 = 'dummy3'
        dummy4 = 'dummy4'
        dummy5 = 'dummy5'
        dummy6 = 'dummy6'
        dummy7 = 'dummy7'
        dummy8 = 'dummy8'
        e_afm = 'e_afm'
        dummy10 = 'dummy10'
        dummy11 = 'dummy11'
        nanite_afm = 'nanite_afm'
        afsem = 'afsem'
        flex_afm = 'flex_afm'
        lens_afm = 'lens_afm'
        semafm = 'semafm'
        arac = 'arac'
        p6 = 'p6'
        core_afm = 'core_afm'
        cytomass = 'cytomass'
        p6_mount = 'p6_mount'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.type'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanheadInstanceAttributeType.EnumType(self._context.call('root.lu.scanhead.instance.attribute.type.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scanhead.instance.attribute.type.set_value', new_val.value)


class RootLuScanheadInstanceAttributePte_laser_power_monitor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_power_monitor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.get_min'))



class RootLuScanheadInstanceAttributeTilt_angle_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_x.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_x.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_x.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_x.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_x.get_min'))



class RootLuScanheadInstanceAttributeHas_xy_sensor(wrap.CmdTreeProp):

    class EnumType(Enum):
        no = 'no'
        yes = 'yes'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_xy_sensor'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuScanheadInstanceAttributeHas_xy_sensor.EnumType(self._context.call('root.lu.scanhead.instance.attribute.has_xy_sensor.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.scanhead.instance.attribute.has_xy_sensor.set_value', new_val.value)


class RootLuScanheadInstanceAttributePte_laser_setpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_setpoint.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scanhead.instance.attribute.pte_laser_setpoint.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_setpoint.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_setpoint.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.pte_laser_setpoint.get_min'))



class RootLuScanheadInstanceAttributeTilt_angle_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_y.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_y.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_y.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_y.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.scanhead.instance.attribute.tilt_angle_y.get_min'))



class RootLuScanheadInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute'
        self.tilt_angle_y = RootLuScanheadInstanceAttributeTilt_angle_y(self._context)
        self.pte_laser_setpoint = RootLuScanheadInstanceAttributePte_laser_setpoint(self._context)
        self.has_xy_sensor = RootLuScanheadInstanceAttributeHas_xy_sensor(self._context)
        self.tilt_angle_x = RootLuScanheadInstanceAttributeTilt_angle_x(self._context)
        self.pte_laser_power_monitor = RootLuScanheadInstanceAttributePte_laser_power_monitor(self._context)
        self.type = RootLuScanheadInstanceAttributeType(self._context)
        self.tilt_mode = RootLuScanheadInstanceAttributeTilt_mode(self._context)
        self.readout_laser_setpoint = RootLuScanheadInstanceAttributeReadout_laser_setpoint(self._context)
        self.fast_in2_channel = RootLuScanheadInstanceAttributeFast_in2_channel(self._context)
        self.readout_laser_power_monitor = RootLuScanheadInstanceAttributeReadout_laser_power_monitor(self._context)
        self.has_z_sensor = RootLuScanheadInstanceAttributeHas_z_sensor(self._context)


class RootLuScanheadInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger'

    def enable_pte_laser(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_pte_laser', *args)

    def disable_readout_laser(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_readout_laser', *args)

    def enable_electro_thermal_excitation(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_electro_thermal_excitation', *args)

    def apply_tilt_mode(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.apply_tilt_mode', *args)

    def disable_piezo_electric_excitation(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_piezo_electric_excitation', *args)

    def disable_electro_thermal_excitation(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_electro_thermal_excitation', *args)

    def disable_pte_laser(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_pte_laser', *args)

    def enable_piezo_electric_excitation(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_piezo_electric_excitation', *args)

    def enable_readout_laser(self, *args) -> Any:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_readout_laser', *args)


class RootLuScanheadInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance'
        self.trigger = RootLuScanheadInstanceTrigger(self._context)
        self.attribute = RootLuScanheadInstanceAttribute(self._context)
        self.busy = RootLuScanheadInstanceBusy(self._context)


class RootLuScanhead(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead'
        self.instance = RootLuScanheadInstance(self._context)


class RootLuThermal_tuningInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.busy'


class RootLuThermal_tuningInstanceAttributeBuffer_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.attribute.buffer_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.thermal_tuning.instance.attribute.buffer_group_id.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.thermal_tuning.instance.attribute.buffer_group_id.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.thermal_tuning.instance.attribute.buffer_group_id.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.thermal_tuning.instance.attribute.buffer_group_id.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.thermal_tuning.instance.attribute.buffer_group_id.get_min'))



class RootLuThermal_tuningInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.attribute'
        self.buffer_group_id = RootLuThermal_tuningInstanceAttributeBuffer_group_id(self._context)


class RootLuThermal_tuningInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.trigger'

    def start_block(self, *args) -> Any:
        return self._context.call('root.lu.thermal_tuning.instance.trigger.start_block', *args)

    def user_abort(self, *args) -> Any:
        return self._context.call('root.lu.thermal_tuning.instance.trigger.user_abort', *args)


class RootLuThermal_tuningInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance'
        self.trigger = RootLuThermal_tuningInstanceTrigger(self._context)
        self.attribute = RootLuThermal_tuningInstanceAttribute(self._context)
        self.busy = RootLuThermal_tuningInstanceBusy(self._context)


class RootLuThermal_tuning(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning'
        self.instance = RootLuThermal_tuningInstance(self._context)


class RootLuTimerDbg1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.busy'

    def is_busy(self, *args) -> Any:
        return self._context.call('root.lu.timer.dbg1.busy.is_busy', *args)


class RootLuTimerDbg1AttributeCurrent_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.current_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.dbg1.attribute.current_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.dbg1.attribute.current_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.dbg1.attribute.current_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.current_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.current_time.get_min'))



class RootLuTimerDbg1AttributeMode(wrap.CmdTreeProp):

    class EnumType(Enum):
        delay_timer = 'delay_timer'
        event_counter = 'event_counter'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuTimerDbg1AttributeMode.EnumType(self._context.call('root.lu.timer.dbg1.attribute.mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.timer.dbg1.attribute.mode.set_value', new_val.value)


class RootLuTimerDbg1AttributeDelay_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.delay_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.dbg1.attribute.delay_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.dbg1.attribute.delay_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.dbg1.attribute.delay_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.delay_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.delay_time.get_min'))



class RootLuTimerDbg1AttributeCounter_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.counter_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.dbg1.attribute.counter_max.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.dbg1.attribute.counter_max.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.dbg1.attribute.counter_max.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.counter_max.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.counter_max.get_min'))



class RootLuTimerDbg1AttributeCounter_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.counter_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.dbg1.attribute.counter_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.dbg1.attribute.counter_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.dbg1.attribute.counter_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.counter_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.dbg1.attribute.counter_value.get_min'))



class RootLuTimerDbg1AttributeCounter_input(wrap.CmdTreeProp):

    class EnumType(Enum):
        digital_sync1 = 'digital_sync1'
        digital_sync2 = 'digital_sync2'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.counter_input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuTimerDbg1AttributeCounter_input.EnumType(self._context.call('root.lu.timer.dbg1.attribute.counter_input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.timer.dbg1.attribute.counter_input.set_value', new_val.value)


class RootLuTimerDbg1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute'
        self.counter_input = RootLuTimerDbg1AttributeCounter_input(self._context)
        self.counter_value = RootLuTimerDbg1AttributeCounter_value(self._context)
        self.counter_max = RootLuTimerDbg1AttributeCounter_max(self._context)
        self.delay_time = RootLuTimerDbg1AttributeDelay_time(self._context)
        self.mode = RootLuTimerDbg1AttributeMode(self._context)
        self.current_time = RootLuTimerDbg1AttributeCurrent_time(self._context)


class RootLuTimerDbg1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.trigger'

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.timer.dbg1.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.timer.dbg1.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.timer.dbg1.trigger.start', *args)


class RootLuTimerDbg1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1'
        self.trigger = RootLuTimerDbg1Trigger(self._context)
        self.attribute = RootLuTimerDbg1Attribute(self._context)
        self.busy = RootLuTimerDbg1Busy(self._context)


class RootLuTimerProc0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.busy'

    def is_busy(self, *args) -> Any:
        return self._context.call('root.lu.timer.proc0.busy.is_busy', *args)


class RootLuTimerProc0AttributeCurrent_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.current_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.proc0.attribute.current_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.proc0.attribute.current_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.proc0.attribute.current_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.current_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.current_time.get_min'))



class RootLuTimerProc0AttributeMode(wrap.CmdTreeProp):

    class EnumType(Enum):
        delay_timer = 'delay_timer'
        event_counter = 'event_counter'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuTimerProc0AttributeMode.EnumType(self._context.call('root.lu.timer.proc0.attribute.mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.timer.proc0.attribute.mode.set_value', new_val.value)


class RootLuTimerProc0AttributeDelay_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.delay_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.proc0.attribute.delay_time.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.proc0.attribute.delay_time.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.proc0.attribute.delay_time.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.delay_time.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.delay_time.get_min'))



class RootLuTimerProc0AttributeCounter_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.counter_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.proc0.attribute.counter_max.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.proc0.attribute.counter_max.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.proc0.attribute.counter_max.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.counter_max.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.counter_max.get_min'))



class RootLuTimerProc0AttributeCounter_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.counter_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.timer.proc0.attribute.counter_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.timer.proc0.attribute.counter_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.timer.proc0.attribute.counter_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.counter_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.timer.proc0.attribute.counter_value.get_min'))



class RootLuTimerProc0AttributeCounter_input(wrap.CmdTreeProp):

    class EnumType(Enum):
        digital_sync1 = 'digital_sync1'
        digital_sync2 = 'digital_sync2'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.counter_input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuTimerProc0AttributeCounter_input.EnumType(self._context.call('root.lu.timer.proc0.attribute.counter_input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.timer.proc0.attribute.counter_input.set_value', new_val.value)


class RootLuTimerProc0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute'
        self.counter_input = RootLuTimerProc0AttributeCounter_input(self._context)
        self.counter_value = RootLuTimerProc0AttributeCounter_value(self._context)
        self.counter_max = RootLuTimerProc0AttributeCounter_max(self._context)
        self.delay_time = RootLuTimerProc0AttributeDelay_time(self._context)
        self.mode = RootLuTimerProc0AttributeMode(self._context)
        self.current_time = RootLuTimerProc0AttributeCurrent_time(self._context)


class RootLuTimerProc0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.trigger'

    def stop(self, *args) -> Any:
        return self._context.call('root.lu.timer.proc0.trigger.stop', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.lu.timer.proc0.trigger.abort', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.lu.timer.proc0.trigger.start', *args)


class RootLuTimerProc0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0'
        self.trigger = RootLuTimerProc0Trigger(self._context)
        self.attribute = RootLuTimerProc0Attribute(self._context)
        self.busy = RootLuTimerProc0Busy(self._context)


class RootLuTimer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer'
        self.proc0 = RootLuTimerProc0(self._context)
        self.dbg1 = RootLuTimerDbg1(self._context)


class RootLuZ_controller_exInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.busy'


class RootLuZ_controller_exInstanceAttributeDifferential_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.differential_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.differential_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.differential_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.differential_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.differential_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.differential_gain.get_min'))



class RootLuZ_controller_exInstanceAttributeClosed_loop_polarity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_polarity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_polarity.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_polarity.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_polarity.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_polarity.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_polarity.get_min'))



class RootLuZ_controller_exInstanceAttributeSet_point_modulation_enable(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeSet_point_modulation_enable.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeCurrent_status_flags(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_status_flags'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_status_flags.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_status_flags.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_status_flags.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_status_flags.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_status_flags.get_min'))



class RootLuZ_controller_exInstanceAttributeClosed_loop_p_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_p_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_p_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_p_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_p_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_p_gain.get_min'))



class RootLuZ_controller_exInstanceAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.filter_coeff_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.filter_coeff_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.filter_coeff_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.filter_coeff_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.filter_coeff_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.filter_coeff_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.filter_coeff_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.filter_coeff_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributeDdc_filter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributeDdc_filter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ddc_filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_number.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_number.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_number.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_number.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_number.get_min'))



class RootLuZ_controller_exInstanceAttributeInput_compare_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        equal_or_higher_than = 'equal_or_higher_than'
        equal_or_lower_than = 'equal_or_lower_than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.input_compare_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeInput_compare_mode.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.input_compare_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.input_compare_mode.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeMax_z_current_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.max_z_current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_current_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_current_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_current_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_current_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_current_value.get_min'))



class RootLuZ_controller_exInstanceAttributeMax_z_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.max_z_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value.get_min'))



class RootLuZ_controller_exInstanceAttributeCurrent_feedback_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        in_range = 'in_range'
        max_retracted = 'max_retracted'
        max_extended = 'max_extended'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_feedback_status'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeCurrent_feedback_status.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.current_feedback_status.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_feedback_status.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeBase_line_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.base_line_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.base_line_pos.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.base_line_pos.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.base_line_pos.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.base_line_pos.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.base_line_pos.get_min'))



class RootLuZ_controller_exInstanceAttributePhase_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_count.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.phase_count.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_count.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_count.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_count.get_min'))



class RootLuZ_controller_exInstanceAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeMemory_signal_gen_drive_enable.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeBase_work_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        z_closed_loop = 'z_closed_loop'
        z_drive = 'z_drive'
        z_feedback = 'z_feedback'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.base_work_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeBase_work_mode.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.base_work_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.base_work_mode.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeOutput_modulation_enable(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_modulation_enable'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeOutput_modulation_enable.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.output_modulation_enable.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.output_modulation_enable.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributePhase_real_end_pos_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributePhase_move_mode_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.enum'


class RootLuZ_controller_exInstanceAttributePhase_move_mode_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec'
        self.enum = RootLuZ_controller_exInstanceAttributePhase_move_mode_vecEnum(self._context)

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.get_vector_value', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.set_vector', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.set_vector_value', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributePhase_move_time_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_time_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_time_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_time_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_time_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_time_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_time_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_time_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_time_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributePhase_move_value_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_value_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_value_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_value_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_value_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_value_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_value_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_value_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_value_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributeMax_z_value_change_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.max_z_value_change_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value_change_speed.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value_change_speed.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value_change_speed.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value_change_speed.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.max_z_value_change_speed.get_min'))



class RootLuZ_controller_exInstanceAttributePhase_work_mode_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum'


class RootLuZ_controller_exInstanceAttributePhase_work_mode_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec'
        self.enum = RootLuZ_controller_exInstanceAttributePhase_work_mode_vecEnum(self._context)

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.get_vector_value', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.set_vector', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.set_vector_value', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributeCurrent_pid_command_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_pid_command_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_pid_command_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_pid_command_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_pid_command_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_pid_command_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_pid_command_value.get_min'))



class RootLuZ_controller_exInstanceAttributeProportional_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.proportional_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.proportional_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.proportional_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.proportional_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.proportional_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.proportional_gain.get_min'))



class RootLuZ_controller_exInstanceAttributeIntegral_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.integral_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.integral_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.integral_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.integral_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.integral_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.integral_gain.get_min'))



class RootLuZ_controller_exInstanceAttributeSet_point(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.set_point'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.set_point.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.set_point.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.set_point.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.set_point.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.set_point.get_min'))



class RootLuZ_controller_exInstanceAttributeDdc_filter_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ddc_filter_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_rate.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_rate.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_rate.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_rate.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.ddc_filter_rate.get_min'))



class RootLuZ_controller_exInstanceAttributeCurrent_limited_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_limited_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_limited_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_limited_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_limited_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_limited_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_limited_value.get_min'))



class RootLuZ_controller_exInstanceAttributeCurrent_input_filtered_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_input_filtered_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_filtered_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_filtered_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_filtered_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_filtered_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_filtered_value.get_min'))



class RootLuZ_controller_exInstanceAttributeFeedback_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.feedback_polarity'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeFeedback_polarity.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.feedback_polarity.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.feedback_polarity.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeTarget_output_channel(wrap.CmdTreeProp):

    class EnumType(Enum):
        out_position_z = 'out_position_z'
        out_external_z = 'out_external_z'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.target_output_channel'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeTarget_output_channel.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.target_output_channel.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.target_output_channel.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeOutput_compare_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_compare_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.output_compare_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.output_compare_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.output_compare_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.output_compare_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.output_compare_value.get_min'))



class RootLuZ_controller_exInstanceAttributeZ_controller_adjust_timed_out(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.z_controller_adjust_timed_out'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.z_controller_adjust_timed_out.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.z_controller_adjust_timed_out.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.z_controller_adjust_timed_out.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.z_controller_adjust_timed_out.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.z_controller_adjust_timed_out.get_min'))



class RootLuZ_controller_exInstanceAttributeInput_compare_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.input_compare_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.input_compare_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.input_compare_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.input_compare_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.input_compare_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.input_compare_value.get_min'))



class RootLuZ_controller_exInstanceAttributeMin_z_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.min_z_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.min_z_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.min_z_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.min_z_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.min_z_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.min_z_value.get_min'))



class RootLuZ_controller_exInstanceAttributeActive_pid_gain_set(wrap.CmdTreeProp):

    class EnumType(Enum):
        out_position_z = 'out_position_z'
        out_external_z = 'out_external_z'
        user = 'user'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.active_pid_gain_set'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeActive_pid_gain_set.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeCurrent_phase(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_phase'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_phase.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_phase.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_phase.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_phase.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_phase.get_min'))



class RootLuZ_controller_exInstanceAttributeCurrent_error_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_error_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_error_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_error_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_error_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_error_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_error_value.get_min'))



class RootLuZ_controller_exInstanceAttributePhase_move_stop_by_value_active_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributeCurrent_output_channel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_output_channel'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_output_channel.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_output_channel.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_output_channel.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_output_channel.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_output_channel.get_min'))



class RootLuZ_controller_exInstanceAttributeOutput_compare_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        equal_or_higher_than = 'equal_or_higher_than'
        equal_or_lower_than = 'equal_or_lower_than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_compare_mode'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeOutput_compare_mode.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.output_compare_mode.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.output_compare_mode.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeClosed_loop_d_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_d_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_d_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_d_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_d_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_d_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_d_gain.get_min'))



class RootLuZ_controller_exInstanceAttributeMemory_signal_gen_position_enable(wrap.CmdTreeProp):

    class EnumType(Enum):
        disabled = 'disabled'
        enabled = 'enabled'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeMemory_signal_gen_position_enable.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributeCtrl_input(wrap.CmdTreeProp):

    class EnumType(Enum):
        in_deflection = 'in_deflection'
        in_lateral = 'in_lateral'
        in_position_z = 'in_position_z'
        in_user1 = 'in_user1'
        in_user2 = 'in_user2'
        in_user3 = 'in_user3'
        in_user4 = 'in_user4'
        in_tip_current = 'in_tip_current'
        analyzer1_amplitude = 'analyzer1_amplitude'
        analyzer1_phase = 'analyzer1_phase'
        analyzer1_ctrl_amplitude = 'analyzer1_ctrl_amplitude'
        analyzer1_ctrl_delta_f = 'analyzer1_ctrl_delta_f'
        analyzer2_amplitude = 'analyzer2_amplitude'
        analyzer2_phase = 'analyzer2_phase'
        analyzer2_ctrl_amplitude = 'analyzer2_ctrl_amplitude'
        analyzer2_ctrl_delta_f = 'analyzer2_ctrl_delta_f'
        ort_amplitude_reduction = 'ort_amplitude_reduction'
        static = 'static'
        gen_test_dynamic = 'gen_test_dynamic'
        ramp_gen_test = 'ramp_gen_test'
        in_position_x = 'in_position_x'
        in_position_y = 'in_position_y'
        in_detector_sum = 'in_detector_sum'
        in6 = 'in6'
        memory_gen_position_x = 'memory_gen_position_x'
        memory_gen_drive_x = 'memory_gen_drive_x'
        memory_gen_position_y = 'memory_gen_position_y'
        memory_gen_drive_y = 'memory_gen_drive_y'
        memory_gen_position_z = 'memory_gen_position_z'
        memory_gen_drive_z = 'memory_gen_drive_z'
        memory_gen_out7 = 'memory_gen_out7'
        memory_gen_out8 = 'memory_gen_out8'
        ramp_gen_approach = 'ramp_gen_approach'
        ramp_gen_position_x = 'ramp_gen_position_x'
        ramp_gen_position_y = 'ramp_gen_position_y'
        ramp_gen_tip_voltage = 'ramp_gen_tip_voltage'
        ramp_gen_alternate_z = 'ramp_gen_alternate_z'
        ramp_gen_user4 = 'ramp_gen_user4'
        ramp_gen_plane_z = 'ramp_gen_plane_z'
        ramp_gen_ctrl_z = 'ramp_gen_ctrl_z'
        ramp_gen_max_z = 'ramp_gen_max_z'
        ctrl_z_in = 'ctrl_z_in'
        ctrl_z_error = 'ctrl_z_error'
        ctrl_z_pid_command = 'ctrl_z_pid_command'
        ctrl_z_sum = 'ctrl_z_sum'
        ctrl_z_nominal = 'ctrl_z_nominal'
        ctrl_z_out = 'ctrl_z_out'
        ctrl_x_out = 'ctrl_x_out'
        ctrl_y_out = 'ctrl_y_out'
        ctrl_w_out = 'ctrl_w_out'
        ctrl_user1_out = 'ctrl_user1_out'
        ctrl_user2_out = 'ctrl_user2_out'
        analyzer1_x = 'analyzer1_x'
        analyzer1_y = 'analyzer1_y'
        analyzer2_x = 'analyzer2_x'
        analyzer2_y = 'analyzer2_y'
        ort_baseline = 'ort_baseline'
        ort_baseline_corrected = 'ort_baseline_corrected'
        ort_adhesion_value = 'ort_adhesion_value'
        ort_adhesion_position = 'ort_adhesion_position'
        fast_in_deflection = 'fast_in_deflection'
        fast_in2 = 'fast_in2'
        fast_in_user = 'fast_in_user'
        analyzer1_reference = 'analyzer1_reference'
        analyzer2_reference = 'analyzer2_reference'
        ort_excitation = 'ort_excitation'
        ort_free_wave = 'ort_free_wave'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ctrl_input'
        self._lua_value_type = wrap.LuaType('EnumType')

    @property
    def value(self) -> EnumType:
        return RootLuZ_controller_exInstanceAttributeCtrl_input.EnumType(self._context.call('root.lu.z_controller_ex.instance.attribute.ctrl_input.get_value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.call('root.lu.z_controller_ex.instance.attribute.ctrl_input.set_value', new_val.value)


class RootLuZ_controller_exInstanceAttributePhase_move_speed_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributePhase_move_end_mode_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum'


class RootLuZ_controller_exInstanceAttributePhase_move_end_mode_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec'
        self.enum = RootLuZ_controller_exInstanceAttributePhase_move_end_mode_vecEnum(self._context)

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.get_vector_value', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.set_vector', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.set_vector_value', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributePhase_pause_time_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec'

    def get_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec.get_vector_value', *args)

    def get_max(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec.get_max', *args)

    def set_vector_value(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec.set_vector_value', *args)

    def get_min(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec.get_min', *args)

    def get_unit(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec.get_unit', *args)

    def set_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec.set_vector', *args)

    def get_vector(self, *args) -> Any:
        return self._context.call('root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec.get_vector', *args)


class RootLuZ_controller_exInstanceAttributeClosed_loop_i_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_i_gain.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_i_gain.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_i_gain.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_i_gain.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.closed_loop_i_gain.get_min'))



class RootLuZ_controller_exInstanceAttributePhase_init_phase_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_init_phase_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_init_phase_count.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.phase_init_phase_count.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_init_phase_count.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_init_phase_count.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.phase_init_phase_count.get_min'))



class RootLuZ_controller_exInstanceAttributeNumber_of_pid_gain_sets(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.number_of_pid_gain_sets'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.number_of_pid_gain_sets.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.number_of_pid_gain_sets.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.number_of_pid_gain_sets.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.number_of_pid_gain_sets.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.number_of_pid_gain_sets.get_min'))



class RootLuZ_controller_exInstanceAttributeCurrent_sum_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_sum_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_sum_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_sum_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_sum_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_sum_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_sum_value.get_min'))



class RootLuZ_controller_exInstanceAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_value.get_unit'))

    @property
    def max(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_value.get_max'))

    @property
    def min(self) -> float:
        return str(self._context.call('root.lu.z_controller_ex.instance.attribute.current_input_value.get_min'))



class RootLuZ_controller_exInstanceAttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.call('root.lu.z_controller_ex.instance.attribute.current_output_value.get_value'))

    @value.setter
    def value(self, new_val:float):
        self._context.call('root.lu.z_controller_ex.instance.attribute.current_output_value.set_value', float(new_val))

    @property
    def unit(self) -> str:
        r