from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="guardrails-security",
    version="1.0.0",
    author="GuardRails Team",
    author_email="team@guardrails.dev",
    description="AI-powered security scanner for modern development workflows",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/guardrails/guardrails-security",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Security",
        "Topic :: Software Development :: Quality Assurance",
        "Topic :: Software Development :: Testing",
    ],
    python_requires=">=3.8",
    install_requires=[
        "requests>=2.25.0",
        "click>=8.0.0",
        "colorama>=0.4.4",
        "rich>=10.0.0",
        "pyyaml>=5.4.0",
    ],
    extras_require={
        "dev": [
            "pytest>=6.0.0",
            "pytest-cov>=2.10.0",
            "black>=21.0.0",
            "flake8>=3.8.0",
            "mypy>=0.800",
        ],
    },
    entry_points={
        "console_scripts": [
            "guardrails=guardrails.cli:main",
        ],
    },
    keywords="security, scanner, vulnerability, ai, gemini, devsecops, code-analysis",
    project_urls={
        "Bug Reports": "https://github.com/guardrails/guardrails-security/issues",
        "Source": "https://github.com/guardrails/guardrails-security",
        "Documentation": "https://docs.guardrails.dev",
        "Homepage": "https://guardrails.dev",
    },
)
