from mtmai.crewai.memory.entity.entity_memory_item import EntityMemoryItem
from mtmai.crewai.memory.memory import Memory
from mtmai.crewai.memory.storage.rag_storage import RAGStorage


class EntityMemory(Memory):
    """
    EntityMemory class for managing structured information about entities
    and their relationships using SQLite storage.
    Inherits from the Memory class.
    """

    def __init__(self, crew=None, embedder_config=None, storage=None):
        storage = (
            storage
            if storage
            else RAGStorage(
                type="entities",
                allow_reset=False,
                embedder_config=embedder_config,
                crew=crew,
            )
        )
        super().__init__(storage)

    def save(self, item: EntityMemoryItem) -> None:  # type: ignore # BUG?: Signature of "save" incompatible with supertype "Memory"
        """Saves an entity item into the SQLite storage."""
        data = f"{item.name}({item.type}): {item.description}"
        super().save(data, item.metadata)

    def reset(self) -> None:
        try:
            self.storage.reset()
        except Exception as e:
            raise Exception(f"An error occurred while resetting the entity memory: {e}")
