# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpIntegrationsArgs', 'GcpIntegrations']

@pulumi.input_type
class GcpIntegrationsArgs:
    def __init__(__self__, *,
                 linked_account_id: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 alloy_db: Optional[pulumi.Input['GcpIntegrationsAlloyDbArgs']] = None,
                 app_engine: Optional[pulumi.Input['GcpIntegrationsAppEngineArgs']] = None,
                 big_query: Optional[pulumi.Input['GcpIntegrationsBigQueryArgs']] = None,
                 big_table: Optional[pulumi.Input['GcpIntegrationsBigTableArgs']] = None,
                 composer: Optional[pulumi.Input['GcpIntegrationsComposerArgs']] = None,
                 data_flow: Optional[pulumi.Input['GcpIntegrationsDataFlowArgs']] = None,
                 data_proc: Optional[pulumi.Input['GcpIntegrationsDataProcArgs']] = None,
                 data_store: Optional[pulumi.Input['GcpIntegrationsDataStoreArgs']] = None,
                 fire_base_database: Optional[pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs']] = None,
                 fire_base_hosting: Optional[pulumi.Input['GcpIntegrationsFireBaseHostingArgs']] = None,
                 fire_base_storage: Optional[pulumi.Input['GcpIntegrationsFireBaseStorageArgs']] = None,
                 fire_store: Optional[pulumi.Input['GcpIntegrationsFireStoreArgs']] = None,
                 functions: Optional[pulumi.Input['GcpIntegrationsFunctionsArgs']] = None,
                 interconnect: Optional[pulumi.Input['GcpIntegrationsInterconnectArgs']] = None,
                 kubernetes: Optional[pulumi.Input['GcpIntegrationsKubernetesArgs']] = None,
                 load_balancing: Optional[pulumi.Input['GcpIntegrationsLoadBalancingArgs']] = None,
                 mem_cache: Optional[pulumi.Input['GcpIntegrationsMemCacheArgs']] = None,
                 pub_sub: Optional[pulumi.Input['GcpIntegrationsPubSubArgs']] = None,
                 redis: Optional[pulumi.Input['GcpIntegrationsRedisArgs']] = None,
                 router: Optional[pulumi.Input['GcpIntegrationsRouterArgs']] = None,
                 run: Optional[pulumi.Input['GcpIntegrationsRunArgs']] = None,
                 spanner: Optional[pulumi.Input['GcpIntegrationsSpannerArgs']] = None,
                 sql: Optional[pulumi.Input['GcpIntegrationsSqlArgs']] = None,
                 storage: Optional[pulumi.Input['GcpIntegrationsStorageArgs']] = None,
                 virtual_machines: Optional[pulumi.Input['GcpIntegrationsVirtualMachinesArgs']] = None,
                 vpc_access: Optional[pulumi.Input['GcpIntegrationsVpcAccessArgs']] = None):
        """
        The set of arguments for constructing a GcpIntegrations resource.
        :param pulumi.Input[builtins.str] linked_account_id: The ID of the linked GCP account in New Relic.
               
               The following arguments/integration blocks are intended to be used with a minimum `metrics_polling_interval` of 300 seconds.
        :param pulumi.Input[builtins.str] account_id: The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input['GcpIntegrationsAlloyDbArgs'] alloy_db: Alloy DB integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsAppEngineArgs'] app_engine: App Engine integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsBigQueryArgs'] big_query: Biq Query integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsBigTableArgs'] big_table: Big Table. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsComposerArgs'] composer: Composer integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsDataFlowArgs'] data_flow: Data Flow integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsDataProcArgs'] data_proc: Data Proc integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsDataStoreArgs'] data_store: Data Store integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs'] fire_base_database: Fire Base Database integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireBaseHostingArgs'] fire_base_hosting: Fire Base Hosting integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireBaseStorageArgs'] fire_base_storage: Fire Base Storage integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireStoreArgs'] fire_store: Fire Store integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFunctionsArgs'] functions: Functions integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsInterconnectArgs'] interconnect: Interconnect integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsKubernetesArgs'] kubernetes: Kubernetes integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsLoadBalancingArgs'] load_balancing: Load Balancing integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsMemCacheArgs'] mem_cache: Mem cache integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsPubSubArgs'] pub_sub: Pub/Sub integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsRedisArgs'] redis: Redis integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsRouterArgs'] router: Router integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsRunArgs'] run: Run integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsSpannerArgs'] spanner: Spanner integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsSqlArgs'] sql: SQL integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsStorageArgs'] storage: Storage integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsVirtualMachinesArgs'] virtual_machines: Virtual machines integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsVpcAccessArgs'] vpc_access: VPC Access integration. See Integration blocks below for details.
        """
        pulumi.set(__self__, "linked_account_id", linked_account_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if alloy_db is not None:
            pulumi.set(__self__, "alloy_db", alloy_db)
        if app_engine is not None:
            pulumi.set(__self__, "app_engine", app_engine)
        if big_query is not None:
            pulumi.set(__self__, "big_query", big_query)
        if big_table is not None:
            pulumi.set(__self__, "big_table", big_table)
        if composer is not None:
            pulumi.set(__self__, "composer", composer)
        if data_flow is not None:
            pulumi.set(__self__, "data_flow", data_flow)
        if data_proc is not None:
            pulumi.set(__self__, "data_proc", data_proc)
        if data_store is not None:
            pulumi.set(__self__, "data_store", data_store)
        if fire_base_database is not None:
            pulumi.set(__self__, "fire_base_database", fire_base_database)
        if fire_base_hosting is not None:
            pulumi.set(__self__, "fire_base_hosting", fire_base_hosting)
        if fire_base_storage is not None:
            pulumi.set(__self__, "fire_base_storage", fire_base_storage)
        if fire_store is not None:
            pulumi.set(__self__, "fire_store", fire_store)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if interconnect is not None:
            pulumi.set(__self__, "interconnect", interconnect)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if mem_cache is not None:
            pulumi.set(__self__, "mem_cache", mem_cache)
        if pub_sub is not None:
            pulumi.set(__self__, "pub_sub", pub_sub)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if run is not None:
            pulumi.set(__self__, "run", run)
        if spanner is not None:
            pulumi.set(__self__, "spanner", spanner)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter(name="linkedAccountId")
    def linked_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the linked GCP account in New Relic.

        The following arguments/integration blocks are intended to be used with a minimum `metrics_polling_interval` of 300 seconds.
        """
        return pulumi.get(self, "linked_account_id")

    @linked_account_id.setter
    def linked_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "linked_account_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="alloyDb")
    def alloy_db(self) -> Optional[pulumi.Input['GcpIntegrationsAlloyDbArgs']]:
        """
        Alloy DB integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "alloy_db")

    @alloy_db.setter
    def alloy_db(self, value: Optional[pulumi.Input['GcpIntegrationsAlloyDbArgs']]):
        pulumi.set(self, "alloy_db", value)

    @property
    @pulumi.getter(name="appEngine")
    def app_engine(self) -> Optional[pulumi.Input['GcpIntegrationsAppEngineArgs']]:
        """
        App Engine integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "app_engine")

    @app_engine.setter
    def app_engine(self, value: Optional[pulumi.Input['GcpIntegrationsAppEngineArgs']]):
        pulumi.set(self, "app_engine", value)

    @property
    @pulumi.getter(name="bigQuery")
    def big_query(self) -> Optional[pulumi.Input['GcpIntegrationsBigQueryArgs']]:
        """
        Biq Query integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "big_query")

    @big_query.setter
    def big_query(self, value: Optional[pulumi.Input['GcpIntegrationsBigQueryArgs']]):
        pulumi.set(self, "big_query", value)

    @property
    @pulumi.getter(name="bigTable")
    def big_table(self) -> Optional[pulumi.Input['GcpIntegrationsBigTableArgs']]:
        """
        Big Table. See Integration blocks below for details.
        """
        return pulumi.get(self, "big_table")

    @big_table.setter
    def big_table(self, value: Optional[pulumi.Input['GcpIntegrationsBigTableArgs']]):
        pulumi.set(self, "big_table", value)

    @property
    @pulumi.getter
    def composer(self) -> Optional[pulumi.Input['GcpIntegrationsComposerArgs']]:
        """
        Composer integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "composer")

    @composer.setter
    def composer(self, value: Optional[pulumi.Input['GcpIntegrationsComposerArgs']]):
        pulumi.set(self, "composer", value)

    @property
    @pulumi.getter(name="dataFlow")
    def data_flow(self) -> Optional[pulumi.Input['GcpIntegrationsDataFlowArgs']]:
        """
        Data Flow integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_flow")

    @data_flow.setter
    def data_flow(self, value: Optional[pulumi.Input['GcpIntegrationsDataFlowArgs']]):
        pulumi.set(self, "data_flow", value)

    @property
    @pulumi.getter(name="dataProc")
    def data_proc(self) -> Optional[pulumi.Input['GcpIntegrationsDataProcArgs']]:
        """
        Data Proc integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_proc")

    @data_proc.setter
    def data_proc(self, value: Optional[pulumi.Input['GcpIntegrationsDataProcArgs']]):
        pulumi.set(self, "data_proc", value)

    @property
    @pulumi.getter(name="dataStore")
    def data_store(self) -> Optional[pulumi.Input['GcpIntegrationsDataStoreArgs']]:
        """
        Data Store integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_store")

    @data_store.setter
    def data_store(self, value: Optional[pulumi.Input['GcpIntegrationsDataStoreArgs']]):
        pulumi.set(self, "data_store", value)

    @property
    @pulumi.getter(name="fireBaseDatabase")
    def fire_base_database(self) -> Optional[pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs']]:
        """
        Fire Base Database integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_database")

    @fire_base_database.setter
    def fire_base_database(self, value: Optional[pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs']]):
        pulumi.set(self, "fire_base_database", value)

    @property
    @pulumi.getter(name="fireBaseHosting")
    def fire_base_hosting(self) -> Optional[pulumi.Input['GcpIntegrationsFireBaseHostingArgs']]:
        """
        Fire Base Hosting integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_hosting")

    @fire_base_hosting.setter
    def fire_base_hosting(self, value: Optional[pulumi.Input['GcpIntegrationsFireBaseHostingArgs']]):
        pulumi.set(self, "fire_base_hosting", value)

    @property
    @pulumi.getter(name="fireBaseStorage")
    def fire_base_storage(self) -> Optional[pulumi.Input['GcpIntegrationsFireBaseStorageArgs']]:
        """
        Fire Base Storage integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_storage")

    @fire_base_storage.setter
    def fire_base_storage(self, value: Optional[pulumi.Input['GcpIntegrationsFireBaseStorageArgs']]):
        pulumi.set(self, "fire_base_storage", value)

    @property
    @pulumi.getter(name="fireStore")
    def fire_store(self) -> Optional[pulumi.Input['GcpIntegrationsFireStoreArgs']]:
        """
        Fire Store integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_store")

    @fire_store.setter
    def fire_store(self, value: Optional[pulumi.Input['GcpIntegrationsFireStoreArgs']]):
        pulumi.set(self, "fire_store", value)

    @property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input['GcpIntegrationsFunctionsArgs']]:
        """
        Functions integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input['GcpIntegrationsFunctionsArgs']]):
        pulumi.set(self, "functions", value)

    @property
    @pulumi.getter
    def interconnect(self) -> Optional[pulumi.Input['GcpIntegrationsInterconnectArgs']]:
        """
        Interconnect integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "interconnect")

    @interconnect.setter
    def interconnect(self, value: Optional[pulumi.Input['GcpIntegrationsInterconnectArgs']]):
        pulumi.set(self, "interconnect", value)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input['GcpIntegrationsKubernetesArgs']]:
        """
        Kubernetes integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input['GcpIntegrationsKubernetesArgs']]):
        pulumi.set(self, "kubernetes", value)

    @property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[pulumi.Input['GcpIntegrationsLoadBalancingArgs']]:
        """
        Load Balancing integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: Optional[pulumi.Input['GcpIntegrationsLoadBalancingArgs']]):
        pulumi.set(self, "load_balancing", value)

    @property
    @pulumi.getter(name="memCache")
    def mem_cache(self) -> Optional[pulumi.Input['GcpIntegrationsMemCacheArgs']]:
        """
        Mem cache integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "mem_cache")

    @mem_cache.setter
    def mem_cache(self, value: Optional[pulumi.Input['GcpIntegrationsMemCacheArgs']]):
        pulumi.set(self, "mem_cache", value)

    @property
    @pulumi.getter(name="pubSub")
    def pub_sub(self) -> Optional[pulumi.Input['GcpIntegrationsPubSubArgs']]:
        """
        Pub/Sub integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "pub_sub")

    @pub_sub.setter
    def pub_sub(self, value: Optional[pulumi.Input['GcpIntegrationsPubSubArgs']]):
        pulumi.set(self, "pub_sub", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input['GcpIntegrationsRedisArgs']]:
        """
        Redis integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input['GcpIntegrationsRedisArgs']]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input['GcpIntegrationsRouterArgs']]:
        """
        Router integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input['GcpIntegrationsRouterArgs']]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['GcpIntegrationsRunArgs']]:
        """
        Run integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['GcpIntegrationsRunArgs']]):
        pulumi.set(self, "run", value)

    @property
    @pulumi.getter
    def spanner(self) -> Optional[pulumi.Input['GcpIntegrationsSpannerArgs']]:
        """
        Spanner integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "spanner")

    @spanner.setter
    def spanner(self, value: Optional[pulumi.Input['GcpIntegrationsSpannerArgs']]):
        pulumi.set(self, "spanner", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input['GcpIntegrationsSqlArgs']]:
        """
        SQL integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input['GcpIntegrationsSqlArgs']]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['GcpIntegrationsStorageArgs']]:
        """
        Storage integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['GcpIntegrationsStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[pulumi.Input['GcpIntegrationsVirtualMachinesArgs']]:
        """
        Virtual machines integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: Optional[pulumi.Input['GcpIntegrationsVirtualMachinesArgs']]):
        pulumi.set(self, "virtual_machines", value)

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional[pulumi.Input['GcpIntegrationsVpcAccessArgs']]:
        """
        VPC Access integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "vpc_access")

    @vpc_access.setter
    def vpc_access(self, value: Optional[pulumi.Input['GcpIntegrationsVpcAccessArgs']]):
        pulumi.set(self, "vpc_access", value)


@pulumi.input_type
class _GcpIntegrationsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 alloy_db: Optional[pulumi.Input['GcpIntegrationsAlloyDbArgs']] = None,
                 app_engine: Optional[pulumi.Input['GcpIntegrationsAppEngineArgs']] = None,
                 big_query: Optional[pulumi.Input['GcpIntegrationsBigQueryArgs']] = None,
                 big_table: Optional[pulumi.Input['GcpIntegrationsBigTableArgs']] = None,
                 composer: Optional[pulumi.Input['GcpIntegrationsComposerArgs']] = None,
                 data_flow: Optional[pulumi.Input['GcpIntegrationsDataFlowArgs']] = None,
                 data_proc: Optional[pulumi.Input['GcpIntegrationsDataProcArgs']] = None,
                 data_store: Optional[pulumi.Input['GcpIntegrationsDataStoreArgs']] = None,
                 fire_base_database: Optional[pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs']] = None,
                 fire_base_hosting: Optional[pulumi.Input['GcpIntegrationsFireBaseHostingArgs']] = None,
                 fire_base_storage: Optional[pulumi.Input['GcpIntegrationsFireBaseStorageArgs']] = None,
                 fire_store: Optional[pulumi.Input['GcpIntegrationsFireStoreArgs']] = None,
                 functions: Optional[pulumi.Input['GcpIntegrationsFunctionsArgs']] = None,
                 interconnect: Optional[pulumi.Input['GcpIntegrationsInterconnectArgs']] = None,
                 kubernetes: Optional[pulumi.Input['GcpIntegrationsKubernetesArgs']] = None,
                 linked_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancing: Optional[pulumi.Input['GcpIntegrationsLoadBalancingArgs']] = None,
                 mem_cache: Optional[pulumi.Input['GcpIntegrationsMemCacheArgs']] = None,
                 pub_sub: Optional[pulumi.Input['GcpIntegrationsPubSubArgs']] = None,
                 redis: Optional[pulumi.Input['GcpIntegrationsRedisArgs']] = None,
                 router: Optional[pulumi.Input['GcpIntegrationsRouterArgs']] = None,
                 run: Optional[pulumi.Input['GcpIntegrationsRunArgs']] = None,
                 spanner: Optional[pulumi.Input['GcpIntegrationsSpannerArgs']] = None,
                 sql: Optional[pulumi.Input['GcpIntegrationsSqlArgs']] = None,
                 storage: Optional[pulumi.Input['GcpIntegrationsStorageArgs']] = None,
                 virtual_machines: Optional[pulumi.Input['GcpIntegrationsVirtualMachinesArgs']] = None,
                 vpc_access: Optional[pulumi.Input['GcpIntegrationsVpcAccessArgs']] = None):
        """
        Input properties used for looking up and filtering GcpIntegrations resources.
        :param pulumi.Input[builtins.str] account_id: The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input['GcpIntegrationsAlloyDbArgs'] alloy_db: Alloy DB integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsAppEngineArgs'] app_engine: App Engine integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsBigQueryArgs'] big_query: Biq Query integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsBigTableArgs'] big_table: Big Table. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsComposerArgs'] composer: Composer integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsDataFlowArgs'] data_flow: Data Flow integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsDataProcArgs'] data_proc: Data Proc integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsDataStoreArgs'] data_store: Data Store integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs'] fire_base_database: Fire Base Database integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireBaseHostingArgs'] fire_base_hosting: Fire Base Hosting integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireBaseStorageArgs'] fire_base_storage: Fire Base Storage integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFireStoreArgs'] fire_store: Fire Store integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsFunctionsArgs'] functions: Functions integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsInterconnectArgs'] interconnect: Interconnect integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsKubernetesArgs'] kubernetes: Kubernetes integration. See Integration blocks below for details.
        :param pulumi.Input[builtins.str] linked_account_id: The ID of the linked GCP account in New Relic.
               
               The following arguments/integration blocks are intended to be used with a minimum `metrics_polling_interval` of 300 seconds.
        :param pulumi.Input['GcpIntegrationsLoadBalancingArgs'] load_balancing: Load Balancing integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsMemCacheArgs'] mem_cache: Mem cache integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsPubSubArgs'] pub_sub: Pub/Sub integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsRedisArgs'] redis: Redis integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsRouterArgs'] router: Router integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsRunArgs'] run: Run integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsSpannerArgs'] spanner: Spanner integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsSqlArgs'] sql: SQL integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsStorageArgs'] storage: Storage integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsVirtualMachinesArgs'] virtual_machines: Virtual machines integration. See Integration blocks below for details.
        :param pulumi.Input['GcpIntegrationsVpcAccessArgs'] vpc_access: VPC Access integration. See Integration blocks below for details.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if alloy_db is not None:
            pulumi.set(__self__, "alloy_db", alloy_db)
        if app_engine is not None:
            pulumi.set(__self__, "app_engine", app_engine)
        if big_query is not None:
            pulumi.set(__self__, "big_query", big_query)
        if big_table is not None:
            pulumi.set(__self__, "big_table", big_table)
        if composer is not None:
            pulumi.set(__self__, "composer", composer)
        if data_flow is not None:
            pulumi.set(__self__, "data_flow", data_flow)
        if data_proc is not None:
            pulumi.set(__self__, "data_proc", data_proc)
        if data_store is not None:
            pulumi.set(__self__, "data_store", data_store)
        if fire_base_database is not None:
            pulumi.set(__self__, "fire_base_database", fire_base_database)
        if fire_base_hosting is not None:
            pulumi.set(__self__, "fire_base_hosting", fire_base_hosting)
        if fire_base_storage is not None:
            pulumi.set(__self__, "fire_base_storage", fire_base_storage)
        if fire_store is not None:
            pulumi.set(__self__, "fire_store", fire_store)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if interconnect is not None:
            pulumi.set(__self__, "interconnect", interconnect)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if linked_account_id is not None:
            pulumi.set(__self__, "linked_account_id", linked_account_id)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if mem_cache is not None:
            pulumi.set(__self__, "mem_cache", mem_cache)
        if pub_sub is not None:
            pulumi.set(__self__, "pub_sub", pub_sub)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if run is not None:
            pulumi.set(__self__, "run", run)
        if spanner is not None:
            pulumi.set(__self__, "spanner", spanner)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="alloyDb")
    def alloy_db(self) -> Optional[pulumi.Input['GcpIntegrationsAlloyDbArgs']]:
        """
        Alloy DB integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "alloy_db")

    @alloy_db.setter
    def alloy_db(self, value: Optional[pulumi.Input['GcpIntegrationsAlloyDbArgs']]):
        pulumi.set(self, "alloy_db", value)

    @property
    @pulumi.getter(name="appEngine")
    def app_engine(self) -> Optional[pulumi.Input['GcpIntegrationsAppEngineArgs']]:
        """
        App Engine integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "app_engine")

    @app_engine.setter
    def app_engine(self, value: Optional[pulumi.Input['GcpIntegrationsAppEngineArgs']]):
        pulumi.set(self, "app_engine", value)

    @property
    @pulumi.getter(name="bigQuery")
    def big_query(self) -> Optional[pulumi.Input['GcpIntegrationsBigQueryArgs']]:
        """
        Biq Query integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "big_query")

    @big_query.setter
    def big_query(self, value: Optional[pulumi.Input['GcpIntegrationsBigQueryArgs']]):
        pulumi.set(self, "big_query", value)

    @property
    @pulumi.getter(name="bigTable")
    def big_table(self) -> Optional[pulumi.Input['GcpIntegrationsBigTableArgs']]:
        """
        Big Table. See Integration blocks below for details.
        """
        return pulumi.get(self, "big_table")

    @big_table.setter
    def big_table(self, value: Optional[pulumi.Input['GcpIntegrationsBigTableArgs']]):
        pulumi.set(self, "big_table", value)

    @property
    @pulumi.getter
    def composer(self) -> Optional[pulumi.Input['GcpIntegrationsComposerArgs']]:
        """
        Composer integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "composer")

    @composer.setter
    def composer(self, value: Optional[pulumi.Input['GcpIntegrationsComposerArgs']]):
        pulumi.set(self, "composer", value)

    @property
    @pulumi.getter(name="dataFlow")
    def data_flow(self) -> Optional[pulumi.Input['GcpIntegrationsDataFlowArgs']]:
        """
        Data Flow integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_flow")

    @data_flow.setter
    def data_flow(self, value: Optional[pulumi.Input['GcpIntegrationsDataFlowArgs']]):
        pulumi.set(self, "data_flow", value)

    @property
    @pulumi.getter(name="dataProc")
    def data_proc(self) -> Optional[pulumi.Input['GcpIntegrationsDataProcArgs']]:
        """
        Data Proc integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_proc")

    @data_proc.setter
    def data_proc(self, value: Optional[pulumi.Input['GcpIntegrationsDataProcArgs']]):
        pulumi.set(self, "data_proc", value)

    @property
    @pulumi.getter(name="dataStore")
    def data_store(self) -> Optional[pulumi.Input['GcpIntegrationsDataStoreArgs']]:
        """
        Data Store integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_store")

    @data_store.setter
    def data_store(self, value: Optional[pulumi.Input['GcpIntegrationsDataStoreArgs']]):
        pulumi.set(self, "data_store", value)

    @property
    @pulumi.getter(name="fireBaseDatabase")
    def fire_base_database(self) -> Optional[pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs']]:
        """
        Fire Base Database integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_database")

    @fire_base_database.setter
    def fire_base_database(self, value: Optional[pulumi.Input['GcpIntegrationsFireBaseDatabaseArgs']]):
        pulumi.set(self, "fire_base_database", value)

    @property
    @pulumi.getter(name="fireBaseHosting")
    def fire_base_hosting(self) -> Optional[pulumi.Input['GcpIntegrationsFireBaseHostingArgs']]:
        """
        Fire Base Hosting integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_hosting")

    @fire_base_hosting.setter
    def fire_base_hosting(self, value: Optional[pulumi.Input['GcpIntegrationsFireBaseHostingArgs']]):
        pulumi.set(self, "fire_base_hosting", value)

    @property
    @pulumi.getter(name="fireBaseStorage")
    def fire_base_storage(self) -> Optional[pulumi.Input['GcpIntegrationsFireBaseStorageArgs']]:
        """
        Fire Base Storage integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_storage")

    @fire_base_storage.setter
    def fire_base_storage(self, value: Optional[pulumi.Input['GcpIntegrationsFireBaseStorageArgs']]):
        pulumi.set(self, "fire_base_storage", value)

    @property
    @pulumi.getter(name="fireStore")
    def fire_store(self) -> Optional[pulumi.Input['GcpIntegrationsFireStoreArgs']]:
        """
        Fire Store integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_store")

    @fire_store.setter
    def fire_store(self, value: Optional[pulumi.Input['GcpIntegrationsFireStoreArgs']]):
        pulumi.set(self, "fire_store", value)

    @property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input['GcpIntegrationsFunctionsArgs']]:
        """
        Functions integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input['GcpIntegrationsFunctionsArgs']]):
        pulumi.set(self, "functions", value)

    @property
    @pulumi.getter
    def interconnect(self) -> Optional[pulumi.Input['GcpIntegrationsInterconnectArgs']]:
        """
        Interconnect integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "interconnect")

    @interconnect.setter
    def interconnect(self, value: Optional[pulumi.Input['GcpIntegrationsInterconnectArgs']]):
        pulumi.set(self, "interconnect", value)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input['GcpIntegrationsKubernetesArgs']]:
        """
        Kubernetes integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input['GcpIntegrationsKubernetesArgs']]):
        pulumi.set(self, "kubernetes", value)

    @property
    @pulumi.getter(name="linkedAccountId")
    def linked_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the linked GCP account in New Relic.

        The following arguments/integration blocks are intended to be used with a minimum `metrics_polling_interval` of 300 seconds.
        """
        return pulumi.get(self, "linked_account_id")

    @linked_account_id.setter
    def linked_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "linked_account_id", value)

    @property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[pulumi.Input['GcpIntegrationsLoadBalancingArgs']]:
        """
        Load Balancing integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: Optional[pulumi.Input['GcpIntegrationsLoadBalancingArgs']]):
        pulumi.set(self, "load_balancing", value)

    @property
    @pulumi.getter(name="memCache")
    def mem_cache(self) -> Optional[pulumi.Input['GcpIntegrationsMemCacheArgs']]:
        """
        Mem cache integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "mem_cache")

    @mem_cache.setter
    def mem_cache(self, value: Optional[pulumi.Input['GcpIntegrationsMemCacheArgs']]):
        pulumi.set(self, "mem_cache", value)

    @property
    @pulumi.getter(name="pubSub")
    def pub_sub(self) -> Optional[pulumi.Input['GcpIntegrationsPubSubArgs']]:
        """
        Pub/Sub integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "pub_sub")

    @pub_sub.setter
    def pub_sub(self, value: Optional[pulumi.Input['GcpIntegrationsPubSubArgs']]):
        pulumi.set(self, "pub_sub", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input['GcpIntegrationsRedisArgs']]:
        """
        Redis integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input['GcpIntegrationsRedisArgs']]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input['GcpIntegrationsRouterArgs']]:
        """
        Router integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input['GcpIntegrationsRouterArgs']]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['GcpIntegrationsRunArgs']]:
        """
        Run integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['GcpIntegrationsRunArgs']]):
        pulumi.set(self, "run", value)

    @property
    @pulumi.getter
    def spanner(self) -> Optional[pulumi.Input['GcpIntegrationsSpannerArgs']]:
        """
        Spanner integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "spanner")

    @spanner.setter
    def spanner(self, value: Optional[pulumi.Input['GcpIntegrationsSpannerArgs']]):
        pulumi.set(self, "spanner", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input['GcpIntegrationsSqlArgs']]:
        """
        SQL integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input['GcpIntegrationsSqlArgs']]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['GcpIntegrationsStorageArgs']]:
        """
        Storage integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['GcpIntegrationsStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[pulumi.Input['GcpIntegrationsVirtualMachinesArgs']]:
        """
        Virtual machines integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: Optional[pulumi.Input['GcpIntegrationsVirtualMachinesArgs']]):
        pulumi.set(self, "virtual_machines", value)

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional[pulumi.Input['GcpIntegrationsVpcAccessArgs']]:
        """
        VPC Access integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "vpc_access")

    @vpc_access.setter
    def vpc_access(self, value: Optional[pulumi.Input['GcpIntegrationsVpcAccessArgs']]):
        pulumi.set(self, "vpc_access", value)


@pulumi.type_token("newrelic:cloud/gcpIntegrations:GcpIntegrations")
class GcpIntegrations(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 alloy_db: Optional[pulumi.Input[Union['GcpIntegrationsAlloyDbArgs', 'GcpIntegrationsAlloyDbArgsDict']]] = None,
                 app_engine: Optional[pulumi.Input[Union['GcpIntegrationsAppEngineArgs', 'GcpIntegrationsAppEngineArgsDict']]] = None,
                 big_query: Optional[pulumi.Input[Union['GcpIntegrationsBigQueryArgs', 'GcpIntegrationsBigQueryArgsDict']]] = None,
                 big_table: Optional[pulumi.Input[Union['GcpIntegrationsBigTableArgs', 'GcpIntegrationsBigTableArgsDict']]] = None,
                 composer: Optional[pulumi.Input[Union['GcpIntegrationsComposerArgs', 'GcpIntegrationsComposerArgsDict']]] = None,
                 data_flow: Optional[pulumi.Input[Union['GcpIntegrationsDataFlowArgs', 'GcpIntegrationsDataFlowArgsDict']]] = None,
                 data_proc: Optional[pulumi.Input[Union['GcpIntegrationsDataProcArgs', 'GcpIntegrationsDataProcArgsDict']]] = None,
                 data_store: Optional[pulumi.Input[Union['GcpIntegrationsDataStoreArgs', 'GcpIntegrationsDataStoreArgsDict']]] = None,
                 fire_base_database: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseDatabaseArgs', 'GcpIntegrationsFireBaseDatabaseArgsDict']]] = None,
                 fire_base_hosting: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseHostingArgs', 'GcpIntegrationsFireBaseHostingArgsDict']]] = None,
                 fire_base_storage: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseStorageArgs', 'GcpIntegrationsFireBaseStorageArgsDict']]] = None,
                 fire_store: Optional[pulumi.Input[Union['GcpIntegrationsFireStoreArgs', 'GcpIntegrationsFireStoreArgsDict']]] = None,
                 functions: Optional[pulumi.Input[Union['GcpIntegrationsFunctionsArgs', 'GcpIntegrationsFunctionsArgsDict']]] = None,
                 interconnect: Optional[pulumi.Input[Union['GcpIntegrationsInterconnectArgs', 'GcpIntegrationsInterconnectArgsDict']]] = None,
                 kubernetes: Optional[pulumi.Input[Union['GcpIntegrationsKubernetesArgs', 'GcpIntegrationsKubernetesArgsDict']]] = None,
                 linked_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancing: Optional[pulumi.Input[Union['GcpIntegrationsLoadBalancingArgs', 'GcpIntegrationsLoadBalancingArgsDict']]] = None,
                 mem_cache: Optional[pulumi.Input[Union['GcpIntegrationsMemCacheArgs', 'GcpIntegrationsMemCacheArgsDict']]] = None,
                 pub_sub: Optional[pulumi.Input[Union['GcpIntegrationsPubSubArgs', 'GcpIntegrationsPubSubArgsDict']]] = None,
                 redis: Optional[pulumi.Input[Union['GcpIntegrationsRedisArgs', 'GcpIntegrationsRedisArgsDict']]] = None,
                 router: Optional[pulumi.Input[Union['GcpIntegrationsRouterArgs', 'GcpIntegrationsRouterArgsDict']]] = None,
                 run: Optional[pulumi.Input[Union['GcpIntegrationsRunArgs', 'GcpIntegrationsRunArgsDict']]] = None,
                 spanner: Optional[pulumi.Input[Union['GcpIntegrationsSpannerArgs', 'GcpIntegrationsSpannerArgsDict']]] = None,
                 sql: Optional[pulumi.Input[Union['GcpIntegrationsSqlArgs', 'GcpIntegrationsSqlArgsDict']]] = None,
                 storage: Optional[pulumi.Input[Union['GcpIntegrationsStorageArgs', 'GcpIntegrationsStorageArgsDict']]] = None,
                 virtual_machines: Optional[pulumi.Input[Union['GcpIntegrationsVirtualMachinesArgs', 'GcpIntegrationsVirtualMachinesArgsDict']]] = None,
                 vpc_access: Optional[pulumi.Input[Union['GcpIntegrationsVpcAccessArgs', 'GcpIntegrationsVpcAccessArgsDict']]] = None,
                 __props__=None):
        """
        Use this resource to integrate GCP services with New Relic.

        ## Prerequisite

        Setup is required for this resource to work properly. This resource assumes you have linked a GCP account to New Relic and configured it to pull metrics from GCP.

        New Relic doesn't automatically receive metrics from GCP services, so this resource can be used to configure integrations to those services.

        ## Example Usage

        Leave an integration block empty to use its default configuration. You can also use the full example, including the GCP set up, found in our guides.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.cloud.GcpLinkAccount("foo",
            name="example",
            project_id="<Your GCP project ID>")
        foo1 = newrelic.cloud.GcpIntegrations("foo1",
            linked_account_id=foo.id,
            app_engine={
                "metrics_polling_interval": 300,
            },
            big_query={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            big_table={
                "metrics_polling_interval": 300,
            },
            composer={
                "metrics_polling_interval": 300,
            },
            data_flow={
                "metrics_polling_interval": 300,
            },
            data_proc={
                "metrics_polling_interval": 300,
            },
            data_store={
                "metrics_polling_interval": 300,
            },
            fire_base_database={
                "metrics_polling_interval": 300,
            },
            fire_base_hosting={
                "metrics_polling_interval": 300,
            },
            fire_base_storage={
                "metrics_polling_interval": 300,
            },
            fire_store={
                "metrics_polling_interval": 300,
            },
            functions={
                "metrics_polling_interval": 300,
            },
            interconnect={
                "metrics_polling_interval": 300,
            },
            kubernetes={
                "metrics_polling_interval": 300,
            },
            load_balancing={
                "metrics_polling_interval": 300,
            },
            mem_cache={
                "metrics_polling_interval": 300,
            },
            pub_sub={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            redis={
                "metrics_polling_interval": 300,
            },
            router={
                "metrics_polling_interval": 300,
            },
            run={
                "metrics_polling_interval": 300,
            },
            spanner={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            sql={
                "metrics_polling_interval": 300,
            },
            storage={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            virtual_machines={
                "metrics_polling_interval": 300,
            },
            vpc_access={
                "metrics_polling_interval": 300,
            })
        ```

        ## Import

        Linked GCP account integrations can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:cloud/gcpIntegrations:GcpIntegrations foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[Union['GcpIntegrationsAlloyDbArgs', 'GcpIntegrationsAlloyDbArgsDict']] alloy_db: Alloy DB integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsAppEngineArgs', 'GcpIntegrationsAppEngineArgsDict']] app_engine: App Engine integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsBigQueryArgs', 'GcpIntegrationsBigQueryArgsDict']] big_query: Biq Query integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsBigTableArgs', 'GcpIntegrationsBigTableArgsDict']] big_table: Big Table. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsComposerArgs', 'GcpIntegrationsComposerArgsDict']] composer: Composer integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsDataFlowArgs', 'GcpIntegrationsDataFlowArgsDict']] data_flow: Data Flow integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsDataProcArgs', 'GcpIntegrationsDataProcArgsDict']] data_proc: Data Proc integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsDataStoreArgs', 'GcpIntegrationsDataStoreArgsDict']] data_store: Data Store integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireBaseDatabaseArgs', 'GcpIntegrationsFireBaseDatabaseArgsDict']] fire_base_database: Fire Base Database integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireBaseHostingArgs', 'GcpIntegrationsFireBaseHostingArgsDict']] fire_base_hosting: Fire Base Hosting integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireBaseStorageArgs', 'GcpIntegrationsFireBaseStorageArgsDict']] fire_base_storage: Fire Base Storage integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireStoreArgs', 'GcpIntegrationsFireStoreArgsDict']] fire_store: Fire Store integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFunctionsArgs', 'GcpIntegrationsFunctionsArgsDict']] functions: Functions integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsInterconnectArgs', 'GcpIntegrationsInterconnectArgsDict']] interconnect: Interconnect integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsKubernetesArgs', 'GcpIntegrationsKubernetesArgsDict']] kubernetes: Kubernetes integration. See Integration blocks below for details.
        :param pulumi.Input[builtins.str] linked_account_id: The ID of the linked GCP account in New Relic.
               
               The following arguments/integration blocks are intended to be used with a minimum `metrics_polling_interval` of 300 seconds.
        :param pulumi.Input[Union['GcpIntegrationsLoadBalancingArgs', 'GcpIntegrationsLoadBalancingArgsDict']] load_balancing: Load Balancing integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsMemCacheArgs', 'GcpIntegrationsMemCacheArgsDict']] mem_cache: Mem cache integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsPubSubArgs', 'GcpIntegrationsPubSubArgsDict']] pub_sub: Pub/Sub integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsRedisArgs', 'GcpIntegrationsRedisArgsDict']] redis: Redis integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsRouterArgs', 'GcpIntegrationsRouterArgsDict']] router: Router integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsRunArgs', 'GcpIntegrationsRunArgsDict']] run: Run integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsSpannerArgs', 'GcpIntegrationsSpannerArgsDict']] spanner: Spanner integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsSqlArgs', 'GcpIntegrationsSqlArgsDict']] sql: SQL integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsStorageArgs', 'GcpIntegrationsStorageArgsDict']] storage: Storage integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsVirtualMachinesArgs', 'GcpIntegrationsVirtualMachinesArgsDict']] virtual_machines: Virtual machines integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsVpcAccessArgs', 'GcpIntegrationsVpcAccessArgsDict']] vpc_access: VPC Access integration. See Integration blocks below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpIntegrationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to integrate GCP services with New Relic.

        ## Prerequisite

        Setup is required for this resource to work properly. This resource assumes you have linked a GCP account to New Relic and configured it to pull metrics from GCP.

        New Relic doesn't automatically receive metrics from GCP services, so this resource can be used to configure integrations to those services.

        ## Example Usage

        Leave an integration block empty to use its default configuration. You can also use the full example, including the GCP set up, found in our guides.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.cloud.GcpLinkAccount("foo",
            name="example",
            project_id="<Your GCP project ID>")
        foo1 = newrelic.cloud.GcpIntegrations("foo1",
            linked_account_id=foo.id,
            app_engine={
                "metrics_polling_interval": 300,
            },
            big_query={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            big_table={
                "metrics_polling_interval": 300,
            },
            composer={
                "metrics_polling_interval": 300,
            },
            data_flow={
                "metrics_polling_interval": 300,
            },
            data_proc={
                "metrics_polling_interval": 300,
            },
            data_store={
                "metrics_polling_interval": 300,
            },
            fire_base_database={
                "metrics_polling_interval": 300,
            },
            fire_base_hosting={
                "metrics_polling_interval": 300,
            },
            fire_base_storage={
                "metrics_polling_interval": 300,
            },
            fire_store={
                "metrics_polling_interval": 300,
            },
            functions={
                "metrics_polling_interval": 300,
            },
            interconnect={
                "metrics_polling_interval": 300,
            },
            kubernetes={
                "metrics_polling_interval": 300,
            },
            load_balancing={
                "metrics_polling_interval": 300,
            },
            mem_cache={
                "metrics_polling_interval": 300,
            },
            pub_sub={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            redis={
                "metrics_polling_interval": 300,
            },
            router={
                "metrics_polling_interval": 300,
            },
            run={
                "metrics_polling_interval": 300,
            },
            spanner={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            sql={
                "metrics_polling_interval": 300,
            },
            storage={
                "metrics_polling_interval": 300,
                "fetch_tags": True,
            },
            virtual_machines={
                "metrics_polling_interval": 300,
            },
            vpc_access={
                "metrics_polling_interval": 300,
            })
        ```

        ## Import

        Linked GCP account integrations can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:cloud/gcpIntegrations:GcpIntegrations foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param GcpIntegrationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpIntegrationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 alloy_db: Optional[pulumi.Input[Union['GcpIntegrationsAlloyDbArgs', 'GcpIntegrationsAlloyDbArgsDict']]] = None,
                 app_engine: Optional[pulumi.Input[Union['GcpIntegrationsAppEngineArgs', 'GcpIntegrationsAppEngineArgsDict']]] = None,
                 big_query: Optional[pulumi.Input[Union['GcpIntegrationsBigQueryArgs', 'GcpIntegrationsBigQueryArgsDict']]] = None,
                 big_table: Optional[pulumi.Input[Union['GcpIntegrationsBigTableArgs', 'GcpIntegrationsBigTableArgsDict']]] = None,
                 composer: Optional[pulumi.Input[Union['GcpIntegrationsComposerArgs', 'GcpIntegrationsComposerArgsDict']]] = None,
                 data_flow: Optional[pulumi.Input[Union['GcpIntegrationsDataFlowArgs', 'GcpIntegrationsDataFlowArgsDict']]] = None,
                 data_proc: Optional[pulumi.Input[Union['GcpIntegrationsDataProcArgs', 'GcpIntegrationsDataProcArgsDict']]] = None,
                 data_store: Optional[pulumi.Input[Union['GcpIntegrationsDataStoreArgs', 'GcpIntegrationsDataStoreArgsDict']]] = None,
                 fire_base_database: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseDatabaseArgs', 'GcpIntegrationsFireBaseDatabaseArgsDict']]] = None,
                 fire_base_hosting: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseHostingArgs', 'GcpIntegrationsFireBaseHostingArgsDict']]] = None,
                 fire_base_storage: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseStorageArgs', 'GcpIntegrationsFireBaseStorageArgsDict']]] = None,
                 fire_store: Optional[pulumi.Input[Union['GcpIntegrationsFireStoreArgs', 'GcpIntegrationsFireStoreArgsDict']]] = None,
                 functions: Optional[pulumi.Input[Union['GcpIntegrationsFunctionsArgs', 'GcpIntegrationsFunctionsArgsDict']]] = None,
                 interconnect: Optional[pulumi.Input[Union['GcpIntegrationsInterconnectArgs', 'GcpIntegrationsInterconnectArgsDict']]] = None,
                 kubernetes: Optional[pulumi.Input[Union['GcpIntegrationsKubernetesArgs', 'GcpIntegrationsKubernetesArgsDict']]] = None,
                 linked_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancing: Optional[pulumi.Input[Union['GcpIntegrationsLoadBalancingArgs', 'GcpIntegrationsLoadBalancingArgsDict']]] = None,
                 mem_cache: Optional[pulumi.Input[Union['GcpIntegrationsMemCacheArgs', 'GcpIntegrationsMemCacheArgsDict']]] = None,
                 pub_sub: Optional[pulumi.Input[Union['GcpIntegrationsPubSubArgs', 'GcpIntegrationsPubSubArgsDict']]] = None,
                 redis: Optional[pulumi.Input[Union['GcpIntegrationsRedisArgs', 'GcpIntegrationsRedisArgsDict']]] = None,
                 router: Optional[pulumi.Input[Union['GcpIntegrationsRouterArgs', 'GcpIntegrationsRouterArgsDict']]] = None,
                 run: Optional[pulumi.Input[Union['GcpIntegrationsRunArgs', 'GcpIntegrationsRunArgsDict']]] = None,
                 spanner: Optional[pulumi.Input[Union['GcpIntegrationsSpannerArgs', 'GcpIntegrationsSpannerArgsDict']]] = None,
                 sql: Optional[pulumi.Input[Union['GcpIntegrationsSqlArgs', 'GcpIntegrationsSqlArgsDict']]] = None,
                 storage: Optional[pulumi.Input[Union['GcpIntegrationsStorageArgs', 'GcpIntegrationsStorageArgsDict']]] = None,
                 virtual_machines: Optional[pulumi.Input[Union['GcpIntegrationsVirtualMachinesArgs', 'GcpIntegrationsVirtualMachinesArgsDict']]] = None,
                 vpc_access: Optional[pulumi.Input[Union['GcpIntegrationsVpcAccessArgs', 'GcpIntegrationsVpcAccessArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpIntegrationsArgs.__new__(GcpIntegrationsArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["alloy_db"] = alloy_db
            __props__.__dict__["app_engine"] = app_engine
            __props__.__dict__["big_query"] = big_query
            __props__.__dict__["big_table"] = big_table
            __props__.__dict__["composer"] = composer
            __props__.__dict__["data_flow"] = data_flow
            __props__.__dict__["data_proc"] = data_proc
            __props__.__dict__["data_store"] = data_store
            __props__.__dict__["fire_base_database"] = fire_base_database
            __props__.__dict__["fire_base_hosting"] = fire_base_hosting
            __props__.__dict__["fire_base_storage"] = fire_base_storage
            __props__.__dict__["fire_store"] = fire_store
            __props__.__dict__["functions"] = functions
            __props__.__dict__["interconnect"] = interconnect
            __props__.__dict__["kubernetes"] = kubernetes
            if linked_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'linked_account_id'")
            __props__.__dict__["linked_account_id"] = linked_account_id
            __props__.__dict__["load_balancing"] = load_balancing
            __props__.__dict__["mem_cache"] = mem_cache
            __props__.__dict__["pub_sub"] = pub_sub
            __props__.__dict__["redis"] = redis
            __props__.__dict__["router"] = router
            __props__.__dict__["run"] = run
            __props__.__dict__["spanner"] = spanner
            __props__.__dict__["sql"] = sql
            __props__.__dict__["storage"] = storage
            __props__.__dict__["virtual_machines"] = virtual_machines
            __props__.__dict__["vpc_access"] = vpc_access
        super(GcpIntegrations, __self__).__init__(
            'newrelic:cloud/gcpIntegrations:GcpIntegrations',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            alloy_db: Optional[pulumi.Input[Union['GcpIntegrationsAlloyDbArgs', 'GcpIntegrationsAlloyDbArgsDict']]] = None,
            app_engine: Optional[pulumi.Input[Union['GcpIntegrationsAppEngineArgs', 'GcpIntegrationsAppEngineArgsDict']]] = None,
            big_query: Optional[pulumi.Input[Union['GcpIntegrationsBigQueryArgs', 'GcpIntegrationsBigQueryArgsDict']]] = None,
            big_table: Optional[pulumi.Input[Union['GcpIntegrationsBigTableArgs', 'GcpIntegrationsBigTableArgsDict']]] = None,
            composer: Optional[pulumi.Input[Union['GcpIntegrationsComposerArgs', 'GcpIntegrationsComposerArgsDict']]] = None,
            data_flow: Optional[pulumi.Input[Union['GcpIntegrationsDataFlowArgs', 'GcpIntegrationsDataFlowArgsDict']]] = None,
            data_proc: Optional[pulumi.Input[Union['GcpIntegrationsDataProcArgs', 'GcpIntegrationsDataProcArgsDict']]] = None,
            data_store: Optional[pulumi.Input[Union['GcpIntegrationsDataStoreArgs', 'GcpIntegrationsDataStoreArgsDict']]] = None,
            fire_base_database: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseDatabaseArgs', 'GcpIntegrationsFireBaseDatabaseArgsDict']]] = None,
            fire_base_hosting: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseHostingArgs', 'GcpIntegrationsFireBaseHostingArgsDict']]] = None,
            fire_base_storage: Optional[pulumi.Input[Union['GcpIntegrationsFireBaseStorageArgs', 'GcpIntegrationsFireBaseStorageArgsDict']]] = None,
            fire_store: Optional[pulumi.Input[Union['GcpIntegrationsFireStoreArgs', 'GcpIntegrationsFireStoreArgsDict']]] = None,
            functions: Optional[pulumi.Input[Union['GcpIntegrationsFunctionsArgs', 'GcpIntegrationsFunctionsArgsDict']]] = None,
            interconnect: Optional[pulumi.Input[Union['GcpIntegrationsInterconnectArgs', 'GcpIntegrationsInterconnectArgsDict']]] = None,
            kubernetes: Optional[pulumi.Input[Union['GcpIntegrationsKubernetesArgs', 'GcpIntegrationsKubernetesArgsDict']]] = None,
            linked_account_id: Optional[pulumi.Input[builtins.str]] = None,
            load_balancing: Optional[pulumi.Input[Union['GcpIntegrationsLoadBalancingArgs', 'GcpIntegrationsLoadBalancingArgsDict']]] = None,
            mem_cache: Optional[pulumi.Input[Union['GcpIntegrationsMemCacheArgs', 'GcpIntegrationsMemCacheArgsDict']]] = None,
            pub_sub: Optional[pulumi.Input[Union['GcpIntegrationsPubSubArgs', 'GcpIntegrationsPubSubArgsDict']]] = None,
            redis: Optional[pulumi.Input[Union['GcpIntegrationsRedisArgs', 'GcpIntegrationsRedisArgsDict']]] = None,
            router: Optional[pulumi.Input[Union['GcpIntegrationsRouterArgs', 'GcpIntegrationsRouterArgsDict']]] = None,
            run: Optional[pulumi.Input[Union['GcpIntegrationsRunArgs', 'GcpIntegrationsRunArgsDict']]] = None,
            spanner: Optional[pulumi.Input[Union['GcpIntegrationsSpannerArgs', 'GcpIntegrationsSpannerArgsDict']]] = None,
            sql: Optional[pulumi.Input[Union['GcpIntegrationsSqlArgs', 'GcpIntegrationsSqlArgsDict']]] = None,
            storage: Optional[pulumi.Input[Union['GcpIntegrationsStorageArgs', 'GcpIntegrationsStorageArgsDict']]] = None,
            virtual_machines: Optional[pulumi.Input[Union['GcpIntegrationsVirtualMachinesArgs', 'GcpIntegrationsVirtualMachinesArgsDict']]] = None,
            vpc_access: Optional[pulumi.Input[Union['GcpIntegrationsVpcAccessArgs', 'GcpIntegrationsVpcAccessArgsDict']]] = None) -> 'GcpIntegrations':
        """
        Get an existing GcpIntegrations resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[Union['GcpIntegrationsAlloyDbArgs', 'GcpIntegrationsAlloyDbArgsDict']] alloy_db: Alloy DB integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsAppEngineArgs', 'GcpIntegrationsAppEngineArgsDict']] app_engine: App Engine integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsBigQueryArgs', 'GcpIntegrationsBigQueryArgsDict']] big_query: Biq Query integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsBigTableArgs', 'GcpIntegrationsBigTableArgsDict']] big_table: Big Table. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsComposerArgs', 'GcpIntegrationsComposerArgsDict']] composer: Composer integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsDataFlowArgs', 'GcpIntegrationsDataFlowArgsDict']] data_flow: Data Flow integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsDataProcArgs', 'GcpIntegrationsDataProcArgsDict']] data_proc: Data Proc integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsDataStoreArgs', 'GcpIntegrationsDataStoreArgsDict']] data_store: Data Store integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireBaseDatabaseArgs', 'GcpIntegrationsFireBaseDatabaseArgsDict']] fire_base_database: Fire Base Database integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireBaseHostingArgs', 'GcpIntegrationsFireBaseHostingArgsDict']] fire_base_hosting: Fire Base Hosting integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireBaseStorageArgs', 'GcpIntegrationsFireBaseStorageArgsDict']] fire_base_storage: Fire Base Storage integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFireStoreArgs', 'GcpIntegrationsFireStoreArgsDict']] fire_store: Fire Store integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsFunctionsArgs', 'GcpIntegrationsFunctionsArgsDict']] functions: Functions integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsInterconnectArgs', 'GcpIntegrationsInterconnectArgsDict']] interconnect: Interconnect integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsKubernetesArgs', 'GcpIntegrationsKubernetesArgsDict']] kubernetes: Kubernetes integration. See Integration blocks below for details.
        :param pulumi.Input[builtins.str] linked_account_id: The ID of the linked GCP account in New Relic.
               
               The following arguments/integration blocks are intended to be used with a minimum `metrics_polling_interval` of 300 seconds.
        :param pulumi.Input[Union['GcpIntegrationsLoadBalancingArgs', 'GcpIntegrationsLoadBalancingArgsDict']] load_balancing: Load Balancing integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsMemCacheArgs', 'GcpIntegrationsMemCacheArgsDict']] mem_cache: Mem cache integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsPubSubArgs', 'GcpIntegrationsPubSubArgsDict']] pub_sub: Pub/Sub integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsRedisArgs', 'GcpIntegrationsRedisArgsDict']] redis: Redis integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsRouterArgs', 'GcpIntegrationsRouterArgsDict']] router: Router integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsRunArgs', 'GcpIntegrationsRunArgsDict']] run: Run integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsSpannerArgs', 'GcpIntegrationsSpannerArgsDict']] spanner: Spanner integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsSqlArgs', 'GcpIntegrationsSqlArgsDict']] sql: SQL integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsStorageArgs', 'GcpIntegrationsStorageArgsDict']] storage: Storage integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsVirtualMachinesArgs', 'GcpIntegrationsVirtualMachinesArgsDict']] virtual_machines: Virtual machines integration. See Integration blocks below for details.
        :param pulumi.Input[Union['GcpIntegrationsVpcAccessArgs', 'GcpIntegrationsVpcAccessArgsDict']] vpc_access: VPC Access integration. See Integration blocks below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpIntegrationsState.__new__(_GcpIntegrationsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["alloy_db"] = alloy_db
        __props__.__dict__["app_engine"] = app_engine
        __props__.__dict__["big_query"] = big_query
        __props__.__dict__["big_table"] = big_table
        __props__.__dict__["composer"] = composer
        __props__.__dict__["data_flow"] = data_flow
        __props__.__dict__["data_proc"] = data_proc
        __props__.__dict__["data_store"] = data_store
        __props__.__dict__["fire_base_database"] = fire_base_database
        __props__.__dict__["fire_base_hosting"] = fire_base_hosting
        __props__.__dict__["fire_base_storage"] = fire_base_storage
        __props__.__dict__["fire_store"] = fire_store
        __props__.__dict__["functions"] = functions
        __props__.__dict__["interconnect"] = interconnect
        __props__.__dict__["kubernetes"] = kubernetes
        __props__.__dict__["linked_account_id"] = linked_account_id
        __props__.__dict__["load_balancing"] = load_balancing
        __props__.__dict__["mem_cache"] = mem_cache
        __props__.__dict__["pub_sub"] = pub_sub
        __props__.__dict__["redis"] = redis
        __props__.__dict__["router"] = router
        __props__.__dict__["run"] = run
        __props__.__dict__["spanner"] = spanner
        __props__.__dict__["sql"] = sql
        __props__.__dict__["storage"] = storage
        __props__.__dict__["virtual_machines"] = virtual_machines
        __props__.__dict__["vpc_access"] = vpc_access
        return GcpIntegrations(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The New Relic account ID to operate on.  This allows the user to override the `account_id` attribute set on the provider. Defaults to the environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="alloyDb")
    def alloy_db(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsAlloyDb']]:
        """
        Alloy DB integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "alloy_db")

    @property
    @pulumi.getter(name="appEngine")
    def app_engine(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsAppEngine']]:
        """
        App Engine integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "app_engine")

    @property
    @pulumi.getter(name="bigQuery")
    def big_query(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsBigQuery']]:
        """
        Biq Query integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "big_query")

    @property
    @pulumi.getter(name="bigTable")
    def big_table(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsBigTable']]:
        """
        Big Table. See Integration blocks below for details.
        """
        return pulumi.get(self, "big_table")

    @property
    @pulumi.getter
    def composer(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsComposer']]:
        """
        Composer integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "composer")

    @property
    @pulumi.getter(name="dataFlow")
    def data_flow(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsDataFlow']]:
        """
        Data Flow integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_flow")

    @property
    @pulumi.getter(name="dataProc")
    def data_proc(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsDataProc']]:
        """
        Data Proc integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_proc")

    @property
    @pulumi.getter(name="dataStore")
    def data_store(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsDataStore']]:
        """
        Data Store integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "data_store")

    @property
    @pulumi.getter(name="fireBaseDatabase")
    def fire_base_database(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsFireBaseDatabase']]:
        """
        Fire Base Database integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_database")

    @property
    @pulumi.getter(name="fireBaseHosting")
    def fire_base_hosting(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsFireBaseHosting']]:
        """
        Fire Base Hosting integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_hosting")

    @property
    @pulumi.getter(name="fireBaseStorage")
    def fire_base_storage(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsFireBaseStorage']]:
        """
        Fire Base Storage integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_base_storage")

    @property
    @pulumi.getter(name="fireStore")
    def fire_store(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsFireStore']]:
        """
        Fire Store integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "fire_store")

    @property
    @pulumi.getter
    def functions(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsFunctions']]:
        """
        Functions integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "functions")

    @property
    @pulumi.getter
    def interconnect(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsInterconnect']]:
        """
        Interconnect integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "interconnect")

    @property
    @pulumi.getter
    def kubernetes(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsKubernetes']]:
        """
        Kubernetes integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="linkedAccountId")
    def linked_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the linked GCP account in New Relic.

        The following arguments/integration blocks are intended to be used with a minimum `metrics_polling_interval` of 300 seconds.
        """
        return pulumi.get(self, "linked_account_id")

    @property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsLoadBalancing']]:
        """
        Load Balancing integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "load_balancing")

    @property
    @pulumi.getter(name="memCache")
    def mem_cache(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsMemCache']]:
        """
        Mem cache integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "mem_cache")

    @property
    @pulumi.getter(name="pubSub")
    def pub_sub(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsPubSub']]:
        """
        Pub/Sub integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "pub_sub")

    @property
    @pulumi.getter
    def redis(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsRedis']]:
        """
        Redis integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "redis")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsRouter']]:
        """
        Router integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter
    def run(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsRun']]:
        """
        Run integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "run")

    @property
    @pulumi.getter
    def spanner(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsSpanner']]:
        """
        Spanner integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "spanner")

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsSql']]:
        """
        SQL integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsStorage']]:
        """
        Storage integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsVirtualMachines']]:
        """
        Virtual machines integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "virtual_machines")

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> pulumi.Output[Optional['outputs.GcpIntegrationsVpcAccess']]:
        """
        VPC Access integration. See Integration blocks below for details.
        """
        return pulumi.get(self, "vpc_access")

