# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationChannelArgs', 'NotificationChannel']

@pulumi.input_type
class NotificationChannelArgs:
    def __init__(__self__, *,
                 destination_id: pulumi.Input[builtins.str],
                 product: pulumi.Input[builtins.str],
                 properties: pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]],
                 type: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NotificationChannel resource.
        :param pulumi.Input[builtins.str] destination_id: The id of the destination.
        :param pulumi.Input[builtins.str] product: The type of product.  One of: `DISCUSSIONS`, `ERROR_TRACKING` or `IINT` (workflows).
        :param pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]] properties: A nested block that describes a notification channel property. See Nested property blocks below for details.
        :param pulumi.Input[builtins.str] type: The type of channel.  One of: `EMAIL`, `SERVICENOW_INCIDENTS`, `SERVICE_NOW_APP`, `WEBHOOK`, `JIRA_CLASSIC`, `MOBILE_PUSH`, `EVENT_BRIDGE`, `SLACK` and `SLACK_COLLABORATION`, `PAGERDUTY_ACCOUNT_INTEGRATION`, `PAGERDUTY_SERVICE_INTEGRATION`, `MICROSOFT_TEAMS` or `WORKFLOW_AUTOMATION`.
        :param pulumi.Input[builtins.str] account_id: Determines the New Relic account where the notification channel will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[builtins.bool] active: Indicates whether the channel is active.
        :param pulumi.Input[builtins.str] name: The name of the channel.
        """
        pulumi.set(__self__, "destination_id", destination_id)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="destinationId")
    def destination_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the destination.
        """
        return pulumi.get(self, "destination_id")

    @destination_id.setter
    def destination_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_id", value)

    @property
    @pulumi.getter
    def product(self) -> pulumi.Input[builtins.str]:
        """
        The type of product.  One of: `DISCUSSIONS`, `ERROR_TRACKING` or `IINT` (workflows).
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]]:
        """
        A nested block that describes a notification channel property. See Nested property blocks below for details.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of channel.  One of: `EMAIL`, `SERVICENOW_INCIDENTS`, `SERVICE_NOW_APP`, `WEBHOOK`, `JIRA_CLASSIC`, `MOBILE_PUSH`, `EVENT_BRIDGE`, `SLACK` and `SLACK_COLLABORATION`, `PAGERDUTY_ACCOUNT_INTEGRATION`, `PAGERDUTY_SERVICE_INTEGRATION`, `MICROSOFT_TEAMS` or `WORKFLOW_AUTOMATION`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines the New Relic account where the notification channel will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the channel is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the channel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NotificationChannelState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 product: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NotificationChannel resources.
        :param pulumi.Input[builtins.str] account_id: Determines the New Relic account where the notification channel will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[builtins.bool] active: Indicates whether the channel is active.
        :param pulumi.Input[builtins.str] destination_id: The id of the destination.
        :param pulumi.Input[builtins.str] name: The name of the channel.
        :param pulumi.Input[builtins.str] product: The type of product.  One of: `DISCUSSIONS`, `ERROR_TRACKING` or `IINT` (workflows).
        :param pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]] properties: A nested block that describes a notification channel property. See Nested property blocks below for details.
        :param pulumi.Input[builtins.str] status: The status of the channel.
        :param pulumi.Input[builtins.str] type: The type of channel.  One of: `EMAIL`, `SERVICENOW_INCIDENTS`, `SERVICE_NOW_APP`, `WEBHOOK`, `JIRA_CLASSIC`, `MOBILE_PUSH`, `EVENT_BRIDGE`, `SLACK` and `SLACK_COLLABORATION`, `PAGERDUTY_ACCOUNT_INTEGRATION`, `PAGERDUTY_SERVICE_INTEGRATION`, `MICROSOFT_TEAMS` or `WORKFLOW_AUTOMATION`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if destination_id is not None:
            pulumi.set(__self__, "destination_id", destination_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines the New Relic account where the notification channel will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the channel is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="destinationId")
    def destination_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the destination.
        """
        return pulumi.get(self, "destination_id")

    @destination_id.setter
    def destination_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the channel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of product.  One of: `DISCUSSIONS`, `ERROR_TRACKING` or `IINT` (workflows).
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]]]:
        """
        A nested block that describes a notification channel property. See Nested property blocks below for details.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the channel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of channel.  One of: `EMAIL`, `SERVICENOW_INCIDENTS`, `SERVICE_NOW_APP`, `WEBHOOK`, `JIRA_CLASSIC`, `MOBILE_PUSH`, `EVENT_BRIDGE`, `SLACK` and `SLACK_COLLABORATION`, `PAGERDUTY_ACCOUNT_INTEGRATION`, `PAGERDUTY_SERVICE_INTEGRATION`, `MICROSOFT_TEAMS` or `WORKFLOW_AUTOMATION`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("newrelic:index/notificationChannel:NotificationChannel")
class NotificationChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 product: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationChannelPropertyArgs', 'NotificationChannelPropertyArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to create and manage New Relic notification channels. Details regarding supported products and permissions can be found [here](https://docs.newrelic.com/docs/alerts-applied-intelligence/notifications/destinations).

        A channel is an entity that is used to configure notifications. It is also called a message template. It is a separate entity from workflows, but a channel is required in order to create a workflow.

        ## Example Usage

        ##### [Webhook](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#webhook)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="webhook-example",
            type="WEBHOOK",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[{
                "key": "payload",
                "value": "name: {{ foo }}",
                "label": "Payload Template",
            }])
        ```
        See additional examples.

        ## Additional Examples

        > **NOTE:** We support all properties. The mentioned properties are just an example.

        ##### [ServiceNow](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#servicenow)
        To see the properties’ keys for your account, check ServiceNow incidents table.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="servicenow-incident-example",
            type="SERVICENOW_INCIDENTS",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "description",
                    "value": "General description",
                },
                {
                    "key": "short_description",
                    "value": "Short description",
                },
            ])
        ```
        ##### [ServiceNowApp](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#servicenowapp)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="servicenow-app-example",
            type="SERVICE_NOW_APP",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT")
        ```

        ##### [Email](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#email)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="email-example",
            type="EMAIL",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "subject",
                    "value": "New Subject Title",
                },
                {
                    "key": "customDetailsEmail",
                    "value": "issue id - {{issueId}}",
                },
            ])
        ```

        ##### [Jira Classic](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#jira)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="jira-example",
            type="JIRA_CLASSIC",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="ERROR_TRACKING",
            properties=[
                {
                    "key": "project",
                    "value": "10000",
                    "label": "Project-Name",
                },
                {
                    "key": "issuetype",
                    "value": "10004",
                    "label": "Bug",
                },
                {
                    "key": "description",
                    "value": "Issue ID: {{ issueId }}",
                },
                {
                    "key": "summary",
                    "value": "{{ annotations.title.[0] }}",
                },
            ])
        ```

        ##### [PagerDuty with account integration](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#pagerduty)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="pagerduty-account-example",
            type="PAGERDUTY_ACCOUNT_INTEGRATION",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "summary",
                    "value": "General summary",
                },
                {
                    "key": "service",
                    "label": "Service Name",
                    "value": "PTQK3FM",
                },
                {
                    "key": "email",
                    "value": "example@email.com",
                },
                {
                    "key": "customDetails",
                    "value": \"\"\"{
        "id":{{json issueId}},
        "IssueURL":{{json issuePageUrl}},
        "NewRelic priority":{{json priority}},
        "Total Incidents":{{json totalIncidents}},
        "Impacted Entities":"{{#each entitiesData.names}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Runbook":"{{#each accumulations.runbookUrl}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Description":"{{#each annotations.description}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "isCorrelated":{{json isCorrelated}},
        "Alert Policy Names":"{{#each accumulations.policyName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Alert Condition Names":"{{#each accumulations.conditionName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Workflow Name":{{json workflowName}}
        }
        \"\"\",
                },
            ])
        ```

        ##### [PagerDuty with service integration](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#pagerduty)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="pagerduty-account-example",
            type="PAGERDUTY_SERVICE_INTEGRATION",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "summary",
                    "value": "General summary",
                },
                {
                    "key": "customDetails",
                    "value": \"\"\"{
        "id":{{json issueId}},
        "IssueURL":{{json issuePageUrl}},
        "NewRelic priority":{{json priority}},
        "Total Incidents":{{json totalIncidents}},
        "Impacted Entities":"{{#each entitiesData.names}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Runbook":"{{#each accumulations.runbookUrl}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Description":"{{#each annotations.description}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "isCorrelated":{{json isCorrelated}},
        "Alert Policy Names":"{{#each accumulations.policyName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Alert Condition Names":"{{#each accumulations.conditionName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Workflow Name":{{json workflowName}}
        }
        \"\"\",
                },
            ])
        ```

        #### Mobile Push
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="mobile-push-example",
            type="MOBILE_PUSH",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT")
        ```

        #### [AWS Event Bridge](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#eventBridge)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="event-bridge-example",
            type="EVENT_BRIDGE",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "eventSource",
                    "value": "aws.partner/mydomain/myaccountid/name",
                },
                {
                    "key": "eventContent",
                    "value": "{ id: {{ json issueId }} }",
                },
            ])
        ```

        #### [SLACK](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#slack)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="slack-example",
            type="SLACK",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "channelId",
                    "value": "123456",
                },
                {
                    "key": "customDetailsSlack",
                    "value": "issue id - {{issueId}}",
                },
            ])
        ```

        #### [MICROSOFT_TEAMS](https://docs.newrelic.com/docs/alerts/get-notified/microsoft-teams-integrations/)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="ms-teams-example",
            type="MICROSOFT_TEAMS",
            destination_id="52d36b54-3d68-4ac4-9d0a-581febb91f2c",
            product="IINT",
            properties=[
                {
                    "key": "teamId",
                    "value": "906379b4-f5ac-40fd-b242-d4faaa4d3963",
                },
                {
                    "key": "channelId",
                    "value": "19:wk9tU4tSr335Y1cNiXOynredbi3lFoeabu0kybfmbBA1@thread.tacv2",
                },
                {
                    "key": "customDetails",
                    "value": "{{ nrAccountId }}",
                },
            ])
        ```

        > **NOTE:** Sensitive data such as channel API keys, service keys, etc are not returned from the underlying API for security reasons and may not be set in state when importing.

        ## Full Scenario Example

        Create a destination resource and reference that destination to the channel resource:

        ### Create a destination
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        webhook_destination = newrelic.NotificationDestination("webhook-destination",
            account_id="12345678",
            name="destination-webhook",
            type="WEBHOOK",
            properties=[{
                "key": "url",
                "value": "https://webhook.mywebhook.com",
            }],
            auth_basic={
                "user": "username",
                "password": "password",
            })
        ```

        ### Create a channel
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        webhook_channel = newrelic.NotificationChannel("webhook-channel",
            account_id="12345678",
            name="channel-webhook",
            type="WEBHOOK",
            destination_id=webhook_destination["id"],
            product="IINT",
            properties=[{
                "key": "payload",
                "value": "{name: foo}",
                "label": "Payload Template",
            }])
        ```

        ## Additional Information

        More details about the channels API can be found [here](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels).
        ### Moving from Legacy Alert Channels to Notification Channels
        As described in the documentation of this resource, channels can be created and managed using `NotificationDestination` and `NotificationChannel`. A combination of these resources is an alternative to the legacy resource `AlertChannel`, which is **deprecated** and will be **removed in a future major release**, as stated in the documentation of the resource.

        If you're currently using `AlertChannel` to manage channels, we **strongly recommend** migrating to these notifications-based resources at the earliest.

        Please refer to the examples in this page, or this example for illustrations on setting up channels with these resources.

        ## Import

        Channels can only be used by a single workflow, therefore importing them is not particularly useful, because in the UI channels are created upon workflow creation.

        Additionally, the channel id isn't available via the UI, and you'd need to look it up with the `channels` query in the NerdGraph API.

        That being said, importing is possible using -

        ```sh
        $ pulumi import newrelic:index/notificationChannel:NotificationChannel foo <destination_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Determines the New Relic account where the notification channel will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[builtins.bool] active: Indicates whether the channel is active.
        :param pulumi.Input[builtins.str] destination_id: The id of the destination.
        :param pulumi.Input[builtins.str] name: The name of the channel.
        :param pulumi.Input[builtins.str] product: The type of product.  One of: `DISCUSSIONS`, `ERROR_TRACKING` or `IINT` (workflows).
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationChannelPropertyArgs', 'NotificationChannelPropertyArgsDict']]]] properties: A nested block that describes a notification channel property. See Nested property blocks below for details.
        :param pulumi.Input[builtins.str] type: The type of channel.  One of: `EMAIL`, `SERVICENOW_INCIDENTS`, `SERVICE_NOW_APP`, `WEBHOOK`, `JIRA_CLASSIC`, `MOBILE_PUSH`, `EVENT_BRIDGE`, `SLACK` and `SLACK_COLLABORATION`, `PAGERDUTY_ACCOUNT_INTEGRATION`, `PAGERDUTY_SERVICE_INTEGRATION`, `MICROSOFT_TEAMS` or `WORKFLOW_AUTOMATION`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create and manage New Relic notification channels. Details regarding supported products and permissions can be found [here](https://docs.newrelic.com/docs/alerts-applied-intelligence/notifications/destinations).

        A channel is an entity that is used to configure notifications. It is also called a message template. It is a separate entity from workflows, but a channel is required in order to create a workflow.

        ## Example Usage

        ##### [Webhook](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#webhook)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="webhook-example",
            type="WEBHOOK",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[{
                "key": "payload",
                "value": "name: {{ foo }}",
                "label": "Payload Template",
            }])
        ```
        See additional examples.

        ## Additional Examples

        > **NOTE:** We support all properties. The mentioned properties are just an example.

        ##### [ServiceNow](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#servicenow)
        To see the properties’ keys for your account, check ServiceNow incidents table.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="servicenow-incident-example",
            type="SERVICENOW_INCIDENTS",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "description",
                    "value": "General description",
                },
                {
                    "key": "short_description",
                    "value": "Short description",
                },
            ])
        ```
        ##### [ServiceNowApp](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#servicenowapp)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="servicenow-app-example",
            type="SERVICE_NOW_APP",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT")
        ```

        ##### [Email](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#email)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="email-example",
            type="EMAIL",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "subject",
                    "value": "New Subject Title",
                },
                {
                    "key": "customDetailsEmail",
                    "value": "issue id - {{issueId}}",
                },
            ])
        ```

        ##### [Jira Classic](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#jira)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="jira-example",
            type="JIRA_CLASSIC",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="ERROR_TRACKING",
            properties=[
                {
                    "key": "project",
                    "value": "10000",
                    "label": "Project-Name",
                },
                {
                    "key": "issuetype",
                    "value": "10004",
                    "label": "Bug",
                },
                {
                    "key": "description",
                    "value": "Issue ID: {{ issueId }}",
                },
                {
                    "key": "summary",
                    "value": "{{ annotations.title.[0] }}",
                },
            ])
        ```

        ##### [PagerDuty with account integration](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#pagerduty)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="pagerduty-account-example",
            type="PAGERDUTY_ACCOUNT_INTEGRATION",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "summary",
                    "value": "General summary",
                },
                {
                    "key": "service",
                    "label": "Service Name",
                    "value": "PTQK3FM",
                },
                {
                    "key": "email",
                    "value": "example@email.com",
                },
                {
                    "key": "customDetails",
                    "value": \"\"\"{
        "id":{{json issueId}},
        "IssueURL":{{json issuePageUrl}},
        "NewRelic priority":{{json priority}},
        "Total Incidents":{{json totalIncidents}},
        "Impacted Entities":"{{#each entitiesData.names}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Runbook":"{{#each accumulations.runbookUrl}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Description":"{{#each annotations.description}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "isCorrelated":{{json isCorrelated}},
        "Alert Policy Names":"{{#each accumulations.policyName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Alert Condition Names":"{{#each accumulations.conditionName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Workflow Name":{{json workflowName}}
        }
        \"\"\",
                },
            ])
        ```

        ##### [PagerDuty with service integration](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#pagerduty)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="pagerduty-account-example",
            type="PAGERDUTY_SERVICE_INTEGRATION",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "summary",
                    "value": "General summary",
                },
                {
                    "key": "customDetails",
                    "value": \"\"\"{
        "id":{{json issueId}},
        "IssueURL":{{json issuePageUrl}},
        "NewRelic priority":{{json priority}},
        "Total Incidents":{{json totalIncidents}},
        "Impacted Entities":"{{#each entitiesData.names}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Runbook":"{{#each accumulations.runbookUrl}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Description":"{{#each annotations.description}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "isCorrelated":{{json isCorrelated}},
        "Alert Policy Names":"{{#each accumulations.policyName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Alert Condition Names":"{{#each accumulations.conditionName}}{{this}}{{#unless @last}}, {{/unless}}{{/each}}",
        "Workflow Name":{{json workflowName}}
        }
        \"\"\",
                },
            ])
        ```

        #### Mobile Push
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="mobile-push-example",
            type="MOBILE_PUSH",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT")
        ```

        #### [AWS Event Bridge](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#eventBridge)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="event-bridge-example",
            type="EVENT_BRIDGE",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "eventSource",
                    "value": "aws.partner/mydomain/myaccountid/name",
                },
                {
                    "key": "eventContent",
                    "value": "{ id: {{ json issueId }} }",
                },
            ])
        ```

        #### [SLACK](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels/#slack)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="slack-example",
            type="SLACK",
            destination_id="00b6bd1d-ac06-4d3d-bd72-49551e70f7a8",
            product="IINT",
            properties=[
                {
                    "key": "channelId",
                    "value": "123456",
                },
                {
                    "key": "customDetailsSlack",
                    "value": "issue id - {{issueId}}",
                },
            ])
        ```

        #### [MICROSOFT_TEAMS](https://docs.newrelic.com/docs/alerts/get-notified/microsoft-teams-integrations/)
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.NotificationChannel("foo",
            account_id="12345678",
            name="ms-teams-example",
            type="MICROSOFT_TEAMS",
            destination_id="52d36b54-3d68-4ac4-9d0a-581febb91f2c",
            product="IINT",
            properties=[
                {
                    "key": "teamId",
                    "value": "906379b4-f5ac-40fd-b242-d4faaa4d3963",
                },
                {
                    "key": "channelId",
                    "value": "19:wk9tU4tSr335Y1cNiXOynredbi3lFoeabu0kybfmbBA1@thread.tacv2",
                },
                {
                    "key": "customDetails",
                    "value": "{{ nrAccountId }}",
                },
            ])
        ```

        > **NOTE:** Sensitive data such as channel API keys, service keys, etc are not returned from the underlying API for security reasons and may not be set in state when importing.

        ## Full Scenario Example

        Create a destination resource and reference that destination to the channel resource:

        ### Create a destination
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        webhook_destination = newrelic.NotificationDestination("webhook-destination",
            account_id="12345678",
            name="destination-webhook",
            type="WEBHOOK",
            properties=[{
                "key": "url",
                "value": "https://webhook.mywebhook.com",
            }],
            auth_basic={
                "user": "username",
                "password": "password",
            })
        ```

        ### Create a channel
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        webhook_channel = newrelic.NotificationChannel("webhook-channel",
            account_id="12345678",
            name="channel-webhook",
            type="WEBHOOK",
            destination_id=webhook_destination["id"],
            product="IINT",
            properties=[{
                "key": "payload",
                "value": "{name: foo}",
                "label": "Payload Template",
            }])
        ```

        ## Additional Information

        More details about the channels API can be found [here](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-api-notifications-channels).
        ### Moving from Legacy Alert Channels to Notification Channels
        As described in the documentation of this resource, channels can be created and managed using `NotificationDestination` and `NotificationChannel`. A combination of these resources is an alternative to the legacy resource `AlertChannel`, which is **deprecated** and will be **removed in a future major release**, as stated in the documentation of the resource.

        If you're currently using `AlertChannel` to manage channels, we **strongly recommend** migrating to these notifications-based resources at the earliest.

        Please refer to the examples in this page, or this example for illustrations on setting up channels with these resources.

        ## Import

        Channels can only be used by a single workflow, therefore importing them is not particularly useful, because in the UI channels are created upon workflow creation.

        Additionally, the channel id isn't available via the UI, and you'd need to look it up with the `channels` query in the NerdGraph API.

        That being said, importing is possible using -

        ```sh
        $ pulumi import newrelic:index/notificationChannel:NotificationChannel foo <destination_id>
        ```

        :param str resource_name: The name of the resource.
        :param NotificationChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 product: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationChannelPropertyArgs', 'NotificationChannelPropertyArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationChannelArgs.__new__(NotificationChannelArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["active"] = active
            if destination_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_id'")
            __props__.__dict__["destination_id"] = destination_id
            __props__.__dict__["name"] = name
            if product is None and not opts.urn:
                raise TypeError("Missing required property 'product'")
            __props__.__dict__["product"] = product
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["status"] = None
        super(NotificationChannel, __self__).__init__(
            'newrelic:index/notificationChannel:NotificationChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            destination_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            product: Optional[pulumi.Input[builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationChannelPropertyArgs', 'NotificationChannelPropertyArgsDict']]]]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'NotificationChannel':
        """
        Get an existing NotificationChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Determines the New Relic account where the notification channel will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[builtins.bool] active: Indicates whether the channel is active.
        :param pulumi.Input[builtins.str] destination_id: The id of the destination.
        :param pulumi.Input[builtins.str] name: The name of the channel.
        :param pulumi.Input[builtins.str] product: The type of product.  One of: `DISCUSSIONS`, `ERROR_TRACKING` or `IINT` (workflows).
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationChannelPropertyArgs', 'NotificationChannelPropertyArgsDict']]]] properties: A nested block that describes a notification channel property. See Nested property blocks below for details.
        :param pulumi.Input[builtins.str] status: The status of the channel.
        :param pulumi.Input[builtins.str] type: The type of channel.  One of: `EMAIL`, `SERVICENOW_INCIDENTS`, `SERVICE_NOW_APP`, `WEBHOOK`, `JIRA_CLASSIC`, `MOBILE_PUSH`, `EVENT_BRIDGE`, `SLACK` and `SLACK_COLLABORATION`, `PAGERDUTY_ACCOUNT_INTEGRATION`, `PAGERDUTY_SERVICE_INTEGRATION`, `MICROSOFT_TEAMS` or `WORKFLOW_AUTOMATION`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationChannelState.__new__(_NotificationChannelState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["active"] = active
        __props__.__dict__["destination_id"] = destination_id
        __props__.__dict__["name"] = name
        __props__.__dict__["product"] = product
        __props__.__dict__["properties"] = properties
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return NotificationChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Determines the New Relic account where the notification channel will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the channel is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="destinationId")
    def destination_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the destination.
        """
        return pulumi.get(self, "destination_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the channel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> pulumi.Output[builtins.str]:
        """
        The type of product.  One of: `DISCUSSIONS`, `ERROR_TRACKING` or `IINT` (workflows).
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NotificationChannelProperty']]:
        """
        A nested block that describes a notification channel property. See Nested property blocks below for details.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the channel.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of channel.  One of: `EMAIL`, `SERVICENOW_INCIDENTS`, `SERVICE_NOW_APP`, `WEBHOOK`, `JIRA_CLASSIC`, `MOBILE_PUSH`, `EVENT_BRIDGE`, `SLACK` and `SLACK_COLLABORATION`, `PAGERDUTY_ACCOUNT_INTEGRATION`, `PAGERDUTY_SERVICE_INTEGRATION`, `MICROSOFT_TEAMS` or `WORKFLOW_AUTOMATION`.
        """
        return pulumi.get(self, "type")

