# MIT License
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# This file was compiled from a KSY format file downloaded from:
# https://github.com/kaitai-io/kaitai_struct_formats


# This is a generated file! Please edit source .ksy file and use kaitai-struct-compiler to rebuild

import kaitaistruct
from kaitaistruct import KaitaiStruct, KaitaiStream, BytesIO
from enum import Enum
import collections


if getattr(kaitaistruct, 'API_VERSION', (0, 9)) < (0, 9):
    raise Exception("Incompatible Kaitai Struct Python API: 0.9 or later is required, but you have %s" % (kaitaistruct.__version__))

class Dicom(KaitaiStruct):
    """DICOM (Digital Imaging and Communications in Medicine), AKA NEMA
    PS3, AKA ISO 12052:2006, is a file format and network protocol
    standard for medical imaging purposes. This parser covers file
    format, typically written by various medical equipment, such as
    radiography, computer tomography scans, MRT, ultrasonography, etc.
    
    DICOM defines two transfer syntaxes: implicit and explicit. This
    top-level parser attempts to autodetect and handle both of them. If
    any problems arise, one can use `file_explicit` and `file_implicit`
    subtypes to force parsing in particular transfer syntax.
    
    .. seealso::
       Source - https://dicom.nema.org/medical/dicom/current/output/html/part10.html#chapter_7
    """

    class Tags(Enum):
        file_meta_information_group_length = 131072
        file_meta_information_version = 131073
        media_storage_sop_class_uid = 131074
        media_storage_sop_instance_uid = 131075
        transfer_syntax_uid = 131088
        implementation_class_uid = 131090
        implementation_version_name = 131091
        source_application_entity_title = 131094
        sending_application_entity_title = 131095
        receiving_application_entity_title = 131096
        private_information_creator_uid = 131328
        private_information = 131330
        file_set_id = 266544
        file_set_descriptor_file_id = 266561
        specific_character_set_of_file_set_descriptor_file = 266562
        offset_of_the_first_directory_record_of_the_root_directory_entity = 266752
        offset_of_the_last_directory_record_of_the_root_directory_entity = 266754
        file_set_consistency_flag = 266770
        directory_record_sequence = 266784
        offset_of_the_next_directory_record = 267264
        record_in_use_flag = 267280
        offset_of_referenced_lower_level_directory_entity = 267296
        directory_record_type = 267312
        private_record_uid = 267314
        referenced_file_id = 267520
        mrdr_directory_record_offset = 267524
        referenced_sop_class_uid_in_file = 267536
        referenced_sop_instance_uid_in_file = 267537
        referenced_transfer_syntax_uid_in_file = 267538
        referenced_related_general_sop_class_uid_in_file = 267546
        number_of_references = 267776
        length_to_end = 524289
        specific_character_set = 524293
        language_code_sequence = 524294
        image_type = 524296
        recognition_code = 524304
        instance_creation_date = 524306
        instance_creation_time = 524307
        instance_creator_uid = 524308
        instance_coercion_datetime = 524309
        sop_class_uid = 524310
        sop_instance_uid = 524312
        related_general_sop_class_uid = 524314
        original_specialized_sop_class_uid = 524315
        study_date = 524320
        series_date = 524321
        acquisition_date = 524322
        content_date = 524323
        overlay_date = 524324
        curve_date = 524325
        acquisition_datetime = 524330
        study_time = 524336
        series_time = 524337
        acquisition_time = 524338
        content_time = 524339
        overlay_time = 524340
        curve_time = 524341
        data_set_type = 524352
        data_set_subtype = 524353
        nuclear_medicine_series_type = 524354
        accession_number = 524368
        issuer_of_accession_number_sequence = 524369
        query_retrieve_level = 524370
        query_retrieve_view = 524371
        retrieve_ae_title = 524372
        station_ae_title = 524373
        instance_availability = 524374
        failed_sop_instance_uid_list = 524376
        modality = 524384
        modalities_in_study = 524385
        sop_classes_in_study = 524386
        conversion_type = 524388
        presentation_intent_type = 524392
        manufacturer = 524400
        institution_name = 524416
        institution_address = 524417
        institution_code_sequence = 524418
        referring_physician_s_name = 524432
        referring_physician_s_address = 524434
        referring_physician_s_telephone_numbers = 524436
        referring_physician_identification_sequence = 524438
        consulting_physician_s_name = 524444
        consulting_physician_identification_sequence = 524445
        code_value = 524544
        extended_code_value = 524545
        coding_scheme_designator = 524546
        coding_scheme_version = 524547
        code_meaning = 524548
        mapping_resource = 524549
        context_group_version = 524550
        context_group_local_version = 524551
        extended_code_meaning = 524552
        context_group_extension_flag = 524555
        coding_scheme_uid = 524556
        context_group_extension_creator_uid = 524557
        context_identifier = 524559
        coding_scheme_identification_sequence = 524560
        coding_scheme_registry = 524562
        coding_scheme_external_id = 524564
        coding_scheme_name = 524565
        coding_scheme_responsible_organization = 524566
        context_uid = 524567
        mapping_resource_uid = 524568
        long_code_value = 524569
        urn_code_value = 524576
        equivalent_code_sequence = 524577
        mapping_resource_name = 524578
        context_group_identification_sequence = 524579
        mapping_resource_identification_sequence = 524580
        timezone_offset_from_utc = 524801
        private_data_element_characteristics_sequence = 525056
        private_group_reference = 525057
        private_creator_reference = 525058
        block_identifying_information_status = 525059
        nonidentifying_private_elements = 525060
        deidentification_action_sequence = 525061
        identifying_private_elements = 525062
        deidentification_action = 525063
        network_id = 528384
        station_name = 528400
        study_description = 528432
        procedure_code_sequence = 528434
        series_description = 528446
        series_description_code_sequence = 528447
        institutional_department_name = 528448
        physician_s__of_record = 528456
        physician_s__of_record_identification_sequence = 528457
        performing_physician_s_name = 528464
        performing_physician_identification_sequence = 528466
        name_of_physician_s__reading_study = 528480
        physician_s__reading_study_identification_sequence = 528482
        operators__name = 528496
        operator_identification_sequence = 528498
        admitting_diagnoses_description = 528512
        admitting_diagnoses_code_sequence = 528516
        manufacturer_s_model_name = 528528
        referenced_results_sequence = 528640
        referenced_study_sequence = 528656
        referenced_performed_procedure_step_sequence = 528657
        referenced_series_sequence = 528661
        referenced_patient_sequence = 528672
        referenced_visit_sequence = 528677
        referenced_overlay_sequence = 528688
        referenced_stereometric_instance_sequence = 528692
        referenced_waveform_sequence = 528698
        referenced_image_sequence = 528704
        referenced_curve_sequence = 528709
        referenced_instance_sequence = 528714
        referenced_real_world_value_mapping_instance_sequence = 528715
        referenced_sop_class_uid = 528720
        referenced_sop_instance_uid = 528725
        sop_classes_supported = 528730
        referenced_frame_number = 528736
        simple_frame_list = 528737
        calculated_frame_list = 528738
        time_range = 528739
        frame_extraction_sequence = 528740
        multi_frame_source_sop_instance_uid = 528743
        retrieve_url = 528784
        transaction_uid = 528789
        warning_reason = 528790
        failure_reason = 528791
        failed_sop_sequence = 528792
        referenced_sop_sequence = 528793
        other_failures_sequence = 528794
        studies_containing_other_referenced_instances_sequence = 528896
        related_series_sequence = 528976
        lossy_image_compression_retired = 532752
        derivation_description = 532753
        source_image_sequence = 532754
        stage_name = 532768
        stage_number = 532770
        number_of_stages = 532772
        view_name = 532775
        view_number = 532776
        number_of_event_timers = 532777
        number_of_views_in_stage = 532778
        event_elapsed_time_s_ = 532784
        event_timer_name_s_ = 532786
        event_timer_sequence = 532787
        event_time_offset = 532788
        event_code_sequence = 532789
        start_trim = 532802
        stop_trim = 532803
        recommended_display_frame_rate = 532804
        transducer_position = 532992
        transducer_orientation = 532996
        anatomic_structure = 533000
        anatomic_region_sequence = 533016
        anatomic_region_modifier_sequence = 533024
        primary_anatomic_structure_sequence = 533032
        anatomic_structure__space_or_region_sequence = 533033
        primary_anatomic_structure_modifier_sequence = 533040
        transducer_position_sequence = 533056
        transducer_position_modifier_sequence = 533058
        transducer_orientation_sequence = 533060
        transducer_orientation_modifier_sequence = 533062
        anatomic_structure_space_or_region_code_sequence__trial_ = 533073
        anatomic_portal_of_entrance_code_sequence__trial_ = 533075
        anatomic_approach_direction_code_sequence__trial_ = 533077
        anatomic_perspective_description__trial_ = 533078
        anatomic_perspective_code_sequence__trial_ = 533079
        anatomic_location_of_examining_instrument_description__trial_ = 533080
        anatomic_location_of_examining_instrument_code_sequence__trial_ = 533081
        anatomic_structure_space_or_region_modifier_code_sequence__trial_ = 533082
        on_axis_background_anatomic_structure_code_sequence__trial_ = 533084
        alternate_representation_sequence = 536577
        irradiation_event_uid = 536592
        source_irradiation_event_sequence = 536593
        radiopharmaceutical_administration_event_uid = 536594
        identifying_comments = 540672
        frame_type = 561159
        referenced_image_evidence_sequence = 561298
        referenced_raw_data_sequence = 561441
        creator_version_uid = 561443
        derivation_image_sequence = 561444
        source_image_evidence_sequence = 561492
        pixel_presentation = 561669
        volumetric_properties = 561670
        volume_based_calculation_technique = 561671
        complex_image_component = 561672
        acquisition_contrast = 561673
        derivation_code_sequence = 561685
        referenced_presentation_state_sequence = 561719
        referenced_other_plane_sequence = 562192
        frame_display_sequence = 562264
        recommended_display_frame_rate_in_float = 562265
        skip_frame_range_flag = 562272
        patient_s_name = 1048592
        patient_id = 1048608
        issuer_of_patient_id = 1048609
        type_of_patient_id = 1048610
        issuer_of_patient_id_qualifiers_sequence = 1048612
        source_patient_group_identification_sequence = 1048614
        group_of_patients_identification_sequence = 1048615
        subject_relative_position_in_image = 1048616
        patient_s_birth_date = 1048624
        patient_s_birth_time = 1048626
        patient_s_birth_date_in_alternative_calendar = 1048627
        patient_s_death_date_in_alternative_calendar = 1048628
        patient_s_alternative_calendar = 1048629
        patient_s_sex = 1048640
        patient_s_insurance_plan_code_sequence = 1048656
        patient_s_primary_language_code_sequence = 1048833
        patient_s_primary_language_modifier_code_sequence = 1048834
        quality_control_subject = 1049088
        quality_control_subject_type_code_sequence = 1049089
        strain_description = 1049106
        strain_nomenclature = 1049107
        strain_stock_number = 1049108
        strain_source_registry_code_sequence = 1049109
        strain_stock_sequence = 1049110
        strain_source = 1049111
        strain_additional_information = 1049112
        strain_code_sequence = 1049113
        other_patient_ids = 1052672
        other_patient_names = 1052673
        other_patient_ids_sequence = 1052674
        patient_s_birth_name = 1052677
        patient_s_age = 1052688
        patient_s_size = 1052704
        patient_s_size_code_sequence = 1052705
        patient_s_weight = 1052720
        patient_s_address = 1052736
        insurance_plan_identification = 1052752
        patient_s_mother_s_birth_name = 1052768
        military_rank = 1052800
        branch_of_service = 1052801
        medical_record_locator = 1052816
        referenced_patient_photo_sequence = 1052928
        medical_alerts = 1056768
        allergies = 1057040
        country_of_residence = 1057104
        region_of_residence = 1057106
        patient_s_telephone_numbers = 1057108
        patient_s_telecom_information = 1057109
        ethnic_group = 1057120
        occupation = 1057152
        smoking_status = 1057184
        additional_patient_history = 1057200
        pregnancy_status = 1057216
        last_menstrual_date = 1057232
        patient_s_religious_preference = 1057264
        patient_species_description = 1057281
        patient_species_code_sequence = 1057282
        patient_s_sex_neutered = 1057283
        anatomical_orientation_type = 1057296
        patient_breed_description = 1057426
        patient_breed_code_sequence = 1057427
        breed_registration_sequence = 1057428
        breed_registration_number = 1057429
        breed_registry_code_sequence = 1057430
        responsible_person = 1057431
        responsible_person_role = 1057432
        responsible_organization = 1057433
        patient_comments = 1064960
        examined_body_thickness = 1086513
        clinical_trial_sponsor_name = 1179664
        clinical_trial_protocol_id = 1179680
        clinical_trial_protocol_name = 1179681
        clinical_trial_site_id = 1179696
        clinical_trial_site_name = 1179697
        clinical_trial_subject_id = 1179712
        clinical_trial_subject_reading_id = 1179714
        clinical_trial_time_point_id = 1179728
        clinical_trial_time_point_description = 1179729
        clinical_trial_coordinating_center_name = 1179744
        patient_identity_removed = 1179746
        de_identification_method = 1179747
        de_identification_method_code_sequence = 1179748
        clinical_trial_series_id = 1179761
        clinical_trial_series_description = 1179762
        clinical_trial_protocol_ethics_committee_name = 1179777
        clinical_trial_protocol_ethics_committee_approval_number = 1179778
        consent_for_clinical_trial_use_sequence = 1179779
        distribution_type = 1179780
        consent_for_distribution_flag = 1179781
        cad_file_format = 1310755
        component_reference_system = 1310756
        component_manufacturing_procedure = 1310757
        component_manufacturer = 1310760
        material_thickness = 1310768
        material_pipe_diameter = 1310770
        material_isolation_diameter = 1310772
        material_grade = 1310786
        material_properties_description = 1310788
        material_properties_file_format__retired_ = 1310789
        material_notes = 1310790
        component_shape = 1310800
        curvature_type = 1310802
        outer_diameter = 1310804
        inner_diameter = 1310806
        component_welder_ids = 1310976
        secondary_approval_status = 1310977
        secondary_review_date = 1310978
        secondary_review_time = 1310979
        secondary_reviewer_name = 1310980
        repair_id = 1310981
        multiple_component_approval_sequence = 1310982
        other_approval_status = 1310983
        other_secondary_approval_status = 1310984
        actual_environmental_conditions = 1314832
        expiry_date = 1314848
        environmental_conditions = 1314880
        evaluator_sequence = 1318914
        evaluator_number = 1318916
        evaluator_name = 1318918
        evaluation_attempt = 1318920
        indication_sequence = 1318930
        indication_number = 1318932
        indication_label = 1318934
        indication_description = 1318936
        indication_type = 1318938
        indication_disposition = 1318940
        indication_roi_sequence = 1318942
        indication_physical_property_sequence = 1318960
        property_label = 1318962
        coordinate_system_number_of_axes = 1319426
        coordinate_system_axes_sequence = 1319428
        coordinate_system_axis_description = 1319430
        coordinate_system_data_set_mapping = 1319432
        coordinate_system_axis_number = 1319434
        coordinate_system_axis_type = 1319436
        coordinate_system_axis_units = 1319438
        coordinate_system_axis_values = 1319440
        coordinate_system_transform_sequence = 1319456
        transform_description = 1319458
        transform_number_of_axes = 1319460
        transform_order_of_axes = 1319462
        transformed_axis_units = 1319464
        coordinate_system_transform_rotation_and_scale_matrix = 1319466
        coordinate_system_transform_translation_matrix = 1319468
        internal_detector_frame_time = 1323025
        number_of_frames_integrated = 1323026
        detector_temperature_sequence = 1323040
        sensor_name = 1323042
        horizontal_offset_of_sensor = 1323044
        vertical_offset_of_sensor = 1323046
        sensor_temperature = 1323048
        dark_current_sequence = 1323072
        dark_current_counts = 1323088
        gain_correction_reference_sequence = 1323104
        air_counts = 1323120
        kv_used_in_gain_calibration = 1323121
        ma_used_in_gain_calibration = 1323122
        number_of_frames_used_for_integration = 1323123
        filter_material_used_in_gain_calibration = 1323124
        filter_thickness_used_in_gain_calibration = 1323125
        date_of_gain_calibration = 1323126
        time_of_gain_calibration = 1323127
        bad_pixel_image = 1323136
        calibration_notes = 1323161
        pulser_equipment_sequence = 1327106
        pulser_type = 1327108
        pulser_notes = 1327110
        receiver_equipment_sequence = 1327112
        amplifier_type = 1327114
        receiver_notes = 1327116
        pre_amplifier_equipment_sequence = 1327118
        pre_amplifier_notes = 1327119
        transmit_transducer_sequence = 1327120
        receive_transducer_sequence = 1327121
        number_of_elements = 1327122
        element_shape = 1327123
        element_dimension_a = 1327124
        element_dimension_b = 1327125
        element_pitch_a = 1327126
        measured_beam_dimension_a = 1327127
        measured_beam_dimension_b = 1327128
        location_of_measured_beam_diameter = 1327129
        nominal_frequency = 1327130
        measured_center_frequency = 1327131
        measured_bandwidth = 1327132
        element_pitch_b = 1327133
        pulser_settings_sequence = 1327136
        pulse_width = 1327138
        excitation_frequency = 1327140
        modulation_type = 1327142
        damping = 1327144
        receiver_settings_sequence = 1327152
        acquired_soundpath_length = 1327153
        acquisition_compression_type = 1327154
        acquisition_sample_size = 1327155
        rectifier_smoothing = 1327156
        dac_sequence = 1327157
        dac_type = 1327158
        dac_gain_points = 1327160
        dac_time_points = 1327162
        dac_amplitude = 1327164
        pre_amplifier_settings_sequence = 1327168
        transmit_transducer_settings_sequence = 1327184
        receive_transducer_settings_sequence = 1327185
        incident_angle = 1327186
        coupling_technique = 1327188
        coupling_medium = 1327190
        coupling_velocity = 1327191
        probe_center_location_x = 1327192
        probe_center_location_z = 1327193
        sound_path_length = 1327194
        delay_law_identifier = 1327196
        gate_settings_sequence = 1327200
        gate_threshold = 1327202
        velocity_of_sound = 1327204
        calibration_settings_sequence = 1327216
        calibration_procedure = 1327218
        procedure_version = 1327220
        procedure_creation_date = 1327222
        procedure_expiration_date = 1327224
        procedure_last_modified_date = 1327226
        calibration_time = 1327228
        calibration_date = 1327230
        probe_drive_equipment_sequence = 1327232
        drive_type = 1327233
        probe_drive_notes = 1327234
        drive_probe_sequence = 1327235
        probe_inductance = 1327236
        probe_resistance = 1327237
        receive_probe_sequence = 1327238
        probe_drive_settings_sequence = 1327239
        bridge_resistors = 1327240
        probe_orientation_angle = 1327241
        user_selected_gain_y = 1327243
        user_selected_phase = 1327244
        user_selected_offset_x = 1327245
        user_selected_offset_y = 1327246
        channel_settings_sequence = 1327249
        channel_threshold = 1327250
        scanner_settings_sequence = 1327258
        scan_procedure = 1327259
        translation_rate_x = 1327260
        translation_rate_y = 1327261
        channel_overlap = 1327263
        image_quality_indicator_type = 1327264
        image_quality_indicator_material = 1327265
        image_quality_indicator_size = 1327266
        linac_energy = 1331202
        linac_output = 1331204
        active_aperture = 1331456
        total_aperture = 1331457
        aperture_elevation = 1331458
        main_lobe_angle = 1331459
        main_roof_angle = 1331460
        connector_type = 1331461
        wedge_model_number = 1331462
        wedge_angle_float = 1331463
        wedge_roof_angle = 1331464
        wedge_element_1_position = 1331465
        wedge_material_velocity = 1331466
        wedge_material = 1331467
        wedge_offset_z = 1331468
        wedge_origin_offset_x = 1331469
        wedge_time_delay = 1331470
        wedge_name = 1331471
        wedge_manufacturer_name = 1331472
        wedge_description = 1331473
        nominal_beam_angle = 1331474
        wedge_offset_x = 1331475
        wedge_offset_y = 1331476
        wedge_total_length = 1331477
        wedge_in_contact_length = 1331478
        wedge_front_gap = 1331479
        wedge_total_height = 1331480
        wedge_front_height = 1331481
        wedge_rear_height = 1331482
        wedge_total_width = 1331483
        wedge_in_contact_width = 1331484
        wedge_chamfer_height = 1331485
        wedge_curve = 1331486
        radius_along_the_wedge = 1331487
        contrast_bolus_agent = 1572880
        contrast_bolus_agent_sequence = 1572882
        contrast_bolus_t1_relaxivity = 1572883
        contrast_bolus_administration_route_sequence = 1572884
        body_part_examined = 1572885
        scanning_sequence = 1572896
        sequence_variant = 1572897
        scan_options = 1572898
        mr_acquisition_type = 1572899
        sequence_name = 1572900
        angio_flag = 1572901
        intervention_drug_information_sequence = 1572902
        intervention_drug_stop_time = 1572903
        intervention_drug_dose = 1572904
        intervention_drug_code_sequence = 1572905
        additional_drug_sequence = 1572906
        radionuclide = 1572912
        radiopharmaceutical = 1572913
        energy_window_centerline = 1572914
        energy_window_total_width = 1572915
        intervention_drug_name = 1572916
        intervention_drug_start_time = 1572917
        intervention_sequence = 1572918
        therapy_type = 1572919
        intervention_status = 1572920
        therapy_description = 1572921
        intervention_description = 1572922
        cine_rate = 1572928
        initial_cine_run_state = 1572930
        slice_thickness = 1572944
        kvp = 1572960
        counts_accumulated = 1572976
        acquisition_termination_condition = 1572977
        effective_duration = 1572978
        acquisition_start_condition = 1572979
        acquisition_start_condition_data = 1572980
        acquisition_termination_condition_data = 1572981
        repetition_time = 1572992
        echo_time = 1572993
        inversion_time = 1572994
        number_of_averages = 1572995
        imaging_frequency = 1572996
        imaged_nucleus = 1572997
        echo_number_s_ = 1572998
        magnetic_field_strength = 1572999
        spacing_between_slices = 1573000
        number_of_phase_encoding_steps = 1573001
        data_collection_diameter = 1573008
        echo_train_length = 1573009
        percent_sampling = 1573011
        percent_phase_field_of_view = 1573012
        pixel_bandwidth = 1573013
        device_serial_number = 1576960
        device_uid = 1576962
        device_id = 1576963
        plate_id = 1576964
        generator_id = 1576965
        grid_id = 1576966
        cassette_id = 1576967
        gantry_id = 1576968
        secondary_capture_device_id = 1576976
        hardcopy_creation_device_id = 1576977
        date_of_secondary_capture = 1576978
        time_of_secondary_capture = 1576980
        secondary_capture_device_manufacturer = 1576982
        hardcopy_device_manufacturer = 1576983
        secondary_capture_device_manufacturer_s_model_name = 1576984
        secondary_capture_device_software_versions = 1576985
        hardcopy_device_software_version = 1576986
        hardcopy_device_manufacturer_s_model_name = 1576987
        software_version_s_ = 1576992
        video_image_format_acquired = 1576994
        digital_image_format_acquired = 1576995
        protocol_name = 1577008
        contrast_bolus_route = 1577024
        contrast_bolus_volume = 1577025
        contrast_bolus_start_time = 1577026
        contrast_bolus_stop_time = 1577027
        contrast_bolus_total_dose = 1577028
        syringe_counts = 1577029
        contrast_flow_rate = 1577030
        contrast_flow_duration = 1577031
        contrast_bolus_ingredient = 1577032
        contrast_bolus_ingredient_concentration = 1577033
        spatial_resolution = 1577040
        trigger_time = 1577056
        trigger_source_or_type = 1577057
        nominal_interval = 1577058
        frame_time = 1577059
        cardiac_framing_type = 1577060
        frame_time_vector = 1577061
        frame_delay = 1577062
        image_trigger_delay = 1577063
        multiplex_group_time_offset = 1577064
        trigger_time_offset = 1577065
        synchronization_trigger = 1577066
        synchronization_channel = 1577068
        trigger_sample_position = 1577070
        radiopharmaceutical_route = 1577072
        radiopharmaceutical_volume = 1577073
        radiopharmaceutical_start_time = 1577074
        radiopharmaceutical_stop_time = 1577075
        radionuclide_total_dose = 1577076
        radionuclide_half_life = 1577077
        radionuclide_positron_fraction = 1577078
        radiopharmaceutical_specific_activity = 1577079
        radiopharmaceutical_start_datetime = 1577080
        radiopharmaceutical_stop_datetime = 1577081
        beat_rejection_flag = 1577088
        low_r_r_value = 1577089
        high_r_r_value = 1577090
        intervals_acquired = 1577091
        intervals_rejected = 1577092
        pvc_rejection = 1577093
        skip_beats = 1577094
        heart_rate = 1577096
        cardiac_number_of_images = 1577104
        trigger_window = 1577108
        reconstruction_diameter = 1577216
        distance_source_to_detector = 1577232
        distance_source_to_patient = 1577233
        estimated_radiographic_magnification_factor = 1577236
        gantry_detector_tilt = 1577248
        gantry_detector_slew = 1577249
        table_height = 1577264
        table_traverse = 1577265
        table_motion = 1577268
        table_vertical_increment = 1577269
        table_lateral_increment = 1577270
        table_longitudinal_increment = 1577271
        table_angle = 1577272
        table_type = 1577274
        rotation_direction = 1577280
        angular_position = 1577281
        radial_position = 1577282
        scan_arc = 1577283
        angular_step = 1577284
        center_of_rotation_offset = 1577285
        rotation_offset = 1577286
        field_of_view_shape = 1577287
        field_of_view_dimension_s_ = 1577289
        exposure_time = 1577296
        x_ray_tube_current = 1577297
        exposure = 1577298
        exposure_in__as = 1577299
        average_pulse_width = 1577300
        radiation_setting = 1577301
        rectification_type = 1577302
        radiation_mode = 1577306
        image_and_fluoroscopy_area_dose_product = 1577310
        filter_type = 1577312
        type_of_filters = 1577313
        intensifier_size = 1577314
        imager_pixel_spacing = 1577316
        grid = 1577318
        generator_power = 1577328
        collimator_grid_name = 1577344
        collimator_type = 1577345
        focal_distance = 1577346
        x_focus_center = 1577347
        y_focus_center = 1577348
        focal_spot_s_ = 1577360
        anode_target_material = 1577361
        body_part_thickness = 1577376
        compression_force = 1577378
        paddle_description = 1577380
        date_of_last_calibration = 1577472
        time_of_last_calibration = 1577473
        datetime_of_last_calibration = 1577474
        convolution_kernel = 1577488
        upper_lower_pixel_values = 1577536
        actual_frame_duration = 1577538
        count_rate = 1577539
        preferred_playback_sequencing = 1577540
        receive_coil_name = 1577552
        transmit_coil_name = 1577553
        plate_type = 1577568
        phosphor_type = 1577569
        water_equivalent_diameter = 1577585
        water_equivalent_diameter_calculation_method_code_sequence = 1577586
        scan_velocity = 1577728
        whole_body_technique = 1577729
        scan_length = 1577730
        acquisition_matrix = 1577744
        in_plane_phase_encoding_direction = 1577746
        flip_angle = 1577748
        variable_flip_angle_flag = 1577749
        sar = 1577750
        db_dt = 1577752
        b1rms = 1577760
        acquisition_device_processing_description = 1577984
        acquisition_device_processing_code = 1577985
        cassette_orientation = 1577986
        cassette_size = 1577987
        exposures_on_plate = 1577988
        relative_x_ray_exposure = 1577989
        exposure_index = 1578001
        target_exposure_index = 1578002
        deviation_index = 1578003
        column_angulation = 1578064
        tomo_layer_height = 1578080
        tomo_angle = 1578096
        tomo_time = 1578112
        tomo_type = 1578128
        tomo_class = 1578129
        number_of_tomosynthesis_source_images = 1578133
        positioner_motion = 1578240
        positioner_type = 1578248
        positioner_primary_angle = 1578256
        positioner_secondary_angle = 1578257
        positioner_primary_angle_increment = 1578272
        positioner_secondary_angle_increment = 1578273
        detector_primary_angle = 1578288
        detector_secondary_angle = 1578289
        shutter_shape = 1578496
        shutter_left_vertical_edge = 1578498
        shutter_right_vertical_edge = 1578500
        shutter_upper_horizontal_edge = 1578502
        shutter_lower_horizontal_edge = 1578504
        center_of_circular_shutter = 1578512
        radius_of_circular_shutter = 1578514
        vertices_of_the_polygonal_shutter = 1578528
        shutter_presentation_value = 1578530
        shutter_overlay_group = 1578531
        shutter_presentation_color_cielab_value = 1578532
        collimator_shape = 1578752
        collimator_left_vertical_edge = 1578754
        collimator_right_vertical_edge = 1578756
        collimator_upper_horizontal_edge = 1578758
        collimator_lower_horizontal_edge = 1578760
        center_of_circular_collimator = 1578768
        radius_of_circular_collimator = 1578770
        vertices_of_the_polygonal_collimator = 1578784
        acquisition_time_synchronized = 1579008
        time_source = 1579009
        time_distribution_protocol = 1579010
        ntp_source_address = 1579011
        page_number_vector = 1581057
        frame_label_vector = 1581058
        frame_primary_angle_vector = 1581059
        frame_secondary_angle_vector = 1581060
        slice_location_vector = 1581061
        display_window_label_vector = 1581062
        nominal_scanned_pixel_spacing = 1581072
        digitizing_device_transport_direction = 1581088
        rotation_of_scanned_film = 1581104
        biopsy_target_sequence = 1581121
        target_uid = 1581122
        localizing_cursor_position = 1581123
        calculated_target_position = 1581124
        target_label = 1581125
        displayed_z_value = 1581126
        ivus_acquisition = 1585408
        ivus_pullback_rate = 1585409
        ivus_gated_rate = 1585410
        ivus_pullback_start_frame_number = 1585411
        ivus_pullback_stop_frame_number = 1585412
        lesion_number = 1585413
        acquisition_comments = 1589248
        output_power = 1593344
        transducer_data = 1593360
        focus_depth = 1593362
        processing_function = 1593376
        postprocessing_function = 1593377
        mechanical_index = 1593378
        bone_thermal_index = 1593380
        cranial_thermal_index = 1593382
        soft_tissue_thermal_index = 1593383
        soft_tissue_focus_thermal_index = 1593384
        soft_tissue_surface_thermal_index = 1593385
        dynamic_range = 1593392
        total_gain = 1593408
        depth_of_scan_field = 1593424
        patient_position = 1593600
        view_position = 1593601
        projection_eponymous_name_code_sequence = 1593604
        image_transformation_matrix = 1593872
        image_translation_vector = 1593874
        sensitivity = 1597440
        sequence_of_ultrasound_regions = 1597457
        region_spatial_format = 1597458
        region_data_type = 1597460
        region_flags = 1597462
        region_location_min_x0 = 1597464
        region_location_min_y0 = 1597466
        region_location_max_x1 = 1597468
        region_location_max_y1 = 1597470
        reference_pixel_x0 = 1597472
        reference_pixel_y0 = 1597474
        physical_units_x_direction = 1597476
        physical_units_y_direction = 1597478
        reference_pixel_physical_value_x = 1597480
        reference_pixel_physical_value_y = 1597482
        physical_delta_x = 1597484
        physical_delta_y = 1597486
        transducer_frequency = 1597488
        transducer_type = 1597489
        pulse_repetition_frequency = 1597490
        doppler_correction_angle = 1597492
        steering_angle = 1597494
        doppler_sample_volume_x_position__retired_ = 1597496
        doppler_sample_volume_x_position = 1597497
        doppler_sample_volume_y_position__retired_ = 1597498
        doppler_sample_volume_y_position = 1597499
        tm_line_position_x0__retired_ = 1597500
        tm_line_position_x0 = 1597501
        tm_line_position_y0__retired_ = 1597502
        tm_line_position_y0 = 1597503
        tm_line_position_x1__retired_ = 1597504
        tm_line_position_x1 = 1597505
        tm_line_position_y1__retired_ = 1597506
        tm_line_position_y1 = 1597507
        pixel_component_organization = 1597508
        pixel_component_mask = 1597510
        pixel_component_range_start = 1597512
        pixel_component_range_stop = 1597514
        pixel_component_physical_units = 1597516
        pixel_component_data_type = 1597518
        number_of_table_break_points = 1597520
        table_of_x_break_points = 1597522
        table_of_y_break_points = 1597524
        number_of_table_entries = 1597526
        table_of_pixel_values = 1597528
        table_of_parameter_values = 1597530
        r_wave_time_vector = 1597536
        detector_conditions_nominal_flag = 1601536
        detector_temperature = 1601537
        detector_type = 1601540
        detector_configuration = 1601541
        detector_description = 1601542
        detector_mode = 1601544
        detector_id = 1601546
        date_of_last_detector_calibration = 1601548
        time_of_last_detector_calibration = 1601550
        exposures_on_detector_since_last_calibration = 1601552
        exposures_on_detector_since_manufactured = 1601553
        detector_time_since_last_exposure = 1601554
        detector_active_time = 1601556
        detector_activation_offset_from_exposure = 1601558
        detector_binning = 1601562
        detector_element_physical_size = 1601568
        detector_element_spacing = 1601570
        detector_active_shape = 1601572
        detector_active_dimension_s_ = 1601574
        detector_active_origin = 1601576
        detector_manufacturer_name = 1601578
        detector_manufacturer_s_model_name = 1601579
        field_of_view_origin = 1601584
        field_of_view_rotation = 1601586
        field_of_view_horizontal_flip = 1601588
        pixel_data_area_origin_relative_to_fov = 1601590
        pixel_data_area_rotation_angle_relative_to_fov = 1601592
        grid_absorbing_material = 1601600
        grid_spacing_material = 1601601
        grid_thickness = 1601602
        grid_pitch = 1601604
        grid_aspect_ratio = 1601606
        grid_period = 1601608
        grid_focal_distance = 1601612
        filter_material = 1601616
        filter_thickness_minimum = 1601618
        filter_thickness_maximum = 1601620
        filter_beam_path_length_minimum = 1601622
        filter_beam_path_length_maximum = 1601624
        exposure_control_mode = 1601632
        exposure_control_mode_description = 1601634
        exposure_status = 1601636
        phototimer_setting = 1601637
        exposure_time_in__s = 1605968
        x_ray_tube_current_in__a = 1605969
        content_qualification = 1609732
        pulse_sequence_name = 1609733
        mr_imaging_modifier_sequence = 1609734
        echo_pulse_sequence = 1609736
        inversion_recovery = 1609737
        flow_compensation = 1609744
        multiple_spin_echo = 1609745
        multi_planar_excitation = 1609746
        phase_contrast = 1609748
        time_of_flight_contrast = 1609749
        spoiling = 1609750
        steady_state_pulse_sequence = 1609751
        echo_planar_pulse_sequence = 1609752
        tag_angle_first_axis = 1609753
        magnetization_transfer = 1609760
        t2_preparation = 1609761
        blood_signal_nulling = 1609762
        saturation_recovery = 1609764
        spectrally_selected_suppression = 1609765
        spectrally_selected_excitation = 1609766
        spatial_pre_saturation = 1609767
        tagging = 1609768
        oversampling_phase = 1609769
        tag_spacing_first_dimension = 1609776
        geometry_of_k_space_traversal = 1609778
        segmented_k_space_traversal = 1609779
        rectilinear_phase_encode_reordering = 1609780
        tag_thickness = 1609781
        partial_fourier_direction = 1609782
        cardiac_synchronization_technique = 1609783
        receive_coil_manufacturer_name = 1609793
        mr_receive_coil_sequence = 1609794
        receive_coil_type = 1609795
        quadrature_receive_coil = 1609796
        multi_coil_definition_sequence = 1609797
        multi_coil_configuration = 1609798
        multi_coil_element_name = 1609799
        multi_coil_element_used = 1609800
        mr_transmit_coil_sequence = 1609801
        transmit_coil_manufacturer_name = 1609808
        transmit_coil_type = 1609809
        spectral_width = 1609810
        chemical_shift_reference = 1609811
        volume_localization_technique = 1609812
        mr_acquisition_frequency_encoding_steps = 1609816
        de_coupling = 1609817
        de_coupled_nucleus = 1609824
        de_coupling_frequency = 1609825
        de_coupling_method = 1609826
        de_coupling_chemical_shift_reference = 1609827
        k_space_filtering = 1609828
        time_domain_filtering = 1609829
        number_of_zero_fills = 1609830
        baseline_correction = 1609831
        parallel_reduction_factor_in_plane = 1609833
        cardiac_r_r_interval_specified = 1609840
        acquisition_duration = 1609843
        frame_acquisition_datetime = 1609844
        diffusion_directionality = 1609845
        diffusion_gradient_direction_sequence = 1609846
        parallel_acquisition = 1609847
        parallel_acquisition_technique = 1609848
        inversion_times = 1609849
        metabolite_map_description = 1609856
        partial_fourier = 1609857
        effective_echo_time = 1609858
        metabolite_map_code_sequence = 1609859
        chemical_shift_sequence = 1609860
        cardiac_signal_source = 1609861
        diffusion_b_value = 1609863
        diffusion_gradient_orientation = 1609865
        velocity_encoding_direction = 1609872
        velocity_encoding_minimum_value = 1609873
        velocity_encoding_acquisition_sequence = 1609874
        number_of_k_space_trajectories = 1609875
        coverage_of_k_space = 1609876
        spectroscopy_acquisition_phase_rows = 1609877
        parallel_reduction_factor_in_plane__retired_ = 1609878
        transmitter_frequency = 1609880
        resonant_nucleus = 1609984
        frequency_correction = 1609985
        mr_spectroscopy_fov_geometry_sequence = 1609987
        slab_thickness = 1609988
        slab_orientation = 1609989
        mid_slab_position = 1609990
        mr_spatial_saturation_sequence = 1609991
        mr_timing_and_related_parameters_sequence = 1610002
        mr_echo_sequence = 1610004
        mr_modifier_sequence = 1610005
        mr_diffusion_sequence = 1610007
        cardiac_synchronization_sequence = 1610008
        mr_averages_sequence = 1610009
        mr_fov_geometry_sequence = 1610021
        volume_localization_sequence = 1610022
        spectroscopy_acquisition_data_columns = 1610023
        diffusion_anisotropy_type = 1610055
        frame_reference_datetime = 1610065
        mr_metabolite_map_sequence = 1610066
        parallel_reduction_factor_out_of_plane = 1610069
        spectroscopy_acquisition_out_of_plane_phase_steps = 1610073
        bulk_motion_status = 1610086
        parallel_reduction_factor_second_in_plane = 1610088
        cardiac_beat_rejection_technique = 1610089
        respiratory_motion_compensation_technique = 1610096
        respiratory_signal_source = 1610097
        bulk_motion_compensation_technique = 1610098
        bulk_motion_signal_source = 1610099
        applicable_safety_standard_agency = 1610100
        applicable_safety_standard_description = 1610101
        operating_mode_sequence = 1610102
        operating_mode_type = 1610103
        operating_mode = 1610104
        specific_absorption_rate_definition = 1610105
        gradient_output_type = 1610112
        specific_absorption_rate_value = 1610113
        gradient_output = 1610114
        flow_compensation_direction = 1610115
        tagging_delay = 1610116
        respiratory_motion_compensation_technique_description = 1610117
        respiratory_signal_source_id = 1610118
        chemical_shift_minimum_integration_limit_in_hz = 1610133
        chemical_shift_maximum_integration_limit_in_hz = 1610134
        mr_velocity_encoding_sequence = 1610135
        first_order_phase_correction = 1610136
        water_referenced_phase_correction = 1610137
        mr_spectroscopy_acquisition_type = 1610240
        respiratory_cycle_position = 1610260
        velocity_encoding_maximum_value = 1610263
        tag_spacing_second_dimension = 1610264
        tag_angle_second_axis = 1610265
        frame_acquisition_duration = 1610272
        mr_image_frame_type_sequence = 1610278
        mr_spectroscopy_frame_type_sequence = 1610279
        mr_acquisition_phase_encoding_steps_in_plane = 1610289
        mr_acquisition_phase_encoding_steps_out_of_plane = 1610290
        spectroscopy_acquisition_phase_columns = 1610292
        cardiac_cycle_position = 1610294
        specific_absorption_rate_sequence = 1610297
        rf_echo_train_length = 1610304
        gradient_echo_train_length = 1610305
        arterial_spin_labeling_contrast = 1610320
        mr_arterial_spin_labeling_sequence = 1610321
        asl_technique_description = 1610322
        asl_slab_number = 1610323
        asl_slab_thickness = 1610324
        asl_slab_orientation = 1610325
        asl_mid_slab_position = 1610326
        asl_context = 1610327
        asl_pulse_train_duration = 1610328
        asl_crusher_flag = 1610329
        asl_crusher_flow_limit = 1610330
        asl_crusher_description = 1610331
        asl_bolus_cut_off_flag = 1610332
        asl_bolus_cut_off_timing_sequence = 1610333
        asl_bolus_cut_off_technique = 1610334
        asl_bolus_cut_off_delay_time = 1610335
        asl_slab_sequence = 1610336
        chemical_shift_minimum_integration_limit_in_ppm = 1610389
        chemical_shift_maximum_integration_limit_in_ppm = 1610390
        water_reference_acquisition = 1610391
        echo_peak_position = 1610392
        ct_acquisition_type_sequence = 1610497
        acquisition_type = 1610498
        tube_angle = 1610499
        ct_acquisition_details_sequence = 1610500
        revolution_time = 1610501
        single_collimation_width = 1610502
        total_collimation_width = 1610503
        ct_table_dynamics_sequence = 1610504
        table_speed = 1610505
        table_feed_per_rotation = 1610512
        spiral_pitch_factor = 1610513
        ct_geometry_sequence = 1610514
        data_collection_center__patient_ = 1610515
        ct_reconstruction_sequence = 1610516
        reconstruction_algorithm = 1610517
        convolution_kernel_group = 1610518
        reconstruction_field_of_view = 1610519
        reconstruction_target_center__patient_ = 1610520
        reconstruction_angle = 1610521
        image_filter = 1610528
        ct_exposure_sequence = 1610529
        reconstruction_pixel_spacing = 1610530
        exposure_modulation_type = 1610531
        estimated_dose_saving = 1610532
        ct_x_ray_details_sequence = 1610533
        ct_position_sequence = 1610534
        table_position = 1610535
        exposure_time_in_ms = 1610536
        ct_image_frame_type_sequence = 1610537
        x_ray_tube_current_in_ma = 1610544
        exposure_in_mas = 1610546
        constant_volume_flag = 1610547
        fluoroscopy_flag = 1610548
        distance_source_to_data_collection_center = 1610549
        contrast_bolus_agent_number = 1610551
        contrast_bolus_ingredient_code_sequence = 1610552
        contrast_administration_profile_sequence = 1610560
        contrast_bolus_usage_sequence = 1610561
        contrast_bolus_agent_administered = 1610562
        contrast_bolus_agent_detected = 1610563
        contrast_bolus_agent_phase = 1610564
        ctdivol = 1610565
        ctdi_phantom_type_code_sequence = 1610566
        calcium_scoring_mass_factor_patient = 1610577
        calcium_scoring_mass_factor_device = 1610578
        energy_weighting_factor = 1610579
        ct_additional_x_ray_source_sequence = 1610592
        projection_pixel_calibration_sequence = 1610753
        distance_source_to_isocenter = 1610754
        distance_object_to_table_top = 1610755
        object_pixel_spacing_in_center_of_beam = 1610756
        positioner_position_sequence = 1610757
        table_position_sequence = 1610758
        collimator_shape_sequence = 1610759
        planes_in_acquisition = 1610768
        xa_xrf_frame_characteristics_sequence = 1610770
        frame_acquisition_sequence = 1610775
        x_ray_receptor_type = 1610784
        acquisition_protocol_name = 1610787
        acquisition_protocol_description = 1610788
        contrast_bolus_ingredient_opaque = 1610789
        distance_receptor_plane_to_detector_housing = 1610790
        intensifier_active_shape = 1610791
        intensifier_active_dimension_s_ = 1610792
        physical_detector_size = 1610793
        position_of_isocenter_projection = 1610800
        field_of_view_sequence = 1610802
        field_of_view_description = 1610803
        exposure_control_sensing_regions_sequence = 1610804
        exposure_control_sensing_region_shape = 1610805
        exposure_control_sensing_region_left_vertical_edge = 1610806
        exposure_control_sensing_region_right_vertical_edge = 1610807
        exposure_control_sensing_region_upper_horizontal_edge = 1610808
        exposure_control_sensing_region_lower_horizontal_edge = 1610809
        center_of_circular_exposure_control_sensing_region = 1610816
        radius_of_circular_exposure_control_sensing_region = 1610817
        vertices_of_the_polygonal_exposure_control_sensing_region = 1610818
        column_angulation__patient_ = 1610823
        beam_angle = 1610825
        frame_detector_parameters_sequence = 1610833
        calculated_anatomy_thickness = 1610834
        calibration_sequence = 1610837
        object_thickness_sequence = 1610838
        plane_identification = 1610839
        field_of_view_dimension_s__in_float = 1610849
        isocenter_reference_system_sequence = 1610850
        positioner_isocenter_primary_angle = 1610851
        positioner_isocenter_secondary_angle = 1610852
        positioner_isocenter_detector_rotation_angle = 1610853
        table_x_position_to_isocenter = 1610854
        table_y_position_to_isocenter = 1610855
        table_z_position_to_isocenter = 1610856
        table_horizontal_rotation_angle = 1610857
        table_head_tilt_angle = 1610864
        table_cradle_tilt_angle = 1610865
        frame_display_shutter_sequence = 1610866
        acquired_image_area_dose_product = 1610867
        c_arm_positioner_tabletop_relationship = 1610868
        x_ray_geometry_sequence = 1610870
        irradiation_event_identification_sequence = 1610871
        x_ray_3d_frame_type_sequence = 1611012
        contributing_sources_sequence = 1611014
        x_ray_3d_acquisition_sequence = 1611015
        primary_positioner_scan_arc = 1611016
        secondary_positioner_scan_arc = 1611017
        primary_positioner_scan_start_angle = 1611024
        secondary_positioner_scan_start_angle = 1611025
        primary_positioner_increment = 1611028
        secondary_positioner_increment = 1611029
        start_acquisition_datetime = 1611030
        end_acquisition_datetime = 1611031
        primary_positioner_increment_sign = 1611032
        secondary_positioner_increment_sign = 1611033
        application_name = 1611044
        application_version = 1611045
        application_manufacturer = 1611046
        algorithm_type = 1611047
        algorithm_description = 1611048
        x_ray_3d_reconstruction_sequence = 1611056
        reconstruction_description = 1611057
        per_projection_acquisition_sequence = 1611064
        detector_position_sequence = 1611073
        x_ray_acquisition_dose_sequence = 1611074
        x_ray_source_isocenter_primary_angle = 1611075
        x_ray_source_isocenter_secondary_angle = 1611076
        breast_support_isocenter_primary_angle = 1611077
        breast_support_isocenter_secondary_angle = 1611078
        breast_support_x_position_to_isocenter = 1611079
        breast_support_y_position_to_isocenter = 1611080
        breast_support_z_position_to_isocenter = 1611081
        detector_isocenter_primary_angle = 1611088
        detector_isocenter_secondary_angle = 1611089
        detector_x_position_to_isocenter = 1611090
        detector_y_position_to_isocenter = 1611091
        detector_z_position_to_isocenter = 1611092
        x_ray_grid_sequence = 1611093
        x_ray_filter_sequence = 1611094
        detector_active_area_tlhc_position = 1611095
        detector_active_area_orientation = 1611096
        positioner_primary_angle_direction = 1611097
        diffusion_b_matrix_sequence = 1611265
        diffusion_b_value_xx = 1611266
        diffusion_b_value_xy = 1611267
        diffusion_b_value_xz = 1611268
        diffusion_b_value_yy = 1611269
        diffusion_b_value_yz = 1611270
        diffusion_b_value_zz = 1611271
        functional_mr_sequence = 1611297
        functional_settling_phase_frames_present = 1611298
        functional_sync_pulse = 1611299
        settling_phase_frame = 1611300
        decay_correction_datetime = 1611521
        start_density_threshold = 1611541
        start_relative_density_difference_threshold = 1611542
        start_cardiac_trigger_count_threshold = 1611543
        start_respiratory_trigger_count_threshold = 1611544
        termination_counts_threshold = 1611545
        termination_density_threshold = 1611552
        termination_relative_density_threshold = 1611553
        termination_time_threshold = 1611554
        termination_cardiac_trigger_count_threshold = 1611555
        termination_respiratory_trigger_count_threshold = 1611556
        detector_geometry = 1611557
        transverse_detector_separation = 1611558
        axial_detector_dimension = 1611559
        radiopharmaceutical_agent_number = 1611561
        pet_frame_acquisition_sequence = 1611570
        pet_detector_motion_details_sequence = 1611571
        pet_table_dynamics_sequence = 1611572
        pet_position_sequence = 1611573
        pet_frame_correction_factors_sequence = 1611574
        radiopharmaceutical_usage_sequence = 1611575
        attenuation_correction_source = 1611576
        number_of_iterations = 1611577
        number_of_subsets = 1611584
        pet_reconstruction_sequence = 1611593
        pet_frame_type_sequence = 1611601
        time_of_flight_information_used = 1611605
        reconstruction_type = 1611606
        decay_corrected = 1611608
        attenuation_corrected = 1611609
        scatter_corrected = 1611616
        dead_time_corrected = 1611617
        gantry_motion_corrected = 1611618
        patient_motion_corrected = 1611619
        count_loss_normalization_corrected = 1611620
        randoms_corrected = 1611621
        non_uniform_radial_sampling_corrected = 1611622
        sensitivity_calibrated = 1611623
        detector_normalization_correction = 1611624
        iterative_reconstruction_method = 1611625
        attenuation_correction_temporal_relationship = 1611632
        patient_physiological_state_sequence = 1611633
        patient_physiological_state_code_sequence = 1611634
        depth_s__of_focus = 1611777
        excluded_intervals_sequence = 1611779
        exclusion_start_datetime = 1611780
        exclusion_duration = 1611781
        us_image_description_sequence = 1611782
        image_data_type_sequence = 1611783
        data_type = 1611784
        transducer_scan_pattern_code_sequence = 1611785
        aliased_data_type = 1611787
        position_measuring_device_used = 1611788
        transducer_geometry_code_sequence = 1611789
        transducer_beam_steering_code_sequence = 1611790
        transducer_application_code_sequence = 1611791
        zero_velocity_pixel_value = 1611792
        contributing_equipment_sequence = 1613825
        contribution_datetime = 1613826
        contribution_description = 1613827
        study_instance_uid = 2097165
        series_instance_uid = 2097166
        study_id = 2097168
        series_number = 2097169
        acquisition_number = 2097170
        instance_number = 2097171
        isotope_number = 2097172
        phase_number = 2097173
        interval_number = 2097174
        time_slot_number = 2097175
        angle_number = 2097176
        item_number = 2097177
        patient_orientation = 2097184
        overlay_number = 2097186
        curve_number = 2097188
        lut_number = 2097190
        image_position = 2097200
        image_position__patient_ = 2097202
        image_orientation = 2097205
        image_orientation__patient_ = 2097207
        location = 2097232
        frame_of_reference_uid = 2097234
        laterality = 2097248
        image_laterality = 2097250
        image_geometry_type = 2097264
        masking_image = 2097280
        report_number = 2097322
        temporal_position_identifier = 2097408
        number_of_temporal_positions = 2097413
        temporal_resolution = 2097424
        synchronization_frame_of_reference_uid = 2097664
        sop_instance_uid_of_concatenation_source = 2097730
        series_in_study = 2101248
        acquisitions_in_series = 2101249
        images_in_acquisition = 2101250
        images_in_series = 2101251
        acquisitions_in_study = 2101252
        images_in_study = 2101253
        reference = 2101280
        position_reference_indicator = 2101312
        slice_location = 2101313
        other_study_numbers = 2101360
        number_of_patient_related_studies = 2101760
        number_of_patient_related_series = 2101762
        number_of_patient_related_instances = 2101764
        number_of_study_related_series = 2101766
        number_of_study_related_instances = 2101768
        number_of_series_related_instances = 2101769
        modifying_device_id = 2110465
        modified_image_id = 2110466
        modified_image_date = 2110467
        modifying_device_manufacturer = 2110468
        modified_image_time = 2110469
        modified_image_description = 2110470
        image_comments = 2113536
        original_image_identification = 2117632
        original_image_identification_nomenclature = 2117634
        stack_id = 2134102
        in_stack_position_number = 2134103
        frame_anatomy_sequence = 2134129
        frame_laterality = 2134130
        frame_content_sequence = 2134289
        plane_position_sequence = 2134291
        plane_orientation_sequence = 2134294
        temporal_position_index = 2134312
        nominal_cardiac_trigger_delay_time = 2134355
        nominal_cardiac_trigger_time_prior_to_r_peak = 2134356
        actual_cardiac_trigger_time_prior_to_r_peak = 2134357
        frame_acquisition_number = 2134358
        dimension_index_values = 2134359
        frame_comments = 2134360
        concatenation_uid = 2134369
        in_concatenation_number = 2134370
        in_concatenation_total_number = 2134371
        dimension_organization_uid = 2134372
        dimension_index_pointer = 2134373
        functional_group_pointer = 2134375
        unassigned_shared_converted_attributes_sequence = 2134384
        unassigned_per_frame_converted_attributes_sequence = 2134385
        conversion_source_attributes_sequence = 2134386
        dimension_index_private_creator = 2134547
        dimension_organization_sequence = 2134561
        dimension_index_sequence = 2134562
        concatenation_frame_offset_number = 2134568
        functional_group_private_creator = 2134584
        nominal_percentage_of_cardiac_phase = 2134593
        nominal_percentage_of_respiratory_phase = 2134597
        starting_respiratory_amplitude = 2134598
        starting_respiratory_phase = 2134599
        ending_respiratory_amplitude = 2134600
        ending_respiratory_phase = 2134601
        respiratory_trigger_type = 2134608
        r_r_interval_time_nominal = 2134609
        actual_cardiac_trigger_delay_time = 2134610
        respiratory_synchronization_sequence = 2134611
        respiratory_interval_time = 2134612
        nominal_respiratory_trigger_delay_time = 2134613
        respiratory_trigger_delay_threshold = 2134614
        actual_respiratory_trigger_delay_time = 2134615
        image_position__volume_ = 2134785
        image_orientation__volume_ = 2134786
        ultrasound_acquisition_geometry = 2134791
        apex_position = 2134792
        volume_to_transducer_mapping_matrix = 2134793
        volume_to_table_mapping_matrix = 2134794
        volume_to_transducer_relationship = 2134795
        patient_frame_of_reference_source = 2134796
        temporal_position_time_offset = 2134797
        plane_position__volume__sequence = 2134798
        plane_orientation__volume__sequence = 2134799
        temporal_position_sequence = 2134800
        dimension_organization_type = 2134801
        volume_frame_of_reference_uid = 2134802
        table_frame_of_reference_uid = 2134803
        dimension_description_label = 2135073
        patient_orientation_in_frame_sequence = 2135120
        frame_label = 2135123
        acquisition_index = 2135320
        contributing_sop_instances_reference_sequence = 2135337
        reconstruction_index = 2135350
        light_path_filter_pass_through_wavelength = 2228225
        light_path_filter_pass_band = 2228226
        image_path_filter_pass_through_wavelength = 2228227
        image_path_filter_pass_band = 2228228
        patient_eye_movement_commanded = 2228229
        patient_eye_movement_command_code_sequence = 2228230
        spherical_lens_power = 2228231
        cylinder_lens_power = 2228232
        cylinder_axis = 2228233
        emmetropic_magnification = 2228234
        intra_ocular_pressure = 2228235
        horizontal_field_of_view = 2228236
        pupil_dilated = 2228237
        degree_of_dilation = 2228238
        stereo_baseline_angle = 2228240
        stereo_baseline_displacement = 2228241
        stereo_horizontal_pixel_offset = 2228242
        stereo_vertical_pixel_offset = 2228243
        stereo_rotation = 2228244
        acquisition_device_type_code_sequence = 2228245
        illumination_type_code_sequence = 2228246
        light_path_filter_type_stack_code_sequence = 2228247
        image_path_filter_type_stack_code_sequence = 2228248
        lenses_code_sequence = 2228249
        channel_description_code_sequence = 2228250
        refractive_state_sequence = 2228251
        mydriatic_agent_code_sequence = 2228252
        relative_image_position_code_sequence = 2228253
        camera_angle_of_view = 2228254
        stereo_pairs_sequence = 2228256
        left_image_sequence = 2228257
        right_image_sequence = 2228258
        stereo_pairs_present = 2228264
        axial_length_of_the_eye = 2228272
        ophthalmic_frame_location_sequence = 2228273
        reference_coordinates = 2228274
        depth_spatial_resolution = 2228277
        maximum_depth_distortion = 2228278
        along_scan_spatial_resolution = 2228279
        maximum_along_scan_distortion = 2228280
        ophthalmic_image_orientation = 2228281
        depth_of_transverse_image = 2228289
        mydriatic_agent_concentration_units_sequence = 2228290
        across_scan_spatial_resolution = 2228296
        maximum_across_scan_distortion = 2228297
        mydriatic_agent_concentration = 2228302
        illumination_wave_length = 2228309
        illumination_power = 2228310
        illumination_bandwidth = 2228311
        mydriatic_agent_sequence = 2228312
        ophthalmic_axial_measurements_right_eye_sequence = 2232327
        ophthalmic_axial_measurements_left_eye_sequence = 2232328
        ophthalmic_axial_measurements_device_type = 2232329
        ophthalmic_axial_length_measurements_type = 2232336
        ophthalmic_axial_length_sequence = 2232338
        ophthalmic_axial_length = 2232345
        lens_status_code_sequence = 2232356
        vitreous_status_code_sequence = 2232357
        iol_formula_code_sequence = 2232360
        iol_formula_detail = 2232361
        keratometer_index = 2232371
        source_of_ophthalmic_axial_length_code_sequence = 2232373
        target_refraction = 2232375
        refractive_procedure_occurred = 2232377
        refractive_surgery_type_code_sequence = 2232384
        ophthalmic_ultrasound_method_code_sequence = 2232388
        ophthalmic_axial_length_measurements_sequence = 2232400
        iol_power = 2232403
        predicted_refractive_error = 2232404
        ophthalmic_axial_length_velocity = 2232409
        lens_status_description = 2232421
        vitreous_status_description = 2232422
        iol_power_sequence = 2232464
        lens_constant_sequence = 2232466
        iol_manufacturer = 2232467
        lens_constant_description = 2232468
        implant_name = 2232469
        keratometry_measurement_type_code_sequence = 2232470
        implant_part_number = 2232471
        referenced_ophthalmic_axial_measurements_sequence = 2232576
        ophthalmic_axial_length_measurements_segment_name_code_sequence = 2232577
        refractive_error_before_refractive_surgery_code_sequence = 2232579
        iol_power_for_exact_emmetropia = 2232609
        iol_power_for_exact_target_refraction = 2232610
        anterior_chamber_depth_definition_code_sequence = 2232613
        lens_thickness_sequence = 2232615
        anterior_chamber_depth_sequence = 2232616
        lens_thickness = 2232624
        anterior_chamber_depth = 2232625
        source_of_lens_thickness_data_code_sequence = 2232626
        source_of_anterior_chamber_depth_data_code_sequence = 2232627
        source_of_refractive_measurements_sequence = 2232628
        source_of_refractive_measurements_code_sequence = 2232629
        ophthalmic_axial_length_measurement_modified = 2232640
        ophthalmic_axial_length_data_source_code_sequence = 2232656
        ophthalmic_axial_length_acquisition_method_code_sequence = 2232659
        signal_to_noise_ratio = 2232661
        ophthalmic_axial_length_data_source_description = 2232665
        ophthalmic_axial_length_measurements_total_length_sequence = 2232848
        ophthalmic_axial_length_measurements_segmental_length_sequence = 2232849
        ophthalmic_axial_length_measurements_length_summation_sequence = 2232850
        ultrasound_ophthalmic_axial_length_measurements_sequence = 2232864
        optical_ophthalmic_axial_length_measurements_sequence = 2232869
        ultrasound_selected_ophthalmic_axial_length_sequence = 2232880
        ophthalmic_axial_length_selection_method_code_sequence = 2232912
        optical_selected_ophthalmic_axial_length_sequence = 2232917
        selected_segmental_ophthalmic_axial_length_sequence = 2232919
        selected_total_ophthalmic_axial_length_sequence = 2232928
        ophthalmic_axial_length_quality_metric_sequence = 2232930
        ophthalmic_axial_length_quality_metric_type_code_sequence = 2232933
        ophthalmic_axial_length_quality_metric_type_description = 2232947
        intraocular_lens_calculations_right_eye_sequence = 2233088
        intraocular_lens_calculations_left_eye_sequence = 2233104
        referenced_ophthalmic_axial_length_measurement_qc_image_sequence = 2233136
        ophthalmic_mapping_device_type = 2233365
        acquisition_method_code_sequence = 2233376
        acquisition_method_algorithm_sequence = 2233379
        ophthalmic_thickness_map_type_code_sequence = 2233398
        ophthalmic_thickness_mapping_normals_sequence = 2233411
        retinal_thickness_definition_code_sequence = 2233413
        pixel_value_mapping_to_coded_concept_sequence = 2233424
        mapped_pixel_value = 2233426
        pixel_value_mapping_explanation = 2233428
        ophthalmic_thickness_map_quality_threshold_sequence = 2233432
        ophthalmic_thickness_map_threshold_quality_rating = 2233440
        anatomic_structure_reference_point = 2233443
        registration_to_localizer_sequence = 2233445
        registered_localizer_units = 2233446
        registered_localizer_top_left_hand_corner = 2233447
        registered_localizer_bottom_right_hand_corner = 2233448
        ophthalmic_thickness_map_quality_rating_sequence = 2233456
        relevant_opt_attributes_sequence = 2233458
        transformation_method_code_sequence = 2233618
        transformation_algorithm_sequence = 2233619
        ophthalmic_axial_length_method = 2233621
        ophthalmic_fov = 2233623
        two_dimensional_to_three_dimensional_map_sequence = 2233624
        wide_field_ophthalmic_photography_quality_rating_sequence = 2233637
        wide_field_ophthalmic_photography_quality_threshold_sequence = 2233638
        wide_field_ophthalmic_photography_threshold_quality_rating = 2233639
        x_coordinates_center_pixel_view_angle = 2233640
        y_coordinates_center_pixel_view_angle = 2233641
        number_of_map_points = 2233648
        two_dimensional_to_three_dimensional_map_data = 2233649
        visual_field_horizontal_extent = 2359312
        visual_field_vertical_extent = 2359313
        visual_field_shape = 2359314
        screening_test_mode_code_sequence = 2359318
        maximum_stimulus_luminance = 2359320
        background_luminance = 2359328
        stimulus_color_code_sequence = 2359329
        background_illumination_color_code_sequence = 2359332
        stimulus_area = 2359333
        stimulus_presentation_time = 2359336
        fixation_sequence = 2359346
        fixation_monitoring_code_sequence = 2359347
        visual_field_catch_trial_sequence = 2359348
        fixation_checked_quantity = 2359349
        patient_not_properly_fixated_quantity = 2359350
        presented_visual_stimuli_data_flag = 2359351
        number_of_visual_stimuli = 2359352
        excessive_fixation_losses_data_flag = 2359353
        excessive_fixation_losses = 2359360
        stimuli_retesting_quantity = 2359362
        comments_on_patient_s_performance_of_visual_field = 2359364
        false_negatives_estimate_flag = 2359365
        false_negatives_estimate = 2359366
        negative_catch_trials_quantity = 2359368
        false_negatives_quantity = 2359376
        excessive_false_negatives_data_flag = 2359377
        excessive_false_negatives = 2359378
        false_positives_estimate_flag = 2359379
        false_positives_estimate = 2359380
        catch_trials_data_flag = 2359381
        positive_catch_trials_quantity = 2359382
        test_point_normals_data_flag = 2359383
        test_point_normals_sequence = 2359384
        global_deviation_probability_normals_flag = 2359385
        false_positives_quantity = 2359392
        excessive_false_positives_data_flag = 2359393
        excessive_false_positives = 2359394
        visual_field_test_normals_flag = 2359395
        results_normals_sequence = 2359396
        age_corrected_sensitivity_deviation_algorithm_sequence = 2359397
        global_deviation_from_normal = 2359398
        generalized_defect_sensitivity_deviation_algorithm_sequence = 2359399
        localized_deviation_from_normal = 2359400
        patient_reliability_indicator = 2359401
        visual_field_mean_sensitivity = 2359408
        global_deviation_probability = 2359409
        local_deviation_probability_normals_flag = 2359410
        localized_deviation_probability = 2359411
        short_term_fluctuation_calculated = 2359412
        short_term_fluctuation = 2359413
        short_term_fluctuation_probability_calculated = 2359414
        short_term_fluctuation_probability = 2359415
        corrected_localized_deviation_from_normal_calculated = 2359416
        corrected_localized_deviation_from_normal = 2359417
        corrected_localized_deviation_from_normal_probability_calculated = 2359424
        corrected_localized_deviation_from_normal_probability = 2359425
        global_deviation_probability_sequence = 2359427
        localized_deviation_probability_sequence = 2359429
        foveal_sensitivity_measured = 2359430
        foveal_sensitivity = 2359431
        visual_field_test_duration = 2359432
        visual_field_test_point_sequence = 2359433
        visual_field_test_point_x_coordinate = 2359440
        visual_field_test_point_y_coordinate = 2359441
        age_corrected_sensitivity_deviation_value = 2359442
        stimulus_results = 2359443
        sensitivity_value = 2359444
        retest_stimulus_seen = 2359445
        retest_sensitivity_value = 2359446
        visual_field_test_point_normals_sequence = 2359447
        quantified_defect = 2359448
        age_corrected_sensitivity_deviation_probability_value = 2359552
        generalized_defect_corrected_sensitivity_deviation_flag = 2359554
        generalized_defect_corrected_sensitivity_deviation_value = 2359555
        generalized_defect_corrected_sensitivity_deviation_probability_value = 2359556
        minimum_sensitivity_value = 2359557
        blind_spot_localized = 2359558
        blind_spot_x_coordinate = 2359559
        blind_spot_y_coordinate = 2359560
        visual_acuity_measurement_sequence = 2359568
        refractive_parameters_used_on_patient_sequence = 2359570
        measurement_laterality = 2359571
        ophthalmic_patient_clinical_information_left_eye_sequence = 2359572
        ophthalmic_patient_clinical_information_right_eye_sequence = 2359573
        foveal_point_normative_data_flag = 2359575
        foveal_point_probability_value = 2359576
        screening_baseline_measured = 2359584
        screening_baseline_measured_sequence = 2359586
        screening_baseline_type = 2359588
        screening_baseline_value = 2359590
        algorithm_source = 2359810
        data_set_name = 2360070
        data_set_version = 2360071
        data_set_source = 2360072
        data_set_description = 2360073
        visual_field_test_reliability_global_index_sequence = 2360087
        visual_field_global_results_index_sequence = 2360096
        data_observation_sequence = 2360101
        index_normals_flag = 2360120
        index_probability = 2360129
        index_probability_sequence = 2360132
        samples_per_pixel = 2621442
        samples_per_pixel_used = 2621443
        photometric_interpretation = 2621444
        image_dimensions = 2621445
        planar_configuration = 2621446
        number_of_frames = 2621448
        frame_increment_pointer = 2621449
        frame_dimension_pointer = 2621450
        rows = 2621456
        columns = 2621457
        planes = 2621458
        ultrasound_color_data_present = 2621460
        pixel_spacing = 2621488
        zoom_factor = 2621489
        zoom_center = 2621490
        pixel_aspect_ratio = 2621492
        image_format = 2621504
        manipulated_image = 2621520
        corrected_image = 2621521
        compression_recognition_code = 2621535
        compression_code = 2621536
        compression_originator = 2621537
        compression_label = 2621538
        compression_description = 2621539
        compression_sequence = 2621541
        compression_step_pointers = 2621542
        repeat_interval = 2621544
        bits_grouped = 2621545
        perimeter_table = 2621552
        perimeter_value = 2621553
        predictor_rows = 2621568
        predictor_columns = 2621569
        predictor_constants = 2621570
        blocked_pixels = 2621584
        block_rows = 2621585
        block_columns = 2621586
        row_overlap = 2621587
        column_overlap = 2621588
        bits_allocated = 2621696
        bits_stored = 2621697
        high_bit = 2621698
        pixel_representation = 2621699
        smallest_valid_pixel_value = 2621700
        largest_valid_pixel_value = 2621701
        smallest_image_pixel_value = 2621702
        largest_image_pixel_value = 2621703
        smallest_pixel_value_in_series = 2621704
        largest_pixel_value_in_series = 2621705
        smallest_image_pixel_value_in_plane = 2621712
        largest_image_pixel_value_in_plane = 2621713
        pixel_padding_value = 2621728
        pixel_padding_range_limit = 2621729
        float_pixel_padding_value = 2621730
        double_float_pixel_padding_value = 2621731
        float_pixel_padding_range_limit = 2621732
        double_float_pixel_padding_range_limit = 2621733
        image_location = 2621952
        quality_control_image = 2622208
        burned_in_annotation = 2622209
        recognizable_visual_features = 2622210
        longitudinal_temporal_information_modified = 2622211
        referenced_color_palette_instance_uid = 2622212
        transform_label = 2622464
        transform_version_number = 2622465
        number_of_transform_steps = 2622466
        sequence_of_compressed_data = 2622467
        details_of_coefficients = 2622468
        dct_label = 2623232
        data_block_description = 2623233
        data_block = 2623234
        normalization_factor_format = 2623248
        zonal_map_number_format = 2623264
        zonal_map_location = 2623265
        zonal_map_format = 2623266
        adaptive_map_format = 2623280
        code_number_format = 2623296
        pixel_spacing_calibration_type = 2624002
        pixel_spacing_calibration_description = 2624004
        pixel_intensity_relationship = 2625600
        pixel_intensity_relationship_sign = 2625601
        window_center = 2625616
        window_width = 2625617
        rescale_intercept = 2625618
        rescale_slope = 2625619
        rescale_type = 2625620
        window_center___width_explanation = 2625621
        voi_lut_function = 2625622
        gray_scale = 2625664
        recommended_viewing_mode = 2625680
        gray_lookup_table_descriptor = 2625792
        red_palette_color_lookup_table_descriptor = 2625793
        green_palette_color_lookup_table_descriptor = 2625794
        blue_palette_color_lookup_table_descriptor = 2625795
        alpha_palette_color_lookup_table_descriptor = 2625796
        large_red_palette_color_lookup_table_descriptor = 2625809
        large_green_palette_color_lookup_table_descriptor = 2625810
        large_blue_palette_color_lookup_table_descriptor = 2625811
        palette_color_lookup_table_uid = 2625945
        gray_lookup_table_data = 2626048
        red_palette_color_lookup_table_data = 2626049
        green_palette_color_lookup_table_data = 2626050
        blue_palette_color_lookup_table_data = 2626051
        alpha_palette_color_lookup_table_data = 2626052
        large_red_palette_color_lookup_table_data = 2626065
        large_green_palette_color_lookup_table_data = 2626066
        large_blue_palette_color_lookup_table_data = 2626067
        large_palette_color_lookup_table_uid = 2626068
        segmented_red_palette_color_lookup_table_data = 2626081
        segmented_green_palette_color_lookup_table_data = 2626082
        segmented_blue_palette_color_lookup_table_data = 2626083
        segmented_alpha_palette_color_lookup_table_data = 2626084
        breast_implant_present = 2626304
        partial_view = 2626384
        partial_view_description = 2626385
        partial_view_code_sequence = 2626386
        spatial_locations_preserved = 2626394
        data_frame_assignment_sequence = 2626561
        data_path_assignment = 2626562
        bits_mapped_to_color_lookup_table = 2626563
        blending_lut_1_sequence = 2626564
        blending_lut_1_transfer_function = 2626565
        blending_weight_constant = 2626566
        blending_lookup_table_descriptor = 2626567
        blending_lookup_table_data = 2626568
        enhanced_palette_color_lookup_table_sequence = 2626571
        blending_lut_2_sequence = 2626572
        blending_lut_2_transfer_function = 2626573
        data_path_id = 2626574
        rgb_lut_transfer_function = 2626575
        alpha_lut_transfer_function = 2626576
        icc_profile = 2629632
        color_space = 2629634
        lossy_image_compression = 2629904
        lossy_image_compression_ratio = 2629906
        lossy_image_compression_method = 2629908
        modality_lut_sequence = 2633728
        lut_descriptor = 2633730
        lut_explanation = 2633731
        modality_lut_type = 2633732
        lut_data = 2633734
        voi_lut_sequence = 2633744
        softcopy_voi_lut_sequence = 2634000
        image_presentation_comments = 2637824
        bi_plane_acquisition_sequence = 2641920
        representative_frame_number = 2646032
        frame_numbers_of_interest__foi_ = 2646048
        frame_of_interest_description = 2646050
        frame_of_interest_type = 2646051
        mask_pointer_s_ = 2646064
        r_wave_pointer = 2646080
        mask_subtraction_sequence = 2646272
        mask_operation = 2646273
        applicable_frame_range = 2646274
        mask_frame_numbers = 2646288
        contrast_frame_averaging = 2646290
        mask_sub_pixel_shift = 2646292
        tid_offset = 2646304
        mask_operation_explanation = 2646416
        equipment_administrator_sequence = 2650112
        number_of_display_subsystems = 2650113
        current_configuration_id = 2650114
        display_subsystem_id = 2650115
        display_subsystem_name = 2650116
        display_subsystem_description = 2650117
        system_status = 2650118
        system_status_comment = 2650119
        target_luminance_characteristics_sequence = 2650120
        luminance_characteristics_id = 2650121
        display_subsystem_configuration_sequence = 2650122
        configuration_id = 2650123
        configuration_name = 2650124
        configuration_description = 2650125
        referenced_target_luminance_characteristics_id = 2650126
        qa_results_sequence = 2650127
        display_subsystem_qa_results_sequence = 2650128
        configuration_qa_results_sequence = 2650129
        measurement_equipment_sequence = 2650130
        measurement_functions = 2650131
        measurement_equipment_type = 2650132
        visual_evaluation_result_sequence = 2650133
        display_calibration_result_sequence = 2650134
        ddl_value = 2650135
        ciexy_white_point = 2650136
        display_function_type = 2650137
        gamma_value = 2650138
        number_of_luminance_points = 2650139
        luminance_response_sequence = 2650140
        target_minimum_luminance = 2650141
        target_maximum_luminance = 2650142
        luminance_value = 2650143
        luminance_response_description = 2650144
        white_point_flag = 2650145
        display_device_type_code_sequence = 2650146
        display_subsystem_sequence = 2650147
        luminance_result_sequence = 2650148
        ambient_light_value_source = 2650149
        measured_characteristics = 2650150
        luminance_uniformity_result_sequence = 2650151
        visual_evaluation_test_sequence = 2650152
        test_result = 2650153
        test_result_comment = 2650154
        test_image_validation = 2650155
        test_pattern_code_sequence = 2650156
        measurement_pattern_code_sequence = 2650157
        visual_evaluation_method_code_sequence = 2650158
        pixel_data_provider_url = 2654176
        data_point_rows = 2658305
        data_point_columns = 2658306
        signal_domain_columns = 2658307
        largest_monochrome_pixel_value = 2658457
        data_representation = 2658568
        pixel_measures_sequence = 2658576
        frame_voi_lut_sequence = 2658610
        pixel_value_transformation_sequence = 2658629
        signal_domain_rows = 2658869
        display_filter_percentage = 2659345
        frame_pixel_shift_sequence = 2659349
        subtraction_item_id = 2659350
        pixel_intensity_relationship_lut_sequence = 2659362
        frame_pixel_data_properties_sequence = 2659395
        geometrical_properties = 2659396
        geometric_maximum_distortion = 2659397
        image_processing_applied = 2659398
        mask_selection_mode = 2659412
        lut_function = 2659444
        mask_visibility_percentage = 2659448
        pixel_shift_sequence = 2659585
        region_pixel_shift_sequence = 2659586
        vertices_of_the_region = 2659587
        multi_frame_presentation_sequence = 2659589
        pixel_shift_frame_range = 2659590
        lut_frame_range = 2659591
        image_to_equipment_mapping_matrix = 2659616
        equipment_coordinate_system_identification = 2659639
        study_status_id = 3276810
        study_priority_id = 3276812
        study_id_issuer = 3276818
        study_verified_date = 3276850
        study_verified_time = 3276851
        study_read_date = 3276852
        study_read_time = 3276853
        scheduled_study_start_date = 3280896
        scheduled_study_start_time = 3280897
        scheduled_study_stop_date = 3280912
        scheduled_study_stop_time = 3280913
        scheduled_study_location = 3280928
        scheduled_study_location_ae_title = 3280929
        reason_for_study = 3280944
        requesting_physician_identification_sequence = 3280945
        requesting_physician = 3280946
        requesting_service = 3280947
        requesting_service_code_sequence = 3280948
        study_arrival_date = 3280960
        study_arrival_time = 3280961
        study_completion_date = 3280976
        study_completion_time = 3280977
        study_component_status_id = 3280981
        requested_procedure_description = 3280992
        requested_procedure_code_sequence = 3280996
        requested_contrast_agent = 3281008
        study_comments = 3293184
        referenced_patient_alias_sequence = 3670020
        visit_status_id = 3670024
        admission_id = 3670032
        issuer_of_admission_id = 3670033
        issuer_of_admission_id_sequence = 3670036
        route_of_admissions = 3670038
        scheduled_admission_date = 3670042
        scheduled_admission_time = 3670043
        scheduled_discharge_date = 3670044
        scheduled_discharge_time = 3670045
        scheduled_patient_institution_residence = 3670046
        admitting_date = 3670048
        admitting_time = 3670049
        discharge_date = 3670064
        discharge_time = 3670066
        discharge_diagnosis_description = 3670080
        discharge_diagnosis_code_sequence = 3670084
        special_needs = 3670096
        service_episode_id = 3670112
        issuer_of_service_episode_id = 3670113
        service_episode_description = 3670114
        issuer_of_service_episode_id_sequence = 3670116
        pertinent_documents_sequence = 3670272
        pertinent_resources_sequence = 3670273
        resource_description = 3670274
        current_patient_location = 3670784
        patient_s_institution_residence = 3671040
        patient_state = 3671296
        patient_clinical_trial_participation_sequence = 3671298
        visit_comments = 3686400
        waveform_originality = 3801092
        number_of_waveform_channels = 3801093
        number_of_waveform_samples = 3801104
        sampling_frequency = 3801114
        multiplex_group_label = 3801120
        channel_definition_sequence = 3801600
        waveform_channel_number = 3801602
        channel_label = 3801603
        channel_status = 3801605
        channel_source_sequence = 3801608
        channel_source_modifiers_sequence = 3801609
        source_waveform_sequence = 3801610
        channel_derivation_description = 3801612
        channel_sensitivity = 3801616
        channel_sensitivity_units_sequence = 3801617
        channel_sensitivity_correction_factor = 3801618
        channel_baseline = 3801619
        channel_time_skew = 3801620
        channel_sample_skew = 3801621
        channel_offset = 3801624
        waveform_bits_stored = 3801626
        filter_low_frequency = 3801632
        filter_high_frequency = 3801633
        notch_filter_frequency = 3801634
        notch_filter_bandwidth = 3801635
        waveform_data_display_scale = 3801648
        waveform_display_background_cielab_value = 3801649
        waveform_presentation_group_sequence = 3801664
        presentation_group_number = 3801665
        channel_display_sequence = 3801666
        channel_recommended_display_cielab_value = 3801668
        channel_position = 3801669
        display_shading_flag = 3801670
        fractional_channel_display_scale = 3801671
        absolute_channel_display_scale = 3801672
        multiplexed_audio_channels_description_code_sequence = 3801856
        channel_identification_code = 3801857
        channel_mode = 3801858
        scheduled_station_ae_title = 4194305
        scheduled_procedure_step_start_date = 4194306
        scheduled_procedure_step_start_time = 4194307
        scheduled_procedure_step_end_date = 4194308
        scheduled_procedure_step_end_time = 4194309
        scheduled_performing_physician_s_name = 4194310
        scheduled_procedure_step_description = 4194311
        scheduled_protocol_code_sequence = 4194312
        scheduled_procedure_step_id = 4194313
        stage_code_sequence = 4194314
        scheduled_performing_physician_identification_sequence = 4194315
        scheduled_station_name = 4194320
        scheduled_procedure_step_location = 4194321
        pre_medication = 4194322
        scheduled_procedure_step_status = 4194336
        order_placer_identifier_sequence = 4194342
        order_filler_identifier_sequence = 4194343
        local_namespace_entity_id = 4194353
        universal_entity_id = 4194354
        universal_entity_id_type = 4194355
        identifier_type_code = 4194357
        assigning_facility_sequence = 4194358
        assigning_jurisdiction_code_sequence = 4194361
        assigning_agency_or_department_code_sequence = 4194362
        scheduled_procedure_step_sequence = 4194560
        referenced_non_image_composite_sop_instance_sequence = 4194848
        performed_station_ae_title = 4194881
        performed_station_name = 4194882
        performed_location = 4194883
        performed_procedure_step_start_date = 4194884
        performed_procedure_step_start_time = 4194885
        performed_procedure_step_end_date = 4194896
        performed_procedure_step_end_time = 4194897
        performed_procedure_step_status = 4194898
        performed_procedure_step_id = 4194899
        performed_procedure_step_description = 4194900
        performed_procedure_type_description = 4194901
        performed_protocol_code_sequence = 4194912
        performed_protocol_type = 4194913
        scheduled_step_attributes_sequence = 4194928
        request_attributes_sequence = 4194933
        comments_on_the_performed_procedure_step = 4194944
        performed_procedure_step_discontinuation_reason_code_sequence = 4194945
        quantity_sequence = 4194963
        quantity = 4194964
        measuring_units_sequence = 4194965
        billing_item_sequence = 4194966
        total_time_of_fluoroscopy = 4195072
        total_number_of_exposures = 4195073
        entrance_dose = 4195074
        exposed_area = 4195075
        distance_source_to_entrance = 4195078
        distance_source_to_support = 4195079
        exposure_dose_sequence = 4195086
        comments_on_radiation_dose = 4195088
        x_ray_output = 4195090
        half_value_layer = 4195092
        organ_dose = 4195094
        organ_exposed = 4195096
        billing_procedure_step_sequence = 4195104
        film_consumption_sequence = 4195105
        billing_supplies_and_devices_sequence = 4195108
        referenced_procedure_step_sequence = 4195120
        performed_series_sequence = 4195136
        comments_on_the_scheduled_procedure_step = 4195328
        protocol_context_sequence = 4195392
        content_item_modifier_sequence = 4195393
        scheduled_specimen_sequence = 4195584
        specimen_accession_number = 4195594
        container_identifier = 4195602
        issuer_of_the_container_identifier_sequence = 4195603
        alternate_container_identifier_sequence = 4195605
        container_type_code_sequence = 4195608
        container_description = 4195610
        container_component_sequence = 4195616
        specimen_sequence = 4195664
        specimen_identifier = 4195665
        specimen_description_sequence__trial_ = 4195666
        specimen_description__trial_ = 4195667
        specimen_uid = 4195668
        acquisition_context_sequence = 4195669
        acquisition_context_description = 4195670
        specimen_description_sequence = 4195680
        issuer_of_the_specimen_identifier_sequence = 4195682
        specimen_type_code_sequence = 4195738
        specimen_short_description = 4195840
        specimen_detailed_description = 4195842
        specimen_preparation_sequence = 4195856
        specimen_preparation_step_content_item_sequence = 4195858
        specimen_localization_content_item_sequence = 4195872
        slide_identifier = 4196090
        image_center_point_coordinates_sequence = 4196122
        x_offset_in_slide_coordinate_system = 4196138
        y_offset_in_slide_coordinate_system = 4196154
        z_offset_in_slide_coordinate_system = 4196170
        pixel_spacing_sequence = 4196568
        coordinate_system_axis_code_sequence = 4196570
        measurement_units_code_sequence = 4196586
        vital_stain_code_sequence__trial_ = 4196856
        requested_procedure_id = 4198401
        reason_for_the_requested_procedure = 4198402
        requested_procedure_priority = 4198403
        patient_transport_arrangements = 4198404
        requested_procedure_location = 4198405
        placer_order_number___procedure = 4198406
        filler_order_number___procedure = 4198407
        confidentiality_code = 4198408
        reporting_priority = 4198409
        reason_for_requested_procedure_code_sequence = 4198410
        names_of_intended_recipients_of_results = 4198416
        intended_recipients_of_results_identification_sequence = 4198417
        reason_for_performed_procedure_code_sequence = 4198418
        requested_procedure_description__trial_ = 4198496
        person_identification_code_sequence = 4198657
        person_s_address = 4198658
        person_s_telephone_numbers = 4198659
        person_s_telecom_information = 4198660
        requested_procedure_comments = 4199424
        reason_for_the_imaging_service_request = 4202497
        issue_date_of_imaging_service_request = 4202500
        issue_time_of_imaging_service_request = 4202501
        placer_order_number___imaging_service_request__retired_ = 4202502
        filler_order_number___imaging_service_request__retired_ = 4202503
        order_entered_by = 4202504
        order_enterer_s_location = 4202505
        order_callback_phone_number = 4202512
        order_callback_telecom_information = 4202513
        placer_order_number___imaging_service_request = 4202518
        filler_order_number___imaging_service_request = 4202519
        imaging_service_request_comments = 4203520
        confidentiality_constraint_on_patient_data_description = 4206593
        general_purpose_scheduled_procedure_step_status = 4210689
        general_purpose_performed_procedure_step_status = 4210690
        general_purpose_scheduled_procedure_step_priority = 4210691
        scheduled_processing_applications_code_sequence = 4210692
        scheduled_procedure_step_start_datetime = 4210693
        multiple_copies_flag = 4210694
        performed_processing_applications_code_sequence = 4210695
        human_performer_code_sequence = 4210697
        scheduled_procedure_step_modification_datetime = 4210704
        expected_completion_datetime = 4210705
        resulting_general_purpose_performed_procedure_steps_sequence = 4210709
        referenced_general_purpose_scheduled_procedure_step_sequence = 4210710
        scheduled_workitem_code_sequence = 4210712
        performed_workitem_code_sequence = 4210713
        input_availability_flag = 4210720
        input_information_sequence = 4210721
        relevant_information_sequence = 4210722
        referenced_general_purpose_scheduled_procedure_step_transaction_uid = 4210723
        scheduled_station_name_code_sequence = 4210725
        scheduled_station_class_code_sequence = 4210726
        scheduled_station_geographic_location_code_sequence = 4210727
        performed_station_name_code_sequence = 4210728
        performed_station_class_code_sequence = 4210729
        performed_station_geographic_location_code_sequence = 4210736
        requested_subsequent_workitem_code_sequence = 4210737
        non_dicom_output_code_sequence = 4210738
        output_information_sequence = 4210739
        scheduled_human_performers_sequence = 4210740
        actual_human_performers_sequence = 4210741
        human_performer_s_organization = 4210742
        human_performer_s_name = 4210743
        raw_data_handling = 4210752
        input_readiness_state = 4210753
        performed_procedure_step_start_datetime = 4210768
        performed_procedure_step_end_datetime = 4210769
        procedure_step_cancellation_datetime = 4210770
        output_destination_sequence = 4210800
        dicom_storage_sequence = 4210801
        stow_rs_storage_sequence = 4210802
        storage_url = 4210803
        xds_storage_sequence = 4210804
        entrance_dose_in_mgy = 4227842
        parametric_map_frame_type_sequence = 4231314
        referenced_image_real_world_value_mapping_sequence = 4231316
        real_world_value_mapping_sequence = 4231318
        pixel_value_mapping_code_sequence = 4231320
        lut_label = 4231696
        real_world_value_last_value_mapped = 4231697
        real_world_value_lut_data = 4231698
        double_float_real_world_value_last_value_mapped = 4231699
        double_float_real_world_value_first_value_mapped = 4231700
        real_world_value_first_value_mapped = 4231702
        quantity_definition_sequence = 4231712
        real_world_value_intercept = 4231716
        real_world_value_slope = 4231717
        findings_flag__trial_ = 4235271
        relationship_type = 4235280
        findings_sequence__trial_ = 4235296
        findings_group_uid__trial_ = 4235297
        referenced_findings_group_uid__trial_ = 4235298
        findings_group_recording_date__trial_ = 4235299
        findings_group_recording_time__trial_ = 4235300
        findings_source_category_code_sequence__trial_ = 4235302
        verifying_organization = 4235303
        documenting_organization_identifier_code_sequence__trial_ = 4235304
        verification_datetime = 4235312
        observation_datetime = 4235314
        value_type = 4235328
        concept_name_code_sequence = 4235331
        measurement_precision_description__trial_ = 4235335
        continuity_of_content = 4235344
        urgency_or_priority_alerts__trial_ = 4235351
        sequencing_indicator__trial_ = 4235360
        document_identifier_code_sequence__trial_ = 4235366
        document_author__trial_ = 4235367
        document_author_identifier_code_sequence__trial_ = 4235368
        identifier_code_sequence__trial_ = 4235376
        verifying_observer_sequence = 4235379
        object_binary_identifier__trial_ = 4235380
        verifying_observer_name = 4235381
        documenting_observer_identifier_code_sequence__trial_ = 4235382
        author_observer_sequence = 4235384
        participant_sequence = 4235386
        custodial_organization_sequence = 4235388
        participation_type = 4235392
        participation_datetime = 4235394
        observer_type = 4235396
        procedure_identifier_code_sequence__trial_ = 4235397
        verifying_observer_identification_code_sequence = 4235400
        object_directory_binary_identifier__trial_ = 4235401
        equivalent_cda_document_sequence = 4235408
        referenced_waveform_channels = 4235440
        date_of_document_or_verbal_transaction__trial_ = 4235536
        time_of_document_creation_or_verbal_transaction__trial_ = 4235538
        datetime = 4235552
        date = 4235553
        time = 4235554
        person_name = 4235555
        uid = 4235556
        report_status_id__trial_ = 4235557
        temporal_range_type = 4235568
        referenced_sample_positions = 4235570
        referenced_frame_numbers = 4235574
        referenced_time_offsets = 4235576
        referenced_datetime = 4235578
        text_value = 4235616
        floating_point_value = 4235617
        rational_numerator_value = 4235618
        rational_denominator_value = 4235619
        observation_category_code_sequence__trial_ = 4235623
        concept_code_sequence = 4235624
        bibliographic_citation__trial_ = 4235626
        purpose_of_reference_code_sequence = 4235632
        observation_uid = 4235633
        referenced_observation_uid__trial_ = 4235634
        referenced_observation_class__trial_ = 4235635
        referenced_object_observation_class__trial_ = 4235636
        annotation_group_number = 4235648
        observation_date__trial_ = 4235666
        observation_time__trial_ = 4235667
        measurement_automation__trial_ = 4235668
        modifier_code_sequence = 4235669
        identification_description__trial_ = 4235812
        coordinates_set_geometric_type__trial_ = 4235920
        algorithm_code_sequence__trial_ = 4235926
        algorithm_description__trial_ = 4235927
        pixel_coordinates_set__trial_ = 4235930
        measured_value_sequence = 4236032
        numeric_value_qualifier_code_sequence = 4236033
        current_observer__trial_ = 4236039
        numeric_value = 4236042
        referenced_accession_sequence__trial_ = 4236051
        report_status_comment__trial_ = 4236090
        procedure_context_sequence__trial_ = 4236096
        verbal_source__trial_ = 4236114
        address__trial_ = 4236115
        telephone_number__trial_ = 4236116
        verbal_source_identifier_code_sequence__trial_ = 4236120
        predecessor_documents_sequence = 4236128
        referenced_request_sequence = 4236144
        performed_procedure_code_sequence = 4236146
        current_requested_procedure_evidence_sequence = 4236149
        report_detail_sequence__trial_ = 4236160
        pertinent_other_evidence_sequence = 4236165
        hl7_structured_document_reference_sequence = 4236176
        observation_subject_uid__trial_ = 4236290
        observation_subject_class__trial_ = 4236291
        observation_subject_type_code_sequence__trial_ = 4236292
        completion_flag = 4236433
        completion_flag_description = 4236434
        verification_flag = 4236435
        archive_requested = 4236436
        preliminary_flag = 4236438
        content_template_sequence = 4236548
        identical_documents_sequence = 4236581
        observation_subject_context_flag__trial_ = 4236800
        observer_context_flag__trial_ = 4236801
        procedure_context_flag__trial_ = 4236803
        content_sequence = 4237104
        relationship_sequence__trial_ = 4237105
        relationship_type_code_sequence__trial_ = 4237106
        language_code_sequence__trial_ = 4237124
        uniform_resource_locator__trial_ = 4237714
        waveform_annotation_sequence = 4239392
        template_identifier = 4250368
        template_version = 4250374
        template_local_version = 4250375
        template_extension_flag = 4250379
        template_extension_organization_uid = 4250380
        template_extension_creator_uid = 4250381
        referenced_content_item_identifier = 4250483
        hl7_instance_identifier = 4251649
        hl7_document_effective_time = 4251652
        hl7_document_type_code_sequence = 4251654
        document_class_code_sequence = 4251656
        retrieve_uri = 4251664
        retrieve_location_uid = 4251665
        type_of_instances = 4251680
        dicom_retrieval_sequence = 4251681
        dicom_media_retrieval_sequence = 4251682
        wado_retrieval_sequence = 4251683
        xds_retrieval_sequence = 4251684
        wado_rs_retrieval_sequence = 4251685
        repository_unique_id = 4251696
        home_community_id = 4251697
        document_title = 4325392
        encapsulated_document = 4325393
        mime_type_of_encapsulated_document = 4325394
        source_instance_sequence = 4325395
        list_of_mime_types = 4325396
        product_package_identifier = 4456449
        substance_administration_approval = 4456450
        approval_status_further_description = 4456451
        approval_status_datetime = 4456452
        product_type_code_sequence = 4456455
        product_name = 4456456
        product_description = 4456457
        product_lot_identifier = 4456458
        product_expiration_datetime = 4456459
        substance_administration_datetime = 4456464
        substance_administration_notes = 4456465
        substance_administration_device_id = 4456466
        product_parameter_sequence = 4456467
        substance_administration_parameter_sequence = 4456473
        lens_description = 4587538
        right_lens_sequence = 4587540
        left_lens_sequence = 4587541
        unspecified_laterality_lens_sequence = 4587542
        cylinder_sequence = 4587544
        prism_sequence = 4587560
        horizontal_prism_power = 4587568
        horizontal_prism_base = 4587570
        vertical_prism_power = 4587572
        vertical_prism_base = 4587574
        lens_segment_type = 4587576
        optical_transmittance = 4587584
        channel_width = 4587586
        pupil_size = 4587588
        corneal_size = 4587590
        autorefraction_right_eye_sequence = 4587600
        autorefraction_left_eye_sequence = 4587602
        distance_pupillary_distance = 4587616
        near_pupillary_distance = 4587618
        intermediate_pupillary_distance = 4587619
        other_pupillary_distance = 4587620
        keratometry_right_eye_sequence = 4587632
        keratometry_left_eye_sequence = 4587633
        steep_keratometric_axis_sequence = 4587636
        radius_of_curvature = 4587637
        keratometric_power = 4587638
        keratometric_axis = 4587639
        flat_keratometric_axis_sequence = 4587648
        background_color = 4587666
        optotype = 4587668
        optotype_presentation = 4587669
        subjective_refraction_right_eye_sequence = 4587671
        subjective_refraction_left_eye_sequence = 4587672
        add_near_sequence = 4587776
        add_intermediate_sequence = 4587777
        add_other_sequence = 4587778
        add_power = 4587780
        viewing_distance = 4587782
        visual_acuity_type_code_sequence = 4587809
        visual_acuity_right_eye_sequence = 4587810
        visual_acuity_left_eye_sequence = 4587811
        visual_acuity_both_eyes_open_sequence = 4587812
        viewing_distance_type = 4587813
        visual_acuity_modifiers = 4587829
        decimal_visual_acuity = 4587831
        optotype_detailed_definition = 4587833
        referenced_refractive_measurements_sequence = 4587845
        sphere_power = 4587846
        cylinder_power = 4587847
        corneal_topography_surface = 4588033
        corneal_vertex_location = 4588034
        pupil_centroid_x_coordinate = 4588035
        pupil_centroid_y_coordinate = 4588036
        equivalent_pupil_radius = 4588037
        corneal_topography_map_type_code_sequence = 4588039
        vertices_of_the_outline_of_pupil = 4588040
        corneal_topography_mapping_normals_sequence = 4588048
        maximum_corneal_curvature_sequence = 4588049
        maximum_corneal_curvature = 4588050
        maximum_corneal_curvature_location = 4588051
        minimum_keratometric_sequence = 4588053
        simulated_keratometric_cylinder_sequence = 4588056
        average_corneal_power = 4588064
        corneal_i_s_value = 4588068
        analyzed_area = 4588071
        surface_regularity_index = 4588080
        surface_asymmetry_index = 4588082
        corneal_eccentricity_index = 4588084
        keratoconus_prediction_index = 4588086
        decimal_potential_visual_acuity = 4588088
        corneal_topography_map_quality_evaluation = 4588098
        source_image_corneal_processed_data_sequence = 4588100
        corneal_point_location = 4588103
        corneal_point_estimated = 4588104
        axial_power = 4588105
        tangential_power = 4588112
        refractive_power = 4588113
        relative_elevation = 4588114
        corneal_wavefront = 4588115
        imaged_volume_width = 4718593
        imaged_volume_height = 4718594
        imaged_volume_depth = 4718595
        total_pixel_matrix_columns = 4718598
        total_pixel_matrix_rows = 4718599
        total_pixel_matrix_origin_sequence = 4718600
        specimen_label_in_image = 4718608
        focus_method = 4718609
        extended_depth_of_field = 4718610
        number_of_focal_planes = 4718611
        distance_between_focal_planes = 4718612
        recommended_absent_pixel_cielab_value = 4718613
        illuminator_type_code_sequence = 4718848
        image_orientation__slide_ = 4718850
        optical_path_sequence = 4718853
        optical_path_identifier = 4718854
        optical_path_description = 4718855
        illumination_color_code_sequence = 4718856
        specimen_reference_sequence = 4718864
        condenser_lens_power = 4718865
        objective_lens_power = 4718866
        objective_lens_numerical_aperture = 4718867
        palette_color_lookup_table_sequence = 4718880
        referenced_image_navigation_sequence = 4719104
        top_left_hand_corner_of_localizer_area = 4719105
        bottom_right_hand_corner_of_localizer_area = 4719106
        optical_path_identification_sequence = 4719111
        plane_position__slide__sequence = 4719130
        column_position_in_total_image_pixel_matrix = 4719134
        row_position_in_total_image_pixel_matrix = 4719135
        pixel_origin_interpretation = 4719361
        calibration_image = 5242884
        device_sequence = 5242896
        container_component_type_code_sequence = 5242898
        container_component_thickness = 5242899
        device_length = 5242900
        container_component_width = 5242901
        device_diameter = 5242902
        device_diameter_units = 5242903
        device_volume = 5242904
        inter_marker_distance = 5242905
        container_component_material = 5242906
        container_component_id = 5242907
        container_component_length = 5242908
        container_component_diameter = 5242909
        container_component_description = 5242910
        device_description = 5242912
        contrast_bolus_ingredient_percent_by_volume = 5373953
        oct_focal_distance = 5373954
        beam_spot_size = 5373955
        effective_refractive_index = 5373956
        oct_acquisition_domain = 5373958
        oct_optical_center_wavelength = 5373959
        axial_resolution = 5373960
        ranging_depth = 5373961
        a_line_rate = 5373969
        a_lines_per_frame = 5373970
        catheter_rotational_rate = 5373971
        a_line_pixel_spacing = 5373972
        mode_of_percutaneous_access_sequence = 5373974
        intravascular_oct_frame_type_sequence = 5373989
        oct_z_offset_applied = 5373990
        intravascular_frame_content_sequence = 5373991
        intravascular_longitudinal_distance = 5373992
        intravascular_oct_frame_content_sequence = 5373993
        oct_z_offset_correction = 5374000
        catheter_direction_of_rotation = 5374001
        seam_line_location = 5374003
        first_a_line_location = 5374004
        seam_line_index = 5374006
        number_of_padded_a_lines = 5374008
        interpolation_type = 5374009
        refractive_index_applied = 5374010
        energy_window_vector = 5505040
        number_of_energy_windows = 5505041
        energy_window_information_sequence = 5505042
        energy_window_range_sequence = 5505043
        energy_window_lower_limit = 5505044
        energy_window_upper_limit = 5505045
        radiopharmaceutical_information_sequence = 5505046
        residual_syringe_counts = 5505047
        energy_window_name = 5505048
        detector_vector = 5505056
        number_of_detectors = 5505057
        detector_information_sequence = 5505058
        phase_vector = 5505072
        number_of_phases = 5505073
        phase_information_sequence = 5505074
        number_of_frames_in_phase = 5505075
        phase_delay = 5505078
        pause_between_frames = 5505080
        phase_description = 5505081
        rotation_vector = 5505104
        number_of_rotations = 5505105
        rotation_information_sequence = 5505106
        number_of_frames_in_rotation = 5505107
        r_r_interval_vector = 5505120
        number_of_r_r_intervals = 5505121
        gated_information_sequence = 5505122
        data_information_sequence = 5505123
        time_slot_vector = 5505136
        number_of_time_slots = 5505137
        time_slot_information_sequence = 5505138
        time_slot_time = 5505139
        slice_vector = 5505152
        number_of_slices = 5505153
        angular_view_vector = 5505168
        time_slice_vector = 5505280
        number_of_time_slices = 5505281
        start_angle = 5505536
        type_of_detector_motion = 5505538
        trigger_vector = 5505552
        number_of_triggers_in_phase = 5505553
        view_code_sequence = 5505568
        view_modifier_code_sequence = 5505570
        radionuclide_code_sequence = 5505792
        administration_route_code_sequence = 5505794
        radiopharmaceutical_code_sequence = 5505796
        calibration_data_sequence = 5505798
        energy_window_number = 5505800
        image_id = 5506048
        patient_orientation_code_sequence = 5506064
        patient_orientation_modifier_code_sequence = 5506066
        patient_gantry_relationship_code_sequence = 5506068
        slice_progression_direction = 5506304
        scan_progression_direction = 5506305
        series_type = 5509120
        units = 5509121
        counts_source = 5509122
        reprojection_method = 5509124
        suv_type = 5509126
        randoms_correction_method = 5509376
        attenuation_correction_method = 5509377
        decay_correction = 5509378
        reconstruction_method = 5509379
        detector_lines_of_response_used = 5509380
        scatter_correction_method = 5509381
        axial_acceptance = 5509632
        axial_mash = 5509633
        transverse_mash = 5509634
        detector_element_size = 5509635
        coincidence_window_width = 5509648
        secondary_counts_type = 5509664
        frame_reference_time = 5509888
        primary__prompts__counts_accumulated = 5509904
        secondary_counts_accumulated = 5509905
        slice_sensitivity_factor = 5509920
        decay_factor = 5509921
        dose_calibration_factor = 5509922
        scatter_fraction_factor = 5509923
        dead_time_factor = 5509924
        image_index = 5509936
        counts_included = 5510144
        dead_time_correction_flag = 5510145
        histogram_sequence = 6303744
        histogram_number_of_bins = 6303746
        histogram_first_bin_value = 6303748
        histogram_last_bin_value = 6303750
        histogram_bin_width = 6303752
        histogram_explanation = 6303760
        histogram_data = 6303776
        segmentation_type = 6422529
        segment_sequence = 6422530
        segmented_property_category_code_sequence = 6422531
        segment_number = 6422532
        segment_label = 6422533
        segment_description = 6422534
        segment_algorithm_type = 6422536
        segment_algorithm_name = 6422537
        segment_identification_sequence = 6422538
        referenced_segment_number = 6422539
        recommended_display_grayscale_value = 6422540
        recommended_display_cielab_value = 6422541
        maximum_fractional_value = 6422542
        segmented_property_type_code_sequence = 6422543
        segmentation_fractional_type = 6422544
        segmented_property_type_modifier_code_sequence = 6422545
        used_segments_sequence = 6422546
        tracking_id = 6422560
        tracking_uid = 6422561
        deformable_registration_sequence = 6553602
        source_frame_of_reference_uid = 6553603
        deformable_registration_grid_sequence = 6553605
        grid_dimensions = 6553607
        grid_resolution = 6553608
        vector_grid_data = 6553609
        pre_deformation_matrix_registration_sequence = 6553615
        post_deformation_matrix_registration_sequence = 6553616
        number_of_surfaces = 6684673
        surface_sequence = 6684674
        surface_number = 6684675
        surface_comments = 6684676
        surface_processing = 6684681
        surface_processing_ratio = 6684682
        surface_processing_description = 6684683
        recommended_presentation_opacity = 6684684
        recommended_presentation_type = 6684685
        finite_volume = 6684686
        manifold = 6684688
        surface_points_sequence = 6684689
        surface_points_normals_sequence = 6684690
        surface_mesh_primitives_sequence = 6684691
        number_of_surface_points = 6684693
        point_coordinates_data = 6684694
        point_position_accuracy = 6684695
        mean_point_distance = 6684696
        maximum_point_distance = 6684697
        points_bounding_box_coordinates = 6684698
        axis_of_rotation = 6684699
        center_of_rotation = 6684700
        number_of_vectors = 6684702
        vector_dimensionality = 6684703
        vector_accuracy = 6684704
        vector_coordinate_data = 6684705
        triangle_point_index_list = 6684707
        edge_point_index_list = 6684708
        vertex_point_index_list = 6684709
        triangle_strip_sequence = 6684710
        triangle_fan_sequence = 6684711
        line_sequence = 6684712
        primitive_point_index_list = 6684713
        surface_count = 6684714
        referenced_surface_sequence = 6684715
        referenced_surface_number = 6684716
        segment_surface_generation_algorithm_identification_sequence = 6684717
        segment_surface_source_instance_sequence = 6684718
        algorithm_family_code_sequence = 6684719
        algorithm_name_code_sequence = 6684720
        algorithm_version = 6684721
        algorithm_parameters = 6684722
        facet_sequence = 6684724
        surface_processing_algorithm_identification_sequence = 6684725
        algorithm_name = 6684726
        recommended_point_radius = 6684727
        recommended_line_thickness = 6684728
        long_primitive_point_index_list = 6684736
        long_triangle_point_index_list = 6684737
        long_edge_point_index_list = 6684738
        long_vertex_point_index_list = 6684739
        track_set_sequence = 6684929
        track_sequence = 6684930
        recommended_display_cielab_value_list = 6684931
        tracking_algorithm_identification_sequence = 6684932
        track_set_number = 6684933
        track_set_label = 6684934
        track_set_description = 6684935
        track_set_anatomical_type_code_sequence = 6684936
        measurements_sequence = 6684961
        track_set_statistics_sequence = 6684964
        floating_point_values = 6684965
        track_point_index_list = 6684969
        track_statistics_sequence = 6684976
        measurement_values_sequence = 6684978
        diffusion_acquisition_code_sequence = 6684979
        diffusion_model_code_sequence = 6684980
        implant_size = 6840848
        implant_template_version = 6840865
        replaced_implant_template_sequence = 6840866
        implant_type = 6840867
        derivation_implant_template_sequence = 6840868
        original_implant_template_sequence = 6840869
        effective_datetime = 6840870
        implant_target_anatomy_sequence = 6840880
        information_from_manufacturer_sequence = 6840928
        notification_from_manufacturer_sequence = 6840933
        information_issue_datetime = 6840944
        information_summary = 6840960
        implant_regulatory_disapproval_code_sequence = 6840992
        overall_template_spatial_tolerance = 6840997
        hpgl_document_sequence = 6841024
        hpgl_document_id = 6841040
        hpgl_document_label = 6841045
        view_orientation_code_sequence = 6841056
        view_orientation_modifier = 6841072
        hpgl_document_scaling = 6841074
        hpgl_document = 6841088
        hpgl_contour_pen_number = 6841104
        hpgl_pen_sequence = 6841120
        hpgl_pen_number = 6841136
        hpgl_pen_label = 6841152
        hpgl_pen_description = 6841157
        recommended_rotation_point = 6841158
        bounding_rectangle = 6841159
        implant_template_3d_model_surface_number = 6841168
        surface_model_description_sequence = 6841184
        surface_model_label = 6841216
        surface_model_scaling_factor = 6841232
        materials_code_sequence = 6841248
        coating_materials_code_sequence = 6841252
        implant_type_code_sequence = 6841256
        fixation_method_code_sequence = 6841260
        mating_feature_sets_sequence = 6841264
        mating_feature_set_id = 6841280
        mating_feature_set_label = 6841296
        mating_feature_sequence = 6841312
        mating_feature_id = 6841328
        mating_feature_degree_of_freedom_sequence = 6841344
        degree_of_freedom_id = 6841360
        degree_of_freedom_type = 6841376
        tag_2d_mating_feature_coordinates_sequence = 6841392
        referenced_hpgl_document_id = 6841408
        tag_2d_mating_point = 6841424
        tag_2d_mating_axes = 6841440
        tag_2d_degree_of_freedom_sequence = 6841456
        tag_3d_degree_of_freedom_axis = 6841488
        range_of_freedom = 6841504
        tag_3d_mating_point = 6841536
        tag_3d_mating_axes = 6841552
        tag_2d_degree_of_freedom_axis = 6841584
        planning_landmark_point_sequence = 6841600
        planning_landmark_line_sequence = 6841616
        planning_landmark_plane_sequence = 6841632
        planning_landmark_id = 6841648
        planning_landmark_description = 6841664
        planning_landmark_identification_code_sequence = 6841669
        tag_2d_point_coordinates_sequence = 6841680
        tag_2d_point_coordinates = 6841696
        tag_3d_point_coordinates = 6841744
        tag_2d_line_coordinates_sequence = 6841760
        tag_2d_line_coordinates = 6841776
        tag_3d_line_coordinates = 6841808
        tag_2d_plane_coordinates_sequence = 6841824
        tag_2d_plane_intersection = 6841840
        tag_3d_plane_origin = 6841872
        tag_3d_plane_normal = 6841888
        graphic_annotation_sequence = 7340033
        graphic_layer = 7340034
        bounding_box_annotation_units = 7340035
        anchor_point_annotation_units = 7340036
        graphic_annotation_units = 7340037
        unformatted_text_value = 7340038
        text_object_sequence = 7340040
        graphic_object_sequence = 7340041
        bounding_box_top_left_hand_corner = 7340048
        bounding_box_bottom_right_hand_corner = 7340049
        bounding_box_text_horizontal_justification = 7340050
        anchor_point = 7340052
        anchor_point_visibility = 7340053
        graphic_dimensions = 7340064
        number_of_graphic_points = 7340065
        graphic_data = 7340066
        graphic_type = 7340067
        graphic_filled = 7340068
        image_rotation__retired_ = 7340096
        image_horizontal_flip = 7340097
        image_rotation = 7340098
        displayed_area_top_left_hand_corner__trial_ = 7340112
        displayed_area_bottom_right_hand_corner__trial_ = 7340113
        displayed_area_top_left_hand_corner = 7340114
        displayed_area_bottom_right_hand_corner = 7340115
        displayed_area_selection_sequence = 7340122
        graphic_layer_sequence = 7340128
        graphic_layer_order = 7340130
        graphic_layer_recommended_display_grayscale_value = 7340134
        graphic_layer_recommended_display_rgb_value = 7340135
        graphic_layer_description = 7340136
        content_label = 7340160
        content_description = 7340161
        presentation_creation_date = 7340162
        presentation_creation_time = 7340163
        content_creator_s_name = 7340164
        content_creator_s_identification_code_sequence = 7340166
        alternate_content_description_sequence = 7340167
        presentation_size_mode = 7340288
        presentation_pixel_spacing = 7340289
        presentation_pixel_aspect_ratio = 7340290
        presentation_pixel_magnification_ratio = 7340291
        graphic_group_label = 7340551
        graphic_group_description = 7340552
        compound_graphic_sequence = 7340553
        compound_graphic_instance_id = 7340582
        font_name = 7340583
        font_name_type = 7340584
        css_font_name = 7340585
        rotation_angle = 7340592
        text_style_sequence = 7340593
        line_style_sequence = 7340594
        fill_style_sequence = 7340595
        graphic_group_sequence = 7340596
        text_color_cielab_value = 7340609
        horizontal_alignment = 7340610
        vertical_alignment = 7340611
        shadow_style = 7340612
        shadow_offset_x = 7340613
        shadow_offset_y = 7340614
        shadow_color_cielab_value = 7340615
        underlined = 7340616
        bold = 7340617
        italic = 7340624
        pattern_on_color_cielab_value = 7340625
        pattern_off_color_cielab_value = 7340626
        line_thickness = 7340627
        line_dashing_style = 7340628
        line_pattern = 7340629
        fill_pattern = 7340630
        fill_mode = 7340631
        shadow_opacity = 7340632
        gap_length = 7340641
        diameter_of_visibility = 7340642
        rotation_point = 7340659
        tick_alignment = 7340660
        show_tick_label = 7340664
        tick_label_alignment = 7340665
        compound_graphic_units = 7340674
        pattern_on_opacity = 7340676
        pattern_off_opacity = 7340677
        major_ticks_sequence = 7340679
        tick_position = 7340680
        tick_label = 7340681
        compound_graphic_type = 7340692
        graphic_group_id = 7340693
        shape_type = 7340806
        registration_sequence = 7340808
        matrix_registration_sequence = 7340809
        matrix_sequence = 7340810
        frame_of_reference_to_displayed_coordinate_system_transformation_matrix = 7340811
        frame_of_reference_transformation_matrix_type = 7340812
        registration_type_code_sequence = 7340813
        fiducial_description = 7340815
        fiducial_identifier = 7340816
        fiducial_identifier_code_sequence = 7340817
        contour_uncertainty_radius = 7340818
        used_fiducials_sequence = 7340820
        graphic_coordinates_data_sequence = 7340824
        fiducial_uid = 7340826
        fiducial_set_sequence = 7340828
        fiducial_sequence = 7340830
        graphic_layer_recommended_display_cielab_value = 7341057
        blending_sequence = 7341058
        relative_opacity = 7341059
        referenced_spatial_registration_sequence = 7341060
        blending_position = 7341061
        presentation_display_collection_uid = 7344385
        presentation_sequence_collection_uid = 7344386
        presentation_sequence_position_index = 7344387
        rendered_image_reference_sequence = 7344388
        volumetric_presentation_state_input_sequence = 7344641
        presentation_input_type = 7344642
        input_sequence_position_index = 7344643
        crop = 7344644
        cropping_specification_index = 7344645
        compositing_method = 7344646
        volumetric_presentation_input_number = 7344647
        image_volume_geometry = 7344648
        volume_cropping_sequence = 7344897
        volume_cropping_method = 7344898
        bounding_box_crop = 7344899
        oblique_cropping_plane_sequence = 7344900
        plane = 7344901
        plane_normal = 7344902
        cropping_specification_number = 7344905
        multi_planar_reconstruction_style = 7345409
        mpr_thickness_type = 7345410
        mpr_slab_thickness = 7345411
        mpr_top_left_hand_corner = 7345413
        mpr_view_width_direction = 7345415
        mpr_view_width = 7345416
        number_of_volumetric_curve_points = 7345420
        volumetric_curve_points = 7345421
        mpr_view_height_direction = 7345425
        mpr_view_height = 7345426
        presentation_state_classification_component_sequence = 7346177
        component_type = 7346178
        component_input_sequence = 7346179
        volumetric_presentation_input_index = 7346180
        presentation_state_compositor_component_sequence = 7346181
        weighting_transfer_function_sequence = 7346182
        weighting_lookup_table_descriptor = 7346183
        weighting_lookup_table_data = 7346184
        volumetric_annotation_sequence = 7346433
        referenced_structured_context_sequence = 7346435
        referenced_content_item = 7346436
        volumetric_presentation_input_annotation_sequence = 7346437
        annotation_clipping = 7346439
        presentation_animation_style = 7346689
        recommended_animation_rate = 7346691
        animation_curve_sequence = 7346692
        animation_step_size = 7346693
        hanging_protocol_name = 7471106
        hanging_protocol_description = 7471108
        hanging_protocol_level = 7471110
        hanging_protocol_creator = 7471112
        hanging_protocol_creation_datetime = 7471114
        hanging_protocol_definition_sequence = 7471116
        hanging_protocol_user_identification_code_sequence = 7471118
        hanging_protocol_user_group_name = 7471120
        source_hanging_protocol_sequence = 7471122
        number_of_priors_referenced = 7471124
        image_sets_sequence = 7471136
        image_set_selector_sequence = 7471138
        image_set_selector_usage_flag = 7471140
        selector_attribute = 7471142
        selector_value_number = 7471144
        time_based_image_sets_sequence = 7471152
        image_set_number = 7471154
        image_set_selector_category = 7471156
        relative_time = 7471160
        relative_time_units = 7471162
        abstract_prior_value = 7471164
        abstract_prior_code_sequence = 7471166
        image_set_label = 7471168
        selector_attribute_vr = 7471184
        selector_sequence_pointer = 7471186
        selector_sequence_pointer_private_creator = 7471188
        selector_attribute_private_creator = 7471190
        selector_ae_value = 7471198
        selector_as_value = 7471199
        selector_at_value = 7471200
        selector_da_value = 7471201
        selector_cs_value = 7471202
        selector_dt_value = 7471203
        selector_is_value = 7471204
        selector_ob_value = 7471205
        selector_lo_value = 7471206
        selector_of_value = 7471207
        selector_lt_value = 7471208
        selector_ow_value = 7471209
        selector_pn_value = 7471210
        selector_tm_value = 7471211
        selector_sh_value = 7471212
        selector_un_value = 7471213
        selector_st_value = 7471214
        selector_uc_value = 7471215
        selector_ut_value = 7471216
        selector_ur_value = 7471217
        selector_ds_value = 7471218
        selector_od_value = 7471219
        selector_fd_value = 7471220
        selector_ol_value = 7471221
        selector_fl_value = 7471222
        selector_ul_value = 7471224
        selector_us_value = 7471226
        selector_sl_value = 7471228
        selector_ss_value = 7471230
        selector_ui_value = 7471231
        selector_code_sequence_value = 7471232
        number_of_screens = 7471360
        nominal_screen_definition_sequence = 7471362
        number_of_vertical_pixels = 7471364
        number_of_horizontal_pixels = 7471366
        display_environment_spatial_position = 7471368
        screen_minimum_grayscale_bit_depth = 7471370
        screen_minimum_color_bit_depth = 7471372
        application_maximum_repaint_time = 7471374
        display_sets_sequence = 7471616
        display_set_number = 7471618
        display_set_label = 7471619
        display_set_presentation_group = 7471620
        display_set_presentation_group_description = 7471622
        partial_data_display_handling = 7471624
        synchronized_scrolling_sequence = 7471632
        display_set_scrolling_group = 7471634
        navigation_indicator_sequence = 7471636
        navigation_display_set = 7471638
        reference_display_sets = 7471640
        image_boxes_sequence = 7471872
        image_box_number = 7471874
        image_box_layout_type = 7471876
        image_box_tile_horizontal_dimension = 7471878
        image_box_tile_vertical_dimension = 7471880
        image_box_scroll_direction = 7471888
        image_box_small_scroll_type = 7471890
        image_box_small_scroll_amount = 7471892
        image_box_large_scroll_type = 7471894
        image_box_large_scroll_amount = 7471896
        image_box_overlap_priority = 7471904
        cine_relative_to_real_time = 7471920
        filter_operations_sequence = 7472128
        filter_by_category = 7472130
        filter_by_attribute_presence = 7472132
        filter_by_operator = 7472134
        structured_display_background_cielab_value = 7472160
        empty_image_box_cielab_value = 7472161
        structured_display_image_box_sequence = 7472162
        structured_display_text_box_sequence = 7472164
        referenced_first_frame_sequence = 7472167
        image_box_synchronization_sequence = 7472176
        synchronized_image_box_list = 7472178
        type_of_synchronization = 7472180
        blending_operation_type = 7472384
        reformatting_operation_type = 7472400
        reformatting_thickness = 7472402
        reformatting_interval = 7472404
        reformatting_operation_initial_view_direction = 7472406
        tag_3d_rendering_type = 7472416
        sorting_operations_sequence = 7472640
        sort_by_category = 7472642
        sorting_direction = 7472644
        display_set_patient_orientation = 7472896
        voi_type = 7472898
        pseudo_color_type = 7472900
        pseudo_color_palette_instance_reference_sequence = 7472901
        show_grayscale_inverted = 7472902
        show_image_true_size_flag = 7472912
        show_graphic_annotation_flag = 7472914
        show_patient_demographics_flag = 7472916
        show_acquisition_techniques_flag = 7472918
        display_set_horizontal_justification = 7472919
        display_set_vertical_justification = 7472920
        continuation_start_meterset = 7602464
        continuation_end_meterset = 7602465
        procedure_step_state = 7606272
        procedure_step_progress_information_sequence = 7606274
        procedure_step_progress = 7606276
        procedure_step_progress_description = 7606278
        procedure_step_communications_uri_sequence = 7606280
        contact_uri = 7606282
        contact_display_name = 7606284
        procedure_step_discontinuation_reason_code_sequence = 7606286
        beam_task_sequence = 7606304
        beam_task_type = 7606306
        beam_order_index__trial_ = 7606308
        autosequence_flag = 7606309
        table_top_vertical_adjusted_position = 7606310
        table_top_longitudinal_adjusted_position = 7606311
        table_top_lateral_adjusted_position = 7606312
        patient_support_adjusted_angle = 7606314
        table_top_eccentric_adjusted_angle = 7606315
        table_top_pitch_adjusted_angle = 7606316
        table_top_roll_adjusted_angle = 7606317
        delivery_verification_image_sequence = 7606320
        verification_image_timing = 7606322
        double_exposure_flag = 7606324
        double_exposure_ordering = 7606326
        double_exposure_meterset__trial_ = 7606328
        double_exposure_field_delta__trial_ = 7606330
        related_reference_rt_image_sequence = 7606336
        general_machine_verification_sequence = 7606338
        conventional_machine_verification_sequence = 7606340
        ion_machine_verification_sequence = 7606342
        failed_attributes_sequence = 7606344
        overridden_attributes_sequence = 7606346
        conventional_control_point_verification_sequence = 7606348
        ion_control_point_verification_sequence = 7606350
        attribute_occurrence_sequence = 7606352
        attribute_occurrence_pointer = 7606354
        attribute_item_selector = 7606356
        attribute_occurrence_private_creator = 7606358
        selector_sequence_pointer_items = 7606359
        scheduled_procedure_step_priority = 7606784
        worklist_label = 7606786
        procedure_step_label = 7606788
        scheduled_processing_parameters_sequence = 7606800
        performed_processing_parameters_sequence = 7606802
        unified_procedure_step_performed_procedure_sequence = 7606806
        related_procedure_step_sequence = 7606816
        procedure_step_relationship_type = 7606818
        replaced_procedure_step_sequence = 7606820
        deletion_lock = 7606832
        receiving_ae = 7606836
        requesting_ae = 7606838
        reason_for_cancellation = 7606840
        scp_status = 7606850
        subscription_list_status = 7606852
        unified_procedure_step_list_status = 7606854
        beam_order_index = 7607076
        double_exposure_meterset = 7607096
        double_exposure_field_delta = 7607098
        brachy_task_sequence = 7607297
        continuation_start_total_reference_air_kerma = 7607298
        continuation_end_total_reference_air_kerma = 7607299
        continuation_pulse_number = 7607300
        channel_delivery_order_sequence = 7607301
        referenced_channel_number = 7607302
        start_cumulative_time_weight = 7607303
        end_cumulative_time_weight = 7607304
        omitted_channel_sequence = 7607305
        reason_for_channel_omission = 7607306
        reason_for_channel_omission_description = 7607307
        channel_delivery_order_index = 7607308
        channel_delivery_continuation_sequence = 7607309
        omitted_application_setup_sequence = 7607310
        implant_assembly_template_name = 7733249
        implant_assembly_template_issuer = 7733251
        implant_assembly_template_version = 7733254
        replaced_implant_assembly_template_sequence = 7733256
        implant_assembly_template_type = 7733258
        original_implant_assembly_template_sequence = 7733260
        derivation_implant_assembly_template_sequence = 7733262
        implant_assembly_template_target_anatomy_sequence = 7733264
        procedure_type_code_sequence = 7733280
        surgical_technique = 7733296
        component_types_sequence = 7733298
        component_type_code_sequence = 7733300
        exclusive_component_type = 7733302
        mandatory_component_type = 7733304
        component_sequence = 7733312
        component_id = 7733333
        component_assembly_sequence = 7733344
        component_1_referenced_id = 7733360
        component_1_referenced_mating_feature_set_id = 7733376
        component_1_referenced_mating_feature_id = 7733392
        component_2_referenced_id = 7733408
        component_2_referenced_mating_feature_set_id = 7733424
        component_2_referenced_mating_feature_id = 7733440
        implant_template_group_name = 7864321
        implant_template_group_description = 7864336
        implant_template_group_issuer = 7864352
        implant_template_group_version = 7864356
        replaced_implant_template_group_sequence = 7864358
        implant_template_group_target_anatomy_sequence = 7864360
        implant_template_group_members_sequence = 7864362
        implant_template_group_member_id = 7864366
        tag_3d_implant_template_group_member_matching_point = 7864400
        tag_3d_implant_template_group_member_matching_axes = 7864416
        implant_template_group_member_matching_2d_coordinates_sequence = 7864432
        tag_2d_implant_template_group_member_matching_point = 7864464
        tag_2d_implant_template_group_member_matching_axes = 7864480
        implant_template_group_variation_dimension_sequence = 7864496
        implant_template_group_variation_dimension_name = 7864498
        implant_template_group_variation_dimension_rank_sequence = 7864500
        referenced_implant_template_group_member_id = 7864502
        implant_template_group_variation_dimension_rank = 7864504
        surface_scan_acquisition_type_code_sequence = 8388609
        surface_scan_mode_code_sequence = 8388610
        registration_method_code_sequence = 8388611
        shot_duration_time = 8388612
        shot_offset_time = 8388613
        surface_point_presentation_value_data = 8388614
        surface_point_color_cielab_value_data = 8388615
        uv_mapping_sequence = 8388616
        texture_label = 8388617
        u_value_data = 8388624
        v_value_data = 8388625
        referenced_texture_sequence = 8388626
        referenced_surface_data_sequence = 8388627
        assessment_summary = 8519681
        assessment_summary_description = 8519683
        assessed_sop_instance_sequence = 8519684
        referenced_comparison_sop_instance_sequence = 8519685
        number_of_assessment_observations = 8519686
        assessment_observations_sequence = 8519687
        observation_significance = 8519688
        observation_description = 8519690
        structured_constraint_observation_sequence = 8519692
        assessed_attribute_value_sequence = 8519696
        assessment_set_id = 8519702
        assessment_requester_sequence = 8519703
        selector_attribute_name = 8519704
        selector_attribute_keyword = 8519705
        assessment_type_code_sequence = 8519713
        observation_basis_code_sequence = 8519714
        assessment_label = 8519715
        constraint_type = 8519730
        specification_selection_guidance = 8519731
        constraint_value_sequence = 8519732
        recommended_default_value_sequence = 8519733
        constraint_violation_significance = 8519734
        constraint_violation_condition = 8519735
        storage_media_file_set_id = 8913200
        storage_media_file_set_uid = 8913216
        icon_image_sequence = 8913408
        topic_title = 8915204
        topic_subject = 8915206
        topic_author = 8915216
        topic_keywords = 8915218
        sop_instance_status = 16778256
        sop_authorization_datetime = 16778272
        sop_authorization_comment = 16778276
        authorization_equipment_certification_number = 16778278
        mac_id_number = 67108869
        mac_calculation_transfer_syntax_uid = 67108880
        mac_algorithm = 67108885
        data_elements_signed = 67108896
        digital_signature_uid = 67109120
        digital_signature_datetime = 67109125
        certificate_type = 67109136
        certificate_of_signer = 67109141
        signature = 67109152
        certified_timestamp_type = 67109637
        certified_timestamp = 67109648
        digital_signature_purpose_code_sequence = 67109889
        referenced_digital_signature_sequence = 67109890
        referenced_sop_instance_mac_sequence = 67109891
        mac = 67109892
        encrypted_attributes_sequence = 67110144
        encrypted_content_transfer_syntax_uid = 67110160
        encrypted_content = 67110176
        modified_attributes_sequence = 67110224
        original_attributes_sequence = 67110241
        attribute_modification_datetime = 67110242
        modifying_system = 67110243
        source_of_previous_values = 67110244
        reason_for_the_attribute_modification = 67110245
        number_of_copies = 536870928
        printer_configuration_sequence = 536870942
        print_priority = 536870944
        medium_type = 536870960
        film_destination = 536870976
        film_session_label = 536870992
        memory_allocation = 536871008
        maximum_memory_allocation = 536871009
        color_image_printing_flag = 536871010
        collation_flag = 536871011
        annotation_flag = 536871013
        image_overlay_flag = 536871015
        presentation_lut_flag = 536871017
        image_box_presentation_lut_flag = 536871018
        memory_bit_depth = 536871072
        printing_bit_depth = 536871073
        media_installed_sequence = 536871074
        other_media_available_sequence = 536871076
        supported_image_display_formats_sequence = 536871080
        referenced_film_box_sequence = 536872192
        referenced_stored_print_sequence = 536872208
        image_display_format = 537919504
        annotation_display_format_id = 537919536
        film_orientation = 537919552
        film_size_id = 537919568
        printer_resolution_id = 537919570
        default_printer_resolution_id = 537919572
        magnification_type = 537919584
        smoothing_type = 537919616
        default_magnification_type = 537919654
        other_magnification_types_available = 537919655
        default_smoothing_type = 537919656
        other_smoothing_types_available = 537919657
        border_density = 537919744
        empty_image_density = 537919760
        min_density = 537919776
        max_density = 537919792
        trim = 537919808
        configuration_information = 537919824
        configuration_information_description = 537919826
        maximum_collated_films = 537919828
        illumination = 537919838
        reflected_ambient_light = 537919840
        printer_pixel_spacing = 537920374
        referenced_film_session_sequence = 537920768
        referenced_image_box_sequence = 537920784
        referenced_basic_annotation_box_sequence = 537920800
        image_box_position = 538968080
        polarity = 538968096
        requested_image_size = 538968112
        requested_decimate_crop_behavior = 538968128
        requested_resolution_id = 538968144
        requested_image_size_flag = 538968224
        decimate_crop_result = 538968226
        basic_grayscale_image_sequence = 538968336
        basic_color_image_sequence = 538968337
        referenced_image_overlay_box_sequence = 538968368
        referenced_voi_lut_box_sequence = 538968384
        annotation_position = 540016656
        text_string = 540016672
        referenced_overlay_plane_sequence = 541065232
        referenced_overlay_plane_groups = 541065233
        overlay_pixel_data_sequence = 541065248
        overlay_magnification_type = 541065312
        overlay_smoothing_type = 541065328
        overlay_or_image_magnification = 541065330
        magnify_to_number_of_columns = 541065332
        overlay_foreground_density = 541065344
        overlay_background_density = 541065346
        overlay_mode = 541065360
        threshold_density = 541065472
        referenced_image_box_sequence__retired_ = 541066496
        presentation_lut_sequence = 542113808
        presentation_lut_shape = 542113824
        referenced_presentation_lut_sequence = 542115072
        print_job_id = 553648144
        execution_status = 553648160
        execution_status_info = 553648176
        creation_date = 553648192
        creation_time = 553648208
        originator = 553648240
        destination_ae = 553648448
        owner_id = 553648480
        number_of_films = 553648496
        referenced_print_job_sequence__pull_stored_print_ = 553649408
        printer_status = 554696720
        printer_status_info = 554696736
        printer_name = 554696752
        print_queue_id = 554696857
        queue_status = 555745296
        print_job_description_sequence = 555745360
        referenced_print_job_sequence = 555745392
        print_management_capabilities_sequence = 556793872
        printer_characteristics_sequence = 556793877
        film_box_content_sequence = 556793904
        image_box_content_sequence = 556793920
        annotation_content_sequence = 556793936
        image_overlay_box_content_sequence = 556793952
        presentation_lut_content_sequence = 556793984
        proposed_study_sequence = 556794016
        original_image_sequence = 556794048
        label_using_information_extracted_from_instances = 570425345
        label_text = 570425346
        label_style_selection = 570425347
        media_disposition = 570425348
        barcode_value = 570425349
        barcode_symbology = 570425350
        allow_media_splitting = 570425351
        include_non_dicom_objects = 570425352
        include_display_application = 570425353
        preserve_composite_instances_after_media_creation = 570425354
        total_number_of_pieces_of_media_created = 570425355
        requested_media_application_profile = 570425356
        referenced_storage_media_sequence = 570425357
        failure_attributes = 570425358
        allow_lossy_compression = 570425359
        request_priority = 570425376
        rt_image_label = 805437442
        rt_image_name = 805437443
        rt_image_description = 805437444
        reported_values_origin = 805437450
        rt_image_plane = 805437452
        x_ray_image_receptor_translation = 805437453
        x_ray_image_receptor_angle = 805437454
        rt_image_orientation = 805437456
        image_plane_pixel_spacing = 805437457
        rt_image_position = 805437458
        radiation_machine_name = 805437472
        radiation_machine_sad = 805437474
        radiation_machine_ssd = 805437476
        rt_image_sid = 805437478
        source_to_reference_object_distance = 805437480
        fraction_number = 805437481
        exposure_sequence = 805437488
        meterset_exposure = 805437490
        diaphragm_position = 805437492
        fluence_map_sequence = 805437504
        fluence_data_source = 805437505
        fluence_data_scale = 805437506
        primary_fluence_mode_sequence = 805437520
        fluence_mode = 805437521
        fluence_mode_id = 805437522
        dvh_type = 805568513
        dose_units = 805568514
        dose_type = 805568516
        spatial_transform_of_dose = 805568517
        dose_comment = 805568518
        normalization_point = 805568520
        dose_summation_type = 805568522
        grid_frame_offset_vector = 805568524
        dose_grid_scaling = 805568526
        rt_dose_roi_sequence = 805568528
        dose_value = 805568530
        tissue_heterogeneity_correction = 805568532
        dvh_normalization_point = 805568576
        dvh_normalization_dose_value = 805568578
        dvh_sequence = 805568592
        dvh_dose_scaling = 805568594
        dvh_volume_units = 805568596
        dvh_number_of_bins = 805568598
        dvh_data = 805568600
        dvh_referenced_roi_sequence = 805568608
        dvh_roi_contribution_type = 805568610
        dvh_minimum_dose = 805568624
        dvh_maximum_dose = 805568626
        dvh_mean_dose = 805568628
        structure_set_label = 805699586
        structure_set_name = 805699588
        structure_set_description = 805699590
        structure_set_date = 805699592
        structure_set_time = 805699593
        referenced_frame_of_reference_sequence = 805699600
        rt_referenced_study_sequence = 805699602
        rt_referenced_series_sequence = 805699604
        contour_image_sequence = 805699606
        predecessor_structure_set_sequence = 805699608
        structure_set_roi_sequence = 805699616
        roi_number = 805699618
        referenced_frame_of_reference_uid = 805699620
        roi_name = 805699622
        roi_description = 805699624
        roi_display_color = 805699626
        roi_volume = 805699628
        rt_related_roi_sequence = 805699632
        rt_roi_relationship = 805699635
        roi_generation_algorithm = 805699638
        roi_generation_description = 805699640
        roi_contour_sequence = 805699641
        contour_sequence = 805699648
        contour_geometric_type = 805699650
        contour_slab_thickness = 805699652
        contour_offset_vector = 805699653
        number_of_contour_points = 805699654
        contour_number = 805699656
        attached_contours = 805699657
        contour_data = 805699664
        rt_roi_observations_sequence = 805699712
        observation_number = 805699714
        referenced_roi_number = 805699716
        roi_observation_label = 805699717
        rt_roi_identification_code_sequence = 805699718
        roi_observation_description = 805699720
        related_rt_roi_observations_sequence = 805699744
        rt_roi_interpreted_type = 805699748
        roi_interpreter = 805699750
        roi_physical_properties_sequence = 805699760
        roi_physical_property = 805699762
        roi_physical_property_value = 805699764
        roi_elemental_composition_sequence = 805699766
        roi_elemental_composition_atomic_number = 805699767
        roi_elemental_composition_atomic_mass_fraction = 805699768
        additional_rt_roi_identification_code_sequence = 805699769
        frame_of_reference_relationship_sequence = 805699776
        related_frame_of_reference_uid = 805699778
        frame_of_reference_transformation_type = 805699780
        frame_of_reference_transformation_matrix = 805699782
        frame_of_reference_transformation_comment = 805699784
        measured_dose_reference_sequence = 805830672
        measured_dose_description = 805830674
        measured_dose_type = 805830676
        measured_dose_value = 805830678
        treatment_session_beam_sequence = 805830688
        treatment_session_ion_beam_sequence = 805830689
        current_fraction_number = 805830690
        treatment_control_point_date = 805830692
        treatment_control_point_time = 805830693
        treatment_termination_status = 805830698
        treatment_termination_code = 805830699
        treatment_verification_status = 805830700
        referenced_treatment_record_sequence = 805830704
        specified_primary_meterset = 805830706
        specified_secondary_meterset = 805830707
        delivered_primary_meterset = 805830710
        delivered_secondary_meterset = 805830711
        specified_treatment_time = 805830714
        delivered_treatment_time = 805830715
        control_point_delivery_sequence = 805830720
        ion_control_point_delivery_sequence = 805830721
        specified_meterset = 805830722
        delivered_meterset = 805830724
        meterset_rate_set = 805830725
        meterset_rate_delivered = 805830726
        scan_spot_metersets_delivered = 805830727
        dose_rate_delivered = 805830728
        treatment_summary_calculated_dose_reference_sequence = 805830736
        cumulative_dose_to_dose_reference = 805830738
        first_treatment_date = 805830740
        most_recent_treatment_date = 805830742
        number_of_fractions_delivered = 805830746
        override_sequence = 805830752
        parameter_sequence_pointer = 805830753
        override_parameter_pointer = 805830754
        parameter_item_index = 805830755
        measured_dose_reference_number = 805830756
        parameter_pointer = 805830757
        override_reason = 805830758
        corrected_parameter_sequence = 805830760
        correction_value = 805830762
        calculated_dose_reference_sequence = 805830768
        calculated_dose_reference_number = 805830770
        calculated_dose_reference_description = 805830772
        calculated_dose_reference_dose_value = 805830774
        start_meterset = 805830776
        end_meterset = 805830778
        referenced_measured_dose_reference_sequence = 805830784
        referenced_measured_dose_reference_number = 805830786
        referenced_calculated_dose_reference_sequence = 805830800
        referenced_calculated_dose_reference_number = 805830802
        beam_limiting_device_leaf_pairs_sequence = 805830816
        recorded_wedge_sequence = 805830832
        recorded_compensator_sequence = 805830848
        recorded_block_sequence = 805830864
        treatment_summary_measured_dose_reference_sequence = 805830880
        recorded_snout_sequence = 805830896
        recorded_range_shifter_sequence = 805830898
        recorded_lateral_spreading_device_sequence = 805830900
        recorded_range_modulator_sequence = 805830902
        recorded_source_sequence = 805830912
        source_serial_number = 805830917
        treatment_session_application_setup_sequence = 805830928
        application_setup_check = 805830934
        recorded_brachy_accessory_device_sequence = 805830944
        referenced_brachy_accessory_device_number = 805830946
        recorded_channel_sequence = 805830960
        specified_channel_total_time = 805830962
        delivered_channel_total_time = 805830964
        specified_number_of_pulses = 805830966
        delivered_number_of_pulses = 805830968
        specified_pulse_repetition_interval = 805830970
        delivered_pulse_repetition_interval = 805830972
        recorded_source_applicator_sequence = 805830976
        referenced_source_applicator_number = 805830978
        recorded_channel_shield_sequence = 805830992
        referenced_channel_shield_number = 805830994
        brachy_control_point_delivered_sequence = 805831008
        safe_position_exit_date = 805831010
        safe_position_exit_time = 805831012
        safe_position_return_date = 805831014
        safe_position_return_time = 805831016
        pulse_specific_brachy_control_point_delivered_sequence = 805831025
        pulse_number = 805831026
        brachy_pulse_control_point_delivered_sequence = 805831027
        current_treatment_status = 805831168
        treatment_status_comment = 805831170
        fraction_group_summary_sequence = 805831200
        referenced_fraction_number = 805831203
        fraction_group_type = 805831204
        beam_stopper_position = 805831216
        fraction_status_summary_sequence = 805831232
        treatment_date = 805831248
        treatment_time = 805831249
        rt_plan_label = 805961730
        rt_plan_name = 805961731
        rt_plan_description = 805961732
        rt_plan_date = 805961734
        rt_plan_time = 805961735
        treatment_protocols = 805961737
        plan_intent = 805961738
        treatment_sites = 805961739
        rt_plan_geometry = 805961740
        prescription_description = 805961742
        dose_reference_sequence = 805961744
        dose_reference_number = 805961746
        dose_reference_uid = 805961747
        dose_reference_structure_type = 805961748
        nominal_beam_energy_unit = 805961749
        dose_reference_description = 805961750
        dose_reference_point_coordinates = 805961752
        nominal_prior_dose = 805961754
        dose_reference_type = 805961760
        constraint_weight = 805961761
        delivery_warning_dose = 805961762
        delivery_maximum_dose = 805961763
        target_minimum_dose = 805961765
        target_prescription_dose = 805961766
        target_maximum_dose = 805961767
        target_underdose_volume_fraction = 805961768
        organ_at_risk_full_volume_dose = 805961770
        organ_at_risk_limit_dose = 805961771
        organ_at_risk_maximum_dose = 805961772
        organ_at_risk_overdose_volume_fraction = 805961773
        tolerance_table_sequence = 805961792
        tolerance_table_number = 805961794
        tolerance_table_label = 805961795
        gantry_angle_tolerance = 805961796
        beam_limiting_device_angle_tolerance = 805961798
        beam_limiting_device_tolerance_sequence = 805961800
        beam_limiting_device_position_tolerance = 805961802
        snout_position_tolerance = 805961803
        patient_support_angle_tolerance = 805961804
        table_top_eccentric_angle_tolerance = 805961806
        table_top_pitch_angle_tolerance = 805961807
        table_top_roll_angle_tolerance = 805961808
        table_top_vertical_position_tolerance = 805961809
        table_top_longitudinal_position_tolerance = 805961810
        table_top_lateral_position_tolerance = 805961811
        rt_plan_relationship = 805961813
        fraction_group_sequence = 805961840
        fraction_group_number = 805961841
        fraction_group_description = 805961842
        number_of_fractions_planned = 805961848
        number_of_fraction_pattern_digits_per_day = 805961849
        repeat_fraction_cycle_length = 805961850
        fraction_pattern = 805961851
        number_of_beams = 805961856
        beam_dose_specification_point = 805961858
        beam_dose = 805961860
        beam_meterset = 805961862
        beam_dose_point_depth = 805961864
        beam_dose_point_equivalent_depth = 805961865
        beam_dose_point_ssd = 805961866
        beam_dose_meaning = 805961867
        beam_dose_verification_control_point_sequence = 805961868
        average_beam_dose_point_depth = 805961869
        average_beam_dose_point_equivalent_depth = 805961870
        average_beam_dose_point_ssd = 805961871
        beam_dose_type = 805961872
        alternate_beam_dose = 805961873
        alternate_beam_dose_type = 805961874
        number_of_brachy_application_setups = 805961888
        brachy_application_setup_dose_specification_point = 805961890
        brachy_application_setup_dose = 805961892
        beam_sequence = 805961904
        treatment_machine_name = 805961906
        primary_dosimeter_unit = 805961907
        source_axis_distance = 805961908
        beam_limiting_device_sequence = 805961910
        rt_beam_limiting_device_type = 805961912
        source_to_beam_limiting_device_distance = 805961914
        isocenter_to_beam_limiting_device_distance = 805961915
        number_of_leaf_jaw_pairs = 805961916
        leaf_position_boundaries = 805961918
        beam_number = 805961920
        beam_name = 805961922
        beam_description = 805961923
        beam_type = 805961924
        beam_delivery_duration_limit = 805961925
        radiation_type = 805961926
        high_dose_technique_type = 805961927
        reference_image_number = 805961928
        planned_verification_image_sequence = 805961930
        imaging_device_specific_acquisition_parameters = 805961932
        treatment_delivery_type = 805961934
        number_of_wedges = 805961936
        wedge_sequence = 805961937
        wedge_number = 805961938
        wedge_type = 805961939
        wedge_id = 805961940
        wedge_angle = 805961941
        wedge_factor = 805961942
        total_wedge_tray_water_equivalent_thickness = 805961943
        wedge_orientation = 805961944
        isocenter_to_wedge_tray_distance = 805961945
        source_to_wedge_tray_distance = 805961946
        wedge_thin_edge_position = 805961947
        bolus_id = 805961948
        bolus_description = 805961949
        effective_wedge_angle = 805961950
        number_of_compensators = 805961952
        material_id = 805961953
        total_compensator_tray_factor = 805961954
        compensator_sequence = 805961955
        compensator_number = 805961956
        compensator_id = 805961957
        source_to_compensator_tray_distance = 805961958
        compensator_rows = 805961959
        compensator_columns = 805961960
        compensator_pixel_spacing = 805961961
        compensator_position = 805961962
        compensator_transmission_data = 805961963
        compensator_thickness_data = 805961964
        number_of_boli = 805961965
        compensator_type = 805961966
        compensator_tray_id = 805961967
        number_of_blocks = 805961968
        total_block_tray_factor = 805961970
        total_block_tray_water_equivalent_thickness = 805961971
        block_sequence = 805961972
        block_tray_id = 805961973
        source_to_block_tray_distance = 805961974
        isocenter_to_block_tray_distance = 805961975
        block_type = 805961976
        accessory_code = 805961977
        block_divergence = 805961978
        block_mounting_position = 805961979
        block_number = 805961980
        block_name = 805961982
        block_thickness = 805961984
        block_transmission = 805961986
        block_number_of_points = 805961988
        block_data = 805961990
        applicator_sequence = 805961991
        applicator_id = 805961992
        applicator_type = 805961993
        applicator_description = 805961994
        cumulative_dose_reference_coefficient = 805961996
        final_cumulative_meterset_weight = 805961998
        number_of_control_points = 805962000
        control_point_sequence = 805962001
        control_point_index = 805962002
        nominal_beam_energy = 805962004
        dose_rate_set = 805962005
        wedge_position_sequence = 805962006
        wedge_position = 805962008
        beam_limiting_device_position_sequence = 805962010
        leaf_jaw_positions = 805962012
        gantry_angle = 805962014
        gantry_rotation_direction = 805962015
        beam_limiting_device_angle = 805962016
        beam_limiting_device_rotation_direction = 805962017
        patient_support_angle = 805962018
        patient_support_rotation_direction = 805962019
        table_top_eccentric_axis_distance = 805962020
        table_top_eccentric_angle = 805962021
        table_top_eccentric_rotation_direction = 805962022
        table_top_vertical_position = 805962024
        table_top_longitudinal_position = 805962025
        table_top_lateral_position = 805962026
        isocenter_position = 805962028
        surface_entry_point = 805962030
        source_to_surface_distance = 805962032
        average_beam_dose_point_source_to_external_contour_distance = 805962033
        source_to_external_contour_distance = 805962034
        external_contour_entry_point = 805962035
        cumulative_meterset_weight = 805962036
        table_top_pitch_angle = 805962048
        table_top_pitch_rotation_direction = 805962050
        table_top_roll_angle = 805962052
        table_top_roll_rotation_direction = 805962054
        head_fixation_angle = 805962056
        gantry_pitch_angle = 805962058
        gantry_pitch_rotation_direction = 805962060
        gantry_pitch_angle_tolerance = 805962062
        fixation_eye = 805962064
        chair_head_frame_position = 805962065
        head_fixation_angle_tolerance = 805962066
        chair_head_frame_position_tolerance = 805962067
        fixation_light_azimuthal_angle_tolerance = 805962068
        fixation_light_polar_angle_tolerance = 805962069
        patient_setup_sequence = 805962112
        patient_setup_number = 805962114
        patient_setup_label = 805962115
        patient_additional_position = 805962116
        fixation_device_sequence = 805962128
        fixation_device_type = 805962130
        fixation_device_label = 805962132
        fixation_device_description = 805962134
        fixation_device_position = 805962136
        fixation_device_pitch_angle = 805962137
        fixation_device_roll_angle = 805962138
        shielding_device_sequence = 805962144
        shielding_device_type = 805962146
        shielding_device_label = 805962148
        shielding_device_description = 805962150
        shielding_device_position = 805962152
        setup_technique = 805962160
        setup_technique_description = 805962162
        setup_device_sequence = 805962164
        setup_device_type = 805962166
        setup_device_label = 805962168
        setup_device_description = 805962170
        setup_device_parameter = 805962172
        setup_reference_description = 805962192
        table_top_vertical_setup_displacement = 805962194
        table_top_longitudinal_setup_displacement = 805962196
        table_top_lateral_setup_displacement = 805962198
        brachy_treatment_technique = 805962240
        brachy_treatment_type = 805962242
        treatment_machine_sequence = 805962246
        source_sequence = 805962256
        source_number = 805962258
        source_type = 805962260
        source_manufacturer = 805962262
        active_source_diameter = 805962264
        active_source_length = 805962266
        source_model_id = 805962267
        source_description = 805962268
        source_encapsulation_nominal_thickness = 805962274
        source_encapsulation_nominal_transmission = 805962276
        source_isotope_name = 805962278
        source_isotope_half_life = 805962280
        source_strength_units = 805962281
        reference_air_kerma_rate = 805962282
        source_strength = 805962283
        source_strength_reference_date = 805962284
        source_strength_reference_time = 805962286
        application_setup_sequence = 805962288
        application_setup_type = 805962290
        application_setup_number = 805962292
        application_setup_name = 805962294
        application_setup_manufacturer = 805962296
        template_number = 805962304
        template_type = 805962306
        template_name = 805962308
        total_reference_air_kerma = 805962320
        brachy_accessory_device_sequence = 805962336
        brachy_accessory_device_number = 805962338
        brachy_accessory_device_id = 805962339
        brachy_accessory_device_type = 805962340
        brachy_accessory_device_name = 805962342
        brachy_accessory_device_nominal_thickness = 805962346
        brachy_accessory_device_nominal_transmission = 805962348
        channel_sequence = 805962368
        channel_number = 805962370
        channel_length = 805962372
        channel_total_time = 805962374
        source_movement_type = 805962376
        number_of_pulses = 805962378
        pulse_repetition_interval = 805962380
        source_applicator_number = 805962384
        source_applicator_id = 805962385
        source_applicator_type = 805962386
        source_applicator_name = 805962388
        source_applicator_length = 805962390
        source_applicator_manufacturer = 805962392
        source_applicator_wall_nominal_thickness = 805962396
        source_applicator_wall_nominal_transmission = 805962398
        source_applicator_step_size = 805962400
        transfer_tube_number = 805962402
        transfer_tube_length = 805962404
        channel_shield_sequence = 805962416
        channel_shield_number = 805962418
        channel_shield_id = 805962419
        channel_shield_name = 805962420
        channel_shield_nominal_thickness = 805962424
        channel_shield_nominal_transmission = 805962426
        final_cumulative_time_weight = 805962440
        brachy_control_point_sequence = 805962448
        control_point_relative_position = 805962450
        control_point_3d_position = 805962452
        cumulative_time_weight = 805962454
        compensator_divergence = 805962464
        compensator_mounting_position = 805962465
        source_to_compensator_distance = 805962466
        total_compensator_tray_water_equivalent_thickness = 805962467
        isocenter_to_compensator_tray_distance = 805962468
        compensator_column_offset = 805962469
        isocenter_to_compensator_distances = 805962470
        compensator_relative_stopping_power_ratio = 805962471
        compensator_milling_tool_diameter = 805962472
        ion_range_compensator_sequence = 805962474
        compensator_description = 805962475
        radiation_mass_number = 805962498
        radiation_atomic_number = 805962500
        radiation_charge_state = 805962502
        scan_mode = 805962504
        modulated_scan_mode_type = 805962505
        virtual_source_axis_distances = 805962506
        snout_sequence = 805962508
        snout_position = 805962509
        snout_id = 805962511
        number_of_range_shifters = 805962514
        range_shifter_sequence = 805962516
        range_shifter_number = 805962518
        range_shifter_id = 805962520
        range_shifter_type = 805962528
        range_shifter_description = 805962530
        number_of_lateral_spreading_devices = 805962544
        lateral_spreading_device_sequence = 805962546
        lateral_spreading_device_number = 805962548
        lateral_spreading_device_id = 805962550
        lateral_spreading_device_type = 805962552
        lateral_spreading_device_description = 805962554
        lateral_spreading_device_water_equivalent_thickness = 805962556
        number_of_range_modulators = 805962560
        range_modulator_sequence = 805962562
        range_modulator_number = 805962564
        range_modulator_id = 805962566
        range_modulator_type = 805962568
        range_modulator_description = 805962570
        beam_current_modulation_id = 805962572
        patient_support_type = 805962576
        patient_support_id = 805962578
        patient_support_accessory_code = 805962580
        tray_accessory_code = 805962581
        fixation_light_azimuthal_angle = 805962582
        fixation_light_polar_angle = 805962584
        meterset_rate = 805962586
        range_shifter_settings_sequence = 805962592
        range_shifter_setting = 805962594
        isocenter_to_range_shifter_distance = 805962596
        range_shifter_water_equivalent_thickness = 805962598
        lateral_spreading_device_settings_sequence = 805962608
        lateral_spreading_device_setting = 805962610
        isocenter_to_lateral_spreading_device_distance = 805962612
        range_modulator_settings_sequence = 805962624
        range_modulator_gating_start_value = 805962626
        range_modulator_gating_stop_value = 805962628
        range_modulator_gating_start_water_equivalent_thickness = 805962630
        range_modulator_gating_stop_water_equivalent_thickness = 805962632
        isocenter_to_range_modulator_distance = 805962634
        scan_spot_tune_id = 805962640
        scan_spot_prescribed_indices = 805962641
        number_of_scan_spot_positions = 805962642
        scan_spot_reordered = 805962643
        scan_spot_position_map = 805962644
        scan_spot_reordering_allowed = 805962645
        scan_spot_meterset_weights = 805962646
        scanning_spot_size = 805962648
        number_of_paintings = 805962650
        ion_tolerance_table_sequence = 805962656
        ion_beam_sequence = 805962658
        ion_beam_limiting_device_sequence = 805962660
        ion_block_sequence = 805962662
        ion_control_point_sequence = 805962664
        ion_wedge_sequence = 805962666
        ion_wedge_position_sequence = 805962668
        referenced_setup_image_sequence = 805962753
        setup_image_comment = 805962754
        motion_synchronization_sequence = 805962768
        control_point_orientation = 805962770
        general_accessory_sequence = 805962784
        general_accessory_id = 805962785
        general_accessory_description = 805962786
        general_accessory_type = 805962787
        general_accessory_number = 805962788
        source_to_general_accessory_distance = 805962789
        applicator_geometry_sequence = 805962801
        applicator_aperture_shape = 805962802
        applicator_opening = 805962803
        applicator_opening_x = 805962804
        applicator_opening_y = 805962805
        source_to_applicator_mounting_position_distance = 805962806
        number_of_block_slab_items = 805962816
        block_slab_sequence = 805962817
        block_slab_thickness = 805962818
        block_slab_number = 805962819
        device_motion_control_sequence = 805962832
        device_motion_execution_mode = 805962833
        device_motion_observation_mode = 805962834
        device_motion_parameter_code_sequence = 805962835
        distal_depth_fraction = 805963009
        distal_depth = 805963010
        nominal_range_modulation_fractions = 805963011
        nominal_range_modulated_region_depths = 805963012
        depth_dose_parameters_sequence = 805963013
        delivered_depth_dose_parameters_sequence = 805963014
        delivered_distal_depth_fraction = 805963015
        delivered_distal_depth = 805963016
        delivered_nominal_range_modulation_fractions = 805963017
        delivered_nominal_range_modulated_region_depths = 805963024
        delivered_reference_dose_definition = 805963025
        reference_dose_definition = 805963026
        referenced_rt_plan_sequence = 806092802
        referenced_beam_sequence = 806092804
        referenced_beam_number = 806092806
        referenced_reference_image_number = 806092807
        start_cumulative_meterset_weight = 806092808
        end_cumulative_meterset_weight = 806092809
        referenced_brachy_application_setup_sequence = 806092810
        referenced_brachy_application_setup_number = 806092812
        referenced_source_number = 806092814
        referenced_fraction_group_sequence = 806092832
        referenced_fraction_group_number = 806092834
        referenced_verification_image_sequence = 806092864
        referenced_reference_image_sequence = 806092866
        referenced_dose_reference_sequence = 806092880
        referenced_dose_reference_number = 806092881
        brachy_referenced_dose_reference_sequence = 806092885
        referenced_structure_set_sequence = 806092896
        referenced_patient_setup_number = 806092906
        referenced_dose_sequence = 806092928
        referenced_tolerance_table_number = 806092960
        referenced_bolus_sequence = 806092976
        referenced_wedge_number = 806092992
        referenced_compensator_number = 806093008
        referenced_block_number = 806093024
        referenced_control_point_index = 806093040
        referenced_control_point_sequence = 806093042
        referenced_start_control_point_index = 806093044
        referenced_stop_control_point_index = 806093046
        referenced_range_shifter_number = 806093056
        referenced_lateral_spreading_device_number = 806093058
        referenced_range_modulator_number = 806093060
        omitted_beam_task_sequence = 806093073
        reason_for_omission = 806093074
        reason_for_omission_description = 806093075
        approval_status = 806223874
        review_date = 806223876
        review_time = 806223877
        reviewer_name = 806223880
        arbitrary = 1073741840
        text_comments = 1073758208
        results_id = 1074266176
        results_id_issuer = 1074266178
        referenced_interpretation_sequence = 1074266192
        report_production_status__trial_ = 1074266367
        interpretation_recorded_date = 1074266368
        interpretation_recorded_time = 1074266369
        interpretation_recorder = 1074266370
        reference_to_recorded_sound = 1074266371
        interpretation_transcription_date = 1074266376
        interpretation_transcription_time = 1074266377
        interpretation_transcriber = 1074266378
        interpretation_text = 1074266379
        interpretation_author = 1074266380
        interpretation_approver_sequence = 1074266385
        interpretation_approval_date = 1074266386
        interpretation_approval_time = 1074266387
        physician_approving_interpretation = 1074266388
        interpretation_diagnosis_description = 1074266389
        interpretation_diagnosis_code_sequence = 1074266391
        results_distribution_list_sequence = 1074266392
        distribution_name = 1074266393
        distribution_address = 1074266394
        interpretation_id = 1074266624
        interpretation_id_issuer = 1074266626
        interpretation_type_id = 1074266640
        interpretation_status_id = 1074266642
        impressions = 1074266880
        results_comments = 1074282496
        low_energy_detectors = 1074790401
        high_energy_detectors = 1074790402
        detector_geometry_sequence = 1074790404
        threat_roi_voxel_sequence = 1074794497
        threat_roi_base = 1074794500
        threat_roi_extents = 1074794501
        threat_roi_bitmap = 1074794502
        route_segment_id = 1074794503
        gantry_type = 1074794504
        ooi_owner_type = 1074794505
        route_segment_sequence = 1074794506
        potential_threat_object_id = 1074794512
        threat_sequence = 1074794513
        threat_category = 1074794514
        threat_category_description = 1074794515
        atd_ability_assessment = 1074794516
        atd_assessment_flag = 1074794517
        atd_assessment_probability = 1074794518
        mass = 1074794519
        density = 1074794520
        z_effective = 1074794521
        boarding_pass_id = 1074794522
        center_of_mass = 1074794523
        center_of_pto = 1074794524
        bounding_polygon = 1074794525
        route_segment_start_location_id = 1074794526
        route_segment_end_location_id = 1074794527
        route_segment_location_id_type = 1074794528
        abort_reason = 1074794529
        volume_of_pto = 1074794531
        abort_flag = 1074794532
        route_segment_start_time = 1074794533
        route_segment_end_time = 1074794534
        tdr_type = 1074794535
        international_route_segment = 1074794536
        threat_detection_algorithm_and_version = 1074794537
        assigned_location = 1074794538
        alarm_decision_time = 1074794539
        alarm_decision = 1074794545
        number_of_total_objects = 1074794547
        number_of_alarm_objects = 1074794548
        pto_representation_sequence = 1074794551
        atd_assessment_sequence = 1074794552
        tip_type = 1074794553
        version = 1074794554
        ooi_owner_creation_time = 1074794561
        ooi_type = 1074794562
        ooi_size = 1074794563
        acquisition_status = 1074794564
        basis_materials_code_sequence = 1074794565
        phantom_type = 1074794566
        ooi_owner_sequence = 1074794567
        scan_type = 1074794568
        itinerary_id = 1074794577
        itinerary_id_type = 1074794578
        itinerary_id_assigning_authority = 1074794579
        route_id = 1074794580
        route_id_assigning_authority = 1074794581
        inbound_arrival_type = 1074794582
        carrier_id = 1074794584
        carrier_id_assigning_authority = 1074794585
        source_orientation = 1074794592
        source_position = 1074794593
        belt_height = 1074794594
        algorithm_routing_code_sequence = 1074794596
        transport_classification = 1074794599
        ooi_type_descriptor = 1074794600
        total_processing_time = 1074794601
        detector_calibration_data = 1074794604
        additional_screening_performed = 1074794605
        additional_inspection_selection_criteria = 1074794606
        additional_inspection_method_sequence = 1074794607
        ait_device_type = 1074794608
        qr_measurements_sequence = 1074794609
        target_material_sequence = 1074794610
        snr_threshold = 1074794611
        image_scale_representation = 1074794613
        referenced_pto_sequence = 1074794614
        referenced_tdr_instance_sequence = 1074794615
        pto_location_description = 1074794616
        anomaly_locator_indicator_sequence = 1074794617
        anomaly_locator_indicator = 1074794618
        pto_region_sequence = 1074794619
        inspection_selection_criteria = 1074794620
        secondary_inspection_method_sequence = 1074794621
        prcs_to_rcs_orientation = 1074794622
        mac_parameters_sequence = 1342046209
        shared_functional_groups_sequence = 1375769129
        per_frame_functional_groups_sequence = 1375769136
        waveform_sequence = 1409286400
        channel_minimum_value = 1409286416
        channel_maximum_value = 1409286418
        waveform_bits_allocated = 1409290244
        waveform_sample_interpretation = 1409290246
        waveform_padding_value = 1409290250
        waveform_data = 1409290256
        first_order_phase_correction_angle = 1442840592
        spectroscopy_data = 1442840608
        float_pixel_data = 2145386504
        double_float_pixel_data = 2145386505
        pixel_data = 2145386512
        coefficients_sdvn = 2145386528
        coefficients_sdhn = 2145386544
        coefficients_sddn = 2145386560
        digital_signatures_sequence = 4294639610
        data_set_trailing_padding = 4294770684
        item = 4294893568
        item_delimitation_item = 4294893581
        sequence_delimitation_item = 4294893789
    SEQ_FIELDS = ["file_header", "elements"]
    def __init__(self, _io, _parent=None, _root=None):
        self._io = _io
        self._parent = _parent
        self._root = _root if _root else self
        self._debug = collections.defaultdict(dict)

    def _read(self):
        self._debug['file_header']['start'] = self._io.pos()
        self.file_header = Dicom.TFileHeader(self._io, self, self._root)
        self.file_header._read()
        self._debug['file_header']['end'] = self._io.pos()
        self._debug['elements']['start'] = self._io.pos()
        self.elements = []
        i = 0
        while not self._io.is_eof():
            if not 'arr' in self._debug['elements']:
                self._debug['elements']['arr'] = []
            self._debug['elements']['arr'].append({'start': self._io.pos()})
            _t_elements = Dicom.TDataElementImplicit(self._io, self, self._root)
            _t_elements._read()
            self.elements.append(_t_elements)
            self._debug['elements']['arr'][len(self.elements) - 1]['end'] = self._io.pos()
            i += 1

        self._debug['elements']['end'] = self._io.pos()

    class TFileHeader(KaitaiStruct):
        SEQ_FIELDS = ["preamble", "magic"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['preamble']['start'] = self._io.pos()
            self.preamble = self._io.read_bytes(128)
            self._debug['preamble']['end'] = self._io.pos()
            self._debug['magic']['start'] = self._io.pos()
            self.magic = self._io.read_bytes(4)
            self._debug['magic']['end'] = self._io.pos()
            if not self.magic == b"\x44\x49\x43\x4D":
                raise kaitaistruct.ValidationNotEqualError(b"\x44\x49\x43\x4D", self.magic, self._io, u"/types/t_file_header/seq/1")


    class TDataElementExplicit(KaitaiStruct):
        """
        .. seealso::
           Source - https://dicom.nema.org/medical/dicom/current/output/html/part05.html#sect_7.1.2
        """
        SEQ_FIELDS = ["tag_group", "tag_elem", "vr", "reserved", "value_len", "value", "items", "elements_implicit"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['tag_group']['start'] = self._io.pos()
            self.tag_group = self._io.read_u2le()
            self._debug['tag_group']['end'] = self._io.pos()
            self._debug['tag_elem']['start'] = self._io.pos()
            self.tag_elem = self._io.read_u2le()
            self._debug['tag_elem']['end'] = self._io.pos()
            if not (self.is_forced_implicit):
                self._debug['vr']['start'] = self._io.pos()
                self.vr = (self._io.read_bytes(2)).decode(u"ASCII")
                self._debug['vr']['end'] = self._io.pos()

            if  ((self.is_long_len) and (not (self.is_forced_implicit))) :
                self._debug['reserved']['start'] = self._io.pos()
                self.reserved = self._io.read_u2le()
                self._debug['reserved']['end'] = self._io.pos()

            self._debug['value_len']['start'] = self._io.pos()
            _on = self.is_long_len
            if _on == False:
                self.value_len = self._io.read_u2le()
            elif _on == True:
                self.value_len = self._io.read_u4le()
            self._debug['value_len']['end'] = self._io.pos()
            if self.value_len != 4294967295:
                self._debug['value']['start'] = self._io.pos()
                self.value = self._io.read_bytes(self.value_len)
                self._debug['value']['end'] = self._io.pos()

            if  ((self.vr == u"SQ") and (self.value_len == 4294967295)) :
                self._debug['items']['start'] = self._io.pos()
                self.items = []
                i = 0
                while True:
                    if not 'arr' in self._debug['items']:
                        self._debug['items']['arr'] = []
                    self._debug['items']['arr'].append({'start': self._io.pos()})
                    _t_items = Dicom.SeqItem(self._io, self, self._root)
                    _t_items._read()
                    _ = _t_items
                    self.items.append(_)
                    self._debug['items']['arr'][len(self.items) - 1]['end'] = self._io.pos()
                    if _.tag_elem == 57565:
                        break
                    i += 1
                self._debug['items']['end'] = self._io.pos()

            if self.is_transfer_syntax_change_implicit:
                self._debug['elements_implicit']['start'] = self._io.pos()
                self.elements_implicit = []
                i = 0
                while not self._io.is_eof():
                    if not 'arr' in self._debug['elements_implicit']:
                        self._debug['elements_implicit']['arr'] = []
                    self._debug['elements_implicit']['arr'].append({'start': self._io.pos()})
                    _t_elements_implicit = Dicom.TDataElementImplicit(self._io, self, self._root)
                    _t_elements_implicit._read()
                    self.elements_implicit.append(_t_elements_implicit)
                    self._debug['elements_implicit']['arr'][len(self.elements_implicit) - 1]['end'] = self._io.pos()
                    i += 1

                self._debug['elements_implicit']['end'] = self._io.pos()


        @property
        def is_forced_implicit(self):
            if hasattr(self, '_m_is_forced_implicit'):
                return self._m_is_forced_implicit

            self._m_is_forced_implicit = self.tag_group == 65534
            return getattr(self, '_m_is_forced_implicit', None)

        @property
        def is_long_len(self):
            if hasattr(self, '_m_is_long_len'):
                return self._m_is_long_len

            self._m_is_long_len =  ((self.is_forced_implicit) or (self.vr == u"OB") or (self.vr == u"OD") or (self.vr == u"OF") or (self.vr == u"OL") or (self.vr == u"OW") or (self.vr == u"SQ") or (self.vr == u"UC") or (self.vr == u"UR") or (self.vr == u"UT") or (self.vr == u"UN")) 
            return getattr(self, '_m_is_long_len', None)

        @property
        def is_transfer_syntax_change_implicit(self):
            if hasattr(self, '_m_is_transfer_syntax_change_implicit'):
                return self._m_is_transfer_syntax_change_implicit

            self._m_is_transfer_syntax_change_implicit = False
            return getattr(self, '_m_is_transfer_syntax_change_implicit', None)

        @property
        def tag(self):
            if hasattr(self, '_m_tag'):
                return self._m_tag

            self._m_tag = KaitaiStream.resolve_enum(Dicom.Tags, ((self.tag_group << 16) | self.tag_elem))
            return getattr(self, '_m_tag', None)


    class TDataElementImplicit(KaitaiStruct):
        """
        .. seealso::
           Source - https://dicom.nema.org/medical/dicom/current/output/html/part05.html#sect_7.1.2
        """
        SEQ_FIELDS = ["tag_group", "tag_elem", "vr", "reserved", "value_len", "value", "items", "elements"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['tag_group']['start'] = self._io.pos()
            self.tag_group = self._io.read_u2le()
            self._debug['tag_group']['end'] = self._io.pos()
            self._debug['tag_elem']['start'] = self._io.pos()
            self.tag_elem = self._io.read_u2le()
            self._debug['tag_elem']['end'] = self._io.pos()
            if self.is_forced_explicit:
                self._debug['vr']['start'] = self._io.pos()
                self.vr = (self._io.read_bytes(2)).decode(u"ASCII")
                self._debug['vr']['end'] = self._io.pos()

            if  ((self.is_long_len) and (self.is_forced_explicit)) :
                self._debug['reserved']['start'] = self._io.pos()
                self.reserved = self._io.read_u2le()
                self._debug['reserved']['end'] = self._io.pos()

            self._debug['value_len']['start'] = self._io.pos()
            _on = (self.is_long_len if self.is_forced_explicit else True)
            if _on == False:
                self.value_len = self._io.read_u2le()
            elif _on == True:
                self.value_len = self._io.read_u4le()
            self._debug['value_len']['end'] = self._io.pos()
            if self.value_len != 4294967295:
                self._debug['value']['start'] = self._io.pos()
                self.value = self._io.read_bytes(self.value_len)
                self._debug['value']['end'] = self._io.pos()

            if  ((self.vr == u"SQ") and (self.value_len == 4294967295)) :
                self._debug['items']['start'] = self._io.pos()
                self.items = []
                i = 0
                while True:
                    if not 'arr' in self._debug['items']:
                        self._debug['items']['arr'] = []
                    self._debug['items']['arr'].append({'start': self._io.pos()})
                    _t_items = Dicom.SeqItem(self._io, self, self._root)
                    _t_items._read()
                    _ = _t_items
                    self.items.append(_)
                    self._debug['items']['arr'][len(self.items) - 1]['end'] = self._io.pos()
                    if _.tag_elem == 57565:
                        break
                    i += 1
                self._debug['items']['end'] = self._io.pos()

            if self.is_transfer_syntax_change_explicit:
                self._debug['elements']['start'] = self._io.pos()
                self.elements = []
                i = 0
                while not self._io.is_eof():
                    if not 'arr' in self._debug['elements']:
                        self._debug['elements']['arr'] = []
                    self._debug['elements']['arr'].append({'start': self._io.pos()})
                    _t_elements = Dicom.TDataElementExplicit(self._io, self, self._root)
                    _t_elements._read()
                    self.elements.append(_t_elements)
                    self._debug['elements']['arr'][len(self.elements) - 1]['end'] = self._io.pos()
                    i += 1

                self._debug['elements']['end'] = self._io.pos()


        @property
        def tag(self):
            if hasattr(self, '_m_tag'):
                return self._m_tag

            self._m_tag = KaitaiStream.resolve_enum(Dicom.Tags, ((self.tag_group << 16) | self.tag_elem))
            return getattr(self, '_m_tag', None)

        @property
        def is_transfer_syntax_change_explicit(self):
            if hasattr(self, '_m_is_transfer_syntax_change_explicit'):
                return self._m_is_transfer_syntax_change_explicit

            self._m_is_transfer_syntax_change_explicit = self.p_is_transfer_syntax_change_explicit
            return getattr(self, '_m_is_transfer_syntax_change_explicit', None)

        @property
        def is_long_len(self):
            if hasattr(self, '_m_is_long_len'):
                return self._m_is_long_len

            self._m_is_long_len =  ((self.is_forced_explicit) and ( ((self.vr == u"OB") or (self.vr == u"OD") or (self.vr == u"OF") or (self.vr == u"OL") or (self.vr == u"OW") or (self.vr == u"SQ") or (self.vr == u"UC") or (self.vr == u"UR") or (self.vr == u"UT") or (self.vr == u"UN")) )) 
            return getattr(self, '_m_is_long_len', None)

        @property
        def p_is_transfer_syntax_change_explicit(self):
            if hasattr(self, '_m_p_is_transfer_syntax_change_explicit'):
                return self._m_p_is_transfer_syntax_change_explicit

            self._m_p_is_transfer_syntax_change_explicit = self.value == b"\x31\x2E\x32\x2E\x38\x34\x30\x2E\x31\x30\x30\x30\x38\x2E\x31\x2E\x32\x2E\x31\x00"
            return getattr(self, '_m_p_is_transfer_syntax_change_explicit', None)

        @property
        def is_forced_explicit(self):
            if hasattr(self, '_m_is_forced_explicit'):
                return self._m_is_forced_explicit

            self._m_is_forced_explicit = self.tag_group == 2
            return getattr(self, '_m_is_forced_explicit', None)


    class SeqItem(KaitaiStruct):
        SEQ_FIELDS = ["tag_group", "tag_elem", "value_len", "value", "items"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['tag_group']['start'] = self._io.pos()
            self.tag_group = self._io.read_bytes(2)
            self._debug['tag_group']['end'] = self._io.pos()
            if not self.tag_group == b"\xFE\xFF":
                raise kaitaistruct.ValidationNotEqualError(b"\xFE\xFF", self.tag_group, self._io, u"/types/seq_item/seq/0")
            self._debug['tag_elem']['start'] = self._io.pos()
            self.tag_elem = self._io.read_u2le()
            self._debug['tag_elem']['end'] = self._io.pos()
            self._debug['value_len']['start'] = self._io.pos()
            self.value_len = self._io.read_u4le()
            self._debug['value_len']['end'] = self._io.pos()
            if self.value_len != 4294967295:
                self._debug['value']['start'] = self._io.pos()
                self.value = self._io.read_bytes(self.value_len)
                self._debug['value']['end'] = self._io.pos()

            if self.value_len == 4294967295:
                self._debug['items']['start'] = self._io.pos()
                self.items = []
                i = 0
                while True:
                    if not 'arr' in self._debug['items']:
                        self._debug['items']['arr'] = []
                    self._debug['items']['arr'].append({'start': self._io.pos()})
                    _t_items = Dicom.TDataElementExplicit(self._io, self, self._root)
                    _t_items._read()
                    _ = _t_items
                    self.items.append(_)
                    self._debug['items']['arr'][len(self.items) - 1]['end'] = self._io.pos()
                    if  ((_.tag_group == 65534) and (_.tag_elem == 57357)) :
                        break
                    i += 1
                self._debug['items']['end'] = self._io.pos()




