#                                  Apache License
#                            Version 2.0, January 2004
#                         https://www.apache.org/licenses/
#
#    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
#
#    1. Definitions.
#
#       "License" shall mean the terms and conditions for use, reproduction,
#       and distribution as defined by Sections 1 through 9 of this document.
#
#       "Licensor" shall mean the copyright owner or entity authorized by
#       the copyright owner that is granting the License.
#
#       "Legal Entity" shall mean the union of the acting entity and all
#       other entities that control, are controlled by, or are under common
#       control with that entity. For the purposes of this definition,
#       "control" means (i) the power, direct or indirect, to cause the
#       direction or management of such entity, whether by contract or
#       otherwise, or (ii) ownership of fifty percent (50%) or more of the
#       outstanding shares, or (iii) beneficial ownership of such entity.
#
#       "You" (or "Your") shall mean an individual or Legal Entity
#       exercising permissions granted by this License.
#
#       "Source" form shall mean the preferred form for making modifications,
#       including but not limited to software source code, documentation
#       source, and configuration files.
#
#       "Object" form shall mean any form resulting from mechanical
#       transformation or translation of a Source form, including but
#       not limited to compiled object code, generated documentation,
#       and conversions to other media types.
#
#       "Work" shall mean the work of authorship, whether in Source or
#       Object form, made available under the License, as indicated by a
#       copyright notice that is included in or attached to the work
#       (an example is provided in the Appendix below).
#
#       "Derivative Works" shall mean any work, whether in Source or Object
#       form, that is based on (or derived from) the Work and for which the
#       editorial revisions, annotations, elaborations, or other modifications
#       represent, as a whole, an original work of authorship. For the purposes
#       of this License, Derivative Works shall not include works that remain
#       separable from, or merely link (or bind by name) to the interfaces of,
#       the Work and Derivative Works thereof.
#
#       "Contribution" shall mean any work of authorship, including
#       the original version of the Work and any modifications or additions
#       to that Work or Derivative Works thereof, that is intentionally
#       submitted to Licensor for inclusion in the Work by the copyright owner
#       or by an individual or Legal Entity authorized to submit on behalf of
#       the copyright owner. For the purposes of this definition, "submitted"
#       means any form of electronic, verbal, or written communication sent
#       to the Licensor or its representatives, including but not limited to
#       communication on electronic mailing lists, source code control systems,
#       and issue tracking systems that are managed by, or on behalf of, the
#       Licensor for the purpose of discussing and improving the Work, but
#       excluding communication that is conspicuously marked or otherwise
#       designated in writing by the copyright owner as "Not a Contribution."
#
#       "Contributor" shall mean Licensor and any individual or Legal Entity
#       on behalf of whom a Contribution has been received by Licensor and
#       subsequently incorporated within the Work.
#
#    2. Grant of Copyright License. Subject to the terms and conditions of
#       this License, each Contributor hereby grants to You a perpetual,
#       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
#       copyright license to reproduce, prepare Derivative Works of,
#       publicly display, publicly perform, sublicense, and distribute the
#       Work and such Derivative Works in Source or Object form.
#
#    3. Grant of Patent License. Subject to the terms and conditions of
#       this License, each Contributor hereby grants to You a perpetual,
#       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
#       (except as stated in this section) patent license to make, have made,
#       use, offer to sell, sell, import, and otherwise transfer the Work,
#       where such license applies only to those patent claims licensable
#       by such Contributor that are necessarily infringed by their
#       Contribution(s) alone or by combination of their Contribution(s)
#       with the Work to which such Contribution(s) was submitted. If You
#       institute patent litigation against any entity (including a
#       cross-claim or counterclaim in a lawsuit) alleging that the Work
#       or a Contribution incorporated within the Work constitutes direct
#       or contributory patent infringement, then any patent licenses
#       granted to You under this License for that Work shall terminate
#       as of the date such litigation is filed.
#
#    4. Redistribution. You may reproduce and distribute copies of the
#       Work or Derivative Works thereof in any medium, with or without
#       modifications, and in Source or Object form, provided that You
#       meet the following conditions:
#
#       (a) You must give any other recipients of the Work or
#           Derivative Works a copy of this License; and
#
#       (b) You must cause any modified files to carry prominent notices
#           stating that You changed the files; and
#
#       (c) You must retain, in the Source form of any Derivative Works
#           that You distribute, all copyright, patent, trademark, and
#           attribution notices from the Source form of the Work,
#           excluding those notices that do not pertain to any part of
#           the Derivative Works; and
#
#       (d) If the Work includes a "NOTICE" text file as part of its
#           distribution, then any Derivative Works that You distribute must
#           include a readable copy of the attribution notices contained
#           within such NOTICE file, excluding those notices that do not
#           pertain to any part of the Derivative Works, in at least one
#           of the following places: within a NOTICE text file distributed
#           as part of the Derivative Works; within the Source form or
#           documentation, if provided along with the Derivative Works; or,
#           within a display generated by the Derivative Works, if and
#           wherever such third-party notices normally appear. The contents
#           of the NOTICE file are for informational purposes only and
#           do not modify the License. You may add Your own attribution
#           notices within Derivative Works that You distribute, alongside
#           or as an addendum to the NOTICE text from the Work, provided
#           that such additional attribution notices cannot be construed
#           as modifying the License.
#
#       You may add Your own copyright statement to Your modifications and
#       may provide additional or different license terms and conditions
#       for use, reproduction, or distribution of Your modifications, or
#       for any such Derivative Works as a whole, provided Your use,
#       reproduction, and distribution of the Work otherwise complies with
#       the conditions stated in this License.
#
#    5. Submission of Contributions. Unless You explicitly state otherwise,
#       any Contribution intentionally submitted for inclusion in the Work
#       by You to the Licensor shall be under the terms and conditions of
#       this License, without any additional terms or conditions.
#       Notwithstanding the above, nothing herein shall supersede or modify
#       the terms of any separate license agreement you may have executed
#       with Licensor regarding such Contributions.
#
#    6. Trademarks. This License does not grant permission to use the trade
#       names, trademarks, service marks, or product names of the Licensor,
#       except as required for reasonable and customary use in describing the
#       origin of the Work and reproducing the content of the NOTICE file.
#
#    7. Disclaimer of Warranty. Unless required by applicable law or
#       agreed to in writing, Licensor provides the Work (and each
#       Contributor provides its Contributions) on an "AS IS" BASIS,
#       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
#       implied, including, without limitation, any warranties or conditions
#       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
#       PARTICULAR PURPOSE. You are solely responsible for determining the
#       appropriateness of using or redistributing the Work and assume any
#       risks associated with Your exercise of permissions under this License.
#
#    8. Limitation of Liability. In no event and under no legal theory,
#       whether in tort (including negligence), contract, or otherwise,
#       unless required by applicable law (such as deliberate and grossly
#       negligent acts) or agreed to in writing, shall any Contributor be
#       liable to You for damages, including any direct, indirect, special,
#       incidental, or consequential damages of any character arising as a
#       result of this License or out of the use or inability to use the
#       Work (including but not limited to damages for loss of goodwill,
#       work stoppage, computer failure or malfunction, or any and all
#       other commercial damages or losses), even if such Contributor
#       has been advised of the possibility of such damages.
#
#    9. Accepting Warranty or Additional Liability. While redistributing
#       the Work or Derivative Works thereof, You may choose to offer,
#       and charge a fee for, acceptance of support, warranty, indemnity,
#       or other liability obligations and/or rights consistent with this
#       License. However, in accepting such obligations, You may act only
#       on Your own behalf and on Your sole responsibility, not on behalf
#       of any other Contributor, and only if You agree to indemnify,
#       defend, and hold each Contributor harmless for any liability
#       incurred by, or claims asserted against, such Contributor by reason
#       of your accepting any such warranty or additional liability.
#
#    END OF TERMS AND CONDITIONS
#
#    Copyright 2013-2018 Docker, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        https://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

# This file was compiled from a KSY format file downloaded from:
# https://github.com/kaitai-io/kaitai_struct_formats


# This is a generated file! Please edit source .ksy file and use kaitai-struct-compiler to rebuild

import kaitaistruct
from kaitaistruct import KaitaiStruct, KaitaiStream, BytesIO
from enum import Enum
import collections


if getattr(kaitaistruct, 'API_VERSION', (0, 9)) < (0, 9):
    raise Exception("Incompatible Kaitai Struct Python API: 0.9 or later is required, but you have %s" % (kaitaistruct.__version__))

class Mcap(KaitaiStruct):
    """MCAP is a modular container format and logging library for pub/sub messages with
    arbitrary message serialization. It is primarily intended for use in robotics
    applications, and works well under various workloads, resource constraints, and
    durability requirements.
    
    Time values (`log_time`, `publish_time`, `create_time`) are represented in
    nanoseconds since a user-understood epoch (i.e. Unix epoch, robot boot time,
    etc.)
    
    .. seealso::
       Source - https://github.com/foxglove/mcap/tree/c1cc51d/docs/specification#readme
    """

    class Opcode(Enum):
        header = 1
        footer = 2
        schema = 3
        channel = 4
        message = 5
        chunk = 6
        message_index = 7
        chunk_index = 8
        attachment = 9
        attachment_index = 10
        statistics = 11
        metadata = 12
        metadata_index = 13
        summary_offset = 14
        data_end = 15
    SEQ_FIELDS = ["header_magic", "records", "footer_magic"]
    def __init__(self, _io, _parent=None, _root=None):
        self._io = _io
        self._parent = _parent
        self._root = _root if _root else self
        self._debug = collections.defaultdict(dict)

    def _read(self):
        self._debug['header_magic']['start'] = self._io.pos()
        self.header_magic = Mcap.Magic(self._io, self, self._root)
        self.header_magic._read()
        self._debug['header_magic']['end'] = self._io.pos()
        self._debug['records']['start'] = self._io.pos()
        self.records = []
        i = 0
        while True:
            if not 'arr' in self._debug['records']:
                self._debug['records']['arr'] = []
            self._debug['records']['arr'].append({'start': self._io.pos()})
            _t_records = Mcap.Record(self._io, self, self._root)
            _t_records._read()
            _ = _t_records
            self.records.append(_)
            self._debug['records']['arr'][len(self.records) - 1]['end'] = self._io.pos()
            if _.op == Mcap.Opcode.footer:
                break
            i += 1
        self._debug['records']['end'] = self._io.pos()
        self._debug['footer_magic']['start'] = self._io.pos()
        self.footer_magic = Mcap.Magic(self._io, self, self._root)
        self.footer_magic._read()
        self._debug['footer_magic']['end'] = self._io.pos()

    class PrefixedStr(KaitaiStruct):
        SEQ_FIELDS = ["len_str", "str"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['len_str']['start'] = self._io.pos()
            self.len_str = self._io.read_u4le()
            self._debug['len_str']['end'] = self._io.pos()
            self._debug['str']['start'] = self._io.pos()
            self.str = (self._io.read_bytes(self.len_str)).decode(u"UTF-8")
            self._debug['str']['end'] = self._io.pos()


    class Chunk(KaitaiStruct):
        SEQ_FIELDS = ["message_start_time", "message_end_time", "uncompressed_size", "uncompressed_crc32", "compression", "len_records", "records"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['message_start_time']['start'] = self._io.pos()
            self.message_start_time = self._io.read_u8le()
            self._debug['message_start_time']['end'] = self._io.pos()
            self._debug['message_end_time']['start'] = self._io.pos()
            self.message_end_time = self._io.read_u8le()
            self._debug['message_end_time']['end'] = self._io.pos()
            self._debug['uncompressed_size']['start'] = self._io.pos()
            self.uncompressed_size = self._io.read_u8le()
            self._debug['uncompressed_size']['end'] = self._io.pos()
            self._debug['uncompressed_crc32']['start'] = self._io.pos()
            self.uncompressed_crc32 = self._io.read_u4le()
            self._debug['uncompressed_crc32']['end'] = self._io.pos()
            self._debug['compression']['start'] = self._io.pos()
            self.compression = Mcap.PrefixedStr(self._io, self, self._root)
            self.compression._read()
            self._debug['compression']['end'] = self._io.pos()
            self._debug['len_records']['start'] = self._io.pos()
            self.len_records = self._io.read_u8le()
            self._debug['len_records']['end'] = self._io.pos()
            self._debug['records']['start'] = self._io.pos()
            _on = self.compression.str
            if _on == u"":
                self._raw_records = self._io.read_bytes(self.len_records)
                _io__raw_records = KaitaiStream(BytesIO(self._raw_records))
                self.records = Mcap.Records(_io__raw_records, self, self._root)
                self.records._read()
            else:
                self.records = self._io.read_bytes(self.len_records)
            self._debug['records']['end'] = self._io.pos()


    class DataEnd(KaitaiStruct):
        SEQ_FIELDS = ["data_section_crc32"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['data_section_crc32']['start'] = self._io.pos()
            self.data_section_crc32 = self._io.read_u4le()
            self._debug['data_section_crc32']['end'] = self._io.pos()


    class Channel(KaitaiStruct):
        SEQ_FIELDS = ["id", "schema_id", "topic", "message_encoding", "metadata"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['id']['start'] = self._io.pos()
            self.id = self._io.read_u2le()
            self._debug['id']['end'] = self._io.pos()
            self._debug['schema_id']['start'] = self._io.pos()
            self.schema_id = self._io.read_u2le()
            self._debug['schema_id']['end'] = self._io.pos()
            self._debug['topic']['start'] = self._io.pos()
            self.topic = Mcap.PrefixedStr(self._io, self, self._root)
            self.topic._read()
            self._debug['topic']['end'] = self._io.pos()
            self._debug['message_encoding']['start'] = self._io.pos()
            self.message_encoding = Mcap.PrefixedStr(self._io, self, self._root)
            self.message_encoding._read()
            self._debug['message_encoding']['end'] = self._io.pos()
            self._debug['metadata']['start'] = self._io.pos()
            self.metadata = Mcap.MapStrStr(self._io, self, self._root)
            self.metadata._read()
            self._debug['metadata']['end'] = self._io.pos()


    class MessageIndex(KaitaiStruct):
        SEQ_FIELDS = ["channel_id", "len_records", "records"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['channel_id']['start'] = self._io.pos()
            self.channel_id = self._io.read_u2le()
            self._debug['channel_id']['end'] = self._io.pos()
            self._debug['len_records']['start'] = self._io.pos()
            self.len_records = self._io.read_u4le()
            self._debug['len_records']['end'] = self._io.pos()
            self._debug['records']['start'] = self._io.pos()
            self._raw_records = self._io.read_bytes(self.len_records)
            _io__raw_records = KaitaiStream(BytesIO(self._raw_records))
            self.records = Mcap.MessageIndex.MessageIndexEntries(_io__raw_records, self, self._root)
            self.records._read()
            self._debug['records']['end'] = self._io.pos()

        class MessageIndexEntry(KaitaiStruct):
            SEQ_FIELDS = ["log_time", "offset"]
            def __init__(self, _io, _parent=None, _root=None):
                self._io = _io
                self._parent = _parent
                self._root = _root if _root else self
                self._debug = collections.defaultdict(dict)

            def _read(self):
                self._debug['log_time']['start'] = self._io.pos()
                self.log_time = self._io.read_u8le()
                self._debug['log_time']['end'] = self._io.pos()
                self._debug['offset']['start'] = self._io.pos()
                self.offset = self._io.read_u8le()
                self._debug['offset']['end'] = self._io.pos()


        class MessageIndexEntries(KaitaiStruct):
            SEQ_FIELDS = ["entries"]
            def __init__(self, _io, _parent=None, _root=None):
                self._io = _io
                self._parent = _parent
                self._root = _root if _root else self
                self._debug = collections.defaultdict(dict)

            def _read(self):
                self._debug['entries']['start'] = self._io.pos()
                self.entries = []
                i = 0
                while not self._io.is_eof():
                    if not 'arr' in self._debug['entries']:
                        self._debug['entries']['arr'] = []
                    self._debug['entries']['arr'].append({'start': self._io.pos()})
                    _t_entries = Mcap.MessageIndex.MessageIndexEntry(self._io, self, self._root)
                    _t_entries._read()
                    self.entries.append(_t_entries)
                    self._debug['entries']['arr'][len(self.entries) - 1]['end'] = self._io.pos()
                    i += 1

                self._debug['entries']['end'] = self._io.pos()



    class Statistics(KaitaiStruct):
        SEQ_FIELDS = ["message_count", "schema_count", "channel_count", "attachment_count", "metadata_count", "chunk_count", "message_start_time", "message_end_time", "len_channel_message_counts", "channel_message_counts"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['message_count']['start'] = self._io.pos()
            self.message_count = self._io.read_u8le()
            self._debug['message_count']['end'] = self._io.pos()
            self._debug['schema_count']['start'] = self._io.pos()
            self.schema_count = self._io.read_u2le()
            self._debug['schema_count']['end'] = self._io.pos()
            self._debug['channel_count']['start'] = self._io.pos()
            self.channel_count = self._io.read_u4le()
            self._debug['channel_count']['end'] = self._io.pos()
            self._debug['attachment_count']['start'] = self._io.pos()
            self.attachment_count = self._io.read_u4le()
            self._debug['attachment_count']['end'] = self._io.pos()
            self._debug['metadata_count']['start'] = self._io.pos()
            self.metadata_count = self._io.read_u4le()
            self._debug['metadata_count']['end'] = self._io.pos()
            self._debug['chunk_count']['start'] = self._io.pos()
            self.chunk_count = self._io.read_u4le()
            self._debug['chunk_count']['end'] = self._io.pos()
            self._debug['message_start_time']['start'] = self._io.pos()
            self.message_start_time = self._io.read_u8le()
            self._debug['message_start_time']['end'] = self._io.pos()
            self._debug['message_end_time']['start'] = self._io.pos()
            self.message_end_time = self._io.read_u8le()
            self._debug['message_end_time']['end'] = self._io.pos()
            self._debug['len_channel_message_counts']['start'] = self._io.pos()
            self.len_channel_message_counts = self._io.read_u4le()
            self._debug['len_channel_message_counts']['end'] = self._io.pos()
            self._debug['channel_message_counts']['start'] = self._io.pos()
            self._raw_channel_message_counts = self._io.read_bytes(self.len_channel_message_counts)
            _io__raw_channel_message_counts = KaitaiStream(BytesIO(self._raw_channel_message_counts))
            self.channel_message_counts = Mcap.Statistics.ChannelMessageCounts(_io__raw_channel_message_counts, self, self._root)
            self.channel_message_counts._read()
            self._debug['channel_message_counts']['end'] = self._io.pos()

        class ChannelMessageCounts(KaitaiStruct):
            SEQ_FIELDS = ["entries"]
            def __init__(self, _io, _parent=None, _root=None):
                self._io = _io
                self._parent = _parent
                self._root = _root if _root else self
                self._debug = collections.defaultdict(dict)

            def _read(self):
                self._debug['entries']['start'] = self._io.pos()
                self.entries = []
                i = 0
                while not self._io.is_eof():
                    if not 'arr' in self._debug['entries']:
                        self._debug['entries']['arr'] = []
                    self._debug['entries']['arr'].append({'start': self._io.pos()})
                    _t_entries = Mcap.Statistics.ChannelMessageCount(self._io, self, self._root)
                    _t_entries._read()
                    self.entries.append(_t_entries)
                    self._debug['entries']['arr'][len(self.entries) - 1]['end'] = self._io.pos()
                    i += 1

                self._debug['entries']['end'] = self._io.pos()


        class ChannelMessageCount(KaitaiStruct):
            SEQ_FIELDS = ["channel_id", "message_count"]
            def __init__(self, _io, _parent=None, _root=None):
                self._io = _io
                self._parent = _parent
                self._root = _root if _root else self
                self._debug = collections.defaultdict(dict)

            def _read(self):
                self._debug['channel_id']['start'] = self._io.pos()
                self.channel_id = self._io.read_u2le()
                self._debug['channel_id']['end'] = self._io.pos()
                self._debug['message_count']['start'] = self._io.pos()
                self.message_count = self._io.read_u8le()
                self._debug['message_count']['end'] = self._io.pos()



    class AttachmentIndex(KaitaiStruct):
        SEQ_FIELDS = ["ofs_attachment", "len_attachment", "log_time", "create_time", "data_size", "name", "content_type"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['ofs_attachment']['start'] = self._io.pos()
            self.ofs_attachment = self._io.read_u8le()
            self._debug['ofs_attachment']['end'] = self._io.pos()
            self._debug['len_attachment']['start'] = self._io.pos()
            self.len_attachment = self._io.read_u8le()
            self._debug['len_attachment']['end'] = self._io.pos()
            self._debug['log_time']['start'] = self._io.pos()
            self.log_time = self._io.read_u8le()
            self._debug['log_time']['end'] = self._io.pos()
            self._debug['create_time']['start'] = self._io.pos()
            self.create_time = self._io.read_u8le()
            self._debug['create_time']['end'] = self._io.pos()
            self._debug['data_size']['start'] = self._io.pos()
            self.data_size = self._io.read_u8le()
            self._debug['data_size']['end'] = self._io.pos()
            self._debug['name']['start'] = self._io.pos()
            self.name = Mcap.PrefixedStr(self._io, self, self._root)
            self.name._read()
            self._debug['name']['end'] = self._io.pos()
            self._debug['content_type']['start'] = self._io.pos()
            self.content_type = Mcap.PrefixedStr(self._io, self, self._root)
            self.content_type._read()
            self._debug['content_type']['end'] = self._io.pos()

        @property
        def attachment(self):
            if hasattr(self, '_m_attachment'):
                return self._m_attachment

            io = self._root._io
            _pos = io.pos()
            io.seek(self.ofs_attachment)
            self._debug['_m_attachment']['start'] = io.pos()
            self._raw__m_attachment = io.read_bytes(self.len_attachment)
            _io__raw__m_attachment = KaitaiStream(BytesIO(self._raw__m_attachment))
            self._m_attachment = Mcap.Record(_io__raw__m_attachment, self, self._root)
            self._m_attachment._read()
            self._debug['_m_attachment']['end'] = io.pos()
            io.seek(_pos)
            return getattr(self, '_m_attachment', None)


    class Schema(KaitaiStruct):
        SEQ_FIELDS = ["id", "name", "encoding", "len_data", "data"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['id']['start'] = self._io.pos()
            self.id = self._io.read_u2le()
            self._debug['id']['end'] = self._io.pos()
            self._debug['name']['start'] = self._io.pos()
            self.name = Mcap.PrefixedStr(self._io, self, self._root)
            self.name._read()
            self._debug['name']['end'] = self._io.pos()
            self._debug['encoding']['start'] = self._io.pos()
            self.encoding = Mcap.PrefixedStr(self._io, self, self._root)
            self.encoding._read()
            self._debug['encoding']['end'] = self._io.pos()
            self._debug['len_data']['start'] = self._io.pos()
            self.len_data = self._io.read_u4le()
            self._debug['len_data']['end'] = self._io.pos()
            self._debug['data']['start'] = self._io.pos()
            self.data = self._io.read_bytes(self.len_data)
            self._debug['data']['end'] = self._io.pos()


    class MapStrStr(KaitaiStruct):
        SEQ_FIELDS = ["len_entries", "entries"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['len_entries']['start'] = self._io.pos()
            self.len_entries = self._io.read_u4le()
            self._debug['len_entries']['end'] = self._io.pos()
            self._debug['entries']['start'] = self._io.pos()
            self._raw_entries = self._io.read_bytes(self.len_entries)
            _io__raw_entries = KaitaiStream(BytesIO(self._raw_entries))
            self.entries = Mcap.MapStrStr.Entries(_io__raw_entries, self, self._root)
            self.entries._read()
            self._debug['entries']['end'] = self._io.pos()

        class Entries(KaitaiStruct):
            SEQ_FIELDS = ["entries"]
            def __init__(self, _io, _parent=None, _root=None):
                self._io = _io
                self._parent = _parent
                self._root = _root if _root else self
                self._debug = collections.defaultdict(dict)

            def _read(self):
                self._debug['entries']['start'] = self._io.pos()
                self.entries = []
                i = 0
                while not self._io.is_eof():
                    if not 'arr' in self._debug['entries']:
                        self._debug['entries']['arr'] = []
                    self._debug['entries']['arr'].append({'start': self._io.pos()})
                    _t_entries = Mcap.TupleStrStr(self._io, self, self._root)
                    _t_entries._read()
                    self.entries.append(_t_entries)
                    self._debug['entries']['arr'][len(self.entries) - 1]['end'] = self._io.pos()
                    i += 1

                self._debug['entries']['end'] = self._io.pos()



    class SummaryOffset(KaitaiStruct):
        SEQ_FIELDS = ["group_opcode", "ofs_group", "len_group"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['group_opcode']['start'] = self._io.pos()
            self.group_opcode = KaitaiStream.resolve_enum(Mcap.Opcode, self._io.read_u1())
            self._debug['group_opcode']['end'] = self._io.pos()
            self._debug['ofs_group']['start'] = self._io.pos()
            self.ofs_group = self._io.read_u8le()
            self._debug['ofs_group']['end'] = self._io.pos()
            self._debug['len_group']['start'] = self._io.pos()
            self.len_group = self._io.read_u8le()
            self._debug['len_group']['end'] = self._io.pos()

        @property
        def group(self):
            if hasattr(self, '_m_group'):
                return self._m_group

            io = self._root._io
            _pos = io.pos()
            io.seek(self.ofs_group)
            self._debug['_m_group']['start'] = io.pos()
            self._raw__m_group = io.read_bytes(self.len_group)
            _io__raw__m_group = KaitaiStream(BytesIO(self._raw__m_group))
            self._m_group = Mcap.Records(_io__raw__m_group, self, self._root)
            self._m_group._read()
            self._debug['_m_group']['end'] = io.pos()
            io.seek(_pos)
            return getattr(self, '_m_group', None)


    class Attachment(KaitaiStruct):
        SEQ_FIELDS = ["log_time", "create_time", "name", "content_type", "len_data", "data", "invoke_crc32_input_end", "crc32"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['log_time']['start'] = self._io.pos()
            self.log_time = self._io.read_u8le()
            self._debug['log_time']['end'] = self._io.pos()
            self._debug['create_time']['start'] = self._io.pos()
            self.create_time = self._io.read_u8le()
            self._debug['create_time']['end'] = self._io.pos()
            self._debug['name']['start'] = self._io.pos()
            self.name = Mcap.PrefixedStr(self._io, self, self._root)
            self.name._read()
            self._debug['name']['end'] = self._io.pos()
            self._debug['content_type']['start'] = self._io.pos()
            self.content_type = Mcap.PrefixedStr(self._io, self, self._root)
            self.content_type._read()
            self._debug['content_type']['end'] = self._io.pos()
            self._debug['len_data']['start'] = self._io.pos()
            self.len_data = self._io.read_u8le()
            self._debug['len_data']['end'] = self._io.pos()
            self._debug['data']['start'] = self._io.pos()
            self.data = self._io.read_bytes(self.len_data)
            self._debug['data']['end'] = self._io.pos()
            if self.crc32_input_end >= 0:
                self._debug['invoke_crc32_input_end']['start'] = self._io.pos()
                self.invoke_crc32_input_end = self._io.read_bytes(0)
                self._debug['invoke_crc32_input_end']['end'] = self._io.pos()

            self._debug['crc32']['start'] = self._io.pos()
            self.crc32 = self._io.read_u4le()
            self._debug['crc32']['end'] = self._io.pos()

        @property
        def crc32_input_end(self):
            if hasattr(self, '_m_crc32_input_end'):
                return self._m_crc32_input_end

            self._m_crc32_input_end = self._io.pos()
            return getattr(self, '_m_crc32_input_end', None)

        @property
        def crc32_input(self):
            if hasattr(self, '_m_crc32_input'):
                return self._m_crc32_input

            _pos = self._io.pos()
            self._io.seek(0)
            self._debug['_m_crc32_input']['start'] = self._io.pos()
            self._m_crc32_input = self._io.read_bytes(self.crc32_input_end)
            self._debug['_m_crc32_input']['end'] = self._io.pos()
            self._io.seek(_pos)
            return getattr(self, '_m_crc32_input', None)


    class Metadata(KaitaiStruct):
        SEQ_FIELDS = ["name", "metadata"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['name']['start'] = self._io.pos()
            self.name = Mcap.PrefixedStr(self._io, self, self._root)
            self.name._read()
            self._debug['name']['end'] = self._io.pos()
            self._debug['metadata']['start'] = self._io.pos()
            self.metadata = Mcap.MapStrStr(self._io, self, self._root)
            self.metadata._read()
            self._debug['metadata']['end'] = self._io.pos()


    class Header(KaitaiStruct):
        SEQ_FIELDS = ["profile", "library"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['profile']['start'] = self._io.pos()
            self.profile = Mcap.PrefixedStr(self._io, self, self._root)
            self.profile._read()
            self._debug['profile']['end'] = self._io.pos()
            self._debug['library']['start'] = self._io.pos()
            self.library = Mcap.PrefixedStr(self._io, self, self._root)
            self.library._read()
            self._debug['library']['end'] = self._io.pos()


    class Message(KaitaiStruct):
        SEQ_FIELDS = ["channel_id", "sequence", "log_time", "publish_time", "data"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['channel_id']['start'] = self._io.pos()
            self.channel_id = self._io.read_u2le()
            self._debug['channel_id']['end'] = self._io.pos()
            self._debug['sequence']['start'] = self._io.pos()
            self.sequence = self._io.read_u4le()
            self._debug['sequence']['end'] = self._io.pos()
            self._debug['log_time']['start'] = self._io.pos()
            self.log_time = self._io.read_u8le()
            self._debug['log_time']['end'] = self._io.pos()
            self._debug['publish_time']['start'] = self._io.pos()
            self.publish_time = self._io.read_u8le()
            self._debug['publish_time']['end'] = self._io.pos()
            self._debug['data']['start'] = self._io.pos()
            self.data = self._io.read_bytes_full()
            self._debug['data']['end'] = self._io.pos()


    class TupleStrStr(KaitaiStruct):
        SEQ_FIELDS = ["key", "value"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['key']['start'] = self._io.pos()
            self.key = Mcap.PrefixedStr(self._io, self, self._root)
            self.key._read()
            self._debug['key']['end'] = self._io.pos()
            self._debug['value']['start'] = self._io.pos()
            self.value = Mcap.PrefixedStr(self._io, self, self._root)
            self.value._read()
            self._debug['value']['end'] = self._io.pos()


    class MetadataIndex(KaitaiStruct):
        SEQ_FIELDS = ["ofs_metadata", "len_metadata", "name"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['ofs_metadata']['start'] = self._io.pos()
            self.ofs_metadata = self._io.read_u8le()
            self._debug['ofs_metadata']['end'] = self._io.pos()
            self._debug['len_metadata']['start'] = self._io.pos()
            self.len_metadata = self._io.read_u8le()
            self._debug['len_metadata']['end'] = self._io.pos()
            self._debug['name']['start'] = self._io.pos()
            self.name = Mcap.PrefixedStr(self._io, self, self._root)
            self.name._read()
            self._debug['name']['end'] = self._io.pos()

        @property
        def metadata(self):
            if hasattr(self, '_m_metadata'):
                return self._m_metadata

            io = self._root._io
            _pos = io.pos()
            io.seek(self.ofs_metadata)
            self._debug['_m_metadata']['start'] = io.pos()
            self._raw__m_metadata = io.read_bytes(self.len_metadata)
            _io__raw__m_metadata = KaitaiStream(BytesIO(self._raw__m_metadata))
            self._m_metadata = Mcap.Record(_io__raw__m_metadata, self, self._root)
            self._m_metadata._read()
            self._debug['_m_metadata']['end'] = io.pos()
            io.seek(_pos)
            return getattr(self, '_m_metadata', None)


    class Magic(KaitaiStruct):
        SEQ_FIELDS = ["magic"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['magic']['start'] = self._io.pos()
            self.magic = self._io.read_bytes(8)
            self._debug['magic']['end'] = self._io.pos()
            if not self.magic == b"\x89\x4D\x43\x41\x50\x30\x0D\x0A":
                raise kaitaistruct.ValidationNotEqualError(b"\x89\x4D\x43\x41\x50\x30\x0D\x0A", self.magic, self._io, u"/types/magic/seq/0")


    class Records(KaitaiStruct):
        SEQ_FIELDS = ["records"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['records']['start'] = self._io.pos()
            self.records = []
            i = 0
            while not self._io.is_eof():
                if not 'arr' in self._debug['records']:
                    self._debug['records']['arr'] = []
                self._debug['records']['arr'].append({'start': self._io.pos()})
                _t_records = Mcap.Record(self._io, self, self._root)
                _t_records._read()
                self.records.append(_t_records)
                self._debug['records']['arr'][len(self.records) - 1]['end'] = self._io.pos()
                i += 1

            self._debug['records']['end'] = self._io.pos()


    class Footer(KaitaiStruct):
        SEQ_FIELDS = ["ofs_summary_section", "ofs_summary_offset_section", "summary_crc32"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['ofs_summary_section']['start'] = self._io.pos()
            self.ofs_summary_section = self._io.read_u8le()
            self._debug['ofs_summary_section']['end'] = self._io.pos()
            self._debug['ofs_summary_offset_section']['start'] = self._io.pos()
            self.ofs_summary_offset_section = self._io.read_u8le()
            self._debug['ofs_summary_offset_section']['end'] = self._io.pos()
            self._debug['summary_crc32']['start'] = self._io.pos()
            self.summary_crc32 = self._io.read_u4le()
            self._debug['summary_crc32']['end'] = self._io.pos()

        @property
        def summary_section(self):
            if hasattr(self, '_m_summary_section'):
                return self._m_summary_section

            if self.ofs_summary_section != 0:
                io = self._root._io
                _pos = io.pos()
                io.seek(self.ofs_summary_section)
                self._debug['_m_summary_section']['start'] = io.pos()
                self._raw__m_summary_section = io.read_bytes(((self.ofs_summary_offset_section if self.ofs_summary_offset_section != 0 else self._root.ofs_footer) - self.ofs_summary_section))
                _io__raw__m_summary_section = KaitaiStream(BytesIO(self._raw__m_summary_section))
                self._m_summary_section = Mcap.Records(_io__raw__m_summary_section, self, self._root)
                self._m_summary_section._read()
                self._debug['_m_summary_section']['end'] = io.pos()
                io.seek(_pos)

            return getattr(self, '_m_summary_section', None)

        @property
        def summary_offset_section(self):
            if hasattr(self, '_m_summary_offset_section'):
                return self._m_summary_offset_section

            if self.ofs_summary_offset_section != 0:
                io = self._root._io
                _pos = io.pos()
                io.seek(self.ofs_summary_offset_section)
                self._debug['_m_summary_offset_section']['start'] = io.pos()
                self._raw__m_summary_offset_section = io.read_bytes((self._root.ofs_footer - self.ofs_summary_offset_section))
                _io__raw__m_summary_offset_section = KaitaiStream(BytesIO(self._raw__m_summary_offset_section))
                self._m_summary_offset_section = Mcap.Records(_io__raw__m_summary_offset_section, self, self._root)
                self._m_summary_offset_section._read()
                self._debug['_m_summary_offset_section']['end'] = io.pos()
                io.seek(_pos)

            return getattr(self, '_m_summary_offset_section', None)

        @property
        def ofs_summary_crc32_input(self):
            if hasattr(self, '_m_ofs_summary_crc32_input'):
                return self._m_ofs_summary_crc32_input

            self._m_ofs_summary_crc32_input = (self.ofs_summary_section if self.ofs_summary_section != 0 else self._root.ofs_footer)
            return getattr(self, '_m_ofs_summary_crc32_input', None)

        @property
        def summary_crc32_input(self):
            if hasattr(self, '_m_summary_crc32_input'):
                return self._m_summary_crc32_input

            io = self._root._io
            _pos = io.pos()
            io.seek(self.ofs_summary_crc32_input)
            self._debug['_m_summary_crc32_input']['start'] = io.pos()
            self._m_summary_crc32_input = io.read_bytes((((self._root._io.size() - self.ofs_summary_crc32_input) - 8) - 4))
            self._debug['_m_summary_crc32_input']['end'] = io.pos()
            io.seek(_pos)
            return getattr(self, '_m_summary_crc32_input', None)


    class Record(KaitaiStruct):
        SEQ_FIELDS = ["op", "len_body", "body"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['op']['start'] = self._io.pos()
            self.op = KaitaiStream.resolve_enum(Mcap.Opcode, self._io.read_u1())
            self._debug['op']['end'] = self._io.pos()
            self._debug['len_body']['start'] = self._io.pos()
            self.len_body = self._io.read_u8le()
            self._debug['len_body']['end'] = self._io.pos()
            self._debug['body']['start'] = self._io.pos()
            _on = self.op
            if _on == Mcap.Opcode.message:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Message(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.metadata_index:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.MetadataIndex(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.chunk:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Chunk(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.schema:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Schema(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.chunk_index:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.ChunkIndex(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.data_end:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.DataEnd(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.attachment_index:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.AttachmentIndex(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.statistics:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Statistics(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.message_index:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.MessageIndex(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.channel:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Channel(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.metadata:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Metadata(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.attachment:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Attachment(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.header:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Header(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.footer:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.Footer(_io__raw_body, self, self._root)
                self.body._read()
            elif _on == Mcap.Opcode.summary_offset:
                self._raw_body = self._io.read_bytes(self.len_body)
                _io__raw_body = KaitaiStream(BytesIO(self._raw_body))
                self.body = Mcap.SummaryOffset(_io__raw_body, self, self._root)
                self.body._read()
            else:
                self.body = self._io.read_bytes(self.len_body)
            self._debug['body']['end'] = self._io.pos()


    class ChunkIndex(KaitaiStruct):
        SEQ_FIELDS = ["message_start_time", "message_end_time", "ofs_chunk", "len_chunk", "len_message_index_offsets", "message_index_offsets", "message_index_length", "compression", "compressed_size", "uncompressed_size"]
        def __init__(self, _io, _parent=None, _root=None):
            self._io = _io
            self._parent = _parent
            self._root = _root if _root else self
            self._debug = collections.defaultdict(dict)

        def _read(self):
            self._debug['message_start_time']['start'] = self._io.pos()
            self.message_start_time = self._io.read_u8le()
            self._debug['message_start_time']['end'] = self._io.pos()
            self._debug['message_end_time']['start'] = self._io.pos()
            self.message_end_time = self._io.read_u8le()
            self._debug['message_end_time']['end'] = self._io.pos()
            self._debug['ofs_chunk']['start'] = self._io.pos()
            self.ofs_chunk = self._io.read_u8le()
            self._debug['ofs_chunk']['end'] = self._io.pos()
            self._debug['len_chunk']['start'] = self._io.pos()
            self.len_chunk = self._io.read_u8le()
            self._debug['len_chunk']['end'] = self._io.pos()
            self._debug['len_message_index_offsets']['start'] = self._io.pos()
            self.len_message_index_offsets = self._io.read_u4le()
            self._debug['len_message_index_offsets']['end'] = self._io.pos()
            self._debug['message_index_offsets']['start'] = self._io.pos()
            self._raw_message_index_offsets = self._io.read_bytes(self.len_message_index_offsets)
            _io__raw_message_index_offsets = KaitaiStream(BytesIO(self._raw_message_index_offsets))
            self.message_index_offsets = Mcap.ChunkIndex.MessageIndexOffsets(_io__raw_message_index_offsets, self, self._root)
            self.message_index_offsets._read()
            self._debug['message_index_offsets']['end'] = self._io.pos()
            self._debug['message_index_length']['start'] = self._io.pos()
            self.message_index_length = self._io.read_u8le()
            self._debug['message_index_length']['end'] = self._io.pos()
            self._debug['compression']['start'] = self._io.pos()
            self.compression = Mcap.PrefixedStr(self._io, self, self._root)
            self.compression._read()
            self._debug['compression']['end'] = self._io.pos()
            self._debug['compressed_size']['start'] = self._io.pos()
            self.compressed_size = self._io.read_u8le()
            self._debug['compressed_size']['end'] = self._io.pos()
            self._debug['uncompressed_size']['start'] = self._io.pos()
            self.uncompressed_size = self._io.read_u8le()
            self._debug['uncompressed_size']['end'] = self._io.pos()

        class MessageIndexOffset(KaitaiStruct):
            SEQ_FIELDS = ["channel_id", "offset"]
            def __init__(self, _io, _parent=None, _root=None):
                self._io = _io
                self._parent = _parent
                self._root = _root if _root else self
                self._debug = collections.defaultdict(dict)

            def _read(self):
                self._debug['channel_id']['start'] = self._io.pos()
                self.channel_id = self._io.read_u2le()
                self._debug['channel_id']['end'] = self._io.pos()
                self._debug['offset']['start'] = self._io.pos()
                self.offset = self._io.read_u8le()
                self._debug['offset']['end'] = self._io.pos()


        class MessageIndexOffsets(KaitaiStruct):
            SEQ_FIELDS = ["entries"]
            def __init__(self, _io, _parent=None, _root=None):
                self._io = _io
                self._parent = _parent
                self._root = _root if _root else self
                self._debug = collections.defaultdict(dict)

            def _read(self):
                self._debug['entries']['start'] = self._io.pos()
                self.entries = []
                i = 0
                while not self._io.is_eof():
                    if not 'arr' in self._debug['entries']:
                        self._debug['entries']['arr'] = []
                    self._debug['entries']['arr'].append({'start': self._io.pos()})
                    _t_entries = Mcap.ChunkIndex.MessageIndexOffset(self._io, self, self._root)
                    _t_entries._read()
                    self.entries.append(_t_entries)
                    self._debug['entries']['arr'][len(self.entries) - 1]['end'] = self._io.pos()
                    i += 1

                self._debug['entries']['end'] = self._io.pos()


        @property
        def chunk(self):
            if hasattr(self, '_m_chunk'):
                return self._m_chunk

            io = self._root._io
            _pos = io.pos()
            io.seek(self.ofs_chunk)
            self._debug['_m_chunk']['start'] = io.pos()
            self._raw__m_chunk = io.read_bytes(self.len_chunk)
            _io__raw__m_chunk = KaitaiStream(BytesIO(self._raw__m_chunk))
            self._m_chunk = Mcap.Record(_io__raw__m_chunk, self, self._root)
            self._m_chunk._read()
            self._debug['_m_chunk']['end'] = io.pos()
            io.seek(_pos)
            return getattr(self, '_m_chunk', None)


    @property
    def footer(self):
        if hasattr(self, '_m_footer'):
            return self._m_footer

        _pos = self._io.pos()
        self._io.seek(self.ofs_footer)
        self._debug['_m_footer']['start'] = self._io.pos()
        self._raw__m_footer = self._io.read_bytes_full()
        _io__raw__m_footer = KaitaiStream(BytesIO(self._raw__m_footer))
        self._m_footer = Mcap.Record(_io__raw__m_footer, self, self._root)
        self._m_footer._read()
        self._debug['_m_footer']['end'] = self._io.pos()
        self._io.seek(_pos)
        return getattr(self, '_m_footer', None)

    @property
    def ofs_footer(self):
        if hasattr(self, '_m_ofs_footer'):
            return self._m_ofs_footer

        self._m_ofs_footer = ((((self._io.size() - 1) - 8) - 20) - 8)
        return getattr(self, '_m_ofs_footer', None)


