"Main interface for rds Client"
from __future__ import annotations

from datetime import datetime
from typing import Any
from typing import Dict
from typing import List
from botocore.client import BaseClient
from botocore.paginate import Paginator
from botocore.waiter import Waiter


class Client(BaseClient):
    def add_role_to_db_cluster(
        self,
        DBClusterIdentifier: str,
        RoleArn: str,
        FeatureName: str = None
    ) -> None:
        """
        Associates an Identity and Access Management (IAM) role from an Amazon Aurora DB cluster. For more information, see `Authorizing Amazon Aurora MySQL to Access Other AWS Services on Your Behalf <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.html>`__ in the *Amazon Aurora User Guide* .

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster>`_

        **Request Syntax**
        ::

          response = client.add_role_to_db_cluster(
              DBClusterIdentifier='string',
              RoleArn='string',
              FeatureName='string'
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The name of the DB cluster to associate the IAM role with.

        :type RoleArn: string
        :param RoleArn: **[REQUIRED]**

          The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example ``arn:aws:iam::123456789012:role/AuroraAccessRole`` .

        :type FeatureName: string
        :param FeatureName:

          The name of the feature for the DB cluster that the IAM role is to be associated with. For the list of supported feature names, see  DBEngineVersion .

        :returns: None
        """
        pass

    def add_role_to_db_instance(
        self,
        DBInstanceIdentifier: str,
        RoleArn: str,
        FeatureName: str
    ) -> None:
        """
        Associates an AWS Identity and Access Management (IAM) role with a DB instance.

        .. note::

          To add a role to a DB instance, the status of the DB instance must be ``available`` .

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance>`_

        **Request Syntax**
        ::

          response = client.add_role_to_db_instance(
              DBInstanceIdentifier='string',
              RoleArn='string',
              FeatureName='string'
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The name of the DB instance to associate the IAM role with.

        :type RoleArn: string
        :param RoleArn: **[REQUIRED]**

          The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example ``arn:aws:iam::123456789012:role/AccessRole`` .

        :type FeatureName: string
        :param FeatureName: **[REQUIRED]**

          The name of the feature for the DB instance that the IAM role is to be associated with. For the list of supported feature names, see  DBEngineVersion .

        :returns: None
        """
        pass

    def add_source_identifier_to_subscription(
        self,
        SubscriptionName: str,
        SourceIdentifier: str
    ) -> Dict[str, Any]:
        """
        Adds a source identifier to an existing RDS event notification subscription.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription>`_

        **Request Syntax**
        ::

          response = client.add_source_identifier_to_subscription(
              SubscriptionName='string',
              SourceIdentifier='string'
          )
        :type SubscriptionName: string
        :param SubscriptionName: **[REQUIRED]**

          The name of the RDS event notification subscription you want to add a source identifier to.

        :type SourceIdentifier: string
        :param SourceIdentifier: **[REQUIRED]**

          The identifier of the event source to be added.

          Constraints:

          * If the source type is a DB instance, then a ``DBInstanceIdentifier`` must be supplied.

          * If the source type is a DB security group, a ``DBSecurityGroupName`` must be supplied.

          * If the source type is a DB parameter group, a ``DBParameterGroupName`` must be supplied.

          * If the source type is a DB snapshot, a ``DBSnapshotIdentifier`` must be supplied.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'EventSubscription': {
                    'CustomerAwsId': 'string',
                    'CustSubscriptionId': 'string',
                    'SnsTopicArn': 'string',
                    'Status': 'string',
                    'SubscriptionCreationTime': 'string',
                    'SourceType': 'string',
                    'SourceIdsList': [
                        'string',
                    ],
                    'EventCategoriesList': [
                        'string',
                    ],
                    'Enabled': True|False,
                    'EventSubscriptionArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **EventSubscription** *(dict) --*

              Contains the results of a successful invocation of the ``DescribeEventSubscriptions`` action.

              - **CustomerAwsId** *(string) --*

                The AWS customer account associated with the RDS event notification subscription.

              - **CustSubscriptionId** *(string) --*

                The RDS event notification subscription Id.

              - **SnsTopicArn** *(string) --*

                The topic ARN of the RDS event notification subscription.

              - **Status** *(string) --*

                The status of the RDS event notification subscription.

                Constraints:

                Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist

                The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.

              - **SubscriptionCreationTime** *(string) --*

                The time the RDS event notification subscription was created.

              - **SourceType** *(string) --*

                The source type for the RDS event notification subscription.

              - **SourceIdsList** *(list) --*

                A list of source IDs for the RDS event notification subscription.

                - *(string) --*

              - **EventCategoriesList** *(list) --*

                A list of event categories for the RDS event notification subscription.

                - *(string) --*

              - **Enabled** *(boolean) --*

                A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.

              - **EventSubscriptionArn** *(string) --*

                The Amazon Resource Name (ARN) for the event subscription.

        """
        pass

    def add_tags_to_resource(
        self,
        ResourceName: str,
        Tags: List[Any]
    ) -> None:
        """
        Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.

        For an overview on tagging Amazon RDS resources, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html>`__ .

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource>`_

        **Request Syntax**
        ::

          response = client.add_tags_to_resource(
              ResourceName='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type ResourceName: string
        :param ResourceName: **[REQUIRED]**

          The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see `Constructing an RDS Amazon Resource Name (ARN) <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing>`__ .

        :type Tags: list
        :param Tags: **[REQUIRED]**

          The tags to be assigned to the Amazon RDS resource.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :returns: None
        """
        pass

    def apply_pending_maintenance_action(
        self,
        ResourceIdentifier: str,
        ApplyAction: str,
        OptInType: str
    ) -> Dict[str, Any]:
        """
        Applies a pending maintenance action to a resource (for example, to a DB instance).

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction>`_

        **Request Syntax**
        ::

          response = client.apply_pending_maintenance_action(
              ResourceIdentifier='string',
              ApplyAction='string',
              OptInType='string'
          )
        :type ResourceIdentifier: string
        :param ResourceIdentifier: **[REQUIRED]**

          The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see `Constructing an RDS Amazon Resource Name (ARN) <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing>`__ .

        :type ApplyAction: string
        :param ApplyAction: **[REQUIRED]**

          The pending maintenance action to apply to this resource.

          Valid values: ``system-update`` , ``db-upgrade`` , ``hardware-maintenance``

        :type OptInType: string
        :param OptInType: **[REQUIRED]**

          A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type ``immediate`` can't be undone.

          Valid values:

          * ``immediate`` - Apply the maintenance action immediately.

          * ``next-maintenance`` - Apply the maintenance action during the next maintenance window for the resource.

          * ``undo-opt-in`` - Cancel any existing ``next-maintenance`` opt-in requests.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'ResourcePendingMaintenanceActions': {
                    'ResourceIdentifier': 'string',
                    'PendingMaintenanceActionDetails': [
                        {
                            'Action': 'string',
                            'AutoAppliedAfterDate': datetime(2015, 1, 1),
                            'ForcedApplyDate': datetime(2015, 1, 1),
                            'OptInStatus': 'string',
                            'CurrentApplyDate': datetime(2015, 1, 1),
                            'Description': 'string'
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **ResourcePendingMaintenanceActions** *(dict) --*

              Describes the pending maintenance actions for a resource.

              - **ResourceIdentifier** *(string) --*

                The ARN of the resource that has pending maintenance actions.

              - **PendingMaintenanceActionDetails** *(list) --*

                A list that provides details about the pending maintenance actions for the resource.

                - *(dict) --*

                  Provides information about a pending maintenance action for a resource.

                  - **Action** *(string) --*

                    The type of pending maintenance action that is available for the resource. Valid actions are ``system-update`` , ``db-upgrade`` , and ``hardware-maintenance`` .

                  - **AutoAppliedAfterDate** *(datetime) --*

                    The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.

                  - **ForcedApplyDate** *(datetime) --*

                    The date when the maintenance action is automatically applied. The maintenance action is applied to the resource on this date regardless of the maintenance window for the resource.

                  - **OptInStatus** *(string) --*

                    Indicates the type of opt-in request that has been received for the resource.

                  - **CurrentApplyDate** *(datetime) --*

                    The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the ``ApplyPendingMaintenanceAction`` API, the ``AutoAppliedAfterDate`` , and the ``ForcedApplyDate`` . This value is blank if an opt-in request has not been received and nothing has been specified as ``AutoAppliedAfterDate`` or ``ForcedApplyDate`` .

                  - **Description** *(string) --*

                    A description providing more detail about the maintenance action.

        """
        pass

    def authorize_db_security_group_ingress(
        self,
        DBSecurityGroupName: str,
        CIDRIP: str = None,
        EC2SecurityGroupName: str = None,
        EC2SecurityGroupId: str = None,
        EC2SecurityGroupOwnerId: str = None
    ) -> Dict[str, Any]:
        """
        Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the Internet. Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).

        .. note::

          You can't authorize ingress from an EC2 security group in one AWS Region to an Amazon RDS DB instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.

        For an overview of CIDR ranges, go to the `Wikipedia Tutorial <http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`__ .

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress>`_

        **Request Syntax**
        ::

          response = client.authorize_db_security_group_ingress(
              DBSecurityGroupName='string',
              CIDRIP='string',
              EC2SecurityGroupName='string',
              EC2SecurityGroupId='string',
              EC2SecurityGroupOwnerId='string'
          )
        :type DBSecurityGroupName: string
        :param DBSecurityGroupName: **[REQUIRED]**

          The name of the DB security group to add authorization to.

        :type CIDRIP: string
        :param CIDRIP:

          The IP range to authorize.

        :type EC2SecurityGroupName: string
        :param EC2SecurityGroupName:

          Name of the EC2 security group to authorize. For VPC DB security groups, ``EC2SecurityGroupId`` must be provided. Otherwise, ``EC2SecurityGroupOwnerId`` and either ``EC2SecurityGroupName`` or ``EC2SecurityGroupId`` must be provided.

        :type EC2SecurityGroupId: string
        :param EC2SecurityGroupId:

          Id of the EC2 security group to authorize. For VPC DB security groups, ``EC2SecurityGroupId`` must be provided. Otherwise, ``EC2SecurityGroupOwnerId`` and either ``EC2SecurityGroupName`` or ``EC2SecurityGroupId`` must be provided.

        :type EC2SecurityGroupOwnerId: string
        :param EC2SecurityGroupOwnerId:

          AWS account number of the owner of the EC2 security group specified in the ``EC2SecurityGroupName`` parameter. The AWS access key ID isn't an acceptable value. For VPC DB security groups, ``EC2SecurityGroupId`` must be provided. Otherwise, ``EC2SecurityGroupOwnerId`` and either ``EC2SecurityGroupName`` or ``EC2SecurityGroupId`` must be provided.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSecurityGroup': {
                    'OwnerId': 'string',
                    'DBSecurityGroupName': 'string',
                    'DBSecurityGroupDescription': 'string',
                    'VpcId': 'string',
                    'EC2SecurityGroups': [
                        {
                            'Status': 'string',
                            'EC2SecurityGroupName': 'string',
                            'EC2SecurityGroupId': 'string',
                            'EC2SecurityGroupOwnerId': 'string'
                        },
                    ],
                    'IPRanges': [
                        {
                            'Status': 'string',
                            'CIDRIP': 'string'
                        },
                    ],
                    'DBSecurityGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSecurityGroup** *(dict) --*

              Contains the details for an Amazon RDS DB security group.

              This data type is used as a response element in the ``DescribeDBSecurityGroups`` action.

              - **OwnerId** *(string) --*

                Provides the AWS ID of the owner of a specific DB security group.

              - **DBSecurityGroupName** *(string) --*

                Specifies the name of the DB security group.

              - **DBSecurityGroupDescription** *(string) --*

                Provides the description of the DB security group.

              - **VpcId** *(string) --*

                Provides the VpcId of the DB security group.

              - **EC2SecurityGroups** *(list) --*

                Contains a list of ``EC2SecurityGroup`` elements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``AuthorizeDBSecurityGroupIngress``

                  * ``DescribeDBSecurityGroups``

                  * ``RevokeDBSecurityGroupIngress``

                  - **Status** *(string) --*

                    Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".

                  - **EC2SecurityGroupName** *(string) --*

                    Specifies the name of the EC2 security group.

                  - **EC2SecurityGroupId** *(string) --*

                    Specifies the id of the EC2 security group.

                  - **EC2SecurityGroupOwnerId** *(string) --*

                    Specifies the AWS ID of the owner of the EC2 security group specified in the ``EC2SecurityGroupName`` field.

              - **IPRanges** *(list) --*

                Contains a list of ``IPRange`` elements.

                - *(dict) --*

                  This data type is used as a response element in the ``DescribeDBSecurityGroups`` action.

                  - **Status** *(string) --*

                    Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".

                  - **CIDRIP** *(string) --*

                    Specifies the IP range.

              - **DBSecurityGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB security group.

        """
        pass

    def backtrack_db_cluster(
        self,
        DBClusterIdentifier: str,
        BacktrackTo: datetime,
        Force: bool = None,
        UseEarliestTimeOnPointInTimeUnavailable: bool = None
    ) -> Dict[str, Any]:
        """
        Backtracks a DB cluster to a specific time, without creating a new DB cluster.

        For more information on backtracking, see `Backtracking an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster>`_

        **Request Syntax**
        ::

          response = client.backtrack_db_cluster(
              DBClusterIdentifier='string',
              BacktrackTo=datetime(2015, 1, 1),
              Force=True|False,
              UseEarliestTimeOnPointInTimeUnavailable=True|False
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 alphanumeric characters or hyphens.

          * First character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          Example: ``my-cluster1``

        :type BacktrackTo: datetime
        :param BacktrackTo: **[REQUIRED]**

          The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the `ISO8601 Wikipedia page. <http://en.wikipedia.org/wiki/ISO_8601>`__

          .. note::

            If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.

          Constraints:

          * Must contain a valid ISO 8601 timestamp.

          * Can't contain a timestamp set in the future.

          Example: ``2017-07-08T18:00Z``

        :type Force: boolean
        :param Force:

          A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.

        :type UseEarliestTimeOnPointInTimeUnavailable: boolean
        :param UseEarliestTimeOnPointInTimeUnavailable:

          A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when *BacktrackTo* is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and *BacktrackTo* is set to a timestamp earlier than the earliest backtrack time, an error occurs.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterIdentifier': 'string',
                'BacktrackIdentifier': 'string',
                'BacktrackTo': datetime(2015, 1, 1),
                'BacktrackedFrom': datetime(2015, 1, 1),
                'BacktrackRequestCreationTime': datetime(2015, 1, 1),
                'Status': 'string'
            }
          **Response Structure**

          - *(dict) --*

            This data type is used as a response element in the ``DescribeDBClusterBacktracks`` action.

            - **DBClusterIdentifier** *(string) --*

              Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

            - **BacktrackIdentifier** *(string) --*

              Contains the backtrack identifier.

            - **BacktrackTo** *(datetime) --*

              The timestamp of the time to which the DB cluster was backtracked.

            - **BacktrackedFrom** *(datetime) --*

              The timestamp of the time from which the DB cluster was backtracked.

            - **BacktrackRequestCreationTime** *(datetime) --*

              The timestamp of the time at which the backtrack was requested.

            - **Status** *(string) --*

              The status of the backtrack. This property returns one of the following values:

              * ``applying`` - The backtrack is currently being applied to or rolled back from the DB cluster.

              * ``completed`` - The backtrack has successfully been applied to or rolled back from the DB cluster.

              * ``failed`` - An error occurred while the backtrack was applied to or rolled back from the DB cluster.

              * ``pending`` - The backtrack is currently pending application to or rollback from the DB cluster.

        """
        pass

    def can_paginate(
        self,
        operation_name: str = None
    ) -> None:
        """
        Check if an operation can be paginated.

        :type operation_name: string
        :param operation_name: The operation name.  This is the same name
            as the method name on the client.  For example, if the
            method name is ``create_foo``, and you'd normally invoke the
            operation as ``client.create_foo(**kwargs)``, if the
            ``create_foo`` operation can be paginated, you can use the
            call ``client.get_paginator("create_foo")``.

        :return: ``True`` if the operation can be paginated,
            ``False`` otherwise.
        """
        pass

    def copy_db_cluster_parameter_group(
        self,
        SourceDBClusterParameterGroupIdentifier: str,
        TargetDBClusterParameterGroupIdentifier: str,
        TargetDBClusterParameterGroupDescription: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Copies the specified DB cluster parameter group.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup>`_

        **Request Syntax**
        ::

          response = client.copy_db_cluster_parameter_group(
              SourceDBClusterParameterGroupIdentifier='string',
              TargetDBClusterParameterGroupIdentifier='string',
              TargetDBClusterParameterGroupDescription='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type SourceDBClusterParameterGroupIdentifier: string
        :param SourceDBClusterParameterGroupIdentifier: **[REQUIRED]**

          The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see `Constructing an ARN for Amazon RDS <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing>`__ in the *Amazon Aurora User Guide* .

          Constraints:

          * Must specify a valid DB cluster parameter group.

          * If the source DB cluster parameter group is in the same AWS Region as the copy, specify a valid DB parameter group identifier, for example ``my-db-cluster-param-group`` , or a valid ARN.

          * If the source DB parameter group is in a different AWS Region than the copy, specify a valid DB cluster parameter group ARN, for example ``arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1`` .

        :type TargetDBClusterParameterGroupIdentifier: string
        :param TargetDBClusterParameterGroupIdentifier: **[REQUIRED]**

          The identifier for the copied DB cluster parameter group.

          Constraints:

          * Can't be null, empty, or blank

          * Must contain from 1 to 255 letters, numbers, or hyphens

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``my-cluster-param-group1``

        :type TargetDBClusterParameterGroupDescription: string
        :param TargetDBClusterParameterGroupDescription: **[REQUIRED]**

          A description for the copied DB cluster parameter group.

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterParameterGroup': {
                    'DBClusterParameterGroupName': 'string',
                    'DBParameterGroupFamily': 'string',
                    'Description': 'string',
                    'DBClusterParameterGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterParameterGroup** *(dict) --*

              Contains the details of an Amazon RDS DB cluster parameter group.

              This data type is used as a response element in the ``DescribeDBClusterParameterGroups`` action.

              - **DBClusterParameterGroupName** *(string) --*

                Provides the name of the DB cluster parameter group.

              - **DBParameterGroupFamily** *(string) --*

                Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.

              - **Description** *(string) --*

                Provides the customer-specified description for this DB cluster parameter group.

              - **DBClusterParameterGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster parameter group.

        """
        pass

    def copy_db_cluster_snapshot(
        self,
        SourceDBClusterSnapshotIdentifier: str,
        TargetDBClusterSnapshotIdentifier: str,
        KmsKeyId: str = None,
        PreSignedUrl: str = None,
        CopyTags: bool = None,
        Tags: List[Any] = None,
        SourceRegion: str = None
    ) -> Dict[str, Any]:
        """
        Copies a snapshot of a DB cluster.

        To copy a DB cluster snapshot from a shared manual DB cluster snapshot, ``SourceDBClusterSnapshotIdentifier`` must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.

        You can copy an encrypted DB cluster snapshot from another AWS Region. In that case, the AWS Region where you call the ``CopyDBClusterSnapshot`` action is the destination AWS Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot from another AWS Region, you must provide the following values:

        * ``KmsKeyId`` - The AWS Key Management System (AWS KMS) key identifier for the key to use to encrypt the copy of the DB cluster snapshot in the destination AWS Region.

        * ``PreSignedUrl`` - A URL that contains a Signature Version 4 signed request for the ``CopyDBClusterSnapshot`` action to be called in the source AWS Region where the DB cluster snapshot is copied from. The pre-signed URL must be a valid request for the ``CopyDBClusterSnapshot`` API action that can be executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:

          * ``KmsKeyId`` - The KMS key identifier for the key to use to encrypt the copy of the DB cluster snapshot in the destination AWS Region. This is the same identifier for both the ``CopyDBClusterSnapshot`` action that is called in the destination AWS Region, and the action contained in the pre-signed URL.

          * ``DestinationRegion`` - The name of the AWS Region that the DB cluster snapshot will be created in.

          * ``SourceDBClusterSnapshotIdentifier`` - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 AWS Region, then your ``SourceDBClusterSnapshotIdentifier`` looks like the following example: ``arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`` .

        To learn how to generate a Signature Version 4 signed request, see `Authenticating Requests: Using Query Parameters (AWS Signature Version 4) <https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html>`__ and `Signature Version 4 Signing Process <https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html>`__ .

        .. note::

          If you are using an AWS SDK tool or the AWS CLI, you can specify ``SourceRegion`` (or ``--source-region`` for the AWS CLI) instead of specifying ``PreSignedUrl`` manually. Specifying ``SourceRegion`` autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source AWS Region.

        * ``TargetDBClusterSnapshotIdentifier`` - The identifier for the new copy of the DB cluster snapshot in the destination AWS Region.

        * ``SourceDBClusterSnapshotIdentifier`` - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the ARN format for the source AWS Region and is the same value as the ``SourceDBClusterSnapshotIdentifier`` in the pre-signed URL.

        To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by ``TargetDBClusterSnapshotIdentifier`` while that DB cluster snapshot is in "copying" status.

        For more information on copying encrypted DB cluster snapshots from one AWS Region to another, see `Copying a Snapshot <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html>`__ in the *Amazon Aurora User Guide.*

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot>`_

        **Request Syntax**
        ::

          response = client.copy_db_cluster_snapshot(
              SourceDBClusterSnapshotIdentifier='string',
              TargetDBClusterSnapshotIdentifier='string',
              KmsKeyId='string',
              CopyTags=True|False,
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ],
              SourceRegion='string'
          )
        :type SourceDBClusterSnapshotIdentifier: string
        :param SourceDBClusterSnapshotIdentifier: **[REQUIRED]**

          The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.

          You can't copy an encrypted, shared DB cluster snapshot from one AWS Region to another.

          Constraints:

          * Must specify a valid system snapshot in the "available" state.

          * If the source snapshot is in the same AWS Region as the copy, specify a valid DB snapshot identifier.

          * If the source snapshot is in a different AWS Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to `Copying Snapshots Across AWS Regions <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions>`__ in the *Amazon Aurora User Guide.*

          Example: ``my-cluster-snapshot1``

        :type TargetDBClusterSnapshotIdentifier: string
        :param TargetDBClusterSnapshotIdentifier: **[REQUIRED]**

          The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.

          Constraints:

          * Must contain from 1 to 63 letters, numbers, or hyphens.

          * First character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          Example: ``my-cluster-snapshot2``

        :type KmsKeyId: string
        :param KmsKeyId:

          The AWS AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

          If you copy an encrypted DB cluster snapshot from your AWS account, you can specify a value for ``KmsKeyId`` to encrypt the copy with a new KMS encryption key. If you don't specify a value for ``KmsKeyId`` , then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.

          If you copy an encrypted DB cluster snapshot that is shared from another AWS account, then you must specify a value for ``KmsKeyId`` .

          To copy an encrypted DB cluster snapshot to another AWS Region, you must set ``KmsKeyId`` to the KMS key ID you want to use to encrypt the copy of the DB cluster snapshot in the destination AWS Region. KMS encryption keys are specific to the AWS Region that they are created in, and you can't use encryption keys from one AWS Region in another AWS Region.

          If you copy an unencrypted DB cluster snapshot and specify a value for the ``KmsKeyId`` parameter, an error is returned.

        :type PreSignedUrl: string
        :param PreSignedUrl:

          The URL that contains a Signature Version 4 signed request for the ``CopyDBClusterSnapshot`` API action in the AWS Region that contains the source DB cluster snapshot to copy. The ``PreSignedUrl`` parameter must be used when copying an encrypted DB cluster snapshot from another AWS Region. Don't specify ``PreSignedUrl`` when you are copying an encrypted DB cluster snapshot in the same AWS Region.

          The pre-signed URL must be a valid request for the ``CopyDBSClusterSnapshot`` API action that can be executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:

          * ``KmsKeyId`` - The AWS KMS key identifier for the key to use to encrypt the copy of the DB cluster snapshot in the destination AWS Region. This is the same identifier for both the ``CopyDBClusterSnapshot`` action that is called in the destination AWS Region, and the action contained in the pre-signed URL.

          * ``DestinationRegion`` - The name of the AWS Region that the DB cluster snapshot will be created in.

          * ``SourceDBClusterSnapshotIdentifier`` - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 AWS Region, then your ``SourceDBClusterSnapshotIdentifier`` looks like the following example: ``arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`` .

          To learn how to generate a Signature Version 4 signed request, see `Authenticating Requests: Using Query Parameters (AWS Signature Version 4) <https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html>`__ and `Signature Version 4 Signing Process <https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html>`__ .

          .. note::

            If you are using an AWS SDK tool or the AWS CLI, you can specify ``SourceRegion`` (or ``--source-region`` for the AWS CLI) instead of specifying ``PreSignedUrl`` manually. Specifying ``SourceRegion`` autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source AWS Region.

            Please note that this parameter is automatically populated if it is not provided. Including this parameter is not required

        :type CopyTags: boolean
        :param CopyTags:

          A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :type SourceRegion: string
        :param SourceRegion:

          The ID of the region that contains the snapshot to be copied.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterSnapshot': {
                    'AvailabilityZones': [
                        'string',
                    ],
                    'DBClusterSnapshotIdentifier': 'string',
                    'DBClusterIdentifier': 'string',
                    'SnapshotCreateTime': datetime(2015, 1, 1),
                    'Engine': 'string',
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'VpcId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'SnapshotType': 'string',
                    'PercentProgress': 123,
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DBClusterSnapshotArn': 'string',
                    'SourceDBClusterSnapshotArn': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterSnapshot** *(dict) --*

              Contains the details for an Amazon RDS DB cluster snapshot

              This data type is used as a response element in the ``DescribeDBClusterSnapshots`` action.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.

                - *(string) --*

              - **DBClusterSnapshotIdentifier** *(string) --*

                Specifies the identifier for the DB cluster snapshot.

              - **DBClusterIdentifier** *(string) --*

                Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.

              - **SnapshotCreateTime** *(datetime) --*

                Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **Engine** *(string) --*

                Specifies the name of the database engine.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Specifies the status of this DB cluster snapshot.

              - **Port** *(integer) --*

                Specifies the port that the DB cluster was listening on at the time of the snapshot.

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB cluster snapshot.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **MasterUsername** *(string) --*

                Provides the master username for the DB cluster snapshot.

              - **EngineVersion** *(string) --*

                Provides the version of the database engine for this DB cluster snapshot.

              - **LicenseModel** *(string) --*

                Provides the license model information for this DB cluster snapshot.

              - **SnapshotType** *(string) --*

                Provides the type of the DB cluster snapshot.

              - **PercentProgress** *(integer) --*

                Specifies the percentage of the estimated data that has been transferred.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster snapshot is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.

              - **DBClusterSnapshotArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster snapshot.

              - **SourceDBClusterSnapshotArn** *(string) --*

                If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

        """
        pass

    def copy_db_parameter_group(
        self,
        SourceDBParameterGroupIdentifier: str,
        TargetDBParameterGroupIdentifier: str,
        TargetDBParameterGroupDescription: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Copies the specified DB parameter group.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup>`_

        **Request Syntax**
        ::

          response = client.copy_db_parameter_group(
              SourceDBParameterGroupIdentifier='string',
              TargetDBParameterGroupIdentifier='string',
              TargetDBParameterGroupDescription='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type SourceDBParameterGroupIdentifier: string
        :param SourceDBParameterGroupIdentifier: **[REQUIRED]**

          The identifier or ARN for the source DB parameter group. For information about creating an ARN, see `Constructing an ARN for Amazon RDS <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing>`__ in the *Amazon RDS User Guide* .

          Constraints:

          * Must specify a valid DB parameter group.

          * Must specify a valid DB parameter group identifier, for example ``my-db-param-group`` , or a valid ARN.

        :type TargetDBParameterGroupIdentifier: string
        :param TargetDBParameterGroupIdentifier: **[REQUIRED]**

          The identifier for the copied DB parameter group.

          Constraints:

          * Can't be null, empty, or blank

          * Must contain from 1 to 255 letters, numbers, or hyphens

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``my-db-parameter-group``

        :type TargetDBParameterGroupDescription: string
        :param TargetDBParameterGroupDescription: **[REQUIRED]**

          A description for the copied DB parameter group.

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBParameterGroup': {
                    'DBParameterGroupName': 'string',
                    'DBParameterGroupFamily': 'string',
                    'Description': 'string',
                    'DBParameterGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBParameterGroup** *(dict) --*

              Contains the details of an Amazon RDS DB parameter group.

              This data type is used as a response element in the ``DescribeDBParameterGroups`` action.

              - **DBParameterGroupName** *(string) --*

                Provides the name of the DB parameter group.

              - **DBParameterGroupFamily** *(string) --*

                Provides the name of the DB parameter group family that this DB parameter group is compatible with.

              - **Description** *(string) --*

                Provides the customer-specified description for this DB parameter group.

              - **DBParameterGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB parameter group.

        """
        pass

    def copy_db_snapshot(
        self,
        SourceDBSnapshotIdentifier: str,
        TargetDBSnapshotIdentifier: str,
        KmsKeyId: str = None,
        Tags: List[Any] = None,
        CopyTags: bool = None,
        PreSignedUrl: str = None,
        OptionGroupName: str = None,
        SourceRegion: str = None
    ) -> Dict[str, Any]:
        """
        Copies the specified DB snapshot. The source DB snapshot must be in the "available" state.

        You can copy a snapshot from one AWS Region to another. In that case, the AWS Region where you call the ``CopyDBSnapshot`` action is the destination AWS Region for the DB snapshot copy.

        For more information about copying snapshots, see `Copying a DB Snapshot <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopyDBSnapshot.html>`__ in the *Amazon RDS User Guide.*

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot>`_

        **Request Syntax**
        ::

          response = client.copy_db_snapshot(
              SourceDBSnapshotIdentifier='string',
              TargetDBSnapshotIdentifier='string',
              KmsKeyId='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ],
              CopyTags=True|False,
              OptionGroupName='string',
              SourceRegion='string'
          )
        :type SourceDBSnapshotIdentifier: string
        :param SourceDBSnapshotIdentifier: **[REQUIRED]**

          The identifier for the source DB snapshot.

          If the source snapshot is in the same AWS Region as the copy, specify a valid DB snapshot identifier. For example, you might specify ``rds:mysql-instance1-snapshot-20130805`` .

          If the source snapshot is in a different AWS Region than the copy, specify a valid DB snapshot ARN. For example, you might specify ``arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805`` .

          If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.

          If you are copying an encrypted snapshot this parameter must be in the ARN format for the source AWS Region, and must match the ``SourceDBSnapshotIdentifier`` in the ``PreSignedUrl`` parameter.

          Constraints:

          * Must specify a valid system snapshot in the "available" state.

          Example: ``rds:mydb-2012-04-02-00-01``

          Example: ``arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805``

        :type TargetDBSnapshotIdentifier: string
        :param TargetDBSnapshotIdentifier: **[REQUIRED]**

          The identifier for the copy of the snapshot.

          Constraints:

          * Can't be null, empty, or blank

          * Must contain from 1 to 255 letters, numbers, or hyphens

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``my-db-snapshot``

        :type KmsKeyId: string
        :param KmsKeyId:

          The AWS KMS key ID for an encrypted DB snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

          If you copy an encrypted DB snapshot from your AWS account, you can specify a value for this parameter to encrypt the copy with a new KMS encryption key. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same KMS key as the source DB snapshot.

          If you copy an encrypted DB snapshot that is shared from another AWS account, then you must specify a value for this parameter.

          If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.

          If you copy an encrypted snapshot to a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the AWS Region that they are created in, and you can't use encryption keys from one AWS Region in another AWS Region.

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :type CopyTags: boolean
        :param CopyTags:

          A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.

        :type PreSignedUrl: string
        :param PreSignedUrl:

          The URL that contains a Signature Version 4 signed request for the ``CopyDBSnapshot`` API action in the source AWS Region that contains the source DB snapshot to copy.

          You must specify this parameter when you copy an encrypted DB snapshot from another AWS Region by using the Amazon RDS API. Don't specify ``PreSignedUrl`` when you are copying an encrypted DB snapshot in the same AWS Region.

          The presigned URL must be a valid request for the ``CopyDBSnapshot`` API action that can be executed in the source AWS Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values:

          * ``DestinationRegion`` - The AWS Region that the encrypted DB snapshot is copied to. This AWS Region is the same one where the ``CopyDBSnapshot`` action is called that contains this presigned URL.  For example, if you copy an encrypted DB snapshot from the us-west-2 AWS Region to the us-east-1 AWS Region, then you call the ``CopyDBSnapshot`` action in the us-east-1 AWS Region and provide a presigned URL that contains a call to the ``CopyDBSnapshot`` action in the us-west-2 AWS Region. For this example, the ``DestinationRegion`` in the presigned URL must be set to the us-east-1 AWS Region.

          * ``KmsKeyId`` - The AWS KMS key identifier for the key to use to encrypt the copy of the DB snapshot in the destination AWS Region. This is the same identifier for both the ``CopyDBSnapshot`` action that is called in the destination AWS Region, and the action contained in the presigned URL.

          * ``SourceDBSnapshotIdentifier`` - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 AWS Region, then your ``SourceDBSnapshotIdentifier`` looks like the following example: ``arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115`` .

          To learn how to generate a Signature Version 4 signed request, see `Authenticating Requests: Using Query Parameters (AWS Signature Version 4) <https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html>`__ and `Signature Version 4 Signing Process <https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html>`__ .

          .. note::

            If you are using an AWS SDK tool or the AWS CLI, you can specify ``SourceRegion`` (or ``--source-region`` for the AWS CLI) instead of specifying ``PreSignedUrl`` manually. Specifying ``SourceRegion`` autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source AWS Region.

            Please note that this parameter is automatically populated if it is not provided. Including this parameter is not required

        :type OptionGroupName: string
        :param OptionGroupName:

          The name of an option group to associate with the copy of the snapshot.

          Specify this option if you are copying a snapshot from one AWS Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across AWS Regions. For more information, see `Option Group Considerations <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options>`__ in the *Amazon RDS User Guide.*

        :type SourceRegion: string
        :param SourceRegion:

          The ID of the region that contains the snapshot to be copied.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSnapshot': {
                    'DBSnapshotIdentifier': 'string',
                    'DBInstanceIdentifier': 'string',
                    'SnapshotCreateTime': datetime(2015, 1, 1),
                    'Engine': 'string',
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'AvailabilityZone': 'string',
                    'VpcId': 'string',
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'SnapshotType': 'string',
                    'Iops': 123,
                    'OptionGroupName': 'string',
                    'PercentProgress': 123,
                    'SourceRegion': 'string',
                    'SourceDBSnapshotIdentifier': 'string',
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'Encrypted': True|False,
                    'KmsKeyId': 'string',
                    'DBSnapshotArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DbiResourceId': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSnapshot** *(dict) --*

              Contains the details of an Amazon RDS DB snapshot.

              This data type is used as a response element in the ``DescribeDBSnapshots`` action.

              - **DBSnapshotIdentifier** *(string) --*

                Specifies the identifier for the DB snapshot.

              - **DBInstanceIdentifier** *(string) --*

                Specifies the DB instance identifier of the DB instance this DB snapshot was created from.

              - **SnapshotCreateTime** *(datetime) --*

                Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **Engine** *(string) --*

                Specifies the name of the database engine.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Specifies the status of this DB snapshot.

              - **Port** *(integer) --*

                Specifies the port that the database engine was listening on at the time of the snapshot.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB snapshot.

              - **InstanceCreateTime** *(datetime) --*

                Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **MasterUsername** *(string) --*

                Provides the master username for the DB snapshot.

              - **EngineVersion** *(string) --*

                Specifies the version of the database engine.

              - **LicenseModel** *(string) --*

                License model information for the restored DB instance.

              - **SnapshotType** *(string) --*

                Provides the type of the DB snapshot.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.

              - **OptionGroupName** *(string) --*

                Provides the option group name for the DB snapshot.

              - **PercentProgress** *(integer) --*

                The percentage of the estimated data that has been transferred.

              - **SourceRegion** *(string) --*

                The AWS Region that the DB snapshot was created in or copied from.

              - **SourceDBSnapshotIdentifier** *(string) --*

                The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has value in case of cross-customer or cross-region copy.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB snapshot.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which to associate the instance for TDE encryption.

              - **Encrypted** *(boolean) --*

                Specifies whether the DB snapshot is encrypted.

              - **KmsKeyId** *(string) --*

                If ``Encrypted`` is true, the AWS KMS key identifier for the encrypted DB snapshot.

              - **DBSnapshotArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB snapshot.

              - **Timezone** *(string) --*

                The time zone of the DB snapshot. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DbiResourceId** *(string) --*

                The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

        """
        pass

    def copy_option_group(
        self,
        SourceOptionGroupIdentifier: str,
        TargetOptionGroupIdentifier: str,
        TargetOptionGroupDescription: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Copies the specified option group.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup>`_

        **Request Syntax**
        ::

          response = client.copy_option_group(
              SourceOptionGroupIdentifier='string',
              TargetOptionGroupIdentifier='string',
              TargetOptionGroupDescription='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type SourceOptionGroupIdentifier: string
        :param SourceOptionGroupIdentifier: **[REQUIRED]**

          The identifier or ARN for the source option group. For information about creating an ARN, see `Constructing an ARN for Amazon RDS <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing>`__ in the *Amazon RDS User Guide* .

          Constraints:

          * Must specify a valid option group.

          * If the source option group is in the same AWS Region as the copy, specify a valid option group identifier, for example ``my-option-group`` , or a valid ARN.

          * If the source option group is in a different AWS Region than the copy, specify a valid option group ARN, for example ``arn:aws:rds:us-west-2:123456789012:og:special-options`` .

        :type TargetOptionGroupIdentifier: string
        :param TargetOptionGroupIdentifier: **[REQUIRED]**

          The identifier for the copied option group.

          Constraints:

          * Can't be null, empty, or blank

          * Must contain from 1 to 255 letters, numbers, or hyphens

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``my-option-group``

        :type TargetOptionGroupDescription: string
        :param TargetOptionGroupDescription: **[REQUIRED]**

          The description for the copied option group.

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'OptionGroup': {
                    'OptionGroupName': 'string',
                    'OptionGroupDescription': 'string',
                    'EngineName': 'string',
                    'MajorEngineVersion': 'string',
                    'Options': [
                        {
                            'OptionName': 'string',
                            'OptionDescription': 'string',
                            'Persistent': True|False,
                            'Permanent': True|False,
                            'Port': 123,
                            'OptionVersion': 'string',
                            'OptionSettings': [
                                {
                                    'Name': 'string',
                                    'Value': 'string',
                                    'DefaultValue': 'string',
                                    'Description': 'string',
                                    'ApplyType': 'string',
                                    'DataType': 'string',
                                    'AllowedValues': 'string',
                                    'IsModifiable': True|False,
                                    'IsCollection': True|False
                                },
                            ],
                            'DBSecurityGroupMemberships': [
                                {
                                    'DBSecurityGroupName': 'string',
                                    'Status': 'string'
                                },
                            ],
                            'VpcSecurityGroupMemberships': [
                                {
                                    'VpcSecurityGroupId': 'string',
                                    'Status': 'string'
                                },
                            ]
                        },
                    ],
                    'AllowsVpcAndNonVpcInstanceMemberships': True|False,
                    'VpcId': 'string',
                    'OptionGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **OptionGroup** *(dict) --*

              - **OptionGroupName** *(string) --*

                Specifies the name of the option group.

              - **OptionGroupDescription** *(string) --*

                Provides a description of the option group.

              - **EngineName** *(string) --*

                Indicates the name of the engine that this option group can be applied to.

              - **MajorEngineVersion** *(string) --*

                Indicates the major engine version associated with this option group.

              - **Options** *(list) --*

                Indicates what options are available in the option group.

                - *(dict) --*

                  Option details.

                  - **OptionName** *(string) --*

                    The name of the option.

                  - **OptionDescription** *(string) --*

                    The description of the option.

                  - **Persistent** *(boolean) --*

                    Indicate if this option is persistent.

                  - **Permanent** *(boolean) --*

                    Indicate if this option is permanent.

                  - **Port** *(integer) --*

                    If required, the port configured for this option to use.

                  - **OptionVersion** *(string) --*

                    The version of the option.

                  - **OptionSettings** *(list) --*

                    The option settings for this option.

                    - *(dict) --*

                      Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.

                      - **Name** *(string) --*

                        The name of the option that has settings that you can set.

                      - **Value** *(string) --*

                        The current value of the option setting.

                      - **DefaultValue** *(string) --*

                        The default value of the option setting.

                      - **Description** *(string) --*

                        The description of the option setting.

                      - **ApplyType** *(string) --*

                        The DB engine specific parameter type.

                      - **DataType** *(string) --*

                        The data type of the option setting.

                      - **AllowedValues** *(string) --*

                        The allowed values of the option setting.

                      - **IsModifiable** *(boolean) --*

                        A Boolean value that, when true, indicates the option setting can be modified from the default.

                      - **IsCollection** *(boolean) --*

                        Indicates if the option setting is part of a collection.

                  - **DBSecurityGroupMemberships** *(list) --*

                    If the option requires access to a port, then this DB security group allows access to the port.

                    - *(dict) --*

                      This data type is used as a response element in the following actions:

                      * ``ModifyDBInstance``

                      * ``RebootDBInstance``

                      * ``RestoreDBInstanceFromDBSnapshot``

                      * ``RestoreDBInstanceToPointInTime``

                      - **DBSecurityGroupName** *(string) --*

                        The name of the DB security group.

                      - **Status** *(string) --*

                        The status of the DB security group.

                  - **VpcSecurityGroupMemberships** *(list) --*

                    If the option requires access to a port, then this VPC security group allows access to the port.

                    - *(dict) --*

                      This data type is used as a response element for queries on VPC security group membership.

                      - **VpcSecurityGroupId** *(string) --*

                        The name of the VPC security group.

                      - **Status** *(string) --*

                        The status of the VPC security group.

              - **AllowsVpcAndNonVpcInstanceMemberships** *(boolean) --*

                Indicates whether this option group can be applied to both VPC and non-VPC instances. The value ``true`` indicates the option group can be applied to both VPC and non-VPC instances.

              - **VpcId** *(string) --*

                If **AllowsVpcAndNonVpcInstanceMemberships** is ``false`` , this field is blank. If **AllowsVpcAndNonVpcInstanceMemberships** is ``true`` and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field.

              - **OptionGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the option group.

        """
        pass

    def create_custom_availability_zone(
        self,
        CustomAvailabilityZoneName: str,
        ExistingVpnId: str = None,
        NewVpnTunnelName: str = None,
        VpnTunnelOriginatorIP: str = None
    ) -> Dict[str, Any]:
        """
        .. _https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html: https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html

        Creates a custom Availability Zone (AZ).

        A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster.

        For more information about RDS on VMware, see the ` *RDS on VMware User Guide.* https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html`__

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomAvailabilityZone>`_

        **Request Syntax**
        ::

          response = client.create_custom_availability_zone(
              CustomAvailabilityZoneName='string',
              ExistingVpnId='string',
              NewVpnTunnelName='string',
              VpnTunnelOriginatorIP='string'
          )
        :type CustomAvailabilityZoneName: string
        :param CustomAvailabilityZoneName: **[REQUIRED]**

          The name of the custom Availability Zone (AZ).

        :type ExistingVpnId: string
        :param ExistingVpnId:

          The ID of an existing virtual private network (VPN) between the Amazon RDS website and the VMware vSphere cluster.

        :type NewVpnTunnelName: string
        :param NewVpnTunnelName:

          The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.

          Specify this parameter only if ``ExistingVpnId`` isn't specified.

        :type VpnTunnelOriginatorIP: string
        :param VpnTunnelOriginatorIP:

          The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.

          Specify this parameter only if ``ExistingVpnId`` isn't specified.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'CustomAvailabilityZone': {
                    'CustomAvailabilityZoneId': 'string',
                    'CustomAvailabilityZoneName': 'string',
                    'CustomAvailabilityZoneStatus': 'string',
                    'VpnDetails': {
                        'VpnId': 'string',
                        'VpnTunnelOriginatorIP': 'string',
                        'VpnGatewayIp': 'string',
                        'VpnPSK': 'string',
                        'VpnName': 'string',
                        'VpnState': 'string'
                    }
                }
            }
          **Response Structure**

          - *(dict) --*

            - **CustomAvailabilityZone** *(dict) --*

              A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.

              For more information about RDS on VMware, see the ` *RDS on VMware User Guide.* https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html`__

              - **CustomAvailabilityZoneId** *(string) --*

                The identifier of the custom AZ.

                Amazon RDS generates a unique identifier when a custom AZ is created.

              - **CustomAvailabilityZoneName** *(string) --*

                The name of the custom AZ.

              - **CustomAvailabilityZoneStatus** *(string) --*

                The status of the custom AZ.

              - **VpnDetails** *(dict) --*

                Information about the virtual private network (VPN) between the VMware vSphere cluster and the AWS website.

                - **VpnId** *(string) --*

                  The ID of the VPN.

                - **VpnTunnelOriginatorIP** *(string) --*

                  The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.

                - **VpnGatewayIp** *(string) --*

                  The IP address of network traffic from AWS to your on-premises data center.

                - **VpnPSK** *(string) --*

                  The preshared key (PSK) for the VPN.

                - **VpnName** *(string) --*

                  The name of the VPN.

                - **VpnState** *(string) --*

                  The state of the VPN.

        """
        pass

    def create_db_cluster(
        self,
        DBClusterIdentifier: str,
        Engine: str,
        AvailabilityZones: List[Any] = None,
        BackupRetentionPeriod: int = None,
        CharacterSetName: str = None,
        DatabaseName: str = None,
        DBClusterParameterGroupName: str = None,
        VpcSecurityGroupIds: List[Any] = None,
        DBSubnetGroupName: str = None,
        EngineVersion: str = None,
        Port: int = None,
        MasterUsername: str = None,
        MasterUserPassword: str = None,
        OptionGroupName: str = None,
        PreferredBackupWindow: str = None,
        PreferredMaintenanceWindow: str = None,
        ReplicationSourceIdentifier: str = None,
        Tags: List[Any] = None,
        StorageEncrypted: bool = None,
        KmsKeyId: str = None,
        PreSignedUrl: str = None,
        EnableIAMDatabaseAuthentication: bool = None,
        BacktrackWindow: int = None,
        EnableCloudwatchLogsExports: List[Any] = None,
        EngineMode: str = None,
        ScalingConfiguration: Dict[str, Any] = None,
        DeletionProtection: bool = None,
        GlobalClusterIdentifier: str = None,
        EnableHttpEndpoint: bool = None,
        CopyTagsToSnapshot: bool = None,
        SourceRegion: str = None
    ) -> Dict[str, Any]:
        """
        Creates a new Amazon Aurora DB cluster.

        You can use the ``ReplicationSourceIdentifier`` parameter to create the DB cluster as a Read Replica of another DB cluster or Amazon RDS MySQL DB instance. For cross-region replication where the DB cluster identified by ``ReplicationSourceIdentifier`` is encrypted, you must also specify the ``PreSignedUrl`` parameter.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster>`_

        **Request Syntax**
        ::

          response = client.create_db_cluster(
              AvailabilityZones=[
                  'string',
              ],
              BackupRetentionPeriod=123,
              CharacterSetName='string',
              DatabaseName='string',
              DBClusterIdentifier='string',
              DBClusterParameterGroupName='string',
              VpcSecurityGroupIds=[
                  'string',
              ],
              DBSubnetGroupName='string',
              Engine='string',
              EngineVersion='string',
              Port=123,
              MasterUsername='string',
              MasterUserPassword='string',
              OptionGroupName='string',
              PreferredBackupWindow='string',
              PreferredMaintenanceWindow='string',
              ReplicationSourceIdentifier='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ],
              StorageEncrypted=True|False,
              KmsKeyId='string',
              EnableIAMDatabaseAuthentication=True|False,
              BacktrackWindow=123,
              EnableCloudwatchLogsExports=[
                  'string',
              ],
              EngineMode='string',
              ScalingConfiguration={
                  'MinCapacity': 123,
                  'MaxCapacity': 123,
                  'AutoPause': True|False,
                  'SecondsUntilAutoPause': 123,
                  'TimeoutAction': 'string'
              },
              DeletionProtection=True|False,
              GlobalClusterIdentifier='string',
              EnableHttpEndpoint=True|False,
              CopyTagsToSnapshot=True|False,
              SourceRegion='string'
          )
        :type AvailabilityZones: list
        :param AvailabilityZones:

          A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see `Choosing the Regions and Availability Zones <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html>`__ in the *Amazon Aurora User Guide* .

          - *(string) --*

        :type BackupRetentionPeriod: integer
        :param BackupRetentionPeriod:

          The number of days for which automated backups are retained.

          Default: 1

          Constraints:

          * Must be a value from 1 to 35

        :type CharacterSetName: string
        :param CharacterSetName:

          A value that indicates that the DB cluster should be associated with the specified CharacterSet.

        :type DatabaseName: string
        :param DatabaseName:

          The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon RDS will not create a database in the DB cluster you are creating.

        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The DB cluster identifier. This parameter is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 letters, numbers, or hyphens.

          * First character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          Example: ``my-cluster1``

        :type DBClusterParameterGroupName: string
        :param DBClusterParameterGroupName:

          The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.

          Constraints:

          * If supplied, must match the name of an existing DB cluster parameter group.

        :type VpcSecurityGroupIds: list
        :param VpcSecurityGroupIds:

          A list of EC2 VPC security groups to associate with this DB cluster.

          - *(string) --*

        :type DBSubnetGroupName: string
        :param DBSubnetGroupName:

          A DB subnet group to associate with this DB cluster.

          Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.

          Example: ``mySubnetgroup``

        :type Engine: string
        :param Engine: **[REQUIRED]**

          The name of the database engine to be used for this DB cluster.

          Valid Values: ``aurora`` (for MySQL 5.6-compatible Aurora), ``aurora-mysql`` (for MySQL 5.7-compatible Aurora), and ``aurora-postgresql``

        :type EngineVersion: string
        :param EngineVersion:

          The version number of the database engine to use.

          To list all of the available engine versions for ``aurora`` (for MySQL 5.6-compatible Aurora), use the following command:

           ``aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"``

          To list all of the available engine versions for ``aurora-mysql`` (for MySQL 5.7-compatible Aurora), use the following command:

           ``aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"``

          To list all of the available engine versions for ``aurora-postgresql`` , use the following command:

           ``aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"``

           **Aurora MySQL**

          Example: ``5.6.10a`` , ``5.6.mysql_aurora.1.19.2`` , ``5.7.12`` , ``5.7.mysql_aurora.2.04.5``

           **Aurora PostgreSQL**

          Example: ``9.6.3`` , ``10.7``

        :type Port: integer
        :param Port:

          The port number on which the instances in the DB cluster accept connections.

          Default: ``3306`` if engine is set as aurora or ``5432`` if set to aurora-postgresql.

        :type MasterUsername: string
        :param MasterUsername:

          The name of the master user for the DB cluster.

          Constraints:

          * Must be 1 to 16 letters or numbers.

          * First character must be a letter.

          * Can't be a reserved word for the chosen database engine.

        :type MasterUserPassword: string
        :param MasterUserPassword:

          The password for the master database user. This password can contain any printable ASCII character except "/", '"', or "@".

          Constraints: Must contain from 8 to 41 characters.

        :type OptionGroupName: string
        :param OptionGroupName:

          A value that indicates that the DB cluster should be associated with the specified option group.

          Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster.

        :type PreferredBackupWindow: string
        :param PreferredBackupWindow:

          The daily time range during which automated backups are created if automated backups are enabled using the ``BackupRetentionPeriod`` parameter.

          The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see `Adjusting the Preferred DB Cluster Maintenance Window <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora>`__ in the *Amazon Aurora User Guide.*

          Constraints:

          * Must be in the format ``hh24:mi-hh24:mi`` .

          * Must be in Universal Coordinated Time (UTC).

          * Must not conflict with the preferred maintenance window.

          * Must be at least 30 minutes.

        :type PreferredMaintenanceWindow: string
        :param PreferredMaintenanceWindow:

          The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

          Format: ``ddd:hh24:mi-ddd:hh24:mi``

          The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see `Adjusting the Preferred DB Cluster Maintenance Window <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora>`__ in the *Amazon Aurora User Guide.*

          Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

          Constraints: Minimum 30-minute window.

        :type ReplicationSourceIdentifier: string
        :param ReplicationSourceIdentifier:

          The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.

        :type Tags: list
        :param Tags:

          Tags to assign to the DB cluster.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :type StorageEncrypted: boolean
        :param StorageEncrypted:

          A value that indicates whether the DB cluster is encrypted.

        :type KmsKeyId: string
        :param KmsKeyId:

          The AWS KMS key identifier for an encrypted DB cluster.

          The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.

          If an encryption key isn't specified in ``KmsKeyId`` :

          * If ``ReplicationSourceIdentifier`` identifies an encrypted source, then Amazon RDS will use the encryption key used to encrypt the source. Otherwise, Amazon RDS will use your default encryption key.

          * If the ``StorageEncrypted`` parameter is enabled and ``ReplicationSourceIdentifier`` isn't specified, then Amazon RDS will use your default encryption key.

          AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS Region.

          If you create a Read Replica of an encrypted DB cluster in another AWS Region, you must set ``KmsKeyId`` to a KMS key ID that is valid in the destination AWS Region. This key is used to encrypt the Read Replica in that AWS Region.

        :type PreSignedUrl: string
        :param PreSignedUrl:

          A URL that contains a Signature Version 4 signed request for the ``CreateDBCluster`` action to be called in the source AWS Region where the DB cluster is replicated from. You only need to specify ``PreSignedUrl`` when you are performing cross-region replication from an encrypted DB cluster.

          The pre-signed URL must be a valid request for the ``CreateDBCluster`` API action that can be executed in the source AWS Region that contains the encrypted DB cluster to be copied.

          The pre-signed URL request must contain the following parameter values:

          * ``KmsKeyId`` - The AWS KMS key identifier for the key to use to encrypt the copy of the DB cluster in the destination AWS Region. This should refer to the same KMS key for both the ``CreateDBCluster`` action that is called in the destination AWS Region, and the action contained in the pre-signed URL.

          * ``DestinationRegion`` - The name of the AWS Region that Aurora Read Replica will be created in.

          * ``ReplicationSourceIdentifier`` - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS Region. For example, if you are copying an encrypted DB cluster from the us-west-2 AWS Region, then your ``ReplicationSourceIdentifier`` would look like Example: ``arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1`` .

          To learn how to generate a Signature Version 4 signed request, see `Authenticating Requests: Using Query Parameters (AWS Signature Version 4) <https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html>`__ and `Signature Version 4 Signing Process <https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html>`__ .

          .. note::

            If you are using an AWS SDK tool or the AWS CLI, you can specify ``SourceRegion`` (or ``--source-region`` for the AWS CLI) instead of specifying ``PreSignedUrl`` manually. Specifying ``SourceRegion`` autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source AWS Region.

            Please note that this parameter is automatically populated if it is not provided. Including this parameter is not required

        :type EnableIAMDatabaseAuthentication: boolean
        :param EnableIAMDatabaseAuthentication:

          A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.

          For more information, see `IAM Database Authentication <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html>`__ in the *Amazon Aurora User Guide.*

        :type BacktrackWindow: integer
        :param BacktrackWindow:

          The target backtrack window, in seconds. To disable backtracking, set this value to 0.

          Default: 0

          Constraints:

          * If specified, this value must be set to a number from 0 to 259,200 (72 hours).

        :type EnableCloudwatchLogsExports: list
        :param EnableCloudwatchLogsExports:

          The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see `Publishing Database Logs to Amazon CloudWatch Logs <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch>`__ in the *Amazon Aurora User Guide* .

          - *(string) --*

        :type EngineMode: string
        :param EngineMode:

          The DB engine mode of the DB cluster, either ``provisioned`` , ``serverless`` , ``parallelquery`` , ``global`` , or ``multimaster`` .

        :type ScalingConfiguration: dict
        :param ScalingConfiguration:

          For DB clusters in ``serverless`` DB engine mode, the scaling properties of the DB cluster.

          - **MinCapacity** *(integer) --*

            The minimum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

            Valid capacity values are ``1`` , ``2`` , ``4`` , ``8`` , ``16`` , ``32`` , ``64`` , ``128`` , and ``256`` .

            The minimum capacity must be less than or equal to the maximum capacity.

          - **MaxCapacity** *(integer) --*

            The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

            Valid capacity values are ``1`` , ``2`` , ``4`` , ``8`` , ``16`` , ``32`` , ``64`` , ``128`` , and ``256`` .

            The maximum capacity must be greater than or equal to the minimum capacity.

          - **AutoPause** *(boolean) --*

            A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in ``serverless`` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).

            .. note::

              If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.

          - **SecondsUntilAutoPause** *(integer) --*

            The time, in seconds, before an Aurora DB cluster in ``serverless`` mode is paused.

          - **TimeoutAction** *(string) --*

            The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

             ``ForceApplyCapacityChange`` sets the capacity to the specified value as soon as possible.

             ``RollbackCapacityChange`` , the default, ignores the capacity change if a scaling point isn't found in the timeout period.

            .. warning::

              If you specify ``ForceApplyCapacityChange`` , connections that prevent Aurora Serverless from finding a scaling point might be dropped.

            For more information, see `Autoscaling for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling>`__ in the *Amazon Aurora User Guide* .

        :type DeletionProtection: boolean
        :param DeletionProtection:

          A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.

        :type GlobalClusterIdentifier: string
        :param GlobalClusterIdentifier:

          The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.

        :type EnableHttpEndpoint: boolean
        :param EnableHttpEndpoint:

          A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.

          When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

          For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

        :type CopyTagsToSnapshot: boolean
        :param CopyTagsToSnapshot:

          A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.

        :type SourceRegion: string
        :param SourceRegion:

          The ID of the region that contains the source for the db cluster.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBCluster': {
                    'AllocatedStorage': 123,
                    'AvailabilityZones': [
                        'string',
                    ],
                    'BackupRetentionPeriod': 123,
                    'CharacterSetName': 'string',
                    'DatabaseName': 'string',
                    'DBClusterIdentifier': 'string',
                    'DBClusterParameterGroup': 'string',
                    'DBSubnetGroup': 'string',
                    'Status': 'string',
                    'PercentProgress': 'string',
                    'EarliestRestorableTime': datetime(2015, 1, 1),
                    'Endpoint': 'string',
                    'ReaderEndpoint': 'string',
                    'CustomEndpoints': [
                        'string',
                    ],
                    'MultiAZ': True|False,
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'Port': 123,
                    'MasterUsername': 'string',
                    'DBClusterOptionGroupMemberships': [
                        {
                            'DBClusterOptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'PreferredBackupWindow': 'string',
                    'PreferredMaintenanceWindow': 'string',
                    'ReplicationSourceIdentifier': 'string',
                    'ReadReplicaIdentifiers': [
                        'string',
                    ],
                    'DBClusterMembers': [
                        {
                            'DBInstanceIdentifier': 'string',
                            'IsClusterWriter': True|False,
                            'DBClusterParameterGroupStatus': 'string',
                            'PromotionTier': 123
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'HostedZoneId': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbClusterResourceId': 'string',
                    'DBClusterArn': 'string',
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'Status': 'string',
                            'FeatureName': 'string'
                        },
                    ],
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'CloneGroupId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'EarliestBacktrackTime': datetime(2015, 1, 1),
                    'BacktrackWindow': 123,
                    'BacktrackConsumedChangeRecords': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'Capacity': 123,
                    'EngineMode': 'string',
                    'ScalingConfigurationInfo': {
                        'MinCapacity': 123,
                        'MaxCapacity': 123,
                        'AutoPause': True|False,
                        'SecondsUntilAutoPause': 123,
                        'TimeoutAction': 'string'
                    },
                    'DeletionProtection': True|False,
                    'HttpEndpointEnabled': True|False,
                    'ActivityStreamMode': 'sync'|'async',
                    'ActivityStreamStatus': 'stopped'|'starting'|'started'|'stopping',
                    'ActivityStreamKmsKeyId': 'string',
                    'ActivityStreamKinesisStreamName': 'string',
                    'CopyTagsToSnapshot': True|False,
                    'CrossAccountClone': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBCluster** *(dict) --*

              Contains the details of an Amazon Aurora DB cluster.

              This data type is used as a response element in the ``DescribeDBClusters`` , ``StopDBCluster`` , and ``StartDBCluster`` actions.

              - **AllocatedStorage** *(integer) --*

                For all database engines except Amazon Aurora, ``AllocatedStorage`` specifies the allocated storage size in gibibytes (GiB). For Aurora, ``AllocatedStorage`` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.

                - *(string) --*

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this cluster is associated with.

              - **DatabaseName** *(string) --*

                Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.

              - **DBClusterIdentifier** *(string) --*

                Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

              - **DBClusterParameterGroup** *(string) --*

                Specifies the name of the DB cluster parameter group for the DB cluster.

              - **DBSubnetGroup** *(string) --*

                Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.

              - **Status** *(string) --*

                Specifies the current state of this DB cluster.

              - **PercentProgress** *(string) --*

                Specifies the progress of the operation as a percentage.

              - **EarliestRestorableTime** *(datetime) --*

                The earliest time to which a database can be restored with point-in-time restore.

              - **Endpoint** *(string) --*

                Specifies the connection endpoint for the primary instance of the DB cluster.

              - **ReaderEndpoint** *(string) --*

                The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.

                If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.

              - **CustomEndpoints** *(list) --*

                Identifies all custom endpoints associated with the cluster.

                - *(string) --*

              - **MultiAZ** *(boolean) --*

                Specifies whether the DB cluster has instances in multiple Availability Zones.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **Port** *(integer) --*

                Specifies the port that the database engine is listening on.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB cluster.

              - **DBClusterOptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB cluster.

                - *(dict) --*

                  Contains status information for a DB cluster option group.

                  - **DBClusterOptionGroupName** *(string) --*

                    Specifies the name of the DB cluster option group.

                  - **Status** *(string) --*

                    Specifies the status of the DB cluster option group.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **ReplicationSourceIdentifier** *(string) --*

                Contains the identifier of the source DB cluster if this DB cluster is a Read Replica.

              - **ReadReplicaIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB cluster.

                - *(string) --*

              - **DBClusterMembers** *(list) --*

                Provides the list of instances that make up the DB cluster.

                - *(dict) --*

                  Contains information about an instance that is part of a DB cluster.

                  - **DBInstanceIdentifier** *(string) --*

                    Specifies the instance identifier for this member of the DB cluster.

                  - **IsClusterWriter** *(boolean) --*

                    Value that is ``true`` if the cluster member is the primary instance for the DB cluster and ``false`` otherwise.

                  - **DBClusterParameterGroupStatus** *(string) --*

                    Specifies the status of the DB cluster parameter group for this member of the DB cluster.

                  - **PromotionTier** *(integer) --*

                    A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security groups that the DB cluster belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **HostedZoneId** *(string) --*

                Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is enabled, the AWS KMS key identifier for the encrypted DB cluster.

              - **DbClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **DBClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster.

              - **AssociatedRoles** *(list) --*

                Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB cluster and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB cluster.

                    * ``INVALID`` - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other AWS services on your behalf.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see  DBEngineVersion .

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                A value that indicates whether the mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.

              - **CloneGroupId** *(string) --*

                Identifies the clone group to which the DB cluster is associated.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **EarliestBacktrackTime** *(datetime) --*

                The earliest time to which a DB cluster can be backtracked.

              - **BacktrackWindow** *(integer) --*

                The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.

              - **BacktrackConsumedChangeRecords** *(integer) --*

                The number of change records stored for Backtrack.

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB cluster is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html>`__ in the *Amazon Aurora User Guide.*

                - *(string) --*

              - **Capacity** *(integer) --*

                The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.

                For more information about Aurora Serverless, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

              - **EngineMode** *(string) --*

                The DB engine mode of the DB cluster, either ``provisioned`` , ``serverless`` , ``parallelquery`` , ``global`` , or ``multimaster`` .

              - **ScalingConfigurationInfo** *(dict) --*

                Shows the scaling configuration for an Aurora DB cluster in ``serverless`` DB engine mode.

                For more information, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

                - **MinCapacity** *(integer) --*

                  The maximum capacity for the Aurora DB cluster in ``serverless`` DB engine mode.

                - **MaxCapacity** *(integer) --*

                  The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

                - **AutoPause** *(boolean) --*

                  A value that indicates whether automatic pause is allowed for the Aurora DB cluster in ``serverless`` DB engine mode.

                  When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.

                - **SecondsUntilAutoPause** *(integer) --*

                  The remaining amount of time, in seconds, before the Aurora DB cluster in ``serverless`` mode is paused. A DB cluster can be paused only when it's idle (it has no connections).

                - **TimeoutAction** *(string) --*

                  The timeout action of a call to ``ModifyCurrentDBClusterCapacity`` , either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.

              - **HttpEndpointEnabled** *(boolean) --*

                A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.

                When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

                For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

              - **ActivityStreamMode** *(string) --*

                The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.

              - **ActivityStreamStatus** *(string) --*

                The status of the database activity stream.

              - **ActivityStreamKmsKeyId** *(string) --*

                The AWS KMS key identifier used for encrypting messages in the database activity stream.

              - **ActivityStreamKinesisStreamName** *(string) --*

                The name of the Amazon Kinesis data stream used for the database activity stream.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.

              - **CrossAccountClone** *(boolean) --*

                Specifies whether the DB cluster is a clone of a DB cluster owned by a different AWS account.

        """
        pass

    def create_db_cluster_endpoint(
        self,
        DBClusterIdentifier: str,
        DBClusterEndpointIdentifier: str,
        EndpointType: str,
        StaticMembers: List[Any] = None,
        ExcludedMembers: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint>`_

        **Request Syntax**
        ::

          response = client.create_db_cluster_endpoint(
              DBClusterIdentifier='string',
              DBClusterEndpointIdentifier='string',
              EndpointType='string',
              StaticMembers=[
                  'string',
              ],
              ExcludedMembers=[
                  'string',
              ]
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.

        :type DBClusterEndpointIdentifier: string
        :param DBClusterEndpointIdentifier: **[REQUIRED]**

          The identifier to use for the new endpoint. This parameter is stored as a lowercase string.

        :type EndpointType: string
        :param EndpointType: **[REQUIRED]**

          The type of the endpoint. One of: ``READER`` , ``WRITER`` , ``ANY`` .

        :type StaticMembers: list
        :param StaticMembers:

          List of DB instance identifiers that are part of the custom endpoint group.

          - *(string) --*

        :type ExcludedMembers: list
        :param ExcludedMembers:

          List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.

          - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterEndpointIdentifier': 'string',
                'DBClusterIdentifier': 'string',
                'DBClusterEndpointResourceIdentifier': 'string',
                'Endpoint': 'string',
                'Status': 'string',
                'EndpointType': 'string',
                'CustomEndpointType': 'string',
                'StaticMembers': [
                    'string',
                ],
                'ExcludedMembers': [
                    'string',
                ],
                'DBClusterEndpointArn': 'string'
            }
          **Response Structure**

          - *(dict) --*

            This data type represents the information you need to connect to an Amazon Aurora DB cluster. This data type is used as a response element in the following actions:

            * ``CreateDBClusterEndpoint``

            * ``DescribeDBClusterEndpoints``

            * ``ModifyDBClusterEndpoint``

            * ``DeleteDBClusterEndpoint``

            For the data structure that represents Amazon RDS DB instance endpoints, see ``Endpoint`` .

            - **DBClusterEndpointIdentifier** *(string) --*

              The identifier associated with the endpoint. This parameter is stored as a lowercase string.

            - **DBClusterIdentifier** *(string) --*

              The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.

            - **DBClusterEndpointResourceIdentifier** *(string) --*

              A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.

            - **Endpoint** *(string) --*

              The DNS address of the endpoint.

            - **Status** *(string) --*

              The current status of the endpoint. One of: ``creating`` , ``available`` , ``deleting`` , ``modifying`` .

            - **EndpointType** *(string) --*

              The type of the endpoint. One of: ``READER`` , ``WRITER`` , ``CUSTOM`` .

            - **CustomEndpointType** *(string) --*

              The type associated with a custom endpoint. One of: ``READER`` , ``WRITER`` , ``ANY`` .

            - **StaticMembers** *(list) --*

              List of DB instance identifiers that are part of the custom endpoint group.

              - *(string) --*

            - **ExcludedMembers** *(list) --*

              List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.

              - *(string) --*

            - **DBClusterEndpointArn** *(string) --*

              The Amazon Resource Name (ARN) for the endpoint.

        """
        pass

    def create_db_cluster_parameter_group(
        self,
        DBClusterParameterGroupName: str,
        DBParameterGroupFamily: str,
        Description: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a new DB cluster parameter group.

        Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.

        A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using ``ModifyDBClusterParameterGroup`` . Once you've created a DB cluster parameter group, you need to associate it with your DB cluster using ``ModifyDBCluster`` . When you associate a new DB cluster parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.

        .. warning::

          After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the ``character_set_database`` parameter. You can use the *Parameter Groups* option of the `Amazon RDS console <https://console.aws.amazon.com/rds/>`__ or the ``DescribeDBClusterParameters`` action to verify that your DB cluster parameter group has been created or modified.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup>`_

        **Request Syntax**
        ::

          response = client.create_db_cluster_parameter_group(
              DBClusterParameterGroupName='string',
              DBParameterGroupFamily='string',
              Description='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type DBClusterParameterGroupName: string
        :param DBClusterParameterGroupName: **[REQUIRED]**

          The name of the DB cluster parameter group.

          Constraints:

          * Must match the name of an existing DB cluster parameter group.

          .. note::

            This value is stored as a lowercase string.

        :type DBParameterGroupFamily: string
        :param DBParameterGroupFamily: **[REQUIRED]**

          The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.

           **Aurora MySQL**

          Example: ``aurora5.6`` , ``aurora-mysql5.7``

           **Aurora PostgreSQL**

          Example: ``aurora-postgresql9.6``

        :type Description: string
        :param Description: **[REQUIRED]**

          The description for the DB cluster parameter group.

        :type Tags: list
        :param Tags:

          Tags to assign to the DB cluster parameter group.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterParameterGroup': {
                    'DBClusterParameterGroupName': 'string',
                    'DBParameterGroupFamily': 'string',
                    'Description': 'string',
                    'DBClusterParameterGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterParameterGroup** *(dict) --*

              Contains the details of an Amazon RDS DB cluster parameter group.

              This data type is used as a response element in the ``DescribeDBClusterParameterGroups`` action.

              - **DBClusterParameterGroupName** *(string) --*

                Provides the name of the DB cluster parameter group.

              - **DBParameterGroupFamily** *(string) --*

                Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.

              - **Description** *(string) --*

                Provides the customer-specified description for this DB cluster parameter group.

              - **DBClusterParameterGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster parameter group.

        """
        pass

    def create_db_cluster_snapshot(
        self,
        DBClusterSnapshotIdentifier: str,
        DBClusterIdentifier: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a snapshot of a DB cluster. For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot>`_

        **Request Syntax**
        ::

          response = client.create_db_cluster_snapshot(
              DBClusterSnapshotIdentifier='string',
              DBClusterIdentifier='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type DBClusterSnapshotIdentifier: string
        :param DBClusterSnapshotIdentifier: **[REQUIRED]**

          The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 letters, numbers, or hyphens.

          * First character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          Example: ``my-cluster1-snapshot1``

        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.

          Constraints:

          * Must match the identifier of an existing DBCluster.

          Example: ``my-cluster1``

        :type Tags: list
        :param Tags:

          The tags to be assigned to the DB cluster snapshot.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterSnapshot': {
                    'AvailabilityZones': [
                        'string',
                    ],
                    'DBClusterSnapshotIdentifier': 'string',
                    'DBClusterIdentifier': 'string',
                    'SnapshotCreateTime': datetime(2015, 1, 1),
                    'Engine': 'string',
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'VpcId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'SnapshotType': 'string',
                    'PercentProgress': 123,
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DBClusterSnapshotArn': 'string',
                    'SourceDBClusterSnapshotArn': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterSnapshot** *(dict) --*

              Contains the details for an Amazon RDS DB cluster snapshot

              This data type is used as a response element in the ``DescribeDBClusterSnapshots`` action.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.

                - *(string) --*

              - **DBClusterSnapshotIdentifier** *(string) --*

                Specifies the identifier for the DB cluster snapshot.

              - **DBClusterIdentifier** *(string) --*

                Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.

              - **SnapshotCreateTime** *(datetime) --*

                Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **Engine** *(string) --*

                Specifies the name of the database engine.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Specifies the status of this DB cluster snapshot.

              - **Port** *(integer) --*

                Specifies the port that the DB cluster was listening on at the time of the snapshot.

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB cluster snapshot.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **MasterUsername** *(string) --*

                Provides the master username for the DB cluster snapshot.

              - **EngineVersion** *(string) --*

                Provides the version of the database engine for this DB cluster snapshot.

              - **LicenseModel** *(string) --*

                Provides the license model information for this DB cluster snapshot.

              - **SnapshotType** *(string) --*

                Provides the type of the DB cluster snapshot.

              - **PercentProgress** *(integer) --*

                Specifies the percentage of the estimated data that has been transferred.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster snapshot is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.

              - **DBClusterSnapshotArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster snapshot.

              - **SourceDBClusterSnapshotArn** *(string) --*

                If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

        """
        pass

    def create_db_instance(
        self,
        DBInstanceIdentifier: str,
        DBInstanceClass: str,
        Engine: str,
        DBName: str = None,
        AllocatedStorage: int = None,
        MasterUsername: str = None,
        MasterUserPassword: str = None,
        DBSecurityGroups: List[Any] = None,
        VpcSecurityGroupIds: List[Any] = None,
        AvailabilityZone: str = None,
        DBSubnetGroupName: str = None,
        PreferredMaintenanceWindow: str = None,
        DBParameterGroupName: str = None,
        BackupRetentionPeriod: int = None,
        PreferredBackupWindow: str = None,
        Port: int = None,
        MultiAZ: bool = None,
        EngineVersion: str = None,
        AutoMinorVersionUpgrade: bool = None,
        LicenseModel: str = None,
        Iops: int = None,
        OptionGroupName: str = None,
        CharacterSetName: str = None,
        PubliclyAccessible: bool = None,
        Tags: List[Any] = None,
        DBClusterIdentifier: str = None,
        StorageType: str = None,
        TdeCredentialArn: str = None,
        TdeCredentialPassword: str = None,
        StorageEncrypted: bool = None,
        KmsKeyId: str = None,
        Domain: str = None,
        CopyTagsToSnapshot: bool = None,
        MonitoringInterval: int = None,
        MonitoringRoleArn: str = None,
        DomainIAMRoleName: str = None,
        PromotionTier: int = None,
        Timezone: str = None,
        EnableIAMDatabaseAuthentication: bool = None,
        EnablePerformanceInsights: bool = None,
        PerformanceInsightsKMSKeyId: str = None,
        PerformanceInsightsRetentionPeriod: int = None,
        EnableCloudwatchLogsExports: List[Any] = None,
        ProcessorFeatures: List[Any] = None,
        DeletionProtection: bool = None,
        MaxAllocatedStorage: int = None
    ) -> Dict[str, Any]:
        """
        .. _https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html: https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html

        Creates a new DB instance.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance>`_

        **Request Syntax**
        ::

          response = client.create_db_instance(
              DBName='string',
              DBInstanceIdentifier='string',
              AllocatedStorage=123,
              DBInstanceClass='string',
              Engine='string',
              MasterUsername='string',
              MasterUserPassword='string',
              DBSecurityGroups=[
                  'string',
              ],
              VpcSecurityGroupIds=[
                  'string',
              ],
              AvailabilityZone='string',
              DBSubnetGroupName='string',
              PreferredMaintenanceWindow='string',
              DBParameterGroupName='string',
              BackupRetentionPeriod=123,
              PreferredBackupWindow='string',
              Port=123,
              MultiAZ=True|False,
              EngineVersion='string',
              AutoMinorVersionUpgrade=True|False,
              LicenseModel='string',
              Iops=123,
              OptionGroupName='string',
              CharacterSetName='string',
              PubliclyAccessible=True|False,
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ],
              DBClusterIdentifier='string',
              StorageType='string',
              TdeCredentialArn='string',
              TdeCredentialPassword='string',
              StorageEncrypted=True|False,
              KmsKeyId='string',
              Domain='string',
              CopyTagsToSnapshot=True|False,
              MonitoringInterval=123,
              MonitoringRoleArn='string',
              DomainIAMRoleName='string',
              PromotionTier=123,
              Timezone='string',
              EnableIAMDatabaseAuthentication=True|False,
              EnablePerformanceInsights=True|False,
              PerformanceInsightsKMSKeyId='string',
              PerformanceInsightsRetentionPeriod=123,
              EnableCloudwatchLogsExports=[
                  'string',
              ],
              ProcessorFeatures=[
                  {
                      'Name': 'string',
                      'Value': 'string'
                  },
              ],
              DeletionProtection=True|False,
              MaxAllocatedStorage=123
          )
        :type DBName: string
        :param DBName:

          The meaning of this parameter differs according to the database engine you use.

           **MySQL**

          The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.

          Constraints:

          * Must contain 1 to 64 letters or numbers.

          * Can't be a word reserved by the specified database engine

           **MariaDB**

          The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.

          Constraints:

          * Must contain 1 to 64 letters or numbers.

          * Can't be a word reserved by the specified database engine

           **PostgreSQL**

          The name of the database to create when the DB instance is created. If this parameter isn't specified, the default "postgres" database is created in the DB instance.

          Constraints:

          * Must contain 1 to 63 letters, numbers, or underscores.

          * Must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0-9).

          * Can't be a word reserved by the specified database engine

           **Oracle**

          The Oracle System ID (SID) of the created DB instance. If you specify ``null`` , the default value ``ORCL`` is used. You can't specify the string NULL, or any other reserved word, for ``DBName`` .

          Default: ``ORCL``

          Constraints:

          * Can't be longer than 8 characters

           **SQL Server**

          Not applicable. Must be null.

           **Amazon Aurora**

          The name of the database to create when the primary instance of the DB cluster is created. If this parameter isn't specified, no database is created in the DB instance.

          Constraints:

          * Must contain 1 to 64 letters or numbers.

          * Can't be a word reserved by the specified database engine

        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The DB instance identifier. This parameter is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 letters, numbers, or hyphens.

          * First character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          Example: ``mydbinstance``

        :type AllocatedStorage: integer
        :param AllocatedStorage:

          The amount of storage (in gibibytes) to allocate for the DB instance.

          Type: Integer

           **Amazon Aurora**

          Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.

           **MySQL**

          Constraints to the amount of storage for each storage type are the following:

          * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.

          * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.

          * Magnetic storage (standard): Must be an integer from 5 to 3072.

           **MariaDB**

          Constraints to the amount of storage for each storage type are the following:

          * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.

          * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.

          * Magnetic storage (standard): Must be an integer from 5 to 3072.

           **PostgreSQL**

          Constraints to the amount of storage for each storage type are the following:

          * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.

          * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.

          * Magnetic storage (standard): Must be an integer from 5 to 3072.

           **Oracle**

          Constraints to the amount of storage for each storage type are the following:

          * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.

          * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.

          * Magnetic storage (standard): Must be an integer from 10 to 3072.

           **SQL Server**

          Constraints to the amount of storage for each storage type are the following:

          * General Purpose (SSD) storage (gp2):

            * Enterprise and Standard editions: Must be an integer from 200 to 16384.

            * Web and Express editions: Must be an integer from 20 to 16384.

          * Provisioned IOPS storage (io1):

            * Enterprise and Standard editions: Must be an integer from 200 to 16384.

            * Web and Express editions: Must be an integer from 100 to 16384.

          * Magnetic storage (standard):

            * Enterprise and Standard editions: Must be an integer from 200 to 1024.

            * Web and Express editions: Must be an integer from 20 to 1024.

        :type DBInstanceClass: string
        :param DBInstanceClass: **[REQUIRED]**

          The compute and memory capacity of the DB instance, for example, ``db.m4.large`` . Not all DB instance classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see `DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html>`__ in the *Amazon RDS User Guide.*

        :type Engine: string
        :param Engine: **[REQUIRED]**

          The name of the database engine to be used for this instance.

          Not every database engine is available for every AWS Region.

          Valid Values:

          * ``aurora`` (for MySQL 5.6-compatible Aurora)

          * ``aurora-mysql`` (for MySQL 5.7-compatible Aurora)

          * ``aurora-postgresql``

          * ``mariadb``

          * ``mysql``

          * ``oracle-ee``

          * ``oracle-se2``

          * ``oracle-se1``

          * ``oracle-se``

          * ``postgres``

          * ``sqlserver-ee``

          * ``sqlserver-se``

          * ``sqlserver-ex``

          * ``sqlserver-web``

        :type MasterUsername: string
        :param MasterUsername:

          The name for the master user.

           **Amazon Aurora**

          Not applicable. The name for the master user is managed by the DB cluster.

           **MariaDB**

          Constraints:

          * Required for MariaDB.

          * Must be 1 to 16 letters or numbers.

          * Can't be a reserved word for the chosen database engine.

           **Microsoft SQL Server**

          Constraints:

          * Required for SQL Server.

          * Must be 1 to 128 letters or numbers.

          * The first character must be a letter.

          * Can't be a reserved word for the chosen database engine.

           **MySQL**

          Constraints:

          * Required for MySQL.

          * Must be 1 to 16 letters or numbers.

          * First character must be a letter.

          * Can't be a reserved word for the chosen database engine.

           **Oracle**

          Constraints:

          * Required for Oracle.

          * Must be 1 to 30 letters or numbers.

          * First character must be a letter.

          * Can't be a reserved word for the chosen database engine.

           **PostgreSQL**

          Constraints:

          * Required for PostgreSQL.

          * Must be 1 to 63 letters or numbers.

          * First character must be a letter.

          * Can't be a reserved word for the chosen database engine.

        :type MasterUserPassword: string
        :param MasterUserPassword:

          The password for the master user. The password can include any printable ASCII character except "/", '"', or "@".

           **Amazon Aurora**

          Not applicable. The password for the master user is managed by the DB cluster.

           **MariaDB**

          Constraints: Must contain from 8 to 41 characters.

           **Microsoft SQL Server**

          Constraints: Must contain from 8 to 128 characters.

           **MySQL**

          Constraints: Must contain from 8 to 41 characters.

           **Oracle**

          Constraints: Must contain from 8 to 30 characters.

           **PostgreSQL**

          Constraints: Must contain from 8 to 128 characters.

        :type DBSecurityGroups: list
        :param DBSecurityGroups:

          A list of DB security groups to associate with this DB instance.

          Default: The default DB security group for the database engine.

          - *(string) --*

        :type VpcSecurityGroupIds: list
        :param VpcSecurityGroupIds:

          A list of Amazon EC2 VPC security groups to associate with this DB instance.

           **Amazon Aurora**

          Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.

          Default: The default EC2 VPC security group for the DB subnet group's VPC.

          - *(string) --*

        :type AvailabilityZone: string
        :param AvailabilityZone:

          The Availability Zone (AZ) where the database will be created. For information on AWS Regions and Availability Zones, see `Regions and Availability Zones <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html>`__ .

          Default: A random, system-chosen Availability Zone in the endpoint's AWS Region.

          Example: ``us-east-1d``

          Constraint: The ``AvailabilityZone`` parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same AWS Region as the current endpoint.

          .. note::

            If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom Availability Zone to create the DB instance in.

            For more information about RDS on VMware, see the ` *RDS on VMware User Guide.* https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html`__

        :type DBSubnetGroupName: string
        :param DBSubnetGroupName:

          A DB subnet group to associate with this DB instance.

          If there is no DB subnet group, then it is a non-VPC DB instance.

        :type PreferredMaintenanceWindow: string
        :param PreferredMaintenanceWindow:

          The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see `Amazon RDS Maintenance Window <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance>`__ .

          Format: ``ddd:hh24:mi-ddd:hh24:mi``

          The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week.

          Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

          Constraints: Minimum 30-minute window.

        :type DBParameterGroupName: string
        :param DBParameterGroupName:

          The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the default DB parameter group for the specified DB engine and version is used.

          Constraints:

          * Must be 1 to 255 letters, numbers, or hyphens.

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

        :type BackupRetentionPeriod: integer
        :param BackupRetentionPeriod:

          The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.

           **Amazon Aurora**

          Not applicable. The retention period for automated backups is managed by the DB cluster.

          Default: 1

          Constraints:

          * Must be a value from 0 to 35

          * Can't be set to 0 if the DB instance is a source to Read Replicas

        :type PreferredBackupWindow: string
        :param PreferredBackupWindow:

          The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter. For more information, see `The Backup Window <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow>`__ in the *Amazon RDS User Guide* .

           **Amazon Aurora**

          Not applicable. The daily time range for creating automated backups is managed by the DB cluster.

          The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see `Adjusting the Preferred DB Instance Maintenance Window <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow>`__ in the *Amazon RDS User Guide* .

          Constraints:

          * Must be in the format ``hh24:mi-hh24:mi`` .

          * Must be in Universal Coordinated Time (UTC).

          * Must not conflict with the preferred maintenance window.

          * Must be at least 30 minutes.

        :type Port: integer
        :param Port:

          The port number on which the database accepts connections.

           **MySQL**

          Default: ``3306``

          Valid Values: ``1150-65535``

          Type: Integer

           **MariaDB**

          Default: ``3306``

          Valid Values: ``1150-65535``

          Type: Integer

           **PostgreSQL**

          Default: ``5432``

          Valid Values: ``1150-65535``

          Type: Integer

           **Oracle**

          Default: ``1521``

          Valid Values: ``1150-65535``

           **SQL Server**

          Default: ``1433``

          Valid Values: ``1150-65535`` except for ``1434`` , ``3389`` , ``47001`` , ``49152`` , and ``49152`` through ``49156`` .

           **Amazon Aurora**

          Default: ``3306``

          Valid Values: ``1150-65535``

          Type: Integer

        :type MultiAZ: boolean
        :param MultiAZ:

          A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the ``AvailabilityZone`` parameter if the DB instance is a Multi-AZ deployment.

        :type EngineVersion: string
        :param EngineVersion:

          The version number of the database engine to use.

          For a list of valid engine versions, use the ``DescribeDBEngineVersions`` action.

          The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.

           **Amazon Aurora**

          Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.

           **MariaDB**

          See `MariaDB on Amazon RDS Versions <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt>`__ in the *Amazon RDS User Guide.*

           **Microsoft SQL Server**

          See `Version and Feature Support on Amazon RDS <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport>`__ in the *Amazon RDS User Guide.*

           **MySQL**

          See `MySQL on Amazon RDS Versions <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt>`__ in the *Amazon RDS User Guide.*

           **Oracle**

          See `Oracle Database Engine Release Notes <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html>`__ in the *Amazon RDS User Guide.*

           **PostgreSQL**

          See `Supported PostgreSQL Database Versions <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions>`__ in the *Amazon RDS User Guide.*

        :type AutoMinorVersionUpgrade: boolean
        :param AutoMinorVersionUpgrade:

          A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.

        :type LicenseModel: string
        :param LicenseModel:

          License model information for this DB instance.

          Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

        :type Iops: integer
        :param Iops:

          The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance. For information about valid Iops values, see `Amazon RDS Provisioned IOPS Storage to Improve Performance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS>`__ in the *Amazon RDS User Guide* .

          Constraints: Must be a multiple between 1 and 50 of the storage amount for the DB instance.

        :type OptionGroupName: string
        :param OptionGroupName:

          Indicates that the DB instance should be associated with the specified option group.

          Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance

        :type CharacterSetName: string
        :param CharacterSetName:

          For supported engines, indicates that the DB instance should be associated with the specified CharacterSet.

           **Amazon Aurora**

          Not applicable. The character set is managed by the DB cluster. For more information, see ``CreateDBCluster`` .

        :type PubliclyAccessible: boolean
        :param PubliclyAccessible:

          A value that indicates whether the DB instance is publicly accessible. When the DB instance is publicly accessible, it is an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. When the DB instance isn't publicly accessible, it is an internal instance with a DNS name that resolves to a private IP address.

          Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.

          If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:

          * If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB instance is private.

          * If the default VPC in the target region has an Internet gateway attached to it, the DB instance is public.

          If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:

          * If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance is private.

          * If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is public.

        :type Tags: list
        :param Tags:

          Tags to assign to the DB instance.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :type DBClusterIdentifier: string
        :param DBClusterIdentifier:

          The identifier of the DB cluster that the instance will belong to.

        :type StorageType: string
        :param StorageType:

          Specifies the storage type to be associated with the DB instance.

          Valid values: ``standard | gp2 | io1``

          If you specify ``io1`` , you must also include a value for the ``Iops`` parameter.

          Default: ``io1`` if the ``Iops`` parameter is specified, otherwise ``gp2``

        :type TdeCredentialArn: string
        :param TdeCredentialArn:

          The ARN from the key store with which to associate the instance for TDE encryption.

        :type TdeCredentialPassword: string
        :param TdeCredentialPassword:

          The password for the given ARN from the key store in order to access the device.

        :type StorageEncrypted: boolean
        :param StorageEncrypted:

          A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.

           **Amazon Aurora**

          Not applicable. The encryption for DB instances is managed by the DB cluster.

        :type KmsKeyId: string
        :param KmsKeyId:

          The AWS KMS key identifier for an encrypted DB instance.

          The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same AWS account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.

           **Amazon Aurora**

          Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see ``CreateDBCluster`` .

          If ``StorageEncrypted`` is enabled, and you do not specify a value for the ``KmsKeyId`` parameter, then Amazon RDS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS Region.

        :type Domain: string
        :param Domain:

          The Active Directory directory ID to create the DB instance in. Currently, only Microsoft SQL Server and Oracle DB instances can be created in an Active Directory Domain.

          For Microsoft SQL Server DB instances, Amazon RDS can use Windows Authentication to authenticate users that connect to the DB instance. For more information, see `Using Windows Authentication with an Amazon RDS DB Instance Running Microsoft SQL Server <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_SQLServerWinAuth.html>`__ in the *Amazon RDS User Guide* .

          For Oracle DB instance, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB instance. For more information, see `Using Kerberos Authentication with Amazon RDS for Oracle <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-kerberos.html>`__ in the *Amazon RDS User Guide* .

        :type CopyTagsToSnapshot: boolean
        :param CopyTagsToSnapshot:

          A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.

           **Amazon Aurora**

          Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.

        :type MonitoringInterval: integer
        :param MonitoringInterval:

          The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.

          If ``MonitoringRoleArn`` is specified, then you must also set ``MonitoringInterval`` to a value other than 0.

          Valid Values: ``0, 1, 5, 10, 15, 30, 60``

        :type MonitoringRoleArn: string
        :param MonitoringRoleArn:

          The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess`` . For information on creating a monitoring role, go to `Setting Up and Enabling Enhanced Monitoring <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling>`__ in the *Amazon RDS User Guide* .

          If ``MonitoringInterval`` is set to a value other than 0, then you must supply a ``MonitoringRoleArn`` value.

        :type DomainIAMRoleName: string
        :param DomainIAMRoleName:

          Specify the name of the IAM role to be used when making API calls to the Directory Service.

        :type PromotionTier: integer
        :param PromotionTier:

          A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

          Default: 1

          Valid Values: 0 - 15

        :type Timezone: string
        :param Timezone:

          The time zone of the DB instance. The time zone parameter is currently supported only by `Microsoft SQL Server <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone>`__ .

        :type EnableIAMDatabaseAuthentication: boolean
        :param EnableIAMDatabaseAuthentication:

          A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.

          You can enable IAM database authentication for the following database engines:

           **Amazon Aurora**

          Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.

           **MySQL**

          * For MySQL 5.6, minor version 5.6.34 or higher

          * For MySQL 5.7, minor version 5.7.16 or higher

          * For MySQL 8.0, minor version 8.0.16 or higher

           **PostgreSQL**

          * For PostgreSQL 9.5, minor version 9.5.15 or higher

          * For PostgreSQL 9.6, minor version 9.6.11 or higher

          * PostgreSQL 10.6, 10.7, and 10.9

          For more information, see `IAM Database Authentication for MySQL and PostgreSQL <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html>`__ in the *Amazon RDS User Guide.*

        :type EnablePerformanceInsights: boolean
        :param EnablePerformanceInsights:

          A value that indicates whether to enable Performance Insights for the DB instance.

          For more information, see `Using Amazon Performance Insights <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html>`__ in the *Amazon Relational Database Service User Guide* .

        :type PerformanceInsightsKMSKeyId: string
        :param PerformanceInsightsKMSKeyId:

          The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

          If you do not specify a value for ``PerformanceInsightsKMSKeyId`` , then Amazon RDS uses your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS Region.

        :type PerformanceInsightsRetentionPeriod: integer
        :param PerformanceInsightsRetentionPeriod:

          The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

        :type EnableCloudwatchLogsExports: list
        :param EnableCloudwatchLogsExports:

          The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see `Publishing Database Logs to Amazon CloudWatch Logs <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch>`__ in the *Amazon Relational Database Service User Guide* .

          - *(string) --*

        :type ProcessorFeatures: list
        :param ProcessorFeatures:

          The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

          - *(dict) --*

            Contains the processor features of a DB instance class.

            To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

            You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

            * ``CreateDBInstance``

            * ``ModifyDBInstance``

            * ``RestoreDBInstanceFromDBSnapshot``

            * ``RestoreDBInstanceFromS3``

            * ``RestoreDBInstanceToPointInTime``

            You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

            In addition, you can use the following actions for DB instance class processor information:

            * ``DescribeDBInstances``

            * ``DescribeDBSnapshots``

            * ``DescribeValidDBInstanceModifications``

            For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

            - **Name** *(string) --*

              The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

            - **Value** *(string) --*

              The value of a processor feature name.

        :type DeletionProtection: boolean
        :param DeletionProtection:

          A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

        :type MaxAllocatedStorage: integer
        :param MaxAllocatedStorage:

          The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBInstance': {
                    'DBInstanceIdentifier': 'string',
                    'DBInstanceClass': 'string',
                    'Engine': 'string',
                    'DBInstanceStatus': 'string',
                    'MasterUsername': 'string',
                    'DBName': 'string',
                    'Endpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'AllocatedStorage': 123,
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'PreferredBackupWindow': 'string',
                    'BackupRetentionPeriod': 123,
                    'DBSecurityGroups': [
                        {
                            'DBSecurityGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'DBParameterGroups': [
                        {
                            'DBParameterGroupName': 'string',
                            'ParameterApplyStatus': 'string'
                        },
                    ],
                    'AvailabilityZone': 'string',
                    'DBSubnetGroup': {
                        'DBSubnetGroupName': 'string',
                        'DBSubnetGroupDescription': 'string',
                        'VpcId': 'string',
                        'SubnetGroupStatus': 'string',
                        'Subnets': [
                            {
                                'SubnetIdentifier': 'string',
                                'SubnetAvailabilityZone': {
                                    'Name': 'string'
                                },
                                'SubnetStatus': 'string'
                            },
                        ],
                        'DBSubnetGroupArn': 'string'
                    },
                    'PreferredMaintenanceWindow': 'string',
                    'PendingModifiedValues': {
                        'DBInstanceClass': 'string',
                        'AllocatedStorage': 123,
                        'MasterUserPassword': 'string',
                        'Port': 123,
                        'BackupRetentionPeriod': 123,
                        'MultiAZ': True|False,
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'DBInstanceIdentifier': 'string',
                        'StorageType': 'string',
                        'CACertificateIdentifier': 'string',
                        'DBSubnetGroupName': 'string',
                        'PendingCloudwatchLogsExports': {
                            'LogTypesToEnable': [
                                'string',
                            ],
                            'LogTypesToDisable': [
                                'string',
                            ]
                        },
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ]
                    },
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'MultiAZ': True|False,
                    'EngineVersion': 'string',
                    'AutoMinorVersionUpgrade': True|False,
                    'ReadReplicaSourceDBInstanceIdentifier': 'string',
                    'ReadReplicaDBInstanceIdentifiers': [
                        'string',
                    ],
                    'ReadReplicaDBClusterIdentifiers': [
                        'string',
                    ],
                    'LicenseModel': 'string',
                    'Iops': 123,
                    'OptionGroupMemberships': [
                        {
                            'OptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'CharacterSetName': 'string',
                    'SecondaryAvailabilityZone': 'string',
                    'PubliclyAccessible': True|False,
                    'StatusInfos': [
                        {
                            'StatusType': 'string',
                            'Normal': True|False,
                            'Status': 'string',
                            'Message': 'string'
                        },
                    ],
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'DbInstancePort': 123,
                    'DBClusterIdentifier': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbiResourceId': 'string',
                    'CACertificateIdentifier': 'string',
                    'DomainMemberships': [
                        {
                            'Domain': 'string',
                            'Status': 'string',
                            'FQDN': 'string',
                            'IAMRoleName': 'string'
                        },
                    ],
                    'CopyTagsToSnapshot': True|False,
                    'MonitoringInterval': 123,
                    'EnhancedMonitoringResourceArn': 'string',
                    'MonitoringRoleArn': 'string',
                    'PromotionTier': 123,
                    'DBInstanceArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'PerformanceInsightsEnabled': True|False,
                    'PerformanceInsightsKMSKeyId': 'string',
                    'PerformanceInsightsRetentionPeriod': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DeletionProtection': True|False,
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'FeatureName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'ListenerEndpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'MaxAllocatedStorage': 123
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBInstance** *(dict) --*

              Contains the details of an Amazon RDS DB instance.

              This data type is used as a response element in the ``DescribeDBInstances`` action.

              - **DBInstanceIdentifier** *(string) --*

                Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.

              - **DBInstanceClass** *(string) --*

                Contains the name of the compute and memory capacity class of the DB instance.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB instance.

              - **DBInstanceStatus** *(string) --*

                Specifies the current state of this database.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB instance.

              - **DBName** *(string) --*

                The meaning of this parameter differs according to the database engine you use.

                 **MySQL, MariaDB, SQL Server, PostgreSQL**

                Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.

                Type: String

                 **Oracle**

                Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.

              - **Endpoint** *(dict) --*

                Specifies the connection endpoint.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size specified in gibibytes.

              - **InstanceCreateTime** *(datetime) --*

                Provides the date and time the DB instance was created.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **DBSecurityGroups** *(list) --*

                A list of DB security group elements containing ``DBSecurityGroup.Name`` and ``DBSecurityGroup.Status`` subelements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceToPointInTime``

                  - **DBSecurityGroupName** *(string) --*

                    The name of the DB security group.

                  - **Status** *(string) --*

                    The status of the DB security group.

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security group elements that the DB instance belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **DBParameterGroups** *(list) --*

                Provides the list of DB parameter groups applied to this DB instance.

                - *(dict) --*

                  The status of the DB parameter group.

                  This data type is used as a response element in the following actions:

                  * ``CreateDBInstance``

                  * ``CreateDBInstanceReadReplica``

                  * ``DeleteDBInstance``

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  - **DBParameterGroupName** *(string) --*

                    The name of the DB parameter group.

                  - **ParameterApplyStatus** *(string) --*

                    The status of parameter updates.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance is located in.

              - **DBSubnetGroup** *(dict) --*

                Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.

                - **DBSubnetGroupName** *(string) --*

                  The name of the DB subnet group.

                - **DBSubnetGroupDescription** *(string) --*

                  Provides the description of the DB subnet group.

                - **VpcId** *(string) --*

                  Provides the VpcId of the DB subnet group.

                - **SubnetGroupStatus** *(string) --*

                  Provides the status of the DB subnet group.

                - **Subnets** *(list) --*

                  Contains a list of ``Subnet`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                    - **SubnetIdentifier** *(string) --*

                      Specifies the identifier of the subnet.

                    - **SubnetAvailabilityZone** *(dict) --*

                      Contains Availability Zone information.

                      This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                      - **Name** *(string) --*

                        The name of the Availability Zone.

                    - **SubnetStatus** *(string) --*

                      Specifies the status of the subnet.

                - **DBSubnetGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB subnet group.

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **PendingModifiedValues** *(dict) --*

                Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.

                - **DBInstanceClass** *(string) --*

                  Contains the new ``DBInstanceClass`` for the DB instance that will be applied or is currently being applied.

                - **AllocatedStorage** *(integer) --*

                  Contains the new ``AllocatedStorage`` size for the DB instance that will be applied or is currently being applied.

                - **MasterUserPassword** *(string) --*

                  Contains the pending or currently-in-progress change of the master credentials for the DB instance.

                - **Port** *(integer) --*

                  Specifies the pending port for the DB instance.

                - **BackupRetentionPeriod** *(integer) --*

                  Specifies the pending number of days for which automated backups are retained.

                - **MultiAZ** *(boolean) --*

                  Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **LicenseModel** *(string) --*

                  The license model for the DB instance.

                  Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

                - **Iops** *(integer) --*

                  Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.

                - **DBInstanceIdentifier** *(string) --*

                  Contains the new ``DBInstanceIdentifier`` for the DB instance that will be applied or is currently being applied.

                - **StorageType** *(string) --*

                  Specifies the storage type to be associated with the DB instance.

                - **CACertificateIdentifier** *(string) --*

                  Specifies the identifier of the CA certificate for the DB instance.

                - **DBSubnetGroupName** *(string) --*

                  The new DB subnet group for the DB instance.

                - **PendingCloudwatchLogsExports** *(dict) --*

                  A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.

                  - **LogTypesToEnable** *(list) --*

                    Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.

                    - *(string) --*

                  - **LogTypesToDisable** *(list) --*

                    Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.

                    - *(string) --*

                - **ProcessorFeatures** *(list) --*

                  The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                  - *(dict) --*

                    Contains the processor features of a DB instance class.

                    To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                    You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                    * ``CreateDBInstance``

                    * ``ModifyDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceFromS3``

                    * ``RestoreDBInstanceToPointInTime``

                    You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                    In addition, you can use the following actions for DB instance class processor information:

                    * ``DescribeDBInstances``

                    * ``DescribeDBSnapshots``

                    * ``DescribeValidDBInstanceModifications``

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **Value** *(string) --*

                      The value of a processor feature name.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **MultiAZ** *(boolean) --*

                Specifies if the DB instance is a Multi-AZ deployment.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **AutoMinorVersionUpgrade** *(boolean) --*

                Indicates that minor version patches are applied automatically.

              - **ReadReplicaSourceDBInstanceIdentifier** *(string) --*

                Contains the identifier of the source DB instance if this DB instance is a Read Replica.

              - **ReadReplicaDBInstanceIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB instance.

                - *(string) --*

              - **ReadReplicaDBClusterIdentifiers** *(list) --*

                Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a Read Replica. For example, when you create an Aurora Read Replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster for the Aurora Read Replica is shown. This output does not contain information about cross region Aurora Read Replicas.

                .. note::

                  Currently, each RDS DB instance can have only one Aurora Read Replica.

                - *(string) --*

              - **LicenseModel** *(string) --*

                License model information for this DB instance.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value.

              - **OptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB instance.

                - *(dict) --*

                  Provides information on the option groups the DB instance is a member of.

                  - **OptionGroupName** *(string) --*

                    The name of the option group that the instance belongs to.

                  - **Status** *(string) --*

                    The status of the DB instance's option group membership. Valid values are: ``in-sync`` , ``pending-apply`` , ``pending-removal`` , ``pending-maintenance-apply`` , ``pending-maintenance-removal`` , ``applying`` , ``removing`` , and ``failed`` .

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this instance is associated with.

              - **SecondaryAvailabilityZone** *(string) --*

                If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.

              - **PubliclyAccessible** *(boolean) --*

                Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address.

              - **StatusInfos** *(list) --*

                The status of a Read Replica. If the instance isn't a Read Replica, this is blank.

                - *(dict) --*

                  Provides a list of status information for a DB instance.

                  - **StatusType** *(string) --*

                    This value is currently "read replication."

                  - **Normal** *(boolean) --*

                    Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.

                  - **Status** *(string) --*

                    Status of the DB instance. For a StatusType of Read Replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.

                  - **Message** *(string) --*

                    Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB instance.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which the instance is associated for TDE encryption.

              - **DbInstancePort** *(integer) --*

                Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.

              - **DBClusterIdentifier** *(string) --*

                If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB instance is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB instance.

              - **DbiResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.

              - **CACertificateIdentifier** *(string) --*

                The identifier of the CA certificate for this DB instance.

              - **DomainMemberships** *(list) --*

                The Active Directory Domain membership records associated with the DB instance.

                - *(dict) --*

                  An Active Directory Domain membership record associated with the DB instance.

                  - **Domain** *(string) --*

                    The identifier of the Active Directory Domain.

                  - **Status** *(string) --*

                    The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).

                  - **FQDN** *(string) --*

                    The fully qualified domain name of the Active Directory Domain.

                  - **IAMRoleName** *(string) --*

                    The name of the IAM role to be used when making API calls to the Directory Service.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB instance to snapshots of the DB instance.

                 **Amazon Aurora**

                Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see ``DBCluster`` .

              - **MonitoringInterval** *(integer) --*

                The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.

              - **EnhancedMonitoringResourceArn** *(string) --*

                The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.

              - **MonitoringRoleArn** *(string) --*

                The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.

              - **PromotionTier** *(integer) --*

                A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **DBInstanceArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB instance.

              - **Timezone** *(string) --*

                The time zone of the DB instance. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

                IAM database authentication can be enabled for the following database engines

                * For MySQL 5.6, minor version 5.6.34 or higher

                * For MySQL 5.7, minor version 5.7.16 or higher

                * Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.

              - **PerformanceInsightsEnabled** *(boolean) --*

                True if Performance Insights is enabled for the DB instance, and otherwise false.

              - **PerformanceInsightsKMSKeyId** *(string) --*

                The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

              - **PerformanceInsightsRetentionPeriod** *(integer) --*

                The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB instance is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html>`__ in the *Amazon RDS User Guide.*

                - *(string) --*

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

              - **AssociatedRoles** *(list) --*

                The AWS Identity and Access Management (IAM) roles associated with the DB instance.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB instance.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see ``DBEngineVersion`` .

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB instance and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB instance.

                    * ``INVALID`` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other AWS services on your behalf.

              - **ListenerEndpoint** *(dict) --*

                Specifies the listener connection endpoint for SQL Server Always On.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **MaxAllocatedStorage** *(integer) --*

                The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        """
        pass

    def create_db_instance_read_replica(
        self,
        DBInstanceIdentifier: str,
        SourceDBInstanceIdentifier: str,
        DBInstanceClass: str = None,
        AvailabilityZone: str = None,
        Port: int = None,
        MultiAZ: bool = None,
        AutoMinorVersionUpgrade: bool = None,
        Iops: int = None,
        OptionGroupName: str = None,
        DBParameterGroupName: str = None,
        PubliclyAccessible: bool = None,
        Tags: List[Any] = None,
        DBSubnetGroupName: str = None,
        VpcSecurityGroupIds: List[Any] = None,
        StorageType: str = None,
        CopyTagsToSnapshot: bool = None,
        MonitoringInterval: int = None,
        MonitoringRoleArn: str = None,
        KmsKeyId: str = None,
        PreSignedUrl: str = None,
        EnableIAMDatabaseAuthentication: bool = None,
        EnablePerformanceInsights: bool = None,
        PerformanceInsightsKMSKeyId: str = None,
        PerformanceInsightsRetentionPeriod: int = None,
        EnableCloudwatchLogsExports: List[Any] = None,
        ProcessorFeatures: List[Any] = None,
        UseDefaultProcessorFeatures: bool = None,
        DeletionProtection: bool = None,
        Domain: str = None,
        DomainIAMRoleName: str = None,
        SourceRegion: str = None
    ) -> Dict[str, Any]:
        """
        Creates a new DB instance that acts as a Read Replica for an existing source DB instance. You can create a Read Replica for a DB instance running MySQL, MariaDB, Oracle, or PostgreSQL. For more information, see `Working with Read Replicas <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html>`__ in the *Amazon RDS User Guide* .

        Amazon Aurora doesn't support this action. You must call the ``CreateDBInstance`` action to create a DB instance for an Aurora DB cluster.

        All Read Replica DB instances are created with backups disabled. All other DB instance attributes (including DB security groups and DB parameter groups) are inherited from the source DB instance, except as specified following.

        .. warning::

          Your source DB instance must have backup retention enabled.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica>`_

        **Request Syntax**
        ::

          response = client.create_db_instance_read_replica(
              DBInstanceIdentifier='string',
              SourceDBInstanceIdentifier='string',
              DBInstanceClass='string',
              AvailabilityZone='string',
              Port=123,
              MultiAZ=True|False,
              AutoMinorVersionUpgrade=True|False,
              Iops=123,
              OptionGroupName='string',
              DBParameterGroupName='string',
              PubliclyAccessible=True|False,
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ],
              DBSubnetGroupName='string',
              VpcSecurityGroupIds=[
                  'string',
              ],
              StorageType='string',
              CopyTagsToSnapshot=True|False,
              MonitoringInterval=123,
              MonitoringRoleArn='string',
              KmsKeyId='string',
              EnableIAMDatabaseAuthentication=True|False,
              EnablePerformanceInsights=True|False,
              PerformanceInsightsKMSKeyId='string',
              PerformanceInsightsRetentionPeriod=123,
              EnableCloudwatchLogsExports=[
                  'string',
              ],
              ProcessorFeatures=[
                  {
                      'Name': 'string',
                      'Value': 'string'
                  },
              ],
              UseDefaultProcessorFeatures=True|False,
              DeletionProtection=True|False,
              Domain='string',
              DomainIAMRoleName='string',
              SourceRegion='string'
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The DB instance identifier of the Read Replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.

        :type SourceDBInstanceIdentifier: string
        :param SourceDBInstanceIdentifier: **[REQUIRED]**

          The identifier of the DB instance that will act as the source for the Read Replica. Each DB instance can have up to five Read Replicas.

          Constraints:

          * Must be the identifier of an existing MySQL, MariaDB, Oracle, or PostgreSQL DB instance.

          * Can specify a DB instance that is a MySQL Read Replica only if the source is running MySQL 5.6 or later.

          * For the limitations of Oracle Read Replicas, see `Read Replica Limitations with Oracle <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html>`__ in the *Amazon RDS User Guide* .

          * Can specify a DB instance that is a PostgreSQL DB instance only if the source is running PostgreSQL 9.3.5 or later (9.4.7 and higher for cross-region replication).

          * The specified DB instance must have automatic backups enabled, its backup retention period must be greater than 0.

          * If the source DB instance is in the same AWS Region as the Read Replica, specify a valid DB instance identifier.

          * If the source DB instance is in a different AWS Region than the Read Replica, specify a valid DB instance ARN. For more information, go to `Constructing an ARN for Amazon RDS <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing>`__ in the *Amazon RDS User Guide* .

        :type DBInstanceClass: string
        :param DBInstanceClass:

          The compute and memory capacity of the Read Replica, for example, ``db.m4.large`` . Not all DB instance classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see `DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html>`__ in the *Amazon RDS User Guide.*

          Default: Inherits from the source DB instance.

        :type AvailabilityZone: string
        :param AvailabilityZone:

          The Availability Zone (AZ) where the Read Replica will be created.

          Default: A random, system-chosen Availability Zone in the endpoint's AWS Region.

          Example: ``us-east-1d``

        :type Port: integer
        :param Port:

          The port number that the DB instance uses for connections.

          Default: Inherits from the source DB instance

          Valid Values: ``1150-65535``

        :type MultiAZ: boolean
        :param MultiAZ:

          A value that indicates whether the Read Replica is in a Multi-AZ deployment.

          You can create a Read Replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your Read Replica as a Multi-AZ DB instance is independent of whether the source database is a Multi-AZ DB instance.

        :type AutoMinorVersionUpgrade: boolean
        :param AutoMinorVersionUpgrade:

          A value that indicates whether minor engine upgrades are applied automatically to the Read Replica during the maintenance window.

          Default: Inherits from the source DB instance

        :type Iops: integer
        :param Iops:

          The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.

        :type OptionGroupName: string
        :param OptionGroupName:

          The option group the DB instance is associated with. If omitted, the option group associated with the source instance is used.

        :type DBParameterGroupName: string
        :param DBParameterGroupName:

          The name of the DB parameter group to associate with this DB instance.

          If you do not specify a value for ``DBParameterGroupName`` , then Amazon RDS uses the ``DBParameterGroup`` of source DB instance for a same region Read Replica, or the default ``DBParameterGroup`` for the specified DB engine for a cross region Read Replica.

          .. note::

            Currently, specifying a parameter group for this operation is only supported for Oracle DB instances.

          Constraints:

          * Must be 1 to 255 letters, numbers, or hyphens.

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

        :type PubliclyAccessible: boolean
        :param PubliclyAccessible:

          A value that indicates whether the DB instance is publicly accessible. When the DB instance is publicly accessible, it is an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. When the DB instance isn't publicly accessible, it is an internal instance with a DNS name that resolves to a private IP address. For more information, see  CreateDBInstance .

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :type DBSubnetGroupName: string
        :param DBSubnetGroupName:

          Specifies a DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.

          Constraints:

          * Can only be specified if the source DB instance identifier specifies a DB instance in another AWS Region.

          * If supplied, must match the name of an existing DBSubnetGroup.

          * The specified DB subnet group must be in the same AWS Region in which the operation is running.

          * All Read Replicas in one AWS Region that are created from the same source DB instance must either:>

            * Specify DB subnet groups from the same VPC. All these Read Replicas are created in the same VPC.

            * Not specify a DB subnet group. All these Read Replicas are created outside of any VPC.

          Example: ``mySubnetgroup``

        :type VpcSecurityGroupIds: list
        :param VpcSecurityGroupIds:

          A list of EC2 VPC security groups to associate with the Read Replica.

          Default: The default EC2 VPC security group for the DB subnet group's VPC.

          - *(string) --*

        :type StorageType: string
        :param StorageType:

          Specifies the storage type to be associated with the Read Replica.

          Valid values: ``standard | gp2 | io1``

          If you specify ``io1`` , you must also include a value for the ``Iops`` parameter.

          Default: ``io1`` if the ``Iops`` parameter is specified, otherwise ``gp2``

        :type CopyTagsToSnapshot: boolean
        :param CopyTagsToSnapshot:

          A value that indicates whether to copy all tags from the Read Replica to snapshots of the Read Replica. By default, tags are not copied.

        :type MonitoringInterval: integer
        :param MonitoringInterval:

          The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the Read Replica. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.

          If ``MonitoringRoleArn`` is specified, then you must also set ``MonitoringInterval`` to a value other than 0.

          Valid Values: ``0, 1, 5, 10, 15, 30, 60``

        :type MonitoringRoleArn: string
        :param MonitoringRoleArn:

          The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess`` . For information on creating a monitoring role, go to `To create an IAM role for Amazon RDS Enhanced Monitoring <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole>`__ in the *Amazon RDS User Guide* .

          If ``MonitoringInterval`` is set to a value other than 0, then you must supply a ``MonitoringRoleArn`` value.

        :type KmsKeyId: string
        :param KmsKeyId:

          The AWS KMS key ID for an encrypted Read Replica. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

          If you create an encrypted Read Replica in the same AWS Region as the source DB instance, then you do not have to specify a value for this parameter. The Read Replica is encrypted with the same KMS key as the source DB instance.

          If you create an encrypted Read Replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the AWS Region that they are created in, and you can't use encryption keys from one AWS Region in another AWS Region.

          You can't create an encrypted Read Replica from an unencrypted DB instance.

        :type PreSignedUrl: string
        :param PreSignedUrl:

          The URL that contains a Signature Version 4 signed request for the ``CreateDBInstanceReadReplica`` API action in the source AWS Region that contains the source DB instance.

          You must specify this parameter when you create an encrypted Read Replica from another AWS Region by using the Amazon RDS API. Don't specify ``PreSignedUrl`` when you are creating an encrypted Read Replica in the same AWS Region.

          The presigned URL must be a valid request for the ``CreateDBInstanceReadReplica`` API action that can be executed in the source AWS Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values:

          * ``DestinationRegion`` - The AWS Region that the encrypted Read Replica is created in. This AWS Region is the same one where the ``CreateDBInstanceReadReplica`` action is called that contains this presigned URL.  For example, if you create an encrypted DB instance in the us-west-1 AWS Region, from a source DB instance in the us-east-2 AWS Region, then you call the ``CreateDBInstanceReadReplica`` action in the us-east-1 AWS Region and provide a presigned URL that contains a call to the ``CreateDBInstanceReadReplica`` action in the us-west-2 AWS Region. For this example, the ``DestinationRegion`` in the presigned URL must be set to the us-east-1 AWS Region.

          * ``KmsKeyId`` - The AWS KMS key identifier for the key to use to encrypt the Read Replica in the destination AWS Region. This is the same identifier for both the ``CreateDBInstanceReadReplica`` action that is called in the destination AWS Region, and the action contained in the presigned URL.

          * ``SourceDBInstanceIdentifier`` - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS Region. For example, if you are creating an encrypted Read Replica from a DB instance in the us-west-2 AWS Region, then your ``SourceDBInstanceIdentifier`` looks like the following example: ``arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115`` .

          To learn how to generate a Signature Version 4 signed request, see `Authenticating Requests: Using Query Parameters (AWS Signature Version 4) <https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html>`__ and `Signature Version 4 Signing Process <https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html>`__ .

          .. note::

            If you are using an AWS SDK tool or the AWS CLI, you can specify ``SourceRegion`` (or ``--source-region`` for the AWS CLI) instead of specifying ``PreSignedUrl`` manually. Specifying ``SourceRegion`` autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source AWS Region.

            Please note that this parameter is automatically populated if it is not provided. Including this parameter is not required

        :type EnableIAMDatabaseAuthentication: boolean
        :param EnableIAMDatabaseAuthentication:

          A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For information about the supported DB engines, see  CreateDBInstance .

          For more information about IAM database authentication, see `IAM Database Authentication for MySQL and PostgreSQL <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html>`__ in the *Amazon RDS User Guide.*

        :type EnablePerformanceInsights: boolean
        :param EnablePerformanceInsights:

          A value that indicates whether to enable Performance Insights for the Read Replica.

          For more information, see `Using Amazon Performance Insights <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html>`__ in the *Amazon RDS User Guide* .

        :type PerformanceInsightsKMSKeyId: string
        :param PerformanceInsightsKMSKeyId:

          The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

          If you do not specify a value for ``PerformanceInsightsKMSKeyId`` , then Amazon RDS uses your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS Region.

        :type PerformanceInsightsRetentionPeriod: integer
        :param PerformanceInsightsRetentionPeriod:

          The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

        :type EnableCloudwatchLogsExports: list
        :param EnableCloudwatchLogsExports:

          The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see `Publishing Database Logs to Amazon CloudWatch Logs <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch>`__ in the *Amazon RDS User Guide* .

          - *(string) --*

        :type ProcessorFeatures: list
        :param ProcessorFeatures:

          The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

          - *(dict) --*

            Contains the processor features of a DB instance class.

            To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

            You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

            * ``CreateDBInstance``

            * ``ModifyDBInstance``

            * ``RestoreDBInstanceFromDBSnapshot``

            * ``RestoreDBInstanceFromS3``

            * ``RestoreDBInstanceToPointInTime``

            You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

            In addition, you can use the following actions for DB instance class processor information:

            * ``DescribeDBInstances``

            * ``DescribeDBSnapshots``

            * ``DescribeValidDBInstanceModifications``

            For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

            - **Name** *(string) --*

              The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

            - **Value** *(string) --*

              The value of a processor feature name.

        :type UseDefaultProcessorFeatures: boolean
        :param UseDefaultProcessorFeatures:

          A value that indicates whether the DB instance class of the DB instance uses its default processor features.

        :type DeletionProtection: boolean
        :param DeletionProtection:

          A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

        :type Domain: string
        :param Domain:

          The Active Directory directory ID to create the DB instance in.

          For Oracle DB instances, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB instance. For more information, see `Using Kerberos Authentication with Amazon RDS for Oracle <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-kerberos.html>`__ in the *Amazon RDS User Guide* .

        :type DomainIAMRoleName: string
        :param DomainIAMRoleName:

          Specify the name of the IAM role to be used when making API calls to the Directory Service.

        :type SourceRegion: string
        :param SourceRegion:

          The ID of the region that contains the source for the read replica.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBInstance': {
                    'DBInstanceIdentifier': 'string',
                    'DBInstanceClass': 'string',
                    'Engine': 'string',
                    'DBInstanceStatus': 'string',
                    'MasterUsername': 'string',
                    'DBName': 'string',
                    'Endpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'AllocatedStorage': 123,
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'PreferredBackupWindow': 'string',
                    'BackupRetentionPeriod': 123,
                    'DBSecurityGroups': [
                        {
                            'DBSecurityGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'DBParameterGroups': [
                        {
                            'DBParameterGroupName': 'string',
                            'ParameterApplyStatus': 'string'
                        },
                    ],
                    'AvailabilityZone': 'string',
                    'DBSubnetGroup': {
                        'DBSubnetGroupName': 'string',
                        'DBSubnetGroupDescription': 'string',
                        'VpcId': 'string',
                        'SubnetGroupStatus': 'string',
                        'Subnets': [
                            {
                                'SubnetIdentifier': 'string',
                                'SubnetAvailabilityZone': {
                                    'Name': 'string'
                                },
                                'SubnetStatus': 'string'
                            },
                        ],
                        'DBSubnetGroupArn': 'string'
                    },
                    'PreferredMaintenanceWindow': 'string',
                    'PendingModifiedValues': {
                        'DBInstanceClass': 'string',
                        'AllocatedStorage': 123,
                        'MasterUserPassword': 'string',
                        'Port': 123,
                        'BackupRetentionPeriod': 123,
                        'MultiAZ': True|False,
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'DBInstanceIdentifier': 'string',
                        'StorageType': 'string',
                        'CACertificateIdentifier': 'string',
                        'DBSubnetGroupName': 'string',
                        'PendingCloudwatchLogsExports': {
                            'LogTypesToEnable': [
                                'string',
                            ],
                            'LogTypesToDisable': [
                                'string',
                            ]
                        },
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ]
                    },
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'MultiAZ': True|False,
                    'EngineVersion': 'string',
                    'AutoMinorVersionUpgrade': True|False,
                    'ReadReplicaSourceDBInstanceIdentifier': 'string',
                    'ReadReplicaDBInstanceIdentifiers': [
                        'string',
                    ],
                    'ReadReplicaDBClusterIdentifiers': [
                        'string',
                    ],
                    'LicenseModel': 'string',
                    'Iops': 123,
                    'OptionGroupMemberships': [
                        {
                            'OptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'CharacterSetName': 'string',
                    'SecondaryAvailabilityZone': 'string',
                    'PubliclyAccessible': True|False,
                    'StatusInfos': [
                        {
                            'StatusType': 'string',
                            'Normal': True|False,
                            'Status': 'string',
                            'Message': 'string'
                        },
                    ],
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'DbInstancePort': 123,
                    'DBClusterIdentifier': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbiResourceId': 'string',
                    'CACertificateIdentifier': 'string',
                    'DomainMemberships': [
                        {
                            'Domain': 'string',
                            'Status': 'string',
                            'FQDN': 'string',
                            'IAMRoleName': 'string'
                        },
                    ],
                    'CopyTagsToSnapshot': True|False,
                    'MonitoringInterval': 123,
                    'EnhancedMonitoringResourceArn': 'string',
                    'MonitoringRoleArn': 'string',
                    'PromotionTier': 123,
                    'DBInstanceArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'PerformanceInsightsEnabled': True|False,
                    'PerformanceInsightsKMSKeyId': 'string',
                    'PerformanceInsightsRetentionPeriod': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DeletionProtection': True|False,
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'FeatureName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'ListenerEndpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'MaxAllocatedStorage': 123
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBInstance** *(dict) --*

              Contains the details of an Amazon RDS DB instance.

              This data type is used as a response element in the ``DescribeDBInstances`` action.

              - **DBInstanceIdentifier** *(string) --*

                Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.

              - **DBInstanceClass** *(string) --*

                Contains the name of the compute and memory capacity class of the DB instance.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB instance.

              - **DBInstanceStatus** *(string) --*

                Specifies the current state of this database.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB instance.

              - **DBName** *(string) --*

                The meaning of this parameter differs according to the database engine you use.

                 **MySQL, MariaDB, SQL Server, PostgreSQL**

                Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.

                Type: String

                 **Oracle**

                Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.

              - **Endpoint** *(dict) --*

                Specifies the connection endpoint.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size specified in gibibytes.

              - **InstanceCreateTime** *(datetime) --*

                Provides the date and time the DB instance was created.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **DBSecurityGroups** *(list) --*

                A list of DB security group elements containing ``DBSecurityGroup.Name`` and ``DBSecurityGroup.Status`` subelements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceToPointInTime``

                  - **DBSecurityGroupName** *(string) --*

                    The name of the DB security group.

                  - **Status** *(string) --*

                    The status of the DB security group.

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security group elements that the DB instance belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **DBParameterGroups** *(list) --*

                Provides the list of DB parameter groups applied to this DB instance.

                - *(dict) --*

                  The status of the DB parameter group.

                  This data type is used as a response element in the following actions:

                  * ``CreateDBInstance``

                  * ``CreateDBInstanceReadReplica``

                  * ``DeleteDBInstance``

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  - **DBParameterGroupName** *(string) --*

                    The name of the DB parameter group.

                  - **ParameterApplyStatus** *(string) --*

                    The status of parameter updates.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance is located in.

              - **DBSubnetGroup** *(dict) --*

                Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.

                - **DBSubnetGroupName** *(string) --*

                  The name of the DB subnet group.

                - **DBSubnetGroupDescription** *(string) --*

                  Provides the description of the DB subnet group.

                - **VpcId** *(string) --*

                  Provides the VpcId of the DB subnet group.

                - **SubnetGroupStatus** *(string) --*

                  Provides the status of the DB subnet group.

                - **Subnets** *(list) --*

                  Contains a list of ``Subnet`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                    - **SubnetIdentifier** *(string) --*

                      Specifies the identifier of the subnet.

                    - **SubnetAvailabilityZone** *(dict) --*

                      Contains Availability Zone information.

                      This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                      - **Name** *(string) --*

                        The name of the Availability Zone.

                    - **SubnetStatus** *(string) --*

                      Specifies the status of the subnet.

                - **DBSubnetGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB subnet group.

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **PendingModifiedValues** *(dict) --*

                Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.

                - **DBInstanceClass** *(string) --*

                  Contains the new ``DBInstanceClass`` for the DB instance that will be applied or is currently being applied.

                - **AllocatedStorage** *(integer) --*

                  Contains the new ``AllocatedStorage`` size for the DB instance that will be applied or is currently being applied.

                - **MasterUserPassword** *(string) --*

                  Contains the pending or currently-in-progress change of the master credentials for the DB instance.

                - **Port** *(integer) --*

                  Specifies the pending port for the DB instance.

                - **BackupRetentionPeriod** *(integer) --*

                  Specifies the pending number of days for which automated backups are retained.

                - **MultiAZ** *(boolean) --*

                  Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **LicenseModel** *(string) --*

                  The license model for the DB instance.

                  Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

                - **Iops** *(integer) --*

                  Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.

                - **DBInstanceIdentifier** *(string) --*

                  Contains the new ``DBInstanceIdentifier`` for the DB instance that will be applied or is currently being applied.

                - **StorageType** *(string) --*

                  Specifies the storage type to be associated with the DB instance.

                - **CACertificateIdentifier** *(string) --*

                  Specifies the identifier of the CA certificate for the DB instance.

                - **DBSubnetGroupName** *(string) --*

                  The new DB subnet group for the DB instance.

                - **PendingCloudwatchLogsExports** *(dict) --*

                  A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.

                  - **LogTypesToEnable** *(list) --*

                    Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.

                    - *(string) --*

                  - **LogTypesToDisable** *(list) --*

                    Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.

                    - *(string) --*

                - **ProcessorFeatures** *(list) --*

                  The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                  - *(dict) --*

                    Contains the processor features of a DB instance class.

                    To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                    You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                    * ``CreateDBInstance``

                    * ``ModifyDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceFromS3``

                    * ``RestoreDBInstanceToPointInTime``

                    You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                    In addition, you can use the following actions for DB instance class processor information:

                    * ``DescribeDBInstances``

                    * ``DescribeDBSnapshots``

                    * ``DescribeValidDBInstanceModifications``

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **Value** *(string) --*

                      The value of a processor feature name.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **MultiAZ** *(boolean) --*

                Specifies if the DB instance is a Multi-AZ deployment.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **AutoMinorVersionUpgrade** *(boolean) --*

                Indicates that minor version patches are applied automatically.

              - **ReadReplicaSourceDBInstanceIdentifier** *(string) --*

                Contains the identifier of the source DB instance if this DB instance is a Read Replica.

              - **ReadReplicaDBInstanceIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB instance.

                - *(string) --*

              - **ReadReplicaDBClusterIdentifiers** *(list) --*

                Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a Read Replica. For example, when you create an Aurora Read Replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster for the Aurora Read Replica is shown. This output does not contain information about cross region Aurora Read Replicas.

                .. note::

                  Currently, each RDS DB instance can have only one Aurora Read Replica.

                - *(string) --*

              - **LicenseModel** *(string) --*

                License model information for this DB instance.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value.

              - **OptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB instance.

                - *(dict) --*

                  Provides information on the option groups the DB instance is a member of.

                  - **OptionGroupName** *(string) --*

                    The name of the option group that the instance belongs to.

                  - **Status** *(string) --*

                    The status of the DB instance's option group membership. Valid values are: ``in-sync`` , ``pending-apply`` , ``pending-removal`` , ``pending-maintenance-apply`` , ``pending-maintenance-removal`` , ``applying`` , ``removing`` , and ``failed`` .

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this instance is associated with.

              - **SecondaryAvailabilityZone** *(string) --*

                If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.

              - **PubliclyAccessible** *(boolean) --*

                Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address.

              - **StatusInfos** *(list) --*

                The status of a Read Replica. If the instance isn't a Read Replica, this is blank.

                - *(dict) --*

                  Provides a list of status information for a DB instance.

                  - **StatusType** *(string) --*

                    This value is currently "read replication."

                  - **Normal** *(boolean) --*

                    Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.

                  - **Status** *(string) --*

                    Status of the DB instance. For a StatusType of Read Replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.

                  - **Message** *(string) --*

                    Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB instance.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which the instance is associated for TDE encryption.

              - **DbInstancePort** *(integer) --*

                Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.

              - **DBClusterIdentifier** *(string) --*

                If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB instance is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB instance.

              - **DbiResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.

              - **CACertificateIdentifier** *(string) --*

                The identifier of the CA certificate for this DB instance.

              - **DomainMemberships** *(list) --*

                The Active Directory Domain membership records associated with the DB instance.

                - *(dict) --*

                  An Active Directory Domain membership record associated with the DB instance.

                  - **Domain** *(string) --*

                    The identifier of the Active Directory Domain.

                  - **Status** *(string) --*

                    The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).

                  - **FQDN** *(string) --*

                    The fully qualified domain name of the Active Directory Domain.

                  - **IAMRoleName** *(string) --*

                    The name of the IAM role to be used when making API calls to the Directory Service.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB instance to snapshots of the DB instance.

                 **Amazon Aurora**

                Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see ``DBCluster`` .

              - **MonitoringInterval** *(integer) --*

                The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.

              - **EnhancedMonitoringResourceArn** *(string) --*

                The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.

              - **MonitoringRoleArn** *(string) --*

                The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.

              - **PromotionTier** *(integer) --*

                A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **DBInstanceArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB instance.

              - **Timezone** *(string) --*

                The time zone of the DB instance. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

                IAM database authentication can be enabled for the following database engines

                * For MySQL 5.6, minor version 5.6.34 or higher

                * For MySQL 5.7, minor version 5.7.16 or higher

                * Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.

              - **PerformanceInsightsEnabled** *(boolean) --*

                True if Performance Insights is enabled for the DB instance, and otherwise false.

              - **PerformanceInsightsKMSKeyId** *(string) --*

                The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

              - **PerformanceInsightsRetentionPeriod** *(integer) --*

                The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB instance is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html>`__ in the *Amazon RDS User Guide.*

                - *(string) --*

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

              - **AssociatedRoles** *(list) --*

                The AWS Identity and Access Management (IAM) roles associated with the DB instance.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB instance.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see ``DBEngineVersion`` .

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB instance and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB instance.

                    * ``INVALID`` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other AWS services on your behalf.

              - **ListenerEndpoint** *(dict) --*

                Specifies the listener connection endpoint for SQL Server Always On.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **MaxAllocatedStorage** *(integer) --*

                The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        """
        pass

    def create_db_parameter_group(
        self,
        DBParameterGroupName: str,
        DBParameterGroupFamily: str,
        Description: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a new DB parameter group.

        A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using *ModifyDBParameterGroup* . Once you've created a DB parameter group, you need to associate it with your DB instance using *ModifyDBInstance* . When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.

        .. warning::

          After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the ``character_set_database`` parameter. You can use the *Parameter Groups* option of the `Amazon RDS console <https://console.aws.amazon.com/rds/>`__ or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup>`_

        **Request Syntax**
        ::

          response = client.create_db_parameter_group(
              DBParameterGroupName='string',
              DBParameterGroupFamily='string',
              Description='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type DBParameterGroupName: string
        :param DBParameterGroupName: **[REQUIRED]**

          The name of the DB parameter group.

          Constraints:

          * Must be 1 to 255 letters, numbers, or hyphens.

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          .. note::

            This value is stored as a lowercase string.

        :type DBParameterGroupFamily: string
        :param DBParameterGroupFamily: **[REQUIRED]**

          The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.

          To list all of the available parameter group families, use the following command:

           ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily"``

          .. note::

            The output contains duplicates.

        :type Description: string
        :param Description: **[REQUIRED]**

          The description for the DB parameter group.

        :type Tags: list
        :param Tags:

          Tags to assign to the DB parameter group.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBParameterGroup': {
                    'DBParameterGroupName': 'string',
                    'DBParameterGroupFamily': 'string',
                    'Description': 'string',
                    'DBParameterGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBParameterGroup** *(dict) --*

              Contains the details of an Amazon RDS DB parameter group.

              This data type is used as a response element in the ``DescribeDBParameterGroups`` action.

              - **DBParameterGroupName** *(string) --*

                Provides the name of the DB parameter group.

              - **DBParameterGroupFamily** *(string) --*

                Provides the name of the DB parameter group family that this DB parameter group is compatible with.

              - **Description** *(string) --*

                Provides the customer-specified description for this DB parameter group.

              - **DBParameterGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB parameter group.

        """
        pass

    def create_db_security_group(
        self,
        DBSecurityGroupName: str,
        DBSecurityGroupDescription: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a new DB security group. DB security groups control access to a DB instance.

        .. note::

          A DB security group controls access to EC2-Classic DB instances that are not in a VPC.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup>`_

        **Request Syntax**
        ::

          response = client.create_db_security_group(
              DBSecurityGroupName='string',
              DBSecurityGroupDescription='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type DBSecurityGroupName: string
        :param DBSecurityGroupName: **[REQUIRED]**

          The name for the DB security group. This value is stored as a lowercase string.

          Constraints:

          * Must be 1 to 255 letters, numbers, or hyphens.

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          * Must not be "Default"

          Example: ``mysecuritygroup``

        :type DBSecurityGroupDescription: string
        :param DBSecurityGroupDescription: **[REQUIRED]**

          The description for the DB security group.

        :type Tags: list
        :param Tags:

          Tags to assign to the DB security group.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSecurityGroup': {
                    'OwnerId': 'string',
                    'DBSecurityGroupName': 'string',
                    'DBSecurityGroupDescription': 'string',
                    'VpcId': 'string',
                    'EC2SecurityGroups': [
                        {
                            'Status': 'string',
                            'EC2SecurityGroupName': 'string',
                            'EC2SecurityGroupId': 'string',
                            'EC2SecurityGroupOwnerId': 'string'
                        },
                    ],
                    'IPRanges': [
                        {
                            'Status': 'string',
                            'CIDRIP': 'string'
                        },
                    ],
                    'DBSecurityGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSecurityGroup** *(dict) --*

              Contains the details for an Amazon RDS DB security group.

              This data type is used as a response element in the ``DescribeDBSecurityGroups`` action.

              - **OwnerId** *(string) --*

                Provides the AWS ID of the owner of a specific DB security group.

              - **DBSecurityGroupName** *(string) --*

                Specifies the name of the DB security group.

              - **DBSecurityGroupDescription** *(string) --*

                Provides the description of the DB security group.

              - **VpcId** *(string) --*

                Provides the VpcId of the DB security group.

              - **EC2SecurityGroups** *(list) --*

                Contains a list of ``EC2SecurityGroup`` elements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``AuthorizeDBSecurityGroupIngress``

                  * ``DescribeDBSecurityGroups``

                  * ``RevokeDBSecurityGroupIngress``

                  - **Status** *(string) --*

                    Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".

                  - **EC2SecurityGroupName** *(string) --*

                    Specifies the name of the EC2 security group.

                  - **EC2SecurityGroupId** *(string) --*

                    Specifies the id of the EC2 security group.

                  - **EC2SecurityGroupOwnerId** *(string) --*

                    Specifies the AWS ID of the owner of the EC2 security group specified in the ``EC2SecurityGroupName`` field.

              - **IPRanges** *(list) --*

                Contains a list of ``IPRange`` elements.

                - *(dict) --*

                  This data type is used as a response element in the ``DescribeDBSecurityGroups`` action.

                  - **Status** *(string) --*

                    Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".

                  - **CIDRIP** *(string) --*

                    Specifies the IP range.

              - **DBSecurityGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB security group.

        """
        pass

    def create_db_snapshot(
        self,
        DBSnapshotIdentifier: str,
        DBInstanceIdentifier: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a DBSnapshot. The source DBInstance must be in "available" state.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot>`_

        **Request Syntax**
        ::

          response = client.create_db_snapshot(
              DBSnapshotIdentifier='string',
              DBInstanceIdentifier='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type DBSnapshotIdentifier: string
        :param DBSnapshotIdentifier: **[REQUIRED]**

          The identifier for the DB snapshot.

          Constraints:

          * Can't be null, empty, or blank

          * Must contain from 1 to 255 letters, numbers, or hyphens

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``my-snapshot-id``

        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The identifier of the DB instance that you want to create the snapshot of.

          Constraints:

          * Must match the identifier of an existing DBInstance.

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSnapshot': {
                    'DBSnapshotIdentifier': 'string',
                    'DBInstanceIdentifier': 'string',
                    'SnapshotCreateTime': datetime(2015, 1, 1),
                    'Engine': 'string',
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'AvailabilityZone': 'string',
                    'VpcId': 'string',
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'SnapshotType': 'string',
                    'Iops': 123,
                    'OptionGroupName': 'string',
                    'PercentProgress': 123,
                    'SourceRegion': 'string',
                    'SourceDBSnapshotIdentifier': 'string',
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'Encrypted': True|False,
                    'KmsKeyId': 'string',
                    'DBSnapshotArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DbiResourceId': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSnapshot** *(dict) --*

              Contains the details of an Amazon RDS DB snapshot.

              This data type is used as a response element in the ``DescribeDBSnapshots`` action.

              - **DBSnapshotIdentifier** *(string) --*

                Specifies the identifier for the DB snapshot.

              - **DBInstanceIdentifier** *(string) --*

                Specifies the DB instance identifier of the DB instance this DB snapshot was created from.

              - **SnapshotCreateTime** *(datetime) --*

                Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **Engine** *(string) --*

                Specifies the name of the database engine.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Specifies the status of this DB snapshot.

              - **Port** *(integer) --*

                Specifies the port that the database engine was listening on at the time of the snapshot.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB snapshot.

              - **InstanceCreateTime** *(datetime) --*

                Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **MasterUsername** *(string) --*

                Provides the master username for the DB snapshot.

              - **EngineVersion** *(string) --*

                Specifies the version of the database engine.

              - **LicenseModel** *(string) --*

                License model information for the restored DB instance.

              - **SnapshotType** *(string) --*

                Provides the type of the DB snapshot.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.

              - **OptionGroupName** *(string) --*

                Provides the option group name for the DB snapshot.

              - **PercentProgress** *(integer) --*

                The percentage of the estimated data that has been transferred.

              - **SourceRegion** *(string) --*

                The AWS Region that the DB snapshot was created in or copied from.

              - **SourceDBSnapshotIdentifier** *(string) --*

                The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has value in case of cross-customer or cross-region copy.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB snapshot.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which to associate the instance for TDE encryption.

              - **Encrypted** *(boolean) --*

                Specifies whether the DB snapshot is encrypted.

              - **KmsKeyId** *(string) --*

                If ``Encrypted`` is true, the AWS KMS key identifier for the encrypted DB snapshot.

              - **DBSnapshotArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB snapshot.

              - **Timezone** *(string) --*

                The time zone of the DB snapshot. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DbiResourceId** *(string) --*

                The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

        """
        pass

    def create_db_subnet_group(
        self,
        DBSubnetGroupName: str,
        DBSubnetGroupDescription: str,
        SubnetIds: List[Any],
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the AWS Region.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup>`_

        **Request Syntax**
        ::

          response = client.create_db_subnet_group(
              DBSubnetGroupName='string',
              DBSubnetGroupDescription='string',
              SubnetIds=[
                  'string',
              ],
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type DBSubnetGroupName: string
        :param DBSubnetGroupName: **[REQUIRED]**

          The name for the DB subnet group. This value is stored as a lowercase string.

          Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.

          Example: ``mySubnetgroup``

        :type DBSubnetGroupDescription: string
        :param DBSubnetGroupDescription: **[REQUIRED]**

          The description for the DB subnet group.

        :type SubnetIds: list
        :param SubnetIds: **[REQUIRED]**

          The EC2 Subnet IDs for the DB subnet group.

          - *(string) --*

        :type Tags: list
        :param Tags:

          Tags to assign to the DB subnet group.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSubnetGroup': {
                    'DBSubnetGroupName': 'string',
                    'DBSubnetGroupDescription': 'string',
                    'VpcId': 'string',
                    'SubnetGroupStatus': 'string',
                    'Subnets': [
                        {
                            'SubnetIdentifier': 'string',
                            'SubnetAvailabilityZone': {
                                'Name': 'string'
                            },
                            'SubnetStatus': 'string'
                        },
                    ],
                    'DBSubnetGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSubnetGroup** *(dict) --*

              Contains the details of an Amazon RDS DB subnet group.

              This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

              - **DBSubnetGroupName** *(string) --*

                The name of the DB subnet group.

              - **DBSubnetGroupDescription** *(string) --*

                Provides the description of the DB subnet group.

              - **VpcId** *(string) --*

                Provides the VpcId of the DB subnet group.

              - **SubnetGroupStatus** *(string) --*

                Provides the status of the DB subnet group.

              - **Subnets** *(list) --*

                Contains a list of ``Subnet`` elements.

                - *(dict) --*

                  This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                  - **SubnetIdentifier** *(string) --*

                    Specifies the identifier of the subnet.

                  - **SubnetAvailabilityZone** *(dict) --*

                    Contains Availability Zone information.

                    This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                    - **Name** *(string) --*

                      The name of the Availability Zone.

                  - **SubnetStatus** *(string) --*

                    Specifies the status of the subnet.

              - **DBSubnetGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB subnet group.

        """
        pass

    def create_event_subscription(
        self,
        SubscriptionName: str,
        SnsTopicArn: str,
        SourceType: str = None,
        EventCategories: List[Any] = None,
        SourceIds: List[Any] = None,
        Enabled: bool = None,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates an RDS event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.

        You can specify the type of source (SourceType) you want to be notified of, provide a list of RDS sources (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.

        If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier = myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your RDS sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of events generated from all RDS sources belonging to your customer account.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription>`_

        **Request Syntax**
        ::

          response = client.create_event_subscription(
              SubscriptionName='string',
              SnsTopicArn='string',
              SourceType='string',
              EventCategories=[
                  'string',
              ],
              SourceIds=[
                  'string',
              ],
              Enabled=True|False,
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type SubscriptionName: string
        :param SubscriptionName: **[REQUIRED]**

          The name of the subscription.

          Constraints: The name must be less than 255 characters.

        :type SnsTopicArn: string
        :param SnsTopicArn: **[REQUIRED]**

          The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.

        :type SourceType: string
        :param SourceType:

          The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value isn't specified, all events are returned.

          Valid values: ``db-instance`` | ``db-cluster`` | ``db-parameter-group`` | ``db-security-group`` | ``db-snapshot`` | ``db-cluster-snapshot``

        :type EventCategories: list
        :param EventCategories:

          A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType in the `Events <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html>`__ topic in the *Amazon RDS User Guide* or by using the **DescribeEventCategories** action.

          - *(string) --*

        :type SourceIds: list
        :param SourceIds:

          The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.

          Constraints:

          * If SourceIds are supplied, SourceType must also be provided.

          * If the source type is a DB instance, then a ``DBInstanceIdentifier`` must be supplied.

          * If the source type is a DB security group, a ``DBSecurityGroupName`` must be supplied.

          * If the source type is a DB parameter group, a ``DBParameterGroupName`` must be supplied.

          * If the source type is a DB snapshot, a ``DBSnapshotIdentifier`` must be supplied.

          - *(string) --*

        :type Enabled: boolean
        :param Enabled:

          A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'EventSubscription': {
                    'CustomerAwsId': 'string',
                    'CustSubscriptionId': 'string',
                    'SnsTopicArn': 'string',
                    'Status': 'string',
                    'SubscriptionCreationTime': 'string',
                    'SourceType': 'string',
                    'SourceIdsList': [
                        'string',
                    ],
                    'EventCategoriesList': [
                        'string',
                    ],
                    'Enabled': True|False,
                    'EventSubscriptionArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **EventSubscription** *(dict) --*

              Contains the results of a successful invocation of the ``DescribeEventSubscriptions`` action.

              - **CustomerAwsId** *(string) --*

                The AWS customer account associated with the RDS event notification subscription.

              - **CustSubscriptionId** *(string) --*

                The RDS event notification subscription Id.

              - **SnsTopicArn** *(string) --*

                The topic ARN of the RDS event notification subscription.

              - **Status** *(string) --*

                The status of the RDS event notification subscription.

                Constraints:

                Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist

                The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.

              - **SubscriptionCreationTime** *(string) --*

                The time the RDS event notification subscription was created.

              - **SourceType** *(string) --*

                The source type for the RDS event notification subscription.

              - **SourceIdsList** *(list) --*

                A list of source IDs for the RDS event notification subscription.

                - *(string) --*

              - **EventCategoriesList** *(list) --*

                A list of event categories for the RDS event notification subscription.

                - *(string) --*

              - **Enabled** *(boolean) --*

                A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.

              - **EventSubscriptionArn** *(string) --*

                The Amazon Resource Name (ARN) for the event subscription.

        """
        pass

    def create_global_cluster(
        self,
        GlobalClusterIdentifier: str = None,
        SourceDBClusterIdentifier: str = None,
        Engine: str = None,
        EngineVersion: str = None,
        DeletionProtection: bool = None,
        DatabaseName: str = None,
        StorageEncrypted: bool = None
    ) -> Dict[str, Any]:
        """

        Creates an Aurora global database spread across multiple regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.

        You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster to it. Or you can specify an existing Aurora cluster during the create operation, and this cluster becomes the primary cluster of the global database.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster>`_

        **Request Syntax**
        ::

          response = client.create_global_cluster(
              GlobalClusterIdentifier='string',
              SourceDBClusterIdentifier='string',
              Engine='string',
              EngineVersion='string',
              DeletionProtection=True|False,
              DatabaseName='string',
              StorageEncrypted=True|False
          )
        :type GlobalClusterIdentifier: string
        :param GlobalClusterIdentifier:

          The cluster identifier of the new global database cluster.

        :type SourceDBClusterIdentifier: string
        :param SourceDBClusterIdentifier:

          The Amazon Resource Name (ARN) to use as the primary cluster of the global database. This parameter is optional.

        :type Engine: string
        :param Engine:

          Provides the name of the database engine to be used for this DB cluster.

        :type EngineVersion: string
        :param EngineVersion:

          The engine version of the Aurora global database.

        :type DeletionProtection: boolean
        :param DeletionProtection:

          The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled.

        :type DatabaseName: string
        :param DatabaseName:

          The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Aurora will not create a database in the global database cluster you are creating.

        :type StorageEncrypted: boolean
        :param StorageEncrypted:

          The storage encryption setting for the new global database cluster.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'GlobalCluster': {
                    'GlobalClusterIdentifier': 'string',
                    'GlobalClusterResourceId': 'string',
                    'GlobalClusterArn': 'string',
                    'Status': 'string',
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'DatabaseName': 'string',
                    'StorageEncrypted': True|False,
                    'DeletionProtection': True|False,
                    'GlobalClusterMembers': [
                        {
                            'DBClusterArn': 'string',
                            'Readers': [
                                'string',
                            ],
                            'IsWriter': True|False
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **GlobalCluster** *(dict) --*

              A data type representing an Aurora global database.

              - **GlobalClusterIdentifier** *(string) --*

                Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster.

              - **GlobalClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **GlobalClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the global database cluster.

              - **Status** *(string) --*

                Specifies the current state of this global database cluster.

              - **Engine** *(string) --*

                The Aurora database engine used by the global database cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **DatabaseName** *(string) --*

                The default database name within the new global database cluster.

              - **StorageEncrypted** *(boolean) --*

                The storage encryption setting for the global database cluster.

              - **DeletionProtection** *(boolean) --*

                The deletion protection setting for the new global database cluster.

              - **GlobalClusterMembers** *(list) --*

                The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item.

                - *(dict) --*

                  A data structure with information about any primary and secondary clusters associated with an Aurora global database.

                  - **DBClusterArn** *(string) --*

                    The Amazon Resource Name (ARN) for each Aurora cluster.

                  - **Readers** *(list) --*

                    The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database.

                    - *(string) --*

                  - **IsWriter** *(boolean) --*

                    Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated.

        """
        pass

    def create_option_group(
        self,
        OptionGroupName: str,
        EngineName: str,
        MajorEngineVersion: str,
        OptionGroupDescription: str,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Creates a new option group. You can create up to 20 option groups.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup>`_

        **Request Syntax**
        ::

          response = client.create_option_group(
              OptionGroupName='string',
              EngineName='string',
              MajorEngineVersion='string',
              OptionGroupDescription='string',
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type OptionGroupName: string
        :param OptionGroupName: **[REQUIRED]**

          Specifies the name of the option group to be created.

          Constraints:

          * Must be 1 to 255 letters, numbers, or hyphens

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``myoptiongroup``

        :type EngineName: string
        :param EngineName: **[REQUIRED]**

          Specifies the name of the engine that this option group should be associated with.

        :type MajorEngineVersion: string
        :param MajorEngineVersion: **[REQUIRED]**

          Specifies the major version of the engine that this option group should be associated with.

        :type OptionGroupDescription: string
        :param OptionGroupDescription: **[REQUIRED]**

          The description of the option group.

        :type Tags: list
        :param Tags:

          Tags to assign to the option group.

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'OptionGroup': {
                    'OptionGroupName': 'string',
                    'OptionGroupDescription': 'string',
                    'EngineName': 'string',
                    'MajorEngineVersion': 'string',
                    'Options': [
                        {
                            'OptionName': 'string',
                            'OptionDescription': 'string',
                            'Persistent': True|False,
                            'Permanent': True|False,
                            'Port': 123,
                            'OptionVersion': 'string',
                            'OptionSettings': [
                                {
                                    'Name': 'string',
                                    'Value': 'string',
                                    'DefaultValue': 'string',
                                    'Description': 'string',
                                    'ApplyType': 'string',
                                    'DataType': 'string',
                                    'AllowedValues': 'string',
                                    'IsModifiable': True|False,
                                    'IsCollection': True|False
                                },
                            ],
                            'DBSecurityGroupMemberships': [
                                {
                                    'DBSecurityGroupName': 'string',
                                    'Status': 'string'
                                },
                            ],
                            'VpcSecurityGroupMemberships': [
                                {
                                    'VpcSecurityGroupId': 'string',
                                    'Status': 'string'
                                },
                            ]
                        },
                    ],
                    'AllowsVpcAndNonVpcInstanceMemberships': True|False,
                    'VpcId': 'string',
                    'OptionGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **OptionGroup** *(dict) --*

              - **OptionGroupName** *(string) --*

                Specifies the name of the option group.

              - **OptionGroupDescription** *(string) --*

                Provides a description of the option group.

              - **EngineName** *(string) --*

                Indicates the name of the engine that this option group can be applied to.

              - **MajorEngineVersion** *(string) --*

                Indicates the major engine version associated with this option group.

              - **Options** *(list) --*

                Indicates what options are available in the option group.

                - *(dict) --*

                  Option details.

                  - **OptionName** *(string) --*

                    The name of the option.

                  - **OptionDescription** *(string) --*

                    The description of the option.

                  - **Persistent** *(boolean) --*

                    Indicate if this option is persistent.

                  - **Permanent** *(boolean) --*

                    Indicate if this option is permanent.

                  - **Port** *(integer) --*

                    If required, the port configured for this option to use.

                  - **OptionVersion** *(string) --*

                    The version of the option.

                  - **OptionSettings** *(list) --*

                    The option settings for this option.

                    - *(dict) --*

                      Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.

                      - **Name** *(string) --*

                        The name of the option that has settings that you can set.

                      - **Value** *(string) --*

                        The current value of the option setting.

                      - **DefaultValue** *(string) --*

                        The default value of the option setting.

                      - **Description** *(string) --*

                        The description of the option setting.

                      - **ApplyType** *(string) --*

                        The DB engine specific parameter type.

                      - **DataType** *(string) --*

                        The data type of the option setting.

                      - **AllowedValues** *(string) --*

                        The allowed values of the option setting.

                      - **IsModifiable** *(boolean) --*

                        A Boolean value that, when true, indicates the option setting can be modified from the default.

                      - **IsCollection** *(boolean) --*

                        Indicates if the option setting is part of a collection.

                  - **DBSecurityGroupMemberships** *(list) --*

                    If the option requires access to a port, then this DB security group allows access to the port.

                    - *(dict) --*

                      This data type is used as a response element in the following actions:

                      * ``ModifyDBInstance``

                      * ``RebootDBInstance``

                      * ``RestoreDBInstanceFromDBSnapshot``

                      * ``RestoreDBInstanceToPointInTime``

                      - **DBSecurityGroupName** *(string) --*

                        The name of the DB security group.

                      - **Status** *(string) --*

                        The status of the DB security group.

                  - **VpcSecurityGroupMemberships** *(list) --*

                    If the option requires access to a port, then this VPC security group allows access to the port.

                    - *(dict) --*

                      This data type is used as a response element for queries on VPC security group membership.

                      - **VpcSecurityGroupId** *(string) --*

                        The name of the VPC security group.

                      - **Status** *(string) --*

                        The status of the VPC security group.

              - **AllowsVpcAndNonVpcInstanceMemberships** *(boolean) --*

                Indicates whether this option group can be applied to both VPC and non-VPC instances. The value ``true`` indicates the option group can be applied to both VPC and non-VPC instances.

              - **VpcId** *(string) --*

                If **AllowsVpcAndNonVpcInstanceMemberships** is ``false`` , this field is blank. If **AllowsVpcAndNonVpcInstanceMemberships** is ``true`` and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field.

              - **OptionGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the option group.

        """
        pass

    def delete_custom_availability_zone(
        self,
        CustomAvailabilityZoneId: str
    ) -> Dict[str, Any]:
        """
        .. _https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html: https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html

        Deletes a custom Availability Zone (AZ).

        A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster.

        For more information about RDS on VMware, see the ` *RDS on VMware User Guide.* https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html`__

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomAvailabilityZone>`_

        **Request Syntax**
        ::

          response = client.delete_custom_availability_zone(
              CustomAvailabilityZoneId='string'
          )
        :type CustomAvailabilityZoneId: string
        :param CustomAvailabilityZoneId: **[REQUIRED]**

          The custom AZ identifier.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'CustomAvailabilityZone': {
                    'CustomAvailabilityZoneId': 'string',
                    'CustomAvailabilityZoneName': 'string',
                    'CustomAvailabilityZoneStatus': 'string',
                    'VpnDetails': {
                        'VpnId': 'string',
                        'VpnTunnelOriginatorIP': 'string',
                        'VpnGatewayIp': 'string',
                        'VpnPSK': 'string',
                        'VpnName': 'string',
                        'VpnState': 'string'
                    }
                }
            }
          **Response Structure**

          - *(dict) --*

            - **CustomAvailabilityZone** *(dict) --*

              A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.

              For more information about RDS on VMware, see the ` *RDS on VMware User Guide.* https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html`__

              - **CustomAvailabilityZoneId** *(string) --*

                The identifier of the custom AZ.

                Amazon RDS generates a unique identifier when a custom AZ is created.

              - **CustomAvailabilityZoneName** *(string) --*

                The name of the custom AZ.

              - **CustomAvailabilityZoneStatus** *(string) --*

                The status of the custom AZ.

              - **VpnDetails** *(dict) --*

                Information about the virtual private network (VPN) between the VMware vSphere cluster and the AWS website.

                - **VpnId** *(string) --*

                  The ID of the VPN.

                - **VpnTunnelOriginatorIP** *(string) --*

                  The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.

                - **VpnGatewayIp** *(string) --*

                  The IP address of network traffic from AWS to your on-premises data center.

                - **VpnPSK** *(string) --*

                  The preshared key (PSK) for the VPN.

                - **VpnName** *(string) --*

                  The name of the VPN.

                - **VpnState** *(string) --*

                  The state of the VPN.

        """
        pass

    def delete_db_cluster(
        self,
        DBClusterIdentifier: str,
        SkipFinalSnapshot: bool = None,
        FinalDBSnapshotIdentifier: str = None
    ) -> Dict[str, Any]:
        """
        The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster>`_

        **Request Syntax**
        ::

          response = client.delete_db_cluster(
              DBClusterIdentifier='string',
              SkipFinalSnapshot=True|False,
              FinalDBSnapshotIdentifier='string'
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.

          Constraints:

          * Must match an existing DBClusterIdentifier.

        :type SkipFinalSnapshot: boolean
        :param SkipFinalSnapshot:

          A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By default, this parameter is disabled.

          .. note::

            You must specify a ``FinalDBSnapshotIdentifier`` parameter if ``SkipFinalSnapshot`` is disabled.

        :type FinalDBSnapshotIdentifier: string
        :param FinalDBSnapshotIdentifier:

          The DB cluster snapshot identifier of the new DB cluster snapshot created when ``SkipFinalSnapshot`` is disabled.

          .. note::

            Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the ``SkipFinalShapshot`` parameter results in an error.

          Constraints:

          * Must be 1 to 255 letters, numbers, or hyphens.

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBCluster': {
                    'AllocatedStorage': 123,
                    'AvailabilityZones': [
                        'string',
                    ],
                    'BackupRetentionPeriod': 123,
                    'CharacterSetName': 'string',
                    'DatabaseName': 'string',
                    'DBClusterIdentifier': 'string',
                    'DBClusterParameterGroup': 'string',
                    'DBSubnetGroup': 'string',
                    'Status': 'string',
                    'PercentProgress': 'string',
                    'EarliestRestorableTime': datetime(2015, 1, 1),
                    'Endpoint': 'string',
                    'ReaderEndpoint': 'string',
                    'CustomEndpoints': [
                        'string',
                    ],
                    'MultiAZ': True|False,
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'Port': 123,
                    'MasterUsername': 'string',
                    'DBClusterOptionGroupMemberships': [
                        {
                            'DBClusterOptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'PreferredBackupWindow': 'string',
                    'PreferredMaintenanceWindow': 'string',
                    'ReplicationSourceIdentifier': 'string',
                    'ReadReplicaIdentifiers': [
                        'string',
                    ],
                    'DBClusterMembers': [
                        {
                            'DBInstanceIdentifier': 'string',
                            'IsClusterWriter': True|False,
                            'DBClusterParameterGroupStatus': 'string',
                            'PromotionTier': 123
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'HostedZoneId': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbClusterResourceId': 'string',
                    'DBClusterArn': 'string',
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'Status': 'string',
                            'FeatureName': 'string'
                        },
                    ],
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'CloneGroupId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'EarliestBacktrackTime': datetime(2015, 1, 1),
                    'BacktrackWindow': 123,
                    'BacktrackConsumedChangeRecords': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'Capacity': 123,
                    'EngineMode': 'string',
                    'ScalingConfigurationInfo': {
                        'MinCapacity': 123,
                        'MaxCapacity': 123,
                        'AutoPause': True|False,
                        'SecondsUntilAutoPause': 123,
                        'TimeoutAction': 'string'
                    },
                    'DeletionProtection': True|False,
                    'HttpEndpointEnabled': True|False,
                    'ActivityStreamMode': 'sync'|'async',
                    'ActivityStreamStatus': 'stopped'|'starting'|'started'|'stopping',
                    'ActivityStreamKmsKeyId': 'string',
                    'ActivityStreamKinesisStreamName': 'string',
                    'CopyTagsToSnapshot': True|False,
                    'CrossAccountClone': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBCluster** *(dict) --*

              Contains the details of an Amazon Aurora DB cluster.

              This data type is used as a response element in the ``DescribeDBClusters`` , ``StopDBCluster`` , and ``StartDBCluster`` actions.

              - **AllocatedStorage** *(integer) --*

                For all database engines except Amazon Aurora, ``AllocatedStorage`` specifies the allocated storage size in gibibytes (GiB). For Aurora, ``AllocatedStorage`` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.

                - *(string) --*

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this cluster is associated with.

              - **DatabaseName** *(string) --*

                Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.

              - **DBClusterIdentifier** *(string) --*

                Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

              - **DBClusterParameterGroup** *(string) --*

                Specifies the name of the DB cluster parameter group for the DB cluster.

              - **DBSubnetGroup** *(string) --*

                Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.

              - **Status** *(string) --*

                Specifies the current state of this DB cluster.

              - **PercentProgress** *(string) --*

                Specifies the progress of the operation as a percentage.

              - **EarliestRestorableTime** *(datetime) --*

                The earliest time to which a database can be restored with point-in-time restore.

              - **Endpoint** *(string) --*

                Specifies the connection endpoint for the primary instance of the DB cluster.

              - **ReaderEndpoint** *(string) --*

                The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.

                If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.

              - **CustomEndpoints** *(list) --*

                Identifies all custom endpoints associated with the cluster.

                - *(string) --*

              - **MultiAZ** *(boolean) --*

                Specifies whether the DB cluster has instances in multiple Availability Zones.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **Port** *(integer) --*

                Specifies the port that the database engine is listening on.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB cluster.

              - **DBClusterOptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB cluster.

                - *(dict) --*

                  Contains status information for a DB cluster option group.

                  - **DBClusterOptionGroupName** *(string) --*

                    Specifies the name of the DB cluster option group.

                  - **Status** *(string) --*

                    Specifies the status of the DB cluster option group.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **ReplicationSourceIdentifier** *(string) --*

                Contains the identifier of the source DB cluster if this DB cluster is a Read Replica.

              - **ReadReplicaIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB cluster.

                - *(string) --*

              - **DBClusterMembers** *(list) --*

                Provides the list of instances that make up the DB cluster.

                - *(dict) --*

                  Contains information about an instance that is part of a DB cluster.

                  - **DBInstanceIdentifier** *(string) --*

                    Specifies the instance identifier for this member of the DB cluster.

                  - **IsClusterWriter** *(boolean) --*

                    Value that is ``true`` if the cluster member is the primary instance for the DB cluster and ``false`` otherwise.

                  - **DBClusterParameterGroupStatus** *(string) --*

                    Specifies the status of the DB cluster parameter group for this member of the DB cluster.

                  - **PromotionTier** *(integer) --*

                    A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security groups that the DB cluster belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **HostedZoneId** *(string) --*

                Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is enabled, the AWS KMS key identifier for the encrypted DB cluster.

              - **DbClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **DBClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster.

              - **AssociatedRoles** *(list) --*

                Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB cluster and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB cluster.

                    * ``INVALID`` - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other AWS services on your behalf.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see  DBEngineVersion .

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                A value that indicates whether the mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.

              - **CloneGroupId** *(string) --*

                Identifies the clone group to which the DB cluster is associated.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **EarliestBacktrackTime** *(datetime) --*

                The earliest time to which a DB cluster can be backtracked.

              - **BacktrackWindow** *(integer) --*

                The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.

              - **BacktrackConsumedChangeRecords** *(integer) --*

                The number of change records stored for Backtrack.

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB cluster is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html>`__ in the *Amazon Aurora User Guide.*

                - *(string) --*

              - **Capacity** *(integer) --*

                The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.

                For more information about Aurora Serverless, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

              - **EngineMode** *(string) --*

                The DB engine mode of the DB cluster, either ``provisioned`` , ``serverless`` , ``parallelquery`` , ``global`` , or ``multimaster`` .

              - **ScalingConfigurationInfo** *(dict) --*

                Shows the scaling configuration for an Aurora DB cluster in ``serverless`` DB engine mode.

                For more information, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

                - **MinCapacity** *(integer) --*

                  The maximum capacity for the Aurora DB cluster in ``serverless`` DB engine mode.

                - **MaxCapacity** *(integer) --*

                  The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

                - **AutoPause** *(boolean) --*

                  A value that indicates whether automatic pause is allowed for the Aurora DB cluster in ``serverless`` DB engine mode.

                  When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.

                - **SecondsUntilAutoPause** *(integer) --*

                  The remaining amount of time, in seconds, before the Aurora DB cluster in ``serverless`` mode is paused. A DB cluster can be paused only when it's idle (it has no connections).

                - **TimeoutAction** *(string) --*

                  The timeout action of a call to ``ModifyCurrentDBClusterCapacity`` , either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.

              - **HttpEndpointEnabled** *(boolean) --*

                A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.

                When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

                For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

              - **ActivityStreamMode** *(string) --*

                The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.

              - **ActivityStreamStatus** *(string) --*

                The status of the database activity stream.

              - **ActivityStreamKmsKeyId** *(string) --*

                The AWS KMS key identifier used for encrypting messages in the database activity stream.

              - **ActivityStreamKinesisStreamName** *(string) --*

                The name of the Amazon Kinesis data stream used for the database activity stream.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.

              - **CrossAccountClone** *(boolean) --*

                Specifies whether the DB cluster is a clone of a DB cluster owned by a different AWS account.

        """
        pass

    def delete_db_cluster_endpoint(
        self,
        DBClusterEndpointIdentifier: str
    ) -> Dict[str, Any]:
        """
        Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint>`_

        **Request Syntax**
        ::

          response = client.delete_db_cluster_endpoint(
              DBClusterEndpointIdentifier='string'
          )
        :type DBClusterEndpointIdentifier: string
        :param DBClusterEndpointIdentifier: **[REQUIRED]**

          The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterEndpointIdentifier': 'string',
                'DBClusterIdentifier': 'string',
                'DBClusterEndpointResourceIdentifier': 'string',
                'Endpoint': 'string',
                'Status': 'string',
                'EndpointType': 'string',
                'CustomEndpointType': 'string',
                'StaticMembers': [
                    'string',
                ],
                'ExcludedMembers': [
                    'string',
                ],
                'DBClusterEndpointArn': 'string'
            }
          **Response Structure**

          - *(dict) --*

            This data type represents the information you need to connect to an Amazon Aurora DB cluster. This data type is used as a response element in the following actions:

            * ``CreateDBClusterEndpoint``

            * ``DescribeDBClusterEndpoints``

            * ``ModifyDBClusterEndpoint``

            * ``DeleteDBClusterEndpoint``

            For the data structure that represents Amazon RDS DB instance endpoints, see ``Endpoint`` .

            - **DBClusterEndpointIdentifier** *(string) --*

              The identifier associated with the endpoint. This parameter is stored as a lowercase string.

            - **DBClusterIdentifier** *(string) --*

              The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.

            - **DBClusterEndpointResourceIdentifier** *(string) --*

              A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.

            - **Endpoint** *(string) --*

              The DNS address of the endpoint.

            - **Status** *(string) --*

              The current status of the endpoint. One of: ``creating`` , ``available`` , ``deleting`` , ``modifying`` .

            - **EndpointType** *(string) --*

              The type of the endpoint. One of: ``READER`` , ``WRITER`` , ``CUSTOM`` .

            - **CustomEndpointType** *(string) --*

              The type associated with a custom endpoint. One of: ``READER`` , ``WRITER`` , ``ANY`` .

            - **StaticMembers** *(list) --*

              List of DB instance identifiers that are part of the custom endpoint group.

              - *(string) --*

            - **ExcludedMembers** *(list) --*

              List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.

              - *(string) --*

            - **DBClusterEndpointArn** *(string) --*

              The Amazon Resource Name (ARN) for the endpoint.

        """
        pass

    def delete_db_cluster_parameter_group(
        self,
        DBClusterParameterGroupName: str
    ) -> None:
        """
        Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup>`_

        **Request Syntax**
        ::

          response = client.delete_db_cluster_parameter_group(
              DBClusterParameterGroupName='string'
          )
        :type DBClusterParameterGroupName: string
        :param DBClusterParameterGroupName: **[REQUIRED]**

          The name of the DB cluster parameter group.

          Constraints:

          * Must be the name of an existing DB cluster parameter group.

          * You can't delete a default DB cluster parameter group.

          * Can't be associated with any DB clusters.

        :returns: None
        """
        pass

    def delete_db_cluster_snapshot(
        self,
        DBClusterSnapshotIdentifier: str
    ) -> Dict[str, Any]:
        """
        Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.

        .. note::

          The DB cluster snapshot must be in the ``available`` state to be deleted.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot>`_

        **Request Syntax**
        ::

          response = client.delete_db_cluster_snapshot(
              DBClusterSnapshotIdentifier='string'
          )
        :type DBClusterSnapshotIdentifier: string
        :param DBClusterSnapshotIdentifier: **[REQUIRED]**

          The identifier of the DB cluster snapshot to delete.

          Constraints: Must be the name of an existing DB cluster snapshot in the ``available`` state.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterSnapshot': {
                    'AvailabilityZones': [
                        'string',
                    ],
                    'DBClusterSnapshotIdentifier': 'string',
                    'DBClusterIdentifier': 'string',
                    'SnapshotCreateTime': datetime(2015, 1, 1),
                    'Engine': 'string',
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'VpcId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'SnapshotType': 'string',
                    'PercentProgress': 123,
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DBClusterSnapshotArn': 'string',
                    'SourceDBClusterSnapshotArn': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterSnapshot** *(dict) --*

              Contains the details for an Amazon RDS DB cluster snapshot

              This data type is used as a response element in the ``DescribeDBClusterSnapshots`` action.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.

                - *(string) --*

              - **DBClusterSnapshotIdentifier** *(string) --*

                Specifies the identifier for the DB cluster snapshot.

              - **DBClusterIdentifier** *(string) --*

                Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.

              - **SnapshotCreateTime** *(datetime) --*

                Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **Engine** *(string) --*

                Specifies the name of the database engine.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Specifies the status of this DB cluster snapshot.

              - **Port** *(integer) --*

                Specifies the port that the DB cluster was listening on at the time of the snapshot.

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB cluster snapshot.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **MasterUsername** *(string) --*

                Provides the master username for the DB cluster snapshot.

              - **EngineVersion** *(string) --*

                Provides the version of the database engine for this DB cluster snapshot.

              - **LicenseModel** *(string) --*

                Provides the license model information for this DB cluster snapshot.

              - **SnapshotType** *(string) --*

                Provides the type of the DB cluster snapshot.

              - **PercentProgress** *(integer) --*

                Specifies the percentage of the estimated data that has been transferred.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster snapshot is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.

              - **DBClusterSnapshotArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster snapshot.

              - **SourceDBClusterSnapshotArn** *(string) --*

                If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

        """
        pass

    def delete_db_instance(
        self,
        DBInstanceIdentifier: str,
        SkipFinalSnapshot: bool = None,
        FinalDBSnapshotIdentifier: str = None,
        DeleteAutomatedBackups: bool = None
    ) -> Dict[str, Any]:
        """
        The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by ``DeleteDBInstance`` are not deleted.

        If you request a final DB snapshot the status of the Amazon RDS DB instance is ``deleting`` until the DB snapshot is created. The API action ``DescribeDBInstance`` is used to monitor the status of this operation. The action can't be canceled or reverted once submitted.

        Note that when a DB instance is in a failure state and has a status of ``failed`` , ``incompatible-restore`` , or ``incompatible-network`` , you can only delete it when you skip creation of the final snapshot with the ``SkipFinalSnapshot`` parameter.

        If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of the following conditions are true:

        * The DB cluster is a Read Replica of another Amazon Aurora DB cluster.

        * The DB instance is the only instance in the DB cluster.

        To delete a DB instance in this case, first call the ``PromoteReadReplicaDBCluster`` API action to promote the DB cluster so it's no longer a Read Replica. After the promotion completes, then call the ``DeleteDBInstance`` API action to delete the final instance in the DB cluster.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance>`_

        **Request Syntax**
        ::

          response = client.delete_db_instance(
              DBInstanceIdentifier='string',
              SkipFinalSnapshot=True|False,
              FinalDBSnapshotIdentifier='string',
              DeleteAutomatedBackups=True|False
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.

          Constraints:

          * Must match the name of an existing DB instance.

        :type SkipFinalSnapshot: boolean
        :param SkipFinalSnapshot:

          A value that indicates whether to skip the creation of a final DB snapshot before the DB instance is deleted. If skip is specified, no DB snapshot is created. If skip isn't specified, a DB snapshot is created before the DB instance is deleted. By default, skip isn't specified, and the DB snapshot is created.

          Note that when a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or 'incompatible-network', it can only be deleted when skip is specified.

          Specify skip when deleting a Read Replica.

          .. note::

            The FinalDBSnapshotIdentifier parameter must be specified if skip isn't specified.

        :type FinalDBSnapshotIdentifier: string
        :param FinalDBSnapshotIdentifier:

          The ``DBSnapshotIdentifier`` of the new ``DBSnapshot`` created when the ``SkipFinalSnapshot`` parameter is disabled.

          .. note::

            Specifying this parameter and also specifying to skip final DB snapshot creation in SkipFinalShapshot results in an error.

          Constraints:

          * Must be 1 to 255 letters or numbers.

          * First character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          * Can't be specified when deleting a Read Replica.

        :type DeleteAutomatedBackups: boolean
        :param DeleteAutomatedBackups:

          A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBInstance': {
                    'DBInstanceIdentifier': 'string',
                    'DBInstanceClass': 'string',
                    'Engine': 'string',
                    'DBInstanceStatus': 'string',
                    'MasterUsername': 'string',
                    'DBName': 'string',
                    'Endpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'AllocatedStorage': 123,
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'PreferredBackupWindow': 'string',
                    'BackupRetentionPeriod': 123,
                    'DBSecurityGroups': [
                        {
                            'DBSecurityGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'DBParameterGroups': [
                        {
                            'DBParameterGroupName': 'string',
                            'ParameterApplyStatus': 'string'
                        },
                    ],
                    'AvailabilityZone': 'string',
                    'DBSubnetGroup': {
                        'DBSubnetGroupName': 'string',
                        'DBSubnetGroupDescription': 'string',
                        'VpcId': 'string',
                        'SubnetGroupStatus': 'string',
                        'Subnets': [
                            {
                                'SubnetIdentifier': 'string',
                                'SubnetAvailabilityZone': {
                                    'Name': 'string'
                                },
                                'SubnetStatus': 'string'
                            },
                        ],
                        'DBSubnetGroupArn': 'string'
                    },
                    'PreferredMaintenanceWindow': 'string',
                    'PendingModifiedValues': {
                        'DBInstanceClass': 'string',
                        'AllocatedStorage': 123,
                        'MasterUserPassword': 'string',
                        'Port': 123,
                        'BackupRetentionPeriod': 123,
                        'MultiAZ': True|False,
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'DBInstanceIdentifier': 'string',
                        'StorageType': 'string',
                        'CACertificateIdentifier': 'string',
                        'DBSubnetGroupName': 'string',
                        'PendingCloudwatchLogsExports': {
                            'LogTypesToEnable': [
                                'string',
                            ],
                            'LogTypesToDisable': [
                                'string',
                            ]
                        },
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ]
                    },
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'MultiAZ': True|False,
                    'EngineVersion': 'string',
                    'AutoMinorVersionUpgrade': True|False,
                    'ReadReplicaSourceDBInstanceIdentifier': 'string',
                    'ReadReplicaDBInstanceIdentifiers': [
                        'string',
                    ],
                    'ReadReplicaDBClusterIdentifiers': [
                        'string',
                    ],
                    'LicenseModel': 'string',
                    'Iops': 123,
                    'OptionGroupMemberships': [
                        {
                            'OptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'CharacterSetName': 'string',
                    'SecondaryAvailabilityZone': 'string',
                    'PubliclyAccessible': True|False,
                    'StatusInfos': [
                        {
                            'StatusType': 'string',
                            'Normal': True|False,
                            'Status': 'string',
                            'Message': 'string'
                        },
                    ],
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'DbInstancePort': 123,
                    'DBClusterIdentifier': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbiResourceId': 'string',
                    'CACertificateIdentifier': 'string',
                    'DomainMemberships': [
                        {
                            'Domain': 'string',
                            'Status': 'string',
                            'FQDN': 'string',
                            'IAMRoleName': 'string'
                        },
                    ],
                    'CopyTagsToSnapshot': True|False,
                    'MonitoringInterval': 123,
                    'EnhancedMonitoringResourceArn': 'string',
                    'MonitoringRoleArn': 'string',
                    'PromotionTier': 123,
                    'DBInstanceArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'PerformanceInsightsEnabled': True|False,
                    'PerformanceInsightsKMSKeyId': 'string',
                    'PerformanceInsightsRetentionPeriod': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DeletionProtection': True|False,
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'FeatureName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'ListenerEndpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'MaxAllocatedStorage': 123
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBInstance** *(dict) --*

              Contains the details of an Amazon RDS DB instance.

              This data type is used as a response element in the ``DescribeDBInstances`` action.

              - **DBInstanceIdentifier** *(string) --*

                Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.

              - **DBInstanceClass** *(string) --*

                Contains the name of the compute and memory capacity class of the DB instance.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB instance.

              - **DBInstanceStatus** *(string) --*

                Specifies the current state of this database.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB instance.

              - **DBName** *(string) --*

                The meaning of this parameter differs according to the database engine you use.

                 **MySQL, MariaDB, SQL Server, PostgreSQL**

                Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.

                Type: String

                 **Oracle**

                Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.

              - **Endpoint** *(dict) --*

                Specifies the connection endpoint.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size specified in gibibytes.

              - **InstanceCreateTime** *(datetime) --*

                Provides the date and time the DB instance was created.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **DBSecurityGroups** *(list) --*

                A list of DB security group elements containing ``DBSecurityGroup.Name`` and ``DBSecurityGroup.Status`` subelements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceToPointInTime``

                  - **DBSecurityGroupName** *(string) --*

                    The name of the DB security group.

                  - **Status** *(string) --*

                    The status of the DB security group.

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security group elements that the DB instance belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **DBParameterGroups** *(list) --*

                Provides the list of DB parameter groups applied to this DB instance.

                - *(dict) --*

                  The status of the DB parameter group.

                  This data type is used as a response element in the following actions:

                  * ``CreateDBInstance``

                  * ``CreateDBInstanceReadReplica``

                  * ``DeleteDBInstance``

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  - **DBParameterGroupName** *(string) --*

                    The name of the DB parameter group.

                  - **ParameterApplyStatus** *(string) --*

                    The status of parameter updates.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance is located in.

              - **DBSubnetGroup** *(dict) --*

                Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.

                - **DBSubnetGroupName** *(string) --*

                  The name of the DB subnet group.

                - **DBSubnetGroupDescription** *(string) --*

                  Provides the description of the DB subnet group.

                - **VpcId** *(string) --*

                  Provides the VpcId of the DB subnet group.

                - **SubnetGroupStatus** *(string) --*

                  Provides the status of the DB subnet group.

                - **Subnets** *(list) --*

                  Contains a list of ``Subnet`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                    - **SubnetIdentifier** *(string) --*

                      Specifies the identifier of the subnet.

                    - **SubnetAvailabilityZone** *(dict) --*

                      Contains Availability Zone information.

                      This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                      - **Name** *(string) --*

                        The name of the Availability Zone.

                    - **SubnetStatus** *(string) --*

                      Specifies the status of the subnet.

                - **DBSubnetGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB subnet group.

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **PendingModifiedValues** *(dict) --*

                Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.

                - **DBInstanceClass** *(string) --*

                  Contains the new ``DBInstanceClass`` for the DB instance that will be applied or is currently being applied.

                - **AllocatedStorage** *(integer) --*

                  Contains the new ``AllocatedStorage`` size for the DB instance that will be applied or is currently being applied.

                - **MasterUserPassword** *(string) --*

                  Contains the pending or currently-in-progress change of the master credentials for the DB instance.

                - **Port** *(integer) --*

                  Specifies the pending port for the DB instance.

                - **BackupRetentionPeriod** *(integer) --*

                  Specifies the pending number of days for which automated backups are retained.

                - **MultiAZ** *(boolean) --*

                  Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **LicenseModel** *(string) --*

                  The license model for the DB instance.

                  Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

                - **Iops** *(integer) --*

                  Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.

                - **DBInstanceIdentifier** *(string) --*

                  Contains the new ``DBInstanceIdentifier`` for the DB instance that will be applied or is currently being applied.

                - **StorageType** *(string) --*

                  Specifies the storage type to be associated with the DB instance.

                - **CACertificateIdentifier** *(string) --*

                  Specifies the identifier of the CA certificate for the DB instance.

                - **DBSubnetGroupName** *(string) --*

                  The new DB subnet group for the DB instance.

                - **PendingCloudwatchLogsExports** *(dict) --*

                  A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.

                  - **LogTypesToEnable** *(list) --*

                    Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.

                    - *(string) --*

                  - **LogTypesToDisable** *(list) --*

                    Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.

                    - *(string) --*

                - **ProcessorFeatures** *(list) --*

                  The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                  - *(dict) --*

                    Contains the processor features of a DB instance class.

                    To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                    You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                    * ``CreateDBInstance``

                    * ``ModifyDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceFromS3``

                    * ``RestoreDBInstanceToPointInTime``

                    You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                    In addition, you can use the following actions for DB instance class processor information:

                    * ``DescribeDBInstances``

                    * ``DescribeDBSnapshots``

                    * ``DescribeValidDBInstanceModifications``

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **Value** *(string) --*

                      The value of a processor feature name.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **MultiAZ** *(boolean) --*

                Specifies if the DB instance is a Multi-AZ deployment.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **AutoMinorVersionUpgrade** *(boolean) --*

                Indicates that minor version patches are applied automatically.

              - **ReadReplicaSourceDBInstanceIdentifier** *(string) --*

                Contains the identifier of the source DB instance if this DB instance is a Read Replica.

              - **ReadReplicaDBInstanceIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB instance.

                - *(string) --*

              - **ReadReplicaDBClusterIdentifiers** *(list) --*

                Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a Read Replica. For example, when you create an Aurora Read Replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster for the Aurora Read Replica is shown. This output does not contain information about cross region Aurora Read Replicas.

                .. note::

                  Currently, each RDS DB instance can have only one Aurora Read Replica.

                - *(string) --*

              - **LicenseModel** *(string) --*

                License model information for this DB instance.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value.

              - **OptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB instance.

                - *(dict) --*

                  Provides information on the option groups the DB instance is a member of.

                  - **OptionGroupName** *(string) --*

                    The name of the option group that the instance belongs to.

                  - **Status** *(string) --*

                    The status of the DB instance's option group membership. Valid values are: ``in-sync`` , ``pending-apply`` , ``pending-removal`` , ``pending-maintenance-apply`` , ``pending-maintenance-removal`` , ``applying`` , ``removing`` , and ``failed`` .

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this instance is associated with.

              - **SecondaryAvailabilityZone** *(string) --*

                If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.

              - **PubliclyAccessible** *(boolean) --*

                Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address.

              - **StatusInfos** *(list) --*

                The status of a Read Replica. If the instance isn't a Read Replica, this is blank.

                - *(dict) --*

                  Provides a list of status information for a DB instance.

                  - **StatusType** *(string) --*

                    This value is currently "read replication."

                  - **Normal** *(boolean) --*

                    Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.

                  - **Status** *(string) --*

                    Status of the DB instance. For a StatusType of Read Replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.

                  - **Message** *(string) --*

                    Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB instance.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which the instance is associated for TDE encryption.

              - **DbInstancePort** *(integer) --*

                Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.

              - **DBClusterIdentifier** *(string) --*

                If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB instance is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB instance.

              - **DbiResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.

              - **CACertificateIdentifier** *(string) --*

                The identifier of the CA certificate for this DB instance.

              - **DomainMemberships** *(list) --*

                The Active Directory Domain membership records associated with the DB instance.

                - *(dict) --*

                  An Active Directory Domain membership record associated with the DB instance.

                  - **Domain** *(string) --*

                    The identifier of the Active Directory Domain.

                  - **Status** *(string) --*

                    The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).

                  - **FQDN** *(string) --*

                    The fully qualified domain name of the Active Directory Domain.

                  - **IAMRoleName** *(string) --*

                    The name of the IAM role to be used when making API calls to the Directory Service.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB instance to snapshots of the DB instance.

                 **Amazon Aurora**

                Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see ``DBCluster`` .

              - **MonitoringInterval** *(integer) --*

                The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.

              - **EnhancedMonitoringResourceArn** *(string) --*

                The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.

              - **MonitoringRoleArn** *(string) --*

                The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.

              - **PromotionTier** *(integer) --*

                A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **DBInstanceArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB instance.

              - **Timezone** *(string) --*

                The time zone of the DB instance. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

                IAM database authentication can be enabled for the following database engines

                * For MySQL 5.6, minor version 5.6.34 or higher

                * For MySQL 5.7, minor version 5.7.16 or higher

                * Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.

              - **PerformanceInsightsEnabled** *(boolean) --*

                True if Performance Insights is enabled for the DB instance, and otherwise false.

              - **PerformanceInsightsKMSKeyId** *(string) --*

                The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

              - **PerformanceInsightsRetentionPeriod** *(integer) --*

                The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB instance is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html>`__ in the *Amazon RDS User Guide.*

                - *(string) --*

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

              - **AssociatedRoles** *(list) --*

                The AWS Identity and Access Management (IAM) roles associated with the DB instance.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB instance.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see ``DBEngineVersion`` .

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB instance and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB instance.

                    * ``INVALID`` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other AWS services on your behalf.

              - **ListenerEndpoint** *(dict) --*

                Specifies the listener connection endpoint for SQL Server Always On.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **MaxAllocatedStorage** *(integer) --*

                The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        """
        pass

    def delete_db_instance_automated_backup(
        self,
        DbiResourceId: str
    ) -> Dict[str, Any]:
        """
        Deletes automated backups based on the source instance's ``DbiResourceId`` value or the restorable instance's resource ID.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup>`_

        **Request Syntax**
        ::

          response = client.delete_db_instance_automated_backup(
              DbiResourceId='string'
          )
        :type DbiResourceId: string
        :param DbiResourceId: **[REQUIRED]**

          The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBInstanceAutomatedBackup': {
                    'DBInstanceArn': 'string',
                    'DbiResourceId': 'string',
                    'Region': 'string',
                    'DBInstanceIdentifier': 'string',
                    'RestoreWindow': {
                        'EarliestTime': datetime(2015, 1, 1),
                        'LatestTime': datetime(2015, 1, 1)
                    },
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'AvailabilityZone': 'string',
                    'VpcId': 'string',
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'Iops': 123,
                    'OptionGroupName': 'string',
                    'TdeCredentialArn': 'string',
                    'Encrypted': True|False,
                    'StorageType': 'string',
                    'KmsKeyId': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBInstanceAutomatedBackup** *(dict) --*

              An automated backup of a DB instance. It it consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.

              - **DBInstanceArn** *(string) --*

                The Amazon Resource Name (ARN) for the automated backup.

              - **DbiResourceId** *(string) --*

                The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

              - **Region** *(string) --*

                The AWS Region associated with the automated backup.

              - **DBInstanceIdentifier** *(string) --*

                The customer id of the instance that is/was associated with the automated backup.

              - **RestoreWindow** *(dict) --*

                Earliest and latest time an instance can be restored to.

                - **EarliestTime** *(datetime) --*

                  The earliest time you can restore an instance to.

                - **LatestTime** *(datetime) --*

                  The latest time you can restore an instance to.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Provides a list of status information for an automated backup:

                * ``active`` - automated backups for current instances

                * ``retained`` - automated backups for deleted instances

                * ``creating`` - automated backups that are waiting for the first automated snapshot to be available.

              - **Port** *(integer) --*

                The port number that the automated backup used for connections.

                Default: Inherits from the source DB instance

                Valid Values: ``1150-65535``

              - **AvailabilityZone** *(string) --*

                The Availability Zone that the automated backup was created in. For information on AWS Regions and Availability Zones, see `Regions and Availability Zones <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html>`__ .

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB instance

              - **InstanceCreateTime** *(datetime) --*

                Provides the date and time that the DB instance was created.

              - **MasterUsername** *(string) --*

                The license model of an automated backup.

              - **Engine** *(string) --*

                The name of the database engine for this automated backup.

              - **EngineVersion** *(string) --*

                The version of the database engine for the automated backup.

              - **LicenseModel** *(string) --*

                License model information for the automated backup.

              - **Iops** *(integer) --*

                The IOPS (I/O operations per second) value for the automated backup.

              - **OptionGroupName** *(string) --*

                The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which the automated backup is associated for TDE encryption.

              - **Encrypted** *(boolean) --*

                Specifies whether the automated backup is encrypted.

              - **StorageType** *(string) --*

                Specifies the storage type associated with the automated backup.

              - **KmsKeyId** *(string) --*

                The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

              - **Timezone** *(string) --*

                The time zone of the automated backup. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

        """
        pass

    def delete_db_parameter_group(
        self,
        DBParameterGroupName: str
    ) -> None:
        """
        Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB instances.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup>`_

        **Request Syntax**
        ::

          response = client.delete_db_parameter_group(
              DBParameterGroupName='string'
          )
        :type DBParameterGroupName: string
        :param DBParameterGroupName: **[REQUIRED]**

          The name of the DB parameter group.

          Constraints:

          * Must be the name of an existing DB parameter group

          * You can't delete a default DB parameter group

          * Can't be associated with any DB instances

        :returns: None
        """
        pass

    def delete_db_security_group(
        self,
        DBSecurityGroupName: str
    ) -> None:
        """
        Deletes a DB security group.

        .. note::

          The specified DB security group must not be associated with any DB instances.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup>`_

        **Request Syntax**
        ::

          response = client.delete_db_security_group(
              DBSecurityGroupName='string'
          )
        :type DBSecurityGroupName: string
        :param DBSecurityGroupName: **[REQUIRED]**

          The name of the DB security group to delete.

          .. note::

            You can't delete the default DB security group.

          Constraints:

          * Must be 1 to 255 letters, numbers, or hyphens.

          * First character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          * Must not be "Default"

        :returns: None
        """
        pass

    def delete_db_snapshot(
        self,
        DBSnapshotIdentifier: str
    ) -> Dict[str, Any]:
        """
        Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.

        .. note::

          The DB snapshot must be in the ``available`` state to be deleted.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot>`_

        **Request Syntax**
        ::

          response = client.delete_db_snapshot(
              DBSnapshotIdentifier='string'
          )
        :type DBSnapshotIdentifier: string
        :param DBSnapshotIdentifier: **[REQUIRED]**

          The DB snapshot identifier.

          Constraints: Must be the name of an existing DB snapshot in the ``available`` state.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSnapshot': {
                    'DBSnapshotIdentifier': 'string',
                    'DBInstanceIdentifier': 'string',
                    'SnapshotCreateTime': datetime(2015, 1, 1),
                    'Engine': 'string',
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'AvailabilityZone': 'string',
                    'VpcId': 'string',
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'SnapshotType': 'string',
                    'Iops': 123,
                    'OptionGroupName': 'string',
                    'PercentProgress': 123,
                    'SourceRegion': 'string',
                    'SourceDBSnapshotIdentifier': 'string',
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'Encrypted': True|False,
                    'KmsKeyId': 'string',
                    'DBSnapshotArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DbiResourceId': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSnapshot** *(dict) --*

              Contains the details of an Amazon RDS DB snapshot.

              This data type is used as a response element in the ``DescribeDBSnapshots`` action.

              - **DBSnapshotIdentifier** *(string) --*

                Specifies the identifier for the DB snapshot.

              - **DBInstanceIdentifier** *(string) --*

                Specifies the DB instance identifier of the DB instance this DB snapshot was created from.

              - **SnapshotCreateTime** *(datetime) --*

                Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **Engine** *(string) --*

                Specifies the name of the database engine.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Specifies the status of this DB snapshot.

              - **Port** *(integer) --*

                Specifies the port that the database engine was listening on at the time of the snapshot.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB snapshot.

              - **InstanceCreateTime** *(datetime) --*

                Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **MasterUsername** *(string) --*

                Provides the master username for the DB snapshot.

              - **EngineVersion** *(string) --*

                Specifies the version of the database engine.

              - **LicenseModel** *(string) --*

                License model information for the restored DB instance.

              - **SnapshotType** *(string) --*

                Provides the type of the DB snapshot.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.

              - **OptionGroupName** *(string) --*

                Provides the option group name for the DB snapshot.

              - **PercentProgress** *(integer) --*

                The percentage of the estimated data that has been transferred.

              - **SourceRegion** *(string) --*

                The AWS Region that the DB snapshot was created in or copied from.

              - **SourceDBSnapshotIdentifier** *(string) --*

                The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has value in case of cross-customer or cross-region copy.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB snapshot.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which to associate the instance for TDE encryption.

              - **Encrypted** *(boolean) --*

                Specifies whether the DB snapshot is encrypted.

              - **KmsKeyId** *(string) --*

                If ``Encrypted`` is true, the AWS KMS key identifier for the encrypted DB snapshot.

              - **DBSnapshotArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB snapshot.

              - **Timezone** *(string) --*

                The time zone of the DB snapshot. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DbiResourceId** *(string) --*

                The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

        """
        pass

    def delete_db_subnet_group(
        self,
        DBSubnetGroupName: str
    ) -> None:
        """
        Deletes a DB subnet group.

        .. note::

          The specified database subnet group must not be associated with any DB instances.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup>`_

        **Request Syntax**
        ::

          response = client.delete_db_subnet_group(
              DBSubnetGroupName='string'
          )
        :type DBSubnetGroupName: string
        :param DBSubnetGroupName: **[REQUIRED]**

          The name of the database subnet group to delete.

          .. note::

            You can't delete the default subnet group.

          Constraints:

          Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.

          Example: ``mySubnetgroup``

        :returns: None
        """
        pass

    def delete_event_subscription(
        self,
        SubscriptionName: str
    ) -> Dict[str, Any]:
        """
        Deletes an RDS event notification subscription.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription>`_

        **Request Syntax**
        ::

          response = client.delete_event_subscription(
              SubscriptionName='string'
          )
        :type SubscriptionName: string
        :param SubscriptionName: **[REQUIRED]**

          The name of the RDS event notification subscription you want to delete.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'EventSubscription': {
                    'CustomerAwsId': 'string',
                    'CustSubscriptionId': 'string',
                    'SnsTopicArn': 'string',
                    'Status': 'string',
                    'SubscriptionCreationTime': 'string',
                    'SourceType': 'string',
                    'SourceIdsList': [
                        'string',
                    ],
                    'EventCategoriesList': [
                        'string',
                    ],
                    'Enabled': True|False,
                    'EventSubscriptionArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **EventSubscription** *(dict) --*

              Contains the results of a successful invocation of the ``DescribeEventSubscriptions`` action.

              - **CustomerAwsId** *(string) --*

                The AWS customer account associated with the RDS event notification subscription.

              - **CustSubscriptionId** *(string) --*

                The RDS event notification subscription Id.

              - **SnsTopicArn** *(string) --*

                The topic ARN of the RDS event notification subscription.

              - **Status** *(string) --*

                The status of the RDS event notification subscription.

                Constraints:

                Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist

                The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.

              - **SubscriptionCreationTime** *(string) --*

                The time the RDS event notification subscription was created.

              - **SourceType** *(string) --*

                The source type for the RDS event notification subscription.

              - **SourceIdsList** *(list) --*

                A list of source IDs for the RDS event notification subscription.

                - *(string) --*

              - **EventCategoriesList** *(list) --*

                A list of event categories for the RDS event notification subscription.

                - *(string) --*

              - **Enabled** *(boolean) --*

                A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.

              - **EventSubscriptionArn** *(string) --*

                The Amazon Resource Name (ARN) for the event subscription.

        """
        pass

    def delete_global_cluster(
        self,
        GlobalClusterIdentifier: str
    ) -> Dict[str, Any]:
        """
        Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed first.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster>`_

        **Request Syntax**
        ::

          response = client.delete_global_cluster(
              GlobalClusterIdentifier='string'
          )
        :type GlobalClusterIdentifier: string
        :param GlobalClusterIdentifier: **[REQUIRED]**

          The cluster identifier of the global database cluster being deleted.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'GlobalCluster': {
                    'GlobalClusterIdentifier': 'string',
                    'GlobalClusterResourceId': 'string',
                    'GlobalClusterArn': 'string',
                    'Status': 'string',
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'DatabaseName': 'string',
                    'StorageEncrypted': True|False,
                    'DeletionProtection': True|False,
                    'GlobalClusterMembers': [
                        {
                            'DBClusterArn': 'string',
                            'Readers': [
                                'string',
                            ],
                            'IsWriter': True|False
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **GlobalCluster** *(dict) --*

              A data type representing an Aurora global database.

              - **GlobalClusterIdentifier** *(string) --*

                Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster.

              - **GlobalClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **GlobalClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the global database cluster.

              - **Status** *(string) --*

                Specifies the current state of this global database cluster.

              - **Engine** *(string) --*

                The Aurora database engine used by the global database cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **DatabaseName** *(string) --*

                The default database name within the new global database cluster.

              - **StorageEncrypted** *(boolean) --*

                The storage encryption setting for the global database cluster.

              - **DeletionProtection** *(boolean) --*

                The deletion protection setting for the new global database cluster.

              - **GlobalClusterMembers** *(list) --*

                The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item.

                - *(dict) --*

                  A data structure with information about any primary and secondary clusters associated with an Aurora global database.

                  - **DBClusterArn** *(string) --*

                    The Amazon Resource Name (ARN) for each Aurora cluster.

                  - **Readers** *(list) --*

                    The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database.

                    - *(string) --*

                  - **IsWriter** *(boolean) --*

                    Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated.

        """
        pass

    def delete_installation_media(
        self,
        InstallationMediaId: str
    ) -> Dict[str, Any]:
        """
        Deletes the installation medium for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteInstallationMedia>`_

        **Request Syntax**
        ::

          response = client.delete_installation_media(
              InstallationMediaId='string'
          )
        :type InstallationMediaId: string
        :param InstallationMediaId: **[REQUIRED]**

          The installation medium ID.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'InstallationMediaId': 'string',
                'CustomAvailabilityZoneId': 'string',
                'Engine': 'string',
                'EngineVersion': 'string',
                'EngineInstallationMediaPath': 'string',
                'OSInstallationMediaPath': 'string',
                'Status': 'string',
                'FailureCause': {
                    'Message': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            Contains the installation media for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.

            - **InstallationMediaId** *(string) --*

              The installation medium ID.

            - **CustomAvailabilityZoneId** *(string) --*

              The custom Availability Zone (AZ) that contains the installation media.

            - **Engine** *(string) --*

              The DB engine.

            - **EngineVersion** *(string) --*

              The engine version of the DB engine.

            - **EngineInstallationMediaPath** *(string) --*

              The path to the installation medium for the DB engine.

            - **OSInstallationMediaPath** *(string) --*

              The path to the installation medium for the operating system associated with the DB engine.

            - **Status** *(string) --*

              The status of the installation medium.

            - **FailureCause** *(dict) --*

              If an installation media failure occurred, the cause of the failure.

              - **Message** *(string) --*

                The reason that an installation media import failed.

        """
        pass

    def delete_option_group(
        self,
        OptionGroupName: str
    ) -> None:
        """
        Deletes an existing option group.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup>`_

        **Request Syntax**
        ::

          response = client.delete_option_group(
              OptionGroupName='string'
          )
        :type OptionGroupName: string
        :param OptionGroupName: **[REQUIRED]**

          The name of the option group to be deleted.

          .. note::

            You can't delete default option groups.

        :returns: None
        """
        pass

    def describe_account_attributes(
        self
    ) -> Dict[str, Any]:
        """
        Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.

        This command doesn't take any parameters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes>`_

        **Request Syntax**
        ::

          response = client.describe_account_attributes()

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'AccountQuotas': [
                    {
                        'AccountQuotaName': 'string',
                        'Used': 123,
                        'Max': 123
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Data returned by the **DescribeAccountAttributes** action.

            - **AccountQuotas** *(list) --*

              A list of ``AccountQuota`` objects. Within this list, each quota has a name, a count of usage toward the quota maximum, and a maximum value for the quota.

              - *(dict) --*

                Describes a quota for an AWS account.

                The following are account quotas:

                * ``AllocatedStorage`` - The total allocated storage per account, in GiB. The used value is the total allocated storage in the account, in GiB.

                * ``AuthorizationsPerDBSecurityGroup`` - The number of ingress rules per DB security group. The used value is the highest number of ingress rules in a DB security group in the account. Other DB security groups in the account might have a lower number of ingress rules.

                * ``CustomEndpointsPerDBCluster`` - The number of custom endpoints per DB cluster. The used value is the highest number of custom endpoints in a DB clusters in the account. Other DB clusters in the account might have a lower number of custom endpoints.

                * ``DBClusterParameterGroups`` - The number of DB cluster parameter groups per account, excluding default parameter groups. The used value is the count of nondefault DB cluster parameter groups in the account.

                * ``DBClusterRoles`` - The number of associated AWS Identity and Access Management (IAM) roles per DB cluster. The used value is the highest number of associated IAM roles for a DB cluster in the account. Other DB clusters in the account might have a lower number of associated IAM roles.

                * ``DBClusters`` - The number of DB clusters per account. The used value is the count of DB clusters in the account.

                * ``DBInstanceRoles`` - The number of associated IAM roles per DB instance. The used value is the highest number of associated IAM roles for a DB instance in the account. Other DB instances in the account might have a lower number of associated IAM roles.

                * ``DBInstances`` - The number of DB instances per account. The used value is the count of the DB instances in the account.

                * ``DBParameterGroups`` - The number of DB parameter groups per account, excluding default parameter groups. The used value is the count of nondefault DB parameter groups in the account.

                * ``DBSecurityGroups`` - The number of DB security groups (not VPC security groups) per account, excluding the default security group. The used value is the count of nondefault DB security groups in the account.

                * ``DBSubnetGroups`` - The number of DB subnet groups per account. The used value is the count of the DB subnet groups in the account.

                * ``EventSubscriptions`` - The number of event subscriptions per account. The used value is the count of the event subscriptions in the account.

                * ``ManualSnapshots`` - The number of manual DB snapshots per account. The used value is the count of the manual DB snapshots in the account.

                * ``OptionGroups`` - The number of DB option groups per account, excluding default option groups. The used value is the count of nondefault DB option groups in the account.

                * ``ReadReplicasPerMaster`` - The number of Read Replicas per DB instance. The used value is the highest number of Read Replicas for a DB instance in the account. Other DB instances in the account might have a lower number of Read Replicas.

                * ``ReservedDBInstances`` - The number of reserved DB instances per account. The used value is the count of the active reserved DB instances in the account.

                * ``SubnetsPerDBSubnetGroup`` - The number of subnets per DB subnet group. The used value is highest number of subnets for a DB subnet group in the account. Other DB subnet groups in the account might have a lower number of subnets.

                For more information, see `Limits <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html>`__ in the *Amazon RDS User Guide* and `Limits <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html>`__ in the *Amazon Aurora User Guide* .

                - **AccountQuotaName** *(string) --*

                  The name of the Amazon RDS quota for this AWS account.

                - **Used** *(integer) --*

                  The amount currently used toward the quota maximum.

                - **Max** *(integer) --*

                  The maximum allowed value for the quota.

        """
        pass

    def describe_certificates(
        self,
        CertificateIdentifier: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Lists the set of CA certificates provided by Amazon RDS for this AWS account.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates>`_

        **Request Syntax**
        ::

          response = client.describe_certificates(
              CertificateIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type CertificateIdentifier: string
        :param CertificateIdentifier:

          The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn't case-sensitive.

          Constraints:

          * Must match an existing CertificateIdentifier.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeCertificates`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Certificates': [
                    {
                        'CertificateIdentifier': 'string',
                        'CertificateType': 'string',
                        'Thumbprint': 'string',
                        'ValidFrom': datetime(2015, 1, 1),
                        'ValidTill': datetime(2015, 1, 1),
                        'CertificateArn': 'string'
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            Data returned by the **DescribeCertificates** action.

            - **Certificates** *(list) --*

              The list of ``Certificate`` objects for the AWS account.

              - *(dict) --*

                A CA certificate for an AWS account.

                - **CertificateIdentifier** *(string) --*

                  The unique key that identifies a certificate.

                - **CertificateType** *(string) --*

                  The type of the certificate.

                - **Thumbprint** *(string) --*

                  The thumbprint of the certificate.

                - **ValidFrom** *(datetime) --*

                  The starting date from which the certificate is valid.

                - **ValidTill** *(datetime) --*

                  The final date that the certificate continues to be valid.

                - **CertificateArn** *(string) --*

                  The Amazon Resource Name (ARN) for the certificate.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous ``DescribeCertificates`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        """
        pass

    def describe_custom_availability_zones(
        self,
        CustomAvailabilityZoneId: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        .. _https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html: https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html

        Returns information about custom Availability Zones (AZs).

        A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster.

        For more information about RDS on VMware, see the ` *RDS on VMware User Guide.* https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html`__

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCustomAvailabilityZones>`_

        **Request Syntax**
        ::

          response = client.describe_custom_availability_zones(
              CustomAvailabilityZoneId='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type CustomAvailabilityZoneId: string
        :param CustomAvailabilityZoneId:

          The custom AZ identifier. If this parameter is specified, information from only the specific custom AZ is returned.

        :type Filters: list
        :param Filters:

          A filter that specifies one or more custom AZs to describe.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeCustomAvailabilityZones`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'CustomAvailabilityZones': [
                    {
                        'CustomAvailabilityZoneId': 'string',
                        'CustomAvailabilityZoneName': 'string',
                        'CustomAvailabilityZoneStatus': 'string',
                        'VpnDetails': {
                            'VpnId': 'string',
                            'VpnTunnelOriginatorIP': 'string',
                            'VpnGatewayIp': 'string',
                            'VpnPSK': 'string',
                            'VpnName': 'string',
                            'VpnState': 'string'
                        }
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            - **Marker** *(string) --*

              An optional pagination token provided by a previous ``DescribeCustomAvailabilityZones`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **CustomAvailabilityZones** *(list) --*

              The list of  CustomAvailabilityZone objects for the AWS account.

              - *(dict) --*

                A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.

                For more information about RDS on VMware, see the ` *RDS on VMware User Guide.* https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html`__

                - **CustomAvailabilityZoneId** *(string) --*

                  The identifier of the custom AZ.

                  Amazon RDS generates a unique identifier when a custom AZ is created.

                - **CustomAvailabilityZoneName** *(string) --*

                  The name of the custom AZ.

                - **CustomAvailabilityZoneStatus** *(string) --*

                  The status of the custom AZ.

                - **VpnDetails** *(dict) --*

                  Information about the virtual private network (VPN) between the VMware vSphere cluster and the AWS website.

                  - **VpnId** *(string) --*

                    The ID of the VPN.

                  - **VpnTunnelOriginatorIP** *(string) --*

                    The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.

                  - **VpnGatewayIp** *(string) --*

                    The IP address of network traffic from AWS to your on-premises data center.

                  - **VpnPSK** *(string) --*

                    The preshared key (PSK) for the VPN.

                  - **VpnName** *(string) --*

                    The name of the VPN.

                  - **VpnState** *(string) --*

                    The state of the VPN.

        """
        pass

    def describe_db_cluster_backtracks(
        self,
        DBClusterIdentifier: str,
        BacktrackIdentifier: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns information about backtracks for a DB cluster.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks>`_

        **Request Syntax**
        ::

          response = client.describe_db_cluster_backtracks(
              DBClusterIdentifier='string',
              BacktrackIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 alphanumeric characters or hyphens.

          * First character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          Example: ``my-cluster1``

        :type BacktrackIdentifier: string
        :param BacktrackIdentifier:

          If specified, this value is the backtrack identifier of the backtrack to be described.

          Constraints:

          * Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see `A Universally Unique Identifier (UUID) URN Namespace <http://www.ietf.org/rfc/rfc4122.txt>`__ .

          Example: ``123e4567-e89b-12d3-a456-426655440000``

        :type Filters: list
        :param Filters:

          A filter that specifies one or more DB clusters to describe. Supported filters include the following:

          * ``db-cluster-backtrack-id`` - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.

          * ``db-cluster-backtrack-status`` - Accepts any of the following backtrack status values:

            * ``applying``

            * ``completed``

            * ``failed``

            * ``pending``

          The results list includes information about only the backtracks identified by these values.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBClusterBacktracks`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBClusterBacktracks': [
                    {
                        'DBClusterIdentifier': 'string',
                        'BacktrackIdentifier': 'string',
                        'BacktrackTo': datetime(2015, 1, 1),
                        'BacktrackedFrom': datetime(2015, 1, 1),
                        'BacktrackRequestCreationTime': datetime(2015, 1, 1),
                        'Status': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBClusterBacktracks`` action.

            - **Marker** *(string) --*

              A pagination token that can be used in a subsequent ``DescribeDBClusterBacktracks`` request.

            - **DBClusterBacktracks** *(list) --*

              Contains a list of backtracks for the user.

              - *(dict) --*

                This data type is used as a response element in the ``DescribeDBClusterBacktracks`` action.

                - **DBClusterIdentifier** *(string) --*

                  Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

                - **BacktrackIdentifier** *(string) --*

                  Contains the backtrack identifier.

                - **BacktrackTo** *(datetime) --*

                  The timestamp of the time to which the DB cluster was backtracked.

                - **BacktrackedFrom** *(datetime) --*

                  The timestamp of the time from which the DB cluster was backtracked.

                - **BacktrackRequestCreationTime** *(datetime) --*

                  The timestamp of the time at which the backtrack was requested.

                - **Status** *(string) --*

                  The status of the backtrack. This property returns one of the following values:

                  * ``applying`` - The backtrack is currently being applied to or rolled back from the DB cluster.

                  * ``completed`` - The backtrack has successfully been applied to or rolled back from the DB cluster.

                  * ``failed`` - An error occurred while the backtrack was applied to or rolled back from the DB cluster.

                  * ``pending`` - The backtrack is currently pending application to or rollback from the DB cluster.

        """
        pass

    def describe_db_cluster_endpoints(
        self,
        DBClusterIdentifier: str = None,
        DBClusterEndpointIdentifier: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns information about endpoints for an Amazon Aurora DB cluster.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints>`_

        **Request Syntax**
        ::

          response = client.describe_db_cluster_endpoints(
              DBClusterIdentifier='string',
              DBClusterEndpointIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier:

          The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.

        :type DBClusterEndpointIdentifier: string
        :param DBClusterEndpointIdentifier:

          The identifier of the endpoint to describe. This parameter is stored as a lowercase string.

        :type Filters: list
        :param Filters:

          A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format ``Name=*endpoint_type* ,Values=*endpoint_type1* ,*endpoint_type2* ,...`` . ``Name`` can be one of: ``db-cluster-endpoint-type`` , ``db-cluster-endpoint-custom-type`` , ``db-cluster-endpoint-id`` , ``db-cluster-endpoint-status`` . ``Values`` for the ``db-cluster-endpoint-type`` filter can be one or more of: ``reader`` , ``writer`` , ``custom`` . ``Values`` for the ``db-cluster-endpoint-custom-type`` filter can be one or more of: ``reader`` , ``any`` . ``Values`` for the ``db-cluster-endpoint-status`` filter can be one or more of: ``available`` , ``creating`` , ``deleting`` , ``modifying`` .

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBClusterEndpoints`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBClusterEndpoints': [
                    {
                        'DBClusterEndpointIdentifier': 'string',
                        'DBClusterIdentifier': 'string',
                        'DBClusterEndpointResourceIdentifier': 'string',
                        'Endpoint': 'string',
                        'Status': 'string',
                        'EndpointType': 'string',
                        'CustomEndpointType': 'string',
                        'StaticMembers': [
                            'string',
                        ],
                        'ExcludedMembers': [
                            'string',
                        ],
                        'DBClusterEndpointArn': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            - **Marker** *(string) --*

              An optional pagination token provided by a previous ``DescribeDBClusterEndpoints`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBClusterEndpoints** *(list) --*

              Contains the details of the endpoints associated with the cluster and matching any filter conditions.

              - *(dict) --*

                This data type represents the information you need to connect to an Amazon Aurora DB cluster. This data type is used as a response element in the following actions:

                * ``CreateDBClusterEndpoint``

                * ``DescribeDBClusterEndpoints``

                * ``ModifyDBClusterEndpoint``

                * ``DeleteDBClusterEndpoint``

                For the data structure that represents Amazon RDS DB instance endpoints, see ``Endpoint`` .

                - **DBClusterEndpointIdentifier** *(string) --*

                  The identifier associated with the endpoint. This parameter is stored as a lowercase string.

                - **DBClusterIdentifier** *(string) --*

                  The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.

                - **DBClusterEndpointResourceIdentifier** *(string) --*

                  A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.

                - **Endpoint** *(string) --*

                  The DNS address of the endpoint.

                - **Status** *(string) --*

                  The current status of the endpoint. One of: ``creating`` , ``available`` , ``deleting`` , ``modifying`` .

                - **EndpointType** *(string) --*

                  The type of the endpoint. One of: ``READER`` , ``WRITER`` , ``CUSTOM`` .

                - **CustomEndpointType** *(string) --*

                  The type associated with a custom endpoint. One of: ``READER`` , ``WRITER`` , ``ANY`` .

                - **StaticMembers** *(list) --*

                  List of DB instance identifiers that are part of the custom endpoint group.

                  - *(string) --*

                - **ExcludedMembers** *(list) --*

                  List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.

                  - *(string) --*

                - **DBClusterEndpointArn** *(string) --*

                  The Amazon Resource Name (ARN) for the endpoint.

        """
        pass

    def describe_db_cluster_parameter_groups(
        self,
        DBClusterParameterGroupName: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns a list of ``DBClusterParameterGroup`` descriptions. If a ``DBClusterParameterGroupName`` parameter is specified, the list will contain only the description of the specified DB cluster parameter group.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups>`_

        **Request Syntax**
        ::

          response = client.describe_db_cluster_parameter_groups(
              DBClusterParameterGroupName='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBClusterParameterGroupName: string
        :param DBClusterParameterGroupName:

          The name of a specific DB cluster parameter group to return details for.

          Constraints:

          * If supplied, must match the name of an existing DBClusterParameterGroup.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBClusterParameterGroups`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBClusterParameterGroups': [
                    {
                        'DBClusterParameterGroupName': 'string',
                        'DBParameterGroupFamily': 'string',
                        'Description': 'string',
                        'DBClusterParameterGroupArn': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            - **Marker** *(string) --*

              An optional pagination token provided by a previous ``DescribeDBClusterParameterGroups`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBClusterParameterGroups** *(list) --*

              A list of DB cluster parameter groups.

              - *(dict) --*

                Contains the details of an Amazon RDS DB cluster parameter group.

                This data type is used as a response element in the ``DescribeDBClusterParameterGroups`` action.

                - **DBClusterParameterGroupName** *(string) --*

                  Provides the name of the DB cluster parameter group.

                - **DBParameterGroupFamily** *(string) --*

                  Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.

                - **Description** *(string) --*

                  Provides the customer-specified description for this DB cluster parameter group.

                - **DBClusterParameterGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB cluster parameter group.

        """
        pass

    def describe_db_cluster_parameters(
        self,
        DBClusterParameterGroupName: str,
        Source: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns the detailed parameter list for a particular DB cluster parameter group.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters>`_

        **Request Syntax**
        ::

          response = client.describe_db_cluster_parameters(
              DBClusterParameterGroupName='string',
              Source='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBClusterParameterGroupName: string
        :param DBClusterParameterGroupName: **[REQUIRED]**

          The name of a specific DB cluster parameter group to return parameter details for.

          Constraints:

          * If supplied, must match the name of an existing DBClusterParameterGroup.

        :type Source: string
        :param Source:

          A value that indicates to return only parameters for a specific source. Parameter sources can be ``engine`` , ``service`` , or ``customer`` .

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBClusterParameters`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Parameters': [
                    {
                        'ParameterName': 'string',
                        'ParameterValue': 'string',
                        'Description': 'string',
                        'Source': 'string',
                        'ApplyType': 'string',
                        'DataType': 'string',
                        'AllowedValues': 'string',
                        'IsModifiable': True|False,
                        'MinimumEngineVersion': 'string',
                        'ApplyMethod': 'immediate'|'pending-reboot',
                        'SupportedEngineModes': [
                            'string',
                        ]
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            Provides details about a DB cluster parameter group including the parameters in the DB cluster parameter group.

            - **Parameters** *(list) --*

              Provides a list of parameters for the DB cluster parameter group.

              - *(dict) --*

                This data type is used as a request parameter in the ``ModifyDBParameterGroup`` and ``ResetDBParameterGroup`` actions.

                This data type is used as a response element in the ``DescribeEngineDefaultParameters`` and ``DescribeDBParameters`` actions.

                - **ParameterName** *(string) --*

                  Specifies the name of the parameter.

                - **ParameterValue** *(string) --*

                  Specifies the value of the parameter.

                - **Description** *(string) --*

                  Provides a description of the parameter.

                - **Source** *(string) --*

                  Indicates the source of the parameter value.

                - **ApplyType** *(string) --*

                  Specifies the engine specific parameters type.

                - **DataType** *(string) --*

                  Specifies the valid data type for the parameter.

                - **AllowedValues** *(string) --*

                  Specifies the valid range of values for the parameter.

                - **IsModifiable** *(boolean) --*

                  Indicates whether (``true`` ) or not (``false`` ) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.

                - **MinimumEngineVersion** *(string) --*

                  The earliest engine version to which the parameter can apply.

                - **ApplyMethod** *(string) --*

                  Indicates when to apply parameter updates.

                - **SupportedEngineModes** *(list) --*

                  The valid DB engine modes.

                  - *(string) --*

            - **Marker** *(string) --*

              An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        """
        pass

    def describe_db_cluster_snapshot_attributes(
        self,
        DBClusterSnapshotIdentifier: str
    ) -> Dict[str, Any]:
        """
        Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.

        When sharing snapshots with other AWS accounts, ``DescribeDBClusterSnapshotAttributes`` returns the ``restore`` attribute and a list of IDs for the AWS accounts that are authorized to copy or restore the manual DB cluster snapshot. If ``all`` is included in the list of values for the ``restore`` attribute, then the manual DB cluster snapshot is public and can be copied or restored by all AWS accounts.

        To add or remove access for an AWS account to copy or restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or private, use the ``ModifyDBClusterSnapshotAttribute`` API action.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes>`_

        **Request Syntax**
        ::

          response = client.describe_db_cluster_snapshot_attributes(
              DBClusterSnapshotIdentifier='string'
          )
        :type DBClusterSnapshotIdentifier: string
        :param DBClusterSnapshotIdentifier: **[REQUIRED]**

          The identifier for the DB cluster snapshot to describe the attributes for.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterSnapshotAttributesResult': {
                    'DBClusterSnapshotIdentifier': 'string',
                    'DBClusterSnapshotAttributes': [
                        {
                            'AttributeName': 'string',
                            'AttributeValues': [
                                'string',
                            ]
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterSnapshotAttributesResult** *(dict) --*

              Contains the results of a successful call to the ``DescribeDBClusterSnapshotAttributes`` API action.

              Manual DB cluster snapshot attributes are used to authorize other AWS accounts to copy or restore a manual DB cluster snapshot. For more information, see the ``ModifyDBClusterSnapshotAttribute`` API action.

              - **DBClusterSnapshotIdentifier** *(string) --*

                The identifier of the manual DB cluster snapshot that the attributes apply to.

              - **DBClusterSnapshotAttributes** *(list) --*

                The list of attributes and values for the manual DB cluster snapshot.

                - *(dict) --*

                  Contains the name and values of a manual DB cluster snapshot attribute.

                  Manual DB cluster snapshot attributes are used to authorize other AWS accounts to restore a manual DB cluster snapshot. For more information, see the ``ModifyDBClusterSnapshotAttribute`` API action.

                  - **AttributeName** *(string) --*

                    The name of the manual DB cluster snapshot attribute.

                    The attribute named ``restore`` refers to the list of AWS accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the ``ModifyDBClusterSnapshotAttribute`` API action.

                  - **AttributeValues** *(list) --*

                    The value(s) for the manual DB cluster snapshot attribute.

                    If the ``AttributeName`` field is set to ``restore`` , then this element returns a list of IDs of the AWS accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of ``all`` is in the list, then the manual DB cluster snapshot is public and available for any AWS account to copy or restore.

                    - *(string) --*

        """
        pass

    def describe_db_cluster_snapshots(
        self,
        DBClusterIdentifier: str = None,
        DBClusterSnapshotIdentifier: str = None,
        SnapshotType: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None,
        IncludeShared: bool = None,
        IncludePublic: bool = None
    ) -> Dict[str, Any]:
        """
        Returns information about DB cluster snapshots. This API action supports pagination.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots>`_

        **Request Syntax**
        ::

          response = client.describe_db_cluster_snapshots(
              DBClusterIdentifier='string',
              DBClusterSnapshotIdentifier='string',
              SnapshotType='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string',
              IncludeShared=True|False,
              IncludePublic=True|False
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier:

          The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the ``DBClusterSnapshotIdentifier`` parameter. This parameter isn't case-sensitive.

          Constraints:

          * If supplied, must match the identifier of an existing DBCluster.

        :type DBClusterSnapshotIdentifier: string
        :param DBClusterSnapshotIdentifier:

          A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the ``DBClusterIdentifier`` parameter. This value is stored as a lowercase string.

          Constraints:

          * If supplied, must match the identifier of an existing DBClusterSnapshot.

          * If this identifier is for an automated snapshot, the ``SnapshotType`` parameter must also be specified.

        :type SnapshotType: string
        :param SnapshotType:

          The type of DB cluster snapshots to be returned. You can specify one of the following values:

          * ``automated`` - Return all DB cluster snapshots that have been automatically taken by Amazon RDS for my AWS account.

          * ``manual`` - Return all DB cluster snapshots that have been taken by my AWS account.

          * ``shared`` - Return all manual DB cluster snapshots that have been shared to my AWS account.

          * ``public`` - Return all DB cluster snapshots that have been marked as public.

          If you don't specify a ``SnapshotType`` value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by enabling the ``IncludeShared`` parameter. You can include public DB cluster snapshots with these results by enabling the ``IncludePublic`` parameter.

          The ``IncludeShared`` and ``IncludePublic`` parameters don't apply for ``SnapshotType`` values of ``manual`` or ``automated`` . The ``IncludePublic`` parameter doesn't apply when ``SnapshotType`` is set to ``shared`` . The ``IncludeShared`` parameter doesn't apply when ``SnapshotType`` is set to ``public`` .

        :type Filters: list
        :param Filters:

          A filter that specifies one or more DB cluster snapshots to describe.

          Supported filters:

          * ``db-cluster-id`` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).

          * ``db-cluster-snapshot-id`` - Accepts DB cluster snapshot identifiers.

          * ``snapshot-type`` - Accepts types of DB cluster snapshots.

          * ``engine`` - Accepts names of database engines.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBClusterSnapshots`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :type IncludeShared: boolean
        :param IncludeShared:

          A value that indicates whether to include shared manual DB cluster snapshots from other AWS accounts that this AWS account has been given permission to copy or restore. By default, these snapshots are not included.

          You can give an AWS account permission to restore a manual DB cluster snapshot from another AWS account by the ``ModifyDBClusterSnapshotAttribute`` API action.

        :type IncludePublic: boolean
        :param IncludePublic:

          A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any AWS account. By default, the public snapshots are not included.

          You can share a manual DB cluster snapshot as public by using the  ModifyDBClusterSnapshotAttribute API action.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBClusterSnapshots': [
                    {
                        'AvailabilityZones': [
                            'string',
                        ],
                        'DBClusterSnapshotIdentifier': 'string',
                        'DBClusterIdentifier': 'string',
                        'SnapshotCreateTime': datetime(2015, 1, 1),
                        'Engine': 'string',
                        'AllocatedStorage': 123,
                        'Status': 'string',
                        'Port': 123,
                        'VpcId': 'string',
                        'ClusterCreateTime': datetime(2015, 1, 1),
                        'MasterUsername': 'string',
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'SnapshotType': 'string',
                        'PercentProgress': 123,
                        'StorageEncrypted': True|False,
                        'KmsKeyId': 'string',
                        'DBClusterSnapshotArn': 'string',
                        'SourceDBClusterSnapshotArn': 'string',
                        'IAMDatabaseAuthenticationEnabled': True|False
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Provides a list of DB cluster snapshots for the user as the result of a call to the ``DescribeDBClusterSnapshots`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous ``DescribeDBClusterSnapshots`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBClusterSnapshots** *(list) --*

              Provides a list of DB cluster snapshots for the user.

              - *(dict) --*

                Contains the details for an Amazon RDS DB cluster snapshot

                This data type is used as a response element in the ``DescribeDBClusterSnapshots`` action.

                - **AvailabilityZones** *(list) --*

                  Provides the list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.

                  - *(string) --*

                - **DBClusterSnapshotIdentifier** *(string) --*

                  Specifies the identifier for the DB cluster snapshot.

                - **DBClusterIdentifier** *(string) --*

                  Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.

                - **SnapshotCreateTime** *(datetime) --*

                  Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

                - **Engine** *(string) --*

                  Specifies the name of the database engine.

                - **AllocatedStorage** *(integer) --*

                  Specifies the allocated storage size in gibibytes (GiB).

                - **Status** *(string) --*

                  Specifies the status of this DB cluster snapshot.

                - **Port** *(integer) --*

                  Specifies the port that the DB cluster was listening on at the time of the snapshot.

                - **VpcId** *(string) --*

                  Provides the VPC ID associated with the DB cluster snapshot.

                - **ClusterCreateTime** *(datetime) --*

                  Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

                - **MasterUsername** *(string) --*

                  Provides the master username for the DB cluster snapshot.

                - **EngineVersion** *(string) --*

                  Provides the version of the database engine for this DB cluster snapshot.

                - **LicenseModel** *(string) --*

                  Provides the license model information for this DB cluster snapshot.

                - **SnapshotType** *(string) --*

                  Provides the type of the DB cluster snapshot.

                - **PercentProgress** *(integer) --*

                  Specifies the percentage of the estimated data that has been transferred.

                - **StorageEncrypted** *(boolean) --*

                  Specifies whether the DB cluster snapshot is encrypted.

                - **KmsKeyId** *(string) --*

                  If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.

                - **DBClusterSnapshotArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB cluster snapshot.

                - **SourceDBClusterSnapshotArn** *(string) --*

                  If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.

                - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                  True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

        """
        pass

    def describe_db_clusters(
        self,
        DBClusterIdentifier: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None,
        IncludeShared: bool = None
    ) -> Dict[str, Any]:
        """
        Returns information about provisioned Aurora DB clusters. This API supports pagination.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters>`_

        **Request Syntax**
        ::

          response = client.describe_db_clusters(
              DBClusterIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string',
              IncludeShared=True|False
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier:

          The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.

          Constraints:

          * If supplied, must match an existing DBClusterIdentifier.

        :type Filters: list
        :param Filters:

          A filter that specifies one or more DB clusters to describe.

          Supported filters:

          * ``db-cluster-id`` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBClusters`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :type IncludeShared: boolean
        :param IncludeShared:

          Optional Boolean parameter that specifies whether the output includes information about clusters shared from other AWS accounts.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBClusters': [
                    {
                        'AllocatedStorage': 123,
                        'AvailabilityZones': [
                            'string',
                        ],
                        'BackupRetentionPeriod': 123,
                        'CharacterSetName': 'string',
                        'DatabaseName': 'string',
                        'DBClusterIdentifier': 'string',
                        'DBClusterParameterGroup': 'string',
                        'DBSubnetGroup': 'string',
                        'Status': 'string',
                        'PercentProgress': 'string',
                        'EarliestRestorableTime': datetime(2015, 1, 1),
                        'Endpoint': 'string',
                        'ReaderEndpoint': 'string',
                        'CustomEndpoints': [
                            'string',
                        ],
                        'MultiAZ': True|False,
                        'Engine': 'string',
                        'EngineVersion': 'string',
                        'LatestRestorableTime': datetime(2015, 1, 1),
                        'Port': 123,
                        'MasterUsername': 'string',
                        'DBClusterOptionGroupMemberships': [
                            {
                                'DBClusterOptionGroupName': 'string',
                                'Status': 'string'
                            },
                        ],
                        'PreferredBackupWindow': 'string',
                        'PreferredMaintenanceWindow': 'string',
                        'ReplicationSourceIdentifier': 'string',
                        'ReadReplicaIdentifiers': [
                            'string',
                        ],
                        'DBClusterMembers': [
                            {
                                'DBInstanceIdentifier': 'string',
                                'IsClusterWriter': True|False,
                                'DBClusterParameterGroupStatus': 'string',
                                'PromotionTier': 123
                            },
                        ],
                        'VpcSecurityGroups': [
                            {
                                'VpcSecurityGroupId': 'string',
                                'Status': 'string'
                            },
                        ],
                        'HostedZoneId': 'string',
                        'StorageEncrypted': True|False,
                        'KmsKeyId': 'string',
                        'DbClusterResourceId': 'string',
                        'DBClusterArn': 'string',
                        'AssociatedRoles': [
                            {
                                'RoleArn': 'string',
                                'Status': 'string',
                                'FeatureName': 'string'
                            },
                        ],
                        'IAMDatabaseAuthenticationEnabled': True|False,
                        'CloneGroupId': 'string',
                        'ClusterCreateTime': datetime(2015, 1, 1),
                        'EarliestBacktrackTime': datetime(2015, 1, 1),
                        'BacktrackWindow': 123,
                        'BacktrackConsumedChangeRecords': 123,
                        'EnabledCloudwatchLogsExports': [
                            'string',
                        ],
                        'Capacity': 123,
                        'EngineMode': 'string',
                        'ScalingConfigurationInfo': {
                            'MinCapacity': 123,
                            'MaxCapacity': 123,
                            'AutoPause': True|False,
                            'SecondsUntilAutoPause': 123,
                            'TimeoutAction': 'string'
                        },
                        'DeletionProtection': True|False,
                        'HttpEndpointEnabled': True|False,
                        'ActivityStreamMode': 'sync'|'async',
                        'ActivityStreamStatus': 'stopped'|'starting'|'started'|'stopping',
                        'ActivityStreamKmsKeyId': 'string',
                        'ActivityStreamKinesisStreamName': 'string',
                        'CopyTagsToSnapshot': True|False,
                        'CrossAccountClone': True|False
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBClusters`` action.

            - **Marker** *(string) --*

              A pagination token that can be used in a subsequent DescribeDBClusters request.

            - **DBClusters** *(list) --*

              Contains a list of DB clusters for the user.

              - *(dict) --*

                Contains the details of an Amazon Aurora DB cluster.

                This data type is used as a response element in the ``DescribeDBClusters`` , ``StopDBCluster`` , and ``StartDBCluster`` actions.

                - **AllocatedStorage** *(integer) --*

                  For all database engines except Amazon Aurora, ``AllocatedStorage`` specifies the allocated storage size in gibibytes (GiB). For Aurora, ``AllocatedStorage`` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.

                - **AvailabilityZones** *(list) --*

                  Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.

                  - *(string) --*

                - **BackupRetentionPeriod** *(integer) --*

                  Specifies the number of days for which automatic DB snapshots are retained.

                - **CharacterSetName** *(string) --*

                  If present, specifies the name of the character set that this cluster is associated with.

                - **DatabaseName** *(string) --*

                  Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.

                - **DBClusterIdentifier** *(string) --*

                  Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

                - **DBClusterParameterGroup** *(string) --*

                  Specifies the name of the DB cluster parameter group for the DB cluster.

                - **DBSubnetGroup** *(string) --*

                  Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.

                - **Status** *(string) --*

                  Specifies the current state of this DB cluster.

                - **PercentProgress** *(string) --*

                  Specifies the progress of the operation as a percentage.

                - **EarliestRestorableTime** *(datetime) --*

                  The earliest time to which a database can be restored with point-in-time restore.

                - **Endpoint** *(string) --*

                  Specifies the connection endpoint for the primary instance of the DB cluster.

                - **ReaderEndpoint** *(string) --*

                  The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.

                  If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.

                - **CustomEndpoints** *(list) --*

                  Identifies all custom endpoints associated with the cluster.

                  - *(string) --*

                - **MultiAZ** *(boolean) --*

                  Specifies whether the DB cluster has instances in multiple Availability Zones.

                - **Engine** *(string) --*

                  Provides the name of the database engine to be used for this DB cluster.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **LatestRestorableTime** *(datetime) --*

                  Specifies the latest time to which a database can be restored with point-in-time restore.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **MasterUsername** *(string) --*

                  Contains the master username for the DB cluster.

                - **DBClusterOptionGroupMemberships** *(list) --*

                  Provides the list of option group memberships for this DB cluster.

                  - *(dict) --*

                    Contains status information for a DB cluster option group.

                    - **DBClusterOptionGroupName** *(string) --*

                      Specifies the name of the DB cluster option group.

                    - **Status** *(string) --*

                      Specifies the status of the DB cluster option group.

                - **PreferredBackupWindow** *(string) --*

                  Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

                - **PreferredMaintenanceWindow** *(string) --*

                  Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

                - **ReplicationSourceIdentifier** *(string) --*

                  Contains the identifier of the source DB cluster if this DB cluster is a Read Replica.

                - **ReadReplicaIdentifiers** *(list) --*

                  Contains one or more identifiers of the Read Replicas associated with this DB cluster.

                  - *(string) --*

                - **DBClusterMembers** *(list) --*

                  Provides the list of instances that make up the DB cluster.

                  - *(dict) --*

                    Contains information about an instance that is part of a DB cluster.

                    - **DBInstanceIdentifier** *(string) --*

                      Specifies the instance identifier for this member of the DB cluster.

                    - **IsClusterWriter** *(boolean) --*

                      Value that is ``true`` if the cluster member is the primary instance for the DB cluster and ``false`` otherwise.

                    - **DBClusterParameterGroupStatus** *(string) --*

                      Specifies the status of the DB cluster parameter group for this member of the DB cluster.

                    - **PromotionTier** *(integer) --*

                      A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

                - **VpcSecurityGroups** *(list) --*

                  Provides a list of VPC security groups that the DB cluster belongs to.

                  - *(dict) --*

                    This data type is used as a response element for queries on VPC security group membership.

                    - **VpcSecurityGroupId** *(string) --*

                      The name of the VPC security group.

                    - **Status** *(string) --*

                      The status of the VPC security group.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

                - **StorageEncrypted** *(boolean) --*

                  Specifies whether the DB cluster is encrypted.

                - **KmsKeyId** *(string) --*

                  If ``StorageEncrypted`` is enabled, the AWS KMS key identifier for the encrypted DB cluster.

                - **DbClusterResourceId** *(string) --*

                  The AWS Region-unique, immutable identifier for the DB cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

                - **DBClusterArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB cluster.

                - **AssociatedRoles** *(list) --*

                  Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.

                  - *(dict) --*

                    Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.

                    - **RoleArn** *(string) --*

                      The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.

                    - **Status** *(string) --*

                      Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:

                      * ``ACTIVE`` - the IAM role ARN is associated with the DB cluster and can be used to access other AWS services on your behalf.

                      * ``PENDING`` - the IAM role ARN is being associated with the DB cluster.

                      * ``INVALID`` - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other AWS services on your behalf.

                    - **FeatureName** *(string) --*

                      The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see  DBEngineVersion .

                - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                  A value that indicates whether the mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.

                - **CloneGroupId** *(string) --*

                  Identifies the clone group to which the DB cluster is associated.

                - **ClusterCreateTime** *(datetime) --*

                  Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

                - **EarliestBacktrackTime** *(datetime) --*

                  The earliest time to which a DB cluster can be backtracked.

                - **BacktrackWindow** *(integer) --*

                  The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.

                - **BacktrackConsumedChangeRecords** *(integer) --*

                  The number of change records stored for Backtrack.

                - **EnabledCloudwatchLogsExports** *(list) --*

                  A list of log types that this DB cluster is configured to export to CloudWatch Logs.

                  Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html>`__ in the *Amazon Aurora User Guide.*

                  - *(string) --*

                - **Capacity** *(integer) --*

                  The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.

                  For more information about Aurora Serverless, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

                - **EngineMode** *(string) --*

                  The DB engine mode of the DB cluster, either ``provisioned`` , ``serverless`` , ``parallelquery`` , ``global`` , or ``multimaster`` .

                - **ScalingConfigurationInfo** *(dict) --*

                  Shows the scaling configuration for an Aurora DB cluster in ``serverless`` DB engine mode.

                  For more information, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

                  - **MinCapacity** *(integer) --*

                    The maximum capacity for the Aurora DB cluster in ``serverless`` DB engine mode.

                  - **MaxCapacity** *(integer) --*

                    The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

                  - **AutoPause** *(boolean) --*

                    A value that indicates whether automatic pause is allowed for the Aurora DB cluster in ``serverless`` DB engine mode.

                    When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.

                  - **SecondsUntilAutoPause** *(integer) --*

                    The remaining amount of time, in seconds, before the Aurora DB cluster in ``serverless`` mode is paused. A DB cluster can be paused only when it's idle (it has no connections).

                  - **TimeoutAction** *(string) --*

                    The timeout action of a call to ``ModifyCurrentDBClusterCapacity`` , either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

                - **DeletionProtection** *(boolean) --*

                  Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.

                - **HttpEndpointEnabled** *(boolean) --*

                  A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.

                  When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

                  For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

                - **ActivityStreamMode** *(string) --*

                  The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.

                - **ActivityStreamStatus** *(string) --*

                  The status of the database activity stream.

                - **ActivityStreamKmsKeyId** *(string) --*

                  The AWS KMS key identifier used for encrypting messages in the database activity stream.

                - **ActivityStreamKinesisStreamName** *(string) --*

                  The name of the Amazon Kinesis data stream used for the database activity stream.

                - **CopyTagsToSnapshot** *(boolean) --*

                  Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.

                - **CrossAccountClone** *(boolean) --*

                  Specifies whether the DB cluster is a clone of a DB cluster owned by a different AWS account.

        """
        pass

    def describe_db_engine_versions(
        self,
        Engine: str = None,
        EngineVersion: str = None,
        DBParameterGroupFamily: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None,
        DefaultOnly: bool = None,
        ListSupportedCharacterSets: bool = None,
        ListSupportedTimezones: bool = None,
        IncludeAll: bool = None
    ) -> Dict[str, Any]:
        """
        Returns a list of the available DB engines.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions>`_

        **Request Syntax**
        ::

          response = client.describe_db_engine_versions(
              Engine='string',
              EngineVersion='string',
              DBParameterGroupFamily='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string',
              DefaultOnly=True|False,
              ListSupportedCharacterSets=True|False,
              ListSupportedTimezones=True|False,
              IncludeAll=True|False
          )
        :type Engine: string
        :param Engine:

          The database engine to return.

        :type EngineVersion: string
        :param EngineVersion:

          The database engine version to return.

          Example: ``5.1.49``

        :type DBParameterGroupFamily: string
        :param DBParameterGroupFamily:

          The name of a specific DB parameter group family to return details for.

          Constraints:

          * If supplied, must match an existing DBParameterGroupFamily.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more than the ``MaxRecords`` value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :type DefaultOnly: boolean
        :param DefaultOnly:

          A value that indicates whether only the default version of the specified engine or engine and major version combination is returned.

        :type ListSupportedCharacterSets: boolean
        :param ListSupportedCharacterSets:

          A value that indicates whether to list the supported character sets for each engine version.

          If this parameter is enabled and the requested engine supports the ``CharacterSetName`` parameter for ``CreateDBInstance`` , the response includes a list of supported character sets for each engine version.

        :type ListSupportedTimezones: boolean
        :param ListSupportedTimezones:

          A value that indicates whether to list the supported time zones for each engine version.

          If this parameter is enabled and the requested engine supports the ``TimeZone`` parameter for ``CreateDBInstance`` , the response includes a list of supported time zones for each engine version.

        :type IncludeAll: boolean
        :param IncludeAll:

          A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBEngineVersions': [
                    {
                        'Engine': 'string',
                        'EngineVersion': 'string',
                        'DBParameterGroupFamily': 'string',
                        'DBEngineDescription': 'string',
                        'DBEngineVersionDescription': 'string',
                        'DefaultCharacterSet': {
                            'CharacterSetName': 'string',
                            'CharacterSetDescription': 'string'
                        },
                        'SupportedCharacterSets': [
                            {
                                'CharacterSetName': 'string',
                                'CharacterSetDescription': 'string'
                            },
                        ],
                        'ValidUpgradeTarget': [
                            {
                                'Engine': 'string',
                                'EngineVersion': 'string',
                                'Description': 'string',
                                'AutoUpgrade': True|False,
                                'IsMajorVersionUpgrade': True|False
                            },
                        ],
                        'SupportedTimezones': [
                            {
                                'TimezoneName': 'string'
                            },
                        ],
                        'ExportableLogTypes': [
                            'string',
                        ],
                        'SupportsLogExportsToCloudwatchLogs': True|False,
                        'SupportsReadReplica': True|False,
                        'SupportedEngineModes': [
                            'string',
                        ],
                        'SupportedFeatureNames': [
                            'string',
                        ],
                        'Status': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBEngineVersions`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBEngineVersions** *(list) --*

              A list of ``DBEngineVersion`` elements.

              - *(dict) --*

                This data type is used as a response element in the action ``DescribeDBEngineVersions`` .

                - **Engine** *(string) --*

                  The name of the database engine.

                - **EngineVersion** *(string) --*

                  The version number of the database engine.

                - **DBParameterGroupFamily** *(string) --*

                  The name of the DB parameter group family for the database engine.

                - **DBEngineDescription** *(string) --*

                  The description of the database engine.

                - **DBEngineVersionDescription** *(string) --*

                  The description of the database engine version.

                - **DefaultCharacterSet** *(dict) --*

                  The default character set for new instances of this engine version, if the ``CharacterSetName`` parameter of the CreateDBInstance API isn't specified.

                  - **CharacterSetName** *(string) --*

                    The name of the character set.

                  - **CharacterSetDescription** *(string) --*

                    The description of the character set.

                - **SupportedCharacterSets** *(list) --*

                  A list of the character sets supported by this engine for the ``CharacterSetName`` parameter of the ``CreateDBInstance`` action.

                  - *(dict) --*

                    This data type is used as a response element in the action ``DescribeDBEngineVersions`` .

                    - **CharacterSetName** *(string) --*

                      The name of the character set.

                    - **CharacterSetDescription** *(string) --*

                      The description of the character set.

                - **ValidUpgradeTarget** *(list) --*

                  A list of engine versions that this database engine version can be upgraded to.

                  - *(dict) --*

                    The version of the database engine that a DB instance can be upgraded to.

                    - **Engine** *(string) --*

                      The name of the upgrade target database engine.

                    - **EngineVersion** *(string) --*

                      The version number of the upgrade target database engine.

                    - **Description** *(string) --*

                      The version of the database engine that a DB instance can be upgraded to.

                    - **AutoUpgrade** *(boolean) --*

                      A value that indicates whether the target version is applied to any source DB instances that have ``AutoMinorVersionUpgrade`` set to true.

                    - **IsMajorVersionUpgrade** *(boolean) --*

                      A value that indicates whether a database engine is upgraded to a major version.

                - **SupportedTimezones** *(list) --*

                  A list of the time zones supported by this engine for the ``Timezone`` parameter of the ``CreateDBInstance`` action.

                  - *(dict) --*

                    A time zone associated with a ``DBInstance`` or a ``DBSnapshot`` . This data type is an element in the response to the ``DescribeDBInstances`` , the ``DescribeDBSnapshots`` , and the ``DescribeDBEngineVersions`` actions.

                    - **TimezoneName** *(string) --*

                      The name of the time zone.

                - **ExportableLogTypes** *(list) --*

                  The types of logs that the database engine has available for export to CloudWatch Logs.

                  - *(string) --*

                - **SupportsLogExportsToCloudwatchLogs** *(boolean) --*

                  A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.

                - **SupportsReadReplica** *(boolean) --*

                  Indicates whether the database engine version supports Read Replicas.

                - **SupportedEngineModes** *(list) --*

                  A list of the supported DB engine modes.

                  - *(string) --*

                - **SupportedFeatureNames** *(list) --*

                  A list of features supported by the DB engine. Supported feature names include the following.

                  * s3Import

                  - *(string) --*

                - **Status** *(string) --*

                  The status of the DB engine version, either ``available`` or ``deprecated`` .

        """
        pass

    def describe_db_instance_automated_backups(
        self,
        DbiResourceId: str = None,
        DBInstanceIdentifier: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Displays backups for both current and deleted instances. For example, use this operation to find details about automated backups for previously deleted instances. Current instances with retention periods greater than zero (0) are returned for both the ``DescribeDBInstanceAutomatedBackups`` and ``DescribeDBInstances`` operations.

        All parameters are optional.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups>`_

        **Request Syntax**
        ::

          response = client.describe_db_instance_automated_backups(
              DbiResourceId='string',
              DBInstanceIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DbiResourceId: string
        :param DbiResourceId:

          The resource ID of the DB instance that is the source of the automated backup. This parameter isn't case-sensitive.

        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier:

          (Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of an existing DB instance. It returns information from the specific DB instance' automated backup. This parameter isn't case-sensitive.

        :type Filters: list
        :param Filters:

          A filter that specifies which resources to return based on status.

          Supported filters are the following:

          * ``status``

            * ``active`` - automated backups for current instances

            * ``retained`` - automated backups for deleted instances

            * ``creating`` - automated backups that are waiting for the first automated snapshot to be available

          * ``db-instance-id`` - Accepts DB instance identifiers and Amazon Resource Names (ARNs) for DB instances. The results list includes only information about the DB instance automated backupss identified by these ARNs.

          * ``dbi-resource-id`` - Accepts DB instance resource identifiers and DB Amazon Resource Names (ARNs) for DB instances. The results list includes only information about the DB instance resources identified by these ARNs.

          Returns all resources by default. The status for each resource is specified in the response.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

        :type Marker: string
        :param Marker:

          The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBInstanceAutomatedBackups': [
                    {
                        'DBInstanceArn': 'string',
                        'DbiResourceId': 'string',
                        'Region': 'string',
                        'DBInstanceIdentifier': 'string',
                        'RestoreWindow': {
                            'EarliestTime': datetime(2015, 1, 1),
                            'LatestTime': datetime(2015, 1, 1)
                        },
                        'AllocatedStorage': 123,
                        'Status': 'string',
                        'Port': 123,
                        'AvailabilityZone': 'string',
                        'VpcId': 'string',
                        'InstanceCreateTime': datetime(2015, 1, 1),
                        'MasterUsername': 'string',
                        'Engine': 'string',
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'OptionGroupName': 'string',
                        'TdeCredentialArn': 'string',
                        'Encrypted': True|False,
                        'StorageType': 'string',
                        'KmsKeyId': 'string',
                        'Timezone': 'string',
                        'IAMDatabaseAuthenticationEnabled': True|False
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBInstanceAutomatedBackups`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBInstanceAutomatedBackups** *(list) --*

              A list of ``DBInstanceAutomatedBackup`` instances.

              - *(dict) --*

                An automated backup of a DB instance. It it consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.

                - **DBInstanceArn** *(string) --*

                  The Amazon Resource Name (ARN) for the automated backup.

                - **DbiResourceId** *(string) --*

                  The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

                - **Region** *(string) --*

                  The AWS Region associated with the automated backup.

                - **DBInstanceIdentifier** *(string) --*

                  The customer id of the instance that is/was associated with the automated backup.

                - **RestoreWindow** *(dict) --*

                  Earliest and latest time an instance can be restored to.

                  - **EarliestTime** *(datetime) --*

                    The earliest time you can restore an instance to.

                  - **LatestTime** *(datetime) --*

                    The latest time you can restore an instance to.

                - **AllocatedStorage** *(integer) --*

                  Specifies the allocated storage size in gibibytes (GiB).

                - **Status** *(string) --*

                  Provides a list of status information for an automated backup:

                  * ``active`` - automated backups for current instances

                  * ``retained`` - automated backups for deleted instances

                  * ``creating`` - automated backups that are waiting for the first automated snapshot to be available.

                - **Port** *(integer) --*

                  The port number that the automated backup used for connections.

                  Default: Inherits from the source DB instance

                  Valid Values: ``1150-65535``

                - **AvailabilityZone** *(string) --*

                  The Availability Zone that the automated backup was created in. For information on AWS Regions and Availability Zones, see `Regions and Availability Zones <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html>`__ .

                - **VpcId** *(string) --*

                  Provides the VPC ID associated with the DB instance

                - **InstanceCreateTime** *(datetime) --*

                  Provides the date and time that the DB instance was created.

                - **MasterUsername** *(string) --*

                  The license model of an automated backup.

                - **Engine** *(string) --*

                  The name of the database engine for this automated backup.

                - **EngineVersion** *(string) --*

                  The version of the database engine for the automated backup.

                - **LicenseModel** *(string) --*

                  License model information for the automated backup.

                - **Iops** *(integer) --*

                  The IOPS (I/O operations per second) value for the automated backup.

                - **OptionGroupName** *(string) --*

                  The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.

                - **TdeCredentialArn** *(string) --*

                  The ARN from the key store with which the automated backup is associated for TDE encryption.

                - **Encrypted** *(boolean) --*

                  Specifies whether the automated backup is encrypted.

                - **StorageType** *(string) --*

                  Specifies the storage type associated with the automated backup.

                - **KmsKeyId** *(string) --*

                  The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

                - **Timezone** *(string) --*

                  The time zone of the automated backup. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

                - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                  True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

        """
        pass

    def describe_db_instances(
        self,
        DBInstanceIdentifier: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns information about provisioned RDS instances. This API supports pagination.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances>`_

        **Request Syntax**
        ::

          response = client.describe_db_instances(
              DBInstanceIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier:

          The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.

          Constraints:

          * If supplied, must match the identifier of an existing DBInstance.

        :type Filters: list
        :param Filters:

          A filter that specifies one or more DB instances to describe.

          Supported filters:

          * ``db-cluster-id`` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB instances associated with the DB clusters identified by these ARNs.

          * ``db-instance-id`` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list will only include information about the DB instances identified by these ARNs.

          * ``dbi-resource-id`` - Accepts DB instance resource identifiers. The results list will only include information about the DB instances identified by these DB instance resource identifiers.

          * ``domain`` - Accepts Active Directory directory IDs. The results list will only include information about the DB instances associated with these domains.

          * ``engine`` - Accepts engine names. The results list will only include information about the DB instances for these engines.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBInstances`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBInstances': [
                    {
                        'DBInstanceIdentifier': 'string',
                        'DBInstanceClass': 'string',
                        'Engine': 'string',
                        'DBInstanceStatus': 'string',
                        'MasterUsername': 'string',
                        'DBName': 'string',
                        'Endpoint': {
                            'Address': 'string',
                            'Port': 123,
                            'HostedZoneId': 'string'
                        },
                        'AllocatedStorage': 123,
                        'InstanceCreateTime': datetime(2015, 1, 1),
                        'PreferredBackupWindow': 'string',
                        'BackupRetentionPeriod': 123,
                        'DBSecurityGroups': [
                            {
                                'DBSecurityGroupName': 'string',
                                'Status': 'string'
                            },
                        ],
                        'VpcSecurityGroups': [
                            {
                                'VpcSecurityGroupId': 'string',
                                'Status': 'string'
                            },
                        ],
                        'DBParameterGroups': [
                            {
                                'DBParameterGroupName': 'string',
                                'ParameterApplyStatus': 'string'
                            },
                        ],
                        'AvailabilityZone': 'string',
                        'DBSubnetGroup': {
                            'DBSubnetGroupName': 'string',
                            'DBSubnetGroupDescription': 'string',
                            'VpcId': 'string',
                            'SubnetGroupStatus': 'string',
                            'Subnets': [
                                {
                                    'SubnetIdentifier': 'string',
                                    'SubnetAvailabilityZone': {
                                        'Name': 'string'
                                    },
                                    'SubnetStatus': 'string'
                                },
                            ],
                            'DBSubnetGroupArn': 'string'
                        },
                        'PreferredMaintenanceWindow': 'string',
                        'PendingModifiedValues': {
                            'DBInstanceClass': 'string',
                            'AllocatedStorage': 123,
                            'MasterUserPassword': 'string',
                            'Port': 123,
                            'BackupRetentionPeriod': 123,
                            'MultiAZ': True|False,
                            'EngineVersion': 'string',
                            'LicenseModel': 'string',
                            'Iops': 123,
                            'DBInstanceIdentifier': 'string',
                            'StorageType': 'string',
                            'CACertificateIdentifier': 'string',
                            'DBSubnetGroupName': 'string',
                            'PendingCloudwatchLogsExports': {
                                'LogTypesToEnable': [
                                    'string',
                                ],
                                'LogTypesToDisable': [
                                    'string',
                                ]
                            },
                            'ProcessorFeatures': [
                                {
                                    'Name': 'string',
                                    'Value': 'string'
                                },
                            ]
                        },
                        'LatestRestorableTime': datetime(2015, 1, 1),
                        'MultiAZ': True|False,
                        'EngineVersion': 'string',
                        'AutoMinorVersionUpgrade': True|False,
                        'ReadReplicaSourceDBInstanceIdentifier': 'string',
                        'ReadReplicaDBInstanceIdentifiers': [
                            'string',
                        ],
                        'ReadReplicaDBClusterIdentifiers': [
                            'string',
                        ],
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'OptionGroupMemberships': [
                            {
                                'OptionGroupName': 'string',
                                'Status': 'string'
                            },
                        ],
                        'CharacterSetName': 'string',
                        'SecondaryAvailabilityZone': 'string',
                        'PubliclyAccessible': True|False,
                        'StatusInfos': [
                            {
                                'StatusType': 'string',
                                'Normal': True|False,
                                'Status': 'string',
                                'Message': 'string'
                            },
                        ],
                        'StorageType': 'string',
                        'TdeCredentialArn': 'string',
                        'DbInstancePort': 123,
                        'DBClusterIdentifier': 'string',
                        'StorageEncrypted': True|False,
                        'KmsKeyId': 'string',
                        'DbiResourceId': 'string',
                        'CACertificateIdentifier': 'string',
                        'DomainMemberships': [
                            {
                                'Domain': 'string',
                                'Status': 'string',
                                'FQDN': 'string',
                                'IAMRoleName': 'string'
                            },
                        ],
                        'CopyTagsToSnapshot': True|False,
                        'MonitoringInterval': 123,
                        'EnhancedMonitoringResourceArn': 'string',
                        'MonitoringRoleArn': 'string',
                        'PromotionTier': 123,
                        'DBInstanceArn': 'string',
                        'Timezone': 'string',
                        'IAMDatabaseAuthenticationEnabled': True|False,
                        'PerformanceInsightsEnabled': True|False,
                        'PerformanceInsightsKMSKeyId': 'string',
                        'PerformanceInsightsRetentionPeriod': 123,
                        'EnabledCloudwatchLogsExports': [
                            'string',
                        ],
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ],
                        'DeletionProtection': True|False,
                        'AssociatedRoles': [
                            {
                                'RoleArn': 'string',
                                'FeatureName': 'string',
                                'Status': 'string'
                            },
                        ],
                        'ListenerEndpoint': {
                            'Address': 'string',
                            'Port': 123,
                            'HostedZoneId': 'string'
                        },
                        'MaxAllocatedStorage': 123
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBInstances`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBInstances** *(list) --*

              A list of ``DBInstance`` instances.

              - *(dict) --*

                Contains the details of an Amazon RDS DB instance.

                This data type is used as a response element in the ``DescribeDBInstances`` action.

                - **DBInstanceIdentifier** *(string) --*

                  Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.

                - **DBInstanceClass** *(string) --*

                  Contains the name of the compute and memory capacity class of the DB instance.

                - **Engine** *(string) --*

                  Provides the name of the database engine to be used for this DB instance.

                - **DBInstanceStatus** *(string) --*

                  Specifies the current state of this database.

                - **MasterUsername** *(string) --*

                  Contains the master username for the DB instance.

                - **DBName** *(string) --*

                  The meaning of this parameter differs according to the database engine you use.

                   **MySQL, MariaDB, SQL Server, PostgreSQL**

                  Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.

                  Type: String

                   **Oracle**

                  Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.

                - **Endpoint** *(dict) --*

                  Specifies the connection endpoint.

                  - **Address** *(string) --*

                    Specifies the DNS address of the DB instance.

                  - **Port** *(integer) --*

                    Specifies the port that the database engine is listening on.

                  - **HostedZoneId** *(string) --*

                    Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

                - **AllocatedStorage** *(integer) --*

                  Specifies the allocated storage size specified in gibibytes.

                - **InstanceCreateTime** *(datetime) --*

                  Provides the date and time the DB instance was created.

                - **PreferredBackupWindow** *(string) --*

                  Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

                - **BackupRetentionPeriod** *(integer) --*

                  Specifies the number of days for which automatic DB snapshots are retained.

                - **DBSecurityGroups** *(list) --*

                  A list of DB security group elements containing ``DBSecurityGroup.Name`` and ``DBSecurityGroup.Status`` subelements.

                  - *(dict) --*

                    This data type is used as a response element in the following actions:

                    * ``ModifyDBInstance``

                    * ``RebootDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceToPointInTime``

                    - **DBSecurityGroupName** *(string) --*

                      The name of the DB security group.

                    - **Status** *(string) --*

                      The status of the DB security group.

                - **VpcSecurityGroups** *(list) --*

                  Provides a list of VPC security group elements that the DB instance belongs to.

                  - *(dict) --*

                    This data type is used as a response element for queries on VPC security group membership.

                    - **VpcSecurityGroupId** *(string) --*

                      The name of the VPC security group.

                    - **Status** *(string) --*

                      The status of the VPC security group.

                - **DBParameterGroups** *(list) --*

                  Provides the list of DB parameter groups applied to this DB instance.

                  - *(dict) --*

                    The status of the DB parameter group.

                    This data type is used as a response element in the following actions:

                    * ``CreateDBInstance``

                    * ``CreateDBInstanceReadReplica``

                    * ``DeleteDBInstance``

                    * ``ModifyDBInstance``

                    * ``RebootDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    - **DBParameterGroupName** *(string) --*

                      The name of the DB parameter group.

                    - **ParameterApplyStatus** *(string) --*

                      The status of parameter updates.

                - **AvailabilityZone** *(string) --*

                  Specifies the name of the Availability Zone the DB instance is located in.

                - **DBSubnetGroup** *(dict) --*

                  Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.

                  - **DBSubnetGroupName** *(string) --*

                    The name of the DB subnet group.

                  - **DBSubnetGroupDescription** *(string) --*

                    Provides the description of the DB subnet group.

                  - **VpcId** *(string) --*

                    Provides the VpcId of the DB subnet group.

                  - **SubnetGroupStatus** *(string) --*

                    Provides the status of the DB subnet group.

                  - **Subnets** *(list) --*

                    Contains a list of ``Subnet`` elements.

                    - *(dict) --*

                      This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                      - **SubnetIdentifier** *(string) --*

                        Specifies the identifier of the subnet.

                      - **SubnetAvailabilityZone** *(dict) --*

                        Contains Availability Zone information.

                        This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                        - **Name** *(string) --*

                          The name of the Availability Zone.

                      - **SubnetStatus** *(string) --*

                        Specifies the status of the subnet.

                  - **DBSubnetGroupArn** *(string) --*

                    The Amazon Resource Name (ARN) for the DB subnet group.

                - **PreferredMaintenanceWindow** *(string) --*

                  Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

                - **PendingModifiedValues** *(dict) --*

                  Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.

                  - **DBInstanceClass** *(string) --*

                    Contains the new ``DBInstanceClass`` for the DB instance that will be applied or is currently being applied.

                  - **AllocatedStorage** *(integer) --*

                    Contains the new ``AllocatedStorage`` size for the DB instance that will be applied or is currently being applied.

                  - **MasterUserPassword** *(string) --*

                    Contains the pending or currently-in-progress change of the master credentials for the DB instance.

                  - **Port** *(integer) --*

                    Specifies the pending port for the DB instance.

                  - **BackupRetentionPeriod** *(integer) --*

                    Specifies the pending number of days for which automated backups are retained.

                  - **MultiAZ** *(boolean) --*

                    Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.

                  - **EngineVersion** *(string) --*

                    Indicates the database engine version.

                  - **LicenseModel** *(string) --*

                    The license model for the DB instance.

                    Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

                  - **Iops** *(integer) --*

                    Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.

                  - **DBInstanceIdentifier** *(string) --*

                    Contains the new ``DBInstanceIdentifier`` for the DB instance that will be applied or is currently being applied.

                  - **StorageType** *(string) --*

                    Specifies the storage type to be associated with the DB instance.

                  - **CACertificateIdentifier** *(string) --*

                    Specifies the identifier of the CA certificate for the DB instance.

                  - **DBSubnetGroupName** *(string) --*

                    The new DB subnet group for the DB instance.

                  - **PendingCloudwatchLogsExports** *(dict) --*

                    A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.

                    - **LogTypesToEnable** *(list) --*

                      Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.

                      - *(string) --*

                    - **LogTypesToDisable** *(list) --*

                      Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.

                      - *(string) --*

                  - **ProcessorFeatures** *(list) --*

                    The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                    - *(dict) --*

                      Contains the processor features of a DB instance class.

                      To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                      You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                      * ``CreateDBInstance``

                      * ``ModifyDBInstance``

                      * ``RestoreDBInstanceFromDBSnapshot``

                      * ``RestoreDBInstanceFromS3``

                      * ``RestoreDBInstanceToPointInTime``

                      You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                      In addition, you can use the following actions for DB instance class processor information:

                      * ``DescribeDBInstances``

                      * ``DescribeDBSnapshots``

                      * ``DescribeValidDBInstanceModifications``

                      For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                      - **Name** *(string) --*

                        The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                      - **Value** *(string) --*

                        The value of a processor feature name.

                - **LatestRestorableTime** *(datetime) --*

                  Specifies the latest time to which a database can be restored with point-in-time restore.

                - **MultiAZ** *(boolean) --*

                  Specifies if the DB instance is a Multi-AZ deployment.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **AutoMinorVersionUpgrade** *(boolean) --*

                  Indicates that minor version patches are applied automatically.

                - **ReadReplicaSourceDBInstanceIdentifier** *(string) --*

                  Contains the identifier of the source DB instance if this DB instance is a Read Replica.

                - **ReadReplicaDBInstanceIdentifiers** *(list) --*

                  Contains one or more identifiers of the Read Replicas associated with this DB instance.

                  - *(string) --*

                - **ReadReplicaDBClusterIdentifiers** *(list) --*

                  Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a Read Replica. For example, when you create an Aurora Read Replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster for the Aurora Read Replica is shown. This output does not contain information about cross region Aurora Read Replicas.

                  .. note::

                    Currently, each RDS DB instance can have only one Aurora Read Replica.

                  - *(string) --*

                - **LicenseModel** *(string) --*

                  License model information for this DB instance.

                - **Iops** *(integer) --*

                  Specifies the Provisioned IOPS (I/O operations per second) value.

                - **OptionGroupMemberships** *(list) --*

                  Provides the list of option group memberships for this DB instance.

                  - *(dict) --*

                    Provides information on the option groups the DB instance is a member of.

                    - **OptionGroupName** *(string) --*

                      The name of the option group that the instance belongs to.

                    - **Status** *(string) --*

                      The status of the DB instance's option group membership. Valid values are: ``in-sync`` , ``pending-apply`` , ``pending-removal`` , ``pending-maintenance-apply`` , ``pending-maintenance-removal`` , ``applying`` , ``removing`` , and ``failed`` .

                - **CharacterSetName** *(string) --*

                  If present, specifies the name of the character set that this instance is associated with.

                - **SecondaryAvailabilityZone** *(string) --*

                  If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.

                - **PubliclyAccessible** *(boolean) --*

                  Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address.

                - **StatusInfos** *(list) --*

                  The status of a Read Replica. If the instance isn't a Read Replica, this is blank.

                  - *(dict) --*

                    Provides a list of status information for a DB instance.

                    - **StatusType** *(string) --*

                      This value is currently "read replication."

                    - **Normal** *(boolean) --*

                      Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.

                    - **Status** *(string) --*

                      Status of the DB instance. For a StatusType of Read Replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.

                    - **Message** *(string) --*

                      Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.

                - **StorageType** *(string) --*

                  Specifies the storage type associated with DB instance.

                - **TdeCredentialArn** *(string) --*

                  The ARN from the key store with which the instance is associated for TDE encryption.

                - **DbInstancePort** *(integer) --*

                  Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.

                - **DBClusterIdentifier** *(string) --*

                  If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.

                - **StorageEncrypted** *(boolean) --*

                  Specifies whether the DB instance is encrypted.

                - **KmsKeyId** *(string) --*

                  If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB instance.

                - **DbiResourceId** *(string) --*

                  The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.

                - **CACertificateIdentifier** *(string) --*

                  The identifier of the CA certificate for this DB instance.

                - **DomainMemberships** *(list) --*

                  The Active Directory Domain membership records associated with the DB instance.

                  - *(dict) --*

                    An Active Directory Domain membership record associated with the DB instance.

                    - **Domain** *(string) --*

                      The identifier of the Active Directory Domain.

                    - **Status** *(string) --*

                      The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).

                    - **FQDN** *(string) --*

                      The fully qualified domain name of the Active Directory Domain.

                    - **IAMRoleName** *(string) --*

                      The name of the IAM role to be used when making API calls to the Directory Service.

                - **CopyTagsToSnapshot** *(boolean) --*

                  Specifies whether tags are copied from the DB instance to snapshots of the DB instance.

                   **Amazon Aurora**

                  Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see ``DBCluster`` .

                - **MonitoringInterval** *(integer) --*

                  The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.

                - **EnhancedMonitoringResourceArn** *(string) --*

                  The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.

                - **MonitoringRoleArn** *(string) --*

                  The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.

                - **PromotionTier** *(integer) --*

                  A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

                - **DBInstanceArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB instance.

                - **Timezone** *(string) --*

                  The time zone of the DB instance. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

                - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                  True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

                  IAM database authentication can be enabled for the following database engines

                  * For MySQL 5.6, minor version 5.6.34 or higher

                  * For MySQL 5.7, minor version 5.7.16 or higher

                  * Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.

                - **PerformanceInsightsEnabled** *(boolean) --*

                  True if Performance Insights is enabled for the DB instance, and otherwise false.

                - **PerformanceInsightsKMSKeyId** *(string) --*

                  The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

                - **PerformanceInsightsRetentionPeriod** *(integer) --*

                  The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

                - **EnabledCloudwatchLogsExports** *(list) --*

                  A list of log types that this DB instance is configured to export to CloudWatch Logs.

                  Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html>`__ in the *Amazon RDS User Guide.*

                  - *(string) --*

                - **ProcessorFeatures** *(list) --*

                  The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                  - *(dict) --*

                    Contains the processor features of a DB instance class.

                    To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                    You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                    * ``CreateDBInstance``

                    * ``ModifyDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceFromS3``

                    * ``RestoreDBInstanceToPointInTime``

                    You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                    In addition, you can use the following actions for DB instance class processor information:

                    * ``DescribeDBInstances``

                    * ``DescribeDBSnapshots``

                    * ``DescribeValidDBInstanceModifications``

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **Value** *(string) --*

                      The value of a processor feature name.

                - **DeletionProtection** *(boolean) --*

                  Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

                - **AssociatedRoles** *(list) --*

                  The AWS Identity and Access Management (IAM) roles associated with the DB instance.

                  - *(dict) --*

                    Describes an AWS Identity and Access Management (IAM) role that is associated with a DB instance.

                    - **RoleArn** *(string) --*

                      The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.

                    - **FeatureName** *(string) --*

                      The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see ``DBEngineVersion`` .

                    - **Status** *(string) --*

                      Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:

                      * ``ACTIVE`` - the IAM role ARN is associated with the DB instance and can be used to access other AWS services on your behalf.

                      * ``PENDING`` - the IAM role ARN is being associated with the DB instance.

                      * ``INVALID`` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other AWS services on your behalf.

                - **ListenerEndpoint** *(dict) --*

                  Specifies the listener connection endpoint for SQL Server Always On.

                  - **Address** *(string) --*

                    Specifies the DNS address of the DB instance.

                  - **Port** *(integer) --*

                    Specifies the port that the database engine is listening on.

                  - **HostedZoneId** *(string) --*

                    Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

                - **MaxAllocatedStorage** *(integer) --*

                  The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        """
        pass

    def describe_db_log_files(
        self,
        DBInstanceIdentifier: str,
        FilenameContains: str = None,
        FileLastWritten: int = None,
        FileSize: int = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns a list of DB log files for the DB instance.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles>`_

        **Request Syntax**
        ::

          response = client.describe_db_log_files(
              DBInstanceIdentifier='string',
              FilenameContains='string',
              FileLastWritten=123,
              FileSize=123,
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The customer-assigned name of the DB instance that contains the log files you want to list.

          Constraints:

          * Must match the identifier of an existing DBInstance.

        :type FilenameContains: string
        :param FilenameContains:

          Filters the available log files for log file names that contain the specified string.

        :type FileLastWritten: integer
        :param FileLastWritten:

          Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.

        :type FileSize: integer
        :param FileSize:

          Filters the available log files for files larger than the specified size.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

        :type Marker: string
        :param Marker:

          The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DescribeDBLogFiles': [
                    {
                        'LogFileName': 'string',
                        'LastWritten': 123,
                        'Size': 123
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            The response from a call to ``DescribeDBLogFiles`` .

            - **DescribeDBLogFiles** *(list) --*

              The DB log files returned.

              - *(dict) --*

                This data type is used as a response element to ``DescribeDBLogFiles`` .

                - **LogFileName** *(string) --*

                  The name of the log file for the specified DB instance.

                - **LastWritten** *(integer) --*

                  A POSIX timestamp when the last log entry was written.

                - **Size** *(integer) --*

                  The size, in bytes, of the log file for the specified DB instance.

            - **Marker** *(string) --*

              A pagination token that can be used in a subsequent DescribeDBLogFiles request.

        """
        pass

    def describe_db_parameter_groups(
        self,
        DBParameterGroupName: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns a list of ``DBParameterGroup`` descriptions. If a ``DBParameterGroupName`` is specified, the list will contain only the description of the specified DB parameter group.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups>`_

        **Request Syntax**
        ::

          response = client.describe_db_parameter_groups(
              DBParameterGroupName='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBParameterGroupName: string
        :param DBParameterGroupName:

          The name of a specific DB parameter group to return details for.

          Constraints:

          * If supplied, must match the name of an existing DBClusterParameterGroup.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBParameterGroups`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBParameterGroups': [
                    {
                        'DBParameterGroupName': 'string',
                        'DBParameterGroupFamily': 'string',
                        'Description': 'string',
                        'DBParameterGroupArn': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBParameterGroups`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBParameterGroups** *(list) --*

              A list of ``DBParameterGroup`` instances.

              - *(dict) --*

                Contains the details of an Amazon RDS DB parameter group.

                This data type is used as a response element in the ``DescribeDBParameterGroups`` action.

                - **DBParameterGroupName** *(string) --*

                  Provides the name of the DB parameter group.

                - **DBParameterGroupFamily** *(string) --*

                  Provides the name of the DB parameter group family that this DB parameter group is compatible with.

                - **Description** *(string) --*

                  Provides the customer-specified description for this DB parameter group.

                - **DBParameterGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB parameter group.

        """
        pass

    def describe_db_parameters(
        self,
        DBParameterGroupName: str,
        Source: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns the detailed parameter list for a particular DB parameter group.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters>`_

        **Request Syntax**
        ::

          response = client.describe_db_parameters(
              DBParameterGroupName='string',
              Source='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBParameterGroupName: string
        :param DBParameterGroupName: **[REQUIRED]**

          The name of a specific DB parameter group to return details for.

          Constraints:

          * If supplied, must match the name of an existing DBParameterGroup.

        :type Source: string
        :param Source:

          The parameter types to return.

          Default: All parameter types returned

          Valid Values: ``user | system | engine-default``

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBParameters`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Parameters': [
                    {
                        'ParameterName': 'string',
                        'ParameterValue': 'string',
                        'Description': 'string',
                        'Source': 'string',
                        'ApplyType': 'string',
                        'DataType': 'string',
                        'AllowedValues': 'string',
                        'IsModifiable': True|False,
                        'MinimumEngineVersion': 'string',
                        'ApplyMethod': 'immediate'|'pending-reboot',
                        'SupportedEngineModes': [
                            'string',
                        ]
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBParameters`` action.

            - **Parameters** *(list) --*

              A list of ``Parameter`` values.

              - *(dict) --*

                This data type is used as a request parameter in the ``ModifyDBParameterGroup`` and ``ResetDBParameterGroup`` actions.

                This data type is used as a response element in the ``DescribeEngineDefaultParameters`` and ``DescribeDBParameters`` actions.

                - **ParameterName** *(string) --*

                  Specifies the name of the parameter.

                - **ParameterValue** *(string) --*

                  Specifies the value of the parameter.

                - **Description** *(string) --*

                  Provides a description of the parameter.

                - **Source** *(string) --*

                  Indicates the source of the parameter value.

                - **ApplyType** *(string) --*

                  Specifies the engine specific parameters type.

                - **DataType** *(string) --*

                  Specifies the valid data type for the parameter.

                - **AllowedValues** *(string) --*

                  Specifies the valid range of values for the parameter.

                - **IsModifiable** *(boolean) --*

                  Indicates whether (``true`` ) or not (``false`` ) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.

                - **MinimumEngineVersion** *(string) --*

                  The earliest engine version to which the parameter can apply.

                - **ApplyMethod** *(string) --*

                  Indicates when to apply parameter updates.

                - **SupportedEngineModes** *(list) --*

                  The valid DB engine modes.

                  - *(string) --*

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        """
        pass

    def describe_db_security_groups(
        self,
        DBSecurityGroupName: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns a list of ``DBSecurityGroup`` descriptions. If a ``DBSecurityGroupName`` is specified, the list will contain only the descriptions of the specified DB security group.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups>`_

        **Request Syntax**
        ::

          response = client.describe_db_security_groups(
              DBSecurityGroupName='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBSecurityGroupName: string
        :param DBSecurityGroupName:

          The name of the DB security group to return details for.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBSecurityGroups`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBSecurityGroups': [
                    {
                        'OwnerId': 'string',
                        'DBSecurityGroupName': 'string',
                        'DBSecurityGroupDescription': 'string',
                        'VpcId': 'string',
                        'EC2SecurityGroups': [
                            {
                                'Status': 'string',
                                'EC2SecurityGroupName': 'string',
                                'EC2SecurityGroupId': 'string',
                                'EC2SecurityGroupOwnerId': 'string'
                            },
                        ],
                        'IPRanges': [
                            {
                                'Status': 'string',
                                'CIDRIP': 'string'
                            },
                        ],
                        'DBSecurityGroupArn': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBSecurityGroups`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBSecurityGroups** *(list) --*

              A list of ``DBSecurityGroup`` instances.

              - *(dict) --*

                Contains the details for an Amazon RDS DB security group.

                This data type is used as a response element in the ``DescribeDBSecurityGroups`` action.

                - **OwnerId** *(string) --*

                  Provides the AWS ID of the owner of a specific DB security group.

                - **DBSecurityGroupName** *(string) --*

                  Specifies the name of the DB security group.

                - **DBSecurityGroupDescription** *(string) --*

                  Provides the description of the DB security group.

                - **VpcId** *(string) --*

                  Provides the VpcId of the DB security group.

                - **EC2SecurityGroups** *(list) --*

                  Contains a list of ``EC2SecurityGroup`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the following actions:

                    * ``AuthorizeDBSecurityGroupIngress``

                    * ``DescribeDBSecurityGroups``

                    * ``RevokeDBSecurityGroupIngress``

                    - **Status** *(string) --*

                      Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".

                    - **EC2SecurityGroupName** *(string) --*

                      Specifies the name of the EC2 security group.

                    - **EC2SecurityGroupId** *(string) --*

                      Specifies the id of the EC2 security group.

                    - **EC2SecurityGroupOwnerId** *(string) --*

                      Specifies the AWS ID of the owner of the EC2 security group specified in the ``EC2SecurityGroupName`` field.

                - **IPRanges** *(list) --*

                  Contains a list of ``IPRange`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeDBSecurityGroups`` action.

                    - **Status** *(string) --*

                      Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".

                    - **CIDRIP** *(string) --*

                      Specifies the IP range.

                - **DBSecurityGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB security group.

        """
        pass

    def describe_db_snapshot_attributes(
        self,
        DBSnapshotIdentifier: str
    ) -> Dict[str, Any]:
        """
        Returns a list of DB snapshot attribute names and values for a manual DB snapshot.

        When sharing snapshots with other AWS accounts, ``DescribeDBSnapshotAttributes`` returns the ``restore`` attribute and a list of IDs for the AWS accounts that are authorized to copy or restore the manual DB snapshot. If ``all`` is included in the list of values for the ``restore`` attribute, then the manual DB snapshot is public and can be copied or restored by all AWS accounts.

        To add or remove access for an AWS account to copy or restore a manual DB snapshot, or to make the manual DB snapshot public or private, use the ``ModifyDBSnapshotAttribute`` API action.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes>`_

        **Request Syntax**
        ::

          response = client.describe_db_snapshot_attributes(
              DBSnapshotIdentifier='string'
          )
        :type DBSnapshotIdentifier: string
        :param DBSnapshotIdentifier: **[REQUIRED]**

          The identifier for the DB snapshot to describe the attributes for.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSnapshotAttributesResult': {
                    'DBSnapshotIdentifier': 'string',
                    'DBSnapshotAttributes': [
                        {
                            'AttributeName': 'string',
                            'AttributeValues': [
                                'string',
                            ]
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSnapshotAttributesResult** *(dict) --*

              Contains the results of a successful call to the ``DescribeDBSnapshotAttributes`` API action.

              Manual DB snapshot attributes are used to authorize other AWS accounts to copy or restore a manual DB snapshot. For more information, see the ``ModifyDBSnapshotAttribute`` API action.

              - **DBSnapshotIdentifier** *(string) --*

                The identifier of the manual DB snapshot that the attributes apply to.

              - **DBSnapshotAttributes** *(list) --*

                The list of attributes and values for the manual DB snapshot.

                - *(dict) --*

                  Contains the name and values of a manual DB snapshot attribute

                  Manual DB snapshot attributes are used to authorize other AWS accounts to restore a manual DB snapshot. For more information, see the ``ModifyDBSnapshotAttribute`` API.

                  - **AttributeName** *(string) --*

                    The name of the manual DB snapshot attribute.

                    The attribute named ``restore`` refers to the list of AWS accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the ``ModifyDBSnapshotAttribute`` API action.

                  - **AttributeValues** *(list) --*

                    The value or values for the manual DB snapshot attribute.

                    If the ``AttributeName`` field is set to ``restore`` , then this element returns a list of IDs of the AWS accounts that are authorized to copy or restore the manual DB snapshot. If a value of ``all`` is in the list, then the manual DB snapshot is public and available for any AWS account to copy or restore.

                    - *(string) --*

        """
        pass

    def describe_db_snapshots(
        self,
        DBInstanceIdentifier: str = None,
        DBSnapshotIdentifier: str = None,
        SnapshotType: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None,
        IncludeShared: bool = None,
        IncludePublic: bool = None,
        DbiResourceId: str = None
    ) -> Dict[str, Any]:
        """
        .. _https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html: https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html

        Returns information about DB snapshots. This API action supports pagination.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots>`_

        **Request Syntax**
        ::

          response = client.describe_db_snapshots(
              DBInstanceIdentifier='string',
              DBSnapshotIdentifier='string',
              SnapshotType='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string',
              IncludeShared=True|False,
              IncludePublic=True|False,
              DbiResourceId='string'
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier:

          The ID of the DB instance to retrieve the list of DB snapshots for. This parameter can't be used in conjunction with ``DBSnapshotIdentifier`` . This parameter isn't case-sensitive.

          Constraints:

          * If supplied, must match the identifier of an existing DBInstance.

        :type DBSnapshotIdentifier: string
        :param DBSnapshotIdentifier:

          A specific DB snapshot identifier to describe. This parameter can't be used in conjunction with ``DBInstanceIdentifier`` . This value is stored as a lowercase string.

          Constraints:

          * If supplied, must match the identifier of an existing DBSnapshot.

          * If this identifier is for an automated snapshot, the ``SnapshotType`` parameter must also be specified.

        :type SnapshotType: string
        :param SnapshotType:

          The type of snapshots to be returned. You can specify one of the following values:

          * ``automated`` - Return all DB snapshots that have been automatically taken by Amazon RDS for my AWS account.

          * ``manual`` - Return all DB snapshots that have been taken by my AWS account.

          * ``shared`` - Return all manual DB snapshots that have been shared to my AWS account.

          * ``public`` - Return all DB snapshots that have been marked as public.

          * ``awsbackup`` - Return the DB snapshots managed by the AWS Backup service. For information about AWS Backup, see the ` *AWS Backup Developer Guide.* https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html`__   The ``awsbackup`` type does not apply to Aurora.

          If you don't specify a ``SnapshotType`` value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the ``IncludeShared`` parameter. You can include public snapshots with these results by enabling the ``IncludePublic`` parameter.

          The ``IncludeShared`` and ``IncludePublic`` parameters don't apply for ``SnapshotType`` values of ``manual`` or ``automated`` . The ``IncludePublic`` parameter doesn't apply when ``SnapshotType`` is set to ``shared`` . The ``IncludeShared`` parameter doesn't apply when ``SnapshotType`` is set to ``public`` .

        :type Filters: list
        :param Filters:

          A filter that specifies one or more DB snapshots to describe.

          Supported filters:

          * ``db-instance-id`` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).

          * ``db-snapshot-id`` - Accepts DB snapshot identifiers.

          * ``dbi-resource-id`` - Accepts identifiers of source DB instances.

          * ``snapshot-type`` - Accepts types of DB snapshots.

          * ``engine`` - Accepts names of database engines.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeDBSnapshots`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :type IncludeShared: boolean
        :param IncludeShared:

          A value that indicates whether to include shared manual DB cluster snapshots from other AWS accounts that this AWS account has been given permission to copy or restore. By default, these snapshots are not included.

          You can give an AWS account permission to restore a manual DB snapshot from another AWS account by using the ``ModifyDBSnapshotAttribute`` API action.

        :type IncludePublic: boolean
        :param IncludePublic:

          A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any AWS account. By default, the public snapshots are not included.

          You can share a manual DB snapshot as public by using the  ModifyDBSnapshotAttribute API.

        :type DbiResourceId: string
        :param DbiResourceId:

          A specific DB resource ID to describe.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBSnapshots': [
                    {
                        'DBSnapshotIdentifier': 'string',
                        'DBInstanceIdentifier': 'string',
                        'SnapshotCreateTime': datetime(2015, 1, 1),
                        'Engine': 'string',
                        'AllocatedStorage': 123,
                        'Status': 'string',
                        'Port': 123,
                        'AvailabilityZone': 'string',
                        'VpcId': 'string',
                        'InstanceCreateTime': datetime(2015, 1, 1),
                        'MasterUsername': 'string',
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'SnapshotType': 'string',
                        'Iops': 123,
                        'OptionGroupName': 'string',
                        'PercentProgress': 123,
                        'SourceRegion': 'string',
                        'SourceDBSnapshotIdentifier': 'string',
                        'StorageType': 'string',
                        'TdeCredentialArn': 'string',
                        'Encrypted': True|False,
                        'KmsKeyId': 'string',
                        'DBSnapshotArn': 'string',
                        'Timezone': 'string',
                        'IAMDatabaseAuthenticationEnabled': True|False,
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ],
                        'DbiResourceId': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBSnapshots`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBSnapshots** *(list) --*

              A list of ``DBSnapshot`` instances.

              - *(dict) --*

                Contains the details of an Amazon RDS DB snapshot.

                This data type is used as a response element in the ``DescribeDBSnapshots`` action.

                - **DBSnapshotIdentifier** *(string) --*

                  Specifies the identifier for the DB snapshot.

                - **DBInstanceIdentifier** *(string) --*

                  Specifies the DB instance identifier of the DB instance this DB snapshot was created from.

                - **SnapshotCreateTime** *(datetime) --*

                  Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

                - **Engine** *(string) --*

                  Specifies the name of the database engine.

                - **AllocatedStorage** *(integer) --*

                  Specifies the allocated storage size in gibibytes (GiB).

                - **Status** *(string) --*

                  Specifies the status of this DB snapshot.

                - **Port** *(integer) --*

                  Specifies the port that the database engine was listening on at the time of the snapshot.

                - **AvailabilityZone** *(string) --*

                  Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.

                - **VpcId** *(string) --*

                  Provides the VPC ID associated with the DB snapshot.

                - **InstanceCreateTime** *(datetime) --*

                  Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).

                - **MasterUsername** *(string) --*

                  Provides the master username for the DB snapshot.

                - **EngineVersion** *(string) --*

                  Specifies the version of the database engine.

                - **LicenseModel** *(string) --*

                  License model information for the restored DB instance.

                - **SnapshotType** *(string) --*

                  Provides the type of the DB snapshot.

                - **Iops** *(integer) --*

                  Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.

                - **OptionGroupName** *(string) --*

                  Provides the option group name for the DB snapshot.

                - **PercentProgress** *(integer) --*

                  The percentage of the estimated data that has been transferred.

                - **SourceRegion** *(string) --*

                  The AWS Region that the DB snapshot was created in or copied from.

                - **SourceDBSnapshotIdentifier** *(string) --*

                  The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has value in case of cross-customer or cross-region copy.

                - **StorageType** *(string) --*

                  Specifies the storage type associated with DB snapshot.

                - **TdeCredentialArn** *(string) --*

                  The ARN from the key store with which to associate the instance for TDE encryption.

                - **Encrypted** *(boolean) --*

                  Specifies whether the DB snapshot is encrypted.

                - **KmsKeyId** *(string) --*

                  If ``Encrypted`` is true, the AWS KMS key identifier for the encrypted DB snapshot.

                - **DBSnapshotArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB snapshot.

                - **Timezone** *(string) --*

                  The time zone of the DB snapshot. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.

                - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                  True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

                - **ProcessorFeatures** *(list) --*

                  The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.

                  - *(dict) --*

                    Contains the processor features of a DB instance class.

                    To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                    You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                    * ``CreateDBInstance``

                    * ``ModifyDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceFromS3``

                    * ``RestoreDBInstanceToPointInTime``

                    You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                    In addition, you can use the following actions for DB instance class processor information:

                    * ``DescribeDBInstances``

                    * ``DescribeDBSnapshots``

                    * ``DescribeValidDBInstanceModifications``

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **Value** *(string) --*

                      The value of a processor feature name.

                - **DbiResourceId** *(string) --*

                  The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

        """
        pass

    def describe_db_subnet_groups(
        self,
        DBSubnetGroupName: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.

        For an overview of CIDR ranges, go to the `Wikipedia Tutorial <http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`__ .

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups>`_

        **Request Syntax**
        ::

          response = client.describe_db_subnet_groups(
              DBSubnetGroupName='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBSubnetGroupName: string
        :param DBSubnetGroupName:

          The name of the DB subnet group to return details for.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'DBSubnetGroups': [
                    {
                        'DBSubnetGroupName': 'string',
                        'DBSubnetGroupDescription': 'string',
                        'VpcId': 'string',
                        'SubnetGroupStatus': 'string',
                        'Subnets': [
                            {
                                'SubnetIdentifier': 'string',
                                'SubnetAvailabilityZone': {
                                    'Name': 'string'
                                },
                                'SubnetStatus': 'string'
                            },
                        ],
                        'DBSubnetGroupArn': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeDBSubnetGroups`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **DBSubnetGroups** *(list) --*

              A list of ``DBSubnetGroup`` instances.

              - *(dict) --*

                Contains the details of an Amazon RDS DB subnet group.

                This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                - **DBSubnetGroupName** *(string) --*

                  The name of the DB subnet group.

                - **DBSubnetGroupDescription** *(string) --*

                  Provides the description of the DB subnet group.

                - **VpcId** *(string) --*

                  Provides the VpcId of the DB subnet group.

                - **SubnetGroupStatus** *(string) --*

                  Provides the status of the DB subnet group.

                - **Subnets** *(list) --*

                  Contains a list of ``Subnet`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                    - **SubnetIdentifier** *(string) --*

                      Specifies the identifier of the subnet.

                    - **SubnetAvailabilityZone** *(dict) --*

                      Contains Availability Zone information.

                      This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                      - **Name** *(string) --*

                        The name of the Availability Zone.

                    - **SubnetStatus** *(string) --*

                      Specifies the status of the subnet.

                - **DBSubnetGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB subnet group.

        """
        pass

    def describe_engine_default_cluster_parameters(
        self,
        DBParameterGroupFamily: str,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns the default engine and system parameter information for the cluster database engine.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters>`_

        **Request Syntax**
        ::

          response = client.describe_engine_default_cluster_parameters(
              DBParameterGroupFamily='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBParameterGroupFamily: string
        :param DBParameterGroupFamily: **[REQUIRED]**

          The name of the DB cluster parameter group family to return engine parameter information for.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeEngineDefaultClusterParameters`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'EngineDefaults': {
                    'DBParameterGroupFamily': 'string',
                    'Marker': 'string',
                    'Parameters': [
                        {
                            'ParameterName': 'string',
                            'ParameterValue': 'string',
                            'Description': 'string',
                            'Source': 'string',
                            'ApplyType': 'string',
                            'DataType': 'string',
                            'AllowedValues': 'string',
                            'IsModifiable': True|False,
                            'MinimumEngineVersion': 'string',
                            'ApplyMethod': 'immediate'|'pending-reboot',
                            'SupportedEngineModes': [
                                'string',
                            ]
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **EngineDefaults** *(dict) --*

              Contains the result of a successful invocation of the ``DescribeEngineDefaultParameters`` action.

              - **DBParameterGroupFamily** *(string) --*

                Specifies the name of the DB parameter group family that the engine default parameters apply to.

              - **Marker** *(string) --*

                An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

              - **Parameters** *(list) --*

                Contains a list of engine default parameters.

                - *(dict) --*

                  This data type is used as a request parameter in the ``ModifyDBParameterGroup`` and ``ResetDBParameterGroup`` actions.

                  This data type is used as a response element in the ``DescribeEngineDefaultParameters`` and ``DescribeDBParameters`` actions.

                  - **ParameterName** *(string) --*

                    Specifies the name of the parameter.

                  - **ParameterValue** *(string) --*

                    Specifies the value of the parameter.

                  - **Description** *(string) --*

                    Provides a description of the parameter.

                  - **Source** *(string) --*

                    Indicates the source of the parameter value.

                  - **ApplyType** *(string) --*

                    Specifies the engine specific parameters type.

                  - **DataType** *(string) --*

                    Specifies the valid data type for the parameter.

                  - **AllowedValues** *(string) --*

                    Specifies the valid range of values for the parameter.

                  - **IsModifiable** *(boolean) --*

                    Indicates whether (``true`` ) or not (``false`` ) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.

                  - **MinimumEngineVersion** *(string) --*

                    The earliest engine version to which the parameter can apply.

                  - **ApplyMethod** *(string) --*

                    Indicates when to apply parameter updates.

                  - **SupportedEngineModes** *(list) --*

                    The valid DB engine modes.

                    - *(string) --*

        """
        pass

    def describe_engine_default_parameters(
        self,
        DBParameterGroupFamily: str,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns the default engine and system parameter information for the specified database engine.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters>`_

        **Request Syntax**
        ::

          response = client.describe_engine_default_parameters(
              DBParameterGroupFamily='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type DBParameterGroupFamily: string
        :param DBParameterGroupFamily: **[REQUIRED]**

          The name of the DB parameter group family.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeEngineDefaultParameters`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'EngineDefaults': {
                    'DBParameterGroupFamily': 'string',
                    'Marker': 'string',
                    'Parameters': [
                        {
                            'ParameterName': 'string',
                            'ParameterValue': 'string',
                            'Description': 'string',
                            'Source': 'string',
                            'ApplyType': 'string',
                            'DataType': 'string',
                            'AllowedValues': 'string',
                            'IsModifiable': True|False,
                            'MinimumEngineVersion': 'string',
                            'ApplyMethod': 'immediate'|'pending-reboot',
                            'SupportedEngineModes': [
                                'string',
                            ]
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **EngineDefaults** *(dict) --*

              Contains the result of a successful invocation of the ``DescribeEngineDefaultParameters`` action.

              - **DBParameterGroupFamily** *(string) --*

                Specifies the name of the DB parameter group family that the engine default parameters apply to.

              - **Marker** *(string) --*

                An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

              - **Parameters** *(list) --*

                Contains a list of engine default parameters.

                - *(dict) --*

                  This data type is used as a request parameter in the ``ModifyDBParameterGroup`` and ``ResetDBParameterGroup`` actions.

                  This data type is used as a response element in the ``DescribeEngineDefaultParameters`` and ``DescribeDBParameters`` actions.

                  - **ParameterName** *(string) --*

                    Specifies the name of the parameter.

                  - **ParameterValue** *(string) --*

                    Specifies the value of the parameter.

                  - **Description** *(string) --*

                    Provides a description of the parameter.

                  - **Source** *(string) --*

                    Indicates the source of the parameter value.

                  - **ApplyType** *(string) --*

                    Specifies the engine specific parameters type.

                  - **DataType** *(string) --*

                    Specifies the valid data type for the parameter.

                  - **AllowedValues** *(string) --*

                    Specifies the valid range of values for the parameter.

                  - **IsModifiable** *(boolean) --*

                    Indicates whether (``true`` ) or not (``false`` ) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.

                  - **MinimumEngineVersion** *(string) --*

                    The earliest engine version to which the parameter can apply.

                  - **ApplyMethod** *(string) --*

                    Indicates when to apply parameter updates.

                  - **SupportedEngineModes** *(list) --*

                    The valid DB engine modes.

                    - *(string) --*

        """
        pass

    def describe_event_categories(
        self,
        SourceType: str = None,
        Filters: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Displays a list of categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in the `Events <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html>`__ topic in the *Amazon RDS User Guide.*

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories>`_

        **Request Syntax**
        ::

          response = client.describe_event_categories(
              SourceType='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ]
          )
        :type SourceType: string
        :param SourceType:

          The type of source that is generating the events.

          Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'EventCategoriesMapList': [
                    {
                        'SourceType': 'string',
                        'EventCategories': [
                            'string',
                        ]
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Data returned from the **DescribeEventCategories** action.

            - **EventCategoriesMapList** *(list) --*

              A list of EventCategoriesMap data types.

              - *(dict) --*

                Contains the results of a successful invocation of the ``DescribeEventCategories`` action.

                - **SourceType** *(string) --*

                  The source type that the returned categories belong to

                - **EventCategories** *(list) --*

                  The event categories for the specified source type

                  - *(string) --*

        """
        pass

    def describe_event_subscriptions(
        self,
        SubscriptionName: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.

        If you specify a SubscriptionName, lists the description for that subscription.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions>`_

        **Request Syntax**
        ::

          response = client.describe_event_subscriptions(
              SubscriptionName='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type SubscriptionName: string
        :param SubscriptionName:

          The name of the RDS event notification subscription you want to describe.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'EventSubscriptionsList': [
                    {
                        'CustomerAwsId': 'string',
                        'CustSubscriptionId': 'string',
                        'SnsTopicArn': 'string',
                        'Status': 'string',
                        'SubscriptionCreationTime': 'string',
                        'SourceType': 'string',
                        'SourceIdsList': [
                            'string',
                        ],
                        'EventCategoriesList': [
                            'string',
                        ],
                        'Enabled': True|False,
                        'EventSubscriptionArn': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Data returned by the **DescribeEventSubscriptions** action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **EventSubscriptionsList** *(list) --*

              A list of EventSubscriptions data types.

              - *(dict) --*

                Contains the results of a successful invocation of the ``DescribeEventSubscriptions`` action.

                - **CustomerAwsId** *(string) --*

                  The AWS customer account associated with the RDS event notification subscription.

                - **CustSubscriptionId** *(string) --*

                  The RDS event notification subscription Id.

                - **SnsTopicArn** *(string) --*

                  The topic ARN of the RDS event notification subscription.

                - **Status** *(string) --*

                  The status of the RDS event notification subscription.

                  Constraints:

                  Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist

                  The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.

                - **SubscriptionCreationTime** *(string) --*

                  The time the RDS event notification subscription was created.

                - **SourceType** *(string) --*

                  The source type for the RDS event notification subscription.

                - **SourceIdsList** *(list) --*

                  A list of source IDs for the RDS event notification subscription.

                  - *(string) --*

                - **EventCategoriesList** *(list) --*

                  A list of event categories for the RDS event notification subscription.

                  - *(string) --*

                - **Enabled** *(boolean) --*

                  A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.

                - **EventSubscriptionArn** *(string) --*

                  The Amazon Resource Name (ARN) for the event subscription.

        """
        pass

    def describe_events(
        self,
        SourceIdentifier: str = None,
        SourceType: str = None,
        StartTime: datetime = None,
        EndTime: datetime = None,
        Duration: int = None,
        EventCategories: List[Any] = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents>`_

        **Request Syntax**
        ::

          response = client.describe_events(
              SourceIdentifier='string',
              SourceType='db-instance'|'db-parameter-group'|'db-security-group'|'db-snapshot'|'db-cluster'|'db-cluster-snapshot',
              StartTime=datetime(2015, 1, 1),
              EndTime=datetime(2015, 1, 1),
              Duration=123,
              EventCategories=[
                  'string',
              ],
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type SourceIdentifier: string
        :param SourceIdentifier:

          The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.

          Constraints:

          * If SourceIdentifier is supplied, SourceType must also be provided.

          * If the source type is ``DBInstance`` , then a ``DBInstanceIdentifier`` must be supplied.

          * If the source type is ``DBSecurityGroup`` , a ``DBSecurityGroupName`` must be supplied.

          * If the source type is ``DBParameterGroup`` , a ``DBParameterGroupName`` must be supplied.

          * If the source type is ``DBSnapshot`` , a ``DBSnapshotIdentifier`` must be supplied.

          * Can't end with a hyphen or contain two consecutive hyphens.

        :type SourceType: string
        :param SourceType:

          The event source to retrieve events for. If no value is specified, all events are returned.

        :type StartTime: datetime
        :param StartTime:

          The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the `ISO8601 Wikipedia page. <http://en.wikipedia.org/wiki/ISO_8601>`__

          Example: 2009-07-08T18:00Z

        :type EndTime: datetime
        :param EndTime:

          The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the `ISO8601 Wikipedia page. <http://en.wikipedia.org/wiki/ISO_8601>`__

          Example: 2009-07-08T18:00Z

        :type Duration: integer
        :param Duration:

          The number of minutes to retrieve events for.

          Default: 60

        :type EventCategories: list
        :param EventCategories:

          A list of event categories that trigger notifications for a event notification subscription.

          - *(string) --*

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'Events': [
                    {
                        'SourceIdentifier': 'string',
                        'SourceType': 'db-instance'|'db-parameter-group'|'db-security-group'|'db-snapshot'|'db-cluster'|'db-cluster-snapshot',
                        'Message': 'string',
                        'EventCategories': [
                            'string',
                        ],
                        'Date': datetime(2015, 1, 1),
                        'SourceArn': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeEvents`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **Events** *(list) --*

              A list of ``Event`` instances.

              - *(dict) --*

                This data type is used as a response element in the ``DescribeEvents`` action.

                - **SourceIdentifier** *(string) --*

                  Provides the identifier for the source of the event.

                - **SourceType** *(string) --*

                  Specifies the source type for this event.

                - **Message** *(string) --*

                  Provides the text of this event.

                - **EventCategories** *(list) --*

                  Specifies the category for the event.

                  - *(string) --*

                - **Date** *(datetime) --*

                  Specifies the date and time of the event.

                - **SourceArn** *(string) --*

                  The Amazon Resource Name (ARN) for the event.

        """
        pass

    def describe_global_clusters(
        self,
        GlobalClusterIdentifier: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns information about Aurora global database clusters. This API supports pagination.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters>`_

        **Request Syntax**
        ::

          response = client.describe_global_clusters(
              GlobalClusterIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type GlobalClusterIdentifier: string
        :param GlobalClusterIdentifier:

          The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.

          Constraints:

          * If supplied, must match an existing DBClusterIdentifier.

        :type Filters: list
        :param Filters:

          A filter that specifies one or more global DB clusters to describe.

          Supported filters:

          * ``db-cluster-id`` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeGlobalClusters`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'GlobalClusters': [
                    {
                        'GlobalClusterIdentifier': 'string',
                        'GlobalClusterResourceId': 'string',
                        'GlobalClusterArn': 'string',
                        'Status': 'string',
                        'Engine': 'string',
                        'EngineVersion': 'string',
                        'DatabaseName': 'string',
                        'StorageEncrypted': True|False,
                        'DeletionProtection': True|False,
                        'GlobalClusterMembers': [
                            {
                                'DBClusterArn': 'string',
                                'Readers': [
                                    'string',
                                ],
                                'IsWriter': True|False
                            },
                        ]
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            - **Marker** *(string) --*

              An optional pagination token provided by a previous ``DescribeGlobalClusters`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **GlobalClusters** *(list) --*

              The list of global clusters returned by this request.

              - *(dict) --*

                A data type representing an Aurora global database.

                - **GlobalClusterIdentifier** *(string) --*

                  Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster.

                - **GlobalClusterResourceId** *(string) --*

                  The AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

                - **GlobalClusterArn** *(string) --*

                  The Amazon Resource Name (ARN) for the global database cluster.

                - **Status** *(string) --*

                  Specifies the current state of this global database cluster.

                - **Engine** *(string) --*

                  The Aurora database engine used by the global database cluster.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **DatabaseName** *(string) --*

                  The default database name within the new global database cluster.

                - **StorageEncrypted** *(boolean) --*

                  The storage encryption setting for the global database cluster.

                - **DeletionProtection** *(boolean) --*

                  The deletion protection setting for the new global database cluster.

                - **GlobalClusterMembers** *(list) --*

                  The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item.

                  - *(dict) --*

                    A data structure with information about any primary and secondary clusters associated with an Aurora global database.

                    - **DBClusterArn** *(string) --*

                      The Amazon Resource Name (ARN) for each Aurora cluster.

                    - **Readers** *(list) --*

                      The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database.

                      - *(string) --*

                    - **IsWriter** *(boolean) --*

                      Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated.

        """
        pass

    def describe_installation_media(
        self,
        InstallationMediaId: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Describes the available installation media for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeInstallationMedia>`_

        **Request Syntax**
        ::

          response = client.describe_installation_media(
              InstallationMediaId='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type InstallationMediaId: string
        :param InstallationMediaId:

          The installation medium ID.

        :type Filters: list
        :param Filters:

          A filter that specifies one or more installation media to describe. Supported filters include the following:

          * ``custom-availability-zone-id`` - Accepts custom Availability Zone (AZ) identifiers. The results list includes information about only the custom AZs identified by these identifiers.

          * ``engine`` - Accepts database engines. The results list includes information about only the database engines identified by these identifiers. For more information about the valid engines for installation media, see  ImportInstallationMedia .

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          An optional pagination token provided by a previous DescribeInstallationMedia request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'InstallationMedia': [
                    {
                        'InstallationMediaId': 'string',
                        'CustomAvailabilityZoneId': 'string',
                        'Engine': 'string',
                        'EngineVersion': 'string',
                        'EngineInstallationMediaPath': 'string',
                        'OSInstallationMediaPath': 'string',
                        'Status': 'string',
                        'FailureCause': {
                            'Message': 'string'
                        }
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            - **Marker** *(string) --*

              An optional pagination token provided by a previous  DescribeInstallationMedia request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **InstallationMedia** *(list) --*

              The list of  InstallationMedia objects for the AWS account.

              - *(dict) --*

                Contains the installation media for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.

                - **InstallationMediaId** *(string) --*

                  The installation medium ID.

                - **CustomAvailabilityZoneId** *(string) --*

                  The custom Availability Zone (AZ) that contains the installation media.

                - **Engine** *(string) --*

                  The DB engine.

                - **EngineVersion** *(string) --*

                  The engine version of the DB engine.

                - **EngineInstallationMediaPath** *(string) --*

                  The path to the installation medium for the DB engine.

                - **OSInstallationMediaPath** *(string) --*

                  The path to the installation medium for the operating system associated with the DB engine.

                - **Status** *(string) --*

                  The status of the installation medium.

                - **FailureCause** *(dict) --*

                  If an installation media failure occurred, the cause of the failure.

                  - **Message** *(string) --*

                    The reason that an installation media import failed.

        """
        pass

    def describe_option_group_options(
        self,
        EngineName: str,
        MajorEngineVersion: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Describes all available options.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions>`_

        **Request Syntax**
        ::

          response = client.describe_option_group_options(
              EngineName='string',
              MajorEngineVersion='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type EngineName: string
        :param EngineName: **[REQUIRED]**

          A required parameter. Options available for the given engine name are described.

        :type MajorEngineVersion: string
        :param MajorEngineVersion:

          If specified, filters the results to include only options for the specified major engine version.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'OptionGroupOptions': [
                    {
                        'Name': 'string',
                        'Description': 'string',
                        'EngineName': 'string',
                        'MajorEngineVersion': 'string',
                        'MinimumRequiredMinorEngineVersion': 'string',
                        'PortRequired': True|False,
                        'DefaultPort': 123,
                        'OptionsDependedOn': [
                            'string',
                        ],
                        'OptionsConflictsWith': [
                            'string',
                        ],
                        'Persistent': True|False,
                        'Permanent': True|False,
                        'RequiresAutoMinorEngineVersionUpgrade': True|False,
                        'VpcOnly': True|False,
                        'SupportsOptionVersionDowngrade': True|False,
                        'OptionGroupOptionSettings': [
                            {
                                'SettingName': 'string',
                                'SettingDescription': 'string',
                                'DefaultValue': 'string',
                                'ApplyType': 'string',
                                'AllowedValues': 'string',
                                'IsModifiable': True|False,
                                'IsRequired': True|False,
                                'MinimumEngineVersionPerAllowedValue': [
                                    {
                                        'AllowedValue': 'string',
                                        'MinimumEngineVersion': 'string'
                                    },
                                ]
                            },
                        ],
                        'OptionGroupOptionVersions': [
                            {
                                'Version': 'string',
                                'IsDefault': True|False
                            },
                        ]
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            - **OptionGroupOptions** *(list) --*

              List of available option group options.

              - *(dict) --*

                Available option.

                - **Name** *(string) --*

                  The name of the option.

                - **Description** *(string) --*

                  The description of the option.

                - **EngineName** *(string) --*

                  The name of the engine that this option can be applied to.

                - **MajorEngineVersion** *(string) --*

                  Indicates the major engine version that the option is available for.

                - **MinimumRequiredMinorEngineVersion** *(string) --*

                  The minimum required engine version for the option to be applied.

                - **PortRequired** *(boolean) --*

                  Specifies whether the option requires a port.

                - **DefaultPort** *(integer) --*

                  If the option requires a port, specifies the default port for the option.

                - **OptionsDependedOn** *(list) --*

                  The options that are prerequisites for this option.

                  - *(string) --*

                - **OptionsConflictsWith** *(list) --*

                  The options that conflict with this option.

                  - *(string) --*

                - **Persistent** *(boolean) --*

                  Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.

                - **Permanent** *(boolean) --*

                  Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.

                - **RequiresAutoMinorEngineVersionUpgrade** *(boolean) --*

                  If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB instance later.

                - **VpcOnly** *(boolean) --*

                  If true, you can only use this option with a DB instance that is in a VPC.

                - **SupportsOptionVersionDowngrade** *(boolean) --*

                  If true, you can change the option to an earlier version of the option. This only applies to options that have different versions available.

                - **OptionGroupOptionSettings** *(list) --*

                  The option settings that are available (and the default value) for each option in an option group.

                  - *(dict) --*

                    Option group option settings are used to display settings available for each option with their default values and other information. These values are used with the DescribeOptionGroupOptions action.

                    - **SettingName** *(string) --*

                      The name of the option group option.

                    - **SettingDescription** *(string) --*

                      The description of the option group option.

                    - **DefaultValue** *(string) --*

                      The default value for the option group option.

                    - **ApplyType** *(string) --*

                      The DB engine specific parameter type for the option group option.

                    - **AllowedValues** *(string) --*

                      Indicates the acceptable values for the option group option.

                    - **IsModifiable** *(boolean) --*

                      Boolean value where true indicates that this option group option can be changed from the default value.

                    - **IsRequired** *(boolean) --*

                      Boolean value where true indicates that a value must be specified for this option setting of the option group option.

                    - **MinimumEngineVersionPerAllowedValue** *(list) --*

                      The minimum DB engine version required for the corresponding allowed value for this option setting.

                      - *(dict) --*

                        The minimum DB engine version required for each corresponding allowed value for an option setting.

                        - **AllowedValue** *(string) --*

                          The allowed value for an option setting.

                        - **MinimumEngineVersion** *(string) --*

                          The minimum DB engine version required for the allowed value.

                - **OptionGroupOptionVersions** *(list) --*

                  The versions that are available for the option.

                  - *(dict) --*

                    The version for an option. Option group option versions are returned by the ``DescribeOptionGroupOptions`` action.

                    - **Version** *(string) --*

                      The version of the option.

                    - **IsDefault** *(boolean) --*

                      True if the version is the default version of the option, and otherwise false.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        """
        pass

    def describe_option_groups(
        self,
        OptionGroupName: str = None,
        Filters: List[Any] = None,
        Marker: str = None,
        MaxRecords: int = None,
        EngineName: str = None,
        MajorEngineVersion: str = None
    ) -> Dict[str, Any]:
        """
        Describes the available option groups.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups>`_

        **Request Syntax**
        ::

          response = client.describe_option_groups(
              OptionGroupName='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              Marker='string',
              MaxRecords=123,
              EngineName='string',
              MajorEngineVersion='string'
          )
        :type OptionGroupName: string
        :param OptionGroupName:

          The name of the option group to describe. Can't be supplied together with EngineName or MajorEngineVersion.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous DescribeOptionGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type EngineName: string
        :param EngineName:

          Filters the list of option groups to only include groups associated with a specific database engine.

        :type MajorEngineVersion: string
        :param MajorEngineVersion:

          Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'OptionGroupsList': [
                    {
                        'OptionGroupName': 'string',
                        'OptionGroupDescription': 'string',
                        'EngineName': 'string',
                        'MajorEngineVersion': 'string',
                        'Options': [
                            {
                                'OptionName': 'string',
                                'OptionDescription': 'string',
                                'Persistent': True|False,
                                'Permanent': True|False,
                                'Port': 123,
                                'OptionVersion': 'string',
                                'OptionSettings': [
                                    {
                                        'Name': 'string',
                                        'Value': 'string',
                                        'DefaultValue': 'string',
                                        'Description': 'string',
                                        'ApplyType': 'string',
                                        'DataType': 'string',
                                        'AllowedValues': 'string',
                                        'IsModifiable': True|False,
                                        'IsCollection': True|False
                                    },
                                ],
                                'DBSecurityGroupMemberships': [
                                    {
                                        'DBSecurityGroupName': 'string',
                                        'Status': 'string'
                                    },
                                ],
                                'VpcSecurityGroupMemberships': [
                                    {
                                        'VpcSecurityGroupId': 'string',
                                        'Status': 'string'
                                    },
                                ]
                            },
                        ],
                        'AllowsVpcAndNonVpcInstanceMemberships': True|False,
                        'VpcId': 'string',
                        'OptionGroupArn': 'string'
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            List of option groups.

            - **OptionGroupsList** *(list) --*

              List of option groups.

              - *(dict) --*

                - **OptionGroupName** *(string) --*

                  Specifies the name of the option group.

                - **OptionGroupDescription** *(string) --*

                  Provides a description of the option group.

                - **EngineName** *(string) --*

                  Indicates the name of the engine that this option group can be applied to.

                - **MajorEngineVersion** *(string) --*

                  Indicates the major engine version associated with this option group.

                - **Options** *(list) --*

                  Indicates what options are available in the option group.

                  - *(dict) --*

                    Option details.

                    - **OptionName** *(string) --*

                      The name of the option.

                    - **OptionDescription** *(string) --*

                      The description of the option.

                    - **Persistent** *(boolean) --*

                      Indicate if this option is persistent.

                    - **Permanent** *(boolean) --*

                      Indicate if this option is permanent.

                    - **Port** *(integer) --*

                      If required, the port configured for this option to use.

                    - **OptionVersion** *(string) --*

                      The version of the option.

                    - **OptionSettings** *(list) --*

                      The option settings for this option.

                      - *(dict) --*

                        Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.

                        - **Name** *(string) --*

                          The name of the option that has settings that you can set.

                        - **Value** *(string) --*

                          The current value of the option setting.

                        - **DefaultValue** *(string) --*

                          The default value of the option setting.

                        - **Description** *(string) --*

                          The description of the option setting.

                        - **ApplyType** *(string) --*

                          The DB engine specific parameter type.

                        - **DataType** *(string) --*

                          The data type of the option setting.

                        - **AllowedValues** *(string) --*

                          The allowed values of the option setting.

                        - **IsModifiable** *(boolean) --*

                          A Boolean value that, when true, indicates the option setting can be modified from the default.

                        - **IsCollection** *(boolean) --*

                          Indicates if the option setting is part of a collection.

                    - **DBSecurityGroupMemberships** *(list) --*

                      If the option requires access to a port, then this DB security group allows access to the port.

                      - *(dict) --*

                        This data type is used as a response element in the following actions:

                        * ``ModifyDBInstance``

                        * ``RebootDBInstance``

                        * ``RestoreDBInstanceFromDBSnapshot``

                        * ``RestoreDBInstanceToPointInTime``

                        - **DBSecurityGroupName** *(string) --*

                          The name of the DB security group.

                        - **Status** *(string) --*

                          The status of the DB security group.

                    - **VpcSecurityGroupMemberships** *(list) --*

                      If the option requires access to a port, then this VPC security group allows access to the port.

                      - *(dict) --*

                        This data type is used as a response element for queries on VPC security group membership.

                        - **VpcSecurityGroupId** *(string) --*

                          The name of the VPC security group.

                        - **Status** *(string) --*

                          The status of the VPC security group.

                - **AllowsVpcAndNonVpcInstanceMemberships** *(boolean) --*

                  Indicates whether this option group can be applied to both VPC and non-VPC instances. The value ``true`` indicates the option group can be applied to both VPC and non-VPC instances.

                - **VpcId** *(string) --*

                  If **AllowsVpcAndNonVpcInstanceMemberships** is ``false`` , this field is blank. If **AllowsVpcAndNonVpcInstanceMemberships** is ``true`` and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field.

                - **OptionGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the option group.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        """
        pass

    def describe_orderable_db_instance_options(
        self,
        Engine: str,
        EngineVersion: str = None,
        DBInstanceClass: str = None,
        LicenseModel: str = None,
        Vpc: bool = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns a list of orderable DB instance options for the specified engine.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions>`_

        **Request Syntax**
        ::

          response = client.describe_orderable_db_instance_options(
              Engine='string',
              EngineVersion='string',
              DBInstanceClass='string',
              LicenseModel='string',
              Vpc=True|False,
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type Engine: string
        :param Engine: **[REQUIRED]**

          The name of the engine to retrieve DB instance options for.

        :type EngineVersion: string
        :param EngineVersion:

          The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.

        :type DBInstanceClass: string
        :param DBInstanceClass:

          The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.

        :type LicenseModel: string
        :param LicenseModel:

          The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.

        :type Vpc: boolean
        :param Vpc:

          A value that indicates whether to show only VPC or non-VPC offerings.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'OrderableDBInstanceOptions': [
                    {
                        'Engine': 'string',
                        'EngineVersion': 'string',
                        'DBInstanceClass': 'string',
                        'LicenseModel': 'string',
                        'AvailabilityZones': [
                            {
                                'Name': 'string'
                            },
                        ],
                        'MultiAZCapable': True|False,
                        'ReadReplicaCapable': True|False,
                        'Vpc': True|False,
                        'SupportsStorageEncryption': True|False,
                        'StorageType': 'string',
                        'SupportsIops': True|False,
                        'SupportsEnhancedMonitoring': True|False,
                        'SupportsIAMDatabaseAuthentication': True|False,
                        'SupportsPerformanceInsights': True|False,
                        'MinStorageSize': 123,
                        'MaxStorageSize': 123,
                        'MinIopsPerDbInstance': 123,
                        'MaxIopsPerDbInstance': 123,
                        'MinIopsPerGib': 123.0,
                        'MaxIopsPerGib': 123.0,
                        'AvailableProcessorFeatures': [
                            {
                                'Name': 'string',
                                'DefaultValue': 'string',
                                'AllowedValues': 'string'
                            },
                        ],
                        'SupportedEngineModes': [
                            'string',
                        ],
                        'SupportsStorageAutoscaling': True|False,
                        'SupportsKerberosAuthentication': True|False
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeOrderableDBInstanceOptions`` action.

            - **OrderableDBInstanceOptions** *(list) --*

              An ``OrderableDBInstanceOption`` structure containing information about orderable options for the DB instance.

              - *(dict) --*

                Contains a list of available options for a DB instance.

                This data type is used as a response element in the ``DescribeOrderableDBInstanceOptions`` action.

                - **Engine** *(string) --*

                  The engine type of a DB instance.

                - **EngineVersion** *(string) --*

                  The engine version of a DB instance.

                - **DBInstanceClass** *(string) --*

                  The DB instance class for a DB instance.

                - **LicenseModel** *(string) --*

                  The license model for a DB instance.

                - **AvailabilityZones** *(list) --*

                  A list of Availability Zones for a DB instance.

                  - *(dict) --*

                    Contains Availability Zone information.

                    This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                    - **Name** *(string) --*

                      The name of the Availability Zone.

                - **MultiAZCapable** *(boolean) --*

                  Indicates whether a DB instance is Multi-AZ capable.

                - **ReadReplicaCapable** *(boolean) --*

                  Indicates whether a DB instance can have a Read Replica.

                - **Vpc** *(boolean) --*

                  Indicates whether a DB instance is in a VPC.

                - **SupportsStorageEncryption** *(boolean) --*

                  Indicates whether a DB instance supports encrypted storage.

                - **StorageType** *(string) --*

                  Indicates the storage type for a DB instance.

                - **SupportsIops** *(boolean) --*

                  Indicates whether a DB instance supports provisioned IOPS.

                - **SupportsEnhancedMonitoring** *(boolean) --*

                  Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.

                - **SupportsIAMDatabaseAuthentication** *(boolean) --*

                  Indicates whether a DB instance supports IAM database authentication.

                - **SupportsPerformanceInsights** *(boolean) --*

                  True if a DB instance supports Performance Insights, otherwise false.

                - **MinStorageSize** *(integer) --*

                  Minimum storage size for a DB instance.

                - **MaxStorageSize** *(integer) --*

                  Maximum storage size for a DB instance.

                - **MinIopsPerDbInstance** *(integer) --*

                  Minimum total provisioned IOPS for a DB instance.

                - **MaxIopsPerDbInstance** *(integer) --*

                  Maximum total provisioned IOPS for a DB instance.

                - **MinIopsPerGib** *(float) --*

                  Minimum provisioned IOPS per GiB for a DB instance.

                - **MaxIopsPerGib** *(float) --*

                  Maximum provisioned IOPS per GiB for a DB instance.

                - **AvailableProcessorFeatures** *(list) --*

                  A list of the available processor features for the DB instance class of a DB instance.

                  - *(dict) --*

                    Contains the available processor feature information for the DB instance class of a DB instance.

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **DefaultValue** *(string) --*

                      The default value for the processor feature of the DB instance class.

                    - **AllowedValues** *(string) --*

                      The allowed values for the processor feature of the DB instance class.

                - **SupportedEngineModes** *(list) --*

                  A list of the supported DB engine modes.

                  - *(string) --*

                - **SupportsStorageAutoscaling** *(boolean) --*

                  Whether or not Amazon RDS can automatically scale storage for DB instances that use the specified instance class.

                - **SupportsKerberosAuthentication** *(boolean) --*

                  Whether a DB instance supports Kerberos Authentication.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        """
        pass

    def describe_pending_maintenance_actions(
        self,
        ResourceIdentifier: str = None,
        Filters: List[Any] = None,
        Marker: str = None,
        MaxRecords: int = None
    ) -> Dict[str, Any]:
        """
        Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions>`_

        **Request Syntax**
        ::

          response = client.describe_pending_maintenance_actions(
              ResourceIdentifier='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              Marker='string',
              MaxRecords=123
          )
        :type ResourceIdentifier: string
        :param ResourceIdentifier:

          The ARN of a resource to return pending maintenance actions for.

        :type Filters: list
        :param Filters:

          A filter that specifies one or more resources to return pending maintenance actions for.

          Supported filters:

          * ``db-cluster-id`` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance actions for the DB clusters identified by these ARNs.

          * ``db-instance-id`` - Accepts DB instance identifiers and DB instance ARNs. The results list will only include pending maintenance actions for the DB instances identified by these ARNs.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribePendingMaintenanceActions`` request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by ``MaxRecords`` .

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'PendingMaintenanceActions': [
                    {
                        'ResourceIdentifier': 'string',
                        'PendingMaintenanceActionDetails': [
                            {
                                'Action': 'string',
                                'AutoAppliedAfterDate': datetime(2015, 1, 1),
                                'ForcedApplyDate': datetime(2015, 1, 1),
                                'OptInStatus': 'string',
                                'CurrentApplyDate': datetime(2015, 1, 1),
                                'Description': 'string'
                            },
                        ]
                    },
                ],
                'Marker': 'string'
            }
          **Response Structure**

          - *(dict) --*

            Data returned from the **DescribePendingMaintenanceActions** action.

            - **PendingMaintenanceActions** *(list) --*

              A list of the pending maintenance actions for the resource.

              - *(dict) --*

                Describes the pending maintenance actions for a resource.

                - **ResourceIdentifier** *(string) --*

                  The ARN of the resource that has pending maintenance actions.

                - **PendingMaintenanceActionDetails** *(list) --*

                  A list that provides details about the pending maintenance actions for the resource.

                  - *(dict) --*

                    Provides information about a pending maintenance action for a resource.

                    - **Action** *(string) --*

                      The type of pending maintenance action that is available for the resource. Valid actions are ``system-update`` , ``db-upgrade`` , and ``hardware-maintenance`` .

                    - **AutoAppliedAfterDate** *(datetime) --*

                      The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.

                    - **ForcedApplyDate** *(datetime) --*

                      The date when the maintenance action is automatically applied. The maintenance action is applied to the resource on this date regardless of the maintenance window for the resource.

                    - **OptInStatus** *(string) --*

                      Indicates the type of opt-in request that has been received for the resource.

                    - **CurrentApplyDate** *(datetime) --*

                      The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the ``ApplyPendingMaintenanceAction`` API, the ``AutoAppliedAfterDate`` , and the ``ForcedApplyDate`` . This value is blank if an opt-in request has not been received and nothing has been specified as ``AutoAppliedAfterDate`` or ``ForcedApplyDate`` .

                    - **Description** *(string) --*

                      A description providing more detail about the maintenance action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous ``DescribePendingMaintenanceActions`` request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by ``MaxRecords`` .

        """
        pass

    def describe_reserved_db_instances(
        self,
        ReservedDBInstanceId: str = None,
        ReservedDBInstancesOfferingId: str = None,
        DBInstanceClass: str = None,
        Duration: str = None,
        ProductDescription: str = None,
        OfferingType: str = None,
        MultiAZ: bool = None,
        LeaseId: str = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Returns information about reserved DB instances for this account, or about a specified reserved DB instance.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances>`_

        **Request Syntax**
        ::

          response = client.describe_reserved_db_instances(
              ReservedDBInstanceId='string',
              ReservedDBInstancesOfferingId='string',
              DBInstanceClass='string',
              Duration='string',
              ProductDescription='string',
              OfferingType='string',
              MultiAZ=True|False,
              LeaseId='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type ReservedDBInstanceId: string
        :param ReservedDBInstanceId:

          The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID.

        :type ReservedDBInstancesOfferingId: string
        :param ReservedDBInstancesOfferingId:

          The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier.

        :type DBInstanceClass: string
        :param DBInstanceClass:

          The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class.

        :type Duration: string
        :param Duration:

          The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.

          Valid Values: ``1 | 3 | 31536000 | 94608000``

        :type ProductDescription: string
        :param ProductDescription:

          The product description filter value. Specify this parameter to show only those reservations matching the specified product description.

        :type OfferingType: string
        :param OfferingType:

          The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.

          Valid Values: ``"Partial Upfront" | "All Upfront" | "No Upfront"``

        :type MultiAZ: boolean
        :param MultiAZ:

          A value that indicates whether to show only those reservations that support Multi-AZ.

        :type LeaseId: string
        :param LeaseId:

          The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified lease ID.

          .. note::

            AWS Support might request the lease ID for an issue related to a reserved DB instance.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more than the ``MaxRecords`` value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'ReservedDBInstances': [
                    {
                        'ReservedDBInstanceId': 'string',
                        'ReservedDBInstancesOfferingId': 'string',
                        'DBInstanceClass': 'string',
                        'StartTime': datetime(2015, 1, 1),
                        'Duration': 123,
                        'FixedPrice': 123.0,
                        'UsagePrice': 123.0,
                        'CurrencyCode': 'string',
                        'DBInstanceCount': 123,
                        'ProductDescription': 'string',
                        'OfferingType': 'string',
                        'MultiAZ': True|False,
                        'State': 'string',
                        'RecurringCharges': [
                            {
                                'RecurringChargeAmount': 123.0,
                                'RecurringChargeFrequency': 'string'
                            },
                        ],
                        'ReservedDBInstanceArn': 'string',
                        'LeaseId': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeReservedDBInstances`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **ReservedDBInstances** *(list) --*

              A list of reserved DB instances.

              - *(dict) --*

                This data type is used as a response element in the ``DescribeReservedDBInstances`` and ``PurchaseReservedDBInstancesOffering`` actions.

                - **ReservedDBInstanceId** *(string) --*

                  The unique identifier for the reservation.

                - **ReservedDBInstancesOfferingId** *(string) --*

                  The offering identifier.

                - **DBInstanceClass** *(string) --*

                  The DB instance class for the reserved DB instance.

                - **StartTime** *(datetime) --*

                  The time the reservation started.

                - **Duration** *(integer) --*

                  The duration of the reservation in seconds.

                - **FixedPrice** *(float) --*

                  The fixed price charged for this reserved DB instance.

                - **UsagePrice** *(float) --*

                  The hourly price charged for this reserved DB instance.

                - **CurrencyCode** *(string) --*

                  The currency code for the reserved DB instance.

                - **DBInstanceCount** *(integer) --*

                  The number of reserved DB instances.

                - **ProductDescription** *(string) --*

                  The description of the reserved DB instance.

                - **OfferingType** *(string) --*

                  The offering type of this reserved DB instance.

                - **MultiAZ** *(boolean) --*

                  Indicates if the reservation applies to Multi-AZ deployments.

                - **State** *(string) --*

                  The state of the reserved DB instance.

                - **RecurringCharges** *(list) --*

                  The recurring price charged to run this reserved DB instance.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeReservedDBInstances`` and ``DescribeReservedDBInstancesOfferings`` actions.

                    - **RecurringChargeAmount** *(float) --*

                      The amount of the recurring charge.

                    - **RecurringChargeFrequency** *(string) --*

                      The frequency of the recurring charge.

                - **ReservedDBInstanceArn** *(string) --*

                  The Amazon Resource Name (ARN) for the reserved DB instance.

                - **LeaseId** *(string) --*

                  The unique identifier for the lease associated with the reserved DB instance.

                  .. note::

                    AWS Support might request the lease ID for an issue related to a reserved DB instance.

        """
        pass

    def describe_reserved_db_instances_offerings(
        self,
        ReservedDBInstancesOfferingId: str = None,
        DBInstanceClass: str = None,
        Duration: str = None,
        ProductDescription: str = None,
        OfferingType: str = None,
        MultiAZ: bool = None,
        Filters: List[Any] = None,
        MaxRecords: int = None,
        Marker: str = None
    ) -> Dict[str, Any]:
        """
        Lists available reserved DB instance offerings.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings>`_

        **Request Syntax**
        ::

          response = client.describe_reserved_db_instances_offerings(
              ReservedDBInstancesOfferingId='string',
              DBInstanceClass='string',
              Duration='string',
              ProductDescription='string',
              OfferingType='string',
              MultiAZ=True|False,
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ],
              MaxRecords=123,
              Marker='string'
          )
        :type ReservedDBInstancesOfferingId: string
        :param ReservedDBInstancesOfferingId:

          The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier.

          Example: ``438012d3-4052-4cc7-b2e3-8d3372e0e706``

        :type DBInstanceClass: string
        :param DBInstanceClass:

          The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.

        :type Duration: string
        :param Duration:

          Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.

          Valid Values: ``1 | 3 | 31536000 | 94608000``

        :type ProductDescription: string
        :param ProductDescription:

          Product description filter value. Specify this parameter to show only the available offerings that contain the specified product description.

          .. note::

            The results show offerings that partially match the filter value.

        :type OfferingType: string
        :param OfferingType:

          The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.

          Valid Values: ``"Partial Upfront" | "All Upfront" | "No Upfront"``

        :type MultiAZ: boolean
        :param MultiAZ:

          A value that indicates whether to show only those reservations that support Multi-AZ.

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more than the ``MaxRecords`` value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'ReservedDBInstancesOfferings': [
                    {
                        'ReservedDBInstancesOfferingId': 'string',
                        'DBInstanceClass': 'string',
                        'Duration': 123,
                        'FixedPrice': 123.0,
                        'UsagePrice': 123.0,
                        'CurrencyCode': 'string',
                        'ProductDescription': 'string',
                        'OfferingType': 'string',
                        'MultiAZ': True|False,
                        'RecurringCharges': [
                            {
                                'RecurringChargeAmount': 123.0,
                                'RecurringChargeFrequency': 'string'
                            },
                        ]
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeReservedDBInstancesOfferings`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **ReservedDBInstancesOfferings** *(list) --*

              A list of reserved DB instance offerings.

              - *(dict) --*

                This data type is used as a response element in the ``DescribeReservedDBInstancesOfferings`` action.

                - **ReservedDBInstancesOfferingId** *(string) --*

                  The offering identifier.

                - **DBInstanceClass** *(string) --*

                  The DB instance class for the reserved DB instance.

                - **Duration** *(integer) --*

                  The duration of the offering in seconds.

                - **FixedPrice** *(float) --*

                  The fixed price charged for this offering.

                - **UsagePrice** *(float) --*

                  The hourly price charged for this offering.

                - **CurrencyCode** *(string) --*

                  The currency code for the reserved DB instance offering.

                - **ProductDescription** *(string) --*

                  The database engine used by the offering.

                - **OfferingType** *(string) --*

                  The offering type.

                - **MultiAZ** *(boolean) --*

                  Indicates if the offering applies to Multi-AZ deployments.

                - **RecurringCharges** *(list) --*

                  The recurring price charged to run this reserved DB instance.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeReservedDBInstances`` and ``DescribeReservedDBInstancesOfferings`` actions.

                    - **RecurringChargeAmount** *(float) --*

                      The amount of the recurring charge.

                    - **RecurringChargeFrequency** *(string) --*

                      The frequency of the recurring charge.

        """
        pass

    def describe_source_regions(
        self,
        RegionName: str = None,
        MaxRecords: int = None,
        Marker: str = None,
        Filters: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Returns a list of the source AWS Regions where the current AWS Region can create a Read Replica or copy a DB snapshot from. This API action supports pagination.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions>`_

        **Request Syntax**
        ::

          response = client.describe_source_regions(
              RegionName='string',
              MaxRecords=123,
              Marker='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ]
          )
        :type RegionName: string
        :param RegionName:

          The source AWS Region name. For example, ``us-east-1`` .

          Constraints:

          * Must specify a valid AWS Region name.

        :type MaxRecords: integer
        :param MaxRecords:

          The maximum number of records to include in the response. If more records exist than the specified ``MaxRecords`` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.

          Default: 100

          Constraints: Minimum 20, maximum 100.

        :type Marker: string
        :param Marker:

          An optional pagination token provided by a previous ``DescribeSourceRegions`` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'Marker': 'string',
                'SourceRegions': [
                    {
                        'RegionName': 'string',
                        'Endpoint': 'string',
                        'Status': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``DescribeSourceRegions`` action.

            - **Marker** *(string) --*

              An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by ``MaxRecords`` .

            - **SourceRegions** *(list) --*

              A list of SourceRegion instances that contains each source AWS Region that the current AWS Region can get a Read Replica or a DB snapshot from.

              - *(dict) --*

                Contains an AWS Region name as the result of a successful call to the ``DescribeSourceRegions`` action.

                - **RegionName** *(string) --*

                  The name of the source AWS Region.

                - **Endpoint** *(string) --*

                  The endpoint for the source AWS Region endpoint.

                - **Status** *(string) --*

                  The status of the source AWS Region.

        """
        pass

    def describe_valid_db_instance_modifications(
        self,
        DBInstanceIdentifier: str
    ) -> Dict[str, Any]:
        """
        You can call ``DescribeValidDBInstanceModifications`` to learn what modifications you can make to your DB instance. You can use this information when you call ``ModifyDBInstance`` .

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications>`_

        **Request Syntax**
        ::

          response = client.describe_valid_db_instance_modifications(
              DBInstanceIdentifier='string'
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The customer identifier or the ARN of your DB instance.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'ValidDBInstanceModificationsMessage': {
                    'Storage': [
                        {
                            'StorageType': 'string',
                            'StorageSize': [
                                {
                                    'From': 123,
                                    'To': 123,
                                    'Step': 123
                                },
                            ],
                            'ProvisionedIops': [
                                {
                                    'From': 123,
                                    'To': 123,
                                    'Step': 123
                                },
                            ],
                            'IopsToStorageRatio': [
                                {
                                    'From': 123.0,
                                    'To': 123.0
                                },
                            ],
                            'SupportsStorageAutoscaling': True|False
                        },
                    ],
                    'ValidProcessorFeatures': [
                        {
                            'Name': 'string',
                            'DefaultValue': 'string',
                            'AllowedValues': 'string'
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **ValidDBInstanceModificationsMessage** *(dict) --*

              Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the ``DescribeValidDBInstanceModifications`` action. You can use this information when you call ``ModifyDBInstance`` .

              - **Storage** *(list) --*

                Valid storage options for your DB instance.

                - *(dict) --*

                  Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the ``DescribeValidDBInstanceModifications`` action.

                  - **StorageType** *(string) --*

                    The valid storage types for your DB instance. For example, gp2, io1.

                  - **StorageSize** *(list) --*

                    The valid range of storage in gibibytes. For example, 100 to 16384.

                    - *(dict) --*

                      A range of integer values.

                      - **From** *(integer) --*

                        The minimum value in the range.

                      - **To** *(integer) --*

                        The maximum value in the range.

                      - **Step** *(integer) --*

                        The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...

                  - **ProvisionedIops** *(list) --*

                    The valid range of provisioned IOPS. For example, 1000-20000.

                    - *(dict) --*

                      A range of integer values.

                      - **From** *(integer) --*

                        The minimum value in the range.

                      - **To** *(integer) --*

                        The maximum value in the range.

                      - **Step** *(integer) --*

                        The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...

                  - **IopsToStorageRatio** *(list) --*

                    The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage.

                    - *(dict) --*

                      A range of double values.

                      - **From** *(float) --*

                        The minimum value in the range.

                      - **To** *(float) --*

                        The maximum value in the range.

                  - **SupportsStorageAutoscaling** *(boolean) --*

                    Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.

              - **ValidProcessorFeatures** *(list) --*

                Valid processor features for your DB instance.

                - *(dict) --*

                  Contains the available processor feature information for the DB instance class of a DB instance.

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **DefaultValue** *(string) --*

                    The default value for the processor feature of the DB instance class.

                  - **AllowedValues** *(string) --*

                    The allowed values for the processor feature of the DB instance class.

        """
        pass

    def download_db_log_file_portion(
        self,
        DBInstanceIdentifier: str,
        LogFileName: str,
        Marker: str = None,
        NumberOfLines: int = None
    ) -> Dict[str, Any]:
        """
        Downloads all or a portion of the specified log file, up to 1 MB in size.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion>`_

        **Request Syntax**
        ::

          response = client.download_db_log_file_portion(
              DBInstanceIdentifier='string',
              LogFileName='string',
              Marker='string',
              NumberOfLines=123
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The customer-assigned name of the DB instance that contains the log files you want to list.

          Constraints:

          * Must match the identifier of an existing DBInstance.

        :type LogFileName: string
        :param LogFileName: **[REQUIRED]**

          The name of the log file to be downloaded.

        :type Marker: string
        :param Marker:

          The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.

        :type NumberOfLines: integer
        :param NumberOfLines:

          The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.

          If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or the end of the log file, depending on the value of the Marker parameter.

          * If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of 10000 lines, starting with the most recent log entries first.

          * If NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end of the log file are returned.

          * If Marker is specified as "0", then the specified number of lines from the beginning of the log file are returned.

          * You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your first request. Include the Marker value returned in the response as the Marker value for the next request, continuing until the AdditionalDataPending response element returns false.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'LogFileData': 'string',
                'Marker': 'string',
                'AdditionalDataPending': True|False
            }
          **Response Structure**

          - *(dict) --*

            This data type is used as a response element to ``DownloadDBLogFilePortion`` .

            - **LogFileData** *(string) --*

              Entries from the specified log file.

            - **Marker** *(string) --*

              A pagination token that can be used in a subsequent DownloadDBLogFilePortion request.

            - **AdditionalDataPending** *(boolean) --*

              Boolean value that if true, indicates there is more data to be downloaded.

        """
        pass

    def failover_db_cluster(
        self,
        DBClusterIdentifier: str,
        TargetDBInstanceIdentifier: str = None
    ) -> Dict[str, Any]:
        """
        Forces a failover for a DB cluster.

        A failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in the DB cluster to be the primary instance (the cluster writer).

        Amazon Aurora will automatically fail over to an Aurora Replica, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster>`_

        **Request Syntax**
        ::

          response = client.failover_db_cluster(
              DBClusterIdentifier='string',
              TargetDBInstanceIdentifier='string'
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          A DB cluster identifier to force a failover for. This parameter isn't case-sensitive.

          Constraints:

          * Must match the identifier of an existing DBCluster.

        :type TargetDBInstanceIdentifier: string
        :param TargetDBInstanceIdentifier:

          The name of the instance to promote to the primary instance.

          You must specify the instance identifier for an Aurora Replica in the DB cluster. For example, ``mydbcluster-replica1`` .

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBCluster': {
                    'AllocatedStorage': 123,
                    'AvailabilityZones': [
                        'string',
                    ],
                    'BackupRetentionPeriod': 123,
                    'CharacterSetName': 'string',
                    'DatabaseName': 'string',
                    'DBClusterIdentifier': 'string',
                    'DBClusterParameterGroup': 'string',
                    'DBSubnetGroup': 'string',
                    'Status': 'string',
                    'PercentProgress': 'string',
                    'EarliestRestorableTime': datetime(2015, 1, 1),
                    'Endpoint': 'string',
                    'ReaderEndpoint': 'string',
                    'CustomEndpoints': [
                        'string',
                    ],
                    'MultiAZ': True|False,
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'Port': 123,
                    'MasterUsername': 'string',
                    'DBClusterOptionGroupMemberships': [
                        {
                            'DBClusterOptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'PreferredBackupWindow': 'string',
                    'PreferredMaintenanceWindow': 'string',
                    'ReplicationSourceIdentifier': 'string',
                    'ReadReplicaIdentifiers': [
                        'string',
                    ],
                    'DBClusterMembers': [
                        {
                            'DBInstanceIdentifier': 'string',
                            'IsClusterWriter': True|False,
                            'DBClusterParameterGroupStatus': 'string',
                            'PromotionTier': 123
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'HostedZoneId': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbClusterResourceId': 'string',
                    'DBClusterArn': 'string',
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'Status': 'string',
                            'FeatureName': 'string'
                        },
                    ],
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'CloneGroupId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'EarliestBacktrackTime': datetime(2015, 1, 1),
                    'BacktrackWindow': 123,
                    'BacktrackConsumedChangeRecords': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'Capacity': 123,
                    'EngineMode': 'string',
                    'ScalingConfigurationInfo': {
                        'MinCapacity': 123,
                        'MaxCapacity': 123,
                        'AutoPause': True|False,
                        'SecondsUntilAutoPause': 123,
                        'TimeoutAction': 'string'
                    },
                    'DeletionProtection': True|False,
                    'HttpEndpointEnabled': True|False,
                    'ActivityStreamMode': 'sync'|'async',
                    'ActivityStreamStatus': 'stopped'|'starting'|'started'|'stopping',
                    'ActivityStreamKmsKeyId': 'string',
                    'ActivityStreamKinesisStreamName': 'string',
                    'CopyTagsToSnapshot': True|False,
                    'CrossAccountClone': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBCluster** *(dict) --*

              Contains the details of an Amazon Aurora DB cluster.

              This data type is used as a response element in the ``DescribeDBClusters`` , ``StopDBCluster`` , and ``StartDBCluster`` actions.

              - **AllocatedStorage** *(integer) --*

                For all database engines except Amazon Aurora, ``AllocatedStorage`` specifies the allocated storage size in gibibytes (GiB). For Aurora, ``AllocatedStorage`` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.

                - *(string) --*

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this cluster is associated with.

              - **DatabaseName** *(string) --*

                Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.

              - **DBClusterIdentifier** *(string) --*

                Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

              - **DBClusterParameterGroup** *(string) --*

                Specifies the name of the DB cluster parameter group for the DB cluster.

              - **DBSubnetGroup** *(string) --*

                Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.

              - **Status** *(string) --*

                Specifies the current state of this DB cluster.

              - **PercentProgress** *(string) --*

                Specifies the progress of the operation as a percentage.

              - **EarliestRestorableTime** *(datetime) --*

                The earliest time to which a database can be restored with point-in-time restore.

              - **Endpoint** *(string) --*

                Specifies the connection endpoint for the primary instance of the DB cluster.

              - **ReaderEndpoint** *(string) --*

                The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.

                If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.

              - **CustomEndpoints** *(list) --*

                Identifies all custom endpoints associated with the cluster.

                - *(string) --*

              - **MultiAZ** *(boolean) --*

                Specifies whether the DB cluster has instances in multiple Availability Zones.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **Port** *(integer) --*

                Specifies the port that the database engine is listening on.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB cluster.

              - **DBClusterOptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB cluster.

                - *(dict) --*

                  Contains status information for a DB cluster option group.

                  - **DBClusterOptionGroupName** *(string) --*

                    Specifies the name of the DB cluster option group.

                  - **Status** *(string) --*

                    Specifies the status of the DB cluster option group.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **ReplicationSourceIdentifier** *(string) --*

                Contains the identifier of the source DB cluster if this DB cluster is a Read Replica.

              - **ReadReplicaIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB cluster.

                - *(string) --*

              - **DBClusterMembers** *(list) --*

                Provides the list of instances that make up the DB cluster.

                - *(dict) --*

                  Contains information about an instance that is part of a DB cluster.

                  - **DBInstanceIdentifier** *(string) --*

                    Specifies the instance identifier for this member of the DB cluster.

                  - **IsClusterWriter** *(boolean) --*

                    Value that is ``true`` if the cluster member is the primary instance for the DB cluster and ``false`` otherwise.

                  - **DBClusterParameterGroupStatus** *(string) --*

                    Specifies the status of the DB cluster parameter group for this member of the DB cluster.

                  - **PromotionTier** *(integer) --*

                    A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security groups that the DB cluster belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **HostedZoneId** *(string) --*

                Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is enabled, the AWS KMS key identifier for the encrypted DB cluster.

              - **DbClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **DBClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster.

              - **AssociatedRoles** *(list) --*

                Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB cluster and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB cluster.

                    * ``INVALID`` - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other AWS services on your behalf.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see  DBEngineVersion .

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                A value that indicates whether the mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.

              - **CloneGroupId** *(string) --*

                Identifies the clone group to which the DB cluster is associated.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **EarliestBacktrackTime** *(datetime) --*

                The earliest time to which a DB cluster can be backtracked.

              - **BacktrackWindow** *(integer) --*

                The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.

              - **BacktrackConsumedChangeRecords** *(integer) --*

                The number of change records stored for Backtrack.

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB cluster is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html>`__ in the *Amazon Aurora User Guide.*

                - *(string) --*

              - **Capacity** *(integer) --*

                The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.

                For more information about Aurora Serverless, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

              - **EngineMode** *(string) --*

                The DB engine mode of the DB cluster, either ``provisioned`` , ``serverless`` , ``parallelquery`` , ``global`` , or ``multimaster`` .

              - **ScalingConfigurationInfo** *(dict) --*

                Shows the scaling configuration for an Aurora DB cluster in ``serverless`` DB engine mode.

                For more information, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

                - **MinCapacity** *(integer) --*

                  The maximum capacity for the Aurora DB cluster in ``serverless`` DB engine mode.

                - **MaxCapacity** *(integer) --*

                  The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

                - **AutoPause** *(boolean) --*

                  A value that indicates whether automatic pause is allowed for the Aurora DB cluster in ``serverless`` DB engine mode.

                  When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.

                - **SecondsUntilAutoPause** *(integer) --*

                  The remaining amount of time, in seconds, before the Aurora DB cluster in ``serverless`` mode is paused. A DB cluster can be paused only when it's idle (it has no connections).

                - **TimeoutAction** *(string) --*

                  The timeout action of a call to ``ModifyCurrentDBClusterCapacity`` , either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.

              - **HttpEndpointEnabled** *(boolean) --*

                A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.

                When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

                For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

              - **ActivityStreamMode** *(string) --*

                The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.

              - **ActivityStreamStatus** *(string) --*

                The status of the database activity stream.

              - **ActivityStreamKmsKeyId** *(string) --*

                The AWS KMS key identifier used for encrypting messages in the database activity stream.

              - **ActivityStreamKinesisStreamName** *(string) --*

                The name of the Amazon Kinesis data stream used for the database activity stream.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.

              - **CrossAccountClone** *(boolean) --*

                Specifies whether the DB cluster is a clone of a DB cluster owned by a different AWS account.

        """
        pass

    def generate_db_auth_token(
        self,
        DBHostname: str = None,
        Port: int = None,
        DBUsername: str = None,
        Region: str = None
    ) -> None:
        """
        Generates an auth token used to connect to a db with IAM credentials.

        :type DBHostname: str
        :param DBHostname: The hostname of the database to connect to.

        :type Port: int
        :param Port: The port number the database is listening on.

        :type DBUsername: str
        :param DBUsername: The username to log in as.

        :type Region: str
        :param Region: The region the database is in. If None, the client
            region will be used.

        :return: A presigned url which can be used as an auth token.
        """
        pass

    def generate_presigned_url(
        self,
        ClientMethod: str = None,
        Params: Dict[str, Any] = None,
        ExpiresIn: int = None,
        HttpMethod: str = None
    ) -> None:
        """
        Generate a presigned url given a client, its method, and arguments

        :type ClientMethod: string
        :param ClientMethod: The client method to presign for

        :type Params: dict
        :param Params: The parameters normally passed to
            ``ClientMethod``.

        :type ExpiresIn: int
        :param ExpiresIn: The number of seconds the presigned url is valid
            for. By default it expires in an hour (3600 seconds)

        :type HttpMethod: string
        :param HttpMethod: The http method to use on the generated url. By
            default, the http method is whatever is used in the method's model.

        :returns: The presigned url
        """
        pass

    def get_paginator(
        self,
        operation_name: str = None
    ) -> Paginator:
        """
        Create a paginator for an operation.

        :type operation_name: string
        :param operation_name: The operation name.  This is the same name
            as the method name on the client.  For example, if the
            method name is ``create_foo``, and you'd normally invoke the
            operation as ``client.create_foo(**kwargs)``, if the
            ``create_foo`` operation can be paginated, you can use the
            call ``client.get_paginator("create_foo")``.

        :raise OperationNotPageableError: Raised if the operation is not
            pageable.  You can use the ``client.can_paginate`` method to
            check if an operation is pageable.

        :rtype: L{botocore.paginate.Paginator}
        :return: A paginator object.
        """
        pass

    def get_waiter(
        self,
        waiter_name: str = None
    ) -> Waiter:
        """
        Returns an object that can wait for some condition.

        :type waiter_name: str
        :param waiter_name: The name of the waiter to get. See the waiters
            section of the service docs for a list of available waiters.

        :returns: The specified waiter object.
        :rtype: botocore.waiter.Waiter
        """
        pass

    def import_installation_media(
        self,
        CustomAvailabilityZoneId: str,
        Engine: str,
        EngineVersion: str,
        EngineInstallationMediaPath: str,
        OSInstallationMediaPath: str
    ) -> Dict[str, Any]:
        """
        Imports the installation media for a DB engine that requires an on-premises customer provided license, such as SQL Server.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ImportInstallationMedia>`_

        **Request Syntax**
        ::

          response = client.import_installation_media(
              CustomAvailabilityZoneId='string',
              Engine='string',
              EngineVersion='string',
              EngineInstallationMediaPath='string',
              OSInstallationMediaPath='string'
          )
        :type CustomAvailabilityZoneId: string
        :param CustomAvailabilityZoneId: **[REQUIRED]**

          The identifier of the custom Availability Zone (AZ) to import the installation media to.

        :type Engine: string
        :param Engine: **[REQUIRED]**

          The name of the database engine to be used for this instance.

          The list only includes supported DB engines that require an on-premises customer provided license.

          Valid Values:

          * ``sqlserver-ee``

          * ``sqlserver-se``

          * ``sqlserver-ex``

          * ``sqlserver-web``

        :type EngineVersion: string
        :param EngineVersion: **[REQUIRED]**

          The version number of the database engine to use.

          For a list of valid engine versions, call  DescribeDBEngineVersions .

          The following are the database engines and links to information about the major and minor versions. The list only includes DB engines that require an on-premises customer provided license.

           **Microsoft SQL Server**

          See `Version and Feature Support on Amazon RDS <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport>`__ in the *Amazon RDS User Guide.*

        :type EngineInstallationMediaPath: string
        :param EngineInstallationMediaPath: **[REQUIRED]**

          The path to the installation medium for the specified DB engine.

          Example: ``SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso``

        :type OSInstallationMediaPath: string
        :param OSInstallationMediaPath: **[REQUIRED]**

          The path to the installation medium for the operating system associated with the specified DB engine.

          Example: ``WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso``

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'InstallationMediaId': 'string',
                'CustomAvailabilityZoneId': 'string',
                'Engine': 'string',
                'EngineVersion': 'string',
                'EngineInstallationMediaPath': 'string',
                'OSInstallationMediaPath': 'string',
                'Status': 'string',
                'FailureCause': {
                    'Message': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            Contains the installation media for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.

            - **InstallationMediaId** *(string) --*

              The installation medium ID.

            - **CustomAvailabilityZoneId** *(string) --*

              The custom Availability Zone (AZ) that contains the installation media.

            - **Engine** *(string) --*

              The DB engine.

            - **EngineVersion** *(string) --*

              The engine version of the DB engine.

            - **EngineInstallationMediaPath** *(string) --*

              The path to the installation medium for the DB engine.

            - **OSInstallationMediaPath** *(string) --*

              The path to the installation medium for the operating system associated with the DB engine.

            - **Status** *(string) --*

              The status of the installation medium.

            - **FailureCause** *(dict) --*

              If an installation media failure occurred, the cause of the failure.

              - **Message** *(string) --*

                The reason that an installation media import failed.

        """
        pass

    def list_tags_for_resource(
        self,
        ResourceName: str,
        Filters: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Lists all tags on an Amazon RDS resource.

        For an overview on tagging an Amazon RDS resource, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html>`__ in the *Amazon RDS User Guide* .

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource>`_

        **Request Syntax**
        ::

          response = client.list_tags_for_resource(
              ResourceName='string',
              Filters=[
                  {
                      'Name': 'string',
                      'Values': [
                          'string',
                      ]
                  },
              ]
          )
        :type ResourceName: string
        :param ResourceName: **[REQUIRED]**

          The Amazon RDS resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see `Constructing an ARN for Amazon RDS <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing>`__ in the *Amazon RDS User Guide* .

        :type Filters: list
        :param Filters:

          This parameter isn't currently supported.

          - *(dict) --*

            A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.

            .. note::

              Currently, wildcards are not supported in filters.

            The following actions can be filtered:

            * ``DescribeDBClusterBacktracks``

            * ``DescribeDBClusterEndpoints``

            * ``DescribeDBClusters``

            * ``DescribeDBInstances``

            * ``DescribePendingMaintenanceActions``

            - **Name** *(string) --* **[REQUIRED]**

              The name of the filter. Filter names are case-sensitive.

            - **Values** *(list) --* **[REQUIRED]**

              One or more filter values. Filter values are case-sensitive.

              - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'TagList': [
                    {
                        'Key': 'string',
                        'Value': 'string'
                    },
                ]
            }
          **Response Structure**

          - *(dict) --*

            - **TagList** *(list) --*

              List of tags returned by the ListTagsForResource operation.

              - *(dict) --*

                Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

                - **Key** *(string) --*

                  A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

                - **Value** *(string) --*

                  A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        """
        pass

    def modify_current_db_cluster_capacity(
        self,
        DBClusterIdentifier: str,
        Capacity: int = None,
        SecondsBeforeTimeout: int = None,
        TimeoutAction: str = None
    ) -> Dict[str, Any]:
        """
        Set the capacity of an Aurora Serverless DB cluster to a specific value.

        Aurora Serverless scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might not scale fast enough to meet a sudden change in workload, such as a large number of new transactions. Call ``ModifyCurrentDBClusterCapacity`` to set the capacity explicitly.

        After this call sets the DB cluster capacity, Aurora Serverless can automatically scale the DB cluster based on the cooldown period for scaling up and the cooldown period for scaling down.

        For more information about Aurora Serverless, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

        .. warning::

          If you call ``ModifyCurrentDBClusterCapacity`` with the default ``TimeoutAction`` , connections that prevent Aurora Serverless from finding a scaling point might be dropped. For more information about scaling points, see `Autoscaling for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling>`__ in the *Amazon Aurora User Guide* .

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity>`_

        **Request Syntax**
        ::

          response = client.modify_current_db_cluster_capacity(
              DBClusterIdentifier='string',
              Capacity=123,
              SecondsBeforeTimeout=123,
              TimeoutAction='string'
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.

          Constraints:

          * Must match the identifier of an existing DB cluster.

        :type Capacity: integer
        :param Capacity:

          The DB cluster capacity.

          When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.

          Constraints:

          * Value must be ``1`` , ``2`` , ``4`` , ``8`` , ``16`` , ``32`` , ``64`` , ``128`` , or ``256`` .

        :type SecondsBeforeTimeout: integer
        :param SecondsBeforeTimeout:

          The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.

          * Value must be from 10 through 600.

        :type TimeoutAction: string
        :param TimeoutAction:

          The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

           ``ForceApplyCapacityChange`` , the default, sets the capacity to the specified value as soon as possible.

           ``RollbackCapacityChange`` ignores the capacity change if a scaling point isn't found in the timeout period.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterIdentifier': 'string',
                'PendingCapacity': 123,
                'CurrentCapacity': 123,
                'SecondsBeforeTimeout': 123,
                'TimeoutAction': 'string'
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterIdentifier** *(string) --*

              A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

            - **PendingCapacity** *(integer) --*

              A value that specifies the capacity that the DB cluster scales to next.

            - **CurrentCapacity** *(integer) --*

              The current capacity of the DB cluster.

            - **SecondsBeforeTimeout** *(integer) --*

              The number of seconds before a call to ``ModifyCurrentDBClusterCapacity`` times out.

            - **TimeoutAction** *(string) --*

              The timeout action of a call to ``ModifyCurrentDBClusterCapacity`` , either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

        """
        pass

    def modify_db_cluster(
        self,
        DBClusterIdentifier: str,
        NewDBClusterIdentifier: str = None,
        ApplyImmediately: bool = None,
        BackupRetentionPeriod: int = None,
        DBClusterParameterGroupName: str = None,
        VpcSecurityGroupIds: List[Any] = None,
        Port: int = None,
        MasterUserPassword: str = None,
        OptionGroupName: str = None,
        PreferredBackupWindow: str = None,
        PreferredMaintenanceWindow: str = None,
        EnableIAMDatabaseAuthentication: bool = None,
        BacktrackWindow: int = None,
        CloudwatchLogsExportConfiguration: Dict[str, Any] = None,
        EngineVersion: str = None,
        AllowMajorVersionUpgrade: bool = None,
        DBInstanceParameterGroupName: str = None,
        ScalingConfiguration: Dict[str, Any] = None,
        DeletionProtection: bool = None,
        EnableHttpEndpoint: bool = None,
        CopyTagsToSnapshot: bool = None
    ) -> Dict[str, Any]:
        """
        Modify a setting for an Amazon Aurora DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster>`_

        **Request Syntax**
        ::

          response = client.modify_db_cluster(
              DBClusterIdentifier='string',
              NewDBClusterIdentifier='string',
              ApplyImmediately=True|False,
              BackupRetentionPeriod=123,
              DBClusterParameterGroupName='string',
              VpcSecurityGroupIds=[
                  'string',
              ],
              Port=123,
              MasterUserPassword='string',
              OptionGroupName='string',
              PreferredBackupWindow='string',
              PreferredMaintenanceWindow='string',
              EnableIAMDatabaseAuthentication=True|False,
              BacktrackWindow=123,
              CloudwatchLogsExportConfiguration={
                  'EnableLogTypes': [
                      'string',
                  ],
                  'DisableLogTypes': [
                      'string',
                  ]
              },
              EngineVersion='string',
              AllowMajorVersionUpgrade=True|False,
              DBInstanceParameterGroupName='string',
              ScalingConfiguration={
                  'MinCapacity': 123,
                  'MaxCapacity': 123,
                  'AutoPause': True|False,
                  'SecondsUntilAutoPause': 123,
                  'TimeoutAction': 'string'
              },
              DeletionProtection=True|False,
              EnableHttpEndpoint=True|False,
              CopyTagsToSnapshot=True|False
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.

          Constraints: This identifier must match the identifier of an existing DB cluster.

        :type NewDBClusterIdentifier: string
        :param NewDBClusterIdentifier:

          The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 letters, numbers, or hyphens

          * The first character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``my-cluster2``

        :type ApplyImmediately: boolean
        :param ApplyImmediately:

          A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the ``PreferredMaintenanceWindow`` setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.

          The ``ApplyImmediately`` parameter only affects the ``EnableIAMDatabaseAuthentication`` , ``MasterUserPassword`` , and ``NewDBClusterIdentifier`` values. If the ``ApplyImmediately`` parameter is disabled, then changes to the ``EnableIAMDatabaseAuthentication`` , ``MasterUserPassword`` , and ``NewDBClusterIdentifier`` values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the ``ApplyImmediately`` parameter.

          By default, this parameter is disabled.

        :type BackupRetentionPeriod: integer
        :param BackupRetentionPeriod:

          The number of days for which automated backups are retained. You must specify a minimum value of 1.

          Default: 1

          Constraints:

          * Must be a value from 1 to 35

        :type DBClusterParameterGroupName: string
        :param DBClusterParameterGroupName:

          The name of the DB cluster parameter group to use for the DB cluster.

        :type VpcSecurityGroupIds: list
        :param VpcSecurityGroupIds:

          A list of VPC security groups that the DB cluster will belong to.

          - *(string) --*

        :type Port: integer
        :param Port:

          The port number on which the DB cluster accepts connections.

          Constraints: Value must be ``1150-65535``

          Default: The same port as the original DB cluster.

        :type MasterUserPassword: string
        :param MasterUserPassword:

          The new password for the master database user. This password can contain any printable ASCII character except "/", '"', or "@".

          Constraints: Must contain from 8 to 41 characters.

        :type OptionGroupName: string
        :param OptionGroupName:

          A value that indicates that the DB cluster should be associated with the specified option group. Changing this parameter doesn't result in an outage except in the following case, and the change is applied during the next maintenance window unless the ``ApplyImmediately`` is enabled for this request. If the parameter change results in an option group that enables OEM, this change can cause a brief (sub-second) period during which new connections are rejected but existing connections are not interrupted.

          Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster.

        :type PreferredBackupWindow: string
        :param PreferredBackupWindow:

          The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter.

          The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see `Adjusting the Preferred DB Cluster Maintenance Window <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora>`__ in the *Amazon Aurora User Guide.*

          Constraints:

          * Must be in the format ``hh24:mi-hh24:mi`` .

          * Must be in Universal Coordinated Time (UTC).

          * Must not conflict with the preferred maintenance window.

          * Must be at least 30 minutes.

        :type PreferredMaintenanceWindow: string
        :param PreferredMaintenanceWindow:

          The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

          Format: ``ddd:hh24:mi-ddd:hh24:mi``

          The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see `Adjusting the Preferred DB Cluster Maintenance Window <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora>`__ in the *Amazon Aurora User Guide.*

          Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

          Constraints: Minimum 30-minute window.

        :type EnableIAMDatabaseAuthentication: boolean
        :param EnableIAMDatabaseAuthentication:

          A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.

          For more information, see `IAM Database Authentication <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html>`__ in the *Amazon Aurora User Guide.*

        :type BacktrackWindow: integer
        :param BacktrackWindow:

          The target backtrack window, in seconds. To disable backtracking, set this value to 0.

          Default: 0

          Constraints:

          * If specified, this value must be set to a number from 0 to 259,200 (72 hours).

        :type CloudwatchLogsExportConfiguration: dict
        :param CloudwatchLogsExportConfiguration:

          The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.

          - **EnableLogTypes** *(list) --*

            The list of log types to enable.

            - *(string) --*

          - **DisableLogTypes** *(list) --*

            The list of log types to disable.

            - *(string) --*

        :type EngineVersion: string
        :param EngineVersion:

          The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless ``ApplyImmediately`` is enabled.

          To list all of the available engine versions for ``aurora`` (for MySQL 5.6-compatible Aurora), use the following command:

           ``aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"``

          To list all of the available engine versions for ``aurora-mysql`` (for MySQL 5.7-compatible Aurora), use the following command:

           ``aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"``

          To list all of the available engine versions for ``aurora-postgresql`` , use the following command:

           ``aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"``

        :type AllowMajorVersionUpgrade: boolean
        :param AllowMajorVersionUpgrade:

          A value that indicates whether major version upgrades are allowed.

          Constraints: You must allow major version upgrades when specifying a value for the ``EngineVersion`` parameter that is a different major version than the DB cluster's current version.

        :type DBInstanceParameterGroupName: string
        :param DBInstanceParameterGroupName:

          The name of the DB parameter group to apply to all instances of the DB cluster.

          .. note::

            When you apply a parameter group using the ``DBInstanceParameterGroupName`` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes aren't applied during the next maintenance window but instead are applied immediately.

          Default: The existing name setting

          Constraints:

          * The DB parameter group must be in the same DB parameter group family as this DB cluster.

          * The ``DBInstanceParameterGroupName`` parameter is only valid in combination with the ``AllowMajorVersionUpgrade`` parameter.

        :type ScalingConfiguration: dict
        :param ScalingConfiguration:

          The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in ``serverless`` DB engine mode.

          - **MinCapacity** *(integer) --*

            The minimum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

            Valid capacity values are ``1`` , ``2`` , ``4`` , ``8`` , ``16`` , ``32`` , ``64`` , ``128`` , and ``256`` .

            The minimum capacity must be less than or equal to the maximum capacity.

          - **MaxCapacity** *(integer) --*

            The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

            Valid capacity values are ``1`` , ``2`` , ``4`` , ``8`` , ``16`` , ``32`` , ``64`` , ``128`` , and ``256`` .

            The maximum capacity must be greater than or equal to the minimum capacity.

          - **AutoPause** *(boolean) --*

            A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in ``serverless`` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).

            .. note::

              If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.

          - **SecondsUntilAutoPause** *(integer) --*

            The time, in seconds, before an Aurora DB cluster in ``serverless`` mode is paused.

          - **TimeoutAction** *(string) --*

            The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

             ``ForceApplyCapacityChange`` sets the capacity to the specified value as soon as possible.

             ``RollbackCapacityChange`` , the default, ignores the capacity change if a scaling point isn't found in the timeout period.

            .. warning::

              If you specify ``ForceApplyCapacityChange`` , connections that prevent Aurora Serverless from finding a scaling point might be dropped.

            For more information, see `Autoscaling for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling>`__ in the *Amazon Aurora User Guide* .

        :type DeletionProtection: boolean
        :param DeletionProtection:

          A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.

        :type EnableHttpEndpoint: boolean
        :param EnableHttpEndpoint:

          A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.

          When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

          For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

        :type CopyTagsToSnapshot: boolean
        :param CopyTagsToSnapshot:

          A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBCluster': {
                    'AllocatedStorage': 123,
                    'AvailabilityZones': [
                        'string',
                    ],
                    'BackupRetentionPeriod': 123,
                    'CharacterSetName': 'string',
                    'DatabaseName': 'string',
                    'DBClusterIdentifier': 'string',
                    'DBClusterParameterGroup': 'string',
                    'DBSubnetGroup': 'string',
                    'Status': 'string',
                    'PercentProgress': 'string',
                    'EarliestRestorableTime': datetime(2015, 1, 1),
                    'Endpoint': 'string',
                    'ReaderEndpoint': 'string',
                    'CustomEndpoints': [
                        'string',
                    ],
                    'MultiAZ': True|False,
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'Port': 123,
                    'MasterUsername': 'string',
                    'DBClusterOptionGroupMemberships': [
                        {
                            'DBClusterOptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'PreferredBackupWindow': 'string',
                    'PreferredMaintenanceWindow': 'string',
                    'ReplicationSourceIdentifier': 'string',
                    'ReadReplicaIdentifiers': [
                        'string',
                    ],
                    'DBClusterMembers': [
                        {
                            'DBInstanceIdentifier': 'string',
                            'IsClusterWriter': True|False,
                            'DBClusterParameterGroupStatus': 'string',
                            'PromotionTier': 123
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'HostedZoneId': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbClusterResourceId': 'string',
                    'DBClusterArn': 'string',
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'Status': 'string',
                            'FeatureName': 'string'
                        },
                    ],
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'CloneGroupId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'EarliestBacktrackTime': datetime(2015, 1, 1),
                    'BacktrackWindow': 123,
                    'BacktrackConsumedChangeRecords': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'Capacity': 123,
                    'EngineMode': 'string',
                    'ScalingConfigurationInfo': {
                        'MinCapacity': 123,
                        'MaxCapacity': 123,
                        'AutoPause': True|False,
                        'SecondsUntilAutoPause': 123,
                        'TimeoutAction': 'string'
                    },
                    'DeletionProtection': True|False,
                    'HttpEndpointEnabled': True|False,
                    'ActivityStreamMode': 'sync'|'async',
                    'ActivityStreamStatus': 'stopped'|'starting'|'started'|'stopping',
                    'ActivityStreamKmsKeyId': 'string',
                    'ActivityStreamKinesisStreamName': 'string',
                    'CopyTagsToSnapshot': True|False,
                    'CrossAccountClone': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBCluster** *(dict) --*

              Contains the details of an Amazon Aurora DB cluster.

              This data type is used as a response element in the ``DescribeDBClusters`` , ``StopDBCluster`` , and ``StartDBCluster`` actions.

              - **AllocatedStorage** *(integer) --*

                For all database engines except Amazon Aurora, ``AllocatedStorage`` specifies the allocated storage size in gibibytes (GiB). For Aurora, ``AllocatedStorage`` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.

                - *(string) --*

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this cluster is associated with.

              - **DatabaseName** *(string) --*

                Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.

              - **DBClusterIdentifier** *(string) --*

                Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

              - **DBClusterParameterGroup** *(string) --*

                Specifies the name of the DB cluster parameter group for the DB cluster.

              - **DBSubnetGroup** *(string) --*

                Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.

              - **Status** *(string) --*

                Specifies the current state of this DB cluster.

              - **PercentProgress** *(string) --*

                Specifies the progress of the operation as a percentage.

              - **EarliestRestorableTime** *(datetime) --*

                The earliest time to which a database can be restored with point-in-time restore.

              - **Endpoint** *(string) --*

                Specifies the connection endpoint for the primary instance of the DB cluster.

              - **ReaderEndpoint** *(string) --*

                The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.

                If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.

              - **CustomEndpoints** *(list) --*

                Identifies all custom endpoints associated with the cluster.

                - *(string) --*

              - **MultiAZ** *(boolean) --*

                Specifies whether the DB cluster has instances in multiple Availability Zones.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **Port** *(integer) --*

                Specifies the port that the database engine is listening on.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB cluster.

              - **DBClusterOptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB cluster.

                - *(dict) --*

                  Contains status information for a DB cluster option group.

                  - **DBClusterOptionGroupName** *(string) --*

                    Specifies the name of the DB cluster option group.

                  - **Status** *(string) --*

                    Specifies the status of the DB cluster option group.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **ReplicationSourceIdentifier** *(string) --*

                Contains the identifier of the source DB cluster if this DB cluster is a Read Replica.

              - **ReadReplicaIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB cluster.

                - *(string) --*

              - **DBClusterMembers** *(list) --*

                Provides the list of instances that make up the DB cluster.

                - *(dict) --*

                  Contains information about an instance that is part of a DB cluster.

                  - **DBInstanceIdentifier** *(string) --*

                    Specifies the instance identifier for this member of the DB cluster.

                  - **IsClusterWriter** *(boolean) --*

                    Value that is ``true`` if the cluster member is the primary instance for the DB cluster and ``false`` otherwise.

                  - **DBClusterParameterGroupStatus** *(string) --*

                    Specifies the status of the DB cluster parameter group for this member of the DB cluster.

                  - **PromotionTier** *(integer) --*

                    A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security groups that the DB cluster belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **HostedZoneId** *(string) --*

                Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is enabled, the AWS KMS key identifier for the encrypted DB cluster.

              - **DbClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **DBClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster.

              - **AssociatedRoles** *(list) --*

                Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB cluster and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB cluster.

                    * ``INVALID`` - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other AWS services on your behalf.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see  DBEngineVersion .

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                A value that indicates whether the mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.

              - **CloneGroupId** *(string) --*

                Identifies the clone group to which the DB cluster is associated.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **EarliestBacktrackTime** *(datetime) --*

                The earliest time to which a DB cluster can be backtracked.

              - **BacktrackWindow** *(integer) --*

                The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.

              - **BacktrackConsumedChangeRecords** *(integer) --*

                The number of change records stored for Backtrack.

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB cluster is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html>`__ in the *Amazon Aurora User Guide.*

                - *(string) --*

              - **Capacity** *(integer) --*

                The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.

                For more information about Aurora Serverless, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

              - **EngineMode** *(string) --*

                The DB engine mode of the DB cluster, either ``provisioned`` , ``serverless`` , ``parallelquery`` , ``global`` , or ``multimaster`` .

              - **ScalingConfigurationInfo** *(dict) --*

                Shows the scaling configuration for an Aurora DB cluster in ``serverless`` DB engine mode.

                For more information, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

                - **MinCapacity** *(integer) --*

                  The maximum capacity for the Aurora DB cluster in ``serverless`` DB engine mode.

                - **MaxCapacity** *(integer) --*

                  The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

                - **AutoPause** *(boolean) --*

                  A value that indicates whether automatic pause is allowed for the Aurora DB cluster in ``serverless`` DB engine mode.

                  When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.

                - **SecondsUntilAutoPause** *(integer) --*

                  The remaining amount of time, in seconds, before the Aurora DB cluster in ``serverless`` mode is paused. A DB cluster can be paused only when it's idle (it has no connections).

                - **TimeoutAction** *(string) --*

                  The timeout action of a call to ``ModifyCurrentDBClusterCapacity`` , either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.

              - **HttpEndpointEnabled** *(boolean) --*

                A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.

                When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

                For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

              - **ActivityStreamMode** *(string) --*

                The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.

              - **ActivityStreamStatus** *(string) --*

                The status of the database activity stream.

              - **ActivityStreamKmsKeyId** *(string) --*

                The AWS KMS key identifier used for encrypting messages in the database activity stream.

              - **ActivityStreamKinesisStreamName** *(string) --*

                The name of the Amazon Kinesis data stream used for the database activity stream.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.

              - **CrossAccountClone** *(boolean) --*

                Specifies whether the DB cluster is a clone of a DB cluster owned by a different AWS account.

        """
        pass

    def modify_db_cluster_endpoint(
        self,
        DBClusterEndpointIdentifier: str,
        EndpointType: str = None,
        StaticMembers: List[Any] = None,
        ExcludedMembers: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Modifies the properties of an endpoint in an Amazon Aurora DB cluster.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint>`_

        **Request Syntax**
        ::

          response = client.modify_db_cluster_endpoint(
              DBClusterEndpointIdentifier='string',
              EndpointType='string',
              StaticMembers=[
                  'string',
              ],
              ExcludedMembers=[
                  'string',
              ]
          )
        :type DBClusterEndpointIdentifier: string
        :param DBClusterEndpointIdentifier: **[REQUIRED]**

          The identifier of the endpoint to modify. This parameter is stored as a lowercase string.

        :type EndpointType: string
        :param EndpointType:

          The type of the endpoint. One of: ``READER`` , ``WRITER`` , ``ANY`` .

        :type StaticMembers: list
        :param StaticMembers:

          List of DB instance identifiers that are part of the custom endpoint group.

          - *(string) --*

        :type ExcludedMembers: list
        :param ExcludedMembers:

          List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.

          - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterEndpointIdentifier': 'string',
                'DBClusterIdentifier': 'string',
                'DBClusterEndpointResourceIdentifier': 'string',
                'Endpoint': 'string',
                'Status': 'string',
                'EndpointType': 'string',
                'CustomEndpointType': 'string',
                'StaticMembers': [
                    'string',
                ],
                'ExcludedMembers': [
                    'string',
                ],
                'DBClusterEndpointArn': 'string'
            }
          **Response Structure**

          - *(dict) --*

            This data type represents the information you need to connect to an Amazon Aurora DB cluster. This data type is used as a response element in the following actions:

            * ``CreateDBClusterEndpoint``

            * ``DescribeDBClusterEndpoints``

            * ``ModifyDBClusterEndpoint``

            * ``DeleteDBClusterEndpoint``

            For the data structure that represents Amazon RDS DB instance endpoints, see ``Endpoint`` .

            - **DBClusterEndpointIdentifier** *(string) --*

              The identifier associated with the endpoint. This parameter is stored as a lowercase string.

            - **DBClusterIdentifier** *(string) --*

              The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.

            - **DBClusterEndpointResourceIdentifier** *(string) --*

              A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.

            - **Endpoint** *(string) --*

              The DNS address of the endpoint.

            - **Status** *(string) --*

              The current status of the endpoint. One of: ``creating`` , ``available`` , ``deleting`` , ``modifying`` .

            - **EndpointType** *(string) --*

              The type of the endpoint. One of: ``READER`` , ``WRITER`` , ``CUSTOM`` .

            - **CustomEndpointType** *(string) --*

              The type associated with a custom endpoint. One of: ``READER`` , ``WRITER`` , ``ANY`` .

            - **StaticMembers** *(list) --*

              List of DB instance identifiers that are part of the custom endpoint group.

              - *(string) --*

            - **ExcludedMembers** *(list) --*

              List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.

              - *(string) --*

            - **DBClusterEndpointArn** *(string) --*

              The Amazon Resource Name (ARN) for the endpoint.

        """
        pass

    def modify_db_cluster_parameter_group(
        self,
        DBClusterParameterGroupName: str,
        Parameters: List[Any]
    ) -> Dict[str, Any]:
        """
        Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: ``ParameterName`` , ``ParameterValue`` , and ``ApplyMethod`` . A maximum of 20 parameters can be modified in a single request.

        For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB cluster associated with the parameter group before the change can take effect.

        .. warning::

          After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the ``character_set_database`` parameter. You can use the *Parameter Groups* option of the `Amazon RDS console <https://console.aws.amazon.com/rds/>`__ or the ``DescribeDBClusterParameters`` action to verify that your DB cluster parameter group has been created or modified.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup>`_

        **Request Syntax**
        ::

          response = client.modify_db_cluster_parameter_group(
              DBClusterParameterGroupName='string',
              Parameters=[
                  {
                      'ParameterName': 'string',
                      'ParameterValue': 'string',
                      'Description': 'string',
                      'Source': 'string',
                      'ApplyType': 'string',
                      'DataType': 'string',
                      'AllowedValues': 'string',
                      'IsModifiable': True|False,
                      'MinimumEngineVersion': 'string',
                      'ApplyMethod': 'immediate'|'pending-reboot',
                      'SupportedEngineModes': [
                          'string',
                      ]
                  },
              ]
          )
        :type DBClusterParameterGroupName: string
        :param DBClusterParameterGroupName: **[REQUIRED]**

          The name of the DB cluster parameter group to modify.

        :type Parameters: list
        :param Parameters: **[REQUIRED]**

          A list of parameters in the DB cluster parameter group to modify.

          - *(dict) --*

            This data type is used as a request parameter in the ``ModifyDBParameterGroup`` and ``ResetDBParameterGroup`` actions.

            This data type is used as a response element in the ``DescribeEngineDefaultParameters`` and ``DescribeDBParameters`` actions.

            - **ParameterName** *(string) --*

              Specifies the name of the parameter.

            - **ParameterValue** *(string) --*

              Specifies the value of the parameter.

            - **Description** *(string) --*

              Provides a description of the parameter.

            - **Source** *(string) --*

              Indicates the source of the parameter value.

            - **ApplyType** *(string) --*

              Specifies the engine specific parameters type.

            - **DataType** *(string) --*

              Specifies the valid data type for the parameter.

            - **AllowedValues** *(string) --*

              Specifies the valid range of values for the parameter.

            - **IsModifiable** *(boolean) --*

              Indicates whether (``true`` ) or not (``false`` ) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.

            - **MinimumEngineVersion** *(string) --*

              The earliest engine version to which the parameter can apply.

            - **ApplyMethod** *(string) --*

              Indicates when to apply parameter updates.

            - **SupportedEngineModes** *(list) --*

              The valid DB engine modes.

              - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterParameterGroupName': 'string'
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterParameterGroupName** *(string) --*

              The name of the DB cluster parameter group.

              Constraints:

              * Must be 1 to 255 letters or numbers.

              * First character must be a letter

              * Can't end with a hyphen or contain two consecutive hyphens

              .. note::

                This value is stored as a lowercase string.

        """
        pass

    def modify_db_cluster_snapshot_attribute(
        self,
        DBClusterSnapshotIdentifier: str,
        AttributeName: str,
        ValuesToAdd: List[Any] = None,
        ValuesToRemove: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.

        To share a manual DB cluster snapshot with other AWS accounts, specify ``restore`` as the ``AttributeName`` and use the ``ValuesToAdd`` parameter to add a list of IDs of the AWS accounts that are authorized to restore the manual DB cluster snapshot. Use the value ``all`` to make the manual DB cluster snapshot public, which means that it can be copied or restored by all AWS accounts. Do not add the ``all`` value for any manual DB cluster snapshots that contain private information that you don't want available to all AWS accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized AWS account IDs for the ``ValuesToAdd`` parameter. You can't use ``all`` as a value for that parameter in this case.

        To view which AWS accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot public or private, use the ``DescribeDBClusterSnapshotAttributes`` API action.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute>`_

        **Request Syntax**
        ::

          response = client.modify_db_cluster_snapshot_attribute(
              DBClusterSnapshotIdentifier='string',
              AttributeName='string',
              ValuesToAdd=[
                  'string',
              ],
              ValuesToRemove=[
                  'string',
              ]
          )
        :type DBClusterSnapshotIdentifier: string
        :param DBClusterSnapshotIdentifier: **[REQUIRED]**

          The identifier for the DB cluster snapshot to modify the attributes for.

        :type AttributeName: string
        :param AttributeName: **[REQUIRED]**

          The name of the DB cluster snapshot attribute to modify.

          To manage authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this value to ``restore`` .

        :type ValuesToAdd: list
        :param ValuesToAdd:

          A list of DB cluster snapshot attributes to add to the attribute specified by ``AttributeName`` .

          To authorize other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more AWS account IDs, or ``all`` to make the manual DB cluster snapshot restorable by any AWS account. Do not add the ``all`` value for any manual DB cluster snapshots that contain private information that you don't want available to all AWS accounts.

          - *(string) --*

        :type ValuesToRemove: list
        :param ValuesToRemove:

          A list of DB cluster snapshot attributes to remove from the attribute specified by ``AttributeName`` .

          To remove authorization for other AWS accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more AWS account identifiers, or ``all`` to remove authorization for any AWS account to copy or restore the DB cluster snapshot. If you specify ``all`` , an AWS account whose account ID is explicitly added to the ``restore`` attribute can still copy or restore a manual DB cluster snapshot.

          - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBClusterSnapshotAttributesResult': {
                    'DBClusterSnapshotIdentifier': 'string',
                    'DBClusterSnapshotAttributes': [
                        {
                            'AttributeName': 'string',
                            'AttributeValues': [
                                'string',
                            ]
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBClusterSnapshotAttributesResult** *(dict) --*

              Contains the results of a successful call to the ``DescribeDBClusterSnapshotAttributes`` API action.

              Manual DB cluster snapshot attributes are used to authorize other AWS accounts to copy or restore a manual DB cluster snapshot. For more information, see the ``ModifyDBClusterSnapshotAttribute`` API action.

              - **DBClusterSnapshotIdentifier** *(string) --*

                The identifier of the manual DB cluster snapshot that the attributes apply to.

              - **DBClusterSnapshotAttributes** *(list) --*

                The list of attributes and values for the manual DB cluster snapshot.

                - *(dict) --*

                  Contains the name and values of a manual DB cluster snapshot attribute.

                  Manual DB cluster snapshot attributes are used to authorize other AWS accounts to restore a manual DB cluster snapshot. For more information, see the ``ModifyDBClusterSnapshotAttribute`` API action.

                  - **AttributeName** *(string) --*

                    The name of the manual DB cluster snapshot attribute.

                    The attribute named ``restore`` refers to the list of AWS accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the ``ModifyDBClusterSnapshotAttribute`` API action.

                  - **AttributeValues** *(list) --*

                    The value(s) for the manual DB cluster snapshot attribute.

                    If the ``AttributeName`` field is set to ``restore`` , then this element returns a list of IDs of the AWS accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of ``all`` is in the list, then the manual DB cluster snapshot is public and available for any AWS account to copy or restore.

                    - *(string) --*

        """
        pass

    def modify_db_instance(
        self,
        DBInstanceIdentifier: str,
        AllocatedStorage: int = None,
        DBInstanceClass: str = None,
        DBSubnetGroupName: str = None,
        DBSecurityGroups: List[Any] = None,
        VpcSecurityGroupIds: List[Any] = None,
        ApplyImmediately: bool = None,
        MasterUserPassword: str = None,
        DBParameterGroupName: str = None,
        BackupRetentionPeriod: int = None,
        PreferredBackupWindow: str = None,
        PreferredMaintenanceWindow: str = None,
        MultiAZ: bool = None,
        EngineVersion: str = None,
        AllowMajorVersionUpgrade: bool = None,
        AutoMinorVersionUpgrade: bool = None,
        LicenseModel: str = None,
        Iops: int = None,
        OptionGroupName: str = None,
        NewDBInstanceIdentifier: str = None,
        StorageType: str = None,
        TdeCredentialArn: str = None,
        TdeCredentialPassword: str = None,
        CACertificateIdentifier: str = None,
        Domain: str = None,
        CopyTagsToSnapshot: bool = None,
        MonitoringInterval: int = None,
        DBPortNumber: int = None,
        PubliclyAccessible: bool = None,
        MonitoringRoleArn: str = None,
        DomainIAMRoleName: str = None,
        PromotionTier: int = None,
        EnableIAMDatabaseAuthentication: bool = None,
        EnablePerformanceInsights: bool = None,
        PerformanceInsightsKMSKeyId: str = None,
        PerformanceInsightsRetentionPeriod: int = None,
        CloudwatchLogsExportConfiguration: Dict[str, Any] = None,
        ProcessorFeatures: List[Any] = None,
        UseDefaultProcessorFeatures: bool = None,
        DeletionProtection: bool = None,
        MaxAllocatedStorage: int = None
    ) -> Dict[str, Any]:
        """
        Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call ``DescribeValidDBInstanceModifications`` before you call ``ModifyDBInstance`` .

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance>`_

        **Request Syntax**
        ::

          response = client.modify_db_instance(
              DBInstanceIdentifier='string',
              AllocatedStorage=123,
              DBInstanceClass='string',
              DBSubnetGroupName='string',
              DBSecurityGroups=[
                  'string',
              ],
              VpcSecurityGroupIds=[
                  'string',
              ],
              ApplyImmediately=True|False,
              MasterUserPassword='string',
              DBParameterGroupName='string',
              BackupRetentionPeriod=123,
              PreferredBackupWindow='string',
              PreferredMaintenanceWindow='string',
              MultiAZ=True|False,
              EngineVersion='string',
              AllowMajorVersionUpgrade=True|False,
              AutoMinorVersionUpgrade=True|False,
              LicenseModel='string',
              Iops=123,
              OptionGroupName='string',
              NewDBInstanceIdentifier='string',
              StorageType='string',
              TdeCredentialArn='string',
              TdeCredentialPassword='string',
              CACertificateIdentifier='string',
              Domain='string',
              CopyTagsToSnapshot=True|False,
              MonitoringInterval=123,
              DBPortNumber=123,
              PubliclyAccessible=True|False,
              MonitoringRoleArn='string',
              DomainIAMRoleName='string',
              PromotionTier=123,
              EnableIAMDatabaseAuthentication=True|False,
              EnablePerformanceInsights=True|False,
              PerformanceInsightsKMSKeyId='string',
              PerformanceInsightsRetentionPeriod=123,
              CloudwatchLogsExportConfiguration={
                  'EnableLogTypes': [
                      'string',
                  ],
                  'DisableLogTypes': [
                      'string',
                  ]
              },
              ProcessorFeatures=[
                  {
                      'Name': 'string',
                      'Value': 'string'
                  },
              ],
              UseDefaultProcessorFeatures=True|False,
              DeletionProtection=True|False,
              MaxAllocatedStorage=123
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The DB instance identifier. This value is stored as a lowercase string.

          Constraints:

          * Must match the identifier of an existing DBInstance.

        :type AllocatedStorage: integer
        :param AllocatedStorage:

          The new amount of storage (in gibibytes) to allocate for the DB instance.

          For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.

          For the valid values for allocated storage for each engine, see ``CreateDBInstance`` .

        :type DBInstanceClass: string
        :param DBInstanceClass:

          The new compute and memory capacity of the DB instance, for example, ``db.m4.large`` . Not all DB instance classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see `DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html>`__ in the *Amazon RDS User Guide.*

          If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless ``ApplyImmediately`` is enabled for this request.

          Default: Uses existing setting

        :type DBSubnetGroupName: string
        :param DBSubnetGroupName:

          The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC. For more information, see `Updating the VPC for a DB Instance <http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC>`__ in the *Amazon RDS User Guide.*

          Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you enable ``ApplyImmediately`` .

          Constraints: If supplied, must match the name of an existing DBSubnetGroup.

          Example: ``mySubnetGroup``

        :type DBSecurityGroups: list
        :param DBSecurityGroups:

          A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.

          Constraints:

          * If supplied, must match existing DBSecurityGroups.

          - *(string) --*

        :type VpcSecurityGroupIds: list
        :param VpcSecurityGroupIds:

          A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.

           **Amazon Aurora**

          Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see ``ModifyDBCluster`` .

          Constraints:

          * If supplied, must match existing VpcSecurityGroupIds.

          - *(string) --*

        :type ApplyImmediately: boolean
        :param ApplyImmediately:

          A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the ``PreferredMaintenanceWindow`` setting for the DB instance. By default, this parameter is disabled.

          If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to  RebootDBInstance , or the next failure reboot. Review the table of parameters in `Modifying a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html>`__ in the *Amazon RDS User Guide.* to see the impact of enabling or disabling ``ApplyImmediately`` for each modified parameter and to determine when the changes are applied.

        :type MasterUserPassword: string
        :param MasterUserPassword:

          The new password for the master user. The password can include any printable ASCII character except "/", '"', or "@".

          Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the ``MasterUserPassword`` element exists in the ``PendingModifiedValues`` element of the operation response.

           **Amazon Aurora**

          Not applicable. The password for the master user is managed by the DB cluster. For more information, see ``ModifyDBCluster`` .

          Default: Uses existing setting

           **MariaDB**

          Constraints: Must contain from 8 to 41 characters.

           **Microsoft SQL Server**

          Constraints: Must contain from 8 to 128 characters.

           **MySQL**

          Constraints: Must contain from 8 to 41 characters.

           **Oracle**

          Constraints: Must contain from 8 to 30 characters.

           **PostgreSQL**

          Constraints: Must contain from 8 to 128 characters.

          .. note::

            Amazon RDS API actions never return the password, so this action provides a way to regain access to a primary instance user if the password is lost. This includes restoring privileges that might have been accidentally revoked.

        :type DBParameterGroupName: string
        :param DBParameterGroupName:

          The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. In this case, the DB instance isn't rebooted automatically and the parameter changes isn't applied during the next maintenance window.

          Default: Uses existing setting

          Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.

        :type BackupRetentionPeriod: integer
        :param BackupRetentionPeriod:

          The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.

          Changing this parameter can result in an outage if you change from 0 to a non-zero value or from a non-zero value to 0. These changes are applied during the next maintenance window unless the ``ApplyImmediately`` parameter is enabled for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously applied as soon as possible.

           **Amazon Aurora**

          Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see ``ModifyDBCluster`` .

          Default: Uses existing setting

          Constraints:

          * Must be a value from 0 to 35

          * Can be specified for a MySQL Read Replica only if the source is running MySQL 5.6 or later

          * Can be specified for a PostgreSQL Read Replica only if the source is running PostgreSQL 9.3.5

          * Can't be set to 0 if the DB instance is a source to Read Replicas

        :type PreferredBackupWindow: string
        :param PreferredBackupWindow:

          The daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` parameter. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.

           **Amazon Aurora**

          Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see ``ModifyDBCluster`` .

          Constraints:

          * Must be in the format hh24:mi-hh24:mi

          * Must be in Universal Time Coordinated (UTC)

          * Must not conflict with the preferred maintenance window

          * Must be at least 30 minutes

        :type PreferredMaintenanceWindow: string
        :param PreferredMaintenanceWindow:

          The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.

          Default: Uses existing setting

          Format: ddd:hh24:mi-ddd:hh24:mi

          Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun

          Constraints: Must be at least 30 minutes

        :type MultiAZ: boolean
        :param MultiAZ:

          A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the ``ApplyImmediately`` parameter is enabled for this request.

        :type EngineVersion: string
        :param EngineVersion:

          The version number of the database engine to upgrade to. Changing this parameter results in an outage and the change is applied during the next maintenance window unless the ``ApplyImmediately`` parameter is eanbled for this request.

          For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group in the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the default for that DB parameter group family.

          For information about valid engine versions, see ``CreateDBInstance`` , or call ``DescribeDBEngineVersions`` .

        :type AllowMajorVersionUpgrade: boolean
        :param AllowMajorVersionUpgrade:

          A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.

          Constraints: Major version upgrades must be allowed when specifying a value for the EngineVersion parameter that is a different major version than the DB instance's current version.

        :type AutoMinorVersionUpgrade: boolean
        :param AutoMinorVersionUpgrade:

          A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage results if this parameter is enabled during the maintenance window, and a newer minor version is available, and RDS has enabled auto patching for that engine version.

        :type LicenseModel: string
        :param LicenseModel:

          The license model for the DB instance.

          Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

        :type Iops: integer
        :param Iops:

          The new Provisioned IOPS (I/O operations per second) value for the RDS instance.

          Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the ``ApplyImmediately`` parameter is enabled for this request. If you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change in storage type to take effect.

          If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a Read Replica for the instance, and creating a DB snapshot of the instance.

          Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.

          Default: Uses existing setting

        :type OptionGroupName: string
        :param OptionGroupName:

          Indicates that the DB instance should be associated with the specified option group. Changing this parameter doesn't result in an outage except in the following case and the change is applied during the next maintenance window unless the ``ApplyImmediately`` parameter is enabled for this request. If the parameter change results in an option group that enables OEM, this change can cause a brief (sub-second) period during which new connections are rejected but existing connections are not interrupted.

          Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance

        :type NewDBInstanceIdentifier: string
        :param NewDBInstanceIdentifier:

          The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot occurs immediately if you enable ``ApplyImmediately`` , or will occur during the next maintenance window if you disable Apply Immediately. This value is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 letters, numbers, or hyphens.

          * The first character must be a letter.

          * Can't end with a hyphen or contain two consecutive hyphens.

          Example: ``mydbinstance``

        :type StorageType: string
        :param StorageType:

          Specifies the storage type to be associated with the DB instance.

          If you specify Provisioned IOPS (``io1`` ), you must also include a value for the ``Iops`` parameter.

          If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a Read Replica for the instance, and creating a DB snapshot of the instance.

          Valid values: ``standard | gp2 | io1``

          Default: ``io1`` if the ``Iops`` parameter is specified, otherwise ``gp2``

        :type TdeCredentialArn: string
        :param TdeCredentialArn:

          The ARN from the key store with which to associate the instance for TDE encryption.

        :type TdeCredentialPassword: string
        :param TdeCredentialPassword:

          The password for the given ARN from the key store in order to access the device.

        :type CACertificateIdentifier: string
        :param CACertificateIdentifier:

          Indicates the certificate that needs to be associated with the instance.

        :type Domain: string
        :param Domain:

          The Active Directory directory ID to move the DB instance to. Specify ``none`` to remove the instance from its current domain. The domain must be created prior to this operation. Currently, only Microsoft SQL Server and Oracle DB instances can be created in an Active Directory Domain.

          For Microsoft SQL Server DB instances, Amazon RDS can use Windows Authentication to authenticate users that connect to the DB instance. For more information, see `Using Windows Authentication with an Amazon RDS DB Instance Running Microsoft SQL Server <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_SQLServerWinAuth.html>`__ in the *Amazon RDS User Guide* .

          For Oracle DB instances, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB instance. For more information, see `Using Kerberos Authentication with Amazon RDS for Oracle <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-kerberos.html>`__ in the *Amazon RDS User Guide* .

        :type CopyTagsToSnapshot: boolean
        :param CopyTagsToSnapshot:

          A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.

           **Amazon Aurora**

          Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see ``ModifyDBCluster`` .

        :type MonitoringInterval: integer
        :param MonitoringInterval:

          The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.

          If ``MonitoringRoleArn`` is specified, then you must also set ``MonitoringInterval`` to a value other than 0.

          Valid Values: ``0, 1, 5, 10, 15, 30, 60``

        :type DBPortNumber: integer
        :param DBPortNumber:

          The port number on which the database accepts connections.

          The value of the ``DBPortNumber`` parameter must not match any of the port values specified for options in the option group for the DB instance.

          Your database will restart when you change the ``DBPortNumber`` value regardless of the value of the ``ApplyImmediately`` parameter.

           **MySQL**

          Default: ``3306``

          Valid Values: ``1150-65535``

           **MariaDB**

          Default: ``3306``

          Valid Values: ``1150-65535``

           **PostgreSQL**

          Default: ``5432``

          Valid Values: ``1150-65535``

          Type: Integer

           **Oracle**

          Default: ``1521``

          Valid Values: ``1150-65535``

           **SQL Server**

          Default: ``1433``

          Valid Values: ``1150-65535`` except for ``1434`` , ``3389`` , ``47001`` , ``49152`` , and ``49152`` through ``49156`` .

           **Amazon Aurora**

          Default: ``3306``

          Valid Values: ``1150-65535``

        :type PubliclyAccessible: boolean
        :param PubliclyAccessible:

          A value that indicates whether the DB instance is publicly accessible. When the DB instance is publicly accessible, it is an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. When the DB instance isn't publicly accessible, it is an internal instance with a DNS name that resolves to a private IP address.

           ``PubliclyAccessible`` only applies to DB instances in a VPC. The DB instance must be part of a public subnet and ``PubliclyAccessible`` must be enabled for it to be publicly accessible.

          Changes to the ``PubliclyAccessible`` parameter are applied immediately regardless of the value of the ``ApplyImmediately`` parameter.

        :type MonitoringRoleArn: string
        :param MonitoringRoleArn:

          The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess`` . For information on creating a monitoring role, go to `To create an IAM role for Amazon RDS Enhanced Monitoring <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole>`__ in the *Amazon RDS User Guide.*

          If ``MonitoringInterval`` is set to a value other than 0, then you must supply a ``MonitoringRoleArn`` value.

        :type DomainIAMRoleName: string
        :param DomainIAMRoleName:

          The name of the IAM role to use when making API calls to the Directory Service.

        :type PromotionTier: integer
        :param PromotionTier:

          A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

          Default: 1

          Valid Values: 0 - 15

        :type EnableIAMDatabaseAuthentication: boolean
        :param EnableIAMDatabaseAuthentication:

          A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For information about the supported DB engines, see  CreateDBInstance .

          For more information about IAM database authentication, see `IAM Database Authentication for MySQL and PostgreSQL <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html>`__ in the *Amazon RDS User Guide.*

        :type EnablePerformanceInsights: boolean
        :param EnablePerformanceInsights:

          A value that indicates whether to enable Performance Insights for the DB instance.

          For more information, see `Using Amazon Performance Insights <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html>`__ in the *Amazon Relational Database Service User Guide* .

        :type PerformanceInsightsKMSKeyId: string
        :param PerformanceInsightsKMSKeyId:

          The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

          If you do not specify a value for ``PerformanceInsightsKMSKeyId`` , then Amazon RDS uses your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS Region.

        :type PerformanceInsightsRetentionPeriod: integer
        :param PerformanceInsightsRetentionPeriod:

          The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

        :type CloudwatchLogsExportConfiguration: dict
        :param CloudwatchLogsExportConfiguration:

          The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance.

          A change to the ``CloudwatchLogsExportConfiguration`` parameter is always applied to the DB instance immediately. Therefore, the ``ApplyImmediately`` parameter has no effect.

          - **EnableLogTypes** *(list) --*

            The list of log types to enable.

            - *(string) --*

          - **DisableLogTypes** *(list) --*

            The list of log types to disable.

            - *(string) --*

        :type ProcessorFeatures: list
        :param ProcessorFeatures:

          The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

          - *(dict) --*

            Contains the processor features of a DB instance class.

            To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

            You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

            * ``CreateDBInstance``

            * ``ModifyDBInstance``

            * ``RestoreDBInstanceFromDBSnapshot``

            * ``RestoreDBInstanceFromS3``

            * ``RestoreDBInstanceToPointInTime``

            You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

            In addition, you can use the following actions for DB instance class processor information:

            * ``DescribeDBInstances``

            * ``DescribeDBSnapshots``

            * ``DescribeValidDBInstanceModifications``

            For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

            - **Name** *(string) --*

              The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

            - **Value** *(string) --*

              The value of a processor feature name.

        :type UseDefaultProcessorFeatures: boolean
        :param UseDefaultProcessorFeatures:

          A value that indicates whether the DB instance class of the DB instance uses its default processor features.

        :type DeletionProtection: boolean
        :param DeletionProtection:

          A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

        :type MaxAllocatedStorage: integer
        :param MaxAllocatedStorage:

          The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBInstance': {
                    'DBInstanceIdentifier': 'string',
                    'DBInstanceClass': 'string',
                    'Engine': 'string',
                    'DBInstanceStatus': 'string',
                    'MasterUsername': 'string',
                    'DBName': 'string',
                    'Endpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'AllocatedStorage': 123,
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'PreferredBackupWindow': 'string',
                    'BackupRetentionPeriod': 123,
                    'DBSecurityGroups': [
                        {
                            'DBSecurityGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'DBParameterGroups': [
                        {
                            'DBParameterGroupName': 'string',
                            'ParameterApplyStatus': 'string'
                        },
                    ],
                    'AvailabilityZone': 'string',
                    'DBSubnetGroup': {
                        'DBSubnetGroupName': 'string',
                        'DBSubnetGroupDescription': 'string',
                        'VpcId': 'string',
                        'SubnetGroupStatus': 'string',
                        'Subnets': [
                            {
                                'SubnetIdentifier': 'string',
                                'SubnetAvailabilityZone': {
                                    'Name': 'string'
                                },
                                'SubnetStatus': 'string'
                            },
                        ],
                        'DBSubnetGroupArn': 'string'
                    },
                    'PreferredMaintenanceWindow': 'string',
                    'PendingModifiedValues': {
                        'DBInstanceClass': 'string',
                        'AllocatedStorage': 123,
                        'MasterUserPassword': 'string',
                        'Port': 123,
                        'BackupRetentionPeriod': 123,
                        'MultiAZ': True|False,
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'DBInstanceIdentifier': 'string',
                        'StorageType': 'string',
                        'CACertificateIdentifier': 'string',
                        'DBSubnetGroupName': 'string',
                        'PendingCloudwatchLogsExports': {
                            'LogTypesToEnable': [
                                'string',
                            ],
                            'LogTypesToDisable': [
                                'string',
                            ]
                        },
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ]
                    },
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'MultiAZ': True|False,
                    'EngineVersion': 'string',
                    'AutoMinorVersionUpgrade': True|False,
                    'ReadReplicaSourceDBInstanceIdentifier': 'string',
                    'ReadReplicaDBInstanceIdentifiers': [
                        'string',
                    ],
                    'ReadReplicaDBClusterIdentifiers': [
                        'string',
                    ],
                    'LicenseModel': 'string',
                    'Iops': 123,
                    'OptionGroupMemberships': [
                        {
                            'OptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'CharacterSetName': 'string',
                    'SecondaryAvailabilityZone': 'string',
                    'PubliclyAccessible': True|False,
                    'StatusInfos': [
                        {
                            'StatusType': 'string',
                            'Normal': True|False,
                            'Status': 'string',
                            'Message': 'string'
                        },
                    ],
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'DbInstancePort': 123,
                    'DBClusterIdentifier': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbiResourceId': 'string',
                    'CACertificateIdentifier': 'string',
                    'DomainMemberships': [
                        {
                            'Domain': 'string',
                            'Status': 'string',
                            'FQDN': 'string',
                            'IAMRoleName': 'string'
                        },
                    ],
                    'CopyTagsToSnapshot': True|False,
                    'MonitoringInterval': 123,
                    'EnhancedMonitoringResourceArn': 'string',
                    'MonitoringRoleArn': 'string',
                    'PromotionTier': 123,
                    'DBInstanceArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'PerformanceInsightsEnabled': True|False,
                    'PerformanceInsightsKMSKeyId': 'string',
                    'PerformanceInsightsRetentionPeriod': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DeletionProtection': True|False,
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'FeatureName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'ListenerEndpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'MaxAllocatedStorage': 123
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBInstance** *(dict) --*

              Contains the details of an Amazon RDS DB instance.

              This data type is used as a response element in the ``DescribeDBInstances`` action.

              - **DBInstanceIdentifier** *(string) --*

                Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.

              - **DBInstanceClass** *(string) --*

                Contains the name of the compute and memory capacity class of the DB instance.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB instance.

              - **DBInstanceStatus** *(string) --*

                Specifies the current state of this database.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB instance.

              - **DBName** *(string) --*

                The meaning of this parameter differs according to the database engine you use.

                 **MySQL, MariaDB, SQL Server, PostgreSQL**

                Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.

                Type: String

                 **Oracle**

                Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.

              - **Endpoint** *(dict) --*

                Specifies the connection endpoint.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size specified in gibibytes.

              - **InstanceCreateTime** *(datetime) --*

                Provides the date and time the DB instance was created.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **DBSecurityGroups** *(list) --*

                A list of DB security group elements containing ``DBSecurityGroup.Name`` and ``DBSecurityGroup.Status`` subelements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceToPointInTime``

                  - **DBSecurityGroupName** *(string) --*

                    The name of the DB security group.

                  - **Status** *(string) --*

                    The status of the DB security group.

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security group elements that the DB instance belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **DBParameterGroups** *(list) --*

                Provides the list of DB parameter groups applied to this DB instance.

                - *(dict) --*

                  The status of the DB parameter group.

                  This data type is used as a response element in the following actions:

                  * ``CreateDBInstance``

                  * ``CreateDBInstanceReadReplica``

                  * ``DeleteDBInstance``

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  - **DBParameterGroupName** *(string) --*

                    The name of the DB parameter group.

                  - **ParameterApplyStatus** *(string) --*

                    The status of parameter updates.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance is located in.

              - **DBSubnetGroup** *(dict) --*

                Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.

                - **DBSubnetGroupName** *(string) --*

                  The name of the DB subnet group.

                - **DBSubnetGroupDescription** *(string) --*

                  Provides the description of the DB subnet group.

                - **VpcId** *(string) --*

                  Provides the VpcId of the DB subnet group.

                - **SubnetGroupStatus** *(string) --*

                  Provides the status of the DB subnet group.

                - **Subnets** *(list) --*

                  Contains a list of ``Subnet`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                    - **SubnetIdentifier** *(string) --*

                      Specifies the identifier of the subnet.

                    - **SubnetAvailabilityZone** *(dict) --*

                      Contains Availability Zone information.

                      This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                      - **Name** *(string) --*

                        The name of the Availability Zone.

                    - **SubnetStatus** *(string) --*

                      Specifies the status of the subnet.

                - **DBSubnetGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB subnet group.

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **PendingModifiedValues** *(dict) --*

                Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.

                - **DBInstanceClass** *(string) --*

                  Contains the new ``DBInstanceClass`` for the DB instance that will be applied or is currently being applied.

                - **AllocatedStorage** *(integer) --*

                  Contains the new ``AllocatedStorage`` size for the DB instance that will be applied or is currently being applied.

                - **MasterUserPassword** *(string) --*

                  Contains the pending or currently-in-progress change of the master credentials for the DB instance.

                - **Port** *(integer) --*

                  Specifies the pending port for the DB instance.

                - **BackupRetentionPeriod** *(integer) --*

                  Specifies the pending number of days for which automated backups are retained.

                - **MultiAZ** *(boolean) --*

                  Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **LicenseModel** *(string) --*

                  The license model for the DB instance.

                  Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

                - **Iops** *(integer) --*

                  Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.

                - **DBInstanceIdentifier** *(string) --*

                  Contains the new ``DBInstanceIdentifier`` for the DB instance that will be applied or is currently being applied.

                - **StorageType** *(string) --*

                  Specifies the storage type to be associated with the DB instance.

                - **CACertificateIdentifier** *(string) --*

                  Specifies the identifier of the CA certificate for the DB instance.

                - **DBSubnetGroupName** *(string) --*

                  The new DB subnet group for the DB instance.

                - **PendingCloudwatchLogsExports** *(dict) --*

                  A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.

                  - **LogTypesToEnable** *(list) --*

                    Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.

                    - *(string) --*

                  - **LogTypesToDisable** *(list) --*

                    Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.

                    - *(string) --*

                - **ProcessorFeatures** *(list) --*

                  The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                  - *(dict) --*

                    Contains the processor features of a DB instance class.

                    To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                    You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                    * ``CreateDBInstance``

                    * ``ModifyDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceFromS3``

                    * ``RestoreDBInstanceToPointInTime``

                    You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                    In addition, you can use the following actions for DB instance class processor information:

                    * ``DescribeDBInstances``

                    * ``DescribeDBSnapshots``

                    * ``DescribeValidDBInstanceModifications``

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **Value** *(string) --*

                      The value of a processor feature name.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **MultiAZ** *(boolean) --*

                Specifies if the DB instance is a Multi-AZ deployment.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **AutoMinorVersionUpgrade** *(boolean) --*

                Indicates that minor version patches are applied automatically.

              - **ReadReplicaSourceDBInstanceIdentifier** *(string) --*

                Contains the identifier of the source DB instance if this DB instance is a Read Replica.

              - **ReadReplicaDBInstanceIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB instance.

                - *(string) --*

              - **ReadReplicaDBClusterIdentifiers** *(list) --*

                Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a Read Replica. For example, when you create an Aurora Read Replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster for the Aurora Read Replica is shown. This output does not contain information about cross region Aurora Read Replicas.

                .. note::

                  Currently, each RDS DB instance can have only one Aurora Read Replica.

                - *(string) --*

              - **LicenseModel** *(string) --*

                License model information for this DB instance.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value.

              - **OptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB instance.

                - *(dict) --*

                  Provides information on the option groups the DB instance is a member of.

                  - **OptionGroupName** *(string) --*

                    The name of the option group that the instance belongs to.

                  - **Status** *(string) --*

                    The status of the DB instance's option group membership. Valid values are: ``in-sync`` , ``pending-apply`` , ``pending-removal`` , ``pending-maintenance-apply`` , ``pending-maintenance-removal`` , ``applying`` , ``removing`` , and ``failed`` .

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this instance is associated with.

              - **SecondaryAvailabilityZone** *(string) --*

                If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.

              - **PubliclyAccessible** *(boolean) --*

                Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address.

              - **StatusInfos** *(list) --*

                The status of a Read Replica. If the instance isn't a Read Replica, this is blank.

                - *(dict) --*

                  Provides a list of status information for a DB instance.

                  - **StatusType** *(string) --*

                    This value is currently "read replication."

                  - **Normal** *(boolean) --*

                    Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.

                  - **Status** *(string) --*

                    Status of the DB instance. For a StatusType of Read Replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.

                  - **Message** *(string) --*

                    Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB instance.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which the instance is associated for TDE encryption.

              - **DbInstancePort** *(integer) --*

                Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.

              - **DBClusterIdentifier** *(string) --*

                If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB instance is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB instance.

              - **DbiResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.

              - **CACertificateIdentifier** *(string) --*

                The identifier of the CA certificate for this DB instance.

              - **DomainMemberships** *(list) --*

                The Active Directory Domain membership records associated with the DB instance.

                - *(dict) --*

                  An Active Directory Domain membership record associated with the DB instance.

                  - **Domain** *(string) --*

                    The identifier of the Active Directory Domain.

                  - **Status** *(string) --*

                    The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).

                  - **FQDN** *(string) --*

                    The fully qualified domain name of the Active Directory Domain.

                  - **IAMRoleName** *(string) --*

                    The name of the IAM role to be used when making API calls to the Directory Service.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB instance to snapshots of the DB instance.

                 **Amazon Aurora**

                Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see ``DBCluster`` .

              - **MonitoringInterval** *(integer) --*

                The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.

              - **EnhancedMonitoringResourceArn** *(string) --*

                The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.

              - **MonitoringRoleArn** *(string) --*

                The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.

              - **PromotionTier** *(integer) --*

                A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **DBInstanceArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB instance.

              - **Timezone** *(string) --*

                The time zone of the DB instance. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

                IAM database authentication can be enabled for the following database engines

                * For MySQL 5.6, minor version 5.6.34 or higher

                * For MySQL 5.7, minor version 5.7.16 or higher

                * Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.

              - **PerformanceInsightsEnabled** *(boolean) --*

                True if Performance Insights is enabled for the DB instance, and otherwise false.

              - **PerformanceInsightsKMSKeyId** *(string) --*

                The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

              - **PerformanceInsightsRetentionPeriod** *(integer) --*

                The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB instance is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html>`__ in the *Amazon RDS User Guide.*

                - *(string) --*

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

              - **AssociatedRoles** *(list) --*

                The AWS Identity and Access Management (IAM) roles associated with the DB instance.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB instance.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see ``DBEngineVersion`` .

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB instance and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB instance.

                    * ``INVALID`` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other AWS services on your behalf.

              - **ListenerEndpoint** *(dict) --*

                Specifies the listener connection endpoint for SQL Server Always On.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **MaxAllocatedStorage** *(integer) --*

                The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        """
        pass

    def modify_db_parameter_group(
        self,
        DBParameterGroupName: str,
        Parameters: List[Any]
    ) -> Dict[str, Any]:
        """
        Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: ``ParameterName`` , ``ParameterValue`` , and ``ApplyMethod`` . A maximum of 20 parameters can be modified in a single request.

        .. note::

          Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB instance associated with the parameter group before the change can take effect.

        .. warning::

          After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the modify action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the ``character_set_database`` parameter. You can use the *Parameter Groups* option of the `Amazon RDS console <https://console.aws.amazon.com/rds/>`__ or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup>`_

        **Request Syntax**
        ::

          response = client.modify_db_parameter_group(
              DBParameterGroupName='string',
              Parameters=[
                  {
                      'ParameterName': 'string',
                      'ParameterValue': 'string',
                      'Description': 'string',
                      'Source': 'string',
                      'ApplyType': 'string',
                      'DataType': 'string',
                      'AllowedValues': 'string',
                      'IsModifiable': True|False,
                      'MinimumEngineVersion': 'string',
                      'ApplyMethod': 'immediate'|'pending-reboot',
                      'SupportedEngineModes': [
                          'string',
                      ]
                  },
              ]
          )
        :type DBParameterGroupName: string
        :param DBParameterGroupName: **[REQUIRED]**

          The name of the DB parameter group.

          Constraints:

          * If supplied, must match the name of an existing ``DBParameterGroup`` .

        :type Parameters: list
        :param Parameters: **[REQUIRED]**

          An array of parameter names, values, and the apply method for the parameter update. At least one parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be modified in a single request.

          Valid Values (for the application method): ``immediate | pending-reboot``

          .. note::

            You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.

          - *(dict) --*

            This data type is used as a request parameter in the ``ModifyDBParameterGroup`` and ``ResetDBParameterGroup`` actions.

            This data type is used as a response element in the ``DescribeEngineDefaultParameters`` and ``DescribeDBParameters`` actions.

            - **ParameterName** *(string) --*

              Specifies the name of the parameter.

            - **ParameterValue** *(string) --*

              Specifies the value of the parameter.

            - **Description** *(string) --*

              Provides a description of the parameter.

            - **Source** *(string) --*

              Indicates the source of the parameter value.

            - **ApplyType** *(string) --*

              Specifies the engine specific parameters type.

            - **DataType** *(string) --*

              Specifies the valid data type for the parameter.

            - **AllowedValues** *(string) --*

              Specifies the valid range of values for the parameter.

            - **IsModifiable** *(boolean) --*

              Indicates whether (``true`` ) or not (``false`` ) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.

            - **MinimumEngineVersion** *(string) --*

              The earliest engine version to which the parameter can apply.

            - **ApplyMethod** *(string) --*

              Indicates when to apply parameter updates.

            - **SupportedEngineModes** *(list) --*

              The valid DB engine modes.

              - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBParameterGroupName': 'string'
            }
          **Response Structure**

          - *(dict) --*

            Contains the result of a successful invocation of the ``ModifyDBParameterGroup`` or ``ResetDBParameterGroup`` action.

            - **DBParameterGroupName** *(string) --*

              Provides the name of the DB parameter group.

        """
        pass

    def modify_db_snapshot(
        self,
        DBSnapshotIdentifier: str,
        EngineVersion: str = None,
        OptionGroupName: str = None
    ) -> Dict[str, Any]:
        """
        Updates a manual DB snapshot, which can be encrypted or not encrypted, with a new engine version.

        Amazon RDS supports upgrading DB snapshots for MySQL and Oracle.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot>`_

        **Request Syntax**
        ::

          response = client.modify_db_snapshot(
              DBSnapshotIdentifier='string',
              EngineVersion='string',
              OptionGroupName='string'
          )
        :type DBSnapshotIdentifier: string
        :param DBSnapshotIdentifier: **[REQUIRED]**

          The identifier of the DB snapshot to modify.

        :type EngineVersion: string
        :param EngineVersion:

          The engine version to upgrade the DB snapshot to.

          The following are the database engines and engine versions that are available when you upgrade a DB snapshot.

           **MySQL**

          * ``5.5.46`` (supported for 5.1 DB snapshots)

           **Oracle**

          * ``12.1.0.2.v8`` (supported for 12.1.0.1 DB snapshots)

          * ``11.2.0.4.v12`` (supported for 11.2.0.2 DB snapshots)

          * ``11.2.0.4.v11`` (supported for 11.2.0.3 DB snapshots)

        :type OptionGroupName: string
        :param OptionGroupName:

          The option group to identify with the upgraded DB snapshot.

          You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see `Option Group Considerations <http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG>`__ in the *Amazon RDS User Guide.*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSnapshot': {
                    'DBSnapshotIdentifier': 'string',
                    'DBInstanceIdentifier': 'string',
                    'SnapshotCreateTime': datetime(2015, 1, 1),
                    'Engine': 'string',
                    'AllocatedStorage': 123,
                    'Status': 'string',
                    'Port': 123,
                    'AvailabilityZone': 'string',
                    'VpcId': 'string',
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'MasterUsername': 'string',
                    'EngineVersion': 'string',
                    'LicenseModel': 'string',
                    'SnapshotType': 'string',
                    'Iops': 123,
                    'OptionGroupName': 'string',
                    'PercentProgress': 123,
                    'SourceRegion': 'string',
                    'SourceDBSnapshotIdentifier': 'string',
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'Encrypted': True|False,
                    'KmsKeyId': 'string',
                    'DBSnapshotArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DbiResourceId': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSnapshot** *(dict) --*

              Contains the details of an Amazon RDS DB snapshot.

              This data type is used as a response element in the ``DescribeDBSnapshots`` action.

              - **DBSnapshotIdentifier** *(string) --*

                Specifies the identifier for the DB snapshot.

              - **DBInstanceIdentifier** *(string) --*

                Specifies the DB instance identifier of the DB instance this DB snapshot was created from.

              - **SnapshotCreateTime** *(datetime) --*

                Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **Engine** *(string) --*

                Specifies the name of the database engine.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size in gibibytes (GiB).

              - **Status** *(string) --*

                Specifies the status of this DB snapshot.

              - **Port** *(integer) --*

                Specifies the port that the database engine was listening on at the time of the snapshot.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.

              - **VpcId** *(string) --*

                Provides the VPC ID associated with the DB snapshot.

              - **InstanceCreateTime** *(datetime) --*

                Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).

              - **MasterUsername** *(string) --*

                Provides the master username for the DB snapshot.

              - **EngineVersion** *(string) --*

                Specifies the version of the database engine.

              - **LicenseModel** *(string) --*

                License model information for the restored DB instance.

              - **SnapshotType** *(string) --*

                Provides the type of the DB snapshot.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.

              - **OptionGroupName** *(string) --*

                Provides the option group name for the DB snapshot.

              - **PercentProgress** *(integer) --*

                The percentage of the estimated data that has been transferred.

              - **SourceRegion** *(string) --*

                The AWS Region that the DB snapshot was created in or copied from.

              - **SourceDBSnapshotIdentifier** *(string) --*

                The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has value in case of cross-customer or cross-region copy.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB snapshot.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which to associate the instance for TDE encryption.

              - **Encrypted** *(boolean) --*

                Specifies whether the DB snapshot is encrypted.

              - **KmsKeyId** *(string) --*

                If ``Encrypted`` is true, the AWS KMS key identifier for the encrypted DB snapshot.

              - **DBSnapshotArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB snapshot.

              - **Timezone** *(string) --*

                The time zone of the DB snapshot. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DbiResourceId** *(string) --*

                The identifier for the source DB instance, which can't be changed and which is unique to an AWS Region.

        """
        pass

    def modify_db_snapshot_attribute(
        self,
        DBSnapshotIdentifier: str,
        AttributeName: str,
        ValuesToAdd: List[Any] = None,
        ValuesToRemove: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.

        To share a manual DB snapshot with other AWS accounts, specify ``restore`` as the ``AttributeName`` and use the ``ValuesToAdd`` parameter to add a list of IDs of the AWS accounts that are authorized to restore the manual DB snapshot. Uses the value ``all`` to make the manual DB snapshot public, which means it can be copied or restored by all AWS accounts. Do not add the ``all`` value for any manual DB snapshots that contain private information that you don't want available to all AWS accounts. If the manual DB snapshot is encrypted, it can be shared, but only by specifying a list of authorized AWS account IDs for the ``ValuesToAdd`` parameter. You can't use ``all`` as a value for that parameter in this case.

        To view which AWS accounts have access to copy or restore a manual DB snapshot, or whether a manual DB snapshot public or private, use the ``DescribeDBSnapshotAttributes`` API action.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute>`_

        **Request Syntax**
        ::

          response = client.modify_db_snapshot_attribute(
              DBSnapshotIdentifier='string',
              AttributeName='string',
              ValuesToAdd=[
                  'string',
              ],
              ValuesToRemove=[
                  'string',
              ]
          )
        :type DBSnapshotIdentifier: string
        :param DBSnapshotIdentifier: **[REQUIRED]**

          The identifier for the DB snapshot to modify the attributes for.

        :type AttributeName: string
        :param AttributeName: **[REQUIRED]**

          The name of the DB snapshot attribute to modify.

          To manage authorization for other AWS accounts to copy or restore a manual DB snapshot, set this value to ``restore`` .

        :type ValuesToAdd: list
        :param ValuesToAdd:

          A list of DB snapshot attributes to add to the attribute specified by ``AttributeName`` .

          To authorize other AWS accounts to copy or restore a manual snapshot, set this list to include one or more AWS account IDs, or ``all`` to make the manual DB snapshot restorable by any AWS account. Do not add the ``all`` value for any manual DB snapshots that contain private information that you don't want available to all AWS accounts.

          - *(string) --*

        :type ValuesToRemove: list
        :param ValuesToRemove:

          A list of DB snapshot attributes to remove from the attribute specified by ``AttributeName`` .

          To remove authorization for other AWS accounts to copy or restore a manual snapshot, set this list to include one or more AWS account identifiers, or ``all`` to remove authorization for any AWS account to copy or restore the DB snapshot. If you specify ``all`` , an AWS account whose account ID is explicitly added to the ``restore`` attribute can still copy or restore the manual DB snapshot.

          - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSnapshotAttributesResult': {
                    'DBSnapshotIdentifier': 'string',
                    'DBSnapshotAttributes': [
                        {
                            'AttributeName': 'string',
                            'AttributeValues': [
                                'string',
                            ]
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSnapshotAttributesResult** *(dict) --*

              Contains the results of a successful call to the ``DescribeDBSnapshotAttributes`` API action.

              Manual DB snapshot attributes are used to authorize other AWS accounts to copy or restore a manual DB snapshot. For more information, see the ``ModifyDBSnapshotAttribute`` API action.

              - **DBSnapshotIdentifier** *(string) --*

                The identifier of the manual DB snapshot that the attributes apply to.

              - **DBSnapshotAttributes** *(list) --*

                The list of attributes and values for the manual DB snapshot.

                - *(dict) --*

                  Contains the name and values of a manual DB snapshot attribute

                  Manual DB snapshot attributes are used to authorize other AWS accounts to restore a manual DB snapshot. For more information, see the ``ModifyDBSnapshotAttribute`` API.

                  - **AttributeName** *(string) --*

                    The name of the manual DB snapshot attribute.

                    The attribute named ``restore`` refers to the list of AWS accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the ``ModifyDBSnapshotAttribute`` API action.

                  - **AttributeValues** *(list) --*

                    The value or values for the manual DB snapshot attribute.

                    If the ``AttributeName`` field is set to ``restore`` , then this element returns a list of IDs of the AWS accounts that are authorized to copy or restore the manual DB snapshot. If a value of ``all`` is in the list, then the manual DB snapshot is public and available for any AWS account to copy or restore.

                    - *(string) --*

        """
        pass

    def modify_db_subnet_group(
        self,
        DBSubnetGroupName: str,
        SubnetIds: List[Any],
        DBSubnetGroupDescription: str = None
    ) -> Dict[str, Any]:
        """
        Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the AWS Region.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup>`_

        **Request Syntax**
        ::

          response = client.modify_db_subnet_group(
              DBSubnetGroupName='string',
              DBSubnetGroupDescription='string',
              SubnetIds=[
                  'string',
              ]
          )
        :type DBSubnetGroupName: string
        :param DBSubnetGroupName: **[REQUIRED]**

          The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default subnet group.

          Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.

          Example: ``mySubnetgroup``

        :type DBSubnetGroupDescription: string
        :param DBSubnetGroupDescription:

          The description for the DB subnet group.

        :type SubnetIds: list
        :param SubnetIds: **[REQUIRED]**

          The EC2 subnet IDs for the DB subnet group.

          - *(string) --*

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBSubnetGroup': {
                    'DBSubnetGroupName': 'string',
                    'DBSubnetGroupDescription': 'string',
                    'VpcId': 'string',
                    'SubnetGroupStatus': 'string',
                    'Subnets': [
                        {
                            'SubnetIdentifier': 'string',
                            'SubnetAvailabilityZone': {
                                'Name': 'string'
                            },
                            'SubnetStatus': 'string'
                        },
                    ],
                    'DBSubnetGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBSubnetGroup** *(dict) --*

              Contains the details of an Amazon RDS DB subnet group.

              This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

              - **DBSubnetGroupName** *(string) --*

                The name of the DB subnet group.

              - **DBSubnetGroupDescription** *(string) --*

                Provides the description of the DB subnet group.

              - **VpcId** *(string) --*

                Provides the VpcId of the DB subnet group.

              - **SubnetGroupStatus** *(string) --*

                Provides the status of the DB subnet group.

              - **Subnets** *(list) --*

                Contains a list of ``Subnet`` elements.

                - *(dict) --*

                  This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                  - **SubnetIdentifier** *(string) --*

                    Specifies the identifier of the subnet.

                  - **SubnetAvailabilityZone** *(dict) --*

                    Contains Availability Zone information.

                    This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                    - **Name** *(string) --*

                      The name of the Availability Zone.

                  - **SubnetStatus** *(string) --*

                    Specifies the status of the subnet.

              - **DBSubnetGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB subnet group.

        """
        pass

    def modify_event_subscription(
        self,
        SubscriptionName: str,
        SnsTopicArn: str = None,
        SourceType: str = None,
        EventCategories: List[Any] = None,
        Enabled: bool = None
    ) -> Dict[str, Any]:
        """
        Modifies an existing RDS event notification subscription. Note that you can't modify the source identifiers using this call; to change source identifiers for a subscription, use the ``AddSourceIdentifierToSubscription`` and ``RemoveSourceIdentifierFromSubscription`` calls.

        You can see a list of the event categories for a given SourceType in the `Events <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html>`__ topic in the *Amazon RDS User Guide* or by using the **DescribeEventCategories** action.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription>`_

        **Request Syntax**
        ::

          response = client.modify_event_subscription(
              SubscriptionName='string',
              SnsTopicArn='string',
              SourceType='string',
              EventCategories=[
                  'string',
              ],
              Enabled=True|False
          )
        :type SubscriptionName: string
        :param SubscriptionName: **[REQUIRED]**

          The name of the RDS event notification subscription.

        :type SnsTopicArn: string
        :param SnsTopicArn:

          The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.

        :type SourceType: string
        :param SourceType:

          The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. If this value isn't specified, all events are returned.

          Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot

        :type EventCategories: list
        :param EventCategories:

          A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType in the `Events <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html>`__ topic in the *Amazon RDS User Guide* or by using the **DescribeEventCategories** action.

          - *(string) --*

        :type Enabled: boolean
        :param Enabled:

          A value that indicates whether to activate the subscription.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'EventSubscription': {
                    'CustomerAwsId': 'string',
                    'CustSubscriptionId': 'string',
                    'SnsTopicArn': 'string',
                    'Status': 'string',
                    'SubscriptionCreationTime': 'string',
                    'SourceType': 'string',
                    'SourceIdsList': [
                        'string',
                    ],
                    'EventCategoriesList': [
                        'string',
                    ],
                    'Enabled': True|False,
                    'EventSubscriptionArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **EventSubscription** *(dict) --*

              Contains the results of a successful invocation of the ``DescribeEventSubscriptions`` action.

              - **CustomerAwsId** *(string) --*

                The AWS customer account associated with the RDS event notification subscription.

              - **CustSubscriptionId** *(string) --*

                The RDS event notification subscription Id.

              - **SnsTopicArn** *(string) --*

                The topic ARN of the RDS event notification subscription.

              - **Status** *(string) --*

                The status of the RDS event notification subscription.

                Constraints:

                Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist

                The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.

              - **SubscriptionCreationTime** *(string) --*

                The time the RDS event notification subscription was created.

              - **SourceType** *(string) --*

                The source type for the RDS event notification subscription.

              - **SourceIdsList** *(list) --*

                A list of source IDs for the RDS event notification subscription.

                - *(string) --*

              - **EventCategoriesList** *(list) --*

                A list of event categories for the RDS event notification subscription.

                - *(string) --*

              - **Enabled** *(boolean) --*

                A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.

              - **EventSubscriptionArn** *(string) --*

                The Amazon Resource Name (ARN) for the event subscription.

        """
        pass

    def modify_global_cluster(
        self,
        GlobalClusterIdentifier: str = None,
        NewGlobalClusterIdentifier: str = None,
        DeletionProtection: bool = None
    ) -> Dict[str, Any]:
        """
        Modify a setting for an Amazon Aurora global cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see `What Is Amazon Aurora? <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html>`__ in the *Amazon Aurora User Guide.*

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyGlobalCluster>`_

        **Request Syntax**
        ::

          response = client.modify_global_cluster(
              GlobalClusterIdentifier='string',
              NewGlobalClusterIdentifier='string',
              DeletionProtection=True|False
          )
        :type GlobalClusterIdentifier: string
        :param GlobalClusterIdentifier:

          The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.

          Constraints:

          * Must match the identifier of an existing global database cluster.

        :type NewGlobalClusterIdentifier: string
        :param NewGlobalClusterIdentifier:

          The new cluster identifier for the global database cluster when modifying a global database cluster. This value is stored as a lowercase string.

          Constraints:

          * Must contain from 1 to 63 letters, numbers, or hyphens

          * The first character must be a letter

          * Can't end with a hyphen or contain two consecutive hyphens

          Example: ``my-cluster2``

        :type DeletionProtection: boolean
        :param DeletionProtection:

          Indicates if the global database cluster has deletion protection enabled. The global database cluster can't be deleted when deletion protection is enabled.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'GlobalCluster': {
                    'GlobalClusterIdentifier': 'string',
                    'GlobalClusterResourceId': 'string',
                    'GlobalClusterArn': 'string',
                    'Status': 'string',
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'DatabaseName': 'string',
                    'StorageEncrypted': True|False,
                    'DeletionProtection': True|False,
                    'GlobalClusterMembers': [
                        {
                            'DBClusterArn': 'string',
                            'Readers': [
                                'string',
                            ],
                            'IsWriter': True|False
                        },
                    ]
                }
            }
          **Response Structure**

          - *(dict) --*

            - **GlobalCluster** *(dict) --*

              A data type representing an Aurora global database.

              - **GlobalClusterIdentifier** *(string) --*

                Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster.

              - **GlobalClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **GlobalClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the global database cluster.

              - **Status** *(string) --*

                Specifies the current state of this global database cluster.

              - **Engine** *(string) --*

                The Aurora database engine used by the global database cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **DatabaseName** *(string) --*

                The default database name within the new global database cluster.

              - **StorageEncrypted** *(boolean) --*

                The storage encryption setting for the global database cluster.

              - **DeletionProtection** *(boolean) --*

                The deletion protection setting for the new global database cluster.

              - **GlobalClusterMembers** *(list) --*

                The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item.

                - *(dict) --*

                  A data structure with information about any primary and secondary clusters associated with an Aurora global database.

                  - **DBClusterArn** *(string) --*

                    The Amazon Resource Name (ARN) for each Aurora cluster.

                  - **Readers** *(list) --*

                    The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database.

                    - *(string) --*

                  - **IsWriter** *(boolean) --*

                    Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated.

        """
        pass

    def modify_option_group(
        self,
        OptionGroupName: str,
        OptionsToInclude: List[Any] = None,
        OptionsToRemove: List[Any] = None,
        ApplyImmediately: bool = None
    ) -> Dict[str, Any]:
        """
        Modifies an existing option group.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroup>`_

        **Request Syntax**
        ::

          response = client.modify_option_group(
              OptionGroupName='string',
              OptionsToInclude=[
                  {
                      'OptionName': 'string',
                      'Port': 123,
                      'OptionVersion': 'string',
                      'DBSecurityGroupMemberships': [
                          'string',
                      ],
                      'VpcSecurityGroupMemberships': [
                          'string',
                      ],
                      'OptionSettings': [
                          {
                              'Name': 'string',
                              'Value': 'string',
                              'DefaultValue': 'string',
                              'Description': 'string',
                              'ApplyType': 'string',
                              'DataType': 'string',
                              'AllowedValues': 'string',
                              'IsModifiable': True|False,
                              'IsCollection': True|False
                          },
                      ]
                  },
              ],
              OptionsToRemove=[
                  'string',
              ],
              ApplyImmediately=True|False
          )
        :type OptionGroupName: string
        :param OptionGroupName: **[REQUIRED]**

          The name of the option group to be modified.

          Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance

        :type OptionsToInclude: list
        :param OptionsToInclude:

          Options in this list are added to the option group or, if already present, the specified configuration is used to update the existing configuration.

          - *(dict) --*

            A list of all available options

            - **OptionName** *(string) --* **[REQUIRED]**

              The configuration of options to include in a group.

            - **Port** *(integer) --*

              The optional port for the option.

            - **OptionVersion** *(string) --*

              The version for the option.

            - **DBSecurityGroupMemberships** *(list) --*

              A list of DBSecurityGroupMembership name strings used for this option.

              - *(string) --*

            - **VpcSecurityGroupMemberships** *(list) --*

              A list of VpcSecurityGroupMembership name strings used for this option.

              - *(string) --*

            - **OptionSettings** *(list) --*

              The option settings to include in an option group.

              - *(dict) --*

                Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.

                - **Name** *(string) --*

                  The name of the option that has settings that you can set.

                - **Value** *(string) --*

                  The current value of the option setting.

                - **DefaultValue** *(string) --*

                  The default value of the option setting.

                - **Description** *(string) --*

                  The description of the option setting.

                - **ApplyType** *(string) --*

                  The DB engine specific parameter type.

                - **DataType** *(string) --*

                  The data type of the option setting.

                - **AllowedValues** *(string) --*

                  The allowed values of the option setting.

                - **IsModifiable** *(boolean) --*

                  A Boolean value that, when true, indicates the option setting can be modified from the default.

                - **IsCollection** *(boolean) --*

                  Indicates if the option setting is part of a collection.

        :type OptionsToRemove: list
        :param OptionsToRemove:

          Options in this list are removed from the option group.

          - *(string) --*

        :type ApplyImmediately: boolean
        :param ApplyImmediately:

          A value that indicates whether to apply the change immediately or during the next maintenance window for each instance associated with the option group.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'OptionGroup': {
                    'OptionGroupName': 'string',
                    'OptionGroupDescription': 'string',
                    'EngineName': 'string',
                    'MajorEngineVersion': 'string',
                    'Options': [
                        {
                            'OptionName': 'string',
                            'OptionDescription': 'string',
                            'Persistent': True|False,
                            'Permanent': True|False,
                            'Port': 123,
                            'OptionVersion': 'string',
                            'OptionSettings': [
                                {
                                    'Name': 'string',
                                    'Value': 'string',
                                    'DefaultValue': 'string',
                                    'Description': 'string',
                                    'ApplyType': 'string',
                                    'DataType': 'string',
                                    'AllowedValues': 'string',
                                    'IsModifiable': True|False,
                                    'IsCollection': True|False
                                },
                            ],
                            'DBSecurityGroupMemberships': [
                                {
                                    'DBSecurityGroupName': 'string',
                                    'Status': 'string'
                                },
                            ],
                            'VpcSecurityGroupMemberships': [
                                {
                                    'VpcSecurityGroupId': 'string',
                                    'Status': 'string'
                                },
                            ]
                        },
                    ],
                    'AllowsVpcAndNonVpcInstanceMemberships': True|False,
                    'VpcId': 'string',
                    'OptionGroupArn': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **OptionGroup** *(dict) --*

              - **OptionGroupName** *(string) --*

                Specifies the name of the option group.

              - **OptionGroupDescription** *(string) --*

                Provides a description of the option group.

              - **EngineName** *(string) --*

                Indicates the name of the engine that this option group can be applied to.

              - **MajorEngineVersion** *(string) --*

                Indicates the major engine version associated with this option group.

              - **Options** *(list) --*

                Indicates what options are available in the option group.

                - *(dict) --*

                  Option details.

                  - **OptionName** *(string) --*

                    The name of the option.

                  - **OptionDescription** *(string) --*

                    The description of the option.

                  - **Persistent** *(boolean) --*

                    Indicate if this option is persistent.

                  - **Permanent** *(boolean) --*

                    Indicate if this option is permanent.

                  - **Port** *(integer) --*

                    If required, the port configured for this option to use.

                  - **OptionVersion** *(string) --*

                    The version of the option.

                  - **OptionSettings** *(list) --*

                    The option settings for this option.

                    - *(dict) --*

                      Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.

                      - **Name** *(string) --*

                        The name of the option that has settings that you can set.

                      - **Value** *(string) --*

                        The current value of the option setting.

                      - **DefaultValue** *(string) --*

                        The default value of the option setting.

                      - **Description** *(string) --*

                        The description of the option setting.

                      - **ApplyType** *(string) --*

                        The DB engine specific parameter type.

                      - **DataType** *(string) --*

                        The data type of the option setting.

                      - **AllowedValues** *(string) --*

                        The allowed values of the option setting.

                      - **IsModifiable** *(boolean) --*

                        A Boolean value that, when true, indicates the option setting can be modified from the default.

                      - **IsCollection** *(boolean) --*

                        Indicates if the option setting is part of a collection.

                  - **DBSecurityGroupMemberships** *(list) --*

                    If the option requires access to a port, then this DB security group allows access to the port.

                    - *(dict) --*

                      This data type is used as a response element in the following actions:

                      * ``ModifyDBInstance``

                      * ``RebootDBInstance``

                      * ``RestoreDBInstanceFromDBSnapshot``

                      * ``RestoreDBInstanceToPointInTime``

                      - **DBSecurityGroupName** *(string) --*

                        The name of the DB security group.

                      - **Status** *(string) --*

                        The status of the DB security group.

                  - **VpcSecurityGroupMemberships** *(list) --*

                    If the option requires access to a port, then this VPC security group allows access to the port.

                    - *(dict) --*

                      This data type is used as a response element for queries on VPC security group membership.

                      - **VpcSecurityGroupId** *(string) --*

                        The name of the VPC security group.

                      - **Status** *(string) --*

                        The status of the VPC security group.

              - **AllowsVpcAndNonVpcInstanceMemberships** *(boolean) --*

                Indicates whether this option group can be applied to both VPC and non-VPC instances. The value ``true`` indicates the option group can be applied to both VPC and non-VPC instances.

              - **VpcId** *(string) --*

                If **AllowsVpcAndNonVpcInstanceMemberships** is ``false`` , this field is blank. If **AllowsVpcAndNonVpcInstanceMemberships** is ``true`` and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field.

              - **OptionGroupArn** *(string) --*

                The Amazon Resource Name (ARN) for the option group.

        """
        pass

    def promote_read_replica(
        self,
        DBInstanceIdentifier: str,
        BackupRetentionPeriod: int = None,
        PreferredBackupWindow: str = None
    ) -> Dict[str, Any]:
        """
        Promotes a Read Replica DB instance to a standalone DB instance.

        .. note::

          * Backup duration is a function of the amount of changes to the database since the previous backup. If you plan to promote a Read Replica to a standalone instance, we recommend that you enable backups and complete at least one backup prior to promotion. In addition, a Read Replica cannot be promoted to a standalone instance when it is in the ``backing-up`` status. If you have enabled backups on your Read Replica, configure the automated backup window so that daily backups do not interfere with Read Replica promotion.

          * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplica>`_

        **Request Syntax**
        ::

          response = client.promote_read_replica(
              DBInstanceIdentifier='string',
              BackupRetentionPeriod=123,
              PreferredBackupWindow='string'
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The DB instance identifier. This value is stored as a lowercase string.

          Constraints:

          * Must match the identifier of an existing Read Replica DB instance.

          Example: ``mydbinstance``

        :type BackupRetentionPeriod: integer
        :param BackupRetentionPeriod:

          The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.

          Default: 1

          Constraints:

          * Must be a value from 0 to 35.

          * Can't be set to 0 if the DB instance is a source to Read Replicas.

        :type PreferredBackupWindow: string
        :param PreferredBackupWindow:

          The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter.

          The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see `Adjusting the Preferred Maintenance Window <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html>`__ in the *Amazon RDS User Guide.*

          Constraints:

          * Must be in the format ``hh24:mi-hh24:mi`` .

          * Must be in Universal Coordinated Time (UTC).

          * Must not conflict with the preferred maintenance window.

          * Must be at least 30 minutes.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBInstance': {
                    'DBInstanceIdentifier': 'string',
                    'DBInstanceClass': 'string',
                    'Engine': 'string',
                    'DBInstanceStatus': 'string',
                    'MasterUsername': 'string',
                    'DBName': 'string',
                    'Endpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'AllocatedStorage': 123,
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'PreferredBackupWindow': 'string',
                    'BackupRetentionPeriod': 123,
                    'DBSecurityGroups': [
                        {
                            'DBSecurityGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'DBParameterGroups': [
                        {
                            'DBParameterGroupName': 'string',
                            'ParameterApplyStatus': 'string'
                        },
                    ],
                    'AvailabilityZone': 'string',
                    'DBSubnetGroup': {
                        'DBSubnetGroupName': 'string',
                        'DBSubnetGroupDescription': 'string',
                        'VpcId': 'string',
                        'SubnetGroupStatus': 'string',
                        'Subnets': [
                            {
                                'SubnetIdentifier': 'string',
                                'SubnetAvailabilityZone': {
                                    'Name': 'string'
                                },
                                'SubnetStatus': 'string'
                            },
                        ],
                        'DBSubnetGroupArn': 'string'
                    },
                    'PreferredMaintenanceWindow': 'string',
                    'PendingModifiedValues': {
                        'DBInstanceClass': 'string',
                        'AllocatedStorage': 123,
                        'MasterUserPassword': 'string',
                        'Port': 123,
                        'BackupRetentionPeriod': 123,
                        'MultiAZ': True|False,
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'DBInstanceIdentifier': 'string',
                        'StorageType': 'string',
                        'CACertificateIdentifier': 'string',
                        'DBSubnetGroupName': 'string',
                        'PendingCloudwatchLogsExports': {
                            'LogTypesToEnable': [
                                'string',
                            ],
                            'LogTypesToDisable': [
                                'string',
                            ]
                        },
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ]
                    },
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'MultiAZ': True|False,
                    'EngineVersion': 'string',
                    'AutoMinorVersionUpgrade': True|False,
                    'ReadReplicaSourceDBInstanceIdentifier': 'string',
                    'ReadReplicaDBInstanceIdentifiers': [
                        'string',
                    ],
                    'ReadReplicaDBClusterIdentifiers': [
                        'string',
                    ],
                    'LicenseModel': 'string',
                    'Iops': 123,
                    'OptionGroupMemberships': [
                        {
                            'OptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'CharacterSetName': 'string',
                    'SecondaryAvailabilityZone': 'string',
                    'PubliclyAccessible': True|False,
                    'StatusInfos': [
                        {
                            'StatusType': 'string',
                            'Normal': True|False,
                            'Status': 'string',
                            'Message': 'string'
                        },
                    ],
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'DbInstancePort': 123,
                    'DBClusterIdentifier': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbiResourceId': 'string',
                    'CACertificateIdentifier': 'string',
                    'DomainMemberships': [
                        {
                            'Domain': 'string',
                            'Status': 'string',
                            'FQDN': 'string',
                            'IAMRoleName': 'string'
                        },
                    ],
                    'CopyTagsToSnapshot': True|False,
                    'MonitoringInterval': 123,
                    'EnhancedMonitoringResourceArn': 'string',
                    'MonitoringRoleArn': 'string',
                    'PromotionTier': 123,
                    'DBInstanceArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'PerformanceInsightsEnabled': True|False,
                    'PerformanceInsightsKMSKeyId': 'string',
                    'PerformanceInsightsRetentionPeriod': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DeletionProtection': True|False,
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'FeatureName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'ListenerEndpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'MaxAllocatedStorage': 123
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBInstance** *(dict) --*

              Contains the details of an Amazon RDS DB instance.

              This data type is used as a response element in the ``DescribeDBInstances`` action.

              - **DBInstanceIdentifier** *(string) --*

                Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.

              - **DBInstanceClass** *(string) --*

                Contains the name of the compute and memory capacity class of the DB instance.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB instance.

              - **DBInstanceStatus** *(string) --*

                Specifies the current state of this database.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB instance.

              - **DBName** *(string) --*

                The meaning of this parameter differs according to the database engine you use.

                 **MySQL, MariaDB, SQL Server, PostgreSQL**

                Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.

                Type: String

                 **Oracle**

                Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.

              - **Endpoint** *(dict) --*

                Specifies the connection endpoint.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size specified in gibibytes.

              - **InstanceCreateTime** *(datetime) --*

                Provides the date and time the DB instance was created.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **DBSecurityGroups** *(list) --*

                A list of DB security group elements containing ``DBSecurityGroup.Name`` and ``DBSecurityGroup.Status`` subelements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceToPointInTime``

                  - **DBSecurityGroupName** *(string) --*

                    The name of the DB security group.

                  - **Status** *(string) --*

                    The status of the DB security group.

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security group elements that the DB instance belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **DBParameterGroups** *(list) --*

                Provides the list of DB parameter groups applied to this DB instance.

                - *(dict) --*

                  The status of the DB parameter group.

                  This data type is used as a response element in the following actions:

                  * ``CreateDBInstance``

                  * ``CreateDBInstanceReadReplica``

                  * ``DeleteDBInstance``

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  - **DBParameterGroupName** *(string) --*

                    The name of the DB parameter group.

                  - **ParameterApplyStatus** *(string) --*

                    The status of parameter updates.

              - **AvailabilityZone** *(string) --*

                Specifies the name of the Availability Zone the DB instance is located in.

              - **DBSubnetGroup** *(dict) --*

                Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.

                - **DBSubnetGroupName** *(string) --*

                  The name of the DB subnet group.

                - **DBSubnetGroupDescription** *(string) --*

                  Provides the description of the DB subnet group.

                - **VpcId** *(string) --*

                  Provides the VpcId of the DB subnet group.

                - **SubnetGroupStatus** *(string) --*

                  Provides the status of the DB subnet group.

                - **Subnets** *(list) --*

                  Contains a list of ``Subnet`` elements.

                  - *(dict) --*

                    This data type is used as a response element in the ``DescribeDBSubnetGroups`` action.

                    - **SubnetIdentifier** *(string) --*

                      Specifies the identifier of the subnet.

                    - **SubnetAvailabilityZone** *(dict) --*

                      Contains Availability Zone information.

                      This data type is used as an element in the ``OrderableDBInstanceOption`` data type.

                      - **Name** *(string) --*

                        The name of the Availability Zone.

                    - **SubnetStatus** *(string) --*

                      Specifies the status of the subnet.

                - **DBSubnetGroupArn** *(string) --*

                  The Amazon Resource Name (ARN) for the DB subnet group.

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **PendingModifiedValues** *(dict) --*

                Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.

                - **DBInstanceClass** *(string) --*

                  Contains the new ``DBInstanceClass`` for the DB instance that will be applied or is currently being applied.

                - **AllocatedStorage** *(integer) --*

                  Contains the new ``AllocatedStorage`` size for the DB instance that will be applied or is currently being applied.

                - **MasterUserPassword** *(string) --*

                  Contains the pending or currently-in-progress change of the master credentials for the DB instance.

                - **Port** *(integer) --*

                  Specifies the pending port for the DB instance.

                - **BackupRetentionPeriod** *(integer) --*

                  Specifies the pending number of days for which automated backups are retained.

                - **MultiAZ** *(boolean) --*

                  Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.

                - **EngineVersion** *(string) --*

                  Indicates the database engine version.

                - **LicenseModel** *(string) --*

                  The license model for the DB instance.

                  Valid values: ``license-included`` | ``bring-your-own-license`` | ``general-public-license``

                - **Iops** *(integer) --*

                  Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.

                - **DBInstanceIdentifier** *(string) --*

                  Contains the new ``DBInstanceIdentifier`` for the DB instance that will be applied or is currently being applied.

                - **StorageType** *(string) --*

                  Specifies the storage type to be associated with the DB instance.

                - **CACertificateIdentifier** *(string) --*

                  Specifies the identifier of the CA certificate for the DB instance.

                - **DBSubnetGroupName** *(string) --*

                  The new DB subnet group for the DB instance.

                - **PendingCloudwatchLogsExports** *(dict) --*

                  A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.

                  - **LogTypesToEnable** *(list) --*

                    Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.

                    - *(string) --*

                  - **LogTypesToDisable** *(list) --*

                    Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.

                    - *(string) --*

                - **ProcessorFeatures** *(list) --*

                  The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                  - *(dict) --*

                    Contains the processor features of a DB instance class.

                    To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                    You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                    * ``CreateDBInstance``

                    * ``ModifyDBInstance``

                    * ``RestoreDBInstanceFromDBSnapshot``

                    * ``RestoreDBInstanceFromS3``

                    * ``RestoreDBInstanceToPointInTime``

                    You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                    In addition, you can use the following actions for DB instance class processor information:

                    * ``DescribeDBInstances``

                    * ``DescribeDBSnapshots``

                    * ``DescribeValidDBInstanceModifications``

                    For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                    - **Name** *(string) --*

                      The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                    - **Value** *(string) --*

                      The value of a processor feature name.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **MultiAZ** *(boolean) --*

                Specifies if the DB instance is a Multi-AZ deployment.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **AutoMinorVersionUpgrade** *(boolean) --*

                Indicates that minor version patches are applied automatically.

              - **ReadReplicaSourceDBInstanceIdentifier** *(string) --*

                Contains the identifier of the source DB instance if this DB instance is a Read Replica.

              - **ReadReplicaDBInstanceIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB instance.

                - *(string) --*

              - **ReadReplicaDBClusterIdentifiers** *(list) --*

                Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a Read Replica. For example, when you create an Aurora Read Replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster for the Aurora Read Replica is shown. This output does not contain information about cross region Aurora Read Replicas.

                .. note::

                  Currently, each RDS DB instance can have only one Aurora Read Replica.

                - *(string) --*

              - **LicenseModel** *(string) --*

                License model information for this DB instance.

              - **Iops** *(integer) --*

                Specifies the Provisioned IOPS (I/O operations per second) value.

              - **OptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB instance.

                - *(dict) --*

                  Provides information on the option groups the DB instance is a member of.

                  - **OptionGroupName** *(string) --*

                    The name of the option group that the instance belongs to.

                  - **Status** *(string) --*

                    The status of the DB instance's option group membership. Valid values are: ``in-sync`` , ``pending-apply`` , ``pending-removal`` , ``pending-maintenance-apply`` , ``pending-maintenance-removal`` , ``applying`` , ``removing`` , and ``failed`` .

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this instance is associated with.

              - **SecondaryAvailabilityZone** *(string) --*

                If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.

              - **PubliclyAccessible** *(boolean) --*

                Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address.

              - **StatusInfos** *(list) --*

                The status of a Read Replica. If the instance isn't a Read Replica, this is blank.

                - *(dict) --*

                  Provides a list of status information for a DB instance.

                  - **StatusType** *(string) --*

                    This value is currently "read replication."

                  - **Normal** *(boolean) --*

                    Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.

                  - **Status** *(string) --*

                    Status of the DB instance. For a StatusType of Read Replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.

                  - **Message** *(string) --*

                    Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.

              - **StorageType** *(string) --*

                Specifies the storage type associated with DB instance.

              - **TdeCredentialArn** *(string) --*

                The ARN from the key store with which the instance is associated for TDE encryption.

              - **DbInstancePort** *(integer) --*

                Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.

              - **DBClusterIdentifier** *(string) --*

                If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB instance is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is true, the AWS KMS key identifier for the encrypted DB instance.

              - **DbiResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.

              - **CACertificateIdentifier** *(string) --*

                The identifier of the CA certificate for this DB instance.

              - **DomainMemberships** *(list) --*

                The Active Directory Domain membership records associated with the DB instance.

                - *(dict) --*

                  An Active Directory Domain membership record associated with the DB instance.

                  - **Domain** *(string) --*

                    The identifier of the Active Directory Domain.

                  - **Status** *(string) --*

                    The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).

                  - **FQDN** *(string) --*

                    The fully qualified domain name of the Active Directory Domain.

                  - **IAMRoleName** *(string) --*

                    The name of the IAM role to be used when making API calls to the Directory Service.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB instance to snapshots of the DB instance.

                 **Amazon Aurora**

                Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see ``DBCluster`` .

              - **MonitoringInterval** *(integer) --*

                The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.

              - **EnhancedMonitoringResourceArn** *(string) --*

                The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.

              - **MonitoringRoleArn** *(string) --*

                The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.

              - **PromotionTier** *(integer) --*

                A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **DBInstanceArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB instance.

              - **Timezone** *(string) --*

                The time zone of the DB instance. In most cases, the ``Timezone`` element is empty. ``Timezone`` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.

                IAM database authentication can be enabled for the following database engines

                * For MySQL 5.6, minor version 5.6.34 or higher

                * For MySQL 5.7, minor version 5.7.16 or higher

                * Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.

              - **PerformanceInsightsEnabled** *(boolean) --*

                True if Performance Insights is enabled for the DB instance, and otherwise false.

              - **PerformanceInsightsKMSKeyId** *(string) --*

                The AWS KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.

              - **PerformanceInsightsRetentionPeriod** *(integer) --*

                The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB instance is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html>`__ in the *Amazon RDS User Guide.*

                - *(string) --*

              - **ProcessorFeatures** *(list) --*

                The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.

                - *(dict) --*

                  Contains the processor features of a DB instance class.

                  To specify the number of CPU cores, use the ``coreCount`` feature name for the ``Name`` parameter. To specify the number of threads per core, use the ``threadsPerCore`` feature name for the ``Name`` parameter.

                  You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:

                  * ``CreateDBInstance``

                  * ``ModifyDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceFromS3``

                  * ``RestoreDBInstanceToPointInTime``

                  You can view the valid processor values for a particular instance class by calling the ``DescribeOrderableDBInstanceOptions`` action and specifying the instance class for the ``DBInstanceClass`` parameter.

                  In addition, you can use the following actions for DB instance class processor information:

                  * ``DescribeDBInstances``

                  * ``DescribeDBSnapshots``

                  * ``DescribeValidDBInstanceModifications``

                  For more information, see `Configuring the Processor of the DB Instance Class <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor>`__ in the *Amazon RDS User Guide.*

                  - **Name** *(string) --*

                    The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore`` .

                  - **Value** *(string) --*

                    The value of a processor feature name.

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see `Deleting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html>`__ .

              - **AssociatedRoles** *(list) --*

                The AWS Identity and Access Management (IAM) roles associated with the DB instance.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB instance.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see ``DBEngineVersion`` .

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB instance and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB instance.

                    * ``INVALID`` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other AWS services on your behalf.

              - **ListenerEndpoint** *(dict) --*

                Specifies the listener connection endpoint for SQL Server Always On.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **MaxAllocatedStorage** *(integer) --*

                The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.

        """
        pass

    def promote_read_replica_db_cluster(
        self,
        DBClusterIdentifier: str
    ) -> Dict[str, Any]:
        """
        Promotes a Read Replica DB cluster to a standalone DB cluster.

        .. note::

          This action only applies to Aurora DB clusters.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBCluster>`_

        **Request Syntax**
        ::

          response = client.promote_read_replica_db_cluster(
              DBClusterIdentifier='string'
          )
        :type DBClusterIdentifier: string
        :param DBClusterIdentifier: **[REQUIRED]**

          The identifier of the DB cluster Read Replica to promote. This parameter isn't case-sensitive.

          Constraints:

          * Must match the identifier of an existing DBCluster Read Replica.

          Example: ``my-cluster-replica1``

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBCluster': {
                    'AllocatedStorage': 123,
                    'AvailabilityZones': [
                        'string',
                    ],
                    'BackupRetentionPeriod': 123,
                    'CharacterSetName': 'string',
                    'DatabaseName': 'string',
                    'DBClusterIdentifier': 'string',
                    'DBClusterParameterGroup': 'string',
                    'DBSubnetGroup': 'string',
                    'Status': 'string',
                    'PercentProgress': 'string',
                    'EarliestRestorableTime': datetime(2015, 1, 1),
                    'Endpoint': 'string',
                    'ReaderEndpoint': 'string',
                    'CustomEndpoints': [
                        'string',
                    ],
                    'MultiAZ': True|False,
                    'Engine': 'string',
                    'EngineVersion': 'string',
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'Port': 123,
                    'MasterUsername': 'string',
                    'DBClusterOptionGroupMemberships': [
                        {
                            'DBClusterOptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'PreferredBackupWindow': 'string',
                    'PreferredMaintenanceWindow': 'string',
                    'ReplicationSourceIdentifier': 'string',
                    'ReadReplicaIdentifiers': [
                        'string',
                    ],
                    'DBClusterMembers': [
                        {
                            'DBInstanceIdentifier': 'string',
                            'IsClusterWriter': True|False,
                            'DBClusterParameterGroupStatus': 'string',
                            'PromotionTier': 123
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'HostedZoneId': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbClusterResourceId': 'string',
                    'DBClusterArn': 'string',
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'Status': 'string',
                            'FeatureName': 'string'
                        },
                    ],
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'CloneGroupId': 'string',
                    'ClusterCreateTime': datetime(2015, 1, 1),
                    'EarliestBacktrackTime': datetime(2015, 1, 1),
                    'BacktrackWindow': 123,
                    'BacktrackConsumedChangeRecords': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'Capacity': 123,
                    'EngineMode': 'string',
                    'ScalingConfigurationInfo': {
                        'MinCapacity': 123,
                        'MaxCapacity': 123,
                        'AutoPause': True|False,
                        'SecondsUntilAutoPause': 123,
                        'TimeoutAction': 'string'
                    },
                    'DeletionProtection': True|False,
                    'HttpEndpointEnabled': True|False,
                    'ActivityStreamMode': 'sync'|'async',
                    'ActivityStreamStatus': 'stopped'|'starting'|'started'|'stopping',
                    'ActivityStreamKmsKeyId': 'string',
                    'ActivityStreamKinesisStreamName': 'string',
                    'CopyTagsToSnapshot': True|False,
                    'CrossAccountClone': True|False
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBCluster** *(dict) --*

              Contains the details of an Amazon Aurora DB cluster.

              This data type is used as a response element in the ``DescribeDBClusters`` , ``StopDBCluster`` , and ``StartDBCluster`` actions.

              - **AllocatedStorage** *(integer) --*

                For all database engines except Amazon Aurora, ``AllocatedStorage`` specifies the allocated storage size in gibibytes (GiB). For Aurora, ``AllocatedStorage`` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.

              - **AvailabilityZones** *(list) --*

                Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.

                - *(string) --*

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **CharacterSetName** *(string) --*

                If present, specifies the name of the character set that this cluster is associated with.

              - **DatabaseName** *(string) --*

                Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.

              - **DBClusterIdentifier** *(string) --*

                Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.

              - **DBClusterParameterGroup** *(string) --*

                Specifies the name of the DB cluster parameter group for the DB cluster.

              - **DBSubnetGroup** *(string) --*

                Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.

              - **Status** *(string) --*

                Specifies the current state of this DB cluster.

              - **PercentProgress** *(string) --*

                Specifies the progress of the operation as a percentage.

              - **EarliestRestorableTime** *(datetime) --*

                The earliest time to which a database can be restored with point-in-time restore.

              - **Endpoint** *(string) --*

                Specifies the connection endpoint for the primary instance of the DB cluster.

              - **ReaderEndpoint** *(string) --*

                The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.

                If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.

              - **CustomEndpoints** *(list) --*

                Identifies all custom endpoints associated with the cluster.

                - *(string) --*

              - **MultiAZ** *(boolean) --*

                Specifies whether the DB cluster has instances in multiple Availability Zones.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB cluster.

              - **EngineVersion** *(string) --*

                Indicates the database engine version.

              - **LatestRestorableTime** *(datetime) --*

                Specifies the latest time to which a database can be restored with point-in-time restore.

              - **Port** *(integer) --*

                Specifies the port that the database engine is listening on.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB cluster.

              - **DBClusterOptionGroupMemberships** *(list) --*

                Provides the list of option group memberships for this DB cluster.

                - *(dict) --*

                  Contains status information for a DB cluster option group.

                  - **DBClusterOptionGroupName** *(string) --*

                    Specifies the name of the DB cluster option group.

                  - **Status** *(string) --*

                    Specifies the status of the DB cluster option group.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **PreferredMaintenanceWindow** *(string) --*

                Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

              - **ReplicationSourceIdentifier** *(string) --*

                Contains the identifier of the source DB cluster if this DB cluster is a Read Replica.

              - **ReadReplicaIdentifiers** *(list) --*

                Contains one or more identifiers of the Read Replicas associated with this DB cluster.

                - *(string) --*

              - **DBClusterMembers** *(list) --*

                Provides the list of instances that make up the DB cluster.

                - *(dict) --*

                  Contains information about an instance that is part of a DB cluster.

                  - **DBInstanceIdentifier** *(string) --*

                    Specifies the instance identifier for this member of the DB cluster.

                  - **IsClusterWriter** *(boolean) --*

                    Value that is ``true`` if the cluster member is the primary instance for the DB cluster and ``false`` otherwise.

                  - **DBClusterParameterGroupStatus** *(string) --*

                    Specifies the status of the DB cluster parameter group for this member of the DB cluster.

                  - **PromotionTier** *(integer) --*

                    A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see `Fault Tolerance for an Aurora DB Cluster <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance>`__ in the *Amazon Aurora User Guide* .

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security groups that the DB cluster belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **HostedZoneId** *(string) --*

                Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **StorageEncrypted** *(boolean) --*

                Specifies whether the DB cluster is encrypted.

              - **KmsKeyId** *(string) --*

                If ``StorageEncrypted`` is enabled, the AWS KMS key identifier for the encrypted DB cluster.

              - **DbClusterResourceId** *(string) --*

                The AWS Region-unique, immutable identifier for the DB cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.

              - **DBClusterArn** *(string) --*

                The Amazon Resource Name (ARN) for the DB cluster.

              - **AssociatedRoles** *(list) --*

                Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.

                - *(dict) --*

                  Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.

                  - **RoleArn** *(string) --*

                    The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.

                  - **Status** *(string) --*

                    Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:

                    * ``ACTIVE`` - the IAM role ARN is associated with the DB cluster and can be used to access other AWS services on your behalf.

                    * ``PENDING`` - the IAM role ARN is being associated with the DB cluster.

                    * ``INVALID`` - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other AWS services on your behalf.

                  - **FeatureName** *(string) --*

                    The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see  DBEngineVersion .

              - **IAMDatabaseAuthenticationEnabled** *(boolean) --*

                A value that indicates whether the mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.

              - **CloneGroupId** *(string) --*

                Identifies the clone group to which the DB cluster is associated.

              - **ClusterCreateTime** *(datetime) --*

                Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).

              - **EarliestBacktrackTime** *(datetime) --*

                The earliest time to which a DB cluster can be backtracked.

              - **BacktrackWindow** *(integer) --*

                The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.

              - **BacktrackConsumedChangeRecords** *(integer) --*

                The number of change records stored for Backtrack.

              - **EnabledCloudwatchLogsExports** *(list) --*

                A list of log types that this DB cluster is configured to export to CloudWatch Logs.

                Log types vary by DB engine. For information about the log types for each DB engine, see `Amazon RDS Database Log Files <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html>`__ in the *Amazon Aurora User Guide.*

                - *(string) --*

              - **Capacity** *(integer) --*

                The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.

                For more information about Aurora Serverless, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

              - **EngineMode** *(string) --*

                The DB engine mode of the DB cluster, either ``provisioned`` , ``serverless`` , ``parallelquery`` , ``global`` , or ``multimaster`` .

              - **ScalingConfigurationInfo** *(dict) --*

                Shows the scaling configuration for an Aurora DB cluster in ``serverless`` DB engine mode.

                For more information, see `Using Amazon Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html>`__ in the *Amazon Aurora User Guide* .

                - **MinCapacity** *(integer) --*

                  The maximum capacity for the Aurora DB cluster in ``serverless`` DB engine mode.

                - **MaxCapacity** *(integer) --*

                  The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.

                - **AutoPause** *(boolean) --*

                  A value that indicates whether automatic pause is allowed for the Aurora DB cluster in ``serverless`` DB engine mode.

                  When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.

                - **SecondsUntilAutoPause** *(integer) --*

                  The remaining amount of time, in seconds, before the Aurora DB cluster in ``serverless`` mode is paused. A DB cluster can be paused only when it's idle (it has no connections).

                - **TimeoutAction** *(string) --*

                  The timeout action of a call to ``ModifyCurrentDBClusterCapacity`` , either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange`` .

              - **DeletionProtection** *(boolean) --*

                Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.

              - **HttpEndpointEnabled** *(boolean) --*

                A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.

                When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.

                For more information, see `Using the Data API for Aurora Serverless <https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html>`__ in the *Amazon Aurora User Guide* .

              - **ActivityStreamMode** *(string) --*

                The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.

              - **ActivityStreamStatus** *(string) --*

                The status of the database activity stream.

              - **ActivityStreamKmsKeyId** *(string) --*

                The AWS KMS key identifier used for encrypting messages in the database activity stream.

              - **ActivityStreamKinesisStreamName** *(string) --*

                The name of the Amazon Kinesis data stream used for the database activity stream.

              - **CopyTagsToSnapshot** *(boolean) --*

                Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.

              - **CrossAccountClone** *(boolean) --*

                Specifies whether the DB cluster is a clone of a DB cluster owned by a different AWS account.

        """
        pass

    def purchase_reserved_db_instances_offering(
        self,
        ReservedDBInstancesOfferingId: str,
        ReservedDBInstanceId: str = None,
        DBInstanceCount: int = None,
        Tags: List[Any] = None
    ) -> Dict[str, Any]:
        """
        Purchases a reserved DB instance offering.

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOffering>`_

        **Request Syntax**
        ::

          response = client.purchase_reserved_db_instances_offering(
              ReservedDBInstancesOfferingId='string',
              ReservedDBInstanceId='string',
              DBInstanceCount=123,
              Tags=[
                  {
                      'Key': 'string',
                      'Value': 'string'
                  },
              ]
          )
        :type ReservedDBInstancesOfferingId: string
        :param ReservedDBInstancesOfferingId: **[REQUIRED]**

          The ID of the Reserved DB instance offering to purchase.

          Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706

        :type ReservedDBInstanceId: string
        :param ReservedDBInstanceId:

          Customer-specified identifier to track this reservation.

          Example: myreservationID

        :type DBInstanceCount: integer
        :param DBInstanceCount:

          The number of instances to reserve.

          Default: ``1``

        :type Tags: list
        :param Tags:

          A list of tags. For more information, see `Tagging Amazon RDS Resources <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html>`__ in the *Amazon RDS User Guide.*

          - *(dict) --*

            Metadata assigned to an Amazon RDS resource consisting of a key-value pair.

            - **Key** *(string) --*

              A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

            - **Value** *(string) --*

              A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'ReservedDBInstance': {
                    'ReservedDBInstanceId': 'string',
                    'ReservedDBInstancesOfferingId': 'string',
                    'DBInstanceClass': 'string',
                    'StartTime': datetime(2015, 1, 1),
                    'Duration': 123,
                    'FixedPrice': 123.0,
                    'UsagePrice': 123.0,
                    'CurrencyCode': 'string',
                    'DBInstanceCount': 123,
                    'ProductDescription': 'string',
                    'OfferingType': 'string',
                    'MultiAZ': True|False,
                    'State': 'string',
                    'RecurringCharges': [
                        {
                            'RecurringChargeAmount': 123.0,
                            'RecurringChargeFrequency': 'string'
                        },
                    ],
                    'ReservedDBInstanceArn': 'string',
                    'LeaseId': 'string'
                }
            }
          **Response Structure**

          - *(dict) --*

            - **ReservedDBInstance** *(dict) --*

              This data type is used as a response element in the ``DescribeReservedDBInstances`` and ``PurchaseReservedDBInstancesOffering`` actions.

              - **ReservedDBInstanceId** *(string) --*

                The unique identifier for the reservation.

              - **ReservedDBInstancesOfferingId** *(string) --*

                The offering identifier.

              - **DBInstanceClass** *(string) --*

                The DB instance class for the reserved DB instance.

              - **StartTime** *(datetime) --*

                The time the reservation started.

              - **Duration** *(integer) --*

                The duration of the reservation in seconds.

              - **FixedPrice** *(float) --*

                The fixed price charged for this reserved DB instance.

              - **UsagePrice** *(float) --*

                The hourly price charged for this reserved DB instance.

              - **CurrencyCode** *(string) --*

                The currency code for the reserved DB instance.

              - **DBInstanceCount** *(integer) --*

                The number of reserved DB instances.

              - **ProductDescription** *(string) --*

                The description of the reserved DB instance.

              - **OfferingType** *(string) --*

                The offering type of this reserved DB instance.

              - **MultiAZ** *(boolean) --*

                Indicates if the reservation applies to Multi-AZ deployments.

              - **State** *(string) --*

                The state of the reserved DB instance.

              - **RecurringCharges** *(list) --*

                The recurring price charged to run this reserved DB instance.

                - *(dict) --*

                  This data type is used as a response element in the ``DescribeReservedDBInstances`` and ``DescribeReservedDBInstancesOfferings`` actions.

                  - **RecurringChargeAmount** *(float) --*

                    The amount of the recurring charge.

                  - **RecurringChargeFrequency** *(string) --*

                    The frequency of the recurring charge.

              - **ReservedDBInstanceArn** *(string) --*

                The Amazon Resource Name (ARN) for the reserved DB instance.

              - **LeaseId** *(string) --*

                The unique identifier for the lease associated with the reserved DB instance.

                .. note::

                  AWS Support might request the lease ID for an issue related to a reserved DB instance.

        """
        pass

    def reboot_db_instance(
        self,
        DBInstanceIdentifier: str,
        ForceFailover: bool = None
    ) -> Dict[str, Any]:
        """
        You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.

        Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.

        For more information about rebooting, see `Rebooting a DB Instance <https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html>`__ in the *Amazon RDS User Guide.*

        See also: `AWS API Documentation <https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstance>`_

        **Request Syntax**
        ::

          response = client.reboot_db_instance(
              DBInstanceIdentifier='string',
              ForceFailover=True|False
          )
        :type DBInstanceIdentifier: string
        :param DBInstanceIdentifier: **[REQUIRED]**

          The DB instance identifier. This parameter is stored as a lowercase string.

          Constraints:

          * Must match the identifier of an existing DBInstance.

        :type ForceFailover: boolean
        :param ForceFailover:

          A value that indicates whether the reboot is conducted through a Multi-AZ failover.

          Constraint: You can't enable force failover if the instance isn't configured for Multi-AZ.

        :rtype: dict
        :returns:

          **Response Syntax**

          ::

            {
                'DBInstance': {
                    'DBInstanceIdentifier': 'string',
                    'DBInstanceClass': 'string',
                    'Engine': 'string',
                    'DBInstanceStatus': 'string',
                    'MasterUsername': 'string',
                    'DBName': 'string',
                    'Endpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'AllocatedStorage': 123,
                    'InstanceCreateTime': datetime(2015, 1, 1),
                    'PreferredBackupWindow': 'string',
                    'BackupRetentionPeriod': 123,
                    'DBSecurityGroups': [
                        {
                            'DBSecurityGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'VpcSecurityGroups': [
                        {
                            'VpcSecurityGroupId': 'string',
                            'Status': 'string'
                        },
                    ],
                    'DBParameterGroups': [
                        {
                            'DBParameterGroupName': 'string',
                            'ParameterApplyStatus': 'string'
                        },
                    ],
                    'AvailabilityZone': 'string',
                    'DBSubnetGroup': {
                        'DBSubnetGroupName': 'string',
                        'DBSubnetGroupDescription': 'string',
                        'VpcId': 'string',
                        'SubnetGroupStatus': 'string',
                        'Subnets': [
                            {
                                'SubnetIdentifier': 'string',
                                'SubnetAvailabilityZone': {
                                    'Name': 'string'
                                },
                                'SubnetStatus': 'string'
                            },
                        ],
                        'DBSubnetGroupArn': 'string'
                    },
                    'PreferredMaintenanceWindow': 'string',
                    'PendingModifiedValues': {
                        'DBInstanceClass': 'string',
                        'AllocatedStorage': 123,
                        'MasterUserPassword': 'string',
                        'Port': 123,
                        'BackupRetentionPeriod': 123,
                        'MultiAZ': True|False,
                        'EngineVersion': 'string',
                        'LicenseModel': 'string',
                        'Iops': 123,
                        'DBInstanceIdentifier': 'string',
                        'StorageType': 'string',
                        'CACertificateIdentifier': 'string',
                        'DBSubnetGroupName': 'string',
                        'PendingCloudwatchLogsExports': {
                            'LogTypesToEnable': [
                                'string',
                            ],
                            'LogTypesToDisable': [
                                'string',
                            ]
                        },
                        'ProcessorFeatures': [
                            {
                                'Name': 'string',
                                'Value': 'string'
                            },
                        ]
                    },
                    'LatestRestorableTime': datetime(2015, 1, 1),
                    'MultiAZ': True|False,
                    'EngineVersion': 'string',
                    'AutoMinorVersionUpgrade': True|False,
                    'ReadReplicaSourceDBInstanceIdentifier': 'string',
                    'ReadReplicaDBInstanceIdentifiers': [
                        'string',
                    ],
                    'ReadReplicaDBClusterIdentifiers': [
                        'string',
                    ],
                    'LicenseModel': 'string',
                    'Iops': 123,
                    'OptionGroupMemberships': [
                        {
                            'OptionGroupName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'CharacterSetName': 'string',
                    'SecondaryAvailabilityZone': 'string',
                    'PubliclyAccessible': True|False,
                    'StatusInfos': [
                        {
                            'StatusType': 'string',
                            'Normal': True|False,
                            'Status': 'string',
                            'Message': 'string'
                        },
                    ],
                    'StorageType': 'string',
                    'TdeCredentialArn': 'string',
                    'DbInstancePort': 123,
                    'DBClusterIdentifier': 'string',
                    'StorageEncrypted': True|False,
                    'KmsKeyId': 'string',
                    'DbiResourceId': 'string',
                    'CACertificateIdentifier': 'string',
                    'DomainMemberships': [
                        {
                            'Domain': 'string',
                            'Status': 'string',
                            'FQDN': 'string',
                            'IAMRoleName': 'string'
                        },
                    ],
                    'CopyTagsToSnapshot': True|False,
                    'MonitoringInterval': 123,
                    'EnhancedMonitoringResourceArn': 'string',
                    'MonitoringRoleArn': 'string',
                    'PromotionTier': 123,
                    'DBInstanceArn': 'string',
                    'Timezone': 'string',
                    'IAMDatabaseAuthenticationEnabled': True|False,
                    'PerformanceInsightsEnabled': True|False,
                    'PerformanceInsightsKMSKeyId': 'string',
                    'PerformanceInsightsRetentionPeriod': 123,
                    'EnabledCloudwatchLogsExports': [
                        'string',
                    ],
                    'ProcessorFeatures': [
                        {
                            'Name': 'string',
                            'Value': 'string'
                        },
                    ],
                    'DeletionProtection': True|False,
                    'AssociatedRoles': [
                        {
                            'RoleArn': 'string',
                            'FeatureName': 'string',
                            'Status': 'string'
                        },
                    ],
                    'ListenerEndpoint': {
                        'Address': 'string',
                        'Port': 123,
                        'HostedZoneId': 'string'
                    },
                    'MaxAllocatedStorage': 123
                }
            }
          **Response Structure**

          - *(dict) --*

            - **DBInstance** *(dict) --*

              Contains the details of an Amazon RDS DB instance.

              This data type is used as a response element in the ``DescribeDBInstances`` action.

              - **DBInstanceIdentifier** *(string) --*

                Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.

              - **DBInstanceClass** *(string) --*

                Contains the name of the compute and memory capacity class of the DB instance.

              - **Engine** *(string) --*

                Provides the name of the database engine to be used for this DB instance.

              - **DBInstanceStatus** *(string) --*

                Specifies the current state of this database.

              - **MasterUsername** *(string) --*

                Contains the master username for the DB instance.

              - **DBName** *(string) --*

                The meaning of this parameter differs according to the database engine you use.

                 **MySQL, MariaDB, SQL Server, PostgreSQL**

                Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.

                Type: String

                 **Oracle**

                Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.

              - **Endpoint** *(dict) --*

                Specifies the connection endpoint.

                - **Address** *(string) --*

                  Specifies the DNS address of the DB instance.

                - **Port** *(integer) --*

                  Specifies the port that the database engine is listening on.

                - **HostedZoneId** *(string) --*

                  Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.

              - **AllocatedStorage** *(integer) --*

                Specifies the allocated storage size specified in gibibytes.

              - **InstanceCreateTime** *(datetime) --*

                Provides the date and time the DB instance was created.

              - **PreferredBackupWindow** *(string) --*

                Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the ``BackupRetentionPeriod`` .

              - **BackupRetentionPeriod** *(integer) --*

                Specifies the number of days for which automatic DB snapshots are retained.

              - **DBSecurityGroups** *(list) --*

                A list of DB security group elements containing ``DBSecurityGroup.Name`` and ``DBSecurityGroup.Status`` subelements.

                - *(dict) --*

                  This data type is used as a response element in the following actions:

                  * ``ModifyDBInstance``

                  * ``RebootDBInstance``

                  * ``RestoreDBInstanceFromDBSnapshot``

                  * ``RestoreDBInstanceToPointInTime``

                  - **DBSecurityGroupName** *(string) --*

                    The name of the DB security group.

                  - **Status** *(string) --*

                    The status of the DB security group.

              - **VpcSecurityGroups** *(list) --*

                Provides a list of VPC security group elements that the DB instance belongs to.

                - *(dict) --*

                  This data type is used as a response element for queries on VPC security group membership.

                  - **VpcSecurityGroupId** *(string) --*

                    The name of the VPC security group.

                  - **Status** *(string) --*

                    The status of the VPC security group.

              - **DBParameterGroups** *(list) --*

                Provides the list of DB parameter groups applied to this DB instance.

                - *(dict) --*

                  The status of the DB parameter group.

                  This data type is used as a response element in the following actions:

                  * ``CreateDBInstance``

                  * ``Cr