#  Copyright 2021-present, the Recognai S.L. team.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

"""create metadata_properties table

Revision ID: 7cbcccf8b57a
Revises: 1e629a913727
Create Date: 2023-09-22 11:40:07.700301

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "7cbcccf8b57a"
down_revision = "1e629a913727"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "metadata_properties",
        sa.Column("id", sa.Uuid(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("title", sa.Text(), nullable=False),
        sa.Column("settings", sa.JSON(), nullable=False),
        sa.Column("allowed_roles", sa.JSON(), server_default="[]", nullable=False),
        sa.Column("dataset_id", sa.Uuid(), nullable=False),
        sa.Column("inserted_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["dataset_id"], ["datasets.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name", "dataset_id", name="metadata_property_name_dataset_id_uq"),
    )
    op.create_index(op.f("ix_metadata_properties_dataset_id"), "metadata_properties", ["dataset_id"], unique=False)
    op.create_index(op.f("ix_metadata_properties_name"), "metadata_properties", ["name"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_metadata_properties_name"), table_name="metadata_properties")
    op.drop_index(op.f("ix_metadata_properties_dataset_id"), table_name="metadata_properties")
    op.drop_table("metadata_properties")
    # ### end Alembic commands ###
