#  Copyright 2021-present, the Recognai S.L. team.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

"""add last_activity_at to datasets table

Revision ID: 84f6b9ff6076
Revises: b8458008b60e
Create Date: 2023-10-19 16:06:16.097130

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "84f6b9ff6076"
down_revision = "b8458008b60e"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("datasets", sa.Column("last_activity_at", sa.DateTime(), nullable=True))
    op.execute("UPDATE datasets SET last_activity_at = updated_at")
    with op.batch_alter_table("datasets") as batch_op:
        batch_op.alter_column("last_activity_at", nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("datasets", "last_activity_at")
    # ### end Alembic commands ###
