import pandas as pd

chadwick_dtypes = {
    "GAME_ID": "object",
    "AWAY_TEAM_ID": "object",
    "INN_CT": "int64",
    "OUTS_CT": "int64",
    "BALLS_CT": "int64",
    "STRIKES_CT": "int64",
    "AWAY_SCORE_CT": "int64",
    "HOME_SCORE_CT": "int64",
    "RESP_BAT_ID": "object",
    "RESP_BAT_HAND_CD": "object",
    "RESP_PIT_ID": "object",
    "RESP_PIT_HAND_CD": "object",
    "BASE1_RUN_ID": "object",
    "BASE2_RUN_ID": "object",
    "BASE3_RUN_ID": "object",
    "BAT_FLD_CD": "int64",
    "BAT_LINEUP_ID": "int64",
    "EVENT_CD": "int64",
    "AB_FL": "bool",
    "H_CD": "int64",
    "SH_FL": "bool",
    "SF_FL": "bool",
    "EVENT_OUTS_CT": "int64",
    "DP_FL": "bool",
    "TP_FL": "bool",
    "RBI_CT": "int64",
    "WP_FL": "bool",
    "PB_FL": "bool",
    "BATTEDBALL_CD": "object",
    "BAT_DEST_ID": "int64",
    "RUN1_DEST_ID": "int64",
    "RUN2_DEST_ID": "int64",
    "RUN3_DEST_ID": "int64",
    "RUN1_SB_FL": "bool",
    "RUN2_SB_FL": "bool",
    "RUN3_SB_FL": "bool",
    "RUN1_CS_FL": "bool",
    "RUN2_CS_FL": "bool",
    "RUN3_CS_FL": "bool",
    "RUN1_PK_FL": "bool",
    "RUN2_PK_FL": "bool",
    "RUN3_PK_FL": "bool",
    "RUN1_RESP_PIT_ID": "object",
    "RUN2_RESP_PIT_ID": "object",
    "RUN3_RESP_PIT_ID": "object",
    "HOME_TEAM_ID": "object",
    "BAT_TEAM_ID": "object",
    "FLD_TEAM_ID": "object",
    "PA_TRUNC_FL": "bool",
    "START_BASES_CD": "int64",
    "END_BASES_CD": "int64",
    "RESP_PIT_START_FL": "bool",
    "PA_BALL_CT": "int64",
    "PA_OTHER_BALL_CT": "int64",
    "PA_STRIKE_CT": "int64",
    "PA_OTHER_STRIKE_CT": "int64",
    "EVENT_RUNS_CT": "int64",
    "BAT_SAFE_ERR_FL": "bool",
    "FATE_RUNS_CT": "int64",
    "RESP_BAT_START_FL": "bool",
    "MLB_STATSAPI_APPROX": "bool",
    "mlbam_id": "Int64",
}

chadwick_defaults = {
    "GAME_ID": None,
    "AWAY_TEAM_ID": None,
    "INN_CT": None,
    "OUTS_CT": None,
    "BALLS_CT": None,
    "STRIKES_CT": None,
    "AWAY_SCORE_CT": None,
    "HOME_SCORE_CT": None,
    "RESP_BAT_ID": None,
    "RESP_BAT_HAND_CD": None,
    "RESP_PIT_ID": None,
    "RESP_PIT_HAND_CD": None,
    "BASE1_RUN_ID": pd.NA,
    "BASE2_RUN_ID": pd.NA,
    "BASE3_RUN_ID": pd.NA,
    "BAT_FLD_CD": None,
    "BAT_LINEUP_ID": None,
    "EVENT_CD": None,
    "AB_FL": False,
    "H_CD": 0,
    "SH_FL": False,
    "SF_FL": False,
    "EVENT_OUTS_CT": 0,
    "DP_FL": False,
    "TP_FL": False,
    "RBI_CT": 0,
    "WP_FL": False,
    "PB_FL": False,
    "BATTEDBALL_CD": None,
    "BAT_DEST_ID": 0,
    "RUN1_DEST_ID": 0,
    "RUN2_DEST_ID": 0,
    "RUN3_DEST_ID": 0,
    "RUN1_SB_FL": False,
    "RUN2_SB_FL": False,
    "RUN3_SB_FL": False,
    "RUN1_CS_FL": False,
    "RUN2_CS_FL": False,
    "RUN3_CS_FL": False,
    "RUN1_PK_FL": False,
    "RUN2_PK_FL": False,
    "RUN3_PK_FL": False,
    "RUN1_RESP_PIT_ID": pd.NA,
    "RUN2_RESP_PIT_ID": pd.NA,
    "RUN3_RESP_PIT_ID": pd.NA,
    "HOME_TEAM_ID": None,
    "BAT_TEAM_ID": None,
    "FLD_TEAM_ID": None,
    "PA_TRUNC_FL": False,
    "START_BASES_CD": 0,
    "END_BASES_CD": 0,
    "RESP_PIT_START_FL": False,
    "PA_BALL_CT": 0,
    "PA_OTHER_BALL_CT": 0,
    "PA_STRIKE_CT": 0,
    "PA_OTHER_STRIKE_CT": 0,
    "EVENT_RUNS_CT": 0,
    "BAT_SAFE_ERR_FL": False,
    "FATE_RUNS_CT": 0,
    "RESP_BAT_START_FL": False,
    "MLB_STATSAPI_APPROX": True,
    "mlbam_id": None,
}

cwgame_dtypes = {
    "GAME_ID": "object",
    "GAME_DY": "object",
    "START_GAME_TM": "Int64",
    "DAYNIGHT_PARK_CD": "object",
    "PARK_ID": "object",        # Doesn't work with MLBAM data
    "ATTEND_PARK_CT": "Int64",
    "TEMP_PARK_CT": "Int64",
    "WIND_DIRECTION_PARK_CD": "Int64",
    "WIND_SPEED_PARK_CT": "Int64",
    "FIELD_PARK_CD": "Int64",   # Doesn't work with MLBAM data
    "PRECIP_PARK_CD": "Int64",  # Doesn't work with MLBAM data
    "SKY_PARK_CD": "Int64",     # Doesn't work with MLBAM data
    "MINUTES_GAME_CT": "Int64",
    "WIN_PIT_ID": "object",
    "LOSE_PIT_ID": "object",
    "SAVE_PIT_ID": "object",
}