# coding: utf-8

"""
    IONOS Cloud - Object Storage Management API

    Object Storage Management API is a RESTful API that manages the object storage service configuration for IONOS Cloud.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud_object_storage_management.configuration import Configuration


class MetadataWithStatusAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'status': 'str',

        'status_message': 'str',

        'administrative': 'bool',
    }

    attribute_map = {

        'status': 'status',

        'status_message': 'statusMessage',

        'administrative': 'administrative',
    }

    def __init__(self, status=None, status_message=None, administrative=None, local_vars_configuration=None):  # noqa: E501
        """MetadataWithStatusAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._status = None
        self._status_message = None
        self._administrative = None
        self.discriminator = None

        self.status = status
        if status_message is not None:
            self.status_message = status_message
        if administrative is not None:
            self.administrative = administrative


    @property
    def status(self):
        """Gets the status of this MetadataWithStatusAllOf.  # noqa: E501

        The status of the object. The status can be: * `AVAILABLE` - resource exists and is healthy. * `PROVISIONING` - resource is being created or updated. * `DESTROYING` - delete command was issued, the resource is being deleted. * `FAILED` - resource failed, details in `failureMessage`.   # noqa: E501

        :return: The status of this MetadataWithStatusAllOf.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this MetadataWithStatusAllOf.

        The status of the object. The status can be: * `AVAILABLE` - resource exists and is healthy. * `PROVISIONING` - resource is being created or updated. * `DESTROYING` - delete command was issued, the resource is being deleted. * `FAILED` - resource failed, details in `failureMessage`.   # noqa: E501

        :param status: The status of this MetadataWithStatusAllOf.  # noqa: E501
        :type status: str
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["PROVISIONING", "DESTROYING", "AVAILABLE", "FAILED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def status_message(self):
        """Gets the status_message of this MetadataWithStatusAllOf.  # noqa: E501

        The message of the failure if the status is `FAILED`.   # noqa: E501

        :return: The status_message of this MetadataWithStatusAllOf.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this MetadataWithStatusAllOf.

        The message of the failure if the status is `FAILED`.   # noqa: E501

        :param status_message: The status_message of this MetadataWithStatusAllOf.  # noqa: E501
        :type status_message: str
        """

        self._status_message = status_message

    @property
    def administrative(self):
        """Gets the administrative of this MetadataWithStatusAllOf.  # noqa: E501

        Indicates if the key is an administrative key. Administrative keys can create buckets and set bucket policies.   # noqa: E501

        :return: The administrative of this MetadataWithStatusAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._administrative

    @administrative.setter
    def administrative(self, administrative):
        """Sets the administrative of this MetadataWithStatusAllOf.

        Indicates if the key is an administrative key. Administrative keys can create buckets and set bucket policies.   # noqa: E501

        :param administrative: The administrative of this MetadataWithStatusAllOf.  # noqa: E501
        :type administrative: bool
        """

        self._administrative = administrative
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MetadataWithStatusAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MetadataWithStatusAllOf):
            return True

        return self.to_dict() != other.to_dict()
