# coding: utf-8

"""
    IONOS Cloud - Object Storage Management API

    Object Storage Management API is a RESTful API that manages the object storage service configuration for IONOS Cloud.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud_object_storage_management.configuration import Configuration


class Region(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'version': 'int',

        'endpoint': 'str',

        'website': 'str',

        'capability': 'RegionCapability',

        'storage_classes': 'list[str]',

        'location': 'str',
    }

    attribute_map = {

        'version': 'version',

        'endpoint': 'endpoint',

        'website': 'website',

        'capability': 'capability',

        'storage_classes': 'storageClasses',

        'location': 'location',
    }

    def __init__(self, version=None, endpoint=None, website=None, capability=None, storage_classes=None, location=None, local_vars_configuration=None):  # noqa: E501
        """Region - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._version = None
        self._endpoint = None
        self._website = None
        self._capability = None
        self._storage_classes = None
        self._location = None
        self.discriminator = None

        self.version = version
        self.endpoint = endpoint
        self.website = website
        self.capability = capability
        if storage_classes is not None:
            self.storage_classes = storage_classes
        self.location = location


    @property
    def version(self):
        """Gets the version of this Region.  # noqa: E501

        The version of the region properties  # noqa: E501

        :return: The version of this Region.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Region.

        The version of the region properties  # noqa: E501

        :param version: The version of this Region.  # noqa: E501
        :type version: int
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def endpoint(self):
        """Gets the endpoint of this Region.  # noqa: E501

        The endpoint URL for the region  # noqa: E501

        :return: The endpoint of this Region.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this Region.

        The endpoint URL for the region  # noqa: E501

        :param endpoint: The endpoint of this Region.  # noqa: E501
        :type endpoint: str
        """
        if self.local_vars_configuration.client_side_validation and endpoint is None:  # noqa: E501
            raise ValueError("Invalid value for `endpoint`, must not be `None`")  # noqa: E501

        self._endpoint = endpoint

    @property
    def website(self):
        """Gets the website of this Region.  # noqa: E501

        The website URL for the region  # noqa: E501

        :return: The website of this Region.  # noqa: E501
        :rtype: str
        """
        return self._website

    @website.setter
    def website(self, website):
        """Sets the website of this Region.

        The website URL for the region  # noqa: E501

        :param website: The website of this Region.  # noqa: E501
        :type website: str
        """
        if self.local_vars_configuration.client_side_validation and website is None:  # noqa: E501
            raise ValueError("Invalid value for `website`, must not be `None`")  # noqa: E501

        self._website = website

    @property
    def capability(self):
        """Gets the capability of this Region.  # noqa: E501


        :return: The capability of this Region.  # noqa: E501
        :rtype: RegionCapability
        """
        return self._capability

    @capability.setter
    def capability(self, capability):
        """Sets the capability of this Region.


        :param capability: The capability of this Region.  # noqa: E501
        :type capability: RegionCapability
        """
        if self.local_vars_configuration.client_side_validation and capability is None:  # noqa: E501
            raise ValueError("Invalid value for `capability`, must not be `None`")  # noqa: E501

        self._capability = capability

    @property
    def storage_classes(self):
        """Gets the storage_classes of this Region.  # noqa: E501

        The available classes in the region  # noqa: E501

        :return: The storage_classes of this Region.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_classes

    @storage_classes.setter
    def storage_classes(self, storage_classes):
        """Sets the storage_classes of this Region.

        The available classes in the region  # noqa: E501

        :param storage_classes: The storage_classes of this Region.  # noqa: E501
        :type storage_classes: list[str]
        """

        self._storage_classes = storage_classes

    @property
    def location(self):
        """Gets the location of this Region.  # noqa: E501

        The data center location of the region as per [Get Location](/docs/cloud/v6/#tag/Locations/operation/locationsGet). *Can't be used as `LocationConstraint` on bucket creation.*   # noqa: E501

        :return: The location of this Region.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this Region.

        The data center location of the region as per [Get Location](/docs/cloud/v6/#tag/Locations/operation/locationsGet). *Can't be used as `LocationConstraint` on bucket creation.*   # noqa: E501

        :param location: The location of this Region.  # noqa: E501
        :type location: str
        """
        if self.local_vars_configuration.client_side_validation and location is None:  # noqa: E501
            raise ValueError("Invalid value for `location`, must not be `None`")  # noqa: E501

        self._location = location
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Region):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Region):
            return True

        return self.to_dict() != other.to_dict()
