# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsPrivatelinkArgs', 'AwsPrivatelink']

@pulumi.input_type
class AwsPrivatelinkArgs:
    def __init__(__self__, *,
                 principals: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AwsPrivatelink resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "principals", principals)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter
    def principals(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "principals", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _AwsPrivatelinkState:
    def __init__(__self__, *,
                 aws_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AwsPrivatelink resources.
        :param pulumi.Input[_builtins.str] aws_service_id: AWS service ID.
        :param pulumi.Input[_builtins.str] aws_service_name: AWS service name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        if aws_service_id is not None:
            pulumi.set(__self__, "aws_service_id", aws_service_id)
        if aws_service_name is not None:
            pulumi.set(__self__, "aws_service_name", aws_service_name)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter(name="awsServiceId")
    def aws_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS service ID.
        """
        return pulumi.get(self, "aws_service_id")

    @aws_service_id.setter
    def aws_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_service_id", value)

    @_builtins.property
    @pulumi.getter(name="awsServiceName")
    def aws_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS service name.
        """
        return pulumi.get(self, "aws_service_name")

    @aws_service_name.setter
    def aws_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_service_name", value)

    @_builtins.property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "principals", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.type_token("aiven:index/awsPrivatelink:AwsPrivatelink")
class AwsPrivatelink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an [AWS PrivateLink for Aiven services](https://aiven.io/docs/platform/howto/use-aws-privatelinks) in a VPC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        main = aiven.AwsPrivatelink("main",
            project=example_project["project"],
            service_name=example_kafka["serviceName"],
            principals=["arn:aws:iam::012345678901:user/mwf"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/awsPrivatelink:AwsPrivatelink main PROJECT/SERVICE_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsPrivatelinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [AWS PrivateLink for Aiven services](https://aiven.io/docs/platform/howto/use-aws-privatelinks) in a VPC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        main = aiven.AwsPrivatelink("main",
            project=example_project["project"],
            service_name=example_kafka["serviceName"],
            principals=["arn:aws:iam::012345678901:user/mwf"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/awsPrivatelink:AwsPrivatelink main PROJECT/SERVICE_NAME
        ```

        :param str resource_name: The name of the resource.
        :param AwsPrivatelinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsPrivatelinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsPrivatelinkArgs.__new__(AwsPrivatelinkArgs)

            if principals is None and not opts.urn:
                raise TypeError("Missing required property 'principals'")
            __props__.__dict__["principals"] = principals
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["aws_service_id"] = None
            __props__.__dict__["aws_service_name"] = None
        super(AwsPrivatelink, __self__).__init__(
            'aiven:index/awsPrivatelink:AwsPrivatelink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            aws_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AwsPrivatelink':
        """
        Get an existing AwsPrivatelink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_service_id: AWS service ID.
        :param pulumi.Input[_builtins.str] aws_service_name: AWS service name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsPrivatelinkState.__new__(_AwsPrivatelinkState)

        __props__.__dict__["aws_service_id"] = aws_service_id
        __props__.__dict__["aws_service_name"] = aws_service_name
        __props__.__dict__["principals"] = principals
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        return AwsPrivatelink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsServiceId")
    def aws_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        AWS service ID.
        """
        return pulumi.get(self, "aws_service_id")

    @_builtins.property
    @pulumi.getter(name="awsServiceName")
    def aws_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        AWS service name.
        """
        return pulumi.get(self, "aws_service_name")

    @_builtins.property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        """
        return pulumi.get(self, "principals")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

